#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHB1 = 0,
	AHB2 = 1,
	APB1 = 2,
	APB2 = 3,
	PARENT_MAX = 4,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ARB_TIMER = 0,
	ARB_BP_CAP_CLR = 1,
	ARB_BP_CAP_HI_ADDR = 2,
	ARB_BP_CAP_ADDR = 3,
	ARB_BP_CAP_STATUS = 4,
	ARB_BP_CAP_MASTER = 5,
	ARB_ERR_CAP_CLR = 6,
	ARB_ERR_CAP_HI_ADDR = 7,
	ARB_ERR_CAP_ADDR = 8,
	ARB_ERR_CAP_STATUS = 9,
	ARB_ERR_CAP_MASTER = 10,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_MAX_VALUES = 13,
};

enum {
	AXP15060_DCDC1 = 0,
	AXP15060_DCDC2 = 1,
	AXP15060_DCDC3 = 2,
	AXP15060_DCDC4 = 3,
	AXP15060_DCDC5 = 4,
	AXP15060_DCDC6 = 5,
	AXP15060_ALDO1 = 6,
	AXP15060_ALDO2 = 7,
	AXP15060_ALDO3 = 8,
	AXP15060_ALDO4 = 9,
	AXP15060_ALDO5 = 10,
	AXP15060_BLDO1 = 11,
	AXP15060_BLDO2 = 12,
	AXP15060_BLDO3 = 13,
	AXP15060_BLDO4 = 14,
	AXP15060_BLDO5 = 15,
	AXP15060_CLDO1 = 16,
	AXP15060_CLDO2 = 17,
	AXP15060_CLDO3 = 18,
	AXP15060_CLDO4 = 19,
	AXP15060_CPUSLDO = 20,
	AXP15060_SW = 21,
	AXP15060_RTC_LDO = 22,
	AXP15060_REG_ID_MAX = 23,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	AXP20X_LDO1 = 0,
	AXP20X_LDO2 = 1,
	AXP20X_LDO3 = 2,
	AXP20X_LDO4 = 3,
	AXP20X_LDO5 = 4,
	AXP20X_DCDC2 = 5,
	AXP20X_DCDC3 = 6,
	AXP20X_REG_ID_MAX = 7,
};

enum {
	AXP22X_DCDC1 = 0,
	AXP22X_DCDC2 = 1,
	AXP22X_DCDC3 = 2,
	AXP22X_DCDC4 = 3,
	AXP22X_DCDC5 = 4,
	AXP22X_DC1SW = 5,
	AXP22X_DC5LDO = 6,
	AXP22X_ALDO1 = 7,
	AXP22X_ALDO2 = 8,
	AXP22X_ALDO3 = 9,
	AXP22X_ELDO1 = 10,
	AXP22X_ELDO2 = 11,
	AXP22X_ELDO3 = 12,
	AXP22X_DLDO1 = 13,
	AXP22X_DLDO2 = 14,
	AXP22X_DLDO3 = 15,
	AXP22X_DLDO4 = 16,
	AXP22X_RTC_LDO = 17,
	AXP22X_LDO_IO0 = 18,
	AXP22X_LDO_IO1 = 19,
	AXP22X_REG_ID_MAX = 20,
};

enum {
	AXP313A_DCDC1 = 0,
	AXP313A_DCDC2 = 1,
	AXP313A_DCDC3 = 2,
	AXP313A_ALDO1 = 3,
	AXP313A_DLDO1 = 4,
	AXP313A_RTC_LDO = 5,
	AXP313A_REG_ID_MAX = 6,
};

enum {
	AXP717_DCDC1 = 0,
	AXP717_DCDC2 = 1,
	AXP717_DCDC3 = 2,
	AXP717_DCDC4 = 3,
	AXP717_ALDO1 = 4,
	AXP717_ALDO2 = 5,
	AXP717_ALDO3 = 6,
	AXP717_ALDO4 = 7,
	AXP717_BLDO1 = 8,
	AXP717_BLDO2 = 9,
	AXP717_BLDO3 = 10,
	AXP717_BLDO4 = 11,
	AXP717_CLDO1 = 12,
	AXP717_CLDO2 = 13,
	AXP717_CLDO3 = 14,
	AXP717_CLDO4 = 15,
	AXP717_CPUSLDO = 16,
	AXP717_BOOST = 17,
	AXP717_REG_ID_MAX = 18,
};

enum {
	AXP803_DCDC1 = 0,
	AXP803_DCDC2 = 1,
	AXP803_DCDC3 = 2,
	AXP803_DCDC4 = 3,
	AXP803_DCDC5 = 4,
	AXP803_DCDC6 = 5,
	AXP803_DC1SW = 6,
	AXP803_ALDO1 = 7,
	AXP803_ALDO2 = 8,
	AXP803_ALDO3 = 9,
	AXP803_DLDO1 = 10,
	AXP803_DLDO2 = 11,
	AXP803_DLDO3 = 12,
	AXP803_DLDO4 = 13,
	AXP803_ELDO1 = 14,
	AXP803_ELDO2 = 15,
	AXP803_ELDO3 = 16,
	AXP803_FLDO1 = 17,
	AXP803_FLDO2 = 18,
	AXP803_RTC_LDO = 19,
	AXP803_LDO_IO0 = 20,
	AXP803_LDO_IO1 = 21,
	AXP803_REG_ID_MAX = 22,
};

enum {
	AXP806_DCDCA = 0,
	AXP806_DCDCB = 1,
	AXP806_DCDCC = 2,
	AXP806_DCDCD = 3,
	AXP806_DCDCE = 4,
	AXP806_ALDO1 = 5,
	AXP806_ALDO2 = 6,
	AXP806_ALDO3 = 7,
	AXP806_BLDO1 = 8,
	AXP806_BLDO2 = 9,
	AXP806_BLDO3 = 10,
	AXP806_BLDO4 = 11,
	AXP806_CLDO1 = 12,
	AXP806_CLDO2 = 13,
	AXP806_CLDO3 = 14,
	AXP806_SW = 15,
	AXP806_REG_ID_MAX = 16,
};

enum {
	AXP809_DCDC1 = 0,
	AXP809_DCDC2 = 1,
	AXP809_DCDC3 = 2,
	AXP809_DCDC4 = 3,
	AXP809_DCDC5 = 4,
	AXP809_DC1SW = 5,
	AXP809_DC5LDO = 6,
	AXP809_ALDO1 = 7,
	AXP809_ALDO2 = 8,
	AXP809_ALDO3 = 9,
	AXP809_ELDO1 = 10,
	AXP809_ELDO2 = 11,
	AXP809_ELDO3 = 12,
	AXP809_DLDO1 = 13,
	AXP809_DLDO2 = 14,
	AXP809_RTC_LDO = 15,
	AXP809_LDO_IO0 = 16,
	AXP809_LDO_IO1 = 17,
	AXP809_SW = 18,
	AXP809_REG_ID_MAX = 19,
};

enum {
	AXP813_DCDC1 = 0,
	AXP813_DCDC2 = 1,
	AXP813_DCDC3 = 2,
	AXP813_DCDC4 = 3,
	AXP813_DCDC5 = 4,
	AXP813_DCDC6 = 5,
	AXP813_DCDC7 = 6,
	AXP813_ALDO1 = 7,
	AXP813_ALDO2 = 8,
	AXP813_ALDO3 = 9,
	AXP813_DLDO1 = 10,
	AXP813_DLDO2 = 11,
	AXP813_DLDO3 = 12,
	AXP813_DLDO4 = 13,
	AXP813_ELDO1 = 14,
	AXP813_ELDO2 = 15,
	AXP813_ELDO3 = 16,
	AXP813_FLDO1 = 17,
	AXP813_FLDO2 = 18,
	AXP813_FLDO3 = 19,
	AXP813_RTC_LDO = 20,
	AXP813_LDO_IO0 = 21,
	AXP813_LDO_IO1 = 22,
	AXP813_SW = 23,
	AXP813_REG_ID_MAX = 24,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	B28_DPT_INI = 3584,
	B28_DPT_VAL = 3588,
	B28_DPT_CTRL = 3592,
	B28_DPT_TST = 3594,
};

enum {
	B28_Y2_SMB_CONFIG = 3648,
	B28_Y2_SMB_CSD_REG = 3652,
	B28_Y2_ASF_IRQ_V_BASE = 3680,
	B28_Y2_ASF_STAT_CMD = 3688,
	B28_Y2_ASF_HOST_COM = 3692,
	B28_Y2_DATA_REG_1 = 3696,
	B28_Y2_DATA_REG_2 = 3700,
	B28_Y2_DATA_REG_3 = 3704,
	B28_Y2_DATA_REG_4 = 3708,
};

enum {
	B6_EXT_REG = 768,
	B7_CFG_SPC = 896,
	B8_RQ1_REGS = 1024,
	B8_RQ2_REGS = 1152,
	B8_TS1_REGS = 1536,
	B8_TA1_REGS = 1664,
	B8_TS2_REGS = 1792,
	B8_TA2_REGS = 1920,
	B16_RAM_REGS = 2048,
};

enum {
	B8_Q_REGS = 1024,
	Q_D = 0,
	Q_VLAN = 32,
	Q_DONE = 36,
	Q_AC_L = 40,
	Q_AC_H = 44,
	Q_BC = 48,
	Q_CSR = 52,
	Q_TEST = 56,
	Q_WM = 64,
	Q_AL = 66,
	Q_RSP = 68,
	Q_RSL = 70,
	Q_RP = 72,
	Q_RL = 74,
	Q_WP = 76,
	Q_WSP = 77,
	Q_WL = 78,
	Q_WSL = 79,
};

enum {
	BASE_GMAC_1 = 10240,
	BASE_GMAC_2 = 14336,
};

enum {
	BD71837_REG_BUCK3_CTRL = 7,
	BD71837_REG_BUCK4_CTRL = 8,
	BD71837_REG_BUCK3_VOLT_RUN = 18,
	BD71837_REG_BUCK4_VOLT_RUN = 19,
	BD71837_REG_LDO7_VOLT = 30,
};

enum {
	BD718XX_BUCK1 = 0,
	BD718XX_BUCK2 = 1,
	BD718XX_BUCK3 = 2,
	BD718XX_BUCK4 = 3,
	BD718XX_BUCK5 = 4,
	BD718XX_BUCK6 = 5,
	BD718XX_BUCK7 = 6,
	BD718XX_BUCK8 = 7,
	BD718XX_LDO1 = 8,
	BD718XX_LDO2 = 9,
	BD718XX_LDO3 = 10,
	BD718XX_LDO4 = 11,
	BD718XX_LDO5 = 12,
	BD718XX_LDO6 = 13,
	BD718XX_LDO7 = 14,
	BD718XX_REGULATOR_AMOUNT = 15,
};

enum {
	BD718XX_INT_STBY_REQ = 0,
	BD718XX_INT_ON_REQ = 1,
	BD718XX_INT_WDOG = 2,
	BD718XX_INT_PWRBTN = 3,
	BD718XX_INT_PWRBTN_L = 4,
	BD718XX_INT_PWRBTN_S = 5,
	BD718XX_INT_SWRST = 6,
};

enum {
	BD718XX_REG_REV = 0,
	BD718XX_REG_SWRESET = 1,
	BD718XX_REG_I2C_DEV = 2,
	BD718XX_REG_PWRCTRL0 = 3,
	BD718XX_REG_PWRCTRL1 = 4,
	BD718XX_REG_BUCK1_CTRL = 5,
	BD718XX_REG_BUCK2_CTRL = 6,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 9,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 10,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 11,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 12,
	BD718XX_REG_BUCK1_VOLT_RUN = 13,
	BD718XX_REG_BUCK1_VOLT_IDLE = 14,
	BD718XX_REG_BUCK1_VOLT_SUSP = 15,
	BD718XX_REG_BUCK2_VOLT_RUN = 16,
	BD718XX_REG_BUCK2_VOLT_IDLE = 17,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 20,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 21,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 22,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 23,
	BD718XX_REG_LDO1_VOLT = 24,
	BD718XX_REG_LDO2_VOLT = 25,
	BD718XX_REG_LDO3_VOLT = 26,
	BD718XX_REG_LDO4_VOLT = 27,
	BD718XX_REG_LDO5_VOLT = 28,
	BD718XX_REG_LDO6_VOLT = 29,
	BD718XX_REG_TRANS_COND0 = 31,
	BD718XX_REG_TRANS_COND1 = 32,
	BD718XX_REG_VRFAULTEN = 33,
	BD718XX_REG_MVRFLTMASK0 = 34,
	BD718XX_REG_MVRFLTMASK1 = 35,
	BD718XX_REG_MVRFLTMASK2 = 36,
	BD718XX_REG_RCVCFG = 37,
	BD718XX_REG_RCVNUM = 38,
	BD718XX_REG_PWRONCONFIG0 = 39,
	BD718XX_REG_PWRONCONFIG1 = 40,
	BD718XX_REG_RESETSRC = 41,
	BD718XX_REG_MIRQ = 42,
	BD718XX_REG_IRQ = 43,
	BD718XX_REG_IN_MON = 44,
	BD718XX_REG_POW_STATE = 45,
	BD718XX_REG_OUT32K = 46,
	BD718XX_REG_REGLOCK = 47,
	BD718XX_REG_OTPVER = 255,
	BD718XX_MAX_REGISTER = 256,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLINK_42MS = 0,
	BLINK_84MS = 1,
	BLINK_170MS = 2,
	BLINK_340MS = 3,
	BLINK_670MS = 4,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BMC_NPCM7XX = 0,
	BMC_NPCM8XX = 1,
};

enum {
	BMU_IDLE = -2147483648,
	BMU_RX_TCP_PKT = 1073741824,
	BMU_RX_IP_PKT = 536870912,
	BMU_ENA_RX_RSS_HASH = 32768,
	BMU_DIS_RX_RSS_HASH = 16384,
	BMU_ENA_RX_CHKSUM = 8192,
	BMU_DIS_RX_CHKSUM = 4096,
	BMU_CLR_IRQ_PAR = 2048,
	BMU_CLR_IRQ_TCP = 2048,
	BMU_CLR_IRQ_CHK = 1024,
	BMU_STOP = 512,
	BMU_START = 256,
	BMU_FIFO_OP_ON = 128,
	BMU_FIFO_OP_OFF = 64,
	BMU_FIFO_ENA = 32,
	BMU_FIFO_RST = 16,
	BMU_OP_ON = 8,
	BMU_OP_OFF = 4,
	BMU_RST_CLR = 2,
	BMU_RST_SET = 1,
	BMU_CLR_RESET = 22,
	BMU_OPER_INIT = 3368,
	BMU_WM_DEFAULT = 1536,
	BMU_WM_PEX = 128,
};

enum {
	BOOST_ILMIN_75MA = 0,
	BOOST_ILMIN_100MA = 1,
	BOOST_ILMIN_125MA = 2,
	BOOST_ILMIN_150MA = 3,
	BOOST_ILMIN_175MA = 4,
	BOOST_ILMIN_200MA = 5,
	BOOST_ILMIN_225MA = 6,
	BOOST_ILMIN_250MA = 7,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_R2_HI = 0,
	BPF_R2_LO = 1,
	BPF_R3_HI = 2,
	BPF_R3_LO = 3,
	BPF_R4_HI = 4,
	BPF_R4_LO = 5,
	BPF_R5_HI = 6,
	BPF_R5_LO = 7,
	BPF_R7_HI = 8,
	BPF_R7_LO = 9,
	BPF_R8_HI = 10,
	BPF_R8_LO = 11,
	BPF_R9_HI = 12,
	BPF_R9_LO = 13,
	BPF_FP_HI = 14,
	BPF_FP_LO = 15,
	BPF_TC_HI = 16,
	BPF_TC_LO = 17,
	BPF_AX_HI = 18,
	BPF_AX_LO = 19,
	BPF_JIT_SCRATCH_REGS = 20,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BUCK_ILMIN_50MA = 0,
	BUCK_ILMIN_100MA = 1,
	BUCK_ILMIN_150MA = 2,
	BUCK_ILMIN_200MA = 3,
	BUCK_ILMIN_250MA = 4,
	BUCK_ILMIN_300MA = 5,
	BUCK_ILMIN_350MA = 6,
	BUCK_ILMIN_400MA = 7,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CFG_CHIP_R_MSK = 240,
	CFG_DIS_M2_CLK = 2,
	CFG_SNG_MAC = 1,
};

enum {
	CFG_LED_MODE_MSK = 28,
	CFG_LINK_2_AVAIL = 2,
	CFG_LINK_1_AVAIL = 1,
};

enum {
	CFG_PRE_INIT = 0,
	CFG_POST_INIT = 1,
	CFG_PRE_PWR_HS = 2,
	CFG_POST_PWR_HS = 3,
	CFG_TAG_MAX = 4,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHIP_ID_YUKON_XL = 179,
	CHIP_ID_YUKON_EC_U = 180,
	CHIP_ID_YUKON_EX = 181,
	CHIP_ID_YUKON_EC = 182,
	CHIP_ID_YUKON_FE = 183,
	CHIP_ID_YUKON_FE_P = 184,
	CHIP_ID_YUKON_SUPR = 185,
	CHIP_ID_YUKON_UL_2 = 186,
	CHIP_ID_YUKON_OPT = 188,
	CHIP_ID_YUKON_PRM = 189,
	CHIP_ID_YUKON_OP_2 = 190,
};

enum {
	CLK_ALPHA_PLL_TYPE_DEFAULT = 0,
	CLK_ALPHA_PLL_TYPE_HUAYRA = 1,
	CLK_ALPHA_PLL_TYPE_HUAYRA_APSS = 2,
	CLK_ALPHA_PLL_TYPE_HUAYRA_2290 = 3,
	CLK_ALPHA_PLL_TYPE_BRAMMO = 4,
	CLK_ALPHA_PLL_TYPE_FABIA = 5,
	CLK_ALPHA_PLL_TYPE_TRION = 6,
	CLK_ALPHA_PLL_TYPE_LUCID = 6,
	CLK_ALPHA_PLL_TYPE_AGERA = 7,
	CLK_ALPHA_PLL_TYPE_ZONDA = 8,
	CLK_ALPHA_PLL_TYPE_REGERA = 8,
	CLK_ALPHA_PLL_TYPE_ZONDA_OLE = 9,
	CLK_ALPHA_PLL_TYPE_LUCID_EVO = 10,
	CLK_ALPHA_PLL_TYPE_LUCID_OLE = 11,
	CLK_ALPHA_PLL_TYPE_PONGO_ELU = 12,
	CLK_ALPHA_PLL_TYPE_TAYCAN_ELU = 13,
	CLK_ALPHA_PLL_TYPE_RIVIAN_EVO = 14,
	CLK_ALPHA_PLL_TYPE_DEFAULT_EVO = 15,
	CLK_ALPHA_PLL_TYPE_BRAMMO_EVO = 16,
	CLK_ALPHA_PLL_TYPE_STROMER = 17,
	CLK_ALPHA_PLL_TYPE_STROMER_PLUS = 18,
	CLK_ALPHA_PLL_TYPE_NSS_HUAYRA = 19,
	CLK_ALPHA_PLL_TYPE_MAX = 20,
};

enum {
	CLK_QSPI_APB = 0,
	CLK_QSPI_AHB = 1,
	CLK_QSPI_NUM = 2,
};

enum {
	CMD_CLK_GET_RATE = 1,
	CMD_CLK_SET_RATE = 2,
	CMD_CLK_ROUND_RATE = 3,
	CMD_CLK_GET_PARENT = 4,
	CMD_CLK_SET_PARENT = 5,
	CMD_CLK_IS_ENABLED = 6,
	CMD_CLK_ENABLE = 7,
	CMD_CLK_DISABLE = 8,
	CMD_CLK_PROPERTIES = 9,
	CMD_CLK_POSSIBLE_PARENTS = 10,
	CMD_CLK_NUM_POSSIBLE_PARENTS = 11,
	CMD_CLK_GET_POSSIBLE_PARENT = 12,
	CMD_CLK_RESET_REFCOUNTS = 13,
	CMD_CLK_GET_ALL_INFO = 14,
	CMD_CLK_GET_MAX_CLK_ID = 15,
	CMD_CLK_GET_FMAX_AT_VMIN = 16,
	CMD_CLK_MAX = 17,
};

enum {
	CMD_I2C_XFER = 1,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	CPORT_IDLE = 0,
	CPORT_CONNECTED = 1,
};

enum {
	CPU_WDOG = 3656,
	CPU_CNTR = 3660,
	CPU_TIM = 3664,
	CPU_AHB_ADDR = 3668,
	CPU_AHB_WDATA = 3672,
	CPU_AHB_RDATA = 3676,
	HCU_MAP_BASE = 3680,
	CPU_AHB_CTRL = 3684,
	HCU_CCSR = 3688,
	HCU_HCSR = 3692,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CROS_EC_SENSOR_LAST_TS = 0,
	CROS_EC_SENSOR_NEW_TS = 1,
	CROS_EC_SENSOR_ALL_TS = 2,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CRYPTO_MSG_BASE = 16,
	CRYPTO_MSG_NEWALG = 16,
	CRYPTO_MSG_DELALG = 17,
	CRYPTO_MSG_UPDATEALG = 18,
	CRYPTO_MSG_GETALG = 19,
	CRYPTO_MSG_DELRNG = 20,
	CRYPTO_MSG_GETSTAT = 21,
	__CRYPTO_MSG_MAX = 22,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DEV_ID = 0,
	PEER_DEV_ID = 1,
	PEER_CPORT_ID = 0,
	TRAFFIC_CLASS = 0,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DP83867_PORT_MIRROING_KEEP = 0,
	DP83867_PORT_MIRROING_EN = 1,
	DP83867_PORT_MIRROING_DIS = 2,
};

enum {
	DPT_START = 2,
	DPT_STOP = 1,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DRV_FIXED = 0,
	DRV_GRP0 = 1,
	DRV_GRP1 = 2,
	DRV_GRP2 = 3,
	DRV_GRP3 = 4,
	DRV_GRP4 = 5,
	DRV_GRP_MAX = 6,
};

enum {
	DT_BI_TCXO = 0,
	DT_SLEEP_CLK = 1,
	DT_UFS_PHY_RX_SYMBOL_0_CLK = 2,
	DT_UFS_PHY_RX_SYMBOL_1_CLK = 3,
	DT_UFS_PHY_TX_SYMBOL_0_CLK = 4,
	DT_UFS_CARD_RX_SYMBOL_0_CLK = 5,
	DT_UFS_CARD_RX_SYMBOL_1_CLK = 6,
	DT_UFS_CARD_TX_SYMBOL_0_CLK = 7,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK = 8,
	DT_USB3_PHY_WRAPPER_GCC_USB30_SEC_PIPE_CLK = 9,
	DT_PCIE_0_PIPE_CLK = 10,
	DT_PCIE_1_PIPE_CLK = 11,
	DT_PCIE_PHY_AUX_CLK = 12,
	DT_RXC0_REF_CLK = 13,
	DT_RXC1_REF_CLK = 14,
};

enum {
	DT_BI_TCXO___2 = 0,
	DT_SLEEP_CLK___2 = 1,
	DT_EMAC0_SGMIIPHY_MAC_RCLK = 2,
	DT_EMAC0_SGMIIPHY_MAC_TCLK = 3,
	DT_EMAC0_SGMIIPHY_RCLK = 4,
	DT_EMAC0_SGMIIPHY_TCLK = 5,
	DT_EMAC1_SGMIIPHY_MAC_RCLK = 6,
	DT_EMAC1_SGMIIPHY_MAC_TCLK = 7,
	DT_EMAC1_SGMIIPHY_RCLK = 8,
	DT_EMAC1_SGMIIPHY_TCLK = 9,
	DT_PCIE20_PHY_AUX_CLK = 10,
	DT_PCIE_1_PIPE_CLK___2 = 11,
	DT_PCIE_2_PIPE_CLK = 12,
	DT_PCIE_PIPE_CLK = 13,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 14,
};

enum {
	DT_TCXO_IDX = 0,
	DT_SLEEP_CLK_IDX = 1,
	DT_PCIE_0_PIPE_CLK_IDX = 2,
	DT_PCIE_0_PHY_AUX_CLK_IDX = 3,
	DT_USB3_PHY_WRAPPER_PIPE_CLK_IDX = 4,
};

enum {
	DT_XO = 0,
	DT_SLEEP_CLK___3 = 1,
	DT_PCIE20_PHY0_PIPE_CLK = 2,
	DT_PCIE20_PHY1_PIPE_CLK = 3,
	DT_USB3_PHY0_CC_PIPE_CLK = 4,
	DT_GEPHY_RX_CLK = 5,
	DT_GEPHY_TX_CLK = 6,
	DT_UNIPHY_RX_CLK = 7,
	DT_UNIPHY_TX_CLK = 8,
};

enum {
	DT_XO___2 = 0,
	DT_SLEEP_CLK___4 = 1,
	DT_PCIE_0_PIPE_CLK___2 = 2,
	DT_DSI0_PHY_PLL_OUT_DSICLK = 3,
	DT_DSI0_PHY_PLL_OUT_BYTECLK = 4,
	DT_HDMI_PHY_PLL_CLK = 5,
};

enum {
	DT_XO___3 = 0,
	DT_SLEEP_CLK___5 = 1,
	DT_BIAS_PLL_UBI_NC_CLK = 2,
	DT_PCIE30_PHY0_PIPE_CLK = 3,
	DT_PCIE30_PHY1_PIPE_CLK = 4,
	DT_PCIE30_PHY2_PIPE_CLK = 5,
	DT_PCIE30_PHY3_PIPE_CLK = 6,
	DT_USB3PHY_0_CC_PIPE_CLK = 7,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EDSR = 0,
	EDMR = 1,
	EDTRR = 2,
	EDRRR = 3,
	EESR = 4,
	EESIPR = 5,
	TDLAR = 6,
	TDFAR = 7,
	TDFXR = 8,
	TDFFR = 9,
	RDLAR = 10,
	RDFAR = 11,
	RDFXR = 12,
	RDFFR = 13,
	TRSCER = 14,
	RMFCR = 15,
	TFTR = 16,
	FDR = 17,
	RMCR = 18,
	EDOCR = 19,
	TFUCR = 20,
	RFOCR = 21,
	RMIIMODE = 22,
	FCFTR = 23,
	RPADIR = 24,
	TRIMD = 25,
	RBWAR = 26,
	TBRAR = 27,
	ECMR = 28,
	ECSR = 29,
	ECSIPR = 30,
	PIR = 31,
	PSR = 32,
	RDMLR = 33,
	PIPR = 34,
	RFLR = 35,
	IPGR = 36,
	APR = 37,
	MPR = 38,
	PFTCR = 39,
	PFRCR = 40,
	RFCR = 41,
	RFCF = 42,
	TPAUSER = 43,
	TPAUSECR = 44,
	BCFR = 45,
	BCFRR = 46,
	GECMR = 47,
	BCULR = 48,
	MAHR = 49,
	MALR = 50,
	TROCR = 51,
	CDCR = 52,
	LCCR = 53,
	CNDCR = 54,
	CEFCR = 55,
	FRECR = 56,
	TSFRCR = 57,
	TLFRCR = 58,
	CERCR = 59,
	CEECR = 60,
	MAFCR = 61,
	RTRATE = 62,
	CSMR = 63,
	RMII_MII = 64,
	ARSTR = 65,
	TSU_CTRST = 66,
	TSU_FWEN0 = 67,
	TSU_FWEN1 = 68,
	TSU_FCM = 69,
	TSU_BSYSL0 = 70,
	TSU_BSYSL1 = 71,
	TSU_PRISL0 = 72,
	TSU_PRISL1 = 73,
	TSU_FWSL0 = 74,
	TSU_FWSL1 = 75,
	TSU_FWSLC = 76,
	TSU_QTAG0 = 77,
	TSU_QTAG1 = 78,
	TSU_QTAGM0 = 79,
	TSU_QTAGM1 = 80,
	TSU_FWSR = 81,
	TSU_FWINMK = 82,
	TSU_ADQT0 = 83,
	TSU_ADQT1 = 84,
	TSU_VTAG0 = 85,
	TSU_VTAG1 = 86,
	TSU_ADSBSY = 87,
	TSU_TEN = 88,
	TSU_POST1 = 89,
	TSU_POST2 = 90,
	TSU_POST3 = 91,
	TSU_POST4 = 92,
	TSU_ADRH0 = 93,
	TXNLCR0 = 94,
	TXALCR0 = 95,
	RXNLCR0 = 96,
	RXALCR0 = 97,
	FWNLCR0 = 98,
	FWALCR0 = 99,
	TXNLCR1 = 100,
	TXALCR1 = 101,
	RXNLCR1 = 102,
	RXALCR1 = 103,
	FWNLCR1 = 104,
	FWALCR1 = 105,
	SH_ETH_MAX_REGISTER_OFFSET = 106,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	__ETHTOOL_MSG_USER_CNT = 48,
	ETHTOOL_MSG_USER_MAX = 47,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_STAT_EEE_WAKEUP = 0,
	ETHTOOL_STAT_SKB_ALLOC_ERR = 1,
	ETHTOOL_STAT_REFILL_ERR = 2,
	ETHTOOL_XDP_REDIRECT = 3,
	ETHTOOL_XDP_PASS = 4,
	ETHTOOL_XDP_DROP = 5,
	ETHTOOL_XDP_TX = 6,
	ETHTOOL_XDP_TX_ERR = 7,
	ETHTOOL_XDP_XMIT = 8,
	ETHTOOL_XDP_XMIT_ERR = 9,
	ETHTOOL_MAX_STATS = 10,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETHTOOL_XDP_REDIRECT___2 = 0,
	ETHTOOL_XDP_PASS___2 = 1,
	ETHTOOL_XDP_DROP___2 = 2,
	ETHTOOL_XDP_TX___2 = 3,
	ETHTOOL_XDP_TX_ERR___2 = 4,
	ETHTOOL_XDP_XMIT___2 = 5,
	ETHTOOL_XDP_XMIT_ERR___2 = 6,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_CMD_COMPLETE = 0,
	EVENT_XFER_COMPLETE = 1,
	EVENT_DATA_COMPLETE = 2,
	EVENT_DATA_ERROR = 3,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_FLAGS_RESIZING = 0,
	EXT4_FLAGS_SHUTDOWN = 1,
	EXT4_FLAGS_BDEV_IS_DAX = 2,
	EXT4_FLAGS_EMERGENCY_RO = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
	EXT4_MF_JOURNAL_DESTROY = 2,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_FC_FLUSHING_DATA = 11,
	EXT4_STATE_ORPHAN_FILE = 12,
};

enum {
	EXYNOS_ASV_SUBSYS_ID_ARM = 0,
	EXYNOS_ASV_SUBSYS_ID_KFC = 1,
	EXYNOS_ASV_SUBSYS_ID_MAX = 2,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	FW_DO_IDLE_SLEEP = 0,
	FW_DO_IDLE_AFTR = 1,
};

enum {
	F_TX_CHK_AUTO_OFF = -2147483648,
	F_TX_CHK_AUTO_ON = 1073741824,
	F_M_RX_RAM_DIS = 16777216,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GLB_GPIO_CLK_DEB_ENA = -2147483648,
	GLB_GPIO_CLK_DBG_MSK = 1006632960,
	GLB_GPIO_INT_RST_D3_DIS = 32768,
	GLB_GPIO_LED_PAD_SPEED_UP = 16384,
	GLB_GPIO_STAT_RACE_DIS = 8192,
	GLB_GPIO_TEST_SEL_MSK = 6144,
	GLB_GPIO_TEST_SEL_BASE = 2048,
	GLB_GPIO_RAND_ENA = 1024,
	GLB_GPIO_RAND_BIT_1 = 512,
};

enum {
	GMAC_CTRL = 3840,
	GPHY_CTRL = 3844,
	GMAC_IRQ_SRC = 3848,
	GMAC_IRQ_MSK = 3852,
	GMAC_LINK_CTRL = 3856,
	WOL_CTRL_STAT = 3872,
	WOL_MATCH_CTL = 3874,
	WOL_MATCH_RES = 3875,
	WOL_MAC_ADDR = 3876,
	WOL_PATT_RPTR = 3884,
	WOL_PATT_LEN_LO = 3888,
	WOL_PATT_LEN_HI = 3892,
	WOL_PATT_CNT_0 = 3896,
	WOL_PATT_CNT_4 = 3900,
};

enum {
	GMAC_TI_ST_VAL = 3604,
	GMAC_TI_ST_CTRL = 3608,
	GMAC_TI_ST_TST = 3610,
};

enum {
	GMC_SET_RST = 32768,
	GMC_SEC_RST_OFF = 16384,
	GMC_BYP_MACSECRX_ON = 8192,
	GMC_BYP_MACSECRX_OFF = 4096,
	GMC_BYP_MACSECTX_ON = 2048,
	GMC_BYP_MACSECTX_OFF = 1024,
	GMC_BYP_RETR_ON = 512,
	GMC_BYP_RETR_OFF = 256,
	GMC_H_BURST_ON = 128,
	GMC_H_BURST_OFF = 64,
	GMC_F_LOOPB_ON = 32,
	GMC_F_LOOPB_OFF = 16,
	GMC_PAUSE_ON = 8,
	GMC_PAUSE_OFF = 4,
	GMC_RST_CLR = 2,
	GMC_RST_SET = 1,
};

enum {
	GMLC_RST_CLR = 2,
	GMLC_RST_SET = 1,
};

enum {
	GMR_FS_LEN = 2147418112,
	GMR_FS_VLAN = 8192,
	GMR_FS_JABBER = 4096,
	GMR_FS_UN_SIZE = 2048,
	GMR_FS_MC = 1024,
	GMR_FS_BC = 512,
	GMR_FS_RX_OK = 256,
	GMR_FS_GOOD_FC = 128,
	GMR_FS_BAD_FC = 64,
	GMR_FS_MII_ERR = 32,
	GMR_FS_LONG_ERR = 16,
	GMR_FS_FRAGMENT = 8,
	GMR_FS_CRC_ERR = 2,
	GMR_FS_RX_FF_OV = 1,
	GMR_FS_ANY_ERR = 6267,
};

enum {
	GMT_ST_START = 4,
	GMT_ST_STOP = 2,
	GMT_ST_CLR_IRQ = 1,
};

enum {
	GM_GPCR_PROM_ENA = 16384,
	GM_GPCR_FC_TX_DIS = 8192,
	GM_GPCR_TX_ENA = 4096,
	GM_GPCR_RX_ENA = 2048,
	GM_GPCR_BURST_ENA = 1024,
	GM_GPCR_LOOP_ENA = 512,
	GM_GPCR_PART_ENA = 256,
	GM_GPCR_GIGS_ENA = 128,
	GM_GPCR_FL_PASS = 64,
	GM_GPCR_DUP_FULL = 32,
	GM_GPCR_FC_RX_DIS = 16,
	GM_GPCR_SPEED_100 = 8,
	GM_GPCR_AU_DUP_DIS = 4,
	GM_GPCR_AU_FCT_DIS = 2,
	GM_GPCR_AU_SPD_DIS = 1,
};

enum {
	GM_GP_STAT = 0,
	GM_GP_CTRL = 4,
	GM_TX_CTRL = 8,
	GM_RX_CTRL = 12,
	GM_TX_FLOW_CTRL = 16,
	GM_TX_PARAM = 20,
	GM_SERIAL_MODE = 24,
	GM_SRC_ADDR_1L = 28,
	GM_SRC_ADDR_1M = 32,
	GM_SRC_ADDR_1H = 36,
	GM_SRC_ADDR_2L = 40,
	GM_SRC_ADDR_2M = 44,
	GM_SRC_ADDR_2H = 48,
	GM_MC_ADDR_H1 = 52,
	GM_MC_ADDR_H2 = 56,
	GM_MC_ADDR_H3 = 60,
	GM_MC_ADDR_H4 = 64,
	GM_TX_IRQ_SRC = 68,
	GM_RX_IRQ_SRC = 72,
	GM_TR_IRQ_SRC = 76,
	GM_TX_IRQ_MSK = 80,
	GM_RX_IRQ_MSK = 84,
	GM_TR_IRQ_MSK = 88,
	GM_SMI_CTRL = 128,
	GM_SMI_DATA = 132,
	GM_PHY_ADDR = 136,
	GM_MIB_CNT_BASE = 256,
	GM_MIB_CNT_END = 604,
};

enum {
	GM_IS_TX_CO_OV = 32,
	GM_IS_RX_CO_OV = 16,
	GM_IS_TX_FF_UR = 8,
	GM_IS_TX_COMPL = 4,
	GM_IS_RX_FF_OR = 2,
	GM_IS_RX_COMPL = 1,
};

enum {
	GM_PAR_MIB_CLR = 32,
	GM_PAR_MIB_TST = 16,
};

enum {
	GM_RXCR_UCF_ENA = 32768,
	GM_RXCR_MCF_ENA = 16384,
	GM_RXCR_CRC_DIS = 8192,
	GM_RXCR_PASS_FC = 4096,
};

enum {
	GM_RXF_UC_OK = 256,
	GM_RXF_BC_OK = 264,
	GM_RXF_MPAUSE = 272,
	GM_RXF_MC_OK = 280,
	GM_RXF_FCS_ERR = 288,
	GM_RXO_OK_LO = 304,
	GM_RXO_OK_HI = 312,
	GM_RXO_ERR_LO = 320,
	GM_RXO_ERR_HI = 328,
	GM_RXF_SHT = 336,
	GM_RXE_FRAG = 344,
	GM_RXF_64B = 352,
	GM_RXF_127B = 360,
	GM_RXF_255B = 368,
	GM_RXF_511B = 376,
	GM_RXF_1023B = 384,
	GM_RXF_1518B = 392,
	GM_RXF_MAX_SZ = 400,
	GM_RXF_LNG_ERR = 408,
	GM_RXF_JAB_PKT = 416,
	GM_RXE_FIFO_OV = 432,
	GM_TXF_UC_OK = 448,
	GM_TXF_BC_OK = 456,
	GM_TXF_MPAUSE = 464,
	GM_TXF_MC_OK = 472,
	GM_TXO_OK_LO = 480,
	GM_TXO_OK_HI = 488,
	GM_TXF_64B = 496,
	GM_TXF_127B = 504,
	GM_TXF_255B = 512,
	GM_TXF_511B = 520,
	GM_TXF_1023B = 528,
	GM_TXF_1518B = 536,
	GM_TXF_MAX_SZ = 544,
	GM_TXF_COL = 560,
	GM_TXF_LAT_COL = 568,
	GM_TXF_ABO_COL = 576,
	GM_TXF_MUL_COL = 584,
	GM_TXF_SNG_COL = 592,
	GM_TXE_FIFO_UR = 600,
};

enum {
	GM_SMI_CT_PHY_A_MSK = 63488,
	GM_SMI_CT_REG_A_MSK = 1984,
	GM_SMI_CT_OP_RD = 32,
	GM_SMI_CT_RD_VAL = 16,
	GM_SMI_CT_BUSY = 8,
};

enum {
	GM_SMOD_DATABL_MSK = 63488,
	GM_SMOD_LIMIT_4 = 1024,
	GM_SMOD_VLAN_ENA = 512,
	GM_SMOD_JUMBO_ENA = 256,
	GM_NEW_FLOW_CTRL = 64,
	GM_SMOD_IPG_MSK = 31,
};

enum {
	GM_TXCR_FORCE_JAM = 32768,
	GM_TXCR_CRC_DIS = 16384,
	GM_TXCR_PAD_DIS = 8192,
	GM_TXCR_COL_THR_MSK = 7168,
};

enum {
	GM_TXPA_JAMLEN_MSK = 49152,
	GM_TXPA_JAMIPG_MSK = 15872,
	GM_TXPA_JAMDAT_MSK = 496,
	GM_TXPA_BO_LIM_MSK = 15,
	TX_JAM_LEN_DEF = 3,
	TX_JAM_IPG_DEF = 11,
	TX_IPG_JAM_DEF = 28,
	TX_BOF_LIM_DEF = 4,
};

enum {
	GPC_TX_PAUSE = 1073741824,
	GPC_RX_PAUSE = 536870912,
	GPC_SPEED = 402653184,
	GPC_LINK = 67108864,
	GPC_DUPLEX = 33554432,
	GPC_CLOCK = 16777216,
	GPC_PDOWN = 8388608,
	GPC_TSTMODE = 4194304,
	GPC_REG18 = 2097152,
	GPC_REG12SEL = 1572864,
	GPC_REG18SEL = 393216,
	GPC_SPILOCK = 65536,
	GPC_LEDMUX = 49152,
	GPC_INTPOL = 8192,
	GPC_DETECT = 4096,
	GPC_1000HD = 2048,
	GPC_SLAVE = 1024,
	GPC_PAUSE = 512,
	GPC_LEDCTL = 192,
	GPC_RST_CLR = 2,
	GPC_RST_SET = 1,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GP_LAST = 154,
	PIN_CLKOUT = 155,
	PIN_CS0 = 156,
	PIN_CS1_A26 = 157,
};

enum {
	GP_LAST___2 = 217,
	PIN_ASEBRK_N_ACK = 218,
	PIN_TCK = 219,
	PIN_TDI = 220,
	PIN_TMS = 221,
	PIN_TRST_N = 222,
};

enum {
	GP_LAST___3 = 249,
	PIN_ASEBRK_N_ACK___2 = 250,
	PIN_AVS1 = 251,
	PIN_AVS2 = 252,
	PIN_TCK___2 = 253,
	PIN_TDI___2 = 254,
	PIN_TMS___2 = 255,
	PIN_TRST_N___2 = 256,
};

enum {
	GP_LAST___4 = 191,
	PIN_ASEBRK_N_ACK___3 = 192,
	PIN_IIC0_SDA = 193,
	PIN_IIC0_SCL = 194,
	PIN_IIC3_SDA = 195,
	PIN_IIC3_SCL = 196,
	PIN_TCK___3 = 197,
	PIN_TDI___3 = 198,
	PIN_TMS___3 = 199,
	PIN_TRST_N___3 = 200,
};

enum {
	GP_LAST___5 = 200,
	PIN_ASEBRK_N_ACK___4 = 201,
	PIN_D0 = 202,
	PIN_D1 = 203,
	PIN_D2 = 204,
	PIN_D3 = 205,
	PIN_D4 = 206,
	PIN_D5 = 207,
	PIN_D6 = 208,
	PIN_D7 = 209,
	PIN_D8 = 210,
	PIN_D9 = 211,
	PIN_D10 = 212,
	PIN_D11 = 213,
	PIN_D12 = 214,
	PIN_D13 = 215,
	PIN_D14 = 216,
	PIN_D15 = 217,
	PIN_PRESETOUT_N = 218,
	PIN_TCK___4 = 219,
	PIN_TDI___4 = 220,
	PIN_TDO = 221,
	PIN_TMS___4 = 222,
	PIN_TRST_N___4 = 223,
};

enum {
	GP_LAST___6 = 381,
	PIN_DU0_DOTCLKIN = 382,
	PIN_DU0_DOTCLKOUT = 383,
	PIN_DU1_DOTCLKIN = 384,
	PIN_DU1_DOTCLKOUT = 385,
	PIN_EDBGREQ = 386,
	PIN_TCK___5 = 387,
	PIN_TDI___5 = 388,
	PIN_TMS___5 = 389,
	PIN_TRST_N___5 = 390,
};

enum {
	GP_LAST___7 = 191,
	PIN_ASEBRK_N_ACK___5 = 192,
	PIN_NMI = 193,
	PIN_PRESETOUT_N___2 = 194,
	PIN_TCK___6 = 195,
	PIN_TDI___6 = 196,
	PIN_TDO___2 = 197,
	PIN_TMS___6 = 198,
	PIN_TRST_N___6 = 199,
};

enum {
	GSSX_NULL = 0,
	GSSX_INDICATE_MECHS = 1,
	GSSX_GET_CALL_CONTEXT = 2,
	GSSX_IMPORT_AND_CANON_NAME = 3,
	GSSX_EXPORT_CRED = 4,
	GSSX_IMPORT_CRED = 5,
	GSSX_ACQUIRE_CRED = 6,
	GSSX_STORE_CRED = 7,
	GSSX_INIT_SEC_CONTEXT = 8,
	GSSX_ACCEPT_SEC_CONTEXT = 9,
	GSSX_RELEASE_HANDLE = 10,
	GSSX_GET_MIC = 11,
	GSSX_VERIFY = 12,
	GSSX_WRAP = 13,
	GSSX_UNWRAP = 14,
	GSSX_WRAP_SIZE_LIMIT = 15,
};

enum {
	G_SAI1 = 0,
	G_SAI2 = 1,
	G_SAI3 = 2,
	G_SAI4 = 3,
	G_SPI1 = 4,
	G_SPI2 = 5,
	G_SPI3 = 6,
	G_SPI4 = 7,
	G_SPI5 = 8,
	G_SPI6 = 9,
	G_SPDIF = 10,
	G_I2C1 = 11,
	G_I2C2 = 12,
	G_I2C3 = 13,
	G_I2C4 = 14,
	G_I2C5 = 15,
	G_I2C6 = 16,
	G_USART2 = 17,
	G_UART4 = 18,
	G_USART3 = 19,
	G_UART5 = 20,
	G_USART1 = 21,
	G_USART6 = 22,
	G_UART7 = 23,
	G_UART8 = 24,
	G_LPTIM1 = 25,
	G_LPTIM2 = 26,
	G_LPTIM3 = 27,
	G_LPTIM4 = 28,
	G_LPTIM5 = 29,
	G_LTDC = 30,
	G_DSI = 31,
	G_QSPI = 32,
	G_FMC = 33,
	G_SDMMC1 = 34,
	G_SDMMC2 = 35,
	G_SDMMC3 = 36,
	G_USBO = 37,
	G_USBPHY = 38,
	G_RNG1 = 39,
	G_RNG2 = 40,
	G_FDCAN = 41,
	G_DAC12 = 42,
	G_CEC = 43,
	G_ADC12 = 44,
	G_GPU = 45,
	G_STGEN = 46,
	G_DFSDM = 47,
	G_ADFSDM = 48,
	G_TIM2 = 49,
	G_TIM3 = 50,
	G_TIM4 = 51,
	G_TIM5 = 52,
	G_TIM6 = 53,
	G_TIM7 = 54,
	G_TIM12 = 55,
	G_TIM13 = 56,
	G_TIM14 = 57,
	G_MDIO = 58,
	G_TIM1 = 59,
	G_TIM8 = 60,
	G_TIM15 = 61,
	G_TIM16 = 62,
	G_TIM17 = 63,
	G_SYSCFG = 64,
	G_VREF = 65,
	G_TMPSENS = 66,
	G_PMBCTRL = 67,
	G_HDP = 68,
	G_IWDG2 = 69,
	G_STGENRO = 70,
	G_DMA1 = 71,
	G_DMA2 = 72,
	G_DMAMUX = 73,
	G_DCMI = 74,
	G_CRYP2 = 75,
	G_HASH2 = 76,
	G_CRC2 = 77,
	G_HSEM = 78,
	G_IPCC = 79,
	G_GPIOA = 80,
	G_GPIOB = 81,
	G_GPIOC = 82,
	G_GPIOD = 83,
	G_GPIOE = 84,
	G_GPIOF = 85,
	G_GPIOG = 86,
	G_GPIOH = 87,
	G_GPIOI = 88,
	G_GPIOJ = 89,
	G_GPIOK = 90,
	G_MDMA = 91,
	G_ETHCK = 92,
	G_ETHTX = 93,
	G_ETHRX = 94,
	G_ETHMAC = 95,
	G_CRC1 = 96,
	G_USBH = 97,
	G_ETHSTP = 98,
	G_RTCAPB = 99,
	G_TZC1 = 100,
	G_TZC2 = 101,
	G_TZPC = 102,
	G_IWDG1 = 103,
	G_BSEC = 104,
	G_GPIOZ = 105,
	G_CRYP1 = 106,
	G_HASH1 = 107,
	G_BKPSRAM = 108,
	G_DDRPERFM = 109,
	G_LAST = 110,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HASH_TCP_IPV6_EX_CTRL = 32,
	HASH_IPV6_EX_CTRL = 16,
	HASH_TCP_IPV6_CTRL = 8,
	HASH_IPV6_CTRL = 4,
	HASH_TCP_IPV4_CTRL = 2,
	HASH_IPV4_CTRL = 1,
	HASH_ALL = 63,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HCU_CCSR_SMBALERT_MONITOR = 134217728,
	HCU_CCSR_CPU_SLEEP = 67108864,
	HCU_CCSR_CS_TO = 33554432,
	HCU_CCSR_WDOG = 16777216,
	HCU_CCSR_CLR_IRQ_HOST = 131072,
	HCU_CCSR_SET_IRQ_HCU = 65536,
	HCU_CCSR_AHB_RST = 512,
	HCU_CCSR_CPU_RST_MODE = 256,
	HCU_CCSR_SET_SYNC_CPU = 32,
	HCU_CCSR_CPU_CLK_DIVIDE_MSK = 24,
	HCU_CCSR_CPU_CLK_DIVIDE_BASE = 8,
	HCU_CCSR_OS_PRSNT = 4,
	HCU_CCSR_UC_STATE_MSK = 3,
	HCU_CCSR_UC_STATE_BASE = 1,
	HCU_CCSR_ASF_RESET = 0,
	HCU_CCSR_ASF_HALTED = 2,
	HCU_CCSR_ASF_RUNNING = 1,
};

enum {
	HI3620_CTRL = 0,
	ERROR_CTRL = 1,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	HW_OWNER = 128,
	OP_TCPWRITE = 17,
	OP_TCPSTART = 18,
	OP_TCPINIT = 20,
	OP_TCPLCK = 24,
	OP_TCPCHKSUM = 18,
	OP_TCPIS = 22,
	OP_TCPLW = 25,
	OP_TCPLSW = 27,
	OP_TCPLISW = 31,
	OP_ADDR64 = 33,
	OP_VLAN = 34,
	OP_ADDR64VLAN = 35,
	OP_LRGLEN = 36,
	OP_LRGLENVLAN = 38,
	OP_MSS = 40,
	OP_MSSVLAN = 42,
	OP_BUFFER = 64,
	OP_PACKET = 65,
	OP_LARGESEND = 67,
	OP_LSOV2 = 69,
	OP_RXSTAT = 96,
	OP_RXTIMESTAMP = 97,
	OP_RXVLAN = 98,
	OP_RXCHKS = 100,
	OP_RXCHKSVLAN = 102,
	OP_RXTIMEVLAN = 99,
	OP_RSS_HASH = 101,
	OP_TXINDEXLE = 104,
	OP_MACSEC = 108,
	OP_PUTIDX = 112,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_TUN_UNSPEC = 0,
	IFLA_TUN_OWNER = 1,
	IFLA_TUN_GROUP = 2,
	IFLA_TUN_TYPE = 3,
	IFLA_TUN_PI = 4,
	IFLA_TUN_VNET_HDR = 5,
	IFLA_TUN_PERSIST = 6,
	IFLA_TUN_MULTI_QUEUE = 7,
	IFLA_TUN_NUM_QUEUES = 8,
	IFLA_TUN_NUM_DISABLED_QUEUES = 9,
	__IFLA_TUN_MAX = 10,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	__IFLA_MAX = 68,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_LINK_STATE_AUTO = 0,
	IFLA_VF_LINK_STATE_ENABLE = 1,
	IFLA_VF_LINK_STATE_DISABLE = 2,
	__IFLA_VF_LINK_STATE_MAX = 3,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INBAND_CISCO_SGMII = 0,
	INBAND_BASEX = 1,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTERRUPT_MASK_ALL_VER_11 = 204799,
	INTERRUPT_MASK_ALL_VER_21 = 466943,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMUFD_ACCESS_RW_READ = 0,
	IOMMUFD_ACCESS_RW_WRITE = 1,
	IOMMUFD_ACCESS_RW_KTHREAD = 2,
	__IOMMUFD_ACCESS_RW_SLOW_PATH = 4,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
};

enum {
	KPARAM_MEM = 0,
	KPARAM_WIDTH = 1,
	KPARAM_HEIGHT = 2,
	KPARAM_CNT = 3,
};

enum {
	KPARAM_X = 0,
	KPARAM_Y = 1,
	KPARAM_CNT___2 = 2,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LANE_0 = 0,
	LANE_1 = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LED_PAR_CTRL_COLX = 0,
	LED_PAR_CTRL_ERROR = 1,
	LED_PAR_CTRL_DUPLEX = 2,
	LED_PAR_CTRL_DP_COL = 3,
	LED_PAR_CTRL_SPEED = 4,
	LED_PAR_CTRL_LINK = 5,
	LED_PAR_CTRL_TX = 6,
	LED_PAR_CTRL_RX = 7,
	LED_PAR_CTRL_ACT = 8,
	LED_PAR_CTRL_LNK_RX = 9,
	LED_PAR_CTRL_LNK_AC = 10,
	LED_PAR_CTRL_ACT_BL = 11,
	LED_PAR_CTRL_TX_BL = 12,
	LED_PAR_CTRL_RX_BL = 13,
	LED_PAR_CTRL_COL_BL = 14,
	LED_PAR_CTRL_INACT = 15,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINKLED_OFF = 1,
	LINKLED_ON = 2,
	LINKLED_LINKSYNC_OFF = 4,
	LINKLED_LINKSYNC_ON = 8,
	LINKLED_BLINK_OFF = 16,
	LINKLED_BLINK_ON = 32,
};

enum {
	LINK_CAPA_10HD = 0,
	LINK_CAPA_10FD = 1,
	LINK_CAPA_100HD = 2,
	LINK_CAPA_100FD = 3,
	LINK_CAPA_1000HD = 4,
	LINK_CAPA_1000FD = 5,
	LINK_CAPA_2500FD = 6,
	LINK_CAPA_5000FD = 7,
	LINK_CAPA_10000FD = 8,
	LINK_CAPA_20000FD = 9,
	LINK_CAPA_25000FD = 10,
	LINK_CAPA_40000FD = 11,
	LINK_CAPA_50000FD = 12,
	LINK_CAPA_56000FD = 13,
	LINK_CAPA_100000FD = 14,
	LINK_CAPA_200000FD = 15,
	LINK_CAPA_400000FD = 16,
	LINK_CAPA_800000FD = 17,
	__LINK_CAPA_MAX = 18,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_TSECRREJECTED = 16,
	LINUX_MIB_PAWS_OLD_ACK = 17,
	LINUX_MIB_PAWS_TW_REJECTED = 18,
	LINUX_MIB_DELAYEDACKS = 19,
	LINUX_MIB_DELAYEDACKLOCKED = 20,
	LINUX_MIB_DELAYEDACKLOST = 21,
	LINUX_MIB_LISTENOVERFLOWS = 22,
	LINUX_MIB_LISTENDROPS = 23,
	LINUX_MIB_TCPHPHITS = 24,
	LINUX_MIB_TCPPUREACKS = 25,
	LINUX_MIB_TCPHPACKS = 26,
	LINUX_MIB_TCPRENORECOVERY = 27,
	LINUX_MIB_TCPSACKRECOVERY = 28,
	LINUX_MIB_TCPSACKRENEGING = 29,
	LINUX_MIB_TCPSACKREORDER = 30,
	LINUX_MIB_TCPRENOREORDER = 31,
	LINUX_MIB_TCPTSREORDER = 32,
	LINUX_MIB_TCPFULLUNDO = 33,
	LINUX_MIB_TCPPARTIALUNDO = 34,
	LINUX_MIB_TCPDSACKUNDO = 35,
	LINUX_MIB_TCPLOSSUNDO = 36,
	LINUX_MIB_TCPLOSTRETRANSMIT = 37,
	LINUX_MIB_TCPRENOFAILURES = 38,
	LINUX_MIB_TCPSACKFAILURES = 39,
	LINUX_MIB_TCPLOSSFAILURES = 40,
	LINUX_MIB_TCPFASTRETRANS = 41,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 42,
	LINUX_MIB_TCPTIMEOUTS = 43,
	LINUX_MIB_TCPLOSSPROBES = 44,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 45,
	LINUX_MIB_TCPRENORECOVERYFAIL = 46,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 47,
	LINUX_MIB_TCPRCVCOLLAPSED = 48,
	LINUX_MIB_TCPDSACKOLDSENT = 49,
	LINUX_MIB_TCPDSACKOFOSENT = 50,
	LINUX_MIB_TCPDSACKRECV = 51,
	LINUX_MIB_TCPDSACKOFORECV = 52,
	LINUX_MIB_TCPABORTONDATA = 53,
	LINUX_MIB_TCPABORTONCLOSE = 54,
	LINUX_MIB_TCPABORTONMEMORY = 55,
	LINUX_MIB_TCPABORTONTIMEOUT = 56,
	LINUX_MIB_TCPABORTONLINGER = 57,
	LINUX_MIB_TCPABORTFAILED = 58,
	LINUX_MIB_TCPMEMORYPRESSURES = 59,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 60,
	LINUX_MIB_TCPSACKDISCARD = 61,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 62,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 63,
	LINUX_MIB_TCPSPURIOUSRTOS = 64,
	LINUX_MIB_TCPMD5NOTFOUND = 65,
	LINUX_MIB_TCPMD5UNEXPECTED = 66,
	LINUX_MIB_TCPMD5FAILURE = 67,
	LINUX_MIB_SACKSHIFTED = 68,
	LINUX_MIB_SACKMERGED = 69,
	LINUX_MIB_SACKSHIFTFALLBACK = 70,
	LINUX_MIB_TCPBACKLOGDROP = 71,
	LINUX_MIB_PFMEMALLOCDROP = 72,
	LINUX_MIB_TCPMINTTLDROP = 73,
	LINUX_MIB_TCPDEFERACCEPTDROP = 74,
	LINUX_MIB_IPRPFILTER = 75,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 76,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 77,
	LINUX_MIB_TCPREQQFULLDROP = 78,
	LINUX_MIB_TCPRETRANSFAIL = 79,
	LINUX_MIB_TCPRCVCOALESCE = 80,
	LINUX_MIB_TCPBACKLOGCOALESCE = 81,
	LINUX_MIB_TCPOFOQUEUE = 82,
	LINUX_MIB_TCPOFODROP = 83,
	LINUX_MIB_TCPOFOMERGE = 84,
	LINUX_MIB_TCPCHALLENGEACK = 85,
	LINUX_MIB_TCPSYNCHALLENGE = 86,
	LINUX_MIB_TCPFASTOPENACTIVE = 87,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENPASSIVE = 89,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 90,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 91,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 92,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 93,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 94,
	LINUX_MIB_BUSYPOLLRXPACKETS = 95,
	LINUX_MIB_TCPAUTOCORKING = 96,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 97,
	LINUX_MIB_TCPTOZEROWINDOWADV = 98,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 99,
	LINUX_MIB_TCPSYNRETRANS = 100,
	LINUX_MIB_TCPORIGDATASENT = 101,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 102,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 103,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 104,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 105,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 106,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 107,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 108,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 109,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 110,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 111,
	LINUX_MIB_TCPWINPROBE = 112,
	LINUX_MIB_TCPKEEPALIVE = 113,
	LINUX_MIB_TCPMTUPFAIL = 114,
	LINUX_MIB_TCPMTUPSUCCESS = 115,
	LINUX_MIB_TCPDELIVERED = 116,
	LINUX_MIB_TCPDELIVEREDCE = 117,
	LINUX_MIB_TCPACKCOMPRESSED = 118,
	LINUX_MIB_TCPZEROWINDOWDROP = 119,
	LINUX_MIB_TCPRCVQDROP = 120,
	LINUX_MIB_TCPWQUEUETOOBIG = 121,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 122,
	LINUX_MIB_TCPTIMEOUTREHASH = 123,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 124,
	LINUX_MIB_TCPDSACKRECVSEGS = 125,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 126,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 127,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 128,
	LINUX_MIB_TCPPLBREHASH = 129,
	LINUX_MIB_TCPAOREQUIRED = 130,
	LINUX_MIB_TCPAOBAD = 131,
	LINUX_MIB_TCPAOKEYNOTFOUND = 132,
	LINUX_MIB_TCPAOGOOD = 133,
	LINUX_MIB_TCPAODROPPEDICMPS = 134,
	__LINUX_MIB_MAX = 135,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LNK_SYNC_INI = 3120,
	LNK_SYNC_VAL = 3124,
	LNK_SYNC_CTRL = 3128,
	LNK_SYNC_TST = 3129,
	LNK_LED_REG = 3132,
	RX_GMF_EA = 3136,
	RX_GMF_AF_THR = 3140,
	RX_GMF_CTRL_T = 3144,
	RX_GMF_FL_MSK = 3148,
	RX_GMF_FL_THR = 3152,
	RX_GMF_FL_CTRL = 3154,
	RX_GMF_TR_THR = 3156,
	RX_GMF_UP_THR = 3160,
	RX_GMF_LP_THR = 3162,
	RX_GMF_VLAN = 3164,
	RX_GMF_WP = 3168,
	RX_GMF_WLEV = 3176,
	RX_GMF_RP = 3184,
	RX_GMF_RLEV = 3192,
};

enum {
	LOCKD_A_SERVER_GRACETIME = 1,
	LOCKD_A_SERVER_TCP_PORT = 2,
	LOCKD_A_SERVER_UDP_PORT = 3,
	__LOCKD_A_SERVER_MAX = 4,
	LOCKD_A_SERVER_MAX = 3,
};

enum {
	LOCKD_CMD_SERVER_SET = 1,
	LOCKD_CMD_SERVER_GET = 2,
	__LOCKD_CMD_MAX = 3,
	LOCKD_CMD_MAX = 2,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MAC_TX_CLK_0_MHZ = 2,
	MAC_TX_CLK_2_5_MHZ = 6,
	MAC_TX_CLK_25_MHZ = 7,
};

enum {
	MAGNITUDE_STRONG = 2,
	MAGNITUDE_WEAK = 3,
	MAGNITUDE_NUM = 4,
};

enum {
	MASK_EE_STATUS = 65535,
	MASK_EE_DYNCAP_EVENT = 1,
	MASK_EE_SYSPOOL_EVENT = 2,
	MASK_EE_URGENT_BKOPS = 4,
	MASK_EE_TOO_HIGH_TEMP = 8,
	MASK_EE_TOO_LOW_TEMP = 16,
	MASK_EE_WRITEBOOSTER_EVENT = 32,
	MASK_EE_PERFORMANCE_THROTTLING = 64,
	MASK_EE_DEV_LVL_EXCEPTION = 128,
	MASK_EE_HEALTH_CRITICAL = 512,
};

enum {
	MASK_OCS = 15,
};

enum {
	MASK_TM_SERVICE_RESP = 255,
};

enum {
	MASK_TRANSFER_REQUESTS_SLOTS_SDB = 31,
	MASK_TRANSFER_REQUESTS_SLOTS_MCQ = 255,
	MASK_NUMBER_OUTSTANDING_RTT = 65280,
	MASK_TASK_MANAGEMENT_REQUEST_SLOTS = 458752,
	MASK_EHSLUTRD_SUPPORTED = 4194304,
	MASK_AUTO_HIBERN8_SUPPORT = 8388608,
	MASK_64_ADDRESSING_SUPPORT = 16777216,
	MASK_OUT_OF_ORDER_DATA_DELIVERY_SUPPORT = 33554432,
	MASK_UIC_DME_TEST_MODE_SUPPORT = 67108864,
	MASK_CRYPTO_SUPPORT = 268435456,
	MASK_LSDB_SUPPORT = 536870912,
	MASK_MCQ_SUPPORT = 1073741824,
};

enum {
	MAX7319 = 0,
	MAX7320 = 1,
	MAX7321 = 2,
	MAX7322 = 3,
	MAX7323 = 4,
	MAX7324 = 5,
	MAX7325 = 6,
	MAX7326 = 7,
	MAX7327 = 8,
};

enum {
	MAX77620_GPIO0 = 0,
	MAX77620_GPIO1 = 1,
	MAX77620_GPIO2 = 2,
	MAX77620_GPIO3 = 3,
	MAX77620_GPIO4 = 4,
	MAX77620_GPIO5 = 5,
	MAX77620_GPIO6 = 6,
	MAX77620_GPIO7 = 7,
	MAX77620_GPIO_NR = 8,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCT_INT_SPI = 0,
	MCT_INT_PPI = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MICRON_ON_DIE_UNSUPPORTED = 0,
	MICRON_ON_DIE_SUPPORTED = 1,
	MICRON_ON_DIE_MANDATORY = 2,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MSI_CHIP_FLAG_SET_EOI = 1,
	MSI_CHIP_FLAG_SET_ACK = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	MSPI_DONE = 1,
	BSPI_DONE = 2,
	BSPI_ERR = 4,
	MSPI_BSPI_DONE = 7,
};

enum {
	MT6357_ID_VCORE = 0,
	MT6357_ID_VMODEM = 1,
	MT6357_ID_VPA = 2,
	MT6357_ID_VPROC = 3,
	MT6357_ID_VS1 = 4,
	MT6357_ID_VAUX18 = 5,
	MT6357_ID_VAUD28 = 6,
	MT6357_ID_VCAMA = 7,
	MT6357_ID_VCAMD = 8,
	MT6357_ID_VCAMIO = 9,
	MT6357_ID_VCN18 = 10,
	MT6357_ID_VCN28 = 11,
	MT6357_ID_VCN33_BT = 12,
	MT6357_ID_VCN33_WIFI = 13,
	MT6357_ID_VDRAM = 14,
	MT6357_ID_VEFUSE = 15,
	MT6357_ID_VEMC = 16,
	MT6357_ID_VFE28 = 17,
	MT6357_ID_VIBR = 18,
	MT6357_ID_VIO18 = 19,
	MT6357_ID_VIO28 = 20,
	MT6357_ID_VLDO28 = 21,
	MT6357_ID_VMC = 22,
	MT6357_ID_VMCH = 23,
	MT6357_ID_VRF12 = 24,
	MT6357_ID_VRF18 = 25,
	MT6357_ID_VSIM1 = 26,
	MT6357_ID_VSIM2 = 27,
	MT6357_ID_VSRAM_OTHERS = 28,
	MT6357_ID_VSRAM_PROC = 29,
	MT6357_ID_VUSB33 = 30,
	MT6357_ID_VXO22 = 31,
	MT6357_ID_RG_MAX = 32,
};

enum {
	MT6358_ID_VDRAM1 = 0,
	MT6358_ID_VCORE = 1,
	MT6358_ID_VPA = 2,
	MT6358_ID_VPROC11 = 3,
	MT6358_ID_VPROC12 = 4,
	MT6358_ID_VGPU = 5,
	MT6358_ID_VS2 = 6,
	MT6358_ID_VMODEM = 7,
	MT6358_ID_VS1 = 8,
	MT6358_ID_VDRAM2 = 9,
	MT6358_ID_VSIM1 = 10,
	MT6358_ID_VIBR = 11,
	MT6358_ID_VRF12 = 12,
	MT6358_ID_VIO18 = 13,
	MT6358_ID_VUSB = 14,
	MT6358_ID_VCAMIO = 15,
	MT6358_ID_VCAMD = 16,
	MT6358_ID_VCN18 = 17,
	MT6358_ID_VFE28 = 18,
	MT6358_ID_VSRAM_PROC11 = 19,
	MT6358_ID_VCN28 = 20,
	MT6358_ID_VSRAM_OTHERS = 21,
	MT6358_ID_VSRAM_GPU = 22,
	MT6358_ID_VXO22 = 23,
	MT6358_ID_VEFUSE = 24,
	MT6358_ID_VAUX18 = 25,
	MT6358_ID_VMCH = 26,
	MT6358_ID_VBIF28 = 27,
	MT6358_ID_VSRAM_PROC12 = 28,
	MT6358_ID_VCAMA1 = 29,
	MT6358_ID_VEMC = 30,
	MT6358_ID_VIO28 = 31,
	MT6358_ID_VA12 = 32,
	MT6358_ID_VRF18 = 33,
	MT6358_ID_VCN33 = 34,
	MT6358_ID_VCAMA2 = 35,
	MT6358_ID_VMC = 36,
	MT6358_ID_VLDO28 = 37,
	MT6358_ID_VAUD28 = 38,
	MT6358_ID_VSIM2 = 39,
	MT6358_ID_RG_MAX = 40,
};

enum {
	MT6359_ID_VS1 = 0,
	MT6359_ID_VGPU11 = 1,
	MT6359_ID_VMODEM = 2,
	MT6359_ID_VPU = 3,
	MT6359_ID_VCORE = 4,
	MT6359_ID_VS2 = 5,
	MT6359_ID_VPA = 6,
	MT6359_ID_VPROC2 = 7,
	MT6359_ID_VPROC1 = 8,
	MT6359_ID_VCORE_SSHUB = 9,
	MT6359_ID_VGPU11_SSHUB = 9,
	MT6359_ID_VAUD18 = 10,
	MT6359_ID_VSIM1 = 11,
	MT6359_ID_VIBR = 12,
	MT6359_ID_VRF12 = 13,
	MT6359_ID_VUSB = 14,
	MT6359_ID_VSRAM_PROC2 = 15,
	MT6359_ID_VIO18 = 16,
	MT6359_ID_VCAMIO = 17,
	MT6359_ID_VCN18 = 18,
	MT6359_ID_VFE28 = 19,
	MT6359_ID_VCN13 = 20,
	MT6359_ID_VCN33_1_BT = 21,
	MT6359_ID_VCN33_1_WIFI = 22,
	MT6359_ID_VAUX18 = 23,
	MT6359_ID_VSRAM_OTHERS = 24,
	MT6359_ID_VEFUSE = 25,
	MT6359_ID_VXO22 = 26,
	MT6359_ID_VRFCK = 27,
	MT6359_ID_VBIF28 = 28,
	MT6359_ID_VIO28 = 29,
	MT6359_ID_VEMC = 30,
	MT6359_ID_VCN33_2_BT = 31,
	MT6359_ID_VCN33_2_WIFI = 32,
	MT6359_ID_VA12 = 33,
	MT6359_ID_VA09 = 34,
	MT6359_ID_VRF18 = 35,
	MT6359_ID_VSRAM_MD = 36,
	MT6359_ID_VUFS = 37,
	MT6359_ID_VM18 = 38,
	MT6359_ID_VBBCK = 39,
	MT6359_ID_VSRAM_PROC1 = 40,
	MT6359_ID_VSIM2 = 41,
	MT6359_ID_VSRAM_OTHERS_SSHUB = 42,
	MT6359_ID_RG_MAX = 43,
};

enum {
	MT6360_REGULATOR_BUCK1 = 0,
	MT6360_REGULATOR_BUCK2 = 1,
	MT6360_REGULATOR_LDO6 = 2,
	MT6360_REGULATOR_LDO7 = 3,
	MT6360_REGULATOR_LDO1 = 4,
	MT6360_REGULATOR_LDO2 = 5,
	MT6360_REGULATOR_LDO3 = 6,
	MT6360_REGULATOR_LDO5 = 7,
	MT6360_REGULATOR_MAX = 8,
};

enum {
	MT6360_SLAVE_TCPC = 0,
	MT6360_SLAVE_PMIC = 1,
	MT6360_SLAVE_LDO = 2,
	MT6360_SLAVE_PMU = 3,
	MT6360_SLAVE_MAX = 4,
};

enum {
	MT6366_ID_VDRAM1 = 0,
	MT6366_ID_VCORE = 1,
	MT6366_ID_VPA = 2,
	MT6366_ID_VPROC11 = 3,
	MT6366_ID_VPROC12 = 4,
	MT6366_ID_VGPU = 5,
	MT6366_ID_VS2 = 6,
	MT6366_ID_VMODEM = 7,
	MT6366_ID_VS1 = 8,
	MT6366_ID_VDRAM2 = 9,
	MT6366_ID_VSIM1 = 10,
	MT6366_ID_VIBR = 11,
	MT6366_ID_VRF12 = 12,
	MT6366_ID_VIO18 = 13,
	MT6366_ID_VUSB = 14,
	MT6366_ID_VCN18 = 15,
	MT6366_ID_VFE28 = 16,
	MT6366_ID_VSRAM_PROC11 = 17,
	MT6366_ID_VCN28 = 18,
	MT6366_ID_VSRAM_OTHERS = 19,
	MT6366_ID_VSRAM_GPU = 20,
	MT6366_ID_VXO22 = 21,
	MT6366_ID_VEFUSE = 22,
	MT6366_ID_VAUX18 = 23,
	MT6366_ID_VMCH = 24,
	MT6366_ID_VBIF28 = 25,
	MT6366_ID_VSRAM_PROC12 = 26,
	MT6366_ID_VEMC = 27,
	MT6366_ID_VIO28 = 28,
	MT6366_ID_VA12 = 29,
	MT6366_ID_VRF18 = 30,
	MT6366_ID_VCN33 = 31,
	MT6366_ID_VMC = 32,
	MT6366_ID_VAUD28 = 33,
	MT6366_ID_VSIM2 = 34,
	MT6366_ID_VM18 = 35,
	MT6366_ID_VMDDR = 36,
	MT6366_ID_VSRAM_CORE = 37,
	MT6366_ID_RG_MAX = 38,
};

enum {
	MT6397_ID_VPCA15 = 0,
	MT6397_ID_VPCA7 = 1,
	MT6397_ID_VSRAMCA15 = 2,
	MT6397_ID_VSRAMCA7 = 3,
	MT6397_ID_VCORE = 4,
	MT6397_ID_VGPU = 5,
	MT6397_ID_VDRM = 6,
	MT6397_ID_VIO18 = 7,
	MT6397_ID_VTCXO = 8,
	MT6397_ID_VA28 = 9,
	MT6397_ID_VCAMA = 10,
	MT6397_ID_VIO28 = 11,
	MT6397_ID_VUSB = 12,
	MT6397_ID_VMC = 13,
	MT6397_ID_VMCH = 14,
	MT6397_ID_VEMC3V3 = 15,
	MT6397_ID_VGP1 = 16,
	MT6397_ID_VGP2 = 17,
	MT6397_ID_VGP3 = 18,
	MT6397_ID_VGP4 = 19,
	MT6397_ID_VGP5 = 20,
	MT6397_ID_VGP6 = 21,
	MT6397_ID_VIBR = 22,
	MT6397_ID_RG_MAX = 23,
};

enum {
	MTD_OPS_PLACE_OOB = 0,
	MTD_OPS_AUTO_OOB = 1,
	MTD_OPS_RAW = 2,
};

enum {
	MTK_UART_FC_NONE = 0,
	MTK_UART_FC_SW = 1,
	MTK_UART_FC_HW = 2,
};

enum {
	MT_UNCACHED = 4,
	MT_CACHECLEAN = 5,
	MT_MINICLEAN = 6,
	MT_LOW_VECTORS = 7,
	MT_HIGH_VECTORS = 8,
	MT_MEMORY_RWX = 9,
	MT_MEMORY_RW = 10,
	MT_MEMORY_RO = 11,
	MT_ROM = 12,
	MT_MEMORY_RWX_NONCACHED = 13,
	MT_MEMORY_RW_DTCM = 14,
	MT_MEMORY_RWX_ITCM = 15,
	MT_MEMORY_RW_SO = 16,
	MT_MEMORY_DMA_READY = 17,
};

enum {
	MUSB_CONTROLLER_MHDRC = 0,
	MUSB_CONTROLLER_HDRC = 1,
};

enum {
	MV64XXX_I2C_ACTION_INVALID = 0,
	MV64XXX_I2C_ACTION_CONTINUE = 1,
	MV64XXX_I2C_ACTION_SEND_RESTART = 2,
	MV64XXX_I2C_ACTION_SEND_ADDR_1 = 3,
	MV64XXX_I2C_ACTION_SEND_ADDR_2 = 4,
	MV64XXX_I2C_ACTION_SEND_DATA = 5,
	MV64XXX_I2C_ACTION_RCV_DATA = 6,
	MV64XXX_I2C_ACTION_RCV_DATA_STOP = 7,
	MV64XXX_I2C_ACTION_SEND_STOP = 8,
};

enum {
	MV64XXX_I2C_STATE_INVALID = 0,
	MV64XXX_I2C_STATE_IDLE = 1,
	MV64XXX_I2C_STATE_WAITING_FOR_START_COND = 2,
	MV64XXX_I2C_STATE_WAITING_FOR_RESTART = 3,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_1_ACK = 4,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_2_ACK = 5,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_ACK = 6,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_DATA = 7,
};

enum {
	MV_PMA_FW_VER0 = 49169,
	MV_PMA_FW_VER1 = 49170,
	MV_PMA_21X0_PORT_CTRL = 49226,
	MV_PMA_21X0_PORT_CTRL_SWRST = 32768,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_USXGMII = 0,
	MV_PMA_2180_PORT_CTRL_MACTYPE_DXGMII = 1,
	MV_PMA_2180_PORT_CTRL_MACTYPE_QXGMII = 2,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER = 4,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER_NO_SGMII_AN = 5,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_PMA_BOOT = 49232,
	MV_PMA_BOOT_FATAL = 1,
	MV_PCS_BASE_T = 0,
	MV_PCS_BASE_R = 4096,
	MV_PCS_1000BASEX = 8192,
	MV_PCS_CSCR1 = 32768,
	MV_PCS_CSCR1_ED_MASK = 768,
	MV_PCS_CSCR1_ED_OFF = 0,
	MV_PCS_CSCR1_ED_RX = 512,
	MV_PCS_CSCR1_ED_NLP = 768,
	MV_PCS_CSCR1_MDIX_MASK = 96,
	MV_PCS_CSCR1_MDIX_MDI = 0,
	MV_PCS_CSCR1_MDIX_MDIX = 32,
	MV_PCS_CSCR1_MDIX_AUTO = 96,
	MV_PCS_DSC1 = 32771,
	MV_PCS_DSC1_ENABLE = 512,
	MV_PCS_DSC1_10GBT = 448,
	MV_PCS_DSC1_1GBR = 56,
	MV_PCS_DSC1_100BTX = 7,
	MV_PCS_DSC2 = 32772,
	MV_PCS_DSC2_2P5G = 61440,
	MV_PCS_DSC2_5G = 3840,
	MV_PCS_CSSR1 = 32776,
	MV_PCS_CSSR1_SPD1_MASK = 49152,
	MV_PCS_CSSR1_SPD1_SPD2 = 49152,
	MV_PCS_CSSR1_SPD1_1000 = 32768,
	MV_PCS_CSSR1_SPD1_100 = 16384,
	MV_PCS_CSSR1_SPD1_10 = 0,
	MV_PCS_CSSR1_DUPLEX_FULL = 8192,
	MV_PCS_CSSR1_RESOLVED = 2048,
	MV_PCS_CSSR1_MDIX = 64,
	MV_PCS_CSSR1_SPD2_MASK = 12,
	MV_PCS_CSSR1_SPD2_5000 = 8,
	MV_PCS_CSSR1_SPD2_2500 = 4,
	MV_PCS_CSSR1_SPD2_10000 = 0,
	MV_PCS_TEMP = 32834,
	MV_PCS_PORT_INFO = 53261,
	MV_PCS_PORT_INFO_NPORTS_MASK = 896,
	MV_PCS_PORT_INFO_NPORTS_SHIFT = 7,
	MV_AN_21X0_SERDES_CTRL2 = 32783,
	MV_AN_21X0_SERDES_CTRL2_AUTO_INIT_DIS = 8192,
	MV_AN_21X0_SERDES_CTRL2_RUN_INIT = 32768,
	MV_AN_CTRL1000 = 32768,
	MV_AN_STAT1000 = 32769,
	MV_V2_PORT_CTRL = 61441,
	MV_V2_PORT_CTRL_PWRDOWN = 2048,
	MV_V2_33X0_PORT_CTRL_SWRST = 32768,
	MV_V2_33X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI = 0,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI_RATE_MATCH = 1,
	MV_V2_3340_PORT_CTRL_MACTYPE_RXAUI_NO_SGMII_AN = 1,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI_RATE_MATCH = 2,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI = 3,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER = 4,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_NO_SGMII_AN = 5,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_V2_33X0_PORT_CTRL_MACTYPE_USXGMII = 7,
	MV_V2_PORT_INTR_STS = 61504,
	MV_V2_PORT_INTR_MASK = 61507,
	MV_V2_PORT_INTR_STS_WOL_EN = 256,
	MV_V2_MAGIC_PKT_WORD0 = 61547,
	MV_V2_MAGIC_PKT_WORD1 = 61548,
	MV_V2_MAGIC_PKT_WORD2 = 61549,
	MV_V2_WOL_CTRL = 61550,
	MV_V2_WOL_CTRL_CLEAR_STS = 32768,
	MV_V2_WOL_CTRL_MAGIC_PKT_EN = 1,
	MV_V2_TEMP_CTRL = 61578,
	MV_V2_TEMP_CTRL_MASK = 49152,
	MV_V2_TEMP_CTRL_SAMPLE = 0,
	MV_V2_TEMP_CTRL_DISABLE = 49152,
	MV_V2_TEMP = 61580,
	MV_V2_TEMP_UNKNOWN = 38400,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	M_SDMMC12 = 0,
	M_SDMMC3 = 1,
	M_FMC = 2,
	M_QSPI = 3,
	M_RNG1 = 4,
	M_RNG2 = 5,
	M_USBPHY = 6,
	M_USBO = 7,
	M_STGEN = 8,
	M_SPDIF = 9,
	M_SPI1 = 10,
	M_SPI23 = 11,
	M_SPI45 = 12,
	M_SPI6 = 13,
	M_CEC = 14,
	M_I2C12 = 15,
	M_I2C35 = 16,
	M_I2C46 = 17,
	M_LPTIM1 = 18,
	M_LPTIM23 = 19,
	M_LPTIM45 = 20,
	M_USART1 = 21,
	M_UART24 = 22,
	M_UART35 = 23,
	M_USART6 = 24,
	M_UART78 = 25,
	M_SAI1 = 26,
	M_SAI2 = 27,
	M_SAI3 = 28,
	M_SAI4 = 29,
	M_DSI = 30,
	M_FDCAN = 31,
	M_ADC12 = 32,
	M_ETHCK = 33,
	M_CKPER = 34,
	M_LAST = 35,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_ZERO_RANGE = 57,
	NFSPROC4_CLNT_LAYOUTSTATS = 58,
	NFSPROC4_CLNT_CLONE = 59,
	NFSPROC4_CLNT_COPY = 60,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 61,
	NFSPROC4_CLNT_LOOKUPP = 62,
	NFSPROC4_CLNT_LAYOUTERROR = 63,
	NFSPROC4_CLNT_COPY_NOTIFY = 64,
	NFSPROC4_CLNT_GETXATTR = 65,
	NFSPROC4_CLNT_SETXATTR = 66,
	NFSPROC4_CLNT_LISTXATTRS = 67,
	NFSPROC4_CLNT_REMOVEXATTR = 68,
	NFSPROC4_CLNT_READ_PLUS = 69,
	NFSPROC4_CLNT_OFFLOAD_STATUS = 70,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check = 0,
	Opt_uid = 1,
	Opt_gid = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___2 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_debug___3 = 0,
	Opt_dfltuid = 1,
	Opt_dfltgid = 2,
	Opt_afid = 3,
	Opt_uname = 4,
	Opt_remotename = 5,
	Opt_cache = 6,
	Opt_cachetag = 7,
	Opt_nodevmap = 8,
	Opt_noxattr = 9,
	Opt_directio = 10,
	Opt_ignoreqv = 11,
	Opt_access = 12,
	Opt_posixacl = 13,
	Opt_locktimeout = 14,
	Opt_err___2 = 15,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_fatal_neterrors_default = 0,
	Opt_fatal_neterrors_enetunreach = 1,
	Opt_fatal_neterrors_none = 2,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_kmsg_bytes = 0,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_msize = 0,
	Opt_trans = 1,
	Opt_legacy = 2,
	Opt_version = 3,
	Opt_err___4 = 4,
};

enum {
	Opt_port = 0,
	Opt_rfdno = 1,
	Opt_wfdno = 2,
	Opt_err___5 = 3,
	Opt_privport = 4,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___6 = 0,
	Opt_gid___6 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___6 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCA9450_BUCK1 = 0,
	PCA9450_BUCK2 = 1,
	PCA9450_BUCK3 = 2,
	PCA9450_BUCK4 = 3,
	PCA9450_BUCK5 = 4,
	PCA9450_BUCK6 = 5,
	PCA9450_LDO1 = 6,
	PCA9450_LDO2 = 7,
	PCA9450_LDO3 = 8,
	PCA9450_LDO4 = 9,
	PCA9450_LDO5 = 10,
	PCA9450_REGULATOR_CNT = 11,
};

enum {
	PCA9450_DVS_LEVEL_RUN = 0,
	PCA9450_DVS_LEVEL_STANDBY = 1,
	PCA9450_DVS_LEVEL_MAX = 2,
};

enum {
	PCA9450_REG_DEV_ID = 0,
	PCA9450_REG_INT1 = 1,
	PCA9450_REG_INT1_MSK = 2,
	PCA9450_REG_STATUS1 = 3,
	PCA9450_REG_STATUS2 = 4,
	PCA9450_REG_PWRON_STAT = 5,
	PCA9450_REG_SWRST = 6,
	PCA9450_REG_PWRCTRL = 7,
	PCA9450_REG_RESET_CTRL = 8,
	PCA9450_REG_CONFIG1 = 9,
	PCA9450_REG_CONFIG2 = 10,
	PCA9450_REG_BUCK123_DVS = 12,
	PCA9450_REG_BUCK1OUT_LIMIT = 13,
	PCA9450_REG_BUCK2OUT_LIMIT = 14,
	PCA9450_REG_BUCK3OUT_LIMIT = 15,
	PCA9450_REG_BUCK1CTRL = 16,
	PCA9450_REG_BUCK1OUT_DVS0 = 17,
	PCA9450_REG_BUCK1OUT_DVS1 = 18,
	PCA9450_REG_BUCK2CTRL = 19,
	PCA9450_REG_BUCK2OUT_DVS0 = 20,
	PCA9450_REG_BUCK2OUT_DVS1 = 21,
	PCA9450_REG_BUCK3CTRL = 22,
	PCA9450_REG_BUCK3OUT_DVS0 = 23,
	PCA9450_REG_BUCK3OUT_DVS1 = 24,
	PCA9450_REG_BUCK4CTRL = 25,
	PCA9450_REG_BUCK4OUT = 26,
	PCA9450_REG_BUCK5CTRL = 27,
	PCA9450_REG_BUCK5OUT = 28,
	PCA9450_REG_BUCK6CTRL = 29,
	PCA9450_REG_BUCK6OUT = 30,
	PCA9450_REG_LDO_AD_CTRL = 32,
	PCA9450_REG_LDO1CTRL = 33,
	PCA9450_REG_LDO2CTRL = 34,
	PCA9450_REG_LDO3CTRL = 35,
	PCA9450_REG_LDO4CTRL = 36,
	PCA9450_REG_LDO5CTRL_L = 37,
	PCA9450_REG_LDO5CTRL_H = 38,
	PCA9450_REG_LOADSW_CTRL = 42,
	PCA9450_REG_VRFLT1_STS = 43,
	PCA9450_REG_VRFLT2_STS = 44,
	PCA9450_REG_VRFLT1_MASK = 45,
	PCA9450_REG_VRFLT2_MASK = 46,
	PCA9450_MAX_REGISTER = 47,
};

enum {
	PCI_DEV_REG1 = 64,
	PCI_DEV_REG2 = 68,
	PCI_DEV_STATUS = 124,
	PCI_DEV_REG3 = 128,
	PCI_DEV_REG4 = 132,
	PCI_DEV_REG5 = 136,
	PCI_CFG_REG_0 = 144,
	PCI_CFG_REG_1 = 148,
	PSM_CONFIG_REG0 = 152,
	PSM_CONFIG_REG1 = 156,
	PSM_CONFIG_REG2 = 352,
	PSM_CONFIG_REG3 = 356,
	PSM_CONFIG_REG4 = 360,
	PCI_LDO_CTRL = 188,
};

enum {
	PCI_ID_F_VFIO_DRIVER_OVERRIDE = 1,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PC_VAUX_ENA = 128,
	PC_VAUX_DIS = 64,
	PC_VCC_ENA = 32,
	PC_VCC_DIS = 16,
	PC_VAUX_ON = 8,
	PC_VAUX_OFF = 4,
	PC_VCC_ON = 2,
	PC_VCC_OFF = 1,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_FC_LEVEL = 0,
	PERF_FC_LIMIT = 1,
	PERF_FC_MAX = 2,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PEX_RD_ACCESS = -2147483648,
	PEX_DB_ACCESS = 1073741824,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PHY_ADDR_MARV = 0,
};

enum {
	PHY_AN_NXT_PG = 32768,
	PHY_AN_ACK = 16384,
	PHY_AN_RF = 8192,
	PHY_AN_PAUSE_ASYM = 2048,
	PHY_AN_PAUSE_CAP = 1024,
	PHY_AN_100BASE4 = 512,
	PHY_AN_100FULL = 256,
	PHY_AN_100HALF = 128,
	PHY_AN_10FULL = 64,
	PHY_AN_10HALF = 32,
	PHY_AN_CSMA = 1,
	PHY_AN_SEL = 31,
	PHY_AN_FULL = 321,
	PHY_AN_ALL = 480,
};

enum {
	PHY_CT_RESET = 32768,
	PHY_CT_LOOP = 16384,
	PHY_CT_SPS_LSB = 8192,
	PHY_CT_ANE = 4096,
	PHY_CT_PDOWN = 2048,
	PHY_CT_ISOL = 1024,
	PHY_CT_RE_CFG = 512,
	PHY_CT_DUP_MD = 256,
	PHY_CT_COL_TST = 128,
	PHY_CT_SPS_MSB = 64,
};

enum {
	PHY_CT_SP1000 = 64,
	PHY_CT_SP100 = 8192,
	PHY_CT_SP10 = 0,
};

enum {
	PHY_MARV_CTRL = 0,
	PHY_MARV_STAT = 1,
	PHY_MARV_ID0 = 2,
	PHY_MARV_ID1 = 3,
	PHY_MARV_AUNE_ADV = 4,
	PHY_MARV_AUNE_LP = 5,
	PHY_MARV_AUNE_EXP = 6,
	PHY_MARV_NEPG = 7,
	PHY_MARV_NEPG_LP = 8,
	PHY_MARV_1000T_CTRL = 9,
	PHY_MARV_1000T_STAT = 10,
	PHY_MARV_EXT_STAT = 15,
	PHY_MARV_PHY_CTRL = 16,
	PHY_MARV_PHY_STAT = 17,
	PHY_MARV_INT_MASK = 18,
	PHY_MARV_INT_STAT = 19,
	PHY_MARV_EXT_CTRL = 20,
	PHY_MARV_RXE_CNT = 21,
	PHY_MARV_EXT_ADR = 22,
	PHY_MARV_PORT_IRQ = 23,
	PHY_MARV_LED_CTRL = 24,
	PHY_MARV_LED_OVER = 25,
	PHY_MARV_EXT_CTRL_2 = 26,
	PHY_MARV_EXT_P_STAT = 27,
	PHY_MARV_CABLE_DIAG = 28,
	PHY_MARV_PAGE_ADDR = 29,
	PHY_MARV_PAGE_DATA = 30,
	PHY_MARV_FE_LED_PAR = 22,
	PHY_MARV_FE_LED_SER = 23,
	PHY_MARV_FE_VCT_TX = 26,
	PHY_MARV_FE_VCT_RX = 27,
	PHY_MARV_FE_SPEC_2 = 28,
};

enum {
	PHY_MARV_ID0_VAL = 321,
	PHY_BCOM_ID1_A1 = 24641,
	PHY_BCOM_ID1_B2 = 24643,
	PHY_BCOM_ID1_C0 = 24644,
	PHY_BCOM_ID1_C5 = 24647,
	PHY_MARV_ID1_B0 = 3107,
	PHY_MARV_ID1_B2 = 3109,
	PHY_MARV_ID1_C2 = 3266,
	PHY_MARV_ID1_Y2 = 3217,
	PHY_MARV_ID1_FE = 3203,
	PHY_MARV_ID1_ECU = 3248,
};

enum {
	PHY_M_1000C_TEST = 57344,
	PHY_M_1000C_MSE = 4096,
	PHY_M_1000C_MSC = 2048,
	PHY_M_1000C_MPD = 1024,
	PHY_M_1000C_AFD = 512,
	PHY_M_1000C_AHD = 256,
};

enum {
	PHY_M_AN_ASP_X = 256,
	PHY_M_AN_PC_X = 128,
	PHY_M_AN_1000X_AHD = 64,
	PHY_M_AN_1000X_AFD = 32,
};

enum {
	PHY_M_AN_NXT_PG = 32768,
	PHY_M_AN_ACK = 16384,
	PHY_M_AN_RF = 8192,
	PHY_M_AN_ASP = 2048,
	PHY_M_AN_PC = 1024,
	PHY_M_AN_100_T4 = 512,
	PHY_M_AN_100_FD = 256,
	PHY_M_AN_100_HD = 128,
	PHY_M_AN_10_FD = 64,
	PHY_M_AN_10_HD = 32,
	PHY_M_AN_SEL_MSK = 496,
};

enum {
	PHY_M_EC_ENA_BC_EXT = 32768,
	PHY_M_EC_ENA_LIN_LB = 16384,
	PHY_M_EC_DIS_LINK_P = 4096,
	PHY_M_EC_M_DSC_MSK = 3072,
	PHY_M_EC_S_DSC_MSK = 768,
	PHY_M_EC_M_DSC_MSK2 = 3584,
	PHY_M_EC_DOWN_S_ENA = 256,
	PHY_M_EC_RX_TIM_CT = 128,
	PHY_M_EC_MAC_S_MSK = 112,
	PHY_M_EC_FIB_AN_ENA = 8,
	PHY_M_EC_DTE_D_ENA = 4,
	PHY_M_EC_TX_TIM_CT = 2,
	PHY_M_EC_TRANS_DIS = 1,
	PHY_M_10B_TE_ENABLE = 128,
};

enum {
	PHY_M_FC_AUTO_SEL = 32768,
	PHY_M_FC_AN_REG_ACC = 16384,
	PHY_M_FC_RESOLUTION = 8192,
	PHY_M_SER_IF_AN_BP = 4096,
	PHY_M_SER_IF_BP_ST = 2048,
	PHY_M_IRQ_POLARITY = 1024,
	PHY_M_DIS_AUT_MED = 512,
	PHY_M_UNDOC1 = 128,
	PHY_M_DTE_POW_STAT = 16,
	PHY_M_MODE_MASK = 15,
};

enum {
	PHY_M_FELP_LED2_MSK = 3840,
	PHY_M_FELP_LED1_MSK = 240,
	PHY_M_FELP_LED0_MSK = 15,
};

enum {
	PHY_M_FESC_DIS_WAIT = 4,
	PHY_M_FESC_ENA_MCLK = 2,
	PHY_M_FESC_SEL_CL_A = 1,
};

enum {
	PHY_M_FIB_FORCE_LNK = 1024,
	PHY_M_FIB_SIGD_POL = 512,
	PHY_M_FIB_TX_DIS = 8,
};

enum {
	PHY_M_IS_AN_ERROR = 32768,
	PHY_M_IS_LSP_CHANGE = 16384,
	PHY_M_IS_DUP_CHANGE = 8192,
	PHY_M_IS_AN_PR = 4096,
	PHY_M_IS_AN_COMPL = 2048,
	PHY_M_IS_LST_CHANGE = 1024,
	PHY_M_IS_SYMB_ERROR = 512,
	PHY_M_IS_FALSE_CARR = 256,
	PHY_M_IS_FIFO_ERROR = 128,
	PHY_M_IS_MDI_CHANGE = 64,
	PHY_M_IS_DOWNSH_DET = 32,
	PHY_M_IS_END_CHANGE = 16,
	PHY_M_IS_DTE_CHANGE = 4,
	PHY_M_IS_POL_CHANGE = 2,
	PHY_M_IS_JABBER = 1,
	PHY_M_DEF_MSK = 25600,
	PHY_M_AN_MSK = 34816,
};

enum {
	PHY_M_LEDC_DIS_LED = 32768,
	PHY_M_LEDC_PULS_MSK = 28672,
	PHY_M_LEDC_F_INT = 2048,
	PHY_M_LEDC_BL_R_MSK = 1792,
	PHY_M_LEDC_DP_C_LSB = 128,
	PHY_M_LEDC_TX_C_LSB = 64,
	PHY_M_LEDC_LK_C_MSK = 56,
};

enum {
	PHY_M_LEDC_LINK_MSK = 24,
	PHY_M_LEDC_DP_CTRL = 4,
	PHY_M_LEDC_DP_C_MSB = 4,
	PHY_M_LEDC_RX_CTRL = 2,
	PHY_M_LEDC_TX_CTRL = 1,
	PHY_M_LEDC_TX_C_MSB = 1,
};

enum {
	PHY_M_LEDC_LOS_MSK = 61440,
	PHY_M_LEDC_INIT_MSK = 3840,
	PHY_M_LEDC_STA1_MSK = 240,
	PHY_M_LEDC_STA0_MSK = 15,
};

enum {
	PHY_M_MAC_MD_MSK = 896,
	PHY_M_MAC_GMIF_PUP = 8,
	PHY_M_MAC_MD_AUTO = 3,
	PHY_M_MAC_MD_COPPER = 5,
	PHY_M_MAC_MD_1000BX = 7,
};

enum {
	PHY_M_PC_COP_TX_DIS = 8,
	PHY_M_PC_POW_D_ENA = 4,
};

enum {
	PHY_M_PC_DIS_LINK_Pa = 32768,
	PHY_M_PC_DSC_MSK = 28672,
	PHY_M_PC_DOWN_S_ENA = 2048,
};

enum {
	PHY_M_PC_ENA_DTE_DT = 32768,
	PHY_M_PC_ENA_ENE_DT = 16384,
	PHY_M_PC_DIS_NLP_CK = 8192,
	PHY_M_PC_ENA_LIP_NP = 4096,
	PHY_M_PC_DIS_NLP_GN = 2048,
	PHY_M_PC_DIS_SCRAMB = 512,
	PHY_M_PC_DIS_FEFI = 256,
	PHY_M_PC_SH_TP_SEL = 64,
	PHY_M_PC_RX_FD_MSK = 12,
};

enum {
	PHY_M_PC_MAN_MDI = 0,
	PHY_M_PC_MAN_MDIX = 1,
	PHY_M_PC_ENA_AUTO = 3,
};

enum {
	PHY_M_PC_TX_FFD_MSK = 49152,
	PHY_M_PC_RX_FFD_MSK = 12288,
	PHY_M_PC_ASS_CRS_TX = 2048,
	PHY_M_PC_FL_GOOD = 1024,
	PHY_M_PC_EN_DET_MSK = 768,
	PHY_M_PC_ENA_EXT_D = 128,
	PHY_M_PC_MDIX_MSK = 96,
	PHY_M_PC_DIS_125CLK = 16,
	PHY_M_PC_MAC_POW_UP = 8,
	PHY_M_PC_SQE_T_ENA = 4,
	PHY_M_PC_POL_R_DIS = 2,
	PHY_M_PC_DIS_JABBER = 1,
};

enum {
	PHY_M_POLC_LS1M_MSK = 61440,
	PHY_M_POLC_IS0M_MSK = 3840,
	PHY_M_POLC_LOS_MSK = 192,
	PHY_M_POLC_INIT_MSK = 48,
	PHY_M_POLC_STA1_MSK = 12,
	PHY_M_POLC_STA0_MSK = 3,
};

enum {
	PHY_M_PS_SPEED_MSK = 49152,
	PHY_M_PS_SPEED_1000 = 32768,
	PHY_M_PS_SPEED_100 = 16384,
	PHY_M_PS_SPEED_10 = 0,
	PHY_M_PS_FULL_DUP = 8192,
	PHY_M_PS_PAGE_REC = 4096,
	PHY_M_PS_SPDUP_RES = 2048,
	PHY_M_PS_LINK_UP = 1024,
	PHY_M_PS_CABLE_MSK = 896,
	PHY_M_PS_MDI_X_STAT = 64,
	PHY_M_PS_DOWNS_STAT = 32,
	PHY_M_PS_ENDET_STAT = 16,
	PHY_M_PS_TX_P_EN = 8,
	PHY_M_PS_RX_P_EN = 4,
	PHY_M_PS_POL_REV = 2,
	PHY_M_PS_JABBER = 1,
};

enum {
	PHY_M_P_NO_PAUSE_X = 0,
	PHY_M_P_SYM_MD_X = 128,
	PHY_M_P_ASYM_MD_X = 256,
	PHY_M_P_BOTH_MD_X = 384,
};

enum {
	PINCTRL_PIN_REG_MODE = 0,
	PINCTRL_PIN_REG_DIR = 1,
	PINCTRL_PIN_REG_DI = 2,
	PINCTRL_PIN_REG_DO = 3,
	PINCTRL_PIN_REG_SR = 4,
	PINCTRL_PIN_REG_SMT = 5,
	PINCTRL_PIN_REG_PD = 6,
	PINCTRL_PIN_REG_PU = 7,
	PINCTRL_PIN_REG_E4 = 8,
	PINCTRL_PIN_REG_E8 = 9,
	PINCTRL_PIN_REG_TDSEL = 10,
	PINCTRL_PIN_REG_RDSEL = 11,
	PINCTRL_PIN_REG_DRV = 12,
	PINCTRL_PIN_REG_PUPD = 13,
	PINCTRL_PIN_REG_R0 = 14,
	PINCTRL_PIN_REG_R1 = 15,
	PINCTRL_PIN_REG_IES = 16,
	PINCTRL_PIN_REG_PULLEN = 17,
	PINCTRL_PIN_REG_PULLSEL = 18,
	PINCTRL_PIN_REG_DRV_EN = 19,
	PINCTRL_PIN_REG_DRV_E0 = 20,
	PINCTRL_PIN_REG_DRV_E1 = 21,
	PINCTRL_PIN_REG_DRV_ADV = 22,
	PINCTRL_PIN_REG_RSEL = 23,
	PINCTRL_PIN_REG_MAX = 24,
};

enum {
	PINMUX_RESERVED = 0,
	PINMUX_DATA_BEGIN = 1,
	GP_0_0_DATA = 2,
	GP_0_1_DATA = 3,
	GP_0_2_DATA = 4,
	GP_0_3_DATA = 5,
	GP_0_4_DATA = 6,
	GP_0_5_DATA = 7,
	GP_0_6_DATA = 8,
	GP_0_7_DATA = 9,
	GP_0_8_DATA = 10,
	GP_0_9_DATA = 11,
	GP_0_10_DATA = 12,
	GP_0_11_DATA = 13,
	GP_0_12_DATA = 14,
	GP_0_13_DATA = 15,
	GP_0_14_DATA = 16,
	GP_0_15_DATA = 17,
	GP_0_16_DATA = 18,
	GP_0_17_DATA = 19,
	GP_0_18_DATA = 20,
	GP_0_19_DATA = 21,
	GP_0_20_DATA = 22,
	GP_0_21_DATA = 23,
	GP_0_22_DATA = 24,
	GP_0_23_DATA = 25,
	GP_0_24_DATA = 26,
	GP_0_25_DATA = 27,
	GP_0_26_DATA = 28,
	GP_0_27_DATA = 29,
	GP_0_28_DATA = 30,
	GP_0_29_DATA = 31,
	GP_0_30_DATA = 32,
	GP_0_31_DATA = 33,
	GP_1_0_DATA = 34,
	GP_1_1_DATA = 35,
	GP_1_2_DATA = 36,
	GP_1_3_DATA = 37,
	GP_1_4_DATA = 38,
	GP_1_5_DATA = 39,
	GP_1_6_DATA = 40,
	GP_1_7_DATA = 41,
	GP_1_8_DATA = 42,
	GP_1_9_DATA = 43,
	GP_1_10_DATA = 44,
	GP_1_11_DATA = 45,
	GP_1_12_DATA = 46,
	GP_1_13_DATA = 47,
	GP_1_14_DATA = 48,
	GP_1_15_DATA = 49,
	GP_1_16_DATA = 50,
	GP_1_17_DATA = 51,
	GP_1_18_DATA = 52,
	GP_1_19_DATA = 53,
	GP_1_20_DATA = 54,
	GP_1_21_DATA = 55,
	GP_1_22_DATA = 56,
	GP_1_23_DATA = 57,
	GP_1_24_DATA = 58,
	GP_1_25_DATA = 59,
	GP_2_0_DATA = 60,
	GP_2_1_DATA = 61,
	GP_2_2_DATA = 62,
	GP_2_3_DATA = 63,
	GP_2_4_DATA = 64,
	GP_2_5_DATA = 65,
	GP_2_6_DATA = 66,
	GP_2_7_DATA = 67,
	GP_2_8_DATA = 68,
	GP_2_9_DATA = 69,
	GP_2_10_DATA = 70,
	GP_2_11_DATA = 71,
	GP_2_12_DATA = 72,
	GP_2_13_DATA = 73,
	GP_2_14_DATA = 74,
	GP_2_15_DATA = 75,
	GP_2_16_DATA = 76,
	GP_2_17_DATA = 77,
	GP_2_18_DATA = 78,
	GP_2_19_DATA = 79,
	GP_2_20_DATA = 80,
	GP_2_21_DATA = 81,
	GP_2_22_DATA = 82,
	GP_2_23_DATA = 83,
	GP_2_24_DATA = 84,
	GP_2_25_DATA = 85,
	GP_2_26_DATA = 86,
	GP_2_27_DATA = 87,
	GP_2_28_DATA = 88,
	GP_2_29_DATA = 89,
	GP_2_30_DATA = 90,
	GP_2_31_DATA = 91,
	GP_3_0_DATA = 92,
	GP_3_1_DATA = 93,
	GP_3_2_DATA = 94,
	GP_3_3_DATA = 95,
	GP_3_4_DATA = 96,
	GP_3_5_DATA = 97,
	GP_3_6_DATA = 98,
	GP_3_7_DATA = 99,
	GP_3_8_DATA = 100,
	GP_3_9_DATA = 101,
	GP_3_10_DATA = 102,
	GP_3_11_DATA = 103,
	GP_3_12_DATA = 104,
	GP_3_13_DATA = 105,
	GP_3_14_DATA = 106,
	GP_3_15_DATA = 107,
	GP_3_16_DATA = 108,
	GP_3_17_DATA = 109,
	GP_3_18_DATA = 110,
	GP_3_19_DATA = 111,
	GP_3_20_DATA = 112,
	GP_3_21_DATA = 113,
	GP_3_22_DATA = 114,
	GP_3_23_DATA = 115,
	GP_3_24_DATA = 116,
	GP_3_25_DATA = 117,
	GP_3_26_DATA = 118,
	GP_3_27_DATA = 119,
	GP_3_28_DATA = 120,
	GP_3_29_DATA = 121,
	GP_3_30_DATA = 122,
	GP_3_31_DATA = 123,
	GP_4_0_DATA = 124,
	GP_4_1_DATA = 125,
	GP_4_2_DATA = 126,
	GP_4_3_DATA = 127,
	GP_4_4_DATA = 128,
	GP_4_5_DATA = 129,
	GP_4_6_DATA = 130,
	GP_4_7_DATA = 131,
	GP_4_8_DATA = 132,
	GP_4_9_DATA = 133,
	GP_4_10_DATA = 134,
	GP_4_11_DATA = 135,
	GP_4_12_DATA = 136,
	GP_4_13_DATA = 137,
	GP_4_14_DATA = 138,
	GP_4_15_DATA = 139,
	GP_4_16_DATA = 140,
	GP_4_17_DATA = 141,
	GP_4_18_DATA = 142,
	GP_4_19_DATA = 143,
	GP_4_20_DATA = 144,
	GP_4_21_DATA = 145,
	GP_4_22_DATA = 146,
	GP_4_23_DATA = 147,
	GP_4_24_DATA = 148,
	GP_4_25_DATA = 149,
	GP_4_26_DATA = 150,
	GP_4_27_DATA = 151,
	GP_4_28_DATA = 152,
	GP_4_29_DATA = 153,
	GP_4_30_DATA = 154,
	GP_4_31_DATA = 155,
	GP_5_0_DATA = 156,
	GP_5_1_DATA = 157,
	GP_5_2_DATA = 158,
	GP_5_3_DATA = 159,
	GP_5_4_DATA = 160,
	GP_5_5_DATA = 161,
	GP_5_6_DATA = 162,
	GP_5_7_DATA = 163,
	GP_5_8_DATA = 164,
	GP_5_9_DATA = 165,
	GP_5_10_DATA = 166,
	GP_5_11_DATA = 167,
	GP_5_12_DATA = 168,
	GP_5_13_DATA = 169,
	GP_5_14_DATA = 170,
	GP_5_15_DATA = 171,
	GP_5_16_DATA = 172,
	GP_5_17_DATA = 173,
	GP_5_18_DATA = 174,
	GP_5_19_DATA = 175,
	GP_5_20_DATA = 176,
	GP_5_21_DATA = 177,
	GP_5_22_DATA = 178,
	GP_5_23_DATA = 179,
	GP_5_24_DATA = 180,
	GP_5_25_DATA = 181,
	GP_5_26_DATA = 182,
	GP_5_27_DATA = 183,
	GP_6_0_DATA = 184,
	GP_6_1_DATA = 185,
	GP_6_2_DATA = 186,
	GP_6_3_DATA = 187,
	GP_6_4_DATA = 188,
	GP_6_5_DATA = 189,
	GP_6_6_DATA = 190,
	GP_6_7_DATA = 191,
	GP_6_8_DATA = 192,
	GP_6_9_DATA = 193,
	GP_6_10_DATA = 194,
	GP_6_11_DATA = 195,
	GP_6_12_DATA = 196,
	GP_6_13_DATA = 197,
	GP_6_14_DATA = 198,
	GP_6_15_DATA = 199,
	GP_6_16_DATA = 200,
	GP_6_17_DATA = 201,
	GP_6_18_DATA = 202,
	GP_6_19_DATA = 203,
	GP_6_20_DATA = 204,
	GP_6_21_DATA = 205,
	GP_6_22_DATA = 206,
	GP_6_23_DATA = 207,
	GP_6_24_DATA = 208,
	GP_6_25_DATA = 209,
	PINMUX_DATA_END = 210,
	PINMUX_FUNCTION_BEGIN = 211,
	GP_0_0_FN = 212,
	GP_0_1_FN = 213,
	GP_0_2_FN = 214,
	GP_0_3_FN = 215,
	GP_0_4_FN = 216,
	GP_0_5_FN = 217,
	GP_0_6_FN = 218,
	GP_0_7_FN = 219,
	GP_0_8_FN = 220,
	GP_0_9_FN = 221,
	GP_0_10_FN = 222,
	GP_0_11_FN = 223,
	GP_0_12_FN = 224,
	GP_0_13_FN = 225,
	GP_0_14_FN = 226,
	GP_0_15_FN = 227,
	GP_0_16_FN = 228,
	GP_0_17_FN = 229,
	GP_0_18_FN = 230,
	GP_0_19_FN = 231,
	GP_0_20_FN = 232,
	GP_0_21_FN = 233,
	GP_0_22_FN = 234,
	GP_0_23_FN = 235,
	GP_0_24_FN = 236,
	GP_0_25_FN = 237,
	GP_0_26_FN = 238,
	GP_0_27_FN = 239,
	GP_0_28_FN = 240,
	GP_0_29_FN = 241,
	GP_0_30_FN = 242,
	GP_0_31_FN = 243,
	GP_1_0_FN = 244,
	GP_1_1_FN = 245,
	GP_1_2_FN = 246,
	GP_1_3_FN = 247,
	GP_1_4_FN = 248,
	GP_1_5_FN = 249,
	GP_1_6_FN = 250,
	GP_1_7_FN = 251,
	GP_1_8_FN = 252,
	GP_1_9_FN = 253,
	GP_1_10_FN = 254,
	GP_1_11_FN = 255,
	GP_1_12_FN = 256,
	GP_1_13_FN = 257,
	GP_1_14_FN = 258,
	GP_1_15_FN = 259,
	GP_1_16_FN = 260,
	GP_1_17_FN = 261,
	GP_1_18_FN = 262,
	GP_1_19_FN = 263,
	GP_1_20_FN = 264,
	GP_1_21_FN = 265,
	GP_1_22_FN = 266,
	GP_1_23_FN = 267,
	GP_1_24_FN = 268,
	GP_1_25_FN = 269,
	GP_2_0_FN = 270,
	GP_2_1_FN = 271,
	GP_2_2_FN = 272,
	GP_2_3_FN = 273,
	GP_2_4_FN = 274,
	GP_2_5_FN = 275,
	GP_2_6_FN = 276,
	GP_2_7_FN = 277,
	GP_2_8_FN = 278,
	GP_2_9_FN = 279,
	GP_2_10_FN = 280,
	GP_2_11_FN = 281,
	GP_2_12_FN = 282,
	GP_2_13_FN = 283,
	GP_2_14_FN = 284,
	GP_2_15_FN = 285,
	GP_2_16_FN = 286,
	GP_2_17_FN = 287,
	GP_2_18_FN = 288,
	GP_2_19_FN = 289,
	GP_2_20_FN = 290,
	GP_2_21_FN = 291,
	GP_2_22_FN = 292,
	GP_2_23_FN = 293,
	GP_2_24_FN = 294,
	GP_2_25_FN = 295,
	GP_2_26_FN = 296,
	GP_2_27_FN = 297,
	GP_2_28_FN = 298,
	GP_2_29_FN = 299,
	GP_2_30_FN = 300,
	GP_2_31_FN = 301,
	GP_3_0_FN = 302,
	GP_3_1_FN = 303,
	GP_3_2_FN = 304,
	GP_3_3_FN = 305,
	GP_3_4_FN = 306,
	GP_3_5_FN = 307,
	GP_3_6_FN = 308,
	GP_3_7_FN = 309,
	GP_3_8_FN = 310,
	GP_3_9_FN = 311,
	GP_3_10_FN = 312,
	GP_3_11_FN = 313,
	GP_3_12_FN = 314,
	GP_3_13_FN = 315,
	GP_3_14_FN = 316,
	GP_3_15_FN = 317,
	GP_3_16_FN = 318,
	GP_3_17_FN = 319,
	GP_3_18_FN = 320,
	GP_3_19_FN = 321,
	GP_3_20_FN = 322,
	GP_3_21_FN = 323,
	GP_3_22_FN = 324,
	GP_3_23_FN = 325,
	GP_3_24_FN = 326,
	GP_3_25_FN = 327,
	GP_3_26_FN = 328,
	GP_3_27_FN = 329,
	GP_3_28_FN = 330,
	GP_3_29_FN = 331,
	GP_3_30_FN = 332,
	GP_3_31_FN = 333,
	GP_4_0_FN = 334,
	GP_4_1_FN = 335,
	GP_4_2_FN = 336,
	GP_4_3_FN = 337,
	GP_4_4_FN = 338,
	GP_4_5_FN = 339,
	GP_4_6_FN = 340,
	GP_4_7_FN = 341,
	GP_4_8_FN = 342,
	GP_4_9_FN = 343,
	GP_4_10_FN = 344,
	GP_4_11_FN = 345,
	GP_4_12_FN = 346,
	GP_4_13_FN = 347,
	GP_4_14_FN = 348,
	GP_4_15_FN = 349,
	GP_4_16_FN = 350,
	GP_4_17_FN = 351,
	GP_4_18_FN = 352,
	GP_4_19_FN = 353,
	GP_4_20_FN = 354,
	GP_4_21_FN = 355,
	GP_4_22_FN = 356,
	GP_4_23_FN = 357,
	GP_4_24_FN = 358,
	GP_4_25_FN = 359,
	GP_4_26_FN = 360,
	GP_4_27_FN = 361,
	GP_4_28_FN = 362,
	GP_4_29_FN = 363,
	GP_4_30_FN = 364,
	GP_4_31_FN = 365,
	GP_5_0_FN = 366,
	GP_5_1_FN = 367,
	GP_5_2_FN = 368,
	GP_5_3_FN = 369,
	GP_5_4_FN = 370,
	GP_5_5_FN = 371,
	GP_5_6_FN = 372,
	GP_5_7_FN = 373,
	GP_5_8_FN = 374,
	GP_5_9_FN = 375,
	GP_5_10_FN = 376,
	GP_5_11_FN = 377,
	GP_5_12_FN = 378,
	GP_5_13_FN = 379,
	GP_5_14_FN = 380,
	GP_5_15_FN = 381,
	GP_5_16_FN = 382,
	GP_5_17_FN = 383,
	GP_5_18_FN = 384,
	GP_5_19_FN = 385,
	GP_5_20_FN = 386,
	GP_5_21_FN = 387,
	GP_5_22_FN = 388,
	GP_5_23_FN = 389,
	GP_5_24_FN = 390,
	GP_5_25_FN = 391,
	GP_5_26_FN = 392,
	GP_5_27_FN = 393,
	GP_6_0_FN = 394,
	GP_6_1_FN = 395,
	GP_6_2_FN = 396,
	GP_6_3_FN = 397,
	GP_6_4_FN = 398,
	GP_6_5_FN = 399,
	GP_6_6_FN = 400,
	GP_6_7_FN = 401,
	GP_6_8_FN = 402,
	GP_6_9_FN = 403,
	GP_6_10_FN = 404,
	GP_6_11_FN = 405,
	GP_6_12_FN = 406,
	GP_6_13_FN = 407,
	GP_6_14_FN = 408,
	GP_6_15_FN = 409,
	GP_6_16_FN = 410,
	GP_6_17_FN = 411,
	GP_6_18_FN = 412,
	GP_6_19_FN = 413,
	GP_6_20_FN = 414,
	GP_6_21_FN = 415,
	GP_6_22_FN = 416,
	GP_6_23_FN = 417,
	GP_6_24_FN = 418,
	GP_6_25_FN = 419,
	FN_IP0_23_22 = 420,
	FN_IP0_24 = 421,
	FN_IP0_25 = 422,
	FN_IP0_27_26 = 423,
	FN_IP0_29_28 = 424,
	FN_IP0_31_30 = 425,
	FN_IP1_1_0 = 426,
	FN_IP1_3_2 = 427,
	FN_IP1_5_4 = 428,
	FN_IP1_7_6 = 429,
	FN_IP1_10_8 = 430,
	FN_IP1_12_11 = 431,
	FN_IP1_14_13 = 432,
	FN_IP1_17_15 = 433,
	FN_IP1_19_18 = 434,
	FN_IP1_21_20 = 435,
	FN_IP1_23_22 = 436,
	FN_IP1_24 = 437,
	FN_A2 = 438,
	FN_IP1_26 = 439,
	FN_IP1_27 = 440,
	FN_IP1_29_28 = 441,
	FN_IP1_31_30 = 442,
	FN_IP2_1_0 = 443,
	FN_IP2_3_2 = 444,
	FN_IP2_5_4 = 445,
	FN_IP2_7_6 = 446,
	FN_IP2_9_8 = 447,
	FN_IP2_11_10 = 448,
	FN_IP2_13_12 = 449,
	FN_IP2_15_14 = 450,
	FN_IP2_17_16 = 451,
	FN_IP2_20_18 = 452,
	FN_IP2_23_21 = 453,
	FN_IP2_26_24 = 454,
	FN_IP2_29_27 = 455,
	FN_IP2_31_30 = 456,
	FN_IP3_1_0 = 457,
	FN_IP3_3_2 = 458,
	FN_IP3_5_4 = 459,
	FN_IP3_7_6 = 460,
	FN_IP3_9_8 = 461,
	FN_IP3_10 = 462,
	FN_IP3_11 = 463,
	FN_IP3_12 = 464,
	FN_IP3_14_13 = 465,
	FN_IP3_17_15 = 466,
	FN_IP3_20_18 = 467,
	FN_IP3_23_21 = 468,
	FN_IP3_26_24 = 469,
	FN_IP3_29_27 = 470,
	FN_IP3_30 = 471,
	FN_IP3_31 = 472,
	FN_WE0_N = 473,
	FN_WE1_N = 474,
	FN_IP4_1_0 = 475,
	FN_IP7_31 = 476,
	FN_DACK0 = 477,
	FN_IP4_4_2 = 478,
	FN_IP4_7_5 = 479,
	FN_IP4_9_8 = 480,
	FN_IP4_11_10 = 481,
	FN_IP4_13_12 = 482,
	FN_IP4_15_14 = 483,
	FN_IP4_17_16 = 484,
	FN_IP4_19_18 = 485,
	FN_IP4_22_20 = 486,
	FN_IP4_25_23 = 487,
	FN_IP4_27_26 = 488,
	FN_IP4_29_28 = 489,
	FN_IP4_31_30 = 490,
	FN_IP5_1_0 = 491,
	FN_IP5_3_2 = 492,
	FN_IP5_5_4 = 493,
	FN_IP5_8_6 = 494,
	FN_IP5_11_9 = 495,
	FN_IP5_13_12 = 496,
	FN_IP5_15_14 = 497,
	FN_IP5_17_16 = 498,
	FN_IP5_19_18 = 499,
	FN_IP5_21_20 = 500,
	FN_IP5_23_22 = 501,
	FN_IP5_25_24 = 502,
	FN_IP5_27_26 = 503,
	FN_IP5_29_28 = 504,
	FN_IP5_31_30 = 505,
	FN_IP6_1_0 = 506,
	FN_IP6_3_2 = 507,
	FN_IP6_5_4 = 508,
	FN_IP6_7_6 = 509,
	FN_IP6_8 = 510,
	FN_IP6_9 = 511,
	FN_IP6_10 = 512,
	FN_IP6_11 = 513,
	FN_IP6_12 = 514,
	FN_IP6_13 = 515,
	FN_IP6_14 = 516,
	FN_IP6_15 = 517,
	FN_IP6_16 = 518,
	FN_IP6_19_17 = 519,
	FN_IP6_22_20 = 520,
	FN_IP6_25_23 = 521,
	FN_IP6_28_26 = 522,
	FN_IP6_31_29 = 523,
	FN_IP7_2_0 = 524,
	FN_IP7_5_3 = 525,
	FN_IP7_8_6 = 526,
	FN_IP7_11_9 = 527,
	FN_IP7_14_12 = 528,
	FN_IP7_17_15 = 529,
	FN_IP7_20_18 = 530,
	FN_IP7_23_21 = 531,
	FN_IP7_26_24 = 532,
	FN_IP7_29_27 = 533,
	FN_IP8_2_0 = 534,
	FN_IP8_5_3 = 535,
	FN_IP8_8_6 = 536,
	FN_IP8_11_9 = 537,
	FN_IP8_14_12 = 538,
	FN_IP8_16_15 = 539,
	FN_IP8_19_17 = 540,
	FN_IP8_22_20 = 541,
	FN_IP8_25_23 = 542,
	FN_IP8_28_26 = 543,
	FN_IP8_31_29 = 544,
	FN_IP9_2_0 = 545,
	FN_IP9_5_3 = 546,
	FN_IP9_8_6 = 547,
	FN_IP9_11_9 = 548,
	FN_IP9_14_12 = 549,
	FN_IP9_16_15 = 550,
	FN_IP9_18_17 = 551,
	FN_IP9_21_19 = 552,
	FN_IP9_24_22 = 553,
	FN_IP9_27_25 = 554,
	FN_IP9_30_28 = 555,
	FN_IP10_2_0 = 556,
	FN_IP10_5_3 = 557,
	FN_IP10_8_6 = 558,
	FN_IP10_11_9 = 559,
	FN_IP10_14_12 = 560,
	FN_IP10_17_15 = 561,
	FN_IP10_20_18 = 562,
	FN_IP10_23_21 = 563,
	FN_IP10_26_24 = 564,
	FN_IP10_29_27 = 565,
	FN_IP10_31_30 = 566,
	FN_IP11_2_0 = 567,
	FN_IP11_5_3 = 568,
	FN_IP11_7_6 = 569,
	FN_IP11_10_8 = 570,
	FN_IP11_13_11 = 571,
	FN_IP11_15_14 = 572,
	FN_IP11_17_16 = 573,
	FN_IP11_20_18 = 574,
	FN_IP11_23_21 = 575,
	FN_IP11_26_24 = 576,
	FN_IP11_29_27 = 577,
	FN_IP12_2_0 = 578,
	FN_IP12_5_3 = 579,
	FN_IP12_8_6 = 580,
	FN_IP12_10_9 = 581,
	FN_IP12_12_11 = 582,
	FN_IP12_14_13 = 583,
	FN_IP12_17_15 = 584,
	FN_IP12_20_18 = 585,
	FN_IP12_23_21 = 586,
	FN_IP12_26_24 = 587,
	FN_IP12_29_27 = 588,
	FN_IP13_2_0 = 589,
	FN_IP13_5_3 = 590,
	FN_IP13_8_6 = 591,
	FN_IP13_11_9 = 592,
	FN_IP13_14_12 = 593,
	FN_IP13_17_15 = 594,
	FN_IP13_20_18 = 595,
	FN_IP13_23_21 = 596,
	FN_IP13_26_24 = 597,
	FN_USB0_PWEN = 598,
	FN_USB0_OVC = 599,
	FN_USB1_PWEN = 600,
	FN_USB1_OVC = 601,
	FN_SD0_CLK = 602,
	FN_SD0_CMD = 603,
	FN_SD0_DATA0 = 604,
	FN_SD0_DATA1 = 605,
	FN_SD0_DATA2 = 606,
	FN_SD0_DATA3 = 607,
	FN_SD0_CD = 608,
	FN_SD0_WP = 609,
	FN_SD1_CLK = 610,
	FN_SD1_CMD = 611,
	FN_SD1_DATA0 = 612,
	FN_SD1_DATA1 = 613,
	FN_SD1_DATA2 = 614,
	FN_SD1_DATA3 = 615,
	FN_IP0_0 = 616,
	FN_IP0_9_8 = 617,
	FN_IP0_10 = 618,
	FN_IP0_11 = 619,
	FN_IP0_12 = 620,
	FN_IP0_13 = 621,
	FN_IP0_14 = 622,
	FN_IP0_15 = 623,
	FN_IP0_16 = 624,
	FN_IP0_17 = 625,
	FN_IP0_19_18 = 626,
	FN_IP0_21_20 = 627,
	FN_SD1_CD = 628,
	FN_CAN0_RX = 629,
	FN_SD1_WP = 630,
	FN_IRQ7 = 631,
	FN_CAN0_TX = 632,
	FN_MMC_CLK = 633,
	FN_SD2_CLK = 634,
	FN_MMC_CMD = 635,
	FN_SD2_CMD = 636,
	FN_MMC_D0 = 637,
	FN_SD2_DATA0 = 638,
	FN_MMC_D1 = 639,
	FN_SD2_DATA1 = 640,
	FN_MMC_D2 = 641,
	FN_SD2_DATA2 = 642,
	FN_MMC_D3 = 643,
	FN_SD2_DATA3 = 644,
	FN_MMC_D4 = 645,
	FN_SD2_CD = 646,
	FN_MMC_D5 = 647,
	FN_SD2_WP = 648,
	FN_MMC_D6 = 649,
	FN_SCIF0_RXD = 650,
	FN_I2C2_SCL_B = 651,
	FN_CAN1_RX = 652,
	FN_MMC_D7 = 653,
	FN_SCIF0_TXD = 654,
	FN_I2C2_SDA_B = 655,
	FN_CAN1_TX = 656,
	FN_D0 = 657,
	FN_SCIFA3_SCK_B = 658,
	FN_IRQ4 = 659,
	FN_D1 = 660,
	FN_SCIFA3_RXD_B = 661,
	FN_D2 = 662,
	FN_SCIFA3_TXD_B = 663,
	FN_D3 = 664,
	FN_I2C3_SCL_B = 665,
	FN_SCIF5_RXD_B = 666,
	FN_D4 = 667,
	FN_I2C3_SDA_B = 668,
	FN_SCIF5_TXD_B = 669,
	FN_D5 = 670,
	FN_SCIF4_RXD_B = 671,
	FN_I2C0_SCL_D = 672,
	FN_D6 = 673,
	FN_SCIF4_TXD_B = 674,
	FN_I2C0_SDA_D = 675,
	FN_D7 = 676,
	FN_IRQ3 = 677,
	FN_TCLK1 = 678,
	FN_PWM6_B = 679,
	FN_D8 = 680,
	FN_HSCIF2_HRX = 681,
	FN_I2C1_SCL_B = 682,
	FN_D9 = 683,
	FN_HSCIF2_HTX = 684,
	FN_I2C1_SDA_B = 685,
	FN_D10 = 686,
	FN_HSCIF2_HSCK = 687,
	FN_SCIF1_SCK_C = 688,
	FN_IRQ6 = 689,
	FN_PWM5_C = 690,
	FN_D11 = 691,
	FN_HSCIF2_HCTS_N = 692,
	FN_SCIF1_RXD_C = 693,
	FN_I2C1_SCL_D = 694,
	FN_D12 = 695,
	FN_HSCIF2_HRTS_N = 696,
	FN_SCIF1_TXD_C = 697,
	FN_I2C1_SDA_D = 698,
	FN_D13 = 699,
	FN_SCIFA1_SCK = 700,
	FN_PWM2_C = 701,
	FN_TCLK2_B = 702,
	FN_D14 = 703,
	FN_SCIFA1_RXD = 704,
	FN_I2C5_SCL_B = 705,
	FN_D15 = 706,
	FN_SCIFA1_TXD = 707,
	FN_I2C5_SDA_B = 708,
	FN_A0 = 709,
	FN_SCIFB1_SCK = 710,
	FN_PWM3_B = 711,
	FN_A1 = 712,
	FN_SCIFB1_TXD = 713,
	FN_A3 = 714,
	FN_SCIFB0_SCK = 715,
	FN_A4 = 716,
	FN_SCIFB0_TXD = 717,
	FN_A5 = 718,
	FN_SCIFB0_RXD = 719,
	FN_PWM4_B = 720,
	FN_TPUTO3_C = 721,
	FN_A6 = 722,
	FN_SCIFB0_CTS_N = 723,
	FN_SCIFA4_RXD_B = 724,
	FN_TPUTO2_C = 725,
	FN_A7 = 726,
	FN_SCIFB0_RTS_N = 727,
	FN_SCIFA4_TXD_B = 728,
	FN_A8 = 729,
	FN_MSIOF1_RXD = 730,
	FN_SCIFA0_RXD_B = 731,
	FN_A9 = 732,
	FN_MSIOF1_TXD = 733,
	FN_SCIFA0_TXD_B = 734,
	FN_A10 = 735,
	FN_MSIOF1_SCK = 736,
	FN_IIC0_SCL_B = 737,
	FN_A11 = 738,
	FN_MSIOF1_SYNC = 739,
	FN_IIC0_SDA_B = 740,
	FN_A12 = 741,
	FN_MSIOF1_SS1 = 742,
	FN_SCIFA5_RXD_B = 743,
	FN_A13 = 744,
	FN_MSIOF1_SS2 = 745,
	FN_SCIFA5_TXD_B = 746,
	FN_A14 = 747,
	FN_MSIOF2_RXD = 748,
	FN_HSCIF0_HRX_B = 749,
	FN_DREQ1_N = 750,
	FN_A15 = 751,
	FN_MSIOF2_TXD = 752,
	FN_HSCIF0_HTX_B = 753,
	FN_DACK1 = 754,
	FN_A16 = 755,
	FN_MSIOF2_SCK = 756,
	FN_HSCIF0_HSCK_B = 757,
	FN_SPEEDIN = 758,
	FN_CAN_CLK_C = 759,
	FN_TPUTO2_B = 760,
	FN_A17 = 761,
	FN_MSIOF2_SYNC = 762,
	FN_SCIF4_RXD_E = 763,
	FN_CAN1_RX_B = 764,
	FN_A18 = 765,
	FN_MSIOF2_SS1 = 766,
	FN_SCIF4_TXD_E = 767,
	FN_CAN1_TX_B = 768,
	FN_A19 = 769,
	FN_MSIOF2_SS2 = 770,
	FN_PWM4 = 771,
	FN_TPUTO2 = 772,
	FN_A20 = 773,
	FN_SPCLK = 774,
	FN_A21 = 775,
	FN_MOSI_IO0 = 776,
	FN_A22 = 777,
	FN_MISO_IO1 = 778,
	FN_ATADIR1_N = 779,
	FN_A23 = 780,
	FN_IO2 = 781,
	FN_ATAWR1_N = 782,
	FN_A24 = 783,
	FN_IO3 = 784,
	FN_EX_WAIT2 = 785,
	FN_A25 = 786,
	FN_SSL = 787,
	FN_ATARD1_N = 788,
	FN_CS0_N = 789,
	FN_VI1_DATA8 = 790,
	FN_CS1_N_A26 = 791,
	FN_VI1_DATA9 = 792,
	FN_EX_CS0_N = 793,
	FN_VI1_DATA10 = 794,
	FN_EX_CS1_N = 795,
	FN_TPUTO3_B = 796,
	FN_SCIFB2_RXD = 797,
	FN_VI1_DATA11 = 798,
	FN_EX_CS2_N = 799,
	FN_PWM0 = 800,
	FN_SCIF4_RXD_C = 801,
	FN_TS_SDATA_B = 802,
	FN_TPUTO3 = 803,
	FN_SCIFB2_TXD = 804,
	FN_EX_CS3_N = 805,
	FN_SCIFA2_SCK = 806,
	FN_SCIF4_TXD_C = 807,
	FN_TS_SCK_B = 808,
	FN_BPFCLK = 809,
	FN_SCIFB2_SCK = 810,
	FN_EX_CS4_N = 811,
	FN_SCIFA2_RXD = 812,
	FN_I2C2_SCL_E = 813,
	FN_TS_SDEN_B = 814,
	FN_FMCLK = 815,
	FN_SCIFB2_CTS_N = 816,
	FN_EX_CS5_N = 817,
	FN_SCIFA2_TXD = 818,
	FN_I2C2_SDA_E = 819,
	FN_TS_SPSYNC_B = 820,
	FN_FMIN = 821,
	FN_SCIFB2_RTS_N = 822,
	FN_BS_N = 823,
	FN_DRACK0 = 824,
	FN_PWM1_C = 825,
	FN_TPUTO0_C = 826,
	FN_ATACS01_N = 827,
	FN_RD_N = 828,
	FN_ATACS11_N = 829,
	FN_RD_WR_N = 830,
	FN_ATAG1_N = 831,
	FN_EX_WAIT0 = 832,
	FN_CAN_CLK_B = 833,
	FN_SCIF_CLK = 834,
	FN_DU0_DR0 = 835,
	FN_LCDOUT16 = 836,
	FN_SCIF5_RXD_C = 837,
	FN_I2C2_SCL_D = 838,
	FN_DU0_DR1 = 839,
	FN_LCDOUT17 = 840,
	FN_SCIF5_TXD_C = 841,
	FN_I2C2_SDA_D = 842,
	FN_DU0_DR2 = 843,
	FN_LCDOUT18 = 844,
	FN_DU0_DR3 = 845,
	FN_LCDOUT19 = 846,
	FN_DU0_DR4 = 847,
	FN_LCDOUT20 = 848,
	FN_DU0_DR5 = 849,
	FN_LCDOUT21 = 850,
	FN_DU0_DR6 = 851,
	FN_LCDOUT22 = 852,
	FN_DU0_DR7 = 853,
	FN_LCDOUT23 = 854,
	FN_DU0_DG0 = 855,
	FN_LCDOUT8 = 856,
	FN_SCIFA0_RXD_C = 857,
	FN_I2C3_SCL_D = 858,
	FN_DU0_DG1 = 859,
	FN_LCDOUT9 = 860,
	FN_SCIFA0_TXD_C = 861,
	FN_I2C3_SDA_D = 862,
	FN_DU0_DG2 = 863,
	FN_LCDOUT10 = 864,
	FN_DU0_DG3 = 865,
	FN_LCDOUT11 = 866,
	FN_DU0_DG4 = 867,
	FN_LCDOUT12 = 868,
	FN_DU0_DG5 = 869,
	FN_LCDOUT13 = 870,
	FN_DU0_DG6 = 871,
	FN_LCDOUT14 = 872,
	FN_DU0_DG7 = 873,
	FN_LCDOUT15 = 874,
	FN_DU0_DB0 = 875,
	FN_LCDOUT0 = 876,
	FN_SCIFA4_RXD_C = 877,
	FN_I2C4_SCL_D = 878,
	FN_CAN0_RX_C = 879,
	FN_DU0_DB1 = 880,
	FN_LCDOUT1 = 881,
	FN_SCIFA4_TXD_C = 882,
	FN_I2C4_SDA_D = 883,
	FN_CAN0_TX_C = 884,
	FN_DU0_DB2 = 885,
	FN_LCDOUT2 = 886,
	FN_DU0_DB3 = 887,
	FN_LCDOUT3 = 888,
	FN_DU0_DB4 = 889,
	FN_LCDOUT4 = 890,
	FN_DU0_DB5 = 891,
	FN_LCDOUT5 = 892,
	FN_DU0_DB6 = 893,
	FN_LCDOUT6 = 894,
	FN_DU0_DB7 = 895,
	FN_LCDOUT7 = 896,
	FN_DU0_DOTCLKIN = 897,
	FN_QSTVA_QVS = 898,
	FN_DU0_DOTCLKOUT0 = 899,
	FN_QCLK = 900,
	FN_DU0_DOTCLKOUT1 = 901,
	FN_QSTVB_QVE = 902,
	FN_DU0_EXHSYNC_DU0_HSYNC = 903,
	FN_QSTH_QHS = 904,
	FN_DU0_EXVSYNC_DU0_VSYNC = 905,
	FN_QSTB_QHE = 906,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE = 907,
	FN_QCPV_QDE = 908,
	FN_DU0_DISP = 909,
	FN_QPOLA = 910,
	FN_DU0_CDE = 911,
	FN_QPOLB = 912,
	FN_VI0_CLK = 913,
	FN_AVB_RX_CLK = 914,
	FN_VI0_DATA0_VI0_B0 = 915,
	FN_AVB_RX_DV = 916,
	FN_VI0_DATA1_VI0_B1 = 917,
	FN_AVB_RXD0 = 918,
	FN_VI0_DATA2_VI0_B2 = 919,
	FN_AVB_RXD1 = 920,
	FN_VI0_DATA3_VI0_B3 = 921,
	FN_AVB_RXD2 = 922,
	FN_VI0_DATA4_VI0_B4 = 923,
	FN_AVB_RXD3 = 924,
	FN_VI0_DATA5_VI0_B5 = 925,
	FN_AVB_RXD4 = 926,
	FN_VI0_DATA6_VI0_B6 = 927,
	FN_AVB_RXD5 = 928,
	FN_VI0_DATA7_VI0_B7 = 929,
	FN_AVB_RXD6 = 930,
	FN_VI0_CLKENB = 931,
	FN_I2C3_SCL = 932,
	FN_SCIFA5_RXD_C = 933,
	FN_IETX_C = 934,
	FN_AVB_RXD7 = 935,
	FN_VI0_FIELD = 936,
	FN_I2C3_SDA = 937,
	FN_SCIFA5_TXD_C = 938,
	FN_IECLK_C = 939,
	FN_AVB_RX_ER = 940,
	FN_VI0_HSYNC_N = 941,
	FN_SCIF0_RXD_B = 942,
	FN_I2C0_SCL_C = 943,
	FN_IERX_C = 944,
	FN_AVB_COL = 945,
	FN_VI0_VSYNC_N = 946,
	FN_SCIF0_TXD_B = 947,
	FN_I2C0_SDA_C = 948,
	FN_AUDIO_CLKOUT_B = 949,
	FN_AVB_TX_EN = 950,
	FN_ETH_MDIO = 951,
	FN_VI0_G0 = 952,
	FN_MSIOF2_RXD_B = 953,
	FN_I2C5_SCL_D = 954,
	FN_AVB_TX_CLK = 955,
	FN_ADIDATA = 956,
	FN_ETH_CRS_DV = 957,
	FN_VI0_G1 = 958,
	FN_MSIOF2_TXD_B = 959,
	FN_I2C5_SDA_D = 960,
	FN_AVB_TXD0 = 961,
	FN_ADICS_SAMP = 962,
	FN_ETH_RX_ER = 963,
	FN_VI0_G2 = 964,
	FN_MSIOF2_SCK_B = 965,
	FN_CAN0_RX_B = 966,
	FN_AVB_TXD1 = 967,
	FN_ADICLK = 968,
	FN_ETH_RXD0 = 969,
	FN_VI0_G3 = 970,
	FN_MSIOF2_SYNC_B = 971,
	FN_CAN0_TX_B = 972,
	FN_AVB_TXD2 = 973,
	FN_ADICHS0 = 974,
	FN_ETH_RXD1 = 975,
	FN_VI0_G4 = 976,
	FN_MSIOF2_SS1_B = 977,
	FN_SCIF4_RXD_D = 978,
	FN_AVB_TXD3 = 979,
	FN_ADICHS1 = 980,
	FN_ETH_LINK = 981,
	FN_VI0_G5 = 982,
	FN_MSIOF2_SS2_B = 983,
	FN_SCIF4_TXD_D = 984,
	FN_AVB_TXD4 = 985,
	FN_ADICHS2 = 986,
	FN_ETH_REFCLK = 987,
	FN_VI0_G6 = 988,
	FN_SCIF2_SCK_C = 989,
	FN_AVB_TXD5 = 990,
	FN_SSI_SCK5_B = 991,
	FN_ETH_TXD1 = 992,
	FN_VI0_G7 = 993,
	FN_SCIF2_RXD_C = 994,
	FN_IIC0_SCL_D = 995,
	FN_AVB_TXD6 = 996,
	FN_SSI_WS5_B = 997,
	FN_ETH_TX_EN = 998,
	FN_VI0_R0 = 999,
	FN_SCIF2_TXD_C = 1000,
	FN_IIC0_SDA_D = 1001,
	FN_AVB_TXD7 = 1002,
	FN_SSI_SDATA5_B = 1003,
	FN_ETH_MAGIC = 1004,
	FN_VI0_R1 = 1005,
	FN_SCIF3_SCK_B = 1006,
	FN_AVB_TX_ER = 1007,
	FN_SSI_SCK6_B = 1008,
	FN_ETH_TXD0 = 1009,
	FN_VI0_R2 = 1010,
	FN_SCIF3_RXD_B = 1011,
	FN_I2C4_SCL_E = 1012,
	FN_AVB_GTX_CLK = 1013,
	FN_SSI_WS6_B = 1014,
	FN_DREQ0_N = 1015,
	FN_SCIFB1_RXD = 1016,
	FN_ETH_MDC = 1017,
	FN_VI0_R3 = 1018,
	FN_SCIF3_TXD_B = 1019,
	FN_I2C4_SDA_E = 1020,
	FN_AVB_MDC = 1021,
	FN_SSI_SDATA6_B = 1022,
	FN_HSCIF0_HRX = 1023,
	FN_VI0_R4 = 1024,
	FN_I2C1_SCL_C = 1025,
	FN_AUDIO_CLKA_B = 1026,
	FN_AVB_MDIO = 1027,
	FN_SSI_SCK78_B = 1028,
	FN_HSCIF0_HTX = 1029,
	FN_VI0_R5 = 1030,
	FN_I2C1_SDA_C = 1031,
	FN_AUDIO_CLKB_B = 1032,
	FN_AVB_LINK = 1033,
	FN_SSI_WS78_B = 1034,
	FN_HSCIF0_HCTS_N = 1035,
	FN_VI0_R6 = 1036,
	FN_SCIF0_RXD_D = 1037,
	FN_I2C0_SCL_E = 1038,
	FN_AVB_MAGIC = 1039,
	FN_SSI_SDATA7_B = 1040,
	FN_HSCIF0_HRTS_N = 1041,
	FN_VI0_R7 = 1042,
	FN_SCIF0_TXD_D = 1043,
	FN_I2C0_SDA_E = 1044,
	FN_AVB_PHY_INT = 1045,
	FN_SSI_SDATA8_B = 1046,
	FN_HSCIF0_HSCK = 1047,
	FN_SCIF_CLK_B = 1048,
	FN_AVB_CRS = 1049,
	FN_AUDIO_CLKC_B = 1050,
	FN_I2C0_SCL = 1051,
	FN_SCIF0_RXD_C = 1052,
	FN_PWM5 = 1053,
	FN_TCLK1_B = 1054,
	FN_AVB_GTXREFCLK = 1055,
	FN_CAN1_RX_D = 1056,
	FN_TPUTO0_B = 1057,
	FN_I2C0_SDA = 1058,
	FN_SCIF0_TXD_C = 1059,
	FN_TPUTO0 = 1060,
	FN_CAN_CLK = 1061,
	FN_DVC_MUTE = 1062,
	FN_CAN1_TX_D = 1063,
	FN_I2C1_SCL = 1064,
	FN_SCIF4_RXD = 1065,
	FN_PWM5_B = 1066,
	FN_DU1_DR0 = 1067,
	FN_TS_SDATA_D = 1068,
	FN_TPUTO1_B = 1069,
	FN_I2C1_SDA = 1070,
	FN_SCIF4_TXD = 1071,
	FN_IRQ5 = 1072,
	FN_DU1_DR1 = 1073,
	FN_TS_SCK_D = 1074,
	FN_BPFCLK_C = 1075,
	FN_MSIOF0_RXD = 1076,
	FN_SCIF5_RXD = 1077,
	FN_I2C2_SCL_C = 1078,
	FN_DU1_DR2 = 1079,
	FN_TS_SDEN_D = 1080,
	FN_FMCLK_C = 1081,
	FN_MSIOF0_TXD = 1082,
	FN_SCIF5_TXD = 1083,
	FN_I2C2_SDA_C = 1084,
	FN_DU1_DR3 = 1085,
	FN_TS_SPSYNC_D = 1086,
	FN_FMIN_C = 1087,
	FN_MSIOF0_SCK = 1088,
	FN_IRQ0 = 1089,
	FN_TS_SDATA = 1090,
	FN_DU1_DR4 = 1091,
	FN_TPUTO1_C = 1092,
	FN_MSIOF0_SYNC = 1093,
	FN_PWM1 = 1094,
	FN_TS_SCK = 1095,
	FN_DU1_DR5 = 1096,
	FN_BPFCLK_B = 1097,
	FN_MSIOF0_SS1 = 1098,
	FN_SCIFA0_RXD = 1099,
	FN_TS_SDEN = 1100,
	FN_DU1_DR6 = 1101,
	FN_FMCLK_B = 1102,
	FN_MSIOF0_SS2 = 1103,
	FN_SCIFA0_TXD = 1104,
	FN_TS_SPSYNC = 1105,
	FN_DU1_DR7 = 1106,
	FN_FMIN_B = 1107,
	FN_HSCIF1_HRX = 1108,
	FN_I2C4_SCL = 1109,
	FN_PWM6 = 1110,
	FN_DU1_DG0 = 1111,
	FN_HSCIF1_HTX = 1112,
	FN_I2C4_SDA = 1113,
	FN_TPUTO1 = 1114,
	FN_DU1_DG1 = 1115,
	FN_HSCIF1_HSCK = 1116,
	FN_PWM2 = 1117,
	FN_IETX = 1118,
	FN_DU1_DG2 = 1119,
	FN_REMOCON_B = 1120,
	FN_SPEEDIN_B = 1121,
	FN_HSCIF1_HCTS_N = 1122,
	FN_SCIFA4_RXD = 1123,
	FN_IECLK = 1124,
	FN_DU1_DG3 = 1125,
	FN_SSI_SCK1_B = 1126,
	FN_HSCIF1_HRTS_N = 1127,
	FN_SCIFA4_TXD = 1128,
	FN_IERX = 1129,
	FN_DU1_DG4 = 1130,
	FN_SSI_WS1_B = 1131,
	FN_SCIF1_SCK = 1132,
	FN_PWM3 = 1133,
	FN_TCLK2 = 1134,
	FN_DU1_DG5 = 1135,
	FN_SSI_SDATA1_B = 1136,
	FN_SCIF1_RXD = 1137,
	FN_I2C5_SCL = 1138,
	FN_DU1_DG6 = 1139,
	FN_SSI_SCK2_B = 1140,
	FN_SCIF1_TXD = 1141,
	FN_I2C5_SDA = 1142,
	FN_DU1_DG7 = 1143,
	FN_SSI_WS2_B = 1144,
	FN_SCIF2_RXD = 1145,
	FN_IIC0_SCL = 1146,
	FN_DU1_DB0 = 1147,
	FN_SSI_SDATA2_B = 1148,
	FN_SCIF2_TXD = 1149,
	FN_IIC0_SDA = 1150,
	FN_DU1_DB1 = 1151,
	FN_SSI_SCK9_B = 1152,
	FN_SCIF2_SCK = 1153,
	FN_IRQ1 = 1154,
	FN_DU1_DB2 = 1155,
	FN_SSI_WS9_B = 1156,
	FN_SCIF3_SCK = 1157,
	FN_IRQ2 = 1158,
	FN_BPFCLK_D = 1159,
	FN_DU1_DB3 = 1160,
	FN_SSI_SDATA9_B = 1161,
	FN_SCIF3_RXD = 1162,
	FN_I2C1_SCL_E = 1163,
	FN_FMCLK_D = 1164,
	FN_DU1_DB4 = 1165,
	FN_AUDIO_CLKA_C = 1166,
	FN_SSI_SCK4_B = 1167,
	FN_SCIF3_TXD = 1168,
	FN_I2C1_SDA_E = 1169,
	FN_FMIN_D = 1170,
	FN_DU1_DB5 = 1171,
	FN_AUDIO_CLKB_C = 1172,
	FN_SSI_WS4_B = 1173,
	FN_I2C2_SCL = 1174,
	FN_SCIFA5_RXD = 1175,
	FN_DU1_DB6 = 1176,
	FN_AUDIO_CLKC_C = 1177,
	FN_SSI_SDATA4_B = 1178,
	FN_I2C2_SDA = 1179,
	FN_SCIFA5_TXD = 1180,
	FN_DU1_DB7 = 1181,
	FN_AUDIO_CLKOUT_C = 1182,
	FN_SSI_SCK5 = 1183,
	FN_SCIFA3_SCK = 1184,
	FN_DU1_DOTCLKIN = 1185,
	FN_SSI_WS5 = 1186,
	FN_SCIFA3_RXD = 1187,
	FN_I2C3_SCL_C = 1188,
	FN_DU1_DOTCLKOUT0 = 1189,
	FN_SSI_SDATA5 = 1190,
	FN_SCIFA3_TXD = 1191,
	FN_I2C3_SDA_C = 1192,
	FN_DU1_DOTCLKOUT1 = 1193,
	FN_SSI_SCK6 = 1194,
	FN_SCIFA1_SCK_B = 1195,
	FN_DU1_EXHSYNC_DU1_HSYNC = 1196,
	FN_SSI_WS6 = 1197,
	FN_SCIFA1_RXD_B = 1198,
	FN_I2C4_SCL_C = 1199,
	FN_DU1_EXVSYNC_DU1_VSYNC = 1200,
	FN_SSI_SDATA6 = 1201,
	FN_SCIFA1_TXD_B = 1202,
	FN_I2C4_SDA_C = 1203,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE = 1204,
	FN_SSI_SCK78 = 1205,
	FN_SCIFA2_SCK_B = 1206,
	FN_I2C5_SDA_C = 1207,
	FN_DU1_DISP = 1208,
	FN_SSI_WS78 = 1209,
	FN_SCIFA2_RXD_B = 1210,
	FN_I2C5_SCL_C = 1211,
	FN_DU1_CDE = 1212,
	FN_SSI_SDATA7 = 1213,
	FN_SCIFA2_TXD_B = 1214,
	FN_IRQ8 = 1215,
	FN_AUDIO_CLKA_D = 1216,
	FN_CAN_CLK_D = 1217,
	FN_SSI_SCK0129 = 1218,
	FN_MSIOF1_RXD_B = 1219,
	FN_SCIF5_RXD_D = 1220,
	FN_ADIDATA_B = 1221,
	FN_SSI_WS0129 = 1222,
	FN_MSIOF1_TXD_B = 1223,
	FN_SCIF5_TXD_D = 1224,
	FN_ADICS_SAMP_B = 1225,
	FN_SSI_SDATA0 = 1226,
	FN_MSIOF1_SCK_B = 1227,
	FN_PWM0_B = 1228,
	FN_ADICLK_B = 1229,
	FN_SSI_SCK34 = 1230,
	FN_MSIOF1_SYNC_B = 1231,
	FN_SCIFA1_SCK_C = 1232,
	FN_ADICHS0_B = 1233,
	FN_DREQ1_N_B = 1234,
	FN_SSI_WS34 = 1235,
	FN_MSIOF1_SS1_B = 1236,
	FN_SCIFA1_RXD_C = 1237,
	FN_ADICHS1_B = 1238,
	FN_CAN1_RX_C = 1239,
	FN_DACK1_B = 1240,
	FN_SSI_SDATA3 = 1241,
	FN_MSIOF1_SS2_B = 1242,
	FN_SCIFA1_TXD_C = 1243,
	FN_ADICHS2_B = 1244,
	FN_CAN1_TX_C = 1245,
	FN_DREQ2_N = 1246,
	FN_SSI_SCK4 = 1247,
	FN_MLB_CLK = 1248,
	FN_IETX_B = 1249,
	FN_SSI_WS4 = 1250,
	FN_MLB_SIG = 1251,
	FN_IECLK_B = 1252,
	FN_SSI_SDATA4 = 1253,
	FN_MLB_DAT = 1254,
	FN_IERX_B = 1255,
	FN_SSI_SDATA8 = 1256,
	FN_SCIF1_SCK_B = 1257,
	FN_PWM1_B = 1258,
	FN_IRQ9 = 1259,
	FN_REMOCON = 1260,
	FN_DACK2 = 1261,
	FN_ETH_MDIO_B = 1262,
	FN_SSI_SCK1 = 1263,
	FN_SCIF1_RXD_B = 1264,
	FN_IIC0_SCL_C = 1265,
	FN_VI1_CLK = 1266,
	FN_CAN0_RX_D = 1267,
	FN_ETH_CRS_DV_B = 1268,
	FN_SSI_WS1 = 1269,
	FN_SCIF1_TXD_B = 1270,
	FN_IIC0_SDA_C = 1271,
	FN_VI1_DATA0 = 1272,
	FN_CAN0_TX_D = 1273,
	FN_ETH_RX_ER_B = 1274,
	FN_SSI_SDATA1 = 1275,
	FN_HSCIF1_HRX_B = 1276,
	FN_VI1_DATA1 = 1277,
	FN_ATAWR0_N = 1278,
	FN_ETH_RXD0_B = 1279,
	FN_SSI_SCK2 = 1280,
	FN_HSCIF1_HTX_B = 1281,
	FN_VI1_DATA2 = 1282,
	FN_ATAG0_N = 1283,
	FN_ETH_RXD1_B = 1284,
	FN_SSI_WS2 = 1285,
	FN_HSCIF1_HCTS_N_B = 1286,
	FN_SCIFA0_RXD_D = 1287,
	FN_VI1_DATA3 = 1288,
	FN_ATACS00_N = 1289,
	FN_ETH_LINK_B = 1290,
	FN_SSI_SDATA2 = 1291,
	FN_HSCIF1_HRTS_N_B = 1292,
	FN_SCIFA0_TXD_D = 1293,
	FN_VI1_DATA4 = 1294,
	FN_ATACS10_N = 1295,
	FN_ETH_REFCLK_B = 1296,
	FN_SSI_SCK9 = 1297,
	FN_SCIF2_SCK_B = 1298,
	FN_PWM2_B = 1299,
	FN_VI1_DATA5 = 1300,
	FN_EX_WAIT1 = 1301,
	FN_ETH_TXD1_B = 1302,
	FN_SSI_WS9 = 1303,
	FN_SCIF2_RXD_B = 1304,
	FN_I2C3_SCL_E = 1305,
	FN_VI1_DATA6 = 1306,
	FN_ATARD0_N = 1307,
	FN_ETH_TX_EN_B = 1308,
	FN_SSI_SDATA9 = 1309,
	FN_SCIF2_TXD_B = 1310,
	FN_I2C3_SDA_E = 1311,
	FN_VI1_DATA7 = 1312,
	FN_ATADIR0_N = 1313,
	FN_ETH_MAGIC_B = 1314,
	FN_AUDIO_CLKA = 1315,
	FN_I2C0_SCL_B = 1316,
	FN_SCIFA4_RXD_D = 1317,
	FN_VI1_CLKENB = 1318,
	FN_TS_SDATA_C = 1319,
	FN_ETH_TXD0_B = 1320,
	FN_AUDIO_CLKB = 1321,
	FN_I2C0_SDA_B = 1322,
	FN_SCIFA4_TXD_D = 1323,
	FN_VI1_FIELD = 1324,
	FN_TS_SCK_C = 1325,
	FN_BPFCLK_E = 1326,
	FN_ETH_MDC_B = 1327,
	FN_AUDIO_CLKC = 1328,
	FN_I2C4_SCL_B = 1329,
	FN_SCIFA5_RXD_D = 1330,
	FN_VI1_HSYNC_N = 1331,
	FN_TS_SDEN_C = 1332,
	FN_FMCLK_E = 1333,
	FN_AUDIO_CLKOUT = 1334,
	FN_I2C4_SDA_B = 1335,
	FN_SCIFA5_TXD_D = 1336,
	FN_VI1_VSYNC_N = 1337,
	FN_TS_SPSYNC_C = 1338,
	FN_FMIN_E = 1339,
	FN_SEL_ADG_0 = 1340,
	FN_SEL_ADG_1 = 1341,
	FN_SEL_ADG_2 = 1342,
	FN_SEL_ADG_3 = 1343,
	FN_SEL_CAN_0 = 1344,
	FN_SEL_CAN_1 = 1345,
	FN_SEL_CAN_2 = 1346,
	FN_SEL_CAN_3 = 1347,
	FN_SEL_DARC_0 = 1348,
	FN_SEL_DARC_1 = 1349,
	FN_SEL_DARC_2 = 1350,
	FN_SEL_DARC_3 = 1351,
	FN_SEL_DARC_4 = 1352,
	FN_SEL_ETH_0 = 1353,
	FN_SEL_ETH_1 = 1354,
	FN_SEL_I2C00_0 = 1355,
	FN_SEL_I2C00_1 = 1356,
	FN_SEL_I2C00_2 = 1357,
	FN_SEL_I2C00_3 = 1358,
	FN_SEL_I2C00_4 = 1359,
	FN_SEL_I2C01_0 = 1360,
	FN_SEL_I2C01_1 = 1361,
	FN_SEL_I2C01_2 = 1362,
	FN_SEL_I2C01_3 = 1363,
	FN_SEL_I2C01_4 = 1364,
	FN_SEL_I2C02_0 = 1365,
	FN_SEL_I2C02_1 = 1366,
	FN_SEL_I2C02_2 = 1367,
	FN_SEL_I2C02_3 = 1368,
	FN_SEL_I2C02_4 = 1369,
	FN_SEL_I2C03_0 = 1370,
	FN_SEL_I2C03_1 = 1371,
	FN_SEL_I2C03_2 = 1372,
	FN_SEL_I2C03_3 = 1373,
	FN_SEL_I2C03_4 = 1374,
	FN_SEL_I2C04_0 = 1375,
	FN_SEL_I2C04_1 = 1376,
	FN_SEL_I2C04_2 = 1377,
	FN_SEL_I2C04_3 = 1378,
	FN_SEL_I2C04_4 = 1379,
	FN_SEL_I2C05_0 = 1380,
	FN_SEL_I2C05_1 = 1381,
	FN_SEL_I2C05_2 = 1382,
	FN_SEL_I2C05_3 = 1383,
	FN_SEL_IEB_0 = 1384,
	FN_SEL_IEB_1 = 1385,
	FN_SEL_IEB_2 = 1386,
	FN_SEL_IIC0_0 = 1387,
	FN_SEL_IIC0_1 = 1388,
	FN_SEL_IIC0_2 = 1389,
	FN_SEL_IIC0_3 = 1390,
	FN_SEL_LBS_0 = 1391,
	FN_SEL_LBS_1 = 1392,
	FN_SEL_MSI1_0 = 1393,
	FN_SEL_MSI1_1 = 1394,
	FN_SEL_MSI2_0 = 1395,
	FN_SEL_MSI2_1 = 1396,
	FN_SEL_RAD_0 = 1397,
	FN_SEL_RAD_1 = 1398,
	FN_SEL_RCN_0 = 1399,
	FN_SEL_RCN_1 = 1400,
	FN_SEL_RSP_0 = 1401,
	FN_SEL_RSP_1 = 1402,
	FN_SEL_SCIFA0_0 = 1403,
	FN_SEL_SCIFA0_1 = 1404,
	FN_SEL_SCIFA0_2 = 1405,
	FN_SEL_SCIFA0_3 = 1406,
	FN_SEL_SCIFA1_0 = 1407,
	FN_SEL_SCIFA1_1 = 1408,
	FN_SEL_SCIFA1_2 = 1409,
	FN_SEL_SCIFA2_0 = 1410,
	FN_SEL_SCIFA2_1 = 1411,
	FN_SEL_SCIFA3_0 = 1412,
	FN_SEL_SCIFA3_1 = 1413,
	FN_SEL_SCIFA4_0 = 1414,
	FN_SEL_SCIFA4_1 = 1415,
	FN_SEL_SCIFA4_2 = 1416,
	FN_SEL_SCIFA4_3 = 1417,
	FN_SEL_SCIFA5_0 = 1418,
	FN_SEL_SCIFA5_1 = 1419,
	FN_SEL_SCIFA5_2 = 1420,
	FN_SEL_SCIFA5_3 = 1421,
	FN_SEL_TMU_0 = 1422,
	FN_SEL_TMU_1 = 1423,
	FN_SEL_TSIF0_0 = 1424,
	FN_SEL_TSIF0_1 = 1425,
	FN_SEL_TSIF0_2 = 1426,
	FN_SEL_TSIF0_3 = 1427,
	FN_SEL_CAN0_0 = 1428,
	FN_SEL_CAN0_1 = 1429,
	FN_SEL_CAN0_2 = 1430,
	FN_SEL_CAN0_3 = 1431,
	FN_SEL_CAN1_0 = 1432,
	FN_SEL_CAN1_1 = 1433,
	FN_SEL_CAN1_2 = 1434,
	FN_SEL_CAN1_3 = 1435,
	FN_SEL_HSCIF0_0 = 1436,
	FN_SEL_HSCIF0_1 = 1437,
	FN_SEL_HSCIF1_0 = 1438,
	FN_SEL_HSCIF1_1 = 1439,
	FN_SEL_SCIF0_0 = 1440,
	FN_SEL_SCIF0_1 = 1441,
	FN_SEL_SCIF0_2 = 1442,
	FN_SEL_SCIF0_3 = 1443,
	FN_SEL_SCIF1_0 = 1444,
	FN_SEL_SCIF1_1 = 1445,
	FN_SEL_SCIF1_2 = 1446,
	FN_SEL_SCIF2_0 = 1447,
	FN_SEL_SCIF2_1 = 1448,
	FN_SEL_SCIF2_2 = 1449,
	FN_SEL_SCIF3_0 = 1450,
	FN_SEL_SCIF3_1 = 1451,
	FN_SEL_SCIF4_0 = 1452,
	FN_SEL_SCIF4_1 = 1453,
	FN_SEL_SCIF4_2 = 1454,
	FN_SEL_SCIF4_3 = 1455,
	FN_SEL_SCIF4_4 = 1456,
	FN_SEL_SCIF5_0 = 1457,
	FN_SEL_SCIF5_1 = 1458,
	FN_SEL_SCIF5_2 = 1459,
	FN_SEL_SCIF5_3 = 1460,
	FN_SEL_SSI1_0 = 1461,
	FN_SEL_SSI1_1 = 1462,
	FN_SEL_SSI2_0 = 1463,
	FN_SEL_SSI2_1 = 1464,
	FN_SEL_SSI4_0 = 1465,
	FN_SEL_SSI4_1 = 1466,
	FN_SEL_SSI5_0 = 1467,
	FN_SEL_SSI5_1 = 1468,
	FN_SEL_SSI6_0 = 1469,
	FN_SEL_SSI6_1 = 1470,
	FN_SEL_SSI7_0 = 1471,
	FN_SEL_SSI7_1 = 1472,
	FN_SEL_SSI8_0 = 1473,
	FN_SEL_SSI8_1 = 1474,
	FN_SEL_SSI9_0 = 1475,
	FN_SEL_SSI9_1 = 1476,
	PINMUX_FUNCTION_END = 1477,
	PINMUX_MARK_BEGIN = 1478,
	A2_MARK = 1479,
	WE0_N_MARK = 1480,
	WE1_N_MARK = 1481,
	DACK0_MARK = 1482,
	USB0_PWEN_MARK = 1483,
	USB0_OVC_MARK = 1484,
	USB1_PWEN_MARK = 1485,
	USB1_OVC_MARK = 1486,
	SD0_CLK_MARK = 1487,
	SD0_CMD_MARK = 1488,
	SD0_DATA0_MARK = 1489,
	SD0_DATA1_MARK = 1490,
	SD0_DATA2_MARK = 1491,
	SD0_DATA3_MARK = 1492,
	SD0_CD_MARK = 1493,
	SD0_WP_MARK = 1494,
	SD1_CLK_MARK = 1495,
	SD1_CMD_MARK = 1496,
	SD1_DATA0_MARK = 1497,
	SD1_DATA1_MARK = 1498,
	SD1_DATA2_MARK = 1499,
	SD1_DATA3_MARK = 1500,
	SD1_CD_MARK = 1501,
	CAN0_RX_MARK = 1502,
	SD1_WP_MARK = 1503,
	IRQ7_MARK = 1504,
	CAN0_TX_MARK = 1505,
	MMC_CLK_MARK = 1506,
	SD2_CLK_MARK = 1507,
	MMC_CMD_MARK = 1508,
	SD2_CMD_MARK = 1509,
	MMC_D0_MARK = 1510,
	SD2_DATA0_MARK = 1511,
	MMC_D1_MARK = 1512,
	SD2_DATA1_MARK = 1513,
	MMC_D2_MARK = 1514,
	SD2_DATA2_MARK = 1515,
	MMC_D3_MARK = 1516,
	SD2_DATA3_MARK = 1517,
	MMC_D4_MARK = 1518,
	SD2_CD_MARK = 1519,
	MMC_D5_MARK = 1520,
	SD2_WP_MARK = 1521,
	MMC_D6_MARK = 1522,
	SCIF0_RXD_MARK = 1523,
	I2C2_SCL_B_MARK = 1524,
	CAN1_RX_MARK = 1525,
	MMC_D7_MARK = 1526,
	SCIF0_TXD_MARK = 1527,
	I2C2_SDA_B_MARK = 1528,
	CAN1_TX_MARK = 1529,
	D0_MARK = 1530,
	SCIFA3_SCK_B_MARK = 1531,
	IRQ4_MARK = 1532,
	D1_MARK = 1533,
	SCIFA3_RXD_B_MARK = 1534,
	D2_MARK = 1535,
	SCIFA3_TXD_B_MARK = 1536,
	D3_MARK = 1537,
	I2C3_SCL_B_MARK = 1538,
	SCIF5_RXD_B_MARK = 1539,
	D4_MARK = 1540,
	I2C3_SDA_B_MARK = 1541,
	SCIF5_TXD_B_MARK = 1542,
	D5_MARK = 1543,
	SCIF4_RXD_B_MARK = 1544,
	I2C0_SCL_D_MARK = 1545,
	D6_MARK = 1546,
	SCIF4_TXD_B_MARK = 1547,
	I2C0_SDA_D_MARK = 1548,
	D7_MARK = 1549,
	IRQ3_MARK = 1550,
	TCLK1_MARK = 1551,
	PWM6_B_MARK = 1552,
	D8_MARK = 1553,
	HSCIF2_HRX_MARK = 1554,
	I2C1_SCL_B_MARK = 1555,
	D9_MARK = 1556,
	HSCIF2_HTX_MARK = 1557,
	I2C1_SDA_B_MARK = 1558,
	D10_MARK = 1559,
	HSCIF2_HSCK_MARK = 1560,
	SCIF1_SCK_C_MARK = 1561,
	IRQ6_MARK = 1562,
	PWM5_C_MARK = 1563,
	D11_MARK = 1564,
	HSCIF2_HCTS_N_MARK = 1565,
	SCIF1_RXD_C_MARK = 1566,
	I2C1_SCL_D_MARK = 1567,
	D12_MARK = 1568,
	HSCIF2_HRTS_N_MARK = 1569,
	SCIF1_TXD_C_MARK = 1570,
	I2C1_SDA_D_MARK = 1571,
	D13_MARK = 1572,
	SCIFA1_SCK_MARK = 1573,
	PWM2_C_MARK = 1574,
	TCLK2_B_MARK = 1575,
	D14_MARK = 1576,
	SCIFA1_RXD_MARK = 1577,
	I2C5_SCL_B_MARK = 1578,
	D15_MARK = 1579,
	SCIFA1_TXD_MARK = 1580,
	I2C5_SDA_B_MARK = 1581,
	A0_MARK = 1582,
	SCIFB1_SCK_MARK = 1583,
	PWM3_B_MARK = 1584,
	A1_MARK = 1585,
	SCIFB1_TXD_MARK = 1586,
	A3_MARK = 1587,
	SCIFB0_SCK_MARK = 1588,
	A4_MARK = 1589,
	SCIFB0_TXD_MARK = 1590,
	A5_MARK = 1591,
	SCIFB0_RXD_MARK = 1592,
	PWM4_B_MARK = 1593,
	TPUTO3_C_MARK = 1594,
	A6_MARK = 1595,
	SCIFB0_CTS_N_MARK = 1596,
	SCIFA4_RXD_B_MARK = 1597,
	TPUTO2_C_MARK = 1598,
	A7_MARK = 1599,
	SCIFB0_RTS_N_MARK = 1600,
	SCIFA4_TXD_B_MARK = 1601,
	A8_MARK = 1602,
	MSIOF1_RXD_MARK = 1603,
	SCIFA0_RXD_B_MARK = 1604,
	A9_MARK = 1605,
	MSIOF1_TXD_MARK = 1606,
	SCIFA0_TXD_B_MARK = 1607,
	A10_MARK = 1608,
	MSIOF1_SCK_MARK = 1609,
	IIC0_SCL_B_MARK = 1610,
	A11_MARK = 1611,
	MSIOF1_SYNC_MARK = 1612,
	IIC0_SDA_B_MARK = 1613,
	A12_MARK = 1614,
	MSIOF1_SS1_MARK = 1615,
	SCIFA5_RXD_B_MARK = 1616,
	A13_MARK = 1617,
	MSIOF1_SS2_MARK = 1618,
	SCIFA5_TXD_B_MARK = 1619,
	A14_MARK = 1620,
	MSIOF2_RXD_MARK = 1621,
	HSCIF0_HRX_B_MARK = 1622,
	DREQ1_N_MARK = 1623,
	A15_MARK = 1624,
	MSIOF2_TXD_MARK = 1625,
	HSCIF0_HTX_B_MARK = 1626,
	DACK1_MARK = 1627,
	A16_MARK = 1628,
	MSIOF2_SCK_MARK = 1629,
	HSCIF0_HSCK_B_MARK = 1630,
	SPEEDIN_MARK = 1631,
	CAN_CLK_C_MARK = 1632,
	TPUTO2_B_MARK = 1633,
	A17_MARK = 1634,
	MSIOF2_SYNC_MARK = 1635,
	SCIF4_RXD_E_MARK = 1636,
	CAN1_RX_B_MARK = 1637,
	A18_MARK = 1638,
	MSIOF2_SS1_MARK = 1639,
	SCIF4_TXD_E_MARK = 1640,
	CAN1_TX_B_MARK = 1641,
	A19_MARK = 1642,
	MSIOF2_SS2_MARK = 1643,
	PWM4_MARK = 1644,
	TPUTO2_MARK = 1645,
	A20_MARK = 1646,
	SPCLK_MARK = 1647,
	A21_MARK = 1648,
	MOSI_IO0_MARK = 1649,
	A22_MARK = 1650,
	MISO_IO1_MARK = 1651,
	ATADIR1_N_MARK = 1652,
	A23_MARK = 1653,
	IO2_MARK = 1654,
	ATAWR1_N_MARK = 1655,
	A24_MARK = 1656,
	IO3_MARK = 1657,
	EX_WAIT2_MARK = 1658,
	A25_MARK = 1659,
	SSL_MARK = 1660,
	ATARD1_N_MARK = 1661,
	CS0_N_MARK = 1662,
	VI1_DATA8_MARK = 1663,
	CS1_N_A26_MARK = 1664,
	VI1_DATA9_MARK = 1665,
	EX_CS0_N_MARK = 1666,
	VI1_DATA10_MARK = 1667,
	EX_CS1_N_MARK = 1668,
	TPUTO3_B_MARK = 1669,
	SCIFB2_RXD_MARK = 1670,
	VI1_DATA11_MARK = 1671,
	EX_CS2_N_MARK = 1672,
	PWM0_MARK = 1673,
	SCIF4_RXD_C_MARK = 1674,
	TS_SDATA_B_MARK = 1675,
	TPUTO3_MARK = 1676,
	SCIFB2_TXD_MARK = 1677,
	EX_CS3_N_MARK = 1678,
	SCIFA2_SCK_MARK = 1679,
	SCIF4_TXD_C_MARK = 1680,
	TS_SCK_B_MARK = 1681,
	BPFCLK_MARK = 1682,
	SCIFB2_SCK_MARK = 1683,
	EX_CS4_N_MARK = 1684,
	SCIFA2_RXD_MARK = 1685,
	I2C2_SCL_E_MARK = 1686,
	TS_SDEN_B_MARK = 1687,
	FMCLK_MARK = 1688,
	SCIFB2_CTS_N_MARK = 1689,
	EX_CS5_N_MARK = 1690,
	SCIFA2_TXD_MARK = 1691,
	I2C2_SDA_E_MARK = 1692,
	TS_SPSYNC_B_MARK = 1693,
	FMIN_MARK = 1694,
	SCIFB2_RTS_N_MARK = 1695,
	BS_N_MARK = 1696,
	DRACK0_MARK = 1697,
	PWM1_C_MARK = 1698,
	TPUTO0_C_MARK = 1699,
	ATACS01_N_MARK = 1700,
	RD_N_MARK = 1701,
	ATACS11_N_MARK = 1702,
	RD_WR_N_MARK = 1703,
	ATAG1_N_MARK = 1704,
	EX_WAIT0_MARK = 1705,
	CAN_CLK_B_MARK = 1706,
	SCIF_CLK_MARK = 1707,
	DU0_DR0_MARK = 1708,
	LCDOUT16_MARK = 1709,
	SCIF5_RXD_C_MARK = 1710,
	I2C2_SCL_D_MARK = 1711,
	DU0_DR1_MARK = 1712,
	LCDOUT17_MARK = 1713,
	SCIF5_TXD_C_MARK = 1714,
	I2C2_SDA_D_MARK = 1715,
	DU0_DR2_MARK = 1716,
	LCDOUT18_MARK = 1717,
	DU0_DR3_MARK = 1718,
	LCDOUT19_MARK = 1719,
	DU0_DR4_MARK = 1720,
	LCDOUT20_MARK = 1721,
	DU0_DR5_MARK = 1722,
	LCDOUT21_MARK = 1723,
	DU0_DR6_MARK = 1724,
	LCDOUT22_MARK = 1725,
	DU0_DR7_MARK = 1726,
	LCDOUT23_MARK = 1727,
	DU0_DG0_MARK = 1728,
	LCDOUT8_MARK = 1729,
	SCIFA0_RXD_C_MARK = 1730,
	I2C3_SCL_D_MARK = 1731,
	DU0_DG1_MARK = 1732,
	LCDOUT9_MARK = 1733,
	SCIFA0_TXD_C_MARK = 1734,
	I2C3_SDA_D_MARK = 1735,
	DU0_DG2_MARK = 1736,
	LCDOUT10_MARK = 1737,
	DU0_DG3_MARK = 1738,
	LCDOUT11_MARK = 1739,
	DU0_DG4_MARK = 1740,
	LCDOUT12_MARK = 1741,
	DU0_DG5_MARK = 1742,
	LCDOUT13_MARK = 1743,
	DU0_DG6_MARK = 1744,
	LCDOUT14_MARK = 1745,
	DU0_DG7_MARK = 1746,
	LCDOUT15_MARK = 1747,
	DU0_DB0_MARK = 1748,
	LCDOUT0_MARK = 1749,
	SCIFA4_RXD_C_MARK = 1750,
	I2C4_SCL_D_MARK = 1751,
	CAN0_RX_C_MARK = 1752,
	DU0_DB1_MARK = 1753,
	LCDOUT1_MARK = 1754,
	SCIFA4_TXD_C_MARK = 1755,
	I2C4_SDA_D_MARK = 1756,
	CAN0_TX_C_MARK = 1757,
	DU0_DB2_MARK = 1758,
	LCDOUT2_MARK = 1759,
	DU0_DB3_MARK = 1760,
	LCDOUT3_MARK = 1761,
	DU0_DB4_MARK = 1762,
	LCDOUT4_MARK = 1763,
	DU0_DB5_MARK = 1764,
	LCDOUT5_MARK = 1765,
	DU0_DB6_MARK = 1766,
	LCDOUT6_MARK = 1767,
	DU0_DB7_MARK = 1768,
	LCDOUT7_MARK = 1769,
	DU0_DOTCLKIN_MARK = 1770,
	QSTVA_QVS_MARK = 1771,
	DU0_DOTCLKOUT0_MARK = 1772,
	QCLK_MARK = 1773,
	DU0_DOTCLKOUT1_MARK = 1774,
	QSTVB_QVE_MARK = 1775,
	DU0_EXHSYNC_DU0_HSYNC_MARK = 1776,
	QSTH_QHS_MARK = 1777,
	DU0_EXVSYNC_DU0_VSYNC_MARK = 1778,
	QSTB_QHE_MARK = 1779,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK = 1780,
	QCPV_QDE_MARK = 1781,
	DU0_DISP_MARK = 1782,
	QPOLA_MARK = 1783,
	DU0_CDE_MARK = 1784,
	QPOLB_MARK = 1785,
	VI0_CLK_MARK = 1786,
	AVB_RX_CLK_MARK = 1787,
	VI0_DATA0_VI0_B0_MARK = 1788,
	AVB_RX_DV_MARK = 1789,
	VI0_DATA1_VI0_B1_MARK = 1790,
	AVB_RXD0_MARK = 1791,
	VI0_DATA2_VI0_B2_MARK = 1792,
	AVB_RXD1_MARK = 1793,
	VI0_DATA3_VI0_B3_MARK = 1794,
	AVB_RXD2_MARK = 1795,
	VI0_DATA4_VI0_B4_MARK = 1796,
	AVB_RXD3_MARK = 1797,
	VI0_DATA5_VI0_B5_MARK = 1798,
	AVB_RXD4_MARK = 1799,
	VI0_DATA6_VI0_B6_MARK = 1800,
	AVB_RXD5_MARK = 1801,
	VI0_DATA7_VI0_B7_MARK = 1802,
	AVB_RXD6_MARK = 1803,
	VI0_CLKENB_MARK = 1804,
	I2C3_SCL_MARK = 1805,
	SCIFA5_RXD_C_MARK = 1806,
	IETX_C_MARK = 1807,
	AVB_RXD7_MARK = 1808,
	VI0_FIELD_MARK = 1809,
	I2C3_SDA_MARK = 1810,
	SCIFA5_TXD_C_MARK = 1811,
	IECLK_C_MARK = 1812,
	AVB_RX_ER_MARK = 1813,
	VI0_HSYNC_N_MARK = 1814,
	SCIF0_RXD_B_MARK = 1815,
	I2C0_SCL_C_MARK = 1816,
	IERX_C_MARK = 1817,
	AVB_COL_MARK = 1818,
	VI0_VSYNC_N_MARK = 1819,
	SCIF0_TXD_B_MARK = 1820,
	I2C0_SDA_C_MARK = 1821,
	AUDIO_CLKOUT_B_MARK = 1822,
	AVB_TX_EN_MARK = 1823,
	ETH_MDIO_MARK = 1824,
	VI0_G0_MARK = 1825,
	MSIOF2_RXD_B_MARK = 1826,
	I2C5_SCL_D_MARK = 1827,
	AVB_TX_CLK_MARK = 1828,
	ADIDATA_MARK = 1829,
	ETH_CRS_DV_MARK = 1830,
	VI0_G1_MARK = 1831,
	MSIOF2_TXD_B_MARK = 1832,
	I2C5_SDA_D_MARK = 1833,
	AVB_TXD0_MARK = 1834,
	ADICS_SAMP_MARK = 1835,
	ETH_RX_ER_MARK = 1836,
	VI0_G2_MARK = 1837,
	MSIOF2_SCK_B_MARK = 1838,
	CAN0_RX_B_MARK = 1839,
	AVB_TXD1_MARK = 1840,
	ADICLK_MARK = 1841,
	ETH_RXD0_MARK = 1842,
	VI0_G3_MARK = 1843,
	MSIOF2_SYNC_B_MARK = 1844,
	CAN0_TX_B_MARK = 1845,
	AVB_TXD2_MARK = 1846,
	ADICHS0_MARK = 1847,
	ETH_RXD1_MARK = 1848,
	VI0_G4_MARK = 1849,
	MSIOF2_SS1_B_MARK = 1850,
	SCIF4_RXD_D_MARK = 1851,
	AVB_TXD3_MARK = 1852,
	ADICHS1_MARK = 1853,
	ETH_LINK_MARK = 1854,
	VI0_G5_MARK = 1855,
	MSIOF2_SS2_B_MARK = 1856,
	SCIF4_TXD_D_MARK = 1857,
	AVB_TXD4_MARK = 1858,
	ADICHS2_MARK = 1859,
	ETH_REFCLK_MARK = 1860,
	VI0_G6_MARK = 1861,
	SCIF2_SCK_C_MARK = 1862,
	AVB_TXD5_MARK = 1863,
	SSI_SCK5_B_MARK = 1864,
	ETH_TXD1_MARK = 1865,
	VI0_G7_MARK = 1866,
	SCIF2_RXD_C_MARK = 1867,
	IIC0_SCL_D_MARK = 1868,
	AVB_TXD6_MARK = 1869,
	SSI_WS5_B_MARK = 1870,
	ETH_TX_EN_MARK = 1871,
	VI0_R0_MARK = 1872,
	SCIF2_TXD_C_MARK = 1873,
	IIC0_SDA_D_MARK = 1874,
	AVB_TXD7_MARK = 1875,
	SSI_SDATA5_B_MARK = 1876,
	ETH_MAGIC_MARK = 1877,
	VI0_R1_MARK = 1878,
	SCIF3_SCK_B_MARK = 1879,
	AVB_TX_ER_MARK = 1880,
	SSI_SCK6_B_MARK = 1881,
	ETH_TXD0_MARK = 1882,
	VI0_R2_MARK = 1883,
	SCIF3_RXD_B_MARK = 1884,
	I2C4_SCL_E_MARK = 1885,
	AVB_GTX_CLK_MARK = 1886,
	SSI_WS6_B_MARK = 1887,
	DREQ0_N_MARK = 1888,
	SCIFB1_RXD_MARK = 1889,
	ETH_MDC_MARK = 1890,
	VI0_R3_MARK = 1891,
	SCIF3_TXD_B_MARK = 1892,
	I2C4_SDA_E_MARK = 1893,
	AVB_MDC_MARK = 1894,
	SSI_SDATA6_B_MARK = 1895,
	HSCIF0_HRX_MARK = 1896,
	VI0_R4_MARK = 1897,
	I2C1_SCL_C_MARK = 1898,
	AUDIO_CLKA_B_MARK = 1899,
	AVB_MDIO_MARK = 1900,
	SSI_SCK78_B_MARK = 1901,
	HSCIF0_HTX_MARK = 1902,
	VI0_R5_MARK = 1903,
	I2C1_SDA_C_MARK = 1904,
	AUDIO_CLKB_B_MARK = 1905,
	AVB_LINK_MARK = 1906,
	SSI_WS78_B_MARK = 1907,
	HSCIF0_HCTS_N_MARK = 1908,
	VI0_R6_MARK = 1909,
	SCIF0_RXD_D_MARK = 1910,
	I2C0_SCL_E_MARK = 1911,
	AVB_MAGIC_MARK = 1912,
	SSI_SDATA7_B_MARK = 1913,
	HSCIF0_HRTS_N_MARK = 1914,
	VI0_R7_MARK = 1915,
	SCIF0_TXD_D_MARK = 1916,
	I2C0_SDA_E_MARK = 1917,
	AVB_PHY_INT_MARK = 1918,
	SSI_SDATA8_B_MARK = 1919,
	HSCIF0_HSCK_MARK = 1920,
	SCIF_CLK_B_MARK = 1921,
	AVB_CRS_MARK = 1922,
	AUDIO_CLKC_B_MARK = 1923,
	I2C0_SCL_MARK = 1924,
	SCIF0_RXD_C_MARK = 1925,
	PWM5_MARK = 1926,
	TCLK1_B_MARK = 1927,
	AVB_GTXREFCLK_MARK = 1928,
	CAN1_RX_D_MARK = 1929,
	TPUTO0_B_MARK = 1930,
	I2C0_SDA_MARK = 1931,
	SCIF0_TXD_C_MARK = 1932,
	TPUTO0_MARK = 1933,
	CAN_CLK_MARK = 1934,
	DVC_MUTE_MARK = 1935,
	CAN1_TX_D_MARK = 1936,
	I2C1_SCL_MARK = 1937,
	SCIF4_RXD_MARK = 1938,
	PWM5_B_MARK = 1939,
	DU1_DR0_MARK = 1940,
	TS_SDATA_D_MARK = 1941,
	TPUTO1_B_MARK = 1942,
	I2C1_SDA_MARK = 1943,
	SCIF4_TXD_MARK = 1944,
	IRQ5_MARK = 1945,
	DU1_DR1_MARK = 1946,
	TS_SCK_D_MARK = 1947,
	BPFCLK_C_MARK = 1948,
	MSIOF0_RXD_MARK = 1949,
	SCIF5_RXD_MARK = 1950,
	I2C2_SCL_C_MARK = 1951,
	DU1_DR2_MARK = 1952,
	TS_SDEN_D_MARK = 1953,
	FMCLK_C_MARK = 1954,
	MSIOF0_TXD_MARK = 1955,
	SCIF5_TXD_MARK = 1956,
	I2C2_SDA_C_MARK = 1957,
	DU1_DR3_MARK = 1958,
	TS_SPSYNC_D_MARK = 1959,
	FMIN_C_MARK = 1960,
	MSIOF0_SCK_MARK = 1961,
	IRQ0_MARK = 1962,
	TS_SDATA_MARK = 1963,
	DU1_DR4_MARK = 1964,
	TPUTO1_C_MARK = 1965,
	MSIOF0_SYNC_MARK = 1966,
	PWM1_MARK = 1967,
	TS_SCK_MARK = 1968,
	DU1_DR5_MARK = 1969,
	BPFCLK_B_MARK = 1970,
	MSIOF0_SS1_MARK = 1971,
	SCIFA0_RXD_MARK = 1972,
	TS_SDEN_MARK = 1973,
	DU1_DR6_MARK = 1974,
	FMCLK_B_MARK = 1975,
	MSIOF0_SS2_MARK = 1976,
	SCIFA0_TXD_MARK = 1977,
	TS_SPSYNC_MARK = 1978,
	DU1_DR7_MARK = 1979,
	FMIN_B_MARK = 1980,
	HSCIF1_HRX_MARK = 1981,
	I2C4_SCL_MARK = 1982,
	PWM6_MARK = 1983,
	DU1_DG0_MARK = 1984,
	HSCIF1_HTX_MARK = 1985,
	I2C4_SDA_MARK = 1986,
	TPUTO1_MARK = 1987,
	DU1_DG1_MARK = 1988,
	HSCIF1_HSCK_MARK = 1989,
	PWM2_MARK = 1990,
	IETX_MARK = 1991,
	DU1_DG2_MARK = 1992,
	REMOCON_B_MARK = 1993,
	SPEEDIN_B_MARK = 1994,
	HSCIF1_HCTS_N_MARK = 1995,
	SCIFA4_RXD_MARK = 1996,
	IECLK_MARK = 1997,
	DU1_DG3_MARK = 1998,
	SSI_SCK1_B_MARK = 1999,
	HSCIF1_HRTS_N_MARK = 2000,
	SCIFA4_TXD_MARK = 2001,
	IERX_MARK = 2002,
	DU1_DG4_MARK = 2003,
	SSI_WS1_B_MARK = 2004,
	SCIF1_SCK_MARK = 2005,
	PWM3_MARK = 2006,
	TCLK2_MARK = 2007,
	DU1_DG5_MARK = 2008,
	SSI_SDATA1_B_MARK = 2009,
	CAN_TXCLK_MARK = 2010,
	SCIF1_RXD_MARK = 2011,
	I2C5_SCL_MARK = 2012,
	DU1_DG6_MARK = 2013,
	SSI_SCK2_B_MARK = 2014,
	SCIF1_TXD_MARK = 2015,
	I2C5_SDA_MARK = 2016,
	DU1_DG7_MARK = 2017,
	SSI_WS2_B_MARK = 2018,
	SCIF2_RXD_MARK = 2019,
	IIC0_SCL_MARK = 2020,
	DU1_DB0_MARK = 2021,
	SSI_SDATA2_B_MARK = 2022,
	SCIF2_TXD_MARK = 2023,
	IIC0_SDA_MARK = 2024,
	DU1_DB1_MARK = 2025,
	SSI_SCK9_B_MARK = 2026,
	SCIF2_SCK_MARK = 2027,
	IRQ1_MARK = 2028,
	DU1_DB2_MARK = 2029,
	SSI_WS9_B_MARK = 2030,
	SCIF3_SCK_MARK = 2031,
	IRQ2_MARK = 2032,
	BPFCLK_D_MARK = 2033,
	DU1_DB3_MARK = 2034,
	SSI_SDATA9_B_MARK = 2035,
	SCIF3_RXD_MARK = 2036,
	I2C1_SCL_E_MARK = 2037,
	FMCLK_D_MARK = 2038,
	DU1_DB4_MARK = 2039,
	AUDIO_CLKA_C_MARK = 2040,
	SSI_SCK4_B_MARK = 2041,
	SCIF3_TXD_MARK = 2042,
	I2C1_SDA_E_MARK = 2043,
	FMIN_D_MARK = 2044,
	DU1_DB5_MARK = 2045,
	AUDIO_CLKB_C_MARK = 2046,
	SSI_WS4_B_MARK = 2047,
	I2C2_SCL_MARK = 2048,
	SCIFA5_RXD_MARK = 2049,
	DU1_DB6_MARK = 2050,
	AUDIO_CLKC_C_MARK = 2051,
	SSI_SDATA4_B_MARK = 2052,
	I2C2_SDA_MARK = 2053,
	SCIFA5_TXD_MARK = 2054,
	DU1_DB7_MARK = 2055,
	AUDIO_CLKOUT_C_MARK = 2056,
	SSI_SCK5_MARK = 2057,
	SCIFA3_SCK_MARK = 2058,
	DU1_DOTCLKIN_MARK = 2059,
	SSI_WS5_MARK = 2060,
	SCIFA3_RXD_MARK = 2061,
	I2C3_SCL_C_MARK = 2062,
	DU1_DOTCLKOUT0_MARK = 2063,
	SSI_SDATA5_MARK = 2064,
	SCIFA3_TXD_MARK = 2065,
	I2C3_SDA_C_MARK = 2066,
	DU1_DOTCLKOUT1_MARK = 2067,
	SSI_SCK6_MARK = 2068,
	SCIFA1_SCK_B_MARK = 2069,
	DU1_EXHSYNC_DU1_HSYNC_MARK = 2070,
	SSI_WS6_MARK = 2071,
	SCIFA1_RXD_B_MARK = 2072,
	I2C4_SCL_C_MARK = 2073,
	DU1_EXVSYNC_DU1_VSYNC_MARK = 2074,
	SSI_SDATA6_MARK = 2075,
	SCIFA1_TXD_B_MARK = 2076,
	I2C4_SDA_C_MARK = 2077,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK = 2078,
	SSI_SCK78_MARK = 2079,
	SCIFA2_SCK_B_MARK = 2080,
	I2C5_SDA_C_MARK = 2081,
	DU1_DISP_MARK = 2082,
	SSI_WS78_MARK = 2083,
	SCIFA2_RXD_B_MARK = 2084,
	I2C5_SCL_C_MARK = 2085,
	DU1_CDE_MARK = 2086,
	SSI_SDATA7_MARK = 2087,
	SCIFA2_TXD_B_MARK = 2088,
	IRQ8_MARK = 2089,
	AUDIO_CLKA_D_MARK = 2090,
	CAN_CLK_D_MARK = 2091,
	SSI_SCK0129_MARK = 2092,
	MSIOF1_RXD_B_MARK = 2093,
	SCIF5_RXD_D_MARK = 2094,
	ADIDATA_B_MARK = 2095,
	SSI_WS0129_MARK = 2096,
	MSIOF1_TXD_B_MARK = 2097,
	SCIF5_TXD_D_MARK = 2098,
	ADICS_SAMP_B_MARK = 2099,
	SSI_SDATA0_MARK = 2100,
	MSIOF1_SCK_B_MARK = 2101,
	PWM0_B_MARK = 2102,
	ADICLK_B_MARK = 2103,
	SSI_SCK34_MARK = 2104,
	MSIOF1_SYNC_B_MARK = 2105,
	SCIFA1_SCK_C_MARK = 2106,
	ADICHS0_B_MARK = 2107,
	DREQ1_N_B_MARK = 2108,
	SSI_WS34_MARK = 2109,
	MSIOF1_SS1_B_MARK = 2110,
	SCIFA1_RXD_C_MARK = 2111,
	ADICHS1_B_MARK = 2112,
	CAN1_RX_C_MARK = 2113,
	DACK1_B_MARK = 2114,
	SSI_SDATA3_MARK = 2115,
	MSIOF1_SS2_B_MARK = 2116,
	SCIFA1_TXD_C_MARK = 2117,
	ADICHS2_B_MARK = 2118,
	CAN1_TX_C_MARK = 2119,
	DREQ2_N_MARK = 2120,
	SSI_SCK4_MARK = 2121,
	MLB_CLK_MARK = 2122,
	IETX_B_MARK = 2123,
	SSI_WS4_MARK = 2124,
	MLB_SIG_MARK = 2125,
	IECLK_B_MARK = 2126,
	SSI_SDATA4_MARK = 2127,
	MLB_DAT_MARK = 2128,
	IERX_B_MARK = 2129,
	SSI_SDATA8_MARK = 2130,
	SCIF1_SCK_B_MARK = 2131,
	PWM1_B_MARK = 2132,
	IRQ9_MARK = 2133,
	REMOCON_MARK = 2134,
	DACK2_MARK = 2135,
	ETH_MDIO_B_MARK = 2136,
	SSI_SCK1_MARK = 2137,
	SCIF1_RXD_B_MARK = 2138,
	IIC0_SCL_C_MARK = 2139,
	VI1_CLK_MARK = 2140,
	CAN0_RX_D_MARK = 2141,
	ETH_CRS_DV_B_MARK = 2142,
	SSI_WS1_MARK = 2143,
	SCIF1_TXD_B_MARK = 2144,
	IIC0_SDA_C_MARK = 2145,
	VI1_DATA0_MARK = 2146,
	CAN0_TX_D_MARK = 2147,
	ETH_RX_ER_B_MARK = 2148,
	SSI_SDATA1_MARK = 2149,
	HSCIF1_HRX_B_MARK = 2150,
	VI1_DATA1_MARK = 2151,
	ATAWR0_N_MARK = 2152,
	ETH_RXD0_B_MARK = 2153,
	SSI_SCK2_MARK = 2154,
	HSCIF1_HTX_B_MARK = 2155,
	VI1_DATA2_MARK = 2156,
	ATAG0_N_MARK = 2157,
	ETH_RXD1_B_MARK = 2158,
	SSI_WS2_MARK = 2159,
	HSCIF1_HCTS_N_B_MARK = 2160,
	SCIFA0_RXD_D_MARK = 2161,
	VI1_DATA3_MARK = 2162,
	ATACS00_N_MARK = 2163,
	ETH_LINK_B_MARK = 2164,
	SSI_SDATA2_MARK = 2165,
	HSCIF1_HRTS_N_B_MARK = 2166,
	SCIFA0_TXD_D_MARK = 2167,
	VI1_DATA4_MARK = 2168,
	ATACS10_N_MARK = 2169,
	ETH_REFCLK_B_MARK = 2170,
	SSI_SCK9_MARK = 2171,
	SCIF2_SCK_B_MARK = 2172,
	PWM2_B_MARK = 2173,
	VI1_DATA5_MARK = 2174,
	EX_WAIT1_MARK = 2175,
	ETH_TXD1_B_MARK = 2176,
	SSI_WS9_MARK = 2177,
	SCIF2_RXD_B_MARK = 2178,
	I2C3_SCL_E_MARK = 2179,
	VI1_DATA6_MARK = 2180,
	ATARD0_N_MARK = 2181,
	ETH_TX_EN_B_MARK = 2182,
	SSI_SDATA9_MARK = 2183,
	SCIF2_TXD_B_MARK = 2184,
	I2C3_SDA_E_MARK = 2185,
	VI1_DATA7_MARK = 2186,
	ATADIR0_N_MARK = 2187,
	ETH_MAGIC_B_MARK = 2188,
	AUDIO_CLKA_MARK = 2189,
	I2C0_SCL_B_MARK = 2190,
	SCIFA4_RXD_D_MARK = 2191,
	VI1_CLKENB_MARK = 2192,
	TS_SDATA_C_MARK = 2193,
	ETH_TXD0_B_MARK = 2194,
	AUDIO_CLKB_MARK = 2195,
	I2C0_SDA_B_MARK = 2196,
	SCIFA4_TXD_D_MARK = 2197,
	VI1_FIELD_MARK = 2198,
	TS_SCK_C_MARK = 2199,
	BPFCLK_E_MARK = 2200,
	ETH_MDC_B_MARK = 2201,
	AUDIO_CLKC_MARK = 2202,
	I2C4_SCL_B_MARK = 2203,
	SCIFA5_RXD_D_MARK = 2204,
	VI1_HSYNC_N_MARK = 2205,
	TS_SDEN_C_MARK = 2206,
	FMCLK_E_MARK = 2207,
	AUDIO_CLKOUT_MARK = 2208,
	I2C4_SDA_B_MARK = 2209,
	SCIFA5_TXD_D_MARK = 2210,
	VI1_VSYNC_N_MARK = 2211,
	TS_SPSYNC_C_MARK = 2212,
	FMIN_E_MARK = 2213,
	PINMUX_MARK_END = 2214,
};

enum {
	PINMUX_RESERVED___2 = 0,
	PINMUX_DATA_BEGIN___2 = 1,
	PORT0_DATA = 2,
	PORT1_DATA = 3,
	PORT2_DATA = 4,
	PORT3_DATA = 5,
	PORT4_DATA = 6,
	PORT5_DATA = 7,
	PORT6_DATA = 8,
	PORT7_DATA = 9,
	PORT8_DATA = 10,
	PORT9_DATA = 11,
	PORT10_DATA = 12,
	PORT11_DATA = 13,
	PORT12_DATA = 14,
	PORT13_DATA = 15,
	PORT14_DATA = 16,
	PORT15_DATA = 17,
	PORT16_DATA = 18,
	PORT17_DATA = 19,
	PORT18_DATA = 20,
	PORT19_DATA = 21,
	PORT20_DATA = 22,
	PORT21_DATA = 23,
	PORT22_DATA = 24,
	PORT23_DATA = 25,
	PORT24_DATA = 26,
	PORT25_DATA = 27,
	PORT26_DATA = 28,
	PORT27_DATA = 29,
	PORT28_DATA = 30,
	PORT29_DATA = 31,
	PORT30_DATA = 32,
	PORT31_DATA = 33,
	PORT32_DATA = 34,
	PORT33_DATA = 35,
	PORT34_DATA = 36,
	PORT35_DATA = 37,
	PORT36_DATA = 38,
	PORT37_DATA = 39,
	PORT38_DATA = 40,
	PORT39_DATA = 41,
	PORT40_DATA = 42,
	PORT41_DATA = 43,
	PORT42_DATA = 44,
	PORT43_DATA = 45,
	PORT44_DATA = 46,
	PORT45_DATA = 47,
	PORT46_DATA = 48,
	PORT47_DATA = 49,
	PORT48_DATA = 50,
	PORT49_DATA = 51,
	PORT50_DATA = 52,
	PORT51_DATA = 53,
	PORT52_DATA = 54,
	PORT53_DATA = 55,
	PORT54_DATA = 56,
	PORT55_DATA = 57,
	PORT56_DATA = 58,
	PORT57_DATA = 59,
	PORT58_DATA = 60,
	PORT59_DATA = 61,
	PORT60_DATA = 62,
	PORT61_DATA = 63,
	PORT62_DATA = 64,
	PORT63_DATA = 65,
	PORT64_DATA = 66,
	PORT65_DATA = 67,
	PORT66_DATA = 68,
	PORT67_DATA = 69,
	PORT68_DATA = 70,
	PORT69_DATA = 71,
	PORT70_DATA = 72,
	PORT71_DATA = 73,
	PORT72_DATA = 74,
	PORT73_DATA = 75,
	PORT74_DATA = 76,
	PORT75_DATA = 77,
	PORT76_DATA = 78,
	PORT77_DATA = 79,
	PORT78_DATA = 80,
	PORT79_DATA = 81,
	PORT80_DATA = 82,
	PORT81_DATA = 83,
	PORT82_DATA = 84,
	PORT83_DATA = 85,
	PORT84_DATA = 86,
	PORT85_DATA = 87,
	PORT86_DATA = 88,
	PORT87_DATA = 89,
	PORT88_DATA = 90,
	PORT89_DATA = 91,
	PORT90_DATA = 92,
	PORT91_DATA = 93,
	PORT92_DATA = 94,
	PORT93_DATA = 95,
	PORT94_DATA = 96,
	PORT95_DATA = 97,
	PORT96_DATA = 98,
	PORT97_DATA = 99,
	PORT98_DATA = 100,
	PORT99_DATA = 101,
	PORT100_DATA = 102,
	PORT101_DATA = 103,
	PORT102_DATA = 104,
	PORT103_DATA = 105,
	PORT104_DATA = 106,
	PORT105_DATA = 107,
	PORT106_DATA = 108,
	PORT107_DATA = 109,
	PORT108_DATA = 110,
	PORT109_DATA = 111,
	PORT110_DATA = 112,
	PORT111_DATA = 113,
	PORT112_DATA = 114,
	PORT113_DATA = 115,
	PORT114_DATA = 116,
	PORT115_DATA = 117,
	PORT116_DATA = 118,
	PORT117_DATA = 119,
	PORT118_DATA = 120,
	PORT128_DATA = 121,
	PORT129_DATA = 122,
	PORT130_DATA = 123,
	PORT131_DATA = 124,
	PORT132_DATA = 125,
	PORT133_DATA = 126,
	PORT134_DATA = 127,
	PORT135_DATA = 128,
	PORT136_DATA = 129,
	PORT137_DATA = 130,
	PORT138_DATA = 131,
	PORT139_DATA = 132,
	PORT140_DATA = 133,
	PORT141_DATA = 134,
	PORT142_DATA = 135,
	PORT143_DATA = 136,
	PORT144_DATA = 137,
	PORT145_DATA = 138,
	PORT146_DATA = 139,
	PORT147_DATA = 140,
	PORT148_DATA = 141,
	PORT149_DATA = 142,
	PORT150_DATA = 143,
	PORT151_DATA = 144,
	PORT152_DATA = 145,
	PORT153_DATA = 146,
	PORT154_DATA = 147,
	PORT155_DATA = 148,
	PORT156_DATA = 149,
	PORT157_DATA = 150,
	PORT158_DATA = 151,
	PORT159_DATA = 152,
	PORT160_DATA = 153,
	PORT161_DATA = 154,
	PORT162_DATA = 155,
	PORT163_DATA = 156,
	PORT164_DATA = 157,
	PORT192_DATA = 158,
	PORT193_DATA = 159,
	PORT194_DATA = 160,
	PORT195_DATA = 161,
	PORT196_DATA = 162,
	PORT197_DATA = 163,
	PORT198_DATA = 164,
	PORT199_DATA = 165,
	PORT200_DATA = 166,
	PORT201_DATA = 167,
	PORT202_DATA = 168,
	PORT203_DATA = 169,
	PORT204_DATA = 170,
	PORT205_DATA = 171,
	PORT206_DATA = 172,
	PORT207_DATA = 173,
	PORT208_DATA = 174,
	PORT209_DATA = 175,
	PORT210_DATA = 176,
	PORT211_DATA = 177,
	PORT212_DATA = 178,
	PORT213_DATA = 179,
	PORT214_DATA = 180,
	PORT215_DATA = 181,
	PORT216_DATA = 182,
	PORT217_DATA = 183,
	PORT218_DATA = 184,
	PORT219_DATA = 185,
	PORT220_DATA = 186,
	PORT221_DATA = 187,
	PORT222_DATA = 188,
	PORT223_DATA = 189,
	PORT224_DATA = 190,
	PORT225_DATA = 191,
	PORT226_DATA = 192,
	PORT227_DATA = 193,
	PORT228_DATA = 194,
	PORT229_DATA = 195,
	PORT230_DATA = 196,
	PORT231_DATA = 197,
	PORT232_DATA = 198,
	PORT233_DATA = 199,
	PORT234_DATA = 200,
	PORT235_DATA = 201,
	PORT236_DATA = 202,
	PORT237_DATA = 203,
	PORT238_DATA = 204,
	PORT239_DATA = 205,
	PORT240_DATA = 206,
	PORT241_DATA = 207,
	PORT242_DATA = 208,
	PORT243_DATA = 209,
	PORT244_DATA = 210,
	PORT245_DATA = 211,
	PORT246_DATA = 212,
	PORT247_DATA = 213,
	PORT248_DATA = 214,
	PORT249_DATA = 215,
	PORT250_DATA = 216,
	PORT251_DATA = 217,
	PORT252_DATA = 218,
	PORT253_DATA = 219,
	PORT254_DATA = 220,
	PORT255_DATA = 221,
	PORT256_DATA = 222,
	PORT257_DATA = 223,
	PORT258_DATA = 224,
	PORT259_DATA = 225,
	PORT260_DATA = 226,
	PORT261_DATA = 227,
	PORT262_DATA = 228,
	PORT263_DATA = 229,
	PORT264_DATA = 230,
	PORT265_DATA = 231,
	PORT266_DATA = 232,
	PORT267_DATA = 233,
	PORT268_DATA = 234,
	PORT269_DATA = 235,
	PORT270_DATA = 236,
	PORT271_DATA = 237,
	PORT272_DATA = 238,
	PORT273_DATA = 239,
	PORT274_DATA = 240,
	PORT275_DATA = 241,
	PORT276_DATA = 242,
	PORT277_DATA = 243,
	PORT278_DATA = 244,
	PORT279_DATA = 245,
	PORT280_DATA = 246,
	PORT281_DATA = 247,
	PORT282_DATA = 248,
	PORT288_DATA = 249,
	PORT289_DATA = 250,
	PORT290_DATA = 251,
	PORT291_DATA = 252,
	PORT292_DATA = 253,
	PORT293_DATA = 254,
	PORT294_DATA = 255,
	PORT295_DATA = 256,
	PORT296_DATA = 257,
	PORT297_DATA = 258,
	PORT298_DATA = 259,
	PORT299_DATA = 260,
	PORT300_DATA = 261,
	PORT301_DATA = 262,
	PORT302_DATA = 263,
	PORT303_DATA = 264,
	PORT304_DATA = 265,
	PORT305_DATA = 266,
	PORT306_DATA = 267,
	PORT307_DATA = 268,
	PORT308_DATA = 269,
	PORT309_DATA = 270,
	PINMUX_DATA_END___2 = 271,
	PINMUX_INPUT_BEGIN = 272,
	PORT0_IN = 273,
	PORT1_IN = 274,
	PORT2_IN = 275,
	PORT3_IN = 276,
	PORT4_IN = 277,
	PORT5_IN = 278,
	PORT6_IN = 279,
	PORT7_IN = 280,
	PORT8_IN = 281,
	PORT9_IN = 282,
	PORT10_IN = 283,
	PORT11_IN = 284,
	PORT12_IN = 285,
	PORT13_IN = 286,
	PORT14_IN = 287,
	PORT15_IN = 288,
	PORT16_IN = 289,
	PORT17_IN = 290,
	PORT18_IN = 291,
	PORT19_IN = 292,
	PORT20_IN = 293,
	PORT21_IN = 294,
	PORT22_IN = 295,
	PORT23_IN = 296,
	PORT24_IN = 297,
	PORT25_IN = 298,
	PORT26_IN = 299,
	PORT27_IN = 300,
	PORT28_IN = 301,
	PORT29_IN = 302,
	PORT30_IN = 303,
	PORT31_IN = 304,
	PORT32_IN = 305,
	PORT33_IN = 306,
	PORT34_IN = 307,
	PORT35_IN = 308,
	PORT36_IN = 309,
	PORT37_IN = 310,
	PORT38_IN = 311,
	PORT39_IN = 312,
	PORT40_IN = 313,
	PORT41_IN = 314,
	PORT42_IN = 315,
	PORT43_IN = 316,
	PORT44_IN = 317,
	PORT45_IN = 318,
	PORT46_IN = 319,
	PORT47_IN = 320,
	PORT48_IN = 321,
	PORT49_IN = 322,
	PORT50_IN = 323,
	PORT51_IN = 324,
	PORT52_IN = 325,
	PORT53_IN = 326,
	PORT54_IN = 327,
	PORT55_IN = 328,
	PORT56_IN = 329,
	PORT57_IN = 330,
	PORT58_IN = 331,
	PORT59_IN = 332,
	PORT60_IN = 333,
	PORT61_IN = 334,
	PORT62_IN = 335,
	PORT63_IN = 336,
	PORT64_IN = 337,
	PORT65_IN = 338,
	PORT66_IN = 339,
	PORT67_IN = 340,
	PORT68_IN = 341,
	PORT69_IN = 342,
	PORT70_IN = 343,
	PORT71_IN = 344,
	PORT72_IN = 345,
	PORT73_IN = 346,
	PORT74_IN = 347,
	PORT75_IN = 348,
	PORT76_IN = 349,
	PORT77_IN = 350,
	PORT78_IN = 351,
	PORT79_IN = 352,
	PORT80_IN = 353,
	PORT81_IN = 354,
	PORT82_IN = 355,
	PORT83_IN = 356,
	PORT84_IN = 357,
	PORT85_IN = 358,
	PORT86_IN = 359,
	PORT87_IN = 360,
	PORT88_IN = 361,
	PORT89_IN = 362,
	PORT90_IN = 363,
	PORT91_IN = 364,
	PORT92_IN = 365,
	PORT93_IN = 366,
	PORT94_IN = 367,
	PORT95_IN = 368,
	PORT96_IN = 369,
	PORT97_IN = 370,
	PORT98_IN = 371,
	PORT99_IN = 372,
	PORT100_IN = 373,
	PORT101_IN = 374,
	PORT102_IN = 375,
	PORT103_IN = 376,
	PORT104_IN = 377,
	PORT105_IN = 378,
	PORT106_IN = 379,
	PORT107_IN = 380,
	PORT108_IN = 381,
	PORT109_IN = 382,
	PORT110_IN = 383,
	PORT111_IN = 384,
	PORT112_IN = 385,
	PORT113_IN = 386,
	PORT114_IN = 387,
	PORT115_IN = 388,
	PORT116_IN = 389,
	PORT117_IN = 390,
	PORT118_IN = 391,
	PORT128_IN = 392,
	PORT129_IN = 393,
	PORT130_IN = 394,
	PORT131_IN = 395,
	PORT132_IN = 396,
	PORT133_IN = 397,
	PORT134_IN = 398,
	PORT135_IN = 399,
	PORT136_IN = 400,
	PORT137_IN = 401,
	PORT138_IN = 402,
	PORT139_IN = 403,
	PORT140_IN = 404,
	PORT141_IN = 405,
	PORT142_IN = 406,
	PORT143_IN = 407,
	PORT144_IN = 408,
	PORT145_IN = 409,
	PORT146_IN = 410,
	PORT147_IN = 411,
	PORT148_IN = 412,
	PORT149_IN = 413,
	PORT150_IN = 414,
	PORT151_IN = 415,
	PORT152_IN = 416,
	PORT153_IN = 417,
	PORT154_IN = 418,
	PORT155_IN = 419,
	PORT156_IN = 420,
	PORT157_IN = 421,
	PORT158_IN = 422,
	PORT159_IN = 423,
	PORT160_IN = 424,
	PORT161_IN = 425,
	PORT162_IN = 426,
	PORT163_IN = 427,
	PORT164_IN = 428,
	PORT192_IN = 429,
	PORT193_IN = 430,
	PORT194_IN = 431,
	PORT195_IN = 432,
	PORT196_IN = 433,
	PORT197_IN = 434,
	PORT198_IN = 435,
	PORT199_IN = 436,
	PORT200_IN = 437,
	PORT201_IN = 438,
	PORT202_IN = 439,
	PORT203_IN = 440,
	PORT204_IN = 441,
	PORT205_IN = 442,
	PORT206_IN = 443,
	PORT207_IN = 444,
	PORT208_IN = 445,
	PORT209_IN = 446,
	PORT210_IN = 447,
	PORT211_IN = 448,
	PORT212_IN = 449,
	PORT213_IN = 450,
	PORT214_IN = 451,
	PORT215_IN = 452,
	PORT216_IN = 453,
	PORT217_IN = 454,
	PORT218_IN = 455,
	PORT219_IN = 456,
	PORT220_IN = 457,
	PORT221_IN = 458,
	PORT222_IN = 459,
	PORT223_IN = 460,
	PORT224_IN = 461,
	PORT225_IN = 462,
	PORT226_IN = 463,
	PORT227_IN = 464,
	PORT228_IN = 465,
	PORT229_IN = 466,
	PORT230_IN = 467,
	PORT231_IN = 468,
	PORT232_IN = 469,
	PORT233_IN = 470,
	PORT234_IN = 471,
	PORT235_IN = 472,
	PORT236_IN = 473,
	PORT237_IN = 474,
	PORT238_IN = 475,
	PORT239_IN = 476,
	PORT240_IN = 477,
	PORT241_IN = 478,
	PORT242_IN = 479,
	PORT243_IN = 480,
	PORT244_IN = 481,
	PORT245_IN = 482,
	PORT246_IN = 483,
	PORT247_IN = 484,
	PORT248_IN = 485,
	PORT249_IN = 486,
	PORT250_IN = 487,
	PORT251_IN = 488,
	PORT252_IN = 489,
	PORT253_IN = 490,
	PORT254_IN = 491,
	PORT255_IN = 492,
	PORT256_IN = 493,
	PORT257_IN = 494,
	PORT258_IN = 495,
	PORT259_IN = 496,
	PORT260_IN = 497,
	PORT261_IN = 498,
	PORT262_IN = 499,
	PORT263_IN = 500,
	PORT264_IN = 501,
	PORT265_IN = 502,
	PORT266_IN = 503,
	PORT267_IN = 504,
	PORT268_IN = 505,
	PORT269_IN = 506,
	PORT270_IN = 507,
	PORT271_IN = 508,
	PORT272_IN = 509,
	PORT273_IN = 510,
	PORT274_IN = 511,
	PORT275_IN = 512,
	PORT276_IN = 513,
	PORT277_IN = 514,
	PORT278_IN = 515,
	PORT279_IN = 516,
	PORT280_IN = 517,
	PORT281_IN = 518,
	PORT282_IN = 519,
	PORT288_IN = 520,
	PORT289_IN = 521,
	PORT290_IN = 522,
	PORT291_IN = 523,
	PORT292_IN = 524,
	PORT293_IN = 525,
	PORT294_IN = 526,
	PORT295_IN = 527,
	PORT296_IN = 528,
	PORT297_IN = 529,
	PORT298_IN = 530,
	PORT299_IN = 531,
	PORT300_IN = 532,
	PORT301_IN = 533,
	PORT302_IN = 534,
	PORT303_IN = 535,
	PORT304_IN = 536,
	PORT305_IN = 537,
	PORT306_IN = 538,
	PORT307_IN = 539,
	PORT308_IN = 540,
	PORT309_IN = 541,
	PINMUX_INPUT_END = 542,
	PINMUX_OUTPUT_BEGIN = 543,
	PORT0_OUT = 544,
	PORT1_OUT = 545,
	PORT2_OUT = 546,
	PORT3_OUT = 547,
	PORT4_OUT = 548,
	PORT5_OUT = 549,
	PORT6_OUT = 550,
	PORT7_OUT = 551,
	PORT8_OUT = 552,
	PORT9_OUT = 553,
	PORT10_OUT = 554,
	PORT11_OUT = 555,
	PORT12_OUT = 556,
	PORT13_OUT = 557,
	PORT14_OUT = 558,
	PORT15_OUT = 559,
	PORT16_OUT = 560,
	PORT17_OUT = 561,
	PORT18_OUT = 562,
	PORT19_OUT = 563,
	PORT20_OUT = 564,
	PORT21_OUT = 565,
	PORT22_OUT = 566,
	PORT23_OUT = 567,
	PORT24_OUT = 568,
	PORT25_OUT = 569,
	PORT26_OUT = 570,
	PORT27_OUT = 571,
	PORT28_OUT = 572,
	PORT29_OUT = 573,
	PORT30_OUT = 574,
	PORT31_OUT = 575,
	PORT32_OUT = 576,
	PORT33_OUT = 577,
	PORT34_OUT = 578,
	PORT35_OUT = 579,
	PORT36_OUT = 580,
	PORT37_OUT = 581,
	PORT38_OUT = 582,
	PORT39_OUT = 583,
	PORT40_OUT = 584,
	PORT41_OUT = 585,
	PORT42_OUT = 586,
	PORT43_OUT = 587,
	PORT44_OUT = 588,
	PORT45_OUT = 589,
	PORT46_OUT = 590,
	PORT47_OUT = 591,
	PORT48_OUT = 592,
	PORT49_OUT = 593,
	PORT50_OUT = 594,
	PORT51_OUT = 595,
	PORT52_OUT = 596,
	PORT53_OUT = 597,
	PORT54_OUT = 598,
	PORT55_OUT = 599,
	PORT56_OUT = 600,
	PORT57_OUT = 601,
	PORT58_OUT = 602,
	PORT59_OUT = 603,
	PORT60_OUT = 604,
	PORT61_OUT = 605,
	PORT62_OUT = 606,
	PORT63_OUT = 607,
	PORT64_OUT = 608,
	PORT65_OUT = 609,
	PORT66_OUT = 610,
	PORT67_OUT = 611,
	PORT68_OUT = 612,
	PORT69_OUT = 613,
	PORT70_OUT = 614,
	PORT71_OUT = 615,
	PORT72_OUT = 616,
	PORT73_OUT = 617,
	PORT74_OUT = 618,
	PORT75_OUT = 619,
	PORT76_OUT = 620,
	PORT77_OUT = 621,
	PORT78_OUT = 622,
	PORT79_OUT = 623,
	PORT80_OUT = 624,
	PORT81_OUT = 625,
	PORT82_OUT = 626,
	PORT83_OUT = 627,
	PORT84_OUT = 628,
	PORT85_OUT = 629,
	PORT86_OUT = 630,
	PORT87_OUT = 631,
	PORT88_OUT = 632,
	PORT89_OUT = 633,
	PORT90_OUT = 634,
	PORT91_OUT = 635,
	PORT92_OUT = 636,
	PORT93_OUT = 637,
	PORT94_OUT = 638,
	PORT95_OUT = 639,
	PORT96_OUT = 640,
	PORT97_OUT = 641,
	PORT98_OUT = 642,
	PORT99_OUT = 643,
	PORT100_OUT = 644,
	PORT101_OUT = 645,
	PORT102_OUT = 646,
	PORT103_OUT = 647,
	PORT104_OUT = 648,
	PORT105_OUT = 649,
	PORT106_OUT = 650,
	PORT107_OUT = 651,
	PORT108_OUT = 652,
	PORT109_OUT = 653,
	PORT110_OUT = 654,
	PORT111_OUT = 655,
	PORT112_OUT = 656,
	PORT113_OUT = 657,
	PORT114_OUT = 658,
	PORT115_OUT = 659,
	PORT116_OUT = 660,
	PORT117_OUT = 661,
	PORT118_OUT = 662,
	PORT128_OUT = 663,
	PORT129_OUT = 664,
	PORT130_OUT = 665,
	PORT131_OUT = 666,
	PORT132_OUT = 667,
	PORT133_OUT = 668,
	PORT134_OUT = 669,
	PORT135_OUT = 670,
	PORT136_OUT = 671,
	PORT137_OUT = 672,
	PORT138_OUT = 673,
	PORT139_OUT = 674,
	PORT140_OUT = 675,
	PORT141_OUT = 676,
	PORT142_OUT = 677,
	PORT143_OUT = 678,
	PORT144_OUT = 679,
	PORT145_OUT = 680,
	PORT146_OUT = 681,
	PORT147_OUT = 682,
	PORT148_OUT = 683,
	PORT149_OUT = 684,
	PORT150_OUT = 685,
	PORT151_OUT = 686,
	PORT152_OUT = 687,
	PORT153_OUT = 688,
	PORT154_OUT = 689,
	PORT155_OUT = 690,
	PORT156_OUT = 691,
	PORT157_OUT = 692,
	PORT158_OUT = 693,
	PORT159_OUT = 694,
	PORT160_OUT = 695,
	PORT161_OUT = 696,
	PORT162_OUT = 697,
	PORT163_OUT = 698,
	PORT164_OUT = 699,
	PORT192_OUT = 700,
	PORT193_OUT = 701,
	PORT194_OUT = 702,
	PORT195_OUT = 703,
	PORT196_OUT = 704,
	PORT197_OUT = 705,
	PORT198_OUT = 706,
	PORT199_OUT = 707,
	PORT200_OUT = 708,
	PORT201_OUT = 709,
	PORT202_OUT = 710,
	PORT203_OUT = 711,
	PORT204_OUT = 712,
	PORT205_OUT = 713,
	PORT206_OUT = 714,
	PORT207_OUT = 715,
	PORT208_OUT = 716,
	PORT209_OUT = 717,
	PORT210_OUT = 718,
	PORT211_OUT = 719,
	PORT212_OUT = 720,
	PORT213_OUT = 721,
	PORT214_OUT = 722,
	PORT215_OUT = 723,
	PORT216_OUT = 724,
	PORT217_OUT = 725,
	PORT218_OUT = 726,
	PORT219_OUT = 727,
	PORT220_OUT = 728,
	PORT221_OUT = 729,
	PORT222_OUT = 730,
	PORT223_OUT = 731,
	PORT224_OUT = 732,
	PORT225_OUT = 733,
	PORT226_OUT = 734,
	PORT227_OUT = 735,
	PORT228_OUT = 736,
	PORT229_OUT = 737,
	PORT230_OUT = 738,
	PORT231_OUT = 739,
	PORT232_OUT = 740,
	PORT233_OUT = 741,
	PORT234_OUT = 742,
	PORT235_OUT = 743,
	PORT236_OUT = 744,
	PORT237_OUT = 745,
	PORT238_OUT = 746,
	PORT239_OUT = 747,
	PORT240_OUT = 748,
	PORT241_OUT = 749,
	PORT242_OUT = 750,
	PORT243_OUT = 751,
	PORT244_OUT = 752,
	PORT245_OUT = 753,
	PORT246_OUT = 754,
	PORT247_OUT = 755,
	PORT248_OUT = 756,
	PORT249_OUT = 757,
	PORT250_OUT = 758,
	PORT251_OUT = 759,
	PORT252_OUT = 760,
	PORT253_OUT = 761,
	PORT254_OUT = 762,
	PORT255_OUT = 763,
	PORT256_OUT = 764,
	PORT257_OUT = 765,
	PORT258_OUT = 766,
	PORT259_OUT = 767,
	PORT260_OUT = 768,
	PORT261_OUT = 769,
	PORT262_OUT = 770,
	PORT263_OUT = 771,
	PORT264_OUT = 772,
	PORT265_OUT = 773,
	PORT266_OUT = 774,
	PORT267_OUT = 775,
	PORT268_OUT = 776,
	PORT269_OUT = 777,
	PORT270_OUT = 778,
	PORT271_OUT = 779,
	PORT272_OUT = 780,
	PORT273_OUT = 781,
	PORT274_OUT = 782,
	PORT275_OUT = 783,
	PORT276_OUT = 784,
	PORT277_OUT = 785,
	PORT278_OUT = 786,
	PORT279_OUT = 787,
	PORT280_OUT = 788,
	PORT281_OUT = 789,
	PORT282_OUT = 790,
	PORT288_OUT = 791,
	PORT289_OUT = 792,
	PORT290_OUT = 793,
	PORT291_OUT = 794,
	PORT292_OUT = 795,
	PORT293_OUT = 796,
	PORT294_OUT = 797,
	PORT295_OUT = 798,
	PORT296_OUT = 799,
	PORT297_OUT = 800,
	PORT298_OUT = 801,
	PORT299_OUT = 802,
	PORT300_OUT = 803,
	PORT301_OUT = 804,
	PORT302_OUT = 805,
	PORT303_OUT = 806,
	PORT304_OUT = 807,
	PORT305_OUT = 808,
	PORT306_OUT = 809,
	PORT307_OUT = 810,
	PORT308_OUT = 811,
	PORT309_OUT = 812,
	PINMUX_OUTPUT_END = 813,
	PINMUX_FUNCTION_BEGIN___2 = 814,
	PORT0_FN_IN = 815,
	PORT1_FN_IN = 816,
	PORT2_FN_IN = 817,
	PORT3_FN_IN = 818,
	PORT4_FN_IN = 819,
	PORT5_FN_IN = 820,
	PORT6_FN_IN = 821,
	PORT7_FN_IN = 822,
	PORT8_FN_IN = 823,
	PORT9_FN_IN = 824,
	PORT10_FN_IN = 825,
	PORT11_FN_IN = 826,
	PORT12_FN_IN = 827,
	PORT13_FN_IN = 828,
	PORT14_FN_IN = 829,
	PORT15_FN_IN = 830,
	PORT16_FN_IN = 831,
	PORT17_FN_IN = 832,
	PORT18_FN_IN = 833,
	PORT19_FN_IN = 834,
	PORT20_FN_IN = 835,
	PORT21_FN_IN = 836,
	PORT22_FN_IN = 837,
	PORT23_FN_IN = 838,
	PORT24_FN_IN = 839,
	PORT25_FN_IN = 840,
	PORT26_FN_IN = 841,
	PORT27_FN_IN = 842,
	PORT28_FN_IN = 843,
	PORT29_FN_IN = 844,
	PORT30_FN_IN = 845,
	PORT31_FN_IN = 846,
	PORT32_FN_IN = 847,
	PORT33_FN_IN = 848,
	PORT34_FN_IN = 849,
	PORT35_FN_IN = 850,
	PORT36_FN_IN = 851,
	PORT37_FN_IN = 852,
	PORT38_FN_IN = 853,
	PORT39_FN_IN = 854,
	PORT40_FN_IN = 855,
	PORT41_FN_IN = 856,
	PORT42_FN_IN = 857,
	PORT43_FN_IN = 858,
	PORT44_FN_IN = 859,
	PORT45_FN_IN = 860,
	PORT46_FN_IN = 861,
	PORT47_FN_IN = 862,
	PORT48_FN_IN = 863,
	PORT49_FN_IN = 864,
	PORT50_FN_IN = 865,
	PORT51_FN_IN = 866,
	PORT52_FN_IN = 867,
	PORT53_FN_IN = 868,
	PORT54_FN_IN = 869,
	PORT55_FN_IN = 870,
	PORT56_FN_IN = 871,
	PORT57_FN_IN = 872,
	PORT58_FN_IN = 873,
	PORT59_FN_IN = 874,
	PORT60_FN_IN = 875,
	PORT61_FN_IN = 876,
	PORT62_FN_IN = 877,
	PORT63_FN_IN = 878,
	PORT64_FN_IN = 879,
	PORT65_FN_IN = 880,
	PORT66_FN_IN = 881,
	PORT67_FN_IN = 882,
	PORT68_FN_IN = 883,
	PORT69_FN_IN = 884,
	PORT70_FN_IN = 885,
	PORT71_FN_IN = 886,
	PORT72_FN_IN = 887,
	PORT73_FN_IN = 888,
	PORT74_FN_IN = 889,
	PORT75_FN_IN = 890,
	PORT76_FN_IN = 891,
	PORT77_FN_IN = 892,
	PORT78_FN_IN = 893,
	PORT79_FN_IN = 894,
	PORT80_FN_IN = 895,
	PORT81_FN_IN = 896,
	PORT82_FN_IN = 897,
	PORT83_FN_IN = 898,
	PORT84_FN_IN = 899,
	PORT85_FN_IN = 900,
	PORT86_FN_IN = 901,
	PORT87_FN_IN = 902,
	PORT88_FN_IN = 903,
	PORT89_FN_IN = 904,
	PORT90_FN_IN = 905,
	PORT91_FN_IN = 906,
	PORT92_FN_IN = 907,
	PORT93_FN_IN = 908,
	PORT94_FN_IN = 909,
	PORT95_FN_IN = 910,
	PORT96_FN_IN = 911,
	PORT97_FN_IN = 912,
	PORT98_FN_IN = 913,
	PORT99_FN_IN = 914,
	PORT100_FN_IN = 915,
	PORT101_FN_IN = 916,
	PORT102_FN_IN = 917,
	PORT103_FN_IN = 918,
	PORT104_FN_IN = 919,
	PORT105_FN_IN = 920,
	PORT106_FN_IN = 921,
	PORT107_FN_IN = 922,
	PORT108_FN_IN = 923,
	PORT109_FN_IN = 924,
	PORT110_FN_IN = 925,
	PORT111_FN_IN = 926,
	PORT112_FN_IN = 927,
	PORT113_FN_IN = 928,
	PORT114_FN_IN = 929,
	PORT115_FN_IN = 930,
	PORT116_FN_IN = 931,
	PORT117_FN_IN = 932,
	PORT118_FN_IN = 933,
	PORT128_FN_IN = 934,
	PORT129_FN_IN = 935,
	PORT130_FN_IN = 936,
	PORT131_FN_IN = 937,
	PORT132_FN_IN = 938,
	PORT133_FN_IN = 939,
	PORT134_FN_IN = 940,
	PORT135_FN_IN = 941,
	PORT136_FN_IN = 942,
	PORT137_FN_IN = 943,
	PORT138_FN_IN = 944,
	PORT139_FN_IN = 945,
	PORT140_FN_IN = 946,
	PORT141_FN_IN = 947,
	PORT142_FN_IN = 948,
	PORT143_FN_IN = 949,
	PORT144_FN_IN = 950,
	PORT145_FN_IN = 951,
	PORT146_FN_IN = 952,
	PORT147_FN_IN = 953,
	PORT148_FN_IN = 954,
	PORT149_FN_IN = 955,
	PORT150_FN_IN = 956,
	PORT151_FN_IN = 957,
	PORT152_FN_IN = 958,
	PORT153_FN_IN = 959,
	PORT154_FN_IN = 960,
	PORT155_FN_IN = 961,
	PORT156_FN_IN = 962,
	PORT157_FN_IN = 963,
	PORT158_FN_IN = 964,
	PORT159_FN_IN = 965,
	PORT160_FN_IN = 966,
	PORT161_FN_IN = 967,
	PORT162_FN_IN = 968,
	PORT163_FN_IN = 969,
	PORT164_FN_IN = 970,
	PORT192_FN_IN = 971,
	PORT193_FN_IN = 972,
	PORT194_FN_IN = 973,
	PORT195_FN_IN = 974,
	PORT196_FN_IN = 975,
	PORT197_FN_IN = 976,
	PORT198_FN_IN = 977,
	PORT199_FN_IN = 978,
	PORT200_FN_IN = 979,
	PORT201_FN_IN = 980,
	PORT202_FN_IN = 981,
	PORT203_FN_IN = 982,
	PORT204_FN_IN = 983,
	PORT205_FN_IN = 984,
	PORT206_FN_IN = 985,
	PORT207_FN_IN = 986,
	PORT208_FN_IN = 987,
	PORT209_FN_IN = 988,
	PORT210_FN_IN = 989,
	PORT211_FN_IN = 990,
	PORT212_FN_IN = 991,
	PORT213_FN_IN = 992,
	PORT214_FN_IN = 993,
	PORT215_FN_IN = 994,
	PORT216_FN_IN = 995,
	PORT217_FN_IN = 996,
	PORT218_FN_IN = 997,
	PORT219_FN_IN = 998,
	PORT220_FN_IN = 999,
	PORT221_FN_IN = 1000,
	PORT222_FN_IN = 1001,
	PORT223_FN_IN = 1002,
	PORT224_FN_IN = 1003,
	PORT225_FN_IN = 1004,
	PORT226_FN_IN = 1005,
	PORT227_FN_IN = 1006,
	PORT228_FN_IN = 1007,
	PORT229_FN_IN = 1008,
	PORT230_FN_IN = 1009,
	PORT231_FN_IN = 1010,
	PORT232_FN_IN = 1011,
	PORT233_FN_IN = 1012,
	PORT234_FN_IN = 1013,
	PORT235_FN_IN = 1014,
	PORT236_FN_IN = 1015,
	PORT237_FN_IN = 1016,
	PORT238_FN_IN = 1017,
	PORT239_FN_IN = 1018,
	PORT240_FN_IN = 1019,
	PORT241_FN_IN = 1020,
	PORT242_FN_IN = 1021,
	PORT243_FN_IN = 1022,
	PORT244_FN_IN = 1023,
	PORT245_FN_IN = 1024,
	PORT246_FN_IN = 1025,
	PORT247_FN_IN = 1026,
	PORT248_FN_IN = 1027,
	PORT249_FN_IN = 1028,
	PORT250_FN_IN = 1029,
	PORT251_FN_IN = 1030,
	PORT252_FN_IN = 1031,
	PORT253_FN_IN = 1032,
	PORT254_FN_IN = 1033,
	PORT255_FN_IN = 1034,
	PORT256_FN_IN = 1035,
	PORT257_FN_IN = 1036,
	PORT258_FN_IN = 1037,
	PORT259_FN_IN = 1038,
	PORT260_FN_IN = 1039,
	PORT261_FN_IN = 1040,
	PORT262_FN_IN = 1041,
	PORT263_FN_IN = 1042,
	PORT264_FN_IN = 1043,
	PORT265_FN_IN = 1044,
	PORT266_FN_IN = 1045,
	PORT267_FN_IN = 1046,
	PORT268_FN_IN = 1047,
	PORT269_FN_IN = 1048,
	PORT270_FN_IN = 1049,
	PORT271_FN_IN = 1050,
	PORT272_FN_IN = 1051,
	PORT273_FN_IN = 1052,
	PORT274_FN_IN = 1053,
	PORT275_FN_IN = 1054,
	PORT276_FN_IN = 1055,
	PORT277_FN_IN = 1056,
	PORT278_FN_IN = 1057,
	PORT279_FN_IN = 1058,
	PORT280_FN_IN = 1059,
	PORT281_FN_IN = 1060,
	PORT282_FN_IN = 1061,
	PORT288_FN_IN = 1062,
	PORT289_FN_IN = 1063,
	PORT290_FN_IN = 1064,
	PORT291_FN_IN = 1065,
	PORT292_FN_IN = 1066,
	PORT293_FN_IN = 1067,
	PORT294_FN_IN = 1068,
	PORT295_FN_IN = 1069,
	PORT296_FN_IN = 1070,
	PORT297_FN_IN = 1071,
	PORT298_FN_IN = 1072,
	PORT299_FN_IN = 1073,
	PORT300_FN_IN = 1074,
	PORT301_FN_IN = 1075,
	PORT302_FN_IN = 1076,
	PORT303_FN_IN = 1077,
	PORT304_FN_IN = 1078,
	PORT305_FN_IN = 1079,
	PORT306_FN_IN = 1080,
	PORT307_FN_IN = 1081,
	PORT308_FN_IN = 1082,
	PORT309_FN_IN = 1083,
	PORT0_FN_OUT = 1084,
	PORT1_FN_OUT = 1085,
	PORT2_FN_OUT = 1086,
	PORT3_FN_OUT = 1087,
	PORT4_FN_OUT = 1088,
	PORT5_FN_OUT = 1089,
	PORT6_FN_OUT = 1090,
	PORT7_FN_OUT = 1091,
	PORT8_FN_OUT = 1092,
	PORT9_FN_OUT = 1093,
	PORT10_FN_OUT = 1094,
	PORT11_FN_OUT = 1095,
	PORT12_FN_OUT = 1096,
	PORT13_FN_OUT = 1097,
	PORT14_FN_OUT = 1098,
	PORT15_FN_OUT = 1099,
	PORT16_FN_OUT = 1100,
	PORT17_FN_OUT = 1101,
	PORT18_FN_OUT = 1102,
	PORT19_FN_OUT = 1103,
	PORT20_FN_OUT = 1104,
	PORT21_FN_OUT = 1105,
	PORT22_FN_OUT = 1106,
	PORT23_FN_OUT = 1107,
	PORT24_FN_OUT = 1108,
	PORT25_FN_OUT = 1109,
	PORT26_FN_OUT = 1110,
	PORT27_FN_OUT = 1111,
	PORT28_FN_OUT = 1112,
	PORT29_FN_OUT = 1113,
	PORT30_FN_OUT = 1114,
	PORT31_FN_OUT = 1115,
	PORT32_FN_OUT = 1116,
	PORT33_FN_OUT = 1117,
	PORT34_FN_OUT = 1118,
	PORT35_FN_OUT = 1119,
	PORT36_FN_OUT = 1120,
	PORT37_FN_OUT = 1121,
	PORT38_FN_OUT = 1122,
	PORT39_FN_OUT = 1123,
	PORT40_FN_OUT = 1124,
	PORT41_FN_OUT = 1125,
	PORT42_FN_OUT = 1126,
	PORT43_FN_OUT = 1127,
	PORT44_FN_OUT = 1128,
	PORT45_FN_OUT = 1129,
	PORT46_FN_OUT = 1130,
	PORT47_FN_OUT = 1131,
	PORT48_FN_OUT = 1132,
	PORT49_FN_OUT = 1133,
	PORT50_FN_OUT = 1134,
	PORT51_FN_OUT = 1135,
	PORT52_FN_OUT = 1136,
	PORT53_FN_OUT = 1137,
	PORT54_FN_OUT = 1138,
	PORT55_FN_OUT = 1139,
	PORT56_FN_OUT = 1140,
	PORT57_FN_OUT = 1141,
	PORT58_FN_OUT = 1142,
	PORT59_FN_OUT = 1143,
	PORT60_FN_OUT = 1144,
	PORT61_FN_OUT = 1145,
	PORT62_FN_OUT = 1146,
	PORT63_FN_OUT = 1147,
	PORT64_FN_OUT = 1148,
	PORT65_FN_OUT = 1149,
	PORT66_FN_OUT = 1150,
	PORT67_FN_OUT = 1151,
	PORT68_FN_OUT = 1152,
	PORT69_FN_OUT = 1153,
	PORT70_FN_OUT = 1154,
	PORT71_FN_OUT = 1155,
	PORT72_FN_OUT = 1156,
	PORT73_FN_OUT = 1157,
	PORT74_FN_OUT = 1158,
	PORT75_FN_OUT = 1159,
	PORT76_FN_OUT = 1160,
	PORT77_FN_OUT = 1161,
	PORT78_FN_OUT = 1162,
	PORT79_FN_OUT = 1163,
	PORT80_FN_OUT = 1164,
	PORT81_FN_OUT = 1165,
	PORT82_FN_OUT = 1166,
	PORT83_FN_OUT = 1167,
	PORT84_FN_OUT = 1168,
	PORT85_FN_OUT = 1169,
	PORT86_FN_OUT = 1170,
	PORT87_FN_OUT = 1171,
	PORT88_FN_OUT = 1172,
	PORT89_FN_OUT = 1173,
	PORT90_FN_OUT = 1174,
	PORT91_FN_OUT = 1175,
	PORT92_FN_OUT = 1176,
	PORT93_FN_OUT = 1177,
	PORT94_FN_OUT = 1178,
	PORT95_FN_OUT = 1179,
	PORT96_FN_OUT = 1180,
	PORT97_FN_OUT = 1181,
	PORT98_FN_OUT = 1182,
	PORT99_FN_OUT = 1183,
	PORT100_FN_OUT = 1184,
	PORT101_FN_OUT = 1185,
	PORT102_FN_OUT = 1186,
	PORT103_FN_OUT = 1187,
	PORT104_FN_OUT = 1188,
	PORT105_FN_OUT = 1189,
	PORT106_FN_OUT = 1190,
	PORT107_FN_OUT = 1191,
	PORT108_FN_OUT = 1192,
	PORT109_FN_OUT = 1193,
	PORT110_FN_OUT = 1194,
	PORT111_FN_OUT = 1195,
	PORT112_FN_OUT = 1196,
	PORT113_FN_OUT = 1197,
	PORT114_FN_OUT = 1198,
	PORT115_FN_OUT = 1199,
	PORT116_FN_OUT = 1200,
	PORT117_FN_OUT = 1201,
	PORT118_FN_OUT = 1202,
	PORT128_FN_OUT = 1203,
	PORT129_FN_OUT = 1204,
	PORT130_FN_OUT = 1205,
	PORT131_FN_OUT = 1206,
	PORT132_FN_OUT = 1207,
	PORT133_FN_OUT = 1208,
	PORT134_FN_OUT = 1209,
	PORT135_FN_OUT = 1210,
	PORT136_FN_OUT = 1211,
	PORT137_FN_OUT = 1212,
	PORT138_FN_OUT = 1213,
	PORT139_FN_OUT = 1214,
	PORT140_FN_OUT = 1215,
	PORT141_FN_OUT = 1216,
	PORT142_FN_OUT = 1217,
	PORT143_FN_OUT = 1218,
	PORT144_FN_OUT = 1219,
	PORT145_FN_OUT = 1220,
	PORT146_FN_OUT = 1221,
	PORT147_FN_OUT = 1222,
	PORT148_FN_OUT = 1223,
	PORT149_FN_OUT = 1224,
	PORT150_FN_OUT = 1225,
	PORT151_FN_OUT = 1226,
	PORT152_FN_OUT = 1227,
	PORT153_FN_OUT = 1228,
	PORT154_FN_OUT = 1229,
	PORT155_FN_OUT = 1230,
	PORT156_FN_OUT = 1231,
	PORT157_FN_OUT = 1232,
	PORT158_FN_OUT = 1233,
	PORT159_FN_OUT = 1234,
	PORT160_FN_OUT = 1235,
	PORT161_FN_OUT = 1236,
	PORT162_FN_OUT = 1237,
	PORT163_FN_OUT = 1238,
	PORT164_FN_OUT = 1239,
	PORT192_FN_OUT = 1240,
	PORT193_FN_OUT = 1241,
	PORT194_FN_OUT = 1242,
	PORT195_FN_OUT = 1243,
	PORT196_FN_OUT = 1244,
	PORT197_FN_OUT = 1245,
	PORT198_FN_OUT = 1246,
	PORT199_FN_OUT = 1247,
	PORT200_FN_OUT = 1248,
	PORT201_FN_OUT = 1249,
	PORT202_FN_OUT = 1250,
	PORT203_FN_OUT = 1251,
	PORT204_FN_OUT = 1252,
	PORT205_FN_OUT = 1253,
	PORT206_FN_OUT = 1254,
	PORT207_FN_OUT = 1255,
	PORT208_FN_OUT = 1256,
	PORT209_FN_OUT = 1257,
	PORT210_FN_OUT = 1258,
	PORT211_FN_OUT = 1259,
	PORT212_FN_OUT = 1260,
	PORT213_FN_OUT = 1261,
	PORT214_FN_OUT = 1262,
	PORT215_FN_OUT = 1263,
	PORT216_FN_OUT = 1264,
	PORT217_FN_OUT = 1265,
	PORT218_FN_OUT = 1266,
	PORT219_FN_OUT = 1267,
	PORT220_FN_OUT = 1268,
	PORT221_FN_OUT = 1269,
	PORT222_FN_OUT = 1270,
	PORT223_FN_OUT = 1271,
	PORT224_FN_OUT = 1272,
	PORT225_FN_OUT = 1273,
	PORT226_FN_OUT = 1274,
	PORT227_FN_OUT = 1275,
	PORT228_FN_OUT = 1276,
	PORT229_FN_OUT = 1277,
	PORT230_FN_OUT = 1278,
	PORT231_FN_OUT = 1279,
	PORT232_FN_OUT = 1280,
	PORT233_FN_OUT = 1281,
	PORT234_FN_OUT = 1282,
	PORT235_FN_OUT = 1283,
	PORT236_FN_OUT = 1284,
	PORT237_FN_OUT = 1285,
	PORT238_FN_OUT = 1286,
	PORT239_FN_OUT = 1287,
	PORT240_FN_OUT = 1288,
	PORT241_FN_OUT = 1289,
	PORT242_FN_OUT = 1290,
	PORT243_FN_OUT = 1291,
	PORT244_FN_OUT = 1292,
	PORT245_FN_OUT = 1293,
	PORT246_FN_OUT = 1294,
	PORT247_FN_OUT = 1295,
	PORT248_FN_OUT = 1296,
	PORT249_FN_OUT = 1297,
	PORT250_FN_OUT = 1298,
	PORT251_FN_OUT = 1299,
	PORT252_FN_OUT = 1300,
	PORT253_FN_OUT = 1301,
	PORT254_FN_OUT = 1302,
	PORT255_FN_OUT = 1303,
	PORT256_FN_OUT = 1304,
	PORT257_FN_OUT = 1305,
	PORT258_FN_OUT = 1306,
	PORT259_FN_OUT = 1307,
	PORT260_FN_OUT = 1308,
	PORT261_FN_OUT = 1309,
	PORT262_FN_OUT = 1310,
	PORT263_FN_OUT = 1311,
	PORT264_FN_OUT = 1312,
	PORT265_FN_OUT = 1313,
	PORT266_FN_OUT = 1314,
	PORT267_FN_OUT = 1315,
	PORT268_FN_OUT = 1316,
	PORT269_FN_OUT = 1317,
	PORT270_FN_OUT = 1318,
	PORT271_FN_OUT = 1319,
	PORT272_FN_OUT = 1320,
	PORT273_FN_OUT = 1321,
	PORT274_FN_OUT = 1322,
	PORT275_FN_OUT = 1323,
	PORT276_FN_OUT = 1324,
	PORT277_FN_OUT = 1325,
	PORT278_FN_OUT = 1326,
	PORT279_FN_OUT = 1327,
	PORT280_FN_OUT = 1328,
	PORT281_FN_OUT = 1329,
	PORT282_FN_OUT = 1330,
	PORT288_FN_OUT = 1331,
	PORT289_FN_OUT = 1332,
	PORT290_FN_OUT = 1333,
	PORT291_FN_OUT = 1334,
	PORT292_FN_OUT = 1335,
	PORT293_FN_OUT = 1336,
	PORT294_FN_OUT = 1337,
	PORT295_FN_OUT = 1338,
	PORT296_FN_OUT = 1339,
	PORT297_FN_OUT = 1340,
	PORT298_FN_OUT = 1341,
	PORT299_FN_OUT = 1342,
	PORT300_FN_OUT = 1343,
	PORT301_FN_OUT = 1344,
	PORT302_FN_OUT = 1345,
	PORT303_FN_OUT = 1346,
	PORT304_FN_OUT = 1347,
	PORT305_FN_OUT = 1348,
	PORT306_FN_OUT = 1349,
	PORT307_FN_OUT = 1350,
	PORT308_FN_OUT = 1351,
	PORT309_FN_OUT = 1352,
	PORT0_FN0 = 1353,
	PORT1_FN0 = 1354,
	PORT2_FN0 = 1355,
	PORT3_FN0 = 1356,
	PORT4_FN0 = 1357,
	PORT5_FN0 = 1358,
	PORT6_FN0 = 1359,
	PORT7_FN0 = 1360,
	PORT8_FN0 = 1361,
	PORT9_FN0 = 1362,
	PORT10_FN0 = 1363,
	PORT11_FN0 = 1364,
	PORT12_FN0 = 1365,
	PORT13_FN0 = 1366,
	PORT14_FN0 = 1367,
	PORT15_FN0 = 1368,
	PORT16_FN0 = 1369,
	PORT17_FN0 = 1370,
	PORT18_FN0 = 1371,
	PORT19_FN0 = 1372,
	PORT20_FN0 = 1373,
	PORT21_FN0 = 1374,
	PORT22_FN0 = 1375,
	PORT23_FN0 = 1376,
	PORT24_FN0 = 1377,
	PORT25_FN0 = 1378,
	PORT26_FN0 = 1379,
	PORT27_FN0 = 1380,
	PORT28_FN0 = 1381,
	PORT29_FN0 = 1382,
	PORT30_FN0 = 1383,
	PORT31_FN0 = 1384,
	PORT32_FN0 = 1385,
	PORT33_FN0 = 1386,
	PORT34_FN0 = 1387,
	PORT35_FN0 = 1388,
	PORT36_FN0 = 1389,
	PORT37_FN0 = 1390,
	PORT38_FN0 = 1391,
	PORT39_FN0 = 1392,
	PORT40_FN0 = 1393,
	PORT41_FN0 = 1394,
	PORT42_FN0 = 1395,
	PORT43_FN0 = 1396,
	PORT44_FN0 = 1397,
	PORT45_FN0 = 1398,
	PORT46_FN0 = 1399,
	PORT47_FN0 = 1400,
	PORT48_FN0 = 1401,
	PORT49_FN0 = 1402,
	PORT50_FN0 = 1403,
	PORT51_FN0 = 1404,
	PORT52_FN0 = 1405,
	PORT53_FN0 = 1406,
	PORT54_FN0 = 1407,
	PORT55_FN0 = 1408,
	PORT56_FN0 = 1409,
	PORT57_FN0 = 1410,
	PORT58_FN0 = 1411,
	PORT59_FN0 = 1412,
	PORT60_FN0 = 1413,
	PORT61_FN0 = 1414,
	PORT62_FN0 = 1415,
	PORT63_FN0 = 1416,
	PORT64_FN0 = 1417,
	PORT65_FN0 = 1418,
	PORT66_FN0 = 1419,
	PORT67_FN0 = 1420,
	PORT68_FN0 = 1421,
	PORT69_FN0 = 1422,
	PORT70_FN0 = 1423,
	PORT71_FN0 = 1424,
	PORT72_FN0 = 1425,
	PORT73_FN0 = 1426,
	PORT74_FN0 = 1427,
	PORT75_FN0 = 1428,
	PORT76_FN0 = 1429,
	PORT77_FN0 = 1430,
	PORT78_FN0 = 1431,
	PORT79_FN0 = 1432,
	PORT80_FN0 = 1433,
	PORT81_FN0 = 1434,
	PORT82_FN0 = 1435,
	PORT83_FN0 = 1436,
	PORT84_FN0 = 1437,
	PORT85_FN0 = 1438,
	PORT86_FN0 = 1439,
	PORT87_FN0 = 1440,
	PORT88_FN0 = 1441,
	PORT89_FN0 = 1442,
	PORT90_FN0 = 1443,
	PORT91_FN0 = 1444,
	PORT92_FN0 = 1445,
	PORT93_FN0 = 1446,
	PORT94_FN0 = 1447,
	PORT95_FN0 = 1448,
	PORT96_FN0 = 1449,
	PORT97_FN0 = 1450,
	PORT98_FN0 = 1451,
	PORT99_FN0 = 1452,
	PORT100_FN0 = 1453,
	PORT101_FN0 = 1454,
	PORT102_FN0 = 1455,
	PORT103_FN0 = 1456,
	PORT104_FN0 = 1457,
	PORT105_FN0 = 1458,
	PORT106_FN0 = 1459,
	PORT107_FN0 = 1460,
	PORT108_FN0 = 1461,
	PORT109_FN0 = 1462,
	PORT110_FN0 = 1463,
	PORT111_FN0 = 1464,
	PORT112_FN0 = 1465,
	PORT113_FN0 = 1466,
	PORT114_FN0 = 1467,
	PORT115_FN0 = 1468,
	PORT116_FN0 = 1469,
	PORT117_FN0 = 1470,
	PORT118_FN0 = 1471,
	PORT128_FN0 = 1472,
	PORT129_FN0 = 1473,
	PORT130_FN0 = 1474,
	PORT131_FN0 = 1475,
	PORT132_FN0 = 1476,
	PORT133_FN0 = 1477,
	PORT134_FN0 = 1478,
	PORT135_FN0 = 1479,
	PORT136_FN0 = 1480,
	PORT137_FN0 = 1481,
	PORT138_FN0 = 1482,
	PORT139_FN0 = 1483,
	PORT140_FN0 = 1484,
	PORT141_FN0 = 1485,
	PORT142_FN0 = 1486,
	PORT143_FN0 = 1487,
	PORT144_FN0 = 1488,
	PORT145_FN0 = 1489,
	PORT146_FN0 = 1490,
	PORT147_FN0 = 1491,
	PORT148_FN0 = 1492,
	PORT149_FN0 = 1493,
	PORT150_FN0 = 1494,
	PORT151_FN0 = 1495,
	PORT152_FN0 = 1496,
	PORT153_FN0 = 1497,
	PORT154_FN0 = 1498,
	PORT155_FN0 = 1499,
	PORT156_FN0 = 1500,
	PORT157_FN0 = 1501,
	PORT158_FN0 = 1502,
	PORT159_FN0 = 1503,
	PORT160_FN0 = 1504,
	PORT161_FN0 = 1505,
	PORT162_FN0 = 1506,
	PORT163_FN0 = 1507,
	PORT164_FN0 = 1508,
	PORT192_FN0 = 1509,
	PORT193_FN0 = 1510,
	PORT194_FN0 = 1511,
	PORT195_FN0 = 1512,
	PORT196_FN0 = 1513,
	PORT197_FN0 = 1514,
	PORT198_FN0 = 1515,
	PORT199_FN0 = 1516,
	PORT200_FN0 = 1517,
	PORT201_FN0 = 1518,
	PORT202_FN0 = 1519,
	PORT203_FN0 = 1520,
	PORT204_FN0 = 1521,
	PORT205_FN0 = 1522,
	PORT206_FN0 = 1523,
	PORT207_FN0 = 1524,
	PORT208_FN0 = 1525,
	PORT209_FN0 = 1526,
	PORT210_FN0 = 1527,
	PORT211_FN0 = 1528,
	PORT212_FN0 = 1529,
	PORT213_FN0 = 1530,
	PORT214_FN0 = 1531,
	PORT215_FN0 = 1532,
	PORT216_FN0 = 1533,
	PORT217_FN0 = 1534,
	PORT218_FN0 = 1535,
	PORT219_FN0 = 1536,
	PORT220_FN0 = 1537,
	PORT221_FN0 = 1538,
	PORT222_FN0 = 1539,
	PORT223_FN0 = 1540,
	PORT224_FN0 = 1541,
	PORT225_FN0 = 1542,
	PORT226_FN0 = 1543,
	PORT227_FN0 = 1544,
	PORT228_FN0 = 1545,
	PORT229_FN0 = 1546,
	PORT230_FN0 = 1547,
	PORT231_FN0 = 1548,
	PORT232_FN0 = 1549,
	PORT233_FN0 = 1550,
	PORT234_FN0 = 1551,
	PORT235_FN0 = 1552,
	PORT236_FN0 = 1553,
	PORT237_FN0 = 1554,
	PORT238_FN0 = 1555,
	PORT239_FN0 = 1556,
	PORT240_FN0 = 1557,
	PORT241_FN0 = 1558,
	PORT242_FN0 = 1559,
	PORT243_FN0 = 1560,
	PORT244_FN0 = 1561,
	PORT245_FN0 = 1562,
	PORT246_FN0 = 1563,
	PORT247_FN0 = 1564,
	PORT248_FN0 = 1565,
	PORT249_FN0 = 1566,
	PORT250_FN0 = 1567,
	PORT251_FN0 = 1568,
	PORT252_FN0 = 1569,
	PORT253_FN0 = 1570,
	PORT254_FN0 = 1571,
	PORT255_FN0 = 1572,
	PORT256_FN0 = 1573,
	PORT257_FN0 = 1574,
	PORT258_FN0 = 1575,
	PORT259_FN0 = 1576,
	PORT260_FN0 = 1577,
	PORT261_FN0 = 1578,
	PORT262_FN0 = 1579,
	PORT263_FN0 = 1580,
	PORT264_FN0 = 1581,
	PORT265_FN0 = 1582,
	PORT266_FN0 = 1583,
	PORT267_FN0 = 1584,
	PORT268_FN0 = 1585,
	PORT269_FN0 = 1586,
	PORT270_FN0 = 1587,
	PORT271_FN0 = 1588,
	PORT272_FN0 = 1589,
	PORT273_FN0 = 1590,
	PORT274_FN0 = 1591,
	PORT275_FN0 = 1592,
	PORT276_FN0 = 1593,
	PORT277_FN0 = 1594,
	PORT278_FN0 = 1595,
	PORT279_FN0 = 1596,
	PORT280_FN0 = 1597,
	PORT281_FN0 = 1598,
	PORT282_FN0 = 1599,
	PORT288_FN0 = 1600,
	PORT289_FN0 = 1601,
	PORT290_FN0 = 1602,
	PORT291_FN0 = 1603,
	PORT292_FN0 = 1604,
	PORT293_FN0 = 1605,
	PORT294_FN0 = 1606,
	PORT295_FN0 = 1607,
	PORT296_FN0 = 1608,
	PORT297_FN0 = 1609,
	PORT298_FN0 = 1610,
	PORT299_FN0 = 1611,
	PORT300_FN0 = 1612,
	PORT301_FN0 = 1613,
	PORT302_FN0 = 1614,
	PORT303_FN0 = 1615,
	PORT304_FN0 = 1616,
	PORT305_FN0 = 1617,
	PORT306_FN0 = 1618,
	PORT307_FN0 = 1619,
	PORT308_FN0 = 1620,
	PORT309_FN0 = 1621,
	PORT0_FN1 = 1622,
	PORT1_FN1 = 1623,
	PORT2_FN1 = 1624,
	PORT3_FN1 = 1625,
	PORT4_FN1 = 1626,
	PORT5_FN1 = 1627,
	PORT6_FN1 = 1628,
	PORT7_FN1 = 1629,
	PORT8_FN1 = 1630,
	PORT9_FN1 = 1631,
	PORT10_FN1 = 1632,
	PORT11_FN1 = 1633,
	PORT12_FN1 = 1634,
	PORT13_FN1 = 1635,
	PORT14_FN1 = 1636,
	PORT15_FN1 = 1637,
	PORT16_FN1 = 1638,
	PORT17_FN1 = 1639,
	PORT18_FN1 = 1640,
	PORT19_FN1 = 1641,
	PORT20_FN1 = 1642,
	PORT21_FN1 = 1643,
	PORT22_FN1 = 1644,
	PORT23_FN1 = 1645,
	PORT24_FN1 = 1646,
	PORT25_FN1 = 1647,
	PORT26_FN1 = 1648,
	PORT27_FN1 = 1649,
	PORT28_FN1 = 1650,
	PORT29_FN1 = 1651,
	PORT30_FN1 = 1652,
	PORT31_FN1 = 1653,
	PORT32_FN1 = 1654,
	PORT33_FN1 = 1655,
	PORT34_FN1 = 1656,
	PORT35_FN1 = 1657,
	PORT36_FN1 = 1658,
	PORT37_FN1 = 1659,
	PORT38_FN1 = 1660,
	PORT39_FN1 = 1661,
	PORT40_FN1 = 1662,
	PORT41_FN1 = 1663,
	PORT42_FN1 = 1664,
	PORT43_FN1 = 1665,
	PORT44_FN1 = 1666,
	PORT45_FN1 = 1667,
	PORT46_FN1 = 1668,
	PORT47_FN1 = 1669,
	PORT48_FN1 = 1670,
	PORT49_FN1 = 1671,
	PORT50_FN1 = 1672,
	PORT51_FN1 = 1673,
	PORT52_FN1 = 1674,
	PORT53_FN1 = 1675,
	PORT54_FN1 = 1676,
	PORT55_FN1 = 1677,
	PORT56_FN1 = 1678,
	PORT57_FN1 = 1679,
	PORT58_FN1 = 1680,
	PORT59_FN1 = 1681,
	PORT60_FN1 = 1682,
	PORT61_FN1 = 1683,
	PORT62_FN1 = 1684,
	PORT63_FN1 = 1685,
	PORT64_FN1 = 1686,
	PORT65_FN1 = 1687,
	PORT66_FN1 = 1688,
	PORT67_FN1 = 1689,
	PORT68_FN1 = 1690,
	PORT69_FN1 = 1691,
	PORT70_FN1 = 1692,
	PORT71_FN1 = 1693,
	PORT72_FN1 = 1694,
	PORT73_FN1 = 1695,
	PORT74_FN1 = 1696,
	PORT75_FN1 = 1697,
	PORT76_FN1 = 1698,
	PORT77_FN1 = 1699,
	PORT78_FN1 = 1700,
	PORT79_FN1 = 1701,
	PORT80_FN1 = 1702,
	PORT81_FN1 = 1703,
	PORT82_FN1 = 1704,
	PORT83_FN1 = 1705,
	PORT84_FN1 = 1706,
	PORT85_FN1 = 1707,
	PORT86_FN1 = 1708,
	PORT87_FN1 = 1709,
	PORT88_FN1 = 1710,
	PORT89_FN1 = 1711,
	PORT90_FN1 = 1712,
	PORT91_FN1 = 1713,
	PORT92_FN1 = 1714,
	PORT93_FN1 = 1715,
	PORT94_FN1 = 1716,
	PORT95_FN1 = 1717,
	PORT96_FN1 = 1718,
	PORT97_FN1 = 1719,
	PORT98_FN1 = 1720,
	PORT99_FN1 = 1721,
	PORT100_FN1 = 1722,
	PORT101_FN1 = 1723,
	PORT102_FN1 = 1724,
	PORT103_FN1 = 1725,
	PORT104_FN1 = 1726,
	PORT105_FN1 = 1727,
	PORT106_FN1 = 1728,
	PORT107_FN1 = 1729,
	PORT108_FN1 = 1730,
	PORT109_FN1 = 1731,
	PORT110_FN1 = 1732,
	PORT111_FN1 = 1733,
	PORT112_FN1 = 1734,
	PORT113_FN1 = 1735,
	PORT114_FN1 = 1736,
	PORT115_FN1 = 1737,
	PORT116_FN1 = 1738,
	PORT117_FN1 = 1739,
	PORT118_FN1 = 1740,
	PORT128_FN1 = 1741,
	PORT129_FN1 = 1742,
	PORT130_FN1 = 1743,
	PORT131_FN1 = 1744,
	PORT132_FN1 = 1745,
	PORT133_FN1 = 1746,
	PORT134_FN1 = 1747,
	PORT135_FN1 = 1748,
	PORT136_FN1 = 1749,
	PORT137_FN1 = 1750,
	PORT138_FN1 = 1751,
	PORT139_FN1 = 1752,
	PORT140_FN1 = 1753,
	PORT141_FN1 = 1754,
	PORT142_FN1 = 1755,
	PORT143_FN1 = 1756,
	PORT144_FN1 = 1757,
	PORT145_FN1 = 1758,
	PORT146_FN1 = 1759,
	PORT147_FN1 = 1760,
	PORT148_FN1 = 1761,
	PORT149_FN1 = 1762,
	PORT150_FN1 = 1763,
	PORT151_FN1 = 1764,
	PORT152_FN1 = 1765,
	PORT153_FN1 = 1766,
	PORT154_FN1 = 1767,
	PORT155_FN1 = 1768,
	PORT156_FN1 = 1769,
	PORT157_FN1 = 1770,
	PORT158_FN1 = 1771,
	PORT159_FN1 = 1772,
	PORT160_FN1 = 1773,
	PORT161_FN1 = 1774,
	PORT162_FN1 = 1775,
	PORT163_FN1 = 1776,
	PORT164_FN1 = 1777,
	PORT192_FN1 = 1778,
	PORT193_FN1 = 1779,
	PORT194_FN1 = 1780,
	PORT195_FN1 = 1781,
	PORT196_FN1 = 1782,
	PORT197_FN1 = 1783,
	PORT198_FN1 = 1784,
	PORT199_FN1 = 1785,
	PORT200_FN1 = 1786,
	PORT201_FN1 = 1787,
	PORT202_FN1 = 1788,
	PORT203_FN1 = 1789,
	PORT204_FN1 = 1790,
	PORT205_FN1 = 1791,
	PORT206_FN1 = 1792,
	PORT207_FN1 = 1793,
	PORT208_FN1 = 1794,
	PORT209_FN1 = 1795,
	PORT210_FN1 = 1796,
	PORT211_FN1 = 1797,
	PORT212_FN1 = 1798,
	PORT213_FN1 = 1799,
	PORT214_FN1 = 1800,
	PORT215_FN1 = 1801,
	PORT216_FN1 = 1802,
	PORT217_FN1 = 1803,
	PORT218_FN1 = 1804,
	PORT219_FN1 = 1805,
	PORT220_FN1 = 1806,
	PORT221_FN1 = 1807,
	PORT222_FN1 = 1808,
	PORT223_FN1 = 1809,
	PORT224_FN1 = 1810,
	PORT225_FN1 = 1811,
	PORT226_FN1 = 1812,
	PORT227_FN1 = 1813,
	PORT228_FN1 = 1814,
	PORT229_FN1 = 1815,
	PORT230_FN1 = 1816,
	PORT231_FN1 = 1817,
	PORT232_FN1 = 1818,
	PORT233_FN1 = 1819,
	PORT234_FN1 = 1820,
	PORT235_FN1 = 1821,
	PORT236_FN1 = 1822,
	PORT237_FN1 = 1823,
	PORT238_FN1 = 1824,
	PORT239_FN1 = 1825,
	PORT240_FN1 = 1826,
	PORT241_FN1 = 1827,
	PORT242_FN1 = 1828,
	PORT243_FN1 = 1829,
	PORT244_FN1 = 1830,
	PORT245_FN1 = 1831,
	PORT246_FN1 = 1832,
	PORT247_FN1 = 1833,
	PORT248_FN1 = 1834,
	PORT249_FN1 = 1835,
	PORT250_FN1 = 1836,
	PORT251_FN1 = 1837,
	PORT252_FN1 = 1838,
	PORT253_FN1 = 1839,
	PORT254_FN1 = 1840,
	PORT255_FN1 = 1841,
	PORT256_FN1 = 1842,
	PORT257_FN1 = 1843,
	PORT258_FN1 = 1844,
	PORT259_FN1 = 1845,
	PORT260_FN1 = 1846,
	PORT261_FN1 = 1847,
	PORT262_FN1 = 1848,
	PORT263_FN1 = 1849,
	PORT264_FN1 = 1850,
	PORT265_FN1 = 1851,
	PORT266_FN1 = 1852,
	PORT267_FN1 = 1853,
	PORT268_FN1 = 1854,
	PORT269_FN1 = 1855,
	PORT270_FN1 = 1856,
	PORT271_FN1 = 1857,
	PORT272_FN1 = 1858,
	PORT273_FN1 = 1859,
	PORT274_FN1 = 1860,
	PORT275_FN1 = 1861,
	PORT276_FN1 = 1862,
	PORT277_FN1 = 1863,
	PORT278_FN1 = 1864,
	PORT279_FN1 = 1865,
	PORT280_FN1 = 1866,
	PORT281_FN1 = 1867,
	PORT282_FN1 = 1868,
	PORT288_FN1 = 1869,
	PORT289_FN1 = 1870,
	PORT290_FN1 = 1871,
	PORT291_FN1 = 1872,
	PORT292_FN1 = 1873,
	PORT293_FN1 = 1874,
	PORT294_FN1 = 1875,
	PORT295_FN1 = 1876,
	PORT296_FN1 = 1877,
	PORT297_FN1 = 1878,
	PORT298_FN1 = 1879,
	PORT299_FN1 = 1880,
	PORT300_FN1 = 1881,
	PORT301_FN1 = 1882,
	PORT302_FN1 = 1883,
	PORT303_FN1 = 1884,
	PORT304_FN1 = 1885,
	PORT305_FN1 = 1886,
	PORT306_FN1 = 1887,
	PORT307_FN1 = 1888,
	PORT308_FN1 = 1889,
	PORT309_FN1 = 1890,
	PORT0_FN2 = 1891,
	PORT1_FN2 = 1892,
	PORT2_FN2 = 1893,
	PORT3_FN2 = 1894,
	PORT4_FN2 = 1895,
	PORT5_FN2 = 1896,
	PORT6_FN2 = 1897,
	PORT7_FN2 = 1898,
	PORT8_FN2 = 1899,
	PORT9_FN2 = 1900,
	PORT10_FN2 = 1901,
	PORT11_FN2 = 1902,
	PORT12_FN2 = 1903,
	PORT13_FN2 = 1904,
	PORT14_FN2 = 1905,
	PORT15_FN2 = 1906,
	PORT16_FN2 = 1907,
	PORT17_FN2 = 1908,
	PORT18_FN2 = 1909,
	PORT19_FN2 = 1910,
	PORT20_FN2 = 1911,
	PORT21_FN2 = 1912,
	PORT22_FN2 = 1913,
	PORT23_FN2 = 1914,
	PORT24_FN2 = 1915,
	PORT25_FN2 = 1916,
	PORT26_FN2 = 1917,
	PORT27_FN2 = 1918,
	PORT28_FN2 = 1919,
	PORT29_FN2 = 1920,
	PORT30_FN2 = 1921,
	PORT31_FN2 = 1922,
	PORT32_FN2 = 1923,
	PORT33_FN2 = 1924,
	PORT34_FN2 = 1925,
	PORT35_FN2 = 1926,
	PORT36_FN2 = 1927,
	PORT37_FN2 = 1928,
	PORT38_FN2 = 1929,
	PORT39_FN2 = 1930,
	PORT40_FN2 = 1931,
	PORT41_FN2 = 1932,
	PORT42_FN2 = 1933,
	PORT43_FN2 = 1934,
	PORT44_FN2 = 1935,
	PORT45_FN2 = 1936,
	PORT46_FN2 = 1937,
	PORT47_FN2 = 1938,
	PORT48_FN2 = 1939,
	PORT49_FN2 = 1940,
	PORT50_FN2 = 1941,
	PORT51_FN2 = 1942,
	PORT52_FN2 = 1943,
	PORT53_FN2 = 1944,
	PORT54_FN2 = 1945,
	PORT55_FN2 = 1946,
	PORT56_FN2 = 1947,
	PORT57_FN2 = 1948,
	PORT58_FN2 = 1949,
	PORT59_FN2 = 1950,
	PORT60_FN2 = 1951,
	PORT61_FN2 = 1952,
	PORT62_FN2 = 1953,
	PORT63_FN2 = 1954,
	PORT64_FN2 = 1955,
	PORT65_FN2 = 1956,
	PORT66_FN2 = 1957,
	PORT67_FN2 = 1958,
	PORT68_FN2 = 1959,
	PORT69_FN2 = 1960,
	PORT70_FN2 = 1961,
	PORT71_FN2 = 1962,
	PORT72_FN2 = 1963,
	PORT73_FN2 = 1964,
	PORT74_FN2 = 1965,
	PORT75_FN2 = 1966,
	PORT76_FN2 = 1967,
	PORT77_FN2 = 1968,
	PORT78_FN2 = 1969,
	PORT79_FN2 = 1970,
	PORT80_FN2 = 1971,
	PORT81_FN2 = 1972,
	PORT82_FN2 = 1973,
	PORT83_FN2 = 1974,
	PORT84_FN2 = 1975,
	PORT85_FN2 = 1976,
	PORT86_FN2 = 1977,
	PORT87_FN2 = 1978,
	PORT88_FN2 = 1979,
	PORT89_FN2 = 1980,
	PORT90_FN2 = 1981,
	PORT91_FN2 = 1982,
	PORT92_FN2 = 1983,
	PORT93_FN2 = 1984,
	PORT94_FN2 = 1985,
	PORT95_FN2 = 1986,
	PORT96_FN2 = 1987,
	PORT97_FN2 = 1988,
	PORT98_FN2 = 1989,
	PORT99_FN2 = 1990,
	PORT100_FN2 = 1991,
	PORT101_FN2 = 1992,
	PORT102_FN2 = 1993,
	PORT103_FN2 = 1994,
	PORT104_FN2 = 1995,
	PORT105_FN2 = 1996,
	PORT106_FN2 = 1997,
	PORT107_FN2 = 1998,
	PORT108_FN2 = 1999,
	PORT109_FN2 = 2000,
	PORT110_FN2 = 2001,
	PORT111_FN2 = 2002,
	PORT112_FN2 = 2003,
	PORT113_FN2 = 2004,
	PORT114_FN2 = 2005,
	PORT115_FN2 = 2006,
	PORT116_FN2 = 2007,
	PORT117_FN2 = 2008,
	PORT118_FN2 = 2009,
	PORT128_FN2 = 2010,
	PORT129_FN2 = 2011,
	PORT130_FN2 = 2012,
	PORT131_FN2 = 2013,
	PORT132_FN2 = 2014,
	PORT133_FN2 = 2015,
	PORT134_FN2 = 2016,
	PORT135_FN2 = 2017,
	PORT136_FN2 = 2018,
	PORT137_FN2 = 2019,
	PORT138_FN2 = 2020,
	PORT139_FN2 = 2021,
	PORT140_FN2 = 2022,
	PORT141_FN2 = 2023,
	PORT142_FN2 = 2024,
	PORT143_FN2 = 2025,
	PORT144_FN2 = 2026,
	PORT145_FN2 = 2027,
	PORT146_FN2 = 2028,
	PORT147_FN2 = 2029,
	PORT148_FN2 = 2030,
	PORT149_FN2 = 2031,
	PORT150_FN2 = 2032,
	PORT151_FN2 = 2033,
	PORT152_FN2 = 2034,
	PORT153_FN2 = 2035,
	PORT154_FN2 = 2036,
	PORT155_FN2 = 2037,
	PORT156_FN2 = 2038,
	PORT157_FN2 = 2039,
	PORT158_FN2 = 2040,
	PORT159_FN2 = 2041,
	PORT160_FN2 = 2042,
	PORT161_FN2 = 2043,
	PORT162_FN2 = 2044,
	PORT163_FN2 = 2045,
	PORT164_FN2 = 2046,
	PORT192_FN2 = 2047,
	PORT193_FN2 = 2048,
	PORT194_FN2 = 2049,
	PORT195_FN2 = 2050,
	PORT196_FN2 = 2051,
	PORT197_FN2 = 2052,
	PORT198_FN2 = 2053,
	PORT199_FN2 = 2054,
	PORT200_FN2 = 2055,
	PORT201_FN2 = 2056,
	PORT202_FN2 = 2057,
	PORT203_FN2 = 2058,
	PORT204_FN2 = 2059,
	PORT205_FN2 = 2060,
	PORT206_FN2 = 2061,
	PORT207_FN2 = 2062,
	PORT208_FN2 = 2063,
	PORT209_FN2 = 2064,
	PORT210_FN2 = 2065,
	PORT211_FN2 = 2066,
	PORT212_FN2 = 2067,
	PORT213_FN2 = 2068,
	PORT214_FN2 = 2069,
	PORT215_FN2 = 2070,
	PORT216_FN2 = 2071,
	PORT217_FN2 = 2072,
	PORT218_FN2 = 2073,
	PORT219_FN2 = 2074,
	PORT220_FN2 = 2075,
	PORT221_FN2 = 2076,
	PORT222_FN2 = 2077,
	PORT223_FN2 = 2078,
	PORT224_FN2 = 2079,
	PORT225_FN2 = 2080,
	PORT226_FN2 = 2081,
	PORT227_FN2 = 2082,
	PORT228_FN2 = 2083,
	PORT229_FN2 = 2084,
	PORT230_FN2 = 2085,
	PORT231_FN2 = 2086,
	PORT232_FN2 = 2087,
	PORT233_FN2 = 2088,
	PORT234_FN2 = 2089,
	PORT235_FN2 = 2090,
	PORT236_FN2 = 2091,
	PORT237_FN2 = 2092,
	PORT238_FN2 = 2093,
	PORT239_FN2 = 2094,
	PORT240_FN2 = 2095,
	PORT241_FN2 = 2096,
	PORT242_FN2 = 2097,
	PORT243_FN2 = 2098,
	PORT244_FN2 = 2099,
	PORT245_FN2 = 2100,
	PORT246_FN2 = 2101,
	PORT247_FN2 = 2102,
	PORT248_FN2 = 2103,
	PORT249_FN2 = 2104,
	PORT250_FN2 = 2105,
	PORT251_FN2 = 2106,
	PORT252_FN2 = 2107,
	PORT253_FN2 = 2108,
	PORT254_FN2 = 2109,
	PORT255_FN2 = 2110,
	PORT256_FN2 = 2111,
	PORT257_FN2 = 2112,
	PORT258_FN2 = 2113,
	PORT259_FN2 = 2114,
	PORT260_FN2 = 2115,
	PORT261_FN2 = 2116,
	PORT262_FN2 = 2117,
	PORT263_FN2 = 2118,
	PORT264_FN2 = 2119,
	PORT265_FN2 = 2120,
	PORT266_FN2 = 2121,
	PORT267_FN2 = 2122,
	PORT268_FN2 = 2123,
	PORT269_FN2 = 2124,
	PORT270_FN2 = 2125,
	PORT271_FN2 = 2126,
	PORT272_FN2 = 2127,
	PORT273_FN2 = 2128,
	PORT274_FN2 = 2129,
	PORT275_FN2 = 2130,
	PORT276_FN2 = 2131,
	PORT277_FN2 = 2132,
	PORT278_FN2 = 2133,
	PORT279_FN2 = 2134,
	PORT280_FN2 = 2135,
	PORT281_FN2 = 2136,
	PORT282_FN2 = 2137,
	PORT288_FN2 = 2138,
	PORT289_FN2 = 2139,
	PORT290_FN2 = 2140,
	PORT291_FN2 = 2141,
	PORT292_FN2 = 2142,
	PORT293_FN2 = 2143,
	PORT294_FN2 = 2144,
	PORT295_FN2 = 2145,
	PORT296_FN2 = 2146,
	PORT297_FN2 = 2147,
	PORT298_FN2 = 2148,
	PORT299_FN2 = 2149,
	PORT300_FN2 = 2150,
	PORT301_FN2 = 2151,
	PORT302_FN2 = 2152,
	PORT303_FN2 = 2153,
	PORT304_FN2 = 2154,
	PORT305_FN2 = 2155,
	PORT306_FN2 = 2156,
	PORT307_FN2 = 2157,
	PORT308_FN2 = 2158,
	PORT309_FN2 = 2159,
	PORT0_FN3 = 2160,
	PORT1_FN3 = 2161,
	PORT2_FN3 = 2162,
	PORT3_FN3 = 2163,
	PORT4_FN3 = 2164,
	PORT5_FN3 = 2165,
	PORT6_FN3 = 2166,
	PORT7_FN3 = 2167,
	PORT8_FN3 = 2168,
	PORT9_FN3 = 2169,
	PORT10_FN3 = 2170,
	PORT11_FN3 = 2171,
	PORT12_FN3 = 2172,
	PORT13_FN3 = 2173,
	PORT14_FN3 = 2174,
	PORT15_FN3 = 2175,
	PORT16_FN3 = 2176,
	PORT17_FN3 = 2177,
	PORT18_FN3 = 2178,
	PORT19_FN3 = 2179,
	PORT20_FN3 = 2180,
	PORT21_FN3 = 2181,
	PORT22_FN3 = 2182,
	PORT23_FN3 = 2183,
	PORT24_FN3 = 2184,
	PORT25_FN3 = 2185,
	PORT26_FN3 = 2186,
	PORT27_FN3 = 2187,
	PORT28_FN3 = 2188,
	PORT29_FN3 = 2189,
	PORT30_FN3 = 2190,
	PORT31_FN3 = 2191,
	PORT32_FN3 = 2192,
	PORT33_FN3 = 2193,
	PORT34_FN3 = 2194,
	PORT35_FN3 = 2195,
	PORT36_FN3 = 2196,
	PORT37_FN3 = 2197,
	PORT38_FN3 = 2198,
	PORT39_FN3 = 2199,
	PORT40_FN3 = 2200,
	PORT41_FN3 = 2201,
	PORT42_FN3 = 2202,
	PORT43_FN3 = 2203,
	PORT44_FN3 = 2204,
	PORT45_FN3 = 2205,
	PORT46_FN3 = 2206,
	PORT47_FN3 = 2207,
	PORT48_FN3 = 2208,
	PORT49_FN3 = 2209,
	PORT50_FN3 = 2210,
	PORT51_FN3 = 2211,
	PORT52_FN3 = 2212,
	PORT53_FN3 = 2213,
	PORT54_FN3 = 2214,
	PORT55_FN3 = 2215,
	PORT56_FN3 = 2216,
	PORT57_FN3 = 2217,
	PORT58_FN3 = 2218,
	PORT59_FN3 = 2219,
	PORT60_FN3 = 2220,
	PORT61_FN3 = 2221,
	PORT62_FN3 = 2222,
	PORT63_FN3 = 2223,
	PORT64_FN3 = 2224,
	PORT65_FN3 = 2225,
	PORT66_FN3 = 2226,
	PORT67_FN3 = 2227,
	PORT68_FN3 = 2228,
	PORT69_FN3 = 2229,
	PORT70_FN3 = 2230,
	PORT71_FN3 = 2231,
	PORT72_FN3 = 2232,
	PORT73_FN3 = 2233,
	PORT74_FN3 = 2234,
	PORT75_FN3 = 2235,
	PORT76_FN3 = 2236,
	PORT77_FN3 = 2237,
	PORT78_FN3 = 2238,
	PORT79_FN3 = 2239,
	PORT80_FN3 = 2240,
	PORT81_FN3 = 2241,
	PORT82_FN3 = 2242,
	PORT83_FN3 = 2243,
	PORT84_FN3 = 2244,
	PORT85_FN3 = 2245,
	PORT86_FN3 = 2246,
	PORT87_FN3 = 2247,
	PORT88_FN3 = 2248,
	PORT89_FN3 = 2249,
	PORT90_FN3 = 2250,
	PORT91_FN3 = 2251,
	PORT92_FN3 = 2252,
	PORT93_FN3 = 2253,
	PORT94_FN3 = 2254,
	PORT95_FN3 = 2255,
	PORT96_FN3 = 2256,
	PORT97_FN3 = 2257,
	PORT98_FN3 = 2258,
	PORT99_FN3 = 2259,
	PORT100_FN3 = 2260,
	PORT101_FN3 = 2261,
	PORT102_FN3 = 2262,
	PORT103_FN3 = 2263,
	PORT104_FN3 = 2264,
	PORT105_FN3 = 2265,
	PORT106_FN3 = 2266,
	PORT107_FN3 = 2267,
	PORT108_FN3 = 2268,
	PORT109_FN3 = 2269,
	PORT110_FN3 = 2270,
	PORT111_FN3 = 2271,
	PORT112_FN3 = 2272,
	PORT113_FN3 = 2273,
	PORT114_FN3 = 2274,
	PORT115_FN3 = 2275,
	PORT116_FN3 = 2276,
	PORT117_FN3 = 2277,
	PORT118_FN3 = 2278,
	PORT128_FN3 = 2279,
	PORT129_FN3 = 2280,
	PORT130_FN3 = 2281,
	PORT131_FN3 = 2282,
	PORT132_FN3 = 2283,
	PORT133_FN3 = 2284,
	PORT134_FN3 = 2285,
	PORT135_FN3 = 2286,
	PORT136_FN3 = 2287,
	PORT137_FN3 = 2288,
	PORT138_FN3 = 2289,
	PORT139_FN3 = 2290,
	PORT140_FN3 = 2291,
	PORT141_FN3 = 2292,
	PORT142_FN3 = 2293,
	PORT143_FN3 = 2294,
	PORT144_FN3 = 2295,
	PORT145_FN3 = 2296,
	PORT146_FN3 = 2297,
	PORT147_FN3 = 2298,
	PORT148_FN3 = 2299,
	PORT149_FN3 = 2300,
	PORT150_FN3 = 2301,
	PORT151_FN3 = 2302,
	PORT152_FN3 = 2303,
	PORT153_FN3 = 2304,
	PORT154_FN3 = 2305,
	PORT155_FN3 = 2306,
	PORT156_FN3 = 2307,
	PORT157_FN3 = 2308,
	PORT158_FN3 = 2309,
	PORT159_FN3 = 2310,
	PORT160_FN3 = 2311,
	PORT161_FN3 = 2312,
	PORT162_FN3 = 2313,
	PORT163_FN3 = 2314,
	PORT164_FN3 = 2315,
	PORT192_FN3 = 2316,
	PORT193_FN3 = 2317,
	PORT194_FN3 = 2318,
	PORT195_FN3 = 2319,
	PORT196_FN3 = 2320,
	PORT197_FN3 = 2321,
	PORT198_FN3 = 2322,
	PORT199_FN3 = 2323,
	PORT200_FN3 = 2324,
	PORT201_FN3 = 2325,
	PORT202_FN3 = 2326,
	PORT203_FN3 = 2327,
	PORT204_FN3 = 2328,
	PORT205_FN3 = 2329,
	PORT206_FN3 = 2330,
	PORT207_FN3 = 2331,
	PORT208_FN3 = 2332,
	PORT209_FN3 = 2333,
	PORT210_FN3 = 2334,
	PORT211_FN3 = 2335,
	PORT212_FN3 = 2336,
	PORT213_FN3 = 2337,
	PORT214_FN3 = 2338,
	PORT215_FN3 = 2339,
	PORT216_FN3 = 2340,
	PORT217_FN3 = 2341,
	PORT218_FN3 = 2342,
	PORT219_FN3 = 2343,
	PORT220_FN3 = 2344,
	PORT221_FN3 = 2345,
	PORT222_FN3 = 2346,
	PORT223_FN3 = 2347,
	PORT224_FN3 = 2348,
	PORT225_FN3 = 2349,
	PORT226_FN3 = 2350,
	PORT227_FN3 = 2351,
	PORT228_FN3 = 2352,
	PORT229_FN3 = 2353,
	PORT230_FN3 = 2354,
	PORT231_FN3 = 2355,
	PORT232_FN3 = 2356,
	PORT233_FN3 = 2357,
	PORT234_FN3 = 2358,
	PORT235_FN3 = 2359,
	PORT236_FN3 = 2360,
	PORT237_FN3 = 2361,
	PORT238_FN3 = 2362,
	PORT239_FN3 = 2363,
	PORT240_FN3 = 2364,
	PORT241_FN3 = 2365,
	PORT242_FN3 = 2366,
	PORT243_FN3 = 2367,
	PORT244_FN3 = 2368,
	PORT245_FN3 = 2369,
	PORT246_FN3 = 2370,
	PORT247_FN3 = 2371,
	PORT248_FN3 = 2372,
	PORT249_FN3 = 2373,
	PORT250_FN3 = 2374,
	PORT251_FN3 = 2375,
	PORT252_FN3 = 2376,
	PORT253_FN3 = 2377,
	PORT254_FN3 = 2378,
	PORT255_FN3 = 2379,
	PORT256_FN3 = 2380,
	PORT257_FN3 = 2381,
	PORT258_FN3 = 2382,
	PORT259_FN3 = 2383,
	PORT260_FN3 = 2384,
	PORT261_FN3 = 2385,
	PORT262_FN3 = 2386,
	PORT263_FN3 = 2387,
	PORT264_FN3 = 2388,
	PORT265_FN3 = 2389,
	PORT266_FN3 = 2390,
	PORT267_FN3 = 2391,
	PORT268_FN3 = 2392,
	PORT269_FN3 = 2393,
	PORT270_FN3 = 2394,
	PORT271_FN3 = 2395,
	PORT272_FN3 = 2396,
	PORT273_FN3 = 2397,
	PORT274_FN3 = 2398,
	PORT275_FN3 = 2399,
	PORT276_FN3 = 2400,
	PORT277_FN3 = 2401,
	PORT278_FN3 = 2402,
	PORT279_FN3 = 2403,
	PORT280_FN3 = 2404,
	PORT281_FN3 = 2405,
	PORT282_FN3 = 2406,
	PORT288_FN3 = 2407,
	PORT289_FN3 = 2408,
	PORT290_FN3 = 2409,
	PORT291_FN3 = 2410,
	PORT292_FN3 = 2411,
	PORT293_FN3 = 2412,
	PORT294_FN3 = 2413,
	PORT295_FN3 = 2414,
	PORT296_FN3 = 2415,
	PORT297_FN3 = 2416,
	PORT298_FN3 = 2417,
	PORT299_FN3 = 2418,
	PORT300_FN3 = 2419,
	PORT301_FN3 = 2420,
	PORT302_FN3 = 2421,
	PORT303_FN3 = 2422,
	PORT304_FN3 = 2423,
	PORT305_FN3 = 2424,
	PORT306_FN3 = 2425,
	PORT307_FN3 = 2426,
	PORT308_FN3 = 2427,
	PORT309_FN3 = 2428,
	PORT0_FN4 = 2429,
	PORT1_FN4 = 2430,
	PORT2_FN4 = 2431,
	PORT3_FN4 = 2432,
	PORT4_FN4 = 2433,
	PORT5_FN4 = 2434,
	PORT6_FN4 = 2435,
	PORT7_FN4 = 2436,
	PORT8_FN4 = 2437,
	PORT9_FN4 = 2438,
	PORT10_FN4 = 2439,
	PORT11_FN4 = 2440,
	PORT12_FN4 = 2441,
	PORT13_FN4 = 2442,
	PORT14_FN4 = 2443,
	PORT15_FN4 = 2444,
	PORT16_FN4 = 2445,
	PORT17_FN4 = 2446,
	PORT18_FN4 = 2447,
	PORT19_FN4 = 2448,
	PORT20_FN4 = 2449,
	PORT21_FN4 = 2450,
	PORT22_FN4 = 2451,
	PORT23_FN4 = 2452,
	PORT24_FN4 = 2453,
	PORT25_FN4 = 2454,
	PORT26_FN4 = 2455,
	PORT27_FN4 = 2456,
	PORT28_FN4 = 2457,
	PORT29_FN4 = 2458,
	PORT30_FN4 = 2459,
	PORT31_FN4 = 2460,
	PORT32_FN4 = 2461,
	PORT33_FN4 = 2462,
	PORT34_FN4 = 2463,
	PORT35_FN4 = 2464,
	PORT36_FN4 = 2465,
	PORT37_FN4 = 2466,
	PORT38_FN4 = 2467,
	PORT39_FN4 = 2468,
	PORT40_FN4 = 2469,
	PORT41_FN4 = 2470,
	PORT42_FN4 = 2471,
	PORT43_FN4 = 2472,
	PORT44_FN4 = 2473,
	PORT45_FN4 = 2474,
	PORT46_FN4 = 2475,
	PORT47_FN4 = 2476,
	PORT48_FN4 = 2477,
	PORT49_FN4 = 2478,
	PORT50_FN4 = 2479,
	PORT51_FN4 = 2480,
	PORT52_FN4 = 2481,
	PORT53_FN4 = 2482,
	PORT54_FN4 = 2483,
	PORT55_FN4 = 2484,
	PORT56_FN4 = 2485,
	PORT57_FN4 = 2486,
	PORT58_FN4 = 2487,
	PORT59_FN4 = 2488,
	PORT60_FN4 = 2489,
	PORT61_FN4 = 2490,
	PORT62_FN4 = 2491,
	PORT63_FN4 = 2492,
	PORT64_FN4 = 2493,
	PORT65_FN4 = 2494,
	PORT66_FN4 = 2495,
	PORT67_FN4 = 2496,
	PORT68_FN4 = 2497,
	PORT69_FN4 = 2498,
	PORT70_FN4 = 2499,
	PORT71_FN4 = 2500,
	PORT72_FN4 = 2501,
	PORT73_FN4 = 2502,
	PORT74_FN4 = 2503,
	PORT75_FN4 = 2504,
	PORT76_FN4 = 2505,
	PORT77_FN4 = 2506,
	PORT78_FN4 = 2507,
	PORT79_FN4 = 2508,
	PORT80_FN4 = 2509,
	PORT81_FN4 = 2510,
	PORT82_FN4 = 2511,
	PORT83_FN4 = 2512,
	PORT84_FN4 = 2513,
	PORT85_FN4 = 2514,
	PORT86_FN4 = 2515,
	PORT87_FN4 = 2516,
	PORT88_FN4 = 2517,
	PORT89_FN4 = 2518,
	PORT90_FN4 = 2519,
	PORT91_FN4 = 2520,
	PORT92_FN4 = 2521,
	PORT93_FN4 = 2522,
	PORT94_FN4 = 2523,
	PORT95_FN4 = 2524,
	PORT96_FN4 = 2525,
	PORT97_FN4 = 2526,
	PORT98_FN4 = 2527,
	PORT99_FN4 = 2528,
	PORT100_FN4 = 2529,
	PORT101_FN4 = 2530,
	PORT102_FN4 = 2531,
	PORT103_FN4 = 2532,
	PORT104_FN4 = 2533,
	PORT105_FN4 = 2534,
	PORT106_FN4 = 2535,
	PORT107_FN4 = 2536,
	PORT108_FN4 = 2537,
	PORT109_FN4 = 2538,
	PORT110_FN4 = 2539,
	PORT111_FN4 = 2540,
	PORT112_FN4 = 2541,
	PORT113_FN4 = 2542,
	PORT114_FN4 = 2543,
	PORT115_FN4 = 2544,
	PORT116_FN4 = 2545,
	PORT117_FN4 = 2546,
	PORT118_FN4 = 2547,
	PORT128_FN4 = 2548,
	PORT129_FN4 = 2549,
	PORT130_FN4 = 2550,
	PORT131_FN4 = 2551,
	PORT132_FN4 = 2552,
	PORT133_FN4 = 2553,
	PORT134_FN4 = 2554,
	PORT135_FN4 = 2555,
	PORT136_FN4 = 2556,
	PORT137_FN4 = 2557,
	PORT138_FN4 = 2558,
	PORT139_FN4 = 2559,
	PORT140_FN4 = 2560,
	PORT141_FN4 = 2561,
	PORT142_FN4 = 2562,
	PORT143_FN4 = 2563,
	PORT144_FN4 = 2564,
	PORT145_FN4 = 2565,
	PORT146_FN4 = 2566,
	PORT147_FN4 = 2567,
	PORT148_FN4 = 2568,
	PORT149_FN4 = 2569,
	PORT150_FN4 = 2570,
	PORT151_FN4 = 2571,
	PORT152_FN4 = 2572,
	PORT153_FN4 = 2573,
	PORT154_FN4 = 2574,
	PORT155_FN4 = 2575,
	PORT156_FN4 = 2576,
	PORT157_FN4 = 2577,
	PORT158_FN4 = 2578,
	PORT159_FN4 = 2579,
	PORT160_FN4 = 2580,
	PORT161_FN4 = 2581,
	PORT162_FN4 = 2582,
	PORT163_FN4 = 2583,
	PORT164_FN4 = 2584,
	PORT192_FN4 = 2585,
	PORT193_FN4 = 2586,
	PORT194_FN4 = 2587,
	PORT195_FN4 = 2588,
	PORT196_FN4 = 2589,
	PORT197_FN4 = 2590,
	PORT198_FN4 = 2591,
	PORT199_FN4 = 2592,
	PORT200_FN4 = 2593,
	PORT201_FN4 = 2594,
	PORT202_FN4 = 2595,
	PORT203_FN4 = 2596,
	PORT204_FN4 = 2597,
	PORT205_FN4 = 2598,
	PORT206_FN4 = 2599,
	PORT207_FN4 = 2600,
	PORT208_FN4 = 2601,
	PORT209_FN4 = 2602,
	PORT210_FN4 = 2603,
	PORT211_FN4 = 2604,
	PORT212_FN4 = 2605,
	PORT213_FN4 = 2606,
	PORT214_FN4 = 2607,
	PORT215_FN4 = 2608,
	PORT216_FN4 = 2609,
	PORT217_FN4 = 2610,
	PORT218_FN4 = 2611,
	PORT219_FN4 = 2612,
	PORT220_FN4 = 2613,
	PORT221_FN4 = 2614,
	PORT222_FN4 = 2615,
	PORT223_FN4 = 2616,
	PORT224_FN4 = 2617,
	PORT225_FN4 = 2618,
	PORT226_FN4 = 2619,
	PORT227_FN4 = 2620,
	PORT228_FN4 = 2621,
	PORT229_FN4 = 2622,
	PORT230_FN4 = 2623,
	PORT231_FN4 = 2624,
	PORT232_FN4 = 2625,
	PORT233_FN4 = 2626,
	PORT234_FN4 = 2627,
	PORT235_FN4 = 2628,
	PORT236_FN4 = 2629,
	PORT237_FN4 = 2630,
	PORT238_FN4 = 2631,
	PORT239_FN4 = 2632,
	PORT240_FN4 = 2633,
	PORT241_FN4 = 2634,
	PORT242_FN4 = 2635,
	PORT243_FN4 = 2636,
	PORT244_FN4 = 2637,
	PORT245_FN4 = 2638,
	PORT246_FN4 = 2639,
	PORT247_FN4 = 2640,
	PORT248_FN4 = 2641,
	PORT249_FN4 = 2642,
	PORT250_FN4 = 2643,
	PORT251_FN4 = 2644,
	PORT252_FN4 = 2645,
	PORT253_FN4 = 2646,
	PORT254_FN4 = 2647,
	PORT255_FN4 = 2648,
	PORT256_FN4 = 2649,
	PORT257_FN4 = 2650,
	PORT258_FN4 = 2651,
	PORT259_FN4 = 2652,
	PORT260_FN4 = 2653,
	PORT261_FN4 = 2654,
	PORT262_FN4 = 2655,
	PORT263_FN4 = 2656,
	PORT264_FN4 = 2657,
	PORT265_FN4 = 2658,
	PORT266_FN4 = 2659,
	PORT267_FN4 = 2660,
	PORT268_FN4 = 2661,
	PORT269_FN4 = 2662,
	PORT270_FN4 = 2663,
	PORT271_FN4 = 2664,
	PORT272_FN4 = 2665,
	PORT273_FN4 = 2666,
	PORT274_FN4 = 2667,
	PORT275_FN4 = 2668,
	PORT276_FN4 = 2669,
	PORT277_FN4 = 2670,
	PORT278_FN4 = 2671,
	PORT279_FN4 = 2672,
	PORT280_FN4 = 2673,
	PORT281_FN4 = 2674,
	PORT282_FN4 = 2675,
	PORT288_FN4 = 2676,
	PORT289_FN4 = 2677,
	PORT290_FN4 = 2678,
	PORT291_FN4 = 2679,
	PORT292_FN4 = 2680,
	PORT293_FN4 = 2681,
	PORT294_FN4 = 2682,
	PORT295_FN4 = 2683,
	PORT296_FN4 = 2684,
	PORT297_FN4 = 2685,
	PORT298_FN4 = 2686,
	PORT299_FN4 = 2687,
	PORT300_FN4 = 2688,
	PORT301_FN4 = 2689,
	PORT302_FN4 = 2690,
	PORT303_FN4 = 2691,
	PORT304_FN4 = 2692,
	PORT305_FN4 = 2693,
	PORT306_FN4 = 2694,
	PORT307_FN4 = 2695,
	PORT308_FN4 = 2696,
	PORT309_FN4 = 2697,
	PORT0_FN5 = 2698,
	PORT1_FN5 = 2699,
	PORT2_FN5 = 2700,
	PORT3_FN5 = 2701,
	PORT4_FN5 = 2702,
	PORT5_FN5 = 2703,
	PORT6_FN5 = 2704,
	PORT7_FN5 = 2705,
	PORT8_FN5 = 2706,
	PORT9_FN5 = 2707,
	PORT10_FN5 = 2708,
	PORT11_FN5 = 2709,
	PORT12_FN5 = 2710,
	PORT13_FN5 = 2711,
	PORT14_FN5 = 2712,
	PORT15_FN5 = 2713,
	PORT16_FN5 = 2714,
	PORT17_FN5 = 2715,
	PORT18_FN5 = 2716,
	PORT19_FN5 = 2717,
	PORT20_FN5 = 2718,
	PORT21_FN5 = 2719,
	PORT22_FN5 = 2720,
	PORT23_FN5 = 2721,
	PORT24_FN5 = 2722,
	PORT25_FN5 = 2723,
	PORT26_FN5 = 2724,
	PORT27_FN5 = 2725,
	PORT28_FN5 = 2726,
	PORT29_FN5 = 2727,
	PORT30_FN5 = 2728,
	PORT31_FN5 = 2729,
	PORT32_FN5 = 2730,
	PORT33_FN5 = 2731,
	PORT34_FN5 = 2732,
	PORT35_FN5 = 2733,
	PORT36_FN5 = 2734,
	PORT37_FN5 = 2735,
	PORT38_FN5 = 2736,
	PORT39_FN5 = 2737,
	PORT40_FN5 = 2738,
	PORT41_FN5 = 2739,
	PORT42_FN5 = 2740,
	PORT43_FN5 = 2741,
	PORT44_FN5 = 2742,
	PORT45_FN5 = 2743,
	PORT46_FN5 = 2744,
	PORT47_FN5 = 2745,
	PORT48_FN5 = 2746,
	PORT49_FN5 = 2747,
	PORT50_FN5 = 2748,
	PORT51_FN5 = 2749,
	PORT52_FN5 = 2750,
	PORT53_FN5 = 2751,
	PORT54_FN5 = 2752,
	PORT55_FN5 = 2753,
	PORT56_FN5 = 2754,
	PORT57_FN5 = 2755,
	PORT58_FN5 = 2756,
	PORT59_FN5 = 2757,
	PORT60_FN5 = 2758,
	PORT61_FN5 = 2759,
	PORT62_FN5 = 2760,
	PORT63_FN5 = 2761,
	PORT64_FN5 = 2762,
	PORT65_FN5 = 2763,
	PORT66_FN5 = 2764,
	PORT67_FN5 = 2765,
	PORT68_FN5 = 2766,
	PORT69_FN5 = 2767,
	PORT70_FN5 = 2768,
	PORT71_FN5 = 2769,
	PORT72_FN5 = 2770,
	PORT73_FN5 = 2771,
	PORT74_FN5 = 2772,
	PORT75_FN5 = 2773,
	PORT76_FN5 = 2774,
	PORT77_FN5 = 2775,
	PORT78_FN5 = 2776,
	PORT79_FN5 = 2777,
	PORT80_FN5 = 2778,
	PORT81_FN5 = 2779,
	PORT82_FN5 = 2780,
	PORT83_FN5 = 2781,
	PORT84_FN5 = 2782,
	PORT85_FN5 = 2783,
	PORT86_FN5 = 2784,
	PORT87_FN5 = 2785,
	PORT88_FN5 = 2786,
	PORT89_FN5 = 2787,
	PORT90_FN5 = 2788,
	PORT91_FN5 = 2789,
	PORT92_FN5 = 2790,
	PORT93_FN5 = 2791,
	PORT94_FN5 = 2792,
	PORT95_FN5 = 2793,
	PORT96_FN5 = 2794,
	PORT97_FN5 = 2795,
	PORT98_FN5 = 2796,
	PORT99_FN5 = 2797,
	PORT100_FN5 = 2798,
	PORT101_FN5 = 2799,
	PORT102_FN5 = 2800,
	PORT103_FN5 = 2801,
	PORT104_FN5 = 2802,
	PORT105_FN5 = 2803,
	PORT106_FN5 = 2804,
	PORT107_FN5 = 2805,
	PORT108_FN5 = 2806,
	PORT109_FN5 = 2807,
	PORT110_FN5 = 2808,
	PORT111_FN5 = 2809,
	PORT112_FN5 = 2810,
	PORT113_FN5 = 2811,
	PORT114_FN5 = 2812,
	PORT115_FN5 = 2813,
	PORT116_FN5 = 2814,
	PORT117_FN5 = 2815,
	PORT118_FN5 = 2816,
	PORT128_FN5 = 2817,
	PORT129_FN5 = 2818,
	PORT130_FN5 = 2819,
	PORT131_FN5 = 2820,
	PORT132_FN5 = 2821,
	PORT133_FN5 = 2822,
	PORT134_FN5 = 2823,
	PORT135_FN5 = 2824,
	PORT136_FN5 = 2825,
	PORT137_FN5 = 2826,
	PORT138_FN5 = 2827,
	PORT139_FN5 = 2828,
	PORT140_FN5 = 2829,
	PORT141_FN5 = 2830,
	PORT142_FN5 = 2831,
	PORT143_FN5 = 2832,
	PORT144_FN5 = 2833,
	PORT145_FN5 = 2834,
	PORT146_FN5 = 2835,
	PORT147_FN5 = 2836,
	PORT148_FN5 = 2837,
	PORT149_FN5 = 2838,
	PORT150_FN5 = 2839,
	PORT151_FN5 = 2840,
	PORT152_FN5 = 2841,
	PORT153_FN5 = 2842,
	PORT154_FN5 = 2843,
	PORT155_FN5 = 2844,
	PORT156_FN5 = 2845,
	PORT157_FN5 = 2846,
	PORT158_FN5 = 2847,
	PORT159_FN5 = 2848,
	PORT160_FN5 = 2849,
	PORT161_FN5 = 2850,
	PORT162_FN5 = 2851,
	PORT163_FN5 = 2852,
	PORT164_FN5 = 2853,
	PORT192_FN5 = 2854,
	PORT193_FN5 = 2855,
	PORT194_FN5 = 2856,
	PORT195_FN5 = 2857,
	PORT196_FN5 = 2858,
	PORT197_FN5 = 2859,
	PORT198_FN5 = 2860,
	PORT199_FN5 = 2861,
	PORT200_FN5 = 2862,
	PORT201_FN5 = 2863,
	PORT202_FN5 = 2864,
	PORT203_FN5 = 2865,
	PORT204_FN5 = 2866,
	PORT205_FN5 = 2867,
	PORT206_FN5 = 2868,
	PORT207_FN5 = 2869,
	PORT208_FN5 = 2870,
	PORT209_FN5 = 2871,
	PORT210_FN5 = 2872,
	PORT211_FN5 = 2873,
	PORT212_FN5 = 2874,
	PORT213_FN5 = 2875,
	PORT214_FN5 = 2876,
	PORT215_FN5 = 2877,
	PORT216_FN5 = 2878,
	PORT217_FN5 = 2879,
	PORT218_FN5 = 2880,
	PORT219_FN5 = 2881,
	PORT220_FN5 = 2882,
	PORT221_FN5 = 2883,
	PORT222_FN5 = 2884,
	PORT223_FN5 = 2885,
	PORT224_FN5 = 2886,
	PORT225_FN5 = 2887,
	PORT226_FN5 = 2888,
	PORT227_FN5 = 2889,
	PORT228_FN5 = 2890,
	PORT229_FN5 = 2891,
	PORT230_FN5 = 2892,
	PORT231_FN5 = 2893,
	PORT232_FN5 = 2894,
	PORT233_FN5 = 2895,
	PORT234_FN5 = 2896,
	PORT235_FN5 = 2897,
	PORT236_FN5 = 2898,
	PORT237_FN5 = 2899,
	PORT238_FN5 = 2900,
	PORT239_FN5 = 2901,
	PORT240_FN5 = 2902,
	PORT241_FN5 = 2903,
	PORT242_FN5 = 2904,
	PORT243_FN5 = 2905,
	PORT244_FN5 = 2906,
	PORT245_FN5 = 2907,
	PORT246_FN5 = 2908,
	PORT247_FN5 = 2909,
	PORT248_FN5 = 2910,
	PORT249_FN5 = 2911,
	PORT250_FN5 = 2912,
	PORT251_FN5 = 2913,
	PORT252_FN5 = 2914,
	PORT253_FN5 = 2915,
	PORT254_FN5 = 2916,
	PORT255_FN5 = 2917,
	PORT256_FN5 = 2918,
	PORT257_FN5 = 2919,
	PORT258_FN5 = 2920,
	PORT259_FN5 = 2921,
	PORT260_FN5 = 2922,
	PORT261_FN5 = 2923,
	PORT262_FN5 = 2924,
	PORT263_FN5 = 2925,
	PORT264_FN5 = 2926,
	PORT265_FN5 = 2927,
	PORT266_FN5 = 2928,
	PORT267_FN5 = 2929,
	PORT268_FN5 = 2930,
	PORT269_FN5 = 2931,
	PORT270_FN5 = 2932,
	PORT271_FN5 = 2933,
	PORT272_FN5 = 2934,
	PORT273_FN5 = 2935,
	PORT274_FN5 = 2936,
	PORT275_FN5 = 2937,
	PORT276_FN5 = 2938,
	PORT277_FN5 = 2939,
	PORT278_FN5 = 2940,
	PORT279_FN5 = 2941,
	PORT280_FN5 = 2942,
	PORT281_FN5 = 2943,
	PORT282_FN5 = 2944,
	PORT288_FN5 = 2945,
	PORT289_FN5 = 2946,
	PORT290_FN5 = 2947,
	PORT291_FN5 = 2948,
	PORT292_FN5 = 2949,
	PORT293_FN5 = 2950,
	PORT294_FN5 = 2951,
	PORT295_FN5 = 2952,
	PORT296_FN5 = 2953,
	PORT297_FN5 = 2954,
	PORT298_FN5 = 2955,
	PORT299_FN5 = 2956,
	PORT300_FN5 = 2957,
	PORT301_FN5 = 2958,
	PORT302_FN5 = 2959,
	PORT303_FN5 = 2960,
	PORT304_FN5 = 2961,
	PORT305_FN5 = 2962,
	PORT306_FN5 = 2963,
	PORT307_FN5 = 2964,
	PORT308_FN5 = 2965,
	PORT309_FN5 = 2966,
	PORT0_FN6 = 2967,
	PORT1_FN6 = 2968,
	PORT2_FN6 = 2969,
	PORT3_FN6 = 2970,
	PORT4_FN6 = 2971,
	PORT5_FN6 = 2972,
	PORT6_FN6 = 2973,
	PORT7_FN6 = 2974,
	PORT8_FN6 = 2975,
	PORT9_FN6 = 2976,
	PORT10_FN6 = 2977,
	PORT11_FN6 = 2978,
	PORT12_FN6 = 2979,
	PORT13_FN6 = 2980,
	PORT14_FN6 = 2981,
	PORT15_FN6 = 2982,
	PORT16_FN6 = 2983,
	PORT17_FN6 = 2984,
	PORT18_FN6 = 2985,
	PORT19_FN6 = 2986,
	PORT20_FN6 = 2987,
	PORT21_FN6 = 2988,
	PORT22_FN6 = 2989,
	PORT23_FN6 = 2990,
	PORT24_FN6 = 2991,
	PORT25_FN6 = 2992,
	PORT26_FN6 = 2993,
	PORT27_FN6 = 2994,
	PORT28_FN6 = 2995,
	PORT29_FN6 = 2996,
	PORT30_FN6 = 2997,
	PORT31_FN6 = 2998,
	PORT32_FN6 = 2999,
	PORT33_FN6 = 3000,
	PORT34_FN6 = 3001,
	PORT35_FN6 = 3002,
	PORT36_FN6 = 3003,
	PORT37_FN6 = 3004,
	PORT38_FN6 = 3005,
	PORT39_FN6 = 3006,
	PORT40_FN6 = 3007,
	PORT41_FN6 = 3008,
	PORT42_FN6 = 3009,
	PORT43_FN6 = 3010,
	PORT44_FN6 = 3011,
	PORT45_FN6 = 3012,
	PORT46_FN6 = 3013,
	PORT47_FN6 = 3014,
	PORT48_FN6 = 3015,
	PORT49_FN6 = 3016,
	PORT50_FN6 = 3017,
	PORT51_FN6 = 3018,
	PORT52_FN6 = 3019,
	PORT53_FN6 = 3020,
	PORT54_FN6 = 3021,
	PORT55_FN6 = 3022,
	PORT56_FN6 = 3023,
	PORT57_FN6 = 3024,
	PORT58_FN6 = 3025,
	PORT59_FN6 = 3026,
	PORT60_FN6 = 3027,
	PORT61_FN6 = 3028,
	PORT62_FN6 = 3029,
	PORT63_FN6 = 3030,
	PORT64_FN6 = 3031,
	PORT65_FN6 = 3032,
	PORT66_FN6 = 3033,
	PORT67_FN6 = 3034,
	PORT68_FN6 = 3035,
	PORT69_FN6 = 3036,
	PORT70_FN6 = 3037,
	PORT71_FN6 = 3038,
	PORT72_FN6 = 3039,
	PORT73_FN6 = 3040,
	PORT74_FN6 = 3041,
	PORT75_FN6 = 3042,
	PORT76_FN6 = 3043,
	PORT77_FN6 = 3044,
	PORT78_FN6 = 3045,
	PORT79_FN6 = 3046,
	PORT80_FN6 = 3047,
	PORT81_FN6 = 3048,
	PORT82_FN6 = 3049,
	PORT83_FN6 = 3050,
	PORT84_FN6 = 3051,
	PORT85_FN6 = 3052,
	PORT86_FN6 = 3053,
	PORT87_FN6 = 3054,
	PORT88_FN6 = 3055,
	PORT89_FN6 = 3056,
	PORT90_FN6 = 3057,
	PORT91_FN6 = 3058,
	PORT92_FN6 = 3059,
	PORT93_FN6 = 3060,
	PORT94_FN6 = 3061,
	PORT95_FN6 = 3062,
	PORT96_FN6 = 3063,
	PORT97_FN6 = 3064,
	PORT98_FN6 = 3065,
	PORT99_FN6 = 3066,
	PORT100_FN6 = 3067,
	PORT101_FN6 = 3068,
	PORT102_FN6 = 3069,
	PORT103_FN6 = 3070,
	PORT104_FN6 = 3071,
	PORT105_FN6 = 3072,
	PORT106_FN6 = 3073,
	PORT107_FN6 = 3074,
	PORT108_FN6 = 3075,
	PORT109_FN6 = 3076,
	PORT110_FN6 = 3077,
	PORT111_FN6 = 3078,
	PORT112_FN6 = 3079,
	PORT113_FN6 = 3080,
	PORT114_FN6 = 3081,
	PORT115_FN6 = 3082,
	PORT116_FN6 = 3083,
	PORT117_FN6 = 3084,
	PORT118_FN6 = 3085,
	PORT128_FN6 = 3086,
	PORT129_FN6 = 3087,
	PORT130_FN6 = 3088,
	PORT131_FN6 = 3089,
	PORT132_FN6 = 3090,
	PORT133_FN6 = 3091,
	PORT134_FN6 = 3092,
	PORT135_FN6 = 3093,
	PORT136_FN6 = 3094,
	PORT137_FN6 = 3095,
	PORT138_FN6 = 3096,
	PORT139_FN6 = 3097,
	PORT140_FN6 = 3098,
	PORT141_FN6 = 3099,
	PORT142_FN6 = 3100,
	PORT143_FN6 = 3101,
	PORT144_FN6 = 3102,
	PORT145_FN6 = 3103,
	PORT146_FN6 = 3104,
	PORT147_FN6 = 3105,
	PORT148_FN6 = 3106,
	PORT149_FN6 = 3107,
	PORT150_FN6 = 3108,
	PORT151_FN6 = 3109,
	PORT152_FN6 = 3110,
	PORT153_FN6 = 3111,
	PORT154_FN6 = 3112,
	PORT155_FN6 = 3113,
	PORT156_FN6 = 3114,
	PORT157_FN6 = 3115,
	PORT158_FN6 = 3116,
	PORT159_FN6 = 3117,
	PORT160_FN6 = 3118,
	PORT161_FN6 = 3119,
	PORT162_FN6 = 3120,
	PORT163_FN6 = 3121,
	PORT164_FN6 = 3122,
	PORT192_FN6 = 3123,
	PORT193_FN6 = 3124,
	PORT194_FN6 = 3125,
	PORT195_FN6 = 3126,
	PORT196_FN6 = 3127,
	PORT197_FN6 = 3128,
	PORT198_FN6 = 3129,
	PORT199_FN6 = 3130,
	PORT200_FN6 = 3131,
	PORT201_FN6 = 3132,
	PORT202_FN6 = 3133,
	PORT203_FN6 = 3134,
	PORT204_FN6 = 3135,
	PORT205_FN6 = 3136,
	PORT206_FN6 = 3137,
	PORT207_FN6 = 3138,
	PORT208_FN6 = 3139,
	PORT209_FN6 = 3140,
	PORT210_FN6 = 3141,
	PORT211_FN6 = 3142,
	PORT212_FN6 = 3143,
	PORT213_FN6 = 3144,
	PORT214_FN6 = 3145,
	PORT215_FN6 = 3146,
	PORT216_FN6 = 3147,
	PORT217_FN6 = 3148,
	PORT218_FN6 = 3149,
	PORT219_FN6 = 3150,
	PORT220_FN6 = 3151,
	PORT221_FN6 = 3152,
	PORT222_FN6 = 3153,
	PORT223_FN6 = 3154,
	PORT224_FN6 = 3155,
	PORT225_FN6 = 3156,
	PORT226_FN6 = 3157,
	PORT227_FN6 = 3158,
	PORT228_FN6 = 3159,
	PORT229_FN6 = 3160,
	PORT230_FN6 = 3161,
	PORT231_FN6 = 3162,
	PORT232_FN6 = 3163,
	PORT233_FN6 = 3164,
	PORT234_FN6 = 3165,
	PORT235_FN6 = 3166,
	PORT236_FN6 = 3167,
	PORT237_FN6 = 3168,
	PORT238_FN6 = 3169,
	PORT239_FN6 = 3170,
	PORT240_FN6 = 3171,
	PORT241_FN6 = 3172,
	PORT242_FN6 = 3173,
	PORT243_FN6 = 3174,
	PORT244_FN6 = 3175,
	PORT245_FN6 = 3176,
	PORT246_FN6 = 3177,
	PORT247_FN6 = 3178,
	PORT248_FN6 = 3179,
	PORT249_FN6 = 3180,
	PORT250_FN6 = 3181,
	PORT251_FN6 = 3182,
	PORT252_FN6 = 3183,
	PORT253_FN6 = 3184,
	PORT254_FN6 = 3185,
	PORT255_FN6 = 3186,
	PORT256_FN6 = 3187,
	PORT257_FN6 = 3188,
	PORT258_FN6 = 3189,
	PORT259_FN6 = 3190,
	PORT260_FN6 = 3191,
	PORT261_FN6 = 3192,
	PORT262_FN6 = 3193,
	PORT263_FN6 = 3194,
	PORT264_FN6 = 3195,
	PORT265_FN6 = 3196,
	PORT266_FN6 = 3197,
	PORT267_FN6 = 3198,
	PORT268_FN6 = 3199,
	PORT269_FN6 = 3200,
	PORT270_FN6 = 3201,
	PORT271_FN6 = 3202,
	PORT272_FN6 = 3203,
	PORT273_FN6 = 3204,
	PORT274_FN6 = 3205,
	PORT275_FN6 = 3206,
	PORT276_FN6 = 3207,
	PORT277_FN6 = 3208,
	PORT278_FN6 = 3209,
	PORT279_FN6 = 3210,
	PORT280_FN6 = 3211,
	PORT281_FN6 = 3212,
	PORT282_FN6 = 3213,
	PORT288_FN6 = 3214,
	PORT289_FN6 = 3215,
	PORT290_FN6 = 3216,
	PORT291_FN6 = 3217,
	PORT292_FN6 = 3218,
	PORT293_FN6 = 3219,
	PORT294_FN6 = 3220,
	PORT295_FN6 = 3221,
	PORT296_FN6 = 3222,
	PORT297_FN6 = 3223,
	PORT298_FN6 = 3224,
	PORT299_FN6 = 3225,
	PORT300_FN6 = 3226,
	PORT301_FN6 = 3227,
	PORT302_FN6 = 3228,
	PORT303_FN6 = 3229,
	PORT304_FN6 = 3230,
	PORT305_FN6 = 3231,
	PORT306_FN6 = 3232,
	PORT307_FN6 = 3233,
	PORT308_FN6 = 3234,
	PORT309_FN6 = 3235,
	PORT0_FN7 = 3236,
	PORT1_FN7 = 3237,
	PORT2_FN7 = 3238,
	PORT3_FN7 = 3239,
	PORT4_FN7 = 3240,
	PORT5_FN7 = 3241,
	PORT6_FN7 = 3242,
	PORT7_FN7 = 3243,
	PORT8_FN7 = 3244,
	PORT9_FN7 = 3245,
	PORT10_FN7 = 3246,
	PORT11_FN7 = 3247,
	PORT12_FN7 = 3248,
	PORT13_FN7 = 3249,
	PORT14_FN7 = 3250,
	PORT15_FN7 = 3251,
	PORT16_FN7 = 3252,
	PORT17_FN7 = 3253,
	PORT18_FN7 = 3254,
	PORT19_FN7 = 3255,
	PORT20_FN7 = 3256,
	PORT21_FN7 = 3257,
	PORT22_FN7 = 3258,
	PORT23_FN7 = 3259,
	PORT24_FN7 = 3260,
	PORT25_FN7 = 3261,
	PORT26_FN7 = 3262,
	PORT27_FN7 = 3263,
	PORT28_FN7 = 3264,
	PORT29_FN7 = 3265,
	PORT30_FN7 = 3266,
	PORT31_FN7 = 3267,
	PORT32_FN7 = 3268,
	PORT33_FN7 = 3269,
	PORT34_FN7 = 3270,
	PORT35_FN7 = 3271,
	PORT36_FN7 = 3272,
	PORT37_FN7 = 3273,
	PORT38_FN7 = 3274,
	PORT39_FN7 = 3275,
	PORT40_FN7 = 3276,
	PORT41_FN7 = 3277,
	PORT42_FN7 = 3278,
	PORT43_FN7 = 3279,
	PORT44_FN7 = 3280,
	PORT45_FN7 = 3281,
	PORT46_FN7 = 3282,
	PORT47_FN7 = 3283,
	PORT48_FN7 = 3284,
	PORT49_FN7 = 3285,
	PORT50_FN7 = 3286,
	PORT51_FN7 = 3287,
	PORT52_FN7 = 3288,
	PORT53_FN7 = 3289,
	PORT54_FN7 = 3290,
	PORT55_FN7 = 3291,
	PORT56_FN7 = 3292,
	PORT57_FN7 = 3293,
	PORT58_FN7 = 3294,
	PORT59_FN7 = 3295,
	PORT60_FN7 = 3296,
	PORT61_FN7 = 3297,
	PORT62_FN7 = 3298,
	PORT63_FN7 = 3299,
	PORT64_FN7 = 3300,
	PORT65_FN7 = 3301,
	PORT66_FN7 = 3302,
	PORT67_FN7 = 3303,
	PORT68_FN7 = 3304,
	PORT69_FN7 = 3305,
	PORT70_FN7 = 3306,
	PORT71_FN7 = 3307,
	PORT72_FN7 = 3308,
	PORT73_FN7 = 3309,
	PORT74_FN7 = 3310,
	PORT75_FN7 = 3311,
	PORT76_FN7 = 3312,
	PORT77_FN7 = 3313,
	PORT78_FN7 = 3314,
	PORT79_FN7 = 3315,
	PORT80_FN7 = 3316,
	PORT81_FN7 = 3317,
	PORT82_FN7 = 3318,
	PORT83_FN7 = 3319,
	PORT84_FN7 = 3320,
	PORT85_FN7 = 3321,
	PORT86_FN7 = 3322,
	PORT87_FN7 = 3323,
	PORT88_FN7 = 3324,
	PORT89_FN7 = 3325,
	PORT90_FN7 = 3326,
	PORT91_FN7 = 3327,
	PORT92_FN7 = 3328,
	PORT93_FN7 = 3329,
	PORT94_FN7 = 3330,
	PORT95_FN7 = 3331,
	PORT96_FN7 = 3332,
	PORT97_FN7 = 3333,
	PORT98_FN7 = 3334,
	PORT99_FN7 = 3335,
	PORT100_FN7 = 3336,
	PORT101_FN7 = 3337,
	PORT102_FN7 = 3338,
	PORT103_FN7 = 3339,
	PORT104_FN7 = 3340,
	PORT105_FN7 = 3341,
	PORT106_FN7 = 3342,
	PORT107_FN7 = 3343,
	PORT108_FN7 = 3344,
	PORT109_FN7 = 3345,
	PORT110_FN7 = 3346,
	PORT111_FN7 = 3347,
	PORT112_FN7 = 3348,
	PORT113_FN7 = 3349,
	PORT114_FN7 = 3350,
	PORT115_FN7 = 3351,
	PORT116_FN7 = 3352,
	PORT117_FN7 = 3353,
	PORT118_FN7 = 3354,
	PORT128_FN7 = 3355,
	PORT129_FN7 = 3356,
	PORT130_FN7 = 3357,
	PORT131_FN7 = 3358,
	PORT132_FN7 = 3359,
	PORT133_FN7 = 3360,
	PORT134_FN7 = 3361,
	PORT135_FN7 = 3362,
	PORT136_FN7 = 3363,
	PORT137_FN7 = 3364,
	PORT138_FN7 = 3365,
	PORT139_FN7 = 3366,
	PORT140_FN7 = 3367,
	PORT141_FN7 = 3368,
	PORT142_FN7 = 3369,
	PORT143_FN7 = 3370,
	PORT144_FN7 = 3371,
	PORT145_FN7 = 3372,
	PORT146_FN7 = 3373,
	PORT147_FN7 = 3374,
	PORT148_FN7 = 3375,
	PORT149_FN7 = 3376,
	PORT150_FN7 = 3377,
	PORT151_FN7 = 3378,
	PORT152_FN7 = 3379,
	PORT153_FN7 = 3380,
	PORT154_FN7 = 3381,
	PORT155_FN7 = 3382,
	PORT156_FN7 = 3383,
	PORT157_FN7 = 3384,
	PORT158_FN7 = 3385,
	PORT159_FN7 = 3386,
	PORT160_FN7 = 3387,
	PORT161_FN7 = 3388,
	PORT162_FN7 = 3389,
	PORT163_FN7 = 3390,
	PORT164_FN7 = 3391,
	PORT192_FN7 = 3392,
	PORT193_FN7 = 3393,
	PORT194_FN7 = 3394,
	PORT195_FN7 = 3395,
	PORT196_FN7 = 3396,
	PORT197_FN7 = 3397,
	PORT198_FN7 = 3398,
	PORT199_FN7 = 3399,
	PORT200_FN7 = 3400,
	PORT201_FN7 = 3401,
	PORT202_FN7 = 3402,
	PORT203_FN7 = 3403,
	PORT204_FN7 = 3404,
	PORT205_FN7 = 3405,
	PORT206_FN7 = 3406,
	PORT207_FN7 = 3407,
	PORT208_FN7 = 3408,
	PORT209_FN7 = 3409,
	PORT210_FN7 = 3410,
	PORT211_FN7 = 3411,
	PORT212_FN7 = 3412,
	PORT213_FN7 = 3413,
	PORT214_FN7 = 3414,
	PORT215_FN7 = 3415,
	PORT216_FN7 = 3416,
	PORT217_FN7 = 3417,
	PORT218_FN7 = 3418,
	PORT219_FN7 = 3419,
	PORT220_FN7 = 3420,
	PORT221_FN7 = 3421,
	PORT222_FN7 = 3422,
	PORT223_FN7 = 3423,
	PORT224_FN7 = 3424,
	PORT225_FN7 = 3425,
	PORT226_FN7 = 3426,
	PORT227_FN7 = 3427,
	PORT228_FN7 = 3428,
	PORT229_FN7 = 3429,
	PORT230_FN7 = 3430,
	PORT231_FN7 = 3431,
	PORT232_FN7 = 3432,
	PORT233_FN7 = 3433,
	PORT234_FN7 = 3434,
	PORT235_FN7 = 3435,
	PORT236_FN7 = 3436,
	PORT237_FN7 = 3437,
	PORT238_FN7 = 3438,
	PORT239_FN7 = 3439,
	PORT240_FN7 = 3440,
	PORT241_FN7 = 3441,
	PORT242_FN7 = 3442,
	PORT243_FN7 = 3443,
	PORT244_FN7 = 3444,
	PORT245_FN7 = 3445,
	PORT246_FN7 = 3446,
	PORT247_FN7 = 3447,
	PORT248_FN7 = 3448,
	PORT249_FN7 = 3449,
	PORT250_FN7 = 3450,
	PORT251_FN7 = 3451,
	PORT252_FN7 = 3452,
	PORT253_FN7 = 3453,
	PORT254_FN7 = 3454,
	PORT255_FN7 = 3455,
	PORT256_FN7 = 3456,
	PORT257_FN7 = 3457,
	PORT258_FN7 = 3458,
	PORT259_FN7 = 3459,
	PORT260_FN7 = 3460,
	PORT261_FN7 = 3461,
	PORT262_FN7 = 3462,
	PORT263_FN7 = 3463,
	PORT264_FN7 = 3464,
	PORT265_FN7 = 3465,
	PORT266_FN7 = 3466,
	PORT267_FN7 = 3467,
	PORT268_FN7 = 3468,
	PORT269_FN7 = 3469,
	PORT270_FN7 = 3470,
	PORT271_FN7 = 3471,
	PORT272_FN7 = 3472,
	PORT273_FN7 = 3473,
	PORT274_FN7 = 3474,
	PORT275_FN7 = 3475,
	PORT276_FN7 = 3476,
	PORT277_FN7 = 3477,
	PORT278_FN7 = 3478,
	PORT279_FN7 = 3479,
	PORT280_FN7 = 3480,
	PORT281_FN7 = 3481,
	PORT282_FN7 = 3482,
	PORT288_FN7 = 3483,
	PORT289_FN7 = 3484,
	PORT290_FN7 = 3485,
	PORT291_FN7 = 3486,
	PORT292_FN7 = 3487,
	PORT293_FN7 = 3488,
	PORT294_FN7 = 3489,
	PORT295_FN7 = 3490,
	PORT296_FN7 = 3491,
	PORT297_FN7 = 3492,
	PORT298_FN7 = 3493,
	PORT299_FN7 = 3494,
	PORT300_FN7 = 3495,
	PORT301_FN7 = 3496,
	PORT302_FN7 = 3497,
	PORT303_FN7 = 3498,
	PORT304_FN7 = 3499,
	PORT305_FN7 = 3500,
	PORT306_FN7 = 3501,
	PORT307_FN7 = 3502,
	PORT308_FN7 = 3503,
	PORT309_FN7 = 3504,
	MSEL2CR_MSEL19_0 = 3505,
	MSEL2CR_MSEL19_1 = 3506,
	MSEL2CR_MSEL18_0 = 3507,
	MSEL2CR_MSEL18_1 = 3508,
	MSEL2CR_MSEL17_0 = 3509,
	MSEL2CR_MSEL17_1 = 3510,
	MSEL2CR_MSEL16_0 = 3511,
	MSEL2CR_MSEL16_1 = 3512,
	MSEL2CR_MSEL14_0 = 3513,
	MSEL2CR_MSEL14_1 = 3514,
	MSEL2CR_MSEL13_0 = 3515,
	MSEL2CR_MSEL13_1 = 3516,
	MSEL2CR_MSEL12_0 = 3517,
	MSEL2CR_MSEL12_1 = 3518,
	MSEL2CR_MSEL11_0 = 3519,
	MSEL2CR_MSEL11_1 = 3520,
	MSEL2CR_MSEL10_0 = 3521,
	MSEL2CR_MSEL10_1 = 3522,
	MSEL2CR_MSEL9_0 = 3523,
	MSEL2CR_MSEL9_1 = 3524,
	MSEL2CR_MSEL8_0 = 3525,
	MSEL2CR_MSEL8_1 = 3526,
	MSEL2CR_MSEL7_0 = 3527,
	MSEL2CR_MSEL7_1 = 3528,
	MSEL2CR_MSEL6_0 = 3529,
	MSEL2CR_MSEL6_1 = 3530,
	MSEL2CR_MSEL4_0 = 3531,
	MSEL2CR_MSEL4_1 = 3532,
	MSEL2CR_MSEL5_0 = 3533,
	MSEL2CR_MSEL5_1 = 3534,
	MSEL2CR_MSEL3_0 = 3535,
	MSEL2CR_MSEL3_1 = 3536,
	MSEL2CR_MSEL2_0 = 3537,
	MSEL2CR_MSEL2_1 = 3538,
	MSEL2CR_MSEL1_0 = 3539,
	MSEL2CR_MSEL1_1 = 3540,
	MSEL2CR_MSEL0_0 = 3541,
	MSEL2CR_MSEL0_1 = 3542,
	MSEL3CR_MSEL28_0 = 3543,
	MSEL3CR_MSEL28_1 = 3544,
	MSEL3CR_MSEL15_0 = 3545,
	MSEL3CR_MSEL15_1 = 3546,
	MSEL3CR_MSEL11_0 = 3547,
	MSEL3CR_MSEL11_1 = 3548,
	MSEL3CR_MSEL9_0 = 3549,
	MSEL3CR_MSEL9_1 = 3550,
	MSEL3CR_MSEL6_0 = 3551,
	MSEL3CR_MSEL6_1 = 3552,
	MSEL3CR_MSEL2_0 = 3553,
	MSEL3CR_MSEL2_1 = 3554,
	MSEL4CR_MSEL29_0 = 3555,
	MSEL4CR_MSEL29_1 = 3556,
	MSEL4CR_MSEL27_0 = 3557,
	MSEL4CR_MSEL27_1 = 3558,
	MSEL4CR_MSEL26_0 = 3559,
	MSEL4CR_MSEL26_1 = 3560,
	MSEL4CR_MSEL22_0 = 3561,
	MSEL4CR_MSEL22_1 = 3562,
	MSEL4CR_MSEL21_0 = 3563,
	MSEL4CR_MSEL21_1 = 3564,
	MSEL4CR_MSEL20_0 = 3565,
	MSEL4CR_MSEL20_1 = 3566,
	MSEL4CR_MSEL19_0 = 3567,
	MSEL4CR_MSEL19_1 = 3568,
	MSEL4CR_MSEL15_0 = 3569,
	MSEL4CR_MSEL15_1 = 3570,
	MSEL4CR_MSEL13_0 = 3571,
	MSEL4CR_MSEL13_1 = 3572,
	MSEL4CR_MSEL12_0 = 3573,
	MSEL4CR_MSEL12_1 = 3574,
	MSEL4CR_MSEL11_0 = 3575,
	MSEL4CR_MSEL11_1 = 3576,
	MSEL4CR_MSEL10_0 = 3577,
	MSEL4CR_MSEL10_1 = 3578,
	MSEL4CR_MSEL9_0 = 3579,
	MSEL4CR_MSEL9_1 = 3580,
	MSEL4CR_MSEL8_0 = 3581,
	MSEL4CR_MSEL8_1 = 3582,
	MSEL4CR_MSEL7_0 = 3583,
	MSEL4CR_MSEL7_1 = 3584,
	MSEL4CR_MSEL4_0 = 3585,
	MSEL4CR_MSEL4_1 = 3586,
	MSEL4CR_MSEL1_0 = 3587,
	MSEL4CR_MSEL1_1 = 3588,
	PINMUX_FUNCTION_END___2 = 3589,
	PINMUX_MARK_BEGIN___2 = 3590,
	VBUS_0_MARK = 3591,
	GPI0_MARK = 3592,
	GPI1_MARK = 3593,
	GPI2_MARK = 3594,
	GPI3_MARK = 3595,
	GPI4_MARK = 3596,
	GPI5_MARK = 3597,
	GPI6_MARK = 3598,
	GPI7_MARK = 3599,
	SCIFA7_RXD_MARK = 3600,
	SCIFA7_CTS__MARK = 3601,
	GPO7_MARK = 3602,
	MFG0_OUT2_MARK = 3603,
	GPO6_MARK = 3604,
	MFG1_OUT2_MARK = 3605,
	GPO5_MARK = 3606,
	SCIFA0_SCK_MARK = 3607,
	FSICOSLDT3_MARK = 3608,
	PORT16_VIO_CKOR_MARK = 3609,
	SCIFA0_TXD_MARK___2 = 3610,
	SCIFA7_TXD_MARK = 3611,
	SCIFA7_RTS__MARK = 3612,
	PORT19_VIO_CKO2_MARK = 3613,
	GPO0_MARK = 3614,
	GPO1_MARK = 3615,
	GPO2_MARK = 3616,
	STATUS0_MARK = 3617,
	GPO3_MARK = 3618,
	STATUS1_MARK = 3619,
	GPO4_MARK = 3620,
	STATUS2_MARK = 3621,
	VINT_MARK = 3622,
	TCKON_MARK = 3623,
	XDVFS1_MARK = 3624,
	PORT27_I2C_SCL2_MARK = 3625,
	PORT27_I2C_SCL3_MARK = 3626,
	MFG0_OUT1_MARK = 3627,
	PORT27_IROUT_MARK = 3628,
	XDVFS2_MARK = 3629,
	PORT28_I2C_SDA2_MARK = 3630,
	PORT28_I2C_SDA3_MARK = 3631,
	PORT28_TPU1TO1_MARK = 3632,
	SIM_RST_MARK = 3633,
	PORT29_TPU1TO1_MARK = 3634,
	SIM_CLK_MARK = 3635,
	PORT30_VIO_CKOR_MARK = 3636,
	SIM_D_MARK = 3637,
	PORT31_IROUT_MARK = 3638,
	SCIFA4_TXD_MARK___2 = 3639,
	SCIFA4_RXD_MARK___2 = 3640,
	XWUP_MARK = 3641,
	SCIFA4_RTS__MARK = 3642,
	SCIFA4_CTS__MARK = 3643,
	FSIBOBT_MARK = 3644,
	FSIBIBT_MARK = 3645,
	FSIBOLR_MARK = 3646,
	FSIBILR_MARK = 3647,
	FSIBOSLD_MARK = 3648,
	FSIBISLD_MARK = 3649,
	VACK_MARK = 3650,
	XTAL1L_MARK = 3651,
	SCIFA0_RTS__MARK = 3652,
	FSICOSLDT2_MARK = 3653,
	SCIFA0_RXD_MARK___2 = 3654,
	SCIFA0_CTS__MARK = 3655,
	FSICOSLDT1_MARK = 3656,
	FSICOBT_MARK = 3657,
	FSICIBT_MARK = 3658,
	FSIDOBT_MARK = 3659,
	FSIDIBT_MARK = 3660,
	FSICOLR_MARK = 3661,
	FSICILR_MARK = 3662,
	FSIDOLR_MARK = 3663,
	FSIDILR_MARK = 3664,
	FSICOSLD_MARK = 3665,
	PORT47_FSICSPDIF_MARK = 3666,
	FSICISLD_MARK = 3667,
	FSIDISLD_MARK = 3668,
	FSIACK_MARK = 3669,
	PORT49_IRDA_OUT_MARK = 3670,
	PORT49_IROUT_MARK = 3671,
	FSIAOMC_MARK = 3672,
	FSIAOLR_MARK = 3673,
	BBIF2_TSYNC2_MARK = 3674,
	TPU2TO2_MARK = 3675,
	FSIAILR_MARK = 3676,
	FSIAOBT_MARK = 3677,
	BBIF2_TSCK2_MARK = 3678,
	TPU2TO3_MARK = 3679,
	FSIAIBT_MARK = 3680,
	FSIAOSLD_MARK = 3681,
	BBIF2_TXD2_MARK = 3682,
	FSIASPDIF_MARK = 3683,
	PORT53_IRDA_IN_MARK = 3684,
	TPU3TO3_MARK = 3685,
	FSIBSPDIF_MARK = 3686,
	PORT53_FSICSPDIF_MARK = 3687,
	FSIBCK_MARK = 3688,
	PORT54_IRDA_FIRSEL_MARK = 3689,
	TPU3TO2_MARK = 3690,
	FSIBOMC_MARK = 3691,
	FSICCK_MARK = 3692,
	FSICOMC_MARK = 3693,
	FSIAISLD_MARK = 3694,
	TPU0TO0_MARK = 3695,
	A0_MARK___2 = 3696,
	BS__MARK = 3697,
	A12_MARK___2 = 3698,
	PORT58_KEYOUT7_MARK = 3699,
	TPU4TO2_MARK = 3700,
	A13_MARK___2 = 3701,
	PORT59_KEYOUT6_MARK = 3702,
	TPU0TO1_MARK = 3703,
	A14_MARK___2 = 3704,
	KEYOUT5_MARK = 3705,
	A15_MARK___2 = 3706,
	KEYOUT4_MARK = 3707,
	A16_MARK___2 = 3708,
	KEYOUT3_MARK = 3709,
	MSIOF0_SS1_MARK___2 = 3710,
	A17_MARK___2 = 3711,
	KEYOUT2_MARK = 3712,
	MSIOF0_TSYNC_MARK = 3713,
	A18_MARK___2 = 3714,
	KEYOUT1_MARK = 3715,
	MSIOF0_TSCK_MARK = 3716,
	A19_MARK___2 = 3717,
	KEYOUT0_MARK = 3718,
	MSIOF0_TXD_MARK___2 = 3719,
	A20_MARK___2 = 3720,
	KEYIN0_MARK = 3721,
	MSIOF0_RSCK_MARK = 3722,
	A21_MARK___2 = 3723,
	KEYIN1_MARK = 3724,
	MSIOF0_RSYNC_MARK = 3725,
	A22_MARK___2 = 3726,
	KEYIN2_MARK = 3727,
	MSIOF0_MCK0_MARK = 3728,
	A23_MARK___2 = 3729,
	KEYIN3_MARK = 3730,
	MSIOF0_MCK1_MARK = 3731,
	A24_MARK___2 = 3732,
	KEYIN4_MARK = 3733,
	MSIOF0_RXD_MARK___2 = 3734,
	A25_MARK___2 = 3735,
	KEYIN5_MARK = 3736,
	MSIOF0_SS2_MARK___2 = 3737,
	A26_MARK = 3738,
	KEYIN6_MARK = 3739,
	KEYIN7_MARK = 3740,
	D0_NAF0_MARK = 3741,
	D1_NAF1_MARK = 3742,
	D2_NAF2_MARK = 3743,
	D3_NAF3_MARK = 3744,
	D4_NAF4_MARK = 3745,
	D5_NAF5_MARK = 3746,
	D6_NAF6_MARK = 3747,
	D7_NAF7_MARK = 3748,
	D8_NAF8_MARK = 3749,
	D9_NAF9_MARK = 3750,
	D10_NAF10_MARK = 3751,
	D11_NAF11_MARK = 3752,
	D12_NAF12_MARK = 3753,
	D13_NAF13_MARK = 3754,
	D14_NAF14_MARK = 3755,
	D15_NAF15_MARK = 3756,
	CS4__MARK = 3757,
	CS5A__MARK = 3758,
	PORT91_RDWR_MARK = 3759,
	CS5B__MARK = 3760,
	FCE1__MARK = 3761,
	CS6B__MARK = 3762,
	DACK0_MARK___2 = 3763,
	FCE0__MARK = 3764,
	CS6A__MARK = 3765,
	WAIT__MARK = 3766,
	DREQ0_MARK = 3767,
	RD__FSC_MARK = 3768,
	WE0__FWE_MARK = 3769,
	RDWR_FWE_MARK = 3770,
	WE1__MARK = 3771,
	FRB_MARK = 3772,
	CKO_MARK = 3773,
	NBRSTOUT__MARK = 3774,
	NBRST__MARK = 3775,
	BBIF2_TXD_MARK = 3776,
	BBIF2_RXD_MARK = 3777,
	BBIF2_SYNC_MARK = 3778,
	BBIF2_SCK_MARK = 3779,
	SCIFA3_CTS__MARK = 3780,
	MFG3_IN2_MARK = 3781,
	SCIFA3_RXD_MARK___2 = 3782,
	MFG3_IN1_MARK = 3783,
	BBIF1_SS2_MARK = 3784,
	SCIFA3_RTS__MARK = 3785,
	MFG3_OUT1_MARK = 3786,
	SCIFA3_TXD_MARK___2 = 3787,
	HSI_RX_DATA_MARK = 3788,
	BBIF1_RXD_MARK = 3789,
	HSI_TX_WAKE_MARK = 3790,
	BBIF1_TSCK_MARK = 3791,
	HSI_TX_DATA_MARK = 3792,
	BBIF1_TSYNC_MARK = 3793,
	HSI_TX_READY_MARK = 3794,
	BBIF1_TXD_MARK = 3795,
	HSI_RX_READY_MARK = 3796,
	BBIF1_RSCK_MARK = 3797,
	PORT115_I2C_SCL2_MARK = 3798,
	PORT115_I2C_SCL3_MARK = 3799,
	HSI_RX_WAKE_MARK = 3800,
	BBIF1_RSYNC_MARK = 3801,
	PORT116_I2C_SDA2_MARK = 3802,
	PORT116_I2C_SDA3_MARK = 3803,
	HSI_RX_FLAG_MARK = 3804,
	BBIF1_SS1_MARK = 3805,
	BBIF1_FLOW_MARK = 3806,
	HSI_TX_FLAG_MARK = 3807,
	VIO_VD_MARK = 3808,
	PORT128_LCD2VSYN_MARK = 3809,
	VIO2_VD_MARK = 3810,
	LCD2D0_MARK = 3811,
	VIO_HD_MARK = 3812,
	PORT129_LCD2HSYN_MARK = 3813,
	PORT129_LCD2CS__MARK = 3814,
	VIO2_HD_MARK = 3815,
	LCD2D1_MARK = 3816,
	VIO_D0_MARK = 3817,
	PORT130_MSIOF2_RXD_MARK = 3818,
	LCD2D10_MARK = 3819,
	VIO_D1_MARK = 3820,
	PORT131_KEYOUT6_MARK = 3821,
	PORT131_MSIOF2_SS1_MARK = 3822,
	PORT131_KEYOUT11_MARK = 3823,
	LCD2D11_MARK = 3824,
	VIO_D2_MARK = 3825,
	PORT132_KEYOUT7_MARK = 3826,
	PORT132_MSIOF2_SS2_MARK = 3827,
	PORT132_KEYOUT10_MARK = 3828,
	LCD2D12_MARK = 3829,
	VIO_D3_MARK = 3830,
	MSIOF2_TSYNC_MARK = 3831,
	LCD2D13_MARK = 3832,
	VIO_D4_MARK = 3833,
	MSIOF2_TXD_MARK___2 = 3834,
	LCD2D14_MARK = 3835,
	VIO_D5_MARK = 3836,
	MSIOF2_TSCK_MARK = 3837,
	LCD2D15_MARK = 3838,
	VIO_D6_MARK = 3839,
	PORT136_KEYOUT8_MARK = 3840,
	LCD2D16_MARK = 3841,
	VIO_D7_MARK = 3842,
	PORT137_KEYOUT9_MARK = 3843,
	LCD2D17_MARK = 3844,
	VIO_D8_MARK = 3845,
	PORT138_KEYOUT8_MARK = 3846,
	VIO2_D0_MARK = 3847,
	LCD2D6_MARK = 3848,
	VIO_D9_MARK = 3849,
	PORT139_KEYOUT9_MARK = 3850,
	VIO2_D1_MARK = 3851,
	LCD2D7_MARK = 3852,
	VIO_D10_MARK = 3853,
	TPU0TO2_MARK = 3854,
	VIO2_D2_MARK = 3855,
	LCD2D8_MARK = 3856,
	VIO_D11_MARK = 3857,
	TPU0TO3_MARK = 3858,
	VIO2_D3_MARK = 3859,
	LCD2D9_MARK = 3860,
	VIO_D12_MARK = 3861,
	PORT142_KEYOUT10_MARK = 3862,
	VIO2_D4_MARK = 3863,
	LCD2D2_MARK = 3864,
	VIO_D13_MARK = 3865,
	PORT143_KEYOUT11_MARK = 3866,
	PORT143_KEYOUT6_MARK = 3867,
	VIO2_D5_MARK = 3868,
	LCD2D3_MARK = 3869,
	VIO_D14_MARK = 3870,
	PORT144_KEYOUT7_MARK = 3871,
	VIO2_D6_MARK = 3872,
	LCD2D4_MARK = 3873,
	VIO_D15_MARK = 3874,
	TPU1TO3_MARK = 3875,
	PORT145_LCD2DISP_MARK = 3876,
	PORT145_LCD2RS_MARK = 3877,
	VIO2_D7_MARK = 3878,
	LCD2D5_MARK = 3879,
	VIO_CLK_MARK = 3880,
	LCD2DCK_MARK = 3881,
	PORT146_LCD2WR__MARK = 3882,
	VIO2_CLK_MARK = 3883,
	LCD2D18_MARK = 3884,
	VIO_FIELD_MARK = 3885,
	LCD2RD__MARK = 3886,
	VIO2_FIELD_MARK = 3887,
	LCD2D19_MARK = 3888,
	VIO_CKO_MARK = 3889,
	A27_MARK = 3890,
	PORT149_RDWR_MARK = 3891,
	MFG0_IN1_MARK = 3892,
	PORT149_KEYOUT9_MARK = 3893,
	MFG0_IN2_MARK = 3894,
	TS_SPSYNC3_MARK = 3895,
	MSIOF2_RSCK_MARK = 3896,
	TS_SDAT3_MARK = 3897,
	MSIOF2_RSYNC_MARK = 3898,
	TPU1TO2_MARK = 3899,
	TS_SDEN3_MARK = 3900,
	PORT153_MSIOF2_SS1_MARK = 3901,
	SCIFA2_TXD1_MARK = 3902,
	MSIOF2_MCK0_MARK = 3903,
	SCIFA2_RXD1_MARK = 3904,
	MSIOF2_MCK1_MARK = 3905,
	SCIFA2_RTS1__MARK = 3906,
	PORT156_MSIOF2_SS2_MARK = 3907,
	SCIFA2_CTS1__MARK = 3908,
	PORT157_MSIOF2_RXD_MARK = 3909,
	DINT__MARK = 3910,
	SCIFA2_SCK1_MARK = 3911,
	TS_SCK3_MARK = 3912,
	PORT159_SCIFB_SCK_MARK = 3913,
	PORT159_SCIFA5_SCK_MARK = 3914,
	NMI_MARK = 3915,
	PORT160_SCIFB_TXD_MARK = 3916,
	PORT160_SCIFA5_TXD_MARK = 3917,
	PORT161_SCIFB_CTS__MARK = 3918,
	PORT161_SCIFA5_CTS__MARK = 3919,
	PORT162_SCIFB_RXD_MARK = 3920,
	PORT162_SCIFA5_RXD_MARK = 3921,
	PORT163_SCIFB_RTS__MARK = 3922,
	PORT163_SCIFA5_RTS__MARK = 3923,
	TPU3TO0_MARK = 3924,
	LCDD0_MARK = 3925,
	LCDD1_MARK = 3926,
	PORT193_SCIFA5_CTS__MARK = 3927,
	BBIF2_TSYNC1_MARK = 3928,
	LCDD2_MARK = 3929,
	PORT194_SCIFA5_RTS__MARK = 3930,
	BBIF2_TSCK1_MARK = 3931,
	LCDD3_MARK = 3932,
	PORT195_SCIFA5_RXD_MARK = 3933,
	BBIF2_TXD1_MARK = 3934,
	LCDD4_MARK = 3935,
	PORT196_SCIFA5_TXD_MARK = 3936,
	LCDD5_MARK = 3937,
	PORT197_SCIFA5_SCK_MARK = 3938,
	MFG2_OUT2_MARK = 3939,
	TPU2TO1_MARK = 3940,
	LCDD6_MARK = 3941,
	LCDD7_MARK = 3942,
	TPU4TO1_MARK = 3943,
	MFG4_OUT2_MARK = 3944,
	LCDD8_MARK = 3945,
	D16_MARK = 3946,
	LCDD9_MARK = 3947,
	D17_MARK = 3948,
	LCDD10_MARK = 3949,
	D18_MARK = 3950,
	LCDD11_MARK = 3951,
	D19_MARK = 3952,
	LCDD12_MARK = 3953,
	D20_MARK = 3954,
	LCDD13_MARK = 3955,
	D21_MARK = 3956,
	LCDD14_MARK = 3957,
	D22_MARK = 3958,
	LCDD15_MARK = 3959,
	PORT207_MSIOF0L_SS1_MARK = 3960,
	D23_MARK = 3961,
	LCDD16_MARK = 3962,
	PORT208_MSIOF0L_SS2_MARK = 3963,
	D24_MARK = 3964,
	LCDD17_MARK = 3965,
	D25_MARK = 3966,
	LCDD18_MARK = 3967,
	DREQ2_MARK = 3968,
	PORT210_MSIOF0L_SS1_MARK = 3969,
	D26_MARK = 3970,
	LCDD19_MARK = 3971,
	PORT211_MSIOF0L_SS2_MARK = 3972,
	D27_MARK = 3973,
	LCDD20_MARK = 3974,
	TS_SPSYNC1_MARK = 3975,
	MSIOF0L_MCK0_MARK = 3976,
	D28_MARK = 3977,
	LCDD21_MARK = 3978,
	TS_SDAT1_MARK = 3979,
	MSIOF0L_MCK1_MARK = 3980,
	D29_MARK = 3981,
	LCDD22_MARK = 3982,
	TS_SDEN1_MARK = 3983,
	MSIOF0L_RSCK_MARK = 3984,
	D30_MARK = 3985,
	LCDD23_MARK = 3986,
	TS_SCK1_MARK = 3987,
	MSIOF0L_RSYNC_MARK = 3988,
	D31_MARK = 3989,
	LCDDCK_MARK = 3990,
	LCDWR__MARK = 3991,
	LCDRD__MARK = 3992,
	DACK2_MARK___2 = 3993,
	PORT217_LCD2RS_MARK = 3994,
	MSIOF0L_TSYNC_MARK = 3995,
	VIO2_FIELD3_MARK = 3996,
	PORT217_LCD2DISP_MARK = 3997,
	LCDHSYN_MARK = 3998,
	LCDCS__MARK = 3999,
	LCDCS2__MARK = 4000,
	DACK3_MARK = 4001,
	PORT218_VIO_CKOR_MARK = 4002,
	LCDDISP_MARK = 4003,
	LCDRS_MARK = 4004,
	PORT219_LCD2WR__MARK = 4005,
	DREQ3_MARK = 4006,
	MSIOF0L_TSCK_MARK = 4007,
	VIO2_CLK3_MARK = 4008,
	LCD2DCK_2_MARK = 4009,
	LCDVSYN_MARK = 4010,
	LCDVSYN2_MARK = 4011,
	LCDLCLK_MARK = 4012,
	DREQ1_MARK = 4013,
	PORT221_LCD2CS__MARK = 4014,
	PWEN_MARK = 4015,
	MSIOF0L_RXD_MARK = 4016,
	VIO2_HD3_MARK = 4017,
	PORT221_LCD2HSYN_MARK = 4018,
	LCDDON_MARK = 4019,
	LCDDON2_MARK = 4020,
	DACK1_MARK___2 = 4021,
	OVCN_MARK = 4022,
	MSIOF0L_TXD_MARK = 4023,
	VIO2_VD3_MARK = 4024,
	PORT222_LCD2VSYN_MARK = 4025,
	SCIFA1_TXD_MARK___2 = 4026,
	OVCN2_MARK = 4027,
	EXTLP_MARK = 4028,
	SCIFA1_SCK_MARK___2 = 4029,
	PORT226_VIO_CKO2_MARK = 4030,
	SCIFA1_RTS__MARK = 4031,
	IDIN_MARK = 4032,
	SCIFA1_RXD_MARK___2 = 4033,
	SCIFA1_CTS__MARK = 4034,
	MFG1_IN1_MARK = 4035,
	MSIOF1_TXD_MARK___2 = 4036,
	SCIFA2_TXD2_MARK = 4037,
	MSIOF1_TSYNC_MARK = 4038,
	SCIFA2_CTS2__MARK = 4039,
	MSIOF1_TSCK_MARK = 4040,
	SCIFA2_SCK2_MARK = 4041,
	MSIOF1_RXD_MARK___2 = 4042,
	SCIFA2_RXD2_MARK = 4043,
	MSIOF1_RSCK_MARK = 4044,
	SCIFA2_RTS2__MARK = 4045,
	VIO2_CLK2_MARK = 4046,
	LCD2D20_MARK = 4047,
	MSIOF1_RSYNC_MARK = 4048,
	MFG1_IN2_MARK = 4049,
	VIO2_VD2_MARK = 4050,
	LCD2D21_MARK = 4051,
	MSIOF1_MCK0_MARK = 4052,
	PORT236_I2C_SDA2_MARK = 4053,
	MSIOF1_MCK1_MARK = 4054,
	PORT237_I2C_SCL2_MARK = 4055,
	MSIOF1_SS1_MARK___2 = 4056,
	VIO2_FIELD2_MARK = 4057,
	LCD2D22_MARK = 4058,
	MSIOF1_SS2_MARK___2 = 4059,
	VIO2_HD2_MARK = 4060,
	LCD2D23_MARK = 4061,
	SCIFA6_TXD_MARK = 4062,
	PORT241_IRDA_OUT_MARK = 4063,
	PORT241_IROUT_MARK = 4064,
	MFG4_OUT1_MARK = 4065,
	TPU4TO0_MARK = 4066,
	PORT242_IRDA_IN_MARK = 4067,
	MFG4_IN2_MARK = 4068,
	PORT243_IRDA_FIRSEL_MARK = 4069,
	PORT243_VIO_CKO2_MARK = 4070,
	PORT244_SCIFA5_CTS__MARK = 4071,
	MFG2_IN1_MARK = 4072,
	PORT244_SCIFB_CTS__MARK = 4073,
	MSIOF2R_RXD_MARK = 4074,
	PORT245_SCIFA5_RTS__MARK = 4075,
	MFG2_IN2_MARK = 4076,
	PORT245_SCIFB_RTS__MARK = 4077,
	MSIOF2R_TXD_MARK = 4078,
	PORT246_SCIFA5_RXD_MARK = 4079,
	MFG1_OUT1_MARK = 4080,
	PORT246_SCIFB_RXD_MARK = 4081,
	TPU1TO0_MARK = 4082,
	PORT247_SCIFA5_TXD_MARK = 4083,
	MFG3_OUT2_MARK = 4084,
	PORT247_SCIFB_TXD_MARK = 4085,
	TPU3TO1_MARK = 4086,
	PORT248_SCIFA5_SCK_MARK = 4087,
	MFG2_OUT1_MARK = 4088,
	PORT248_SCIFB_SCK_MARK = 4089,
	TPU2TO0_MARK = 4090,
	PORT248_I2C_SCL3_MARK = 4091,
	MSIOF2R_TSCK_MARK = 4092,
	PORT249_IROUT_MARK = 4093,
	MFG4_IN1_MARK = 4094,
	PORT249_I2C_SDA3_MARK = 4095,
	MSIOF2R_TSYNC_MARK = 4096,
	SDHICLK0_MARK = 4097,
	SDHICD0_MARK = 4098,
	SDHID0_0_MARK = 4099,
	SDHID0_1_MARK = 4100,
	SDHID0_2_MARK = 4101,
	SDHID0_3_MARK = 4102,
	SDHICMD0_MARK = 4103,
	SDHIWP0_MARK = 4104,
	SDHICLK1_MARK = 4105,
	SDHID1_0_MARK = 4106,
	TS_SPSYNC2_MARK = 4107,
	SDHID1_1_MARK = 4108,
	TS_SDAT2_MARK = 4109,
	SDHID1_2_MARK = 4110,
	TS_SDEN2_MARK = 4111,
	SDHID1_3_MARK = 4112,
	TS_SCK2_MARK = 4113,
	SDHICMD1_MARK = 4114,
	SDHICLK2_MARK = 4115,
	SDHID2_0_MARK = 4116,
	TS_SPSYNC4_MARK = 4117,
	SDHID2_1_MARK = 4118,
	TS_SDAT4_MARK = 4119,
	SDHID2_2_MARK = 4120,
	TS_SDEN4_MARK = 4121,
	SDHID2_3_MARK = 4122,
	TS_SCK4_MARK = 4123,
	SDHICMD2_MARK = 4124,
	MMCCLK0_MARK = 4125,
	MMCD0_0_MARK = 4126,
	MMCD0_1_MARK = 4127,
	MMCD0_2_MARK = 4128,
	MMCD0_3_MARK = 4129,
	MMCD0_4_MARK = 4130,
	TS_SPSYNC5_MARK = 4131,
	MMCD0_5_MARK = 4132,
	TS_SDAT5_MARK = 4133,
	MMCD0_6_MARK = 4134,
	TS_SDEN5_MARK = 4135,
	MMCD0_7_MARK = 4136,
	TS_SCK5_MARK = 4137,
	MMCCMD0_MARK = 4138,
	RESETOUTS__MARK = 4139,
	EXTAL2OUT_MARK = 4140,
	MCP_WAIT__MCP_FRB_MARK = 4141,
	MCP_CKO_MARK = 4142,
	MMCCLK1_MARK = 4143,
	MCP_D15_MCP_NAF15_MARK = 4144,
	MCP_D14_MCP_NAF14_MARK = 4145,
	MCP_D13_MCP_NAF13_MARK = 4146,
	MCP_D12_MCP_NAF12_MARK = 4147,
	MCP_D11_MCP_NAF11_MARK = 4148,
	MCP_D10_MCP_NAF10_MARK = 4149,
	MCP_D9_MCP_NAF9_MARK = 4150,
	MCP_D8_MCP_NAF8_MARK = 4151,
	MMCCMD1_MARK = 4152,
	MCP_D7_MCP_NAF7_MARK = 4153,
	MMCD1_7_MARK = 4154,
	MCP_D6_MCP_NAF6_MARK = 4155,
	MMCD1_6_MARK = 4156,
	MCP_D5_MCP_NAF5_MARK = 4157,
	MMCD1_5_MARK = 4158,
	MCP_D4_MCP_NAF4_MARK = 4159,
	MMCD1_4_MARK = 4160,
	MCP_D3_MCP_NAF3_MARK = 4161,
	MMCD1_3_MARK = 4162,
	MCP_D2_MCP_NAF2_MARK = 4163,
	MMCD1_2_MARK = 4164,
	MCP_D1_MCP_NAF1_MARK = 4165,
	MMCD1_1_MARK = 4166,
	MCP_D0_MCP_NAF0_MARK = 4167,
	MMCD1_0_MARK = 4168,
	MCP_NBRSTOUT__MARK = 4169,
	MCP_WE0__MCP_FWE_MARK = 4170,
	MCP_RDWR_MCP_FWE_MARK = 4171,
	TSIF2_TS_XX1_MARK = 4172,
	TSIF2_TS_XX2_MARK = 4173,
	TSIF2_TS_XX3_MARK = 4174,
	TSIF2_TS_XX4_MARK = 4175,
	TSIF2_TS_XX5_MARK = 4176,
	TSIF1_TS_XX1_MARK = 4177,
	TSIF1_TS_XX2_MARK = 4178,
	TSIF1_TS_XX3_MARK = 4179,
	TSIF1_TS_XX4_MARK = 4180,
	TSIF1_TS_XX5_MARK = 4181,
	TSIF0_TS_XX1_MARK = 4182,
	TSIF0_TS_XX2_MARK = 4183,
	TSIF0_TS_XX3_MARK = 4184,
	TSIF0_TS_XX4_MARK = 4185,
	TSIF0_TS_XX5_MARK = 4186,
	MST1_TS_XX1_MARK = 4187,
	MST1_TS_XX2_MARK = 4188,
	MST1_TS_XX3_MARK = 4189,
	MST1_TS_XX4_MARK = 4190,
	MST1_TS_XX5_MARK = 4191,
	MST0_TS_XX1_MARK = 4192,
	MST0_TS_XX2_MARK = 4193,
	MST0_TS_XX3_MARK = 4194,
	MST0_TS_XX4_MARK = 4195,
	MST0_TS_XX5_MARK = 4196,
	SDHI0_VCCQ_MC0_ON_MARK = 4197,
	SDHI0_VCCQ_MC0_OFF_MARK = 4198,
	DEBUG_MON_VIO_MARK = 4199,
	DEBUG_MON_LCDD_MARK = 4200,
	LCDC_LCDC0_MARK = 4201,
	LCDC_LCDC1_MARK = 4202,
	IRQ9_MEM_INT_MARK = 4203,
	IRQ9_MCP_INT_MARK = 4204,
	A11_MARK___2 = 4205,
	KEYOUT8_MARK = 4206,
	TPU4TO3_MARK = 4207,
	RESETA_N_PU_ON_MARK = 4208,
	RESETA_N_PU_OFF_MARK = 4209,
	EDBGREQ_PD_MARK = 4210,
	EDBGREQ_PU_MARK = 4211,
	PINMUX_MARK_END___2 = 4212,
};

enum {
	PINMUX_RESERVED___3 = 0,
	PINMUX_DATA_BEGIN___3 = 1,
	GP_0_0_DATA___2 = 2,
	GP_0_1_DATA___2 = 3,
	GP_0_2_DATA___2 = 4,
	GP_0_3_DATA___2 = 5,
	GP_0_4_DATA___2 = 6,
	GP_0_5_DATA___2 = 7,
	GP_0_6_DATA___2 = 8,
	GP_0_7_DATA___2 = 9,
	GP_0_8_DATA___2 = 10,
	GP_0_9_DATA___2 = 11,
	GP_0_10_DATA___2 = 12,
	GP_0_11_DATA___2 = 13,
	GP_0_12_DATA___2 = 14,
	GP_0_13_DATA___2 = 15,
	GP_0_14_DATA___2 = 16,
	GP_0_15_DATA___2 = 17,
	GP_0_16_DATA___2 = 18,
	GP_0_17_DATA___2 = 19,
	GP_0_18_DATA___2 = 20,
	GP_0_19_DATA___2 = 21,
	GP_0_20_DATA___2 = 22,
	GP_0_21_DATA___2 = 23,
	GP_0_22_DATA___2 = 24,
	GP_0_23_DATA___2 = 25,
	GP_0_24_DATA___2 = 26,
	GP_0_25_DATA___2 = 27,
	GP_0_26_DATA___2 = 28,
	GP_0_27_DATA___2 = 29,
	GP_0_28_DATA___2 = 30,
	GP_0_29_DATA___2 = 31,
	GP_0_30_DATA___2 = 32,
	GP_0_31_DATA___2 = 33,
	GP_1_0_DATA___2 = 34,
	GP_1_1_DATA___2 = 35,
	GP_1_2_DATA___2 = 36,
	GP_1_3_DATA___2 = 37,
	GP_1_4_DATA___2 = 38,
	GP_1_5_DATA___2 = 39,
	GP_1_6_DATA___2 = 40,
	GP_1_7_DATA___2 = 41,
	GP_1_8_DATA___2 = 42,
	GP_1_9_DATA___2 = 43,
	GP_1_10_DATA___2 = 44,
	GP_1_11_DATA___2 = 45,
	GP_1_12_DATA___2 = 46,
	GP_1_13_DATA___2 = 47,
	GP_1_14_DATA___2 = 48,
	GP_1_15_DATA___2 = 49,
	GP_1_16_DATA___2 = 50,
	GP_1_17_DATA___2 = 51,
	GP_1_18_DATA___2 = 52,
	GP_1_19_DATA___2 = 53,
	GP_1_20_DATA___2 = 54,
	GP_1_21_DATA___2 = 55,
	GP_1_22_DATA___2 = 56,
	GP_1_23_DATA___2 = 57,
	GP_1_24_DATA___2 = 58,
	GP_1_25_DATA___2 = 59,
	GP_2_0_DATA___2 = 60,
	GP_2_1_DATA___2 = 61,
	GP_2_2_DATA___2 = 62,
	GP_2_3_DATA___2 = 63,
	GP_2_4_DATA___2 = 64,
	GP_2_5_DATA___2 = 65,
	GP_2_6_DATA___2 = 66,
	GP_2_7_DATA___2 = 67,
	GP_2_8_DATA___2 = 68,
	GP_2_9_DATA___2 = 69,
	GP_2_10_DATA___2 = 70,
	GP_2_11_DATA___2 = 71,
	GP_2_12_DATA___2 = 72,
	GP_2_13_DATA___2 = 73,
	GP_2_14_DATA___2 = 74,
	GP_2_15_DATA___2 = 75,
	GP_2_16_DATA___2 = 76,
	GP_2_17_DATA___2 = 77,
	GP_2_18_DATA___2 = 78,
	GP_2_19_DATA___2 = 79,
	GP_2_20_DATA___2 = 80,
	GP_2_21_DATA___2 = 81,
	GP_2_22_DATA___2 = 82,
	GP_2_23_DATA___2 = 83,
	GP_2_24_DATA___2 = 84,
	GP_2_25_DATA___2 = 85,
	GP_2_26_DATA___2 = 86,
	GP_2_27_DATA___2 = 87,
	GP_2_28_DATA___2 = 88,
	GP_2_29_DATA___2 = 89,
	GP_2_30_DATA___2 = 90,
	GP_2_31_DATA___2 = 91,
	GP_3_0_DATA___2 = 92,
	GP_3_1_DATA___2 = 93,
	GP_3_2_DATA___2 = 94,
	GP_3_3_DATA___2 = 95,
	GP_3_4_DATA___2 = 96,
	GP_3_5_DATA___2 = 97,
	GP_3_6_DATA___2 = 98,
	GP_3_7_DATA___2 = 99,
	GP_3_8_DATA___2 = 100,
	GP_3_9_DATA___2 = 101,
	GP_3_10_DATA___2 = 102,
	GP_3_11_DATA___2 = 103,
	GP_3_12_DATA___2 = 104,
	GP_3_13_DATA___2 = 105,
	GP_3_14_DATA___2 = 106,
	GP_3_15_DATA___2 = 107,
	GP_3_16_DATA___2 = 108,
	GP_3_17_DATA___2 = 109,
	GP_3_18_DATA___2 = 110,
	GP_3_19_DATA___2 = 111,
	GP_3_20_DATA___2 = 112,
	GP_3_21_DATA___2 = 113,
	GP_3_22_DATA___2 = 114,
	GP_3_23_DATA___2 = 115,
	GP_3_24_DATA___2 = 116,
	GP_3_25_DATA___2 = 117,
	GP_3_26_DATA___2 = 118,
	GP_3_27_DATA___2 = 119,
	GP_3_28_DATA___2 = 120,
	GP_3_29_DATA___2 = 121,
	GP_3_30_DATA___2 = 122,
	GP_3_31_DATA___2 = 123,
	GP_4_0_DATA___2 = 124,
	GP_4_1_DATA___2 = 125,
	GP_4_2_DATA___2 = 126,
	GP_4_3_DATA___2 = 127,
	GP_4_4_DATA___2 = 128,
	GP_4_5_DATA___2 = 129,
	GP_4_6_DATA___2 = 130,
	GP_4_7_DATA___2 = 131,
	GP_4_8_DATA___2 = 132,
	GP_4_9_DATA___2 = 133,
	GP_4_10_DATA___2 = 134,
	GP_4_11_DATA___2 = 135,
	GP_4_12_DATA___2 = 136,
	GP_4_13_DATA___2 = 137,
	GP_4_14_DATA___2 = 138,
	GP_4_15_DATA___2 = 139,
	GP_4_16_DATA___2 = 140,
	GP_4_17_DATA___2 = 141,
	GP_4_18_DATA___2 = 142,
	GP_4_19_DATA___2 = 143,
	GP_4_20_DATA___2 = 144,
	GP_4_21_DATA___2 = 145,
	GP_4_22_DATA___2 = 146,
	GP_4_23_DATA___2 = 147,
	GP_4_24_DATA___2 = 148,
	GP_4_25_DATA___2 = 149,
	GP_4_26_DATA___2 = 150,
	GP_4_27_DATA___2 = 151,
	GP_4_28_DATA___2 = 152,
	GP_4_29_DATA___2 = 153,
	GP_4_30_DATA___2 = 154,
	GP_4_31_DATA___2 = 155,
	GP_5_0_DATA___2 = 156,
	GP_5_1_DATA___2 = 157,
	GP_5_2_DATA___2 = 158,
	GP_5_3_DATA___2 = 159,
	GP_5_4_DATA___2 = 160,
	GP_5_5_DATA___2 = 161,
	GP_5_6_DATA___2 = 162,
	GP_5_7_DATA___2 = 163,
	GP_5_8_DATA___2 = 164,
	GP_5_9_DATA___2 = 165,
	GP_5_10_DATA___2 = 166,
	GP_5_11_DATA___2 = 167,
	GP_5_12_DATA___2 = 168,
	GP_5_13_DATA___2 = 169,
	GP_5_14_DATA___2 = 170,
	GP_5_15_DATA___2 = 171,
	GP_5_16_DATA___2 = 172,
	GP_5_17_DATA___2 = 173,
	GP_5_18_DATA___2 = 174,
	GP_5_19_DATA___2 = 175,
	GP_5_20_DATA___2 = 176,
	GP_5_21_DATA___2 = 177,
	GP_5_22_DATA___2 = 178,
	GP_5_23_DATA___2 = 179,
	GP_5_24_DATA___2 = 180,
	GP_5_25_DATA___2 = 181,
	GP_5_26_DATA___2 = 182,
	GP_5_27_DATA___2 = 183,
	GP_5_28_DATA = 184,
	GP_5_29_DATA = 185,
	GP_5_30_DATA = 186,
	GP_5_31_DATA = 187,
	GP_6_0_DATA___2 = 188,
	GP_6_1_DATA___2 = 189,
	GP_6_2_DATA___2 = 190,
	GP_6_3_DATA___2 = 191,
	GP_6_4_DATA___2 = 192,
	GP_6_5_DATA___2 = 193,
	GP_6_6_DATA___2 = 194,
	GP_6_7_DATA___2 = 195,
	GP_6_8_DATA___2 = 196,
	GP_6_9_DATA___2 = 197,
	GP_6_10_DATA___2 = 198,
	GP_6_11_DATA___2 = 199,
	GP_6_12_DATA___2 = 200,
	GP_6_13_DATA___2 = 201,
	GP_6_14_DATA___2 = 202,
	GP_6_15_DATA___2 = 203,
	GP_6_16_DATA___2 = 204,
	GP_6_17_DATA___2 = 205,
	GP_6_18_DATA___2 = 206,
	GP_6_19_DATA___2 = 207,
	GP_6_20_DATA___2 = 208,
	GP_6_21_DATA___2 = 209,
	GP_6_22_DATA___2 = 210,
	GP_6_23_DATA___2 = 211,
	GP_6_24_DATA___2 = 212,
	GP_6_25_DATA___2 = 213,
	GP_6_26_DATA = 214,
	GP_6_27_DATA = 215,
	GP_6_28_DATA = 216,
	GP_6_29_DATA = 217,
	GP_6_30_DATA = 218,
	GP_6_31_DATA = 219,
	GP_7_0_DATA = 220,
	GP_7_1_DATA = 221,
	GP_7_2_DATA = 222,
	GP_7_3_DATA = 223,
	GP_7_4_DATA = 224,
	GP_7_5_DATA = 225,
	GP_7_6_DATA = 226,
	GP_7_7_DATA = 227,
	GP_7_8_DATA = 228,
	GP_7_9_DATA = 229,
	GP_7_10_DATA = 230,
	GP_7_11_DATA = 231,
	GP_7_12_DATA = 232,
	GP_7_13_DATA = 233,
	GP_7_14_DATA = 234,
	GP_7_15_DATA = 235,
	GP_7_16_DATA = 236,
	GP_7_17_DATA = 237,
	GP_7_18_DATA = 238,
	GP_7_19_DATA = 239,
	GP_7_20_DATA = 240,
	GP_7_21_DATA = 241,
	GP_7_22_DATA = 242,
	GP_7_23_DATA = 243,
	GP_7_24_DATA = 244,
	GP_7_25_DATA = 245,
	PINMUX_DATA_END___3 = 246,
	PINMUX_FUNCTION_BEGIN___3 = 247,
	GP_0_0_FN___2 = 248,
	GP_0_1_FN___2 = 249,
	GP_0_2_FN___2 = 250,
	GP_0_3_FN___2 = 251,
	GP_0_4_FN___2 = 252,
	GP_0_5_FN___2 = 253,
	GP_0_6_FN___2 = 254,
	GP_0_7_FN___2 = 255,
	GP_0_8_FN___2 = 256,
	GP_0_9_FN___2 = 257,
	GP_0_10_FN___2 = 258,
	GP_0_11_FN___2 = 259,
	GP_0_12_FN___2 = 260,
	GP_0_13_FN___2 = 261,
	GP_0_14_FN___2 = 262,
	GP_0_15_FN___2 = 263,
	GP_0_16_FN___2 = 264,
	GP_0_17_FN___2 = 265,
	GP_0_18_FN___2 = 266,
	GP_0_19_FN___2 = 267,
	GP_0_20_FN___2 = 268,
	GP_0_21_FN___2 = 269,
	GP_0_22_FN___2 = 270,
	GP_0_23_FN___2 = 271,
	GP_0_24_FN___2 = 272,
	GP_0_25_FN___2 = 273,
	GP_0_26_FN___2 = 274,
	GP_0_27_FN___2 = 275,
	GP_0_28_FN___2 = 276,
	GP_0_29_FN___2 = 277,
	GP_0_30_FN___2 = 278,
	GP_0_31_FN___2 = 279,
	GP_1_0_FN___2 = 280,
	GP_1_1_FN___2 = 281,
	GP_1_2_FN___2 = 282,
	GP_1_3_FN___2 = 283,
	GP_1_4_FN___2 = 284,
	GP_1_5_FN___2 = 285,
	GP_1_6_FN___2 = 286,
	GP_1_7_FN___2 = 287,
	GP_1_8_FN___2 = 288,
	GP_1_9_FN___2 = 289,
	GP_1_10_FN___2 = 290,
	GP_1_11_FN___2 = 291,
	GP_1_12_FN___2 = 292,
	GP_1_13_FN___2 = 293,
	GP_1_14_FN___2 = 294,
	GP_1_15_FN___2 = 295,
	GP_1_16_FN___2 = 296,
	GP_1_17_FN___2 = 297,
	GP_1_18_FN___2 = 298,
	GP_1_19_FN___2 = 299,
	GP_1_20_FN___2 = 300,
	GP_1_21_FN___2 = 301,
	GP_1_22_FN___2 = 302,
	GP_1_23_FN___2 = 303,
	GP_1_24_FN___2 = 304,
	GP_1_25_FN___2 = 305,
	GP_2_0_FN___2 = 306,
	GP_2_1_FN___2 = 307,
	GP_2_2_FN___2 = 308,
	GP_2_3_FN___2 = 309,
	GP_2_4_FN___2 = 310,
	GP_2_5_FN___2 = 311,
	GP_2_6_FN___2 = 312,
	GP_2_7_FN___2 = 313,
	GP_2_8_FN___2 = 314,
	GP_2_9_FN___2 = 315,
	GP_2_10_FN___2 = 316,
	GP_2_11_FN___2 = 317,
	GP_2_12_FN___2 = 318,
	GP_2_13_FN___2 = 319,
	GP_2_14_FN___2 = 320,
	GP_2_15_FN___2 = 321,
	GP_2_16_FN___2 = 322,
	GP_2_17_FN___2 = 323,
	GP_2_18_FN___2 = 324,
	GP_2_19_FN___2 = 325,
	GP_2_20_FN___2 = 326,
	GP_2_21_FN___2 = 327,
	GP_2_22_FN___2 = 328,
	GP_2_23_FN___2 = 329,
	GP_2_24_FN___2 = 330,
	GP_2_25_FN___2 = 331,
	GP_2_26_FN___2 = 332,
	GP_2_27_FN___2 = 333,
	GP_2_28_FN___2 = 334,
	GP_2_29_FN___2 = 335,
	GP_2_30_FN___2 = 336,
	GP_2_31_FN___2 = 337,
	GP_3_0_FN___2 = 338,
	GP_3_1_FN___2 = 339,
	GP_3_2_FN___2 = 340,
	GP_3_3_FN___2 = 341,
	GP_3_4_FN___2 = 342,
	GP_3_5_FN___2 = 343,
	GP_3_6_FN___2 = 344,
	GP_3_7_FN___2 = 345,
	GP_3_8_FN___2 = 346,
	GP_3_9_FN___2 = 347,
	GP_3_10_FN___2 = 348,
	GP_3_11_FN___2 = 349,
	GP_3_12_FN___2 = 350,
	GP_3_13_FN___2 = 351,
	GP_3_14_FN___2 = 352,
	GP_3_15_FN___2 = 353,
	GP_3_16_FN___2 = 354,
	GP_3_17_FN___2 = 355,
	GP_3_18_FN___2 = 356,
	GP_3_19_FN___2 = 357,
	GP_3_20_FN___2 = 358,
	GP_3_21_FN___2 = 359,
	GP_3_22_FN___2 = 360,
	GP_3_23_FN___2 = 361,
	GP_3_24_FN___2 = 362,
	GP_3_25_FN___2 = 363,
	GP_3_26_FN___2 = 364,
	GP_3_27_FN___2 = 365,
	GP_3_28_FN___2 = 366,
	GP_3_29_FN___2 = 367,
	GP_3_30_FN___2 = 368,
	GP_3_31_FN___2 = 369,
	GP_4_0_FN___2 = 370,
	GP_4_1_FN___2 = 371,
	GP_4_2_FN___2 = 372,
	GP_4_3_FN___2 = 373,
	GP_4_4_FN___2 = 374,
	GP_4_5_FN___2 = 375,
	GP_4_6_FN___2 = 376,
	GP_4_7_FN___2 = 377,
	GP_4_8_FN___2 = 378,
	GP_4_9_FN___2 = 379,
	GP_4_10_FN___2 = 380,
	GP_4_11_FN___2 = 381,
	GP_4_12_FN___2 = 382,
	GP_4_13_FN___2 = 383,
	GP_4_14_FN___2 = 384,
	GP_4_15_FN___2 = 385,
	GP_4_16_FN___2 = 386,
	GP_4_17_FN___2 = 387,
	GP_4_18_FN___2 = 388,
	GP_4_19_FN___2 = 389,
	GP_4_20_FN___2 = 390,
	GP_4_21_FN___2 = 391,
	GP_4_22_FN___2 = 392,
	GP_4_23_FN___2 = 393,
	GP_4_24_FN___2 = 394,
	GP_4_25_FN___2 = 395,
	GP_4_26_FN___2 = 396,
	GP_4_27_FN___2 = 397,
	GP_4_28_FN___2 = 398,
	GP_4_29_FN___2 = 399,
	GP_4_30_FN___2 = 400,
	GP_4_31_FN___2 = 401,
	GP_5_0_FN___2 = 402,
	GP_5_1_FN___2 = 403,
	GP_5_2_FN___2 = 404,
	GP_5_3_FN___2 = 405,
	GP_5_4_FN___2 = 406,
	GP_5_5_FN___2 = 407,
	GP_5_6_FN___2 = 408,
	GP_5_7_FN___2 = 409,
	GP_5_8_FN___2 = 410,
	GP_5_9_FN___2 = 411,
	GP_5_10_FN___2 = 412,
	GP_5_11_FN___2 = 413,
	GP_5_12_FN___2 = 414,
	GP_5_13_FN___2 = 415,
	GP_5_14_FN___2 = 416,
	GP_5_15_FN___2 = 417,
	GP_5_16_FN___2 = 418,
	GP_5_17_FN___2 = 419,
	GP_5_18_FN___2 = 420,
	GP_5_19_FN___2 = 421,
	GP_5_20_FN___2 = 422,
	GP_5_21_FN___2 = 423,
	GP_5_22_FN___2 = 424,
	GP_5_23_FN___2 = 425,
	GP_5_24_FN___2 = 426,
	GP_5_25_FN___2 = 427,
	GP_5_26_FN___2 = 428,
	GP_5_27_FN___2 = 429,
	GP_5_28_FN = 430,
	GP_5_29_FN = 431,
	GP_5_30_FN = 432,
	GP_5_31_FN = 433,
	GP_6_0_FN___2 = 434,
	GP_6_1_FN___2 = 435,
	GP_6_2_FN___2 = 436,
	GP_6_3_FN___2 = 437,
	GP_6_4_FN___2 = 438,
	GP_6_5_FN___2 = 439,
	GP_6_6_FN___2 = 440,
	GP_6_7_FN___2 = 441,
	GP_6_8_FN___2 = 442,
	GP_6_9_FN___2 = 443,
	GP_6_10_FN___2 = 444,
	GP_6_11_FN___2 = 445,
	GP_6_12_FN___2 = 446,
	GP_6_13_FN___2 = 447,
	GP_6_14_FN___2 = 448,
	GP_6_15_FN___2 = 449,
	GP_6_16_FN___2 = 450,
	GP_6_17_FN___2 = 451,
	GP_6_18_FN___2 = 452,
	GP_6_19_FN___2 = 453,
	GP_6_20_FN___2 = 454,
	GP_6_21_FN___2 = 455,
	GP_6_22_FN___2 = 456,
	GP_6_23_FN___2 = 457,
	GP_6_24_FN___2 = 458,
	GP_6_25_FN___2 = 459,
	GP_6_26_FN = 460,
	GP_6_27_FN = 461,
	GP_6_28_FN = 462,
	GP_6_29_FN = 463,
	GP_6_30_FN = 464,
	GP_6_31_FN = 465,
	GP_7_0_FN = 466,
	GP_7_1_FN = 467,
	GP_7_2_FN = 468,
	GP_7_3_FN = 469,
	GP_7_4_FN = 470,
	GP_7_5_FN = 471,
	GP_7_6_FN = 472,
	GP_7_7_FN = 473,
	GP_7_8_FN = 474,
	GP_7_9_FN = 475,
	GP_7_10_FN = 476,
	GP_7_11_FN = 477,
	GP_7_12_FN = 478,
	GP_7_13_FN = 479,
	GP_7_14_FN = 480,
	GP_7_15_FN = 481,
	GP_7_16_FN = 482,
	GP_7_17_FN = 483,
	GP_7_18_FN = 484,
	GP_7_19_FN = 485,
	GP_7_20_FN = 486,
	GP_7_21_FN = 487,
	GP_7_22_FN = 488,
	GP_7_23_FN = 489,
	GP_7_24_FN = 490,
	GP_7_25_FN = 491,
	FN_IP0_0___2 = 492,
	FN_IP0_1 = 493,
	FN_IP0_2 = 494,
	FN_IP0_3 = 495,
	FN_IP0_4 = 496,
	FN_IP0_5 = 497,
	FN_IP0_6 = 498,
	FN_IP0_7 = 499,
	FN_IP0_8 = 500,
	FN_IP0_9 = 501,
	FN_IP0_10___2 = 502,
	FN_IP0_11___2 = 503,
	FN_IP0_12___2 = 504,
	FN_IP0_13___2 = 505,
	FN_IP0_14___2 = 506,
	FN_IP0_15___2 = 507,
	FN_IP0_18_16 = 508,
	FN_IP0_20_19 = 509,
	FN_IP0_22_21 = 510,
	FN_IP0_24_23 = 511,
	FN_IP0_26_25 = 512,
	FN_IP0_28_27 = 513,
	FN_IP0_30_29 = 514,
	FN_IP1_1_0___2 = 515,
	FN_IP1_3_2___2 = 516,
	FN_IP1_5_4___2 = 517,
	FN_IP1_7_6___2 = 518,
	FN_IP1_10_8___2 = 519,
	FN_IP1_13_11 = 520,
	FN_IP1_16_14 = 521,
	FN_IP1_19_17 = 522,
	FN_IP1_22_20 = 523,
	FN_IP1_25_23 = 524,
	FN_IP1_28_26 = 525,
	FN_IP1_31_29 = 526,
	FN_IP2_2_0 = 527,
	FN_IP2_4_3 = 528,
	FN_IP2_6_5 = 529,
	FN_IP2_9_7 = 530,
	FN_IP2_12_10 = 531,
	FN_IP2_15_13 = 532,
	FN_IP2_18_16 = 533,
	FN_IP2_20_19 = 534,
	FN_IP2_22_21 = 535,
	FN_EX_CS0_N___2 = 536,
	FN_IP2_24_23 = 537,
	FN_IP2_26_25 = 538,
	FN_IP2_29_27___2 = 539,
	FN_IP3_2_0 = 540,
	FN_IP3_5_3 = 541,
	FN_IP3_8_6 = 542,
	FN_RD_N___2 = 543,
	FN_IP3_11_9 = 544,
	FN_IP3_13_12 = 545,
	FN_IP3_15_14 = 546,
	FN_IP3_17_16 = 547,
	FN_IP3_19_18 = 548,
	FN_IP3_21_20 = 549,
	FN_IP3_27_25 = 550,
	FN_IP3_30_28 = 551,
	FN_IP4_1_0___2 = 552,
	FN_IP4_4_2___2 = 553,
	FN_IP4_7_5___2 = 554,
	FN_IP4_9_8___2 = 555,
	FN_IP4_12_10 = 556,
	FN_IP4_15_13 = 557,
	FN_IP4_18_16 = 558,
	FN_IP4_19 = 559,
	FN_IP4_20 = 560,
	FN_IP4_21 = 561,
	FN_IP4_23_22 = 562,
	FN_IP4_25_24 = 563,
	FN_IP4_27_26___2 = 564,
	FN_IP4_30_28 = 565,
	FN_IP5_2_0 = 566,
	FN_IP5_5_3 = 567,
	FN_IP5_8_6___2 = 568,
	FN_IP5_11_9___2 = 569,
	FN_IP5_14_12 = 570,
	FN_IP5_16_15 = 571,
	FN_IP5_19_17 = 572,
	FN_IP5_21_20___2 = 573,
	FN_IP5_23_22___2 = 574,
	FN_IP5_25_24___2 = 575,
	FN_IP5_28_26 = 576,
	FN_IP5_31_29 = 577,
	FN_AUDIO_CLKA___2 = 578,
	FN_IP6_2_0 = 579,
	FN_IP6_5_3 = 580,
	FN_IP6_7_6___2 = 581,
	FN_IP7_5_3___2 = 582,
	FN_IP7_8_6___2 = 583,
	FN_IP7_10_9 = 584,
	FN_IP7_12_11 = 585,
	FN_IP7_14_13 = 586,
	FN_IP7_16_15 = 587,
	FN_IP7_18_17 = 588,
	FN_IP7_20_19 = 589,
	FN_IP7_23_21___2 = 590,
	FN_IP7_26_24___2 = 591,
	FN_IP7_29_27___2 = 592,
	FN_IP8_2_0___2 = 593,
	FN_IP8_5_3___2 = 594,
	FN_IP8_8_6___2 = 595,
	FN_IP8_11_9___2 = 596,
	FN_IP8_14_12___2 = 597,
	FN_IP8_17_15 = 598,
	FN_IP8_20_18 = 599,
	FN_IP8_23_21 = 600,
	FN_IP8_25_24 = 601,
	FN_IP8_27_26 = 602,
	FN_IP8_30_28 = 603,
	FN_IP9_2_0___2 = 604,
	FN_IP9_5_3___2 = 605,
	FN_IP9_6 = 606,
	FN_IP9_7 = 607,
	FN_IP9_10_8 = 608,
	FN_IP9_11 = 609,
	FN_IP9_12 = 610,
	FN_IP9_15_13 = 611,
	FN_IP9_16 = 612,
	FN_IP9_18_17___2 = 613,
	FN_VI0_CLK___2 = 614,
	FN_IP9_20_19 = 615,
	FN_IP9_22_21 = 616,
	FN_IP9_24_23 = 617,
	FN_IP9_26_25 = 618,
	FN_VI0_DATA0_VI0_B0___2 = 619,
	FN_VI0_DATA1_VI0_B1___2 = 620,
	FN_VI0_DATA2_VI0_B2___2 = 621,
	FN_IP9_28_27 = 622,
	FN_VI0_DATA4_VI0_B4___2 = 623,
	FN_VI0_DATA5_VI0_B5___2 = 624,
	FN_VI0_DATA6_VI0_B6___2 = 625,
	FN_VI0_DATA7_VI0_B7___2 = 626,
	FN_IP9_31_29 = 627,
	FN_IP10_2_0___2 = 628,
	FN_IP10_5_3___2 = 629,
	FN_IP10_8_6___2 = 630,
	FN_IP10_11_9___2 = 631,
	FN_IP10_14_12___2 = 632,
	FN_IP10_16_15 = 633,
	FN_IP10_18_17 = 634,
	FN_IP10_21_19 = 635,
	FN_IP10_24_22 = 636,
	FN_IP10_26_25 = 637,
	FN_IP10_28_27 = 638,
	FN_IP10_31_29 = 639,
	FN_IP11_2_0___2 = 640,
	FN_IP11_5_3___2 = 641,
	FN_IP11_8_6 = 642,
	FN_IP15_1_0 = 643,
	FN_IP15_3_2 = 644,
	FN_IP15_5_4 = 645,
	FN_IP11_11_9 = 646,
	FN_IP11_14_12 = 647,
	FN_IP11_16_15 = 648,
	FN_IP11_18_17 = 649,
	FN_IP11_19 = 650,
	FN_IP11_20 = 651,
	FN_IP11_21 = 652,
	FN_IP11_22 = 653,
	FN_IP11_23 = 654,
	FN_IP11_24 = 655,
	FN_IP11_25 = 656,
	FN_IP11_26 = 657,
	FN_IP11_27 = 658,
	FN_IP11_29_28 = 659,
	FN_IP11_31_30 = 660,
	FN_IP12_1_0 = 661,
	FN_IP12_3_2 = 662,
	FN_IP12_6_4 = 663,
	FN_IP12_9_7 = 664,
	FN_IP12_12_10 = 665,
	FN_IP12_15_13 = 666,
	FN_IP12_17_16 = 667,
	FN_IP12_19_18 = 668,
	FN_IP12_21_20 = 669,
	FN_IP12_23_22 = 670,
	FN_IP12_26_24___2 = 671,
	FN_IP12_29_27___2 = 672,
	FN_IP13_2_0___2 = 673,
	FN_IP13_4_3 = 674,
	FN_IP13_6_5 = 675,
	FN_IP13_9_7 = 676,
	FN_IP3_24_22 = 677,
	FN_IP13_10 = 678,
	FN_IP13_11 = 679,
	FN_IP13_12 = 680,
	FN_IP13_13 = 681,
	FN_IP13_14 = 682,
	FN_IP13_15 = 683,
	FN_IP13_18_16 = 684,
	FN_IP13_21_19 = 685,
	FN_IP13_22 = 686,
	FN_IP13_24_23 = 687,
	FN_SD1_CLK___2 = 688,
	FN_IP13_25 = 689,
	FN_IP13_26 = 690,
	FN_IP13_27 = 691,
	FN_IP13_30_28 = 692,
	FN_IP14_1_0 = 693,
	FN_IP14_2 = 694,
	FN_IP14_3 = 695,
	FN_IP14_4 = 696,
	FN_IP14_5 = 697,
	FN_IP14_6 = 698,
	FN_IP14_7 = 699,
	FN_IP14_10_8 = 700,
	FN_IP14_13_11 = 701,
	FN_IP14_16_14 = 702,
	FN_IP14_19_17 = 703,
	FN_IP14_22_20 = 704,
	FN_IP14_25_23 = 705,
	FN_IP14_28_26 = 706,
	FN_IP14_31_29 = 707,
	FN_USB1_OVC___2 = 708,
	FN_DU0_DOTCLKIN___2 = 709,
	FN_IP15_17_15 = 710,
	FN_IP15_20_18 = 711,
	FN_IP15_23_21 = 712,
	FN_IP15_26_24 = 713,
	FN_IP15_29_27 = 714,
	FN_IP16_2_0 = 715,
	FN_IP16_5_3 = 716,
	FN_IP16_7_6 = 717,
	FN_IP16_9_8 = 718,
	FN_IP16_11_10 = 719,
	FN_IP6_9_8 = 720,
	FN_IP6_11_10 = 721,
	FN_IP6_13_12 = 722,
	FN_IP6_15_14 = 723,
	FN_IP6_18_16 = 724,
	FN_IP6_20_19 = 725,
	FN_IP6_23_21 = 726,
	FN_IP6_26_24 = 727,
	FN_IP6_29_27 = 728,
	FN_IP7_2_0___2 = 729,
	FN_IP15_8_6 = 730,
	FN_IP15_11_9 = 731,
	FN_IP15_14_12 = 732,
	FN_USB0_PWEN___2 = 733,
	FN_USB0_OVC___2 = 734,
	FN_USB1_PWEN___2 = 735,
	FN_D0___2 = 736,
	FN_D1___2 = 737,
	FN_D2___2 = 738,
	FN_D3___2 = 739,
	FN_D4___2 = 740,
	FN_D5___2 = 741,
	FN_D6___2 = 742,
	FN_D7___2 = 743,
	FN_D8___2 = 744,
	FN_D9___2 = 745,
	FN_D10___2 = 746,
	FN_D11___2 = 747,
	FN_D12___2 = 748,
	FN_D13___2 = 749,
	FN_D14___2 = 750,
	FN_D15___2 = 751,
	FN_A0___2 = 752,
	FN_ATAWR0_N_C = 753,
	FN_MSIOF0_SCK_B = 754,
	FN_I2C0_SCL_C___2 = 755,
	FN_PWM2_B___2 = 756,
	FN_A1___2 = 757,
	FN_MSIOF0_SYNC_B = 758,
	FN_A2___2 = 759,
	FN_MSIOF0_SS1_B = 760,
	FN_A3___2 = 761,
	FN_MSIOF0_SS2_B = 762,
	FN_A4___2 = 763,
	FN_MSIOF0_TXD_B = 764,
	FN_A5___2 = 765,
	FN_MSIOF0_RXD_B = 766,
	FN_A6___2 = 767,
	FN_MSIOF1_SCK___2 = 768,
	FN_A7___2 = 769,
	FN_MSIOF1_SYNC___2 = 770,
	FN_A8___2 = 771,
	FN_MSIOF1_SS1___2 = 772,
	FN_I2C0_SCL___2 = 773,
	FN_A9___2 = 774,
	FN_MSIOF1_SS2___2 = 775,
	FN_I2C0_SDA___2 = 776,
	FN_A10___2 = 777,
	FN_MSIOF1_TXD___2 = 778,
	FN_MSIOF1_TXD_D = 779,
	FN_A11___2 = 780,
	FN_MSIOF1_RXD___2 = 781,
	FN_I2C3_SCL_D___2 = 782,
	FN_MSIOF1_RXD_D = 783,
	FN_A12___2 = 784,
	FN_FMCLK___2 = 785,
	FN_I2C3_SDA_D___2 = 786,
	FN_MSIOF1_SCK_D = 787,
	FN_A13___2 = 788,
	FN_ATAG0_N_C = 789,
	FN_BPFCLK___2 = 790,
	FN_MSIOF1_SS1_D = 791,
	FN_A14___2 = 792,
	FN_ATADIR0_N_C = 793,
	FN_FMIN___2 = 794,
	FN_FMIN_C___2 = 795,
	FN_MSIOF1_SYNC_D = 796,
	FN_A15___2 = 797,
	FN_BPFCLK_C___2 = 798,
	FN_A16___2 = 799,
	FN_DREQ2_B = 800,
	FN_FMCLK_C___2 = 801,
	FN_SCIFA1_SCK_B___2 = 802,
	FN_A17___2 = 803,
	FN_DACK2_B = 804,
	FN_I2C0_SDA_C___2 = 805,
	FN_A18___2 = 806,
	FN_DREQ1 = 807,
	FN_SCIFA1_RXD_C___2 = 808,
	FN_SCIFB1_RXD_C = 809,
	FN_A19___2 = 810,
	FN_DACK1___2 = 811,
	FN_SCIFA1_TXD_C___2 = 812,
	FN_SCIFB1_TXD_C = 813,
	FN_SCIFB1_SCK_B = 814,
	FN_A20___2 = 815,
	FN_SPCLK___2 = 816,
	FN_A21___2 = 817,
	FN_ATAWR0_N_B = 818,
	FN_MOSI_IO0___2 = 819,
	FN_A22___2 = 820,
	FN_MISO_IO1___2 = 821,
	FN_FMCLK_B___2 = 822,
	FN_TX0 = 823,
	FN_SCIFA0_TXD___2 = 824,
	FN_A23___2 = 825,
	FN_IO2___2 = 826,
	FN_BPFCLK_B___2 = 827,
	FN_RX0 = 828,
	FN_SCIFA0_RXD___2 = 829,
	FN_A24___2 = 830,
	FN_DREQ2 = 831,
	FN_IO3___2 = 832,
	FN_TX1 = 833,
	FN_SCIFA1_TXD___2 = 834,
	FN_A25___2 = 835,
	FN_DACK2___2 = 836,
	FN_SSL___2 = 837,
	FN_DREQ1_C = 838,
	FN_RX1 = 839,
	FN_SCIFA1_RXD___2 = 840,
	FN_CS0_N___2 = 841,
	FN_ATAG0_N_B = 842,
	FN_I2C1_SCL___2 = 843,
	FN_CS1_N_A26___2 = 844,
	FN_ATADIR0_N_B = 845,
	FN_I2C1_SDA___2 = 846,
	FN_EX_CS1_N___2 = 847,
	FN_MSIOF2_SCK___2 = 848,
	FN_EX_CS2_N___2 = 849,
	FN_ATAWR0_N___2 = 850,
	FN_MSIOF2_SYNC___2 = 851,
	FN_EX_CS3_N___2 = 852,
	FN_ATADIR0_N___2 = 853,
	FN_MSIOF2_TXD___2 = 854,
	FN_ATAG0_N___2 = 855,
	FN_EX_WAIT1___2 = 856,
	FN_EX_CS4_N___2 = 857,
	FN_ATARD0_N___2 = 858,
	FN_MSIOF2_RXD___2 = 859,
	FN_EX_WAIT2___2 = 860,
	FN_EX_CS5_N___2 = 861,
	FN_ATACS00_N___2 = 862,
	FN_MSIOF2_SS1___2 = 863,
	FN_HRX1_B = 864,
	FN_SCIFB1_RXD_B = 865,
	FN_PWM1___2 = 866,
	FN_TPU_TO1 = 867,
	FN_BS_N___2 = 868,
	FN_ATACS10_N___2 = 869,
	FN_MSIOF2_SS2___2 = 870,
	FN_HTX1_B = 871,
	FN_SCIFB1_TXD_B = 872,
	FN_PWM2___2 = 873,
	FN_TPU_TO2 = 874,
	FN_RD_WR_N___2 = 875,
	FN_HRX2_B = 876,
	FN_FMIN_B___2 = 877,
	FN_SCIFB0_RXD_B = 878,
	FN_DREQ1_D = 879,
	FN_WE0_N___2 = 880,
	FN_HCTS2_N_B = 881,
	FN_SCIFB0_TXD_B = 882,
	FN_WE1_N___2 = 883,
	FN_ATARD0_N_B = 884,
	FN_HTX2_B = 885,
	FN_SCIFB0_RTS_N_B = 886,
	FN_EX_WAIT0___2 = 887,
	FN_HRTS2_N_B = 888,
	FN_SCIFB0_CTS_N_B = 889,
	FN_DREQ0 = 890,
	FN_PWM3___2 = 891,
	FN_TPU_TO3 = 892,
	FN_DACK0___2 = 893,
	FN_DRACK0___2 = 894,
	FN_REMOCON___2 = 895,
	FN_SPEEDIN___2 = 896,
	FN_HSCK0_C = 897,
	FN_HSCK2_C = 898,
	FN_SCIFB0_SCK_B = 899,
	FN_SCIFB2_SCK_B = 900,
	FN_DREQ2_C = 901,
	FN_HTX2_D = 902,
	FN_SSI_SCK0129___2 = 903,
	FN_HRX0_C = 904,
	FN_HRX2_C = 905,
	FN_SCIFB0_RXD_C = 906,
	FN_SCIFB2_RXD_C = 907,
	FN_SSI_WS0129___2 = 908,
	FN_HTX0_C = 909,
	FN_HTX2_C = 910,
	FN_SCIFB0_TXD_C = 911,
	FN_SCIFB2_TXD_C = 912,
	FN_SSI_SDATA0___2 = 913,
	FN_I2C0_SCL_B___2 = 914,
	FN_IIC0_SCL_B___2 = 915,
	FN_MSIOF2_SCK_C = 916,
	FN_SSI_SCK1___2 = 917,
	FN_I2C0_SDA_B___2 = 918,
	FN_IIC0_SDA_B___2 = 919,
	FN_MSIOF2_SYNC_C = 920,
	FN_GLO_I0_D = 921,
	FN_SSI_WS1___2 = 922,
	FN_I2C1_SCL_B___2 = 923,
	FN_IIC1_SCL_B = 924,
	FN_MSIOF2_TXD_C = 925,
	FN_GLO_I1_D = 926,
	FN_SSI_SDATA1___2 = 927,
	FN_I2C1_SDA_B___2 = 928,
	FN_IIC1_SDA_B = 929,
	FN_MSIOF2_RXD_C = 930,
	FN_SSI_SCK2___2 = 931,
	FN_I2C2_SCL___2 = 932,
	FN_GPS_CLK_B = 933,
	FN_GLO_Q0_D = 934,
	FN_HSCK1_E = 935,
	FN_SSI_WS2___2 = 936,
	FN_I2C2_SDA___2 = 937,
	FN_GPS_SIGN_B = 938,
	FN_RX2_E = 939,
	FN_GLO_Q1_D = 940,
	FN_HCTS1_N_E = 941,
	FN_SSI_SDATA2___2 = 942,
	FN_GPS_MAG_B = 943,
	FN_TX2_E = 944,
	FN_HRTS1_N_E = 945,
	FN_SSI_SCK34___2 = 946,
	FN_SSI_WS34___2 = 947,
	FN_SSI_SDATA3___2 = 948,
	FN_SSI_SCK4___2 = 949,
	FN_GLO_SS_D = 950,
	FN_SSI_WS4___2 = 951,
	FN_GLO_RFON_D = 952,
	FN_SSI_SDATA4___2 = 953,
	FN_MSIOF2_SCK_D = 954,
	FN_SSI_SCK5___2 = 955,
	FN_MSIOF1_SCK_C = 956,
	FN_TS_SDATA0 = 957,
	FN_GLO_I0 = 958,
	FN_MSIOF2_SYNC_D = 959,
	FN_VI1_R2_B = 960,
	FN_SSI_WS5___2 = 961,
	FN_MSIOF1_SYNC_C = 962,
	FN_TS_SCK0 = 963,
	FN_GLO_I1 = 964,
	FN_MSIOF2_TXD_D = 965,
	FN_VI1_R3_B = 966,
	FN_SSI_SDATA5___2 = 967,
	FN_MSIOF1_TXD_C = 968,
	FN_TS_SDEN0 = 969,
	FN_GLO_Q0 = 970,
	FN_MSIOF2_SS1_D = 971,
	FN_VI1_R4_B = 972,
	FN_SSI_SCK6___2 = 973,
	FN_MSIOF1_RXD_C = 974,
	FN_TS_SPSYNC0 = 975,
	FN_GLO_Q1 = 976,
	FN_MSIOF2_RXD_D = 977,
	FN_VI1_R5_B = 978,
	FN_SSI_WS6___2 = 979,
	FN_GLO_SCLK = 980,
	FN_MSIOF2_SS2_D = 981,
	FN_VI1_R6_B = 982,
	FN_SSI_SDATA6___2 = 983,
	FN_STP_IVCXO27_0_B = 984,
	FN_GLO_SDATA = 985,
	FN_VI1_R7_B = 986,
	FN_SSI_SCK78___2 = 987,
	FN_STP_ISCLK_0_B = 988,
	FN_GLO_SS = 989,
	FN_SSI_WS78___2 = 990,
	FN_TX0_D = 991,
	FN_STP_ISD_0_B = 992,
	FN_GLO_RFON = 993,
	FN_SSI_SDATA7___2 = 994,
	FN_RX0_D = 995,
	FN_STP_ISEN_0_B = 996,
	FN_SSI_SDATA8___2 = 997,
	FN_TX1_D = 998,
	FN_STP_ISSYNC_0_B = 999,
	FN_SSI_SCK9___2 = 1000,
	FN_RX1_D = 1001,
	FN_GLO_SCLK_D = 1002,
	FN_SSI_WS9___2 = 1003,
	FN_TX3_D = 1004,
	FN_CAN0_TX_D___2 = 1005,
	FN_GLO_SDATA_D = 1006,
	FN_SSI_SDATA9___2 = 1007,
	FN_RX3_D = 1008,
	FN_CAN0_RX_D___2 = 1009,
	FN_AUDIO_CLKB___2 = 1010,
	FN_STP_OPWM_0_B = 1011,
	FN_MSIOF1_SCK_B___2 = 1012,
	FN_SCIF_CLK___2 = 1013,
	FN_DVC_MUTE___2 = 1014,
	FN_BPFCLK_E___2 = 1015,
	FN_AUDIO_CLKC___2 = 1016,
	FN_SCIFB0_SCK_C = 1017,
	FN_MSIOF1_SYNC_B___2 = 1018,
	FN_RX2 = 1019,
	FN_SCIFA2_RXD___2 = 1020,
	FN_FMIN_E___2 = 1021,
	FN_AUDIO_CLKOUT___2 = 1022,
	FN_MSIOF1_SS1_B___2 = 1023,
	FN_TX2 = 1024,
	FN_SCIFA2_TXD___2 = 1025,
	FN_IRQ0___2 = 1026,
	FN_SCIFB1_RXD_D = 1027,
	FN_IRQ1___2 = 1028,
	FN_SCIFB1_SCK_C = 1029,
	FN_IRQ2___2 = 1030,
	FN_SCIFB1_TXD_D = 1031,
	FN_IRQ3___2 = 1032,
	FN_I2C4_SCL_C___2 = 1033,
	FN_MSIOF2_TXD_E = 1034,
	FN_IRQ4___2 = 1035,
	FN_HRX1_C = 1036,
	FN_I2C4_SDA_C___2 = 1037,
	FN_MSIOF2_RXD_E = 1038,
	FN_IRQ5___2 = 1039,
	FN_HTX1_C = 1040,
	FN_I2C1_SCL_E___2 = 1041,
	FN_MSIOF2_SCK_E = 1042,
	FN_IRQ6___2 = 1043,
	FN_HSCK1_C = 1044,
	FN_MSIOF1_SS2_B___2 = 1045,
	FN_I2C1_SDA_E___2 = 1046,
	FN_MSIOF2_SYNC_E = 1047,
	FN_IRQ7___2 = 1048,
	FN_HCTS1_N_C = 1049,
	FN_MSIOF1_TXD_B___2 = 1050,
	FN_GPS_CLK_C = 1051,
	FN_GPS_CLK_D = 1052,
	FN_IRQ8___2 = 1053,
	FN_HRTS1_N_C = 1054,
	FN_MSIOF1_RXD_B___2 = 1055,
	FN_GPS_SIGN_C = 1056,
	FN_GPS_SIGN_D = 1057,
	FN_IRQ9___2 = 1058,
	FN_DU1_DOTCLKIN_B = 1059,
	FN_CAN_CLK_D___2 = 1060,
	FN_GPS_MAG_C = 1061,
	FN_SCIF_CLK_B___2 = 1062,
	FN_GPS_MAG_D = 1063,
	FN_DU1_DR0___2 = 1064,
	FN_LCDOUT0___2 = 1065,
	FN_VI1_DATA0_B = 1066,
	FN_TX0_B = 1067,
	FN_SCIFA0_TXD_B___2 = 1068,
	FN_MSIOF2_SCK_B___2 = 1069,
	FN_DU1_DR1___2 = 1070,
	FN_LCDOUT1___2 = 1071,
	FN_VI1_DATA1_B = 1072,
	FN_RX0_B = 1073,
	FN_SCIFA0_RXD_B___2 = 1074,
	FN_MSIOF2_SYNC_B___2 = 1075,
	FN_DU1_DR2___2 = 1076,
	FN_LCDOUT2___2 = 1077,
	FN_SSI_SCK0129_B = 1078,
	FN_DU1_DR3___2 = 1079,
	FN_LCDOUT3___2 = 1080,
	FN_SSI_WS0129_B = 1081,
	FN_DU1_DR4___2 = 1082,
	FN_LCDOUT4___2 = 1083,
	FN_SSI_SDATA0_B = 1084,
	FN_DU1_DR5___2 = 1085,
	FN_LCDOUT5___2 = 1086,
	FN_SSI_SCK1_B___2 = 1087,
	FN_DU1_DR6___2 = 1088,
	FN_LCDOUT6___2 = 1089,
	FN_SSI_WS1_B___2 = 1090,
	FN_DU1_DR7___2 = 1091,
	FN_LCDOUT7___2 = 1092,
	FN_SSI_SDATA1_B___2 = 1093,
	FN_DU1_DG0___2 = 1094,
	FN_LCDOUT8___2 = 1095,
	FN_VI1_DATA2_B = 1096,
	FN_TX1_B = 1097,
	FN_SCIFA1_TXD_B___2 = 1098,
	FN_MSIOF2_SS1_B___2 = 1099,
	FN_DU1_DG1___2 = 1100,
	FN_LCDOUT9___2 = 1101,
	FN_VI1_DATA3_B = 1102,
	FN_RX1_B = 1103,
	FN_SCIFA1_RXD_B___2 = 1104,
	FN_MSIOF2_SS2_B___2 = 1105,
	FN_DU1_DG2___2 = 1106,
	FN_LCDOUT10___2 = 1107,
	FN_VI1_DATA4_B = 1108,
	FN_SCIF1_SCK_B___2 = 1109,
	FN_SCIFA1_SCK___2 = 1110,
	FN_SSI_SCK78_B___2 = 1111,
	FN_DU1_DG3___2 = 1112,
	FN_LCDOUT11___2 = 1113,
	FN_VI1_DATA5_B = 1114,
	FN_SSI_WS78_B___2 = 1115,
	FN_DU1_DG4___2 = 1116,
	FN_LCDOUT12___2 = 1117,
	FN_VI1_DATA6_B = 1118,
	FN_HRX0_B = 1119,
	FN_SCIFB2_RXD_B = 1120,
	FN_SSI_SDATA7_B___2 = 1121,
	FN_DU1_DG5___2 = 1122,
	FN_LCDOUT13___2 = 1123,
	FN_VI1_DATA7_B = 1124,
	FN_HCTS0_N_B = 1125,
	FN_SCIFB2_TXD_B = 1126,
	FN_SSI_SDATA8_B___2 = 1127,
	FN_DU1_DG6___2 = 1128,
	FN_LCDOUT14___2 = 1129,
	FN_HRTS0_N_B = 1130,
	FN_SCIFB2_CTS_N_B = 1131,
	FN_SSI_SCK9_B___2 = 1132,
	FN_DU1_DG7___2 = 1133,
	FN_LCDOUT15___2 = 1134,
	FN_HTX0_B = 1135,
	FN_SCIFB2_RTS_N_B = 1136,
	FN_SSI_WS9_B___2 = 1137,
	FN_DU1_DB0___2 = 1138,
	FN_LCDOUT16___2 = 1139,
	FN_VI1_CLK_B = 1140,
	FN_TX2_B = 1141,
	FN_SCIFA2_TXD_B___2 = 1142,
	FN_MSIOF2_TXD_B___2 = 1143,
	FN_DU1_DB1___2 = 1144,
	FN_LCDOUT17___2 = 1145,
	FN_VI1_HSYNC_N_B = 1146,
	FN_RX2_B = 1147,
	FN_SCIFA2_RXD_B___2 = 1148,
	FN_MSIOF2_RXD_B___2 = 1149,
	FN_DU1_DB2___2 = 1150,
	FN_LCDOUT18___2 = 1151,
	FN_VI1_VSYNC_N_B = 1152,
	FN_SCIF2_SCK_B___2 = 1153,
	FN_SCIFA2_SCK___2 = 1154,
	FN_SSI_SDATA9_B___2 = 1155,
	FN_DU1_DB3___2 = 1156,
	FN_LCDOUT19___2 = 1157,
	FN_VI1_CLKENB_B = 1158,
	FN_DU1_DB4___2 = 1159,
	FN_LCDOUT20___2 = 1160,
	FN_VI1_FIELD_B = 1161,
	FN_CAN1_RX___2 = 1162,
	FN_DU1_DB5___2 = 1163,
	FN_LCDOUT21___2 = 1164,
	FN_TX3 = 1165,
	FN_SCIFA3_TXD___2 = 1166,
	FN_CAN1_TX___2 = 1167,
	FN_DU1_DB6___2 = 1168,
	FN_LCDOUT22___2 = 1169,
	FN_I2C3_SCL_C___2 = 1170,
	FN_RX3 = 1171,
	FN_SCIFA3_RXD___2 = 1172,
	FN_DU1_DB7___2 = 1173,
	FN_LCDOUT23___2 = 1174,
	FN_I2C3_SDA_C___2 = 1175,
	FN_SCIF3_SCK___2 = 1176,
	FN_SCIFA3_SCK___2 = 1177,
	FN_DU1_DOTCLKIN___2 = 1178,
	FN_QSTVA_QVS___2 = 1179,
	FN_DU1_DOTCLKOUT0___2 = 1180,
	FN_QCLK___2 = 1181,
	FN_DU1_DOTCLKOUT1___2 = 1182,
	FN_QSTVB_QVE___2 = 1183,
	FN_CAN0_TX___2 = 1184,
	FN_TX3_B = 1185,
	FN_I2C2_SCL_B___2 = 1186,
	FN_PWM4___2 = 1187,
	FN_DU1_EXHSYNC_DU1_HSYNC___2 = 1188,
	FN_QSTH_QHS___2 = 1189,
	FN_DU1_EXVSYNC_DU1_VSYNC___2 = 1190,
	FN_QSTB_QHE___2 = 1191,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE___2 = 1192,
	FN_QCPV_QDE___2 = 1193,
	FN_CAN0_RX___2 = 1194,
	FN_RX3_B = 1195,
	FN_I2C2_SDA_B___2 = 1196,
	FN_DU1_DISP___2 = 1197,
	FN_QPOLA___2 = 1198,
	FN_DU1_CDE___2 = 1199,
	FN_QPOLB___2 = 1200,
	FN_PWM4_B___2 = 1201,
	FN_VI0_CLKENB___2 = 1202,
	FN_TX4 = 1203,
	FN_SCIFA4_TXD___2 = 1204,
	FN_TS_SDATA0_D = 1205,
	FN_VI0_FIELD___2 = 1206,
	FN_RX4 = 1207,
	FN_SCIFA4_RXD___2 = 1208,
	FN_TS_SCK0_D = 1209,
	FN_VI0_HSYNC_N___2 = 1210,
	FN_TX5 = 1211,
	FN_SCIFA5_TXD___2 = 1212,
	FN_TS_SDEN0_D = 1213,
	FN_VI0_VSYNC_N___2 = 1214,
	FN_RX5 = 1215,
	FN_SCIFA5_RXD___2 = 1216,
	FN_TS_SPSYNC0_D = 1217,
	FN_VI0_DATA3_VI0_B3___2 = 1218,
	FN_SCIF3_SCK_B___2 = 1219,
	FN_SCIFA3_SCK_B___2 = 1220,
	FN_VI0_G0___2 = 1221,
	FN_IIC1_SCL = 1222,
	FN_STP_IVCXO27_0_C = 1223,
	FN_I2C4_SCL___2 = 1224,
	FN_HCTS2_N = 1225,
	FN_SCIFB2_CTS_N___2 = 1226,
	FN_ATAWR1_N___2 = 1227,
	FN_VI0_G1___2 = 1228,
	FN_IIC1_SDA = 1229,
	FN_STP_ISCLK_0_C = 1230,
	FN_I2C4_SDA___2 = 1231,
	FN_HRTS2_N = 1232,
	FN_SCIFB2_RTS_N___2 = 1233,
	FN_ATADIR1_N___2 = 1234,
	FN_VI0_G2___2 = 1235,
	FN_VI2_HSYNC_N = 1236,
	FN_STP_ISD_0_C = 1237,
	FN_I2C3_SCL_B___2 = 1238,
	FN_HSCK2 = 1239,
	FN_SCIFB2_SCK___2 = 1240,
	FN_ATARD1_N___2 = 1241,
	FN_VI0_G3___2 = 1242,
	FN_VI2_VSYNC_N = 1243,
	FN_STP_ISEN_0_C = 1244,
	FN_I2C3_SDA_B___2 = 1245,
	FN_HRX2 = 1246,
	FN_SCIFB2_RXD___2 = 1247,
	FN_ATACS01_N___2 = 1248,
	FN_VI0_G4___2 = 1249,
	FN_VI2_CLKENB = 1250,
	FN_STP_ISSYNC_0_C = 1251,
	FN_HTX2 = 1252,
	FN_SCIFB2_TXD___2 = 1253,
	FN_SCIFB0_SCK_D = 1254,
	FN_VI0_G5___2 = 1255,
	FN_VI2_FIELD = 1256,
	FN_STP_OPWM_0_C = 1257,
	FN_FMCLK_D___2 = 1258,
	FN_CAN0_TX_E = 1259,
	FN_HTX1_D = 1260,
	FN_SCIFB0_TXD_D = 1261,
	FN_VI0_G6___2 = 1262,
	FN_VI2_CLK = 1263,
	FN_BPFCLK_D___2 = 1264,
	FN_VI0_G7___2 = 1265,
	FN_VI2_DATA0 = 1266,
	FN_FMIN_D___2 = 1267,
	FN_VI0_R0___2 = 1268,
	FN_VI2_DATA1 = 1269,
	FN_GLO_I0_B = 1270,
	FN_TS_SDATA0_C = 1271,
	FN_ATACS11_N___2 = 1272,
	FN_VI0_R1___2 = 1273,
	FN_VI2_DATA2 = 1274,
	FN_GLO_I1_B = 1275,
	FN_TS_SCK0_C = 1276,
	FN_ATAG1_N___2 = 1277,
	FN_VI0_R2___2 = 1278,
	FN_VI2_DATA3 = 1279,
	FN_GLO_Q0_B = 1280,
	FN_TS_SDEN0_C = 1281,
	FN_VI0_R3___2 = 1282,
	FN_VI2_DATA4 = 1283,
	FN_GLO_Q1_B = 1284,
	FN_TS_SPSYNC0_C = 1285,
	FN_VI0_R4___2 = 1286,
	FN_VI2_DATA5 = 1287,
	FN_GLO_SCLK_B = 1288,
	FN_TX0_C = 1289,
	FN_I2C1_SCL_D___2 = 1290,
	FN_VI0_R5___2 = 1291,
	FN_VI2_DATA6 = 1292,
	FN_GLO_SDATA_B = 1293,
	FN_RX0_C = 1294,
	FN_I2C1_SDA_D___2 = 1295,
	FN_VI0_R6___2 = 1296,
	FN_VI2_DATA7 = 1297,
	FN_GLO_SS_B = 1298,
	FN_TX1_C = 1299,
	FN_I2C4_SCL_B___2 = 1300,
	FN_VI0_R7___2 = 1301,
	FN_GLO_RFON_B = 1302,
	FN_RX1_C = 1303,
	FN_CAN0_RX_E = 1304,
	FN_I2C4_SDA_B___2 = 1305,
	FN_HRX1_D = 1306,
	FN_SCIFB0_RXD_D = 1307,
	FN_VI1_HSYNC_N___2 = 1308,
	FN_AVB_RXD0___2 = 1309,
	FN_TS_SDATA0_B = 1310,
	FN_TX4_B = 1311,
	FN_SCIFA4_TXD_B___2 = 1312,
	FN_VI1_VSYNC_N___2 = 1313,
	FN_AVB_RXD1___2 = 1314,
	FN_TS_SCK0_B = 1315,
	FN_RX4_B = 1316,
	FN_SCIFA4_RXD_B___2 = 1317,
	FN_VI1_CLKENB___2 = 1318,
	FN_AVB_RXD2___2 = 1319,
	FN_TS_SDEN0_B = 1320,
	FN_VI1_FIELD___2 = 1321,
	FN_AVB_RXD3___2 = 1322,
	FN_TS_SPSYNC0_B = 1323,
	FN_VI1_CLK___2 = 1324,
	FN_AVB_RXD4___2 = 1325,
	FN_VI1_DATA0___2 = 1326,
	FN_AVB_RXD5___2 = 1327,
	FN_VI1_DATA1___2 = 1328,
	FN_AVB_RXD6___2 = 1329,
	FN_VI1_DATA2___2 = 1330,
	FN_AVB_RXD7___2 = 1331,
	FN_VI1_DATA3___2 = 1332,
	FN_AVB_RX_ER___2 = 1333,
	FN_VI1_DATA4___2 = 1334,
	FN_AVB_MDIO___2 = 1335,
	FN_VI1_DATA5___2 = 1336,
	FN_AVB_RX_DV___2 = 1337,
	FN_VI1_DATA6___2 = 1338,
	FN_AVB_MAGIC___2 = 1339,
	FN_VI1_DATA7___2 = 1340,
	FN_AVB_MDC___2 = 1341,
	FN_ETH_MDIO___2 = 1342,
	FN_AVB_RX_CLK___2 = 1343,
	FN_I2C2_SCL_C___2 = 1344,
	FN_ETH_CRS_DV___2 = 1345,
	FN_AVB_LINK___2 = 1346,
	FN_I2C2_SDA_C___2 = 1347,
	FN_ETH_RX_ER___2 = 1348,
	FN_AVB_CRS___2 = 1349,
	FN_I2C3_SCL___2 = 1350,
	FN_IIC0_SCL___2 = 1351,
	FN_ETH_RXD0___2 = 1352,
	FN_AVB_PHY_INT___2 = 1353,
	FN_I2C3_SDA___2 = 1354,
	FN_IIC0_SDA___2 = 1355,
	FN_ETH_RXD1___2 = 1356,
	FN_AVB_GTXREFCLK___2 = 1357,
	FN_CAN0_TX_C___2 = 1358,
	FN_I2C2_SCL_D___2 = 1359,
	FN_MSIOF1_RXD_E = 1360,
	FN_ETH_LINK___2 = 1361,
	FN_AVB_TXD0___2 = 1362,
	FN_CAN0_RX_C___2 = 1363,
	FN_I2C2_SDA_D___2 = 1364,
	FN_MSIOF1_SCK_E = 1365,
	FN_ETH_REFCLK___2 = 1366,
	FN_AVB_TXD1___2 = 1367,
	FN_SCIFA3_RXD_B___2 = 1368,
	FN_CAN1_RX_C___2 = 1369,
	FN_MSIOF1_SYNC_E = 1370,
	FN_ETH_TXD1___2 = 1371,
	FN_AVB_TXD2___2 = 1372,
	FN_SCIFA3_TXD_B___2 = 1373,
	FN_CAN1_TX_C___2 = 1374,
	FN_MSIOF1_TXD_E = 1375,
	FN_ETH_TX_EN___2 = 1376,
	FN_AVB_TXD3___2 = 1377,
	FN_TCLK1_B___2 = 1378,
	FN_CAN_CLK_B___2 = 1379,
	FN_ETH_MAGIC___2 = 1380,
	FN_AVB_TXD4___2 = 1381,
	FN_IETX_C___2 = 1382,
	FN_ETH_TXD0___2 = 1383,
	FN_AVB_TXD5___2 = 1384,
	FN_IECLK_C___2 = 1385,
	FN_ETH_MDC___2 = 1386,
	FN_AVB_TXD6___2 = 1387,
	FN_IERX_C___2 = 1388,
	FN_STP_IVCXO27_0 = 1389,
	FN_AVB_TXD7___2 = 1390,
	FN_SCIFB2_TXD_D = 1391,
	FN_ADIDATA_B___2 = 1392,
	FN_MSIOF0_SYNC_C = 1393,
	FN_STP_ISCLK_0 = 1394,
	FN_AVB_TX_EN___2 = 1395,
	FN_SCIFB2_RXD_D = 1396,
	FN_ADICS_SAMP_B___2 = 1397,
	FN_MSIOF0_SCK_C = 1398,
	FN_STP_ISD_0 = 1399,
	FN_AVB_TX_ER___2 = 1400,
	FN_SCIFB2_SCK_C = 1401,
	FN_ADICLK_B___2 = 1402,
	FN_MSIOF0_SS1_C = 1403,
	FN_STP_ISEN_0 = 1404,
	FN_AVB_TX_CLK___2 = 1405,
	FN_ADICHS0_B___2 = 1406,
	FN_MSIOF0_SS2_C = 1407,
	FN_STP_ISSYNC_0 = 1408,
	FN_AVB_COL___2 = 1409,
	FN_ADICHS1_B___2 = 1410,
	FN_MSIOF0_RXD_C = 1411,
	FN_STP_OPWM_0 = 1412,
	FN_AVB_GTX_CLK___2 = 1413,
	FN_PWM0_B___2 = 1414,
	FN_ADICHS2_B___2 = 1415,
	FN_MSIOF0_TXD_C = 1416,
	FN_SD0_CLK___2 = 1417,
	FN_SPCLK_B = 1418,
	FN_SD0_CMD___2 = 1419,
	FN_MOSI_IO0_B = 1420,
	FN_SD0_DATA0___2 = 1421,
	FN_MISO_IO1_B = 1422,
	FN_SD0_DATA1___2 = 1423,
	FN_IO2_B = 1424,
	FN_SD0_DATA2___2 = 1425,
	FN_IO3_B = 1426,
	FN_SD0_DATA3___2 = 1427,
	FN_SSL_B = 1428,
	FN_SD0_CD___2 = 1429,
	FN_MMC_D6_B = 1430,
	FN_SIM0_RST_B = 1431,
	FN_CAN0_RX_F = 1432,
	FN_SCIFA5_TXD_B___2 = 1433,
	FN_TX3_C = 1434,
	FN_SD0_WP___2 = 1435,
	FN_MMC_D7_B = 1436,
	FN_SIM0_D_B = 1437,
	FN_CAN0_TX_F = 1438,
	FN_SCIFA5_RXD_B___2 = 1439,
	FN_RX3_C = 1440,
	FN_SD1_CMD___2 = 1441,
	FN_REMOCON_B___2 = 1442,
	FN_SD1_DATA0___2 = 1443,
	FN_SPEEDIN_B___2 = 1444,
	FN_SD1_DATA1___2 = 1445,
	FN_IETX_B___2 = 1446,
	FN_SD1_DATA2___2 = 1447,
	FN_IECLK_B___2 = 1448,
	FN_SD1_DATA3___2 = 1449,
	FN_IERX_B___2 = 1450,
	FN_SD1_CD___2 = 1451,
	FN_PWM0___2 = 1452,
	FN_TPU_TO0 = 1453,
	FN_I2C1_SCL_C___2 = 1454,
	FN_SD1_WP___2 = 1455,
	FN_PWM1_B___2 = 1456,
	FN_I2C1_SDA_C___2 = 1457,
	FN_SD2_CLK___2 = 1458,
	FN_MMC_CLK___2 = 1459,
	FN_SD2_CMD___2 = 1460,
	FN_MMC_CMD___2 = 1461,
	FN_SD2_DATA0___2 = 1462,
	FN_MMC_D0___2 = 1463,
	FN_SD2_DATA1___2 = 1464,
	FN_MMC_D1___2 = 1465,
	FN_SD2_DATA2___2 = 1466,
	FN_MMC_D2___2 = 1467,
	FN_SD2_DATA3___2 = 1468,
	FN_MMC_D3___2 = 1469,
	FN_SD2_CD___2 = 1470,
	FN_MMC_D4___2 = 1471,
	FN_IIC1_SCL_C = 1472,
	FN_TX5_B = 1473,
	FN_SCIFA5_TXD_C___2 = 1474,
	FN_SD2_WP___2 = 1475,
	FN_MMC_D5___2 = 1476,
	FN_IIC1_SDA_C = 1477,
	FN_RX5_B = 1478,
	FN_SCIFA5_RXD_C___2 = 1479,
	FN_MSIOF0_SCK___2 = 1480,
	FN_RX2_C = 1481,
	FN_ADIDATA___2 = 1482,
	FN_VI1_CLK_C = 1483,
	FN_VI1_G0_B = 1484,
	FN_MSIOF0_SYNC___2 = 1485,
	FN_TX2_C = 1486,
	FN_ADICS_SAMP___2 = 1487,
	FN_VI1_CLKENB_C = 1488,
	FN_VI1_G1_B = 1489,
	FN_MSIOF0_TXD___2 = 1490,
	FN_ADICLK___2 = 1491,
	FN_VI1_FIELD_C = 1492,
	FN_VI1_G2_B = 1493,
	FN_MSIOF0_RXD___2 = 1494,
	FN_ADICHS0___2 = 1495,
	FN_VI1_DATA0_C = 1496,
	FN_VI1_G3_B = 1497,
	FN_MSIOF0_SS1___2 = 1498,
	FN_MMC_D6___2 = 1499,
	FN_ADICHS1___2 = 1500,
	FN_TX0_E = 1501,
	FN_VI1_HSYNC_N_C = 1502,
	FN_IIC0_SCL_C___2 = 1503,
	FN_VI1_G4_B = 1504,
	FN_MSIOF0_SS2___2 = 1505,
	FN_MMC_D7___2 = 1506,
	FN_ADICHS2___2 = 1507,
	FN_RX0_E = 1508,
	FN_VI1_VSYNC_N_C = 1509,
	FN_IIC0_SDA_C___2 = 1510,
	FN_VI1_G5_B = 1511,
	FN_SIM0_RST = 1512,
	FN_IETX___2 = 1513,
	FN_CAN1_TX_D___2 = 1514,
	FN_SIM0_CLK = 1515,
	FN_IECLK___2 = 1516,
	FN_CAN_CLK_C___2 = 1517,
	FN_SIM0_D = 1518,
	FN_IERX___2 = 1519,
	FN_CAN1_RX_D___2 = 1520,
	FN_GPS_CLK = 1521,
	FN_DU1_DOTCLKIN_C = 1522,
	FN_AUDIO_CLKB_B___2 = 1523,
	FN_PWM5_B___2 = 1524,
	FN_SCIFA3_TXD_C = 1525,
	FN_GPS_SIGN = 1526,
	FN_TX4_C = 1527,
	FN_SCIFA4_TXD_C___2 = 1528,
	FN_PWM5___2 = 1529,
	FN_VI1_G6_B = 1530,
	FN_SCIFA3_RXD_C = 1531,
	FN_GPS_MAG = 1532,
	FN_RX4_C = 1533,
	FN_SCIFA4_RXD_C___2 = 1534,
	FN_PWM6___2 = 1535,
	FN_VI1_G7_B = 1536,
	FN_SCIFA3_SCK_C = 1537,
	FN_HCTS0_N = 1538,
	FN_SCIFB0_CTS_N___2 = 1539,
	FN_GLO_I0_C = 1540,
	FN_TCLK1___2 = 1541,
	FN_VI1_DATA1_C = 1542,
	FN_HRTS0_N = 1543,
	FN_SCIFB0_RTS_N___2 = 1544,
	FN_GLO_I1_C = 1545,
	FN_VI1_DATA2_C = 1546,
	FN_HSCK0 = 1547,
	FN_SCIFB0_SCK___2 = 1548,
	FN_GLO_Q0_C = 1549,
	FN_CAN_CLK___2 = 1550,
	FN_TCLK2___2 = 1551,
	FN_VI1_DATA3_C = 1552,
	FN_HRX0 = 1553,
	FN_SCIFB0_RXD___2 = 1554,
	FN_GLO_Q1_C = 1555,
	FN_CAN0_RX_B___2 = 1556,
	FN_VI1_DATA4_C = 1557,
	FN_HTX0 = 1558,
	FN_SCIFB0_TXD___2 = 1559,
	FN_GLO_SCLK_C = 1560,
	FN_CAN0_TX_B___2 = 1561,
	FN_VI1_DATA5_C = 1562,
	FN_HRX1 = 1563,
	FN_SCIFB1_RXD___2 = 1564,
	FN_VI1_R0_B = 1565,
	FN_GLO_SDATA_C = 1566,
	FN_VI1_DATA6_C = 1567,
	FN_HTX1 = 1568,
	FN_SCIFB1_TXD___2 = 1569,
	FN_VI1_R1_B = 1570,
	FN_GLO_SS_C = 1571,
	FN_VI1_DATA7_C = 1572,
	FN_HSCK1 = 1573,
	FN_SCIFB1_SCK___2 = 1574,
	FN_MLB_CLK___2 = 1575,
	FN_GLO_RFON_C = 1576,
	FN_HCTS1_N = 1577,
	FN_SCIFB1_CTS_N = 1578,
	FN_MLB_SIG___2 = 1579,
	FN_CAN1_TX_B___2 = 1580,
	FN_HRTS1_N = 1581,
	FN_SCIFB1_RTS_N = 1582,
	FN_MLB_DAT___2 = 1583,
	FN_CAN1_RX_B___2 = 1584,
	FN_SEL_SCIF1_0___2 = 1585,
	FN_SEL_SCIF1_1___2 = 1586,
	FN_SEL_SCIF1_2___2 = 1587,
	FN_SEL_SCIF1_3 = 1588,
	FN_SEL_SCIFB_0 = 1589,
	FN_SEL_SCIFB_1 = 1590,
	FN_SEL_SCIFB_2 = 1591,
	FN_SEL_SCIFB_3 = 1592,
	FN_SEL_SCIFB2_0 = 1593,
	FN_SEL_SCIFB2_1 = 1594,
	FN_SEL_SCIFB2_2 = 1595,
	FN_SEL_SCIFB2_3 = 1596,
	FN_SEL_SCIFB1_0 = 1597,
	FN_SEL_SCIFB1_1 = 1598,
	FN_SEL_SCIFB1_2 = 1599,
	FN_SEL_SCIFB1_3 = 1600,
	FN_SEL_SCIFA1_0___2 = 1601,
	FN_SEL_SCIFA1_1___2 = 1602,
	FN_SEL_SCIFA1_2___2 = 1603,
	FN_SEL_SSI9_0___2 = 1604,
	FN_SEL_SSI9_1___2 = 1605,
	FN_SEL_SCFA_0 = 1606,
	FN_SEL_SCFA_1 = 1607,
	FN_SEL_QSP_0 = 1608,
	FN_SEL_QSP_1 = 1609,
	FN_SEL_SSI7_0___2 = 1610,
	FN_SEL_SSI7_1___2 = 1611,
	FN_SEL_HSCIF1_0___2 = 1612,
	FN_SEL_HSCIF1_1___2 = 1613,
	FN_SEL_HSCIF1_2 = 1614,
	FN_SEL_HSCIF1_3 = 1615,
	FN_SEL_HSCIF1_4 = 1616,
	FN_SEL_VI1_0 = 1617,
	FN_SEL_VI1_1 = 1618,
	FN_SEL_VI1_2 = 1619,
	FN_SEL_TMU1_0 = 1620,
	FN_SEL_TMU1_1 = 1621,
	FN_SEL_LBS_0___2 = 1622,
	FN_SEL_LBS_1___2 = 1623,
	FN_SEL_LBS_2 = 1624,
	FN_SEL_LBS_3 = 1625,
	FN_SEL_TSIF0_0___2 = 1626,
	FN_SEL_TSIF0_1___2 = 1627,
	FN_SEL_TSIF0_2___2 = 1628,
	FN_SEL_TSIF0_3___2 = 1629,
	FN_SEL_SOF0_0 = 1630,
	FN_SEL_SOF0_1 = 1631,
	FN_SEL_SOF0_2 = 1632,
	FN_SEL_SCIF0_0___2 = 1633,
	FN_SEL_SCIF0_1___2 = 1634,
	FN_SEL_SCIF0_2___2 = 1635,
	FN_SEL_SCIF0_3___2 = 1636,
	FN_SEL_SCIF0_4 = 1637,
	FN_SEL_SCIF_0 = 1638,
	FN_SEL_SCIF_1 = 1639,
	FN_SEL_CAN0_0___2 = 1640,
	FN_SEL_CAN0_1___2 = 1641,
	FN_SEL_CAN0_2___2 = 1642,
	FN_SEL_CAN0_3___2 = 1643,
	FN_SEL_CAN0_4 = 1644,
	FN_SEL_CAN0_5 = 1645,
	FN_SEL_CAN1_0___2 = 1646,
	FN_SEL_CAN1_1___2 = 1647,
	FN_SEL_CAN1_2___2 = 1648,
	FN_SEL_CAN1_3___2 = 1649,
	FN_SEL_SCIFA2_0___2 = 1650,
	FN_SEL_SCIFA2_1___2 = 1651,
	FN_SEL_SCIF4_0___2 = 1652,
	FN_SEL_SCIF4_1___2 = 1653,
	FN_SEL_SCIF4_2___2 = 1654,
	FN_SEL_ADG_0___2 = 1655,
	FN_SEL_ADG_1___2 = 1656,
	FN_SEL_FM_0 = 1657,
	FN_SEL_FM_1 = 1658,
	FN_SEL_FM_2 = 1659,
	FN_SEL_FM_3 = 1660,
	FN_SEL_FM_4 = 1661,
	FN_SEL_SCIFA5_0___2 = 1662,
	FN_SEL_SCIFA5_1___2 = 1663,
	FN_SEL_SCIFA5_2___2 = 1664,
	FN_SEL_GPS_0 = 1665,
	FN_SEL_GPS_1 = 1666,
	FN_SEL_GPS_2 = 1667,
	FN_SEL_GPS_3 = 1668,
	FN_SEL_SCIFA4_0___2 = 1669,
	FN_SEL_SCIFA4_1___2 = 1670,
	FN_SEL_SCIFA4_2___2 = 1671,
	FN_SEL_SCIFA3_0___2 = 1672,
	FN_SEL_SCIFA3_1___2 = 1673,
	FN_SEL_SCIFA3_2 = 1674,
	FN_SEL_SIM_0 = 1675,
	FN_SEL_SIM_1 = 1676,
	FN_SEL_SSI8_0___2 = 1677,
	FN_SEL_SSI8_1___2 = 1678,
	FN_SEL_HSCIF2_0 = 1679,
	FN_SEL_HSCIF2_1 = 1680,
	FN_SEL_HSCIF2_2 = 1681,
	FN_SEL_HSCIF2_3 = 1682,
	FN_SEL_CANCLK_0 = 1683,
	FN_SEL_CANCLK_1 = 1684,
	FN_SEL_CANCLK_2 = 1685,
	FN_SEL_CANCLK_3 = 1686,
	FN_SEL_IIC1_0 = 1687,
	FN_SEL_IIC1_1 = 1688,
	FN_SEL_IIC1_2 = 1689,
	FN_SEL_IIC0_0___2 = 1690,
	FN_SEL_IIC0_1___2 = 1691,
	FN_SEL_IIC0_2___2 = 1692,
	FN_SEL_I2C4_0 = 1693,
	FN_SEL_I2C4_1 = 1694,
	FN_SEL_I2C4_2 = 1695,
	FN_SEL_I2C3_0 = 1696,
	FN_SEL_I2C3_1 = 1697,
	FN_SEL_I2C3_2 = 1698,
	FN_SEL_I2C3_3 = 1699,
	FN_SEL_SCIF3_0___2 = 1700,
	FN_SEL_SCIF3_1___2 = 1701,
	FN_SEL_SCIF3_2 = 1702,
	FN_SEL_SCIF3_3 = 1703,
	FN_SEL_IEB_0___2 = 1704,
	FN_SEL_IEB_1___2 = 1705,
	FN_SEL_IEB_2___2 = 1706,
	FN_SEL_MMC_0 = 1707,
	FN_SEL_MMC_1 = 1708,
	FN_SEL_SCIF5_0___2 = 1709,
	FN_SEL_SCIF5_1___2 = 1710,
	FN_SEL_I2C2_0 = 1711,
	FN_SEL_I2C2_1 = 1712,
	FN_SEL_I2C2_2 = 1713,
	FN_SEL_I2C2_3 = 1714,
	FN_SEL_I2C1_0 = 1715,
	FN_SEL_I2C1_1 = 1716,
	FN_SEL_I2C1_2 = 1717,
	FN_SEL_I2C1_3 = 1718,
	FN_SEL_I2C1_4 = 1719,
	FN_SEL_I2C0_0 = 1720,
	FN_SEL_I2C0_1 = 1721,
	FN_SEL_I2C0_2 = 1722,
	FN_SEL_SOF1_0 = 1723,
	FN_SEL_SOF1_1 = 1724,
	FN_SEL_SOF1_2 = 1725,
	FN_SEL_SOF1_3 = 1726,
	FN_SEL_SOF1_4 = 1727,
	FN_SEL_HSCIF0_0___2 = 1728,
	FN_SEL_HSCIF0_1___2 = 1729,
	FN_SEL_HSCIF0_2 = 1730,
	FN_SEL_DIS_0 = 1731,
	FN_SEL_DIS_1 = 1732,
	FN_SEL_DIS_2 = 1733,
	FN_SEL_RAD_0___2 = 1734,
	FN_SEL_RAD_1___2 = 1735,
	FN_SEL_RCN_0___2 = 1736,
	FN_SEL_RCN_1___2 = 1737,
	FN_SEL_RSP_0___2 = 1738,
	FN_SEL_RSP_1___2 = 1739,
	FN_SEL_SCIF2_0___2 = 1740,
	FN_SEL_SCIF2_1___2 = 1741,
	FN_SEL_SCIF2_2___2 = 1742,
	FN_SEL_SCIF2_3 = 1743,
	FN_SEL_SCIF2_4 = 1744,
	FN_SEL_SOF2_0 = 1745,
	FN_SEL_SOF2_1 = 1746,
	FN_SEL_SOF2_2 = 1747,
	FN_SEL_SOF2_3 = 1748,
	FN_SEL_SOF2_4 = 1749,
	FN_SEL_SSI1_0___2 = 1750,
	FN_SEL_SSI1_1___2 = 1751,
	FN_SEL_SSI0_0 = 1752,
	FN_SEL_SSI0_1 = 1753,
	FN_SEL_SSP_0 = 1754,
	FN_SEL_SSP_1 = 1755,
	FN_SEL_SSP_2 = 1756,
	PINMUX_FUNCTION_END___3 = 1757,
	PINMUX_MARK_BEGIN___3 = 1758,
	EX_CS0_N_MARK___2 = 1759,
	RD_N_MARK___2 = 1760,
	AUDIO_CLKA_MARK___2 = 1761,
	VI0_CLK_MARK___2 = 1762,
	VI0_DATA0_VI0_B0_MARK___2 = 1763,
	VI0_DATA1_VI0_B1_MARK___2 = 1764,
	VI0_DATA2_VI0_B2_MARK___2 = 1765,
	VI0_DATA4_VI0_B4_MARK___2 = 1766,
	VI0_DATA5_VI0_B5_MARK___2 = 1767,
	VI0_DATA6_VI0_B6_MARK___2 = 1768,
	VI0_DATA7_VI0_B7_MARK___2 = 1769,
	SD1_CLK_MARK___2 = 1770,
	USB0_PWEN_MARK___2 = 1771,
	USB0_OVC_MARK___2 = 1772,
	USB1_PWEN_MARK___2 = 1773,
	USB1_OVC_MARK___2 = 1774,
	DU0_DOTCLKIN_MARK___2 = 1775,
	D0_MARK___2 = 1776,
	D1_MARK___2 = 1777,
	D2_MARK___2 = 1778,
	D3_MARK___2 = 1779,
	D4_MARK___2 = 1780,
	D5_MARK___2 = 1781,
	D6_MARK___2 = 1782,
	D7_MARK___2 = 1783,
	D8_MARK___2 = 1784,
	D9_MARK___2 = 1785,
	D10_MARK___2 = 1786,
	D11_MARK___2 = 1787,
	D12_MARK___2 = 1788,
	D13_MARK___2 = 1789,
	D14_MARK___2 = 1790,
	D15_MARK___2 = 1791,
	A0_MARK___3 = 1792,
	ATAWR0_N_C_MARK = 1793,
	MSIOF0_SCK_B_MARK = 1794,
	I2C0_SCL_C_MARK___2 = 1795,
	PWM2_B_MARK___2 = 1796,
	A1_MARK___2 = 1797,
	MSIOF0_SYNC_B_MARK = 1798,
	A2_MARK___2 = 1799,
	MSIOF0_SS1_B_MARK = 1800,
	A3_MARK___2 = 1801,
	MSIOF0_SS2_B_MARK = 1802,
	A4_MARK___2 = 1803,
	MSIOF0_TXD_B_MARK = 1804,
	A5_MARK___2 = 1805,
	MSIOF0_RXD_B_MARK = 1806,
	A6_MARK___2 = 1807,
	MSIOF1_SCK_MARK___2 = 1808,
	A7_MARK___2 = 1809,
	MSIOF1_SYNC_MARK___2 = 1810,
	A8_MARK___2 = 1811,
	MSIOF1_SS1_MARK___3 = 1812,
	I2C0_SCL_MARK___2 = 1813,
	A9_MARK___2 = 1814,
	MSIOF1_SS2_MARK___3 = 1815,
	I2C0_SDA_MARK___2 = 1816,
	A10_MARK___2 = 1817,
	MSIOF1_TXD_MARK___3 = 1818,
	MSIOF1_TXD_D_MARK = 1819,
	A11_MARK___3 = 1820,
	MSIOF1_RXD_MARK___3 = 1821,
	I2C3_SCL_D_MARK___2 = 1822,
	MSIOF1_RXD_D_MARK = 1823,
	A12_MARK___3 = 1824,
	FMCLK_MARK___2 = 1825,
	I2C3_SDA_D_MARK___2 = 1826,
	MSIOF1_SCK_D_MARK = 1827,
	A13_MARK___3 = 1828,
	ATAG0_N_C_MARK = 1829,
	BPFCLK_MARK___2 = 1830,
	MSIOF1_SS1_D_MARK = 1831,
	A14_MARK___3 = 1832,
	ATADIR0_N_C_MARK = 1833,
	FMIN_MARK___2 = 1834,
	FMIN_C_MARK___2 = 1835,
	MSIOF1_SYNC_D_MARK = 1836,
	A15_MARK___3 = 1837,
	BPFCLK_C_MARK___2 = 1838,
	A16_MARK___3 = 1839,
	DREQ2_B_MARK = 1840,
	FMCLK_C_MARK___2 = 1841,
	SCIFA1_SCK_B_MARK___2 = 1842,
	A17_MARK___3 = 1843,
	DACK2_B_MARK = 1844,
	I2C0_SDA_C_MARK___2 = 1845,
	A18_MARK___3 = 1846,
	DREQ1_MARK___2 = 1847,
	SCIFA1_RXD_C_MARK___2 = 1848,
	SCIFB1_RXD_C_MARK = 1849,
	A19_MARK___3 = 1850,
	DACK1_MARK___3 = 1851,
	SCIFA1_TXD_C_MARK___2 = 1852,
	SCIFB1_TXD_C_MARK = 1853,
	SCIFB1_SCK_B_MARK = 1854,
	A20_MARK___3 = 1855,
	SPCLK_MARK___2 = 1856,
	A21_MARK___3 = 1857,
	ATAWR0_N_B_MARK = 1858,
	MOSI_IO0_MARK___2 = 1859,
	A22_MARK___3 = 1860,
	MISO_IO1_MARK___2 = 1861,
	FMCLK_B_MARK___2 = 1862,
	TX0_MARK = 1863,
	SCIFA0_TXD_MARK___3 = 1864,
	A23_MARK___3 = 1865,
	IO2_MARK___2 = 1866,
	BPFCLK_B_MARK___2 = 1867,
	RX0_MARK = 1868,
	SCIFA0_RXD_MARK___3 = 1869,
	A24_MARK___3 = 1870,
	DREQ2_MARK___2 = 1871,
	IO3_MARK___2 = 1872,
	TX1_MARK = 1873,
	SCIFA1_TXD_MARK___3 = 1874,
	A25_MARK___3 = 1875,
	DACK2_MARK___3 = 1876,
	SSL_MARK___2 = 1877,
	DREQ1_C_MARK = 1878,
	RX1_MARK = 1879,
	SCIFA1_RXD_MARK___3 = 1880,
	CS0_N_MARK___2 = 1881,
	ATAG0_N_B_MARK = 1882,
	I2C1_SCL_MARK___2 = 1883,
	CS1_N_A26_MARK___2 = 1884,
	ATADIR0_N_B_MARK = 1885,
	I2C1_SDA_MARK___2 = 1886,
	EX_CS1_N_MARK___2 = 1887,
	MSIOF2_SCK_MARK___2 = 1888,
	EX_CS2_N_MARK___2 = 1889,
	ATAWR0_N_MARK___2 = 1890,
	MSIOF2_SYNC_MARK___2 = 1891,
	EX_CS3_N_MARK___2 = 1892,
	ATADIR0_N_MARK___2 = 1893,
	MSIOF2_TXD_MARK___3 = 1894,
	ATAG0_N_MARK___2 = 1895,
	EX_WAIT1_MARK___2 = 1896,
	EX_CS4_N_MARK___2 = 1897,
	ATARD0_N_MARK___2 = 1898,
	MSIOF2_RXD_MARK___2 = 1899,
	EX_WAIT2_MARK___2 = 1900,
	EX_CS5_N_MARK___2 = 1901,
	ATACS00_N_MARK___2 = 1902,
	MSIOF2_SS1_MARK___2 = 1903,
	HRX1_B_MARK = 1904,
	SCIFB1_RXD_B_MARK = 1905,
	PWM1_MARK___2 = 1906,
	TPU_TO1_MARK = 1907,
	BS_N_MARK___2 = 1908,
	ATACS10_N_MARK___2 = 1909,
	MSIOF2_SS2_MARK___2 = 1910,
	HTX1_B_MARK = 1911,
	SCIFB1_TXD_B_MARK = 1912,
	PWM2_MARK___2 = 1913,
	TPU_TO2_MARK = 1914,
	RD_WR_N_MARK___2 = 1915,
	HRX2_B_MARK = 1916,
	FMIN_B_MARK___2 = 1917,
	SCIFB0_RXD_B_MARK = 1918,
	DREQ1_D_MARK = 1919,
	WE0_N_MARK___2 = 1920,
	HCTS2_N_B_MARK = 1921,
	SCIFB0_TXD_B_MARK = 1922,
	WE1_N_MARK___2 = 1923,
	ATARD0_N_B_MARK = 1924,
	HTX2_B_MARK = 1925,
	SCIFB0_RTS_N_B_MARK = 1926,
	EX_WAIT0_MARK___2 = 1927,
	HRTS2_N_B_MARK = 1928,
	SCIFB0_CTS_N_B_MARK = 1929,
	DREQ0_MARK___2 = 1930,
	PWM3_MARK___2 = 1931,
	TPU_TO3_MARK = 1932,
	DACK0_MARK___3 = 1933,
	DRACK0_MARK___2 = 1934,
	REMOCON_MARK___2 = 1935,
	SPEEDIN_MARK___2 = 1936,
	HSCK0_C_MARK = 1937,
	HSCK2_C_MARK = 1938,
	SCIFB0_SCK_B_MARK = 1939,
	SCIFB2_SCK_B_MARK = 1940,
	DREQ2_C_MARK = 1941,
	HTX2_D_MARK = 1942,
	SSI_SCK0129_MARK___2 = 1943,
	HRX0_C_MARK = 1944,
	HRX2_C_MARK = 1945,
	SCIFB0_RXD_C_MARK = 1946,
	SCIFB2_RXD_C_MARK = 1947,
	SSI_WS0129_MARK___2 = 1948,
	HTX0_C_MARK = 1949,
	HTX2_C_MARK = 1950,
	SCIFB0_TXD_C_MARK = 1951,
	SCIFB2_TXD_C_MARK = 1952,
	SSI_SDATA0_MARK___2 = 1953,
	I2C0_SCL_B_MARK___2 = 1954,
	IIC0_SCL_B_MARK___2 = 1955,
	MSIOF2_SCK_C_MARK = 1956,
	SSI_SCK1_MARK___2 = 1957,
	I2C0_SDA_B_MARK___2 = 1958,
	IIC0_SDA_B_MARK___2 = 1959,
	MSIOF2_SYNC_C_MARK = 1960,
	GLO_I0_D_MARK = 1961,
	SSI_WS1_MARK___2 = 1962,
	I2C1_SCL_B_MARK___2 = 1963,
	IIC1_SCL_B_MARK = 1964,
	MSIOF2_TXD_C_MARK = 1965,
	GLO_I1_D_MARK = 1966,
	SSI_SDATA1_MARK___2 = 1967,
	I2C1_SDA_B_MARK___2 = 1968,
	IIC1_SDA_B_MARK = 1969,
	MSIOF2_RXD_C_MARK = 1970,
	SSI_SCK2_MARK___2 = 1971,
	I2C2_SCL_MARK___2 = 1972,
	GPS_CLK_B_MARK = 1973,
	GLO_Q0_D_MARK = 1974,
	HSCK1_E_MARK = 1975,
	SSI_WS2_MARK___2 = 1976,
	I2C2_SDA_MARK___2 = 1977,
	GPS_SIGN_B_MARK = 1978,
	RX2_E_MARK = 1979,
	GLO_Q1_D_MARK = 1980,
	HCTS1_N_E_MARK = 1981,
	SSI_SDATA2_MARK___2 = 1982,
	GPS_MAG_B_MARK = 1983,
	TX2_E_MARK = 1984,
	HRTS1_N_E_MARK = 1985,
	SSI_SCK34_MARK___2 = 1986,
	SSI_WS34_MARK___2 = 1987,
	SSI_SDATA3_MARK___2 = 1988,
	SSI_SCK4_MARK___2 = 1989,
	GLO_SS_D_MARK = 1990,
	SSI_WS4_MARK___2 = 1991,
	GLO_RFON_D_MARK = 1992,
	SSI_SDATA4_MARK___2 = 1993,
	MSIOF2_SCK_D_MARK = 1994,
	SSI_SCK5_MARK___2 = 1995,
	MSIOF1_SCK_C_MARK = 1996,
	TS_SDATA0_MARK = 1997,
	GLO_I0_MARK = 1998,
	MSIOF2_SYNC_D_MARK = 1999,
	VI1_R2_B_MARK = 2000,
	SSI_WS5_MARK___2 = 2001,
	MSIOF1_SYNC_C_MARK = 2002,
	TS_SCK0_MARK = 2003,
	GLO_I1_MARK = 2004,
	MSIOF2_TXD_D_MARK = 2005,
	VI1_R3_B_MARK = 2006,
	SSI_SDATA5_MARK___2 = 2007,
	MSIOF1_TXD_C_MARK = 2008,
	TS_SDEN0_MARK = 2009,
	GLO_Q0_MARK = 2010,
	MSIOF2_SS1_D_MARK = 2011,
	VI1_R4_B_MARK = 2012,
	SSI_SCK6_MARK___2 = 2013,
	MSIOF1_RXD_C_MARK = 2014,
	TS_SPSYNC0_MARK = 2015,
	GLO_Q1_MARK = 2016,
	MSIOF2_RXD_D_MARK = 2017,
	VI1_R5_B_MARK = 2018,
	SSI_WS6_MARK___2 = 2019,
	GLO_SCLK_MARK = 2020,
	MSIOF2_SS2_D_MARK = 2021,
	VI1_R6_B_MARK = 2022,
	SSI_SDATA6_MARK___2 = 2023,
	STP_IVCXO27_0_B_MARK = 2024,
	GLO_SDATA_MARK = 2025,
	VI1_R7_B_MARK = 2026,
	SSI_SCK78_MARK___2 = 2027,
	STP_ISCLK_0_B_MARK = 2028,
	GLO_SS_MARK = 2029,
	SSI_WS78_MARK___2 = 2030,
	TX0_D_MARK = 2031,
	STP_ISD_0_B_MARK = 2032,
	GLO_RFON_MARK = 2033,
	SSI_SDATA7_MARK___2 = 2034,
	RX0_D_MARK = 2035,
	STP_ISEN_0_B_MARK = 2036,
	SSI_SDATA8_MARK___2 = 2037,
	TX1_D_MARK = 2038,
	STP_ISSYNC_0_B_MARK = 2039,
	SSI_SCK9_MARK___2 = 2040,
	RX1_D_MARK = 2041,
	GLO_SCLK_D_MARK = 2042,
	SSI_WS9_MARK___2 = 2043,
	TX3_D_MARK = 2044,
	CAN0_TX_D_MARK___2 = 2045,
	GLO_SDATA_D_MARK = 2046,
	SSI_SDATA9_MARK___2 = 2047,
	RX3_D_MARK = 2048,
	CAN0_RX_D_MARK___2 = 2049,
	AUDIO_CLKB_MARK___2 = 2050,
	STP_OPWM_0_B_MARK = 2051,
	MSIOF1_SCK_B_MARK___2 = 2052,
	SCIF_CLK_MARK___2 = 2053,
	DVC_MUTE_MARK___2 = 2054,
	BPFCLK_E_MARK___2 = 2055,
	AUDIO_CLKC_MARK___2 = 2056,
	SCIFB0_SCK_C_MARK = 2057,
	MSIOF1_SYNC_B_MARK___2 = 2058,
	RX2_MARK = 2059,
	SCIFA2_RXD_MARK___2 = 2060,
	FMIN_E_MARK___2 = 2061,
	AUDIO_CLKOUT_MARK___2 = 2062,
	MSIOF1_SS1_B_MARK___2 = 2063,
	TX2_MARK = 2064,
	SCIFA2_TXD_MARK___2 = 2065,
	IRQ0_MARK___2 = 2066,
	SCIFB1_RXD_D_MARK = 2067,
	IRQ1_MARK___2 = 2068,
	SCIFB1_SCK_C_MARK = 2069,
	IRQ2_MARK___2 = 2070,
	SCIFB1_TXD_D_MARK = 2071,
	IRQ3_MARK___2 = 2072,
	I2C4_SCL_C_MARK___2 = 2073,
	MSIOF2_TXD_E_MARK = 2074,
	IRQ4_MARK___2 = 2075,
	HRX1_C_MARK = 2076,
	I2C4_SDA_C_MARK___2 = 2077,
	MSIOF2_RXD_E_MARK = 2078,
	IRQ5_MARK___2 = 2079,
	HTX1_C_MARK = 2080,
	I2C1_SCL_E_MARK___2 = 2081,
	MSIOF2_SCK_E_MARK = 2082,
	IRQ6_MARK___2 = 2083,
	HSCK1_C_MARK = 2084,
	MSIOF1_SS2_B_MARK___2 = 2085,
	I2C1_SDA_E_MARK___2 = 2086,
	MSIOF2_SYNC_E_MARK = 2087,
	IRQ7_MARK___2 = 2088,
	HCTS1_N_C_MARK = 2089,
	MSIOF1_TXD_B_MARK___2 = 2090,
	GPS_CLK_C_MARK = 2091,
	GPS_CLK_D_MARK = 2092,
	IRQ8_MARK___2 = 2093,
	HRTS1_N_C_MARK = 2094,
	MSIOF1_RXD_B_MARK___2 = 2095,
	GPS_SIGN_C_MARK = 2096,
	GPS_SIGN_D_MARK = 2097,
	IRQ9_MARK___2 = 2098,
	DU1_DOTCLKIN_B_MARK = 2099,
	CAN_CLK_D_MARK___2 = 2100,
	GPS_MAG_C_MARK = 2101,
	SCIF_CLK_B_MARK___2 = 2102,
	GPS_MAG_D_MARK = 2103,
	DU1_DR0_MARK___2 = 2104,
	LCDOUT0_MARK___2 = 2105,
	VI1_DATA0_B_MARK = 2106,
	TX0_B_MARK = 2107,
	SCIFA0_TXD_B_MARK___2 = 2108,
	MSIOF2_SCK_B_MARK___2 = 2109,
	DU1_DR1_MARK___2 = 2110,
	LCDOUT1_MARK___2 = 2111,
	VI1_DATA1_B_MARK = 2112,
	RX0_B_MARK = 2113,
	SCIFA0_RXD_B_MARK___2 = 2114,
	MSIOF2_SYNC_B_MARK___2 = 2115,
	DU1_DR2_MARK___2 = 2116,
	LCDOUT2_MARK___2 = 2117,
	SSI_SCK0129_B_MARK = 2118,
	DU1_DR3_MARK___2 = 2119,
	LCDOUT3_MARK___2 = 2120,
	SSI_WS0129_B_MARK = 2121,
	DU1_DR4_MARK___2 = 2122,
	LCDOUT4_MARK___2 = 2123,
	SSI_SDATA0_B_MARK = 2124,
	DU1_DR5_MARK___2 = 2125,
	LCDOUT5_MARK___2 = 2126,
	SSI_SCK1_B_MARK___2 = 2127,
	DU1_DR6_MARK___2 = 2128,
	LCDOUT6_MARK___2 = 2129,
	SSI_WS1_B_MARK___2 = 2130,
	DU1_DR7_MARK___2 = 2131,
	LCDOUT7_MARK___2 = 2132,
	SSI_SDATA1_B_MARK___2 = 2133,
	DU1_DG0_MARK___2 = 2134,
	LCDOUT8_MARK___2 = 2135,
	VI1_DATA2_B_MARK = 2136,
	TX1_B_MARK = 2137,
	SCIFA1_TXD_B_MARK___2 = 2138,
	MSIOF2_SS1_B_MARK___2 = 2139,
	DU1_DG1_MARK___2 = 2140,
	LCDOUT9_MARK___2 = 2141,
	VI1_DATA3_B_MARK = 2142,
	RX1_B_MARK = 2143,
	SCIFA1_RXD_B_MARK___2 = 2144,
	MSIOF2_SS2_B_MARK___2 = 2145,
	DU1_DG2_MARK___2 = 2146,
	LCDOUT10_MARK___2 = 2147,
	VI1_DATA4_B_MARK = 2148,
	SCIF1_SCK_B_MARK___2 = 2149,
	SCIFA1_SCK_MARK___3 = 2150,
	SSI_SCK78_B_MARK___2 = 2151,
	DU1_DG3_MARK___2 = 2152,
	LCDOUT11_MARK___2 = 2153,
	VI1_DATA5_B_MARK = 2154,
	SSI_WS78_B_MARK___2 = 2155,
	DU1_DG4_MARK___2 = 2156,
	LCDOUT12_MARK___2 = 2157,
	VI1_DATA6_B_MARK = 2158,
	HRX0_B_MARK = 2159,
	SCIFB2_RXD_B_MARK = 2160,
	SSI_SDATA7_B_MARK___2 = 2161,
	DU1_DG5_MARK___2 = 2162,
	LCDOUT13_MARK___2 = 2163,
	VI1_DATA7_B_MARK = 2164,
	HCTS0_N_B_MARK = 2165,
	SCIFB2_TXD_B_MARK = 2166,
	SSI_SDATA8_B_MARK___2 = 2167,
	DU1_DG6_MARK___2 = 2168,
	LCDOUT14_MARK___2 = 2169,
	HRTS0_N_B_MARK = 2170,
	SCIFB2_CTS_N_B_MARK = 2171,
	SSI_SCK9_B_MARK___2 = 2172,
	DU1_DG7_MARK___2 = 2173,
	LCDOUT15_MARK___2 = 2174,
	HTX0_B_MARK = 2175,
	SCIFB2_RTS_N_B_MARK = 2176,
	SSI_WS9_B_MARK___2 = 2177,
	DU1_DB0_MARK___2 = 2178,
	LCDOUT16_MARK___2 = 2179,
	VI1_CLK_B_MARK = 2180,
	TX2_B_MARK = 2181,
	SCIFA2_TXD_B_MARK___2 = 2182,
	MSIOF2_TXD_B_MARK___2 = 2183,
	DU1_DB1_MARK___2 = 2184,
	LCDOUT17_MARK___2 = 2185,
	VI1_HSYNC_N_B_MARK = 2186,
	RX2_B_MARK = 2187,
	SCIFA2_RXD_B_MARK___2 = 2188,
	MSIOF2_RXD_B_MARK___2 = 2189,
	DU1_DB2_MARK___2 = 2190,
	LCDOUT18_MARK___2 = 2191,
	VI1_VSYNC_N_B_MARK = 2192,
	SCIF2_SCK_B_MARK___2 = 2193,
	SCIFA2_SCK_MARK___2 = 2194,
	SSI_SDATA9_B_MARK___2 = 2195,
	DU1_DB3_MARK___2 = 2196,
	LCDOUT19_MARK___2 = 2197,
	VI1_CLKENB_B_MARK = 2198,
	DU1_DB4_MARK___2 = 2199,
	LCDOUT20_MARK___2 = 2200,
	VI1_FIELD_B_MARK = 2201,
	CAN1_RX_MARK___2 = 2202,
	DU1_DB5_MARK___2 = 2203,
	LCDOUT21_MARK___2 = 2204,
	TX3_MARK = 2205,
	SCIFA3_TXD_MARK___3 = 2206,
	CAN1_TX_MARK___2 = 2207,
	DU1_DB6_MARK___2 = 2208,
	LCDOUT22_MARK___2 = 2209,
	I2C3_SCL_C_MARK___2 = 2210,
	RX3_MARK = 2211,
	SCIFA3_RXD_MARK___3 = 2212,
	DU1_DB7_MARK___2 = 2213,
	LCDOUT23_MARK___2 = 2214,
	I2C3_SDA_C_MARK___2 = 2215,
	SCIF3_SCK_MARK___2 = 2216,
	SCIFA3_SCK_MARK___2 = 2217,
	DU1_DOTCLKIN_MARK___2 = 2218,
	QSTVA_QVS_MARK___2 = 2219,
	DU1_DOTCLKOUT0_MARK___2 = 2220,
	QCLK_MARK___2 = 2221,
	DU1_DOTCLKOUT1_MARK___2 = 2222,
	QSTVB_QVE_MARK___2 = 2223,
	CAN0_TX_MARK___2 = 2224,
	TX3_B_MARK = 2225,
	I2C2_SCL_B_MARK___2 = 2226,
	PWM4_MARK___2 = 2227,
	DU1_EXHSYNC_DU1_HSYNC_MARK___2 = 2228,
	QSTH_QHS_MARK___2 = 2229,
	DU1_EXVSYNC_DU1_VSYNC_MARK___2 = 2230,
	QSTB_QHE_MARK___2 = 2231,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK___2 = 2232,
	QCPV_QDE_MARK___2 = 2233,
	CAN0_RX_MARK___2 = 2234,
	RX3_B_MARK = 2235,
	I2C2_SDA_B_MARK___2 = 2236,
	DU1_DISP_MARK___2 = 2237,
	QPOLA_MARK___2 = 2238,
	DU1_CDE_MARK___2 = 2239,
	QPOLB_MARK___2 = 2240,
	PWM4_B_MARK___2 = 2241,
	VI0_CLKENB_MARK___2 = 2242,
	TX4_MARK = 2243,
	SCIFA4_TXD_MARK___3 = 2244,
	TS_SDATA0_D_MARK = 2245,
	VI0_FIELD_MARK___2 = 2246,
	RX4_MARK = 2247,
	SCIFA4_RXD_MARK___3 = 2248,
	TS_SCK0_D_MARK = 2249,
	VI0_HSYNC_N_MARK___2 = 2250,
	TX5_MARK = 2251,
	SCIFA5_TXD_MARK___2 = 2252,
	TS_SDEN0_D_MARK = 2253,
	VI0_VSYNC_N_MARK___2 = 2254,
	RX5_MARK = 2255,
	SCIFA5_RXD_MARK___2 = 2256,
	TS_SPSYNC0_D_MARK = 2257,
	VI0_DATA3_VI0_B3_MARK___2 = 2258,
	SCIF3_SCK_B_MARK___2 = 2259,
	SCIFA3_SCK_B_MARK___2 = 2260,
	VI0_G0_MARK___2 = 2261,
	IIC1_SCL_MARK = 2262,
	STP_IVCXO27_0_C_MARK = 2263,
	I2C4_SCL_MARK___2 = 2264,
	HCTS2_N_MARK = 2265,
	SCIFB2_CTS_N_MARK___2 = 2266,
	ATAWR1_N_MARK___2 = 2267,
	VI0_G1_MARK___2 = 2268,
	IIC1_SDA_MARK = 2269,
	STP_ISCLK_0_C_MARK = 2270,
	I2C4_SDA_MARK___2 = 2271,
	HRTS2_N_MARK = 2272,
	SCIFB2_RTS_N_MARK___2 = 2273,
	ATADIR1_N_MARK___2 = 2274,
	VI0_G2_MARK___2 = 2275,
	VI2_HSYNC_N_MARK = 2276,
	STP_ISD_0_C_MARK = 2277,
	I2C3_SCL_B_MARK___2 = 2278,
	HSCK2_MARK = 2279,
	SCIFB2_SCK_MARK___2 = 2280,
	ATARD1_N_MARK___2 = 2281,
	VI0_G3_MARK___2 = 2282,
	VI2_VSYNC_N_MARK = 2283,
	STP_ISEN_0_C_MARK = 2284,
	I2C3_SDA_B_MARK___2 = 2285,
	HRX2_MARK = 2286,
	SCIFB2_RXD_MARK___2 = 2287,
	ATACS01_N_MARK___2 = 2288,
	VI0_G4_MARK___2 = 2289,
	VI2_CLKENB_MARK = 2290,
	STP_ISSYNC_0_C_MARK = 2291,
	HTX2_MARK = 2292,
	SCIFB2_TXD_MARK___2 = 2293,
	SCIFB0_SCK_D_MARK = 2294,
	VI0_G5_MARK___2 = 2295,
	VI2_FIELD_MARK = 2296,
	STP_OPWM_0_C_MARK = 2297,
	FMCLK_D_MARK___2 = 2298,
	CAN0_TX_E_MARK = 2299,
	HTX1_D_MARK = 2300,
	SCIFB0_TXD_D_MARK = 2301,
	VI0_G6_MARK___2 = 2302,
	VI2_CLK_MARK = 2303,
	BPFCLK_D_MARK___2 = 2304,
	VI0_G7_MARK___2 = 2305,
	VI2_DATA0_MARK = 2306,
	FMIN_D_MARK___2 = 2307,
	VI0_R0_MARK___2 = 2308,
	VI2_DATA1_MARK = 2309,
	GLO_I0_B_MARK = 2310,
	TS_SDATA0_C_MARK = 2311,
	ATACS11_N_MARK___2 = 2312,
	VI0_R1_MARK___2 = 2313,
	VI2_DATA2_MARK = 2314,
	GLO_I1_B_MARK = 2315,
	TS_SCK0_C_MARK = 2316,
	ATAG1_N_MARK___2 = 2317,
	VI0_R2_MARK___2 = 2318,
	VI2_DATA3_MARK = 2319,
	GLO_Q0_B_MARK = 2320,
	TS_SDEN0_C_MARK = 2321,
	VI0_R3_MARK___2 = 2322,
	VI2_DATA4_MARK = 2323,
	GLO_Q1_B_MARK = 2324,
	TS_SPSYNC0_C_MARK = 2325,
	VI0_R4_MARK___2 = 2326,
	VI2_DATA5_MARK = 2327,
	GLO_SCLK_B_MARK = 2328,
	TX0_C_MARK = 2329,
	I2C1_SCL_D_MARK___2 = 2330,
	VI0_R5_MARK___2 = 2331,
	VI2_DATA6_MARK = 2332,
	GLO_SDATA_B_MARK = 2333,
	RX0_C_MARK = 2334,
	I2C1_SDA_D_MARK___2 = 2335,
	VI0_R6_MARK___2 = 2336,
	VI2_DATA7_MARK = 2337,
	GLO_SS_B_MARK = 2338,
	TX1_C_MARK = 2339,
	I2C4_SCL_B_MARK___2 = 2340,
	VI0_R7_MARK___2 = 2341,
	GLO_RFON_B_MARK = 2342,
	RX1_C_MARK = 2343,
	CAN0_RX_E_MARK = 2344,
	I2C4_SDA_B_MARK___2 = 2345,
	HRX1_D_MARK = 2346,
	SCIFB0_RXD_D_MARK = 2347,
	VI1_HSYNC_N_MARK___2 = 2348,
	AVB_RXD0_MARK___2 = 2349,
	TS_SDATA0_B_MARK = 2350,
	TX4_B_MARK = 2351,
	SCIFA4_TXD_B_MARK___2 = 2352,
	VI1_VSYNC_N_MARK___2 = 2353,
	AVB_RXD1_MARK___2 = 2354,
	TS_SCK0_B_MARK = 2355,
	RX4_B_MARK = 2356,
	SCIFA4_RXD_B_MARK___2 = 2357,
	VI1_CLKENB_MARK___2 = 2358,
	AVB_RXD2_MARK___2 = 2359,
	TS_SDEN0_B_MARK = 2360,
	VI1_FIELD_MARK___2 = 2361,
	AVB_RXD3_MARK___2 = 2362,
	TS_SPSYNC0_B_MARK = 2363,
	VI1_CLK_MARK___2 = 2364,
	AVB_RXD4_MARK___2 = 2365,
	VI1_DATA0_MARK___2 = 2366,
	AVB_RXD5_MARK___2 = 2367,
	VI1_DATA1_MARK___2 = 2368,
	AVB_RXD6_MARK___2 = 2369,
	VI1_DATA2_MARK___2 = 2370,
	AVB_RXD7_MARK___2 = 2371,
	VI1_DATA3_MARK___2 = 2372,
	AVB_RX_ER_MARK___2 = 2373,
	VI1_DATA4_MARK___2 = 2374,
	AVB_MDIO_MARK___2 = 2375,
	VI1_DATA5_MARK___2 = 2376,
	AVB_RX_DV_MARK___2 = 2377,
	VI1_DATA6_MARK___2 = 2378,
	AVB_MAGIC_MARK___2 = 2379,
	VI1_DATA7_MARK___2 = 2380,
	AVB_MDC_MARK___2 = 2381,
	ETH_MDIO_MARK___2 = 2382,
	AVB_RX_CLK_MARK___2 = 2383,
	I2C2_SCL_C_MARK___2 = 2384,
	ETH_CRS_DV_MARK___2 = 2385,
	AVB_LINK_MARK___2 = 2386,
	I2C2_SDA_C_MARK___2 = 2387,
	ETH_RX_ER_MARK___2 = 2388,
	AVB_CRS_MARK___2 = 2389,
	I2C3_SCL_MARK___2 = 2390,
	IIC0_SCL_MARK___2 = 2391,
	ETH_RXD0_MARK___2 = 2392,
	AVB_PHY_INT_MARK___2 = 2393,
	I2C3_SDA_MARK___2 = 2394,
	IIC0_SDA_MARK___2 = 2395,
	ETH_RXD1_MARK___2 = 2396,
	AVB_GTXREFCLK_MARK___2 = 2397,
	CAN0_TX_C_MARK___2 = 2398,
	I2C2_SCL_D_MARK___2 = 2399,
	MSIOF1_RXD_E_MARK = 2400,
	ETH_LINK_MARK___2 = 2401,
	AVB_TXD0_MARK___2 = 2402,
	CAN0_RX_C_MARK___2 = 2403,
	I2C2_SDA_D_MARK___2 = 2404,
	MSIOF1_SCK_E_MARK = 2405,
	ETH_REFCLK_MARK___2 = 2406,
	AVB_TXD1_MARK___2 = 2407,
	SCIFA3_RXD_B_MARK___2 = 2408,
	CAN1_RX_C_MARK___2 = 2409,
	MSIOF1_SYNC_E_MARK = 2410,
	ETH_TXD1_MARK___2 = 2411,
	AVB_TXD2_MARK___2 = 2412,
	SCIFA3_TXD_B_MARK___2 = 2413,
	CAN1_TX_C_MARK___2 = 2414,
	MSIOF1_TXD_E_MARK = 2415,
	ETH_TX_EN_MARK___2 = 2416,
	AVB_TXD3_MARK___2 = 2417,
	TCLK1_B_MARK___2 = 2418,
	CAN_CLK_B_MARK___2 = 2419,
	ETH_MAGIC_MARK___2 = 2420,
	AVB_TXD4_MARK___2 = 2421,
	IETX_C_MARK___2 = 2422,
	ETH_TXD0_MARK___2 = 2423,
	AVB_TXD5_MARK___2 = 2424,
	IECLK_C_MARK___2 = 2425,
	ETH_MDC_MARK___2 = 2426,
	AVB_TXD6_MARK___2 = 2427,
	IERX_C_MARK___2 = 2428,
	STP_IVCXO27_0_MARK = 2429,
	AVB_TXD7_MARK___2 = 2430,
	SCIFB2_TXD_D_MARK = 2431,
	ADIDATA_B_MARK___2 = 2432,
	MSIOF0_SYNC_C_MARK = 2433,
	STP_ISCLK_0_MARK = 2434,
	AVB_TX_EN_MARK___2 = 2435,
	SCIFB2_RXD_D_MARK = 2436,
	ADICS_SAMP_B_MARK___2 = 2437,
	MSIOF0_SCK_C_MARK = 2438,
	STP_ISD_0_MARK = 2439,
	AVB_TX_ER_MARK___2 = 2440,
	SCIFB2_SCK_C_MARK = 2441,
	ADICLK_B_MARK___2 = 2442,
	MSIOF0_SS1_C_MARK = 2443,
	STP_ISEN_0_MARK = 2444,
	AVB_TX_CLK_MARK___2 = 2445,
	ADICHS0_B_MARK___2 = 2446,
	MSIOF0_SS2_C_MARK = 2447,
	STP_ISSYNC_0_MARK = 2448,
	AVB_COL_MARK___2 = 2449,
	ADICHS1_B_MARK___2 = 2450,
	MSIOF0_RXD_C_MARK = 2451,
	STP_OPWM_0_MARK = 2452,
	AVB_GTX_CLK_MARK___2 = 2453,
	PWM0_B_MARK___2 = 2454,
	ADICHS2_B_MARK___2 = 2455,
	MSIOF0_TXD_C_MARK = 2456,
	SD0_CLK_MARK___2 = 2457,
	SPCLK_B_MARK = 2458,
	SD0_CMD_MARK___2 = 2459,
	MOSI_IO0_B_MARK = 2460,
	SD0_DATA0_MARK___2 = 2461,
	MISO_IO1_B_MARK = 2462,
	SD0_DATA1_MARK___2 = 2463,
	IO2_B_MARK = 2464,
	SD0_DATA2_MARK___2 = 2465,
	IO3_B_MARK = 2466,
	SD0_DATA3_MARK___2 = 2467,
	SSL_B_MARK = 2468,
	SD0_CD_MARK___2 = 2469,
	MMC_D6_B_MARK = 2470,
	SIM0_RST_B_MARK = 2471,
	CAN0_RX_F_MARK = 2472,
	SCIFA5_TXD_B_MARK___2 = 2473,
	TX3_C_MARK = 2474,
	SD0_WP_MARK___2 = 2475,
	MMC_D7_B_MARK = 2476,
	SIM0_D_B_MARK = 2477,
	CAN0_TX_F_MARK = 2478,
	SCIFA5_RXD_B_MARK___2 = 2479,
	RX3_C_MARK = 2480,
	SD1_CMD_MARK___2 = 2481,
	REMOCON_B_MARK___2 = 2482,
	SD1_DATA0_MARK___2 = 2483,
	SPEEDIN_B_MARK___2 = 2484,
	SD1_DATA1_MARK___2 = 2485,
	IETX_B_MARK___2 = 2486,
	SD1_DATA2_MARK___2 = 2487,
	IECLK_B_MARK___2 = 2488,
	SD1_DATA3_MARK___2 = 2489,
	IERX_B_MARK___2 = 2490,
	SD1_CD_MARK___2 = 2491,
	PWM0_MARK___2 = 2492,
	TPU_TO0_MARK = 2493,
	I2C1_SCL_C_MARK___2 = 2494,
	SD1_WP_MARK___2 = 2495,
	PWM1_B_MARK___2 = 2496,
	I2C1_SDA_C_MARK___2 = 2497,
	SD2_CLK_MARK___2 = 2498,
	MMC_CLK_MARK___2 = 2499,
	SD2_CMD_MARK___2 = 2500,
	MMC_CMD_MARK___2 = 2501,
	SD2_DATA0_MARK___2 = 2502,
	MMC_D0_MARK___2 = 2503,
	SD2_DATA1_MARK___2 = 2504,
	MMC_D1_MARK___2 = 2505,
	SD2_DATA2_MARK___2 = 2506,
	MMC_D2_MARK___2 = 2507,
	SD2_DATA3_MARK___2 = 2508,
	MMC_D3_MARK___2 = 2509,
	SD2_CD_MARK___2 = 2510,
	MMC_D4_MARK___2 = 2511,
	IIC1_SCL_C_MARK = 2512,
	TX5_B_MARK = 2513,
	SCIFA5_TXD_C_MARK___2 = 2514,
	SD2_WP_MARK___2 = 2515,
	MMC_D5_MARK___2 = 2516,
	IIC1_SDA_C_MARK = 2517,
	RX5_B_MARK = 2518,
	SCIFA5_RXD_C_MARK___2 = 2519,
	MSIOF0_SCK_MARK___2 = 2520,
	RX2_C_MARK = 2521,
	ADIDATA_MARK___2 = 2522,
	VI1_CLK_C_MARK = 2523,
	VI1_G0_B_MARK = 2524,
	MSIOF0_SYNC_MARK___2 = 2525,
	TX2_C_MARK = 2526,
	ADICS_SAMP_MARK___2 = 2527,
	VI1_CLKENB_C_MARK = 2528,
	VI1_G1_B_MARK = 2529,
	MSIOF0_TXD_MARK___3 = 2530,
	ADICLK_MARK___2 = 2531,
	VI1_FIELD_C_MARK = 2532,
	VI1_G2_B_MARK = 2533,
	MSIOF0_RXD_MARK___3 = 2534,
	ADICHS0_MARK___2 = 2535,
	VI1_DATA0_C_MARK = 2536,
	VI1_G3_B_MARK = 2537,
	MSIOF0_SS1_MARK___3 = 2538,
	MMC_D6_MARK___2 = 2539,
	ADICHS1_MARK___2 = 2540,
	TX0_E_MARK = 2541,
	VI1_HSYNC_N_C_MARK = 2542,
	IIC0_SCL_C_MARK___2 = 2543,
	VI1_G4_B_MARK = 2544,
	MSIOF0_SS2_MARK___3 = 2545,
	MMC_D7_MARK___2 = 2546,
	ADICHS2_MARK___2 = 2547,
	RX0_E_MARK = 2548,
	VI1_VSYNC_N_C_MARK = 2549,
	IIC0_SDA_C_MARK___2 = 2550,
	VI1_G5_B_MARK = 2551,
	SIM0_RST_MARK = 2552,
	IETX_MARK___2 = 2553,
	CAN1_TX_D_MARK___2 = 2554,
	SIM0_CLK_MARK = 2555,
	IECLK_MARK___2 = 2556,
	CAN_CLK_C_MARK___2 = 2557,
	SIM0_D_MARK = 2558,
	IERX_MARK___2 = 2559,
	CAN1_RX_D_MARK___2 = 2560,
	GPS_CLK_MARK = 2561,
	DU1_DOTCLKIN_C_MARK = 2562,
	AUDIO_CLKB_B_MARK___2 = 2563,
	PWM5_B_MARK___2 = 2564,
	SCIFA3_TXD_C_MARK = 2565,
	GPS_SIGN_MARK = 2566,
	TX4_C_MARK = 2567,
	SCIFA4_TXD_C_MARK___2 = 2568,
	PWM5_MARK___2 = 2569,
	VI1_G6_B_MARK = 2570,
	SCIFA3_RXD_C_MARK = 2571,
	GPS_MAG_MARK = 2572,
	RX4_C_MARK = 2573,
	SCIFA4_RXD_C_MARK___2 = 2574,
	PWM6_MARK___2 = 2575,
	VI1_G7_B_MARK = 2576,
	SCIFA3_SCK_C_MARK = 2577,
	HCTS0_N_MARK = 2578,
	SCIFB0_CTS_N_MARK___2 = 2579,
	GLO_I0_C_MARK = 2580,
	TCLK1_MARK___2 = 2581,
	VI1_DATA1_C_MARK = 2582,
	HRTS0_N_MARK = 2583,
	SCIFB0_RTS_N_MARK___2 = 2584,
	GLO_I1_C_MARK = 2585,
	VI1_DATA2_C_MARK = 2586,
	HSCK0_MARK = 2587,
	SCIFB0_SCK_MARK___2 = 2588,
	GLO_Q0_C_MARK = 2589,
	CAN_CLK_MARK___2 = 2590,
	TCLK2_MARK___2 = 2591,
	VI1_DATA3_C_MARK = 2592,
	HRX0_MARK = 2593,
	SCIFB0_RXD_MARK___2 = 2594,
	GLO_Q1_C_MARK = 2595,
	CAN0_RX_B_MARK___2 = 2596,
	VI1_DATA4_C_MARK = 2597,
	HTX0_MARK = 2598,
	SCIFB0_TXD_MARK___2 = 2599,
	GLO_SCLK_C_MARK = 2600,
	CAN0_TX_B_MARK___2 = 2601,
	VI1_DATA5_C_MARK = 2602,
	HRX1_MARK = 2603,
	SCIFB1_RXD_MARK___2 = 2604,
	VI1_R0_B_MARK = 2605,
	GLO_SDATA_C_MARK = 2606,
	VI1_DATA6_C_MARK = 2607,
	HTX1_MARK = 2608,
	SCIFB1_TXD_MARK___2 = 2609,
	VI1_R1_B_MARK = 2610,
	GLO_SS_C_MARK = 2611,
	VI1_DATA7_C_MARK = 2612,
	HSCK1_MARK = 2613,
	SCIFB1_SCK_MARK___2 = 2614,
	MLB_CLK_MARK___2 = 2615,
	GLO_RFON_C_MARK = 2616,
	HCTS1_N_MARK = 2617,
	SCIFB1_CTS_N_MARK = 2618,
	MLB_SIG_MARK___2 = 2619,
	CAN1_TX_B_MARK___2 = 2620,
	HRTS1_N_MARK = 2621,
	SCIFB1_RTS_N_MARK = 2622,
	MLB_DAT_MARK___2 = 2623,
	CAN1_RX_B_MARK___2 = 2624,
	PINMUX_MARK_END___3 = 2625,
};

enum {
	PINMUX_RESERVED___4 = 0,
	PINMUX_DATA_BEGIN___4 = 1,
	GP_0_0_DATA___3 = 2,
	GP_0_1_DATA___3 = 3,
	GP_0_2_DATA___3 = 4,
	GP_0_3_DATA___3 = 5,
	GP_0_4_DATA___3 = 6,
	GP_0_5_DATA___3 = 7,
	GP_0_6_DATA___3 = 8,
	GP_0_7_DATA___3 = 9,
	GP_0_8_DATA___3 = 10,
	GP_0_9_DATA___3 = 11,
	GP_0_10_DATA___3 = 12,
	GP_0_11_DATA___3 = 13,
	GP_0_12_DATA___3 = 14,
	GP_0_13_DATA___3 = 15,
	GP_0_14_DATA___3 = 16,
	GP_0_15_DATA___3 = 17,
	GP_0_16_DATA___3 = 18,
	GP_0_17_DATA___3 = 19,
	GP_0_18_DATA___3 = 20,
	GP_0_19_DATA___3 = 21,
	GP_0_20_DATA___3 = 22,
	GP_0_21_DATA___3 = 23,
	GP_0_22_DATA___3 = 24,
	GP_0_23_DATA___3 = 25,
	GP_0_24_DATA___3 = 26,
	GP_0_25_DATA___3 = 27,
	GP_0_26_DATA___3 = 28,
	GP_0_27_DATA___3 = 29,
	GP_0_28_DATA___3 = 30,
	GP_0_29_DATA___3 = 31,
	GP_0_30_DATA___3 = 32,
	GP_0_31_DATA___3 = 33,
	GP_1_0_DATA___3 = 34,
	GP_1_1_DATA___3 = 35,
	GP_1_2_DATA___3 = 36,
	GP_1_3_DATA___3 = 37,
	GP_1_4_DATA___3 = 38,
	GP_1_5_DATA___3 = 39,
	GP_1_6_DATA___3 = 40,
	GP_1_7_DATA___3 = 41,
	GP_1_8_DATA___3 = 42,
	GP_1_9_DATA___3 = 43,
	GP_1_10_DATA___3 = 44,
	GP_1_11_DATA___3 = 45,
	GP_1_12_DATA___3 = 46,
	GP_1_13_DATA___3 = 47,
	GP_1_14_DATA___3 = 48,
	GP_1_15_DATA___3 = 49,
	GP_1_16_DATA___3 = 50,
	GP_1_17_DATA___3 = 51,
	GP_1_18_DATA___3 = 52,
	GP_1_19_DATA___3 = 53,
	GP_1_20_DATA___3 = 54,
	GP_1_21_DATA___3 = 55,
	GP_1_22_DATA___3 = 56,
	GP_1_23_DATA___3 = 57,
	GP_1_24_DATA___3 = 58,
	GP_1_25_DATA___3 = 59,
	GP_1_26_DATA = 60,
	GP_1_27_DATA = 61,
	GP_1_28_DATA = 62,
	GP_1_29_DATA = 63,
	GP_1_30_DATA = 64,
	GP_1_31_DATA = 65,
	GP_2_0_DATA___3 = 66,
	GP_2_1_DATA___3 = 67,
	GP_2_2_DATA___3 = 68,
	GP_2_3_DATA___3 = 69,
	GP_2_4_DATA___3 = 70,
	GP_2_5_DATA___3 = 71,
	GP_2_6_DATA___3 = 72,
	GP_2_7_DATA___3 = 73,
	GP_2_8_DATA___3 = 74,
	GP_2_9_DATA___3 = 75,
	GP_2_10_DATA___3 = 76,
	GP_2_11_DATA___3 = 77,
	GP_2_12_DATA___3 = 78,
	GP_2_13_DATA___3 = 79,
	GP_2_14_DATA___3 = 80,
	GP_2_15_DATA___3 = 81,
	GP_2_16_DATA___3 = 82,
	GP_2_17_DATA___3 = 83,
	GP_2_18_DATA___3 = 84,
	GP_2_19_DATA___3 = 85,
	GP_2_20_DATA___3 = 86,
	GP_2_21_DATA___3 = 87,
	GP_2_22_DATA___3 = 88,
	GP_2_23_DATA___3 = 89,
	GP_2_24_DATA___3 = 90,
	GP_2_25_DATA___3 = 91,
	GP_2_26_DATA___3 = 92,
	GP_2_27_DATA___3 = 93,
	GP_2_28_DATA___3 = 94,
	GP_2_29_DATA___3 = 95,
	GP_2_30_DATA___3 = 96,
	GP_2_31_DATA___3 = 97,
	GP_3_0_DATA___3 = 98,
	GP_3_1_DATA___3 = 99,
	GP_3_2_DATA___3 = 100,
	GP_3_3_DATA___3 = 101,
	GP_3_4_DATA___3 = 102,
	GP_3_5_DATA___3 = 103,
	GP_3_6_DATA___3 = 104,
	GP_3_7_DATA___3 = 105,
	GP_3_8_DATA___3 = 106,
	GP_3_9_DATA___3 = 107,
	GP_3_10_DATA___3 = 108,
	GP_3_11_DATA___3 = 109,
	GP_3_12_DATA___3 = 110,
	GP_3_13_DATA___3 = 111,
	GP_3_14_DATA___3 = 112,
	GP_3_15_DATA___3 = 113,
	GP_3_16_DATA___3 = 114,
	GP_3_17_DATA___3 = 115,
	GP_3_18_DATA___3 = 116,
	GP_3_19_DATA___3 = 117,
	GP_3_20_DATA___3 = 118,
	GP_3_21_DATA___3 = 119,
	GP_3_22_DATA___3 = 120,
	GP_3_23_DATA___3 = 121,
	GP_3_24_DATA___3 = 122,
	GP_3_25_DATA___3 = 123,
	GP_3_26_DATA___3 = 124,
	GP_3_27_DATA___3 = 125,
	GP_3_28_DATA___3 = 126,
	GP_3_29_DATA___3 = 127,
	GP_3_30_DATA___3 = 128,
	GP_3_31_DATA___3 = 129,
	GP_4_0_DATA___3 = 130,
	GP_4_1_DATA___3 = 131,
	GP_4_2_DATA___3 = 132,
	GP_4_3_DATA___3 = 133,
	GP_4_4_DATA___3 = 134,
	GP_4_5_DATA___3 = 135,
	GP_4_6_DATA___3 = 136,
	GP_4_7_DATA___3 = 137,
	GP_4_8_DATA___3 = 138,
	GP_4_9_DATA___3 = 139,
	GP_4_10_DATA___3 = 140,
	GP_4_11_DATA___3 = 141,
	GP_4_12_DATA___3 = 142,
	GP_4_13_DATA___3 = 143,
	GP_4_14_DATA___3 = 144,
	GP_4_15_DATA___3 = 145,
	GP_4_16_DATA___3 = 146,
	GP_4_17_DATA___3 = 147,
	GP_4_18_DATA___3 = 148,
	GP_4_19_DATA___3 = 149,
	GP_4_20_DATA___3 = 150,
	GP_4_21_DATA___3 = 151,
	GP_4_22_DATA___3 = 152,
	GP_4_23_DATA___3 = 153,
	GP_4_24_DATA___3 = 154,
	GP_4_25_DATA___3 = 155,
	GP_4_26_DATA___3 = 156,
	GP_4_27_DATA___3 = 157,
	GP_4_28_DATA___3 = 158,
	GP_4_29_DATA___3 = 159,
	GP_4_30_DATA___3 = 160,
	GP_4_31_DATA___3 = 161,
	GP_5_0_DATA___3 = 162,
	GP_5_1_DATA___3 = 163,
	GP_5_2_DATA___3 = 164,
	GP_5_3_DATA___3 = 165,
	GP_5_4_DATA___3 = 166,
	GP_5_5_DATA___3 = 167,
	GP_5_6_DATA___3 = 168,
	GP_5_7_DATA___3 = 169,
	GP_5_8_DATA___3 = 170,
	GP_5_9_DATA___3 = 171,
	GP_5_10_DATA___3 = 172,
	GP_5_11_DATA___3 = 173,
	GP_5_12_DATA___3 = 174,
	GP_5_13_DATA___3 = 175,
	GP_5_14_DATA___3 = 176,
	GP_5_15_DATA___3 = 177,
	GP_5_16_DATA___3 = 178,
	GP_5_17_DATA___3 = 179,
	GP_5_18_DATA___3 = 180,
	GP_5_19_DATA___3 = 181,
	GP_5_20_DATA___3 = 182,
	GP_5_21_DATA___3 = 183,
	GP_5_22_DATA___3 = 184,
	GP_5_23_DATA___3 = 185,
	GP_5_24_DATA___3 = 186,
	GP_5_25_DATA___3 = 187,
	GP_5_26_DATA___3 = 188,
	GP_5_27_DATA___3 = 189,
	GP_5_28_DATA___2 = 190,
	GP_5_29_DATA___2 = 191,
	GP_5_30_DATA___2 = 192,
	GP_5_31_DATA___2 = 193,
	GP_6_0_DATA___3 = 194,
	GP_6_1_DATA___3 = 195,
	GP_6_2_DATA___3 = 196,
	GP_6_3_DATA___3 = 197,
	GP_6_4_DATA___3 = 198,
	GP_6_5_DATA___3 = 199,
	GP_6_6_DATA___3 = 200,
	GP_6_7_DATA___3 = 201,
	GP_6_8_DATA___3 = 202,
	PINMUX_DATA_END___4 = 203,
	PINMUX_FUNCTION_BEGIN___4 = 204,
	GP_0_0_FN___3 = 205,
	GP_0_1_FN___3 = 206,
	GP_0_2_FN___3 = 207,
	GP_0_3_FN___3 = 208,
	GP_0_4_FN___3 = 209,
	GP_0_5_FN___3 = 210,
	GP_0_6_FN___3 = 211,
	GP_0_7_FN___3 = 212,
	GP_0_8_FN___3 = 213,
	GP_0_9_FN___3 = 214,
	GP_0_10_FN___3 = 215,
	GP_0_11_FN___3 = 216,
	GP_0_12_FN___3 = 217,
	GP_0_13_FN___3 = 218,
	GP_0_14_FN___3 = 219,
	GP_0_15_FN___3 = 220,
	GP_0_16_FN___3 = 221,
	GP_0_17_FN___3 = 222,
	GP_0_18_FN___3 = 223,
	GP_0_19_FN___3 = 224,
	GP_0_20_FN___3 = 225,
	GP_0_21_FN___3 = 226,
	GP_0_22_FN___3 = 227,
	GP_0_23_FN___3 = 228,
	GP_0_24_FN___3 = 229,
	GP_0_25_FN___3 = 230,
	GP_0_26_FN___3 = 231,
	GP_0_27_FN___3 = 232,
	GP_0_28_FN___3 = 233,
	GP_0_29_FN___3 = 234,
	GP_0_30_FN___3 = 235,
	GP_0_31_FN___3 = 236,
	GP_1_0_FN___3 = 237,
	GP_1_1_FN___3 = 238,
	GP_1_2_FN___3 = 239,
	GP_1_3_FN___3 = 240,
	GP_1_4_FN___3 = 241,
	GP_1_5_FN___3 = 242,
	GP_1_6_FN___3 = 243,
	GP_1_7_FN___3 = 244,
	GP_1_8_FN___3 = 245,
	GP_1_9_FN___3 = 246,
	GP_1_10_FN___3 = 247,
	GP_1_11_FN___3 = 248,
	GP_1_12_FN___3 = 249,
	GP_1_13_FN___3 = 250,
	GP_1_14_FN___3 = 251,
	GP_1_15_FN___3 = 252,
	GP_1_16_FN___3 = 253,
	GP_1_17_FN___3 = 254,
	GP_1_18_FN___3 = 255,
	GP_1_19_FN___3 = 256,
	GP_1_20_FN___3 = 257,
	GP_1_21_FN___3 = 258,
	GP_1_22_FN___3 = 259,
	GP_1_23_FN___3 = 260,
	GP_1_24_FN___3 = 261,
	GP_1_25_FN___3 = 262,
	GP_1_26_FN = 263,
	GP_1_27_FN = 264,
	GP_1_28_FN = 265,
	GP_1_29_FN = 266,
	GP_1_30_FN = 267,
	GP_1_31_FN = 268,
	GP_2_0_FN___3 = 269,
	GP_2_1_FN___3 = 270,
	GP_2_2_FN___3 = 271,
	GP_2_3_FN___3 = 272,
	GP_2_4_FN___3 = 273,
	GP_2_5_FN___3 = 274,
	GP_2_6_FN___3 = 275,
	GP_2_7_FN___3 = 276,
	GP_2_8_FN___3 = 277,
	GP_2_9_FN___3 = 278,
	GP_2_10_FN___3 = 279,
	GP_2_11_FN___3 = 280,
	GP_2_12_FN___3 = 281,
	GP_2_13_FN___3 = 282,
	GP_2_14_FN___3 = 283,
	GP_2_15_FN___3 = 284,
	GP_2_16_FN___3 = 285,
	GP_2_17_FN___3 = 286,
	GP_2_18_FN___3 = 287,
	GP_2_19_FN___3 = 288,
	GP_2_20_FN___3 = 289,
	GP_2_21_FN___3 = 290,
	GP_2_22_FN___3 = 291,
	GP_2_23_FN___3 = 292,
	GP_2_24_FN___3 = 293,
	GP_2_25_FN___3 = 294,
	GP_2_26_FN___3 = 295,
	GP_2_27_FN___3 = 296,
	GP_2_28_FN___3 = 297,
	GP_2_29_FN___3 = 298,
	GP_2_30_FN___3 = 299,
	GP_2_31_FN___3 = 300,
	GP_3_0_FN___3 = 301,
	GP_3_1_FN___3 = 302,
	GP_3_2_FN___3 = 303,
	GP_3_3_FN___3 = 304,
	GP_3_4_FN___3 = 305,
	GP_3_5_FN___3 = 306,
	GP_3_6_FN___3 = 307,
	GP_3_7_FN___3 = 308,
	GP_3_8_FN___3 = 309,
	GP_3_9_FN___3 = 310,
	GP_3_10_FN___3 = 311,
	GP_3_11_FN___3 = 312,
	GP_3_12_FN___3 = 313,
	GP_3_13_FN___3 = 314,
	GP_3_14_FN___3 = 315,
	GP_3_15_FN___3 = 316,
	GP_3_16_FN___3 = 317,
	GP_3_17_FN___3 = 318,
	GP_3_18_FN___3 = 319,
	GP_3_19_FN___3 = 320,
	GP_3_20_FN___3 = 321,
	GP_3_21_FN___3 = 322,
	GP_3_22_FN___3 = 323,
	GP_3_23_FN___3 = 324,
	GP_3_24_FN___3 = 325,
	GP_3_25_FN___3 = 326,
	GP_3_26_FN___3 = 327,
	GP_3_27_FN___3 = 328,
	GP_3_28_FN___3 = 329,
	GP_3_29_FN___3 = 330,
	GP_3_30_FN___3 = 331,
	GP_3_31_FN___3 = 332,
	GP_4_0_FN___3 = 333,
	GP_4_1_FN___3 = 334,
	GP_4_2_FN___3 = 335,
	GP_4_3_FN___3 = 336,
	GP_4_4_FN___3 = 337,
	GP_4_5_FN___3 = 338,
	GP_4_6_FN___3 = 339,
	GP_4_7_FN___3 = 340,
	GP_4_8_FN___3 = 341,
	GP_4_9_FN___3 = 342,
	GP_4_10_FN___3 = 343,
	GP_4_11_FN___3 = 344,
	GP_4_12_FN___3 = 345,
	GP_4_13_FN___3 = 346,
	GP_4_14_FN___3 = 347,
	GP_4_15_FN___3 = 348,
	GP_4_16_FN___3 = 349,
	GP_4_17_FN___3 = 350,
	GP_4_18_FN___3 = 351,
	GP_4_19_FN___3 = 352,
	GP_4_20_FN___3 = 353,
	GP_4_21_FN___3 = 354,
	GP_4_22_FN___3 = 355,
	GP_4_23_FN___3 = 356,
	GP_4_24_FN___3 = 357,
	GP_4_25_FN___3 = 358,
	GP_4_26_FN___3 = 359,
	GP_4_27_FN___3 = 360,
	GP_4_28_FN___3 = 361,
	GP_4_29_FN___3 = 362,
	GP_4_30_FN___3 = 363,
	GP_4_31_FN___3 = 364,
	GP_5_0_FN___3 = 365,
	GP_5_1_FN___3 = 366,
	GP_5_2_FN___3 = 367,
	GP_5_3_FN___3 = 368,
	GP_5_4_FN___3 = 369,
	GP_5_5_FN___3 = 370,
	GP_5_6_FN___3 = 371,
	GP_5_7_FN___3 = 372,
	GP_5_8_FN___3 = 373,
	GP_5_9_FN___3 = 374,
	GP_5_10_FN___3 = 375,
	GP_5_11_FN___3 = 376,
	GP_5_12_FN___3 = 377,
	GP_5_13_FN___3 = 378,
	GP_5_14_FN___3 = 379,
	GP_5_15_FN___3 = 380,
	GP_5_16_FN___3 = 381,
	GP_5_17_FN___3 = 382,
	GP_5_18_FN___3 = 383,
	GP_5_19_FN___3 = 384,
	GP_5_20_FN___3 = 385,
	GP_5_21_FN___3 = 386,
	GP_5_22_FN___3 = 387,
	GP_5_23_FN___3 = 388,
	GP_5_24_FN___3 = 389,
	GP_5_25_FN___3 = 390,
	GP_5_26_FN___3 = 391,
	GP_5_27_FN___3 = 392,
	GP_5_28_FN___2 = 393,
	GP_5_29_FN___2 = 394,
	GP_5_30_FN___2 = 395,
	GP_5_31_FN___2 = 396,
	GP_6_0_FN___3 = 397,
	GP_6_1_FN___3 = 398,
	GP_6_2_FN___3 = 399,
	GP_6_3_FN___3 = 400,
	GP_6_4_FN___3 = 401,
	GP_6_5_FN___3 = 402,
	GP_6_6_FN___3 = 403,
	GP_6_7_FN___3 = 404,
	GP_6_8_FN___3 = 405,
	FN_AVS1 = 406,
	FN_AVS2 = 407,
	FN_IP0_7_6 = 408,
	FN_A17___3 = 409,
	FN_A18___3 = 410,
	FN_A19___3 = 411,
	FN_IP0_9_8___2 = 412,
	FN_IP0_11_10 = 413,
	FN_IP0_13_12 = 414,
	FN_IP0_15_14 = 415,
	FN_IP0_18_16___2 = 416,
	FN_IP0_22_19 = 417,
	FN_IP0_24_23___2 = 418,
	FN_IP0_25___2 = 419,
	FN_IP0_27_26___2 = 420,
	FN_IP1_1_0___3 = 421,
	FN_IP1_3_2___3 = 422,
	FN_IP1_6_4 = 423,
	FN_IP1_10_7 = 424,
	FN_IP1_14_11 = 425,
	FN_IP1_18_15 = 426,
	FN_IP0_5_3 = 427,
	FN_IP0_30_28 = 428,
	FN_IP2_18_16___2 = 429,
	FN_IP2_21_19 = 430,
	FN_IP2_30_28 = 431,
	FN_IP3_2_0___2 = 432,
	FN_IP3_11_9___2 = 433,
	FN_IP3_14_12 = 434,
	FN_IP3_22_21 = 435,
	FN_IP3_26_24___2 = 436,
	FN_IP3_31_29 = 437,
	FN_IP4_1_0___3 = 438,
	FN_IP4_4_2___3 = 439,
	FN_IP4_7_5___3 = 440,
	FN_IP4_10_8 = 441,
	FN_IP4_11 = 442,
	FN_IP4_12 = 443,
	FN_IP4_13 = 444,
	FN_IP4_14 = 445,
	FN_IP4_15 = 446,
	FN_IP4_16 = 447,
	FN_IP4_19_17 = 448,
	FN_IP4_22_20___2 = 449,
	FN_IP4_23 = 450,
	FN_IP4_24 = 451,
	FN_IP4_25 = 452,
	FN_IP4_26 = 453,
	FN_IP4_27 = 454,
	FN_IP4_28 = 455,
	FN_IP4_31_29 = 456,
	FN_IP5_2_0___2 = 457,
	FN_IP5_3 = 458,
	FN_IP5_4 = 459,
	FN_IP5_5 = 460,
	FN_IP5_6 = 461,
	FN_IP5_7 = 462,
	FN_IP5_8 = 463,
	FN_IP5_10_9 = 464,
	FN_IP5_12_11 = 465,
	FN_IP5_14_13 = 466,
	FN_IP5_16_15___2 = 467,
	FN_IP5_20_17 = 468,
	FN_IP5_23_21 = 469,
	FN_IP5_27_24 = 470,
	FN_IP8_20 = 471,
	FN_IP8_22_21 = 472,
	FN_IP8_24_23 = 473,
	FN_IP8_27_25 = 474,
	FN_IP8_30_28___2 = 475,
	FN_IP9_1_0 = 476,
	FN_IP9_3_2 = 477,
	FN_IP9_4 = 478,
	FN_IP9_5 = 479,
	FN_IP9_6___2 = 480,
	FN_IP9_7___2 = 481,
	FN_IP9_9_8 = 482,
	FN_IP9_11_10 = 483,
	FN_IP9_13_12 = 484,
	FN_IP9_15_14 = 485,
	FN_IP9_18_16 = 486,
	FN_IP9_21_19___2 = 487,
	FN_IP9_23_22 = 488,
	FN_IP9_25_24 = 489,
	FN_IP9_27_26 = 490,
	FN_IP9_29_28 = 491,
	FN_IP10_2_0___3 = 492,
	FN_IP10_5_3___3 = 493,
	FN_IP10_8_6___3 = 494,
	FN_IP10_11_9___3 = 495,
	FN_IP10_14_12___3 = 496,
	FN_IP10_17_15___2 = 497,
	FN_IP10_20_18___2 = 498,
	FN_IP10_23_21___2 = 499,
	FN_IP10_25_24 = 500,
	FN_IP10_28_26 = 501,
	FN_IP10_31_29___2 = 502,
	FN_IP11_2_0___3 = 503,
	FN_IP11_5_3___3 = 504,
	FN_IP11_8_6___2 = 505,
	FN_IP11_11_9___2 = 506,
	FN_IP11_14_12___2 = 507,
	FN_IP11_17_15 = 508,
	FN_IP11_20_18___2 = 509,
	FN_IP11_23_21___2 = 510,
	FN_IP11_26_24___2 = 511,
	FN_IP11_29_27___2 = 512,
	FN_IP12_2_0___2 = 513,
	FN_IP12_5_3___2 = 514,
	FN_IP12_8_6___2 = 515,
	FN_IP12_11_9 = 516,
	FN_IP12_14_12 = 517,
	FN_IP12_17_15___2 = 518,
	FN_IP7_16_15___2 = 519,
	FN_IP7_18_17___2 = 520,
	FN_IP7_28_27 = 521,
	FN_IP7_30_29 = 522,
	FN_IP7_20_19___2 = 523,
	FN_IP7_22_21 = 524,
	FN_IP7_24_23 = 525,
	FN_IP7_26_25 = 526,
	FN_IP1_20_19 = 527,
	FN_IP1_22_21 = 528,
	FN_IP1_24_23 = 529,
	FN_IP5_28 = 530,
	FN_IP5_30_29 = 531,
	FN_IP6_1_0___2 = 532,
	FN_IP6_3_2___2 = 533,
	FN_IP6_5_4___2 = 534,
	FN_IP6_7_6___3 = 535,
	FN_IP6_8___2 = 536,
	FN_IP6_11_9 = 537,
	FN_IP6_14_12 = 538,
	FN_IP6_17_15 = 539,
	FN_IP6_19_18 = 540,
	FN_IP6_22_20___2 = 541,
	FN_IP6_24_23 = 542,
	FN_IP6_26_25 = 543,
	FN_IP6_30_29 = 544,
	FN_IP7_1_0 = 545,
	FN_IP7_3_2 = 546,
	FN_IP7_6_4 = 547,
	FN_IP7_9_7 = 548,
	FN_IP7_12_10 = 549,
	FN_IP7_14_13___2 = 550,
	FN_IP2_7_4 = 551,
	FN_IP2_11_8 = 552,
	FN_IP2_15_12 = 553,
	FN_IP1_28_25 = 554,
	FN_IP2_3_0 = 555,
	FN_IP8_3_0 = 556,
	FN_IP8_7_4 = 557,
	FN_IP8_11_8 = 558,
	FN_IP8_15_12 = 559,
	FN_USB_PENC0 = 560,
	FN_USB_PENC1 = 561,
	FN_IP0_2_0 = 562,
	FN_IP8_17_16 = 563,
	FN_IP8_18 = 564,
	FN_IP8_19 = 565,
	FN_A1___3 = 566,
	FN_A2___3 = 567,
	FN_A3___3 = 568,
	FN_A4___3 = 569,
	FN_A5___3 = 570,
	FN_A6___3 = 571,
	FN_A7___3 = 572,
	FN_A8___3 = 573,
	FN_A9___3 = 574,
	FN_A10___3 = 575,
	FN_A11___3 = 576,
	FN_A12___3 = 577,
	FN_A13___3 = 578,
	FN_A14___3 = 579,
	FN_A15___3 = 580,
	FN_A16___3 = 581,
	FN_RD = 582,
	FN_WE0 = 583,
	FN_WE1 = 584,
	FN_EX_WAIT0___3 = 585,
	FN_IP3_23 = 586,
	FN_IP3_27 = 587,
	FN_IP3_28 = 588,
	FN_IP2_22 = 589,
	FN_IP2_23 = 590,
	FN_IP2_24 = 591,
	FN_IP2_25 = 592,
	FN_IP2_26 = 593,
	FN_IP2_27 = 594,
	FN_IP3_3 = 595,
	FN_IP3_4 = 596,
	FN_IP3_5 = 597,
	FN_IP3_6 = 598,
	FN_IP3_7 = 599,
	FN_IP3_8 = 600,
	FN_IP3_15 = 601,
	FN_IP3_16 = 602,
	FN_IP3_17 = 603,
	FN_IP3_18 = 604,
	FN_IP3_19 = 605,
	FN_IP3_20 = 606,
	FN_RD_WR = 607,
	FN_FWE = 608,
	FN_ATAG0 = 609,
	FN_VI1_R7 = 610,
	FN_HRTS1 = 611,
	FN_RX4_C___2 = 612,
	FN_CS1_A26 = 613,
	FN_HSPI_TX2 = 614,
	FN_SDSELF_B = 615,
	FN_CS0 = 616,
	FN_HSPI_CS2_B = 617,
	FN_CLKOUT = 618,
	FN_TX3C_IRDA_TX_C = 619,
	FN_PWM0_B___3 = 620,
	FN_A25___3 = 621,
	FN_SD1_WP___3 = 622,
	FN_MMC0_D5 = 623,
	FN_FD5 = 624,
	FN_HSPI_RX2 = 625,
	FN_VI1_R3 = 626,
	FN_TX5_B___2 = 627,
	FN_SSI_SDATA7_B___3 = 628,
	FN_CTS0_B = 629,
	FN_A24___3 = 630,
	FN_SD1_CD___3 = 631,
	FN_MMC0_D4 = 632,
	FN_FD4 = 633,
	FN_HSPI_CS2 = 634,
	FN_VI1_R2 = 635,
	FN_SSI_WS78_B___3 = 636,
	FN_A23___3 = 637,
	FN_FCLE = 638,
	FN_HSPI_CLK2 = 639,
	FN_VI1_R1 = 640,
	FN_A22___3 = 641,
	FN_RX5_D = 642,
	FN_HSPI_RX2_B = 643,
	FN_VI1_R0 = 644,
	FN_A21___3 = 645,
	FN_SCK5_D = 646,
	FN_HSPI_CLK2_B = 647,
	FN_A20___3 = 648,
	FN_TX5_D = 649,
	FN_HSPI_TX2_B = 650,
	FN_A0___3 = 651,
	FN_SD1_DAT3 = 652,
	FN_MMC0_D3 = 653,
	FN_FD3 = 654,
	FN_BS = 655,
	FN_SD1_DAT2 = 656,
	FN_MMC0_D2 = 657,
	FN_FD2 = 658,
	FN_ATADIR0 = 659,
	FN_SDSELF = 660,
	FN_HCTS1 = 661,
	FN_TX4_C___2 = 662,
	FN_USB_PENC2 = 663,
	FN_SCK0 = 664,
	FN_PWM1___3 = 665,
	FN_PWMFSW0 = 666,
	FN_SCIF_CLK___3 = 667,
	FN_TCLK0_C = 668,
	FN_EX_CS0 = 669,
	FN_RX3_C_IRDA_RX_C = 670,
	FN_MMC0_D6 = 671,
	FN_FD6 = 672,
	FN_EX_CS1 = 673,
	FN_MMC0_D7 = 674,
	FN_FD7 = 675,
	FN_EX_CS2 = 676,
	FN_SD1_CLK___3 = 677,
	FN_MMC0_CLK = 678,
	FN_FALE = 679,
	FN_ATACS00 = 680,
	FN_EX_CS3 = 681,
	FN_SD1_CMD___3 = 682,
	FN_MMC0_CMD = 683,
	FN_FRE = 684,
	FN_ATACS10 = 685,
	FN_VI1_R4 = 686,
	FN_RX5_B___2 = 687,
	FN_HSCK1___2 = 688,
	FN_SSI_SDATA8_B___3 = 689,
	FN_RTS0_B_TANS_B = 690,
	FN_SSI_SDATA9___3 = 691,
	FN_EX_CS4 = 692,
	FN_SD1_DAT0 = 693,
	FN_MMC0_D0 = 694,
	FN_FD0 = 695,
	FN_ATARD0 = 696,
	FN_VI1_R5 = 697,
	FN_SCK5_B = 698,
	FN_HTX1___2 = 699,
	FN_TX2_E___2 = 700,
	FN_TX0_B___2 = 701,
	FN_SSI_SCK9___3 = 702,
	FN_EX_CS5 = 703,
	FN_SD1_DAT1 = 704,
	FN_MMC0_D1 = 705,
	FN_FD1 = 706,
	FN_ATAWR0 = 707,
	FN_VI1_R6 = 708,
	FN_HRX1___2 = 709,
	FN_RX2_E___2 = 710,
	FN_RX0_B___2 = 711,
	FN_SSI_WS9___3 = 712,
	FN_MLB_CLK___3 = 713,
	FN_PWM2___3 = 714,
	FN_SCK4 = 715,
	FN_MLB_SIG___3 = 716,
	FN_PWM3___3 = 717,
	FN_TX4___2 = 718,
	FN_MLB_DAT___3 = 719,
	FN_PWM4___3 = 720,
	FN_RX4___2 = 721,
	FN_HTX0___2 = 722,
	FN_TX1___2 = 723,
	FN_SDATA = 724,
	FN_CTS0_C = 725,
	FN_SUB_TCK = 726,
	FN_CC5_STATE2 = 727,
	FN_CC5_STATE10 = 728,
	FN_CC5_STATE18 = 729,
	FN_CC5_STATE26 = 730,
	FN_CC5_STATE34 = 731,
	FN_HRX0___2 = 732,
	FN_RX1___2 = 733,
	FN_SCKZ = 734,
	FN_RTS0_C_TANS_C = 735,
	FN_SUB_TDI = 736,
	FN_CC5_STATE3 = 737,
	FN_CC5_STATE11 = 738,
	FN_CC5_STATE19 = 739,
	FN_CC5_STATE27 = 740,
	FN_CC5_STATE35 = 741,
	FN_HSCK0___2 = 742,
	FN_SCK1 = 743,
	FN_MTS = 744,
	FN_PWM5___3 = 745,
	FN_SCK0_C = 746,
	FN_SSI_SDATA9_B___3 = 747,
	FN_SUB_TDO = 748,
	FN_CC5_STATE0 = 749,
	FN_CC5_STATE8 = 750,
	FN_CC5_STATE16 = 751,
	FN_CC5_STATE24 = 752,
	FN_CC5_STATE32 = 753,
	FN_HCTS0 = 754,
	FN_CTS1 = 755,
	FN_STM = 756,
	FN_PWM0_D = 757,
	FN_RX0_C___2 = 758,
	FN_SCIF_CLK_C = 759,
	FN_SUB_TRST = 760,
	FN_TCLK1_B___3 = 761,
	FN_CC5_OSCOUT = 762,
	FN_HRTS0 = 763,
	FN_RTS1_TANS = 764,
	FN_MDATA = 765,
	FN_TX0_C___2 = 766,
	FN_SUB_TMS = 767,
	FN_CC5_STATE1 = 768,
	FN_CC5_STATE9 = 769,
	FN_CC5_STATE17 = 770,
	FN_CC5_STATE25 = 771,
	FN_CC5_STATE33 = 772,
	FN_DU0_DR0___2 = 773,
	FN_LCDOUT0___3 = 774,
	FN_DREQ0___2 = 775,
	FN_GPS_CLK_B___2 = 776,
	FN_AUDATA0 = 777,
	FN_TX5_C = 778,
	FN_DU0_DR1___2 = 779,
	FN_LCDOUT1___3 = 780,
	FN_DACK0___3 = 781,
	FN_DRACK0___3 = 782,
	FN_GPS_SIGN_B___2 = 783,
	FN_AUDATA1 = 784,
	FN_RX5_C = 785,
	FN_DU0_DR2___2 = 786,
	FN_LCDOUT2___3 = 787,
	FN_DU0_DR3___2 = 788,
	FN_LCDOUT3___3 = 789,
	FN_DU0_DR4___2 = 790,
	FN_LCDOUT4___3 = 791,
	FN_DU0_DR5___2 = 792,
	FN_LCDOUT5___3 = 793,
	FN_DU0_DR6___2 = 794,
	FN_LCDOUT6___3 = 795,
	FN_DU0_DR7___2 = 796,
	FN_LCDOUT7___3 = 797,
	FN_DU0_DG0___2 = 798,
	FN_LCDOUT8___3 = 799,
	FN_DREQ1___2 = 800,
	FN_SCL2 = 801,
	FN_AUDATA2 = 802,
	FN_DU0_DG1___2 = 803,
	FN_LCDOUT9___3 = 804,
	FN_DACK1___3 = 805,
	FN_SDA2 = 806,
	FN_AUDATA3 = 807,
	FN_DU0_DG2___2 = 808,
	FN_LCDOUT10___3 = 809,
	FN_DU0_DG3___2 = 810,
	FN_LCDOUT11___3 = 811,
	FN_DU0_DG4___2 = 812,
	FN_LCDOUT12___3 = 813,
	FN_DU0_DG5___2 = 814,
	FN_LCDOUT13___3 = 815,
	FN_DU0_DG6___2 = 816,
	FN_LCDOUT14___3 = 817,
	FN_DU0_DG7___2 = 818,
	FN_LCDOUT15___3 = 819,
	FN_DU0_DB0___2 = 820,
	FN_LCDOUT16___3 = 821,
	FN_EX_WAIT1___3 = 822,
	FN_SCL1 = 823,
	FN_TCLK1___3 = 824,
	FN_AUDATA4 = 825,
	FN_DU0_DB1___2 = 826,
	FN_LCDOUT17___3 = 827,
	FN_EX_WAIT2___3 = 828,
	FN_SDA1 = 829,
	FN_GPS_MAG_B___2 = 830,
	FN_AUDATA5 = 831,
	FN_SCK5_C = 832,
	FN_DU0_DB2___2 = 833,
	FN_LCDOUT18___3 = 834,
	FN_DU0_DB3___2 = 835,
	FN_LCDOUT19___3 = 836,
	FN_DU0_DB4___2 = 837,
	FN_LCDOUT20___3 = 838,
	FN_DU0_DB5___2 = 839,
	FN_LCDOUT21___3 = 840,
	FN_DU0_DB6___2 = 841,
	FN_LCDOUT22___3 = 842,
	FN_DU0_DB7___2 = 843,
	FN_LCDOUT23___3 = 844,
	FN_DU0_DOTCLKIN___3 = 845,
	FN_QSTVA_QVS___3 = 846,
	FN_TX3_D_IRDA_TX_D = 847,
	FN_SCL3_B = 848,
	FN_DU0_DOTCLKOUT0___2 = 849,
	FN_QCLK___3 = 850,
	FN_DU0_DOTCLKOUT1___2 = 851,
	FN_QSTVB_QVE___3 = 852,
	FN_RX3_D_IRDA_RX_D = 853,
	FN_SDA3_B = 854,
	FN_SDA2_C = 855,
	FN_DACK0_B = 856,
	FN_DRACK0_B = 857,
	FN_DU0_EXHSYNC_DU0_HSYNC___2 = 858,
	FN_QSTH_QHS___3 = 859,
	FN_DU0_EXVSYNC_DU0_VSYNC___2 = 860,
	FN_QSTB_QHE___3 = 861,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE___2 = 862,
	FN_QCPV_QDE___3 = 863,
	FN_CAN1_TX___3 = 864,
	FN_TX2_C___2 = 865,
	FN_SCL2_C = 866,
	FN_REMOCON___3 = 867,
	FN_DU0_DISP___2 = 868,
	FN_QPOLA___3 = 869,
	FN_CAN_CLK_C___3 = 870,
	FN_SCK2_C = 871,
	FN_DU0_CDE___2 = 872,
	FN_QPOLB___3 = 873,
	FN_CAN1_RX___3 = 874,
	FN_RX2_C___2 = 875,
	FN_DREQ0_B = 876,
	FN_SSI_SCK78_B___3 = 877,
	FN_SCK0_B = 878,
	FN_DU1_DR0___3 = 879,
	FN_VI2_DATA0_VI2_B0 = 880,
	FN_PWM6___3 = 881,
	FN_SD3_CLK = 882,
	FN_TX3_E_IRDA_TX_E = 883,
	FN_AUDCK = 884,
	FN_PWMFSW0_B = 885,
	FN_DU1_DR1___3 = 886,
	FN_VI2_DATA1_VI2_B1 = 887,
	FN_PWM0___3 = 888,
	FN_SD3_CMD = 889,
	FN_RX3_E_IRDA_RX_E = 890,
	FN_AUDSYNC = 891,
	FN_CTS0_D = 892,
	FN_DU1_DR2___3 = 893,
	FN_VI2_G0 = 894,
	FN_DU1_DR3___3 = 895,
	FN_VI2_G1 = 896,
	FN_DU1_DR4___3 = 897,
	FN_VI2_G2 = 898,
	FN_DU1_DR5___3 = 899,
	FN_VI2_G3 = 900,
	FN_DU1_DR6___3 = 901,
	FN_VI2_G4 = 902,
	FN_DU1_DR7___3 = 903,
	FN_VI2_G5 = 904,
	FN_DU1_DG0___3 = 905,
	FN_VI2_DATA2_VI2_B2 = 906,
	FN_SCL1_B = 907,
	FN_SD3_DAT2 = 908,
	FN_SCK3_E = 909,
	FN_AUDATA6 = 910,
	FN_TX0_D___2 = 911,
	FN_DU1_DG1___3 = 912,
	FN_VI2_DATA3_VI2_B3 = 913,
	FN_SDA1_B = 914,
	FN_SD3_DAT3 = 915,
	FN_SCK5 = 916,
	FN_AUDATA7 = 917,
	FN_RX0_D___2 = 918,
	FN_DU1_DG2___3 = 919,
	FN_VI2_G6 = 920,
	FN_DU1_DG3___3 = 921,
	FN_VI2_G7 = 922,
	FN_DU1_DG4___3 = 923,
	FN_VI2_R0 = 924,
	FN_DU1_DG5___3 = 925,
	FN_VI2_R1 = 926,
	FN_DU1_DG6___3 = 927,
	FN_VI2_R2 = 928,
	FN_DU1_DG7___3 = 929,
	FN_VI2_R3 = 930,
	FN_DU1_DB0___3 = 931,
	FN_VI2_DATA4_VI2_B4 = 932,
	FN_SCL2_B = 933,
	FN_SD3_DAT0 = 934,
	FN_TX5___2 = 935,
	FN_SCK0_D = 936,
	FN_DU1_DB1___3 = 937,
	FN_VI2_DATA5_VI2_B5 = 938,
	FN_SDA2_B = 939,
	FN_SD3_DAT1 = 940,
	FN_RX5___2 = 941,
	FN_RTS0_D_TANS_D = 942,
	FN_DU1_DB2___3 = 943,
	FN_VI2_R4 = 944,
	FN_DU1_DB3___3 = 945,
	FN_VI2_R5 = 946,
	FN_DU1_DB4___3 = 947,
	FN_VI2_R6 = 948,
	FN_DU1_DB5___3 = 949,
	FN_VI2_R7 = 950,
	FN_DU1_DB6___3 = 951,
	FN_SCL2_D = 952,
	FN_DU1_DB7___3 = 953,
	FN_SDA2_D = 954,
	FN_DU1_DOTCLKIN___3 = 955,
	FN_VI2_CLKENB___2 = 956,
	FN_HSPI_CS1 = 957,
	FN_SCL1_D = 958,
	FN_DU1_DOTCLKOUT = 959,
	FN_VI2_FIELD___2 = 960,
	FN_SDA1_D = 961,
	FN_DU1_EXHSYNC_DU1_HSYNC___3 = 962,
	FN_VI2_HSYNC = 963,
	FN_VI3_HSYNC = 964,
	FN_DU1_EXVSYNC_DU1_VSYNC___3 = 965,
	FN_VI2_VSYNC = 966,
	FN_VI3_VSYNC = 967,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE___3 = 968,
	FN_VI2_CLK___2 = 969,
	FN_TX3_B_IRDA_TX_B = 970,
	FN_SD3_CD = 971,
	FN_HSPI_TX1 = 972,
	FN_VI1_CLKENB___3 = 973,
	FN_VI3_CLKENB = 974,
	FN_AUDIO_CLKC___3 = 975,
	FN_TX2_D = 976,
	FN_SPEEDIN___3 = 977,
	FN_GPS_SIGN_D___2 = 978,
	FN_DU1_DISP___3 = 979,
	FN_VI2_DATA6_VI2_B6 = 980,
	FN_TCLK0 = 981,
	FN_QSTVA_B_QVS_B = 982,
	FN_HSPI_CLK1 = 983,
	FN_SCK2_D = 984,
	FN_AUDIO_CLKOUT_B___2 = 985,
	FN_GPS_MAG_D___2 = 986,
	FN_DU1_CDE___3 = 987,
	FN_VI2_DATA7_VI2_B7 = 988,
	FN_RX3_B_IRDA_RX_B = 989,
	FN_SD3_WP = 990,
	FN_HSPI_RX1 = 991,
	FN_VI1_FIELD___3 = 992,
	FN_VI3_FIELD = 993,
	FN_AUDIO_CLKOUT___3 = 994,
	FN_RX2_D = 995,
	FN_GPS_CLK_C___2 = 996,
	FN_GPS_CLK_D___2 = 997,
	FN_AUDIO_CLKA___3 = 998,
	FN_CAN_TXCLK = 999,
	FN_AUDIO_CLKB___3 = 1000,
	FN_USB_OVC2 = 1001,
	FN_CAN_DEBUGOUT0 = 1002,
	FN_MOUT0 = 1003,
	FN_SSI_SCK0129___3 = 1004,
	FN_CAN_DEBUGOUT1 = 1005,
	FN_MOUT1 = 1006,
	FN_SSI_WS0129___3 = 1007,
	FN_CAN_DEBUGOUT2 = 1008,
	FN_MOUT2 = 1009,
	FN_SSI_SDATA0___3 = 1010,
	FN_CAN_DEBUGOUT3 = 1011,
	FN_MOUT5 = 1012,
	FN_SSI_SDATA1___3 = 1013,
	FN_CAN_DEBUGOUT4 = 1014,
	FN_MOUT6 = 1015,
	FN_SSI_SDATA2___3 = 1016,
	FN_CAN_DEBUGOUT5 = 1017,
	FN_SSI_SCK34___3 = 1018,
	FN_CAN_DEBUGOUT6 = 1019,
	FN_CAN0_TX_B___3 = 1020,
	FN_IERX___3 = 1021,
	FN_SSI_SCK9_C = 1022,
	FN_SSI_WS34___3 = 1023,
	FN_CAN_DEBUGOUT7 = 1024,
	FN_CAN0_RX_B___3 = 1025,
	FN_IETX___3 = 1026,
	FN_SSI_WS9_C = 1027,
	FN_SSI_SDATA3___3 = 1028,
	FN_PWM0_C = 1029,
	FN_CAN_DEBUGOUT8 = 1030,
	FN_CAN_CLK_B___3 = 1031,
	FN_IECLK___3 = 1032,
	FN_SCIF_CLK_B___3 = 1033,
	FN_TCLK0_B = 1034,
	FN_SSI_SDATA4___3 = 1035,
	FN_CAN_DEBUGOUT9 = 1036,
	FN_SSI_SDATA9_C = 1037,
	FN_SSI_SCK5___3 = 1038,
	FN_ADICLK___3 = 1039,
	FN_CAN_DEBUGOUT10 = 1040,
	FN_SCK3 = 1041,
	FN_TCLK0_D = 1042,
	FN_SSI_WS5___3 = 1043,
	FN_ADICS_SAMP___3 = 1044,
	FN_CAN_DEBUGOUT11 = 1045,
	FN_TX3_IRDA_TX = 1046,
	FN_SSI_SDATA5___3 = 1047,
	FN_ADIDATA___3 = 1048,
	FN_CAN_DEBUGOUT12 = 1049,
	FN_RX3_IRDA_RX = 1050,
	FN_SSI_SCK6___3 = 1051,
	FN_ADICHS0___3 = 1052,
	FN_CAN0_TX___3 = 1053,
	FN_IERX_B___3 = 1054,
	FN_SSI_WS6___3 = 1055,
	FN_ADICHS1___3 = 1056,
	FN_CAN0_RX___3 = 1057,
	FN_IETX_B___3 = 1058,
	FN_SSI_SDATA6___3 = 1059,
	FN_ADICHS2___3 = 1060,
	FN_CAN_CLK___3 = 1061,
	FN_IECLK_B___3 = 1062,
	FN_SSI_SCK78___3 = 1063,
	FN_CAN_DEBUGOUT13 = 1064,
	FN_IRQ0_B = 1065,
	FN_SSI_SCK9_B___3 = 1066,
	FN_HSPI_CLK1_C = 1067,
	FN_SSI_WS78___3 = 1068,
	FN_CAN_DEBUGOUT14 = 1069,
	FN_IRQ1_B = 1070,
	FN_SSI_WS9_B___3 = 1071,
	FN_HSPI_CS1_C = 1072,
	FN_SSI_SDATA7___3 = 1073,
	FN_CAN_DEBUGOUT15 = 1074,
	FN_IRQ2_B = 1075,
	FN_TCLK1_C = 1076,
	FN_HSPI_TX1_C = 1077,
	FN_SSI_SDATA8___3 = 1078,
	FN_VSP = 1079,
	FN_IRQ3_B = 1080,
	FN_HSPI_RX1_C = 1081,
	FN_SD0_CLK___3 = 1082,
	FN_ATACS01 = 1083,
	FN_SCK1_B = 1084,
	FN_SD0_CMD___3 = 1085,
	FN_ATACS11 = 1086,
	FN_TX1_B___2 = 1087,
	FN_CC5_TDO = 1088,
	FN_SD0_DAT0 = 1089,
	FN_ATADIR1 = 1090,
	FN_RX1_B___2 = 1091,
	FN_CC5_TRST = 1092,
	FN_SD0_DAT1 = 1093,
	FN_ATAG1 = 1094,
	FN_SCK2_B = 1095,
	FN_CC5_TMS = 1096,
	FN_SD0_DAT2 = 1097,
	FN_ATARD1 = 1098,
	FN_TX2_B___2 = 1099,
	FN_CC5_TCK = 1100,
	FN_SD0_DAT3 = 1101,
	FN_ATAWR1 = 1102,
	FN_RX2_B___2 = 1103,
	FN_CC5_TDI = 1104,
	FN_SD0_CD___3 = 1105,
	FN_DREQ2___2 = 1106,
	FN_RTS1_B_TANS_B = 1107,
	FN_SD0_WP___3 = 1108,
	FN_DACK2___3 = 1109,
	FN_CTS1_B = 1110,
	FN_HSPI_CLK0 = 1111,
	FN_CTS0 = 1112,
	FN_USB_OVC0 = 1113,
	FN_AD_CLK = 1114,
	FN_CC5_STATE4 = 1115,
	FN_CC5_STATE12 = 1116,
	FN_CC5_STATE20 = 1117,
	FN_CC5_STATE28 = 1118,
	FN_CC5_STATE36 = 1119,
	FN_HSPI_CS0 = 1120,
	FN_RTS0_TANS = 1121,
	FN_USB_OVC1 = 1122,
	FN_AD_DI = 1123,
	FN_CC5_STATE5 = 1124,
	FN_CC5_STATE13 = 1125,
	FN_CC5_STATE21 = 1126,
	FN_CC5_STATE29 = 1127,
	FN_CC5_STATE37 = 1128,
	FN_HSPI_TX0 = 1129,
	FN_TX0___2 = 1130,
	FN_CAN_DEBUG_HW_TRIGGER = 1131,
	FN_AD_DO = 1132,
	FN_CC5_STATE6 = 1133,
	FN_CC5_STATE14 = 1134,
	FN_CC5_STATE22 = 1135,
	FN_CC5_STATE30 = 1136,
	FN_CC5_STATE38 = 1137,
	FN_HSPI_RX0 = 1138,
	FN_RX0___2 = 1139,
	FN_CAN_STEP0 = 1140,
	FN_AD_NCS = 1141,
	FN_CC5_STATE7 = 1142,
	FN_CC5_STATE15 = 1143,
	FN_CC5_STATE23 = 1144,
	FN_CC5_STATE31 = 1145,
	FN_CC5_STATE39 = 1146,
	FN_FMCLK___3 = 1147,
	FN_RDS_CLK = 1148,
	FN_PCMOE = 1149,
	FN_BPFCLK___3 = 1150,
	FN_PCMWE = 1151,
	FN_FMIN___3 = 1152,
	FN_RDS_DATA = 1153,
	FN_VI0_CLK___3 = 1154,
	FN_MMC1_CLK = 1155,
	FN_VI0_CLKENB___3 = 1156,
	FN_TX1_C___2 = 1157,
	FN_HTX1_B___2 = 1158,
	FN_MT1_SYNC = 1159,
	FN_VI0_FIELD___3 = 1160,
	FN_RX1_C___2 = 1161,
	FN_HRX1_B___2 = 1162,
	FN_VI0_HSYNC = 1163,
	FN_VI0_DATA0_B_VI0_B0_B = 1164,
	FN_CTS1_C = 1165,
	FN_TX4_D = 1166,
	FN_MMC1_CMD = 1167,
	FN_HSCK1_B = 1168,
	FN_VI0_VSYNC = 1169,
	FN_VI0_DATA1_B_VI0_B1_B = 1170,
	FN_RTS1_C_TANS_C = 1171,
	FN_RX4_D = 1172,
	FN_PWMFSW0_C = 1173,
	FN_VI0_DATA0_VI0_B0___3 = 1174,
	FN_HRTS1_B = 1175,
	FN_MT1_VCXO = 1176,
	FN_VI0_DATA1_VI0_B1___3 = 1177,
	FN_HCTS1_B = 1178,
	FN_MT1_PWM = 1179,
	FN_VI0_DATA2_VI0_B2___3 = 1180,
	FN_MMC1_D0 = 1181,
	FN_VI0_DATA3_VI0_B3___3 = 1182,
	FN_MMC1_D1 = 1183,
	FN_VI0_DATA4_VI0_B4___3 = 1184,
	FN_MMC1_D2 = 1185,
	FN_VI0_DATA5_VI0_B5___3 = 1186,
	FN_MMC1_D3 = 1187,
	FN_VI0_DATA6_VI0_B6___3 = 1188,
	FN_MMC1_D4 = 1189,
	FN_ARM_TRACEDATA_0 = 1190,
	FN_VI0_DATA7_VI0_B7___3 = 1191,
	FN_MMC1_D5 = 1192,
	FN_ARM_TRACEDATA_1 = 1193,
	FN_VI0_G0___3 = 1194,
	FN_SSI_SCK78_C = 1195,
	FN_IRQ0___3 = 1196,
	FN_ARM_TRACEDATA_2 = 1197,
	FN_VI0_G1___3 = 1198,
	FN_SSI_WS78_C = 1199,
	FN_IRQ1___3 = 1200,
	FN_ARM_TRACEDATA_3 = 1201,
	FN_VI0_G2___3 = 1202,
	FN_ETH_TXD1___3 = 1203,
	FN_MMC1_D6 = 1204,
	FN_ARM_TRACEDATA_4 = 1205,
	FN_TS_SPSYNC0___2 = 1206,
	FN_VI0_G3___3 = 1207,
	FN_ETH_CRS_DV___3 = 1208,
	FN_MMC1_D7 = 1209,
	FN_ARM_TRACEDATA_5 = 1210,
	FN_TS_SDAT0 = 1211,
	FN_VI0_G4___3 = 1212,
	FN_ETH_TX_EN___3 = 1213,
	FN_SD2_DAT0_B = 1214,
	FN_ARM_TRACEDATA_6 = 1215,
	FN_VI0_G5___3 = 1216,
	FN_ETH_RX_ER___3 = 1217,
	FN_SD2_DAT1_B = 1218,
	FN_ARM_TRACEDATA_7 = 1219,
	FN_VI0_G6___3 = 1220,
	FN_ETH_RXD0___3 = 1221,
	FN_SD2_DAT2_B = 1222,
	FN_ARM_TRACEDATA_8 = 1223,
	FN_VI0_G7___3 = 1224,
	FN_ETH_RXD1___3 = 1225,
	FN_SD2_DAT3_B = 1226,
	FN_ARM_TRACEDATA_9 = 1227,
	FN_VI0_R0___3 = 1228,
	FN_SSI_SDATA7_C = 1229,
	FN_SCK1_C = 1230,
	FN_DREQ1_B = 1231,
	FN_ARM_TRACEDATA_10 = 1232,
	FN_DREQ0_C = 1233,
	FN_VI0_R1___3 = 1234,
	FN_SSI_SDATA8_C = 1235,
	FN_DACK1_B___2 = 1236,
	FN_ARM_TRACEDATA_11 = 1237,
	FN_DACK0_C = 1238,
	FN_DRACK0_C = 1239,
	FN_VI0_R2___3 = 1240,
	FN_ETH_LINK___3 = 1241,
	FN_SD2_CLK_B = 1242,
	FN_IRQ2___3 = 1243,
	FN_ARM_TRACEDATA_12 = 1244,
	FN_VI0_R3___3 = 1245,
	FN_ETH_MAGIC___3 = 1246,
	FN_SD2_CMD_B = 1247,
	FN_IRQ3___3 = 1248,
	FN_ARM_TRACEDATA_13 = 1249,
	FN_VI0_R4___3 = 1250,
	FN_ETH_REFCLK___3 = 1251,
	FN_SD2_CD_B = 1252,
	FN_HSPI_CLK1_B = 1253,
	FN_ARM_TRACEDATA_14 = 1254,
	FN_MT1_CLK = 1255,
	FN_TS_SCK0___2 = 1256,
	FN_VI0_R5___3 = 1257,
	FN_ETH_TXD0___3 = 1258,
	FN_SD2_WP_B = 1259,
	FN_HSPI_CS1_B = 1260,
	FN_ARM_TRACEDATA_15 = 1261,
	FN_MT1_D = 1262,
	FN_TS_SDEN0___2 = 1263,
	FN_VI0_R6___3 = 1264,
	FN_ETH_MDC___3 = 1265,
	FN_DREQ2_C___2 = 1266,
	FN_HSPI_TX1_B = 1267,
	FN_TRACECLK = 1268,
	FN_MT1_BEN = 1269,
	FN_PWMFSW0_D = 1270,
	FN_VI0_R7___3 = 1271,
	FN_ETH_MDIO___3 = 1272,
	FN_DACK2_C = 1273,
	FN_HSPI_RX1_B = 1274,
	FN_SCIF_CLK_D = 1275,
	FN_TRACECTL = 1276,
	FN_MT1_PEN = 1277,
	FN_VI1_CLK___3 = 1278,
	FN_SIM_D = 1279,
	FN_SDA3 = 1280,
	FN_VI1_HSYNC = 1281,
	FN_VI3_CLK = 1282,
	FN_SSI_SCK4___3 = 1283,
	FN_GPS_SIGN_C___2 = 1284,
	FN_PWMFSW0_E = 1285,
	FN_VI1_VSYNC = 1286,
	FN_AUDIO_CLKOUT_C___2 = 1287,
	FN_SSI_WS4___3 = 1288,
	FN_SIM_CLK = 1289,
	FN_GPS_MAG_C___2 = 1290,
	FN_SPV_TRST = 1291,
	FN_SCL3 = 1292,
	FN_VI1_DATA0_VI1_B0 = 1293,
	FN_SD2_DAT0 = 1294,
	FN_SIM_RST = 1295,
	FN_SPV_TCK = 1296,
	FN_ADICLK_B___3 = 1297,
	FN_VI1_DATA1_VI1_B1 = 1298,
	FN_SD2_DAT1 = 1299,
	FN_MT0_CLK = 1300,
	FN_SPV_TMS = 1301,
	FN_ADICS_B_SAMP_B = 1302,
	FN_VI1_DATA2_VI1_B2 = 1303,
	FN_SD2_DAT2 = 1304,
	FN_MT0_D = 1305,
	FN_SPVTDI = 1306,
	FN_ADIDATA_B___3 = 1307,
	FN_VI1_DATA3_VI1_B3 = 1308,
	FN_SD2_DAT3 = 1309,
	FN_MT0_BEN = 1310,
	FN_SPV_TDO = 1311,
	FN_ADICHS0_B___3 = 1312,
	FN_VI1_DATA4_VI1_B4 = 1313,
	FN_SD2_CLK___3 = 1314,
	FN_MT0_PEN = 1315,
	FN_SPA_TRST = 1316,
	FN_HSPI_CLK1_D = 1317,
	FN_ADICHS1_B___3 = 1318,
	FN_VI1_DATA5_VI1_B5 = 1319,
	FN_SD2_CMD___3 = 1320,
	FN_MT0_SYNC = 1321,
	FN_SPA_TCK = 1322,
	FN_HSPI_CS1_D = 1323,
	FN_ADICHS2_B___3 = 1324,
	FN_VI1_DATA6_VI1_B6 = 1325,
	FN_SD2_CD___3 = 1326,
	FN_MT0_VCXO = 1327,
	FN_SPA_TMS = 1328,
	FN_HSPI_TX1_D = 1329,
	FN_VI1_DATA7_VI1_B7 = 1330,
	FN_SD2_WP___3 = 1331,
	FN_MT0_PWM = 1332,
	FN_SPA_TDI = 1333,
	FN_HSPI_RX1_D = 1334,
	FN_VI1_G0 = 1335,
	FN_VI3_DATA0 = 1336,
	FN_TS_SCK1 = 1337,
	FN_DREQ2_B___2 = 1338,
	FN_TX2___2 = 1339,
	FN_SPA_TDO = 1340,
	FN_HCTS0_B = 1341,
	FN_VI1_G1 = 1342,
	FN_VI3_DATA1 = 1343,
	FN_SSI_SCK1___3 = 1344,
	FN_TS_SDEN1 = 1345,
	FN_DACK2_B___2 = 1346,
	FN_RX2___2 = 1347,
	FN_HRTS0_B = 1348,
	FN_VI1_G2 = 1349,
	FN_VI3_DATA2 = 1350,
	FN_SSI_WS1___3 = 1351,
	FN_TS_SPSYNC1 = 1352,
	FN_SCK2 = 1353,
	FN_HSCK0_B = 1354,
	FN_VI1_G3 = 1355,
	FN_VI3_DATA3 = 1356,
	FN_SSI_SCK2___3 = 1357,
	FN_TS_SDAT1 = 1358,
	FN_SCL1_C = 1359,
	FN_HTX0_B___2 = 1360,
	FN_VI1_G4 = 1361,
	FN_VI3_DATA4 = 1362,
	FN_SSI_WS2___3 = 1363,
	FN_SDA1_C = 1364,
	FN_SIM_RST_B = 1365,
	FN_HRX0_B___2 = 1366,
	FN_VI1_G5 = 1367,
	FN_VI3_DATA5 = 1368,
	FN_GPS_CLK___2 = 1369,
	FN_FSE = 1370,
	FN_TX4_B___2 = 1371,
	FN_SIM_D_B = 1372,
	FN_VI1_G6 = 1373,
	FN_VI3_DATA6 = 1374,
	FN_GPS_SIGN___2 = 1375,
	FN_FRB = 1376,
	FN_RX4_B___2 = 1377,
	FN_SIM_CLK_B = 1378,
	FN_VI1_G7 = 1379,
	FN_VI3_DATA7 = 1380,
	FN_GPS_MAG___2 = 1381,
	FN_FCE = 1382,
	FN_SCK4_B = 1383,
	FN_SEL_SCIF5_0___3 = 1384,
	FN_SEL_SCIF5_1___3 = 1385,
	FN_SEL_SCIF5_2___2 = 1386,
	FN_SEL_SCIF5_3___2 = 1387,
	FN_SEL_SCIF4_0___3 = 1388,
	FN_SEL_SCIF4_1___3 = 1389,
	FN_SEL_SCIF4_2___3 = 1390,
	FN_SEL_SCIF4_3___2 = 1391,
	FN_SEL_SCIF3_0___3 = 1392,
	FN_SEL_SCIF3_1___3 = 1393,
	FN_SEL_SCIF3_2___2 = 1394,
	FN_SEL_SCIF3_3___2 = 1395,
	FN_SEL_SCIF3_4 = 1396,
	FN_SEL_SCIF2_0___3 = 1397,
	FN_SEL_SCIF2_1___3 = 1398,
	FN_SEL_SCIF2_2___3 = 1399,
	FN_SEL_SCIF2_3___2 = 1400,
	FN_SEL_SCIF2_4___2 = 1401,
	FN_SEL_SCIF1_0___3 = 1402,
	FN_SEL_SCIF1_1___3 = 1403,
	FN_SEL_SCIF1_2___3 = 1404,
	FN_SEL_SCIF0_0___3 = 1405,
	FN_SEL_SCIF0_1___3 = 1406,
	FN_SEL_SCIF0_2___3 = 1407,
	FN_SEL_SCIF0_3___3 = 1408,
	FN_SEL_SSI9_0___3 = 1409,
	FN_SEL_SSI9_1___3 = 1410,
	FN_SEL_SSI9_2 = 1411,
	FN_SEL_SSI8_0___3 = 1412,
	FN_SEL_SSI8_1___3 = 1413,
	FN_SEL_SSI8_2 = 1414,
	FN_SEL_SSI7_0___3 = 1415,
	FN_SEL_SSI7_1___3 = 1416,
	FN_SEL_SSI7_2 = 1417,
	FN_SEL_VI0_0 = 1418,
	FN_SEL_VI0_1 = 1419,
	FN_SEL_SD2_0 = 1420,
	FN_SEL_SD2_1 = 1421,
	FN_SEL_INT3_0 = 1422,
	FN_SEL_INT3_1 = 1423,
	FN_SEL_INT2_0 = 1424,
	FN_SEL_INT2_1 = 1425,
	FN_SEL_INT1_0 = 1426,
	FN_SEL_INT1_1 = 1427,
	FN_SEL_INT0_0 = 1428,
	FN_SEL_INT0_1 = 1429,
	FN_SEL_IE_0 = 1430,
	FN_SEL_IE_1 = 1431,
	FN_SEL_EXBUS2_0 = 1432,
	FN_SEL_EXBUS2_1 = 1433,
	FN_SEL_EXBUS2_2 = 1434,
	FN_SEL_EXBUS1_0 = 1435,
	FN_SEL_EXBUS1_1 = 1436,
	FN_SEL_EXBUS0_0 = 1437,
	FN_SEL_EXBUS0_1 = 1438,
	FN_SEL_EXBUS0_2 = 1439,
	FN_SEL_TMU1_0___2 = 1440,
	FN_SEL_TMU1_1___2 = 1441,
	FN_SEL_TMU1_2 = 1442,
	FN_SEL_TMU0_0 = 1443,
	FN_SEL_TMU0_1 = 1444,
	FN_SEL_TMU0_2 = 1445,
	FN_SEL_TMU0_3 = 1446,
	FN_SEL_SCIF_0___2 = 1447,
	FN_SEL_SCIF_1___2 = 1448,
	FN_SEL_SCIF_2 = 1449,
	FN_SEL_SCIF_3 = 1450,
	FN_SEL_CANCLK_0___2 = 1451,
	FN_SEL_CANCLK_1___2 = 1452,
	FN_SEL_CANCLK_2___2 = 1453,
	FN_SEL_CAN0_0___3 = 1454,
	FN_SEL_CAN0_1___3 = 1455,
	FN_SEL_HSCIF1_0___3 = 1456,
	FN_SEL_HSCIF1_1___3 = 1457,
	FN_SEL_HSCIF0_0___3 = 1458,
	FN_SEL_HSCIF0_1___3 = 1459,
	FN_SEL_PWMFSW_0 = 1460,
	FN_SEL_PWMFSW_1 = 1461,
	FN_SEL_PWMFSW_2 = 1462,
	FN_SEL_PWMFSW_3 = 1463,
	FN_SEL_PWMFSW_4 = 1464,
	FN_SEL_ADI_0 = 1465,
	FN_SEL_ADI_1 = 1466,
	FN_SEL_GPS_0___2 = 1467,
	FN_SEL_GPS_1___2 = 1468,
	FN_SEL_GPS_2___2 = 1469,
	FN_SEL_GPS_3___2 = 1470,
	FN_SEL_SIM_0___2 = 1471,
	FN_SEL_SIM_1___2 = 1472,
	FN_SEL_HSPI2_0 = 1473,
	FN_SEL_HSPI2_1 = 1474,
	FN_SEL_HSPI1_0 = 1475,
	FN_SEL_HSPI1_1 = 1476,
	FN_SEL_HSPI1_2 = 1477,
	FN_SEL_HSPI1_3 = 1478,
	FN_SEL_I2C3_0___2 = 1479,
	FN_SEL_I2C3_1___2 = 1480,
	FN_SEL_I2C2_0___2 = 1481,
	FN_SEL_I2C2_1___2 = 1482,
	FN_SEL_I2C2_2___2 = 1483,
	FN_SEL_I2C2_3___2 = 1484,
	FN_SEL_I2C1_0___2 = 1485,
	FN_SEL_I2C1_1___2 = 1486,
	FN_SEL_I2C1_2___2 = 1487,
	FN_SEL_I2C1_3___2 = 1488,
	PINMUX_FUNCTION_END___4 = 1489,
	PINMUX_MARK_BEGIN___4 = 1490,
	AVS1_MARK = 1491,
	AVS2_MARK = 1492,
	A17_MARK___4 = 1493,
	A18_MARK___4 = 1494,
	A19_MARK___4 = 1495,
	RD_WR_MARK = 1496,
	FWE_MARK = 1497,
	ATAG0_MARK = 1498,
	VI1_R7_MARK = 1499,
	HRTS1_MARK = 1500,
	RX4_C_MARK___2 = 1501,
	CS1_A26_MARK = 1502,
	HSPI_TX2_MARK = 1503,
	SDSELF_B_MARK = 1504,
	CS0_MARK = 1505,
	HSPI_CS2_B_MARK = 1506,
	CLKOUT_MARK = 1507,
	TX3C_IRDA_TX_C_MARK = 1508,
	PWM0_B_MARK___3 = 1509,
	A25_MARK___4 = 1510,
	SD1_WP_MARK___3 = 1511,
	MMC0_D5_MARK = 1512,
	FD5_MARK = 1513,
	HSPI_RX2_MARK = 1514,
	VI1_R3_MARK = 1515,
	TX5_B_MARK___2 = 1516,
	SSI_SDATA7_B_MARK___3 = 1517,
	CTS0_B_MARK = 1518,
	A24_MARK___4 = 1519,
	SD1_CD_MARK___3 = 1520,
	MMC0_D4_MARK = 1521,
	FD4_MARK = 1522,
	HSPI_CS2_MARK = 1523,
	VI1_R2_MARK = 1524,
	SSI_WS78_B_MARK___3 = 1525,
	A23_MARK___4 = 1526,
	FCLE_MARK = 1527,
	HSPI_CLK2_MARK = 1528,
	VI1_R1_MARK = 1529,
	A22_MARK___4 = 1530,
	RX5_D_MARK = 1531,
	HSPI_RX2_B_MARK = 1532,
	VI1_R0_MARK = 1533,
	A21_MARK___4 = 1534,
	SCK5_D_MARK = 1535,
	HSPI_CLK2_B_MARK = 1536,
	A20_MARK___4 = 1537,
	TX5_D_MARK = 1538,
	HSPI_TX2_B_MARK = 1539,
	A0_MARK___4 = 1540,
	SD1_DAT3_MARK = 1541,
	MMC0_D3_MARK = 1542,
	FD3_MARK = 1543,
	BS_MARK = 1544,
	SD1_DAT2_MARK = 1545,
	MMC0_D2_MARK = 1546,
	FD2_MARK = 1547,
	ATADIR0_MARK = 1548,
	SDSELF_MARK = 1549,
	HCTS1_MARK = 1550,
	TX4_C_MARK___2 = 1551,
	USB_PENC0_MARK = 1552,
	USB_PENC1_MARK = 1553,
	USB_PENC2_MARK = 1554,
	SCK0_MARK = 1555,
	PWM1_MARK___3 = 1556,
	PWMFSW0_MARK = 1557,
	SCIF_CLK_MARK___3 = 1558,
	TCLK0_C_MARK = 1559,
	EX_CS0_MARK = 1560,
	RX3_C_IRDA_RX_C_MARK = 1561,
	MMC0_D6_MARK = 1562,
	FD6_MARK = 1563,
	EX_CS1_MARK = 1564,
	MMC0_D7_MARK = 1565,
	FD7_MARK = 1566,
	EX_CS2_MARK = 1567,
	SD1_CLK_MARK___3 = 1568,
	MMC0_CLK_MARK = 1569,
	FALE_MARK = 1570,
	ATACS00_MARK = 1571,
	EX_CS3_MARK = 1572,
	SD1_CMD_MARK___3 = 1573,
	MMC0_CMD_MARK = 1574,
	FRE_MARK = 1575,
	ATACS10_MARK = 1576,
	VI1_R4_MARK = 1577,
	RX5_B_MARK___2 = 1578,
	HSCK1_MARK___2 = 1579,
	SSI_SDATA8_B_MARK___3 = 1580,
	RTS0_B_TANS_B_MARK = 1581,
	SSI_SDATA9_MARK___3 = 1582,
	EX_CS4_MARK = 1583,
	SD1_DAT0_MARK = 1584,
	MMC0_D0_MARK = 1585,
	FD0_MARK = 1586,
	ATARD0_MARK = 1587,
	VI1_R5_MARK = 1588,
	SCK5_B_MARK = 1589,
	HTX1_MARK___2 = 1590,
	TX2_E_MARK___2 = 1591,
	TX0_B_MARK___2 = 1592,
	SSI_SCK9_MARK___3 = 1593,
	EX_CS5_MARK = 1594,
	SD1_DAT1_MARK = 1595,
	MMC0_D1_MARK = 1596,
	FD1_MARK = 1597,
	ATAWR0_MARK = 1598,
	VI1_R6_MARK = 1599,
	HRX1_MARK___2 = 1600,
	RX2_E_MARK___2 = 1601,
	RX0_B_MARK___2 = 1602,
	SSI_WS9_MARK___3 = 1603,
	MLB_CLK_MARK___3 = 1604,
	PWM2_MARK___3 = 1605,
	SCK4_MARK = 1606,
	MLB_SIG_MARK___3 = 1607,
	PWM3_MARK___3 = 1608,
	TX4_MARK___2 = 1609,
	MLB_DAT_MARK___3 = 1610,
	PWM4_MARK___3 = 1611,
	RX4_MARK___2 = 1612,
	HTX0_MARK___2 = 1613,
	TX1_MARK___2 = 1614,
	SDATA_MARK = 1615,
	CTS0_C_MARK = 1616,
	SUB_TCK_MARK = 1617,
	CC5_STATE2_MARK = 1618,
	CC5_STATE10_MARK = 1619,
	CC5_STATE18_MARK = 1620,
	CC5_STATE26_MARK = 1621,
	CC5_STATE34_MARK = 1622,
	HRX0_MARK___2 = 1623,
	RX1_MARK___2 = 1624,
	SCKZ_MARK = 1625,
	RTS0_C_TANS_C_MARK = 1626,
	SUB_TDI_MARK = 1627,
	CC5_STATE3_MARK = 1628,
	CC5_STATE11_MARK = 1629,
	CC5_STATE19_MARK = 1630,
	CC5_STATE27_MARK = 1631,
	CC5_STATE35_MARK = 1632,
	HSCK0_MARK___2 = 1633,
	SCK1_MARK = 1634,
	MTS_MARK = 1635,
	PWM5_MARK___3 = 1636,
	SCK0_C_MARK = 1637,
	SSI_SDATA9_B_MARK___3 = 1638,
	SUB_TDO_MARK = 1639,
	CC5_STATE0_MARK = 1640,
	CC5_STATE8_MARK = 1641,
	CC5_STATE16_MARK = 1642,
	CC5_STATE24_MARK = 1643,
	CC5_STATE32_MARK = 1644,
	HCTS0_MARK = 1645,
	CTS1_MARK = 1646,
	STM_MARK = 1647,
	PWM0_D_MARK = 1648,
	RX0_C_MARK___2 = 1649,
	SCIF_CLK_C_MARK = 1650,
	SUB_TRST_MARK = 1651,
	TCLK1_B_MARK___3 = 1652,
	CC5_OSCOUT_MARK = 1653,
	HRTS0_MARK = 1654,
	RTS1_TANS_MARK = 1655,
	MDATA_MARK = 1656,
	TX0_C_MARK___2 = 1657,
	SUB_TMS_MARK = 1658,
	CC5_STATE1_MARK = 1659,
	CC5_STATE9_MARK = 1660,
	CC5_STATE17_MARK = 1661,
	CC5_STATE25_MARK = 1662,
	CC5_STATE33_MARK = 1663,
	DU0_DR0_MARK___2 = 1664,
	LCDOUT0_MARK___3 = 1665,
	DREQ0_MARK___3 = 1666,
	GPS_CLK_B_MARK___2 = 1667,
	AUDATA0_MARK = 1668,
	TX5_C_MARK = 1669,
	DU0_DR1_MARK___2 = 1670,
	LCDOUT1_MARK___3 = 1671,
	DACK0_MARK___4 = 1672,
	DRACK0_MARK___3 = 1673,
	GPS_SIGN_B_MARK___2 = 1674,
	AUDATA1_MARK = 1675,
	RX5_C_MARK = 1676,
	DU0_DR2_MARK___2 = 1677,
	LCDOUT2_MARK___3 = 1678,
	DU0_DR3_MARK___2 = 1679,
	LCDOUT3_MARK___3 = 1680,
	DU0_DR4_MARK___2 = 1681,
	LCDOUT4_MARK___3 = 1682,
	DU0_DR5_MARK___2 = 1683,
	LCDOUT5_MARK___3 = 1684,
	DU0_DR6_MARK___2 = 1685,
	LCDOUT6_MARK___3 = 1686,
	DU0_DR7_MARK___2 = 1687,
	LCDOUT7_MARK___3 = 1688,
	DU0_DG0_MARK___2 = 1689,
	LCDOUT8_MARK___3 = 1690,
	DREQ1_MARK___3 = 1691,
	SCL2_MARK = 1692,
	AUDATA2_MARK = 1693,
	DU0_DG1_MARK___2 = 1694,
	LCDOUT9_MARK___3 = 1695,
	DACK1_MARK___4 = 1696,
	SDA2_MARK = 1697,
	AUDATA3_MARK = 1698,
	DU0_DG2_MARK___2 = 1699,
	LCDOUT10_MARK___3 = 1700,
	DU0_DG3_MARK___2 = 1701,
	LCDOUT11_MARK___3 = 1702,
	DU0_DG4_MARK___2 = 1703,
	LCDOUT12_MARK___3 = 1704,
	DU0_DG5_MARK___2 = 1705,
	LCDOUT13_MARK___3 = 1706,
	DU0_DG6_MARK___2 = 1707,
	LCDOUT14_MARK___3 = 1708,
	DU0_DG7_MARK___2 = 1709,
	LCDOUT15_MARK___3 = 1710,
	DU0_DB0_MARK___2 = 1711,
	LCDOUT16_MARK___3 = 1712,
	EX_WAIT1_MARK___3 = 1713,
	SCL1_MARK = 1714,
	TCLK1_MARK___3 = 1715,
	AUDATA4_MARK = 1716,
	DU0_DB1_MARK___2 = 1717,
	LCDOUT17_MARK___3 = 1718,
	EX_WAIT2_MARK___3 = 1719,
	SDA1_MARK = 1720,
	GPS_MAG_B_MARK___2 = 1721,
	AUDATA5_MARK = 1722,
	SCK5_C_MARK = 1723,
	DU0_DB2_MARK___2 = 1724,
	LCDOUT18_MARK___3 = 1725,
	DU0_DB3_MARK___2 = 1726,
	LCDOUT19_MARK___3 = 1727,
	DU0_DB4_MARK___2 = 1728,
	LCDOUT20_MARK___3 = 1729,
	DU0_DB5_MARK___2 = 1730,
	LCDOUT21_MARK___3 = 1731,
	DU0_DB6_MARK___2 = 1732,
	LCDOUT22_MARK___3 = 1733,
	DU0_DB7_MARK___2 = 1734,
	LCDOUT23_MARK___3 = 1735,
	DU0_DOTCLKIN_MARK___3 = 1736,
	QSTVA_QVS_MARK___3 = 1737,
	TX3_D_IRDA_TX_D_MARK = 1738,
	SCL3_B_MARK = 1739,
	DU0_DOTCLKOUT0_MARK___2 = 1740,
	QCLK_MARK___3 = 1741,
	DU0_DOTCLKOUT1_MARK___2 = 1742,
	QSTVB_QVE_MARK___3 = 1743,
	RX3_D_IRDA_RX_D_MARK = 1744,
	SDA3_B_MARK = 1745,
	SDA2_C_MARK = 1746,
	DACK0_B_MARK = 1747,
	DRACK0_B_MARK = 1748,
	DU0_EXHSYNC_DU0_HSYNC_MARK___2 = 1749,
	QSTH_QHS_MARK___3 = 1750,
	DU0_EXVSYNC_DU0_VSYNC_MARK___2 = 1751,
	QSTB_QHE_MARK___3 = 1752,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK___2 = 1753,
	QCPV_QDE_MARK___3 = 1754,
	CAN1_TX_MARK___3 = 1755,
	TX2_C_MARK___2 = 1756,
	SCL2_C_MARK = 1757,
	REMOCON_MARK___3 = 1758,
	DU0_DISP_MARK___2 = 1759,
	QPOLA_MARK___3 = 1760,
	CAN_CLK_C_MARK___3 = 1761,
	SCK2_C_MARK = 1762,
	DU0_CDE_MARK___2 = 1763,
	QPOLB_MARK___3 = 1764,
	CAN1_RX_MARK___3 = 1765,
	RX2_C_MARK___2 = 1766,
	DREQ0_B_MARK = 1767,
	SSI_SCK78_B_MARK___3 = 1768,
	SCK0_B_MARK = 1769,
	DU1_DR0_MARK___3 = 1770,
	VI2_DATA0_VI2_B0_MARK = 1771,
	PWM6_MARK___3 = 1772,
	SD3_CLK_MARK = 1773,
	TX3_E_IRDA_TX_E_MARK = 1774,
	AUDCK_MARK = 1775,
	PWMFSW0_B_MARK = 1776,
	DU1_DR1_MARK___3 = 1777,
	VI2_DATA1_VI2_B1_MARK = 1778,
	PWM0_MARK___3 = 1779,
	SD3_CMD_MARK = 1780,
	RX3_E_IRDA_RX_E_MARK = 1781,
	AUDSYNC_MARK = 1782,
	CTS0_D_MARK = 1783,
	DU1_DR2_MARK___3 = 1784,
	VI2_G0_MARK = 1785,
	DU1_DR3_MARK___3 = 1786,
	VI2_G1_MARK = 1787,
	DU1_DR4_MARK___3 = 1788,
	VI2_G2_MARK = 1789,
	DU1_DR5_MARK___3 = 1790,
	VI2_G3_MARK = 1791,
	DU1_DR6_MARK___3 = 1792,
	VI2_G4_MARK = 1793,
	DU1_DR7_MARK___3 = 1794,
	VI2_G5_MARK = 1795,
	DU1_DG0_MARK___3 = 1796,
	VI2_DATA2_VI2_B2_MARK = 1797,
	SCL1_B_MARK = 1798,
	SD3_DAT2_MARK = 1799,
	SCK3_E_MARK = 1800,
	AUDATA6_MARK = 1801,
	TX0_D_MARK___2 = 1802,
	DU1_DG1_MARK___3 = 1803,
	VI2_DATA3_VI2_B3_MARK = 1804,
	SDA1_B_MARK = 1805,
	SD3_DAT3_MARK = 1806,
	SCK5_MARK = 1807,
	AUDATA7_MARK = 1808,
	RX0_D_MARK___2 = 1809,
	DU1_DG2_MARK___3 = 1810,
	VI2_G6_MARK = 1811,
	DU1_DG3_MARK___3 = 1812,
	VI2_G7_MARK = 1813,
	DU1_DG4_MARK___3 = 1814,
	VI2_R0_MARK = 1815,
	DU1_DG5_MARK___3 = 1816,
	VI2_R1_MARK = 1817,
	DU1_DG6_MARK___3 = 1818,
	VI2_R2_MARK = 1819,
	DU1_DG7_MARK___3 = 1820,
	VI2_R3_MARK = 1821,
	DU1_DB0_MARK___3 = 1822,
	VI2_DATA4_VI2_B4_MARK = 1823,
	SCL2_B_MARK = 1824,
	SD3_DAT0_MARK = 1825,
	TX5_MARK___2 = 1826,
	SCK0_D_MARK = 1827,
	DU1_DB1_MARK___3 = 1828,
	VI2_DATA5_VI2_B5_MARK = 1829,
	SDA2_B_MARK = 1830,
	SD3_DAT1_MARK = 1831,
	RX5_MARK___2 = 1832,
	RTS0_D_TANS_D_MARK = 1833,
	DU1_DB2_MARK___3 = 1834,
	VI2_R4_MARK = 1835,
	DU1_DB3_MARK___3 = 1836,
	VI2_R5_MARK = 1837,
	DU1_DB4_MARK___3 = 1838,
	VI2_R6_MARK = 1839,
	DU1_DB5_MARK___3 = 1840,
	VI2_R7_MARK = 1841,
	DU1_DB6_MARK___3 = 1842,
	SCL2_D_MARK = 1843,
	DU1_DB7_MARK___3 = 1844,
	SDA2_D_MARK = 1845,
	DU1_DOTCLKIN_MARK___3 = 1846,
	VI2_CLKENB_MARK___2 = 1847,
	HSPI_CS1_MARK = 1848,
	SCL1_D_MARK = 1849,
	DU1_DOTCLKOUT_MARK = 1850,
	VI2_FIELD_MARK___2 = 1851,
	SDA1_D_MARK = 1852,
	DU1_EXHSYNC_DU1_HSYNC_MARK___3 = 1853,
	VI2_HSYNC_MARK = 1854,
	VI3_HSYNC_MARK = 1855,
	DU1_EXVSYNC_DU1_VSYNC_MARK___3 = 1856,
	VI2_VSYNC_MARK = 1857,
	VI3_VSYNC_MARK = 1858,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK___3 = 1859,
	VI2_CLK_MARK___2 = 1860,
	TX3_B_IRDA_TX_B_MARK = 1861,
	SD3_CD_MARK = 1862,
	HSPI_TX1_MARK = 1863,
	VI1_CLKENB_MARK___3 = 1864,
	VI3_CLKENB_MARK = 1865,
	AUDIO_CLKC_MARK___3 = 1866,
	TX2_D_MARK = 1867,
	SPEEDIN_MARK___3 = 1868,
	GPS_SIGN_D_MARK___2 = 1869,
	DU1_DISP_MARK___3 = 1870,
	VI2_DATA6_VI2_B6_MARK = 1871,
	TCLK0_MARK = 1872,
	QSTVA_B_QVS_B_MARK = 1873,
	HSPI_CLK1_MARK = 1874,
	SCK2_D_MARK = 1875,
	AUDIO_CLKOUT_B_MARK___2 = 1876,
	GPS_MAG_D_MARK___2 = 1877,
	DU1_CDE_MARK___3 = 1878,
	VI2_DATA7_VI2_B7_MARK = 1879,
	RX3_B_IRDA_RX_B_MARK = 1880,
	SD3_WP_MARK = 1881,
	HSPI_RX1_MARK = 1882,
	VI1_FIELD_MARK___3 = 1883,
	VI3_FIELD_MARK = 1884,
	AUDIO_CLKOUT_MARK___3 = 1885,
	RX2_D_MARK = 1886,
	GPS_CLK_C_MARK___2 = 1887,
	GPS_CLK_D_MARK___2 = 1888,
	AUDIO_CLKA_MARK___3 = 1889,
	CAN_TXCLK_MARK___2 = 1890,
	AUDIO_CLKB_MARK___3 = 1891,
	USB_OVC2_MARK = 1892,
	CAN_DEBUGOUT0_MARK = 1893,
	MOUT0_MARK = 1894,
	SSI_SCK0129_MARK___3 = 1895,
	CAN_DEBUGOUT1_MARK = 1896,
	MOUT1_MARK = 1897,
	SSI_WS0129_MARK___3 = 1898,
	CAN_DEBUGOUT2_MARK = 1899,
	MOUT2_MARK = 1900,
	SSI_SDATA0_MARK___3 = 1901,
	CAN_DEBUGOUT3_MARK = 1902,
	MOUT5_MARK = 1903,
	SSI_SDATA1_MARK___3 = 1904,
	CAN_DEBUGOUT4_MARK = 1905,
	MOUT6_MARK = 1906,
	SSI_SDATA2_MARK___3 = 1907,
	CAN_DEBUGOUT5_MARK = 1908,
	SSI_SCK34_MARK___3 = 1909,
	CAN_DEBUGOUT6_MARK = 1910,
	CAN0_TX_B_MARK___3 = 1911,
	IERX_MARK___3 = 1912,
	SSI_SCK9_C_MARK = 1913,
	SSI_WS34_MARK___3 = 1914,
	CAN_DEBUGOUT7_MARK = 1915,
	CAN0_RX_B_MARK___3 = 1916,
	IETX_MARK___3 = 1917,
	SSI_WS9_C_MARK = 1918,
	SSI_SDATA3_MARK___3 = 1919,
	PWM0_C_MARK = 1920,
	CAN_DEBUGOUT8_MARK = 1921,
	CAN_CLK_B_MARK___3 = 1922,
	IECLK_MARK___3 = 1923,
	SCIF_CLK_B_MARK___3 = 1924,
	TCLK0_B_MARK = 1925,
	SSI_SDATA4_MARK___3 = 1926,
	CAN_DEBUGOUT9_MARK = 1927,
	SSI_SDATA9_C_MARK = 1928,
	SSI_SCK5_MARK___3 = 1929,
	ADICLK_MARK___3 = 1930,
	CAN_DEBUGOUT10_MARK = 1931,
	SCK3_MARK = 1932,
	TCLK0_D_MARK = 1933,
	SSI_WS5_MARK___3 = 1934,
	ADICS_SAMP_MARK___3 = 1935,
	CAN_DEBUGOUT11_MARK = 1936,
	TX3_IRDA_TX_MARK = 1937,
	SSI_SDATA5_MARK___3 = 1938,
	ADIDATA_MARK___3 = 1939,
	CAN_DEBUGOUT12_MARK = 1940,
	RX3_IRDA_RX_MARK = 1941,
	SSI_SCK6_MARK___3 = 1942,
	ADICHS0_MARK___3 = 1943,
	CAN0_TX_MARK___3 = 1944,
	IERX_B_MARK___3 = 1945,
	SSI_WS6_MARK___3 = 1946,
	ADICHS1_MARK___3 = 1947,
	CAN0_RX_MARK___3 = 1948,
	IETX_B_MARK___3 = 1949,
	SSI_SDATA6_MARK___3 = 1950,
	ADICHS2_MARK___3 = 1951,
	CAN_CLK_MARK___3 = 1952,
	IECLK_B_MARK___3 = 1953,
	SSI_SCK78_MARK___3 = 1954,
	CAN_DEBUGOUT13_MARK = 1955,
	IRQ0_B_MARK = 1956,
	SSI_SCK9_B_MARK___3 = 1957,
	HSPI_CLK1_C_MARK = 1958,
	SSI_WS78_MARK___3 = 1959,
	CAN_DEBUGOUT14_MARK = 1960,
	IRQ1_B_MARK = 1961,
	SSI_WS9_B_MARK___3 = 1962,
	HSPI_CS1_C_MARK = 1963,
	SSI_SDATA7_MARK___3 = 1964,
	CAN_DEBUGOUT15_MARK = 1965,
	IRQ2_B_MARK = 1966,
	TCLK1_C_MARK = 1967,
	HSPI_TX1_C_MARK = 1968,
	SSI_SDATA8_MARK___3 = 1969,
	VSP_MARK = 1970,
	IRQ3_B_MARK = 1971,
	HSPI_RX1_C_MARK = 1972,
	SD0_CLK_MARK___3 = 1973,
	ATACS01_MARK = 1974,
	SCK1_B_MARK = 1975,
	SD0_CMD_MARK___3 = 1976,
	ATACS11_MARK = 1977,
	TX1_B_MARK___2 = 1978,
	CC5_TDO_MARK = 1979,
	SD0_DAT0_MARK = 1980,
	ATADIR1_MARK = 1981,
	RX1_B_MARK___2 = 1982,
	CC5_TRST_MARK = 1983,
	SD0_DAT1_MARK = 1984,
	ATAG1_MARK = 1985,
	SCK2_B_MARK = 1986,
	CC5_TMS_MARK = 1987,
	SD0_DAT2_MARK = 1988,
	ATARD1_MARK = 1989,
	TX2_B_MARK___2 = 1990,
	CC5_TCK_MARK = 1991,
	SD0_DAT3_MARK = 1992,
	ATAWR1_MARK = 1993,
	RX2_B_MARK___2 = 1994,
	CC5_TDI_MARK = 1995,
	SD0_CD_MARK___3 = 1996,
	DREQ2_MARK___3 = 1997,
	RTS1_B_TANS_B_MARK = 1998,
	SD0_WP_MARK___3 = 1999,
	DACK2_MARK___4 = 2000,
	CTS1_B_MARK = 2001,
	HSPI_CLK0_MARK = 2002,
	CTS0_MARK = 2003,
	USB_OVC0_MARK = 2004,
	AD_CLK_MARK = 2005,
	CC5_STATE4_MARK = 2006,
	CC5_STATE12_MARK = 2007,
	CC5_STATE20_MARK = 2008,
	CC5_STATE28_MARK = 2009,
	CC5_STATE36_MARK = 2010,
	HSPI_CS0_MARK = 2011,
	RTS0_TANS_MARK = 2012,
	USB_OVC1_MARK = 2013,
	AD_DI_MARK = 2014,
	CC5_STATE5_MARK = 2015,
	CC5_STATE13_MARK = 2016,
	CC5_STATE21_MARK = 2017,
	CC5_STATE29_MARK = 2018,
	CC5_STATE37_MARK = 2019,
	HSPI_TX0_MARK = 2020,
	TX0_MARK___2 = 2021,
	CAN_DEBUG_HW_TRIGGER_MARK = 2022,
	AD_DO_MARK = 2023,
	CC5_STATE6_MARK = 2024,
	CC5_STATE14_MARK = 2025,
	CC5_STATE22_MARK = 2026,
	CC5_STATE30_MARK = 2027,
	CC5_STATE38_MARK = 2028,
	HSPI_RX0_MARK = 2029,
	RX0_MARK___2 = 2030,
	CAN_STEP0_MARK = 2031,
	AD_NCS_MARK = 2032,
	CC5_STATE7_MARK = 2033,
	CC5_STATE15_MARK = 2034,
	CC5_STATE23_MARK = 2035,
	CC5_STATE31_MARK = 2036,
	CC5_STATE39_MARK = 2037,
	FMCLK_MARK___3 = 2038,
	RDS_CLK_MARK = 2039,
	PCMOE_MARK = 2040,
	BPFCLK_MARK___3 = 2041,
	PCMWE_MARK = 2042,
	FMIN_MARK___3 = 2043,
	RDS_DATA_MARK = 2044,
	VI0_CLK_MARK___3 = 2045,
	MMC1_CLK_MARK = 2046,
	VI0_CLKENB_MARK___3 = 2047,
	TX1_C_MARK___2 = 2048,
	HTX1_B_MARK___2 = 2049,
	MT1_SYNC_MARK = 2050,
	VI0_FIELD_MARK___3 = 2051,
	RX1_C_MARK___2 = 2052,
	HRX1_B_MARK___2 = 2053,
	VI0_HSYNC_MARK = 2054,
	VI0_DATA0_B_VI0_B0_B_MARK = 2055,
	CTS1_C_MARK = 2056,
	TX4_D_MARK = 2057,
	MMC1_CMD_MARK = 2058,
	HSCK1_B_MARK = 2059,
	VI0_VSYNC_MARK = 2060,
	VI0_DATA1_B_VI0_B1_B_MARK = 2061,
	RTS1_C_TANS_C_MARK = 2062,
	RX4_D_MARK = 2063,
	PWMFSW0_C_MARK = 2064,
	VI0_DATA0_VI0_B0_MARK___3 = 2065,
	HRTS1_B_MARK = 2066,
	MT1_VCXO_MARK = 2067,
	VI0_DATA1_VI0_B1_MARK___3 = 2068,
	HCTS1_B_MARK = 2069,
	MT1_PWM_MARK = 2070,
	VI0_DATA2_VI0_B2_MARK___3 = 2071,
	MMC1_D0_MARK = 2072,
	VI0_DATA3_VI0_B3_MARK___3 = 2073,
	MMC1_D1_MARK = 2074,
	VI0_DATA4_VI0_B4_MARK___3 = 2075,
	MMC1_D2_MARK = 2076,
	VI0_DATA5_VI0_B5_MARK___3 = 2077,
	MMC1_D3_MARK = 2078,
	VI0_DATA6_VI0_B6_MARK___3 = 2079,
	MMC1_D4_MARK = 2080,
	ARM_TRACEDATA_0_MARK = 2081,
	VI0_DATA7_VI0_B7_MARK___3 = 2082,
	MMC1_D5_MARK = 2083,
	ARM_TRACEDATA_1_MARK = 2084,
	VI0_G0_MARK___3 = 2085,
	SSI_SCK78_C_MARK = 2086,
	IRQ0_MARK___3 = 2087,
	ARM_TRACEDATA_2_MARK = 2088,
	VI0_G1_MARK___3 = 2089,
	SSI_WS78_C_MARK = 2090,
	IRQ1_MARK___3 = 2091,
	ARM_TRACEDATA_3_MARK = 2092,
	VI0_G2_MARK___3 = 2093,
	ETH_TXD1_MARK___3 = 2094,
	MMC1_D6_MARK = 2095,
	ARM_TRACEDATA_4_MARK = 2096,
	TS_SPSYNC0_MARK___2 = 2097,
	VI0_G3_MARK___3 = 2098,
	ETH_CRS_DV_MARK___3 = 2099,
	MMC1_D7_MARK = 2100,
	ARM_TRACEDATA_5_MARK = 2101,
	TS_SDAT0_MARK = 2102,
	VI0_G4_MARK___3 = 2103,
	ETH_TX_EN_MARK___3 = 2104,
	SD2_DAT0_B_MARK = 2105,
	ARM_TRACEDATA_6_MARK = 2106,
	VI0_G5_MARK___3 = 2107,
	ETH_RX_ER_MARK___3 = 2108,
	SD2_DAT1_B_MARK = 2109,
	ARM_TRACEDATA_7_MARK = 2110,
	VI0_G6_MARK___3 = 2111,
	ETH_RXD0_MARK___3 = 2112,
	SD2_DAT2_B_MARK = 2113,
	ARM_TRACEDATA_8_MARK = 2114,
	VI0_G7_MARK___3 = 2115,
	ETH_RXD1_MARK___3 = 2116,
	SD2_DAT3_B_MARK = 2117,
	ARM_TRACEDATA_9_MARK = 2118,
	VI0_R0_MARK___3 = 2119,
	SSI_SDATA7_C_MARK = 2120,
	SCK1_C_MARK = 2121,
	DREQ1_B_MARK = 2122,
	ARM_TRACEDATA_10_MARK = 2123,
	DREQ0_C_MARK = 2124,
	VI0_R1_MARK___3 = 2125,
	SSI_SDATA8_C_MARK = 2126,
	DACK1_B_MARK___2 = 2127,
	ARM_TRACEDATA_11_MARK = 2128,
	DACK0_C_MARK = 2129,
	DRACK0_C_MARK = 2130,
	VI0_R2_MARK___3 = 2131,
	ETH_LINK_MARK___3 = 2132,
	SD2_CLK_B_MARK = 2133,
	IRQ2_MARK___3 = 2134,
	ARM_TRACEDATA_12_MARK = 2135,
	VI0_R3_MARK___3 = 2136,
	ETH_MAGIC_MARK___3 = 2137,
	SD2_CMD_B_MARK = 2138,
	IRQ3_MARK___3 = 2139,
	ARM_TRACEDATA_13_MARK = 2140,
	VI0_R4_MARK___3 = 2141,
	ETH_REFCLK_MARK___3 = 2142,
	SD2_CD_B_MARK = 2143,
	HSPI_CLK1_B_MARK = 2144,
	ARM_TRACEDATA_14_MARK = 2145,
	MT1_CLK_MARK = 2146,
	TS_SCK0_MARK___2 = 2147,
	VI0_R5_MARK___3 = 2148,
	ETH_TXD0_MARK___3 = 2149,
	SD2_WP_B_MARK = 2150,
	HSPI_CS1_B_MARK = 2151,
	ARM_TRACEDATA_15_MARK = 2152,
	MT1_D_MARK = 2153,
	TS_SDEN0_MARK___2 = 2154,
	VI0_R6_MARK___3 = 2155,
	ETH_MDC_MARK___3 = 2156,
	DREQ2_C_MARK___2 = 2157,
	HSPI_TX1_B_MARK = 2158,
	TRACECLK_MARK = 2159,
	MT1_BEN_MARK = 2160,
	PWMFSW0_D_MARK = 2161,
	VI0_R7_MARK___3 = 2162,
	ETH_MDIO_MARK___3 = 2163,
	DACK2_C_MARK = 2164,
	HSPI_RX1_B_MARK = 2165,
	SCIF_CLK_D_MARK = 2166,
	TRACECTL_MARK = 2167,
	MT1_PEN_MARK = 2168,
	VI1_CLK_MARK___3 = 2169,
	SIM_D_MARK___2 = 2170,
	SDA3_MARK = 2171,
	VI1_HSYNC_MARK = 2172,
	VI3_CLK_MARK = 2173,
	SSI_SCK4_MARK___3 = 2174,
	GPS_SIGN_C_MARK___2 = 2175,
	PWMFSW0_E_MARK = 2176,
	VI1_VSYNC_MARK = 2177,
	AUDIO_CLKOUT_C_MARK___2 = 2178,
	SSI_WS4_MARK___3 = 2179,
	SIM_CLK_MARK___2 = 2180,
	GPS_MAG_C_MARK___2 = 2181,
	SPV_TRST_MARK = 2182,
	SCL3_MARK = 2183,
	VI1_DATA0_VI1_B0_MARK = 2184,
	SD2_DAT0_MARK = 2185,
	SIM_RST_MARK___2 = 2186,
	SPV_TCK_MARK = 2187,
	ADICLK_B_MARK___3 = 2188,
	VI1_DATA1_VI1_B1_MARK = 2189,
	SD2_DAT1_MARK = 2190,
	MT0_CLK_MARK = 2191,
	SPV_TMS_MARK = 2192,
	ADICS_B_SAMP_B_MARK = 2193,
	VI1_DATA2_VI1_B2_MARK = 2194,
	SD2_DAT2_MARK = 2195,
	MT0_D_MARK = 2196,
	SPVTDI_MARK = 2197,
	ADIDATA_B_MARK___3 = 2198,
	VI1_DATA3_VI1_B3_MARK = 2199,
	SD2_DAT3_MARK = 2200,
	MT0_BEN_MARK = 2201,
	SPV_TDO_MARK = 2202,
	ADICHS0_B_MARK___3 = 2203,
	VI1_DATA4_VI1_B4_MARK = 2204,
	SD2_CLK_MARK___3 = 2205,
	MT0_PEN_MARK = 2206,
	SPA_TRST_MARK = 2207,
	HSPI_CLK1_D_MARK = 2208,
	ADICHS1_B_MARK___3 = 2209,
	VI1_DATA5_VI1_B5_MARK = 2210,
	SD2_CMD_MARK___3 = 2211,
	MT0_SYNC_MARK = 2212,
	SPA_TCK_MARK = 2213,
	HSPI_CS1_D_MARK = 2214,
	ADICHS2_B_MARK___3 = 2215,
	VI1_DATA6_VI1_B6_MARK = 2216,
	SD2_CD_MARK___3 = 2217,
	MT0_VCXO_MARK = 2218,
	SPA_TMS_MARK = 2219,
	HSPI_TX1_D_MARK = 2220,
	VI1_DATA7_VI1_B7_MARK = 2221,
	SD2_WP_MARK___3 = 2222,
	MT0_PWM_MARK = 2223,
	SPA_TDI_MARK = 2224,
	HSPI_RX1_D_MARK = 2225,
	VI1_G0_MARK = 2226,
	VI3_DATA0_MARK = 2227,
	TS_SCK1_MARK___2 = 2228,
	DREQ2_B_MARK___2 = 2229,
	TX2_MARK___2 = 2230,
	SPA_TDO_MARK = 2231,
	HCTS0_B_MARK = 2232,
	VI1_G1_MARK = 2233,
	VI3_DATA1_MARK = 2234,
	SSI_SCK1_MARK___3 = 2235,
	TS_SDEN1_MARK___2 = 2236,
	DACK2_B_MARK___2 = 2237,
	RX2_MARK___2 = 2238,
	HRTS0_B_MARK = 2239,
	VI1_G2_MARK = 2240,
	VI3_DATA2_MARK = 2241,
	SSI_WS1_MARK___3 = 2242,
	TS_SPSYNC1_MARK___2 = 2243,
	SCK2_MARK = 2244,
	HSCK0_B_MARK = 2245,
	VI1_G3_MARK = 2246,
	VI3_DATA3_MARK = 2247,
	SSI_SCK2_MARK___3 = 2248,
	TS_SDAT1_MARK___2 = 2249,
	SCL1_C_MARK = 2250,
	HTX0_B_MARK___2 = 2251,
	VI1_G4_MARK = 2252,
	VI3_DATA4_MARK = 2253,
	SSI_WS2_MARK___3 = 2254,
	SDA1_C_MARK = 2255,
	SIM_RST_B_MARK = 2256,
	HRX0_B_MARK___2 = 2257,
	VI1_G5_MARK = 2258,
	VI3_DATA5_MARK = 2259,
	GPS_CLK_MARK___2 = 2260,
	FSE_MARK = 2261,
	TX4_B_MARK___2 = 2262,
	SIM_D_B_MARK = 2263,
	VI1_G6_MARK = 2264,
	VI3_DATA6_MARK = 2265,
	GPS_SIGN_MARK___2 = 2266,
	FRB_MARK___2 = 2267,
	RX4_B_MARK___2 = 2268,
	SIM_CLK_B_MARK = 2269,
	VI1_G7_MARK = 2270,
	VI3_DATA7_MARK = 2271,
	GPS_MAG_MARK___2 = 2272,
	FCE_MARK = 2273,
	SCK4_B_MARK = 2274,
	PINMUX_MARK_END___4 = 2275,
};

enum {
	PINMUX_RESERVED___5 = 0,
	PINMUX_DATA_BEGIN___5 = 1,
	PORT0_DATA___2 = 2,
	PORT1_DATA___2 = 3,
	PORT2_DATA___2 = 4,
	PORT3_DATA___2 = 5,
	PORT4_DATA___2 = 6,
	PORT5_DATA___2 = 7,
	PORT6_DATA___2 = 8,
	PORT7_DATA___2 = 9,
	PORT8_DATA___2 = 10,
	PORT9_DATA___2 = 11,
	PORT10_DATA___2 = 12,
	PORT11_DATA___2 = 13,
	PORT12_DATA___2 = 14,
	PORT13_DATA___2 = 15,
	PORT14_DATA___2 = 16,
	PORT15_DATA___2 = 17,
	PORT16_DATA___2 = 18,
	PORT17_DATA___2 = 19,
	PORT18_DATA___2 = 20,
	PORT19_DATA___2 = 21,
	PORT20_DATA___2 = 22,
	PORT21_DATA___2 = 23,
	PORT22_DATA___2 = 24,
	PORT23_DATA___2 = 25,
	PORT24_DATA___2 = 26,
	PORT25_DATA___2 = 27,
	PORT26_DATA___2 = 28,
	PORT27_DATA___2 = 29,
	PORT28_DATA___2 = 30,
	PORT29_DATA___2 = 31,
	PORT30_DATA___2 = 32,
	PORT32_DATA___2 = 33,
	PORT33_DATA___2 = 34,
	PORT34_DATA___2 = 35,
	PORT35_DATA___2 = 36,
	PORT36_DATA___2 = 37,
	PORT37_DATA___2 = 38,
	PORT38_DATA___2 = 39,
	PORT39_DATA___2 = 40,
	PORT40_DATA___2 = 41,
	PORT64_DATA___2 = 42,
	PORT65_DATA___2 = 43,
	PORT66_DATA___2 = 44,
	PORT67_DATA___2 = 45,
	PORT68_DATA___2 = 46,
	PORT69_DATA___2 = 47,
	PORT70_DATA___2 = 48,
	PORT71_DATA___2 = 49,
	PORT72_DATA___2 = 50,
	PORT73_DATA___2 = 51,
	PORT74_DATA___2 = 52,
	PORT75_DATA___2 = 53,
	PORT76_DATA___2 = 54,
	PORT77_DATA___2 = 55,
	PORT78_DATA___2 = 56,
	PORT79_DATA___2 = 57,
	PORT80_DATA___2 = 58,
	PORT81_DATA___2 = 59,
	PORT82_DATA___2 = 60,
	PORT83_DATA___2 = 61,
	PORT84_DATA___2 = 62,
	PORT85_DATA___2 = 63,
	PORT96_DATA___2 = 64,
	PORT97_DATA___2 = 65,
	PORT98_DATA___2 = 66,
	PORT99_DATA___2 = 67,
	PORT100_DATA___2 = 68,
	PORT101_DATA___2 = 69,
	PORT102_DATA___2 = 70,
	PORT103_DATA___2 = 71,
	PORT104_DATA___2 = 72,
	PORT105_DATA___2 = 73,
	PORT106_DATA___2 = 74,
	PORT107_DATA___2 = 75,
	PORT108_DATA___2 = 76,
	PORT109_DATA___2 = 77,
	PORT110_DATA___2 = 78,
	PORT111_DATA___2 = 79,
	PORT112_DATA___2 = 80,
	PORT113_DATA___2 = 81,
	PORT114_DATA___2 = 82,
	PORT115_DATA___2 = 83,
	PORT116_DATA___2 = 84,
	PORT117_DATA___2 = 85,
	PORT118_DATA___2 = 86,
	PORT119_DATA = 87,
	PORT120_DATA = 88,
	PORT121_DATA = 89,
	PORT122_DATA = 90,
	PORT123_DATA = 91,
	PORT124_DATA = 92,
	PORT125_DATA = 93,
	PORT126_DATA = 94,
	PORT128_DATA___2 = 95,
	PORT129_DATA___2 = 96,
	PORT130_DATA___2 = 97,
	PORT131_DATA___2 = 98,
	PORT132_DATA___2 = 99,
	PORT133_DATA___2 = 100,
	PORT134_DATA___2 = 101,
	PORT160_DATA___2 = 102,
	PORT161_DATA___2 = 103,
	PORT162_DATA___2 = 104,
	PORT163_DATA___2 = 105,
	PORT164_DATA___2 = 106,
	PORT165_DATA = 107,
	PORT166_DATA = 108,
	PORT167_DATA = 109,
	PORT168_DATA = 110,
	PORT169_DATA = 111,
	PORT170_DATA = 112,
	PORT171_DATA = 113,
	PORT172_DATA = 114,
	PORT173_DATA = 115,
	PORT174_DATA = 116,
	PORT175_DATA = 117,
	PORT176_DATA = 118,
	PORT177_DATA = 119,
	PORT178_DATA = 120,
	PORT192_DATA___2 = 121,
	PORT193_DATA___2 = 122,
	PORT194_DATA___2 = 123,
	PORT195_DATA___2 = 124,
	PORT196_DATA___2 = 125,
	PORT197_DATA___2 = 126,
	PORT198_DATA___2 = 127,
	PORT199_DATA___2 = 128,
	PORT200_DATA___2 = 129,
	PORT201_DATA___2 = 130,
	PORT202_DATA___2 = 131,
	PORT203_DATA___2 = 132,
	PORT204_DATA___2 = 133,
	PORT205_DATA___2 = 134,
	PORT206_DATA___2 = 135,
	PORT207_DATA___2 = 136,
	PORT208_DATA___2 = 137,
	PORT209_DATA___2 = 138,
	PORT210_DATA___2 = 139,
	PORT211_DATA___2 = 140,
	PORT212_DATA___2 = 141,
	PORT213_DATA___2 = 142,
	PORT214_DATA___2 = 143,
	PORT215_DATA___2 = 144,
	PORT216_DATA___2 = 145,
	PORT217_DATA___2 = 146,
	PORT218_DATA___2 = 147,
	PORT219_DATA___2 = 148,
	PORT220_DATA___2 = 149,
	PORT221_DATA___2 = 150,
	PORT222_DATA___2 = 151,
	PORT224_DATA___2 = 152,
	PORT225_DATA___2 = 153,
	PORT226_DATA___2 = 154,
	PORT227_DATA___2 = 155,
	PORT228_DATA___2 = 156,
	PORT229_DATA___2 = 157,
	PORT230_DATA___2 = 158,
	PORT231_DATA___2 = 159,
	PORT232_DATA___2 = 160,
	PORT233_DATA___2 = 161,
	PORT234_DATA___2 = 162,
	PORT235_DATA___2 = 163,
	PORT236_DATA___2 = 164,
	PORT237_DATA___2 = 165,
	PORT238_DATA___2 = 166,
	PORT239_DATA___2 = 167,
	PORT240_DATA___2 = 168,
	PORT241_DATA___2 = 169,
	PORT242_DATA___2 = 170,
	PORT243_DATA___2 = 171,
	PORT244_DATA___2 = 172,
	PORT245_DATA___2 = 173,
	PORT246_DATA___2 = 174,
	PORT247_DATA___2 = 175,
	PORT248_DATA___2 = 176,
	PORT249_DATA___2 = 177,
	PORT250_DATA___2 = 178,
	PORT256_DATA___2 = 179,
	PORT257_DATA___2 = 180,
	PORT258_DATA___2 = 181,
	PORT259_DATA___2 = 182,
	PORT260_DATA___2 = 183,
	PORT261_DATA___2 = 184,
	PORT262_DATA___2 = 185,
	PORT263_DATA___2 = 186,
	PORT264_DATA___2 = 187,
	PORT265_DATA___2 = 188,
	PORT266_DATA___2 = 189,
	PORT267_DATA___2 = 190,
	PORT268_DATA___2 = 191,
	PORT269_DATA___2 = 192,
	PORT270_DATA___2 = 193,
	PORT271_DATA___2 = 194,
	PORT272_DATA___2 = 195,
	PORT273_DATA___2 = 196,
	PORT274_DATA___2 = 197,
	PORT275_DATA___2 = 198,
	PORT276_DATA___2 = 199,
	PORT277_DATA___2 = 200,
	PORT278_DATA___2 = 201,
	PORT279_DATA___2 = 202,
	PORT280_DATA___2 = 203,
	PORT281_DATA___2 = 204,
	PORT282_DATA___2 = 205,
	PORT283_DATA = 206,
	PORT288_DATA___2 = 207,
	PORT289_DATA___2 = 208,
	PORT290_DATA___2 = 209,
	PORT291_DATA___2 = 210,
	PORT292_DATA___2 = 211,
	PORT293_DATA___2 = 212,
	PORT294_DATA___2 = 213,
	PORT295_DATA___2 = 214,
	PORT296_DATA___2 = 215,
	PORT297_DATA___2 = 216,
	PORT298_DATA___2 = 217,
	PORT299_DATA___2 = 218,
	PORT300_DATA___2 = 219,
	PORT301_DATA___2 = 220,
	PORT302_DATA___2 = 221,
	PORT303_DATA___2 = 222,
	PORT304_DATA___2 = 223,
	PORT305_DATA___2 = 224,
	PORT306_DATA___2 = 225,
	PORT307_DATA___2 = 226,
	PORT308_DATA___2 = 227,
	PORT320_DATA = 228,
	PORT321_DATA = 229,
	PORT322_DATA = 230,
	PORT323_DATA = 231,
	PORT324_DATA = 232,
	PORT325_DATA = 233,
	PORT326_DATA = 234,
	PORT327_DATA = 235,
	PORT328_DATA = 236,
	PORT329_DATA = 237,
	PINMUX_DATA_END___5 = 238,
	PINMUX_INPUT_BEGIN___2 = 239,
	PORT0_IN___2 = 240,
	PORT1_IN___2 = 241,
	PORT2_IN___2 = 242,
	PORT3_IN___2 = 243,
	PORT4_IN___2 = 244,
	PORT5_IN___2 = 245,
	PORT6_IN___2 = 246,
	PORT7_IN___2 = 247,
	PORT8_IN___2 = 248,
	PORT9_IN___2 = 249,
	PORT10_IN___2 = 250,
	PORT11_IN___2 = 251,
	PORT12_IN___2 = 252,
	PORT13_IN___2 = 253,
	PORT14_IN___2 = 254,
	PORT15_IN___2 = 255,
	PORT16_IN___2 = 256,
	PORT17_IN___2 = 257,
	PORT18_IN___2 = 258,
	PORT19_IN___2 = 259,
	PORT20_IN___2 = 260,
	PORT21_IN___2 = 261,
	PORT22_IN___2 = 262,
	PORT23_IN___2 = 263,
	PORT24_IN___2 = 264,
	PORT25_IN___2 = 265,
	PORT26_IN___2 = 266,
	PORT27_IN___2 = 267,
	PORT28_IN___2 = 268,
	PORT29_IN___2 = 269,
	PORT30_IN___2 = 270,
	PORT32_IN___2 = 271,
	PORT33_IN___2 = 272,
	PORT34_IN___2 = 273,
	PORT35_IN___2 = 274,
	PORT36_IN___2 = 275,
	PORT37_IN___2 = 276,
	PORT38_IN___2 = 277,
	PORT39_IN___2 = 278,
	PORT40_IN___2 = 279,
	PORT64_IN___2 = 280,
	PORT65_IN___2 = 281,
	PORT66_IN___2 = 282,
	PORT67_IN___2 = 283,
	PORT68_IN___2 = 284,
	PORT69_IN___2 = 285,
	PORT70_IN___2 = 286,
	PORT71_IN___2 = 287,
	PORT72_IN___2 = 288,
	PORT73_IN___2 = 289,
	PORT74_IN___2 = 290,
	PORT75_IN___2 = 291,
	PORT76_IN___2 = 292,
	PORT77_IN___2 = 293,
	PORT78_IN___2 = 294,
	PORT79_IN___2 = 295,
	PORT80_IN___2 = 296,
	PORT81_IN___2 = 297,
	PORT82_IN___2 = 298,
	PORT83_IN___2 = 299,
	PORT84_IN___2 = 300,
	PORT85_IN___2 = 301,
	PORT96_IN___2 = 302,
	PORT97_IN___2 = 303,
	PORT98_IN___2 = 304,
	PORT99_IN___2 = 305,
	PORT100_IN___2 = 306,
	PORT101_IN___2 = 307,
	PORT102_IN___2 = 308,
	PORT103_IN___2 = 309,
	PORT104_IN___2 = 310,
	PORT105_IN___2 = 311,
	PORT106_IN___2 = 312,
	PORT107_IN___2 = 313,
	PORT108_IN___2 = 314,
	PORT109_IN___2 = 315,
	PORT110_IN___2 = 316,
	PORT111_IN___2 = 317,
	PORT112_IN___2 = 318,
	PORT113_IN___2 = 319,
	PORT114_IN___2 = 320,
	PORT115_IN___2 = 321,
	PORT116_IN___2 = 322,
	PORT117_IN___2 = 323,
	PORT118_IN___2 = 324,
	PORT119_IN = 325,
	PORT120_IN = 326,
	PORT121_IN = 327,
	PORT122_IN = 328,
	PORT123_IN = 329,
	PORT124_IN = 330,
	PORT125_IN = 331,
	PORT126_IN = 332,
	PORT128_IN___2 = 333,
	PORT129_IN___2 = 334,
	PORT130_IN___2 = 335,
	PORT131_IN___2 = 336,
	PORT132_IN___2 = 337,
	PORT133_IN___2 = 338,
	PORT134_IN___2 = 339,
	PORT160_IN___2 = 340,
	PORT161_IN___2 = 341,
	PORT162_IN___2 = 342,
	PORT163_IN___2 = 343,
	PORT164_IN___2 = 344,
	PORT165_IN = 345,
	PORT166_IN = 346,
	PORT167_IN = 347,
	PORT168_IN = 348,
	PORT169_IN = 349,
	PORT170_IN = 350,
	PORT171_IN = 351,
	PORT172_IN = 352,
	PORT173_IN = 353,
	PORT174_IN = 354,
	PORT175_IN = 355,
	PORT176_IN = 356,
	PORT177_IN = 357,
	PORT178_IN = 358,
	PORT192_IN___2 = 359,
	PORT193_IN___2 = 360,
	PORT194_IN___2 = 361,
	PORT195_IN___2 = 362,
	PORT196_IN___2 = 363,
	PORT197_IN___2 = 364,
	PORT198_IN___2 = 365,
	PORT199_IN___2 = 366,
	PORT200_IN___2 = 367,
	PORT201_IN___2 = 368,
	PORT202_IN___2 = 369,
	PORT203_IN___2 = 370,
	PORT204_IN___2 = 371,
	PORT205_IN___2 = 372,
	PORT206_IN___2 = 373,
	PORT207_IN___2 = 374,
	PORT208_IN___2 = 375,
	PORT209_IN___2 = 376,
	PORT210_IN___2 = 377,
	PORT211_IN___2 = 378,
	PORT212_IN___2 = 379,
	PORT213_IN___2 = 380,
	PORT214_IN___2 = 381,
	PORT215_IN___2 = 382,
	PORT216_IN___2 = 383,
	PORT217_IN___2 = 384,
	PORT218_IN___2 = 385,
	PORT219_IN___2 = 386,
	PORT220_IN___2 = 387,
	PORT221_IN___2 = 388,
	PORT222_IN___2 = 389,
	PORT224_IN___2 = 390,
	PORT225_IN___2 = 391,
	PORT226_IN___2 = 392,
	PORT227_IN___2 = 393,
	PORT228_IN___2 = 394,
	PORT229_IN___2 = 395,
	PORT230_IN___2 = 396,
	PORT231_IN___2 = 397,
	PORT232_IN___2 = 398,
	PORT233_IN___2 = 399,
	PORT234_IN___2 = 400,
	PORT235_IN___2 = 401,
	PORT236_IN___2 = 402,
	PORT237_IN___2 = 403,
	PORT238_IN___2 = 404,
	PORT239_IN___2 = 405,
	PORT240_IN___2 = 406,
	PORT241_IN___2 = 407,
	PORT242_IN___2 = 408,
	PORT243_IN___2 = 409,
	PORT244_IN___2 = 410,
	PORT245_IN___2 = 411,
	PORT246_IN___2 = 412,
	PORT247_IN___2 = 413,
	PORT248_IN___2 = 414,
	PORT249_IN___2 = 415,
	PORT250_IN___2 = 416,
	PORT256_IN___2 = 417,
	PORT257_IN___2 = 418,
	PORT258_IN___2 = 419,
	PORT259_IN___2 = 420,
	PORT260_IN___2 = 421,
	PORT261_IN___2 = 422,
	PORT262_IN___2 = 423,
	PORT263_IN___2 = 424,
	PORT264_IN___2 = 425,
	PORT265_IN___2 = 426,
	PORT266_IN___2 = 427,
	PORT267_IN___2 = 428,
	PORT268_IN___2 = 429,
	PORT269_IN___2 = 430,
	PORT270_IN___2 = 431,
	PORT271_IN___2 = 432,
	PORT272_IN___2 = 433,
	PORT273_IN___2 = 434,
	PORT274_IN___2 = 435,
	PORT275_IN___2 = 436,
	PORT276_IN___2 = 437,
	PORT277_IN___2 = 438,
	PORT278_IN___2 = 439,
	PORT279_IN___2 = 440,
	PORT280_IN___2 = 441,
	PORT281_IN___2 = 442,
	PORT282_IN___2 = 443,
	PORT283_IN = 444,
	PORT288_IN___2 = 445,
	PORT289_IN___2 = 446,
	PORT290_IN___2 = 447,
	PORT291_IN___2 = 448,
	PORT292_IN___2 = 449,
	PORT293_IN___2 = 450,
	PORT294_IN___2 = 451,
	PORT295_IN___2 = 452,
	PORT296_IN___2 = 453,
	PORT297_IN___2 = 454,
	PORT298_IN___2 = 455,
	PORT299_IN___2 = 456,
	PORT300_IN___2 = 457,
	PORT301_IN___2 = 458,
	PORT302_IN___2 = 459,
	PORT303_IN___2 = 460,
	PORT304_IN___2 = 461,
	PORT305_IN___2 = 462,
	PORT306_IN___2 = 463,
	PORT307_IN___2 = 464,
	PORT308_IN___2 = 465,
	PORT320_IN = 466,
	PORT321_IN = 467,
	PORT322_IN = 468,
	PORT323_IN = 469,
	PORT324_IN = 470,
	PORT325_IN = 471,
	PORT326_IN = 472,
	PORT327_IN = 473,
	PORT328_IN = 474,
	PORT329_IN = 475,
	PINMUX_INPUT_END___2 = 476,
	PINMUX_OUTPUT_BEGIN___2 = 477,
	PORT0_OUT___2 = 478,
	PORT1_OUT___2 = 479,
	PORT2_OUT___2 = 480,
	PORT3_OUT___2 = 481,
	PORT4_OUT___2 = 482,
	PORT5_OUT___2 = 483,
	PORT6_OUT___2 = 484,
	PORT7_OUT___2 = 485,
	PORT8_OUT___2 = 486,
	PORT9_OUT___2 = 487,
	PORT10_OUT___2 = 488,
	PORT11_OUT___2 = 489,
	PORT12_OUT___2 = 490,
	PORT13_OUT___2 = 491,
	PORT14_OUT___2 = 492,
	PORT15_OUT___2 = 493,
	PORT16_OUT___2 = 494,
	PORT17_OUT___2 = 495,
	PORT18_OUT___2 = 496,
	PORT19_OUT___2 = 497,
	PORT20_OUT___2 = 498,
	PORT21_OUT___2 = 499,
	PORT22_OUT___2 = 500,
	PORT23_OUT___2 = 501,
	PORT24_OUT___2 = 502,
	PORT25_OUT___2 = 503,
	PORT26_OUT___2 = 504,
	PORT27_OUT___2 = 505,
	PORT28_OUT___2 = 506,
	PORT29_OUT___2 = 507,
	PORT30_OUT___2 = 508,
	PORT32_OUT___2 = 509,
	PORT33_OUT___2 = 510,
	PORT34_OUT___2 = 511,
	PORT35_OUT___2 = 512,
	PORT36_OUT___2 = 513,
	PORT37_OUT___2 = 514,
	PORT38_OUT___2 = 515,
	PORT39_OUT___2 = 516,
	PORT40_OUT___2 = 517,
	PORT64_OUT___2 = 518,
	PORT65_OUT___2 = 519,
	PORT66_OUT___2 = 520,
	PORT67_OUT___2 = 521,
	PORT68_OUT___2 = 522,
	PORT69_OUT___2 = 523,
	PORT70_OUT___2 = 524,
	PORT71_OUT___2 = 525,
	PORT72_OUT___2 = 526,
	PORT73_OUT___2 = 527,
	PORT74_OUT___2 = 528,
	PORT75_OUT___2 = 529,
	PORT76_OUT___2 = 530,
	PORT77_OUT___2 = 531,
	PORT78_OUT___2 = 532,
	PORT79_OUT___2 = 533,
	PORT80_OUT___2 = 534,
	PORT81_OUT___2 = 535,
	PORT82_OUT___2 = 536,
	PORT83_OUT___2 = 537,
	PORT84_OUT___2 = 538,
	PORT85_OUT___2 = 539,
	PORT96_OUT___2 = 540,
	PORT97_OUT___2 = 541,
	PORT98_OUT___2 = 542,
	PORT99_OUT___2 = 543,
	PORT100_OUT___2 = 544,
	PORT101_OUT___2 = 545,
	PORT102_OUT___2 = 546,
	PORT103_OUT___2 = 547,
	PORT104_OUT___2 = 548,
	PORT105_OUT___2 = 549,
	PORT106_OUT___2 = 550,
	PORT107_OUT___2 = 551,
	PORT108_OUT___2 = 552,
	PORT109_OUT___2 = 553,
	PORT110_OUT___2 = 554,
	PORT111_OUT___2 = 555,
	PORT112_OUT___2 = 556,
	PORT113_OUT___2 = 557,
	PORT114_OUT___2 = 558,
	PORT115_OUT___2 = 559,
	PORT116_OUT___2 = 560,
	PORT117_OUT___2 = 561,
	PORT118_OUT___2 = 562,
	PORT119_OUT = 563,
	PORT120_OUT = 564,
	PORT121_OUT = 565,
	PORT122_OUT = 566,
	PORT123_OUT = 567,
	PORT124_OUT = 568,
	PORT125_OUT = 569,
	PORT126_OUT = 570,
	PORT128_OUT___2 = 571,
	PORT129_OUT___2 = 572,
	PORT130_OUT___2 = 573,
	PORT131_OUT___2 = 574,
	PORT132_OUT___2 = 575,
	PORT133_OUT___2 = 576,
	PORT134_OUT___2 = 577,
	PORT160_OUT___2 = 578,
	PORT161_OUT___2 = 579,
	PORT162_OUT___2 = 580,
	PORT163_OUT___2 = 581,
	PORT164_OUT___2 = 582,
	PORT165_OUT = 583,
	PORT166_OUT = 584,
	PORT167_OUT = 585,
	PORT168_OUT = 586,
	PORT169_OUT = 587,
	PORT170_OUT = 588,
	PORT171_OUT = 589,
	PORT172_OUT = 590,
	PORT173_OUT = 591,
	PORT174_OUT = 592,
	PORT175_OUT = 593,
	PORT176_OUT = 594,
	PORT177_OUT = 595,
	PORT178_OUT = 596,
	PORT192_OUT___2 = 597,
	PORT193_OUT___2 = 598,
	PORT194_OUT___2 = 599,
	PORT195_OUT___2 = 600,
	PORT196_OUT___2 = 601,
	PORT197_OUT___2 = 602,
	PORT198_OUT___2 = 603,
	PORT199_OUT___2 = 604,
	PORT200_OUT___2 = 605,
	PORT201_OUT___2 = 606,
	PORT202_OUT___2 = 607,
	PORT203_OUT___2 = 608,
	PORT204_OUT___2 = 609,
	PORT205_OUT___2 = 610,
	PORT206_OUT___2 = 611,
	PORT207_OUT___2 = 612,
	PORT208_OUT___2 = 613,
	PORT209_OUT___2 = 614,
	PORT210_OUT___2 = 615,
	PORT211_OUT___2 = 616,
	PORT212_OUT___2 = 617,
	PORT213_OUT___2 = 618,
	PORT214_OUT___2 = 619,
	PORT215_OUT___2 = 620,
	PORT216_OUT___2 = 621,
	PORT217_OUT___2 = 622,
	PORT218_OUT___2 = 623,
	PORT219_OUT___2 = 624,
	PORT220_OUT___2 = 625,
	PORT221_OUT___2 = 626,
	PORT222_OUT___2 = 627,
	PORT224_OUT___2 = 628,
	PORT225_OUT___2 = 629,
	PORT226_OUT___2 = 630,
	PORT227_OUT___2 = 631,
	PORT228_OUT___2 = 632,
	PORT229_OUT___2 = 633,
	PORT230_OUT___2 = 634,
	PORT231_OUT___2 = 635,
	PORT232_OUT___2 = 636,
	PORT233_OUT___2 = 637,
	PORT234_OUT___2 = 638,
	PORT235_OUT___2 = 639,
	PORT236_OUT___2 = 640,
	PORT237_OUT___2 = 641,
	PORT238_OUT___2 = 642,
	PORT239_OUT___2 = 643,
	PORT240_OUT___2 = 644,
	PORT241_OUT___2 = 645,
	PORT242_OUT___2 = 646,
	PORT243_OUT___2 = 647,
	PORT244_OUT___2 = 648,
	PORT245_OUT___2 = 649,
	PORT246_OUT___2 = 650,
	PORT247_OUT___2 = 651,
	PORT248_OUT___2 = 652,
	PORT249_OUT___2 = 653,
	PORT250_OUT___2 = 654,
	PORT256_OUT___2 = 655,
	PORT257_OUT___2 = 656,
	PORT258_OUT___2 = 657,
	PORT259_OUT___2 = 658,
	PORT260_OUT___2 = 659,
	PORT261_OUT___2 = 660,
	PORT262_OUT___2 = 661,
	PORT263_OUT___2 = 662,
	PORT264_OUT___2 = 663,
	PORT265_OUT___2 = 664,
	PORT266_OUT___2 = 665,
	PORT267_OUT___2 = 666,
	PORT268_OUT___2 = 667,
	PORT269_OUT___2 = 668,
	PORT270_OUT___2 = 669,
	PORT271_OUT___2 = 670,
	PORT272_OUT___2 = 671,
	PORT273_OUT___2 = 672,
	PORT274_OUT___2 = 673,
	PORT275_OUT___2 = 674,
	PORT276_OUT___2 = 675,
	PORT277_OUT___2 = 676,
	PORT278_OUT___2 = 677,
	PORT279_OUT___2 = 678,
	PORT280_OUT___2 = 679,
	PORT281_OUT___2 = 680,
	PORT282_OUT___2 = 681,
	PORT283_OUT = 682,
	PORT288_OUT___2 = 683,
	PORT289_OUT___2 = 684,
	PORT290_OUT___2 = 685,
	PORT291_OUT___2 = 686,
	PORT292_OUT___2 = 687,
	PORT293_OUT___2 = 688,
	PORT294_OUT___2 = 689,
	PORT295_OUT___2 = 690,
	PORT296_OUT___2 = 691,
	PORT297_OUT___2 = 692,
	PORT298_OUT___2 = 693,
	PORT299_OUT___2 = 694,
	PORT300_OUT___2 = 695,
	PORT301_OUT___2 = 696,
	PORT302_OUT___2 = 697,
	PORT303_OUT___2 = 698,
	PORT304_OUT___2 = 699,
	PORT305_OUT___2 = 700,
	PORT306_OUT___2 = 701,
	PORT307_OUT___2 = 702,
	PORT308_OUT___2 = 703,
	PORT320_OUT = 704,
	PORT321_OUT = 705,
	PORT322_OUT = 706,
	PORT323_OUT = 707,
	PORT324_OUT = 708,
	PORT325_OUT = 709,
	PORT326_OUT = 710,
	PORT327_OUT = 711,
	PORT328_OUT = 712,
	PORT329_OUT = 713,
	PINMUX_OUTPUT_END___2 = 714,
	PINMUX_FUNCTION_BEGIN___5 = 715,
	PORT0_FN_IN___2 = 716,
	PORT1_FN_IN___2 = 717,
	PORT2_FN_IN___2 = 718,
	PORT3_FN_IN___2 = 719,
	PORT4_FN_IN___2 = 720,
	PORT5_FN_IN___2 = 721,
	PORT6_FN_IN___2 = 722,
	PORT7_FN_IN___2 = 723,
	PORT8_FN_IN___2 = 724,
	PORT9_FN_IN___2 = 725,
	PORT10_FN_IN___2 = 726,
	PORT11_FN_IN___2 = 727,
	PORT12_FN_IN___2 = 728,
	PORT13_FN_IN___2 = 729,
	PORT14_FN_IN___2 = 730,
	PORT15_FN_IN___2 = 731,
	PORT16_FN_IN___2 = 732,
	PORT17_FN_IN___2 = 733,
	PORT18_FN_IN___2 = 734,
	PORT19_FN_IN___2 = 735,
	PORT20_FN_IN___2 = 736,
	PORT21_FN_IN___2 = 737,
	PORT22_FN_IN___2 = 738,
	PORT23_FN_IN___2 = 739,
	PORT24_FN_IN___2 = 740,
	PORT25_FN_IN___2 = 741,
	PORT26_FN_IN___2 = 742,
	PORT27_FN_IN___2 = 743,
	PORT28_FN_IN___2 = 744,
	PORT29_FN_IN___2 = 745,
	PORT30_FN_IN___2 = 746,
	PORT32_FN_IN___2 = 747,
	PORT33_FN_IN___2 = 748,
	PORT34_FN_IN___2 = 749,
	PORT35_FN_IN___2 = 750,
	PORT36_FN_IN___2 = 751,
	PORT37_FN_IN___2 = 752,
	PORT38_FN_IN___2 = 753,
	PORT39_FN_IN___2 = 754,
	PORT40_FN_IN___2 = 755,
	PORT64_FN_IN___2 = 756,
	PORT65_FN_IN___2 = 757,
	PORT66_FN_IN___2 = 758,
	PORT67_FN_IN___2 = 759,
	PORT68_FN_IN___2 = 760,
	PORT69_FN_IN___2 = 761,
	PORT70_FN_IN___2 = 762,
	PORT71_FN_IN___2 = 763,
	PORT72_FN_IN___2 = 764,
	PORT73_FN_IN___2 = 765,
	PORT74_FN_IN___2 = 766,
	PORT75_FN_IN___2 = 767,
	PORT76_FN_IN___2 = 768,
	PORT77_FN_IN___2 = 769,
	PORT78_FN_IN___2 = 770,
	PORT79_FN_IN___2 = 771,
	PORT80_FN_IN___2 = 772,
	PORT81_FN_IN___2 = 773,
	PORT82_FN_IN___2 = 774,
	PORT83_FN_IN___2 = 775,
	PORT84_FN_IN___2 = 776,
	PORT85_FN_IN___2 = 777,
	PORT96_FN_IN___2 = 778,
	PORT97_FN_IN___2 = 779,
	PORT98_FN_IN___2 = 780,
	PORT99_FN_IN___2 = 781,
	PORT100_FN_IN___2 = 782,
	PORT101_FN_IN___2 = 783,
	PORT102_FN_IN___2 = 784,
	PORT103_FN_IN___2 = 785,
	PORT104_FN_IN___2 = 786,
	PORT105_FN_IN___2 = 787,
	PORT106_FN_IN___2 = 788,
	PORT107_FN_IN___2 = 789,
	PORT108_FN_IN___2 = 790,
	PORT109_FN_IN___2 = 791,
	PORT110_FN_IN___2 = 792,
	PORT111_FN_IN___2 = 793,
	PORT112_FN_IN___2 = 794,
	PORT113_FN_IN___2 = 795,
	PORT114_FN_IN___2 = 796,
	PORT115_FN_IN___2 = 797,
	PORT116_FN_IN___2 = 798,
	PORT117_FN_IN___2 = 799,
	PORT118_FN_IN___2 = 800,
	PORT119_FN_IN = 801,
	PORT120_FN_IN = 802,
	PORT121_FN_IN = 803,
	PORT122_FN_IN = 804,
	PORT123_FN_IN = 805,
	PORT124_FN_IN = 806,
	PORT125_FN_IN = 807,
	PORT126_FN_IN = 808,
	PORT128_FN_IN___2 = 809,
	PORT129_FN_IN___2 = 810,
	PORT130_FN_IN___2 = 811,
	PORT131_FN_IN___2 = 812,
	PORT132_FN_IN___2 = 813,
	PORT133_FN_IN___2 = 814,
	PORT134_FN_IN___2 = 815,
	PORT160_FN_IN___2 = 816,
	PORT161_FN_IN___2 = 817,
	PORT162_FN_IN___2 = 818,
	PORT163_FN_IN___2 = 819,
	PORT164_FN_IN___2 = 820,
	PORT165_FN_IN = 821,
	PORT166_FN_IN = 822,
	PORT167_FN_IN = 823,
	PORT168_FN_IN = 824,
	PORT169_FN_IN = 825,
	PORT170_FN_IN = 826,
	PORT171_FN_IN = 827,
	PORT172_FN_IN = 828,
	PORT173_FN_IN = 829,
	PORT174_FN_IN = 830,
	PORT175_FN_IN = 831,
	PORT176_FN_IN = 832,
	PORT177_FN_IN = 833,
	PORT178_FN_IN = 834,
	PORT192_FN_IN___2 = 835,
	PORT193_FN_IN___2 = 836,
	PORT194_FN_IN___2 = 837,
	PORT195_FN_IN___2 = 838,
	PORT196_FN_IN___2 = 839,
	PORT197_FN_IN___2 = 840,
	PORT198_FN_IN___2 = 841,
	PORT199_FN_IN___2 = 842,
	PORT200_FN_IN___2 = 843,
	PORT201_FN_IN___2 = 844,
	PORT202_FN_IN___2 = 845,
	PORT203_FN_IN___2 = 846,
	PORT204_FN_IN___2 = 847,
	PORT205_FN_IN___2 = 848,
	PORT206_FN_IN___2 = 849,
	PORT207_FN_IN___2 = 850,
	PORT208_FN_IN___2 = 851,
	PORT209_FN_IN___2 = 852,
	PORT210_FN_IN___2 = 853,
	PORT211_FN_IN___2 = 854,
	PORT212_FN_IN___2 = 855,
	PORT213_FN_IN___2 = 856,
	PORT214_FN_IN___2 = 857,
	PORT215_FN_IN___2 = 858,
	PORT216_FN_IN___2 = 859,
	PORT217_FN_IN___2 = 860,
	PORT218_FN_IN___2 = 861,
	PORT219_FN_IN___2 = 862,
	PORT220_FN_IN___2 = 863,
	PORT221_FN_IN___2 = 864,
	PORT222_FN_IN___2 = 865,
	PORT224_FN_IN___2 = 866,
	PORT225_FN_IN___2 = 867,
	PORT226_FN_IN___2 = 868,
	PORT227_FN_IN___2 = 869,
	PORT228_FN_IN___2 = 870,
	PORT229_FN_IN___2 = 871,
	PORT230_FN_IN___2 = 872,
	PORT231_FN_IN___2 = 873,
	PORT232_FN_IN___2 = 874,
	PORT233_FN_IN___2 = 875,
	PORT234_FN_IN___2 = 876,
	PORT235_FN_IN___2 = 877,
	PORT236_FN_IN___2 = 878,
	PORT237_FN_IN___2 = 879,
	PORT238_FN_IN___2 = 880,
	PORT239_FN_IN___2 = 881,
	PORT240_FN_IN___2 = 882,
	PORT241_FN_IN___2 = 883,
	PORT242_FN_IN___2 = 884,
	PORT243_FN_IN___2 = 885,
	PORT244_FN_IN___2 = 886,
	PORT245_FN_IN___2 = 887,
	PORT246_FN_IN___2 = 888,
	PORT247_FN_IN___2 = 889,
	PORT248_FN_IN___2 = 890,
	PORT249_FN_IN___2 = 891,
	PORT250_FN_IN___2 = 892,
	PORT256_FN_IN___2 = 893,
	PORT257_FN_IN___2 = 894,
	PORT258_FN_IN___2 = 895,
	PORT259_FN_IN___2 = 896,
	PORT260_FN_IN___2 = 897,
	PORT261_FN_IN___2 = 898,
	PORT262_FN_IN___2 = 899,
	PORT263_FN_IN___2 = 900,
	PORT264_FN_IN___2 = 901,
	PORT265_FN_IN___2 = 902,
	PORT266_FN_IN___2 = 903,
	PORT267_FN_IN___2 = 904,
	PORT268_FN_IN___2 = 905,
	PORT269_FN_IN___2 = 906,
	PORT270_FN_IN___2 = 907,
	PORT271_FN_IN___2 = 908,
	PORT272_FN_IN___2 = 909,
	PORT273_FN_IN___2 = 910,
	PORT274_FN_IN___2 = 911,
	PORT275_FN_IN___2 = 912,
	PORT276_FN_IN___2 = 913,
	PORT277_FN_IN___2 = 914,
	PORT278_FN_IN___2 = 915,
	PORT279_FN_IN___2 = 916,
	PORT280_FN_IN___2 = 917,
	PORT281_FN_IN___2 = 918,
	PORT282_FN_IN___2 = 919,
	PORT283_FN_IN = 920,
	PORT288_FN_IN___2 = 921,
	PORT289_FN_IN___2 = 922,
	PORT290_FN_IN___2 = 923,
	PORT291_FN_IN___2 = 924,
	PORT292_FN_IN___2 = 925,
	PORT293_FN_IN___2 = 926,
	PORT294_FN_IN___2 = 927,
	PORT295_FN_IN___2 = 928,
	PORT296_FN_IN___2 = 929,
	PORT297_FN_IN___2 = 930,
	PORT298_FN_IN___2 = 931,
	PORT299_FN_IN___2 = 932,
	PORT300_FN_IN___2 = 933,
	PORT301_FN_IN___2 = 934,
	PORT302_FN_IN___2 = 935,
	PORT303_FN_IN___2 = 936,
	PORT304_FN_IN___2 = 937,
	PORT305_FN_IN___2 = 938,
	PORT306_FN_IN___2 = 939,
	PORT307_FN_IN___2 = 940,
	PORT308_FN_IN___2 = 941,
	PORT320_FN_IN = 942,
	PORT321_FN_IN = 943,
	PORT322_FN_IN = 944,
	PORT323_FN_IN = 945,
	PORT324_FN_IN = 946,
	PORT325_FN_IN = 947,
	PORT326_FN_IN = 948,
	PORT327_FN_IN = 949,
	PORT328_FN_IN = 950,
	PORT329_FN_IN = 951,
	PORT0_FN_OUT___2 = 952,
	PORT1_FN_OUT___2 = 953,
	PORT2_FN_OUT___2 = 954,
	PORT3_FN_OUT___2 = 955,
	PORT4_FN_OUT___2 = 956,
	PORT5_FN_OUT___2 = 957,
	PORT6_FN_OUT___2 = 958,
	PORT7_FN_OUT___2 = 959,
	PORT8_FN_OUT___2 = 960,
	PORT9_FN_OUT___2 = 961,
	PORT10_FN_OUT___2 = 962,
	PORT11_FN_OUT___2 = 963,
	PORT12_FN_OUT___2 = 964,
	PORT13_FN_OUT___2 = 965,
	PORT14_FN_OUT___2 = 966,
	PORT15_FN_OUT___2 = 967,
	PORT16_FN_OUT___2 = 968,
	PORT17_FN_OUT___2 = 969,
	PORT18_FN_OUT___2 = 970,
	PORT19_FN_OUT___2 = 971,
	PORT20_FN_OUT___2 = 972,
	PORT21_FN_OUT___2 = 973,
	PORT22_FN_OUT___2 = 974,
	PORT23_FN_OUT___2 = 975,
	PORT24_FN_OUT___2 = 976,
	PORT25_FN_OUT___2 = 977,
	PORT26_FN_OUT___2 = 978,
	PORT27_FN_OUT___2 = 979,
	PORT28_FN_OUT___2 = 980,
	PORT29_FN_OUT___2 = 981,
	PORT30_FN_OUT___2 = 982,
	PORT32_FN_OUT___2 = 983,
	PORT33_FN_OUT___2 = 984,
	PORT34_FN_OUT___2 = 985,
	PORT35_FN_OUT___2 = 986,
	PORT36_FN_OUT___2 = 987,
	PORT37_FN_OUT___2 = 988,
	PORT38_FN_OUT___2 = 989,
	PORT39_FN_OUT___2 = 990,
	PORT40_FN_OUT___2 = 991,
	PORT64_FN_OUT___2 = 992,
	PORT65_FN_OUT___2 = 993,
	PORT66_FN_OUT___2 = 994,
	PORT67_FN_OUT___2 = 995,
	PORT68_FN_OUT___2 = 996,
	PORT69_FN_OUT___2 = 997,
	PORT70_FN_OUT___2 = 998,
	PORT71_FN_OUT___2 = 999,
	PORT72_FN_OUT___2 = 1000,
	PORT73_FN_OUT___2 = 1001,
	PORT74_FN_OUT___2 = 1002,
	PORT75_FN_OUT___2 = 1003,
	PORT76_FN_OUT___2 = 1004,
	PORT77_FN_OUT___2 = 1005,
	PORT78_FN_OUT___2 = 1006,
	PORT79_FN_OUT___2 = 1007,
	PORT80_FN_OUT___2 = 1008,
	PORT81_FN_OUT___2 = 1009,
	PORT82_FN_OUT___2 = 1010,
	PORT83_FN_OUT___2 = 1011,
	PORT84_FN_OUT___2 = 1012,
	PORT85_FN_OUT___2 = 1013,
	PORT96_FN_OUT___2 = 1014,
	PORT97_FN_OUT___2 = 1015,
	PORT98_FN_OUT___2 = 1016,
	PORT99_FN_OUT___2 = 1017,
	PORT100_FN_OUT___2 = 1018,
	PORT101_FN_OUT___2 = 1019,
	PORT102_FN_OUT___2 = 1020,
	PORT103_FN_OUT___2 = 1021,
	PORT104_FN_OUT___2 = 1022,
	PORT105_FN_OUT___2 = 1023,
	PORT106_FN_OUT___2 = 1024,
	PORT107_FN_OUT___2 = 1025,
	PORT108_FN_OUT___2 = 1026,
	PORT109_FN_OUT___2 = 1027,
	PORT110_FN_OUT___2 = 1028,
	PORT111_FN_OUT___2 = 1029,
	PORT112_FN_OUT___2 = 1030,
	PORT113_FN_OUT___2 = 1031,
	PORT114_FN_OUT___2 = 1032,
	PORT115_FN_OUT___2 = 1033,
	PORT116_FN_OUT___2 = 1034,
	PORT117_FN_OUT___2 = 1035,
	PORT118_FN_OUT___2 = 1036,
	PORT119_FN_OUT = 1037,
	PORT120_FN_OUT = 1038,
	PORT121_FN_OUT = 1039,
	PORT122_FN_OUT = 1040,
	PORT123_FN_OUT = 1041,
	PORT124_FN_OUT = 1042,
	PORT125_FN_OUT = 1043,
	PORT126_FN_OUT = 1044,
	PORT128_FN_OUT___2 = 1045,
	PORT129_FN_OUT___2 = 1046,
	PORT130_FN_OUT___2 = 1047,
	PORT131_FN_OUT___2 = 1048,
	PORT132_FN_OUT___2 = 1049,
	PORT133_FN_OUT___2 = 1050,
	PORT134_FN_OUT___2 = 1051,
	PORT160_FN_OUT___2 = 1052,
	PORT161_FN_OUT___2 = 1053,
	PORT162_FN_OUT___2 = 1054,
	PORT163_FN_OUT___2 = 1055,
	PORT164_FN_OUT___2 = 1056,
	PORT165_FN_OUT = 1057,
	PORT166_FN_OUT = 1058,
	PORT167_FN_OUT = 1059,
	PORT168_FN_OUT = 1060,
	PORT169_FN_OUT = 1061,
	PORT170_FN_OUT = 1062,
	PORT171_FN_OUT = 1063,
	PORT172_FN_OUT = 1064,
	PORT173_FN_OUT = 1065,
	PORT174_FN_OUT = 1066,
	PORT175_FN_OUT = 1067,
	PORT176_FN_OUT = 1068,
	PORT177_FN_OUT = 1069,
	PORT178_FN_OUT = 1070,
	PORT192_FN_OUT___2 = 1071,
	PORT193_FN_OUT___2 = 1072,
	PORT194_FN_OUT___2 = 1073,
	PORT195_FN_OUT___2 = 1074,
	PORT196_FN_OUT___2 = 1075,
	PORT197_FN_OUT___2 = 1076,
	PORT198_FN_OUT___2 = 1077,
	PORT199_FN_OUT___2 = 1078,
	PORT200_FN_OUT___2 = 1079,
	PORT201_FN_OUT___2 = 1080,
	PORT202_FN_OUT___2 = 1081,
	PORT203_FN_OUT___2 = 1082,
	PORT204_FN_OUT___2 = 1083,
	PORT205_FN_OUT___2 = 1084,
	PORT206_FN_OUT___2 = 1085,
	PORT207_FN_OUT___2 = 1086,
	PORT208_FN_OUT___2 = 1087,
	PORT209_FN_OUT___2 = 1088,
	PORT210_FN_OUT___2 = 1089,
	PORT211_FN_OUT___2 = 1090,
	PORT212_FN_OUT___2 = 1091,
	PORT213_FN_OUT___2 = 1092,
	PORT214_FN_OUT___2 = 1093,
	PORT215_FN_OUT___2 = 1094,
	PORT216_FN_OUT___2 = 1095,
	PORT217_FN_OUT___2 = 1096,
	PORT218_FN_OUT___2 = 1097,
	PORT219_FN_OUT___2 = 1098,
	PORT220_FN_OUT___2 = 1099,
	PORT221_FN_OUT___2 = 1100,
	PORT222_FN_OUT___2 = 1101,
	PORT224_FN_OUT___2 = 1102,
	PORT225_FN_OUT___2 = 1103,
	PORT226_FN_OUT___2 = 1104,
	PORT227_FN_OUT___2 = 1105,
	PORT228_FN_OUT___2 = 1106,
	PORT229_FN_OUT___2 = 1107,
	PORT230_FN_OUT___2 = 1108,
	PORT231_FN_OUT___2 = 1109,
	PORT232_FN_OUT___2 = 1110,
	PORT233_FN_OUT___2 = 1111,
	PORT234_FN_OUT___2 = 1112,
	PORT235_FN_OUT___2 = 1113,
	PORT236_FN_OUT___2 = 1114,
	PORT237_FN_OUT___2 = 1115,
	PORT238_FN_OUT___2 = 1116,
	PORT239_FN_OUT___2 = 1117,
	PORT240_FN_OUT___2 = 1118,
	PORT241_FN_OUT___2 = 1119,
	PORT242_FN_OUT___2 = 1120,
	PORT243_FN_OUT___2 = 1121,
	PORT244_FN_OUT___2 = 1122,
	PORT245_FN_OUT___2 = 1123,
	PORT246_FN_OUT___2 = 1124,
	PORT247_FN_OUT___2 = 1125,
	PORT248_FN_OUT___2 = 1126,
	PORT249_FN_OUT___2 = 1127,
	PORT250_FN_OUT___2 = 1128,
	PORT256_FN_OUT___2 = 1129,
	PORT257_FN_OUT___2 = 1130,
	PORT258_FN_OUT___2 = 1131,
	PORT259_FN_OUT___2 = 1132,
	PORT260_FN_OUT___2 = 1133,
	PORT261_FN_OUT___2 = 1134,
	PORT262_FN_OUT___2 = 1135,
	PORT263_FN_OUT___2 = 1136,
	PORT264_FN_OUT___2 = 1137,
	PORT265_FN_OUT___2 = 1138,
	PORT266_FN_OUT___2 = 1139,
	PORT267_FN_OUT___2 = 1140,
	PORT268_FN_OUT___2 = 1141,
	PORT269_FN_OUT___2 = 1142,
	PORT270_FN_OUT___2 = 1143,
	PORT271_FN_OUT___2 = 1144,
	PORT272_FN_OUT___2 = 1145,
	PORT273_FN_OUT___2 = 1146,
	PORT274_FN_OUT___2 = 1147,
	PORT275_FN_OUT___2 = 1148,
	PORT276_FN_OUT___2 = 1149,
	PORT277_FN_OUT___2 = 1150,
	PORT278_FN_OUT___2 = 1151,
	PORT279_FN_OUT___2 = 1152,
	PORT280_FN_OUT___2 = 1153,
	PORT281_FN_OUT___2 = 1154,
	PORT282_FN_OUT___2 = 1155,
	PORT283_FN_OUT = 1156,
	PORT288_FN_OUT___2 = 1157,
	PORT289_FN_OUT___2 = 1158,
	PORT290_FN_OUT___2 = 1159,
	PORT291_FN_OUT___2 = 1160,
	PORT292_FN_OUT___2 = 1161,
	PORT293_FN_OUT___2 = 1162,
	PORT294_FN_OUT___2 = 1163,
	PORT295_FN_OUT___2 = 1164,
	PORT296_FN_OUT___2 = 1165,
	PORT297_FN_OUT___2 = 1166,
	PORT298_FN_OUT___2 = 1167,
	PORT299_FN_OUT___2 = 1168,
	PORT300_FN_OUT___2 = 1169,
	PORT301_FN_OUT___2 = 1170,
	PORT302_FN_OUT___2 = 1171,
	PORT303_FN_OUT___2 = 1172,
	PORT304_FN_OUT___2 = 1173,
	PORT305_FN_OUT___2 = 1174,
	PORT306_FN_OUT___2 = 1175,
	PORT307_FN_OUT___2 = 1176,
	PORT308_FN_OUT___2 = 1177,
	PORT320_FN_OUT = 1178,
	PORT321_FN_OUT = 1179,
	PORT322_FN_OUT = 1180,
	PORT323_FN_OUT = 1181,
	PORT324_FN_OUT = 1182,
	PORT325_FN_OUT = 1183,
	PORT326_FN_OUT = 1184,
	PORT327_FN_OUT = 1185,
	PORT328_FN_OUT = 1186,
	PORT329_FN_OUT = 1187,
	PORT0_FN0___2 = 1188,
	PORT1_FN0___2 = 1189,
	PORT2_FN0___2 = 1190,
	PORT3_FN0___2 = 1191,
	PORT4_FN0___2 = 1192,
	PORT5_FN0___2 = 1193,
	PORT6_FN0___2 = 1194,
	PORT7_FN0___2 = 1195,
	PORT8_FN0___2 = 1196,
	PORT9_FN0___2 = 1197,
	PORT10_FN0___2 = 1198,
	PORT11_FN0___2 = 1199,
	PORT12_FN0___2 = 1200,
	PORT13_FN0___2 = 1201,
	PORT14_FN0___2 = 1202,
	PORT15_FN0___2 = 1203,
	PORT16_FN0___2 = 1204,
	PORT17_FN0___2 = 1205,
	PORT18_FN0___2 = 1206,
	PORT19_FN0___2 = 1207,
	PORT20_FN0___2 = 1208,
	PORT21_FN0___2 = 1209,
	PORT22_FN0___2 = 1210,
	PORT23_FN0___2 = 1211,
	PORT24_FN0___2 = 1212,
	PORT25_FN0___2 = 1213,
	PORT26_FN0___2 = 1214,
	PORT27_FN0___2 = 1215,
	PORT28_FN0___2 = 1216,
	PORT29_FN0___2 = 1217,
	PORT30_FN0___2 = 1218,
	PORT32_FN0___2 = 1219,
	PORT33_FN0___2 = 1220,
	PORT34_FN0___2 = 1221,
	PORT35_FN0___2 = 1222,
	PORT36_FN0___2 = 1223,
	PORT37_FN0___2 = 1224,
	PORT38_FN0___2 = 1225,
	PORT39_FN0___2 = 1226,
	PORT40_FN0___2 = 1227,
	PORT64_FN0___2 = 1228,
	PORT65_FN0___2 = 1229,
	PORT66_FN0___2 = 1230,
	PORT67_FN0___2 = 1231,
	PORT68_FN0___2 = 1232,
	PORT69_FN0___2 = 1233,
	PORT70_FN0___2 = 1234,
	PORT71_FN0___2 = 1235,
	PORT72_FN0___2 = 1236,
	PORT73_FN0___2 = 1237,
	PORT74_FN0___2 = 1238,
	PORT75_FN0___2 = 1239,
	PORT76_FN0___2 = 1240,
	PORT77_FN0___2 = 1241,
	PORT78_FN0___2 = 1242,
	PORT79_FN0___2 = 1243,
	PORT80_FN0___2 = 1244,
	PORT81_FN0___2 = 1245,
	PORT82_FN0___2 = 1246,
	PORT83_FN0___2 = 1247,
	PORT84_FN0___2 = 1248,
	PORT85_FN0___2 = 1249,
	PORT96_FN0___2 = 1250,
	PORT97_FN0___2 = 1251,
	PORT98_FN0___2 = 1252,
	PORT99_FN0___2 = 1253,
	PORT100_FN0___2 = 1254,
	PORT101_FN0___2 = 1255,
	PORT102_FN0___2 = 1256,
	PORT103_FN0___2 = 1257,
	PORT104_FN0___2 = 1258,
	PORT105_FN0___2 = 1259,
	PORT106_FN0___2 = 1260,
	PORT107_FN0___2 = 1261,
	PORT108_FN0___2 = 1262,
	PORT109_FN0___2 = 1263,
	PORT110_FN0___2 = 1264,
	PORT111_FN0___2 = 1265,
	PORT112_FN0___2 = 1266,
	PORT113_FN0___2 = 1267,
	PORT114_FN0___2 = 1268,
	PORT115_FN0___2 = 1269,
	PORT116_FN0___2 = 1270,
	PORT117_FN0___2 = 1271,
	PORT118_FN0___2 = 1272,
	PORT119_FN0 = 1273,
	PORT120_FN0 = 1274,
	PORT121_FN0 = 1275,
	PORT122_FN0 = 1276,
	PORT123_FN0 = 1277,
	PORT124_FN0 = 1278,
	PORT125_FN0 = 1279,
	PORT126_FN0 = 1280,
	PORT128_FN0___2 = 1281,
	PORT129_FN0___2 = 1282,
	PORT130_FN0___2 = 1283,
	PORT131_FN0___2 = 1284,
	PORT132_FN0___2 = 1285,
	PORT133_FN0___2 = 1286,
	PORT134_FN0___2 = 1287,
	PORT160_FN0___2 = 1288,
	PORT161_FN0___2 = 1289,
	PORT162_FN0___2 = 1290,
	PORT163_FN0___2 = 1291,
	PORT164_FN0___2 = 1292,
	PORT165_FN0 = 1293,
	PORT166_FN0 = 1294,
	PORT167_FN0 = 1295,
	PORT168_FN0 = 1296,
	PORT169_FN0 = 1297,
	PORT170_FN0 = 1298,
	PORT171_FN0 = 1299,
	PORT172_FN0 = 1300,
	PORT173_FN0 = 1301,
	PORT174_FN0 = 1302,
	PORT175_FN0 = 1303,
	PORT176_FN0 = 1304,
	PORT177_FN0 = 1305,
	PORT178_FN0 = 1306,
	PORT192_FN0___2 = 1307,
	PORT193_FN0___2 = 1308,
	PORT194_FN0___2 = 1309,
	PORT195_FN0___2 = 1310,
	PORT196_FN0___2 = 1311,
	PORT197_FN0___2 = 1312,
	PORT198_FN0___2 = 1313,
	PORT199_FN0___2 = 1314,
	PORT200_FN0___2 = 1315,
	PORT201_FN0___2 = 1316,
	PORT202_FN0___2 = 1317,
	PORT203_FN0___2 = 1318,
	PORT204_FN0___2 = 1319,
	PORT205_FN0___2 = 1320,
	PORT206_FN0___2 = 1321,
	PORT207_FN0___2 = 1322,
	PORT208_FN0___2 = 1323,
	PORT209_FN0___2 = 1324,
	PORT210_FN0___2 = 1325,
	PORT211_FN0___2 = 1326,
	PORT212_FN0___2 = 1327,
	PORT213_FN0___2 = 1328,
	PORT214_FN0___2 = 1329,
	PORT215_FN0___2 = 1330,
	PORT216_FN0___2 = 1331,
	PORT217_FN0___2 = 1332,
	PORT218_FN0___2 = 1333,
	PORT219_FN0___2 = 1334,
	PORT220_FN0___2 = 1335,
	PORT221_FN0___2 = 1336,
	PORT222_FN0___2 = 1337,
	PORT224_FN0___2 = 1338,
	PORT225_FN0___2 = 1339,
	PORT226_FN0___2 = 1340,
	PORT227_FN0___2 = 1341,
	PORT228_FN0___2 = 1342,
	PORT229_FN0___2 = 1343,
	PORT230_FN0___2 = 1344,
	PORT231_FN0___2 = 1345,
	PORT232_FN0___2 = 1346,
	PORT233_FN0___2 = 1347,
	PORT234_FN0___2 = 1348,
	PORT235_FN0___2 = 1349,
	PORT236_FN0___2 = 1350,
	PORT237_FN0___2 = 1351,
	PORT238_FN0___2 = 1352,
	PORT239_FN0___2 = 1353,
	PORT240_FN0___2 = 1354,
	PORT241_FN0___2 = 1355,
	PORT242_FN0___2 = 1356,
	PORT243_FN0___2 = 1357,
	PORT244_FN0___2 = 1358,
	PORT245_FN0___2 = 1359,
	PORT246_FN0___2 = 1360,
	PORT247_FN0___2 = 1361,
	PORT248_FN0___2 = 1362,
	PORT249_FN0___2 = 1363,
	PORT250_FN0___2 = 1364,
	PORT256_FN0___2 = 1365,
	PORT257_FN0___2 = 1366,
	PORT258_FN0___2 = 1367,
	PORT259_FN0___2 = 1368,
	PORT260_FN0___2 = 1369,
	PORT261_FN0___2 = 1370,
	PORT262_FN0___2 = 1371,
	PORT263_FN0___2 = 1372,
	PORT264_FN0___2 = 1373,
	PORT265_FN0___2 = 1374,
	PORT266_FN0___2 = 1375,
	PORT267_FN0___2 = 1376,
	PORT268_FN0___2 = 1377,
	PORT269_FN0___2 = 1378,
	PORT270_FN0___2 = 1379,
	PORT271_FN0___2 = 1380,
	PORT272_FN0___2 = 1381,
	PORT273_FN0___2 = 1382,
	PORT274_FN0___2 = 1383,
	PORT275_FN0___2 = 1384,
	PORT276_FN0___2 = 1385,
	PORT277_FN0___2 = 1386,
	PORT278_FN0___2 = 1387,
	PORT279_FN0___2 = 1388,
	PORT280_FN0___2 = 1389,
	PORT281_FN0___2 = 1390,
	PORT282_FN0___2 = 1391,
	PORT283_FN0 = 1392,
	PORT288_FN0___2 = 1393,
	PORT289_FN0___2 = 1394,
	PORT290_FN0___2 = 1395,
	PORT291_FN0___2 = 1396,
	PORT292_FN0___2 = 1397,
	PORT293_FN0___2 = 1398,
	PORT294_FN0___2 = 1399,
	PORT295_FN0___2 = 1400,
	PORT296_FN0___2 = 1401,
	PORT297_FN0___2 = 1402,
	PORT298_FN0___2 = 1403,
	PORT299_FN0___2 = 1404,
	PORT300_FN0___2 = 1405,
	PORT301_FN0___2 = 1406,
	PORT302_FN0___2 = 1407,
	PORT303_FN0___2 = 1408,
	PORT304_FN0___2 = 1409,
	PORT305_FN0___2 = 1410,
	PORT306_FN0___2 = 1411,
	PORT307_FN0___2 = 1412,
	PORT308_FN0___2 = 1413,
	PORT320_FN0 = 1414,
	PORT321_FN0 = 1415,
	PORT322_FN0 = 1416,
	PORT323_FN0 = 1417,
	PORT324_FN0 = 1418,
	PORT325_FN0 = 1419,
	PORT326_FN0 = 1420,
	PORT327_FN0 = 1421,
	PORT328_FN0 = 1422,
	PORT329_FN0 = 1423,
	PORT0_FN1___2 = 1424,
	PORT1_FN1___2 = 1425,
	PORT2_FN1___2 = 1426,
	PORT3_FN1___2 = 1427,
	PORT4_FN1___2 = 1428,
	PORT5_FN1___2 = 1429,
	PORT6_FN1___2 = 1430,
	PORT7_FN1___2 = 1431,
	PORT8_FN1___2 = 1432,
	PORT9_FN1___2 = 1433,
	PORT10_FN1___2 = 1434,
	PORT11_FN1___2 = 1435,
	PORT12_FN1___2 = 1436,
	PORT13_FN1___2 = 1437,
	PORT14_FN1___2 = 1438,
	PORT15_FN1___2 = 1439,
	PORT16_FN1___2 = 1440,
	PORT17_FN1___2 = 1441,
	PORT18_FN1___2 = 1442,
	PORT19_FN1___2 = 1443,
	PORT20_FN1___2 = 1444,
	PORT21_FN1___2 = 1445,
	PORT22_FN1___2 = 1446,
	PORT23_FN1___2 = 1447,
	PORT24_FN1___2 = 1448,
	PORT25_FN1___2 = 1449,
	PORT26_FN1___2 = 1450,
	PORT27_FN1___2 = 1451,
	PORT28_FN1___2 = 1452,
	PORT29_FN1___2 = 1453,
	PORT30_FN1___2 = 1454,
	PORT32_FN1___2 = 1455,
	PORT33_FN1___2 = 1456,
	PORT34_FN1___2 = 1457,
	PORT35_FN1___2 = 1458,
	PORT36_FN1___2 = 1459,
	PORT37_FN1___2 = 1460,
	PORT38_FN1___2 = 1461,
	PORT39_FN1___2 = 1462,
	PORT40_FN1___2 = 1463,
	PORT64_FN1___2 = 1464,
	PORT65_FN1___2 = 1465,
	PORT66_FN1___2 = 1466,
	PORT67_FN1___2 = 1467,
	PORT68_FN1___2 = 1468,
	PORT69_FN1___2 = 1469,
	PORT70_FN1___2 = 1470,
	PORT71_FN1___2 = 1471,
	PORT72_FN1___2 = 1472,
	PORT73_FN1___2 = 1473,
	PORT74_FN1___2 = 1474,
	PORT75_FN1___2 = 1475,
	PORT76_FN1___2 = 1476,
	PORT77_FN1___2 = 1477,
	PORT78_FN1___2 = 1478,
	PORT79_FN1___2 = 1479,
	PORT80_FN1___2 = 1480,
	PORT81_FN1___2 = 1481,
	PORT82_FN1___2 = 1482,
	PORT83_FN1___2 = 1483,
	PORT84_FN1___2 = 1484,
	PORT85_FN1___2 = 1485,
	PORT96_FN1___2 = 1486,
	PORT97_FN1___2 = 1487,
	PORT98_FN1___2 = 1488,
	PORT99_FN1___2 = 1489,
	PORT100_FN1___2 = 1490,
	PORT101_FN1___2 = 1491,
	PORT102_FN1___2 = 1492,
	PORT103_FN1___2 = 1493,
	PORT104_FN1___2 = 1494,
	PORT105_FN1___2 = 1495,
	PORT106_FN1___2 = 1496,
	PORT107_FN1___2 = 1497,
	PORT108_FN1___2 = 1498,
	PORT109_FN1___2 = 1499,
	PORT110_FN1___2 = 1500,
	PORT111_FN1___2 = 1501,
	PORT112_FN1___2 = 1502,
	PORT113_FN1___2 = 1503,
	PORT114_FN1___2 = 1504,
	PORT115_FN1___2 = 1505,
	PORT116_FN1___2 = 1506,
	PORT117_FN1___2 = 1507,
	PORT118_FN1___2 = 1508,
	PORT119_FN1 = 1509,
	PORT120_FN1 = 1510,
	PORT121_FN1 = 1511,
	PORT122_FN1 = 1512,
	PORT123_FN1 = 1513,
	PORT124_FN1 = 1514,
	PORT125_FN1 = 1515,
	PORT126_FN1 = 1516,
	PORT128_FN1___2 = 1517,
	PORT129_FN1___2 = 1518,
	PORT130_FN1___2 = 1519,
	PORT131_FN1___2 = 1520,
	PORT132_FN1___2 = 1521,
	PORT133_FN1___2 = 1522,
	PORT134_FN1___2 = 1523,
	PORT160_FN1___2 = 1524,
	PORT161_FN1___2 = 1525,
	PORT162_FN1___2 = 1526,
	PORT163_FN1___2 = 1527,
	PORT164_FN1___2 = 1528,
	PORT165_FN1 = 1529,
	PORT166_FN1 = 1530,
	PORT167_FN1 = 1531,
	PORT168_FN1 = 1532,
	PORT169_FN1 = 1533,
	PORT170_FN1 = 1534,
	PORT171_FN1 = 1535,
	PORT172_FN1 = 1536,
	PORT173_FN1 = 1537,
	PORT174_FN1 = 1538,
	PORT175_FN1 = 1539,
	PORT176_FN1 = 1540,
	PORT177_FN1 = 1541,
	PORT178_FN1 = 1542,
	PORT192_FN1___2 = 1543,
	PORT193_FN1___2 = 1544,
	PORT194_FN1___2 = 1545,
	PORT195_FN1___2 = 1546,
	PORT196_FN1___2 = 1547,
	PORT197_FN1___2 = 1548,
	PORT198_FN1___2 = 1549,
	PORT199_FN1___2 = 1550,
	PORT200_FN1___2 = 1551,
	PORT201_FN1___2 = 1552,
	PORT202_FN1___2 = 1553,
	PORT203_FN1___2 = 1554,
	PORT204_FN1___2 = 1555,
	PORT205_FN1___2 = 1556,
	PORT206_FN1___2 = 1557,
	PORT207_FN1___2 = 1558,
	PORT208_FN1___2 = 1559,
	PORT209_FN1___2 = 1560,
	PORT210_FN1___2 = 1561,
	PORT211_FN1___2 = 1562,
	PORT212_FN1___2 = 1563,
	PORT213_FN1___2 = 1564,
	PORT214_FN1___2 = 1565,
	PORT215_FN1___2 = 1566,
	PORT216_FN1___2 = 1567,
	PORT217_FN1___2 = 1568,
	PORT218_FN1___2 = 1569,
	PORT219_FN1___2 = 1570,
	PORT220_FN1___2 = 1571,
	PORT221_FN1___2 = 1572,
	PORT222_FN1___2 = 1573,
	PORT224_FN1___2 = 1574,
	PORT225_FN1___2 = 1575,
	PORT226_FN1___2 = 1576,
	PORT227_FN1___2 = 1577,
	PORT228_FN1___2 = 1578,
	PORT229_FN1___2 = 1579,
	PORT230_FN1___2 = 1580,
	PORT231_FN1___2 = 1581,
	PORT232_FN1___2 = 1582,
	PORT233_FN1___2 = 1583,
	PORT234_FN1___2 = 1584,
	PORT235_FN1___2 = 1585,
	PORT236_FN1___2 = 1586,
	PORT237_FN1___2 = 1587,
	PORT238_FN1___2 = 1588,
	PORT239_FN1___2 = 1589,
	PORT240_FN1___2 = 1590,
	PORT241_FN1___2 = 1591,
	PORT242_FN1___2 = 1592,
	PORT243_FN1___2 = 1593,
	PORT244_FN1___2 = 1594,
	PORT245_FN1___2 = 1595,
	PORT246_FN1___2 = 1596,
	PORT247_FN1___2 = 1597,
	PORT248_FN1___2 = 1598,
	PORT249_FN1___2 = 1599,
	PORT250_FN1___2 = 1600,
	PORT256_FN1___2 = 1601,
	PORT257_FN1___2 = 1602,
	PORT258_FN1___2 = 1603,
	PORT259_FN1___2 = 1604,
	PORT260_FN1___2 = 1605,
	PORT261_FN1___2 = 1606,
	PORT262_FN1___2 = 1607,
	PORT263_FN1___2 = 1608,
	PORT264_FN1___2 = 1609,
	PORT265_FN1___2 = 1610,
	PORT266_FN1___2 = 1611,
	PORT267_FN1___2 = 1612,
	PORT268_FN1___2 = 1613,
	PORT269_FN1___2 = 1614,
	PORT270_FN1___2 = 1615,
	PORT271_FN1___2 = 1616,
	PORT272_FN1___2 = 1617,
	PORT273_FN1___2 = 1618,
	PORT274_FN1___2 = 1619,
	PORT275_FN1___2 = 1620,
	PORT276_FN1___2 = 1621,
	PORT277_FN1___2 = 1622,
	PORT278_FN1___2 = 1623,
	PORT279_FN1___2 = 1624,
	PORT280_FN1___2 = 1625,
	PORT281_FN1___2 = 1626,
	PORT282_FN1___2 = 1627,
	PORT283_FN1 = 1628,
	PORT288_FN1___2 = 1629,
	PORT289_FN1___2 = 1630,
	PORT290_FN1___2 = 1631,
	PORT291_FN1___2 = 1632,
	PORT292_FN1___2 = 1633,
	PORT293_FN1___2 = 1634,
	PORT294_FN1___2 = 1635,
	PORT295_FN1___2 = 1636,
	PORT296_FN1___2 = 1637,
	PORT297_FN1___2 = 1638,
	PORT298_FN1___2 = 1639,
	PORT299_FN1___2 = 1640,
	PORT300_FN1___2 = 1641,
	PORT301_FN1___2 = 1642,
	PORT302_FN1___2 = 1643,
	PORT303_FN1___2 = 1644,
	PORT304_FN1___2 = 1645,
	PORT305_FN1___2 = 1646,
	PORT306_FN1___2 = 1647,
	PORT307_FN1___2 = 1648,
	PORT308_FN1___2 = 1649,
	PORT320_FN1 = 1650,
	PORT321_FN1 = 1651,
	PORT322_FN1 = 1652,
	PORT323_FN1 = 1653,
	PORT324_FN1 = 1654,
	PORT325_FN1 = 1655,
	PORT326_FN1 = 1656,
	PORT327_FN1 = 1657,
	PORT328_FN1 = 1658,
	PORT329_FN1 = 1659,
	PORT0_FN2___2 = 1660,
	PORT1_FN2___2 = 1661,
	PORT2_FN2___2 = 1662,
	PORT3_FN2___2 = 1663,
	PORT4_FN2___2 = 1664,
	PORT5_FN2___2 = 1665,
	PORT6_FN2___2 = 1666,
	PORT7_FN2___2 = 1667,
	PORT8_FN2___2 = 1668,
	PORT9_FN2___2 = 1669,
	PORT10_FN2___2 = 1670,
	PORT11_FN2___2 = 1671,
	PORT12_FN2___2 = 1672,
	PORT13_FN2___2 = 1673,
	PORT14_FN2___2 = 1674,
	PORT15_FN2___2 = 1675,
	PORT16_FN2___2 = 1676,
	PORT17_FN2___2 = 1677,
	PORT18_FN2___2 = 1678,
	PORT19_FN2___2 = 1679,
	PORT20_FN2___2 = 1680,
	PORT21_FN2___2 = 1681,
	PORT22_FN2___2 = 1682,
	PORT23_FN2___2 = 1683,
	PORT24_FN2___2 = 1684,
	PORT25_FN2___2 = 1685,
	PORT26_FN2___2 = 1686,
	PORT27_FN2___2 = 1687,
	PORT28_FN2___2 = 1688,
	PORT29_FN2___2 = 1689,
	PORT30_FN2___2 = 1690,
	PORT32_FN2___2 = 1691,
	PORT33_FN2___2 = 1692,
	PORT34_FN2___2 = 1693,
	PORT35_FN2___2 = 1694,
	PORT36_FN2___2 = 1695,
	PORT37_FN2___2 = 1696,
	PORT38_FN2___2 = 1697,
	PORT39_FN2___2 = 1698,
	PORT40_FN2___2 = 1699,
	PORT64_FN2___2 = 1700,
	PORT65_FN2___2 = 1701,
	PORT66_FN2___2 = 1702,
	PORT67_FN2___2 = 1703,
	PORT68_FN2___2 = 1704,
	PORT69_FN2___2 = 1705,
	PORT70_FN2___2 = 1706,
	PORT71_FN2___2 = 1707,
	PORT72_FN2___2 = 1708,
	PORT73_FN2___2 = 1709,
	PORT74_FN2___2 = 1710,
	PORT75_FN2___2 = 1711,
	PORT76_FN2___2 = 1712,
	PORT77_FN2___2 = 1713,
	PORT78_FN2___2 = 1714,
	PORT79_FN2___2 = 1715,
	PORT80_FN2___2 = 1716,
	PORT81_FN2___2 = 1717,
	PORT82_FN2___2 = 1718,
	PORT83_FN2___2 = 1719,
	PORT84_FN2___2 = 1720,
	PORT85_FN2___2 = 1721,
	PORT96_FN2___2 = 1722,
	PORT97_FN2___2 = 1723,
	PORT98_FN2___2 = 1724,
	PORT99_FN2___2 = 1725,
	PORT100_FN2___2 = 1726,
	PORT101_FN2___2 = 1727,
	PORT102_FN2___2 = 1728,
	PORT103_FN2___2 = 1729,
	PORT104_FN2___2 = 1730,
	PORT105_FN2___2 = 1731,
	PORT106_FN2___2 = 1732,
	PORT107_FN2___2 = 1733,
	PORT108_FN2___2 = 1734,
	PORT109_FN2___2 = 1735,
	PORT110_FN2___2 = 1736,
	PORT111_FN2___2 = 1737,
	PORT112_FN2___2 = 1738,
	PORT113_FN2___2 = 1739,
	PORT114_FN2___2 = 1740,
	PORT115_FN2___2 = 1741,
	PORT116_FN2___2 = 1742,
	PORT117_FN2___2 = 1743,
	PORT118_FN2___2 = 1744,
	PORT119_FN2 = 1745,
	PORT120_FN2 = 1746,
	PORT121_FN2 = 1747,
	PORT122_FN2 = 1748,
	PORT123_FN2 = 1749,
	PORT124_FN2 = 1750,
	PORT125_FN2 = 1751,
	PORT126_FN2 = 1752,
	PORT128_FN2___2 = 1753,
	PORT129_FN2___2 = 1754,
	PORT130_FN2___2 = 1755,
	PORT131_FN2___2 = 1756,
	PORT132_FN2___2 = 1757,
	PORT133_FN2___2 = 1758,
	PORT134_FN2___2 = 1759,
	PORT160_FN2___2 = 1760,
	PORT161_FN2___2 = 1761,
	PORT162_FN2___2 = 1762,
	PORT163_FN2___2 = 1763,
	PORT164_FN2___2 = 1764,
	PORT165_FN2 = 1765,
	PORT166_FN2 = 1766,
	PORT167_FN2 = 1767,
	PORT168_FN2 = 1768,
	PORT169_FN2 = 1769,
	PORT170_FN2 = 1770,
	PORT171_FN2 = 1771,
	PORT172_FN2 = 1772,
	PORT173_FN2 = 1773,
	PORT174_FN2 = 1774,
	PORT175_FN2 = 1775,
	PORT176_FN2 = 1776,
	PORT177_FN2 = 1777,
	PORT178_FN2 = 1778,
	PORT192_FN2___2 = 1779,
	PORT193_FN2___2 = 1780,
	PORT194_FN2___2 = 1781,
	PORT195_FN2___2 = 1782,
	PORT196_FN2___2 = 1783,
	PORT197_FN2___2 = 1784,
	PORT198_FN2___2 = 1785,
	PORT199_FN2___2 = 1786,
	PORT200_FN2___2 = 1787,
	PORT201_FN2___2 = 1788,
	PORT202_FN2___2 = 1789,
	PORT203_FN2___2 = 1790,
	PORT204_FN2___2 = 1791,
	PORT205_FN2___2 = 1792,
	PORT206_FN2___2 = 1793,
	PORT207_FN2___2 = 1794,
	PORT208_FN2___2 = 1795,
	PORT209_FN2___2 = 1796,
	PORT210_FN2___2 = 1797,
	PORT211_FN2___2 = 1798,
	PORT212_FN2___2 = 1799,
	PORT213_FN2___2 = 1800,
	PORT214_FN2___2 = 1801,
	PORT215_FN2___2 = 1802,
	PORT216_FN2___2 = 1803,
	PORT217_FN2___2 = 1804,
	PORT218_FN2___2 = 1805,
	PORT219_FN2___2 = 1806,
	PORT220_FN2___2 = 1807,
	PORT221_FN2___2 = 1808,
	PORT222_FN2___2 = 1809,
	PORT224_FN2___2 = 1810,
	PORT225_FN2___2 = 1811,
	PORT226_FN2___2 = 1812,
	PORT227_FN2___2 = 1813,
	PORT228_FN2___2 = 1814,
	PORT229_FN2___2 = 1815,
	PORT230_FN2___2 = 1816,
	PORT231_FN2___2 = 1817,
	PORT232_FN2___2 = 1818,
	PORT233_FN2___2 = 1819,
	PORT234_FN2___2 = 1820,
	PORT235_FN2___2 = 1821,
	PORT236_FN2___2 = 1822,
	PORT237_FN2___2 = 1823,
	PORT238_FN2___2 = 1824,
	PORT239_FN2___2 = 1825,
	PORT240_FN2___2 = 1826,
	PORT241_FN2___2 = 1827,
	PORT242_FN2___2 = 1828,
	PORT243_FN2___2 = 1829,
	PORT244_FN2___2 = 1830,
	PORT245_FN2___2 = 1831,
	PORT246_FN2___2 = 1832,
	PORT247_FN2___2 = 1833,
	PORT248_FN2___2 = 1834,
	PORT249_FN2___2 = 1835,
	PORT250_FN2___2 = 1836,
	PORT256_FN2___2 = 1837,
	PORT257_FN2___2 = 1838,
	PORT258_FN2___2 = 1839,
	PORT259_FN2___2 = 1840,
	PORT260_FN2___2 = 1841,
	PORT261_FN2___2 = 1842,
	PORT262_FN2___2 = 1843,
	PORT263_FN2___2 = 1844,
	PORT264_FN2___2 = 1845,
	PORT265_FN2___2 = 1846,
	PORT266_FN2___2 = 1847,
	PORT267_FN2___2 = 1848,
	PORT268_FN2___2 = 1849,
	PORT269_FN2___2 = 1850,
	PORT270_FN2___2 = 1851,
	PORT271_FN2___2 = 1852,
	PORT272_FN2___2 = 1853,
	PORT273_FN2___2 = 1854,
	PORT274_FN2___2 = 1855,
	PORT275_FN2___2 = 1856,
	PORT276_FN2___2 = 1857,
	PORT277_FN2___2 = 1858,
	PORT278_FN2___2 = 1859,
	PORT279_FN2___2 = 1860,
	PORT280_FN2___2 = 1861,
	PORT281_FN2___2 = 1862,
	PORT282_FN2___2 = 1863,
	PORT283_FN2 = 1864,
	PORT288_FN2___2 = 1865,
	PORT289_FN2___2 = 1866,
	PORT290_FN2___2 = 1867,
	PORT291_FN2___2 = 1868,
	PORT292_FN2___2 = 1869,
	PORT293_FN2___2 = 1870,
	PORT294_FN2___2 = 1871,
	PORT295_FN2___2 = 1872,
	PORT296_FN2___2 = 1873,
	PORT297_FN2___2 = 1874,
	PORT298_FN2___2 = 1875,
	PORT299_FN2___2 = 1876,
	PORT300_FN2___2 = 1877,
	PORT301_FN2___2 = 1878,
	PORT302_FN2___2 = 1879,
	PORT303_FN2___2 = 1880,
	PORT304_FN2___2 = 1881,
	PORT305_FN2___2 = 1882,
	PORT306_FN2___2 = 1883,
	PORT307_FN2___2 = 1884,
	PORT308_FN2___2 = 1885,
	PORT320_FN2 = 1886,
	PORT321_FN2 = 1887,
	PORT322_FN2 = 1888,
	PORT323_FN2 = 1889,
	PORT324_FN2 = 1890,
	PORT325_FN2 = 1891,
	PORT326_FN2 = 1892,
	PORT327_FN2 = 1893,
	PORT328_FN2 = 1894,
	PORT329_FN2 = 1895,
	PORT0_FN3___2 = 1896,
	PORT1_FN3___2 = 1897,
	PORT2_FN3___2 = 1898,
	PORT3_FN3___2 = 1899,
	PORT4_FN3___2 = 1900,
	PORT5_FN3___2 = 1901,
	PORT6_FN3___2 = 1902,
	PORT7_FN3___2 = 1903,
	PORT8_FN3___2 = 1904,
	PORT9_FN3___2 = 1905,
	PORT10_FN3___2 = 1906,
	PORT11_FN3___2 = 1907,
	PORT12_FN3___2 = 1908,
	PORT13_FN3___2 = 1909,
	PORT14_FN3___2 = 1910,
	PORT15_FN3___2 = 1911,
	PORT16_FN3___2 = 1912,
	PORT17_FN3___2 = 1913,
	PORT18_FN3___2 = 1914,
	PORT19_FN3___2 = 1915,
	PORT20_FN3___2 = 1916,
	PORT21_FN3___2 = 1917,
	PORT22_FN3___2 = 1918,
	PORT23_FN3___2 = 1919,
	PORT24_FN3___2 = 1920,
	PORT25_FN3___2 = 1921,
	PORT26_FN3___2 = 1922,
	PORT27_FN3___2 = 1923,
	PORT28_FN3___2 = 1924,
	PORT29_FN3___2 = 1925,
	PORT30_FN3___2 = 1926,
	PORT32_FN3___2 = 1927,
	PORT33_FN3___2 = 1928,
	PORT34_FN3___2 = 1929,
	PORT35_FN3___2 = 1930,
	PORT36_FN3___2 = 1931,
	PORT37_FN3___2 = 1932,
	PORT38_FN3___2 = 1933,
	PORT39_FN3___2 = 1934,
	PORT40_FN3___2 = 1935,
	PORT64_FN3___2 = 1936,
	PORT65_FN3___2 = 1937,
	PORT66_FN3___2 = 1938,
	PORT67_FN3___2 = 1939,
	PORT68_FN3___2 = 1940,
	PORT69_FN3___2 = 1941,
	PORT70_FN3___2 = 1942,
	PORT71_FN3___2 = 1943,
	PORT72_FN3___2 = 1944,
	PORT73_FN3___2 = 1945,
	PORT74_FN3___2 = 1946,
	PORT75_FN3___2 = 1947,
	PORT76_FN3___2 = 1948,
	PORT77_FN3___2 = 1949,
	PORT78_FN3___2 = 1950,
	PORT79_FN3___2 = 1951,
	PORT80_FN3___2 = 1952,
	PORT81_FN3___2 = 1953,
	PORT82_FN3___2 = 1954,
	PORT83_FN3___2 = 1955,
	PORT84_FN3___2 = 1956,
	PORT85_FN3___2 = 1957,
	PORT96_FN3___2 = 1958,
	PORT97_FN3___2 = 1959,
	PORT98_FN3___2 = 1960,
	PORT99_FN3___2 = 1961,
	PORT100_FN3___2 = 1962,
	PORT101_FN3___2 = 1963,
	PORT102_FN3___2 = 1964,
	PORT103_FN3___2 = 1965,
	PORT104_FN3___2 = 1966,
	PORT105_FN3___2 = 1967,
	PORT106_FN3___2 = 1968,
	PORT107_FN3___2 = 1969,
	PORT108_FN3___2 = 1970,
	PORT109_FN3___2 = 1971,
	PORT110_FN3___2 = 1972,
	PORT111_FN3___2 = 1973,
	PORT112_FN3___2 = 1974,
	PORT113_FN3___2 = 1975,
	PORT114_FN3___2 = 1976,
	PORT115_FN3___2 = 1977,
	PORT116_FN3___2 = 1978,
	PORT117_FN3___2 = 1979,
	PORT118_FN3___2 = 1980,
	PORT119_FN3 = 1981,
	PORT120_FN3 = 1982,
	PORT121_FN3 = 1983,
	PORT122_FN3 = 1984,
	PORT123_FN3 = 1985,
	PORT124_FN3 = 1986,
	PORT125_FN3 = 1987,
	PORT126_FN3 = 1988,
	PORT128_FN3___2 = 1989,
	PORT129_FN3___2 = 1990,
	PORT130_FN3___2 = 1991,
	PORT131_FN3___2 = 1992,
	PORT132_FN3___2 = 1993,
	PORT133_FN3___2 = 1994,
	PORT134_FN3___2 = 1995,
	PORT160_FN3___2 = 1996,
	PORT161_FN3___2 = 1997,
	PORT162_FN3___2 = 1998,
	PORT163_FN3___2 = 1999,
	PORT164_FN3___2 = 2000,
	PORT165_FN3 = 2001,
	PORT166_FN3 = 2002,
	PORT167_FN3 = 2003,
	PORT168_FN3 = 2004,
	PORT169_FN3 = 2005,
	PORT170_FN3 = 2006,
	PORT171_FN3 = 2007,
	PORT172_FN3 = 2008,
	PORT173_FN3 = 2009,
	PORT174_FN3 = 2010,
	PORT175_FN3 = 2011,
	PORT176_FN3 = 2012,
	PORT177_FN3 = 2013,
	PORT178_FN3 = 2014,
	PORT192_FN3___2 = 2015,
	PORT193_FN3___2 = 2016,
	PORT194_FN3___2 = 2017,
	PORT195_FN3___2 = 2018,
	PORT196_FN3___2 = 2019,
	PORT197_FN3___2 = 2020,
	PORT198_FN3___2 = 2021,
	PORT199_FN3___2 = 2022,
	PORT200_FN3___2 = 2023,
	PORT201_FN3___2 = 2024,
	PORT202_FN3___2 = 2025,
	PORT203_FN3___2 = 2026,
	PORT204_FN3___2 = 2027,
	PORT205_FN3___2 = 2028,
	PORT206_FN3___2 = 2029,
	PORT207_FN3___2 = 2030,
	PORT208_FN3___2 = 2031,
	PORT209_FN3___2 = 2032,
	PORT210_FN3___2 = 2033,
	PORT211_FN3___2 = 2034,
	PORT212_FN3___2 = 2035,
	PORT213_FN3___2 = 2036,
	PORT214_FN3___2 = 2037,
	PORT215_FN3___2 = 2038,
	PORT216_FN3___2 = 2039,
	PORT217_FN3___2 = 2040,
	PORT218_FN3___2 = 2041,
	PORT219_FN3___2 = 2042,
	PORT220_FN3___2 = 2043,
	PORT221_FN3___2 = 2044,
	PORT222_FN3___2 = 2045,
	PORT224_FN3___2 = 2046,
	PORT225_FN3___2 = 2047,
	PORT226_FN3___2 = 2048,
	PORT227_FN3___2 = 2049,
	PORT228_FN3___2 = 2050,
	PORT229_FN3___2 = 2051,
	PORT230_FN3___2 = 2052,
	PORT231_FN3___2 = 2053,
	PORT232_FN3___2 = 2054,
	PORT233_FN3___2 = 2055,
	PORT234_FN3___2 = 2056,
	PORT235_FN3___2 = 2057,
	PORT236_FN3___2 = 2058,
	PORT237_FN3___2 = 2059,
	PORT238_FN3___2 = 2060,
	PORT239_FN3___2 = 2061,
	PORT240_FN3___2 = 2062,
	PORT241_FN3___2 = 2063,
	PORT242_FN3___2 = 2064,
	PORT243_FN3___2 = 2065,
	PORT244_FN3___2 = 2066,
	PORT245_FN3___2 = 2067,
	PORT246_FN3___2 = 2068,
	PORT247_FN3___2 = 2069,
	PORT248_FN3___2 = 2070,
	PORT249_FN3___2 = 2071,
	PORT250_FN3___2 = 2072,
	PORT256_FN3___2 = 2073,
	PORT257_FN3___2 = 2074,
	PORT258_FN3___2 = 2075,
	PORT259_FN3___2 = 2076,
	PORT260_FN3___2 = 2077,
	PORT261_FN3___2 = 2078,
	PORT262_FN3___2 = 2079,
	PORT263_FN3___2 = 2080,
	PORT264_FN3___2 = 2081,
	PORT265_FN3___2 = 2082,
	PORT266_FN3___2 = 2083,
	PORT267_FN3___2 = 2084,
	PORT268_FN3___2 = 2085,
	PORT269_FN3___2 = 2086,
	PORT270_FN3___2 = 2087,
	PORT271_FN3___2 = 2088,
	PORT272_FN3___2 = 2089,
	PORT273_FN3___2 = 2090,
	PORT274_FN3___2 = 2091,
	PORT275_FN3___2 = 2092,
	PORT276_FN3___2 = 2093,
	PORT277_FN3___2 = 2094,
	PORT278_FN3___2 = 2095,
	PORT279_FN3___2 = 2096,
	PORT280_FN3___2 = 2097,
	PORT281_FN3___2 = 2098,
	PORT282_FN3___2 = 2099,
	PORT283_FN3 = 2100,
	PORT288_FN3___2 = 2101,
	PORT289_FN3___2 = 2102,
	PORT290_FN3___2 = 2103,
	PORT291_FN3___2 = 2104,
	PORT292_FN3___2 = 2105,
	PORT293_FN3___2 = 2106,
	PORT294_FN3___2 = 2107,
	PORT295_FN3___2 = 2108,
	PORT296_FN3___2 = 2109,
	PORT297_FN3___2 = 2110,
	PORT298_FN3___2 = 2111,
	PORT299_FN3___2 = 2112,
	PORT300_FN3___2 = 2113,
	PORT301_FN3___2 = 2114,
	PORT302_FN3___2 = 2115,
	PORT303_FN3___2 = 2116,
	PORT304_FN3___2 = 2117,
	PORT305_FN3___2 = 2118,
	PORT306_FN3___2 = 2119,
	PORT307_FN3___2 = 2120,
	PORT308_FN3___2 = 2121,
	PORT320_FN3 = 2122,
	PORT321_FN3 = 2123,
	PORT322_FN3 = 2124,
	PORT323_FN3 = 2125,
	PORT324_FN3 = 2126,
	PORT325_FN3 = 2127,
	PORT326_FN3 = 2128,
	PORT327_FN3 = 2129,
	PORT328_FN3 = 2130,
	PORT329_FN3 = 2131,
	PORT0_FN4___2 = 2132,
	PORT1_FN4___2 = 2133,
	PORT2_FN4___2 = 2134,
	PORT3_FN4___2 = 2135,
	PORT4_FN4___2 = 2136,
	PORT5_FN4___2 = 2137,
	PORT6_FN4___2 = 2138,
	PORT7_FN4___2 = 2139,
	PORT8_FN4___2 = 2140,
	PORT9_FN4___2 = 2141,
	PORT10_FN4___2 = 2142,
	PORT11_FN4___2 = 2143,
	PORT12_FN4___2 = 2144,
	PORT13_FN4___2 = 2145,
	PORT14_FN4___2 = 2146,
	PORT15_FN4___2 = 2147,
	PORT16_FN4___2 = 2148,
	PORT17_FN4___2 = 2149,
	PORT18_FN4___2 = 2150,
	PORT19_FN4___2 = 2151,
	PORT20_FN4___2 = 2152,
	PORT21_FN4___2 = 2153,
	PORT22_FN4___2 = 2154,
	PORT23_FN4___2 = 2155,
	PORT24_FN4___2 = 2156,
	PORT25_FN4___2 = 2157,
	PORT26_FN4___2 = 2158,
	PORT27_FN4___2 = 2159,
	PORT28_FN4___2 = 2160,
	PORT29_FN4___2 = 2161,
	PORT30_FN4___2 = 2162,
	PORT32_FN4___2 = 2163,
	PORT33_FN4___2 = 2164,
	PORT34_FN4___2 = 2165,
	PORT35_FN4___2 = 2166,
	PORT36_FN4___2 = 2167,
	PORT37_FN4___2 = 2168,
	PORT38_FN4___2 = 2169,
	PORT39_FN4___2 = 2170,
	PORT40_FN4___2 = 2171,
	PORT64_FN4___2 = 2172,
	PORT65_FN4___2 = 2173,
	PORT66_FN4___2 = 2174,
	PORT67_FN4___2 = 2175,
	PORT68_FN4___2 = 2176,
	PORT69_FN4___2 = 2177,
	PORT70_FN4___2 = 2178,
	PORT71_FN4___2 = 2179,
	PORT72_FN4___2 = 2180,
	PORT73_FN4___2 = 2181,
	PORT74_FN4___2 = 2182,
	PORT75_FN4___2 = 2183,
	PORT76_FN4___2 = 2184,
	PORT77_FN4___2 = 2185,
	PORT78_FN4___2 = 2186,
	PORT79_FN4___2 = 2187,
	PORT80_FN4___2 = 2188,
	PORT81_FN4___2 = 2189,
	PORT82_FN4___2 = 2190,
	PORT83_FN4___2 = 2191,
	PORT84_FN4___2 = 2192,
	PORT85_FN4___2 = 2193,
	PORT96_FN4___2 = 2194,
	PORT97_FN4___2 = 2195,
	PORT98_FN4___2 = 2196,
	PORT99_FN4___2 = 2197,
	PORT100_FN4___2 = 2198,
	PORT101_FN4___2 = 2199,
	PORT102_FN4___2 = 2200,
	PORT103_FN4___2 = 2201,
	PORT104_FN4___2 = 2202,
	PORT105_FN4___2 = 2203,
	PORT106_FN4___2 = 2204,
	PORT107_FN4___2 = 2205,
	PORT108_FN4___2 = 2206,
	PORT109_FN4___2 = 2207,
	PORT110_FN4___2 = 2208,
	PORT111_FN4___2 = 2209,
	PORT112_FN4___2 = 2210,
	PORT113_FN4___2 = 2211,
	PORT114_FN4___2 = 2212,
	PORT115_FN4___2 = 2213,
	PORT116_FN4___2 = 2214,
	PORT117_FN4___2 = 2215,
	PORT118_FN4___2 = 2216,
	PORT119_FN4 = 2217,
	PORT120_FN4 = 2218,
	PORT121_FN4 = 2219,
	PORT122_FN4 = 2220,
	PORT123_FN4 = 2221,
	PORT124_FN4 = 2222,
	PORT125_FN4 = 2223,
	PORT126_FN4 = 2224,
	PORT128_FN4___2 = 2225,
	PORT129_FN4___2 = 2226,
	PORT130_FN4___2 = 2227,
	PORT131_FN4___2 = 2228,
	PORT132_FN4___2 = 2229,
	PORT133_FN4___2 = 2230,
	PORT134_FN4___2 = 2231,
	PORT160_FN4___2 = 2232,
	PORT161_FN4___2 = 2233,
	PORT162_FN4___2 = 2234,
	PORT163_FN4___2 = 2235,
	PORT164_FN4___2 = 2236,
	PORT165_FN4 = 2237,
	PORT166_FN4 = 2238,
	PORT167_FN4 = 2239,
	PORT168_FN4 = 2240,
	PORT169_FN4 = 2241,
	PORT170_FN4 = 2242,
	PORT171_FN4 = 2243,
	PORT172_FN4 = 2244,
	PORT173_FN4 = 2245,
	PORT174_FN4 = 2246,
	PORT175_FN4 = 2247,
	PORT176_FN4 = 2248,
	PORT177_FN4 = 2249,
	PORT178_FN4 = 2250,
	PORT192_FN4___2 = 2251,
	PORT193_FN4___2 = 2252,
	PORT194_FN4___2 = 2253,
	PORT195_FN4___2 = 2254,
	PORT196_FN4___2 = 2255,
	PORT197_FN4___2 = 2256,
	PORT198_FN4___2 = 2257,
	PORT199_FN4___2 = 2258,
	PORT200_FN4___2 = 2259,
	PORT201_FN4___2 = 2260,
	PORT202_FN4___2 = 2261,
	PORT203_FN4___2 = 2262,
	PORT204_FN4___2 = 2263,
	PORT205_FN4___2 = 2264,
	PORT206_FN4___2 = 2265,
	PORT207_FN4___2 = 2266,
	PORT208_FN4___2 = 2267,
	PORT209_FN4___2 = 2268,
	PORT210_FN4___2 = 2269,
	PORT211_FN4___2 = 2270,
	PORT212_FN4___2 = 2271,
	PORT213_FN4___2 = 2272,
	PORT214_FN4___2 = 2273,
	PORT215_FN4___2 = 2274,
	PORT216_FN4___2 = 2275,
	PORT217_FN4___2 = 2276,
	PORT218_FN4___2 = 2277,
	PORT219_FN4___2 = 2278,
	PORT220_FN4___2 = 2279,
	PORT221_FN4___2 = 2280,
	PORT222_FN4___2 = 2281,
	PORT224_FN4___2 = 2282,
	PORT225_FN4___2 = 2283,
	PORT226_FN4___2 = 2284,
	PORT227_FN4___2 = 2285,
	PORT228_FN4___2 = 2286,
	PORT229_FN4___2 = 2287,
	PORT230_FN4___2 = 2288,
	PORT231_FN4___2 = 2289,
	PORT232_FN4___2 = 2290,
	PORT233_FN4___2 = 2291,
	PORT234_FN4___2 = 2292,
	PORT235_FN4___2 = 2293,
	PORT236_FN4___2 = 2294,
	PORT237_FN4___2 = 2295,
	PORT238_FN4___2 = 2296,
	PORT239_FN4___2 = 2297,
	PORT240_FN4___2 = 2298,
	PORT241_FN4___2 = 2299,
	PORT242_FN4___2 = 2300,
	PORT243_FN4___2 = 2301,
	PORT244_FN4___2 = 2302,
	PORT245_FN4___2 = 2303,
	PORT246_FN4___2 = 2304,
	PORT247_FN4___2 = 2305,
	PORT248_FN4___2 = 2306,
	PORT249_FN4___2 = 2307,
	PORT250_FN4___2 = 2308,
	PORT256_FN4___2 = 2309,
	PORT257_FN4___2 = 2310,
	PORT258_FN4___2 = 2311,
	PORT259_FN4___2 = 2312,
	PORT260_FN4___2 = 2313,
	PORT261_FN4___2 = 2314,
	PORT262_FN4___2 = 2315,
	PORT263_FN4___2 = 2316,
	PORT264_FN4___2 = 2317,
	PORT265_FN4___2 = 2318,
	PORT266_FN4___2 = 2319,
	PORT267_FN4___2 = 2320,
	PORT268_FN4___2 = 2321,
	PORT269_FN4___2 = 2322,
	PORT270_FN4___2 = 2323,
	PORT271_FN4___2 = 2324,
	PORT272_FN4___2 = 2325,
	PORT273_FN4___2 = 2326,
	PORT274_FN4___2 = 2327,
	PORT275_FN4___2 = 2328,
	PORT276_FN4___2 = 2329,
	PORT277_FN4___2 = 2330,
	PORT278_FN4___2 = 2331,
	PORT279_FN4___2 = 2332,
	PORT280_FN4___2 = 2333,
	PORT281_FN4___2 = 2334,
	PORT282_FN4___2 = 2335,
	PORT283_FN4 = 2336,
	PORT288_FN4___2 = 2337,
	PORT289_FN4___2 = 2338,
	PORT290_FN4___2 = 2339,
	PORT291_FN4___2 = 2340,
	PORT292_FN4___2 = 2341,
	PORT293_FN4___2 = 2342,
	PORT294_FN4___2 = 2343,
	PORT295_FN4___2 = 2344,
	PORT296_FN4___2 = 2345,
	PORT297_FN4___2 = 2346,
	PORT298_FN4___2 = 2347,
	PORT299_FN4___2 = 2348,
	PORT300_FN4___2 = 2349,
	PORT301_FN4___2 = 2350,
	PORT302_FN4___2 = 2351,
	PORT303_FN4___2 = 2352,
	PORT304_FN4___2 = 2353,
	PORT305_FN4___2 = 2354,
	PORT306_FN4___2 = 2355,
	PORT307_FN4___2 = 2356,
	PORT308_FN4___2 = 2357,
	PORT320_FN4 = 2358,
	PORT321_FN4 = 2359,
	PORT322_FN4 = 2360,
	PORT323_FN4 = 2361,
	PORT324_FN4 = 2362,
	PORT325_FN4 = 2363,
	PORT326_FN4 = 2364,
	PORT327_FN4 = 2365,
	PORT328_FN4 = 2366,
	PORT329_FN4 = 2367,
	PORT0_FN5___2 = 2368,
	PORT1_FN5___2 = 2369,
	PORT2_FN5___2 = 2370,
	PORT3_FN5___2 = 2371,
	PORT4_FN5___2 = 2372,
	PORT5_FN5___2 = 2373,
	PORT6_FN5___2 = 2374,
	PORT7_FN5___2 = 2375,
	PORT8_FN5___2 = 2376,
	PORT9_FN5___2 = 2377,
	PORT10_FN5___2 = 2378,
	PORT11_FN5___2 = 2379,
	PORT12_FN5___2 = 2380,
	PORT13_FN5___2 = 2381,
	PORT14_FN5___2 = 2382,
	PORT15_FN5___2 = 2383,
	PORT16_FN5___2 = 2384,
	PORT17_FN5___2 = 2385,
	PORT18_FN5___2 = 2386,
	PORT19_FN5___2 = 2387,
	PORT20_FN5___2 = 2388,
	PORT21_FN5___2 = 2389,
	PORT22_FN5___2 = 2390,
	PORT23_FN5___2 = 2391,
	PORT24_FN5___2 = 2392,
	PORT25_FN5___2 = 2393,
	PORT26_FN5___2 = 2394,
	PORT27_FN5___2 = 2395,
	PORT28_FN5___2 = 2396,
	PORT29_FN5___2 = 2397,
	PORT30_FN5___2 = 2398,
	PORT32_FN5___2 = 2399,
	PORT33_FN5___2 = 2400,
	PORT34_FN5___2 = 2401,
	PORT35_FN5___2 = 2402,
	PORT36_FN5___2 = 2403,
	PORT37_FN5___2 = 2404,
	PORT38_FN5___2 = 2405,
	PORT39_FN5___2 = 2406,
	PORT40_FN5___2 = 2407,
	PORT64_FN5___2 = 2408,
	PORT65_FN5___2 = 2409,
	PORT66_FN5___2 = 2410,
	PORT67_FN5___2 = 2411,
	PORT68_FN5___2 = 2412,
	PORT69_FN5___2 = 2413,
	PORT70_FN5___2 = 2414,
	PORT71_FN5___2 = 2415,
	PORT72_FN5___2 = 2416,
	PORT73_FN5___2 = 2417,
	PORT74_FN5___2 = 2418,
	PORT75_FN5___2 = 2419,
	PORT76_FN5___2 = 2420,
	PORT77_FN5___2 = 2421,
	PORT78_FN5___2 = 2422,
	PORT79_FN5___2 = 2423,
	PORT80_FN5___2 = 2424,
	PORT81_FN5___2 = 2425,
	PORT82_FN5___2 = 2426,
	PORT83_FN5___2 = 2427,
	PORT84_FN5___2 = 2428,
	PORT85_FN5___2 = 2429,
	PORT96_FN5___2 = 2430,
	PORT97_FN5___2 = 2431,
	PORT98_FN5___2 = 2432,
	PORT99_FN5___2 = 2433,
	PORT100_FN5___2 = 2434,
	PORT101_FN5___2 = 2435,
	PORT102_FN5___2 = 2436,
	PORT103_FN5___2 = 2437,
	PORT104_FN5___2 = 2438,
	PORT105_FN5___2 = 2439,
	PORT106_FN5___2 = 2440,
	PORT107_FN5___2 = 2441,
	PORT108_FN5___2 = 2442,
	PORT109_FN5___2 = 2443,
	PORT110_FN5___2 = 2444,
	PORT111_FN5___2 = 2445,
	PORT112_FN5___2 = 2446,
	PORT113_FN5___2 = 2447,
	PORT114_FN5___2 = 2448,
	PORT115_FN5___2 = 2449,
	PORT116_FN5___2 = 2450,
	PORT117_FN5___2 = 2451,
	PORT118_FN5___2 = 2452,
	PORT119_FN5 = 2453,
	PORT120_FN5 = 2454,
	PORT121_FN5 = 2455,
	PORT122_FN5 = 2456,
	PORT123_FN5 = 2457,
	PORT124_FN5 = 2458,
	PORT125_FN5 = 2459,
	PORT126_FN5 = 2460,
	PORT128_FN5___2 = 2461,
	PORT129_FN5___2 = 2462,
	PORT130_FN5___2 = 2463,
	PORT131_FN5___2 = 2464,
	PORT132_FN5___2 = 2465,
	PORT133_FN5___2 = 2466,
	PORT134_FN5___2 = 2467,
	PORT160_FN5___2 = 2468,
	PORT161_FN5___2 = 2469,
	PORT162_FN5___2 = 2470,
	PORT163_FN5___2 = 2471,
	PORT164_FN5___2 = 2472,
	PORT165_FN5 = 2473,
	PORT166_FN5 = 2474,
	PORT167_FN5 = 2475,
	PORT168_FN5 = 2476,
	PORT169_FN5 = 2477,
	PORT170_FN5 = 2478,
	PORT171_FN5 = 2479,
	PORT172_FN5 = 2480,
	PORT173_FN5 = 2481,
	PORT174_FN5 = 2482,
	PORT175_FN5 = 2483,
	PORT176_FN5 = 2484,
	PORT177_FN5 = 2485,
	PORT178_FN5 = 2486,
	PORT192_FN5___2 = 2487,
	PORT193_FN5___2 = 2488,
	PORT194_FN5___2 = 2489,
	PORT195_FN5___2 = 2490,
	PORT196_FN5___2 = 2491,
	PORT197_FN5___2 = 2492,
	PORT198_FN5___2 = 2493,
	PORT199_FN5___2 = 2494,
	PORT200_FN5___2 = 2495,
	PORT201_FN5___2 = 2496,
	PORT202_FN5___2 = 2497,
	PORT203_FN5___2 = 2498,
	PORT204_FN5___2 = 2499,
	PORT205_FN5___2 = 2500,
	PORT206_FN5___2 = 2501,
	PORT207_FN5___2 = 2502,
	PORT208_FN5___2 = 2503,
	PORT209_FN5___2 = 2504,
	PORT210_FN5___2 = 2505,
	PORT211_FN5___2 = 2506,
	PORT212_FN5___2 = 2507,
	PORT213_FN5___2 = 2508,
	PORT214_FN5___2 = 2509,
	PORT215_FN5___2 = 2510,
	PORT216_FN5___2 = 2511,
	PORT217_FN5___2 = 2512,
	PORT218_FN5___2 = 2513,
	PORT219_FN5___2 = 2514,
	PORT220_FN5___2 = 2515,
	PORT221_FN5___2 = 2516,
	PORT222_FN5___2 = 2517,
	PORT224_FN5___2 = 2518,
	PORT225_FN5___2 = 2519,
	PORT226_FN5___2 = 2520,
	PORT227_FN5___2 = 2521,
	PORT228_FN5___2 = 2522,
	PORT229_FN5___2 = 2523,
	PORT230_FN5___2 = 2524,
	PORT231_FN5___2 = 2525,
	PORT232_FN5___2 = 2526,
	PORT233_FN5___2 = 2527,
	PORT234_FN5___2 = 2528,
	PORT235_FN5___2 = 2529,
	PORT236_FN5___2 = 2530,
	PORT237_FN5___2 = 2531,
	PORT238_FN5___2 = 2532,
	PORT239_FN5___2 = 2533,
	PORT240_FN5___2 = 2534,
	PORT241_FN5___2 = 2535,
	PORT242_FN5___2 = 2536,
	PORT243_FN5___2 = 2537,
	PORT244_FN5___2 = 2538,
	PORT245_FN5___2 = 2539,
	PORT246_FN5___2 = 2540,
	PORT247_FN5___2 = 2541,
	PORT248_FN5___2 = 2542,
	PORT249_FN5___2 = 2543,
	PORT250_FN5___2 = 2544,
	PORT256_FN5___2 = 2545,
	PORT257_FN5___2 = 2546,
	PORT258_FN5___2 = 2547,
	PORT259_FN5___2 = 2548,
	PORT260_FN5___2 = 2549,
	PORT261_FN5___2 = 2550,
	PORT262_FN5___2 = 2551,
	PORT263_FN5___2 = 2552,
	PORT264_FN5___2 = 2553,
	PORT265_FN5___2 = 2554,
	PORT266_FN5___2 = 2555,
	PORT267_FN5___2 = 2556,
	PORT268_FN5___2 = 2557,
	PORT269_FN5___2 = 2558,
	PORT270_FN5___2 = 2559,
	PORT271_FN5___2 = 2560,
	PORT272_FN5___2 = 2561,
	PORT273_FN5___2 = 2562,
	PORT274_FN5___2 = 2563,
	PORT275_FN5___2 = 2564,
	PORT276_FN5___2 = 2565,
	PORT277_FN5___2 = 2566,
	PORT278_FN5___2 = 2567,
	PORT279_FN5___2 = 2568,
	PORT280_FN5___2 = 2569,
	PORT281_FN5___2 = 2570,
	PORT282_FN5___2 = 2571,
	PORT283_FN5 = 2572,
	PORT288_FN5___2 = 2573,
	PORT289_FN5___2 = 2574,
	PORT290_FN5___2 = 2575,
	PORT291_FN5___2 = 2576,
	PORT292_FN5___2 = 2577,
	PORT293_FN5___2 = 2578,
	PORT294_FN5___2 = 2579,
	PORT295_FN5___2 = 2580,
	PORT296_FN5___2 = 2581,
	PORT297_FN5___2 = 2582,
	PORT298_FN5___2 = 2583,
	PORT299_FN5___2 = 2584,
	PORT300_FN5___2 = 2585,
	PORT301_FN5___2 = 2586,
	PORT302_FN5___2 = 2587,
	PORT303_FN5___2 = 2588,
	PORT304_FN5___2 = 2589,
	PORT305_FN5___2 = 2590,
	PORT306_FN5___2 = 2591,
	PORT307_FN5___2 = 2592,
	PORT308_FN5___2 = 2593,
	PORT320_FN5 = 2594,
	PORT321_FN5 = 2595,
	PORT322_FN5 = 2596,
	PORT323_FN5 = 2597,
	PORT324_FN5 = 2598,
	PORT325_FN5 = 2599,
	PORT326_FN5 = 2600,
	PORT327_FN5 = 2601,
	PORT328_FN5 = 2602,
	PORT329_FN5 = 2603,
	PORT0_FN6___2 = 2604,
	PORT1_FN6___2 = 2605,
	PORT2_FN6___2 = 2606,
	PORT3_FN6___2 = 2607,
	PORT4_FN6___2 = 2608,
	PORT5_FN6___2 = 2609,
	PORT6_FN6___2 = 2610,
	PORT7_FN6___2 = 2611,
	PORT8_FN6___2 = 2612,
	PORT9_FN6___2 = 2613,
	PORT10_FN6___2 = 2614,
	PORT11_FN6___2 = 2615,
	PORT12_FN6___2 = 2616,
	PORT13_FN6___2 = 2617,
	PORT14_FN6___2 = 2618,
	PORT15_FN6___2 = 2619,
	PORT16_FN6___2 = 2620,
	PORT17_FN6___2 = 2621,
	PORT18_FN6___2 = 2622,
	PORT19_FN6___2 = 2623,
	PORT20_FN6___2 = 2624,
	PORT21_FN6___2 = 2625,
	PORT22_FN6___2 = 2626,
	PORT23_FN6___2 = 2627,
	PORT24_FN6___2 = 2628,
	PORT25_FN6___2 = 2629,
	PORT26_FN6___2 = 2630,
	PORT27_FN6___2 = 2631,
	PORT28_FN6___2 = 2632,
	PORT29_FN6___2 = 2633,
	PORT30_FN6___2 = 2634,
	PORT32_FN6___2 = 2635,
	PORT33_FN6___2 = 2636,
	PORT34_FN6___2 = 2637,
	PORT35_FN6___2 = 2638,
	PORT36_FN6___2 = 2639,
	PORT37_FN6___2 = 2640,
	PORT38_FN6___2 = 2641,
	PORT39_FN6___2 = 2642,
	PORT40_FN6___2 = 2643,
	PORT64_FN6___2 = 2644,
	PORT65_FN6___2 = 2645,
	PORT66_FN6___2 = 2646,
	PORT67_FN6___2 = 2647,
	PORT68_FN6___2 = 2648,
	PORT69_FN6___2 = 2649,
	PORT70_FN6___2 = 2650,
	PORT71_FN6___2 = 2651,
	PORT72_FN6___2 = 2652,
	PORT73_FN6___2 = 2653,
	PORT74_FN6___2 = 2654,
	PORT75_FN6___2 = 2655,
	PORT76_FN6___2 = 2656,
	PORT77_FN6___2 = 2657,
	PORT78_FN6___2 = 2658,
	PORT79_FN6___2 = 2659,
	PORT80_FN6___2 = 2660,
	PORT81_FN6___2 = 2661,
	PORT82_FN6___2 = 2662,
	PORT83_FN6___2 = 2663,
	PORT84_FN6___2 = 2664,
	PORT85_FN6___2 = 2665,
	PORT96_FN6___2 = 2666,
	PORT97_FN6___2 = 2667,
	PORT98_FN6___2 = 2668,
	PORT99_FN6___2 = 2669,
	PORT100_FN6___2 = 2670,
	PORT101_FN6___2 = 2671,
	PORT102_FN6___2 = 2672,
	PORT103_FN6___2 = 2673,
	PORT104_FN6___2 = 2674,
	PORT105_FN6___2 = 2675,
	PORT106_FN6___2 = 2676,
	PORT107_FN6___2 = 2677,
	PORT108_FN6___2 = 2678,
	PORT109_FN6___2 = 2679,
	PORT110_FN6___2 = 2680,
	PORT111_FN6___2 = 2681,
	PORT112_FN6___2 = 2682,
	PORT113_FN6___2 = 2683,
	PORT114_FN6___2 = 2684,
	PORT115_FN6___2 = 2685,
	PORT116_FN6___2 = 2686,
	PORT117_FN6___2 = 2687,
	PORT118_FN6___2 = 2688,
	PORT119_FN6 = 2689,
	PORT120_FN6 = 2690,
	PORT121_FN6 = 2691,
	PORT122_FN6 = 2692,
	PORT123_FN6 = 2693,
	PORT124_FN6 = 2694,
	PORT125_FN6 = 2695,
	PORT126_FN6 = 2696,
	PORT128_FN6___2 = 2697,
	PORT129_FN6___2 = 2698,
	PORT130_FN6___2 = 2699,
	PORT131_FN6___2 = 2700,
	PORT132_FN6___2 = 2701,
	PORT133_FN6___2 = 2702,
	PORT134_FN6___2 = 2703,
	PORT160_FN6___2 = 2704,
	PORT161_FN6___2 = 2705,
	PORT162_FN6___2 = 2706,
	PORT163_FN6___2 = 2707,
	PORT164_FN6___2 = 2708,
	PORT165_FN6 = 2709,
	PORT166_FN6 = 2710,
	PORT167_FN6 = 2711,
	PORT168_FN6 = 2712,
	PORT169_FN6 = 2713,
	PORT170_FN6 = 2714,
	PORT171_FN6 = 2715,
	PORT172_FN6 = 2716,
	PORT173_FN6 = 2717,
	PORT174_FN6 = 2718,
	PORT175_FN6 = 2719,
	PORT176_FN6 = 2720,
	PORT177_FN6 = 2721,
	PORT178_FN6 = 2722,
	PORT192_FN6___2 = 2723,
	PORT193_FN6___2 = 2724,
	PORT194_FN6___2 = 2725,
	PORT195_FN6___2 = 2726,
	PORT196_FN6___2 = 2727,
	PORT197_FN6___2 = 2728,
	PORT198_FN6___2 = 2729,
	PORT199_FN6___2 = 2730,
	PORT200_FN6___2 = 2731,
	PORT201_FN6___2 = 2732,
	PORT202_FN6___2 = 2733,
	PORT203_FN6___2 = 2734,
	PORT204_FN6___2 = 2735,
	PORT205_FN6___2 = 2736,
	PORT206_FN6___2 = 2737,
	PORT207_FN6___2 = 2738,
	PORT208_FN6___2 = 2739,
	PORT209_FN6___2 = 2740,
	PORT210_FN6___2 = 2741,
	PORT211_FN6___2 = 2742,
	PORT212_FN6___2 = 2743,
	PORT213_FN6___2 = 2744,
	PORT214_FN6___2 = 2745,
	PORT215_FN6___2 = 2746,
	PORT216_FN6___2 = 2747,
	PORT217_FN6___2 = 2748,
	PORT218_FN6___2 = 2749,
	PORT219_FN6___2 = 2750,
	PORT220_FN6___2 = 2751,
	PORT221_FN6___2 = 2752,
	PORT222_FN6___2 = 2753,
	PORT224_FN6___2 = 2754,
	PORT225_FN6___2 = 2755,
	PORT226_FN6___2 = 2756,
	PORT227_FN6___2 = 2757,
	PORT228_FN6___2 = 2758,
	PORT229_FN6___2 = 2759,
	PORT230_FN6___2 = 2760,
	PORT231_FN6___2 = 2761,
	PORT232_FN6___2 = 2762,
	PORT233_FN6___2 = 2763,
	PORT234_FN6___2 = 2764,
	PORT235_FN6___2 = 2765,
	PORT236_FN6___2 = 2766,
	PORT237_FN6___2 = 2767,
	PORT238_FN6___2 = 2768,
	PORT239_FN6___2 = 2769,
	PORT240_FN6___2 = 2770,
	PORT241_FN6___2 = 2771,
	PORT242_FN6___2 = 2772,
	PORT243_FN6___2 = 2773,
	PORT244_FN6___2 = 2774,
	PORT245_FN6___2 = 2775,
	PORT246_FN6___2 = 2776,
	PORT247_FN6___2 = 2777,
	PORT248_FN6___2 = 2778,
	PORT249_FN6___2 = 2779,
	PORT250_FN6___2 = 2780,
	PORT256_FN6___2 = 2781,
	PORT257_FN6___2 = 2782,
	PORT258_FN6___2 = 2783,
	PORT259_FN6___2 = 2784,
	PORT260_FN6___2 = 2785,
	PORT261_FN6___2 = 2786,
	PORT262_FN6___2 = 2787,
	PORT263_FN6___2 = 2788,
	PORT264_FN6___2 = 2789,
	PORT265_FN6___2 = 2790,
	PORT266_FN6___2 = 2791,
	PORT267_FN6___2 = 2792,
	PORT268_FN6___2 = 2793,
	PORT269_FN6___2 = 2794,
	PORT270_FN6___2 = 2795,
	PORT271_FN6___2 = 2796,
	PORT272_FN6___2 = 2797,
	PORT273_FN6___2 = 2798,
	PORT274_FN6___2 = 2799,
	PORT275_FN6___2 = 2800,
	PORT276_FN6___2 = 2801,
	PORT277_FN6___2 = 2802,
	PORT278_FN6___2 = 2803,
	PORT279_FN6___2 = 2804,
	PORT280_FN6___2 = 2805,
	PORT281_FN6___2 = 2806,
	PORT282_FN6___2 = 2807,
	PORT283_FN6 = 2808,
	PORT288_FN6___2 = 2809,
	PORT289_FN6___2 = 2810,
	PORT290_FN6___2 = 2811,
	PORT291_FN6___2 = 2812,
	PORT292_FN6___2 = 2813,
	PORT293_FN6___2 = 2814,
	PORT294_FN6___2 = 2815,
	PORT295_FN6___2 = 2816,
	PORT296_FN6___2 = 2817,
	PORT297_FN6___2 = 2818,
	PORT298_FN6___2 = 2819,
	PORT299_FN6___2 = 2820,
	PORT300_FN6___2 = 2821,
	PORT301_FN6___2 = 2822,
	PORT302_FN6___2 = 2823,
	PORT303_FN6___2 = 2824,
	PORT304_FN6___2 = 2825,
	PORT305_FN6___2 = 2826,
	PORT306_FN6___2 = 2827,
	PORT307_FN6___2 = 2828,
	PORT308_FN6___2 = 2829,
	PORT320_FN6 = 2830,
	PORT321_FN6 = 2831,
	PORT322_FN6 = 2832,
	PORT323_FN6 = 2833,
	PORT324_FN6 = 2834,
	PORT325_FN6 = 2835,
	PORT326_FN6 = 2836,
	PORT327_FN6 = 2837,
	PORT328_FN6 = 2838,
	PORT329_FN6 = 2839,
	PORT0_FN7___2 = 2840,
	PORT1_FN7___2 = 2841,
	PORT2_FN7___2 = 2842,
	PORT3_FN7___2 = 2843,
	PORT4_FN7___2 = 2844,
	PORT5_FN7___2 = 2845,
	PORT6_FN7___2 = 2846,
	PORT7_FN7___2 = 2847,
	PORT8_FN7___2 = 2848,
	PORT9_FN7___2 = 2849,
	PORT10_FN7___2 = 2850,
	PORT11_FN7___2 = 2851,
	PORT12_FN7___2 = 2852,
	PORT13_FN7___2 = 2853,
	PORT14_FN7___2 = 2854,
	PORT15_FN7___2 = 2855,
	PORT16_FN7___2 = 2856,
	PORT17_FN7___2 = 2857,
	PORT18_FN7___2 = 2858,
	PORT19_FN7___2 = 2859,
	PORT20_FN7___2 = 2860,
	PORT21_FN7___2 = 2861,
	PORT22_FN7___2 = 2862,
	PORT23_FN7___2 = 2863,
	PORT24_FN7___2 = 2864,
	PORT25_FN7___2 = 2865,
	PORT26_FN7___2 = 2866,
	PORT27_FN7___2 = 2867,
	PORT28_FN7___2 = 2868,
	PORT29_FN7___2 = 2869,
	PORT30_FN7___2 = 2870,
	PORT32_FN7___2 = 2871,
	PORT33_FN7___2 = 2872,
	PORT34_FN7___2 = 2873,
	PORT35_FN7___2 = 2874,
	PORT36_FN7___2 = 2875,
	PORT37_FN7___2 = 2876,
	PORT38_FN7___2 = 2877,
	PORT39_FN7___2 = 2878,
	PORT40_FN7___2 = 2879,
	PORT64_FN7___2 = 2880,
	PORT65_FN7___2 = 2881,
	PORT66_FN7___2 = 2882,
	PORT67_FN7___2 = 2883,
	PORT68_FN7___2 = 2884,
	PORT69_FN7___2 = 2885,
	PORT70_FN7___2 = 2886,
	PORT71_FN7___2 = 2887,
	PORT72_FN7___2 = 2888,
	PORT73_FN7___2 = 2889,
	PORT74_FN7___2 = 2890,
	PORT75_FN7___2 = 2891,
	PORT76_FN7___2 = 2892,
	PORT77_FN7___2 = 2893,
	PORT78_FN7___2 = 2894,
	PORT79_FN7___2 = 2895,
	PORT80_FN7___2 = 2896,
	PORT81_FN7___2 = 2897,
	PORT82_FN7___2 = 2898,
	PORT83_FN7___2 = 2899,
	PORT84_FN7___2 = 2900,
	PORT85_FN7___2 = 2901,
	PORT96_FN7___2 = 2902,
	PORT97_FN7___2 = 2903,
	PORT98_FN7___2 = 2904,
	PORT99_FN7___2 = 2905,
	PORT100_FN7___2 = 2906,
	PORT101_FN7___2 = 2907,
	PORT102_FN7___2 = 2908,
	PORT103_FN7___2 = 2909,
	PORT104_FN7___2 = 2910,
	PORT105_FN7___2 = 2911,
	PORT106_FN7___2 = 2912,
	PORT107_FN7___2 = 2913,
	PORT108_FN7___2 = 2914,
	PORT109_FN7___2 = 2915,
	PORT110_FN7___2 = 2916,
	PORT111_FN7___2 = 2917,
	PORT112_FN7___2 = 2918,
	PORT113_FN7___2 = 2919,
	PORT114_FN7___2 = 2920,
	PORT115_FN7___2 = 2921,
	PORT116_FN7___2 = 2922,
	PORT117_FN7___2 = 2923,
	PORT118_FN7___2 = 2924,
	PORT119_FN7 = 2925,
	PORT120_FN7 = 2926,
	PORT121_FN7 = 2927,
	PORT122_FN7 = 2928,
	PORT123_FN7 = 2929,
	PORT124_FN7 = 2930,
	PORT125_FN7 = 2931,
	PORT126_FN7 = 2932,
	PORT128_FN7___2 = 2933,
	PORT129_FN7___2 = 2934,
	PORT130_FN7___2 = 2935,
	PORT131_FN7___2 = 2936,
	PORT132_FN7___2 = 2937,
	PORT133_FN7___2 = 2938,
	PORT134_FN7___2 = 2939,
	PORT160_FN7___2 = 2940,
	PORT161_FN7___2 = 2941,
	PORT162_FN7___2 = 2942,
	PORT163_FN7___2 = 2943,
	PORT164_FN7___2 = 2944,
	PORT165_FN7 = 2945,
	PORT166_FN7 = 2946,
	PORT167_FN7 = 2947,
	PORT168_FN7 = 2948,
	PORT169_FN7 = 2949,
	PORT170_FN7 = 2950,
	PORT171_FN7 = 2951,
	PORT172_FN7 = 2952,
	PORT173_FN7 = 2953,
	PORT174_FN7 = 2954,
	PORT175_FN7 = 2955,
	PORT176_FN7 = 2956,
	PORT177_FN7 = 2957,
	PORT178_FN7 = 2958,
	PORT192_FN7___2 = 2959,
	PORT193_FN7___2 = 2960,
	PORT194_FN7___2 = 2961,
	PORT195_FN7___2 = 2962,
	PORT196_FN7___2 = 2963,
	PORT197_FN7___2 = 2964,
	PORT198_FN7___2 = 2965,
	PORT199_FN7___2 = 2966,
	PORT200_FN7___2 = 2967,
	PORT201_FN7___2 = 2968,
	PORT202_FN7___2 = 2969,
	PORT203_FN7___2 = 2970,
	PORT204_FN7___2 = 2971,
	PORT205_FN7___2 = 2972,
	PORT206_FN7___2 = 2973,
	PORT207_FN7___2 = 2974,
	PORT208_FN7___2 = 2975,
	PORT209_FN7___2 = 2976,
	PORT210_FN7___2 = 2977,
	PORT211_FN7___2 = 2978,
	PORT212_FN7___2 = 2979,
	PORT213_FN7___2 = 2980,
	PORT214_FN7___2 = 2981,
	PORT215_FN7___2 = 2982,
	PORT216_FN7___2 = 2983,
	PORT217_FN7___2 = 2984,
	PORT218_FN7___2 = 2985,
	PORT219_FN7___2 = 2986,
	PORT220_FN7___2 = 2987,
	PORT221_FN7___2 = 2988,
	PORT222_FN7___2 = 2989,
	PORT224_FN7___2 = 2990,
	PORT225_FN7___2 = 2991,
	PORT226_FN7___2 = 2992,
	PORT227_FN7___2 = 2993,
	PORT228_FN7___2 = 2994,
	PORT229_FN7___2 = 2995,
	PORT230_FN7___2 = 2996,
	PORT231_FN7___2 = 2997,
	PORT232_FN7___2 = 2998,
	PORT233_FN7___2 = 2999,
	PORT234_FN7___2 = 3000,
	PORT235_FN7___2 = 3001,
	PORT236_FN7___2 = 3002,
	PORT237_FN7___2 = 3003,
	PORT238_FN7___2 = 3004,
	PORT239_FN7___2 = 3005,
	PORT240_FN7___2 = 3006,
	PORT241_FN7___2 = 3007,
	PORT242_FN7___2 = 3008,
	PORT243_FN7___2 = 3009,
	PORT244_FN7___2 = 3010,
	PORT245_FN7___2 = 3011,
	PORT246_FN7___2 = 3012,
	PORT247_FN7___2 = 3013,
	PORT248_FN7___2 = 3014,
	PORT249_FN7___2 = 3015,
	PORT250_FN7___2 = 3016,
	PORT256_FN7___2 = 3017,
	PORT257_FN7___2 = 3018,
	PORT258_FN7___2 = 3019,
	PORT259_FN7___2 = 3020,
	PORT260_FN7___2 = 3021,
	PORT261_FN7___2 = 3022,
	PORT262_FN7___2 = 3023,
	PORT263_FN7___2 = 3024,
	PORT264_FN7___2 = 3025,
	PORT265_FN7___2 = 3026,
	PORT266_FN7___2 = 3027,
	PORT267_FN7___2 = 3028,
	PORT268_FN7___2 = 3029,
	PORT269_FN7___2 = 3030,
	PORT270_FN7___2 = 3031,
	PORT271_FN7___2 = 3032,
	PORT272_FN7___2 = 3033,
	PORT273_FN7___2 = 3034,
	PORT274_FN7___2 = 3035,
	PORT275_FN7___2 = 3036,
	PORT276_FN7___2 = 3037,
	PORT277_FN7___2 = 3038,
	PORT278_FN7___2 = 3039,
	PORT279_FN7___2 = 3040,
	PORT280_FN7___2 = 3041,
	PORT281_FN7___2 = 3042,
	PORT282_FN7___2 = 3043,
	PORT283_FN7 = 3044,
	PORT288_FN7___2 = 3045,
	PORT289_FN7___2 = 3046,
	PORT290_FN7___2 = 3047,
	PORT291_FN7___2 = 3048,
	PORT292_FN7___2 = 3049,
	PORT293_FN7___2 = 3050,
	PORT294_FN7___2 = 3051,
	PORT295_FN7___2 = 3052,
	PORT296_FN7___2 = 3053,
	PORT297_FN7___2 = 3054,
	PORT298_FN7___2 = 3055,
	PORT299_FN7___2 = 3056,
	PORT300_FN7___2 = 3057,
	PORT301_FN7___2 = 3058,
	PORT302_FN7___2 = 3059,
	PORT303_FN7___2 = 3060,
	PORT304_FN7___2 = 3061,
	PORT305_FN7___2 = 3062,
	PORT306_FN7___2 = 3063,
	PORT307_FN7___2 = 3064,
	PORT308_FN7___2 = 3065,
	PORT320_FN7 = 3066,
	PORT321_FN7 = 3067,
	PORT322_FN7 = 3068,
	PORT323_FN7 = 3069,
	PORT324_FN7 = 3070,
	PORT325_FN7 = 3071,
	PORT326_FN7 = 3072,
	PORT327_FN7 = 3073,
	PORT328_FN7 = 3074,
	PORT329_FN7 = 3075,
	MSEL1CR_31_0 = 3076,
	MSEL1CR_31_1 = 3077,
	MSEL1CR_27_0 = 3078,
	MSEL1CR_27_1 = 3079,
	MSEL1CR_25_0 = 3080,
	MSEL1CR_25_1 = 3081,
	MSEL1CR_24_0 = 3082,
	MSEL1CR_24_1 = 3083,
	MSEL1CR_22_0 = 3084,
	MSEL1CR_22_1 = 3085,
	MSEL1CR_21_0 = 3086,
	MSEL1CR_21_1 = 3087,
	MSEL1CR_20_0 = 3088,
	MSEL1CR_20_1 = 3089,
	MSEL1CR_19_0 = 3090,
	MSEL1CR_19_1 = 3091,
	MSEL1CR_18_0 = 3092,
	MSEL1CR_18_1 = 3093,
	MSEL1CR_17_0 = 3094,
	MSEL1CR_17_1 = 3095,
	MSEL1CR_16_0 = 3096,
	MSEL1CR_16_1 = 3097,
	MSEL1CR_15_0 = 3098,
	MSEL1CR_15_1 = 3099,
	MSEL1CR_14_0 = 3100,
	MSEL1CR_14_1 = 3101,
	MSEL1CR_13_0 = 3102,
	MSEL1CR_13_1 = 3103,
	MSEL1CR_12_0 = 3104,
	MSEL1CR_12_1 = 3105,
	MSEL1CR_11_0 = 3106,
	MSEL1CR_11_1 = 3107,
	MSEL1CR_10_0 = 3108,
	MSEL1CR_10_1 = 3109,
	MSEL1CR_09_0 = 3110,
	MSEL1CR_09_1 = 3111,
	MSEL1CR_08_0 = 3112,
	MSEL1CR_08_1 = 3113,
	MSEL1CR_07_0 = 3114,
	MSEL1CR_07_1 = 3115,
	MSEL1CR_06_0 = 3116,
	MSEL1CR_06_1 = 3117,
	MSEL1CR_05_0 = 3118,
	MSEL1CR_05_1 = 3119,
	MSEL1CR_04_0 = 3120,
	MSEL1CR_04_1 = 3121,
	MSEL1CR_03_0 = 3122,
	MSEL1CR_03_1 = 3123,
	MSEL1CR_02_0 = 3124,
	MSEL1CR_02_1 = 3125,
	MSEL1CR_01_0 = 3126,
	MSEL1CR_01_1 = 3127,
	MSEL1CR_00_0 = 3128,
	MSEL1CR_00_1 = 3129,
	MSEL3CR_31_0 = 3130,
	MSEL3CR_31_1 = 3131,
	MSEL3CR_28_0 = 3132,
	MSEL3CR_28_1 = 3133,
	MSEL3CR_27_0 = 3134,
	MSEL3CR_27_1 = 3135,
	MSEL3CR_26_0 = 3136,
	MSEL3CR_26_1 = 3137,
	MSEL3CR_23_0 = 3138,
	MSEL3CR_23_1 = 3139,
	MSEL3CR_22_0 = 3140,
	MSEL3CR_22_1 = 3141,
	MSEL3CR_21_0 = 3142,
	MSEL3CR_21_1 = 3143,
	MSEL3CR_20_0 = 3144,
	MSEL3CR_20_1 = 3145,
	MSEL3CR_19_0 = 3146,
	MSEL3CR_19_1 = 3147,
	MSEL3CR_18_0 = 3148,
	MSEL3CR_18_1 = 3149,
	MSEL3CR_17_0 = 3150,
	MSEL3CR_17_1 = 3151,
	MSEL3CR_16_0 = 3152,
	MSEL3CR_16_1 = 3153,
	MSEL3CR_15_0 = 3154,
	MSEL3CR_15_1 = 3155,
	MSEL3CR_12_0 = 3156,
	MSEL3CR_12_1 = 3157,
	MSEL3CR_11_0 = 3158,
	MSEL3CR_11_1 = 3159,
	MSEL3CR_10_0 = 3160,
	MSEL3CR_10_1 = 3161,
	MSEL3CR_09_0 = 3162,
	MSEL3CR_09_1 = 3163,
	MSEL3CR_06_0 = 3164,
	MSEL3CR_06_1 = 3165,
	MSEL3CR_03_0 = 3166,
	MSEL3CR_03_1 = 3167,
	MSEL3CR_01_0 = 3168,
	MSEL3CR_01_1 = 3169,
	MSEL3CR_00_0 = 3170,
	MSEL3CR_00_1 = 3171,
	MSEL4CR_30_0 = 3172,
	MSEL4CR_30_1 = 3173,
	MSEL4CR_29_0 = 3174,
	MSEL4CR_29_1 = 3175,
	MSEL4CR_28_0 = 3176,
	MSEL4CR_28_1 = 3177,
	MSEL4CR_27_0 = 3178,
	MSEL4CR_27_1 = 3179,
	MSEL4CR_26_0 = 3180,
	MSEL4CR_26_1 = 3181,
	MSEL4CR_25_0 = 3182,
	MSEL4CR_25_1 = 3183,
	MSEL4CR_24_0 = 3184,
	MSEL4CR_24_1 = 3185,
	MSEL4CR_23_0 = 3186,
	MSEL4CR_23_1 = 3187,
	MSEL4CR_22_0 = 3188,
	MSEL4CR_22_1 = 3189,
	MSEL4CR_21_0 = 3190,
	MSEL4CR_21_1 = 3191,
	MSEL4CR_20_0 = 3192,
	MSEL4CR_20_1 = 3193,
	MSEL4CR_19_0 = 3194,
	MSEL4CR_19_1 = 3195,
	MSEL4CR_18_0 = 3196,
	MSEL4CR_18_1 = 3197,
	MSEL4CR_17_0 = 3198,
	MSEL4CR_17_1 = 3199,
	MSEL4CR_16_0 = 3200,
	MSEL4CR_16_1 = 3201,
	MSEL4CR_15_0 = 3202,
	MSEL4CR_15_1 = 3203,
	MSEL4CR_14_0 = 3204,
	MSEL4CR_14_1 = 3205,
	MSEL4CR_13_0 = 3206,
	MSEL4CR_13_1 = 3207,
	MSEL4CR_12_0 = 3208,
	MSEL4CR_12_1 = 3209,
	MSEL4CR_11_0 = 3210,
	MSEL4CR_11_1 = 3211,
	MSEL4CR_10_0 = 3212,
	MSEL4CR_10_1 = 3213,
	MSEL4CR_09_0 = 3214,
	MSEL4CR_09_1 = 3215,
	MSEL4CR_07_0 = 3216,
	MSEL4CR_07_1 = 3217,
	MSEL4CR_04_0 = 3218,
	MSEL4CR_04_1 = 3219,
	MSEL4CR_01_0 = 3220,
	MSEL4CR_01_1 = 3221,
	MSEL5CR_31_0 = 3222,
	MSEL5CR_31_1 = 3223,
	MSEL5CR_30_0 = 3224,
	MSEL5CR_30_1 = 3225,
	MSEL5CR_29_0 = 3226,
	MSEL5CR_29_1 = 3227,
	MSEL5CR_28_0 = 3228,
	MSEL5CR_28_1 = 3229,
	MSEL5CR_27_0 = 3230,
	MSEL5CR_27_1 = 3231,
	MSEL5CR_26_0 = 3232,
	MSEL5CR_26_1 = 3233,
	MSEL5CR_25_0 = 3234,
	MSEL5CR_25_1 = 3235,
	MSEL5CR_24_0 = 3236,
	MSEL5CR_24_1 = 3237,
	MSEL5CR_23_0 = 3238,
	MSEL5CR_23_1 = 3239,
	MSEL5CR_22_0 = 3240,
	MSEL5CR_22_1 = 3241,
	MSEL5CR_21_0 = 3242,
	MSEL5CR_21_1 = 3243,
	MSEL5CR_20_0 = 3244,
	MSEL5CR_20_1 = 3245,
	MSEL5CR_19_0 = 3246,
	MSEL5CR_19_1 = 3247,
	MSEL5CR_18_0 = 3248,
	MSEL5CR_18_1 = 3249,
	MSEL5CR_17_0 = 3250,
	MSEL5CR_17_1 = 3251,
	MSEL5CR_16_0 = 3252,
	MSEL5CR_16_1 = 3253,
	MSEL5CR_15_0 = 3254,
	MSEL5CR_15_1 = 3255,
	MSEL5CR_14_0 = 3256,
	MSEL5CR_14_1 = 3257,
	MSEL5CR_13_0 = 3258,
	MSEL5CR_13_1 = 3259,
	MSEL5CR_12_0 = 3260,
	MSEL5CR_12_1 = 3261,
	MSEL5CR_11_0 = 3262,
	MSEL5CR_11_1 = 3263,
	MSEL5CR_10_0 = 3264,
	MSEL5CR_10_1 = 3265,
	MSEL5CR_09_0 = 3266,
	MSEL5CR_09_1 = 3267,
	MSEL5CR_08_0 = 3268,
	MSEL5CR_08_1 = 3269,
	MSEL5CR_07_0 = 3270,
	MSEL5CR_07_1 = 3271,
	MSEL5CR_06_0 = 3272,
	MSEL5CR_06_1 = 3273,
	MSEL8CR_16_0 = 3274,
	MSEL8CR_16_1 = 3275,
	MSEL8CR_01_0 = 3276,
	MSEL8CR_01_1 = 3277,
	MSEL8CR_00_0 = 3278,
	MSEL8CR_00_1 = 3279,
	PINMUX_FUNCTION_END___5 = 3280,
	PINMUX_MARK_BEGIN___5 = 3281,
	LCDD0_MARK___2 = 3282,
	PDM2_CLK_0_MARK = 3283,
	DU0_DR0_MARK___3 = 3284,
	IRQ0_MARK___4 = 3285,
	LCDD1_MARK___2 = 3286,
	PDM2_DATA_1_MARK = 3287,
	DU0_DR19_MARK = 3288,
	IRQ1_MARK___4 = 3289,
	LCDD2_MARK___2 = 3290,
	PDM3_CLK_2_MARK = 3291,
	DU0_DR2_MARK___3 = 3292,
	IRQ2_MARK___4 = 3293,
	LCDD3_MARK___2 = 3294,
	PDM3_DATA_3_MARK = 3295,
	DU0_DR3_MARK___3 = 3296,
	IRQ3_MARK___4 = 3297,
	LCDD4_MARK___2 = 3298,
	PDM4_CLK_4_MARK = 3299,
	DU0_DR4_MARK___3 = 3300,
	IRQ4_MARK___3 = 3301,
	LCDD5_MARK___2 = 3302,
	PDM4_DATA_5_MARK = 3303,
	DU0_DR5_MARK___3 = 3304,
	IRQ5_MARK___3 = 3305,
	LCDD6_MARK___2 = 3306,
	PDM0_OUTCLK_6_MARK = 3307,
	DU0_DR6_MARK___3 = 3308,
	IRQ6_MARK___3 = 3309,
	LCDD7_MARK___2 = 3310,
	PDM0_OUTDATA_7_MARK = 3311,
	DU0_DR7_MARK___3 = 3312,
	IRQ7_MARK___3 = 3313,
	LCDD8_MARK___2 = 3314,
	PDM1_OUTCLK_8_MARK = 3315,
	DU0_DG0_MARK___3 = 3316,
	IRQ8_MARK___3 = 3317,
	LCDD9_MARK___2 = 3318,
	PDM1_OUTDATA_9_MARK = 3319,
	DU0_DG1_MARK___3 = 3320,
	IRQ9_MARK___3 = 3321,
	LCDD10_MARK___2 = 3322,
	FSICCK_MARK___2 = 3323,
	DU0_DG2_MARK___3 = 3324,
	IRQ10_MARK = 3325,
	LCDD11_MARK___2 = 3326,
	FSICISLD_MARK___2 = 3327,
	DU0_DG3_MARK___3 = 3328,
	IRQ11_MARK = 3329,
	LCDD12_MARK___2 = 3330,
	FSICOMC_MARK___2 = 3331,
	DU0_DG4_MARK___3 = 3332,
	IRQ12_MARK = 3333,
	LCDD13_MARK___2 = 3334,
	FSICOLR_MARK___2 = 3335,
	FSICILR_MARK___2 = 3336,
	DU0_DG5_MARK___3 = 3337,
	IRQ13_MARK = 3338,
	LCDD14_MARK___2 = 3339,
	FSICOBT_MARK___2 = 3340,
	FSICIBT_MARK___2 = 3341,
	DU0_DG6_MARK___3 = 3342,
	IRQ14_MARK = 3343,
	LCDD15_MARK___2 = 3344,
	FSICOSLD_MARK___2 = 3345,
	DU0_DG7_MARK___3 = 3346,
	IRQ15_MARK = 3347,
	LCDD16_MARK___2 = 3348,
	TPU1TO1_MARK = 3349,
	DU0_DB0_MARK___3 = 3350,
	LCDD17_MARK___2 = 3351,
	SF_IRQ_00_MARK = 3352,
	DU0_DB1_MARK___3 = 3353,
	LCDD18_MARK___2 = 3354,
	SF_IRQ_01_MARK = 3355,
	DU0_DB2_MARK___3 = 3356,
	LCDD19_MARK___2 = 3357,
	SCIFB3_RTS_19_MARK = 3358,
	DU0_DB3_MARK___3 = 3359,
	LCDD20_MARK___2 = 3360,
	SCIFB3_CTS_20_MARK = 3361,
	DU0_DB4_MARK___3 = 3362,
	LCDD21_MARK___2 = 3363,
	SCIFB3_TXD_21_MARK = 3364,
	DU0_DB5_MARK___3 = 3365,
	LCDD22_MARK___2 = 3366,
	SCIFB3_RXD_22_MARK = 3367,
	DU0_DB6_MARK___3 = 3368,
	LCDD23_MARK___2 = 3369,
	SCIFB3_SCK_23_MARK = 3370,
	DU0_DB7_MARK___3 = 3371,
	LCDHSYN_MARK___2 = 3372,
	LCDCS_MARK = 3373,
	SCIFB1_RTS_24_MARK = 3374,
	DU0_EXHSYNC_N_CSYNC_N_HSYNC_N_MARK = 3375,
	LCDVSYN_MARK___2 = 3376,
	SCIFB1_CTS_25_MARK = 3377,
	DU0_EXVSYNC_N_VSYNC_N_CSYNC_N_MARK = 3378,
	LCDDCK_MARK___2 = 3379,
	LCDWR_MARK = 3380,
	SCIFB1_TXD_26_MARK = 3381,
	DU0_DOTCLKIN_MARK___4 = 3382,
	LCDDISP_MARK___2 = 3383,
	LCDRS_MARK___2 = 3384,
	SCIFB1_RXD_27_MARK = 3385,
	DU0_DOTCLKOUT_MARK = 3386,
	LCDRD_N_MARK = 3387,
	SCIFB1_SCK_28_MARK = 3388,
	DU0_DOTCLKOUTB_MARK = 3389,
	LCDLCLK_MARK___2 = 3390,
	SF_IRQ_02_MARK = 3391,
	DU0_DISP_CSYNC_N_DE_MARK = 3392,
	LCDDON_MARK___2 = 3393,
	SF_IRQ_03_MARK = 3394,
	DU0_ODDF_N_CLAMP_MARK = 3395,
	SCIFA0_RTS_MARK = 3396,
	SIM0_DET_MARK = 3397,
	CSCIF0_RTS_MARK = 3398,
	SCIFA0_CTS_MARK = 3399,
	SIM1_DET_MARK = 3400,
	CSCIF0_CTS_MARK = 3401,
	SCIFA0_SCK_MARK___2 = 3402,
	SIM0_PWRON_MARK = 3403,
	CSCIF0_SCK_MARK = 3404,
	SCIFA1_RTS_MARK = 3405,
	CSCIF1_RTS_MARK = 3406,
	SCIFA1_CTS_MARK = 3407,
	CSCIF1_CTS_MARK = 3408,
	SCIFA1_SCK_MARK___4 = 3409,
	CSCIF1_SCK_MARK = 3410,
	SCIFB0_RTS_MARK = 3411,
	TPU0TO1_MARK___2 = 3412,
	SCIFB3_RTS_38_MARK = 3413,
	CHSCIF0_HRTS_MARK = 3414,
	SCIFB0_CTS_MARK = 3415,
	TPU0TO2_MARK___2 = 3416,
	SCIFB3_CTS_39_MARK = 3417,
	CHSCIF0_HCTS_MARK = 3418,
	SCIFB0_SCK_MARK___3 = 3419,
	TPU0TO3_MARK___2 = 3420,
	SCIFB3_SCK_40_MARK = 3421,
	CHSCIF0_HSCK_MARK = 3422,
	PDM0_DATA_MARK = 3423,
	PDM1_DATA_MARK = 3424,
	HSI_RX_WAKE_MARK___2 = 3425,
	SCIFB2_CTS_66_MARK = 3426,
	MSIOF3_SYNC_MARK = 3427,
	GenIO4_MARK = 3428,
	IRQ40_MARK = 3429,
	HSI_RX_READY_MARK___2 = 3430,
	SCIFB1_TXD_67_MARK = 3431,
	GIO_OUT3_67_MARK = 3432,
	CHSCIF1_HTX_MARK = 3433,
	HSI_RX_FLAG_MARK___2 = 3434,
	SCIFB2_TXD_68_MARK = 3435,
	MSIOF3_TXD_MARK = 3436,
	GIO_OUT4_68_MARK = 3437,
	HSI_RX_DATA_MARK___2 = 3438,
	SCIFB2_RXD_69_MARK = 3439,
	MSIOF3_RXD_MARK = 3440,
	GIO_OUT5_69_MARK = 3441,
	HSI_TX_FLAG_MARK___2 = 3442,
	SCIFB1_RTS_70_MARK = 3443,
	GIO_OUT1_70_MARK = 3444,
	HSIC_TSTCLK0_MARK = 3445,
	CHSCIF1_HRTS_MARK = 3446,
	HSI_TX_DATA_MARK___2 = 3447,
	SCIFB1_CTS_71_MARK = 3448,
	GIO_OUT2_71_MARK = 3449,
	HSIC_TSTCLK1_MARK = 3450,
	CHSCIF1_HCTS_MARK = 3451,
	HSI_TX_WAKE_MARK___2 = 3452,
	SCIFB1_RXD_72_MARK = 3453,
	GenIO8_MARK = 3454,
	CHSCIF1_HRX_MARK = 3455,
	HSI_TX_READY_MARK___2 = 3456,
	SCIFB2_RTS_73_MARK = 3457,
	MSIOF3_SCK_MARK = 3458,
	GIO_OUT0_73_MARK = 3459,
	IRDA_OUT_MARK = 3460,
	IRDA_IN_MARK = 3461,
	IRDA_FIRSEL_MARK = 3462,
	TPU0TO0_MARK___2 = 3463,
	DIGRFEN_MARK = 3464,
	GPS_TIMESTAMP_MARK = 3465,
	TXP_MARK = 3466,
	TXP2_MARK = 3467,
	COEX_0_MARK = 3468,
	COEX_1_MARK = 3469,
	IRQ19_MARK = 3470,
	IRQ18_MARK = 3471,
	KEYIN0_MARK___2 = 3472,
	KEYIN1_MARK___2 = 3473,
	KEYIN2_MARK___2 = 3474,
	KEYIN3_MARK___2 = 3475,
	KEYIN4_MARK___2 = 3476,
	KEYIN5_MARK___2 = 3477,
	KEYIN6_MARK___2 = 3478,
	IRQ41_MARK = 3479,
	KEYIN7_MARK___2 = 3480,
	IRQ42_MARK = 3481,
	KEYOUT0_MARK___2 = 3482,
	KEYOUT1_MARK___2 = 3483,
	KEYOUT2_MARK___2 = 3484,
	KEYOUT3_MARK___2 = 3485,
	KEYOUT4_MARK___2 = 3486,
	KEYOUT5_MARK___2 = 3487,
	IRQ43_MARK = 3488,
	KEYOUT6_MARK = 3489,
	IRQ44_MARK = 3490,
	KEYOUT7_MARK = 3491,
	RFANAEN_MARK = 3492,
	IRQ45_MARK = 3493,
	KEYIN8_MARK = 3494,
	KEYOUT8_MARK___2 = 3495,
	SF_IRQ_04_MARK = 3496,
	IRQ46_MARK = 3497,
	KEYIN9_MARK = 3498,
	KEYOUT9_MARK = 3499,
	SF_IRQ_05_MARK = 3500,
	IRQ47_MARK = 3501,
	KEYIN10_MARK = 3502,
	KEYOUT10_MARK = 3503,
	SF_IRQ_06_MARK = 3504,
	IRQ48_MARK = 3505,
	KEYIN11_MARK = 3506,
	KEYOUT11_MARK = 3507,
	SF_IRQ_07_MARK = 3508,
	IRQ49_MARK = 3509,
	SCIFA0_TXD_MARK___4 = 3510,
	CSCIF0_TX_MARK = 3511,
	SCIFA0_RXD_MARK___4 = 3512,
	CSCIF0_RX_MARK = 3513,
	SCIFA1_TXD_MARK___4 = 3514,
	CSCIF1_TX_MARK = 3515,
	SCIFA1_RXD_MARK___4 = 3516,
	CSCIF1_RX_MARK = 3517,
	SF_PORT_1_120_MARK = 3518,
	SCIFB3_RXD_120_MARK = 3519,
	DU0_CDE_MARK___3 = 3520,
	SF_PORT_0_121_MARK = 3521,
	SCIFB3_TXD_121_MARK = 3522,
	SCIFB0_TXD_MARK___3 = 3523,
	CHSCIF0_HTX_MARK = 3524,
	SCIFB0_RXD_MARK___3 = 3525,
	CHSCIF0_HRX_MARK = 3526,
	ISP_STROBE_124_MARK = 3527,
	STP_ISD_0_MARK___2 = 3528,
	PDM4_CLK_125_MARK = 3529,
	MSIOF2_TXD_MARK___4 = 3530,
	SIM0_VOLTSEL0_MARK = 3531,
	TS_SDEN_MARK___2 = 3532,
	MSIOF7_SYNC_MARK = 3533,
	STP_ISEN_1_MARK = 3534,
	STP_ISEN_0_MARK___2 = 3535,
	PDM1_OUTDATA_128_MARK = 3536,
	MSIOF2_SYNC_MARK___3 = 3537,
	SIM1_VOLTSEL1_MARK = 3538,
	TS_SPSYNC_MARK___2 = 3539,
	MSIOF7_RXD_MARK = 3540,
	STP_ISSYNC_1_MARK = 3541,
	STP_ISSYNC_0_MARK___2 = 3542,
	PDM4_DATA_130_MARK = 3543,
	MSIOF2_RXD_MARK___3 = 3544,
	SIM0_VOLTSEL1_MARK = 3545,
	STP_OPWM_0_MARK___2 = 3546,
	SIM1_PWRON_MARK = 3547,
	TS_SCK_MARK___2 = 3548,
	MSIOF7_SCK_MARK = 3549,
	STP_ISCLK_1_MARK = 3550,
	STP_ISCLK_0_MARK___2 = 3551,
	PDM1_OUTCLK_133_MARK = 3552,
	MSIOF2_SCK_MARK___3 = 3553,
	SIM1_VOLTSEL0_MARK = 3554,
	TS_SDAT_MARK = 3555,
	MSIOF7_TXD_MARK = 3556,
	STP_ISD_1_MARK = 3557,
	IRQ20_MARK = 3558,
	IRQ21_MARK = 3559,
	IRQ22_MARK = 3560,
	IRQ23_MARK = 3561,
	MMCD0_0_MARK___2 = 3562,
	MMCD0_1_MARK___2 = 3563,
	MMCD0_2_MARK___2 = 3564,
	MMCD0_3_MARK___2 = 3565,
	MMCD0_4_MARK___2 = 3566,
	MMCD0_5_MARK___2 = 3567,
	MMCD0_6_MARK___2 = 3568,
	MMCD0_7_MARK___2 = 3569,
	MMCCMD0_MARK___2 = 3570,
	MMCCLK0_MARK___2 = 3571,
	MMCRST_MARK = 3572,
	IRQ24_MARK = 3573,
	IRQ25_MARK = 3574,
	IRQ26_MARK = 3575,
	IRQ27_MARK = 3576,
	A10_MARK___3 = 3577,
	MMCD1_7_MARK___2 = 3578,
	IRQ31_MARK = 3579,
	A9_MARK___3 = 3580,
	MMCD1_6_MARK___2 = 3581,
	IRQ32_MARK = 3582,
	A8_MARK___3 = 3583,
	MMCD1_5_MARK___2 = 3584,
	IRQ33_MARK = 3585,
	A7_MARK___3 = 3586,
	MMCD1_4_MARK___2 = 3587,
	IRQ34_MARK = 3588,
	A6_MARK___3 = 3589,
	MMCD1_3_MARK___2 = 3590,
	IRQ35_MARK = 3591,
	A5_MARK___3 = 3592,
	MMCD1_2_MARK___2 = 3593,
	IRQ36_MARK = 3594,
	A4_MARK___3 = 3595,
	MMCD1_1_MARK___2 = 3596,
	IRQ37_MARK = 3597,
	A3_MARK___3 = 3598,
	MMCD1_0_MARK___2 = 3599,
	IRQ38_MARK = 3600,
	A2_MARK___3 = 3601,
	MMCCMD1_MARK___2 = 3602,
	IRQ39_MARK = 3603,
	A1_MARK___3 = 3604,
	A0_MARK___5 = 3605,
	BS_MARK___2 = 3606,
	CKO_MARK___2 = 3607,
	MMCCLK1_MARK___2 = 3608,
	CS0_N_MARK___3 = 3609,
	SIM0_GPO1_MARK = 3610,
	CS2_N_MARK = 3611,
	SIM0_GPO2_MARK = 3612,
	CS4_N_MARK = 3613,
	VIO_VD_MARK___2 = 3614,
	SIM1_GPO0_MARK = 3615,
	D15_MARK___3 = 3616,
	GIO_OUT15_MARK = 3617,
	D14_MARK___3 = 3618,
	GIO_OUT14_MARK = 3619,
	D13_MARK___3 = 3620,
	GIO_OUT13_MARK = 3621,
	D12_MARK___3 = 3622,
	GIO_OUT12_MARK = 3623,
	D11_MARK___3 = 3624,
	WGM_TXP2_MARK = 3625,
	D10_MARK___3 = 3626,
	WGM_GPS_TIMEM_ASK_RFCLK_MARK = 3627,
	D9_MARK___3 = 3628,
	VIO_D9_MARK___2 = 3629,
	GIO_OUT9_MARK = 3630,
	D8_MARK___3 = 3631,
	VIO_D8_MARK___2 = 3632,
	GIO_OUT8_MARK = 3633,
	D7_MARK___3 = 3634,
	VIO_D7_MARK___2 = 3635,
	GIO_OUT7_MARK = 3636,
	D6_MARK___3 = 3637,
	VIO_D6_MARK___2 = 3638,
	GIO_OUT6_MARK = 3639,
	D5_MARK___3 = 3640,
	VIO_D5_MARK___2 = 3641,
	GIO_OUT5_217_MARK = 3642,
	D4_MARK___3 = 3643,
	VIO_D4_MARK___2 = 3644,
	GIO_OUT4_218_MARK = 3645,
	D3_MARK___3 = 3646,
	VIO_D3_MARK___2 = 3647,
	GIO_OUT3_219_MARK = 3648,
	D2_MARK___3 = 3649,
	VIO_D2_MARK___2 = 3650,
	GIO_OUT2_220_MARK = 3651,
	D1_MARK___3 = 3652,
	VIO_D1_MARK___2 = 3653,
	GIO_OUT1_221_MARK = 3654,
	D0_MARK___3 = 3655,
	VIO_D0_MARK___2 = 3656,
	GIO_OUT0_222_MARK = 3657,
	RDWR_224_MARK = 3658,
	VIO_HD_MARK___2 = 3659,
	SIM1_GPO2_MARK = 3660,
	RD_N_MARK___3 = 3661,
	WAIT_N_MARK = 3662,
	VIO_CLK_MARK___2 = 3663,
	SIM1_GPO1_MARK = 3664,
	WE0_N_MARK___3 = 3665,
	RDWR_227_MARK = 3666,
	WE1_N_MARK___3 = 3667,
	SIM0_GPO0_MARK = 3668,
	PWMO_MARK = 3669,
	VIO_CKO1_229_MARK = 3670,
	SLIM_CLK_MARK = 3671,
	VIO_CKO4_230_MARK = 3672,
	SLIM_DATA_MARK = 3673,
	VIO_CKO5_231_MARK = 3674,
	VIO_CKO2_232_MARK = 3675,
	SF_PORT_0_232_MARK = 3676,
	VIO_CKO3_233_MARK = 3677,
	SF_PORT_1_233_MARK = 3678,
	FSIACK_MARK___2 = 3679,
	PDM3_CLK_234_MARK = 3680,
	ISP_IRIS1_234_MARK = 3681,
	FSIAISLD_MARK___2 = 3682,
	PDM3_DATA_235_MARK = 3683,
	FSIAOMC_MARK___2 = 3684,
	PDM0_OUTCLK_236_MARK = 3685,
	ISP_IRIS0_236_MARK = 3686,
	FSIAOLR_MARK___2 = 3687,
	FSIAILR_MARK___2 = 3688,
	FSIAOBT_MARK___2 = 3689,
	FSIAIBT_MARK___2 = 3690,
	FSIAOSLD_MARK___2 = 3691,
	PDM0_OUTDATA_239_MARK = 3692,
	FSIBISLD_MARK___2 = 3693,
	FSIBOLR_MARK___2 = 3694,
	FSIBILR_MARK___2 = 3695,
	FSIBOMC_MARK___2 = 3696,
	ISP_SHUTTER1_242_MARK = 3697,
	FSIBOBT_MARK___2 = 3698,
	FSIBIBT_MARK___2 = 3699,
	FSIBOSLD_MARK___2 = 3700,
	FSIASPDIF_MARK___2 = 3701,
	FSIBCK_MARK___2 = 3702,
	ISP_SHUTTER0_245_MARK = 3703,
	ISP_IRIS1_246_MARK = 3704,
	ISP_IRIS0_247_MARK = 3705,
	ISP_SHUTTER1_248_MARK = 3706,
	ISP_SHUTTER0_249_MARK = 3707,
	ISP_STROBE_250_MARK = 3708,
	MSIOF0_SYNC_MARK___3 = 3709,
	MSIOF0_RXD_MARK___4 = 3710,
	MSIOF0_SCK_MARK___3 = 3711,
	MSIOF0_SS2_MARK___4 = 3712,
	VIO_CKO3_259_MARK = 3713,
	MSIOF0_TXD_MARK___4 = 3714,
	SCIFB1_SCK_261_MARK = 3715,
	CHSCIF1_HSCK_MARK = 3716,
	SCIFB2_SCK_262_MARK = 3717,
	MSIOF1_SS2_MARK___4 = 3718,
	MSIOF5_SS2_MARK = 3719,
	MSIOF1_TXD_MARK___4 = 3720,
	MSIOF5_TXD_MARK = 3721,
	MSIOF1_RXD_MARK___4 = 3722,
	MSIOF5_RXD_MARK = 3723,
	MSIOF1_SS1_MARK___4 = 3724,
	MSIOF5_SS1_MARK = 3725,
	MSIOF0_SS1_MARK___4 = 3726,
	MSIOF1_SCK_MARK___3 = 3727,
	MSIOF5_SCK_MARK = 3728,
	MSIOF1_SYNC_MARK___3 = 3729,
	MSIOF5_SYNC_MARK = 3730,
	MSIOF2_SS1_MARK___3 = 3731,
	VIO_CKO5_270_MARK = 3732,
	MSIOF2_SS2_MARK___3 = 3733,
	VIO_CKO2_271_MARK = 3734,
	MSIOF3_SS2_MARK = 3735,
	VIO_CKO1_272_MARK = 3736,
	MSIOF3_SS1_MARK = 3737,
	VIO_CKO4_273_MARK = 3738,
	MSIOF4_SS2_MARK = 3739,
	TPU1TO0_MARK___2 = 3740,
	IC_DP_MARK = 3741,
	SIM0_RST_MARK___2 = 3742,
	IC_DM_MARK = 3743,
	SIM0_BSICOMP_MARK = 3744,
	SIM0_CLK_MARK___2 = 3745,
	SIM0_IO_MARK = 3746,
	SIM1_IO_MARK = 3747,
	PDM2_DATA_281_MARK = 3748,
	SIM1_CLK_MARK = 3749,
	PDM2_CLK_282_MARK = 3750,
	SIM1_RST_MARK = 3751,
	SDHID1_0_MARK___2 = 3752,
	STMDATA0_2_MARK = 3753,
	SDHID1_1_MARK___2 = 3754,
	STMDATA1_2_MARK = 3755,
	IRQ51_MARK = 3756,
	SDHID1_2_MARK___2 = 3757,
	STMDATA2_2_MARK = 3758,
	SDHID1_3_MARK___2 = 3759,
	STMDATA3_2_MARK = 3760,
	SDHICLK1_MARK___2 = 3761,
	STMCLK_2_MARK = 3762,
	SDHICMD1_MARK___2 = 3763,
	STMSIDI_2_MARK = 3764,
	SDHID2_0_MARK___2 = 3765,
	MSIOF4_TXD_MARK = 3766,
	SCIFB2_TXD_295_MARK = 3767,
	MSIOF6_TXD_MARK = 3768,
	SDHID2_1_MARK___2 = 3769,
	MSIOF6_SS2_MARK = 3770,
	IRQ52_MARK = 3771,
	SDHID2_2_MARK___2 = 3772,
	MSIOF4_RXD_MARK = 3773,
	SCIFB2_RXD_297_MARK = 3774,
	MSIOF6_RXD_MARK = 3775,
	SDHID2_3_MARK___2 = 3776,
	MSIOF4_SYNC_MARK = 3777,
	SCIFB2_CTS_298_MARK = 3778,
	MSIOF6_SYNC_MARK = 3779,
	SDHICLK2_MARK___2 = 3780,
	MSIOF4_SCK_MARK = 3781,
	SCIFB2_SCK_299_MARK = 3782,
	MSIOF6_SCK_MARK = 3783,
	SDHICMD2_MARK___2 = 3784,
	MSIOF4_SS1_MARK = 3785,
	SCIFB2_RTS_300_MARK = 3786,
	MSIOF6_SS1_MARK = 3787,
	SDHICD0_MARK___2 = 3788,
	IRQ50_MARK = 3789,
	SDHID0_0_MARK___2 = 3790,
	STMDATA0_1_MARK = 3791,
	SDHID0_1_MARK___2 = 3792,
	STMDATA1_1_MARK = 3793,
	SDHID0_2_MARK___2 = 3794,
	STMDATA2_1_MARK = 3795,
	SDHID0_3_MARK___2 = 3796,
	STMDATA3_1_MARK = 3797,
	SDHICMD0_MARK___2 = 3798,
	STMSIDI_1_MARK = 3799,
	SDHIWP0_MARK___2 = 3800,
	SDHICLK0_MARK___2 = 3801,
	STMCLK_1_MARK = 3802,
	IRQ16_MARK = 3803,
	IRQ17_MARK = 3804,
	IRQ28_MARK = 3805,
	IRQ29_MARK = 3806,
	IRQ30_MARK = 3807,
	IRQ53_MARK = 3808,
	IRQ54_MARK = 3809,
	IRQ55_MARK = 3810,
	IRQ56_MARK = 3811,
	IRQ57_MARK = 3812,
	PINMUX_MARK_END___5 = 3813,
};

enum {
	PINMUX_RESERVED___6 = 0,
	PINMUX_DATA_BEGIN___6 = 1,
	PORT0_DATA___3 = 2,
	PORT1_DATA___3 = 3,
	PORT2_DATA___3 = 4,
	PORT3_DATA___3 = 5,
	PORT4_DATA___3 = 6,
	PORT5_DATA___3 = 7,
	PORT6_DATA___3 = 8,
	PORT7_DATA___3 = 9,
	PORT8_DATA___3 = 10,
	PORT9_DATA___3 = 11,
	PORT10_DATA___3 = 12,
	PORT11_DATA___3 = 13,
	PORT12_DATA___3 = 14,
	PORT13_DATA___3 = 15,
	PORT14_DATA___3 = 16,
	PORT15_DATA___3 = 17,
	PORT16_DATA___3 = 18,
	PORT17_DATA___3 = 19,
	PORT18_DATA___3 = 20,
	PORT19_DATA___3 = 21,
	PORT20_DATA___3 = 22,
	PORT21_DATA___3 = 23,
	PORT22_DATA___3 = 24,
	PORT23_DATA___3 = 25,
	PORT24_DATA___3 = 26,
	PORT25_DATA___3 = 27,
	PORT26_DATA___3 = 28,
	PORT27_DATA___3 = 29,
	PORT28_DATA___3 = 30,
	PORT29_DATA___3 = 31,
	PORT30_DATA___3 = 32,
	PORT31_DATA___2 = 33,
	PORT32_DATA___3 = 34,
	PORT33_DATA___3 = 35,
	PORT34_DATA___3 = 36,
	PORT35_DATA___3 = 37,
	PORT36_DATA___3 = 38,
	PORT37_DATA___3 = 39,
	PORT38_DATA___3 = 40,
	PORT39_DATA___3 = 41,
	PORT40_DATA___3 = 42,
	PORT41_DATA___2 = 43,
	PORT42_DATA___2 = 44,
	PORT43_DATA___2 = 45,
	PORT44_DATA___2 = 46,
	PORT45_DATA___2 = 47,
	PORT46_DATA___2 = 48,
	PORT47_DATA___2 = 49,
	PORT48_DATA___2 = 50,
	PORT49_DATA___2 = 51,
	PORT50_DATA___2 = 52,
	PORT51_DATA___2 = 53,
	PORT52_DATA___2 = 54,
	PORT53_DATA___2 = 55,
	PORT54_DATA___2 = 56,
	PORT55_DATA___2 = 57,
	PORT56_DATA___2 = 58,
	PORT57_DATA___2 = 59,
	PORT58_DATA___2 = 60,
	PORT59_DATA___2 = 61,
	PORT60_DATA___2 = 62,
	PORT61_DATA___2 = 63,
	PORT62_DATA___2 = 64,
	PORT63_DATA___2 = 65,
	PORT64_DATA___3 = 66,
	PORT65_DATA___3 = 67,
	PORT66_DATA___3 = 68,
	PORT67_DATA___3 = 69,
	PORT68_DATA___3 = 70,
	PORT69_DATA___3 = 71,
	PORT70_DATA___3 = 72,
	PORT71_DATA___3 = 73,
	PORT72_DATA___3 = 74,
	PORT73_DATA___3 = 75,
	PORT74_DATA___3 = 76,
	PORT75_DATA___3 = 77,
	PORT76_DATA___3 = 78,
	PORT77_DATA___3 = 79,
	PORT78_DATA___3 = 80,
	PORT79_DATA___3 = 81,
	PORT80_DATA___3 = 82,
	PORT81_DATA___3 = 83,
	PORT82_DATA___3 = 84,
	PORT83_DATA___3 = 85,
	PORT84_DATA___3 = 86,
	PORT85_DATA___3 = 87,
	PORT86_DATA___2 = 88,
	PORT87_DATA___2 = 89,
	PORT88_DATA___2 = 90,
	PORT89_DATA___2 = 91,
	PORT90_DATA___2 = 92,
	PORT91_DATA___2 = 93,
	PORT92_DATA___2 = 94,
	PORT93_DATA___2 = 95,
	PORT94_DATA___2 = 96,
	PORT95_DATA___2 = 97,
	PORT96_DATA___3 = 98,
	PORT97_DATA___3 = 99,
	PORT98_DATA___3 = 100,
	PORT99_DATA___3 = 101,
	PORT100_DATA___3 = 102,
	PORT101_DATA___3 = 103,
	PORT102_DATA___3 = 104,
	PORT103_DATA___3 = 105,
	PORT104_DATA___3 = 106,
	PORT105_DATA___3 = 107,
	PORT106_DATA___3 = 108,
	PORT107_DATA___3 = 109,
	PORT108_DATA___3 = 110,
	PORT109_DATA___3 = 111,
	PORT110_DATA___3 = 112,
	PORT111_DATA___3 = 113,
	PORT112_DATA___3 = 114,
	PORT113_DATA___3 = 115,
	PORT114_DATA___3 = 116,
	PORT115_DATA___3 = 117,
	PORT116_DATA___3 = 118,
	PORT117_DATA___3 = 119,
	PORT118_DATA___3 = 120,
	PORT119_DATA___2 = 121,
	PORT120_DATA___2 = 122,
	PORT121_DATA___2 = 123,
	PORT122_DATA___2 = 124,
	PORT123_DATA___2 = 125,
	PORT124_DATA___2 = 126,
	PORT125_DATA___2 = 127,
	PORT126_DATA___2 = 128,
	PORT127_DATA = 129,
	PORT128_DATA___3 = 130,
	PORT129_DATA___3 = 131,
	PORT130_DATA___3 = 132,
	PORT131_DATA___3 = 133,
	PORT132_DATA___3 = 134,
	PORT133_DATA___3 = 135,
	PORT134_DATA___3 = 136,
	PORT135_DATA___2 = 137,
	PORT136_DATA___2 = 138,
	PORT137_DATA___2 = 139,
	PORT138_DATA___2 = 140,
	PORT139_DATA___2 = 141,
	PORT140_DATA___2 = 142,
	PORT141_DATA___2 = 143,
	PORT142_DATA___2 = 144,
	PORT143_DATA___2 = 145,
	PORT144_DATA___2 = 146,
	PORT145_DATA___2 = 147,
	PORT146_DATA___2 = 148,
	PORT147_DATA___2 = 149,
	PORT148_DATA___2 = 150,
	PORT149_DATA___2 = 151,
	PORT150_DATA___2 = 152,
	PORT151_DATA___2 = 153,
	PORT152_DATA___2 = 154,
	PORT153_DATA___2 = 155,
	PORT154_DATA___2 = 156,
	PORT155_DATA___2 = 157,
	PORT156_DATA___2 = 158,
	PORT157_DATA___2 = 159,
	PORT158_DATA___2 = 160,
	PORT159_DATA___2 = 161,
	PORT160_DATA___3 = 162,
	PORT161_DATA___3 = 163,
	PORT162_DATA___3 = 164,
	PORT163_DATA___3 = 165,
	PORT164_DATA___3 = 166,
	PORT165_DATA___2 = 167,
	PORT166_DATA___2 = 168,
	PORT167_DATA___2 = 169,
	PORT168_DATA___2 = 170,
	PORT169_DATA___2 = 171,
	PORT170_DATA___2 = 172,
	PORT171_DATA___2 = 173,
	PORT172_DATA___2 = 174,
	PORT173_DATA___2 = 175,
	PORT174_DATA___2 = 176,
	PORT175_DATA___2 = 177,
	PORT176_DATA___2 = 178,
	PORT177_DATA___2 = 179,
	PORT178_DATA___2 = 180,
	PORT179_DATA = 181,
	PORT180_DATA = 182,
	PORT181_DATA = 183,
	PORT182_DATA = 184,
	PORT183_DATA = 185,
	PORT184_DATA = 186,
	PORT185_DATA = 187,
	PORT186_DATA = 188,
	PORT187_DATA = 189,
	PORT188_DATA = 190,
	PORT189_DATA = 191,
	PORT190_DATA = 192,
	PORT191_DATA = 193,
	PORT192_DATA___3 = 194,
	PORT193_DATA___3 = 195,
	PORT194_DATA___3 = 196,
	PORT195_DATA___3 = 197,
	PORT196_DATA___3 = 198,
	PORT197_DATA___3 = 199,
	PORT198_DATA___3 = 200,
	PORT199_DATA___3 = 201,
	PORT200_DATA___3 = 202,
	PORT201_DATA___3 = 203,
	PORT202_DATA___3 = 204,
	PORT203_DATA___3 = 205,
	PORT204_DATA___3 = 206,
	PORT205_DATA___3 = 207,
	PORT206_DATA___3 = 208,
	PORT207_DATA___3 = 209,
	PORT208_DATA___3 = 210,
	PORT209_DATA___3 = 211,
	PORT210_DATA___3 = 212,
	PORT211_DATA___3 = 213,
	PINMUX_DATA_END___6 = 214,
	PINMUX_INPUT_BEGIN___3 = 215,
	PORT0_IN___3 = 216,
	PORT1_IN___3 = 217,
	PORT2_IN___3 = 218,
	PORT3_IN___3 = 219,
	PORT4_IN___3 = 220,
	PORT5_IN___3 = 221,
	PORT6_IN___3 = 222,
	PORT7_IN___3 = 223,
	PORT8_IN___3 = 224,
	PORT9_IN___3 = 225,
	PORT10_IN___3 = 226,
	PORT11_IN___3 = 227,
	PORT12_IN___3 = 228,
	PORT13_IN___3 = 229,
	PORT14_IN___3 = 230,
	PORT15_IN___3 = 231,
	PORT16_IN___3 = 232,
	PORT17_IN___3 = 233,
	PORT18_IN___3 = 234,
	PORT19_IN___3 = 235,
	PORT20_IN___3 = 236,
	PORT21_IN___3 = 237,
	PORT22_IN___3 = 238,
	PORT23_IN___3 = 239,
	PORT24_IN___3 = 240,
	PORT25_IN___3 = 241,
	PORT26_IN___3 = 242,
	PORT27_IN___3 = 243,
	PORT28_IN___3 = 244,
	PORT29_IN___3 = 245,
	PORT30_IN___3 = 246,
	PORT31_IN___2 = 247,
	PORT32_IN___3 = 248,
	PORT33_IN___3 = 249,
	PORT34_IN___3 = 250,
	PORT35_IN___3 = 251,
	PORT36_IN___3 = 252,
	PORT37_IN___3 = 253,
	PORT38_IN___3 = 254,
	PORT39_IN___3 = 255,
	PORT40_IN___3 = 256,
	PORT41_IN___2 = 257,
	PORT42_IN___2 = 258,
	PORT43_IN___2 = 259,
	PORT44_IN___2 = 260,
	PORT45_IN___2 = 261,
	PORT46_IN___2 = 262,
	PORT47_IN___2 = 263,
	PORT48_IN___2 = 264,
	PORT49_IN___2 = 265,
	PORT50_IN___2 = 266,
	PORT51_IN___2 = 267,
	PORT52_IN___2 = 268,
	PORT53_IN___2 = 269,
	PORT54_IN___2 = 270,
	PORT55_IN___2 = 271,
	PORT56_IN___2 = 272,
	PORT57_IN___2 = 273,
	PORT58_IN___2 = 274,
	PORT59_IN___2 = 275,
	PORT60_IN___2 = 276,
	PORT61_IN___2 = 277,
	PORT62_IN___2 = 278,
	PORT63_IN___2 = 279,
	PORT64_IN___3 = 280,
	PORT65_IN___3 = 281,
	PORT66_IN___3 = 282,
	PORT67_IN___3 = 283,
	PORT68_IN___3 = 284,
	PORT69_IN___3 = 285,
	PORT70_IN___3 = 286,
	PORT71_IN___3 = 287,
	PORT72_IN___3 = 288,
	PORT73_IN___3 = 289,
	PORT74_IN___3 = 290,
	PORT75_IN___3 = 291,
	PORT76_IN___3 = 292,
	PORT77_IN___3 = 293,
	PORT78_IN___3 = 294,
	PORT79_IN___3 = 295,
	PORT80_IN___3 = 296,
	PORT81_IN___3 = 297,
	PORT82_IN___3 = 298,
	PORT83_IN___3 = 299,
	PORT84_IN___3 = 300,
	PORT85_IN___3 = 301,
	PORT86_IN___2 = 302,
	PORT87_IN___2 = 303,
	PORT88_IN___2 = 304,
	PORT89_IN___2 = 305,
	PORT90_IN___2 = 306,
	PORT91_IN___2 = 307,
	PORT92_IN___2 = 308,
	PORT93_IN___2 = 309,
	PORT94_IN___2 = 310,
	PORT95_IN___2 = 311,
	PORT96_IN___3 = 312,
	PORT97_IN___3 = 313,
	PORT98_IN___3 = 314,
	PORT99_IN___3 = 315,
	PORT100_IN___3 = 316,
	PORT101_IN___3 = 317,
	PORT102_IN___3 = 318,
	PORT103_IN___3 = 319,
	PORT104_IN___3 = 320,
	PORT105_IN___3 = 321,
	PORT106_IN___3 = 322,
	PORT107_IN___3 = 323,
	PORT108_IN___3 = 324,
	PORT109_IN___3 = 325,
	PORT110_IN___3 = 326,
	PORT111_IN___3 = 327,
	PORT112_IN___3 = 328,
	PORT113_IN___3 = 329,
	PORT114_IN___3 = 330,
	PORT115_IN___3 = 331,
	PORT116_IN___3 = 332,
	PORT117_IN___3 = 333,
	PORT118_IN___3 = 334,
	PORT119_IN___2 = 335,
	PORT120_IN___2 = 336,
	PORT121_IN___2 = 337,
	PORT122_IN___2 = 338,
	PORT123_IN___2 = 339,
	PORT124_IN___2 = 340,
	PORT125_IN___2 = 341,
	PORT126_IN___2 = 342,
	PORT127_IN = 343,
	PORT128_IN___3 = 344,
	PORT129_IN___3 = 345,
	PORT130_IN___3 = 346,
	PORT131_IN___3 = 347,
	PORT132_IN___3 = 348,
	PORT133_IN___3 = 349,
	PORT134_IN___3 = 350,
	PORT135_IN___2 = 351,
	PORT136_IN___2 = 352,
	PORT137_IN___2 = 353,
	PORT138_IN___2 = 354,
	PORT139_IN___2 = 355,
	PORT140_IN___2 = 356,
	PORT141_IN___2 = 357,
	PORT142_IN___2 = 358,
	PORT143_IN___2 = 359,
	PORT144_IN___2 = 360,
	PORT145_IN___2 = 361,
	PORT146_IN___2 = 362,
	PORT147_IN___2 = 363,
	PORT148_IN___2 = 364,
	PORT149_IN___2 = 365,
	PORT150_IN___2 = 366,
	PORT151_IN___2 = 367,
	PORT152_IN___2 = 368,
	PORT153_IN___2 = 369,
	PORT154_IN___2 = 370,
	PORT155_IN___2 = 371,
	PORT156_IN___2 = 372,
	PORT157_IN___2 = 373,
	PORT158_IN___2 = 374,
	PORT159_IN___2 = 375,
	PORT160_IN___3 = 376,
	PORT161_IN___3 = 377,
	PORT162_IN___3 = 378,
	PORT163_IN___3 = 379,
	PORT164_IN___3 = 380,
	PORT165_IN___2 = 381,
	PORT166_IN___2 = 382,
	PORT167_IN___2 = 383,
	PORT168_IN___2 = 384,
	PORT169_IN___2 = 385,
	PORT170_IN___2 = 386,
	PORT171_IN___2 = 387,
	PORT172_IN___2 = 388,
	PORT173_IN___2 = 389,
	PORT174_IN___2 = 390,
	PORT175_IN___2 = 391,
	PORT176_IN___2 = 392,
	PORT177_IN___2 = 393,
	PORT178_IN___2 = 394,
	PORT179_IN = 395,
	PORT180_IN = 396,
	PORT181_IN = 397,
	PORT182_IN = 398,
	PORT183_IN = 399,
	PORT184_IN = 400,
	PORT185_IN = 401,
	PORT186_IN = 402,
	PORT187_IN = 403,
	PORT188_IN = 404,
	PORT189_IN = 405,
	PORT190_IN = 406,
	PORT191_IN = 407,
	PORT192_IN___3 = 408,
	PORT193_IN___3 = 409,
	PORT194_IN___3 = 410,
	PORT195_IN___3 = 411,
	PORT196_IN___3 = 412,
	PORT197_IN___3 = 413,
	PORT198_IN___3 = 414,
	PORT199_IN___3 = 415,
	PORT200_IN___3 = 416,
	PORT201_IN___3 = 417,
	PORT202_IN___3 = 418,
	PORT203_IN___3 = 419,
	PORT204_IN___3 = 420,
	PORT205_IN___3 = 421,
	PORT206_IN___3 = 422,
	PORT207_IN___3 = 423,
	PORT208_IN___3 = 424,
	PORT209_IN___3 = 425,
	PORT210_IN___3 = 426,
	PORT211_IN___3 = 427,
	PINMUX_INPUT_END___3 = 428,
	PINMUX_OUTPUT_BEGIN___3 = 429,
	PORT0_OUT___3 = 430,
	PORT1_OUT___3 = 431,
	PORT2_OUT___3 = 432,
	PORT3_OUT___3 = 433,
	PORT4_OUT___3 = 434,
	PORT5_OUT___3 = 435,
	PORT6_OUT___3 = 436,
	PORT7_OUT___3 = 437,
	PORT8_OUT___3 = 438,
	PORT9_OUT___3 = 439,
	PORT10_OUT___3 = 440,
	PORT11_OUT___3 = 441,
	PORT12_OUT___3 = 442,
	PORT13_OUT___3 = 443,
	PORT14_OUT___3 = 444,
	PORT15_OUT___3 = 445,
	PORT16_OUT___3 = 446,
	PORT17_OUT___3 = 447,
	PORT18_OUT___3 = 448,
	PORT19_OUT___3 = 449,
	PORT20_OUT___3 = 450,
	PORT21_OUT___3 = 451,
	PORT22_OUT___3 = 452,
	PORT23_OUT___3 = 453,
	PORT24_OUT___3 = 454,
	PORT25_OUT___3 = 455,
	PORT26_OUT___3 = 456,
	PORT27_OUT___3 = 457,
	PORT28_OUT___3 = 458,
	PORT29_OUT___3 = 459,
	PORT30_OUT___3 = 460,
	PORT31_OUT___2 = 461,
	PORT32_OUT___3 = 462,
	PORT33_OUT___3 = 463,
	PORT34_OUT___3 = 464,
	PORT35_OUT___3 = 465,
	PORT36_OUT___3 = 466,
	PORT37_OUT___3 = 467,
	PORT38_OUT___3 = 468,
	PORT39_OUT___3 = 469,
	PORT40_OUT___3 = 470,
	PORT41_OUT___2 = 471,
	PORT42_OUT___2 = 472,
	PORT43_OUT___2 = 473,
	PORT44_OUT___2 = 474,
	PORT45_OUT___2 = 475,
	PORT46_OUT___2 = 476,
	PORT47_OUT___2 = 477,
	PORT48_OUT___2 = 478,
	PORT49_OUT___2 = 479,
	PORT50_OUT___2 = 480,
	PORT51_OUT___2 = 481,
	PORT52_OUT___2 = 482,
	PORT53_OUT___2 = 483,
	PORT54_OUT___2 = 484,
	PORT55_OUT___2 = 485,
	PORT56_OUT___2 = 486,
	PORT57_OUT___2 = 487,
	PORT58_OUT___2 = 488,
	PORT59_OUT___2 = 489,
	PORT60_OUT___2 = 490,
	PORT61_OUT___2 = 491,
	PORT62_OUT___2 = 492,
	PORT63_OUT___2 = 493,
	PORT64_OUT___3 = 494,
	PORT65_OUT___3 = 495,
	PORT66_OUT___3 = 496,
	PORT67_OUT___3 = 497,
	PORT68_OUT___3 = 498,
	PORT69_OUT___3 = 499,
	PORT70_OUT___3 = 500,
	PORT71_OUT___3 = 501,
	PORT72_OUT___3 = 502,
	PORT73_OUT___3 = 503,
	PORT74_OUT___3 = 504,
	PORT75_OUT___3 = 505,
	PORT76_OUT___3 = 506,
	PORT77_OUT___3 = 507,
	PORT78_OUT___3 = 508,
	PORT79_OUT___3 = 509,
	PORT80_OUT___3 = 510,
	PORT81_OUT___3 = 511,
	PORT82_OUT___3 = 512,
	PORT83_OUT___3 = 513,
	PORT84_OUT___3 = 514,
	PORT85_OUT___3 = 515,
	PORT86_OUT___2 = 516,
	PORT87_OUT___2 = 517,
	PORT88_OUT___2 = 518,
	PORT89_OUT___2 = 519,
	PORT90_OUT___2 = 520,
	PORT91_OUT___2 = 521,
	PORT92_OUT___2 = 522,
	PORT93_OUT___2 = 523,
	PORT94_OUT___2 = 524,
	PORT95_OUT___2 = 525,
	PORT96_OUT___3 = 526,
	PORT97_OUT___3 = 527,
	PORT98_OUT___3 = 528,
	PORT99_OUT___3 = 529,
	PORT100_OUT___3 = 530,
	PORT101_OUT___3 = 531,
	PORT102_OUT___3 = 532,
	PORT103_OUT___3 = 533,
	PORT104_OUT___3 = 534,
	PORT105_OUT___3 = 535,
	PORT106_OUT___3 = 536,
	PORT107_OUT___3 = 537,
	PORT108_OUT___3 = 538,
	PORT109_OUT___3 = 539,
	PORT110_OUT___3 = 540,
	PORT111_OUT___3 = 541,
	PORT112_OUT___3 = 542,
	PORT113_OUT___3 = 543,
	PORT114_OUT___3 = 544,
	PORT115_OUT___3 = 545,
	PORT116_OUT___3 = 546,
	PORT117_OUT___3 = 547,
	PORT118_OUT___3 = 548,
	PORT119_OUT___2 = 549,
	PORT120_OUT___2 = 550,
	PORT121_OUT___2 = 551,
	PORT122_OUT___2 = 552,
	PORT123_OUT___2 = 553,
	PORT124_OUT___2 = 554,
	PORT125_OUT___2 = 555,
	PORT126_OUT___2 = 556,
	PORT127_OUT = 557,
	PORT128_OUT___3 = 558,
	PORT129_OUT___3 = 559,
	PORT130_OUT___3 = 560,
	PORT131_OUT___3 = 561,
	PORT132_OUT___3 = 562,
	PORT133_OUT___3 = 563,
	PORT134_OUT___3 = 564,
	PORT135_OUT___2 = 565,
	PORT136_OUT___2 = 566,
	PORT137_OUT___2 = 567,
	PORT138_OUT___2 = 568,
	PORT139_OUT___2 = 569,
	PORT140_OUT___2 = 570,
	PORT141_OUT___2 = 571,
	PORT142_OUT___2 = 572,
	PORT143_OUT___2 = 573,
	PORT144_OUT___2 = 574,
	PORT145_OUT___2 = 575,
	PORT146_OUT___2 = 576,
	PORT147_OUT___2 = 577,
	PORT148_OUT___2 = 578,
	PORT149_OUT___2 = 579,
	PORT150_OUT___2 = 580,
	PORT151_OUT___2 = 581,
	PORT152_OUT___2 = 582,
	PORT153_OUT___2 = 583,
	PORT154_OUT___2 = 584,
	PORT155_OUT___2 = 585,
	PORT156_OUT___2 = 586,
	PORT157_OUT___2 = 587,
	PORT158_OUT___2 = 588,
	PORT159_OUT___2 = 589,
	PORT160_OUT___3 = 590,
	PORT161_OUT___3 = 591,
	PORT162_OUT___3 = 592,
	PORT163_OUT___3 = 593,
	PORT164_OUT___3 = 594,
	PORT165_OUT___2 = 595,
	PORT166_OUT___2 = 596,
	PORT167_OUT___2 = 597,
	PORT168_OUT___2 = 598,
	PORT169_OUT___2 = 599,
	PORT170_OUT___2 = 600,
	PORT171_OUT___2 = 601,
	PORT172_OUT___2 = 602,
	PORT173_OUT___2 = 603,
	PORT174_OUT___2 = 604,
	PORT175_OUT___2 = 605,
	PORT176_OUT___2 = 606,
	PORT177_OUT___2 = 607,
	PORT178_OUT___2 = 608,
	PORT179_OUT = 609,
	PORT180_OUT = 610,
	PORT181_OUT = 611,
	PORT182_OUT = 612,
	PORT183_OUT = 613,
	PORT184_OUT = 614,
	PORT185_OUT = 615,
	PORT186_OUT = 616,
	PORT187_OUT = 617,
	PORT188_OUT = 618,
	PORT189_OUT = 619,
	PORT190_OUT = 620,
	PORT191_OUT = 621,
	PORT192_OUT___3 = 622,
	PORT193_OUT___3 = 623,
	PORT194_OUT___3 = 624,
	PORT195_OUT___3 = 625,
	PORT196_OUT___3 = 626,
	PORT197_OUT___3 = 627,
	PORT198_OUT___3 = 628,
	PORT199_OUT___3 = 629,
	PORT200_OUT___3 = 630,
	PORT201_OUT___3 = 631,
	PORT202_OUT___3 = 632,
	PORT203_OUT___3 = 633,
	PORT204_OUT___3 = 634,
	PORT205_OUT___3 = 635,
	PORT206_OUT___3 = 636,
	PORT207_OUT___3 = 637,
	PORT208_OUT___3 = 638,
	PORT209_OUT___3 = 639,
	PORT210_OUT___3 = 640,
	PORT211_OUT___3 = 641,
	PINMUX_OUTPUT_END___3 = 642,
	PINMUX_FUNCTION_BEGIN___6 = 643,
	PORT0_FN_IN___3 = 644,
	PORT1_FN_IN___3 = 645,
	PORT2_FN_IN___3 = 646,
	PORT3_FN_IN___3 = 647,
	PORT4_FN_IN___3 = 648,
	PORT5_FN_IN___3 = 649,
	PORT6_FN_IN___3 = 650,
	PORT7_FN_IN___3 = 651,
	PORT8_FN_IN___3 = 652,
	PORT9_FN_IN___3 = 653,
	PORT10_FN_IN___3 = 654,
	PORT11_FN_IN___3 = 655,
	PORT12_FN_IN___3 = 656,
	PORT13_FN_IN___3 = 657,
	PORT14_FN_IN___3 = 658,
	PORT15_FN_IN___3 = 659,
	PORT16_FN_IN___3 = 660,
	PORT17_FN_IN___3 = 661,
	PORT18_FN_IN___3 = 662,
	PORT19_FN_IN___3 = 663,
	PORT20_FN_IN___3 = 664,
	PORT21_FN_IN___3 = 665,
	PORT22_FN_IN___3 = 666,
	PORT23_FN_IN___3 = 667,
	PORT24_FN_IN___3 = 668,
	PORT25_FN_IN___3 = 669,
	PORT26_FN_IN___3 = 670,
	PORT27_FN_IN___3 = 671,
	PORT28_FN_IN___3 = 672,
	PORT29_FN_IN___3 = 673,
	PORT30_FN_IN___3 = 674,
	PORT31_FN_IN___2 = 675,
	PORT32_FN_IN___3 = 676,
	PORT33_FN_IN___3 = 677,
	PORT34_FN_IN___3 = 678,
	PORT35_FN_IN___3 = 679,
	PORT36_FN_IN___3 = 680,
	PORT37_FN_IN___3 = 681,
	PORT38_FN_IN___3 = 682,
	PORT39_FN_IN___3 = 683,
	PORT40_FN_IN___3 = 684,
	PORT41_FN_IN___2 = 685,
	PORT42_FN_IN___2 = 686,
	PORT43_FN_IN___2 = 687,
	PORT44_FN_IN___2 = 688,
	PORT45_FN_IN___2 = 689,
	PORT46_FN_IN___2 = 690,
	PORT47_FN_IN___2 = 691,
	PORT48_FN_IN___2 = 692,
	PORT49_FN_IN___2 = 693,
	PORT50_FN_IN___2 = 694,
	PORT51_FN_IN___2 = 695,
	PORT52_FN_IN___2 = 696,
	PORT53_FN_IN___2 = 697,
	PORT54_FN_IN___2 = 698,
	PORT55_FN_IN___2 = 699,
	PORT56_FN_IN___2 = 700,
	PORT57_FN_IN___2 = 701,
	PORT58_FN_IN___2 = 702,
	PORT59_FN_IN___2 = 703,
	PORT60_FN_IN___2 = 704,
	PORT61_FN_IN___2 = 705,
	PORT62_FN_IN___2 = 706,
	PORT63_FN_IN___2 = 707,
	PORT64_FN_IN___3 = 708,
	PORT65_FN_IN___3 = 709,
	PORT66_FN_IN___3 = 710,
	PORT67_FN_IN___3 = 711,
	PORT68_FN_IN___3 = 712,
	PORT69_FN_IN___3 = 713,
	PORT70_FN_IN___3 = 714,
	PORT71_FN_IN___3 = 715,
	PORT72_FN_IN___3 = 716,
	PORT73_FN_IN___3 = 717,
	PORT74_FN_IN___3 = 718,
	PORT75_FN_IN___3 = 719,
	PORT76_FN_IN___3 = 720,
	PORT77_FN_IN___3 = 721,
	PORT78_FN_IN___3 = 722,
	PORT79_FN_IN___3 = 723,
	PORT80_FN_IN___3 = 724,
	PORT81_FN_IN___3 = 725,
	PORT82_FN_IN___3 = 726,
	PORT83_FN_IN___3 = 727,
	PORT84_FN_IN___3 = 728,
	PORT85_FN_IN___3 = 729,
	PORT86_FN_IN___2 = 730,
	PORT87_FN_IN___2 = 731,
	PORT88_FN_IN___2 = 732,
	PORT89_FN_IN___2 = 733,
	PORT90_FN_IN___2 = 734,
	PORT91_FN_IN___2 = 735,
	PORT92_FN_IN___2 = 736,
	PORT93_FN_IN___2 = 737,
	PORT94_FN_IN___2 = 738,
	PORT95_FN_IN___2 = 739,
	PORT96_FN_IN___3 = 740,
	PORT97_FN_IN___3 = 741,
	PORT98_FN_IN___3 = 742,
	PORT99_FN_IN___3 = 743,
	PORT100_FN_IN___3 = 744,
	PORT101_FN_IN___3 = 745,
	PORT102_FN_IN___3 = 746,
	PORT103_FN_IN___3 = 747,
	PORT104_FN_IN___3 = 748,
	PORT105_FN_IN___3 = 749,
	PORT106_FN_IN___3 = 750,
	PORT107_FN_IN___3 = 751,
	PORT108_FN_IN___3 = 752,
	PORT109_FN_IN___3 = 753,
	PORT110_FN_IN___3 = 754,
	PORT111_FN_IN___3 = 755,
	PORT112_FN_IN___3 = 756,
	PORT113_FN_IN___3 = 757,
	PORT114_FN_IN___3 = 758,
	PORT115_FN_IN___3 = 759,
	PORT116_FN_IN___3 = 760,
	PORT117_FN_IN___3 = 761,
	PORT118_FN_IN___3 = 762,
	PORT119_FN_IN___2 = 763,
	PORT120_FN_IN___2 = 764,
	PORT121_FN_IN___2 = 765,
	PORT122_FN_IN___2 = 766,
	PORT123_FN_IN___2 = 767,
	PORT124_FN_IN___2 = 768,
	PORT125_FN_IN___2 = 769,
	PORT126_FN_IN___2 = 770,
	PORT127_FN_IN = 771,
	PORT128_FN_IN___3 = 772,
	PORT129_FN_IN___3 = 773,
	PORT130_FN_IN___3 = 774,
	PORT131_FN_IN___3 = 775,
	PORT132_FN_IN___3 = 776,
	PORT133_FN_IN___3 = 777,
	PORT134_FN_IN___3 = 778,
	PORT135_FN_IN___2 = 779,
	PORT136_FN_IN___2 = 780,
	PORT137_FN_IN___2 = 781,
	PORT138_FN_IN___2 = 782,
	PORT139_FN_IN___2 = 783,
	PORT140_FN_IN___2 = 784,
	PORT141_FN_IN___2 = 785,
	PORT142_FN_IN___2 = 786,
	PORT143_FN_IN___2 = 787,
	PORT144_FN_IN___2 = 788,
	PORT145_FN_IN___2 = 789,
	PORT146_FN_IN___2 = 790,
	PORT147_FN_IN___2 = 791,
	PORT148_FN_IN___2 = 792,
	PORT149_FN_IN___2 = 793,
	PORT150_FN_IN___2 = 794,
	PORT151_FN_IN___2 = 795,
	PORT152_FN_IN___2 = 796,
	PORT153_FN_IN___2 = 797,
	PORT154_FN_IN___2 = 798,
	PORT155_FN_IN___2 = 799,
	PORT156_FN_IN___2 = 800,
	PORT157_FN_IN___2 = 801,
	PORT158_FN_IN___2 = 802,
	PORT159_FN_IN___2 = 803,
	PORT160_FN_IN___3 = 804,
	PORT161_FN_IN___3 = 805,
	PORT162_FN_IN___3 = 806,
	PORT163_FN_IN___3 = 807,
	PORT164_FN_IN___3 = 808,
	PORT165_FN_IN___2 = 809,
	PORT166_FN_IN___2 = 810,
	PORT167_FN_IN___2 = 811,
	PORT168_FN_IN___2 = 812,
	PORT169_FN_IN___2 = 813,
	PORT170_FN_IN___2 = 814,
	PORT171_FN_IN___2 = 815,
	PORT172_FN_IN___2 = 816,
	PORT173_FN_IN___2 = 817,
	PORT174_FN_IN___2 = 818,
	PORT175_FN_IN___2 = 819,
	PORT176_FN_IN___2 = 820,
	PORT177_FN_IN___2 = 821,
	PORT178_FN_IN___2 = 822,
	PORT179_FN_IN = 823,
	PORT180_FN_IN = 824,
	PORT181_FN_IN = 825,
	PORT182_FN_IN = 826,
	PORT183_FN_IN = 827,
	PORT184_FN_IN = 828,
	PORT185_FN_IN = 829,
	PORT186_FN_IN = 830,
	PORT187_FN_IN = 831,
	PORT188_FN_IN = 832,
	PORT189_FN_IN = 833,
	PORT190_FN_IN = 834,
	PORT191_FN_IN = 835,
	PORT192_FN_IN___3 = 836,
	PORT193_FN_IN___3 = 837,
	PORT194_FN_IN___3 = 838,
	PORT195_FN_IN___3 = 839,
	PORT196_FN_IN___3 = 840,
	PORT197_FN_IN___3 = 841,
	PORT198_FN_IN___3 = 842,
	PORT199_FN_IN___3 = 843,
	PORT200_FN_IN___3 = 844,
	PORT201_FN_IN___3 = 845,
	PORT202_FN_IN___3 = 846,
	PORT203_FN_IN___3 = 847,
	PORT204_FN_IN___3 = 848,
	PORT205_FN_IN___3 = 849,
	PORT206_FN_IN___3 = 850,
	PORT207_FN_IN___3 = 851,
	PORT208_FN_IN___3 = 852,
	PORT209_FN_IN___3 = 853,
	PORT210_FN_IN___3 = 854,
	PORT211_FN_IN___3 = 855,
	PORT0_FN_OUT___3 = 856,
	PORT1_FN_OUT___3 = 857,
	PORT2_FN_OUT___3 = 858,
	PORT3_FN_OUT___3 = 859,
	PORT4_FN_OUT___3 = 860,
	PORT5_FN_OUT___3 = 861,
	PORT6_FN_OUT___3 = 862,
	PORT7_FN_OUT___3 = 863,
	PORT8_FN_OUT___3 = 864,
	PORT9_FN_OUT___3 = 865,
	PORT10_FN_OUT___3 = 866,
	PORT11_FN_OUT___3 = 867,
	PORT12_FN_OUT___3 = 868,
	PORT13_FN_OUT___3 = 869,
	PORT14_FN_OUT___3 = 870,
	PORT15_FN_OUT___3 = 871,
	PORT16_FN_OUT___3 = 872,
	PORT17_FN_OUT___3 = 873,
	PORT18_FN_OUT___3 = 874,
	PORT19_FN_OUT___3 = 875,
	PORT20_FN_OUT___3 = 876,
	PORT21_FN_OUT___3 = 877,
	PORT22_FN_OUT___3 = 878,
	PORT23_FN_OUT___3 = 879,
	PORT24_FN_OUT___3 = 880,
	PORT25_FN_OUT___3 = 881,
	PORT26_FN_OUT___3 = 882,
	PORT27_FN_OUT___3 = 883,
	PORT28_FN_OUT___3 = 884,
	PORT29_FN_OUT___3 = 885,
	PORT30_FN_OUT___3 = 886,
	PORT31_FN_OUT___2 = 887,
	PORT32_FN_OUT___3 = 888,
	PORT33_FN_OUT___3 = 889,
	PORT34_FN_OUT___3 = 890,
	PORT35_FN_OUT___3 = 891,
	PORT36_FN_OUT___3 = 892,
	PORT37_FN_OUT___3 = 893,
	PORT38_FN_OUT___3 = 894,
	PORT39_FN_OUT___3 = 895,
	PORT40_FN_OUT___3 = 896,
	PORT41_FN_OUT___2 = 897,
	PORT42_FN_OUT___2 = 898,
	PORT43_FN_OUT___2 = 899,
	PORT44_FN_OUT___2 = 900,
	PORT45_FN_OUT___2 = 901,
	PORT46_FN_OUT___2 = 902,
	PORT47_FN_OUT___2 = 903,
	PORT48_FN_OUT___2 = 904,
	PORT49_FN_OUT___2 = 905,
	PORT50_FN_OUT___2 = 906,
	PORT51_FN_OUT___2 = 907,
	PORT52_FN_OUT___2 = 908,
	PORT53_FN_OUT___2 = 909,
	PORT54_FN_OUT___2 = 910,
	PORT55_FN_OUT___2 = 911,
	PORT56_FN_OUT___2 = 912,
	PORT57_FN_OUT___2 = 913,
	PORT58_FN_OUT___2 = 914,
	PORT59_FN_OUT___2 = 915,
	PORT60_FN_OUT___2 = 916,
	PORT61_FN_OUT___2 = 917,
	PORT62_FN_OUT___2 = 918,
	PORT63_FN_OUT___2 = 919,
	PORT64_FN_OUT___3 = 920,
	PORT65_FN_OUT___3 = 921,
	PORT66_FN_OUT___3 = 922,
	PORT67_FN_OUT___3 = 923,
	PORT68_FN_OUT___3 = 924,
	PORT69_FN_OUT___3 = 925,
	PORT70_FN_OUT___3 = 926,
	PORT71_FN_OUT___3 = 927,
	PORT72_FN_OUT___3 = 928,
	PORT73_FN_OUT___3 = 929,
	PORT74_FN_OUT___3 = 930,
	PORT75_FN_OUT___3 = 931,
	PORT76_FN_OUT___3 = 932,
	PORT77_FN_OUT___3 = 933,
	PORT78_FN_OUT___3 = 934,
	PORT79_FN_OUT___3 = 935,
	PORT80_FN_OUT___3 = 936,
	PORT81_FN_OUT___3 = 937,
	PORT82_FN_OUT___3 = 938,
	PORT83_FN_OUT___3 = 939,
	PORT84_FN_OUT___3 = 940,
	PORT85_FN_OUT___3 = 941,
	PORT86_FN_OUT___2 = 942,
	PORT87_FN_OUT___2 = 943,
	PORT88_FN_OUT___2 = 944,
	PORT89_FN_OUT___2 = 945,
	PORT90_FN_OUT___2 = 946,
	PORT91_FN_OUT___2 = 947,
	PORT92_FN_OUT___2 = 948,
	PORT93_FN_OUT___2 = 949,
	PORT94_FN_OUT___2 = 950,
	PORT95_FN_OUT___2 = 951,
	PORT96_FN_OUT___3 = 952,
	PORT97_FN_OUT___3 = 953,
	PORT98_FN_OUT___3 = 954,
	PORT99_FN_OUT___3 = 955,
	PORT100_FN_OUT___3 = 956,
	PORT101_FN_OUT___3 = 957,
	PORT102_FN_OUT___3 = 958,
	PORT103_FN_OUT___3 = 959,
	PORT104_FN_OUT___3 = 960,
	PORT105_FN_OUT___3 = 961,
	PORT106_FN_OUT___3 = 962,
	PORT107_FN_OUT___3 = 963,
	PORT108_FN_OUT___3 = 964,
	PORT109_FN_OUT___3 = 965,
	PORT110_FN_OUT___3 = 966,
	PORT111_FN_OUT___3 = 967,
	PORT112_FN_OUT___3 = 968,
	PORT113_FN_OUT___3 = 969,
	PORT114_FN_OUT___3 = 970,
	PORT115_FN_OUT___3 = 971,
	PORT116_FN_OUT___3 = 972,
	PORT117_FN_OUT___3 = 973,
	PORT118_FN_OUT___3 = 974,
	PORT119_FN_OUT___2 = 975,
	PORT120_FN_OUT___2 = 976,
	PORT121_FN_OUT___2 = 977,
	PORT122_FN_OUT___2 = 978,
	PORT123_FN_OUT___2 = 979,
	PORT124_FN_OUT___2 = 980,
	PORT125_FN_OUT___2 = 981,
	PORT126_FN_OUT___2 = 982,
	PORT127_FN_OUT = 983,
	PORT128_FN_OUT___3 = 984,
	PORT129_FN_OUT___3 = 985,
	PORT130_FN_OUT___3 = 986,
	PORT131_FN_OUT___3 = 987,
	PORT132_FN_OUT___3 = 988,
	PORT133_FN_OUT___3 = 989,
	PORT134_FN_OUT___3 = 990,
	PORT135_FN_OUT___2 = 991,
	PORT136_FN_OUT___2 = 992,
	PORT137_FN_OUT___2 = 993,
	PORT138_FN_OUT___2 = 994,
	PORT139_FN_OUT___2 = 995,
	PORT140_FN_OUT___2 = 996,
	PORT141_FN_OUT___2 = 997,
	PORT142_FN_OUT___2 = 998,
	PORT143_FN_OUT___2 = 999,
	PORT144_FN_OUT___2 = 1000,
	PORT145_FN_OUT___2 = 1001,
	PORT146_FN_OUT___2 = 1002,
	PORT147_FN_OUT___2 = 1003,
	PORT148_FN_OUT___2 = 1004,
	PORT149_FN_OUT___2 = 1005,
	PORT150_FN_OUT___2 = 1006,
	PORT151_FN_OUT___2 = 1007,
	PORT152_FN_OUT___2 = 1008,
	PORT153_FN_OUT___2 = 1009,
	PORT154_FN_OUT___2 = 1010,
	PORT155_FN_OUT___2 = 1011,
	PORT156_FN_OUT___2 = 1012,
	PORT157_FN_OUT___2 = 1013,
	PORT158_FN_OUT___2 = 1014,
	PORT159_FN_OUT___2 = 1015,
	PORT160_FN_OUT___3 = 1016,
	PORT161_FN_OUT___3 = 1017,
	PORT162_FN_OUT___3 = 1018,
	PORT163_FN_OUT___3 = 1019,
	PORT164_FN_OUT___3 = 1020,
	PORT165_FN_OUT___2 = 1021,
	PORT166_FN_OUT___2 = 1022,
	PORT167_FN_OUT___2 = 1023,
	PORT168_FN_OUT___2 = 1024,
	PORT169_FN_OUT___2 = 1025,
	PORT170_FN_OUT___2 = 1026,
	PORT171_FN_OUT___2 = 1027,
	PORT172_FN_OUT___2 = 1028,
	PORT173_FN_OUT___2 = 1029,
	PORT174_FN_OUT___2 = 1030,
	PORT175_FN_OUT___2 = 1031,
	PORT176_FN_OUT___2 = 1032,
	PORT177_FN_OUT___2 = 1033,
	PORT178_FN_OUT___2 = 1034,
	PORT179_FN_OUT = 1035,
	PORT180_FN_OUT = 1036,
	PORT181_FN_OUT = 1037,
	PORT182_FN_OUT = 1038,
	PORT183_FN_OUT = 1039,
	PORT184_FN_OUT = 1040,
	PORT185_FN_OUT = 1041,
	PORT186_FN_OUT = 1042,
	PORT187_FN_OUT = 1043,
	PORT188_FN_OUT = 1044,
	PORT189_FN_OUT = 1045,
	PORT190_FN_OUT = 1046,
	PORT191_FN_OUT = 1047,
	PORT192_FN_OUT___3 = 1048,
	PORT193_FN_OUT___3 = 1049,
	PORT194_FN_OUT___3 = 1050,
	PORT195_FN_OUT___3 = 1051,
	PORT196_FN_OUT___3 = 1052,
	PORT197_FN_OUT___3 = 1053,
	PORT198_FN_OUT___3 = 1054,
	PORT199_FN_OUT___3 = 1055,
	PORT200_FN_OUT___3 = 1056,
	PORT201_FN_OUT___3 = 1057,
	PORT202_FN_OUT___3 = 1058,
	PORT203_FN_OUT___3 = 1059,
	PORT204_FN_OUT___3 = 1060,
	PORT205_FN_OUT___3 = 1061,
	PORT206_FN_OUT___3 = 1062,
	PORT207_FN_OUT___3 = 1063,
	PORT208_FN_OUT___3 = 1064,
	PORT209_FN_OUT___3 = 1065,
	PORT210_FN_OUT___3 = 1066,
	PORT211_FN_OUT___3 = 1067,
	PORT0_FN0___3 = 1068,
	PORT1_FN0___3 = 1069,
	PORT2_FN0___3 = 1070,
	PORT3_FN0___3 = 1071,
	PORT4_FN0___3 = 1072,
	PORT5_FN0___3 = 1073,
	PORT6_FN0___3 = 1074,
	PORT7_FN0___3 = 1075,
	PORT8_FN0___3 = 1076,
	PORT9_FN0___3 = 1077,
	PORT10_FN0___3 = 1078,
	PORT11_FN0___3 = 1079,
	PORT12_FN0___3 = 1080,
	PORT13_FN0___3 = 1081,
	PORT14_FN0___3 = 1082,
	PORT15_FN0___3 = 1083,
	PORT16_FN0___3 = 1084,
	PORT17_FN0___3 = 1085,
	PORT18_FN0___3 = 1086,
	PORT19_FN0___3 = 1087,
	PORT20_FN0___3 = 1088,
	PORT21_FN0___3 = 1089,
	PORT22_FN0___3 = 1090,
	PORT23_FN0___3 = 1091,
	PORT24_FN0___3 = 1092,
	PORT25_FN0___3 = 1093,
	PORT26_FN0___3 = 1094,
	PORT27_FN0___3 = 1095,
	PORT28_FN0___3 = 1096,
	PORT29_FN0___3 = 1097,
	PORT30_FN0___3 = 1098,
	PORT31_FN0___2 = 1099,
	PORT32_FN0___3 = 1100,
	PORT33_FN0___3 = 1101,
	PORT34_FN0___3 = 1102,
	PORT35_FN0___3 = 1103,
	PORT36_FN0___3 = 1104,
	PORT37_FN0___3 = 1105,
	PORT38_FN0___3 = 1106,
	PORT39_FN0___3 = 1107,
	PORT40_FN0___3 = 1108,
	PORT41_FN0___2 = 1109,
	PORT42_FN0___2 = 1110,
	PORT43_FN0___2 = 1111,
	PORT44_FN0___2 = 1112,
	PORT45_FN0___2 = 1113,
	PORT46_FN0___2 = 1114,
	PORT47_FN0___2 = 1115,
	PORT48_FN0___2 = 1116,
	PORT49_FN0___2 = 1117,
	PORT50_FN0___2 = 1118,
	PORT51_FN0___2 = 1119,
	PORT52_FN0___2 = 1120,
	PORT53_FN0___2 = 1121,
	PORT54_FN0___2 = 1122,
	PORT55_FN0___2 = 1123,
	PORT56_FN0___2 = 1124,
	PORT57_FN0___2 = 1125,
	PORT58_FN0___2 = 1126,
	PORT59_FN0___2 = 1127,
	PORT60_FN0___2 = 1128,
	PORT61_FN0___2 = 1129,
	PORT62_FN0___2 = 1130,
	PORT63_FN0___2 = 1131,
	PORT64_FN0___3 = 1132,
	PORT65_FN0___3 = 1133,
	PORT66_FN0___3 = 1134,
	PORT67_FN0___3 = 1135,
	PORT68_FN0___3 = 1136,
	PORT69_FN0___3 = 1137,
	PORT70_FN0___3 = 1138,
	PORT71_FN0___3 = 1139,
	PORT72_FN0___3 = 1140,
	PORT73_FN0___3 = 1141,
	PORT74_FN0___3 = 1142,
	PORT75_FN0___3 = 1143,
	PORT76_FN0___3 = 1144,
	PORT77_FN0___3 = 1145,
	PORT78_FN0___3 = 1146,
	PORT79_FN0___3 = 1147,
	PORT80_FN0___3 = 1148,
	PORT81_FN0___3 = 1149,
	PORT82_FN0___3 = 1150,
	PORT83_FN0___3 = 1151,
	PORT84_FN0___3 = 1152,
	PORT85_FN0___3 = 1153,
	PORT86_FN0___2 = 1154,
	PORT87_FN0___2 = 1155,
	PORT88_FN0___2 = 1156,
	PORT89_FN0___2 = 1157,
	PORT90_FN0___2 = 1158,
	PORT91_FN0___2 = 1159,
	PORT92_FN0___2 = 1160,
	PORT93_FN0___2 = 1161,
	PORT94_FN0___2 = 1162,
	PORT95_FN0___2 = 1163,
	PORT96_FN0___3 = 1164,
	PORT97_FN0___3 = 1165,
	PORT98_FN0___3 = 1166,
	PORT99_FN0___3 = 1167,
	PORT100_FN0___3 = 1168,
	PORT101_FN0___3 = 1169,
	PORT102_FN0___3 = 1170,
	PORT103_FN0___3 = 1171,
	PORT104_FN0___3 = 1172,
	PORT105_FN0___3 = 1173,
	PORT106_FN0___3 = 1174,
	PORT107_FN0___3 = 1175,
	PORT108_FN0___3 = 1176,
	PORT109_FN0___3 = 1177,
	PORT110_FN0___3 = 1178,
	PORT111_FN0___3 = 1179,
	PORT112_FN0___3 = 1180,
	PORT113_FN0___3 = 1181,
	PORT114_FN0___3 = 1182,
	PORT115_FN0___3 = 1183,
	PORT116_FN0___3 = 1184,
	PORT117_FN0___3 = 1185,
	PORT118_FN0___3 = 1186,
	PORT119_FN0___2 = 1187,
	PORT120_FN0___2 = 1188,
	PORT121_FN0___2 = 1189,
	PORT122_FN0___2 = 1190,
	PORT123_FN0___2 = 1191,
	PORT124_FN0___2 = 1192,
	PORT125_FN0___2 = 1193,
	PORT126_FN0___2 = 1194,
	PORT127_FN0 = 1195,
	PORT128_FN0___3 = 1196,
	PORT129_FN0___3 = 1197,
	PORT130_FN0___3 = 1198,
	PORT131_FN0___3 = 1199,
	PORT132_FN0___3 = 1200,
	PORT133_FN0___3 = 1201,
	PORT134_FN0___3 = 1202,
	PORT135_FN0___2 = 1203,
	PORT136_FN0___2 = 1204,
	PORT137_FN0___2 = 1205,
	PORT138_FN0___2 = 1206,
	PORT139_FN0___2 = 1207,
	PORT140_FN0___2 = 1208,
	PORT141_FN0___2 = 1209,
	PORT142_FN0___2 = 1210,
	PORT143_FN0___2 = 1211,
	PORT144_FN0___2 = 1212,
	PORT145_FN0___2 = 1213,
	PORT146_FN0___2 = 1214,
	PORT147_FN0___2 = 1215,
	PORT148_FN0___2 = 1216,
	PORT149_FN0___2 = 1217,
	PORT150_FN0___2 = 1218,
	PORT151_FN0___2 = 1219,
	PORT152_FN0___2 = 1220,
	PORT153_FN0___2 = 1221,
	PORT154_FN0___2 = 1222,
	PORT155_FN0___2 = 1223,
	PORT156_FN0___2 = 1224,
	PORT157_FN0___2 = 1225,
	PORT158_FN0___2 = 1226,
	PORT159_FN0___2 = 1227,
	PORT160_FN0___3 = 1228,
	PORT161_FN0___3 = 1229,
	PORT162_FN0___3 = 1230,
	PORT163_FN0___3 = 1231,
	PORT164_FN0___3 = 1232,
	PORT165_FN0___2 = 1233,
	PORT166_FN0___2 = 1234,
	PORT167_FN0___2 = 1235,
	PORT168_FN0___2 = 1236,
	PORT169_FN0___2 = 1237,
	PORT170_FN0___2 = 1238,
	PORT171_FN0___2 = 1239,
	PORT172_FN0___2 = 1240,
	PORT173_FN0___2 = 1241,
	PORT174_FN0___2 = 1242,
	PORT175_FN0___2 = 1243,
	PORT176_FN0___2 = 1244,
	PORT177_FN0___2 = 1245,
	PORT178_FN0___2 = 1246,
	PORT179_FN0 = 1247,
	PORT180_FN0 = 1248,
	PORT181_FN0 = 1249,
	PORT182_FN0 = 1250,
	PORT183_FN0 = 1251,
	PORT184_FN0 = 1252,
	PORT185_FN0 = 1253,
	PORT186_FN0 = 1254,
	PORT187_FN0 = 1255,
	PORT188_FN0 = 1256,
	PORT189_FN0 = 1257,
	PORT190_FN0 = 1258,
	PORT191_FN0 = 1259,
	PORT192_FN0___3 = 1260,
	PORT193_FN0___3 = 1261,
	PORT194_FN0___3 = 1262,
	PORT195_FN0___3 = 1263,
	PORT196_FN0___3 = 1264,
	PORT197_FN0___3 = 1265,
	PORT198_FN0___3 = 1266,
	PORT199_FN0___3 = 1267,
	PORT200_FN0___3 = 1268,
	PORT201_FN0___3 = 1269,
	PORT202_FN0___3 = 1270,
	PORT203_FN0___3 = 1271,
	PORT204_FN0___3 = 1272,
	PORT205_FN0___3 = 1273,
	PORT206_FN0___3 = 1274,
	PORT207_FN0___3 = 1275,
	PORT208_FN0___3 = 1276,
	PORT209_FN0___3 = 1277,
	PORT210_FN0___3 = 1278,
	PORT211_FN0___3 = 1279,
	PORT0_FN1___3 = 1280,
	PORT1_FN1___3 = 1281,
	PORT2_FN1___3 = 1282,
	PORT3_FN1___3 = 1283,
	PORT4_FN1___3 = 1284,
	PORT5_FN1___3 = 1285,
	PORT6_FN1___3 = 1286,
	PORT7_FN1___3 = 1287,
	PORT8_FN1___3 = 1288,
	PORT9_FN1___3 = 1289,
	PORT10_FN1___3 = 1290,
	PORT11_FN1___3 = 1291,
	PORT12_FN1___3 = 1292,
	PORT13_FN1___3 = 1293,
	PORT14_FN1___3 = 1294,
	PORT15_FN1___3 = 1295,
	PORT16_FN1___3 = 1296,
	PORT17_FN1___3 = 1297,
	PORT18_FN1___3 = 1298,
	PORT19_FN1___3 = 1299,
	PORT20_FN1___3 = 1300,
	PORT21_FN1___3 = 1301,
	PORT22_FN1___3 = 1302,
	PORT23_FN1___3 = 1303,
	PORT24_FN1___3 = 1304,
	PORT25_FN1___3 = 1305,
	PORT26_FN1___3 = 1306,
	PORT27_FN1___3 = 1307,
	PORT28_FN1___3 = 1308,
	PORT29_FN1___3 = 1309,
	PORT30_FN1___3 = 1310,
	PORT31_FN1___2 = 1311,
	PORT32_FN1___3 = 1312,
	PORT33_FN1___3 = 1313,
	PORT34_FN1___3 = 1314,
	PORT35_FN1___3 = 1315,
	PORT36_FN1___3 = 1316,
	PORT37_FN1___3 = 1317,
	PORT38_FN1___3 = 1318,
	PORT39_FN1___3 = 1319,
	PORT40_FN1___3 = 1320,
	PORT41_FN1___2 = 1321,
	PORT42_FN1___2 = 1322,
	PORT43_FN1___2 = 1323,
	PORT44_FN1___2 = 1324,
	PORT45_FN1___2 = 1325,
	PORT46_FN1___2 = 1326,
	PORT47_FN1___2 = 1327,
	PORT48_FN1___2 = 1328,
	PORT49_FN1___2 = 1329,
	PORT50_FN1___2 = 1330,
	PORT51_FN1___2 = 1331,
	PORT52_FN1___2 = 1332,
	PORT53_FN1___2 = 1333,
	PORT54_FN1___2 = 1334,
	PORT55_FN1___2 = 1335,
	PORT56_FN1___2 = 1336,
	PORT57_FN1___2 = 1337,
	PORT58_FN1___2 = 1338,
	PORT59_FN1___2 = 1339,
	PORT60_FN1___2 = 1340,
	PORT61_FN1___2 = 1341,
	PORT62_FN1___2 = 1342,
	PORT63_FN1___2 = 1343,
	PORT64_FN1___3 = 1344,
	PORT65_FN1___3 = 1345,
	PORT66_FN1___3 = 1346,
	PORT67_FN1___3 = 1347,
	PORT68_FN1___3 = 1348,
	PORT69_FN1___3 = 1349,
	PORT70_FN1___3 = 1350,
	PORT71_FN1___3 = 1351,
	PORT72_FN1___3 = 1352,
	PORT73_FN1___3 = 1353,
	PORT74_FN1___3 = 1354,
	PORT75_FN1___3 = 1355,
	PORT76_FN1___3 = 1356,
	PORT77_FN1___3 = 1357,
	PORT78_FN1___3 = 1358,
	PORT79_FN1___3 = 1359,
	PORT80_FN1___3 = 1360,
	PORT81_FN1___3 = 1361,
	PORT82_FN1___3 = 1362,
	PORT83_FN1___3 = 1363,
	PORT84_FN1___3 = 1364,
	PORT85_FN1___3 = 1365,
	PORT86_FN1___2 = 1366,
	PORT87_FN1___2 = 1367,
	PORT88_FN1___2 = 1368,
	PORT89_FN1___2 = 1369,
	PORT90_FN1___2 = 1370,
	PORT91_FN1___2 = 1371,
	PORT92_FN1___2 = 1372,
	PORT93_FN1___2 = 1373,
	PORT94_FN1___2 = 1374,
	PORT95_FN1___2 = 1375,
	PORT96_FN1___3 = 1376,
	PORT97_FN1___3 = 1377,
	PORT98_FN1___3 = 1378,
	PORT99_FN1___3 = 1379,
	PORT100_FN1___3 = 1380,
	PORT101_FN1___3 = 1381,
	PORT102_FN1___3 = 1382,
	PORT103_FN1___3 = 1383,
	PORT104_FN1___3 = 1384,
	PORT105_FN1___3 = 1385,
	PORT106_FN1___3 = 1386,
	PORT107_FN1___3 = 1387,
	PORT108_FN1___3 = 1388,
	PORT109_FN1___3 = 1389,
	PORT110_FN1___3 = 1390,
	PORT111_FN1___3 = 1391,
	PORT112_FN1___3 = 1392,
	PORT113_FN1___3 = 1393,
	PORT114_FN1___3 = 1394,
	PORT115_FN1___3 = 1395,
	PORT116_FN1___3 = 1396,
	PORT117_FN1___3 = 1397,
	PORT118_FN1___3 = 1398,
	PORT119_FN1___2 = 1399,
	PORT120_FN1___2 = 1400,
	PORT121_FN1___2 = 1401,
	PORT122_FN1___2 = 1402,
	PORT123_FN1___2 = 1403,
	PORT124_FN1___2 = 1404,
	PORT125_FN1___2 = 1405,
	PORT126_FN1___2 = 1406,
	PORT127_FN1 = 1407,
	PORT128_FN1___3 = 1408,
	PORT129_FN1___3 = 1409,
	PORT130_FN1___3 = 1410,
	PORT131_FN1___3 = 1411,
	PORT132_FN1___3 = 1412,
	PORT133_FN1___3 = 1413,
	PORT134_FN1___3 = 1414,
	PORT135_FN1___2 = 1415,
	PORT136_FN1___2 = 1416,
	PORT137_FN1___2 = 1417,
	PORT138_FN1___2 = 1418,
	PORT139_FN1___2 = 1419,
	PORT140_FN1___2 = 1420,
	PORT141_FN1___2 = 1421,
	PORT142_FN1___2 = 1422,
	PORT143_FN1___2 = 1423,
	PORT144_FN1___2 = 1424,
	PORT145_FN1___2 = 1425,
	PORT146_FN1___2 = 1426,
	PORT147_FN1___2 = 1427,
	PORT148_FN1___2 = 1428,
	PORT149_FN1___2 = 1429,
	PORT150_FN1___2 = 1430,
	PORT151_FN1___2 = 1431,
	PORT152_FN1___2 = 1432,
	PORT153_FN1___2 = 1433,
	PORT154_FN1___2 = 1434,
	PORT155_FN1___2 = 1435,
	PORT156_FN1___2 = 1436,
	PORT157_FN1___2 = 1437,
	PORT158_FN1___2 = 1438,
	PORT159_FN1___2 = 1439,
	PORT160_FN1___3 = 1440,
	PORT161_FN1___3 = 1441,
	PORT162_FN1___3 = 1442,
	PORT163_FN1___3 = 1443,
	PORT164_FN1___3 = 1444,
	PORT165_FN1___2 = 1445,
	PORT166_FN1___2 = 1446,
	PORT167_FN1___2 = 1447,
	PORT168_FN1___2 = 1448,
	PORT169_FN1___2 = 1449,
	PORT170_FN1___2 = 1450,
	PORT171_FN1___2 = 1451,
	PORT172_FN1___2 = 1452,
	PORT173_FN1___2 = 1453,
	PORT174_FN1___2 = 1454,
	PORT175_FN1___2 = 1455,
	PORT176_FN1___2 = 1456,
	PORT177_FN1___2 = 1457,
	PORT178_FN1___2 = 1458,
	PORT179_FN1 = 1459,
	PORT180_FN1 = 1460,
	PORT181_FN1 = 1461,
	PORT182_FN1 = 1462,
	PORT183_FN1 = 1463,
	PORT184_FN1 = 1464,
	PORT185_FN1 = 1465,
	PORT186_FN1 = 1466,
	PORT187_FN1 = 1467,
	PORT188_FN1 = 1468,
	PORT189_FN1 = 1469,
	PORT190_FN1 = 1470,
	PORT191_FN1 = 1471,
	PORT192_FN1___3 = 1472,
	PORT193_FN1___3 = 1473,
	PORT194_FN1___3 = 1474,
	PORT195_FN1___3 = 1475,
	PORT196_FN1___3 = 1476,
	PORT197_FN1___3 = 1477,
	PORT198_FN1___3 = 1478,
	PORT199_FN1___3 = 1479,
	PORT200_FN1___3 = 1480,
	PORT201_FN1___3 = 1481,
	PORT202_FN1___3 = 1482,
	PORT203_FN1___3 = 1483,
	PORT204_FN1___3 = 1484,
	PORT205_FN1___3 = 1485,
	PORT206_FN1___3 = 1486,
	PORT207_FN1___3 = 1487,
	PORT208_FN1___3 = 1488,
	PORT209_FN1___3 = 1489,
	PORT210_FN1___3 = 1490,
	PORT211_FN1___3 = 1491,
	PORT0_FN2___3 = 1492,
	PORT1_FN2___3 = 1493,
	PORT2_FN2___3 = 1494,
	PORT3_FN2___3 = 1495,
	PORT4_FN2___3 = 1496,
	PORT5_FN2___3 = 1497,
	PORT6_FN2___3 = 1498,
	PORT7_FN2___3 = 1499,
	PORT8_FN2___3 = 1500,
	PORT9_FN2___3 = 1501,
	PORT10_FN2___3 = 1502,
	PORT11_FN2___3 = 1503,
	PORT12_FN2___3 = 1504,
	PORT13_FN2___3 = 1505,
	PORT14_FN2___3 = 1506,
	PORT15_FN2___3 = 1507,
	PORT16_FN2___3 = 1508,
	PORT17_FN2___3 = 1509,
	PORT18_FN2___3 = 1510,
	PORT19_FN2___3 = 1511,
	PORT20_FN2___3 = 1512,
	PORT21_FN2___3 = 1513,
	PORT22_FN2___3 = 1514,
	PORT23_FN2___3 = 1515,
	PORT24_FN2___3 = 1516,
	PORT25_FN2___3 = 1517,
	PORT26_FN2___3 = 1518,
	PORT27_FN2___3 = 1519,
	PORT28_FN2___3 = 1520,
	PORT29_FN2___3 = 1521,
	PORT30_FN2___3 = 1522,
	PORT31_FN2___2 = 1523,
	PORT32_FN2___3 = 1524,
	PORT33_FN2___3 = 1525,
	PORT34_FN2___3 = 1526,
	PORT35_FN2___3 = 1527,
	PORT36_FN2___3 = 1528,
	PORT37_FN2___3 = 1529,
	PORT38_FN2___3 = 1530,
	PORT39_FN2___3 = 1531,
	PORT40_FN2___3 = 1532,
	PORT41_FN2___2 = 1533,
	PORT42_FN2___2 = 1534,
	PORT43_FN2___2 = 1535,
	PORT44_FN2___2 = 1536,
	PORT45_FN2___2 = 1537,
	PORT46_FN2___2 = 1538,
	PORT47_FN2___2 = 1539,
	PORT48_FN2___2 = 1540,
	PORT49_FN2___2 = 1541,
	PORT50_FN2___2 = 1542,
	PORT51_FN2___2 = 1543,
	PORT52_FN2___2 = 1544,
	PORT53_FN2___2 = 1545,
	PORT54_FN2___2 = 1546,
	PORT55_FN2___2 = 1547,
	PORT56_FN2___2 = 1548,
	PORT57_FN2___2 = 1549,
	PORT58_FN2___2 = 1550,
	PORT59_FN2___2 = 1551,
	PORT60_FN2___2 = 1552,
	PORT61_FN2___2 = 1553,
	PORT62_FN2___2 = 1554,
	PORT63_FN2___2 = 1555,
	PORT64_FN2___3 = 1556,
	PORT65_FN2___3 = 1557,
	PORT66_FN2___3 = 1558,
	PORT67_FN2___3 = 1559,
	PORT68_FN2___3 = 1560,
	PORT69_FN2___3 = 1561,
	PORT70_FN2___3 = 1562,
	PORT71_FN2___3 = 1563,
	PORT72_FN2___3 = 1564,
	PORT73_FN2___3 = 1565,
	PORT74_FN2___3 = 1566,
	PORT75_FN2___3 = 1567,
	PORT76_FN2___3 = 1568,
	PORT77_FN2___3 = 1569,
	PORT78_FN2___3 = 1570,
	PORT79_FN2___3 = 1571,
	PORT80_FN2___3 = 1572,
	PORT81_FN2___3 = 1573,
	PORT82_FN2___3 = 1574,
	PORT83_FN2___3 = 1575,
	PORT84_FN2___3 = 1576,
	PORT85_FN2___3 = 1577,
	PORT86_FN2___2 = 1578,
	PORT87_FN2___2 = 1579,
	PORT88_FN2___2 = 1580,
	PORT89_FN2___2 = 1581,
	PORT90_FN2___2 = 1582,
	PORT91_FN2___2 = 1583,
	PORT92_FN2___2 = 1584,
	PORT93_FN2___2 = 1585,
	PORT94_FN2___2 = 1586,
	PORT95_FN2___2 = 1587,
	PORT96_FN2___3 = 1588,
	PORT97_FN2___3 = 1589,
	PORT98_FN2___3 = 1590,
	PORT99_FN2___3 = 1591,
	PORT100_FN2___3 = 1592,
	PORT101_FN2___3 = 1593,
	PORT102_FN2___3 = 1594,
	PORT103_FN2___3 = 1595,
	PORT104_FN2___3 = 1596,
	PORT105_FN2___3 = 1597,
	PORT106_FN2___3 = 1598,
	PORT107_FN2___3 = 1599,
	PORT108_FN2___3 = 1600,
	PORT109_FN2___3 = 1601,
	PORT110_FN2___3 = 1602,
	PORT111_FN2___3 = 1603,
	PORT112_FN2___3 = 1604,
	PORT113_FN2___3 = 1605,
	PORT114_FN2___3 = 1606,
	PORT115_FN2___3 = 1607,
	PORT116_FN2___3 = 1608,
	PORT117_FN2___3 = 1609,
	PORT118_FN2___3 = 1610,
	PORT119_FN2___2 = 1611,
	PORT120_FN2___2 = 1612,
	PORT121_FN2___2 = 1613,
	PORT122_FN2___2 = 1614,
	PORT123_FN2___2 = 1615,
	PORT124_FN2___2 = 1616,
	PORT125_FN2___2 = 1617,
	PORT126_FN2___2 = 1618,
	PORT127_FN2 = 1619,
	PORT128_FN2___3 = 1620,
	PORT129_FN2___3 = 1621,
	PORT130_FN2___3 = 1622,
	PORT131_FN2___3 = 1623,
	PORT132_FN2___3 = 1624,
	PORT133_FN2___3 = 1625,
	PORT134_FN2___3 = 1626,
	PORT135_FN2___2 = 1627,
	PORT136_FN2___2 = 1628,
	PORT137_FN2___2 = 1629,
	PORT138_FN2___2 = 1630,
	PORT139_FN2___2 = 1631,
	PORT140_FN2___2 = 1632,
	PORT141_FN2___2 = 1633,
	PORT142_FN2___2 = 1634,
	PORT143_FN2___2 = 1635,
	PORT144_FN2___2 = 1636,
	PORT145_FN2___2 = 1637,
	PORT146_FN2___2 = 1638,
	PORT147_FN2___2 = 1639,
	PORT148_FN2___2 = 1640,
	PORT149_FN2___2 = 1641,
	PORT150_FN2___2 = 1642,
	PORT151_FN2___2 = 1643,
	PORT152_FN2___2 = 1644,
	PORT153_FN2___2 = 1645,
	PORT154_FN2___2 = 1646,
	PORT155_FN2___2 = 1647,
	PORT156_FN2___2 = 1648,
	PORT157_FN2___2 = 1649,
	PORT158_FN2___2 = 1650,
	PORT159_FN2___2 = 1651,
	PORT160_FN2___3 = 1652,
	PORT161_FN2___3 = 1653,
	PORT162_FN2___3 = 1654,
	PORT163_FN2___3 = 1655,
	PORT164_FN2___3 = 1656,
	PORT165_FN2___2 = 1657,
	PORT166_FN2___2 = 1658,
	PORT167_FN2___2 = 1659,
	PORT168_FN2___2 = 1660,
	PORT169_FN2___2 = 1661,
	PORT170_FN2___2 = 1662,
	PORT171_FN2___2 = 1663,
	PORT172_FN2___2 = 1664,
	PORT173_FN2___2 = 1665,
	PORT174_FN2___2 = 1666,
	PORT175_FN2___2 = 1667,
	PORT176_FN2___2 = 1668,
	PORT177_FN2___2 = 1669,
	PORT178_FN2___2 = 1670,
	PORT179_FN2 = 1671,
	PORT180_FN2 = 1672,
	PORT181_FN2 = 1673,
	PORT182_FN2 = 1674,
	PORT183_FN2 = 1675,
	PORT184_FN2 = 1676,
	PORT185_FN2 = 1677,
	PORT186_FN2 = 1678,
	PORT187_FN2 = 1679,
	PORT188_FN2 = 1680,
	PORT189_FN2 = 1681,
	PORT190_FN2 = 1682,
	PORT191_FN2 = 1683,
	PORT192_FN2___3 = 1684,
	PORT193_FN2___3 = 1685,
	PORT194_FN2___3 = 1686,
	PORT195_FN2___3 = 1687,
	PORT196_FN2___3 = 1688,
	PORT197_FN2___3 = 1689,
	PORT198_FN2___3 = 1690,
	PORT199_FN2___3 = 1691,
	PORT200_FN2___3 = 1692,
	PORT201_FN2___3 = 1693,
	PORT202_FN2___3 = 1694,
	PORT203_FN2___3 = 1695,
	PORT204_FN2___3 = 1696,
	PORT205_FN2___3 = 1697,
	PORT206_FN2___3 = 1698,
	PORT207_FN2___3 = 1699,
	PORT208_FN2___3 = 1700,
	PORT209_FN2___3 = 1701,
	PORT210_FN2___3 = 1702,
	PORT211_FN2___3 = 1703,
	PORT0_FN3___3 = 1704,
	PORT1_FN3___3 = 1705,
	PORT2_FN3___3 = 1706,
	PORT3_FN3___3 = 1707,
	PORT4_FN3___3 = 1708,
	PORT5_FN3___3 = 1709,
	PORT6_FN3___3 = 1710,
	PORT7_FN3___3 = 1711,
	PORT8_FN3___3 = 1712,
	PORT9_FN3___3 = 1713,
	PORT10_FN3___3 = 1714,
	PORT11_FN3___3 = 1715,
	PORT12_FN3___3 = 1716,
	PORT13_FN3___3 = 1717,
	PORT14_FN3___3 = 1718,
	PORT15_FN3___3 = 1719,
	PORT16_FN3___3 = 1720,
	PORT17_FN3___3 = 1721,
	PORT18_FN3___3 = 1722,
	PORT19_FN3___3 = 1723,
	PORT20_FN3___3 = 1724,
	PORT21_FN3___3 = 1725,
	PORT22_FN3___3 = 1726,
	PORT23_FN3___3 = 1727,
	PORT24_FN3___3 = 1728,
	PORT25_FN3___3 = 1729,
	PORT26_FN3___3 = 1730,
	PORT27_FN3___3 = 1731,
	PORT28_FN3___3 = 1732,
	PORT29_FN3___3 = 1733,
	PORT30_FN3___3 = 1734,
	PORT31_FN3___2 = 1735,
	PORT32_FN3___3 = 1736,
	PORT33_FN3___3 = 1737,
	PORT34_FN3___3 = 1738,
	PORT35_FN3___3 = 1739,
	PORT36_FN3___3 = 1740,
	PORT37_FN3___3 = 1741,
	PORT38_FN3___3 = 1742,
	PORT39_FN3___3 = 1743,
	PORT40_FN3___3 = 1744,
	PORT41_FN3___2 = 1745,
	PORT42_FN3___2 = 1746,
	PORT43_FN3___2 = 1747,
	PORT44_FN3___2 = 1748,
	PORT45_FN3___2 = 1749,
	PORT46_FN3___2 = 1750,
	PORT47_FN3___2 = 1751,
	PORT48_FN3___2 = 1752,
	PORT49_FN3___2 = 1753,
	PORT50_FN3___2 = 1754,
	PORT51_FN3___2 = 1755,
	PORT52_FN3___2 = 1756,
	PORT53_FN3___2 = 1757,
	PORT54_FN3___2 = 1758,
	PORT55_FN3___2 = 1759,
	PORT56_FN3___2 = 1760,
	PORT57_FN3___2 = 1761,
	PORT58_FN3___2 = 1762,
	PORT59_FN3___2 = 1763,
	PORT60_FN3___2 = 1764,
	PORT61_FN3___2 = 1765,
	PORT62_FN3___2 = 1766,
	PORT63_FN3___2 = 1767,
	PORT64_FN3___3 = 1768,
	PORT65_FN3___3 = 1769,
	PORT66_FN3___3 = 1770,
	PORT67_FN3___3 = 1771,
	PORT68_FN3___3 = 1772,
	PORT69_FN3___3 = 1773,
	PORT70_FN3___3 = 1774,
	PORT71_FN3___3 = 1775,
	PORT72_FN3___3 = 1776,
	PORT73_FN3___3 = 1777,
	PORT74_FN3___3 = 1778,
	PORT75_FN3___3 = 1779,
	PORT76_FN3___3 = 1780,
	PORT77_FN3___3 = 1781,
	PORT78_FN3___3 = 1782,
	PORT79_FN3___3 = 1783,
	PORT80_FN3___3 = 1784,
	PORT81_FN3___3 = 1785,
	PORT82_FN3___3 = 1786,
	PORT83_FN3___3 = 1787,
	PORT84_FN3___3 = 1788,
	PORT85_FN3___3 = 1789,
	PORT86_FN3___2 = 1790,
	PORT87_FN3___2 = 1791,
	PORT88_FN3___2 = 1792,
	PORT89_FN3___2 = 1793,
	PORT90_FN3___2 = 1794,
	PORT91_FN3___2 = 1795,
	PORT92_FN3___2 = 1796,
	PORT93_FN3___2 = 1797,
	PORT94_FN3___2 = 1798,
	PORT95_FN3___2 = 1799,
	PORT96_FN3___3 = 1800,
	PORT97_FN3___3 = 1801,
	PORT98_FN3___3 = 1802,
	PORT99_FN3___3 = 1803,
	PORT100_FN3___3 = 1804,
	PORT101_FN3___3 = 1805,
	PORT102_FN3___3 = 1806,
	PORT103_FN3___3 = 1807,
	PORT104_FN3___3 = 1808,
	PORT105_FN3___3 = 1809,
	PORT106_FN3___3 = 1810,
	PORT107_FN3___3 = 1811,
	PORT108_FN3___3 = 1812,
	PORT109_FN3___3 = 1813,
	PORT110_FN3___3 = 1814,
	PORT111_FN3___3 = 1815,
	PORT112_FN3___3 = 1816,
	PORT113_FN3___3 = 1817,
	PORT114_FN3___3 = 1818,
	PORT115_FN3___3 = 1819,
	PORT116_FN3___3 = 1820,
	PORT117_FN3___3 = 1821,
	PORT118_FN3___3 = 1822,
	PORT119_FN3___2 = 1823,
	PORT120_FN3___2 = 1824,
	PORT121_FN3___2 = 1825,
	PORT122_FN3___2 = 1826,
	PORT123_FN3___2 = 1827,
	PORT124_FN3___2 = 1828,
	PORT125_FN3___2 = 1829,
	PORT126_FN3___2 = 1830,
	PORT127_FN3 = 1831,
	PORT128_FN3___3 = 1832,
	PORT129_FN3___3 = 1833,
	PORT130_FN3___3 = 1834,
	PORT131_FN3___3 = 1835,
	PORT132_FN3___3 = 1836,
	PORT133_FN3___3 = 1837,
	PORT134_FN3___3 = 1838,
	PORT135_FN3___2 = 1839,
	PORT136_FN3___2 = 1840,
	PORT137_FN3___2 = 1841,
	PORT138_FN3___2 = 1842,
	PORT139_FN3___2 = 1843,
	PORT140_FN3___2 = 1844,
	PORT141_FN3___2 = 1845,
	PORT142_FN3___2 = 1846,
	PORT143_FN3___2 = 1847,
	PORT144_FN3___2 = 1848,
	PORT145_FN3___2 = 1849,
	PORT146_FN3___2 = 1850,
	PORT147_FN3___2 = 1851,
	PORT148_FN3___2 = 1852,
	PORT149_FN3___2 = 1853,
	PORT150_FN3___2 = 1854,
	PORT151_FN3___2 = 1855,
	PORT152_FN3___2 = 1856,
	PORT153_FN3___2 = 1857,
	PORT154_FN3___2 = 1858,
	PORT155_FN3___2 = 1859,
	PORT156_FN3___2 = 1860,
	PORT157_FN3___2 = 1861,
	PORT158_FN3___2 = 1862,
	PORT159_FN3___2 = 1863,
	PORT160_FN3___3 = 1864,
	PORT161_FN3___3 = 1865,
	PORT162_FN3___3 = 1866,
	PORT163_FN3___3 = 1867,
	PORT164_FN3___3 = 1868,
	PORT165_FN3___2 = 1869,
	PORT166_FN3___2 = 1870,
	PORT167_FN3___2 = 1871,
	PORT168_FN3___2 = 1872,
	PORT169_FN3___2 = 1873,
	PORT170_FN3___2 = 1874,
	PORT171_FN3___2 = 1875,
	PORT172_FN3___2 = 1876,
	PORT173_FN3___2 = 1877,
	PORT174_FN3___2 = 1878,
	PORT175_FN3___2 = 1879,
	PORT176_FN3___2 = 1880,
	PORT177_FN3___2 = 1881,
	PORT178_FN3___2 = 1882,
	PORT179_FN3 = 1883,
	PORT180_FN3 = 1884,
	PORT181_FN3 = 1885,
	PORT182_FN3 = 1886,
	PORT183_FN3 = 1887,
	PORT184_FN3 = 1888,
	PORT185_FN3 = 1889,
	PORT186_FN3 = 1890,
	PORT187_FN3 = 1891,
	PORT188_FN3 = 1892,
	PORT189_FN3 = 1893,
	PORT190_FN3 = 1894,
	PORT191_FN3 = 1895,
	PORT192_FN3___3 = 1896,
	PORT193_FN3___3 = 1897,
	PORT194_FN3___3 = 1898,
	PORT195_FN3___3 = 1899,
	PORT196_FN3___3 = 1900,
	PORT197_FN3___3 = 1901,
	PORT198_FN3___3 = 1902,
	PORT199_FN3___3 = 1903,
	PORT200_FN3___3 = 1904,
	PORT201_FN3___3 = 1905,
	PORT202_FN3___3 = 1906,
	PORT203_FN3___3 = 1907,
	PORT204_FN3___3 = 1908,
	PORT205_FN3___3 = 1909,
	PORT206_FN3___3 = 1910,
	PORT207_FN3___3 = 1911,
	PORT208_FN3___3 = 1912,
	PORT209_FN3___3 = 1913,
	PORT210_FN3___3 = 1914,
	PORT211_FN3___3 = 1915,
	PORT0_FN4___3 = 1916,
	PORT1_FN4___3 = 1917,
	PORT2_FN4___3 = 1918,
	PORT3_FN4___3 = 1919,
	PORT4_FN4___3 = 1920,
	PORT5_FN4___3 = 1921,
	PORT6_FN4___3 = 1922,
	PORT7_FN4___3 = 1923,
	PORT8_FN4___3 = 1924,
	PORT9_FN4___3 = 1925,
	PORT10_FN4___3 = 1926,
	PORT11_FN4___3 = 1927,
	PORT12_FN4___3 = 1928,
	PORT13_FN4___3 = 1929,
	PORT14_FN4___3 = 1930,
	PORT15_FN4___3 = 1931,
	PORT16_FN4___3 = 1932,
	PORT17_FN4___3 = 1933,
	PORT18_FN4___3 = 1934,
	PORT19_FN4___3 = 1935,
	PORT20_FN4___3 = 1936,
	PORT21_FN4___3 = 1937,
	PORT22_FN4___3 = 1938,
	PORT23_FN4___3 = 1939,
	PORT24_FN4___3 = 1940,
	PORT25_FN4___3 = 1941,
	PORT26_FN4___3 = 1942,
	PORT27_FN4___3 = 1943,
	PORT28_FN4___3 = 1944,
	PORT29_FN4___3 = 1945,
	PORT30_FN4___3 = 1946,
	PORT31_FN4___2 = 1947,
	PORT32_FN4___3 = 1948,
	PORT33_FN4___3 = 1949,
	PORT34_FN4___3 = 1950,
	PORT35_FN4___3 = 1951,
	PORT36_FN4___3 = 1952,
	PORT37_FN4___3 = 1953,
	PORT38_FN4___3 = 1954,
	PORT39_FN4___3 = 1955,
	PORT40_FN4___3 = 1956,
	PORT41_FN4___2 = 1957,
	PORT42_FN4___2 = 1958,
	PORT43_FN4___2 = 1959,
	PORT44_FN4___2 = 1960,
	PORT45_FN4___2 = 1961,
	PORT46_FN4___2 = 1962,
	PORT47_FN4___2 = 1963,
	PORT48_FN4___2 = 1964,
	PORT49_FN4___2 = 1965,
	PORT50_FN4___2 = 1966,
	PORT51_FN4___2 = 1967,
	PORT52_FN4___2 = 1968,
	PORT53_FN4___2 = 1969,
	PORT54_FN4___2 = 1970,
	PORT55_FN4___2 = 1971,
	PORT56_FN4___2 = 1972,
	PORT57_FN4___2 = 1973,
	PORT58_FN4___2 = 1974,
	PORT59_FN4___2 = 1975,
	PORT60_FN4___2 = 1976,
	PORT61_FN4___2 = 1977,
	PORT62_FN4___2 = 1978,
	PORT63_FN4___2 = 1979,
	PORT64_FN4___3 = 1980,
	PORT65_FN4___3 = 1981,
	PORT66_FN4___3 = 1982,
	PORT67_FN4___3 = 1983,
	PORT68_FN4___3 = 1984,
	PORT69_FN4___3 = 1985,
	PORT70_FN4___3 = 1986,
	PORT71_FN4___3 = 1987,
	PORT72_FN4___3 = 1988,
	PORT73_FN4___3 = 1989,
	PORT74_FN4___3 = 1990,
	PORT75_FN4___3 = 1991,
	PORT76_FN4___3 = 1992,
	PORT77_FN4___3 = 1993,
	PORT78_FN4___3 = 1994,
	PORT79_FN4___3 = 1995,
	PORT80_FN4___3 = 1996,
	PORT81_FN4___3 = 1997,
	PORT82_FN4___3 = 1998,
	PORT83_FN4___3 = 1999,
	PORT84_FN4___3 = 2000,
	PORT85_FN4___3 = 2001,
	PORT86_FN4___2 = 2002,
	PORT87_FN4___2 = 2003,
	PORT88_FN4___2 = 2004,
	PORT89_FN4___2 = 2005,
	PORT90_FN4___2 = 2006,
	PORT91_FN4___2 = 2007,
	PORT92_FN4___2 = 2008,
	PORT93_FN4___2 = 2009,
	PORT94_FN4___2 = 2010,
	PORT95_FN4___2 = 2011,
	PORT96_FN4___3 = 2012,
	PORT97_FN4___3 = 2013,
	PORT98_FN4___3 = 2014,
	PORT99_FN4___3 = 2015,
	PORT100_FN4___3 = 2016,
	PORT101_FN4___3 = 2017,
	PORT102_FN4___3 = 2018,
	PORT103_FN4___3 = 2019,
	PORT104_FN4___3 = 2020,
	PORT105_FN4___3 = 2021,
	PORT106_FN4___3 = 2022,
	PORT107_FN4___3 = 2023,
	PORT108_FN4___3 = 2024,
	PORT109_FN4___3 = 2025,
	PORT110_FN4___3 = 2026,
	PORT111_FN4___3 = 2027,
	PORT112_FN4___3 = 2028,
	PORT113_FN4___3 = 2029,
	PORT114_FN4___3 = 2030,
	PORT115_FN4___3 = 2031,
	PORT116_FN4___3 = 2032,
	PORT117_FN4___3 = 2033,
	PORT118_FN4___3 = 2034,
	PORT119_FN4___2 = 2035,
	PORT120_FN4___2 = 2036,
	PORT121_FN4___2 = 2037,
	PORT122_FN4___2 = 2038,
	PORT123_FN4___2 = 2039,
	PORT124_FN4___2 = 2040,
	PORT125_FN4___2 = 2041,
	PORT126_FN4___2 = 2042,
	PORT127_FN4 = 2043,
	PORT128_FN4___3 = 2044,
	PORT129_FN4___3 = 2045,
	PORT130_FN4___3 = 2046,
	PORT131_FN4___3 = 2047,
	PORT132_FN4___3 = 2048,
	PORT133_FN4___3 = 2049,
	PORT134_FN4___3 = 2050,
	PORT135_FN4___2 = 2051,
	PORT136_FN4___2 = 2052,
	PORT137_FN4___2 = 2053,
	PORT138_FN4___2 = 2054,
	PORT139_FN4___2 = 2055,
	PORT140_FN4___2 = 2056,
	PORT141_FN4___2 = 2057,
	PORT142_FN4___2 = 2058,
	PORT143_FN4___2 = 2059,
	PORT144_FN4___2 = 2060,
	PORT145_FN4___2 = 2061,
	PORT146_FN4___2 = 2062,
	PORT147_FN4___2 = 2063,
	PORT148_FN4___2 = 2064,
	PORT149_FN4___2 = 2065,
	PORT150_FN4___2 = 2066,
	PORT151_FN4___2 = 2067,
	PORT152_FN4___2 = 2068,
	PORT153_FN4___2 = 2069,
	PORT154_FN4___2 = 2070,
	PORT155_FN4___2 = 2071,
	PORT156_FN4___2 = 2072,
	PORT157_FN4___2 = 2073,
	PORT158_FN4___2 = 2074,
	PORT159_FN4___2 = 2075,
	PORT160_FN4___3 = 2076,
	PORT161_FN4___3 = 2077,
	PORT162_FN4___3 = 2078,
	PORT163_FN4___3 = 2079,
	PORT164_FN4___3 = 2080,
	PORT165_FN4___2 = 2081,
	PORT166_FN4___2 = 2082,
	PORT167_FN4___2 = 2083,
	PORT168_FN4___2 = 2084,
	PORT169_FN4___2 = 2085,
	PORT170_FN4___2 = 2086,
	PORT171_FN4___2 = 2087,
	PORT172_FN4___2 = 2088,
	PORT173_FN4___2 = 2089,
	PORT174_FN4___2 = 2090,
	PORT175_FN4___2 = 2091,
	PORT176_FN4___2 = 2092,
	PORT177_FN4___2 = 2093,
	PORT178_FN4___2 = 2094,
	PORT179_FN4 = 2095,
	PORT180_FN4 = 2096,
	PORT181_FN4 = 2097,
	PORT182_FN4 = 2098,
	PORT183_FN4 = 2099,
	PORT184_FN4 = 2100,
	PORT185_FN4 = 2101,
	PORT186_FN4 = 2102,
	PORT187_FN4 = 2103,
	PORT188_FN4 = 2104,
	PORT189_FN4 = 2105,
	PORT190_FN4 = 2106,
	PORT191_FN4 = 2107,
	PORT192_FN4___3 = 2108,
	PORT193_FN4___3 = 2109,
	PORT194_FN4___3 = 2110,
	PORT195_FN4___3 = 2111,
	PORT196_FN4___3 = 2112,
	PORT197_FN4___3 = 2113,
	PORT198_FN4___3 = 2114,
	PORT199_FN4___3 = 2115,
	PORT200_FN4___3 = 2116,
	PORT201_FN4___3 = 2117,
	PORT202_FN4___3 = 2118,
	PORT203_FN4___3 = 2119,
	PORT204_FN4___3 = 2120,
	PORT205_FN4___3 = 2121,
	PORT206_FN4___3 = 2122,
	PORT207_FN4___3 = 2123,
	PORT208_FN4___3 = 2124,
	PORT209_FN4___3 = 2125,
	PORT210_FN4___3 = 2126,
	PORT211_FN4___3 = 2127,
	PORT0_FN5___3 = 2128,
	PORT1_FN5___3 = 2129,
	PORT2_FN5___3 = 2130,
	PORT3_FN5___3 = 2131,
	PORT4_FN5___3 = 2132,
	PORT5_FN5___3 = 2133,
	PORT6_FN5___3 = 2134,
	PORT7_FN5___3 = 2135,
	PORT8_FN5___3 = 2136,
	PORT9_FN5___3 = 2137,
	PORT10_FN5___3 = 2138,
	PORT11_FN5___3 = 2139,
	PORT12_FN5___3 = 2140,
	PORT13_FN5___3 = 2141,
	PORT14_FN5___3 = 2142,
	PORT15_FN5___3 = 2143,
	PORT16_FN5___3 = 2144,
	PORT17_FN5___3 = 2145,
	PORT18_FN5___3 = 2146,
	PORT19_FN5___3 = 2147,
	PORT20_FN5___3 = 2148,
	PORT21_FN5___3 = 2149,
	PORT22_FN5___3 = 2150,
	PORT23_FN5___3 = 2151,
	PORT24_FN5___3 = 2152,
	PORT25_FN5___3 = 2153,
	PORT26_FN5___3 = 2154,
	PORT27_FN5___3 = 2155,
	PORT28_FN5___3 = 2156,
	PORT29_FN5___3 = 2157,
	PORT30_FN5___3 = 2158,
	PORT31_FN5___2 = 2159,
	PORT32_FN5___3 = 2160,
	PORT33_FN5___3 = 2161,
	PORT34_FN5___3 = 2162,
	PORT35_FN5___3 = 2163,
	PORT36_FN5___3 = 2164,
	PORT37_FN5___3 = 2165,
	PORT38_FN5___3 = 2166,
	PORT39_FN5___3 = 2167,
	PORT40_FN5___3 = 2168,
	PORT41_FN5___2 = 2169,
	PORT42_FN5___2 = 2170,
	PORT43_FN5___2 = 2171,
	PORT44_FN5___2 = 2172,
	PORT45_FN5___2 = 2173,
	PORT46_FN5___2 = 2174,
	PORT47_FN5___2 = 2175,
	PORT48_FN5___2 = 2176,
	PORT49_FN5___2 = 2177,
	PORT50_FN5___2 = 2178,
	PORT51_FN5___2 = 2179,
	PORT52_FN5___2 = 2180,
	PORT53_FN5___2 = 2181,
	PORT54_FN5___2 = 2182,
	PORT55_FN5___2 = 2183,
	PORT56_FN5___2 = 2184,
	PORT57_FN5___2 = 2185,
	PORT58_FN5___2 = 2186,
	PORT59_FN5___2 = 2187,
	PORT60_FN5___2 = 2188,
	PORT61_FN5___2 = 2189,
	PORT62_FN5___2 = 2190,
	PORT63_FN5___2 = 2191,
	PORT64_FN5___3 = 2192,
	PORT65_FN5___3 = 2193,
	PORT66_FN5___3 = 2194,
	PORT67_FN5___3 = 2195,
	PORT68_FN5___3 = 2196,
	PORT69_FN5___3 = 2197,
	PORT70_FN5___3 = 2198,
	PORT71_FN5___3 = 2199,
	PORT72_FN5___3 = 2200,
	PORT73_FN5___3 = 2201,
	PORT74_FN5___3 = 2202,
	PORT75_FN5___3 = 2203,
	PORT76_FN5___3 = 2204,
	PORT77_FN5___3 = 2205,
	PORT78_FN5___3 = 2206,
	PORT79_FN5___3 = 2207,
	PORT80_FN5___3 = 2208,
	PORT81_FN5___3 = 2209,
	PORT82_FN5___3 = 2210,
	PORT83_FN5___3 = 2211,
	PORT84_FN5___3 = 2212,
	PORT85_FN5___3 = 2213,
	PORT86_FN5___2 = 2214,
	PORT87_FN5___2 = 2215,
	PORT88_FN5___2 = 2216,
	PORT89_FN5___2 = 2217,
	PORT90_FN5___2 = 2218,
	PORT91_FN5___2 = 2219,
	PORT92_FN5___2 = 2220,
	PORT93_FN5___2 = 2221,
	PORT94_FN5___2 = 2222,
	PORT95_FN5___2 = 2223,
	PORT96_FN5___3 = 2224,
	PORT97_FN5___3 = 2225,
	PORT98_FN5___3 = 2226,
	PORT99_FN5___3 = 2227,
	PORT100_FN5___3 = 2228,
	PORT101_FN5___3 = 2229,
	PORT102_FN5___3 = 2230,
	PORT103_FN5___3 = 2231,
	PORT104_FN5___3 = 2232,
	PORT105_FN5___3 = 2233,
	PORT106_FN5___3 = 2234,
	PORT107_FN5___3 = 2235,
	PORT108_FN5___3 = 2236,
	PORT109_FN5___3 = 2237,
	PORT110_FN5___3 = 2238,
	PORT111_FN5___3 = 2239,
	PORT112_FN5___3 = 2240,
	PORT113_FN5___3 = 2241,
	PORT114_FN5___3 = 2242,
	PORT115_FN5___3 = 2243,
	PORT116_FN5___3 = 2244,
	PORT117_FN5___3 = 2245,
	PORT118_FN5___3 = 2246,
	PORT119_FN5___2 = 2247,
	PORT120_FN5___2 = 2248,
	PORT121_FN5___2 = 2249,
	PORT122_FN5___2 = 2250,
	PORT123_FN5___2 = 2251,
	PORT124_FN5___2 = 2252,
	PORT125_FN5___2 = 2253,
	PORT126_FN5___2 = 2254,
	PORT127_FN5 = 2255,
	PORT128_FN5___3 = 2256,
	PORT129_FN5___3 = 2257,
	PORT130_FN5___3 = 2258,
	PORT131_FN5___3 = 2259,
	PORT132_FN5___3 = 2260,
	PORT133_FN5___3 = 2261,
	PORT134_FN5___3 = 2262,
	PORT135_FN5___2 = 2263,
	PORT136_FN5___2 = 2264,
	PORT137_FN5___2 = 2265,
	PORT138_FN5___2 = 2266,
	PORT139_FN5___2 = 2267,
	PORT140_FN5___2 = 2268,
	PORT141_FN5___2 = 2269,
	PORT142_FN5___2 = 2270,
	PORT143_FN5___2 = 2271,
	PORT144_FN5___2 = 2272,
	PORT145_FN5___2 = 2273,
	PORT146_FN5___2 = 2274,
	PORT147_FN5___2 = 2275,
	PORT148_FN5___2 = 2276,
	PORT149_FN5___2 = 2277,
	PORT150_FN5___2 = 2278,
	PORT151_FN5___2 = 2279,
	PORT152_FN5___2 = 2280,
	PORT153_FN5___2 = 2281,
	PORT154_FN5___2 = 2282,
	PORT155_FN5___2 = 2283,
	PORT156_FN5___2 = 2284,
	PORT157_FN5___2 = 2285,
	PORT158_FN5___2 = 2286,
	PORT159_FN5___2 = 2287,
	PORT160_FN5___3 = 2288,
	PORT161_FN5___3 = 2289,
	PORT162_FN5___3 = 2290,
	PORT163_FN5___3 = 2291,
	PORT164_FN5___3 = 2292,
	PORT165_FN5___2 = 2293,
	PORT166_FN5___2 = 2294,
	PORT167_FN5___2 = 2295,
	PORT168_FN5___2 = 2296,
	PORT169_FN5___2 = 2297,
	PORT170_FN5___2 = 2298,
	PORT171_FN5___2 = 2299,
	PORT172_FN5___2 = 2300,
	PORT173_FN5___2 = 2301,
	PORT174_FN5___2 = 2302,
	PORT175_FN5___2 = 2303,
	PORT176_FN5___2 = 2304,
	PORT177_FN5___2 = 2305,
	PORT178_FN5___2 = 2306,
	PORT179_FN5 = 2307,
	PORT180_FN5 = 2308,
	PORT181_FN5 = 2309,
	PORT182_FN5 = 2310,
	PORT183_FN5 = 2311,
	PORT184_FN5 = 2312,
	PORT185_FN5 = 2313,
	PORT186_FN5 = 2314,
	PORT187_FN5 = 2315,
	PORT188_FN5 = 2316,
	PORT189_FN5 = 2317,
	PORT190_FN5 = 2318,
	PORT191_FN5 = 2319,
	PORT192_FN5___3 = 2320,
	PORT193_FN5___3 = 2321,
	PORT194_FN5___3 = 2322,
	PORT195_FN5___3 = 2323,
	PORT196_FN5___3 = 2324,
	PORT197_FN5___3 = 2325,
	PORT198_FN5___3 = 2326,
	PORT199_FN5___3 = 2327,
	PORT200_FN5___3 = 2328,
	PORT201_FN5___3 = 2329,
	PORT202_FN5___3 = 2330,
	PORT203_FN5___3 = 2331,
	PORT204_FN5___3 = 2332,
	PORT205_FN5___3 = 2333,
	PORT206_FN5___3 = 2334,
	PORT207_FN5___3 = 2335,
	PORT208_FN5___3 = 2336,
	PORT209_FN5___3 = 2337,
	PORT210_FN5___3 = 2338,
	PORT211_FN5___3 = 2339,
	PORT0_FN6___3 = 2340,
	PORT1_FN6___3 = 2341,
	PORT2_FN6___3 = 2342,
	PORT3_FN6___3 = 2343,
	PORT4_FN6___3 = 2344,
	PORT5_FN6___3 = 2345,
	PORT6_FN6___3 = 2346,
	PORT7_FN6___3 = 2347,
	PORT8_FN6___3 = 2348,
	PORT9_FN6___3 = 2349,
	PORT10_FN6___3 = 2350,
	PORT11_FN6___3 = 2351,
	PORT12_FN6___3 = 2352,
	PORT13_FN6___3 = 2353,
	PORT14_FN6___3 = 2354,
	PORT15_FN6___3 = 2355,
	PORT16_FN6___3 = 2356,
	PORT17_FN6___3 = 2357,
	PORT18_FN6___3 = 2358,
	PORT19_FN6___3 = 2359,
	PORT20_FN6___3 = 2360,
	PORT21_FN6___3 = 2361,
	PORT22_FN6___3 = 2362,
	PORT23_FN6___3 = 2363,
	PORT24_FN6___3 = 2364,
	PORT25_FN6___3 = 2365,
	PORT26_FN6___3 = 2366,
	PORT27_FN6___3 = 2367,
	PORT28_FN6___3 = 2368,
	PORT29_FN6___3 = 2369,
	PORT30_FN6___3 = 2370,
	PORT31_FN6___2 = 2371,
	PORT32_FN6___3 = 2372,
	PORT33_FN6___3 = 2373,
	PORT34_FN6___3 = 2374,
	PORT35_FN6___3 = 2375,
	PORT36_FN6___3 = 2376,
	PORT37_FN6___3 = 2377,
	PORT38_FN6___3 = 2378,
	PORT39_FN6___3 = 2379,
	PORT40_FN6___3 = 2380,
	PORT41_FN6___2 = 2381,
	PORT42_FN6___2 = 2382,
	PORT43_FN6___2 = 2383,
	PORT44_FN6___2 = 2384,
	PORT45_FN6___2 = 2385,
	PORT46_FN6___2 = 2386,
	PORT47_FN6___2 = 2387,
	PORT48_FN6___2 = 2388,
	PORT49_FN6___2 = 2389,
	PORT50_FN6___2 = 2390,
	PORT51_FN6___2 = 2391,
	PORT52_FN6___2 = 2392,
	PORT53_FN6___2 = 2393,
	PORT54_FN6___2 = 2394,
	PORT55_FN6___2 = 2395,
	PORT56_FN6___2 = 2396,
	PORT57_FN6___2 = 2397,
	PORT58_FN6___2 = 2398,
	PORT59_FN6___2 = 2399,
	PORT60_FN6___2 = 2400,
	PORT61_FN6___2 = 2401,
	PORT62_FN6___2 = 2402,
	PORT63_FN6___2 = 2403,
	PORT64_FN6___3 = 2404,
	PORT65_FN6___3 = 2405,
	PORT66_FN6___3 = 2406,
	PORT67_FN6___3 = 2407,
	PORT68_FN6___3 = 2408,
	PORT69_FN6___3 = 2409,
	PORT70_FN6___3 = 2410,
	PORT71_FN6___3 = 2411,
	PORT72_FN6___3 = 2412,
	PORT73_FN6___3 = 2413,
	PORT74_FN6___3 = 2414,
	PORT75_FN6___3 = 2415,
	PORT76_FN6___3 = 2416,
	PORT77_FN6___3 = 2417,
	PORT78_FN6___3 = 2418,
	PORT79_FN6___3 = 2419,
	PORT80_FN6___3 = 2420,
	PORT81_FN6___3 = 2421,
	PORT82_FN6___3 = 2422,
	PORT83_FN6___3 = 2423,
	PORT84_FN6___3 = 2424,
	PORT85_FN6___3 = 2425,
	PORT86_FN6___2 = 2426,
	PORT87_FN6___2 = 2427,
	PORT88_FN6___2 = 2428,
	PORT89_FN6___2 = 2429,
	PORT90_FN6___2 = 2430,
	PORT91_FN6___2 = 2431,
	PORT92_FN6___2 = 2432,
	PORT93_FN6___2 = 2433,
	PORT94_FN6___2 = 2434,
	PORT95_FN6___2 = 2435,
	PORT96_FN6___3 = 2436,
	PORT97_FN6___3 = 2437,
	PORT98_FN6___3 = 2438,
	PORT99_FN6___3 = 2439,
	PORT100_FN6___3 = 2440,
	PORT101_FN6___3 = 2441,
	PORT102_FN6___3 = 2442,
	PORT103_FN6___3 = 2443,
	PORT104_FN6___3 = 2444,
	PORT105_FN6___3 = 2445,
	PORT106_FN6___3 = 2446,
	PORT107_FN6___3 = 2447,
	PORT108_FN6___3 = 2448,
	PORT109_FN6___3 = 2449,
	PORT110_FN6___3 = 2450,
	PORT111_FN6___3 = 2451,
	PORT112_FN6___3 = 2452,
	PORT113_FN6___3 = 2453,
	PORT114_FN6___3 = 2454,
	PORT115_FN6___3 = 2455,
	PORT116_FN6___3 = 2456,
	PORT117_FN6___3 = 2457,
	PORT118_FN6___3 = 2458,
	PORT119_FN6___2 = 2459,
	PORT120_FN6___2 = 2460,
	PORT121_FN6___2 = 2461,
	PORT122_FN6___2 = 2462,
	PORT123_FN6___2 = 2463,
	PORT124_FN6___2 = 2464,
	PORT125_FN6___2 = 2465,
	PORT126_FN6___2 = 2466,
	PORT127_FN6 = 2467,
	PORT128_FN6___3 = 2468,
	PORT129_FN6___3 = 2469,
	PORT130_FN6___3 = 2470,
	PORT131_FN6___3 = 2471,
	PORT132_FN6___3 = 2472,
	PORT133_FN6___3 = 2473,
	PORT134_FN6___3 = 2474,
	PORT135_FN6___2 = 2475,
	PORT136_FN6___2 = 2476,
	PORT137_FN6___2 = 2477,
	PORT138_FN6___2 = 2478,
	PORT139_FN6___2 = 2479,
	PORT140_FN6___2 = 2480,
	PORT141_FN6___2 = 2481,
	PORT142_FN6___2 = 2482,
	PORT143_FN6___2 = 2483,
	PORT144_FN6___2 = 2484,
	PORT145_FN6___2 = 2485,
	PORT146_FN6___2 = 2486,
	PORT147_FN6___2 = 2487,
	PORT148_FN6___2 = 2488,
	PORT149_FN6___2 = 2489,
	PORT150_FN6___2 = 2490,
	PORT151_FN6___2 = 2491,
	PORT152_FN6___2 = 2492,
	PORT153_FN6___2 = 2493,
	PORT154_FN6___2 = 2494,
	PORT155_FN6___2 = 2495,
	PORT156_FN6___2 = 2496,
	PORT157_FN6___2 = 2497,
	PORT158_FN6___2 = 2498,
	PORT159_FN6___2 = 2499,
	PORT160_FN6___3 = 2500,
	PORT161_FN6___3 = 2501,
	PORT162_FN6___3 = 2502,
	PORT163_FN6___3 = 2503,
	PORT164_FN6___3 = 2504,
	PORT165_FN6___2 = 2505,
	PORT166_FN6___2 = 2506,
	PORT167_FN6___2 = 2507,
	PORT168_FN6___2 = 2508,
	PORT169_FN6___2 = 2509,
	PORT170_FN6___2 = 2510,
	PORT171_FN6___2 = 2511,
	PORT172_FN6___2 = 2512,
	PORT173_FN6___2 = 2513,
	PORT174_FN6___2 = 2514,
	PORT175_FN6___2 = 2515,
	PORT176_FN6___2 = 2516,
	PORT177_FN6___2 = 2517,
	PORT178_FN6___2 = 2518,
	PORT179_FN6 = 2519,
	PORT180_FN6 = 2520,
	PORT181_FN6 = 2521,
	PORT182_FN6 = 2522,
	PORT183_FN6 = 2523,
	PORT184_FN6 = 2524,
	PORT185_FN6 = 2525,
	PORT186_FN6 = 2526,
	PORT187_FN6 = 2527,
	PORT188_FN6 = 2528,
	PORT189_FN6 = 2529,
	PORT190_FN6 = 2530,
	PORT191_FN6 = 2531,
	PORT192_FN6___3 = 2532,
	PORT193_FN6___3 = 2533,
	PORT194_FN6___3 = 2534,
	PORT195_FN6___3 = 2535,
	PORT196_FN6___3 = 2536,
	PORT197_FN6___3 = 2537,
	PORT198_FN6___3 = 2538,
	PORT199_FN6___3 = 2539,
	PORT200_FN6___3 = 2540,
	PORT201_FN6___3 = 2541,
	PORT202_FN6___3 = 2542,
	PORT203_FN6___3 = 2543,
	PORT204_FN6___3 = 2544,
	PORT205_FN6___3 = 2545,
	PORT206_FN6___3 = 2546,
	PORT207_FN6___3 = 2547,
	PORT208_FN6___3 = 2548,
	PORT209_FN6___3 = 2549,
	PORT210_FN6___3 = 2550,
	PORT211_FN6___3 = 2551,
	PORT0_FN7___3 = 2552,
	PORT1_FN7___3 = 2553,
	PORT2_FN7___3 = 2554,
	PORT3_FN7___3 = 2555,
	PORT4_FN7___3 = 2556,
	PORT5_FN7___3 = 2557,
	PORT6_FN7___3 = 2558,
	PORT7_FN7___3 = 2559,
	PORT8_FN7___3 = 2560,
	PORT9_FN7___3 = 2561,
	PORT10_FN7___3 = 2562,
	PORT11_FN7___3 = 2563,
	PORT12_FN7___3 = 2564,
	PORT13_FN7___3 = 2565,
	PORT14_FN7___3 = 2566,
	PORT15_FN7___3 = 2567,
	PORT16_FN7___3 = 2568,
	PORT17_FN7___3 = 2569,
	PORT18_FN7___3 = 2570,
	PORT19_FN7___3 = 2571,
	PORT20_FN7___3 = 2572,
	PORT21_FN7___3 = 2573,
	PORT22_FN7___3 = 2574,
	PORT23_FN7___3 = 2575,
	PORT24_FN7___3 = 2576,
	PORT25_FN7___3 = 2577,
	PORT26_FN7___3 = 2578,
	PORT27_FN7___3 = 2579,
	PORT28_FN7___3 = 2580,
	PORT29_FN7___3 = 2581,
	PORT30_FN7___3 = 2582,
	PORT31_FN7___2 = 2583,
	PORT32_FN7___3 = 2584,
	PORT33_FN7___3 = 2585,
	PORT34_FN7___3 = 2586,
	PORT35_FN7___3 = 2587,
	PORT36_FN7___3 = 2588,
	PORT37_FN7___3 = 2589,
	PORT38_FN7___3 = 2590,
	PORT39_FN7___3 = 2591,
	PORT40_FN7___3 = 2592,
	PORT41_FN7___2 = 2593,
	PORT42_FN7___2 = 2594,
	PORT43_FN7___2 = 2595,
	PORT44_FN7___2 = 2596,
	PORT45_FN7___2 = 2597,
	PORT46_FN7___2 = 2598,
	PORT47_FN7___2 = 2599,
	PORT48_FN7___2 = 2600,
	PORT49_FN7___2 = 2601,
	PORT50_FN7___2 = 2602,
	PORT51_FN7___2 = 2603,
	PORT52_FN7___2 = 2604,
	PORT53_FN7___2 = 2605,
	PORT54_FN7___2 = 2606,
	PORT55_FN7___2 = 2607,
	PORT56_FN7___2 = 2608,
	PORT57_FN7___2 = 2609,
	PORT58_FN7___2 = 2610,
	PORT59_FN7___2 = 2611,
	PORT60_FN7___2 = 2612,
	PORT61_FN7___2 = 2613,
	PORT62_FN7___2 = 2614,
	PORT63_FN7___2 = 2615,
	PORT64_FN7___3 = 2616,
	PORT65_FN7___3 = 2617,
	PORT66_FN7___3 = 2618,
	PORT67_FN7___3 = 2619,
	PORT68_FN7___3 = 2620,
	PORT69_FN7___3 = 2621,
	PORT70_FN7___3 = 2622,
	PORT71_FN7___3 = 2623,
	PORT72_FN7___3 = 2624,
	PORT73_FN7___3 = 2625,
	PORT74_FN7___3 = 2626,
	PORT75_FN7___3 = 2627,
	PORT76_FN7___3 = 2628,
	PORT77_FN7___3 = 2629,
	PORT78_FN7___3 = 2630,
	PORT79_FN7___3 = 2631,
	PORT80_FN7___3 = 2632,
	PORT81_FN7___3 = 2633,
	PORT82_FN7___3 = 2634,
	PORT83_FN7___3 = 2635,
	PORT84_FN7___3 = 2636,
	PORT85_FN7___3 = 2637,
	PORT86_FN7___2 = 2638,
	PORT87_FN7___2 = 2639,
	PORT88_FN7___2 = 2640,
	PORT89_FN7___2 = 2641,
	PORT90_FN7___2 = 2642,
	PORT91_FN7___2 = 2643,
	PORT92_FN7___2 = 2644,
	PORT93_FN7___2 = 2645,
	PORT94_FN7___2 = 2646,
	PORT95_FN7___2 = 2647,
	PORT96_FN7___3 = 2648,
	PORT97_FN7___3 = 2649,
	PORT98_FN7___3 = 2650,
	PORT99_FN7___3 = 2651,
	PORT100_FN7___3 = 2652,
	PORT101_FN7___3 = 2653,
	PORT102_FN7___3 = 2654,
	PORT103_FN7___3 = 2655,
	PORT104_FN7___3 = 2656,
	PORT105_FN7___3 = 2657,
	PORT106_FN7___3 = 2658,
	PORT107_FN7___3 = 2659,
	PORT108_FN7___3 = 2660,
	PORT109_FN7___3 = 2661,
	PORT110_FN7___3 = 2662,
	PORT111_FN7___3 = 2663,
	PORT112_FN7___3 = 2664,
	PORT113_FN7___3 = 2665,
	PORT114_FN7___3 = 2666,
	PORT115_FN7___3 = 2667,
	PORT116_FN7___3 = 2668,
	PORT117_FN7___3 = 2669,
	PORT118_FN7___3 = 2670,
	PORT119_FN7___2 = 2671,
	PORT120_FN7___2 = 2672,
	PORT121_FN7___2 = 2673,
	PORT122_FN7___2 = 2674,
	PORT123_FN7___2 = 2675,
	PORT124_FN7___2 = 2676,
	PORT125_FN7___2 = 2677,
	PORT126_FN7___2 = 2678,
	PORT127_FN7 = 2679,
	PORT128_FN7___3 = 2680,
	PORT129_FN7___3 = 2681,
	PORT130_FN7___3 = 2682,
	PORT131_FN7___3 = 2683,
	PORT132_FN7___3 = 2684,
	PORT133_FN7___3 = 2685,
	PORT134_FN7___3 = 2686,
	PORT135_FN7___2 = 2687,
	PORT136_FN7___2 = 2688,
	PORT137_FN7___2 = 2689,
	PORT138_FN7___2 = 2690,
	PORT139_FN7___2 = 2691,
	PORT140_FN7___2 = 2692,
	PORT141_FN7___2 = 2693,
	PORT142_FN7___2 = 2694,
	PORT143_FN7___2 = 2695,
	PORT144_FN7___2 = 2696,
	PORT145_FN7___2 = 2697,
	PORT146_FN7___2 = 2698,
	PORT147_FN7___2 = 2699,
	PORT148_FN7___2 = 2700,
	PORT149_FN7___2 = 2701,
	PORT150_FN7___2 = 2702,
	PORT151_FN7___2 = 2703,
	PORT152_FN7___2 = 2704,
	PORT153_FN7___2 = 2705,
	PORT154_FN7___2 = 2706,
	PORT155_FN7___2 = 2707,
	PORT156_FN7___2 = 2708,
	PORT157_FN7___2 = 2709,
	PORT158_FN7___2 = 2710,
	PORT159_FN7___2 = 2711,
	PORT160_FN7___3 = 2712,
	PORT161_FN7___3 = 2713,
	PORT162_FN7___3 = 2714,
	PORT163_FN7___3 = 2715,
	PORT164_FN7___3 = 2716,
	PORT165_FN7___2 = 2717,
	PORT166_FN7___2 = 2718,
	PORT167_FN7___2 = 2719,
	PORT168_FN7___2 = 2720,
	PORT169_FN7___2 = 2721,
	PORT170_FN7___2 = 2722,
	PORT171_FN7___2 = 2723,
	PORT172_FN7___2 = 2724,
	PORT173_FN7___2 = 2725,
	PORT174_FN7___2 = 2726,
	PORT175_FN7___2 = 2727,
	PORT176_FN7___2 = 2728,
	PORT177_FN7___2 = 2729,
	PORT178_FN7___2 = 2730,
	PORT179_FN7 = 2731,
	PORT180_FN7 = 2732,
	PORT181_FN7 = 2733,
	PORT182_FN7 = 2734,
	PORT183_FN7 = 2735,
	PORT184_FN7 = 2736,
	PORT185_FN7 = 2737,
	PORT186_FN7 = 2738,
	PORT187_FN7 = 2739,
	PORT188_FN7 = 2740,
	PORT189_FN7 = 2741,
	PORT190_FN7 = 2742,
	PORT191_FN7 = 2743,
	PORT192_FN7___3 = 2744,
	PORT193_FN7___3 = 2745,
	PORT194_FN7___3 = 2746,
	PORT195_FN7___3 = 2747,
	PORT196_FN7___3 = 2748,
	PORT197_FN7___3 = 2749,
	PORT198_FN7___3 = 2750,
	PORT199_FN7___3 = 2751,
	PORT200_FN7___3 = 2752,
	PORT201_FN7___3 = 2753,
	PORT202_FN7___3 = 2754,
	PORT203_FN7___3 = 2755,
	PORT204_FN7___3 = 2756,
	PORT205_FN7___3 = 2757,
	PORT206_FN7___3 = 2758,
	PORT207_FN7___3 = 2759,
	PORT208_FN7___3 = 2760,
	PORT209_FN7___3 = 2761,
	PORT210_FN7___3 = 2762,
	PORT211_FN7___3 = 2763,
	MSEL1CR_31_0___2 = 2764,
	MSEL1CR_31_1___2 = 2765,
	MSEL1CR_30_0 = 2766,
	MSEL1CR_30_1 = 2767,
	MSEL1CR_29_0 = 2768,
	MSEL1CR_29_1 = 2769,
	MSEL1CR_28_0 = 2770,
	MSEL1CR_28_1 = 2771,
	MSEL1CR_27_0___2 = 2772,
	MSEL1CR_27_1___2 = 2773,
	MSEL1CR_26_0 = 2774,
	MSEL1CR_26_1 = 2775,
	MSEL1CR_16_0___2 = 2776,
	MSEL1CR_16_1___2 = 2777,
	MSEL1CR_15_0___2 = 2778,
	MSEL1CR_15_1___2 = 2779,
	MSEL1CR_14_0___2 = 2780,
	MSEL1CR_14_1___2 = 2781,
	MSEL1CR_13_0___2 = 2782,
	MSEL1CR_13_1___2 = 2783,
	MSEL1CR_12_0___2 = 2784,
	MSEL1CR_12_1___2 = 2785,
	MSEL1CR_9_0 = 2786,
	MSEL1CR_9_1 = 2787,
	MSEL1CR_7_0 = 2788,
	MSEL1CR_7_1 = 2789,
	MSEL1CR_6_0 = 2790,
	MSEL1CR_6_1 = 2791,
	MSEL1CR_5_0 = 2792,
	MSEL1CR_5_1 = 2793,
	MSEL1CR_4_0 = 2794,
	MSEL1CR_4_1 = 2795,
	MSEL1CR_3_0 = 2796,
	MSEL1CR_3_1 = 2797,
	MSEL1CR_2_0 = 2798,
	MSEL1CR_2_1 = 2799,
	MSEL1CR_0_0 = 2800,
	MSEL1CR_0_1 = 2801,
	MSEL3CR_15_0___2 = 2802,
	MSEL3CR_15_1___2 = 2803,
	MSEL3CR_6_0 = 2804,
	MSEL3CR_6_1 = 2805,
	MSEL4CR_19_0___2 = 2806,
	MSEL4CR_19_1___2 = 2807,
	MSEL4CR_18_0___2 = 2808,
	MSEL4CR_18_1___2 = 2809,
	MSEL4CR_15_0___2 = 2810,
	MSEL4CR_15_1___2 = 2811,
	MSEL4CR_10_0___2 = 2812,
	MSEL4CR_10_1___2 = 2813,
	MSEL4CR_6_0 = 2814,
	MSEL4CR_6_1 = 2815,
	MSEL4CR_4_0 = 2816,
	MSEL4CR_4_1 = 2817,
	MSEL4CR_1_0 = 2818,
	MSEL4CR_1_1 = 2819,
	MSEL5CR_31_0___2 = 2820,
	MSEL5CR_31_1___2 = 2821,
	MSEL5CR_30_0___2 = 2822,
	MSEL5CR_30_1___2 = 2823,
	MSEL5CR_29_0___2 = 2824,
	MSEL5CR_29_1___2 = 2825,
	MSEL5CR_27_0___2 = 2826,
	MSEL5CR_27_1___2 = 2827,
	MSEL5CR_25_0___2 = 2828,
	MSEL5CR_25_1___2 = 2829,
	MSEL5CR_23_0___2 = 2830,
	MSEL5CR_23_1___2 = 2831,
	MSEL5CR_21_0___2 = 2832,
	MSEL5CR_21_1___2 = 2833,
	MSEL5CR_19_0___2 = 2834,
	MSEL5CR_19_1___2 = 2835,
	MSEL5CR_17_0___2 = 2836,
	MSEL5CR_17_1___2 = 2837,
	MSEL5CR_15_0___2 = 2838,
	MSEL5CR_15_1___2 = 2839,
	MSEL5CR_14_0___2 = 2840,
	MSEL5CR_14_1___2 = 2841,
	MSEL5CR_13_0___2 = 2842,
	MSEL5CR_13_1___2 = 2843,
	MSEL5CR_12_0___2 = 2844,
	MSEL5CR_12_1___2 = 2845,
	MSEL5CR_11_0___2 = 2846,
	MSEL5CR_11_1___2 = 2847,
	MSEL5CR_10_0___2 = 2848,
	MSEL5CR_10_1___2 = 2849,
	MSEL5CR_8_0 = 2850,
	MSEL5CR_8_1 = 2851,
	MSEL5CR_7_0 = 2852,
	MSEL5CR_7_1 = 2853,
	MSEL5CR_6_0 = 2854,
	MSEL5CR_6_1 = 2855,
	MSEL5CR_5_0 = 2856,
	MSEL5CR_5_1 = 2857,
	MSEL5CR_4_0 = 2858,
	MSEL5CR_4_1 = 2859,
	MSEL5CR_3_0 = 2860,
	MSEL5CR_3_1 = 2861,
	MSEL5CR_2_0 = 2862,
	MSEL5CR_2_1 = 2863,
	MSEL5CR_0_0 = 2864,
	MSEL5CR_0_1 = 2865,
	PINMUX_FUNCTION_END___6 = 2866,
	PINMUX_MARK_BEGIN___6 = 2867,
	IRQ0_PORT2_MARK = 2868,
	IRQ0_PORT13_MARK = 2869,
	IRQ1_MARK___5 = 2870,
	IRQ2_PORT11_MARK = 2871,
	IRQ2_PORT12_MARK = 2872,
	IRQ3_PORT10_MARK = 2873,
	IRQ3_PORT14_MARK = 2874,
	IRQ4_PORT15_MARK = 2875,
	IRQ4_PORT172_MARK = 2876,
	IRQ5_PORT0_MARK = 2877,
	IRQ5_PORT1_MARK = 2878,
	IRQ6_PORT121_MARK = 2879,
	IRQ6_PORT173_MARK = 2880,
	IRQ7_PORT120_MARK = 2881,
	IRQ7_PORT209_MARK = 2882,
	IRQ8_MARK___4 = 2883,
	IRQ9_PORT118_MARK = 2884,
	IRQ9_PORT210_MARK = 2885,
	IRQ10_MARK___2 = 2886,
	IRQ11_MARK___2 = 2887,
	IRQ12_PORT42_MARK = 2888,
	IRQ12_PORT97_MARK = 2889,
	IRQ13_PORT64_MARK = 2890,
	IRQ13_PORT98_MARK = 2891,
	IRQ14_PORT63_MARK = 2892,
	IRQ14_PORT99_MARK = 2893,
	IRQ15_PORT62_MARK = 2894,
	IRQ15_PORT100_MARK = 2895,
	IRQ16_PORT68_MARK = 2896,
	IRQ16_PORT211_MARK = 2897,
	IRQ17_MARK___2 = 2898,
	IRQ18_MARK___2 = 2899,
	IRQ19_MARK___2 = 2900,
	IRQ20_MARK___2 = 2901,
	IRQ21_MARK___2 = 2902,
	IRQ22_MARK___2 = 2903,
	IRQ23_MARK___2 = 2904,
	IRQ24_MARK___2 = 2905,
	IRQ25_MARK___2 = 2906,
	IRQ26_PORT58_MARK = 2907,
	IRQ26_PORT81_MARK = 2908,
	IRQ27_PORT57_MARK = 2909,
	IRQ27_PORT168_MARK = 2910,
	IRQ28_PORT56_MARK = 2911,
	IRQ28_PORT169_MARK = 2912,
	IRQ29_PORT50_MARK = 2913,
	IRQ29_PORT170_MARK = 2914,
	IRQ30_PORT49_MARK = 2915,
	IRQ30_PORT171_MARK = 2916,
	IRQ31_PORT41_MARK = 2917,
	IRQ31_PORT167_MARK = 2918,
	DBGMDT2_MARK = 2919,
	DBGMDT1_MARK = 2920,
	DBGMDT0_MARK = 2921,
	DBGMD10_MARK = 2922,
	DBGMD11_MARK = 2923,
	DBGMD20_MARK = 2924,
	DBGMD21_MARK = 2925,
	FSIAISLD_PORT0_MARK = 2926,
	FSIAISLD_PORT5_MARK = 2927,
	FSIASPDIF_PORT9_MARK = 2928,
	FSIASPDIF_PORT18_MARK = 2929,
	FSIAOSLD1_MARK = 2930,
	FSIAOSLD2_MARK = 2931,
	FSIAOLR_MARK___3 = 2932,
	FSIAOBT_MARK___3 = 2933,
	FSIAOSLD_MARK___3 = 2934,
	FSIAOMC_MARK___3 = 2935,
	FSIACK_MARK___3 = 2936,
	FSIAILR_MARK___3 = 2937,
	FSIAIBT_MARK___3 = 2938,
	FSIBCK_MARK___3 = 2939,
	FMSISLD_PORT1_MARK = 2940,
	FMSISLD_PORT6_MARK = 2941,
	FMSIILR_MARK = 2942,
	FMSIIBT_MARK = 2943,
	FMSIOLR_MARK = 2944,
	FMSIOBT_MARK = 2945,
	FMSICK_MARK = 2946,
	FMSOILR_MARK = 2947,
	FMSOIBT_MARK = 2948,
	FMSOOLR_MARK = 2949,
	FMSOOBT_MARK = 2950,
	FMSOSLD_MARK = 2951,
	FMSOCK_MARK = 2952,
	SCIFA0_SCK_MARK___3 = 2953,
	SCIFA0_CTS_MARK___2 = 2954,
	SCIFA0_RTS_MARK___2 = 2955,
	SCIFA0_RXD_MARK___5 = 2956,
	SCIFA0_TXD_MARK___5 = 2957,
	SCIFA1_CTS_MARK___2 = 2958,
	SCIFA1_SCK_MARK___5 = 2959,
	SCIFA1_RXD_MARK___5 = 2960,
	SCIFA1_TXD_MARK___5 = 2961,
	SCIFA1_RTS_MARK___2 = 2962,
	SCIFA2_SCK_PORT22_MARK = 2963,
	SCIFA2_SCK_PORT199_MARK = 2964,
	SCIFA2_RXD_MARK___3 = 2965,
	SCIFA2_TXD_MARK___3 = 2966,
	SCIFA2_CTS_MARK = 2967,
	SCIFA2_RTS_MARK = 2968,
	SCIFA3_RTS_PORT105_MARK = 2969,
	SCIFA3_SCK_PORT116_MARK = 2970,
	SCIFA3_CTS_PORT117_MARK = 2971,
	SCIFA3_RXD_PORT174_MARK = 2972,
	SCIFA3_TXD_PORT175_MARK = 2973,
	SCIFA3_RTS_PORT161_MARK = 2974,
	SCIFA3_SCK_PORT158_MARK = 2975,
	SCIFA3_CTS_PORT162_MARK = 2976,
	SCIFA3_RXD_PORT159_MARK = 2977,
	SCIFA3_TXD_PORT160_MARK = 2978,
	SCIFA4_RXD_PORT12_MARK = 2979,
	SCIFA4_TXD_PORT13_MARK = 2980,
	SCIFA4_RXD_PORT204_MARK = 2981,
	SCIFA4_TXD_PORT203_MARK = 2982,
	SCIFA4_RXD_PORT94_MARK = 2983,
	SCIFA4_TXD_PORT93_MARK = 2984,
	SCIFA4_SCK_PORT21_MARK = 2985,
	SCIFA4_SCK_PORT205_MARK = 2986,
	SCIFA5_TXD_PORT20_MARK = 2987,
	SCIFA5_RXD_PORT10_MARK = 2988,
	SCIFA5_RXD_PORT207_MARK = 2989,
	SCIFA5_TXD_PORT208_MARK = 2990,
	SCIFA5_TXD_PORT91_MARK = 2991,
	SCIFA5_RXD_PORT92_MARK = 2992,
	SCIFA5_SCK_PORT23_MARK = 2993,
	SCIFA5_SCK_PORT206_MARK = 2994,
	SCIFA6_SCK_MARK = 2995,
	SCIFA6_RXD_MARK = 2996,
	SCIFA6_TXD_MARK___2 = 2997,
	SCIFA7_TXD_MARK___2 = 2998,
	SCIFA7_RXD_MARK___2 = 2999,
	SCIFB_SCK_PORT190_MARK = 3000,
	SCIFB_RXD_PORT191_MARK = 3001,
	SCIFB_TXD_PORT192_MARK = 3002,
	SCIFB_RTS_PORT186_MARK = 3003,
	SCIFB_CTS_PORT187_MARK = 3004,
	SCIFB_SCK_PORT2_MARK = 3005,
	SCIFB_RXD_PORT3_MARK = 3006,
	SCIFB_TXD_PORT4_MARK = 3007,
	SCIFB_RTS_PORT172_MARK = 3008,
	SCIFB_CTS_PORT173_MARK = 3009,
	LCD0_D0_MARK = 3010,
	LCD0_D1_MARK = 3011,
	LCD0_D2_MARK = 3012,
	LCD0_D3_MARK = 3013,
	LCD0_D4_MARK = 3014,
	LCD0_D5_MARK = 3015,
	LCD0_D6_MARK = 3016,
	LCD0_D7_MARK = 3017,
	LCD0_D8_MARK = 3018,
	LCD0_D9_MARK = 3019,
	LCD0_D10_MARK = 3020,
	LCD0_D11_MARK = 3021,
	LCD0_D12_MARK = 3022,
	LCD0_D13_MARK = 3023,
	LCD0_D14_MARK = 3024,
	LCD0_D15_MARK = 3025,
	LCD0_D16_MARK = 3026,
	LCD0_D17_MARK = 3027,
	LCD0_DON_MARK = 3028,
	LCD0_VCPWC_MARK = 3029,
	LCD0_VEPWC_MARK = 3030,
	LCD0_DCK_MARK = 3031,
	LCD0_VSYN_MARK = 3032,
	LCD0_HSYN_MARK = 3033,
	LCD0_DISP_MARK = 3034,
	LCD0_WR_MARK = 3035,
	LCD0_RD_MARK = 3036,
	LCD0_CS_MARK = 3037,
	LCD0_RS_MARK = 3038,
	LCD0_D21_PORT158_MARK = 3039,
	LCD0_D23_PORT159_MARK = 3040,
	LCD0_D22_PORT160_MARK = 3041,
	LCD0_D20_PORT161_MARK = 3042,
	LCD0_D19_PORT162_MARK = 3043,
	LCD0_D18_PORT163_MARK = 3044,
	LCD0_LCLK_PORT165_MARK = 3045,
	LCD0_D18_PORT40_MARK = 3046,
	LCD0_D22_PORT0_MARK = 3047,
	LCD0_D23_PORT1_MARK = 3048,
	LCD0_D21_PORT2_MARK = 3049,
	LCD0_D20_PORT3_MARK = 3050,
	LCD0_D19_PORT4_MARK = 3051,
	LCD0_LCLK_PORT102_MARK = 3052,
	LCD1_D0_MARK = 3053,
	LCD1_D1_MARK = 3054,
	LCD1_D2_MARK = 3055,
	LCD1_D3_MARK = 3056,
	LCD1_D4_MARK = 3057,
	LCD1_D5_MARK = 3058,
	LCD1_D6_MARK = 3059,
	LCD1_D7_MARK = 3060,
	LCD1_D8_MARK = 3061,
	LCD1_D9_MARK = 3062,
	LCD1_D10_MARK = 3063,
	LCD1_D11_MARK = 3064,
	LCD1_D12_MARK = 3065,
	LCD1_D13_MARK = 3066,
	LCD1_D14_MARK = 3067,
	LCD1_D15_MARK = 3068,
	LCD1_D16_MARK = 3069,
	LCD1_D17_MARK = 3070,
	LCD1_D18_MARK = 3071,
	LCD1_D19_MARK = 3072,
	LCD1_D20_MARK = 3073,
	LCD1_D21_MARK = 3074,
	LCD1_D22_MARK = 3075,
	LCD1_D23_MARK = 3076,
	LCD1_DON_MARK = 3077,
	LCD1_VCPWC_MARK = 3078,
	LCD1_LCLK_MARK = 3079,
	LCD1_VEPWC_MARK = 3080,
	LCD1_DCK_MARK = 3081,
	LCD1_VSYN_MARK = 3082,
	LCD1_HSYN_MARK = 3083,
	LCD1_DISP_MARK = 3084,
	LCD1_RS_MARK = 3085,
	LCD1_CS_MARK = 3086,
	LCD1_RD_MARK = 3087,
	LCD1_WR_MARK = 3088,
	RSPI_SSL0_A_MARK = 3089,
	RSPI_SSL1_A_MARK = 3090,
	RSPI_SSL2_A_MARK = 3091,
	RSPI_SSL3_A_MARK = 3092,
	RSPI_CK_A_MARK = 3093,
	RSPI_MOSI_A_MARK = 3094,
	RSPI_MISO_A_MARK = 3095,
	VIO_CKO1_MARK = 3096,
	VIO_CKO2_MARK = 3097,
	VIO_CKO_1_MARK = 3098,
	VIO_CKO_MARK___2 = 3099,
	VIO0_D0_MARK = 3100,
	VIO0_D1_MARK = 3101,
	VIO0_D2_MARK = 3102,
	VIO0_D3_MARK = 3103,
	VIO0_D4_MARK = 3104,
	VIO0_D5_MARK = 3105,
	VIO0_D6_MARK = 3106,
	VIO0_D7_MARK = 3107,
	VIO0_D8_MARK = 3108,
	VIO0_D9_MARK = 3109,
	VIO0_D10_MARK = 3110,
	VIO0_D11_MARK = 3111,
	VIO0_D12_MARK = 3112,
	VIO0_VD_MARK = 3113,
	VIO0_HD_MARK = 3114,
	VIO0_CLK_MARK = 3115,
	VIO0_FIELD_MARK = 3116,
	VIO0_D13_PORT26_MARK = 3117,
	VIO0_D14_PORT25_MARK = 3118,
	VIO0_D15_PORT24_MARK = 3119,
	VIO0_D13_PORT22_MARK = 3120,
	VIO0_D14_PORT95_MARK = 3121,
	VIO0_D15_PORT96_MARK = 3122,
	VIO1_D0_MARK = 3123,
	VIO1_D1_MARK = 3124,
	VIO1_D2_MARK = 3125,
	VIO1_D3_MARK = 3126,
	VIO1_D4_MARK = 3127,
	VIO1_D5_MARK = 3128,
	VIO1_D6_MARK = 3129,
	VIO1_D7_MARK = 3130,
	VIO1_VD_MARK = 3131,
	VIO1_HD_MARK = 3132,
	VIO1_CLK_MARK = 3133,
	VIO1_FIELD_MARK = 3134,
	TPU0TO0_MARK___3 = 3135,
	TPU0TO1_MARK___3 = 3136,
	TPU0TO3_MARK___3 = 3137,
	TPU0TO2_PORT66_MARK = 3138,
	TPU0TO2_PORT202_MARK = 3139,
	STP0_IPD0_MARK = 3140,
	STP0_IPD1_MARK = 3141,
	STP0_IPD2_MARK = 3142,
	STP0_IPD3_MARK = 3143,
	STP0_IPD4_MARK = 3144,
	STP0_IPD5_MARK = 3145,
	STP0_IPD6_MARK = 3146,
	STP0_IPD7_MARK = 3147,
	STP0_IPEN_MARK = 3148,
	STP0_IPCLK_MARK = 3149,
	STP0_IPSYNC_MARK = 3150,
	STP1_IPD1_MARK = 3151,
	STP1_IPD2_MARK = 3152,
	STP1_IPD3_MARK = 3153,
	STP1_IPD4_MARK = 3154,
	STP1_IPD5_MARK = 3155,
	STP1_IPD6_MARK = 3156,
	STP1_IPD7_MARK = 3157,
	STP1_IPCLK_MARK = 3158,
	STP1_IPSYNC_MARK = 3159,
	STP1_IPD0_PORT186_MARK = 3160,
	STP1_IPEN_PORT187_MARK = 3161,
	STP1_IPD0_PORT194_MARK = 3162,
	STP1_IPEN_PORT193_MARK = 3163,
	SIM_RST_MARK___3 = 3164,
	SIM_CLK_MARK___3 = 3165,
	SIM_D_PORT22_MARK = 3166,
	SIM_D_PORT199_MARK = 3167,
	SDHI0_D0_MARK = 3168,
	SDHI0_D1_MARK = 3169,
	SDHI0_D2_MARK = 3170,
	SDHI0_D3_MARK = 3171,
	SDHI0_CD_MARK = 3172,
	SDHI0_WP_MARK = 3173,
	SDHI0_CMD_MARK = 3174,
	SDHI0_CLK_MARK = 3175,
	SDHI1_D0_MARK = 3176,
	SDHI1_D1_MARK = 3177,
	SDHI1_D2_MARK = 3178,
	SDHI1_D3_MARK = 3179,
	SDHI1_CD_MARK = 3180,
	SDHI1_WP_MARK = 3181,
	SDHI1_CMD_MARK = 3182,
	SDHI1_CLK_MARK = 3183,
	SDHI2_D0_MARK = 3184,
	SDHI2_D1_MARK = 3185,
	SDHI2_D2_MARK = 3186,
	SDHI2_D3_MARK = 3187,
	SDHI2_CLK_MARK = 3188,
	SDHI2_CMD_MARK = 3189,
	SDHI2_CD_PORT24_MARK = 3190,
	SDHI2_WP_PORT25_MARK = 3191,
	SDHI2_WP_PORT177_MARK = 3192,
	SDHI2_CD_PORT202_MARK = 3193,
	MSIOF2_TXD_MARK___5 = 3194,
	MSIOF2_RXD_MARK___4 = 3195,
	MSIOF2_TSCK_MARK___2 = 3196,
	MSIOF2_SS2_MARK___4 = 3197,
	MSIOF2_TSYNC_MARK___2 = 3198,
	MSIOF2_SS1_MARK___4 = 3199,
	MSIOF2_MCK1_MARK___2 = 3200,
	MSIOF2_MCK0_MARK___2 = 3201,
	MSIOF2_RSYNC_MARK___2 = 3202,
	MSIOF2_RSCK_MARK___2 = 3203,
	KEYIN4_MARK___3 = 3204,
	KEYIN5_MARK___3 = 3205,
	KEYIN6_MARK___3 = 3206,
	KEYIN7_MARK___3 = 3207,
	KEYOUT0_MARK___3 = 3208,
	KEYOUT1_MARK___3 = 3209,
	KEYOUT2_MARK___3 = 3210,
	KEYOUT3_MARK___3 = 3211,
	KEYOUT4_MARK___3 = 3212,
	KEYOUT5_MARK___3 = 3213,
	KEYOUT6_MARK___2 = 3214,
	KEYOUT7_MARK___2 = 3215,
	KEYIN0_PORT43_MARK = 3216,
	KEYIN1_PORT44_MARK = 3217,
	KEYIN2_PORT45_MARK = 3218,
	KEYIN3_PORT46_MARK = 3219,
	KEYIN0_PORT58_MARK = 3220,
	KEYIN1_PORT57_MARK = 3221,
	KEYIN2_PORT56_MARK = 3222,
	KEYIN3_PORT55_MARK = 3223,
	DV_D0_MARK = 3224,
	DV_D1_MARK = 3225,
	DV_D2_MARK = 3226,
	DV_D3_MARK = 3227,
	DV_D4_MARK = 3228,
	DV_D5_MARK = 3229,
	DV_D6_MARK = 3230,
	DV_D7_MARK = 3231,
	DV_D8_MARK = 3232,
	DV_D9_MARK = 3233,
	DV_D10_MARK = 3234,
	DV_D11_MARK = 3235,
	DV_D12_MARK = 3236,
	DV_D13_MARK = 3237,
	DV_D14_MARK = 3238,
	DV_D15_MARK = 3239,
	DV_CLK_MARK = 3240,
	DV_VSYNC_MARK = 3241,
	DV_HSYNC_MARK = 3242,
	MEMC_AD0_MARK = 3243,
	MEMC_AD1_MARK = 3244,
	MEMC_AD2_MARK = 3245,
	MEMC_AD3_MARK = 3246,
	MEMC_AD4_MARK = 3247,
	MEMC_AD5_MARK = 3248,
	MEMC_AD6_MARK = 3249,
	MEMC_AD7_MARK = 3250,
	MEMC_AD8_MARK = 3251,
	MEMC_AD9_MARK = 3252,
	MEMC_AD10_MARK = 3253,
	MEMC_AD11_MARK = 3254,
	MEMC_AD12_MARK = 3255,
	MEMC_AD13_MARK = 3256,
	MEMC_AD14_MARK = 3257,
	MEMC_AD15_MARK = 3258,
	MEMC_CS0_MARK = 3259,
	MEMC_INT_MARK = 3260,
	MEMC_NWE_MARK = 3261,
	MEMC_NOE_MARK = 3262,
	MEMC_CS1_MARK = 3263,
	MEMC_ADV_MARK = 3264,
	MEMC_WAIT_MARK = 3265,
	MEMC_BUSCLK_MARK = 3266,
	MEMC_A1_MARK = 3267,
	MEMC_DREQ0_MARK = 3268,
	MEMC_DREQ1_MARK = 3269,
	MEMC_A0_MARK = 3270,
	MMC0_D0_PORT68_MARK = 3271,
	MMC0_D1_PORT69_MARK = 3272,
	MMC0_D2_PORT70_MARK = 3273,
	MMC0_D3_PORT71_MARK = 3274,
	MMC0_D4_PORT72_MARK = 3275,
	MMC0_D5_PORT73_MARK = 3276,
	MMC0_D6_PORT74_MARK = 3277,
	MMC0_D7_PORT75_MARK = 3278,
	MMC0_CLK_PORT66_MARK = 3279,
	MMC0_CMD_PORT67_MARK = 3280,
	MMC1_D0_PORT149_MARK = 3281,
	MMC1_D1_PORT148_MARK = 3282,
	MMC1_D2_PORT147_MARK = 3283,
	MMC1_D3_PORT146_MARK = 3284,
	MMC1_D4_PORT145_MARK = 3285,
	MMC1_D5_PORT144_MARK = 3286,
	MMC1_D6_PORT143_MARK = 3287,
	MMC1_D7_PORT142_MARK = 3288,
	MMC1_CLK_PORT103_MARK = 3289,
	MMC1_CMD_PORT104_MARK = 3290,
	MSIOF0_SS1_MARK___5 = 3291,
	MSIOF0_SS2_MARK___5 = 3292,
	MSIOF0_RXD_MARK___5 = 3293,
	MSIOF0_TXD_MARK___5 = 3294,
	MSIOF0_MCK0_MARK___2 = 3295,
	MSIOF0_MCK1_MARK___2 = 3296,
	MSIOF0_RSYNC_MARK___2 = 3297,
	MSIOF0_RSCK_MARK___2 = 3298,
	MSIOF0_TSCK_MARK___2 = 3299,
	MSIOF0_TSYNC_MARK___2 = 3300,
	MSIOF1_RSCK_MARK___2 = 3301,
	MSIOF1_RSYNC_MARK___2 = 3302,
	MSIOF1_MCK0_MARK___2 = 3303,
	MSIOF1_MCK1_MARK___2 = 3304,
	MSIOF1_SS2_PORT116_MARK = 3305,
	MSIOF1_SS1_PORT117_MARK = 3306,
	MSIOF1_RXD_PORT118_MARK = 3307,
	MSIOF1_TXD_PORT119_MARK = 3308,
	MSIOF1_TSYNC_PORT120_MARK = 3309,
	MSIOF1_TSCK_PORT121_MARK = 3310,
	MSIOF1_SS1_PORT67_MARK = 3311,
	MSIOF1_TSCK_PORT72_MARK = 3312,
	MSIOF1_TSYNC_PORT73_MARK = 3313,
	MSIOF1_TXD_PORT74_MARK = 3314,
	MSIOF1_RXD_PORT75_MARK = 3315,
	MSIOF1_SS2_PORT202_MARK = 3316,
	GPO0_MARK___2 = 3317,
	GPI0_MARK___2 = 3318,
	GPO1_MARK___2 = 3319,
	GPI1_MARK___2 = 3320,
	USB0_OCI_MARK = 3321,
	USB0_PPON_MARK = 3322,
	VBUS_MARK = 3323,
	USB1_OCI_MARK = 3324,
	USB1_PPON_MARK = 3325,
	BBIF1_RXD_MARK___2 = 3326,
	BBIF1_TXD_MARK___2 = 3327,
	BBIF1_TSYNC_MARK___2 = 3328,
	BBIF1_TSCK_MARK___2 = 3329,
	BBIF1_RSCK_MARK___2 = 3330,
	BBIF1_RSYNC_MARK___2 = 3331,
	BBIF1_FLOW_MARK___2 = 3332,
	BBIF1_RX_FLOW_N_MARK = 3333,
	BBIF2_TXD2_PORT5_MARK = 3334,
	BBIF2_RXD2_PORT60_MARK = 3335,
	BBIF2_TSYNC2_PORT6_MARK = 3336,
	BBIF2_TSCK2_PORT59_MARK = 3337,
	BBIF2_RXD2_PORT90_MARK = 3338,
	BBIF2_TXD2_PORT183_MARK = 3339,
	BBIF2_TSCK2_PORT89_MARK = 3340,
	BBIF2_TSYNC2_PORT184_MARK = 3341,
	CS0_MARK___2 = 3342,
	CS2_MARK = 3343,
	CS4_MARK = 3344,
	CS5B_MARK = 3345,
	CS6A_MARK = 3346,
	CS5A_PORT105_MARK = 3347,
	CS5A_PORT19_MARK = 3348,
	IOIS16_MARK = 3349,
	A0_MARK___6 = 3350,
	A1_MARK___4 = 3351,
	A2_MARK___4 = 3352,
	A3_MARK___4 = 3353,
	A4_FOE_MARK = 3354,
	A5_FCDE_MARK = 3355,
	A6_MARK___4 = 3356,
	A7_MARK___4 = 3357,
	A8_MARK___4 = 3358,
	A9_MARK___4 = 3359,
	A10_MARK___4 = 3360,
	A11_MARK___4 = 3361,
	A12_MARK___4 = 3362,
	A13_MARK___4 = 3363,
	A14_MARK___4 = 3364,
	A15_MARK___4 = 3365,
	A16_MARK___4 = 3366,
	A17_MARK___5 = 3367,
	A18_MARK___5 = 3368,
	A19_MARK___5 = 3369,
	A20_MARK___5 = 3370,
	A21_MARK___5 = 3371,
	A22_MARK___5 = 3372,
	A23_MARK___5 = 3373,
	A24_MARK___5 = 3374,
	A25_MARK___5 = 3375,
	A26_MARK___2 = 3376,
	D0_NAF0_MARK___2 = 3377,
	D1_NAF1_MARK___2 = 3378,
	D2_NAF2_MARK___2 = 3379,
	D3_NAF3_MARK___2 = 3380,
	D4_NAF4_MARK___2 = 3381,
	D5_NAF5_MARK___2 = 3382,
	D6_NAF6_MARK___2 = 3383,
	D7_NAF7_MARK___2 = 3384,
	D8_NAF8_MARK___2 = 3385,
	D9_NAF9_MARK___2 = 3386,
	D10_NAF10_MARK___2 = 3387,
	D11_NAF11_MARK___2 = 3388,
	D12_NAF12_MARK___2 = 3389,
	D13_NAF13_MARK___2 = 3390,
	D14_NAF14_MARK___2 = 3391,
	D15_NAF15_MARK___2 = 3392,
	D16_MARK___2 = 3393,
	D17_MARK___2 = 3394,
	D18_MARK___2 = 3395,
	D19_MARK___2 = 3396,
	D20_MARK___2 = 3397,
	D21_MARK___2 = 3398,
	D22_MARK___2 = 3399,
	D23_MARK___2 = 3400,
	D24_MARK___2 = 3401,
	D25_MARK___2 = 3402,
	D26_MARK___2 = 3403,
	D27_MARK___2 = 3404,
	D28_MARK___2 = 3405,
	D29_MARK___2 = 3406,
	D30_MARK___2 = 3407,
	D31_MARK___2 = 3408,
	WE0_FWE_MARK = 3409,
	WE1_MARK = 3410,
	WE2_ICIORD_MARK = 3411,
	WE3_ICIOWR_MARK = 3412,
	CKO_MARK___3 = 3413,
	BS_MARK___3 = 3414,
	RDWR_MARK = 3415,
	RD_FSC_MARK = 3416,
	WAIT_PORT177_MARK = 3417,
	WAIT_PORT90_MARK = 3418,
	FCE0_MARK = 3419,
	FCE1_MARK = 3420,
	FRB_MARK___3 = 3421,
	IRDA_FIRSEL_MARK___2 = 3422,
	IRDA_IN_MARK___2 = 3423,
	IRDA_OUT_MARK___2 = 3424,
	IDE_D0_MARK = 3425,
	IDE_D1_MARK = 3426,
	IDE_D2_MARK = 3427,
	IDE_D3_MARK = 3428,
	IDE_D4_MARK = 3429,
	IDE_D5_MARK = 3430,
	IDE_D6_MARK = 3431,
	IDE_D7_MARK = 3432,
	IDE_D8_MARK = 3433,
	IDE_D9_MARK = 3434,
	IDE_D10_MARK = 3435,
	IDE_D11_MARK = 3436,
	IDE_D12_MARK = 3437,
	IDE_D13_MARK = 3438,
	IDE_D14_MARK = 3439,
	IDE_D15_MARK = 3440,
	IDE_A0_MARK = 3441,
	IDE_A1_MARK = 3442,
	IDE_A2_MARK = 3443,
	IDE_CS0_MARK = 3444,
	IDE_CS1_MARK = 3445,
	IDE_IOWR_MARK = 3446,
	IDE_IORD_MARK = 3447,
	IDE_IORDY_MARK = 3448,
	IDE_INT_MARK = 3449,
	IDE_RST_MARK = 3450,
	IDE_DIRECTION_MARK = 3451,
	IDE_EXBUF_ENB_MARK = 3452,
	IDE_IODACK_MARK = 3453,
	IDE_IODREQ_MARK = 3454,
	RMII_CRS_DV_MARK = 3455,
	RMII_RX_ER_MARK = 3456,
	RMII_RXD0_MARK = 3457,
	RMII_RXD1_MARK = 3458,
	RMII_TX_EN_MARK = 3459,
	RMII_TXD0_MARK = 3460,
	RMII_MDC_MARK = 3461,
	RMII_TXD1_MARK = 3462,
	RMII_MDIO_MARK = 3463,
	RMII_REF50CK_MARK = 3464,
	RMII_REF125CK_MARK = 3465,
	ET_TX_CLK_MARK = 3466,
	ET_TX_EN_MARK = 3467,
	ET_ETXD0_MARK = 3468,
	ET_ETXD1_MARK = 3469,
	ET_ETXD2_MARK = 3470,
	ET_ETXD3_MARK = 3471,
	ET_ETXD4_MARK = 3472,
	ET_ETXD5_MARK = 3473,
	ET_ETXD6_MARK = 3474,
	ET_ETXD7_MARK = 3475,
	ET_COL_MARK = 3476,
	ET_TX_ER_MARK = 3477,
	ET_RX_CLK_MARK = 3478,
	ET_RX_DV_MARK = 3479,
	ET_ERXD0_MARK = 3480,
	ET_ERXD1_MARK = 3481,
	ET_ERXD2_MARK = 3482,
	ET_ERXD3_MARK = 3483,
	ET_ERXD4_MARK = 3484,
	ET_ERXD5_MARK = 3485,
	ET_ERXD6_MARK = 3486,
	ET_ERXD7_MARK = 3487,
	ET_RX_ER_MARK = 3488,
	ET_CRS_MARK = 3489,
	ET_MDC_MARK = 3490,
	ET_MDIO_MARK = 3491,
	ET_LINK_MARK = 3492,
	ET_PHY_INT_MARK = 3493,
	ET_WOL_MARK = 3494,
	ET_GTX_CLK_MARK = 3495,
	DREQ0_MARK___4 = 3496,
	DACK0_MARK___5 = 3497,
	DREQ1_MARK___4 = 3498,
	DACK1_MARK___5 = 3499,
	RESETOUTS_MARK = 3500,
	RESETP_PULLUP_MARK = 3501,
	RESETP_PLAIN_MARK = 3502,
	IROUT_MARK = 3503,
	SDENC_CPG_MARK = 3504,
	SDENC_DV_CLKI_MARK = 3505,
	HDMI_HPD_MARK = 3506,
	HDMI_CEC_MARK = 3507,
	EDEBGREQ_PULLUP_MARK = 3508,
	EDEBGREQ_PULLDOWN_MARK = 3509,
	TRACEAUD_FROM_VIO_MARK = 3510,
	TRACEAUD_FROM_LCDC0_MARK = 3511,
	TRACEAUD_FROM_MEMC_MARK = 3512,
	PINMUX_MARK_END___6 = 3513,
};

enum {
	PINMUX_RESERVED___7 = 0,
	PINMUX_DATA_BEGIN___7 = 1,
	GP_0_0_DATA___4 = 2,
	GP_0_1_DATA___4 = 3,
	GP_0_2_DATA___4 = 4,
	GP_0_3_DATA___4 = 5,
	GP_0_4_DATA___4 = 6,
	GP_0_5_DATA___4 = 7,
	GP_0_6_DATA___4 = 8,
	GP_0_7_DATA___4 = 9,
	GP_0_8_DATA___4 = 10,
	GP_0_9_DATA___4 = 11,
	GP_0_10_DATA___4 = 12,
	GP_0_11_DATA___4 = 13,
	GP_0_12_DATA___4 = 14,
	GP_0_13_DATA___4 = 15,
	GP_0_14_DATA___4 = 16,
	GP_0_15_DATA___4 = 17,
	GP_0_16_DATA___4 = 18,
	GP_0_17_DATA___4 = 19,
	GP_0_18_DATA___4 = 20,
	GP_0_19_DATA___4 = 21,
	GP_0_20_DATA___4 = 22,
	GP_0_21_DATA___4 = 23,
	GP_0_22_DATA___4 = 24,
	GP_1_0_DATA___4 = 25,
	GP_1_1_DATA___4 = 26,
	GP_1_2_DATA___4 = 27,
	GP_1_3_DATA___4 = 28,
	GP_1_4_DATA___4 = 29,
	GP_1_5_DATA___4 = 30,
	GP_1_6_DATA___4 = 31,
	GP_1_7_DATA___4 = 32,
	GP_1_8_DATA___4 = 33,
	GP_1_9_DATA___4 = 34,
	GP_1_10_DATA___4 = 35,
	GP_1_11_DATA___4 = 36,
	GP_1_12_DATA___4 = 37,
	GP_1_13_DATA___4 = 38,
	GP_1_14_DATA___4 = 39,
	GP_1_15_DATA___4 = 40,
	GP_1_16_DATA___4 = 41,
	GP_1_17_DATA___4 = 42,
	GP_1_18_DATA___4 = 43,
	GP_1_19_DATA___4 = 44,
	GP_1_20_DATA___4 = 45,
	GP_1_21_DATA___4 = 46,
	GP_1_22_DATA___4 = 47,
	GP_2_0_DATA___4 = 48,
	GP_2_1_DATA___4 = 49,
	GP_2_2_DATA___4 = 50,
	GP_2_3_DATA___4 = 51,
	GP_2_4_DATA___4 = 52,
	GP_2_5_DATA___4 = 53,
	GP_2_6_DATA___4 = 54,
	GP_2_7_DATA___4 = 55,
	GP_2_8_DATA___4 = 56,
	GP_2_9_DATA___4 = 57,
	GP_2_10_DATA___4 = 58,
	GP_2_11_DATA___4 = 59,
	GP_2_12_DATA___4 = 60,
	GP_2_13_DATA___4 = 61,
	GP_2_14_DATA___4 = 62,
	GP_2_15_DATA___4 = 63,
	GP_2_16_DATA___4 = 64,
	GP_2_17_DATA___4 = 65,
	GP_2_18_DATA___4 = 66,
	GP_2_19_DATA___4 = 67,
	GP_2_20_DATA___4 = 68,
	GP_2_21_DATA___4 = 69,
	GP_2_22_DATA___4 = 70,
	GP_2_23_DATA___4 = 71,
	GP_2_24_DATA___4 = 72,
	GP_2_25_DATA___4 = 73,
	GP_2_26_DATA___4 = 74,
	GP_2_27_DATA___4 = 75,
	GP_2_28_DATA___4 = 76,
	GP_2_29_DATA___4 = 77,
	GP_2_30_DATA___4 = 78,
	GP_2_31_DATA___4 = 79,
	GP_3_0_DATA___4 = 80,
	GP_3_1_DATA___4 = 81,
	GP_3_2_DATA___4 = 82,
	GP_3_3_DATA___4 = 83,
	GP_3_4_DATA___4 = 84,
	GP_3_5_DATA___4 = 85,
	GP_3_6_DATA___4 = 86,
	GP_3_7_DATA___4 = 87,
	GP_3_8_DATA___4 = 88,
	GP_3_9_DATA___4 = 89,
	GP_3_10_DATA___4 = 90,
	GP_3_11_DATA___4 = 91,
	GP_3_12_DATA___4 = 92,
	GP_3_13_DATA___4 = 93,
	GP_3_14_DATA___4 = 94,
	GP_3_15_DATA___4 = 95,
	GP_3_16_DATA___4 = 96,
	GP_3_27_DATA___4 = 97,
	GP_3_28_DATA___4 = 98,
	GP_3_29_DATA___4 = 99,
	GP_4_0_DATA___4 = 100,
	GP_4_1_DATA___4 = 101,
	GP_4_2_DATA___4 = 102,
	GP_4_3_DATA___4 = 103,
	GP_4_4_DATA___4 = 104,
	GP_4_5_DATA___4 = 105,
	GP_4_6_DATA___4 = 106,
	GP_4_7_DATA___4 = 107,
	GP_4_8_DATA___4 = 108,
	GP_4_9_DATA___4 = 109,
	GP_4_10_DATA___4 = 110,
	GP_4_11_DATA___4 = 111,
	GP_4_12_DATA___4 = 112,
	GP_4_13_DATA___4 = 113,
	GP_4_14_DATA___4 = 114,
	GP_4_15_DATA___4 = 115,
	GP_4_16_DATA___4 = 116,
	GP_4_17_DATA___4 = 117,
	GP_4_18_DATA___4 = 118,
	GP_4_19_DATA___4 = 119,
	GP_4_20_DATA___4 = 120,
	GP_4_21_DATA___4 = 121,
	GP_4_22_DATA___4 = 122,
	GP_4_23_DATA___4 = 123,
	GP_4_24_DATA___4 = 124,
	GP_4_25_DATA___4 = 125,
	GP_5_0_DATA___4 = 126,
	GP_5_1_DATA___4 = 127,
	GP_5_2_DATA___4 = 128,
	GP_5_3_DATA___4 = 129,
	GP_5_4_DATA___4 = 130,
	GP_5_5_DATA___4 = 131,
	GP_5_6_DATA___4 = 132,
	GP_5_7_DATA___4 = 133,
	GP_5_8_DATA___4 = 134,
	GP_5_9_DATA___4 = 135,
	GP_5_10_DATA___4 = 136,
	GP_5_11_DATA___4 = 137,
	GP_5_12_DATA___4 = 138,
	GP_5_13_DATA___4 = 139,
	GP_5_14_DATA___4 = 140,
	GP_5_15_DATA___4 = 141,
	GP_5_16_DATA___4 = 142,
	GP_5_17_DATA___4 = 143,
	GP_5_18_DATA___4 = 144,
	GP_5_19_DATA___4 = 145,
	GP_5_20_DATA___4 = 146,
	GP_5_21_DATA___4 = 147,
	GP_5_22_DATA___4 = 148,
	GP_5_23_DATA___4 = 149,
	GP_5_24_DATA___4 = 150,
	GP_5_25_DATA___4 = 151,
	GP_5_26_DATA___4 = 152,
	GP_5_27_DATA___4 = 153,
	GP_5_28_DATA___3 = 154,
	GP_5_29_DATA___3 = 155,
	GP_5_30_DATA___3 = 156,
	GP_5_31_DATA___3 = 157,
	PINMUX_DATA_END___7 = 158,
	PINMUX_FUNCTION_BEGIN___7 = 159,
	GP_0_0_FN___4 = 160,
	GP_0_1_FN___4 = 161,
	GP_0_2_FN___4 = 162,
	GP_0_3_FN___4 = 163,
	GP_0_4_FN___4 = 164,
	GP_0_5_FN___4 = 165,
	GP_0_6_FN___4 = 166,
	GP_0_7_FN___4 = 167,
	GP_0_8_FN___4 = 168,
	GP_0_9_FN___4 = 169,
	GP_0_10_FN___4 = 170,
	GP_0_11_FN___4 = 171,
	GP_0_12_FN___4 = 172,
	GP_0_13_FN___4 = 173,
	GP_0_14_FN___4 = 174,
	GP_0_15_FN___4 = 175,
	GP_0_16_FN___4 = 176,
	GP_0_17_FN___4 = 177,
	GP_0_18_FN___4 = 178,
	GP_0_19_FN___4 = 179,
	GP_0_20_FN___4 = 180,
	GP_0_21_FN___4 = 181,
	GP_0_22_FN___4 = 182,
	GP_1_0_FN___4 = 183,
	GP_1_1_FN___4 = 184,
	GP_1_2_FN___4 = 185,
	GP_1_3_FN___4 = 186,
	GP_1_4_FN___4 = 187,
	GP_1_5_FN___4 = 188,
	GP_1_6_FN___4 = 189,
	GP_1_7_FN___4 = 190,
	GP_1_8_FN___4 = 191,
	GP_1_9_FN___4 = 192,
	GP_1_10_FN___4 = 193,
	GP_1_11_FN___4 = 194,
	GP_1_12_FN___4 = 195,
	GP_1_13_FN___4 = 196,
	GP_1_14_FN___4 = 197,
	GP_1_15_FN___4 = 198,
	GP_1_16_FN___4 = 199,
	GP_1_17_FN___4 = 200,
	GP_1_18_FN___4 = 201,
	GP_1_19_FN___4 = 202,
	GP_1_20_FN___4 = 203,
	GP_1_21_FN___4 = 204,
	GP_1_22_FN___4 = 205,
	GP_2_0_FN___4 = 206,
	GP_2_1_FN___4 = 207,
	GP_2_2_FN___4 = 208,
	GP_2_3_FN___4 = 209,
	GP_2_4_FN___4 = 210,
	GP_2_5_FN___4 = 211,
	GP_2_6_FN___4 = 212,
	GP_2_7_FN___4 = 213,
	GP_2_8_FN___4 = 214,
	GP_2_9_FN___4 = 215,
	GP_2_10_FN___4 = 216,
	GP_2_11_FN___4 = 217,
	GP_2_12_FN___4 = 218,
	GP_2_13_FN___4 = 219,
	GP_2_14_FN___4 = 220,
	GP_2_15_FN___4 = 221,
	GP_2_16_FN___4 = 222,
	GP_2_17_FN___4 = 223,
	GP_2_18_FN___4 = 224,
	GP_2_19_FN___4 = 225,
	GP_2_20_FN___4 = 226,
	GP_2_21_FN___4 = 227,
	GP_2_22_FN___4 = 228,
	GP_2_23_FN___4 = 229,
	GP_2_24_FN___4 = 230,
	GP_2_25_FN___4 = 231,
	GP_2_26_FN___4 = 232,
	GP_2_27_FN___4 = 233,
	GP_2_28_FN___4 = 234,
	GP_2_29_FN___4 = 235,
	GP_2_30_FN___4 = 236,
	GP_2_31_FN___4 = 237,
	GP_3_0_FN___4 = 238,
	GP_3_1_FN___4 = 239,
	GP_3_2_FN___4 = 240,
	GP_3_3_FN___4 = 241,
	GP_3_4_FN___4 = 242,
	GP_3_5_FN___4 = 243,
	GP_3_6_FN___4 = 244,
	GP_3_7_FN___4 = 245,
	GP_3_8_FN___4 = 246,
	GP_3_9_FN___4 = 247,
	GP_3_10_FN___4 = 248,
	GP_3_11_FN___4 = 249,
	GP_3_12_FN___4 = 250,
	GP_3_13_FN___4 = 251,
	GP_3_14_FN___4 = 252,
	GP_3_15_FN___4 = 253,
	GP_3_16_FN___4 = 254,
	GP_3_27_FN___4 = 255,
	GP_3_28_FN___4 = 256,
	GP_3_29_FN___4 = 257,
	GP_4_0_FN___4 = 258,
	GP_4_1_FN___4 = 259,
	GP_4_2_FN___4 = 260,
	GP_4_3_FN___4 = 261,
	GP_4_4_FN___4 = 262,
	GP_4_5_FN___4 = 263,
	GP_4_6_FN___4 = 264,
	GP_4_7_FN___4 = 265,
	GP_4_8_FN___4 = 266,
	GP_4_9_FN___4 = 267,
	GP_4_10_FN___4 = 268,
	GP_4_11_FN___4 = 269,
	GP_4_12_FN___4 = 270,
	GP_4_13_FN___4 = 271,
	GP_4_14_FN___4 = 272,
	GP_4_15_FN___4 = 273,
	GP_4_16_FN___4 = 274,
	GP_4_17_FN___4 = 275,
	GP_4_18_FN___4 = 276,
	GP_4_19_FN___4 = 277,
	GP_4_20_FN___4 = 278,
	GP_4_21_FN___4 = 279,
	GP_4_22_FN___4 = 280,
	GP_4_23_FN___4 = 281,
	GP_4_24_FN___4 = 282,
	GP_4_25_FN___4 = 283,
	GP_5_0_FN___4 = 284,
	GP_5_1_FN___4 = 285,
	GP_5_2_FN___4 = 286,
	GP_5_3_FN___4 = 287,
	GP_5_4_FN___4 = 288,
	GP_5_5_FN___4 = 289,
	GP_5_6_FN___4 = 290,
	GP_5_7_FN___4 = 291,
	GP_5_8_FN___4 = 292,
	GP_5_9_FN___4 = 293,
	GP_5_10_FN___4 = 294,
	GP_5_11_FN___4 = 295,
	GP_5_12_FN___4 = 296,
	GP_5_13_FN___4 = 297,
	GP_5_14_FN___4 = 298,
	GP_5_15_FN___4 = 299,
	GP_5_16_FN___4 = 300,
	GP_5_17_FN___4 = 301,
	GP_5_18_FN___4 = 302,
	GP_5_19_FN___4 = 303,
	GP_5_20_FN___4 = 304,
	GP_5_21_FN___4 = 305,
	GP_5_22_FN___4 = 306,
	GP_5_23_FN___4 = 307,
	GP_5_24_FN___4 = 308,
	GP_5_25_FN___4 = 309,
	GP_5_26_FN___4 = 310,
	GP_5_27_FN___4 = 311,
	GP_5_28_FN___3 = 312,
	GP_5_29_FN___3 = 313,
	GP_5_30_FN___3 = 314,
	GP_5_31_FN___3 = 315,
	FN_USB0_PWEN___3 = 316,
	FN_USB0_OVC___3 = 317,
	FN_USB1_PWEN___3 = 318,
	FN_USB1_OVC___3 = 319,
	FN_CLKOUT___2 = 320,
	FN_IP0_3_0 = 321,
	FN_IP0_7_4 = 322,
	FN_IP0_11_8 = 323,
	FN_IP0_15_12 = 324,
	FN_IP0_19_16 = 325,
	FN_IP0_23_20 = 326,
	FN_IP0_27_24 = 327,
	FN_IP0_31_28 = 328,
	FN_MMC0_CLK_SDHI1_CLK = 329,
	FN_MMC0_CMD_SDHI1_CMD = 330,
	FN_MMC0_D0_SDHI1_D0 = 331,
	FN_MMC0_D1_SDHI1_D1 = 332,
	FN_MMC0_D2_SDHI1_D2 = 333,
	FN_MMC0_D3_SDHI1_D3 = 334,
	FN_IP1_3_0 = 335,
	FN_IP1_7_4 = 336,
	FN_MMC0_D6___2 = 337,
	FN_MMC0_D7___2 = 338,
	FN_IP1_11_8 = 339,
	FN_IP1_15_12 = 340,
	FN_IP1_19_16 = 341,
	FN_IP1_23_20 = 342,
	FN_IP1_27_24 = 343,
	FN_IP1_31_28 = 344,
	FN_IP2_3_0___2 = 345,
	FN_IP2_7_4___2 = 346,
	FN_IP2_11_8___2 = 347,
	FN_IP2_15_12___2 = 348,
	FN_IP2_19_16 = 349,
	FN_IP2_23_20 = 350,
	FN_IP2_27_24 = 351,
	FN_IP2_31_28 = 352,
	FN_IP3_3_0 = 353,
	FN_IP3_7_4 = 354,
	FN_IP3_11_8 = 355,
	FN_IP3_15_12 = 356,
	FN_IP3_19_16 = 357,
	FN_IP3_23_20 = 358,
	FN_IP3_27_24 = 359,
	FN_IP3_31_28 = 360,
	FN_IP4_3_0 = 361,
	FN_IP4_7_4 = 362,
	FN_IP4_11_8 = 363,
	FN_IP4_15_12 = 364,
	FN_IP4_19_16 = 365,
	FN_IP4_23_20 = 366,
	FN_IP4_27_24 = 367,
	FN_IP4_31_28 = 368,
	FN_IP5_3_0 = 369,
	FN_IP5_7_4 = 370,
	FN_IP5_11_8 = 371,
	FN_IP5_15_12 = 372,
	FN_IP5_19_16 = 373,
	FN_IP5_23_20 = 374,
	FN_IP5_27_24___2 = 375,
	FN_IP5_31_28 = 376,
	FN_IP6_3_0 = 377,
	FN_IP6_7_4 = 378,
	FN_IP6_11_8 = 379,
	FN_IP6_15_12 = 380,
	FN_IP6_19_16 = 381,
	FN_IP6_23_20 = 382,
	FN_IP6_27_24 = 383,
	FN_IP6_31_28 = 384,
	FN_IP7_3_0 = 385,
	FN_IP7_7_4 = 386,
	FN_IP7_11_8 = 387,
	FN_IP7_15_12 = 388,
	FN_IP7_19_16 = 389,
	FN_IP7_23_20 = 390,
	FN_IP7_27_24 = 391,
	FN_IP7_31_28 = 392,
	FN_IP8_3_0___2 = 393,
	FN_IP8_7_4___2 = 394,
	FN_IP8_11_8___2 = 395,
	FN_IP8_15_12___2 = 396,
	FN_IP8_19_16 = 397,
	FN_IP8_23_20 = 398,
	FN_IP8_27_24 = 399,
	FN_IP8_31_28 = 400,
	FN_IP9_3_0 = 401,
	FN_IP9_7_4 = 402,
	FN_IP9_11_8 = 403,
	FN_IP9_15_12 = 404,
	FN_IP9_19_16 = 405,
	FN_IP9_23_20 = 406,
	FN_IP9_27_24 = 407,
	FN_IP9_31_28 = 408,
	FN_IP10_3_0 = 409,
	FN_IP10_7_4 = 410,
	FN_IP10_11_8 = 411,
	FN_IP10_15_12 = 412,
	FN_IP10_19_16 = 413,
	FN_IP10_23_20 = 414,
	FN_IP10_27_24 = 415,
	FN_IP10_31_28 = 416,
	FN_IP11_3_0 = 417,
	FN_IP11_7_4 = 418,
	FN_IP11_11_8 = 419,
	FN_IP11_15_12 = 420,
	FN_IP11_19_16 = 421,
	FN_IP11_23_20 = 422,
	FN_IP11_27_24 = 423,
	FN_IP11_31_28 = 424,
	FN_IP12_3_0 = 425,
	FN_IP12_7_4 = 426,
	FN_IP12_11_8 = 427,
	FN_IP12_15_12 = 428,
	FN_IP12_19_16 = 429,
	FN_IP12_23_20 = 430,
	FN_IP12_27_24 = 431,
	FN_IP12_31_28 = 432,
	FN_IP13_3_0 = 433,
	FN_IP13_7_4 = 434,
	FN_IP13_11_8 = 435,
	FN_IP13_15_12 = 436,
	FN_IP13_19_16 = 437,
	FN_IP13_23_20 = 438,
	FN_IP13_27_24 = 439,
	FN_IP13_31_28 = 440,
	FN_IP14_3_0 = 441,
	FN_IP14_7_4 = 442,
	FN_IP14_11_8 = 443,
	FN_IP14_15_12 = 444,
	FN_IP14_19_16 = 445,
	FN_IP14_23_20 = 446,
	FN_IP14_27_24 = 447,
	FN_IP14_31_28 = 448,
	FN_IP15_3_0 = 449,
	FN_IP15_7_4 = 450,
	FN_IP15_11_8 = 451,
	FN_IP15_15_12 = 452,
	FN_IP15_19_16 = 453,
	FN_IP15_23_20 = 454,
	FN_IP15_27_24 = 455,
	FN_IP15_31_28 = 456,
	FN_IP16_3_0 = 457,
	FN_IP16_7_4 = 458,
	FN_IP16_11_8 = 459,
	FN_IP16_15_12 = 460,
	FN_IP16_19_16 = 461,
	FN_IP16_23_20 = 462,
	FN_IP16_27_24 = 463,
	FN_IP16_31_28 = 464,
	FN_IP17_3_0 = 465,
	FN_IP17_7_4 = 466,
	FN_IP17_11_8 = 467,
	FN_IP17_15_12 = 468,
	FN_IP17_19_16 = 469,
	FN_IP17_23_20 = 470,
	FN_IP17_27_24 = 471,
	FN_SD0_CLK___4 = 472,
	FN_SSI_SCK1_C = 473,
	FN_RX3_C___2 = 474,
	FN_SD0_CMD___4 = 475,
	FN_SSI_WS1_C = 476,
	FN_TX3_C___2 = 477,
	FN_SD0_DAT0___2 = 478,
	FN_SSI_SDATA1_C = 479,
	FN_RX4_E = 480,
	FN_SD0_DAT1___2 = 481,
	FN_SSI_SCK0129_B___2 = 482,
	FN_TX4_E = 483,
	FN_SD0_DAT2___2 = 484,
	FN_SSI_WS0129_B___2 = 485,
	FN_RX5_E = 486,
	FN_SD0_DAT3___2 = 487,
	FN_SSI_SDATA0_B___2 = 488,
	FN_TX5_E = 489,
	FN_SD0_CD___4 = 490,
	FN_CAN0_RX_A = 491,
	FN_SD0_WP___4 = 492,
	FN_IRQ7___3 = 493,
	FN_CAN0_TX_A = 494,
	FN_MMC0_D4___2 = 495,
	FN_SD1_CD___4 = 496,
	FN_MMC0_D5___2 = 497,
	FN_SD1_WP___4 = 498,
	FN_D0___3 = 499,
	FN_SCL3_B___2 = 500,
	FN_RX5_B___3 = 501,
	FN_IRQ4___3 = 502,
	FN_MSIOF2_RXD_C___2 = 503,
	FN_SSI_SDATA5_B___2 = 504,
	FN_D1___3 = 505,
	FN_SDA3_B___2 = 506,
	FN_TX5_B___3 = 507,
	FN_MSIOF2_TXD_C___2 = 508,
	FN_SSI_WS5_B___2 = 509,
	FN_D2___3 = 510,
	FN_RX4_B___3 = 511,
	FN_SCL0_D = 512,
	FN_PWM1_C___2 = 513,
	FN_MSIOF2_SCK_C___2 = 514,
	FN_SSI_SCK5_B___2 = 515,
	FN_D3___3 = 516,
	FN_TX4_B___3 = 517,
	FN_SDA0_D = 518,
	FN_PWM0_A = 519,
	FN_MSIOF2_SYNC_C___2 = 520,
	FN_D4___3 = 521,
	FN_IRQ3___4 = 522,
	FN_TCLK1_A = 523,
	FN_PWM6_C = 524,
	FN_D5___3 = 525,
	FN_HRX2___2 = 526,
	FN_SCL1_B___2 = 527,
	FN_PWM2_C___2 = 528,
	FN_TCLK2_B___2 = 529,
	FN_D6___3 = 530,
	FN_HTX2___2 = 531,
	FN_SDA1_B___2 = 532,
	FN_PWM4_C = 533,
	FN_D7___3 = 534,
	FN_HSCK2___2 = 535,
	FN_SCIF1_SCK_C___2 = 536,
	FN_IRQ6___3 = 537,
	FN_PWM5_C___2 = 538,
	FN_D8___3 = 539,
	FN_HCTS2_N___2 = 540,
	FN_RX1_C___3 = 541,
	FN_SCL1_D___2 = 542,
	FN_PWM3_C = 543,
	FN_D9___3 = 544,
	FN_HRTS2_N___2 = 545,
	FN_TX1_C___3 = 546,
	FN_SDA1_D___2 = 547,
	FN_D10___3 = 548,
	FN_MSIOF2_RXD_A = 549,
	FN_HRX0_B___3 = 550,
	FN_D11___3 = 551,
	FN_MSIOF2_TXD_A = 552,
	FN_HTX0_B___3 = 553,
	FN_D12___3 = 554,
	FN_MSIOF2_SCK_A = 555,
	FN_HSCK0___3 = 556,
	FN_CAN_CLK_C___4 = 557,
	FN_D13___3 = 558,
	FN_MSIOF2_SYNC_A = 559,
	FN_RX4_C___3 = 560,
	FN_D14___3 = 561,
	FN_MSIOF2_SS1___3 = 562,
	FN_TX4_C___3 = 563,
	FN_CAN1_RX_B___3 = 564,
	FN_AVB_AVTP_CAPTURE_A = 565,
	FN_D15___3 = 566,
	FN_MSIOF2_SS2___3 = 567,
	FN_PWM4_A = 568,
	FN_CAN1_TX_B___3 = 569,
	FN_IRQ2___4 = 570,
	FN_AVB_AVTP_MATCH_A = 571,
	FN_QSPI0_SPCLK = 572,
	FN_WE0_N___3 = 573,
	FN_QSPI0_MOSI_QSPI0_IO0 = 574,
	FN_BS_N___3 = 575,
	FN_QSPI0_MISO_QSPI0_IO1 = 576,
	FN_RD_WR_N___3 = 577,
	FN_QSPI0_IO2 = 578,
	FN_CS0_N___3 = 579,
	FN_QSPI0_IO3 = 580,
	FN_RD_N___3 = 581,
	FN_QSPI0_SSL = 582,
	FN_WE1_N___3 = 583,
	FN_EX_WAIT0___4 = 584,
	FN_CAN_CLK_B___4 = 585,
	FN_SCIF_CLK_A = 586,
	FN_DU0_DR0___3 = 587,
	FN_RX5_C___2 = 588,
	FN_SCL2_D___2 = 589,
	FN_A0___4 = 590,
	FN_DU0_DR1___3 = 591,
	FN_TX5_C___2 = 592,
	FN_SDA2_D___2 = 593,
	FN_A1___4 = 594,
	FN_DU0_DR2___3 = 595,
	FN_RX0_D___3 = 596,
	FN_SCL0_E = 597,
	FN_A2___4 = 598,
	FN_DU0_DR3___3 = 599,
	FN_TX0_D___3 = 600,
	FN_SDA0_E = 601,
	FN_PWM0_B___4 = 602,
	FN_A3___4 = 603,
	FN_DU0_DR4___3 = 604,
	FN_RX1_D___2 = 605,
	FN_A4___4 = 606,
	FN_DU0_DR5___3 = 607,
	FN_TX1_D___2 = 608,
	FN_PWM1_B___3 = 609,
	FN_A5___4 = 610,
	FN_DU0_DR6___3 = 611,
	FN_RX2_C___3 = 612,
	FN_A6___4 = 613,
	FN_DU0_DR7___3 = 614,
	FN_TX2_C___3 = 615,
	FN_PWM2_B___3 = 616,
	FN_A7___4 = 617,
	FN_DU0_DG0___3 = 618,
	FN_RX3_B___2 = 619,
	FN_SCL3_D = 620,
	FN_A8___4 = 621,
	FN_DU0_DG1___3 = 622,
	FN_TX3_B___2 = 623,
	FN_SDA3_D = 624,
	FN_PWM3_B___2 = 625,
	FN_A9___4 = 626,
	FN_DU0_DG2___3 = 627,
	FN_RX4_D___2 = 628,
	FN_A10___4 = 629,
	FN_DU0_DG3___3 = 630,
	FN_TX4_D___2 = 631,
	FN_PWM4_B___3 = 632,
	FN_A11___4 = 633,
	FN_DU0_DG4___3 = 634,
	FN_HRX0_A = 635,
	FN_A12___4 = 636,
	FN_DU0_DG5___3 = 637,
	FN_HTX0_A = 638,
	FN_PWM5_B___3 = 639,
	FN_A13___4 = 640,
	FN_DU0_DG6___3 = 641,
	FN_HRX1_C___2 = 642,
	FN_A14___4 = 643,
	FN_DU0_DG7___3 = 644,
	FN_HTX1_C___2 = 645,
	FN_PWM6_B___2 = 646,
	FN_A15___4 = 647,
	FN_DU0_DB0___3 = 648,
	FN_SCL4_D = 649,
	FN_CAN0_RX_C___3 = 650,
	FN_A16___4 = 651,
	FN_DU0_DB1___3 = 652,
	FN_SDA4_D = 653,
	FN_CAN0_TX_C___3 = 654,
	FN_A17___4 = 655,
	FN_DU0_DB2___3 = 656,
	FN_HCTS0_N___2 = 657,
	FN_A18___4 = 658,
	FN_DU0_DB3___3 = 659,
	FN_HRTS0_N___2 = 660,
	FN_A19___4 = 661,
	FN_DU0_DB4___3 = 662,
	FN_HCTS1_N_C___2 = 663,
	FN_A20___4 = 664,
	FN_DU0_DB5___3 = 665,
	FN_HRTS1_N_C___2 = 666,
	FN_A21___4 = 667,
	FN_DU0_DB6___3 = 668,
	FN_A22___4 = 669,
	FN_DU0_DB7___3 = 670,
	FN_A23___4 = 671,
	FN_DU0_DOTCLKIN___4 = 672,
	FN_A24___4 = 673,
	FN_DU0_DOTCLKOUT0___3 = 674,
	FN_A25___4 = 675,
	FN_DU0_DOTCLKOUT1___3 = 676,
	FN_MSIOF2_RXD_B___3 = 677,
	FN_CS1_N_A26___3 = 678,
	FN_DU0_EXHSYNC_DU0_HSYNC___3 = 679,
	FN_MSIOF2_TXD_B___3 = 680,
	FN_DREQ0_N___2 = 681,
	FN_DU0_EXVSYNC_DU0_VSYNC___3 = 682,
	FN_MSIOF2_SYNC_B___3 = 683,
	FN_DACK0___4 = 684,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE___3 = 685,
	FN_MSIOF2_SCK_B___3 = 686,
	FN_DRACK0___4 = 687,
	FN_DU0_DISP___3 = 688,
	FN_CAN1_RX_C___3 = 689,
	FN_DU0_CDE___3 = 690,
	FN_CAN1_TX_C___3 = 691,
	FN_VI1_CLK___4 = 692,
	FN_AVB_RX_CLK___3 = 693,
	FN_ETH_REF_CLK = 694,
	FN_VI1_DATA0___3 = 695,
	FN_AVB_RX_DV___3 = 696,
	FN_ETH_CRS_DV___4 = 697,
	FN_VI1_DATA1___3 = 698,
	FN_AVB_RXD0___3 = 699,
	FN_ETH_RXD0___4 = 700,
	FN_VI1_DATA2___3 = 701,
	FN_AVB_RXD1___3 = 702,
	FN_ETH_RXD1___4 = 703,
	FN_VI1_DATA3___3 = 704,
	FN_AVB_RXD2___3 = 705,
	FN_ETH_MDIO___4 = 706,
	FN_VI1_DATA4___3 = 707,
	FN_AVB_RXD3___3 = 708,
	FN_ETH_RX_ER___4 = 709,
	FN_VI1_DATA5___3 = 710,
	FN_AVB_RXD4___3 = 711,
	FN_ETH_LINK___4 = 712,
	FN_VI1_DATA6___3 = 713,
	FN_AVB_RXD5___3 = 714,
	FN_ETH_TXD1___4 = 715,
	FN_VI1_DATA7___3 = 716,
	FN_AVB_RXD6___3 = 717,
	FN_ETH_TX_EN___4 = 718,
	FN_VI1_CLKENB___4 = 719,
	FN_SCL3_A = 720,
	FN_AVB_RXD7___3 = 721,
	FN_ETH_MAGIC___4 = 722,
	FN_VI1_FIELD___4 = 723,
	FN_SDA3_A = 724,
	FN_AVB_RX_ER___3 = 725,
	FN_ETH_TXD0___4 = 726,
	FN_VI1_HSYNC_N___3 = 727,
	FN_RX0_B___3 = 728,
	FN_SCL0_C = 729,
	FN_AVB_GTXREFCLK___3 = 730,
	FN_ETH_MDC___4 = 731,
	FN_VI1_VSYNC_N___3 = 732,
	FN_TX0_B___3 = 733,
	FN_SDA0_C = 734,
	FN_AUDIO_CLKOUT_B___3 = 735,
	FN_AVB_TX_CLK___3 = 736,
	FN_VI1_DATA8___2 = 737,
	FN_SCL2_B___2 = 738,
	FN_AVB_TX_EN___3 = 739,
	FN_VI1_DATA9___2 = 740,
	FN_SDA2_B___2 = 741,
	FN_AVB_TXD0___3 = 742,
	FN_VI1_DATA10___2 = 743,
	FN_CAN0_RX_B___4 = 744,
	FN_AVB_TXD1___3 = 745,
	FN_VI1_DATA11___2 = 746,
	FN_CAN0_TX_B___4 = 747,
	FN_AVB_TXD2___3 = 748,
	FN_AVB_TXD3___3 = 749,
	FN_AUDIO_CLKA_B___2 = 750,
	FN_SSI_SCK1_D = 751,
	FN_RX5_F = 752,
	FN_MSIOF0_RXD_B___2 = 753,
	FN_AVB_TXD4___3 = 754,
	FN_AUDIO_CLKB_B___3 = 755,
	FN_SSI_WS1_D = 756,
	FN_TX5_F = 757,
	FN_MSIOF0_TXD_B___2 = 758,
	FN_AVB_TXD5___3 = 759,
	FN_SCIF_CLK_B___4 = 760,
	FN_AUDIO_CLKC_B___2 = 761,
	FN_SSI_SDATA1_D = 762,
	FN_MSIOF0_SCK_B___2 = 763,
	FN_SCL0_A = 764,
	FN_RX0_C___3 = 765,
	FN_PWM5_A = 766,
	FN_TCLK1_B___4 = 767,
	FN_AVB_TXD6___3 = 768,
	FN_CAN1_RX_D___3 = 769,
	FN_MSIOF0_SYNC_B___2 = 770,
	FN_SDA0_A = 771,
	FN_TX0_C___3 = 772,
	FN_IRQ5___3 = 773,
	FN_CAN_CLK_A = 774,
	FN_AVB_GTX_CLK___3 = 775,
	FN_CAN1_TX_D___3 = 776,
	FN_DVC_MUTE___3 = 777,
	FN_SCL1_A = 778,
	FN_RX4_A = 779,
	FN_PWM5_D = 780,
	FN_DU1_DR0___4 = 781,
	FN_SSI_SCK6_B___2 = 782,
	FN_VI0_G0___4 = 783,
	FN_SDA1_A = 784,
	FN_TX4_A = 785,
	FN_DU1_DR1___4 = 786,
	FN_SSI_WS6_B___2 = 787,
	FN_VI0_G1___4 = 788,
	FN_MSIOF0_RXD_A = 789,
	FN_RX5_A = 790,
	FN_SCL2_C___2 = 791,
	FN_DU1_DR2___4 = 792,
	FN_QSPI1_MOSI_QSPI1_IO0 = 793,
	FN_SSI_SDATA6_B___2 = 794,
	FN_VI0_G2___4 = 795,
	FN_MSIOF0_TXD_A = 796,
	FN_TX5_A = 797,
	FN_SDA2_C___2 = 798,
	FN_DU1_DR3___4 = 799,
	FN_QSPI1_MISO_QSPI1_IO1 = 800,
	FN_SSI_WS78_B___4 = 801,
	FN_VI0_G3___4 = 802,
	FN_MSIOF0_SCK_A = 803,
	FN_IRQ0___4 = 804,
	FN_DU1_DR4___4 = 805,
	FN_QSPI1_SPCLK = 806,
	FN_SSI_SCK78_B___4 = 807,
	FN_VI0_G4___4 = 808,
	FN_MSIOF0_SYNC_A = 809,
	FN_PWM1_A = 810,
	FN_DU1_DR5___4 = 811,
	FN_QSPI1_IO2 = 812,
	FN_SSI_SDATA7_B___4 = 813,
	FN_MSIOF0_SS1_A = 814,
	FN_DU1_DR6___4 = 815,
	FN_QSPI1_IO3 = 816,
	FN_SSI_SDATA8_B___4 = 817,
	FN_MSIOF0_SS2_A = 818,
	FN_DU1_DR7___4 = 819,
	FN_QSPI1_SSL = 820,
	FN_HRX1_A = 821,
	FN_SCL4_A = 822,
	FN_PWM6_A = 823,
	FN_DU1_DG0___4 = 824,
	FN_RX0_A = 825,
	FN_HTX1_A = 826,
	FN_SDA4_A = 827,
	FN_DU1_DG1___4 = 828,
	FN_TX0_A = 829,
	FN_HCTS1_N_A = 830,
	FN_PWM2_A = 831,
	FN_DU1_DG2___4 = 832,
	FN_REMOCON_B___3 = 833,
	FN_HRTS1_N_A = 834,
	FN_DU1_DG3___4 = 835,
	FN_SSI_WS1_B___3 = 836,
	FN_IRQ1___4 = 837,
	FN_SD2_CLK___4 = 838,
	FN_HSCK1___3 = 839,
	FN_DU1_DG4___4 = 840,
	FN_SSI_SCK1_B___3 = 841,
	FN_SD2_CMD___4 = 842,
	FN_SCIF1_SCK_A = 843,
	FN_TCLK2_A = 844,
	FN_DU1_DG5___4 = 845,
	FN_SSI_SCK2_B___2 = 846,
	FN_PWM3_A = 847,
	FN_SD2_DAT0___2 = 848,
	FN_RX1_A = 849,
	FN_SCL1_E = 850,
	FN_DU1_DG6___4 = 851,
	FN_SSI_SDATA1_B___3 = 852,
	FN_SD2_DAT1___2 = 853,
	FN_TX1_A = 854,
	FN_SDA1_E = 855,
	FN_DU1_DG7___4 = 856,
	FN_SSI_WS2_B___2 = 857,
	FN_SD2_DAT2___2 = 858,
	FN_RX2_A = 859,
	FN_DU1_DB0___4 = 860,
	FN_SSI_SDATA2_B___2 = 861,
	FN_SD2_DAT3___2 = 862,
	FN_TX2_A = 863,
	FN_DU1_DB1___4 = 864,
	FN_SSI_WS9_B___4 = 865,
	FN_SD2_CD___4 = 866,
	FN_SCIF2_SCK_A = 867,
	FN_DU1_DB2___4 = 868,
	FN_SSI_SCK9_B___4 = 869,
	FN_SD2_WP___4 = 870,
	FN_SCIF3_SCK___3 = 871,
	FN_DU1_DB3___4 = 872,
	FN_SSI_SDATA9_B___4 = 873,
	FN_RX3_A = 874,
	FN_SCL1_C___2 = 875,
	FN_MSIOF1_RXD_B___3 = 876,
	FN_DU1_DB4___4 = 877,
	FN_AUDIO_CLKA_C___2 = 878,
	FN_SSI_SDATA4_B___2 = 879,
	FN_TX3_A = 880,
	FN_SDA1_C___2 = 881,
	FN_MSIOF1_TXD_B___3 = 882,
	FN_DU1_DB5___4 = 883,
	FN_AUDIO_CLKB_C___2 = 884,
	FN_SSI_WS4_B___2 = 885,
	FN_SCL2_A = 886,
	FN_MSIOF1_SCK_B___3 = 887,
	FN_DU1_DB6___4 = 888,
	FN_AUDIO_CLKC_C___2 = 889,
	FN_SSI_SCK4_B___2 = 890,
	FN_SDA2_A = 891,
	FN_MSIOF1_SYNC_B___3 = 892,
	FN_DU1_DB7___4 = 893,
	FN_AUDIO_CLKOUT_C___3 = 894,
	FN_SSI_SCK5_A = 895,
	FN_DU1_DOTCLKOUT1___3 = 896,
	FN_SSI_WS5_A = 897,
	FN_SCL3_C = 898,
	FN_DU1_DOTCLKIN___4 = 899,
	FN_SSI_SDATA5_A = 900,
	FN_SDA3_C = 901,
	FN_DU1_DOTCLKOUT0___3 = 902,
	FN_SSI_SCK6_A = 903,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE___4 = 904,
	FN_SSI_WS6_A = 905,
	FN_SCL4_C = 906,
	FN_DU1_EXHSYNC_DU1_HSYNC___4 = 907,
	FN_SSI_SDATA6_A = 908,
	FN_SDA4_C = 909,
	FN_DU1_EXVSYNC_DU1_VSYNC___4 = 910,
	FN_SSI_SCK78_A = 911,
	FN_SDA4_E = 912,
	FN_DU1_DISP___4 = 913,
	FN_SSI_WS78_A = 914,
	FN_SCL4_E = 915,
	FN_DU1_CDE___4 = 916,
	FN_SSI_SDATA7_A = 917,
	FN_IRQ8___3 = 918,
	FN_AUDIO_CLKA_D___2 = 919,
	FN_CAN_CLK_D___3 = 920,
	FN_VI0_G5___4 = 921,
	FN_SSI_SCK0129_A = 922,
	FN_MSIOF1_RXD_A = 923,
	FN_RX5_D___2 = 924,
	FN_VI0_G6___4 = 925,
	FN_SSI_WS0129_A = 926,
	FN_MSIOF1_TXD_A = 927,
	FN_TX5_D___2 = 928,
	FN_VI0_G7___4 = 929,
	FN_SSI_SDATA0_A = 930,
	FN_MSIOF1_SYNC_A = 931,
	FN_PWM0_C___2 = 932,
	FN_VI0_R0___4 = 933,
	FN_SSI_SCK34___4 = 934,
	FN_MSIOF1_SCK_A = 935,
	FN_AVB_MDC___3 = 936,
	FN_DACK1___4 = 937,
	FN_VI0_R1___4 = 938,
	FN_SSI_WS34___4 = 939,
	FN_MSIOF1_SS1_A = 940,
	FN_AVB_MDIO___3 = 941,
	FN_CAN1_RX_A = 942,
	FN_DREQ1_N___2 = 943,
	FN_VI0_R2___4 = 944,
	FN_SSI_SDATA3___4 = 945,
	FN_MSIOF1_SS2_A = 946,
	FN_AVB_LINK___3 = 947,
	FN_CAN1_TX_A = 948,
	FN_DREQ2_N___2 = 949,
	FN_VI0_R3___4 = 950,
	FN_SSI_SCK4_A = 951,
	FN_AVB_MAGIC___3 = 952,
	FN_VI0_R4___4 = 953,
	FN_SSI_WS4_A = 954,
	FN_AVB_PHY_INT___3 = 955,
	FN_VI0_R5___4 = 956,
	FN_SSI_SDATA4_A = 957,
	FN_AVB_CRS___3 = 958,
	FN_VI0_R6___4 = 959,
	FN_SSI_SCK1_A = 960,
	FN_SCIF1_SCK_B___3 = 961,
	FN_PWM1_D = 962,
	FN_IRQ9___3 = 963,
	FN_REMOCON_A = 964,
	FN_DACK2___4 = 965,
	FN_VI0_CLK___4 = 966,
	FN_AVB_COL___3 = 967,
	FN_SSI_SDATA8_A = 968,
	FN_RX1_B___3 = 969,
	FN_CAN0_RX_D___3 = 970,
	FN_AVB_AVTP_CAPTURE_B = 971,
	FN_VI0_R7___4 = 972,
	FN_SSI_WS1_A = 973,
	FN_TX1_B___3 = 974,
	FN_CAN0_TX_D___3 = 975,
	FN_AVB_AVTP_MATCH_B = 976,
	FN_VI0_DATA0_VI0_B0___4 = 977,
	FN_SSI_SDATA1_A = 978,
	FN_HRX1_B___3 = 979,
	FN_VI0_DATA1_VI0_B1___4 = 980,
	FN_SSI_SCK2_A = 981,
	FN_HTX1_B___3 = 982,
	FN_AVB_TXD7___3 = 983,
	FN_VI0_DATA2_VI0_B2___4 = 984,
	FN_SSI_WS2_A = 985,
	FN_HCTS1_N_B = 986,
	FN_AVB_TX_ER___3 = 987,
	FN_VI0_DATA3_VI0_B3___4 = 988,
	FN_SSI_SDATA2_A = 989,
	FN_HRTS1_N_B = 990,
	FN_VI0_DATA4_VI0_B4___4 = 991,
	FN_SSI_SCK9_A = 992,
	FN_RX2_B___3 = 993,
	FN_SCL3_E = 994,
	FN_EX_WAIT1___4 = 995,
	FN_VI0_DATA5_VI0_B5___4 = 996,
	FN_SSI_WS9_A = 997,
	FN_TX2_B___3 = 998,
	FN_SDA3_E = 999,
	FN_VI0_DATA6_VI0_B6___4 = 1000,
	FN_SSI_SDATA9_A = 1001,
	FN_SCIF2_SCK_B___3 = 1002,
	FN_PWM2_D = 1003,
	FN_VI0_DATA7_VI0_B7___4 = 1004,
	FN_AUDIO_CLKA_A = 1005,
	FN_SCL0_B = 1006,
	FN_VI0_CLKENB___4 = 1007,
	FN_AUDIO_CLKB_A = 1008,
	FN_SDA0_B = 1009,
	FN_VI0_FIELD___4 = 1010,
	FN_AUDIO_CLKC_A = 1011,
	FN_SCL4_B = 1012,
	FN_VI0_HSYNC_N___3 = 1013,
	FN_AUDIO_CLKOUT_A = 1014,
	FN_SDA4_B = 1015,
	FN_VI0_VSYNC_N___3 = 1016,
	FN_SEL_ADGA_0 = 1017,
	FN_SEL_ADGA_1 = 1018,
	FN_SEL_ADGA_2 = 1019,
	FN_SEL_ADGA_3 = 1020,
	FN_SEL_CANCLK_0___3 = 1021,
	FN_SEL_CANCLK_1___3 = 1022,
	FN_SEL_CANCLK_2___3 = 1023,
	FN_SEL_CANCLK_3___2 = 1024,
	FN_SEL_CAN1_0___3 = 1025,
	FN_SEL_CAN1_1___3 = 1026,
	FN_SEL_CAN1_2___3 = 1027,
	FN_SEL_CAN1_3___3 = 1028,
	FN_SEL_CAN0_0___4 = 1029,
	FN_SEL_CAN0_1___4 = 1030,
	FN_SEL_CAN0_2___3 = 1031,
	FN_SEL_CAN0_3___3 = 1032,
	FN_SEL_I2C04_0___2 = 1033,
	FN_SEL_I2C04_1___2 = 1034,
	FN_SEL_I2C04_2___2 = 1035,
	FN_SEL_I2C04_3___2 = 1036,
	FN_SEL_I2C04_4___2 = 1037,
	FN_SEL_I2C03_0___2 = 1038,
	FN_SEL_I2C03_1___2 = 1039,
	FN_SEL_I2C03_2___2 = 1040,
	FN_SEL_I2C03_3___2 = 1041,
	FN_SEL_I2C03_4___2 = 1042,
	FN_SEL_I2C02_0___2 = 1043,
	FN_SEL_I2C02_1___2 = 1044,
	FN_SEL_I2C02_2___2 = 1045,
	FN_SEL_I2C02_3___2 = 1046,
	FN_SEL_I2C01_0___2 = 1047,
	FN_SEL_I2C01_1___2 = 1048,
	FN_SEL_I2C01_2___2 = 1049,
	FN_SEL_I2C01_3___2 = 1050,
	FN_SEL_I2C01_4___2 = 1051,
	FN_SEL_I2C00_0___2 = 1052,
	FN_SEL_I2C00_1___2 = 1053,
	FN_SEL_I2C00_2___2 = 1054,
	FN_SEL_I2C00_3___2 = 1055,
	FN_SEL_I2C00_4___2 = 1056,
	FN_SEL_AVB_0 = 1057,
	FN_SEL_AVB_1 = 1058,
	FN_SEL_SCIFCLK_0 = 1059,
	FN_SEL_SCIFCLK_1 = 1060,
	FN_SEL_SCIF5_0___4 = 1061,
	FN_SEL_SCIF5_1___4 = 1062,
	FN_SEL_SCIF5_2___3 = 1063,
	FN_SEL_SCIF5_3___3 = 1064,
	FN_SEL_SCIF5_4 = 1065,
	FN_SEL_SCIF5_5 = 1066,
	FN_SEL_SCIF4_0___4 = 1067,
	FN_SEL_SCIF4_1___4 = 1068,
	FN_SEL_SCIF4_2___4 = 1069,
	FN_SEL_SCIF4_3___3 = 1070,
	FN_SEL_SCIF4_4___2 = 1071,
	FN_SEL_SCIF3_0___4 = 1072,
	FN_SEL_SCIF3_1___4 = 1073,
	FN_SEL_SCIF3_2___3 = 1074,
	FN_SEL_SCIF2_0___4 = 1075,
	FN_SEL_SCIF2_1___4 = 1076,
	FN_SEL_SCIF2_2___4 = 1077,
	FN_SEL_SCIF2_CLK_0 = 1078,
	FN_SEL_SCIF2_CLK_1 = 1079,
	FN_SEL_SCIF1_0___4 = 1080,
	FN_SEL_SCIF1_1___4 = 1081,
	FN_SEL_SCIF1_2___4 = 1082,
	FN_SEL_SCIF1_3___2 = 1083,
	FN_SEL_SCIF0_0___4 = 1084,
	FN_SEL_SCIF0_1___4 = 1085,
	FN_SEL_SCIF0_2___4 = 1086,
	FN_SEL_SCIF0_3___4 = 1087,
	FN_SEL_MSIOF2_0 = 1088,
	FN_SEL_MSIOF2_1 = 1089,
	FN_SEL_MSIOF2_2 = 1090,
	FN_SEL_MSIOF1_0 = 1091,
	FN_SEL_MSIOF1_1 = 1092,
	FN_SEL_MSIOF0_0 = 1093,
	FN_SEL_MSIOF0_1 = 1094,
	FN_SEL_RCN_0___3 = 1095,
	FN_SEL_RCN_1___3 = 1096,
	FN_SEL_TMU2_0 = 1097,
	FN_SEL_TMU2_1 = 1098,
	FN_SEL_TMU1_0___3 = 1099,
	FN_SEL_TMU1_1___3 = 1100,
	FN_SEL_HSCIF1_0___4 = 1101,
	FN_SEL_HSCIF1_1___4 = 1102,
	FN_SEL_HSCIF1_2___2 = 1103,
	FN_SEL_HSCIF0_0___4 = 1104,
	FN_SEL_HSCIF0_1___4 = 1105,
	FN_SEL_ADGB_0 = 1106,
	FN_SEL_ADGB_1 = 1107,
	FN_SEL_ADGB_2 = 1108,
	FN_SEL_ADGC_0 = 1109,
	FN_SEL_ADGC_1 = 1110,
	FN_SEL_ADGC_2 = 1111,
	FN_SEL_SSI9_0___4 = 1112,
	FN_SEL_SSI9_1___4 = 1113,
	FN_SEL_SSI8_0___4 = 1114,
	FN_SEL_SSI8_1___4 = 1115,
	FN_SEL_SSI7_0___4 = 1116,
	FN_SEL_SSI7_1___4 = 1117,
	FN_SEL_SSI6_0___2 = 1118,
	FN_SEL_SSI6_1___2 = 1119,
	FN_SEL_SSI5_0___2 = 1120,
	FN_SEL_SSI5_1___2 = 1121,
	FN_SEL_SSI4_0___2 = 1122,
	FN_SEL_SSI4_1___2 = 1123,
	FN_SEL_SSI2_0___2 = 1124,
	FN_SEL_SSI2_1___2 = 1125,
	FN_SEL_SSI1_0___3 = 1126,
	FN_SEL_SSI1_1___3 = 1127,
	FN_SEL_SSI1_2 = 1128,
	FN_SEL_SSI1_3 = 1129,
	FN_SEL_SSI0_0___2 = 1130,
	FN_SEL_SSI0_1___2 = 1131,
	PINMUX_FUNCTION_END___7 = 1132,
	PINMUX_MARK_BEGIN___7 = 1133,
	USB0_PWEN_MARK___3 = 1134,
	USB0_OVC_MARK___3 = 1135,
	USB1_PWEN_MARK___3 = 1136,
	USB1_OVC_MARK___3 = 1137,
	CLKOUT_MARK___2 = 1138,
	MMC0_CLK_SDHI1_CLK_MARK = 1139,
	MMC0_CMD_SDHI1_CMD_MARK = 1140,
	MMC0_D0_SDHI1_D0_MARK = 1141,
	MMC0_D1_SDHI1_D1_MARK = 1142,
	MMC0_D2_SDHI1_D2_MARK = 1143,
	MMC0_D3_SDHI1_D3_MARK = 1144,
	MMC0_D6_MARK___2 = 1145,
	MMC0_D7_MARK___2 = 1146,
	SD0_CLK_MARK___4 = 1147,
	SSI_SCK1_C_MARK = 1148,
	RX3_C_MARK___2 = 1149,
	SD0_CMD_MARK___4 = 1150,
	SSI_WS1_C_MARK = 1151,
	TX3_C_MARK___2 = 1152,
	SD0_DAT0_MARK___2 = 1153,
	SSI_SDATA1_C_MARK = 1154,
	RX4_E_MARK = 1155,
	SD0_DAT1_MARK___2 = 1156,
	SSI_SCK0129_B_MARK___2 = 1157,
	TX4_E_MARK = 1158,
	SD0_DAT2_MARK___2 = 1159,
	SSI_WS0129_B_MARK___2 = 1160,
	RX5_E_MARK = 1161,
	SD0_DAT3_MARK___2 = 1162,
	SSI_SDATA0_B_MARK___2 = 1163,
	TX5_E_MARK = 1164,
	SD0_CD_MARK___4 = 1165,
	CAN0_RX_A_MARK = 1166,
	SD0_WP_MARK___4 = 1167,
	IRQ7_MARK___4 = 1168,
	CAN0_TX_A_MARK = 1169,
	MMC0_D4_MARK___2 = 1170,
	SD1_CD_MARK___4 = 1171,
	MMC0_D5_MARK___2 = 1172,
	SD1_WP_MARK___4 = 1173,
	D0_MARK___4 = 1174,
	SCL3_B_MARK___2 = 1175,
	RX5_B_MARK___3 = 1176,
	IRQ4_MARK___4 = 1177,
	MSIOF2_RXD_C_MARK___2 = 1178,
	SSI_SDATA5_B_MARK___2 = 1179,
	D1_MARK___4 = 1180,
	SDA3_B_MARK___2 = 1181,
	TX5_B_MARK___3 = 1182,
	MSIOF2_TXD_C_MARK___2 = 1183,
	SSI_WS5_B_MARK___2 = 1184,
	D2_MARK___4 = 1185,
	RX4_B_MARK___3 = 1186,
	SCL0_D_MARK = 1187,
	PWM1_C_MARK___2 = 1188,
	MSIOF2_SCK_C_MARK___2 = 1189,
	SSI_SCK5_B_MARK___2 = 1190,
	D3_MARK___4 = 1191,
	TX4_B_MARK___3 = 1192,
	SDA0_D_MARK = 1193,
	PWM0_A_MARK = 1194,
	MSIOF2_SYNC_C_MARK___2 = 1195,
	D4_MARK___4 = 1196,
	IRQ3_MARK___5 = 1197,
	TCLK1_A_MARK = 1198,
	PWM6_C_MARK = 1199,
	D5_MARK___4 = 1200,
	HRX2_MARK___2 = 1201,
	SCL1_B_MARK___2 = 1202,
	PWM2_C_MARK___2 = 1203,
	TCLK2_B_MARK___2 = 1204,
	D6_MARK___4 = 1205,
	HTX2_MARK___2 = 1206,
	SDA1_B_MARK___2 = 1207,
	PWM4_C_MARK = 1208,
	D7_MARK___4 = 1209,
	HSCK2_MARK___2 = 1210,
	SCIF1_SCK_C_MARK___2 = 1211,
	IRQ6_MARK___4 = 1212,
	PWM5_C_MARK___2 = 1213,
	D8_MARK___4 = 1214,
	HCTS2_N_MARK___2 = 1215,
	RX1_C_MARK___3 = 1216,
	SCL1_D_MARK___2 = 1217,
	PWM3_C_MARK = 1218,
	D9_MARK___4 = 1219,
	HRTS2_N_MARK___2 = 1220,
	TX1_C_MARK___3 = 1221,
	SDA1_D_MARK___2 = 1222,
	D10_MARK___4 = 1223,
	MSIOF2_RXD_A_MARK = 1224,
	HRX0_B_MARK___3 = 1225,
	D11_MARK___4 = 1226,
	MSIOF2_TXD_A_MARK = 1227,
	HTX0_B_MARK___3 = 1228,
	D12_MARK___4 = 1229,
	MSIOF2_SCK_A_MARK = 1230,
	HSCK0_MARK___3 = 1231,
	CAN_CLK_C_MARK___4 = 1232,
	D13_MARK___4 = 1233,
	MSIOF2_SYNC_A_MARK = 1234,
	RX4_C_MARK___3 = 1235,
	D14_MARK___4 = 1236,
	MSIOF2_SS1_MARK___5 = 1237,
	TX4_C_MARK___3 = 1238,
	CAN1_RX_B_MARK___3 = 1239,
	AVB_AVTP_CAPTURE_A_MARK = 1240,
	D15_MARK___4 = 1241,
	MSIOF2_SS2_MARK___5 = 1242,
	PWM4_A_MARK = 1243,
	CAN1_TX_B_MARK___3 = 1244,
	IRQ2_MARK___5 = 1245,
	AVB_AVTP_MATCH_A_MARK = 1246,
	QSPI0_SPCLK_MARK = 1247,
	WE0_N_MARK___4 = 1248,
	QSPI0_MOSI_QSPI0_IO0_MARK = 1249,
	BS_N_MARK___3 = 1250,
	QSPI0_MISO_QSPI0_IO1_MARK = 1251,
	RD_WR_N_MARK___3 = 1252,
	QSPI0_IO2_MARK = 1253,
	CS0_N_MARK___4 = 1254,
	QSPI0_IO3_MARK = 1255,
	RD_N_MARK___4 = 1256,
	QSPI0_SSL_MARK = 1257,
	WE1_N_MARK___4 = 1258,
	EX_WAIT0_MARK___3 = 1259,
	CAN_CLK_B_MARK___4 = 1260,
	SCIF_CLK_A_MARK = 1261,
	DU0_DR0_MARK___4 = 1262,
	RX5_C_MARK___2 = 1263,
	SCL2_D_MARK___2 = 1264,
	A0_MARK___7 = 1265,
	DU0_DR1_MARK___3 = 1266,
	TX5_C_MARK___2 = 1267,
	SDA2_D_MARK___2 = 1268,
	A1_MARK___5 = 1269,
	DU0_DR2_MARK___4 = 1270,
	RX0_D_MARK___3 = 1271,
	SCL0_E_MARK = 1272,
	A2_MARK___5 = 1273,
	DU0_DR3_MARK___4 = 1274,
	TX0_D_MARK___3 = 1275,
	SDA0_E_MARK = 1276,
	PWM0_B_MARK___4 = 1277,
	A3_MARK___5 = 1278,
	DU0_DR4_MARK___4 = 1279,
	RX1_D_MARK___2 = 1280,
	A4_MARK___4 = 1281,
	DU0_DR5_MARK___4 = 1282,
	TX1_D_MARK___2 = 1283,
	PWM1_B_MARK___3 = 1284,
	A5_MARK___4 = 1285,
	DU0_DR6_MARK___4 = 1286,
	RX2_C_MARK___3 = 1287,
	A6_MARK___5 = 1288,
	DU0_DR7_MARK___4 = 1289,
	TX2_C_MARK___3 = 1290,
	PWM2_B_MARK___3 = 1291,
	A7_MARK___5 = 1292,
	DU0_DG0_MARK___4 = 1293,
	RX3_B_MARK___2 = 1294,
	SCL3_D_MARK = 1295,
	A8_MARK___5 = 1296,
	DU0_DG1_MARK___4 = 1297,
	TX3_B_MARK___2 = 1298,
	SDA3_D_MARK = 1299,
	PWM3_B_MARK___2 = 1300,
	A9_MARK___5 = 1301,
	DU0_DG2_MARK___4 = 1302,
	RX4_D_MARK___2 = 1303,
	A10_MARK___5 = 1304,
	DU0_DG3_MARK___4 = 1305,
	TX4_D_MARK___2 = 1306,
	PWM4_B_MARK___3 = 1307,
	A11_MARK___5 = 1308,
	DU0_DG4_MARK___4 = 1309,
	HRX0_A_MARK = 1310,
	A12_MARK___5 = 1311,
	DU0_DG5_MARK___4 = 1312,
	HTX0_A_MARK = 1313,
	PWM5_B_MARK___3 = 1314,
	A13_MARK___5 = 1315,
	DU0_DG6_MARK___4 = 1316,
	HRX1_C_MARK___2 = 1317,
	A14_MARK___5 = 1318,
	DU0_DG7_MARK___4 = 1319,
	HTX1_C_MARK___2 = 1320,
	PWM6_B_MARK___2 = 1321,
	A15_MARK___5 = 1322,
	DU0_DB0_MARK___4 = 1323,
	SCL4_D_MARK = 1324,
	CAN0_RX_C_MARK___3 = 1325,
	A16_MARK___5 = 1326,
	DU0_DB1_MARK___4 = 1327,
	SDA4_D_MARK = 1328,
	CAN0_TX_C_MARK___3 = 1329,
	A17_MARK___6 = 1330,
	DU0_DB2_MARK___4 = 1331,
	HCTS0_N_MARK___2 = 1332,
	A18_MARK___6 = 1333,
	DU0_DB3_MARK___4 = 1334,
	HRTS0_N_MARK___2 = 1335,
	A19_MARK___6 = 1336,
	DU0_DB4_MARK___4 = 1337,
	HCTS1_N_C_MARK___2 = 1338,
	A20_MARK___6 = 1339,
	DU0_DB5_MARK___4 = 1340,
	HRTS1_N_C_MARK___2 = 1341,
	A21_MARK___6 = 1342,
	DU0_DB6_MARK___4 = 1343,
	A22_MARK___6 = 1344,
	DU0_DB7_MARK___4 = 1345,
	A23_MARK___6 = 1346,
	DU0_DOTCLKIN_MARK___5 = 1347,
	A24_MARK___6 = 1348,
	DU0_DOTCLKOUT0_MARK___3 = 1349,
	A25_MARK___6 = 1350,
	DU0_DOTCLKOUT1_MARK___3 = 1351,
	MSIOF2_RXD_B_MARK___3 = 1352,
	CS1_N_A26_MARK___3 = 1353,
	DU0_EXHSYNC_DU0_HSYNC_MARK___3 = 1354,
	MSIOF2_TXD_B_MARK___3 = 1355,
	DREQ0_N_MARK___2 = 1356,
	DU0_EXVSYNC_DU0_VSYNC_MARK___3 = 1357,
	MSIOF2_SYNC_B_MARK___3 = 1358,
	DACK0_MARK___6 = 1359,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK___3 = 1360,
	MSIOF2_SCK_B_MARK___3 = 1361,
	DRACK0_MARK___4 = 1362,
	DU0_DISP_MARK___3 = 1363,
	CAN1_RX_C_MARK___3 = 1364,
	DU0_CDE_MARK___4 = 1365,
	CAN1_TX_C_MARK___3 = 1366,
	VI1_CLK_MARK___4 = 1367,
	AVB_RX_CLK_MARK___3 = 1368,
	ETH_REF_CLK_MARK = 1369,
	VI1_DATA0_MARK___3 = 1370,
	AVB_RX_DV_MARK___3 = 1371,
	ETH_CRS_DV_MARK___4 = 1372,
	VI1_DATA1_MARK___3 = 1373,
	AVB_RXD0_MARK___3 = 1374,
	ETH_RXD0_MARK___4 = 1375,
	VI1_DATA2_MARK___3 = 1376,
	AVB_RXD1_MARK___3 = 1377,
	ETH_RXD1_MARK___4 = 1378,
	VI1_DATA3_MARK___3 = 1379,
	AVB_RXD2_MARK___3 = 1380,
	ETH_MDIO_MARK___4 = 1381,
	VI1_DATA4_MARK___3 = 1382,
	AVB_RXD3_MARK___3 = 1383,
	ETH_RX_ER_MARK___4 = 1384,
	VI1_DATA5_MARK___3 = 1385,
	AVB_RXD4_MARK___3 = 1386,
	ETH_LINK_MARK___4 = 1387,
	VI1_DATA6_MARK___3 = 1388,
	AVB_RXD5_MARK___3 = 1389,
	ETH_TXD1_MARK___4 = 1390,
	VI1_DATA7_MARK___3 = 1391,
	AVB_RXD6_MARK___3 = 1392,
	ETH_TX_EN_MARK___4 = 1393,
	VI1_CLKENB_MARK___4 = 1394,
	SCL3_A_MARK = 1395,
	AVB_RXD7_MARK___3 = 1396,
	ETH_MAGIC_MARK___4 = 1397,
	VI1_FIELD_MARK___4 = 1398,
	SDA3_A_MARK = 1399,
	AVB_RX_ER_MARK___3 = 1400,
	ETH_TXD0_MARK___4 = 1401,
	VI1_HSYNC_N_MARK___3 = 1402,
	RX0_B_MARK___3 = 1403,
	SCL0_C_MARK = 1404,
	AVB_GTXREFCLK_MARK___3 = 1405,
	ETH_MDC_MARK___4 = 1406,
	VI1_VSYNC_N_MARK___3 = 1407,
	TX0_B_MARK___3 = 1408,
	SDA0_C_MARK = 1409,
	AUDIO_CLKOUT_B_MARK___3 = 1410,
	AVB_TX_CLK_MARK___3 = 1411,
	VI1_DATA8_MARK___2 = 1412,
	SCL2_B_MARK___2 = 1413,
	AVB_TX_EN_MARK___3 = 1414,
	VI1_DATA9_MARK___2 = 1415,
	SDA2_B_MARK___2 = 1416,
	AVB_TXD0_MARK___3 = 1417,
	VI1_DATA10_MARK___2 = 1418,
	CAN0_RX_B_MARK___4 = 1419,
	AVB_TXD1_MARK___3 = 1420,
	VI1_DATA11_MARK___2 = 1421,
	CAN0_TX_B_MARK___4 = 1422,
	AVB_TXD2_MARK___3 = 1423,
	AVB_TXD3_MARK___3 = 1424,
	AUDIO_CLKA_B_MARK___2 = 1425,
	SSI_SCK1_D_MARK = 1426,
	RX5_F_MARK = 1427,
	MSIOF0_RXD_B_MARK___2 = 1428,
	AVB_TXD4_MARK___3 = 1429,
	AUDIO_CLKB_B_MARK___3 = 1430,
	SSI_WS1_D_MARK = 1431,
	TX5_F_MARK = 1432,
	MSIOF0_TXD_B_MARK___2 = 1433,
	AVB_TXD5_MARK___3 = 1434,
	SCIF_CLK_B_MARK___4 = 1435,
	AUDIO_CLKC_B_MARK___2 = 1436,
	SSI_SDATA1_D_MARK = 1437,
	MSIOF0_SCK_B_MARK___2 = 1438,
	SCL0_A_MARK = 1439,
	RX0_C_MARK___3 = 1440,
	PWM5_A_MARK = 1441,
	TCLK1_B_MARK___4 = 1442,
	AVB_TXD6_MARK___3 = 1443,
	CAN1_RX_D_MARK___3 = 1444,
	MSIOF0_SYNC_B_MARK___2 = 1445,
	SDA0_A_MARK = 1446,
	TX0_C_MARK___3 = 1447,
	IRQ5_MARK___4 = 1448,
	CAN_CLK_A_MARK = 1449,
	AVB_GTX_CLK_MARK___3 = 1450,
	CAN1_TX_D_MARK___3 = 1451,
	DVC_MUTE_MARK___3 = 1452,
	SCL1_A_MARK = 1453,
	RX4_A_MARK = 1454,
	PWM5_D_MARK = 1455,
	DU1_DR0_MARK___4 = 1456,
	SSI_SCK6_B_MARK___2 = 1457,
	VI0_G0_MARK___4 = 1458,
	SDA1_A_MARK = 1459,
	TX4_A_MARK = 1460,
	DU1_DR1_MARK___4 = 1461,
	SSI_WS6_B_MARK___2 = 1462,
	VI0_G1_MARK___4 = 1463,
	MSIOF0_RXD_A_MARK = 1464,
	RX5_A_MARK = 1465,
	SCL2_C_MARK___2 = 1466,
	DU1_DR2_MARK___4 = 1467,
	QSPI1_MOSI_QSPI1_IO0_MARK = 1468,
	SSI_SDATA6_B_MARK___2 = 1469,
	VI0_G2_MARK___4 = 1470,
	MSIOF0_TXD_A_MARK = 1471,
	TX5_A_MARK = 1472,
	SDA2_C_MARK___2 = 1473,
	DU1_DR3_MARK___4 = 1474,
	QSPI1_MISO_QSPI1_IO1_MARK = 1475,
	SSI_WS78_B_MARK___4 = 1476,
	VI0_G3_MARK___4 = 1477,
	MSIOF0_SCK_A_MARK = 1478,
	IRQ0_MARK___5 = 1479,
	DU1_DR4_MARK___4 = 1480,
	QSPI1_SPCLK_MARK = 1481,
	SSI_SCK78_B_MARK___4 = 1482,
	VI0_G4_MARK___4 = 1483,
	MSIOF0_SYNC_A_MARK = 1484,
	PWM1_A_MARK = 1485,
	DU1_DR5_MARK___4 = 1486,
	QSPI1_IO2_MARK = 1487,
	SSI_SDATA7_B_MARK___4 = 1488,
	MSIOF0_SS1_A_MARK = 1489,
	DU1_DR6_MARK___4 = 1490,
	QSPI1_IO3_MARK = 1491,
	SSI_SDATA8_B_MARK___4 = 1492,
	MSIOF0_SS2_A_MARK = 1493,
	DU1_DR7_MARK___4 = 1494,
	QSPI1_SSL_MARK = 1495,
	HRX1_A_MARK = 1496,
	SCL4_A_MARK = 1497,
	PWM6_A_MARK = 1498,
	DU1_DG0_MARK___4 = 1499,
	RX0_A_MARK = 1500,
	HTX1_A_MARK = 1501,
	SDA4_A_MARK = 1502,
	DU1_DG1_MARK___4 = 1503,
	TX0_A_MARK = 1504,
	HCTS1_N_A_MARK = 1505,
	PWM2_A_MARK = 1506,
	DU1_DG2_MARK___4 = 1507,
	REMOCON_B_MARK___3 = 1508,
	HRTS1_N_A_MARK = 1509,
	DU1_DG3_MARK___4 = 1510,
	SSI_WS1_B_MARK___3 = 1511,
	IRQ1_MARK___6 = 1512,
	SD2_CLK_MARK___4 = 1513,
	HSCK1_MARK___3 = 1514,
	DU1_DG4_MARK___4 = 1515,
	SSI_SCK1_B_MARK___3 = 1516,
	SD2_CMD_MARK___4 = 1517,
	SCIF1_SCK_A_MARK = 1518,
	TCLK2_A_MARK = 1519,
	DU1_DG5_MARK___4 = 1520,
	SSI_SCK2_B_MARK___2 = 1521,
	PWM3_A_MARK = 1522,
	SD2_DAT0_MARK___2 = 1523,
	RX1_A_MARK = 1524,
	SCL1_E_MARK = 1525,
	DU1_DG6_MARK___4 = 1526,
	SSI_SDATA1_B_MARK___3 = 1527,
	SD2_DAT1_MARK___2 = 1528,
	TX1_A_MARK = 1529,
	SDA1_E_MARK = 1530,
	DU1_DG7_MARK___4 = 1531,
	SSI_WS2_B_MARK___2 = 1532,
	SD2_DAT2_MARK___2 = 1533,
	RX2_A_MARK = 1534,
	DU1_DB0_MARK___4 = 1535,
	SSI_SDATA2_B_MARK___2 = 1536,
	SD2_DAT3_MARK___2 = 1537,
	TX2_A_MARK = 1538,
	DU1_DB1_MARK___4 = 1539,
	SSI_WS9_B_MARK___4 = 1540,
	SD2_CD_MARK___4 = 1541,
	SCIF2_SCK_A_MARK = 1542,
	DU1_DB2_MARK___4 = 1543,
	SSI_SCK9_B_MARK___4 = 1544,
	SD2_WP_MARK___4 = 1545,
	SCIF3_SCK_MARK___3 = 1546,
	DU1_DB3_MARK___4 = 1547,
	SSI_SDATA9_B_MARK___4 = 1548,
	RX3_A_MARK = 1549,
	SCL1_C_MARK___2 = 1550,
	MSIOF1_RXD_B_MARK___3 = 1551,
	DU1_DB4_MARK___4 = 1552,
	AUDIO_CLKA_C_MARK___2 = 1553,
	SSI_SDATA4_B_MARK___2 = 1554,
	TX3_A_MARK = 1555,
	SDA1_C_MARK___2 = 1556,
	MSIOF1_TXD_B_MARK___3 = 1557,
	DU1_DB5_MARK___4 = 1558,
	AUDIO_CLKB_C_MARK___2 = 1559,
	SSI_WS4_B_MARK___2 = 1560,
	SCL2_A_MARK = 1561,
	MSIOF1_SCK_B_MARK___3 = 1562,
	DU1_DB6_MARK___4 = 1563,
	AUDIO_CLKC_C_MARK___2 = 1564,
	SSI_SCK4_B_MARK___2 = 1565,
	SDA2_A_MARK = 1566,
	MSIOF1_SYNC_B_MARK___3 = 1567,
	DU1_DB7_MARK___4 = 1568,
	AUDIO_CLKOUT_C_MARK___3 = 1569,
	SSI_SCK5_A_MARK = 1570,
	DU1_DOTCLKOUT1_MARK___3 = 1571,
	SSI_WS5_A_MARK = 1572,
	SCL3_C_MARK = 1573,
	DU1_DOTCLKIN_MARK___4 = 1574,
	SSI_SDATA5_A_MARK = 1575,
	SDA3_C_MARK = 1576,
	DU1_DOTCLKOUT0_MARK___3 = 1577,
	SSI_SCK6_A_MARK = 1578,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK___4 = 1579,
	SSI_WS6_A_MARK = 1580,
	SCL4_C_MARK = 1581,
	DU1_EXHSYNC_DU1_HSYNC_MARK___4 = 1582,
	SSI_SDATA6_A_MARK = 1583,
	SDA4_C_MARK = 1584,
	DU1_EXVSYNC_DU1_VSYNC_MARK___4 = 1585,
	SSI_SCK78_A_MARK = 1586,
	SDA4_E_MARK = 1587,
	DU1_DISP_MARK___4 = 1588,
	SSI_WS78_A_MARK = 1589,
	SCL4_E_MARK = 1590,
	DU1_CDE_MARK___4 = 1591,
	SSI_SDATA7_A_MARK = 1592,
	IRQ8_MARK___5 = 1593,
	AUDIO_CLKA_D_MARK___2 = 1594,
	CAN_CLK_D_MARK___3 = 1595,
	VI0_G5_MARK___4 = 1596,
	SSI_SCK0129_A_MARK = 1597,
	MSIOF1_RXD_A_MARK = 1598,
	RX5_D_MARK___2 = 1599,
	VI0_G6_MARK___4 = 1600,
	SSI_WS0129_A_MARK = 1601,
	MSIOF1_TXD_A_MARK = 1602,
	TX5_D_MARK___2 = 1603,
	VI0_G7_MARK___4 = 1604,
	SSI_SDATA0_A_MARK = 1605,
	MSIOF1_SYNC_A_MARK = 1606,
	PWM0_C_MARK___2 = 1607,
	VI0_R0_MARK___4 = 1608,
	SSI_SCK34_MARK___4 = 1609,
	MSIOF1_SCK_A_MARK = 1610,
	AVB_MDC_MARK___3 = 1611,
	DACK1_MARK___6 = 1612,
	VI0_R1_MARK___4 = 1613,
	SSI_WS34_MARK___4 = 1614,
	MSIOF1_SS1_A_MARK = 1615,
	AVB_MDIO_MARK___3 = 1616,
	CAN1_RX_A_MARK = 1617,
	DREQ1_N_MARK___2 = 1618,
	VI0_R2_MARK___4 = 1619,
	SSI_SDATA3_MARK___4 = 1620,
	MSIOF1_SS2_A_MARK = 1621,
	AVB_LINK_MARK___3 = 1622,
	CAN1_TX_A_MARK = 1623,
	DREQ2_N_MARK___2 = 1624,
	VI0_R3_MARK___4 = 1625,
	SSI_SCK4_A_MARK = 1626,
	AVB_MAGIC_MARK___3 = 1627,
	VI0_R4_MARK___4 = 1628,
	SSI_WS4_A_MARK = 1629,
	AVB_PHY_INT_MARK___3 = 1630,
	VI0_R5_MARK___4 = 1631,
	SSI_SDATA4_A_MARK = 1632,
	AVB_CRS_MARK___3 = 1633,
	VI0_R6_MARK___4 = 1634,
	SSI_SCK1_A_MARK = 1635,
	SCIF1_SCK_B_MARK___3 = 1636,
	PWM1_D_MARK = 1637,
	IRQ9_MARK___4 = 1638,
	REMOCON_A_MARK = 1639,
	DACK2_MARK___5 = 1640,
	VI0_CLK_MARK___4 = 1641,
	AVB_COL_MARK___3 = 1642,
	SSI_SDATA8_A_MARK = 1643,
	RX1_B_MARK___3 = 1644,
	CAN0_RX_D_MARK___3 = 1645,
	AVB_AVTP_CAPTURE_B_MARK = 1646,
	VI0_R7_MARK___4 = 1647,
	SSI_WS1_A_MARK = 1648,
	TX1_B_MARK___3 = 1649,
	CAN0_TX_D_MARK___3 = 1650,
	AVB_AVTP_MATCH_B_MARK = 1651,
	VI0_DATA0_VI0_B0_MARK___4 = 1652,
	SSI_SDATA1_A_MARK = 1653,
	HRX1_B_MARK___3 = 1654,
	VI0_DATA1_VI0_B1_MARK___4 = 1655,
	SSI_SCK2_A_MARK = 1656,
	HTX1_B_MARK___3 = 1657,
	AVB_TXD7_MARK___3 = 1658,
	VI0_DATA2_VI0_B2_MARK___4 = 1659,
	SSI_WS2_A_MARK = 1660,
	HCTS1_N_B_MARK = 1661,
	AVB_TX_ER_MARK___3 = 1662,
	VI0_DATA3_VI0_B3_MARK___4 = 1663,
	SSI_SDATA2_A_MARK = 1664,
	HRTS1_N_B_MARK = 1665,
	VI0_DATA4_VI0_B4_MARK___4 = 1666,
	SSI_SCK9_A_MARK = 1667,
	RX2_B_MARK___3 = 1668,
	SCL3_E_MARK = 1669,
	EX_WAIT1_MARK___4 = 1670,
	VI0_DATA5_VI0_B5_MARK___4 = 1671,
	SSI_WS9_A_MARK = 1672,
	TX2_B_MARK___3 = 1673,
	SDA3_E_MARK = 1674,
	VI0_DATA6_VI0_B6_MARK___4 = 1675,
	SSI_SDATA9_A_MARK = 1676,
	SCIF2_SCK_B_MARK___3 = 1677,
	PWM2_D_MARK = 1678,
	VI0_DATA7_VI0_B7_MARK___4 = 1679,
	AUDIO_CLKA_A_MARK = 1680,
	SCL0_B_MARK = 1681,
	VI0_CLKENB_MARK___4 = 1682,
	AUDIO_CLKB_A_MARK = 1683,
	SDA0_B_MARK = 1684,
	VI0_FIELD_MARK___4 = 1685,
	AUDIO_CLKC_A_MARK = 1686,
	SCL4_B_MARK = 1687,
	VI0_HSYNC_N_MARK___3 = 1688,
	AUDIO_CLKOUT_A_MARK = 1689,
	SDA4_B_MARK = 1690,
	VI0_VSYNC_N_MARK___3 = 1691,
	PINMUX_MARK_END___7 = 1692,
};

enum {
	PINMUX_RESERVED___8 = 0,
	PINMUX_DATA_BEGIN___8 = 1,
	GP_0_0_DATA___5 = 2,
	GP_0_1_DATA___5 = 3,
	GP_0_2_DATA___5 = 4,
	GP_0_3_DATA___5 = 5,
	GP_0_4_DATA___5 = 6,
	GP_0_5_DATA___5 = 7,
	GP_0_6_DATA___5 = 8,
	GP_0_7_DATA___5 = 9,
	GP_0_8_DATA___5 = 10,
	GP_0_9_DATA___5 = 11,
	GP_0_10_DATA___5 = 12,
	GP_0_11_DATA___5 = 13,
	GP_0_12_DATA___5 = 14,
	GP_0_13_DATA___5 = 15,
	GP_0_14_DATA___5 = 16,
	GP_0_15_DATA___5 = 17,
	GP_0_16_DATA___5 = 18,
	GP_0_17_DATA___5 = 19,
	GP_0_18_DATA___5 = 20,
	GP_0_19_DATA___5 = 21,
	GP_0_20_DATA___5 = 22,
	GP_0_21_DATA___5 = 23,
	GP_0_22_DATA___5 = 24,
	GP_0_23_DATA___4 = 25,
	GP_0_24_DATA___4 = 26,
	GP_0_25_DATA___4 = 27,
	GP_0_26_DATA___4 = 28,
	GP_0_27_DATA___4 = 29,
	GP_0_28_DATA___4 = 30,
	GP_0_29_DATA___4 = 31,
	GP_0_30_DATA___4 = 32,
	GP_0_31_DATA___4 = 33,
	GP_1_0_DATA___5 = 34,
	GP_1_1_DATA___5 = 35,
	GP_1_2_DATA___5 = 36,
	GP_1_3_DATA___5 = 37,
	GP_1_4_DATA___5 = 38,
	GP_1_5_DATA___5 = 39,
	GP_1_6_DATA___5 = 40,
	GP_1_7_DATA___5 = 41,
	GP_1_8_DATA___5 = 42,
	GP_1_9_DATA___5 = 43,
	GP_1_10_DATA___5 = 44,
	GP_1_11_DATA___5 = 45,
	GP_1_12_DATA___5 = 46,
	GP_1_13_DATA___5 = 47,
	GP_1_14_DATA___5 = 48,
	GP_1_15_DATA___5 = 49,
	GP_1_16_DATA___5 = 50,
	GP_1_17_DATA___5 = 51,
	GP_1_18_DATA___5 = 52,
	GP_1_19_DATA___5 = 53,
	GP_1_20_DATA___5 = 54,
	GP_1_21_DATA___5 = 55,
	GP_1_22_DATA___5 = 56,
	GP_1_23_DATA___4 = 57,
	GP_1_24_DATA___4 = 58,
	GP_1_25_DATA___4 = 59,
	GP_1_26_DATA___2 = 60,
	GP_1_27_DATA___2 = 61,
	GP_1_28_DATA___2 = 62,
	GP_1_29_DATA___2 = 63,
	GP_1_30_DATA___2 = 64,
	GP_1_31_DATA___2 = 65,
	GP_2_0_DATA___5 = 66,
	GP_2_1_DATA___5 = 67,
	GP_2_2_DATA___5 = 68,
	GP_2_3_DATA___5 = 69,
	GP_2_4_DATA___5 = 70,
	GP_2_5_DATA___5 = 71,
	GP_2_6_DATA___5 = 72,
	GP_2_7_DATA___5 = 73,
	GP_2_8_DATA___5 = 74,
	GP_2_9_DATA___5 = 75,
	GP_2_10_DATA___5 = 76,
	GP_2_11_DATA___5 = 77,
	GP_2_12_DATA___5 = 78,
	GP_2_13_DATA___5 = 79,
	GP_2_14_DATA___5 = 80,
	GP_2_15_DATA___5 = 81,
	GP_2_16_DATA___5 = 82,
	GP_2_17_DATA___5 = 83,
	GP_2_18_DATA___5 = 84,
	GP_2_19_DATA___5 = 85,
	GP_2_20_DATA___5 = 86,
	GP_2_21_DATA___5 = 87,
	GP_2_22_DATA___5 = 88,
	GP_2_23_DATA___5 = 89,
	GP_2_24_DATA___5 = 90,
	GP_2_25_DATA___5 = 91,
	GP_2_26_DATA___5 = 92,
	GP_2_27_DATA___5 = 93,
	GP_2_28_DATA___5 = 94,
	GP_2_29_DATA___5 = 95,
	GP_2_30_DATA___5 = 96,
	GP_2_31_DATA___5 = 97,
	GP_3_0_DATA___5 = 98,
	GP_3_1_DATA___5 = 99,
	GP_3_2_DATA___5 = 100,
	GP_3_3_DATA___5 = 101,
	GP_3_4_DATA___5 = 102,
	GP_3_5_DATA___5 = 103,
	GP_3_6_DATA___5 = 104,
	GP_3_7_DATA___5 = 105,
	GP_3_8_DATA___5 = 106,
	GP_3_9_DATA___5 = 107,
	GP_3_10_DATA___5 = 108,
	GP_3_11_DATA___5 = 109,
	GP_3_12_DATA___5 = 110,
	GP_3_13_DATA___5 = 111,
	GP_3_14_DATA___5 = 112,
	GP_3_15_DATA___5 = 113,
	GP_3_16_DATA___5 = 114,
	GP_3_17_DATA___4 = 115,
	GP_3_18_DATA___4 = 116,
	GP_3_19_DATA___4 = 117,
	GP_3_20_DATA___4 = 118,
	GP_3_21_DATA___4 = 119,
	GP_3_22_DATA___4 = 120,
	GP_3_23_DATA___4 = 121,
	GP_3_24_DATA___4 = 122,
	GP_3_25_DATA___4 = 123,
	GP_3_26_DATA___4 = 124,
	GP_3_27_DATA___5 = 125,
	GP_3_28_DATA___5 = 126,
	GP_3_29_DATA___5 = 127,
	GP_3_30_DATA___4 = 128,
	GP_3_31_DATA___4 = 129,
	GP_4_0_DATA___5 = 130,
	GP_4_1_DATA___5 = 131,
	GP_4_2_DATA___5 = 132,
	GP_4_3_DATA___5 = 133,
	GP_4_4_DATA___5 = 134,
	GP_4_5_DATA___5 = 135,
	GP_4_6_DATA___5 = 136,
	GP_4_7_DATA___5 = 137,
	GP_4_8_DATA___5 = 138,
	GP_4_9_DATA___5 = 139,
	GP_4_10_DATA___5 = 140,
	GP_4_11_DATA___5 = 141,
	GP_4_12_DATA___5 = 142,
	GP_4_13_DATA___5 = 143,
	GP_4_14_DATA___5 = 144,
	GP_4_15_DATA___5 = 145,
	GP_4_16_DATA___5 = 146,
	GP_4_17_DATA___5 = 147,
	GP_4_18_DATA___5 = 148,
	GP_4_19_DATA___5 = 149,
	GP_4_20_DATA___5 = 150,
	GP_4_21_DATA___5 = 151,
	GP_4_22_DATA___5 = 152,
	GP_4_23_DATA___5 = 153,
	GP_4_24_DATA___5 = 154,
	GP_4_25_DATA___5 = 155,
	GP_4_26_DATA___4 = 156,
	PINMUX_DATA_END___8 = 157,
	PINMUX_FUNCTION_BEGIN___8 = 158,
	GP_0_0_FN___5 = 159,
	GP_0_1_FN___5 = 160,
	GP_0_2_FN___5 = 161,
	GP_0_3_FN___5 = 162,
	GP_0_4_FN___5 = 163,
	GP_0_5_FN___5 = 164,
	GP_0_6_FN___5 = 165,
	GP_0_7_FN___5 = 166,
	GP_0_8_FN___5 = 167,
	GP_0_9_FN___5 = 168,
	GP_0_10_FN___5 = 169,
	GP_0_11_FN___5 = 170,
	GP_0_12_FN___5 = 171,
	GP_0_13_FN___5 = 172,
	GP_0_14_FN___5 = 173,
	GP_0_15_FN___5 = 174,
	GP_0_16_FN___5 = 175,
	GP_0_17_FN___5 = 176,
	GP_0_18_FN___5 = 177,
	GP_0_19_FN___5 = 178,
	GP_0_20_FN___5 = 179,
	GP_0_21_FN___5 = 180,
	GP_0_22_FN___5 = 181,
	GP_0_23_FN___4 = 182,
	GP_0_24_FN___4 = 183,
	GP_0_25_FN___4 = 184,
	GP_0_26_FN___4 = 185,
	GP_0_27_FN___4 = 186,
	GP_0_28_FN___4 = 187,
	GP_0_29_FN___4 = 188,
	GP_0_30_FN___4 = 189,
	GP_0_31_FN___4 = 190,
	GP_1_0_FN___5 = 191,
	GP_1_1_FN___5 = 192,
	GP_1_2_FN___5 = 193,
	GP_1_3_FN___5 = 194,
	GP_1_4_FN___5 = 195,
	GP_1_5_FN___5 = 196,
	GP_1_6_FN___5 = 197,
	GP_1_7_FN___5 = 198,
	GP_1_8_FN___5 = 199,
	GP_1_9_FN___5 = 200,
	GP_1_10_FN___5 = 201,
	GP_1_11_FN___5 = 202,
	GP_1_12_FN___5 = 203,
	GP_1_13_FN___5 = 204,
	GP_1_14_FN___5 = 205,
	GP_1_15_FN___5 = 206,
	GP_1_16_FN___5 = 207,
	GP_1_17_FN___5 = 208,
	GP_1_18_FN___5 = 209,
	GP_1_19_FN___5 = 210,
	GP_1_20_FN___5 = 211,
	GP_1_21_FN___5 = 212,
	GP_1_22_FN___5 = 213,
	GP_1_23_FN___4 = 214,
	GP_1_24_FN___4 = 215,
	GP_1_25_FN___4 = 216,
	GP_1_26_FN___2 = 217,
	GP_1_27_FN___2 = 218,
	GP_1_28_FN___2 = 219,
	GP_1_29_FN___2 = 220,
	GP_1_30_FN___2 = 221,
	GP_1_31_FN___2 = 222,
	GP_2_0_FN___5 = 223,
	GP_2_1_FN___5 = 224,
	GP_2_2_FN___5 = 225,
	GP_2_3_FN___5 = 226,
	GP_2_4_FN___5 = 227,
	GP_2_5_FN___5 = 228,
	GP_2_6_FN___5 = 229,
	GP_2_7_FN___5 = 230,
	GP_2_8_FN___5 = 231,
	GP_2_9_FN___5 = 232,
	GP_2_10_FN___5 = 233,
	GP_2_11_FN___5 = 234,
	GP_2_12_FN___5 = 235,
	GP_2_13_FN___5 = 236,
	GP_2_14_FN___5 = 237,
	GP_2_15_FN___5 = 238,
	GP_2_16_FN___5 = 239,
	GP_2_17_FN___5 = 240,
	GP_2_18_FN___5 = 241,
	GP_2_19_FN___5 = 242,
	GP_2_20_FN___5 = 243,
	GP_2_21_FN___5 = 244,
	GP_2_22_FN___5 = 245,
	GP_2_23_FN___5 = 246,
	GP_2_24_FN___5 = 247,
	GP_2_25_FN___5 = 248,
	GP_2_26_FN___5 = 249,
	GP_2_27_FN___5 = 250,
	GP_2_28_FN___5 = 251,
	GP_2_29_FN___5 = 252,
	GP_2_30_FN___5 = 253,
	GP_2_31_FN___5 = 254,
	GP_3_0_FN___5 = 255,
	GP_3_1_FN___5 = 256,
	GP_3_2_FN___5 = 257,
	GP_3_3_FN___5 = 258,
	GP_3_4_FN___5 = 259,
	GP_3_5_FN___5 = 260,
	GP_3_6_FN___5 = 261,
	GP_3_7_FN___5 = 262,
	GP_3_8_FN___5 = 263,
	GP_3_9_FN___5 = 264,
	GP_3_10_FN___5 = 265,
	GP_3_11_FN___5 = 266,
	GP_3_12_FN___5 = 267,
	GP_3_13_FN___5 = 268,
	GP_3_14_FN___5 = 269,
	GP_3_15_FN___5 = 270,
	GP_3_16_FN___5 = 271,
	GP_3_17_FN___4 = 272,
	GP_3_18_FN___4 = 273,
	GP_3_19_FN___4 = 274,
	GP_3_20_FN___4 = 275,
	GP_3_21_FN___4 = 276,
	GP_3_22_FN___4 = 277,
	GP_3_23_FN___4 = 278,
	GP_3_24_FN___4 = 279,
	GP_3_25_FN___4 = 280,
	GP_3_26_FN___4 = 281,
	GP_3_27_FN___5 = 282,
	GP_3_28_FN___5 = 283,
	GP_3_29_FN___5 = 284,
	GP_3_30_FN___4 = 285,
	GP_3_31_FN___4 = 286,
	GP_4_0_FN___5 = 287,
	GP_4_1_FN___5 = 288,
	GP_4_2_FN___5 = 289,
	GP_4_3_FN___5 = 290,
	GP_4_4_FN___5 = 291,
	GP_4_5_FN___5 = 292,
	GP_4_6_FN___5 = 293,
	GP_4_7_FN___5 = 294,
	GP_4_8_FN___5 = 295,
	GP_4_9_FN___5 = 296,
	GP_4_10_FN___5 = 297,
	GP_4_11_FN___5 = 298,
	GP_4_12_FN___5 = 299,
	GP_4_13_FN___5 = 300,
	GP_4_14_FN___5 = 301,
	GP_4_15_FN___5 = 302,
	GP_4_16_FN___5 = 303,
	GP_4_17_FN___5 = 304,
	GP_4_18_FN___5 = 305,
	GP_4_19_FN___5 = 306,
	GP_4_20_FN___5 = 307,
	GP_4_21_FN___5 = 308,
	GP_4_22_FN___5 = 309,
	GP_4_23_FN___5 = 310,
	GP_4_24_FN___5 = 311,
	GP_4_25_FN___5 = 312,
	GP_4_26_FN___4 = 313,
	FN_IP0_1_0 = 314,
	FN_PENC0 = 315,
	FN_PENC1 = 316,
	FN_IP0_4_2 = 317,
	FN_IP0_7_5 = 318,
	FN_IP0_11_8___2 = 319,
	FN_IP0_14_12 = 320,
	FN_A1___5 = 321,
	FN_A2___5 = 322,
	FN_A3___5 = 323,
	FN_IP0_15___3 = 324,
	FN_IP0_16___2 = 325,
	FN_IP0_17___2 = 326,
	FN_IP0_18 = 327,
	FN_IP0_19 = 328,
	FN_IP0_20 = 329,
	FN_IP0_21 = 330,
	FN_IP0_22 = 331,
	FN_IP0_23 = 332,
	FN_IP0_24___2 = 333,
	FN_IP0_25___3 = 334,
	FN_IP0_26 = 335,
	FN_IP0_27 = 336,
	FN_IP0_28 = 337,
	FN_IP0_29 = 338,
	FN_IP0_30 = 339,
	FN_IP1_0 = 340,
	FN_IP1_1 = 341,
	FN_IP1_4_2 = 342,
	FN_IP1_7_5 = 343,
	FN_IP1_10_8___3 = 344,
	FN_IP1_14_11___2 = 345,
	FN_IP1_23_21 = 346,
	FN_WE0___2 = 347,
	FN_IP1_24___2 = 348,
	FN_IP1_27_25 = 349,
	FN_IP1_29_28___2 = 350,
	FN_IP2_2_0___2 = 351,
	FN_IP2_5_3 = 352,
	FN_IP2_8_6 = 353,
	FN_IP2_11_9 = 354,
	FN_IP2_13_12___2 = 355,
	FN_IP2_16_14 = 356,
	FN_IP2_17 = 357,
	FN_IP2_30 = 358,
	FN_IP2_31 = 359,
	FN_IP3_1_0___2 = 360,
	FN_IP3_4_2 = 361,
	FN_IP3_7_5 = 362,
	FN_IP3_9_8___2 = 363,
	FN_IP3_12_10 = 364,
	FN_IP3_15_13 = 365,
	FN_IP3_18_16 = 366,
	FN_IP3_20_19 = 367,
	FN_IP3_23_21___2 = 368,
	FN_IP3_26_24___3 = 369,
	FN_IP3_27___2 = 370,
	FN_IP3_28___2 = 371,
	FN_IP3_29 = 372,
	FN_IP3_30___2 = 373,
	FN_IP3_31___2 = 374,
	FN_IP4_0 = 375,
	FN_IP4_3_1 = 376,
	FN_IP4_6_4 = 377,
	FN_IP4_7 = 378,
	FN_IP4_8 = 379,
	FN_IP4_10_9 = 380,
	FN_IP4_12_11 = 381,
	FN_IP4_14_13 = 382,
	FN_IP4_16_15 = 383,
	FN_IP4_20_17 = 384,
	FN_IP4_24_21 = 385,
	FN_IP4_26_25 = 386,
	FN_IP4_28_27 = 387,
	FN_IP4_30_29 = 388,
	FN_IP5_1_0___2 = 389,
	FN_IP5_3_2___2 = 390,
	FN_IP5_5_4___2 = 391,
	FN_IP5_6___2 = 392,
	FN_IP5_7___2 = 393,
	FN_IP5_9_8 = 394,
	FN_IP5_11_10 = 395,
	FN_IP5_12 = 396,
	FN_IP5_14_13___2 = 397,
	FN_IP5_17_15 = 398,
	FN_IP5_20_18 = 399,
	FN_AUDIO_CLKA___4 = 400,
	FN_AUDIO_CLKB___4 = 401,
	FN_IP5_22_21 = 402,
	FN_IP5_25_23 = 403,
	FN_IP5_28_26___2 = 404,
	FN_IP5_30_29___2 = 405,
	FN_IP6_1_0___3 = 406,
	FN_IP6_4_2 = 407,
	FN_IP6_6_5 = 408,
	FN_IP6_7 = 409,
	FN_IP6_8___3 = 410,
	FN_IP6_9___2 = 411,
	FN_SSI_SCK34___5 = 412,
	FN_IP6_10___2 = 413,
	FN_IP6_12_11 = 414,
	FN_IP6_13___2 = 415,
	FN_IP6_15_14___2 = 416,
	FN_IP6_16___2 = 417,
	FN_IP6_18_17 = 418,
	FN_IP6_20_19___2 = 419,
	FN_IP6_21 = 420,
	FN_IP6_23_22 = 421,
	FN_IP6_25_24 = 422,
	FN_IP6_27_26 = 423,
	FN_IP6_29_28 = 424,
	FN_IP6_31_30 = 425,
	FN_IP7_1_0___2 = 426,
	FN_IP7_3_2___2 = 427,
	FN_IP7_5_4 = 428,
	FN_IP7_8_6___3 = 429,
	FN_IP7_11_9___2 = 430,
	FN_IP7_14_12___2 = 431,
	FN_IP7_17_15___2 = 432,
	FN_IP7_20_18___2 = 433,
	FN_IP7_21 = 434,
	FN_IP7_24_22 = 435,
	FN_IP7_28_25 = 436,
	FN_IP7_31_29 = 437,
	FN_IP8_2_0___3 = 438,
	FN_IP8_5_3___3 = 439,
	FN_IP8_8_6___3 = 440,
	FN_IP8_10_9 = 441,
	FN_IP8_13_11 = 442,
	FN_IP8_15_14 = 443,
	FN_IP8_18_16 = 444,
	FN_IP8_21_19 = 445,
	FN_IP8_23_22 = 446,
	FN_IP8_26_24 = 447,
	FN_IP8_29_27 = 448,
	FN_IP9_2_0___3 = 449,
	FN_IP9_5_3___3 = 450,
	FN_IP9_8_6___2 = 451,
	FN_IP9_11_9___2 = 452,
	FN_IP9_14_12___2 = 453,
	FN_IP9_17_15 = 454,
	FN_IP9_20_18 = 455,
	FN_IP9_23_21 = 456,
	FN_IP9_26_24 = 457,
	FN_IP9_29_27 = 458,
	FN_IP10_2_0___4 = 459,
	FN_IP10_5_3___4 = 460,
	FN_IP10_8_6___4 = 461,
	FN_IP10_12_9 = 462,
	FN_IP10_15_13 = 463,
	FN_IP10_18_16 = 464,
	FN_IP10_21_19___2 = 465,
	FN_IP10_24_22___2 = 466,
	FN_AVS1___2 = 467,
	FN_AVS2___2 = 468,
	FN_PRESETOUT = 469,
	FN_PWM1___4 = 470,
	FN_AUDATA0___2 = 471,
	FN_ARM_TRACEDATA_0___2 = 472,
	FN_GPSCLK_C = 473,
	FN_USB_OVC0___2 = 474,
	FN_TX2_E___3 = 475,
	FN_SDA2_B___3 = 476,
	FN_AUDATA1___2 = 477,
	FN_ARM_TRACEDATA_1___2 = 478,
	FN_GPSIN_C = 479,
	FN_USB_OVC1___2 = 480,
	FN_RX2_E___3 = 481,
	FN_SCL2_B___3 = 482,
	FN_SD1_DAT2_A = 483,
	FN_MMC_D2___3 = 484,
	FN_BS___2 = 485,
	FN_ATADIR0_A = 486,
	FN_SDSELF_A = 487,
	FN_PWM4_B___4 = 488,
	FN_SD1_DAT3_A = 489,
	FN_MMC_D3___3 = 490,
	FN_A0___5 = 491,
	FN_ATAG0_A = 492,
	FN_REMOCON_B___4 = 493,
	FN_A4___5 = 494,
	FN_A5___5 = 495,
	FN_A6___5 = 496,
	FN_A7___5 = 497,
	FN_A8___5 = 498,
	FN_A9___5 = 499,
	FN_A10___5 = 500,
	FN_A11___5 = 501,
	FN_A12___5 = 502,
	FN_A13___5 = 503,
	FN_A14___5 = 504,
	FN_A15___5 = 505,
	FN_A16___5 = 506,
	FN_A17___5 = 507,
	FN_A18___5 = 508,
	FN_A19___5 = 509,
	FN_A20___5 = 510,
	FN_HSPI_CS1_B___2 = 511,
	FN_A21___5 = 512,
	FN_HSPI_CLK1_B___2 = 513,
	FN_A22___5 = 514,
	FN_HRTS0_B___2 = 515,
	FN_RX2_B___4 = 516,
	FN_DREQ2_A = 517,
	FN_A23___5 = 518,
	FN_HTX0_B___4 = 519,
	FN_TX2_B___4 = 520,
	FN_DACK2_A = 521,
	FN_TS_SDEN0_A = 522,
	FN_SD1_CD_A = 523,
	FN_MMC_D6___3 = 524,
	FN_A24___5 = 525,
	FN_DREQ1_A = 526,
	FN_HRX0_B___4 = 527,
	FN_TS_SPSYNC0_A = 528,
	FN_SD1_WP_A = 529,
	FN_MMC_D7___3 = 530,
	FN_A25___5 = 531,
	FN_DACK1_A = 532,
	FN_HCTS0_B___2 = 533,
	FN_RX3_C___3 = 534,
	FN_TS_SDAT0_A = 535,
	FN_CLKOUT___3 = 536,
	FN_HSPI_TX1_B___2 = 537,
	FN_PWM0_B___5 = 538,
	FN_CS0___2 = 539,
	FN_HSPI_RX1_B___2 = 540,
	FN_SSI_SCK1_B___4 = 541,
	FN_ATAG0_B = 542,
	FN_CS1_A26___2 = 543,
	FN_SDA2_A___2 = 544,
	FN_SCK2_B___2 = 545,
	FN_MMC_D5___3 = 546,
	FN_ATADIR0_B = 547,
	FN_RD_WR___2 = 548,
	FN_WE1___2 = 549,
	FN_ATAWR0_B = 550,
	FN_SSI_WS1_B___4 = 551,
	FN_EX_CS0___2 = 552,
	FN_SCL2_A___2 = 553,
	FN_TX3_C___3 = 554,
	FN_TS_SCK0_A = 555,
	FN_EX_CS1___2 = 556,
	FN_MMC_D4___3 = 557,
	FN_SD1_CLK_A = 558,
	FN_MMC_CLK___3 = 559,
	FN_ATACS00___2 = 560,
	FN_EX_CS2___2 = 561,
	FN_SD1_CMD_A = 562,
	FN_MMC_CMD___3 = 563,
	FN_ATACS10___2 = 564,
	FN_EX_CS3___2 = 565,
	FN_SD1_DAT0_A = 566,
	FN_MMC_D0___3 = 567,
	FN_ATARD0___2 = 568,
	FN_EX_CS4___2 = 569,
	FN_EX_WAIT1_A = 570,
	FN_SD1_DAT1_A = 571,
	FN_MMC_D1___3 = 572,
	FN_ATAWR0_A = 573,
	FN_EX_CS5___2 = 574,
	FN_EX_WAIT2_A = 575,
	FN_DREQ0_A = 576,
	FN_RX3_A___2 = 577,
	FN_DACK0___5 = 578,
	FN_TX3_A___2 = 579,
	FN_DRACK0___5 = 580,
	FN_EX_WAIT0___5 = 581,
	FN_PWM0_C___3 = 582,
	FN_D0___4 = 583,
	FN_D1___4 = 584,
	FN_D2___4 = 585,
	FN_D3___4 = 586,
	FN_D4___4 = 587,
	FN_D5___4 = 588,
	FN_D6___4 = 589,
	FN_D7___4 = 590,
	FN_D8___4 = 591,
	FN_D9___4 = 592,
	FN_D10___4 = 593,
	FN_D11___4 = 594,
	FN_RD_WR_B = 595,
	FN_IRQ0___5 = 596,
	FN_MLB_CLK___4 = 597,
	FN_IRQ1_A = 598,
	FN_MLB_SIG___4 = 599,
	FN_RX5_B___4 = 600,
	FN_SDA3_A___2 = 601,
	FN_IRQ2_A = 602,
	FN_MLB_DAT___4 = 603,
	FN_TX5_B___4 = 604,
	FN_SCL3_A___2 = 605,
	FN_IRQ3_A = 606,
	FN_SDSELF_B___2 = 607,
	FN_SD1_CMD_B = 608,
	FN_SCIF_CLK___4 = 609,
	FN_AUDIO_CLKOUT_B___4 = 610,
	FN_CAN_CLK_B___5 = 611,
	FN_SDA3_B___3 = 612,
	FN_SD1_CLK_B = 613,
	FN_HTX0_A___2 = 614,
	FN_TX0_A___2 = 615,
	FN_SD1_DAT0_B = 616,
	FN_HRX0_A___2 = 617,
	FN_RX0_A___2 = 618,
	FN_SD1_DAT1_B = 619,
	FN_HSCK0___4 = 620,
	FN_SCK0___2 = 621,
	FN_SCL3_B___3 = 622,
	FN_SD1_DAT2_B = 623,
	FN_HCTS0_A = 624,
	FN_CTS0___2 = 625,
	FN_SD1_DAT3_B = 626,
	FN_HRTS0_A = 627,
	FN_RTS0 = 628,
	FN_SSI_SCK4___4 = 629,
	FN_DU0_DR0___4 = 630,
	FN_LCDOUT0___4 = 631,
	FN_AUDATA2___2 = 632,
	FN_ARM_TRACEDATA_2___2 = 633,
	FN_SDA3_C___2 = 634,
	FN_ADICHS1___4 = 635,
	FN_TS_SDEN0_B___2 = 636,
	FN_SSI_WS4___4 = 637,
	FN_DU0_DR1___4 = 638,
	FN_LCDOUT1___4 = 639,
	FN_AUDATA3___2 = 640,
	FN_ARM_TRACEDATA_3___2 = 641,
	FN_SCL3_C___2 = 642,
	FN_ADICHS2___4 = 643,
	FN_TS_SPSYNC0_B___2 = 644,
	FN_DU0_DR2___4 = 645,
	FN_LCDOUT2___4 = 646,
	FN_DU0_DR3___4 = 647,
	FN_LCDOUT3___4 = 648,
	FN_DU0_DR4___4 = 649,
	FN_LCDOUT4___4 = 650,
	FN_DU0_DR5___4 = 651,
	FN_LCDOUT5___4 = 652,
	FN_DU0_DR6___4 = 653,
	FN_LCDOUT6___4 = 654,
	FN_DU0_DR7___4 = 655,
	FN_LCDOUT7___4 = 656,
	FN_DU0_DG0___4 = 657,
	FN_LCDOUT8___4 = 658,
	FN_AUDATA4___2 = 659,
	FN_ARM_TRACEDATA_4___2 = 660,
	FN_TX1_D___3 = 661,
	FN_CAN0_TX_A___2 = 662,
	FN_ADICHS0___4 = 663,
	FN_DU0_DG1___4 = 664,
	FN_LCDOUT9___4 = 665,
	FN_AUDATA5___2 = 666,
	FN_ARM_TRACEDATA_5___2 = 667,
	FN_RX1_D___3 = 668,
	FN_CAN0_RX_A___2 = 669,
	FN_ADIDATA___4 = 670,
	FN_DU0_DG2___4 = 671,
	FN_LCDOUT10___4 = 672,
	FN_DU0_DG3___4 = 673,
	FN_LCDOUT11___4 = 674,
	FN_DU0_DG4___4 = 675,
	FN_LCDOUT12___4 = 676,
	FN_RX0_B___4 = 677,
	FN_DU0_DG5___4 = 678,
	FN_LCDOUT13___4 = 679,
	FN_TX0_B___4 = 680,
	FN_DU0_DG6___4 = 681,
	FN_LCDOUT14___4 = 682,
	FN_RX4_A___2 = 683,
	FN_DU0_DG7___4 = 684,
	FN_LCDOUT15___4 = 685,
	FN_TX4_A___2 = 686,
	FN_SSI_SCK2_B___3 = 687,
	FN_VI0_R0_B = 688,
	FN_DU0_DB0___4 = 689,
	FN_LCDOUT16___4 = 690,
	FN_AUDATA6___2 = 691,
	FN_ARM_TRACEDATA_6___2 = 692,
	FN_GPSCLK_A = 693,
	FN_PWM0_A___2 = 694,
	FN_ADICLK___4 = 695,
	FN_TS_SDAT0_B = 696,
	FN_AUDIO_CLKC___4 = 697,
	FN_VI0_R1_B = 698,
	FN_DU0_DB1___4 = 699,
	FN_LCDOUT17___4 = 700,
	FN_AUDATA7___2 = 701,
	FN_ARM_TRACEDATA_7___2 = 702,
	FN_GPSIN_A = 703,
	FN_ADICS_SAMP___4 = 704,
	FN_TS_SCK0_B___2 = 705,
	FN_VI0_R2_B = 706,
	FN_DU0_DB2___4 = 707,
	FN_LCDOUT18___4 = 708,
	FN_VI0_R3_B = 709,
	FN_DU0_DB3___4 = 710,
	FN_LCDOUT19___4 = 711,
	FN_VI0_R4_B = 712,
	FN_DU0_DB4___4 = 713,
	FN_LCDOUT20___4 = 714,
	FN_VI0_R5_B = 715,
	FN_DU0_DB5___4 = 716,
	FN_LCDOUT21___4 = 717,
	FN_VI1_DATA10_B = 718,
	FN_DU0_DB6___4 = 719,
	FN_LCDOUT22___4 = 720,
	FN_VI1_DATA11_B = 721,
	FN_DU0_DB7___4 = 722,
	FN_LCDOUT23___4 = 723,
	FN_DU0_DOTCLKIN___5 = 724,
	FN_QSTVA_QVS___4 = 725,
	FN_DU0_DOTCLKO_UT0 = 726,
	FN_QCLK___4 = 727,
	FN_DU0_DOTCLKO_UT1 = 728,
	FN_QSTVB_QVE___4 = 729,
	FN_AUDIO_CLKOUT_A___2 = 730,
	FN_REMOCON_C = 731,
	FN_SSI_WS2_B___3 = 732,
	FN_DU0_EXHSYNC_DU0_HSYNC___4 = 733,
	FN_QSTH_QHS___4 = 734,
	FN_DU0_EXVSYNC_DU0_VSYNC___4 = 735,
	FN_QSTB_QHE___4 = 736,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE___4 = 737,
	FN_QCPV_QDE___4 = 738,
	FN_FMCLK_D___3 = 739,
	FN_SSI_SCK1_A___2 = 740,
	FN_DU0_DISP___4 = 741,
	FN_QPOLA___4 = 742,
	FN_AUDCK___2 = 743,
	FN_ARM_TRACECLK = 744,
	FN_BPFCLK_D___3 = 745,
	FN_SSI_WS1_A___2 = 746,
	FN_DU0_CDE___4 = 747,
	FN_QPOLB___4 = 748,
	FN_AUDSYNC___2 = 749,
	FN_ARM_TRACECTL = 750,
	FN_FMIN_D___3 = 751,
	FN_SD1_CD_B = 752,
	FN_SSI_SCK78___4 = 753,
	FN_HSPI_RX0_B = 754,
	FN_TX1_B___4 = 755,
	FN_SD1_WP_B = 756,
	FN_SSI_WS78___4 = 757,
	FN_HSPI_CLK0_B = 758,
	FN_RX1_B___4 = 759,
	FN_CAN_CLK_D___4 = 760,
	FN_SSI_SDATA8___4 = 761,
	FN_SSI_SCK2_A___2 = 762,
	FN_HSPI_CS0_B = 763,
	FN_TX2_A___2 = 764,
	FN_CAN0_TX_B___5 = 765,
	FN_SSI_SDATA7___4 = 766,
	FN_HSPI_TX0_B = 767,
	FN_RX2_A___2 = 768,
	FN_CAN0_RX_B___5 = 769,
	FN_SSI_SCK6___4 = 770,
	FN_HSPI_RX2_A = 771,
	FN_FMCLK_B___3 = 772,
	FN_CAN1_TX_B___4 = 773,
	FN_SSI_WS6___4 = 774,
	FN_HSPI_CLK2_A = 775,
	FN_BPFCLK_B___3 = 776,
	FN_CAN1_RX_B___4 = 777,
	FN_SSI_SDATA6___4 = 778,
	FN_HSPI_TX2_A = 779,
	FN_FMIN_B___3 = 780,
	FN_SSI_SCK5___4 = 781,
	FN_RX4_C___4 = 782,
	FN_SSI_WS5___4 = 783,
	FN_TX4_C___4 = 784,
	FN_SSI_SDATA5___4 = 785,
	FN_RX0_D___4 = 786,
	FN_SSI_WS34___5 = 787,
	FN_ARM_TRACEDATA_8___2 = 788,
	FN_SSI_SDATA4___4 = 789,
	FN_SSI_WS2_A___2 = 790,
	FN_ARM_TRACEDATA_9___2 = 791,
	FN_SSI_SDATA3___5 = 792,
	FN_ARM_TRACEDATA_10___2 = 793,
	FN_SSI_SCK012 = 794,
	FN_ARM_TRACEDATA_11___2 = 795,
	FN_TX0_D___4 = 796,
	FN_SSI_WS012 = 797,
	FN_ARM_TRACEDATA_12___2 = 798,
	FN_SSI_SDATA2___4 = 799,
	FN_HSPI_CS2_A = 800,
	FN_ARM_TRACEDATA_13___2 = 801,
	FN_SDA1_A___2 = 802,
	FN_SSI_SDATA1___4 = 803,
	FN_ARM_TRACEDATA_14___2 = 804,
	FN_SCL1_A___2 = 805,
	FN_SCK2_A = 806,
	FN_SSI_SDATA0___4 = 807,
	FN_ARM_TRACEDATA_15___2 = 808,
	FN_SD0_CLK___5 = 809,
	FN_SUB_TDO___2 = 810,
	FN_SD0_CMD___5 = 811,
	FN_SUB_TRST___2 = 812,
	FN_SD0_DAT0___3 = 813,
	FN_SUB_TMS___2 = 814,
	FN_SD0_DAT1___3 = 815,
	FN_SUB_TCK___2 = 816,
	FN_SD0_DAT2___3 = 817,
	FN_SUB_TDI___2 = 818,
	FN_SD0_DAT3___3 = 819,
	FN_IRQ1_B___2 = 820,
	FN_SD0_CD___5 = 821,
	FN_TX5_A___2 = 822,
	FN_SD0_WP___5 = 823,
	FN_RX5_A___2 = 824,
	FN_VI1_CLKENB___5 = 825,
	FN_HSPI_CLK0_A = 826,
	FN_HTX1_A___2 = 827,
	FN_RTS1_C = 828,
	FN_VI1_FIELD___5 = 829,
	FN_HSPI_CS0_A = 830,
	FN_HRX1_A___2 = 831,
	FN_SCK1_C___2 = 832,
	FN_VI1_HSYNC___2 = 833,
	FN_HSPI_RX0_A = 834,
	FN_HRTS1_A = 835,
	FN_FMCLK_A = 836,
	FN_RX1_C___4 = 837,
	FN_VI1_VSYNC___2 = 838,
	FN_HSPI_TX0___2 = 839,
	FN_HCTS1_A = 840,
	FN_BPFCLK_A = 841,
	FN_TX1_C___4 = 842,
	FN_TCLK0___2 = 843,
	FN_HSCK1_A = 844,
	FN_FMIN_A = 845,
	FN_IRQ2_C = 846,
	FN_CTS1_C___2 = 847,
	FN_SPEEDIN___4 = 848,
	FN_VI0_CLK___5 = 849,
	FN_CAN_CLK_A___2 = 850,
	FN_VI0_CLKENB___5 = 851,
	FN_SD2_DAT2_B___2 = 852,
	FN_VI1_DATA0___4 = 853,
	FN_DU1_DG6___5 = 854,
	FN_HSPI_RX1_A = 855,
	FN_RX4_B___4 = 856,
	FN_VI0_FIELD___5 = 857,
	FN_SD2_DAT3_B___2 = 858,
	FN_VI0_R3_C = 859,
	FN_VI1_DATA1___4 = 860,
	FN_DU1_DG7___5 = 861,
	FN_HSPI_CLK1_A = 862,
	FN_TX4_B___4 = 863,
	FN_VI0_HSYNC___2 = 864,
	FN_SD2_CD_B___2 = 865,
	FN_VI1_DATA2___4 = 866,
	FN_DU1_DR2___5 = 867,
	FN_HSPI_CS1_A = 868,
	FN_RX3_B___3 = 869,
	FN_VI0_VSYNC___2 = 870,
	FN_SD2_WP_B___2 = 871,
	FN_VI1_DATA3___4 = 872,
	FN_DU1_DR3___5 = 873,
	FN_HSPI_TX1_A = 874,
	FN_TX3_B___3 = 875,
	FN_VI0_DATA0_VI0_B0___5 = 876,
	FN_DU1_DG2___5 = 877,
	FN_IRQ2_B___2 = 878,
	FN_RX3_D___2 = 879,
	FN_VI0_DATA1_VI0_B1___5 = 880,
	FN_DU1_DG3___5 = 881,
	FN_IRQ3_B___2 = 882,
	FN_TX3_D___2 = 883,
	FN_VI0_DATA2_VI0_B2___5 = 884,
	FN_DU1_DG4___5 = 885,
	FN_RX0_C___4 = 886,
	FN_VI0_DATA3_VI0_B3___5 = 887,
	FN_DU1_DG5___5 = 888,
	FN_TX1_A___2 = 889,
	FN_TX0_C___4 = 890,
	FN_VI0_DATA4_VI0_B4___5 = 891,
	FN_DU1_DB2___5 = 892,
	FN_RX1_A___2 = 893,
	FN_VI0_DATA5_VI0_B5___5 = 894,
	FN_DU1_DB3___5 = 895,
	FN_SCK1_A = 896,
	FN_PWM4___4 = 897,
	FN_HSCK1_B___2 = 898,
	FN_VI0_DATA6_VI0_G0 = 899,
	FN_DU1_DB4___5 = 900,
	FN_CTS1_A = 901,
	FN_PWM5___4 = 902,
	FN_VI0_DATA7_VI0_G1 = 903,
	FN_DU1_DB5___5 = 904,
	FN_RTS1_A = 905,
	FN_VI0_G2___5 = 906,
	FN_SD2_CLK_B___2 = 907,
	FN_VI1_DATA4___4 = 908,
	FN_DU1_DR4___5 = 909,
	FN_HTX1_B___4 = 910,
	FN_VI0_G3___5 = 911,
	FN_SD2_CMD_B___2 = 912,
	FN_VI1_DATA5___4 = 913,
	FN_DU1_DR5___5 = 914,
	FN_HRX1_B___4 = 915,
	FN_VI0_G4___5 = 916,
	FN_SD2_DAT0_B___2 = 917,
	FN_VI1_DATA6___4 = 918,
	FN_DU1_DR6___5 = 919,
	FN_HRTS1_B___2 = 920,
	FN_VI0_G5___5 = 921,
	FN_SD2_DAT1_B___2 = 922,
	FN_VI1_DATA7___4 = 923,
	FN_DU1_DR7___5 = 924,
	FN_HCTS1_B___2 = 925,
	FN_VI0_R0_A = 926,
	FN_VI1_CLK___5 = 927,
	FN_ETH_REF_CLK___2 = 928,
	FN_DU1_DOTCLKIN___5 = 929,
	FN_VI0_R1_A = 930,
	FN_VI1_DATA8___3 = 931,
	FN_DU1_DB6___5 = 932,
	FN_ETH_TXD0___5 = 933,
	FN_PWM2___4 = 934,
	FN_TCLK1___4 = 935,
	FN_VI0_R2_A = 936,
	FN_VI1_DATA9___3 = 937,
	FN_DU1_DB7___5 = 938,
	FN_ETH_TXD1___5 = 939,
	FN_PWM3___4 = 940,
	FN_VI0_R3_A = 941,
	FN_ETH_CRS_DV___5 = 942,
	FN_IECLK___4 = 943,
	FN_SCK2_C___2 = 944,
	FN_VI0_R4_A = 945,
	FN_ETH_TX_EN___5 = 946,
	FN_IETX___4 = 947,
	FN_TX2_C___4 = 948,
	FN_VI0_R5_A = 949,
	FN_ETH_RX_ER___5 = 950,
	FN_FMCLK_C___3 = 951,
	FN_IERX___4 = 952,
	FN_RX2_C___4 = 953,
	FN_VI1_DATA10_A = 954,
	FN_DU1_DOTCLKOUT___2 = 955,
	FN_ETH_RXD0___5 = 956,
	FN_BPFCLK_C___3 = 957,
	FN_TX2_D___2 = 958,
	FN_SDA2_C___3 = 959,
	FN_VI1_DATA11_A = 960,
	FN_DU1_EXHSYNC_DU1_HSYNC___5 = 961,
	FN_ETH_RXD1___5 = 962,
	FN_FMIN_C___3 = 963,
	FN_RX2_D___2 = 964,
	FN_SCL2_C___3 = 965,
	FN_SD2_CLK_A = 966,
	FN_DU1_EXVSYNC_DU1_VSYNC___5 = 967,
	FN_ATARD1___2 = 968,
	FN_ETH_MDC___5 = 969,
	FN_SDA1_B___3 = 970,
	FN_SD2_CMD_A = 971,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE___5 = 972,
	FN_ATAWR1___2 = 973,
	FN_ETH_MDIO___5 = 974,
	FN_SCL1_B___3 = 975,
	FN_SD2_DAT0_A = 976,
	FN_DU1_DISP___5 = 977,
	FN_ATACS01___2 = 978,
	FN_DREQ1_B___2 = 979,
	FN_ETH_LINK___5 = 980,
	FN_CAN1_RX_A___2 = 981,
	FN_SD2_DAT1_A = 982,
	FN_DU1_CDE___5 = 983,
	FN_ATACS11___2 = 984,
	FN_DACK1_B___3 = 985,
	FN_ETH_MAGIC___5 = 986,
	FN_CAN1_TX_A___2 = 987,
	FN_PWM6___4 = 988,
	FN_SD2_DAT2_A = 989,
	FN_VI1_DATA12 = 990,
	FN_DREQ2_B___3 = 991,
	FN_ATADIR1___2 = 992,
	FN_HSPI_CLK2_B___2 = 993,
	FN_GPSCLK_B = 994,
	FN_SD2_DAT3_A = 995,
	FN_VI1_DATA13 = 996,
	FN_DACK2_B___3 = 997,
	FN_ATAG1___2 = 998,
	FN_HSPI_CS2_B___2 = 999,
	FN_GPSIN_B = 1000,
	FN_SD2_CD_A = 1001,
	FN_VI1_DATA14 = 1002,
	FN_EX_WAIT1_B = 1003,
	FN_DREQ0_B___2 = 1004,
	FN_HSPI_RX2_B___2 = 1005,
	FN_REMOCON_A___2 = 1006,
	FN_SD2_WP_A = 1007,
	FN_VI1_DATA15 = 1008,
	FN_EX_WAIT2_B = 1009,
	FN_DACK0_B___2 = 1010,
	FN_HSPI_TX2_B___2 = 1011,
	FN_CAN_CLK_C___5 = 1012,
	FN_SEL_SCIF5_A = 1013,
	FN_SEL_SCIF5_B = 1014,
	FN_SEL_SCIF4_A = 1015,
	FN_SEL_SCIF4_B = 1016,
	FN_SEL_SCIF4_C = 1017,
	FN_SEL_SCIF3_A = 1018,
	FN_SEL_SCIF3_B = 1019,
	FN_SEL_SCIF3_C = 1020,
	FN_SEL_SCIF3_D = 1021,
	FN_SEL_SCIF2_A = 1022,
	FN_SEL_SCIF2_B = 1023,
	FN_SEL_SCIF2_C = 1024,
	FN_SEL_SCIF2_D = 1025,
	FN_SEL_SCIF2_E = 1026,
	FN_SEL_SCIF1_A = 1027,
	FN_SEL_SCIF1_B = 1028,
	FN_SEL_SCIF1_C = 1029,
	FN_SEL_SCIF1_D = 1030,
	FN_SEL_SCIF0_A = 1031,
	FN_SEL_SCIF0_B = 1032,
	FN_SEL_SCIF0_C = 1033,
	FN_SEL_SCIF0_D = 1034,
	FN_SEL_SSI2_A = 1035,
	FN_SEL_SSI2_B = 1036,
	FN_SEL_SSI1_A = 1037,
	FN_SEL_SSI1_B = 1038,
	FN_SEL_VI1_A = 1039,
	FN_SEL_VI1_B = 1040,
	FN_SEL_VI0_A = 1041,
	FN_SEL_VI0_B = 1042,
	FN_SEL_VI0_C = 1043,
	FN_SEL_VI0_D = 1044,
	FN_SEL_SD2_A = 1045,
	FN_SEL_SD2_B = 1046,
	FN_SEL_SD1_A = 1047,
	FN_SEL_SD1_B = 1048,
	FN_SEL_IRQ3_A = 1049,
	FN_SEL_IRQ3_B = 1050,
	FN_SEL_IRQ2_A = 1051,
	FN_SEL_IRQ2_B = 1052,
	FN_SEL_IRQ2_C = 1053,
	FN_SEL_IRQ1_A = 1054,
	FN_SEL_IRQ1_B = 1055,
	FN_SEL_DREQ2_A = 1056,
	FN_SEL_DREQ2_B = 1057,
	FN_SEL_DREQ1_A = 1058,
	FN_SEL_DREQ1_B = 1059,
	FN_SEL_DREQ0_A = 1060,
	FN_SEL_DREQ0_B = 1061,
	FN_SEL_WAIT2_A = 1062,
	FN_SEL_WAIT2_B = 1063,
	FN_SEL_WAIT1_A = 1064,
	FN_SEL_WAIT1_B = 1065,
	FN_SEL_CAN1_A = 1066,
	FN_SEL_CAN1_B = 1067,
	FN_SEL_CAN0_A = 1068,
	FN_SEL_CAN0_B = 1069,
	FN_SEL_CANCLK_A = 1070,
	FN_SEL_CANCLK_B = 1071,
	FN_SEL_CANCLK_C = 1072,
	FN_SEL_CANCLK_D = 1073,
	FN_SEL_HSCIF1_A = 1074,
	FN_SEL_HSCIF1_B = 1075,
	FN_SEL_HSCIF0_A = 1076,
	FN_SEL_HSCIF0_B = 1077,
	FN_SEL_REMOCON_A = 1078,
	FN_SEL_REMOCON_B = 1079,
	FN_SEL_REMOCON_C = 1080,
	FN_SEL_FM_A = 1081,
	FN_SEL_FM_B = 1082,
	FN_SEL_FM_C = 1083,
	FN_SEL_FM_D = 1084,
	FN_SEL_GPS_A = 1085,
	FN_SEL_GPS_B = 1086,
	FN_SEL_GPS_C = 1087,
	FN_SEL_TSIF0_A = 1088,
	FN_SEL_TSIF0_B = 1089,
	FN_SEL_HSPI2_A = 1090,
	FN_SEL_HSPI2_B = 1091,
	FN_SEL_HSPI1_A = 1092,
	FN_SEL_HSPI1_B = 1093,
	FN_SEL_HSPI0_A = 1094,
	FN_SEL_HSPI0_B = 1095,
	FN_SEL_I2C3_A = 1096,
	FN_SEL_I2C3_B = 1097,
	FN_SEL_I2C3_C = 1098,
	FN_SEL_I2C2_A = 1099,
	FN_SEL_I2C2_B = 1100,
	FN_SEL_I2C2_C = 1101,
	FN_SEL_I2C1_A = 1102,
	FN_SEL_I2C1_B = 1103,
	PINMUX_FUNCTION_END___8 = 1104,
	PINMUX_MARK_BEGIN___8 = 1105,
	PENC0_MARK = 1106,
	PENC1_MARK = 1107,
	A1_MARK___6 = 1108,
	A2_MARK___6 = 1109,
	A3_MARK___6 = 1110,
	WE0_MARK = 1111,
	AUDIO_CLKA_MARK___4 = 1112,
	AUDIO_CLKB_MARK___4 = 1113,
	SSI_SCK34_MARK___5 = 1114,
	AVS1_MARK___2 = 1115,
	AVS2_MARK___2 = 1116,
	VI0_R0_C_MARK = 1117,
	VI0_R1_C_MARK = 1118,
	VI0_R2_C_MARK = 1119,
	VI0_R4_C_MARK = 1120,
	VI0_R5_C_MARK = 1121,
	VI0_R0_D_MARK = 1122,
	VI0_R1_D_MARK = 1123,
	VI0_R2_D_MARK = 1124,
	VI0_R3_D_MARK = 1125,
	VI0_R4_D_MARK = 1126,
	VI0_R5_D_MARK = 1127,
	PRESETOUT_MARK = 1128,
	PWM1_MARK___4 = 1129,
	AUDATA0_MARK___2 = 1130,
	ARM_TRACEDATA_0_MARK___2 = 1131,
	GPSCLK_C_MARK = 1132,
	USB_OVC0_MARK___2 = 1133,
	TX2_E_MARK___3 = 1134,
	SDA2_B_MARK___3 = 1135,
	AUDATA1_MARK___2 = 1136,
	ARM_TRACEDATA_1_MARK___2 = 1137,
	GPSIN_C_MARK = 1138,
	USB_OVC1_MARK___2 = 1139,
	RX2_E_MARK___3 = 1140,
	SCL2_B_MARK___3 = 1141,
	SD1_DAT2_A_MARK = 1142,
	MMC_D2_MARK___3 = 1143,
	BS_MARK___4 = 1144,
	ATADIR0_A_MARK = 1145,
	SDSELF_A_MARK = 1146,
	PWM4_B_MARK___4 = 1147,
	SD1_DAT3_A_MARK = 1148,
	MMC_D3_MARK___3 = 1149,
	A0_MARK___8 = 1150,
	ATAG0_A_MARK = 1151,
	REMOCON_B_MARK___4 = 1152,
	A4_MARK___5 = 1153,
	A5_MARK___5 = 1154,
	A6_MARK___6 = 1155,
	A7_MARK___6 = 1156,
	A8_MARK___6 = 1157,
	A9_MARK___6 = 1158,
	A10_MARK___6 = 1159,
	A11_MARK___6 = 1160,
	A12_MARK___6 = 1161,
	A13_MARK___6 = 1162,
	A14_MARK___6 = 1163,
	A15_MARK___6 = 1164,
	A16_MARK___6 = 1165,
	A17_MARK___7 = 1166,
	A18_MARK___7 = 1167,
	A19_MARK___7 = 1168,
	A20_MARK___7 = 1169,
	HSPI_CS1_B_MARK___2 = 1170,
	A21_MARK___7 = 1171,
	HSPI_CLK1_B_MARK___2 = 1172,
	A22_MARK___7 = 1173,
	HRTS0_B_MARK___2 = 1174,
	RX2_B_MARK___4 = 1175,
	DREQ2_A_MARK = 1176,
	A23_MARK___7 = 1177,
	HTX0_B_MARK___4 = 1178,
	TX2_B_MARK___4 = 1179,
	DACK2_A_MARK = 1180,
	TS_SDEN0_A_MARK = 1181,
	SD1_CD_A_MARK = 1182,
	MMC_D6_MARK___3 = 1183,
	A24_MARK___7 = 1184,
	DREQ1_A_MARK = 1185,
	HRX0_B_MARK___4 = 1186,
	TS_SPSYNC0_A_MARK = 1187,
	SD1_WP_A_MARK = 1188,
	MMC_D7_MARK___3 = 1189,
	A25_MARK___7 = 1190,
	DACK1_A_MARK = 1191,
	HCTS0_B_MARK___2 = 1192,
	RX3_C_MARK___3 = 1193,
	TS_SDAT0_A_MARK = 1194,
	CLKOUT_MARK___3 = 1195,
	HSPI_TX1_B_MARK___2 = 1196,
	PWM0_B_MARK___5 = 1197,
	CS0_MARK___3 = 1198,
	HSPI_RX1_B_MARK___2 = 1199,
	SSI_SCK1_B_MARK___4 = 1200,
	ATAG0_B_MARK = 1201,
	CS1_A26_MARK___2 = 1202,
	SDA2_A_MARK___2 = 1203,
	SCK2_B_MARK___2 = 1204,
	MMC_D5_MARK___3 = 1205,
	ATADIR0_B_MARK = 1206,
	RD_WR_MARK___2 = 1207,
	WE1_MARK___2 = 1208,
	ATAWR0_B_MARK = 1209,
	SSI_WS1_B_MARK___4 = 1210,
	EX_CS0_MARK___2 = 1211,
	SCL2_A_MARK___2 = 1212,
	TX3_C_MARK___3 = 1213,
	TS_SCK0_A_MARK = 1214,
	EX_CS1_MARK___2 = 1215,
	MMC_D4_MARK___3 = 1216,
	SD1_CLK_A_MARK = 1217,
	MMC_CLK_MARK___3 = 1218,
	ATACS00_MARK___2 = 1219,
	EX_CS2_MARK___2 = 1220,
	SD1_CMD_A_MARK = 1221,
	MMC_CMD_MARK___3 = 1222,
	ATACS10_MARK___2 = 1223,
	EX_CS3_MARK___2 = 1224,
	SD1_DAT0_A_MARK = 1225,
	MMC_D0_MARK___3 = 1226,
	ATARD0_MARK___2 = 1227,
	EX_CS4_MARK___2 = 1228,
	EX_WAIT1_A_MARK = 1229,
	SD1_DAT1_A_MARK = 1230,
	MMC_D1_MARK___3 = 1231,
	ATAWR0_A_MARK = 1232,
	EX_CS5_MARK___2 = 1233,
	EX_WAIT2_A_MARK = 1234,
	DREQ0_A_MARK = 1235,
	RX3_A_MARK___2 = 1236,
	DACK0_MARK___7 = 1237,
	TX3_A_MARK___2 = 1238,
	DRACK0_MARK___5 = 1239,
	EX_WAIT0_MARK___4 = 1240,
	PWM0_C_MARK___3 = 1241,
	D0_MARK___5 = 1242,
	D1_MARK___5 = 1243,
	D2_MARK___5 = 1244,
	D3_MARK___5 = 1245,
	D4_MARK___5 = 1246,
	D5_MARK___5 = 1247,
	D6_MARK___5 = 1248,
	D7_MARK___5 = 1249,
	D8_MARK___5 = 1250,
	D9_MARK___5 = 1251,
	D10_MARK___5 = 1252,
	D11_MARK___5 = 1253,
	RD_WR_B_MARK = 1254,
	IRQ0_MARK___6 = 1255,
	MLB_CLK_MARK___4 = 1256,
	IRQ1_A_MARK = 1257,
	MLB_SIG_MARK___4 = 1258,
	RX5_B_MARK___4 = 1259,
	SDA3_A_MARK___2 = 1260,
	IRQ2_A_MARK = 1261,
	MLB_DAT_MARK___4 = 1262,
	TX5_B_MARK___4 = 1263,
	SCL3_A_MARK___2 = 1264,
	IRQ3_A_MARK = 1265,
	SDSELF_B_MARK___2 = 1266,
	SD1_CMD_B_MARK = 1267,
	SCIF_CLK_MARK___4 = 1268,
	AUDIO_CLKOUT_B_MARK___4 = 1269,
	CAN_CLK_B_MARK___5 = 1270,
	SDA3_B_MARK___3 = 1271,
	SD1_CLK_B_MARK = 1272,
	HTX0_A_MARK___2 = 1273,
	TX0_A_MARK___2 = 1274,
	SD1_DAT0_B_MARK = 1275,
	HRX0_A_MARK___2 = 1276,
	RX0_A_MARK___2 = 1277,
	SD1_DAT1_B_MARK = 1278,
	HSCK0_MARK___4 = 1279,
	SCK0_MARK___2 = 1280,
	SCL3_B_MARK___3 = 1281,
	SD1_DAT2_B_MARK = 1282,
	HCTS0_A_MARK = 1283,
	CTS0_MARK___2 = 1284,
	SD1_DAT3_B_MARK = 1285,
	HRTS0_A_MARK = 1286,
	RTS0_MARK = 1287,
	SSI_SCK4_MARK___4 = 1288,
	DU0_DR0_MARK___5 = 1289,
	LCDOUT0_MARK___4 = 1290,
	AUDATA2_MARK___2 = 1291,
	ARM_TRACEDATA_2_MARK___2 = 1292,
	SDA3_C_MARK___2 = 1293,
	ADICHS1_MARK___4 = 1294,
	TS_SDEN0_B_MARK___2 = 1295,
	SSI_WS4_MARK___4 = 1296,
	DU0_DR1_MARK___4 = 1297,
	LCDOUT1_MARK___4 = 1298,
	AUDATA3_MARK___2 = 1299,
	ARM_TRACEDATA_3_MARK___2 = 1300,
	SCL3_C_MARK___2 = 1301,
	ADICHS2_MARK___4 = 1302,
	TS_SPSYNC0_B_MARK___2 = 1303,
	DU0_DR2_MARK___5 = 1304,
	LCDOUT2_MARK___4 = 1305,
	DU0_DR3_MARK___5 = 1306,
	LCDOUT3_MARK___4 = 1307,
	DU0_DR4_MARK___5 = 1308,
	LCDOUT4_MARK___4 = 1309,
	DU0_DR5_MARK___5 = 1310,
	LCDOUT5_MARK___4 = 1311,
	DU0_DR6_MARK___5 = 1312,
	LCDOUT6_MARK___4 = 1313,
	DU0_DR7_MARK___5 = 1314,
	LCDOUT7_MARK___4 = 1315,
	DU0_DG0_MARK___5 = 1316,
	LCDOUT8_MARK___4 = 1317,
	AUDATA4_MARK___2 = 1318,
	ARM_TRACEDATA_4_MARK___2 = 1319,
	TX1_D_MARK___3 = 1320,
	CAN0_TX_A_MARK___2 = 1321,
	ADICHS0_MARK___4 = 1322,
	DU0_DG1_MARK___5 = 1323,
	LCDOUT9_MARK___4 = 1324,
	AUDATA5_MARK___2 = 1325,
	ARM_TRACEDATA_5_MARK___2 = 1326,
	RX1_D_MARK___3 = 1327,
	CAN0_RX_A_MARK___2 = 1328,
	ADIDATA_MARK___4 = 1329,
	DU0_DG2_MARK___5 = 1330,
	LCDOUT10_MARK___4 = 1331,
	DU0_DG3_MARK___5 = 1332,
	LCDOUT11_MARK___4 = 1333,
	DU0_DG4_MARK___5 = 1334,
	LCDOUT12_MARK___4 = 1335,
	RX0_B_MARK___4 = 1336,
	DU0_DG5_MARK___5 = 1337,
	LCDOUT13_MARK___4 = 1338,
	TX0_B_MARK___4 = 1339,
	DU0_DG6_MARK___5 = 1340,
	LCDOUT14_MARK___4 = 1341,
	RX4_A_MARK___2 = 1342,
	DU0_DG7_MARK___5 = 1343,
	LCDOUT15_MARK___4 = 1344,
	TX4_A_MARK___2 = 1345,
	SSI_SCK2_B_MARK___3 = 1346,
	VI0_R0_B_MARK = 1347,
	DU0_DB0_MARK___5 = 1348,
	LCDOUT16_MARK___4 = 1349,
	AUDATA6_MARK___2 = 1350,
	ARM_TRACEDATA_6_MARK___2 = 1351,
	GPSCLK_A_MARK = 1352,
	PWM0_A_MARK___2 = 1353,
	ADICLK_MARK___4 = 1354,
	TS_SDAT0_B_MARK = 1355,
	AUDIO_CLKC_MARK___4 = 1356,
	VI0_R1_B_MARK = 1357,
	DU0_DB1_MARK___5 = 1358,
	LCDOUT17_MARK___4 = 1359,
	AUDATA7_MARK___2 = 1360,
	ARM_TRACEDATA_7_MARK___2 = 1361,
	GPSIN_A_MARK = 1362,
	ADICS_SAMP_MARK___4 = 1363,
	TS_SCK0_B_MARK___2 = 1364,
	VI0_R2_B_MARK = 1365,
	DU0_DB2_MARK___5 = 1366,
	LCDOUT18_MARK___4 = 1367,
	VI0_R3_B_MARK = 1368,
	DU0_DB3_MARK___5 = 1369,
	LCDOUT19_MARK___4 = 1370,
	VI0_R4_B_MARK = 1371,
	DU0_DB4_MARK___5 = 1372,
	LCDOUT20_MARK___4 = 1373,
	VI0_R5_B_MARK = 1374,
	DU0_DB5_MARK___5 = 1375,
	LCDOUT21_MARK___4 = 1376,
	VI1_DATA10_B_MARK = 1377,
	DU0_DB6_MARK___5 = 1378,
	LCDOUT22_MARK___4 = 1379,
	VI1_DATA11_B_MARK = 1380,
	DU0_DB7_MARK___5 = 1381,
	LCDOUT23_MARK___4 = 1382,
	DU0_DOTCLKIN_MARK___6 = 1383,
	QSTVA_QVS_MARK___4 = 1384,
	DU0_DOTCLKO_UT0_MARK = 1385,
	QCLK_MARK___4 = 1386,
	DU0_DOTCLKO_UT1_MARK = 1387,
	QSTVB_QVE_MARK___4 = 1388,
	AUDIO_CLKOUT_A_MARK___2 = 1389,
	REMOCON_C_MARK = 1390,
	SSI_WS2_B_MARK___3 = 1391,
	DU0_EXHSYNC_DU0_HSYNC_MARK___4 = 1392,
	QSTH_QHS_MARK___4 = 1393,
	DU0_EXVSYNC_DU0_VSYNC_MARK___4 = 1394,
	QSTB_QHE_MARK___4 = 1395,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK___4 = 1396,
	QCPV_QDE_MARK___4 = 1397,
	FMCLK_D_MARK___3 = 1398,
	SSI_SCK1_A_MARK___2 = 1399,
	DU0_DISP_MARK___4 = 1400,
	QPOLA_MARK___4 = 1401,
	AUDCK_MARK___2 = 1402,
	ARM_TRACECLK_MARK = 1403,
	BPFCLK_D_MARK___3 = 1404,
	SSI_WS1_A_MARK___2 = 1405,
	DU0_CDE_MARK___5 = 1406,
	QPOLB_MARK___4 = 1407,
	AUDSYNC_MARK___2 = 1408,
	ARM_TRACECTL_MARK = 1409,
	FMIN_D_MARK___3 = 1410,
	SD1_CD_B_MARK = 1411,
	SSI_SCK78_MARK___4 = 1412,
	HSPI_RX0_B_MARK = 1413,
	TX1_B_MARK___4 = 1414,
	SD1_WP_B_MARK = 1415,
	SSI_WS78_MARK___4 = 1416,
	HSPI_CLK0_B_MARK = 1417,
	RX1_B_MARK___4 = 1418,
	CAN_CLK_D_MARK___4 = 1419,
	SSI_SDATA8_MARK___4 = 1420,
	SSI_SCK2_A_MARK___2 = 1421,
	HSPI_CS0_B_MARK = 1422,
	TX2_A_MARK___2 = 1423,
	CAN0_TX_B_MARK___5 = 1424,
	SSI_SDATA7_MARK___4 = 1425,
	HSPI_TX0_B_MARK = 1426,
	RX2_A_MARK___2 = 1427,
	CAN0_RX_B_MARK___5 = 1428,
	SSI_SCK6_MARK___4 = 1429,
	HSPI_RX2_A_MARK = 1430,
	FMCLK_B_MARK___3 = 1431,
	CAN1_TX_B_MARK___4 = 1432,
	SSI_WS6_MARK___4 = 1433,
	HSPI_CLK2_A_MARK = 1434,
	BPFCLK_B_MARK___3 = 1435,
	CAN1_RX_B_MARK___4 = 1436,
	SSI_SDATA6_MARK___4 = 1437,
	HSPI_TX2_A_MARK = 1438,
	FMIN_B_MARK___3 = 1439,
	SSI_SCK5_MARK___4 = 1440,
	RX4_C_MARK___4 = 1441,
	SSI_WS5_MARK___4 = 1442,
	TX4_C_MARK___4 = 1443,
	SSI_SDATA5_MARK___4 = 1444,
	RX0_D_MARK___4 = 1445,
	SSI_WS34_MARK___5 = 1446,
	ARM_TRACEDATA_8_MARK___2 = 1447,
	SSI_SDATA4_MARK___4 = 1448,
	SSI_WS2_A_MARK___2 = 1449,
	ARM_TRACEDATA_9_MARK___2 = 1450,
	SSI_SDATA3_MARK___5 = 1451,
	ARM_TRACEDATA_10_MARK___2 = 1452,
	SSI_SCK012_MARK = 1453,
	ARM_TRACEDATA_11_MARK___2 = 1454,
	TX0_D_MARK___4 = 1455,
	SSI_WS012_MARK = 1456,
	ARM_TRACEDATA_12_MARK___2 = 1457,
	SSI_SDATA2_MARK___4 = 1458,
	HSPI_CS2_A_MARK = 1459,
	ARM_TRACEDATA_13_MARK___2 = 1460,
	SDA1_A_MARK___2 = 1461,
	SSI_SDATA1_MARK___4 = 1462,
	ARM_TRACEDATA_14_MARK___2 = 1463,
	SCL1_A_MARK___2 = 1464,
	SCK2_A_MARK = 1465,
	SSI_SDATA0_MARK___4 = 1466,
	ARM_TRACEDATA_15_MARK___2 = 1467,
	SD0_CLK_MARK___5 = 1468,
	SUB_TDO_MARK___2 = 1469,
	SD0_CMD_MARK___5 = 1470,
	SUB_TRST_MARK___2 = 1471,
	SD0_DAT0_MARK___3 = 1472,
	SUB_TMS_MARK___2 = 1473,
	SD0_DAT1_MARK___3 = 1474,
	SUB_TCK_MARK___2 = 1475,
	SD0_DAT2_MARK___3 = 1476,
	SUB_TDI_MARK___2 = 1477,
	SD0_DAT3_MARK___3 = 1478,
	IRQ1_B_MARK___2 = 1479,
	SD0_CD_MARK___5 = 1480,
	TX5_A_MARK___2 = 1481,
	SD0_WP_MARK___5 = 1482,
	RX5_A_MARK___2 = 1483,
	VI1_CLKENB_MARK___5 = 1484,
	HSPI_CLK0_A_MARK = 1485,
	HTX1_A_MARK___2 = 1486,
	RTS1_C_MARK = 1487,
	VI1_FIELD_MARK___5 = 1488,
	HSPI_CS0_A_MARK = 1489,
	HRX1_A_MARK___2 = 1490,
	SCK1_C_MARK___2 = 1491,
	VI1_HSYNC_MARK___2 = 1492,
	HSPI_RX0_A_MARK = 1493,
	HRTS1_A_MARK = 1494,
	FMCLK_A_MARK = 1495,
	RX1_C_MARK___4 = 1496,
	VI1_VSYNC_MARK___2 = 1497,
	HSPI_TX0_MARK___2 = 1498,
	HCTS1_A_MARK = 1499,
	BPFCLK_A_MARK = 1500,
	TX1_C_MARK___4 = 1501,
	TCLK0_MARK___2 = 1502,
	HSCK1_A_MARK = 1503,
	FMIN_A_MARK = 1504,
	IRQ2_C_MARK = 1505,
	CTS1_C_MARK___2 = 1506,
	SPEEDIN_MARK___4 = 1507,
	VI0_CLK_MARK___5 = 1508,
	CAN_CLK_A_MARK___2 = 1509,
	VI0_CLKENB_MARK___5 = 1510,
	SD2_DAT2_B_MARK___2 = 1511,
	VI1_DATA0_MARK___4 = 1512,
	DU1_DG6_MARK___5 = 1513,
	HSPI_RX1_A_MARK = 1514,
	RX4_B_MARK___4 = 1515,
	VI0_FIELD_MARK___5 = 1516,
	SD2_DAT3_B_MARK___2 = 1517,
	VI0_R3_C_MARK = 1518,
	VI1_DATA1_MARK___4 = 1519,
	DU1_DG7_MARK___5 = 1520,
	HSPI_CLK1_A_MARK = 1521,
	TX4_B_MARK___4 = 1522,
	VI0_HSYNC_MARK___2 = 1523,
	SD2_CD_B_MARK___2 = 1524,
	VI1_DATA2_MARK___4 = 1525,
	DU1_DR2_MARK___5 = 1526,
	HSPI_CS1_A_MARK = 1527,
	RX3_B_MARK___3 = 1528,
	VI0_VSYNC_MARK___2 = 1529,
	SD2_WP_B_MARK___2 = 1530,
	VI1_DATA3_MARK___4 = 1531,
	DU1_DR3_MARK___5 = 1532,
	HSPI_TX1_A_MARK = 1533,
	TX3_B_MARK___3 = 1534,
	VI0_DATA0_VI0_B0_MARK___5 = 1535,
	DU1_DG2_MARK___5 = 1536,
	IRQ2_B_MARK___2 = 1537,
	RX3_D_MARK___2 = 1538,
	VI0_DATA1_VI0_B1_MARK___5 = 1539,
	DU1_DG3_MARK___5 = 1540,
	IRQ3_B_MARK___2 = 1541,
	TX3_D_MARK___2 = 1542,
	VI0_DATA2_VI0_B2_MARK___5 = 1543,
	DU1_DG4_MARK___5 = 1544,
	RX0_C_MARK___4 = 1545,
	VI0_DATA3_VI0_B3_MARK___5 = 1546,
	DU1_DG5_MARK___5 = 1547,
	TX1_A_MARK___2 = 1548,
	TX0_C_MARK___4 = 1549,
	VI0_DATA4_VI0_B4_MARK___5 = 1550,
	DU1_DB2_MARK___5 = 1551,
	RX1_A_MARK___2 = 1552,
	VI0_DATA5_VI0_B5_MARK___5 = 1553,
	DU1_DB3_MARK___5 = 1554,
	SCK1_A_MARK = 1555,
	PWM4_MARK___4 = 1556,
	HSCK1_B_MARK___2 = 1557,
	VI0_DATA6_VI0_G0_MARK = 1558,
	DU1_DB4_MARK___5 = 1559,
	CTS1_A_MARK = 1560,
	PWM5_MARK___4 = 1561,
	VI0_DATA7_VI0_G1_MARK = 1562,
	DU1_DB5_MARK___5 = 1563,
	RTS1_A_MARK = 1564,
	VI0_G2_MARK___5 = 1565,
	SD2_CLK_B_MARK___2 = 1566,
	VI1_DATA4_MARK___4 = 1567,
	DU1_DR4_MARK___5 = 1568,
	HTX1_B_MARK___4 = 1569,
	VI0_G3_MARK___5 = 1570,
	SD2_CMD_B_MARK___2 = 1571,
	VI1_DATA5_MARK___4 = 1572,
	DU1_DR5_MARK___5 = 1573,
	HRX1_B_MARK___4 = 1574,
	VI0_G4_MARK___5 = 1575,
	SD2_DAT0_B_MARK___2 = 1576,
	VI1_DATA6_MARK___4 = 1577,
	DU1_DR6_MARK___5 = 1578,
	HRTS1_B_MARK___2 = 1579,
	VI0_G5_MARK___5 = 1580,
	SD2_DAT1_B_MARK___2 = 1581,
	VI1_DATA7_MARK___4 = 1582,
	DU1_DR7_MARK___5 = 1583,
	HCTS1_B_MARK___2 = 1584,
	VI0_R0_A_MARK = 1585,
	VI1_CLK_MARK___5 = 1586,
	ETH_REF_CLK_MARK___2 = 1587,
	DU1_DOTCLKIN_MARK___5 = 1588,
	VI0_R1_A_MARK = 1589,
	VI1_DATA8_MARK___3 = 1590,
	DU1_DB6_MARK___5 = 1591,
	ETH_TXD0_MARK___5 = 1592,
	PWM2_MARK___4 = 1593,
	TCLK1_MARK___4 = 1594,
	VI0_R2_A_MARK = 1595,
	VI1_DATA9_MARK___3 = 1596,
	DU1_DB7_MARK___5 = 1597,
	ETH_TXD1_MARK___5 = 1598,
	PWM3_MARK___4 = 1599,
	VI0_R3_A_MARK = 1600,
	ETH_CRS_DV_MARK___5 = 1601,
	IECLK_MARK___4 = 1602,
	SCK2_C_MARK___2 = 1603,
	VI0_R4_A_MARK = 1604,
	ETH_TX_EN_MARK___5 = 1605,
	IETX_MARK___4 = 1606,
	TX2_C_MARK___4 = 1607,
	VI0_R5_A_MARK = 1608,
	ETH_RX_ER_MARK___5 = 1609,
	FMCLK_C_MARK___3 = 1610,
	IERX_MARK___4 = 1611,
	RX2_C_MARK___4 = 1612,
	VI1_DATA10_A_MARK = 1613,
	DU1_DOTCLKOUT_MARK___2 = 1614,
	ETH_RXD0_MARK___5 = 1615,
	BPFCLK_C_MARK___3 = 1616,
	TX2_D_MARK___2 = 1617,
	SDA2_C_MARK___3 = 1618,
	VI1_DATA11_A_MARK = 1619,
	DU1_EXHSYNC_DU1_HSYNC_MARK___5 = 1620,
	ETH_RXD1_MARK___5 = 1621,
	FMIN_C_MARK___3 = 1622,
	RX2_D_MARK___2 = 1623,
	SCL2_C_MARK___3 = 1624,
	SD2_CLK_A_MARK = 1625,
	DU1_EXVSYNC_DU1_VSYNC_MARK___5 = 1626,
	ATARD1_MARK___2 = 1627,
	ETH_MDC_MARK___5 = 1628,
	SDA1_B_MARK___3 = 1629,
	SD2_CMD_A_MARK = 1630,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK___5 = 1631,
	ATAWR1_MARK___2 = 1632,
	ETH_MDIO_MARK___5 = 1633,
	SCL1_B_MARK___3 = 1634,
	SD2_DAT0_A_MARK = 1635,
	DU1_DISP_MARK___5 = 1636,
	ATACS01_MARK___2 = 1637,
	DREQ1_B_MARK___2 = 1638,
	ETH_LINK_MARK___5 = 1639,
	CAN1_RX_A_MARK___2 = 1640,
	SD2_DAT1_A_MARK = 1641,
	DU1_CDE_MARK___5 = 1642,
	ATACS11_MARK___2 = 1643,
	DACK1_B_MARK___3 = 1644,
	ETH_MAGIC_MARK___5 = 1645,
	CAN1_TX_A_MARK___2 = 1646,
	PWM6_MARK___4 = 1647,
	SD2_DAT2_A_MARK = 1648,
	VI1_DATA12_MARK = 1649,
	DREQ2_B_MARK___3 = 1650,
	ATADIR1_MARK___2 = 1651,
	HSPI_CLK2_B_MARK___2 = 1652,
	GPSCLK_B_MARK = 1653,
	SD2_DAT3_A_MARK = 1654,
	VI1_DATA13_MARK = 1655,
	DACK2_B_MARK___3 = 1656,
	ATAG1_MARK___2 = 1657,
	HSPI_CS2_B_MARK___2 = 1658,
	GPSIN_B_MARK = 1659,
	SD2_CD_A_MARK = 1660,
	VI1_DATA14_MARK = 1661,
	EX_WAIT1_B_MARK = 1662,
	DREQ0_B_MARK___2 = 1663,
	HSPI_RX2_B_MARK___2 = 1664,
	REMOCON_A_MARK___2 = 1665,
	SD2_WP_A_MARK = 1666,
	VI1_DATA15_MARK = 1667,
	EX_WAIT2_B_MARK = 1668,
	DACK0_B_MARK___2 = 1669,
	HSPI_TX2_B_MARK___2 = 1670,
	CAN_CLK_C_MARK___5 = 1671,
	PINMUX_MARK_END___8 = 1672,
};

enum {
	PINMUX_RESERVED___9 = 0,
	PINMUX_DATA_BEGIN___9 = 1,
	PORT0_DATA___4 = 2,
	PORT1_DATA___4 = 3,
	PORT2_DATA___4 = 4,
	PORT3_DATA___4 = 5,
	PORT4_DATA___4 = 6,
	PORT5_DATA___4 = 7,
	PORT6_DATA___4 = 8,
	PORT7_DATA___4 = 9,
	PORT8_DATA___4 = 10,
	PORT9_DATA___4 = 11,
	PORT10_DATA___4 = 12,
	PORT11_DATA___4 = 13,
	PORT12_DATA___4 = 14,
	PORT13_DATA___4 = 15,
	PORT14_DATA___4 = 16,
	PORT15_DATA___4 = 17,
	PORT16_DATA___4 = 18,
	PORT17_DATA___4 = 19,
	PORT18_DATA___4 = 20,
	PORT19_DATA___4 = 21,
	PORT20_DATA___4 = 22,
	PORT21_DATA___4 = 23,
	PORT22_DATA___4 = 24,
	PORT23_DATA___4 = 25,
	PORT24_DATA___4 = 26,
	PORT25_DATA___4 = 27,
	PORT26_DATA___4 = 28,
	PORT27_DATA___4 = 29,
	PORT28_DATA___4 = 30,
	PORT29_DATA___4 = 31,
	PORT30_DATA___4 = 32,
	PORT31_DATA___3 = 33,
	PORT32_DATA___4 = 34,
	PORT33_DATA___4 = 35,
	PORT34_DATA___4 = 36,
	PORT35_DATA___4 = 37,
	PORT36_DATA___4 = 38,
	PORT37_DATA___4 = 39,
	PORT38_DATA___4 = 40,
	PORT39_DATA___4 = 41,
	PORT40_DATA___4 = 42,
	PORT41_DATA___3 = 43,
	PORT42_DATA___3 = 44,
	PORT43_DATA___3 = 45,
	PORT44_DATA___3 = 46,
	PORT45_DATA___3 = 47,
	PORT46_DATA___3 = 48,
	PORT47_DATA___3 = 49,
	PORT48_DATA___3 = 50,
	PORT49_DATA___3 = 51,
	PORT50_DATA___3 = 52,
	PORT51_DATA___3 = 53,
	PORT52_DATA___3 = 54,
	PORT53_DATA___3 = 55,
	PORT54_DATA___3 = 56,
	PORT55_DATA___3 = 57,
	PORT56_DATA___3 = 58,
	PORT57_DATA___3 = 59,
	PORT58_DATA___3 = 60,
	PORT59_DATA___3 = 61,
	PORT60_DATA___3 = 62,
	PORT61_DATA___3 = 63,
	PORT62_DATA___3 = 64,
	PORT63_DATA___3 = 65,
	PORT64_DATA___4 = 66,
	PORT65_DATA___4 = 67,
	PORT66_DATA___4 = 68,
	PORT67_DATA___4 = 69,
	PORT68_DATA___4 = 70,
	PORT69_DATA___4 = 71,
	PORT70_DATA___4 = 72,
	PORT71_DATA___4 = 73,
	PORT72_DATA___4 = 74,
	PORT73_DATA___4 = 75,
	PORT74_DATA___4 = 76,
	PORT75_DATA___4 = 77,
	PORT76_DATA___4 = 78,
	PORT77_DATA___4 = 79,
	PORT78_DATA___4 = 80,
	PORT79_DATA___4 = 81,
	PORT80_DATA___4 = 82,
	PORT81_DATA___4 = 83,
	PORT82_DATA___4 = 84,
	PORT83_DATA___4 = 85,
	PORT84_DATA___4 = 86,
	PORT85_DATA___4 = 87,
	PORT86_DATA___3 = 88,
	PORT87_DATA___3 = 89,
	PORT88_DATA___3 = 90,
	PORT89_DATA___3 = 91,
	PORT90_DATA___3 = 92,
	PORT91_DATA___3 = 93,
	PORT92_DATA___3 = 94,
	PORT93_DATA___3 = 95,
	PORT94_DATA___3 = 96,
	PORT95_DATA___3 = 97,
	PORT96_DATA___4 = 98,
	PORT97_DATA___4 = 99,
	PORT98_DATA___4 = 100,
	PORT99_DATA___4 = 101,
	PORT100_DATA___4 = 102,
	PORT101_DATA___4 = 103,
	PORT102_DATA___4 = 104,
	PORT103_DATA___4 = 105,
	PORT104_DATA___4 = 106,
	PORT105_DATA___4 = 107,
	PORT106_DATA___4 = 108,
	PORT107_DATA___4 = 109,
	PORT108_DATA___4 = 110,
	PORT109_DATA___4 = 111,
	PORT110_DATA___4 = 112,
	PORT111_DATA___4 = 113,
	PORT112_DATA___4 = 114,
	PORT113_DATA___4 = 115,
	PORT114_DATA___4 = 116,
	PORT115_DATA___4 = 117,
	PORT116_DATA___4 = 118,
	PORT117_DATA___4 = 119,
	PORT118_DATA___4 = 120,
	PORT119_DATA___3 = 121,
	PORT120_DATA___3 = 122,
	PORT121_DATA___3 = 123,
	PORT122_DATA___3 = 124,
	PORT123_DATA___3 = 125,
	PORT124_DATA___3 = 126,
	PORT125_DATA___3 = 127,
	PORT126_DATA___3 = 128,
	PORT127_DATA___2 = 129,
	PORT128_DATA___4 = 130,
	PORT129_DATA___4 = 131,
	PORT130_DATA___4 = 132,
	PORT131_DATA___4 = 133,
	PORT132_DATA___4 = 134,
	PORT133_DATA___4 = 135,
	PORT134_DATA___4 = 136,
	PORT135_DATA___3 = 137,
	PORT136_DATA___3 = 138,
	PORT137_DATA___3 = 139,
	PORT138_DATA___3 = 140,
	PORT139_DATA___3 = 141,
	PORT140_DATA___3 = 142,
	PORT141_DATA___3 = 143,
	PORT142_DATA___3 = 144,
	PORT143_DATA___3 = 145,
	PORT144_DATA___3 = 146,
	PORT145_DATA___3 = 147,
	PORT146_DATA___3 = 148,
	PORT147_DATA___3 = 149,
	PORT148_DATA___3 = 150,
	PORT149_DATA___3 = 151,
	PORT150_DATA___3 = 152,
	PORT151_DATA___3 = 153,
	PORT152_DATA___3 = 154,
	PORT153_DATA___3 = 155,
	PORT154_DATA___3 = 156,
	PORT155_DATA___3 = 157,
	PORT156_DATA___3 = 158,
	PORT157_DATA___3 = 159,
	PORT158_DATA___3 = 160,
	PINMUX_DATA_END___9 = 161,
	PINMUX_FUNCTION_BEGIN___9 = 162,
	PORT0_FN = 163,
	PORT1_FN = 164,
	PORT2_FN = 165,
	PORT3_FN = 166,
	PORT4_FN = 167,
	PORT5_FN = 168,
	PORT6_FN = 169,
	PORT7_FN = 170,
	PORT8_FN = 171,
	PORT9_FN = 172,
	PORT10_FN = 173,
	PORT11_FN = 174,
	PORT12_FN = 175,
	PORT13_FN = 176,
	PORT14_FN = 177,
	PORT15_FN = 178,
	PORT16_FN = 179,
	PORT17_FN = 180,
	PORT18_FN = 181,
	PORT19_FN = 182,
	PORT20_FN = 183,
	PORT21_FN = 184,
	PORT22_FN = 185,
	PORT23_FN = 186,
	PORT24_FN = 187,
	PORT25_FN = 188,
	PORT26_FN = 189,
	PORT27_FN = 190,
	PORT28_FN = 191,
	PORT29_FN = 192,
	PORT30_FN = 193,
	PORT31_FN = 194,
	PORT32_FN = 195,
	PORT33_FN = 196,
	PORT34_FN = 197,
	PORT35_FN = 198,
	PORT36_FN = 199,
	PORT37_FN = 200,
	PORT38_FN = 201,
	PORT39_FN = 202,
	PORT40_FN = 203,
	PORT41_FN = 204,
	PORT42_FN = 205,
	PORT43_FN = 206,
	PORT44_FN = 207,
	PORT45_FN = 208,
	PORT46_FN = 209,
	PORT47_FN = 210,
	PORT48_FN = 211,
	PORT49_FN = 212,
	PORT50_FN = 213,
	PORT51_FN = 214,
	PORT52_FN = 215,
	PORT53_FN = 216,
	PORT54_FN = 217,
	PORT55_FN = 218,
	PORT56_FN = 219,
	PORT57_FN = 220,
	PORT58_FN = 221,
	PORT59_FN = 222,
	PORT60_FN = 223,
	PORT61_FN = 224,
	PORT62_FN = 225,
	PORT63_FN = 226,
	PORT64_FN = 227,
	PORT65_FN = 228,
	PORT66_FN = 229,
	PORT67_FN = 230,
	PORT68_FN = 231,
	PORT69_FN = 232,
	PORT70_FN = 233,
	PORT71_FN = 234,
	PORT72_FN = 235,
	PORT73_FN = 236,
	PORT74_FN = 237,
	PORT75_FN = 238,
	PORT76_FN = 239,
	PORT77_FN = 240,
	PORT78_FN = 241,
	PORT79_FN = 242,
	PORT80_FN = 243,
	PORT81_FN = 244,
	PORT82_FN = 245,
	PORT83_FN = 246,
	PORT84_FN = 247,
	PORT85_FN = 248,
	PORT86_FN = 249,
	PORT87_FN = 250,
	PORT88_FN = 251,
	PORT89_FN = 252,
	PORT90_FN = 253,
	PORT91_FN = 254,
	PORT92_FN = 255,
	PORT93_FN = 256,
	PORT94_FN = 257,
	PORT95_FN = 258,
	PORT96_FN = 259,
	PORT97_FN = 260,
	PORT98_FN = 261,
	PORT99_FN = 262,
	PORT100_FN = 263,
	PORT101_FN = 264,
	PORT102_FN = 265,
	PORT103_FN = 266,
	PORT104_FN = 267,
	PORT105_FN = 268,
	PORT106_FN = 269,
	PORT107_FN = 270,
	PORT108_FN = 271,
	PORT109_FN = 272,
	PORT110_FN = 273,
	PORT111_FN = 274,
	PORT112_FN = 275,
	PORT113_FN = 276,
	PORT114_FN = 277,
	PORT115_FN = 278,
	PORT116_FN = 279,
	PORT117_FN = 280,
	PORT118_FN = 281,
	PORT119_FN = 282,
	PORT120_FN = 283,
	PORT121_FN = 284,
	PORT122_FN = 285,
	PORT123_FN = 286,
	PORT124_FN = 287,
	PORT125_FN = 288,
	PORT126_FN = 289,
	PORT127_FN = 290,
	PORT128_FN = 291,
	PORT129_FN = 292,
	PORT130_FN = 293,
	PORT131_FN = 294,
	PORT132_FN = 295,
	PORT133_FN = 296,
	PORT134_FN = 297,
	PORT135_FN = 298,
	PORT136_FN = 299,
	PORT137_FN = 300,
	PORT138_FN = 301,
	PORT139_FN = 302,
	PORT140_FN = 303,
	PORT141_FN = 304,
	PORT142_FN = 305,
	PORT143_FN = 306,
	PORT144_FN = 307,
	PORT145_FN = 308,
	PORT146_FN = 309,
	PORT147_FN = 310,
	PORT148_FN = 311,
	PORT149_FN = 312,
	PORT150_FN = 313,
	PORT151_FN = 314,
	PORT152_FN = 315,
	PORT153_FN = 316,
	PORT154_FN = 317,
	PORT155_FN = 318,
	PORT156_FN = 319,
	PORT157_FN = 320,
	PORT158_FN = 321,
	FN_LCD3_1_0_PORT18 = 322,
	FN_LCD3_1_0_PORT20 = 323,
	FN_LCD3_1_0_PORT21 = 324,
	FN_LCD3_1_0_PORT22 = 325,
	FN_LCD3_1_0_PORT23 = 326,
	FN_JT_SEL = 327,
	FN_ERR_RST_REQB = 328,
	FN_REF_CLKO = 329,
	FN_EXT_CLKI = 330,
	FN_LCD3_PXCLKB = 331,
	FN_LCD3_9_8_PORT38 = 332,
	FN_LCD3_9_8_PORT39 = 333,
	FN_LCD3_11_10_PORT40 = 334,
	FN_LCD3_11_10_PORT41 = 335,
	FN_LCD3_11_10_PORT42 = 336,
	FN_LCD3_11_10_PORT43 = 337,
	FN_IIC_1_0_PORT46 = 338,
	FN_IIC_1_0_PORT47 = 339,
	FN_LCD3_R0 = 340,
	FN_LCD3_R1 = 341,
	FN_LCD3_R2 = 342,
	FN_LCD3_R3 = 343,
	FN_LCD3_R4 = 344,
	FN_LCD3_R5 = 345,
	FN_IIC0_SCL___3 = 346,
	FN_IIC0_SDA___3 = 347,
	FN_SD_CKI = 348,
	FN_SDI0_CKO = 349,
	FN_SDI0_CKI = 350,
	FN_SDI0_CMD = 351,
	FN_SDI0_DATA0 = 352,
	FN_SDI0_DATA1 = 353,
	FN_SDI0_DATA2 = 354,
	FN_SDI0_DATA3 = 355,
	FN_SDI0_DATA4 = 356,
	FN_SDI0_DATA5 = 357,
	FN_SDI0_DATA6 = 358,
	FN_SDI0_DATA7 = 359,
	FN_SDI1_CKO = 360,
	FN_SDI1_CKI = 361,
	FN_SDI1_CMD = 362,
	FN_AB_1_0_PORT71 = 363,
	FN_AB_1_0_PORT72 = 364,
	FN_AB_1_0_PORT73 = 365,
	FN_AB_1_0_PORT74 = 366,
	FN_AB_1_0_PORT75 = 367,
	FN_AB_1_0_PORT76 = 368,
	FN_AB_1_0_PORT77 = 369,
	FN_AB_1_0_PORT78 = 370,
	FN_AB_1_0_PORT79 = 371,
	FN_AB_1_0_PORT80 = 372,
	FN_AB_1_0_PORT81 = 373,
	FN_AB_1_0_PORT82 = 374,
	FN_AB_1_0_PORT83 = 375,
	FN_AB_1_0_PORT84 = 376,
	FN_AB_3_2_PORT85 = 377,
	FN_AB_3_2_PORT86 = 378,
	FN_AB_3_2_PORT87 = 379,
	FN_AB_3_2_PORT88 = 380,
	FN_AB_5_4_PORT89 = 381,
	FN_AB_5_4_PORT90 = 382,
	FN_AB_7_6_PORT91 = 383,
	FN_AB_7_6_PORT92 = 384,
	FN_AB_1_0_PORT93 = 385,
	FN_AB_1_0_PORT94 = 386,
	FN_AB_1_0_PORT95 = 387,
	FN_SDI1_DATA0 = 388,
	FN_SDI1_DATA1 = 389,
	FN_SDI1_DATA2 = 390,
	FN_SDI1_DATA3 = 391,
	FN_AB_CLK = 392,
	FN_AB_CSB0 = 393,
	FN_AB_CSB1 = 394,
	FN_AB_13_12_PORT104 = 395,
	FN_AB_13_12_PORT103 = 396,
	FN_AB_11_10_PORT102 = 397,
	FN_AB_11_10_PORT101 = 398,
	FN_AB_11_10_PORT100 = 399,
	FN_AB_9_8_PORT99 = 400,
	FN_AB_9_8_PORT98 = 401,
	FN_AB_9_8_PORT97 = 402,
	FN_USI_1_0_PORT109 = 403,
	FN_USI_1_0_PORT110 = 404,
	FN_USI_1_0_PORT111 = 405,
	FN_USI_1_0_PORT112 = 406,
	FN_USI_3_2_PORT113 = 407,
	FN_USI_3_2_PORT114 = 408,
	FN_USI_5_4_PORT115 = 409,
	FN_USI_5_4_PORT116 = 410,
	FN_USI_5_4_PORT117 = 411,
	FN_USI_5_4_PORT118 = 412,
	FN_USI_7_6_PORT119 = 413,
	FN_USI_9_8_PORT120 = 414,
	FN_USI_9_8_PORT121 = 415,
	FN_AB_A20 = 416,
	FN_USI0_CS1 = 417,
	FN_USI0_CS2 = 418,
	FN_USI1_DI = 419,
	FN_USI1_DO = 420,
	FN_NTSC_CLK = 421,
	FN_NTSC_DATA0 = 422,
	FN_NTSC_DATA1 = 423,
	FN_NTSC_DATA2 = 424,
	FN_NTSC_DATA3 = 425,
	FN_NTSC_DATA4 = 426,
	FN_HSI_1_0_PORT143 = 427,
	FN_HSI_1_0_PORT144 = 428,
	FN_HSI_1_0_PORT145 = 429,
	FN_HSI_1_0_PORT146 = 430,
	FN_HSI_1_0_PORT147 = 431,
	FN_HSI_1_0_PORT148 = 432,
	FN_HSI_1_0_PORT149 = 433,
	FN_HSI_1_0_PORT150 = 434,
	FN_UART_1_0_PORT157 = 435,
	FN_UART_1_0_PORT158 = 436,
	FN_NTSC_DATA5 = 437,
	FN_NTSC_DATA6 = 438,
	FN_NTSC_DATA7 = 439,
	FN_CAM_CLKO = 440,
	FN_CAM_CLKI = 441,
	FN_CAM_VS = 442,
	FN_CAM_HS = 443,
	FN_CAM_YUV0 = 444,
	FN_CAM_YUV1 = 445,
	FN_CAM_YUV2 = 446,
	FN_CAM_YUV3 = 447,
	FN_CAM_YUV4 = 448,
	FN_CAM_YUV5 = 449,
	FN_CAM_YUV6 = 450,
	FN_CAM_YUV7 = 451,
	FN_JT_TDO = 452,
	FN_JT_TDOEN = 453,
	FN_LOWPWR = 454,
	FN_USB_VBUS = 455,
	FN_UART1_RX = 456,
	FN_UART1_TX = 457,
	FN_SEL_LCD3_1_0_00 = 458,
	FN_SEL_LCD3_1_0_01 = 459,
	FN_SEL_LCD3_9_8_00 = 460,
	FN_SEL_LCD3_9_8_10 = 461,
	FN_SEL_LCD3_11_10_00 = 462,
	FN_SEL_LCD3_11_10_01 = 463,
	FN_SEL_LCD3_11_10_10 = 464,
	FN_SEL_IIC_1_0_00 = 465,
	FN_SEL_IIC_1_0_01 = 466,
	FN_SEL_AB_1_0_00 = 467,
	FN_SEL_AB_1_0_10 = 468,
	FN_SEL_AB_3_2_00 = 469,
	FN_SEL_AB_3_2_01 = 470,
	FN_SEL_AB_3_2_10 = 471,
	FN_SEL_AB_3_2_11 = 472,
	FN_SEL_AB_5_4_00 = 473,
	FN_SEL_AB_5_4_01 = 474,
	FN_SEL_AB_5_4_10 = 475,
	FN_SEL_AB_5_4_11 = 476,
	FN_SEL_AB_7_6_00 = 477,
	FN_SEL_AB_7_6_01 = 478,
	FN_SEL_AB_7_6_10 = 479,
	FN_SEL_AB_9_8_00 = 480,
	FN_SEL_AB_9_8_01 = 481,
	FN_SEL_AB_9_8_10 = 482,
	FN_SEL_AB_11_10_00 = 483,
	FN_SEL_AB_11_10_10 = 484,
	FN_SEL_AB_13_12_00 = 485,
	FN_SEL_AB_13_12_10 = 486,
	FN_SEL_USI_1_0_00 = 487,
	FN_SEL_USI_1_0_01 = 488,
	FN_SEL_USI_3_2_00 = 489,
	FN_SEL_USI_3_2_01 = 490,
	FN_SEL_USI_5_4_00 = 491,
	FN_SEL_USI_5_4_01 = 492,
	FN_SEL_USI_7_6_00 = 493,
	FN_SEL_USI_7_6_01 = 494,
	FN_SEL_USI_9_8_00 = 495,
	FN_SEL_USI_9_8_01 = 496,
	FN_SEL_HSI_1_0_00 = 497,
	FN_SEL_HSI_1_0_01 = 498,
	FN_SEL_UART_1_0_00 = 499,
	FN_SEL_UART_1_0_01 = 500,
	PINMUX_FUNCTION_END___9 = 501,
	PINMUX_MARK_BEGIN___9 = 502,
	JT_SEL_MARK = 503,
	ERR_RST_REQB_MARK = 504,
	REF_CLKO_MARK = 505,
	EXT_CLKI_MARK = 506,
	LCD3_PXCLKB_MARK = 507,
	SD_CKI_MARK = 508,
	LCD3_R0_MARK = 509,
	LCD3_R1_MARK = 510,
	LCD3_R2_MARK = 511,
	LCD3_R3_MARK = 512,
	LCD3_R4_MARK = 513,
	LCD3_R5_MARK = 514,
	IIC0_SCL_MARK___3 = 515,
	IIC0_SDA_MARK___3 = 516,
	SDI0_CKO_MARK = 517,
	SDI0_CKI_MARK = 518,
	SDI0_CMD_MARK = 519,
	SDI0_DATA0_MARK = 520,
	SDI0_DATA1_MARK = 521,
	SDI0_DATA2_MARK = 522,
	SDI0_DATA3_MARK = 523,
	SDI0_DATA4_MARK = 524,
	SDI0_DATA5_MARK = 525,
	SDI0_DATA6_MARK = 526,
	SDI0_DATA7_MARK = 527,
	SDI1_CKO_MARK = 528,
	SDI1_CKI_MARK = 529,
	SDI1_CMD_MARK = 530,
	SDI1_DATA0_MARK = 531,
	SDI1_DATA1_MARK = 532,
	SDI1_DATA2_MARK = 533,
	SDI1_DATA3_MARK = 534,
	AB_CLK_MARK = 535,
	AB_CSB0_MARK = 536,
	AB_CSB1_MARK = 537,
	AB_A20_MARK = 538,
	USI0_CS1_MARK = 539,
	USI0_CS2_MARK = 540,
	USI1_DI_MARK = 541,
	USI1_DO_MARK = 542,
	NTSC_CLK_MARK = 543,
	NTSC_DATA0_MARK = 544,
	NTSC_DATA1_MARK = 545,
	NTSC_DATA2_MARK = 546,
	NTSC_DATA3_MARK = 547,
	NTSC_DATA4_MARK = 548,
	NTSC_DATA5_MARK = 549,
	NTSC_DATA6_MARK = 550,
	NTSC_DATA7_MARK = 551,
	CAM_CLKO_MARK = 552,
	CAM_CLKI_MARK = 553,
	CAM_VS_MARK = 554,
	CAM_HS_MARK = 555,
	CAM_YUV0_MARK = 556,
	CAM_YUV1_MARK = 557,
	CAM_YUV2_MARK = 558,
	CAM_YUV3_MARK = 559,
	CAM_YUV4_MARK = 560,
	CAM_YUV5_MARK = 561,
	CAM_YUV6_MARK = 562,
	CAM_YUV7_MARK = 563,
	JT_TDO_MARK = 564,
	JT_TDOEN_MARK = 565,
	USB_VBUS_MARK = 566,
	LOWPWR_MARK = 567,
	UART1_RX_MARK = 568,
	UART1_TX_MARK = 569,
	LCD3_PXCLK_MARK = 570,
	LCD3_CLK_I_MARK = 571,
	LCD3_HS_MARK = 572,
	LCD3_VS_MARK = 573,
	LCD3_DE_MARK = 574,
	LCD3_R6_MARK = 575,
	LCD3_R7_MARK = 576,
	LCD3_G0_MARK = 577,
	LCD3_G1_MARK = 578,
	LCD3_G2_MARK = 579,
	LCD3_G3_MARK = 580,
	LCD3_G4_MARK = 581,
	LCD3_G5_MARK = 582,
	LCD3_G6_MARK = 583,
	LCD3_G7_MARK = 584,
	LCD3_B0_MARK = 585,
	LCD3_B1_MARK = 586,
	LCD3_B2_MARK = 587,
	LCD3_B3_MARK = 588,
	LCD3_B4_MARK = 589,
	LCD3_B5_MARK = 590,
	LCD3_B6_MARK = 591,
	LCD3_B7_MARK = 592,
	YUV3_CLK_O_MARK = 593,
	YUV3_CLK_I_MARK = 594,
	YUV3_HS_MARK = 595,
	YUV3_VS_MARK = 596,
	YUV3_DE_MARK = 597,
	YUV3_D0_MARK = 598,
	YUV3_D1_MARK = 599,
	YUV3_D2_MARK = 600,
	YUV3_D3_MARK = 601,
	YUV3_D4_MARK = 602,
	YUV3_D5_MARK = 603,
	YUV3_D6_MARK = 604,
	YUV3_D7_MARK = 605,
	YUV3_D8_MARK = 606,
	YUV3_D9_MARK = 607,
	YUV3_D10_MARK = 608,
	YUV3_D11_MARK = 609,
	YUV3_D12_MARK = 610,
	YUV3_D13_MARK = 611,
	YUV3_D14_MARK = 612,
	YUV3_D15_MARK = 613,
	TP33_CLK_MARK = 614,
	TP33_CTRL_MARK = 615,
	TP33_DATA0_MARK = 616,
	TP33_DATA1_MARK = 617,
	TP33_DATA2_MARK = 618,
	TP33_DATA3_MARK = 619,
	TP33_DATA4_MARK = 620,
	TP33_DATA5_MARK = 621,
	TP33_DATA6_MARK = 622,
	TP33_DATA7_MARK = 623,
	TP33_DATA8_MARK = 624,
	TP33_DATA9_MARK = 625,
	TP33_DATA10_MARK = 626,
	TP33_DATA11_MARK = 627,
	TP33_DATA12_MARK = 628,
	TP33_DATA13_MARK = 629,
	TP33_DATA14_MARK = 630,
	TP33_DATA15_MARK = 631,
	IIC1_SCL_MARK___2 = 632,
	IIC1_SDA_MARK___2 = 633,
	UART3_RX_MARK = 634,
	UART3_TX_MARK = 635,
	AB_CSB2_MARK = 636,
	AB_CSB3_MARK = 637,
	AB_RDB_MARK = 638,
	AB_WRB_MARK = 639,
	AB_WAIT_MARK = 640,
	AB_ADV_MARK = 641,
	AB_AD0_MARK = 642,
	AB_AD1_MARK = 643,
	AB_AD2_MARK = 644,
	AB_AD3_MARK = 645,
	AB_AD4_MARK = 646,
	AB_AD5_MARK = 647,
	AB_AD6_MARK = 648,
	AB_AD7_MARK = 649,
	AB_AD8_MARK = 650,
	AB_AD9_MARK = 651,
	AB_AD10_MARK = 652,
	AB_AD11_MARK = 653,
	AB_AD12_MARK = 654,
	AB_AD13_MARK = 655,
	AB_AD14_MARK = 656,
	AB_AD15_MARK = 657,
	AB_A17_MARK = 658,
	AB_A18_MARK = 659,
	AB_A19_MARK = 660,
	AB_A21_MARK = 661,
	AB_A22_MARK = 662,
	AB_A23_MARK = 663,
	AB_A24_MARK = 664,
	AB_A25_MARK = 665,
	AB_A26_MARK = 666,
	AB_A27_MARK = 667,
	AB_A28_MARK = 668,
	AB_BEN0_MARK = 669,
	AB_BEN1_MARK = 670,
	DTV_BCLK_A_MARK = 671,
	DTV_PSYNC_A_MARK = 672,
	DTV_VALID_A_MARK = 673,
	DTV_DATA_A_MARK = 674,
	SDI2_CKO_MARK = 675,
	SDI2_CKI_MARK = 676,
	SDI2_CMD_MARK = 677,
	SDI2_DATA0_MARK = 678,
	SDI2_DATA1_MARK = 679,
	SDI2_DATA2_MARK = 680,
	SDI2_DATA3_MARK = 681,
	CF_CSB0_MARK = 682,
	CF_CSB1_MARK = 683,
	CF_IORDB_MARK = 684,
	CF_IOWRB_MARK = 685,
	CF_IORDY_MARK = 686,
	CF_RESET_MARK = 687,
	CF_D00_MARK = 688,
	CF_D01_MARK = 689,
	CF_D02_MARK = 690,
	CF_D03_MARK = 691,
	CF_D04_MARK = 692,
	CF_D05_MARK = 693,
	CF_D06_MARK = 694,
	CF_D07_MARK = 695,
	CF_D08_MARK = 696,
	CF_D09_MARK = 697,
	CF_D10_MARK = 698,
	CF_D11_MARK = 699,
	CF_D12_MARK = 700,
	CF_D13_MARK = 701,
	CF_D14_MARK = 702,
	CF_D15_MARK = 703,
	CF_A00_MARK = 704,
	CF_A01_MARK = 705,
	CF_A02_MARK = 706,
	CF_INTRQ_MARK = 707,
	CF_INPACKB_MARK = 708,
	CF_CDB1_MARK = 709,
	CF_CDB2_MARK = 710,
	USI5_CLK_A_MARK = 711,
	USI5_DI_A_MARK = 712,
	USI5_DO_A_MARK = 713,
	USI5_CS0_A_MARK = 714,
	USI5_CS1_A_MARK = 715,
	USI5_CS2_A_MARK = 716,
	USI0_CS3_MARK = 717,
	USI0_CS4_MARK = 718,
	USI0_CS5_MARK = 719,
	USI0_CS6_MARK = 720,
	USI2_CLK_MARK = 721,
	USI2_DI_MARK = 722,
	USI2_DO_MARK = 723,
	USI2_CS0_MARK = 724,
	USI2_CS1_MARK = 725,
	USI2_CS2_MARK = 726,
	USI3_CLK_MARK = 727,
	USI3_DI_MARK = 728,
	USI3_DO_MARK = 729,
	USI3_CS0_MARK = 730,
	USI4_CLK_MARK = 731,
	USI4_DI_MARK = 732,
	USI4_DO_MARK = 733,
	USI4_CS0_MARK = 734,
	USI4_CS1_MARK = 735,
	PWM0_MARK___4 = 736,
	PWM1_MARK___5 = 737,
	DTV_BCLK_B_MARK = 738,
	DTV_PSYNC_B_MARK = 739,
	DTV_VALID_B_MARK = 740,
	DTV_DATA_B_MARK = 741,
	USI5_CLK_B_MARK = 742,
	USI5_DO_B_MARK = 743,
	USI5_CS0_B_MARK = 744,
	USI5_CS1_B_MARK = 745,
	USI5_CS2_B_MARK = 746,
	USI5_CS3_B_MARK = 747,
	USI5_CS4_B_MARK = 748,
	USI5_DI_B_MARK = 749,
	UART1_CTSB_MARK = 750,
	UART1_RTSB_MARK = 751,
	UART2_RX_MARK = 752,
	UART2_TX_MARK = 753,
	PINMUX_MARK_END___9 = 754,
};

enum {
	PINMUX_RESERVED___10 = 0,
	PINMUX_DATA_BEGIN___10 = 1,
	GP_0_0_DATA___6 = 2,
	GP_0_1_DATA___6 = 3,
	GP_0_2_DATA___6 = 4,
	GP_0_3_DATA___6 = 5,
	GP_0_4_DATA___6 = 6,
	GP_0_5_DATA___6 = 7,
	GP_0_6_DATA___6 = 8,
	GP_0_7_DATA___6 = 9,
	GP_0_8_DATA___6 = 10,
	GP_0_9_DATA___6 = 11,
	GP_0_10_DATA___6 = 12,
	GP_0_11_DATA___6 = 13,
	GP_0_12_DATA___6 = 14,
	GP_0_13_DATA___6 = 15,
	GP_0_14_DATA___6 = 16,
	GP_0_15_DATA___6 = 17,
	GP_0_16_DATA___6 = 18,
	GP_0_17_DATA___6 = 19,
	GP_0_18_DATA___6 = 20,
	GP_0_19_DATA___6 = 21,
	GP_0_20_DATA___6 = 22,
	GP_0_21_DATA___6 = 23,
	GP_0_22_DATA___6 = 24,
	GP_0_23_DATA___5 = 25,
	GP_0_24_DATA___5 = 26,
	GP_0_25_DATA___5 = 27,
	GP_0_26_DATA___5 = 28,
	GP_0_27_DATA___5 = 29,
	GP_0_28_DATA___5 = 30,
	GP_1_0_DATA___6 = 31,
	GP_1_1_DATA___6 = 32,
	GP_1_2_DATA___6 = 33,
	GP_1_3_DATA___6 = 34,
	GP_1_4_DATA___6 = 35,
	GP_1_5_DATA___6 = 36,
	GP_1_6_DATA___6 = 37,
	GP_1_7_DATA___6 = 38,
	GP_1_8_DATA___6 = 39,
	GP_1_9_DATA___6 = 40,
	GP_1_10_DATA___6 = 41,
	GP_1_11_DATA___6 = 42,
	GP_1_12_DATA___6 = 43,
	GP_1_13_DATA___6 = 44,
	GP_1_14_DATA___6 = 45,
	GP_1_15_DATA___6 = 46,
	GP_1_16_DATA___6 = 47,
	GP_1_17_DATA___6 = 48,
	GP_1_18_DATA___6 = 49,
	GP_1_19_DATA___6 = 50,
	GP_1_20_DATA___6 = 51,
	GP_1_21_DATA___6 = 52,
	GP_1_22_DATA___6 = 53,
	GP_2_0_DATA___6 = 54,
	GP_2_1_DATA___6 = 55,
	GP_2_2_DATA___6 = 56,
	GP_2_3_DATA___6 = 57,
	GP_2_4_DATA___6 = 58,
	GP_2_5_DATA___6 = 59,
	GP_2_6_DATA___6 = 60,
	GP_2_7_DATA___6 = 61,
	GP_2_8_DATA___6 = 62,
	GP_2_9_DATA___6 = 63,
	GP_2_10_DATA___6 = 64,
	GP_2_11_DATA___6 = 65,
	GP_2_12_DATA___6 = 66,
	GP_2_13_DATA___6 = 67,
	GP_2_14_DATA___6 = 68,
	GP_2_15_DATA___6 = 69,
	GP_2_16_DATA___6 = 70,
	GP_2_17_DATA___6 = 71,
	GP_2_18_DATA___6 = 72,
	GP_2_19_DATA___6 = 73,
	GP_2_20_DATA___6 = 74,
	GP_2_21_DATA___6 = 75,
	GP_2_22_DATA___6 = 76,
	GP_2_23_DATA___6 = 77,
	GP_2_24_DATA___6 = 78,
	GP_2_25_DATA___6 = 79,
	GP_2_26_DATA___6 = 80,
	GP_2_27_DATA___6 = 81,
	GP_2_28_DATA___6 = 82,
	GP_2_29_DATA___6 = 83,
	GP_2_30_DATA___6 = 84,
	GP_2_31_DATA___6 = 85,
	GP_3_0_DATA___6 = 86,
	GP_3_1_DATA___6 = 87,
	GP_3_2_DATA___6 = 88,
	GP_3_3_DATA___6 = 89,
	GP_3_4_DATA___6 = 90,
	GP_3_5_DATA___6 = 91,
	GP_3_6_DATA___6 = 92,
	GP_3_7_DATA___6 = 93,
	GP_3_8_DATA___6 = 94,
	GP_3_9_DATA___6 = 95,
	GP_3_10_DATA___6 = 96,
	GP_3_11_DATA___6 = 97,
	GP_3_12_DATA___6 = 98,
	GP_3_13_DATA___6 = 99,
	GP_3_14_DATA___6 = 100,
	GP_3_15_DATA___6 = 101,
	GP_3_16_DATA___6 = 102,
	GP_3_17_DATA___5 = 103,
	GP_3_18_DATA___5 = 104,
	GP_3_19_DATA___5 = 105,
	GP_3_20_DATA___5 = 106,
	GP_3_21_DATA___5 = 107,
	GP_3_22_DATA___5 = 108,
	GP_3_23_DATA___5 = 109,
	GP_3_24_DATA___5 = 110,
	GP_3_25_DATA___5 = 111,
	GP_3_26_DATA___5 = 112,
	GP_3_27_DATA___6 = 113,
	GP_4_0_DATA___6 = 114,
	GP_4_1_DATA___6 = 115,
	GP_4_2_DATA___6 = 116,
	GP_4_3_DATA___6 = 117,
	GP_4_4_DATA___6 = 118,
	GP_4_5_DATA___6 = 119,
	GP_4_6_DATA___6 = 120,
	GP_4_7_DATA___6 = 121,
	GP_4_8_DATA___6 = 122,
	GP_4_9_DATA___6 = 123,
	GP_4_10_DATA___6 = 124,
	GP_4_11_DATA___6 = 125,
	GP_4_12_DATA___6 = 126,
	GP_4_13_DATA___6 = 127,
	GP_4_14_DATA___6 = 128,
	GP_4_15_DATA___6 = 129,
	GP_4_16_DATA___6 = 130,
	GP_5_0_DATA___5 = 131,
	GP_5_1_DATA___5 = 132,
	GP_5_2_DATA___5 = 133,
	GP_5_3_DATA___5 = 134,
	GP_5_4_DATA___5 = 135,
	GP_5_5_DATA___5 = 136,
	GP_5_6_DATA___5 = 137,
	GP_5_7_DATA___5 = 138,
	GP_5_8_DATA___5 = 139,
	GP_5_9_DATA___5 = 140,
	GP_5_10_DATA___5 = 141,
	GP_5_11_DATA___5 = 142,
	GP_5_12_DATA___5 = 143,
	GP_5_13_DATA___5 = 144,
	GP_5_14_DATA___5 = 145,
	GP_5_15_DATA___5 = 146,
	GP_5_16_DATA___5 = 147,
	GP_6_0_DATA___4 = 148,
	GP_6_1_DATA___4 = 149,
	GP_6_2_DATA___4 = 150,
	GP_6_3_DATA___4 = 151,
	GP_6_4_DATA___4 = 152,
	GP_6_5_DATA___4 = 153,
	GP_6_6_DATA___4 = 154,
	GP_6_7_DATA___4 = 155,
	GP_6_8_DATA___4 = 156,
	GP_6_9_DATA___3 = 157,
	GP_6_10_DATA___3 = 158,
	GP_6_11_DATA___3 = 159,
	GP_6_12_DATA___3 = 160,
	GP_6_13_DATA___3 = 161,
	GP_6_14_DATA___3 = 162,
	GP_6_15_DATA___3 = 163,
	GP_6_16_DATA___3 = 164,
	GP_7_0_DATA___2 = 165,
	GP_7_1_DATA___2 = 166,
	GP_7_2_DATA___2 = 167,
	GP_7_3_DATA___2 = 168,
	GP_7_4_DATA___2 = 169,
	GP_7_5_DATA___2 = 170,
	GP_7_6_DATA___2 = 171,
	GP_7_7_DATA___2 = 172,
	GP_7_8_DATA___2 = 173,
	GP_7_9_DATA___2 = 174,
	GP_7_10_DATA___2 = 175,
	GP_7_11_DATA___2 = 176,
	GP_7_12_DATA___2 = 177,
	GP_7_13_DATA___2 = 178,
	GP_7_14_DATA___2 = 179,
	GP_7_15_DATA___2 = 180,
	GP_7_16_DATA___2 = 181,
	GP_8_0_DATA = 182,
	GP_8_1_DATA = 183,
	GP_8_2_DATA = 184,
	GP_8_3_DATA = 185,
	GP_8_4_DATA = 186,
	GP_8_5_DATA = 187,
	GP_8_6_DATA = 188,
	GP_8_7_DATA = 189,
	GP_8_8_DATA = 190,
	GP_8_9_DATA = 191,
	GP_8_10_DATA = 192,
	GP_8_11_DATA = 193,
	GP_8_12_DATA = 194,
	GP_8_13_DATA = 195,
	GP_8_14_DATA = 196,
	GP_8_15_DATA = 197,
	GP_8_16_DATA = 198,
	GP_9_0_DATA = 199,
	GP_9_1_DATA = 200,
	GP_9_2_DATA = 201,
	GP_9_3_DATA = 202,
	GP_9_4_DATA = 203,
	GP_9_5_DATA = 204,
	GP_9_6_DATA = 205,
	GP_9_7_DATA = 206,
	GP_9_8_DATA = 207,
	GP_9_9_DATA = 208,
	GP_9_10_DATA = 209,
	GP_9_11_DATA = 210,
	GP_9_12_DATA = 211,
	GP_9_13_DATA = 212,
	GP_9_14_DATA = 213,
	GP_9_15_DATA = 214,
	GP_9_16_DATA = 215,
	GP_10_0_DATA = 216,
	GP_10_1_DATA = 217,
	GP_10_2_DATA = 218,
	GP_10_3_DATA = 219,
	GP_10_4_DATA = 220,
	GP_10_5_DATA = 221,
	GP_10_6_DATA = 222,
	GP_10_7_DATA = 223,
	GP_10_8_DATA = 224,
	GP_10_9_DATA = 225,
	GP_10_10_DATA = 226,
	GP_10_11_DATA = 227,
	GP_10_12_DATA = 228,
	GP_10_13_DATA = 229,
	GP_10_14_DATA = 230,
	GP_10_15_DATA = 231,
	GP_10_16_DATA = 232,
	GP_10_17_DATA = 233,
	GP_10_18_DATA = 234,
	GP_10_19_DATA = 235,
	GP_10_20_DATA = 236,
	GP_10_21_DATA = 237,
	GP_10_22_DATA = 238,
	GP_10_23_DATA = 239,
	GP_10_24_DATA = 240,
	GP_10_25_DATA = 241,
	GP_10_26_DATA = 242,
	GP_10_27_DATA = 243,
	GP_10_28_DATA = 244,
	GP_10_29_DATA = 245,
	GP_10_30_DATA = 246,
	GP_10_31_DATA = 247,
	GP_11_0_DATA = 248,
	GP_11_1_DATA = 249,
	GP_11_2_DATA = 250,
	GP_11_3_DATA = 251,
	GP_11_4_DATA = 252,
	GP_11_5_DATA = 253,
	GP_11_6_DATA = 254,
	GP_11_7_DATA = 255,
	GP_11_8_DATA = 256,
	GP_11_9_DATA = 257,
	GP_11_10_DATA = 258,
	GP_11_11_DATA = 259,
	GP_11_12_DATA = 260,
	GP_11_13_DATA = 261,
	GP_11_14_DATA = 262,
	GP_11_15_DATA = 263,
	GP_11_16_DATA = 264,
	GP_11_17_DATA = 265,
	GP_11_18_DATA = 266,
	GP_11_19_DATA = 267,
	GP_11_20_DATA = 268,
	GP_11_21_DATA = 269,
	GP_11_22_DATA = 270,
	GP_11_23_DATA = 271,
	GP_11_24_DATA = 272,
	GP_11_25_DATA = 273,
	GP_11_26_DATA = 274,
	GP_11_27_DATA = 275,
	GP_11_28_DATA = 276,
	GP_11_29_DATA = 277,
	PINMUX_DATA_END___10 = 278,
	PINMUX_FUNCTION_BEGIN___10 = 279,
	GP_0_0_FN___6 = 280,
	GP_0_1_FN___6 = 281,
	GP_0_2_FN___6 = 282,
	GP_0_3_FN___6 = 283,
	GP_0_4_FN___6 = 284,
	GP_0_5_FN___6 = 285,
	GP_0_6_FN___6 = 286,
	GP_0_7_FN___6 = 287,
	GP_0_8_FN___6 = 288,
	GP_0_9_FN___6 = 289,
	GP_0_10_FN___6 = 290,
	GP_0_11_FN___6 = 291,
	GP_0_12_FN___6 = 292,
	GP_0_13_FN___6 = 293,
	GP_0_14_FN___6 = 294,
	GP_0_15_FN___6 = 295,
	GP_0_16_FN___6 = 296,
	GP_0_17_FN___6 = 297,
	GP_0_18_FN___6 = 298,
	GP_0_19_FN___6 = 299,
	GP_0_20_FN___6 = 300,
	GP_0_21_FN___6 = 301,
	GP_0_22_FN___6 = 302,
	GP_0_23_FN___5 = 303,
	GP_0_24_FN___5 = 304,
	GP_0_25_FN___5 = 305,
	GP_0_26_FN___5 = 306,
	GP_0_27_FN___5 = 307,
	GP_0_28_FN___5 = 308,
	GP_1_0_FN___6 = 309,
	GP_1_1_FN___6 = 310,
	GP_1_2_FN___6 = 311,
	GP_1_3_FN___6 = 312,
	GP_1_4_FN___6 = 313,
	GP_1_5_FN___6 = 314,
	GP_1_6_FN___6 = 315,
	GP_1_7_FN___6 = 316,
	GP_1_8_FN___6 = 317,
	GP_1_9_FN___6 = 318,
	GP_1_10_FN___6 = 319,
	GP_1_11_FN___6 = 320,
	GP_1_12_FN___6 = 321,
	GP_1_13_FN___6 = 322,
	GP_1_14_FN___6 = 323,
	GP_1_15_FN___6 = 324,
	GP_1_16_FN___6 = 325,
	GP_1_17_FN___6 = 326,
	GP_1_18_FN___6 = 327,
	GP_1_19_FN___6 = 328,
	GP_1_20_FN___6 = 329,
	GP_1_21_FN___6 = 330,
	GP_1_22_FN___6 = 331,
	GP_2_0_FN___6 = 332,
	GP_2_1_FN___6 = 333,
	GP_2_2_FN___6 = 334,
	GP_2_3_FN___6 = 335,
	GP_2_4_FN___6 = 336,
	GP_2_5_FN___6 = 337,
	GP_2_6_FN___6 = 338,
	GP_2_7_FN___6 = 339,
	GP_2_8_FN___6 = 340,
	GP_2_9_FN___6 = 341,
	GP_2_10_FN___6 = 342,
	GP_2_11_FN___6 = 343,
	GP_2_12_FN___6 = 344,
	GP_2_13_FN___6 = 345,
	GP_2_14_FN___6 = 346,
	GP_2_15_FN___6 = 347,
	GP_2_16_FN___6 = 348,
	GP_2_17_FN___6 = 349,
	GP_2_18_FN___6 = 350,
	GP_2_19_FN___6 = 351,
	GP_2_20_FN___6 = 352,
	GP_2_21_FN___6 = 353,
	GP_2_22_FN___6 = 354,
	GP_2_23_FN___6 = 355,
	GP_2_24_FN___6 = 356,
	GP_2_25_FN___6 = 357,
	GP_2_26_FN___6 = 358,
	GP_2_27_FN___6 = 359,
	GP_2_28_FN___6 = 360,
	GP_2_29_FN___6 = 361,
	GP_2_30_FN___6 = 362,
	GP_2_31_FN___6 = 363,
	GP_3_0_FN___6 = 364,
	GP_3_1_FN___6 = 365,
	GP_3_2_FN___6 = 366,
	GP_3_3_FN___6 = 367,
	GP_3_4_FN___6 = 368,
	GP_3_5_FN___6 = 369,
	GP_3_6_FN___6 = 370,
	GP_3_7_FN___6 = 371,
	GP_3_8_FN___6 = 372,
	GP_3_9_FN___6 = 373,
	GP_3_10_FN___6 = 374,
	GP_3_11_FN___6 = 375,
	GP_3_12_FN___6 = 376,
	GP_3_13_FN___6 = 377,
	GP_3_14_FN___6 = 378,
	GP_3_15_FN___6 = 379,
	GP_3_16_FN___6 = 380,
	GP_3_17_FN___5 = 381,
	GP_3_18_FN___5 = 382,
	GP_3_19_FN___5 = 383,
	GP_3_20_FN___5 = 384,
	GP_3_21_FN___5 = 385,
	GP_3_22_FN___5 = 386,
	GP_3_23_FN___5 = 387,
	GP_3_24_FN___5 = 388,
	GP_3_25_FN___5 = 389,
	GP_3_26_FN___5 = 390,
	GP_3_27_FN___6 = 391,
	GP_4_0_FN___6 = 392,
	GP_4_1_FN___6 = 393,
	GP_4_2_FN___6 = 394,
	GP_4_3_FN___6 = 395,
	GP_4_4_FN___6 = 396,
	GP_4_5_FN___6 = 397,
	GP_4_6_FN___6 = 398,
	GP_4_7_FN___6 = 399,
	GP_4_8_FN___6 = 400,
	GP_4_9_FN___6 = 401,
	GP_4_10_FN___6 = 402,
	GP_4_11_FN___6 = 403,
	GP_4_12_FN___6 = 404,
	GP_4_13_FN___6 = 405,
	GP_4_14_FN___6 = 406,
	GP_4_15_FN___6 = 407,
	GP_4_16_FN___6 = 408,
	GP_5_0_FN___5 = 409,
	GP_5_1_FN___5 = 410,
	GP_5_2_FN___5 = 411,
	GP_5_3_FN___5 = 412,
	GP_5_4_FN___5 = 413,
	GP_5_5_FN___5 = 414,
	GP_5_6_FN___5 = 415,
	GP_5_7_FN___5 = 416,
	GP_5_8_FN___5 = 417,
	GP_5_9_FN___5 = 418,
	GP_5_10_FN___5 = 419,
	GP_5_11_FN___5 = 420,
	GP_5_12_FN___5 = 421,
	GP_5_13_FN___5 = 422,
	GP_5_14_FN___5 = 423,
	GP_5_15_FN___5 = 424,
	GP_5_16_FN___5 = 425,
	GP_6_0_FN___4 = 426,
	GP_6_1_FN___4 = 427,
	GP_6_2_FN___4 = 428,
	GP_6_3_FN___4 = 429,
	GP_6_4_FN___4 = 430,
	GP_6_5_FN___4 = 431,
	GP_6_6_FN___4 = 432,
	GP_6_7_FN___4 = 433,
	GP_6_8_FN___4 = 434,
	GP_6_9_FN___3 = 435,
	GP_6_10_FN___3 = 436,
	GP_6_11_FN___3 = 437,
	GP_6_12_FN___3 = 438,
	GP_6_13_FN___3 = 439,
	GP_6_14_FN___3 = 440,
	GP_6_15_FN___3 = 441,
	GP_6_16_FN___3 = 442,
	GP_7_0_FN___2 = 443,
	GP_7_1_FN___2 = 444,
	GP_7_2_FN___2 = 445,
	GP_7_3_FN___2 = 446,
	GP_7_4_FN___2 = 447,
	GP_7_5_FN___2 = 448,
	GP_7_6_FN___2 = 449,
	GP_7_7_FN___2 = 450,
	GP_7_8_FN___2 = 451,
	GP_7_9_FN___2 = 452,
	GP_7_10_FN___2 = 453,
	GP_7_11_FN___2 = 454,
	GP_7_12_FN___2 = 455,
	GP_7_13_FN___2 = 456,
	GP_7_14_FN___2 = 457,
	GP_7_15_FN___2 = 458,
	GP_7_16_FN___2 = 459,
	GP_8_0_FN = 460,
	GP_8_1_FN = 461,
	GP_8_2_FN = 462,
	GP_8_3_FN = 463,
	GP_8_4_FN = 464,
	GP_8_5_FN = 465,
	GP_8_6_FN = 466,
	GP_8_7_FN = 467,
	GP_8_8_FN = 468,
	GP_8_9_FN = 469,
	GP_8_10_FN = 470,
	GP_8_11_FN = 471,
	GP_8_12_FN = 472,
	GP_8_13_FN = 473,
	GP_8_14_FN = 474,
	GP_8_15_FN = 475,
	GP_8_16_FN = 476,
	GP_9_0_FN = 477,
	GP_9_1_FN = 478,
	GP_9_2_FN = 479,
	GP_9_3_FN = 480,
	GP_9_4_FN = 481,
	GP_9_5_FN = 482,
	GP_9_6_FN = 483,
	GP_9_7_FN = 484,
	GP_9_8_FN = 485,
	GP_9_9_FN = 486,
	GP_9_10_FN = 487,
	GP_9_11_FN = 488,
	GP_9_12_FN = 489,
	GP_9_13_FN = 490,
	GP_9_14_FN = 491,
	GP_9_15_FN = 492,
	GP_9_16_FN = 493,
	GP_10_0_FN = 494,
	GP_10_1_FN = 495,
	GP_10_2_FN = 496,
	GP_10_3_FN = 497,
	GP_10_4_FN = 498,
	GP_10_5_FN = 499,
	GP_10_6_FN = 500,
	GP_10_7_FN = 501,
	GP_10_8_FN = 502,
	GP_10_9_FN = 503,
	GP_10_10_FN = 504,
	GP_10_11_FN = 505,
	GP_10_12_FN = 506,
	GP_10_13_FN = 507,
	GP_10_14_FN = 508,
	GP_10_15_FN = 509,
	GP_10_16_FN = 510,
	GP_10_17_FN = 511,
	GP_10_18_FN = 512,
	GP_10_19_FN = 513,
	GP_10_20_FN = 514,
	GP_10_21_FN = 515,
	GP_10_22_FN = 516,
	GP_10_23_FN = 517,
	GP_10_24_FN = 518,
	GP_10_25_FN = 519,
	GP_10_26_FN = 520,
	GP_10_27_FN = 521,
	GP_10_28_FN = 522,
	GP_10_29_FN = 523,
	GP_10_30_FN = 524,
	GP_10_31_FN = 525,
	GP_11_0_FN = 526,
	GP_11_1_FN = 527,
	GP_11_2_FN = 528,
	GP_11_3_FN = 529,
	GP_11_4_FN = 530,
	GP_11_5_FN = 531,
	GP_11_6_FN = 532,
	GP_11_7_FN = 533,
	GP_11_8_FN = 534,
	GP_11_9_FN = 535,
	GP_11_10_FN = 536,
	GP_11_11_FN = 537,
	GP_11_12_FN = 538,
	GP_11_13_FN = 539,
	GP_11_14_FN = 540,
	GP_11_15_FN = 541,
	GP_11_16_FN = 542,
	GP_11_17_FN = 543,
	GP_11_18_FN = 544,
	GP_11_19_FN = 545,
	GP_11_20_FN = 546,
	GP_11_21_FN = 547,
	GP_11_22_FN = 548,
	GP_11_23_FN = 549,
	GP_11_24_FN = 550,
	GP_11_25_FN = 551,
	GP_11_26_FN = 552,
	GP_11_27_FN = 553,
	GP_11_28_FN = 554,
	GP_11_29_FN = 555,
	FN_IP0_0___3 = 556,
	FN_IP0_1___2 = 557,
	FN_IP0_2___2 = 558,
	FN_IP0_3___2 = 559,
	FN_IP0_4___2 = 560,
	FN_IP0_5___2 = 561,
	FN_IP0_6___2 = 562,
	FN_IP0_7___2 = 563,
	FN_IP0_8___2 = 564,
	FN_IP0_9___2 = 565,
	FN_IP0_10___3 = 566,
	FN_IP0_11___3 = 567,
	FN_IP0_12___3 = 568,
	FN_IP0_13___3 = 569,
	FN_IP0_14___3 = 570,
	FN_IP0_15___4 = 571,
	FN_IP0_16___3 = 572,
	FN_IP0_17___3 = 573,
	FN_IP0_18___2 = 574,
	FN_IP0_19___2 = 575,
	FN_IP0_20___2 = 576,
	FN_IP0_21___2 = 577,
	FN_IP0_22___2 = 578,
	FN_IP0_23___2 = 579,
	FN_IP1_0___2 = 580,
	FN_IP1_1___2 = 581,
	FN_IP1_2 = 582,
	FN_IP1_3 = 583,
	FN_IP1_4 = 584,
	FN_IP1_5 = 585,
	FN_IP1_6 = 586,
	FN_IP1_7 = 587,
	FN_IP1_8 = 588,
	FN_IP1_9 = 589,
	FN_IP1_10 = 590,
	FN_IP1_11 = 591,
	FN_IP1_12 = 592,
	FN_IP1_13 = 593,
	FN_IP1_14 = 594,
	FN_IP1_15 = 595,
	FN_IP1_16 = 596,
	FN_DU1_DB2_C0_DATA12 = 597,
	FN_DU1_DB3_C1_DATA13 = 598,
	FN_DU1_DB4_C2_DATA14 = 599,
	FN_DU1_DB5_C3_DATA15 = 600,
	FN_DU1_DB6_C4 = 601,
	FN_DU1_DB7_C5 = 602,
	FN_DU1_EXHSYNC_DU1_HSYNC___6 = 603,
	FN_DU1_EXVSYNC_DU1_VSYNC___6 = 604,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE___6 = 605,
	FN_DU1_DISP___6 = 606,
	FN_DU1_CDE___6 = 607,
	FN_D0___5 = 608,
	FN_D1___5 = 609,
	FN_D2___5 = 610,
	FN_D3___5 = 611,
	FN_D4___5 = 612,
	FN_D5___5 = 613,
	FN_D6___5 = 614,
	FN_D7___5 = 615,
	FN_D8___5 = 616,
	FN_D9___5 = 617,
	FN_D10___5 = 618,
	FN_D11___5 = 619,
	FN_D12___4 = 620,
	FN_D13___4 = 621,
	FN_D14___4 = 622,
	FN_D15___4 = 623,
	FN_A0___6 = 624,
	FN_A1___6 = 625,
	FN_A2___6 = 626,
	FN_A3___6 = 627,
	FN_A4___6 = 628,
	FN_A5___6 = 629,
	FN_A6___6 = 630,
	FN_A7___6 = 631,
	FN_A8___6 = 632,
	FN_A9___6 = 633,
	FN_A10___6 = 634,
	FN_A11___6 = 635,
	FN_A12___6 = 636,
	FN_A13___6 = 637,
	FN_A14___6 = 638,
	FN_A15___6 = 639,
	FN_A16___6 = 640,
	FN_A17___6 = 641,
	FN_A18___6 = 642,
	FN_A19___6 = 643,
	FN_IP1_17 = 644,
	FN_IP1_18 = 645,
	FN_CS1_N_A26___4 = 646,
	FN_EX_CS0_N___3 = 647,
	FN_EX_CS1_N___3 = 648,
	FN_EX_CS2_N___3 = 649,
	FN_EX_CS3_N___3 = 650,
	FN_EX_CS4_N___3 = 651,
	FN_EX_CS5_N___3 = 652,
	FN_BS_N___4 = 653,
	FN_RD_N___4 = 654,
	FN_RD_WR_N___4 = 655,
	FN_WE0_N___4 = 656,
	FN_WE1_N___4 = 657,
	FN_EX_WAIT0___6 = 658,
	FN_IRQ0___6 = 659,
	FN_IRQ1___5 = 660,
	FN_IRQ2___5 = 661,
	FN_IRQ3___5 = 662,
	FN_IP1_19 = 663,
	FN_IP1_20 = 664,
	FN_IP1_21 = 665,
	FN_IP1_22 = 666,
	FN_CS0_N___4 = 667,
	FN_VI0_CLK___6 = 668,
	FN_VI0_CLKENB___6 = 669,
	FN_VI0_HSYNC_N___4 = 670,
	FN_VI0_VSYNC_N___4 = 671,
	FN_VI0_D0_B0_C0 = 672,
	FN_VI0_D1_B1_C1 = 673,
	FN_VI0_D2_B2_C2 = 674,
	FN_VI0_D3_B3_C3 = 675,
	FN_VI0_D4_B4_C4 = 676,
	FN_VI0_D5_B5_C5 = 677,
	FN_VI0_D6_B6_C6 = 678,
	FN_VI0_D7_B7_C7 = 679,
	FN_VI0_D8_G0_Y0 = 680,
	FN_VI0_D9_G1_Y1 = 681,
	FN_VI0_D10_G2_Y2 = 682,
	FN_VI0_D11_G3_Y3 = 683,
	FN_VI0_FIELD___6 = 684,
	FN_VI1_CLK___6 = 685,
	FN_VI1_CLKENB___6 = 686,
	FN_VI1_HSYNC_N___4 = 687,
	FN_VI1_VSYNC_N___4 = 688,
	FN_VI1_D0_B0_C0 = 689,
	FN_VI1_D1_B1_C1 = 690,
	FN_VI1_D2_B2_C2 = 691,
	FN_VI1_D3_B3_C3 = 692,
	FN_VI1_D4_B4_C4 = 693,
	FN_VI1_D5_B5_C5 = 694,
	FN_VI1_D6_B6_C6 = 695,
	FN_VI1_D7_B7_C7 = 696,
	FN_VI1_D8_G0_Y0 = 697,
	FN_VI1_D9_G1_Y1 = 698,
	FN_VI1_D10_G2_Y2 = 699,
	FN_VI1_D11_G3_Y3 = 700,
	FN_VI1_FIELD___6 = 701,
	FN_IP2_0 = 702,
	FN_IP2_1 = 703,
	FN_IP2_2 = 704,
	FN_IP2_3 = 705,
	FN_IP2_4 = 706,
	FN_IP2_5 = 707,
	FN_IP2_6 = 708,
	FN_IP2_7 = 709,
	FN_IP2_8 = 710,
	FN_IP2_9 = 711,
	FN_IP2_10 = 712,
	FN_IP2_11 = 713,
	FN_IP2_12 = 714,
	FN_IP2_13 = 715,
	FN_IP2_14 = 716,
	FN_IP2_15 = 717,
	FN_IP2_16 = 718,
	FN_IP3_0 = 719,
	FN_IP3_1 = 720,
	FN_IP3_2 = 721,
	FN_IP3_3___2 = 722,
	FN_IP3_4___2 = 723,
	FN_IP3_5___2 = 724,
	FN_IP3_6___2 = 725,
	FN_IP3_7___2 = 726,
	FN_IP3_8___2 = 727,
	FN_IP3_9 = 728,
	FN_IP3_10___2 = 729,
	FN_IP3_11___2 = 730,
	FN_IP3_12___2 = 731,
	FN_IP3_13 = 732,
	FN_VI3_D10_Y2 = 733,
	FN_IP3_14 = 734,
	FN_VI3_FIELD___2 = 735,
	FN_VI4_CLK = 736,
	FN_IP4_0___2 = 737,
	FN_IP4_1 = 738,
	FN_IP4_3_2 = 739,
	FN_IP4_4 = 740,
	FN_IP4_6_5 = 741,
	FN_IP4_8_7 = 742,
	FN_IP4_10_9___2 = 743,
	FN_IP4_12_11___2 = 744,
	FN_IP4_14_13___2 = 745,
	FN_IP4_16_15___2 = 746,
	FN_IP4_18_17 = 747,
	FN_IP4_20_19 = 748,
	FN_IP4_21___2 = 749,
	FN_IP4_22 = 750,
	FN_IP4_23___2 = 751,
	FN_IP4_24___2 = 752,
	FN_VI5_CLK = 753,
	FN_IP5_0 = 754,
	FN_IP5_1 = 755,
	FN_IP5_2 = 756,
	FN_IP5_3___2 = 757,
	FN_IP5_4___2 = 758,
	FN_IP5_5___2 = 759,
	FN_IP5_6___3 = 760,
	FN_IP5_7___3 = 761,
	FN_IP5_8___2 = 762,
	FN_IP5_9 = 763,
	FN_IP5_10 = 764,
	FN_IP5_11 = 765,
	FN_VI5_D9_Y1 = 766,
	FN_VI5_D10_Y2 = 767,
	FN_VI5_D11_Y3 = 768,
	FN_VI5_FIELD = 769,
	FN_IP6_0 = 770,
	FN_IP6_1 = 771,
	FN_HRTS0_N___3 = 772,
	FN_IP6_2 = 773,
	FN_IP6_3 = 774,
	FN_IP6_4 = 775,
	FN_IP6_5 = 776,
	FN_HCTS1_N___2 = 777,
	FN_IP6_6 = 778,
	FN_IP6_7___2 = 779,
	FN_SCK0___3 = 780,
	FN_CTS0_N = 781,
	FN_RTS0_N = 782,
	FN_TX0___3 = 783,
	FN_RX0___3 = 784,
	FN_SCK1___2 = 785,
	FN_CTS1_N = 786,
	FN_RTS1_N = 787,
	FN_TX1___3 = 788,
	FN_RX1___3 = 789,
	FN_IP6_9_8___2 = 790,
	FN_IP6_11_10___2 = 791,
	FN_IP6_13_12___2 = 792,
	FN_IP6_15_14___3 = 793,
	FN_IP6_16___3 = 794,
	FN_IP6_18_17___2 = 795,
	FN_SCIF_CLK___5 = 796,
	FN_CAN0_TX___4 = 797,
	FN_CAN0_RX___4 = 798,
	FN_CAN_CLK___4 = 799,
	FN_CAN1_TX___4 = 800,
	FN_CAN1_RX___4 = 801,
	FN_IP7_1_0___3 = 802,
	FN_IP7_3_2___3 = 803,
	FN_IP7_5_4___2 = 804,
	FN_IP7_6 = 805,
	FN_IP7_7 = 806,
	FN_SD0_CLK___6 = 807,
	FN_SD0_CMD___6 = 808,
	FN_SD0_DAT0___4 = 809,
	FN_SD0_DAT1___4 = 810,
	FN_SD0_DAT2___4 = 811,
	FN_SD0_DAT3___4 = 812,
	FN_SD0_CD___6 = 813,
	FN_SD0_WP___6 = 814,
	FN_IP7_9_8 = 815,
	FN_IP7_11_10 = 816,
	FN_IP7_13_12 = 817,
	FN_IP7_15_14 = 818,
	FN_IP7_16 = 819,
	FN_IP7_17 = 820,
	FN_IP7_18 = 821,
	FN_IP7_19 = 822,
	FN_IP7_20 = 823,
	FN_ADICLK___5 = 824,
	FN_ADICS_SAMP___5 = 825,
	FN_ADIDATA___5 = 826,
	FN_ADICHS0___5 = 827,
	FN_ADICHS1___5 = 828,
	FN_ADICHS2___5 = 829,
	FN_AVS1___3 = 830,
	FN_AVS2___3 = 831,
	FN_DU0_DR0_DATA0 = 832,
	FN_DU0_DR1_DATA1 = 833,
	FN_DU0_DR2_Y4_DATA2 = 834,
	FN_DU0_DR3_Y5_DATA3 = 835,
	FN_DU0_DR4_Y6_DATA4 = 836,
	FN_DU0_DR5_Y7_DATA5 = 837,
	FN_DU0_DR6_Y8_DATA6 = 838,
	FN_DU0_DR7_Y9_DATA7 = 839,
	FN_DU0_DG0_DATA8 = 840,
	FN_DU0_DG1_DATA9 = 841,
	FN_DU0_DG2_C6_DATA10 = 842,
	FN_DU0_DG3_C7_DATA11 = 843,
	FN_DU0_DG4_Y0_DATA12 = 844,
	FN_DU0_DG5_Y1_DATA13 = 845,
	FN_DU0_DG6_Y2_DATA14 = 846,
	FN_DU0_DG7_Y3_DATA15 = 847,
	FN_DU0_DB0___5 = 848,
	FN_DU0_DB1___5 = 849,
	FN_DU0_DB2_C0 = 850,
	FN_DU0_DB3_C1 = 851,
	FN_DU0_DB4_C2 = 852,
	FN_DU0_DB5_C3 = 853,
	FN_DU0_DB6_C4 = 854,
	FN_DU0_DB7_C5 = 855,
	FN_DU0_EXHSYNC_DU0_HSYNC___5 = 856,
	FN_DU0_EXVSYNC_DU0_VSYNC___5 = 857,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE___5 = 858,
	FN_DU0_DISP___5 = 859,
	FN_DU0_CDE___5 = 860,
	FN_DU1_DR2_Y4_DATA0 = 861,
	FN_DU1_DR3_Y5_DATA1 = 862,
	FN_DU1_DR4_Y6_DATA2 = 863,
	FN_DU1_DR5_Y7_DATA3 = 864,
	FN_DU1_DR6_DATA4 = 865,
	FN_DU1_DR7_DATA5 = 866,
	FN_DU1_DG2_C6_DATA6 = 867,
	FN_DU1_DG3_C7_DATA7 = 868,
	FN_DU1_DG4_Y0_DATA8 = 869,
	FN_DU1_DG5_Y1_DATA9 = 870,
	FN_DU1_DG6_Y2_DATA10 = 871,
	FN_DU1_DG7_Y3_DATA11 = 872,
	FN_A20___6 = 873,
	FN_MOSI_IO0___3 = 874,
	FN_A21___6 = 875,
	FN_MISO_IO1___3 = 876,
	FN_A22___6 = 877,
	FN_IO2___3 = 878,
	FN_A23___6 = 879,
	FN_IO3___3 = 880,
	FN_A24___6 = 881,
	FN_SPCLK___3 = 882,
	FN_A25___6 = 883,
	FN_SSL___3 = 884,
	FN_VI2_CLK___3 = 885,
	FN_AVB_RX_CLK___4 = 886,
	FN_VI2_CLKENB___3 = 887,
	FN_AVB_RX_DV___4 = 888,
	FN_VI2_HSYNC_N___2 = 889,
	FN_AVB_RXD0___4 = 890,
	FN_VI2_VSYNC_N___2 = 891,
	FN_AVB_RXD1___4 = 892,
	FN_VI2_D0_C0 = 893,
	FN_AVB_RXD2___4 = 894,
	FN_VI2_D1_C1 = 895,
	FN_AVB_RXD3___4 = 896,
	FN_VI2_D2_C2 = 897,
	FN_AVB_RXD4___4 = 898,
	FN_VI2_D3_C3 = 899,
	FN_AVB_RXD5___4 = 900,
	FN_VI2_D4_C4 = 901,
	FN_AVB_RXD6___4 = 902,
	FN_VI2_D5_C5 = 903,
	FN_AVB_RXD7___4 = 904,
	FN_VI2_D6_C6 = 905,
	FN_AVB_RX_ER___4 = 906,
	FN_VI2_D7_C7 = 907,
	FN_AVB_COL___4 = 908,
	FN_VI2_D8_Y0 = 909,
	FN_AVB_TXD3___4 = 910,
	FN_VI2_D9_Y1 = 911,
	FN_AVB_TX_EN___4 = 912,
	FN_VI2_D10_Y2 = 913,
	FN_AVB_TXD0___4 = 914,
	FN_VI2_D11_Y3 = 915,
	FN_AVB_TXD1___4 = 916,
	FN_VI2_FIELD___3 = 917,
	FN_AVB_TXD2___4 = 918,
	FN_VI3_CLK___2 = 919,
	FN_AVB_TX_CLK___4 = 920,
	FN_VI3_CLKENB___2 = 921,
	FN_AVB_TXD4___4 = 922,
	FN_VI3_HSYNC_N = 923,
	FN_AVB_TXD5___4 = 924,
	FN_VI3_VSYNC_N = 925,
	FN_AVB_TXD6___4 = 926,
	FN_VI3_D0_C0 = 927,
	FN_AVB_TXD7___4 = 928,
	FN_VI3_D1_C1 = 929,
	FN_AVB_TX_ER___4 = 930,
	FN_VI3_D2_C2 = 931,
	FN_AVB_GTX_CLK___4 = 932,
	FN_VI3_D3_C3 = 933,
	FN_AVB_MDC___4 = 934,
	FN_VI3_D4_C4 = 935,
	FN_AVB_MDIO___4 = 936,
	FN_VI3_D5_C5 = 937,
	FN_AVB_LINK___4 = 938,
	FN_VI3_D6_C6 = 939,
	FN_AVB_MAGIC___4 = 940,
	FN_VI3_D7_C7 = 941,
	FN_AVB_PHY_INT___4 = 942,
	FN_VI3_D8_Y0 = 943,
	FN_AVB_CRS___4 = 944,
	FN_VI3_D9_Y1 = 945,
	FN_AVB_GTXREFCLK___4 = 946,
	FN_VI3_D11_Y3 = 947,
	FN_AVB_AVTP_MATCH = 948,
	FN_VI4_CLKENB = 949,
	FN_VI0_D12_G4_Y4 = 950,
	FN_VI4_HSYNC_N = 951,
	FN_VI0_D13_G5_Y5 = 952,
	FN_VI4_VSYNC_N = 953,
	FN_VI0_D14_G6_Y6 = 954,
	FN_RDR_CLKOUT = 955,
	FN_VI4_D0_C0 = 956,
	FN_VI0_D15_G7_Y7 = 957,
	FN_VI4_D1_C1 = 958,
	FN_VI0_D16_R0 = 959,
	FN_VI1_D12_G4_Y4 = 960,
	FN_VI4_D2_C2 = 961,
	FN_VI0_D17_R1 = 962,
	FN_VI1_D13_G5_Y5 = 963,
	FN_VI4_D3_C3 = 964,
	FN_VI0_D18_R2 = 965,
	FN_VI1_D14_G6_Y6 = 966,
	FN_VI4_D4_C4 = 967,
	FN_VI0_D19_R3 = 968,
	FN_VI1_D15_G7_Y7 = 969,
	FN_VI4_D5_C5 = 970,
	FN_VI0_D20_R4 = 971,
	FN_VI2_D12_Y4 = 972,
	FN_VI4_D6_C6 = 973,
	FN_VI0_D21_R5 = 974,
	FN_VI2_D13_Y5 = 975,
	FN_VI4_D7_C7 = 976,
	FN_VI0_D22_R6 = 977,
	FN_VI2_D14_Y6 = 978,
	FN_VI4_D8_Y0 = 979,
	FN_VI0_D23_R7 = 980,
	FN_VI2_D15_Y7 = 981,
	FN_VI4_D9_Y1 = 982,
	FN_VI3_D12_Y4 = 983,
	FN_VI4_D10_Y2 = 984,
	FN_VI3_D13_Y5 = 985,
	FN_VI4_D11_Y3 = 986,
	FN_VI3_D14_Y6 = 987,
	FN_VI4_FIELD = 988,
	FN_VI3_D15_Y7 = 989,
	FN_VI5_CLKENB = 990,
	FN_VI1_D12_G4_Y4_B = 991,
	FN_VI5_HSYNC_N = 992,
	FN_VI1_D13_G5_Y5_B = 993,
	FN_VI5_VSYNC_N = 994,
	FN_VI1_D14_G6_Y6_B = 995,
	FN_VI5_D0_C0 = 996,
	FN_VI1_D15_G7_Y7_B = 997,
	FN_VI5_D1_C1 = 998,
	FN_VI1_D16_R0 = 999,
	FN_VI5_D2_C2 = 1000,
	FN_VI1_D17_R1 = 1001,
	FN_VI5_D3_C3 = 1002,
	FN_VI1_D18_R2 = 1003,
	FN_VI5_D4_C4 = 1004,
	FN_VI1_D19_R3 = 1005,
	FN_VI5_D5_C5 = 1006,
	FN_VI1_D20_R4 = 1007,
	FN_VI5_D6_C6 = 1008,
	FN_VI1_D21_R5 = 1009,
	FN_VI5_D7_C7 = 1010,
	FN_VI1_D22_R6 = 1011,
	FN_VI5_D8_Y0 = 1012,
	FN_VI1_D23_R7 = 1013,
	FN_MSIOF0_SCK___3 = 1014,
	FN_HSCK0___5 = 1015,
	FN_MSIOF0_SYNC___3 = 1016,
	FN_HCTS0_N___3 = 1017,
	FN_MSIOF0_TXD___3 = 1018,
	FN_HTX0___3 = 1019,
	FN_MSIOF0_RXD___3 = 1020,
	FN_HRX0___3 = 1021,
	FN_MSIOF1_SCK___3 = 1022,
	FN_HSCK1___4 = 1023,
	FN_MSIOF1_SYNC___3 = 1024,
	FN_HRTS1_N___2 = 1025,
	FN_MSIOF1_TXD___3 = 1026,
	FN_HTX1___3 = 1027,
	FN_MSIOF1_RXD___3 = 1028,
	FN_HRX1___3 = 1029,
	FN_DRACK0___6 = 1030,
	FN_SCK2___2 = 1031,
	FN_DACK0___6 = 1032,
	FN_TX2___3 = 1033,
	FN_DREQ0_N___3 = 1034,
	FN_RX2___3 = 1035,
	FN_DACK1___5 = 1036,
	FN_SCK3___2 = 1037,
	FN_TX3___2 = 1038,
	FN_DREQ1_N___3 = 1039,
	FN_RX3___2 = 1040,
	FN_PWM0___4 = 1041,
	FN_TCLK1___5 = 1042,
	FN_FSO_CFE_0 = 1043,
	FN_PWM1___5 = 1044,
	FN_TCLK2___3 = 1045,
	FN_FSO_CFE_1 = 1046,
	FN_PWM2___5 = 1047,
	FN_TCLK3 = 1048,
	FN_FSO_TOE = 1049,
	FN_PWM3___5 = 1050,
	FN_PWM4___5 = 1051,
	FN_SSI_SCK34___6 = 1052,
	FN_TPU0TO0 = 1053,
	FN_SSI_WS34___6 = 1054,
	FN_TPU0TO1 = 1055,
	FN_SSI_SDATA3___6 = 1056,
	FN_TPU0TO2 = 1057,
	FN_SSI_SCK4___5 = 1058,
	FN_TPU0TO3 = 1059,
	FN_SSI_WS4___5 = 1060,
	FN_SSI_SDATA4___5 = 1061,
	FN_AUDIO_CLKOUT___4 = 1062,
	FN_AUDIO_CLKA___5 = 1063,
	FN_AUDIO_CLKB___5 = 1064,
	FN_SEL_VI1_0___2 = 1065,
	FN_SEL_VI1_1___2 = 1066,
	PINMUX_FUNCTION_END___10 = 1067,
	PINMUX_MARK_BEGIN___10 = 1068,
	DU1_DB2_C0_DATA12_MARK = 1069,
	DU1_DB3_C1_DATA13_MARK = 1070,
	DU1_DB4_C2_DATA14_MARK = 1071,
	DU1_DB5_C3_DATA15_MARK = 1072,
	DU1_DB6_C4_MARK = 1073,
	DU1_DB7_C5_MARK = 1074,
	DU1_EXHSYNC_DU1_HSYNC_MARK___6 = 1075,
	DU1_EXVSYNC_DU1_VSYNC_MARK___6 = 1076,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK___6 = 1077,
	DU1_DISP_MARK___6 = 1078,
	DU1_CDE_MARK___6 = 1079,
	D0_MARK___6 = 1080,
	D1_MARK___6 = 1081,
	D2_MARK___6 = 1082,
	D3_MARK___6 = 1083,
	D4_MARK___6 = 1084,
	D5_MARK___6 = 1085,
	D6_MARK___6 = 1086,
	D7_MARK___6 = 1087,
	D8_MARK___6 = 1088,
	D9_MARK___6 = 1089,
	D10_MARK___6 = 1090,
	D11_MARK___6 = 1091,
	D12_MARK___5 = 1092,
	D13_MARK___5 = 1093,
	D14_MARK___5 = 1094,
	D15_MARK___5 = 1095,
	A0_MARK___9 = 1096,
	A1_MARK___7 = 1097,
	A2_MARK___7 = 1098,
	A3_MARK___7 = 1099,
	A4_MARK___6 = 1100,
	A5_MARK___6 = 1101,
	A6_MARK___7 = 1102,
	A7_MARK___7 = 1103,
	A8_MARK___7 = 1104,
	A9_MARK___7 = 1105,
	A10_MARK___7 = 1106,
	A11_MARK___7 = 1107,
	A12_MARK___7 = 1108,
	A13_MARK___7 = 1109,
	A14_MARK___7 = 1110,
	A15_MARK___7 = 1111,
	A16_MARK___7 = 1112,
	A17_MARK___8 = 1113,
	A18_MARK___8 = 1114,
	A19_MARK___8 = 1115,
	CS1_N_A26_MARK___4 = 1116,
	EX_CS0_N_MARK___3 = 1117,
	EX_CS1_N_MARK___3 = 1118,
	EX_CS2_N_MARK___3 = 1119,
	EX_CS3_N_MARK___3 = 1120,
	EX_CS4_N_MARK___3 = 1121,
	EX_CS5_N_MARK___3 = 1122,
	BS_N_MARK___4 = 1123,
	RD_N_MARK___5 = 1124,
	RD_WR_N_MARK___4 = 1125,
	WE0_N_MARK___5 = 1126,
	WE1_N_MARK___5 = 1127,
	EX_WAIT0_MARK___5 = 1128,
	IRQ0_MARK___7 = 1129,
	IRQ1_MARK___7 = 1130,
	IRQ2_MARK___6 = 1131,
	IRQ3_MARK___6 = 1132,
	CS0_N_MARK___5 = 1133,
	VI0_CLK_MARK___6 = 1134,
	VI0_CLKENB_MARK___6 = 1135,
	VI0_HSYNC_N_MARK___4 = 1136,
	VI0_VSYNC_N_MARK___4 = 1137,
	VI0_D0_B0_C0_MARK = 1138,
	VI0_D1_B1_C1_MARK = 1139,
	VI0_D2_B2_C2_MARK = 1140,
	VI0_D3_B3_C3_MARK = 1141,
	VI0_D4_B4_C4_MARK = 1142,
	VI0_D5_B5_C5_MARK = 1143,
	VI0_D6_B6_C6_MARK = 1144,
	VI0_D7_B7_C7_MARK = 1145,
	VI0_D8_G0_Y0_MARK = 1146,
	VI0_D9_G1_Y1_MARK = 1147,
	VI0_D10_G2_Y2_MARK = 1148,
	VI0_D11_G3_Y3_MARK = 1149,
	VI0_FIELD_MARK___6 = 1150,
	VI1_CLK_MARK___6 = 1151,
	VI1_CLKENB_MARK___6 = 1152,
	VI1_HSYNC_N_MARK___4 = 1153,
	VI1_VSYNC_N_MARK___4 = 1154,
	VI1_D0_B0_C0_MARK = 1155,
	VI1_D1_B1_C1_MARK = 1156,
	VI1_D2_B2_C2_MARK = 1157,
	VI1_D3_B3_C3_MARK = 1158,
	VI1_D4_B4_C4_MARK = 1159,
	VI1_D5_B5_C5_MARK = 1160,
	VI1_D6_B6_C6_MARK = 1161,
	VI1_D7_B7_C7_MARK = 1162,
	VI1_D8_G0_Y0_MARK = 1163,
	VI1_D9_G1_Y1_MARK = 1164,
	VI1_D10_G2_Y2_MARK = 1165,
	VI1_D11_G3_Y3_MARK = 1166,
	VI1_FIELD_MARK___6 = 1167,
	VI3_D10_Y2_MARK = 1168,
	VI3_FIELD_MARK___2 = 1169,
	VI4_CLK_MARK = 1170,
	VI5_CLK_MARK = 1171,
	VI5_D9_Y1_MARK = 1172,
	VI5_D10_Y2_MARK = 1173,
	VI5_D11_Y3_MARK = 1174,
	VI5_FIELD_MARK = 1175,
	HRTS0_N_MARK___3 = 1176,
	HCTS1_N_MARK___2 = 1177,
	SCK0_MARK___3 = 1178,
	CTS0_N_MARK = 1179,
	RTS0_N_MARK = 1180,
	TX0_MARK___3 = 1181,
	RX0_MARK___3 = 1182,
	SCK1_MARK___2 = 1183,
	CTS1_N_MARK = 1184,
	RTS1_N_MARK = 1185,
	TX1_MARK___3 = 1186,
	RX1_MARK___3 = 1187,
	SCIF_CLK_MARK___5 = 1188,
	CAN0_TX_MARK___4 = 1189,
	CAN0_RX_MARK___4 = 1190,
	CAN_CLK_MARK___4 = 1191,
	CAN1_TX_MARK___4 = 1192,
	CAN1_RX_MARK___4 = 1193,
	SD0_CLK_MARK___6 = 1194,
	SD0_CMD_MARK___6 = 1195,
	SD0_DAT0_MARK___4 = 1196,
	SD0_DAT1_MARK___4 = 1197,
	SD0_DAT2_MARK___4 = 1198,
	SD0_DAT3_MARK___4 = 1199,
	SD0_CD_MARK___6 = 1200,
	SD0_WP_MARK___6 = 1201,
	ADICLK_MARK___5 = 1202,
	ADICS_SAMP_MARK___5 = 1203,
	ADIDATA_MARK___5 = 1204,
	ADICHS0_MARK___5 = 1205,
	ADICHS1_MARK___5 = 1206,
	ADICHS2_MARK___5 = 1207,
	AVS1_MARK___3 = 1208,
	AVS2_MARK___3 = 1209,
	DU0_DR0_DATA0_MARK = 1210,
	DU0_DR1_DATA1_MARK = 1211,
	DU0_DR2_Y4_DATA2_MARK = 1212,
	DU0_DR3_Y5_DATA3_MARK = 1213,
	DU0_DR4_Y6_DATA4_MARK = 1214,
	DU0_DR5_Y7_DATA5_MARK = 1215,
	DU0_DR6_Y8_DATA6_MARK = 1216,
	DU0_DR7_Y9_DATA7_MARK = 1217,
	DU0_DG0_DATA8_MARK = 1218,
	DU0_DG1_DATA9_MARK = 1219,
	DU0_DG2_C6_DATA10_MARK = 1220,
	DU0_DG3_C7_DATA11_MARK = 1221,
	DU0_DG4_Y0_DATA12_MARK = 1222,
	DU0_DG5_Y1_DATA13_MARK = 1223,
	DU0_DG6_Y2_DATA14_MARK = 1224,
	DU0_DG7_Y3_DATA15_MARK = 1225,
	DU0_DB0_MARK___6 = 1226,
	DU0_DB1_MARK___6 = 1227,
	DU0_DB2_C0_MARK = 1228,
	DU0_DB3_C1_MARK = 1229,
	DU0_DB4_C2_MARK = 1230,
	DU0_DB5_C3_MARK = 1231,
	DU0_DB6_C4_MARK = 1232,
	DU0_DB7_C5_MARK = 1233,
	DU0_EXHSYNC_DU0_HSYNC_MARK___5 = 1234,
	DU0_EXVSYNC_DU0_VSYNC_MARK___5 = 1235,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK___5 = 1236,
	DU0_DISP_MARK___5 = 1237,
	DU0_CDE_MARK___6 = 1238,
	DU1_DR2_Y4_DATA0_MARK = 1239,
	DU1_DR3_Y5_DATA1_MARK = 1240,
	DU1_DR4_Y6_DATA2_MARK = 1241,
	DU1_DR5_Y7_DATA3_MARK = 1242,
	DU1_DR6_DATA4_MARK = 1243,
	DU1_DR7_DATA5_MARK = 1244,
	DU1_DG2_C6_DATA6_MARK = 1245,
	DU1_DG3_C7_DATA7_MARK = 1246,
	DU1_DG4_Y0_DATA8_MARK = 1247,
	DU1_DG5_Y1_DATA9_MARK = 1248,
	DU1_DG6_Y2_DATA10_MARK = 1249,
	DU1_DG7_Y3_DATA11_MARK = 1250,
	A20_MARK___8 = 1251,
	MOSI_IO0_MARK___3 = 1252,
	A21_MARK___8 = 1253,
	MISO_IO1_MARK___3 = 1254,
	A22_MARK___8 = 1255,
	IO2_MARK___3 = 1256,
	A23_MARK___8 = 1257,
	IO3_MARK___3 = 1258,
	A24_MARK___8 = 1259,
	SPCLK_MARK___3 = 1260,
	A25_MARK___8 = 1261,
	SSL_MARK___3 = 1262,
	VI2_CLK_MARK___3 = 1263,
	AVB_RX_CLK_MARK___4 = 1264,
	VI2_CLKENB_MARK___3 = 1265,
	AVB_RX_DV_MARK___4 = 1266,
	VI2_HSYNC_N_MARK___2 = 1267,
	AVB_RXD0_MARK___4 = 1268,
	VI2_VSYNC_N_MARK___2 = 1269,
	AVB_RXD1_MARK___4 = 1270,
	VI2_D0_C0_MARK = 1271,
	AVB_RXD2_MARK___4 = 1272,
	VI2_D1_C1_MARK = 1273,
	AVB_TX_CLK_MARK___4 = 1274,
	VI2_D2_C2_MARK = 1275,
	AVB_RXD4_MARK___4 = 1276,
	VI2_D3_C3_MARK = 1277,
	AVB_RXD5_MARK___4 = 1278,
	VI2_D4_C4_MARK = 1279,
	AVB_RXD6_MARK___4 = 1280,
	VI2_D5_C5_MARK = 1281,
	AVB_RXD7_MARK___4 = 1282,
	VI2_D6_C6_MARK = 1283,
	AVB_RX_ER_MARK___4 = 1284,
	VI2_D7_C7_MARK = 1285,
	AVB_COL_MARK___4 = 1286,
	VI2_D8_Y0_MARK = 1287,
	AVB_RXD3_MARK___4 = 1288,
	VI2_D9_Y1_MARK = 1289,
	AVB_TX_EN_MARK___4 = 1290,
	VI2_D10_Y2_MARK = 1291,
	AVB_TXD0_MARK___4 = 1292,
	VI2_D11_Y3_MARK = 1293,
	AVB_TXD1_MARK___4 = 1294,
	VI2_FIELD_MARK___3 = 1295,
	AVB_TXD2_MARK___4 = 1296,
	VI3_CLK_MARK___2 = 1297,
	AVB_TXD3_MARK___4 = 1298,
	VI3_CLKENB_MARK___2 = 1299,
	AVB_TXD4_MARK___4 = 1300,
	VI3_HSYNC_N_MARK = 1301,
	AVB_TXD5_MARK___4 = 1302,
	VI3_VSYNC_N_MARK = 1303,
	AVB_TXD6_MARK___4 = 1304,
	VI3_D0_C0_MARK = 1305,
	AVB_TXD7_MARK___4 = 1306,
	VI3_D1_C1_MARK = 1307,
	AVB_TX_ER_MARK___4 = 1308,
	VI3_D2_C2_MARK = 1309,
	AVB_GTX_CLK_MARK___4 = 1310,
	VI3_D3_C3_MARK = 1311,
	AVB_MDC_MARK___4 = 1312,
	VI3_D4_C4_MARK = 1313,
	AVB_MDIO_MARK___4 = 1314,
	VI3_D5_C5_MARK = 1315,
	AVB_LINK_MARK___4 = 1316,
	VI3_D6_C6_MARK = 1317,
	AVB_MAGIC_MARK___4 = 1318,
	VI3_D7_C7_MARK = 1319,
	AVB_PHY_INT_MARK___4 = 1320,
	VI3_D8_Y0_MARK = 1321,
	AVB_CRS_MARK___4 = 1322,
	VI3_D9_Y1_MARK = 1323,
	AVB_GTXREFCLK_MARK___4 = 1324,
	VI3_D11_Y3_MARK = 1325,
	AVB_AVTP_MATCH_MARK = 1326,
	VI4_CLKENB_MARK = 1327,
	VI0_D12_G4_Y4_MARK = 1328,
	VI4_HSYNC_N_MARK = 1329,
	VI0_D13_G5_Y5_MARK = 1330,
	VI4_VSYNC_N_MARK = 1331,
	VI0_D14_G6_Y6_MARK = 1332,
	RDR_CLKOUT_MARK = 1333,
	VI4_D0_C0_MARK = 1334,
	VI0_D15_G7_Y7_MARK = 1335,
	VI4_D1_C1_MARK = 1336,
	VI0_D16_R0_MARK = 1337,
	VI1_D12_G4_Y4_MARK = 1338,
	VI4_D2_C2_MARK = 1339,
	VI0_D17_R1_MARK = 1340,
	VI1_D13_G5_Y5_MARK = 1341,
	VI4_D3_C3_MARK = 1342,
	VI0_D18_R2_MARK = 1343,
	VI1_D14_G6_Y6_MARK = 1344,
	VI4_D4_C4_MARK = 1345,
	VI0_D19_R3_MARK = 1346,
	VI1_D15_G7_Y7_MARK = 1347,
	VI4_D5_C5_MARK = 1348,
	VI0_D20_R4_MARK = 1349,
	VI2_D12_Y4_MARK = 1350,
	VI4_D6_C6_MARK = 1351,
	VI0_D21_R5_MARK = 1352,
	VI2_D13_Y5_MARK = 1353,
	VI4_D7_C7_MARK = 1354,
	VI0_D22_R6_MARK = 1355,
	VI2_D14_Y6_MARK = 1356,
	VI4_D8_Y0_MARK = 1357,
	VI0_D23_R7_MARK = 1358,
	VI2_D15_Y7_MARK = 1359,
	VI4_D9_Y1_MARK = 1360,
	VI3_D12_Y4_MARK = 1361,
	VI4_D10_Y2_MARK = 1362,
	VI3_D13_Y5_MARK = 1363,
	VI4_D11_Y3_MARK = 1364,
	VI3_D14_Y6_MARK = 1365,
	VI4_FIELD_MARK = 1366,
	VI3_D15_Y7_MARK = 1367,
	VI5_CLKENB_MARK = 1368,
	VI1_D12_G4_Y4_B_MARK = 1369,
	VI5_HSYNC_N_MARK = 1370,
	VI1_D13_G5_Y5_B_MARK = 1371,
	VI5_VSYNC_N_MARK = 1372,
	VI1_D14_G6_Y6_B_MARK = 1373,
	VI5_D0_C0_MARK = 1374,
	VI1_D15_G7_Y7_B_MARK = 1375,
	VI5_D1_C1_MARK = 1376,
	VI1_D16_R0_MARK = 1377,
	VI5_D2_C2_MARK = 1378,
	VI1_D17_R1_MARK = 1379,
	VI5_D3_C3_MARK = 1380,
	VI1_D18_R2_MARK = 1381,
	VI5_D4_C4_MARK = 1382,
	VI1_D19_R3_MARK = 1383,
	VI5_D5_C5_MARK = 1384,
	VI1_D20_R4_MARK = 1385,
	VI5_D6_C6_MARK = 1386,
	VI1_D21_R5_MARK = 1387,
	VI5_D7_C7_MARK = 1388,
	VI1_D22_R6_MARK = 1389,
	VI5_D8_Y0_MARK = 1390,
	VI1_D23_R7_MARK = 1391,
	MSIOF0_SCK_MARK___4 = 1392,
	HSCK0_MARK___5 = 1393,
	MSIOF0_SYNC_MARK___4 = 1394,
	HCTS0_N_MARK___3 = 1395,
	MSIOF0_TXD_MARK___6 = 1396,
	HTX0_MARK___3 = 1397,
	MSIOF0_RXD_MARK___6 = 1398,
	HRX0_MARK___3 = 1399,
	MSIOF1_SCK_MARK___4 = 1400,
	HSCK1_MARK___4 = 1401,
	MSIOF1_SYNC_MARK___4 = 1402,
	HRTS1_N_MARK___2 = 1403,
	MSIOF1_TXD_MARK___5 = 1404,
	HTX1_MARK___3 = 1405,
	MSIOF1_RXD_MARK___5 = 1406,
	HRX1_MARK___3 = 1407,
	DRACK0_MARK___6 = 1408,
	SCK2_MARK___2 = 1409,
	DACK0_MARK___8 = 1410,
	TX2_MARK___3 = 1411,
	DREQ0_N_MARK___3 = 1412,
	RX2_MARK___3 = 1413,
	DACK1_MARK___7 = 1414,
	SCK3_MARK___2 = 1415,
	TX3_MARK___2 = 1416,
	DREQ1_N_MARK___3 = 1417,
	RX3_MARK___2 = 1418,
	PWM0_MARK___5 = 1419,
	TCLK1_MARK___5 = 1420,
	FSO_CFE_0_MARK = 1421,
	PWM1_MARK___6 = 1422,
	TCLK2_MARK___3 = 1423,
	FSO_CFE_1_MARK = 1424,
	PWM2_MARK___5 = 1425,
	TCLK3_MARK = 1426,
	FSO_TOE_MARK = 1427,
	PWM3_MARK___5 = 1428,
	PWM4_MARK___5 = 1429,
	SSI_SCK34_MARK___6 = 1430,
	TPU0TO0_MARK___4 = 1431,
	SSI_WS34_MARK___6 = 1432,
	TPU0TO1_MARK___4 = 1433,
	SSI_SDATA3_MARK___6 = 1434,
	TPU0TO2_MARK___3 = 1435,
	SSI_SCK4_MARK___5 = 1436,
	TPU0TO3_MARK___4 = 1437,
	SSI_WS4_MARK___5 = 1438,
	SSI_SDATA4_MARK___5 = 1439,
	AUDIO_CLKOUT_MARK___4 = 1440,
	AUDIO_CLKA_MARK___5 = 1441,
	AUDIO_CLKB_MARK___5 = 1442,
	PINMUX_MARK_END___10 = 1443,
};

enum {
	PINMUX_RESERVED___11 = 0,
	PINMUX_DATA_BEGIN___11 = 1,
	GP_0_0_DATA___7 = 2,
	GP_0_1_DATA___7 = 3,
	GP_0_2_DATA___7 = 4,
	GP_0_3_DATA___7 = 5,
	GP_0_4_DATA___7 = 6,
	GP_0_5_DATA___7 = 7,
	GP_0_6_DATA___7 = 8,
	GP_0_7_DATA___7 = 9,
	GP_0_8_DATA___7 = 10,
	GP_0_9_DATA___7 = 11,
	GP_0_10_DATA___7 = 12,
	GP_0_11_DATA___7 = 13,
	GP_0_12_DATA___7 = 14,
	GP_0_13_DATA___7 = 15,
	GP_0_14_DATA___7 = 16,
	GP_0_15_DATA___7 = 17,
	GP_0_16_DATA___7 = 18,
	GP_0_17_DATA___7 = 19,
	GP_0_18_DATA___7 = 20,
	GP_0_19_DATA___7 = 21,
	GP_0_20_DATA___7 = 22,
	GP_0_21_DATA___7 = 23,
	GP_0_22_DATA___7 = 24,
	GP_0_23_DATA___6 = 25,
	GP_0_24_DATA___6 = 26,
	GP_0_25_DATA___6 = 27,
	GP_0_26_DATA___6 = 28,
	GP_0_27_DATA___6 = 29,
	GP_0_28_DATA___6 = 30,
	GP_0_29_DATA___5 = 31,
	GP_0_30_DATA___5 = 32,
	GP_0_31_DATA___5 = 33,
	GP_1_0_DATA___7 = 34,
	GP_1_1_DATA___7 = 35,
	GP_1_2_DATA___7 = 36,
	GP_1_3_DATA___7 = 37,
	GP_1_4_DATA___7 = 38,
	GP_1_5_DATA___7 = 39,
	GP_1_6_DATA___7 = 40,
	GP_1_7_DATA___7 = 41,
	GP_1_8_DATA___7 = 42,
	GP_1_9_DATA___7 = 43,
	GP_1_10_DATA___7 = 44,
	GP_1_11_DATA___7 = 45,
	GP_1_12_DATA___7 = 46,
	GP_1_13_DATA___7 = 47,
	GP_1_14_DATA___7 = 48,
	GP_1_15_DATA___7 = 49,
	GP_1_16_DATA___7 = 50,
	GP_1_17_DATA___7 = 51,
	GP_1_18_DATA___7 = 52,
	GP_1_19_DATA___7 = 53,
	GP_1_20_DATA___7 = 54,
	GP_1_21_DATA___7 = 55,
	GP_1_22_DATA___7 = 56,
	GP_1_23_DATA___5 = 57,
	GP_1_24_DATA___5 = 58,
	GP_1_25_DATA___5 = 59,
	GP_1_26_DATA___3 = 60,
	GP_1_27_DATA___3 = 61,
	GP_1_28_DATA___3 = 62,
	GP_1_29_DATA___3 = 63,
	GP_2_0_DATA___7 = 64,
	GP_2_1_DATA___7 = 65,
	GP_2_2_DATA___7 = 66,
	GP_2_3_DATA___7 = 67,
	GP_2_4_DATA___7 = 68,
	GP_2_5_DATA___7 = 69,
	GP_2_6_DATA___7 = 70,
	GP_2_7_DATA___7 = 71,
	GP_2_8_DATA___7 = 72,
	GP_2_9_DATA___7 = 73,
	GP_2_10_DATA___7 = 74,
	GP_2_11_DATA___7 = 75,
	GP_2_12_DATA___7 = 76,
	GP_2_13_DATA___7 = 77,
	GP_2_14_DATA___7 = 78,
	GP_2_15_DATA___7 = 79,
	GP_2_16_DATA___7 = 80,
	GP_2_17_DATA___7 = 81,
	GP_2_18_DATA___7 = 82,
	GP_2_19_DATA___7 = 83,
	GP_2_20_DATA___7 = 84,
	GP_2_21_DATA___7 = 85,
	GP_2_22_DATA___7 = 86,
	GP_2_23_DATA___7 = 87,
	GP_2_24_DATA___7 = 88,
	GP_2_25_DATA___7 = 89,
	GP_2_26_DATA___7 = 90,
	GP_2_27_DATA___7 = 91,
	GP_2_28_DATA___7 = 92,
	GP_2_29_DATA___7 = 93,
	GP_3_0_DATA___7 = 94,
	GP_3_1_DATA___7 = 95,
	GP_3_2_DATA___7 = 96,
	GP_3_3_DATA___7 = 97,
	GP_3_4_DATA___7 = 98,
	GP_3_5_DATA___7 = 99,
	GP_3_6_DATA___7 = 100,
	GP_3_7_DATA___7 = 101,
	GP_3_8_DATA___7 = 102,
	GP_3_9_DATA___7 = 103,
	GP_3_10_DATA___7 = 104,
	GP_3_11_DATA___7 = 105,
	GP_3_12_DATA___7 = 106,
	GP_3_13_DATA___7 = 107,
	GP_3_14_DATA___7 = 108,
	GP_3_15_DATA___7 = 109,
	GP_3_16_DATA___7 = 110,
	GP_3_17_DATA___6 = 111,
	GP_3_18_DATA___6 = 112,
	GP_3_19_DATA___6 = 113,
	GP_3_20_DATA___6 = 114,
	GP_3_21_DATA___6 = 115,
	GP_3_22_DATA___6 = 116,
	GP_3_23_DATA___6 = 117,
	GP_3_24_DATA___6 = 118,
	GP_3_25_DATA___6 = 119,
	GP_3_26_DATA___6 = 120,
	GP_3_27_DATA___7 = 121,
	GP_3_28_DATA___6 = 122,
	GP_3_29_DATA___6 = 123,
	GP_3_30_DATA___5 = 124,
	GP_3_31_DATA___5 = 125,
	GP_4_0_DATA___7 = 126,
	GP_4_1_DATA___7 = 127,
	GP_4_2_DATA___7 = 128,
	GP_4_3_DATA___7 = 129,
	GP_4_4_DATA___7 = 130,
	GP_4_5_DATA___7 = 131,
	GP_4_6_DATA___7 = 132,
	GP_4_7_DATA___7 = 133,
	GP_4_8_DATA___7 = 134,
	GP_4_9_DATA___7 = 135,
	GP_4_10_DATA___7 = 136,
	GP_4_11_DATA___7 = 137,
	GP_4_12_DATA___7 = 138,
	GP_4_13_DATA___7 = 139,
	GP_4_14_DATA___7 = 140,
	GP_4_15_DATA___7 = 141,
	GP_4_16_DATA___7 = 142,
	GP_4_17_DATA___6 = 143,
	GP_4_18_DATA___6 = 144,
	GP_4_19_DATA___6 = 145,
	GP_4_20_DATA___6 = 146,
	GP_4_21_DATA___6 = 147,
	GP_4_22_DATA___6 = 148,
	GP_4_23_DATA___6 = 149,
	GP_4_24_DATA___6 = 150,
	GP_4_25_DATA___6 = 151,
	GP_4_26_DATA___5 = 152,
	GP_4_27_DATA___4 = 153,
	GP_4_28_DATA___4 = 154,
	GP_4_29_DATA___4 = 155,
	GP_4_30_DATA___4 = 156,
	GP_4_31_DATA___4 = 157,
	GP_5_0_DATA___6 = 158,
	GP_5_1_DATA___6 = 159,
	GP_5_2_DATA___6 = 160,
	GP_5_3_DATA___6 = 161,
	GP_5_4_DATA___6 = 162,
	GP_5_5_DATA___6 = 163,
	GP_5_6_DATA___6 = 164,
	GP_5_7_DATA___6 = 165,
	GP_5_8_DATA___6 = 166,
	GP_5_9_DATA___6 = 167,
	GP_5_10_DATA___6 = 168,
	GP_5_11_DATA___6 = 169,
	GP_5_12_DATA___6 = 170,
	GP_5_13_DATA___6 = 171,
	GP_5_14_DATA___6 = 172,
	GP_5_15_DATA___6 = 173,
	GP_5_16_DATA___6 = 174,
	GP_5_17_DATA___5 = 175,
	GP_5_18_DATA___5 = 176,
	GP_5_19_DATA___5 = 177,
	GP_5_20_DATA___5 = 178,
	GP_5_21_DATA___5 = 179,
	GP_5_22_DATA___5 = 180,
	GP_5_23_DATA___5 = 181,
	GP_5_24_DATA___5 = 182,
	GP_5_25_DATA___5 = 183,
	GP_5_26_DATA___5 = 184,
	GP_5_27_DATA___5 = 185,
	GP_5_28_DATA___4 = 186,
	GP_5_29_DATA___4 = 187,
	GP_5_30_DATA___4 = 188,
	GP_5_31_DATA___4 = 189,
	PINMUX_DATA_END___11 = 190,
	PINMUX_FUNCTION_BEGIN___11 = 191,
	GP_0_0_FN___7 = 192,
	GP_0_1_FN___7 = 193,
	GP_0_2_FN___7 = 194,
	GP_0_3_FN___7 = 195,
	GP_0_4_FN___7 = 196,
	GP_0_5_FN___7 = 197,
	GP_0_6_FN___7 = 198,
	GP_0_7_FN___7 = 199,
	GP_0_8_FN___7 = 200,
	GP_0_9_FN___7 = 201,
	GP_0_10_FN___7 = 202,
	GP_0_11_FN___7 = 203,
	GP_0_12_FN___7 = 204,
	GP_0_13_FN___7 = 205,
	GP_0_14_FN___7 = 206,
	GP_0_15_FN___7 = 207,
	GP_0_16_FN___7 = 208,
	GP_0_17_FN___7 = 209,
	GP_0_18_FN___7 = 210,
	GP_0_19_FN___7 = 211,
	GP_0_20_FN___7 = 212,
	GP_0_21_FN___7 = 213,
	GP_0_22_FN___7 = 214,
	GP_0_23_FN___6 = 215,
	GP_0_24_FN___6 = 216,
	GP_0_25_FN___6 = 217,
	GP_0_26_FN___6 = 218,
	GP_0_27_FN___6 = 219,
	GP_0_28_FN___6 = 220,
	GP_0_29_FN___5 = 221,
	GP_0_30_FN___5 = 222,
	GP_0_31_FN___5 = 223,
	GP_1_0_FN___7 = 224,
	GP_1_1_FN___7 = 225,
	GP_1_2_FN___7 = 226,
	GP_1_3_FN___7 = 227,
	GP_1_4_FN___7 = 228,
	GP_1_5_FN___7 = 229,
	GP_1_6_FN___7 = 230,
	GP_1_7_FN___7 = 231,
	GP_1_8_FN___7 = 232,
	GP_1_9_FN___7 = 233,
	GP_1_10_FN___7 = 234,
	GP_1_11_FN___7 = 235,
	GP_1_12_FN___7 = 236,
	GP_1_13_FN___7 = 237,
	GP_1_14_FN___7 = 238,
	GP_1_15_FN___7 = 239,
	GP_1_16_FN___7 = 240,
	GP_1_17_FN___7 = 241,
	GP_1_18_FN___7 = 242,
	GP_1_19_FN___7 = 243,
	GP_1_20_FN___7 = 244,
	GP_1_21_FN___7 = 245,
	GP_1_22_FN___7 = 246,
	GP_1_23_FN___5 = 247,
	GP_1_24_FN___5 = 248,
	GP_1_25_FN___5 = 249,
	GP_1_26_FN___3 = 250,
	GP_1_27_FN___3 = 251,
	GP_1_28_FN___3 = 252,
	GP_1_29_FN___3 = 253,
	GP_2_0_FN___7 = 254,
	GP_2_1_FN___7 = 255,
	GP_2_2_FN___7 = 256,
	GP_2_3_FN___7 = 257,
	GP_2_4_FN___7 = 258,
	GP_2_5_FN___7 = 259,
	GP_2_6_FN___7 = 260,
	GP_2_7_FN___7 = 261,
	GP_2_8_FN___7 = 262,
	GP_2_9_FN___7 = 263,
	GP_2_10_FN___7 = 264,
	GP_2_11_FN___7 = 265,
	GP_2_12_FN___7 = 266,
	GP_2_13_FN___7 = 267,
	GP_2_14_FN___7 = 268,
	GP_2_15_FN___7 = 269,
	GP_2_16_FN___7 = 270,
	GP_2_17_FN___7 = 271,
	GP_2_18_FN___7 = 272,
	GP_2_19_FN___7 = 273,
	GP_2_20_FN___7 = 274,
	GP_2_21_FN___7 = 275,
	GP_2_22_FN___7 = 276,
	GP_2_23_FN___7 = 277,
	GP_2_24_FN___7 = 278,
	GP_2_25_FN___7 = 279,
	GP_2_26_FN___7 = 280,
	GP_2_27_FN___7 = 281,
	GP_2_28_FN___7 = 282,
	GP_2_29_FN___7 = 283,
	GP_3_0_FN___7 = 284,
	GP_3_1_FN___7 = 285,
	GP_3_2_FN___7 = 286,
	GP_3_3_FN___7 = 287,
	GP_3_4_FN___7 = 288,
	GP_3_5_FN___7 = 289,
	GP_3_6_FN___7 = 290,
	GP_3_7_FN___7 = 291,
	GP_3_8_FN___7 = 292,
	GP_3_9_FN___7 = 293,
	GP_3_10_FN___7 = 294,
	GP_3_11_FN___7 = 295,
	GP_3_12_FN___7 = 296,
	GP_3_13_FN___7 = 297,
	GP_3_14_FN___7 = 298,
	GP_3_15_FN___7 = 299,
	GP_3_16_FN___7 = 300,
	GP_3_17_FN___6 = 301,
	GP_3_18_FN___6 = 302,
	GP_3_19_FN___6 = 303,
	GP_3_20_FN___6 = 304,
	GP_3_21_FN___6 = 305,
	GP_3_22_FN___6 = 306,
	GP_3_23_FN___6 = 307,
	GP_3_24_FN___6 = 308,
	GP_3_25_FN___6 = 309,
	GP_3_26_FN___6 = 310,
	GP_3_27_FN___7 = 311,
	GP_3_28_FN___6 = 312,
	GP_3_29_FN___6 = 313,
	GP_3_30_FN___5 = 314,
	GP_3_31_FN___5 = 315,
	GP_4_0_FN___7 = 316,
	GP_4_1_FN___7 = 317,
	GP_4_2_FN___7 = 318,
	GP_4_3_FN___7 = 319,
	GP_4_4_FN___7 = 320,
	GP_4_5_FN___7 = 321,
	GP_4_6_FN___7 = 322,
	GP_4_7_FN___7 = 323,
	GP_4_8_FN___7 = 324,
	GP_4_9_FN___7 = 325,
	GP_4_10_FN___7 = 326,
	GP_4_11_FN___7 = 327,
	GP_4_12_FN___7 = 328,
	GP_4_13_FN___7 = 329,
	GP_4_14_FN___7 = 330,
	GP_4_15_FN___7 = 331,
	GP_4_16_FN___7 = 332,
	GP_4_17_FN___6 = 333,
	GP_4_18_FN___6 = 334,
	GP_4_19_FN___6 = 335,
	GP_4_20_FN___6 = 336,
	GP_4_21_FN___6 = 337,
	GP_4_22_FN___6 = 338,
	GP_4_23_FN___6 = 339,
	GP_4_24_FN___6 = 340,
	GP_4_25_FN___6 = 341,
	GP_4_26_FN___5 = 342,
	GP_4_27_FN___4 = 343,
	GP_4_28_FN___4 = 344,
	GP_4_29_FN___4 = 345,
	GP_4_30_FN___4 = 346,
	GP_4_31_FN___4 = 347,
	GP_5_0_FN___6 = 348,
	GP_5_1_FN___6 = 349,
	GP_5_2_FN___6 = 350,
	GP_5_3_FN___6 = 351,
	GP_5_4_FN___6 = 352,
	GP_5_5_FN___6 = 353,
	GP_5_6_FN___6 = 354,
	GP_5_7_FN___6 = 355,
	GP_5_8_FN___6 = 356,
	GP_5_9_FN___6 = 357,
	GP_5_10_FN___6 = 358,
	GP_5_11_FN___6 = 359,
	GP_5_12_FN___6 = 360,
	GP_5_13_FN___6 = 361,
	GP_5_14_FN___6 = 362,
	GP_5_15_FN___6 = 363,
	GP_5_16_FN___6 = 364,
	GP_5_17_FN___5 = 365,
	GP_5_18_FN___5 = 366,
	GP_5_19_FN___5 = 367,
	GP_5_20_FN___5 = 368,
	GP_5_21_FN___5 = 369,
	GP_5_22_FN___5 = 370,
	GP_5_23_FN___5 = 371,
	GP_5_24_FN___5 = 372,
	GP_5_25_FN___5 = 373,
	GP_5_26_FN___5 = 374,
	GP_5_27_FN___5 = 375,
	GP_5_28_FN___4 = 376,
	GP_5_29_FN___4 = 377,
	GP_5_30_FN___4 = 378,
	GP_5_31_FN___4 = 379,
	FN_IP0_2_0___2 = 380,
	FN_IP0_5_3___2 = 381,
	FN_IP0_8_6 = 382,
	FN_IP0_11_9 = 383,
	FN_IP0_15_12___2 = 384,
	FN_IP0_19_16___2 = 385,
	FN_IP0_22_20 = 386,
	FN_IP0_26_23 = 387,
	FN_IP0_30_27 = 388,
	FN_IP1_3_0___2 = 389,
	FN_IP1_7_4___2 = 390,
	FN_IP1_11_8___2 = 391,
	FN_IP1_14_12 = 392,
	FN_IP1_17_15___2 = 393,
	FN_IP1_21_18 = 394,
	FN_IP1_25_22 = 395,
	FN_IP1_27_26 = 396,
	FN_IP1_29_28___3 = 397,
	FN_IP2_2_0___3 = 398,
	FN_IP2_5_3___2 = 399,
	FN_IP2_8_6___2 = 400,
	FN_IP2_11_9___2 = 401,
	FN_IP2_14_12 = 402,
	FN_IP2_17_15 = 403,
	FN_IP2_21_18 = 404,
	FN_IP2_25_22 = 405,
	FN_IP2_28_26 = 406,
	FN_IP3_3_0___2 = 407,
	FN_IP3_7_4___2 = 408,
	FN_IP3_11_8___2 = 409,
	FN_IP3_14_12___2 = 410,
	FN_IP3_17_15___2 = 411,
	FN_IP3_19_18___2 = 412,
	FN_IP3_22_20 = 413,
	FN_IP3_25_23 = 414,
	FN_IP3_28_26 = 415,
	FN_IP3_31_29___2 = 416,
	FN_IP4_2_0 = 417,
	FN_IP4_5_3 = 418,
	FN_IP4_8_6 = 419,
	FN_IP4_11_9 = 420,
	FN_IP4_14_12 = 421,
	FN_IP4_17_15 = 422,
	FN_IP4_20_18 = 423,
	FN_IP4_23_21 = 424,
	FN_IP4_26_24 = 425,
	FN_IP4_29_27 = 426,
	FN_IP5_2_0___3 = 427,
	FN_IP5_5_3___2 = 428,
	FN_IP5_9_6 = 429,
	FN_IP5_12_10 = 430,
	FN_IP5_14_13___3 = 431,
	FN_IP5_17_15___2 = 432,
	FN_IP5_20_18___2 = 433,
	FN_IP5_23_21___2 = 434,
	FN_IP5_26_24 = 435,
	FN_IP5_29_27 = 436,
	FN_IP6_2_0___2 = 437,
	FN_IP6_5_3___2 = 438,
	FN_IP6_8_6 = 439,
	FN_IP6_10_9 = 440,
	FN_IP6_13_11 = 441,
	FN_IP7_28_27___2 = 442,
	FN_IP7_30_29___2 = 443,
	FN_IP8_1_0 = 444,
	FN_IP8_3_2 = 445,
	FN_IP8_5_4 = 446,
	FN_IP8_7_6 = 447,
	FN_IP8_9_8 = 448,
	FN_IP8_11_10 = 449,
	FN_IP8_13_12 = 450,
	FN_IP8_15_14___2 = 451,
	FN_IP8_17_16___2 = 452,
	FN_IP8_19_18 = 453,
	FN_IP8_21_20 = 454,
	FN_IP8_23_22___2 = 455,
	FN_IP8_25_24___2 = 456,
	FN_IP8_26 = 457,
	FN_IP8_27 = 458,
	FN_VI1_DATA7_VI1_B7___2 = 459,
	FN_IP6_16_14 = 460,
	FN_IP6_19_17___2 = 461,
	FN_IP6_22_20___3 = 462,
	FN_IP6_25_23___2 = 463,
	FN_IP6_28_26___2 = 464,
	FN_IP6_31_29___2 = 465,
	FN_IP7_2_0___3 = 466,
	FN_IP7_5_3___3 = 467,
	FN_IP7_7_6 = 468,
	FN_IP7_9_8___2 = 469,
	FN_IP7_12_10___2 = 470,
	FN_IP7_15_13 = 471,
	FN_IP8_28 = 472,
	FN_IP8_30_29 = 473,
	FN_IP9_1_0___2 = 474,
	FN_IP9_3_2___2 = 475,
	FN_IP9_5_4 = 476,
	FN_IP9_7_6 = 477,
	FN_IP9_11_8___2 = 478,
	FN_IP9_15_12___2 = 479,
	FN_IP9_17_16 = 480,
	FN_IP9_19_18 = 481,
	FN_IP9_21_20 = 482,
	FN_IP9_23_22___2 = 483,
	FN_IP9_25_24___2 = 484,
	FN_IP9_27_26___2 = 485,
	FN_IP9_31_28___2 = 486,
	FN_IP10_3_0___2 = 487,
	FN_IP10_6_4 = 488,
	FN_IP10_10_7 = 489,
	FN_IP10_14_11 = 490,
	FN_IP10_18_15 = 491,
	FN_IP10_22_19 = 492,
	FN_IP10_25_23 = 493,
	FN_IP10_29_26 = 494,
	FN_IP11_3_0___2 = 495,
	FN_IP11_4 = 496,
	FN_IP11_6_5 = 497,
	FN_IP11_8_7 = 498,
	FN_IP11_10_9 = 499,
	FN_IP11_12_11 = 500,
	FN_IP11_14_13 = 501,
	FN_IP11_17_15___2 = 502,
	FN_IP11_21_18 = 503,
	FN_IP11_23_22 = 504,
	FN_IP11_26_24___3 = 505,
	FN_IP11_29_27___3 = 506,
	FN_IP11_31_30___2 = 507,
	FN_IP12_1_0___2 = 508,
	FN_IP12_3_2___2 = 509,
	FN_IP12_5_4 = 510,
	FN_IP12_7_6 = 511,
	FN_IP12_10_8 = 512,
	FN_IP12_13_11 = 513,
	FN_IP12_16_14 = 514,
	FN_IP12_19_17 = 515,
	FN_IP12_22_20 = 516,
	FN_IP12_24_23 = 517,
	FN_IP12_27_25 = 518,
	FN_IP12_30_28 = 519,
	FN_IP13_2_0___3 = 520,
	FN_IP13_6_3 = 521,
	FN_IP13_9_7___2 = 522,
	FN_IP13_12_10 = 523,
	FN_IP13_15_13 = 524,
	FN_IP13_18_16___2 = 525,
	FN_IP13_22_19 = 526,
	FN_IP13_25_23 = 527,
	FN_IP13_28_26 = 528,
	FN_IP13_30_29 = 529,
	FN_IP14_2_0 = 530,
	FN_IP14_5_3 = 531,
	FN_IP14_8_6 = 532,
	FN_IP14_11_9 = 533,
	FN_IP14_15_12___2 = 534,
	FN_IP14_18_16 = 535,
	FN_IP14_21_19 = 536,
	FN_IP14_24_22 = 537,
	FN_IP14_27_25 = 538,
	FN_IP14_30_28 = 539,
	FN_IP15_2_0 = 540,
	FN_IP15_5_3 = 541,
	FN_IP15_8_6___2 = 542,
	FN_IP15_11_9___2 = 543,
	FN_IP15_13_12 = 544,
	FN_IP15_15_14 = 545,
	FN_IP15_17_16 = 546,
	FN_IP15_19_18 = 547,
	FN_IP15_22_20 = 548,
	FN_IP15_25_23 = 549,
	FN_IP15_27_26 = 550,
	FN_IP15_29_28 = 551,
	FN_IP16_2_0___2 = 552,
	FN_IP16_5_3___2 = 553,
	FN_USB0_PWEN___4 = 554,
	FN_USB0_OVC_VBUS = 555,
	FN_IP16_6 = 556,
	FN_IP16_7 = 557,
	FN_USB2_PWEN = 558,
	FN_USB2_OVC = 559,
	FN_AVS1___4 = 560,
	FN_AVS2___4 = 561,
	FN_DU_DOTCLKIN0 = 562,
	FN_IP7_26_25___2 = 563,
	FN_DU_DOTCLKIN2 = 564,
	FN_IP7_18_16 = 565,
	FN_IP7_21_19 = 566,
	FN_IP7_24_22___2 = 567,
	FN_D0___6 = 568,
	FN_MSIOF3_SCK_B = 569,
	FN_VI3_DATA0___2 = 570,
	FN_VI0_G4___6 = 571,
	FN_VI0_G4_B = 572,
	FN_D1___6 = 573,
	FN_MSIOF3_SYNC_B = 574,
	FN_VI3_DATA1___2 = 575,
	FN_VI0_G5___6 = 576,
	FN_VI0_G5_B = 577,
	FN_D2___6 = 578,
	FN_MSIOF3_RXD_B = 579,
	FN_VI3_DATA2___2 = 580,
	FN_VI0_G6___5 = 581,
	FN_VI0_G6_B = 582,
	FN_D3___6 = 583,
	FN_MSIOF3_TXD_B = 584,
	FN_VI3_DATA3___2 = 585,
	FN_VI0_G7___5 = 586,
	FN_VI0_G7_B = 587,
	FN_D4___6 = 588,
	FN_SCIFB1_RXD_F = 589,
	FN_SCIFB0_RXD_C___2 = 590,
	FN_VI3_DATA4___2 = 591,
	FN_VI0_R0___5 = 592,
	FN_VI0_R0_B___2 = 593,
	FN_RX0_B___5 = 594,
	FN_D5___6 = 595,
	FN_SCIFB1_TXD_F = 596,
	FN_SCIFB0_TXD_C___2 = 597,
	FN_VI3_DATA5___2 = 598,
	FN_VI0_R1___5 = 599,
	FN_VI0_R1_B___2 = 600,
	FN_TX0_B___5 = 601,
	FN_D6___6 = 602,
	FN_IIC2_SCL_C = 603,
	FN_VI3_DATA6___2 = 604,
	FN_VI0_R2___5 = 605,
	FN_VI0_R2_B___2 = 606,
	FN_I2C2_SCL_C___3 = 607,
	FN_D7___6 = 608,
	FN_AD_DI_B = 609,
	FN_IIC2_SDA_C = 610,
	FN_VI3_DATA7___2 = 611,
	FN_VI0_R3___5 = 612,
	FN_VI0_R3_B___2 = 613,
	FN_I2C2_SDA_C___3 = 614,
	FN_TCLK1___6 = 615,
	FN_D8___6 = 616,
	FN_SCIFA1_SCK_C___2 = 617,
	FN_AVB_TXD0___5 = 618,
	FN_VI0_G0___5 = 619,
	FN_VI0_G0_B = 620,
	FN_VI2_DATA0_VI2_B0___2 = 621,
	FN_D9___6 = 622,
	FN_SCIFA1_RXD_C___3 = 623,
	FN_AVB_TXD1___5 = 624,
	FN_VI0_G1___5 = 625,
	FN_VI0_G1_B = 626,
	FN_VI2_DATA1_VI2_B1___2 = 627,
	FN_D10___6 = 628,
	FN_SCIFA1_TXD_C___3 = 629,
	FN_AVB_TXD2___5 = 630,
	FN_VI0_G2___6 = 631,
	FN_VI0_G2_B = 632,
	FN_VI2_DATA2_VI2_B2___2 = 633,
	FN_D11___6 = 634,
	FN_SCIFA1_CTS_N_C = 635,
	FN_AVB_TXD3___5 = 636,
	FN_VI0_G3___6 = 637,
	FN_VI0_G3_B = 638,
	FN_VI2_DATA3_VI2_B3___2 = 639,
	FN_D12___5 = 640,
	FN_SCIFA1_RTS_N_C = 641,
	FN_AVB_TXD4___5 = 642,
	FN_VI0_HSYNC_N___5 = 643,
	FN_VI0_HSYNC_N_B = 644,
	FN_VI2_DATA4_VI2_B4___2 = 645,
	FN_D13___5 = 646,
	FN_AVB_TXD5___5 = 647,
	FN_VI0_VSYNC_N___5 = 648,
	FN_VI0_VSYNC_N_B = 649,
	FN_VI2_DATA5_VI2_B5___2 = 650,
	FN_D14___5 = 651,
	FN_SCIFB1_RXD_C___2 = 652,
	FN_AVB_TXD6___5 = 653,
	FN_RX1_B___5 = 654,
	FN_VI0_CLKENB___7 = 655,
	FN_VI0_CLKENB_B = 656,
	FN_VI2_DATA6_VI2_B6___2 = 657,
	FN_D15___5 = 658,
	FN_SCIFB1_TXD_C___2 = 659,
	FN_AVB_TXD7___5 = 660,
	FN_TX1_B___5 = 661,
	FN_VI0_FIELD___7 = 662,
	FN_VI0_FIELD_B = 663,
	FN_VI2_DATA7_VI2_B7___2 = 664,
	FN_A0___7 = 665,
	FN_PWM3___6 = 666,
	FN_A1___7 = 667,
	FN_PWM4___6 = 668,
	FN_A2___7 = 669,
	FN_PWM5___5 = 670,
	FN_MSIOF1_SS1_B___3 = 671,
	FN_A3___7 = 672,
	FN_PWM6___5 = 673,
	FN_MSIOF1_SS2_B___3 = 674,
	FN_A4___7 = 675,
	FN_MSIOF1_TXD_B___4 = 676,
	FN_TPU0TO0___2 = 677,
	FN_A5___7 = 678,
	FN_SCIFA1_TXD_B___3 = 679,
	FN_TPU0TO1___2 = 680,
	FN_A6___7 = 681,
	FN_SCIFA1_RTS_N_B = 682,
	FN_TPU0TO2___2 = 683,
	FN_A7___7 = 684,
	FN_SCIFA1_SCK_B___3 = 685,
	FN_AUDIO_CLKOUT_B___5 = 686,
	FN_TPU0TO3___2 = 687,
	FN_A8___7 = 688,
	FN_SCIFA1_RXD_B___3 = 689,
	FN_SSI_SCK5_B___3 = 690,
	FN_VI0_R4___5 = 691,
	FN_VI0_R4_B___2 = 692,
	FN_SCIFB2_RXD_C___2 = 693,
	FN_RX2_B___5 = 694,
	FN_VI2_DATA0_VI2_B0_B = 695,
	FN_A9___7 = 696,
	FN_SCIFA1_CTS_N_B = 697,
	FN_SSI_WS5_B___3 = 698,
	FN_VI0_R5___5 = 699,
	FN_VI0_R5_B___2 = 700,
	FN_SCIFB2_TXD_C___2 = 701,
	FN_TX2_B___5 = 702,
	FN_VI2_DATA1_VI2_B1_B = 703,
	FN_A10___7 = 704,
	FN_SSI_SDATA5_B___3 = 705,
	FN_MSIOF2_SYNC___3 = 706,
	FN_VI0_R6___5 = 707,
	FN_VI0_R6_B = 708,
	FN_VI2_DATA2_VI2_B2_B = 709,
	FN_A11___7 = 710,
	FN_SCIFB2_CTS_N_B___2 = 711,
	FN_MSIOF2_SCK___3 = 712,
	FN_VI1_R0___2 = 713,
	FN_VI1_R0_B___2 = 714,
	FN_VI2_G0___2 = 715,
	FN_VI2_DATA3_VI2_B3_B = 716,
	FN_A12___7 = 717,
	FN_SCIFB2_RXD_B___2 = 718,
	FN_MSIOF2_TXD___3 = 719,
	FN_VI1_R1___2 = 720,
	FN_VI1_R1_B___2 = 721,
	FN_VI2_G1___2 = 722,
	FN_VI2_DATA4_VI2_B4_B = 723,
	FN_A13___7 = 724,
	FN_SCIFB2_RTS_N_B___2 = 725,
	FN_EX_WAIT2___4 = 726,
	FN_MSIOF2_RXD___3 = 727,
	FN_VI1_R2___2 = 728,
	FN_VI1_R2_B___2 = 729,
	FN_VI2_G2___2 = 730,
	FN_VI2_DATA5_VI2_B5_B = 731,
	FN_A14___7 = 732,
	FN_SCIFB2_TXD_B___2 = 733,
	FN_ATACS11_N___3 = 734,
	FN_MSIOF2_SS1___4 = 735,
	FN_A15___7 = 736,
	FN_SCIFB2_SCK_B___2 = 737,
	FN_ATARD1_N___3 = 738,
	FN_MSIOF2_SS2___4 = 739,
	FN_A16___7 = 740,
	FN_ATAWR1_N___3 = 741,
	FN_A17___7 = 742,
	FN_AD_DO_B = 743,
	FN_ATADIR1_N___3 = 744,
	FN_A18___7 = 745,
	FN_AD_CLK_B = 746,
	FN_ATAG1_N___3 = 747,
	FN_A19___7 = 748,
	FN_AD_NCS_N_B = 749,
	FN_ATACS01_N___3 = 750,
	FN_EX_WAIT0_B = 751,
	FN_A20___7 = 752,
	FN_SPCLK___4 = 753,
	FN_VI1_R3___2 = 754,
	FN_VI1_R3_B___2 = 755,
	FN_VI2_G4___2 = 756,
	FN_A21___7 = 757,
	FN_MOSI_IO0___4 = 758,
	FN_VI1_R4___2 = 759,
	FN_VI1_R4_B___2 = 760,
	FN_VI2_G5___2 = 761,
	FN_A22___7 = 762,
	FN_MISO_IO1___4 = 763,
	FN_VI1_R5___2 = 764,
	FN_VI1_R5_B___2 = 765,
	FN_VI2_G6___2 = 766,
	FN_A23___7 = 767,
	FN_IO2___4 = 768,
	FN_VI1_G7___2 = 769,
	FN_VI1_G7_B___2 = 770,
	FN_VI2_G7___2 = 771,
	FN_A24___7 = 772,
	FN_IO3___4 = 773,
	FN_VI1_R7___2 = 774,
	FN_VI1_R7_B___2 = 775,
	FN_VI2_CLKENB___4 = 776,
	FN_VI2_CLKENB_B = 777,
	FN_A25___7 = 778,
	FN_SSL___4 = 779,
	FN_VI1_G6___2 = 780,
	FN_VI1_G6_B___2 = 781,
	FN_VI2_FIELD___4 = 782,
	FN_VI2_FIELD_B = 783,
	FN_CS0_N___5 = 784,
	FN_VI1_R6___2 = 785,
	FN_VI1_R6_B___2 = 786,
	FN_VI2_G3___2 = 787,
	FN_MSIOF0_SS2_B___2 = 788,
	FN_CS1_N_A26___5 = 789,
	FN_SPEEDIN___5 = 790,
	FN_VI0_R7___5 = 791,
	FN_VI0_R7_B = 792,
	FN_VI2_CLK___4 = 793,
	FN_VI2_CLK_B = 794,
	FN_EX_CS0_N___4 = 795,
	FN_HRX1_B___5 = 796,
	FN_VI1_G5___2 = 797,
	FN_VI1_G5_B___2 = 798,
	FN_VI2_R0___2 = 799,
	FN_HTX0_B___5 = 800,
	FN_MSIOF0_SS1_B___2 = 801,
	FN_EX_CS1_N___4 = 802,
	FN_GPS_CLK___3 = 803,
	FN_HCTS1_N_B___2 = 804,
	FN_VI1_FIELD___7 = 805,
	FN_VI1_FIELD_B___2 = 806,
	FN_VI2_R1___2 = 807,
	FN_EX_CS2_N___4 = 808,
	FN_GPS_SIGN___3 = 809,
	FN_HRTS1_N_B___2 = 810,
	FN_VI3_CLKENB___3 = 811,
	FN_VI1_G0___2 = 812,
	FN_VI1_G0_B___2 = 813,
	FN_VI2_R2___2 = 814,
	FN_EX_CS3_N___4 = 815,
	FN_GPS_MAG___3 = 816,
	FN_VI3_FIELD___3 = 817,
	FN_VI1_G1___2 = 818,
	FN_VI1_G1_B___2 = 819,
	FN_VI2_R3___2 = 820,
	FN_EX_CS4_N___4 = 821,
	FN_MSIOF1_SCK_B___4 = 822,
	FN_VI3_HSYNC_N___2 = 823,
	FN_VI2_HSYNC_N___3 = 824,
	FN_IIC1_SCL___2 = 825,
	FN_VI2_HSYNC_N_B = 826,
	FN_INTC_EN0_N = 827,
	FN_I2C1_SCL___3 = 828,
	FN_EX_CS5_N___4 = 829,
	FN_CAN0_RX___5 = 830,
	FN_MSIOF1_RXD_B___4 = 831,
	FN_VI3_VSYNC_N___2 = 832,
	FN_VI1_G2___2 = 833,
	FN_VI1_G2_B___2 = 834,
	FN_VI2_R4___2 = 835,
	FN_IIC1_SDA___2 = 836,
	FN_INTC_EN1_N = 837,
	FN_I2C1_SDA___3 = 838,
	FN_BS_N___5 = 839,
	FN_IETX___5 = 840,
	FN_HTX1_B___5 = 841,
	FN_CAN1_TX___5 = 842,
	FN_DRACK0___7 = 843,
	FN_IETX_C___3 = 844,
	FN_RD_N___5 = 845,
	FN_CAN0_TX___5 = 846,
	FN_SCIFA0_SCK_B = 847,
	FN_RD_WR_N___5 = 848,
	FN_VI1_G3___2 = 849,
	FN_VI1_G3_B___2 = 850,
	FN_VI2_R5___2 = 851,
	FN_SCIFA0_RXD_B___3 = 852,
	FN_WE0_N___5 = 853,
	FN_IECLK___5 = 854,
	FN_CAN_CLK___5 = 855,
	FN_VI2_VSYNC_N___3 = 856,
	FN_SCIFA0_TXD_B___3 = 857,
	FN_VI2_VSYNC_N_B = 858,
	FN_WE1_N___5 = 859,
	FN_IERX___5 = 860,
	FN_CAN1_RX___5 = 861,
	FN_VI1_G4___2 = 862,
	FN_VI1_G4_B___2 = 863,
	FN_VI2_R6___2 = 864,
	FN_SCIFA0_CTS_N_B = 865,
	FN_IERX_C___3 = 866,
	FN_EX_WAIT0___7 = 867,
	FN_IRQ3___6 = 868,
	FN_VI3_CLK___3 = 869,
	FN_SCIFA0_RTS_N_B = 870,
	FN_HRX0_B___5 = 871,
	FN_MSIOF0_SCK_B___3 = 872,
	FN_DREQ0_N___4 = 873,
	FN_VI1_HSYNC_N___5 = 874,
	FN_VI1_HSYNC_N_B___2 = 875,
	FN_VI2_R7___2 = 876,
	FN_SSI_SCK78_C___2 = 877,
	FN_SSI_WS78_B___5 = 878,
	FN_DACK0___7 = 879,
	FN_IRQ0___7 = 880,
	FN_SSI_SCK6_B___3 = 881,
	FN_VI1_VSYNC_N___5 = 882,
	FN_VI1_VSYNC_N_B___2 = 883,
	FN_SSI_WS78_C___2 = 884,
	FN_DREQ1_N___4 = 885,
	FN_VI1_CLKENB___7 = 886,
	FN_VI1_CLKENB_B___2 = 887,
	FN_SSI_SDATA7_C___2 = 888,
	FN_SSI_SCK78_B___5 = 889,
	FN_DACK1___6 = 890,
	FN_IRQ1___6 = 891,
	FN_SSI_WS6_B___3 = 892,
	FN_SSI_SDATA8_C___2 = 893,
	FN_DREQ2_N___3 = 894,
	FN_HSCK1_B___3 = 895,
	FN_HCTS0_N_B___2 = 896,
	FN_MSIOF0_TXD_B___3 = 897,
	FN_DACK2___5 = 898,
	FN_IRQ2___6 = 899,
	FN_SSI_SDATA6_B___3 = 900,
	FN_HRTS0_N_B___2 = 901,
	FN_MSIOF0_RXD_B___3 = 902,
	FN_ETH_CRS_DV___6 = 903,
	FN_STP_ISCLK_0_B___2 = 904,
	FN_TS_SDEN0_D___2 = 905,
	FN_GLO_Q0_C___2 = 906,
	FN_IIC2_SCL_E = 907,
	FN_I2C2_SCL_E___2 = 908,
	FN_ETH_RX_ER___6 = 909,
	FN_STP_ISD_0_B___2 = 910,
	FN_TS_SPSYNC0_D___2 = 911,
	FN_GLO_Q1_C___2 = 912,
	FN_IIC2_SDA_E = 913,
	FN_I2C2_SDA_E___2 = 914,
	FN_ETH_RXD0___6 = 915,
	FN_STP_ISEN_0_B___2 = 916,
	FN_TS_SDAT0_D = 917,
	FN_GLO_I0_C___2 = 918,
	FN_SCIFB1_SCK_G = 919,
	FN_SCK1_E = 920,
	FN_ETH_RXD1___6 = 921,
	FN_HRX0_E = 922,
	FN_STP_ISSYNC_0_B___2 = 923,
	FN_TS_SCK0_D___2 = 924,
	FN_GLO_I1_C___2 = 925,
	FN_SCIFB1_RXD_G = 926,
	FN_RX1_E = 927,
	FN_ETH_LINK___6 = 928,
	FN_HTX0_E = 929,
	FN_STP_IVCXO27_0_B___2 = 930,
	FN_SCIFB1_TXD_G = 931,
	FN_TX1_E = 932,
	FN_ETH_REF_CLK___3 = 933,
	FN_HCTS0_N_E = 934,
	FN_STP_IVCXO27_1_B = 935,
	FN_HRX0_F = 936,
	FN_ETH_MDIO___6 = 937,
	FN_HRTS0_N_E = 938,
	FN_SIM0_D_C = 939,
	FN_HCTS0_N_F = 940,
	FN_ETH_TXD1___6 = 941,
	FN_HTX0_F = 942,
	FN_BPFCLK_G = 943,
	FN_ETH_TX_EN___6 = 944,
	FN_SIM0_CLK_C = 945,
	FN_HRTS0_N_F = 946,
	FN_ETH_MAGIC___6 = 947,
	FN_SIM0_RST_C = 948,
	FN_ETH_TXD0___6 = 949,
	FN_STP_ISCLK_1_B = 950,
	FN_TS_SDEN1_C = 951,
	FN_GLO_SCLK_C___2 = 952,
	FN_ETH_MDC___6 = 953,
	FN_STP_ISD_1_B = 954,
	FN_TS_SPSYNC1_C = 955,
	FN_GLO_SDATA_C___2 = 956,
	FN_PWM0___5 = 957,
	FN_SCIFA2_SCK_C = 958,
	FN_STP_ISEN_1_B = 959,
	FN_TS_SDAT1_C = 960,
	FN_GLO_SS_C___2 = 961,
	FN_PWM1___6 = 962,
	FN_SCIFA2_TXD_C = 963,
	FN_STP_ISSYNC_1_B = 964,
	FN_TS_SCK1_C = 965,
	FN_GLO_RFON_C___2 = 966,
	FN_PCMOE_N = 967,
	FN_PWM2___6 = 968,
	FN_PWMFSW0___2 = 969,
	FN_SCIFA2_RXD_C = 970,
	FN_PCMWE_N = 971,
	FN_IECLK_C___3 = 972,
	FN_DU_DOTCLKIN1 = 973,
	FN_AUDIO_CLKC___5 = 974,
	FN_AUDIO_CLKOUT_C___4 = 975,
	FN_VI0_CLK___7 = 976,
	FN_ATACS00_N___3 = 977,
	FN_AVB_RXD1___5 = 978,
	FN_VI0_DATA0_VI0_B0___6 = 979,
	FN_ATACS10_N___3 = 980,
	FN_AVB_RXD2___5 = 981,
	FN_VI0_DATA1_VI0_B1___6 = 982,
	FN_ATARD0_N___3 = 983,
	FN_AVB_RXD3___5 = 984,
	FN_VI0_DATA2_VI0_B2___6 = 985,
	FN_ATAWR0_N___3 = 986,
	FN_AVB_RXD4___5 = 987,
	FN_VI0_DATA3_VI0_B3___6 = 988,
	FN_ATADIR0_N___3 = 989,
	FN_AVB_RXD5___5 = 990,
	FN_VI0_DATA4_VI0_B4___6 = 991,
	FN_ATAG0_N___3 = 992,
	FN_AVB_RXD6___5 = 993,
	FN_VI0_DATA5_VI0_B5___6 = 994,
	FN_EX_WAIT1___5 = 995,
	FN_AVB_RXD7___5 = 996,
	FN_VI0_DATA6_VI0_B6___5 = 997,
	FN_AVB_RX_ER___5 = 998,
	FN_VI0_DATA7_VI0_B7___5 = 999,
	FN_AVB_RX_CLK___5 = 1000,
	FN_VI1_CLK___7 = 1001,
	FN_AVB_RX_DV___5 = 1002,
	FN_VI1_DATA0_VI1_B0___2 = 1003,
	FN_SCIFA1_SCK_D = 1004,
	FN_AVB_CRS___5 = 1005,
	FN_VI1_DATA1_VI1_B1___2 = 1006,
	FN_SCIFA1_RXD_D = 1007,
	FN_AVB_MDC___5 = 1008,
	FN_VI1_DATA2_VI1_B2___2 = 1009,
	FN_SCIFA1_TXD_D = 1010,
	FN_AVB_MDIO___5 = 1011,
	FN_VI1_DATA3_VI1_B3___2 = 1012,
	FN_SCIFA1_CTS_N_D = 1013,
	FN_AVB_GTX_CLK___5 = 1014,
	FN_VI1_DATA4_VI1_B4___2 = 1015,
	FN_SCIFA1_RTS_N_D = 1016,
	FN_AVB_MAGIC___5 = 1017,
	FN_VI1_DATA5_VI1_B5___2 = 1018,
	FN_AVB_PHY_INT___5 = 1019,
	FN_VI1_DATA6_VI1_B6___2 = 1020,
	FN_AVB_GTXREFCLK___5 = 1021,
	FN_SD0_CLK___7 = 1022,
	FN_VI1_DATA0_VI1_B0_B = 1023,
	FN_SD0_CMD___7 = 1024,
	FN_SCIFB1_SCK_B___2 = 1025,
	FN_VI1_DATA1_VI1_B1_B = 1026,
	FN_SD0_DAT0___5 = 1027,
	FN_SCIFB1_RXD_B___2 = 1028,
	FN_VI1_DATA2_VI1_B2_B = 1029,
	FN_SD0_DAT1___5 = 1030,
	FN_SCIFB1_TXD_B___2 = 1031,
	FN_VI1_DATA3_VI1_B3_B = 1032,
	FN_SD0_DAT2___5 = 1033,
	FN_SCIFB1_CTS_N_B = 1034,
	FN_VI1_DATA4_VI1_B4_B = 1035,
	FN_SD0_DAT3___5 = 1036,
	FN_SCIFB1_RTS_N_B = 1037,
	FN_VI1_DATA5_VI1_B5_B = 1038,
	FN_SD0_CD___7 = 1039,
	FN_MMC0_D6___3 = 1040,
	FN_TS_SDEN0_B___3 = 1041,
	FN_USB0_EXTP = 1042,
	FN_GLO_SCLK___2 = 1043,
	FN_VI1_DATA6_VI1_B6_B = 1044,
	FN_IIC1_SCL_B___2 = 1045,
	FN_I2C1_SCL_B___3 = 1046,
	FN_VI2_DATA6_VI2_B6_B = 1047,
	FN_SD0_WP___7 = 1048,
	FN_MMC0_D7___3 = 1049,
	FN_TS_SPSYNC0_B___3 = 1050,
	FN_USB0_IDIN = 1051,
	FN_GLO_SDATA___2 = 1052,
	FN_VI1_DATA7_VI1_B7_B = 1053,
	FN_IIC1_SDA_B___2 = 1054,
	FN_I2C1_SDA_B___3 = 1055,
	FN_VI2_DATA7_VI2_B7_B = 1056,
	FN_SD1_CLK___4 = 1057,
	FN_AVB_TX_EN___5 = 1058,
	FN_SD1_CMD___4 = 1059,
	FN_AVB_TX_ER___5 = 1060,
	FN_SCIFB0_SCK_B___2 = 1061,
	FN_SD1_DAT0___2 = 1062,
	FN_AVB_TX_CLK___5 = 1063,
	FN_SCIFB0_RXD_B___2 = 1064,
	FN_SD1_DAT1___2 = 1065,
	FN_AVB_LINK___5 = 1066,
	FN_SCIFB0_TXD_B___2 = 1067,
	FN_SD1_DAT2___2 = 1068,
	FN_AVB_COL___5 = 1069,
	FN_SCIFB0_CTS_N_B___2 = 1070,
	FN_SD1_DAT3___2 = 1071,
	FN_AVB_RXD0___5 = 1072,
	FN_SCIFB0_RTS_N_B___2 = 1073,
	FN_SD1_CD___5 = 1074,
	FN_MMC1_D6___2 = 1075,
	FN_TS_SDEN1___2 = 1076,
	FN_USB1_EXTP = 1077,
	FN_GLO_SS___2 = 1078,
	FN_VI0_CLK_B = 1079,
	FN_IIC2_SCL_D = 1080,
	FN_I2C2_SCL_D___3 = 1081,
	FN_SIM0_CLK_B = 1082,
	FN_VI3_CLK_B = 1083,
	FN_SD1_WP___5 = 1084,
	FN_MMC1_D7___2 = 1085,
	FN_TS_SPSYNC1___2 = 1086,
	FN_USB1_IDIN = 1087,
	FN_GLO_RFON___2 = 1088,
	FN_VI1_CLK_B___2 = 1089,
	FN_IIC2_SDA_D = 1090,
	FN_I2C2_SDA_D___3 = 1091,
	FN_SIM0_D_B___2 = 1092,
	FN_SD2_CLK___5 = 1093,
	FN_MMC0_CLK___2 = 1094,
	FN_SIM0_CLK___2 = 1095,
	FN_VI0_DATA0_VI0_B0_B = 1096,
	FN_TS_SDEN0_C___2 = 1097,
	FN_GLO_SCLK_B___2 = 1098,
	FN_VI3_DATA0_B = 1099,
	FN_SD2_CMD___5 = 1100,
	FN_MMC0_CMD___2 = 1101,
	FN_SIM0_D___2 = 1102,
	FN_VI0_DATA1_VI0_B1_B = 1103,
	FN_SCIFB1_SCK_E = 1104,
	FN_SCK1_D = 1105,
	FN_TS_SPSYNC0_C___2 = 1106,
	FN_GLO_SDATA_B___2 = 1107,
	FN_VI3_DATA1_B = 1108,
	FN_SD2_DAT0___3 = 1109,
	FN_MMC0_D0___2 = 1110,
	FN_FMCLK_B___4 = 1111,
	FN_VI0_DATA2_VI0_B2_B = 1112,
	FN_SCIFB1_RXD_E = 1113,
	FN_RX1_D___4 = 1114,
	FN_TS_SDAT0_C = 1115,
	FN_GLO_SS_B___2 = 1116,
	FN_VI3_DATA2_B = 1117,
	FN_SD2_DAT1___3 = 1118,
	FN_MMC0_D1___2 = 1119,
	FN_FMIN_B___4 = 1120,
	FN_VI0_DATA3_VI0_B3_B = 1121,
	FN_SCIFB1_TXD_E = 1122,
	FN_TX1_D___4 = 1123,
	FN_TS_SCK0_C___2 = 1124,
	FN_GLO_RFON_B___2 = 1125,
	FN_VI3_DATA3_B = 1126,
	FN_SD2_DAT2___3 = 1127,
	FN_MMC0_D2___2 = 1128,
	FN_BPFCLK_B___4 = 1129,
	FN_VI0_DATA4_VI0_B4_B = 1130,
	FN_HRX0_D = 1131,
	FN_TS_SDEN1_B = 1132,
	FN_GLO_Q0_B___2 = 1133,
	FN_VI3_DATA4_B = 1134,
	FN_SD2_DAT3___3 = 1135,
	FN_MMC0_D3___2 = 1136,
	FN_SIM0_RST___2 = 1137,
	FN_VI0_DATA5_VI0_B5_B = 1138,
	FN_HTX0_D = 1139,
	FN_TS_SPSYNC1_B = 1140,
	FN_GLO_Q1_B___2 = 1141,
	FN_VI3_DATA5_B = 1142,
	FN_SD2_CD___5 = 1143,
	FN_MMC0_D4___3 = 1144,
	FN_TS_SDAT0_B___2 = 1145,
	FN_USB2_EXTP = 1146,
	FN_GLO_I0___2 = 1147,
	FN_VI0_DATA6_VI0_B6_B = 1148,
	FN_HCTS0_N_D = 1149,
	FN_TS_SDAT1_B = 1150,
	FN_GLO_I0_B___2 = 1151,
	FN_VI3_DATA6_B = 1152,
	FN_SD2_WP___5 = 1153,
	FN_MMC0_D5___3 = 1154,
	FN_TS_SCK0_B___3 = 1155,
	FN_USB2_IDIN = 1156,
	FN_GLO_I1___2 = 1157,
	FN_VI0_DATA7_VI0_B7_B = 1158,
	FN_HRTS0_N_D = 1159,
	FN_TS_SCK1_B = 1160,
	FN_GLO_I1_B___2 = 1161,
	FN_VI3_DATA7_B = 1162,
	FN_SD3_CLK___2 = 1163,
	FN_MMC1_CLK___2 = 1164,
	FN_SD3_CMD___2 = 1165,
	FN_MMC1_CMD___2 = 1166,
	FN_MTS_N = 1167,
	FN_SD3_DAT0___2 = 1168,
	FN_MMC1_D0___2 = 1169,
	FN_STM_N = 1170,
	FN_SD3_DAT1___2 = 1171,
	FN_MMC1_D1___2 = 1172,
	FN_MDATA___2 = 1173,
	FN_SD3_DAT2___2 = 1174,
	FN_MMC1_D2___2 = 1175,
	FN_SDATA___2 = 1176,
	FN_SD3_DAT3___2 = 1177,
	FN_MMC1_D3___2 = 1178,
	FN_SCKZ___2 = 1179,
	FN_SD3_CD___2 = 1180,
	FN_MMC1_D4___2 = 1181,
	FN_TS_SDAT1___2 = 1182,
	FN_VSP___2 = 1183,
	FN_GLO_Q0___2 = 1184,
	FN_SIM0_RST_B___2 = 1185,
	FN_SD3_WP___2 = 1186,
	FN_MMC1_D5___2 = 1187,
	FN_TS_SCK1___2 = 1188,
	FN_GLO_Q1___2 = 1189,
	FN_FMIN_C___4 = 1190,
	FN_FMIN_E___3 = 1191,
	FN_FMIN_F = 1192,
	FN_MLB_CLK___5 = 1193,
	FN_IIC2_SCL_B = 1194,
	FN_I2C2_SCL_B___3 = 1195,
	FN_MLB_SIG___5 = 1196,
	FN_SCIFB1_RXD_D___2 = 1197,
	FN_RX1_C___5 = 1198,
	FN_IIC2_SDA_B = 1199,
	FN_I2C2_SDA_B___3 = 1200,
	FN_MLB_DAT___5 = 1201,
	FN_SCIFB1_TXD_D___2 = 1202,
	FN_TX1_C___5 = 1203,
	FN_BPFCLK_C___4 = 1204,
	FN_SSI_SCK0129___4 = 1205,
	FN_CAN_CLK_B___6 = 1206,
	FN_MOUT0___2 = 1207,
	FN_SSI_WS0129___4 = 1208,
	FN_CAN0_TX_B___6 = 1209,
	FN_MOUT1___2 = 1210,
	FN_SSI_SDATA0___5 = 1211,
	FN_CAN0_RX_B___6 = 1212,
	FN_MOUT2___2 = 1213,
	FN_SSI_SDATA1___5 = 1214,
	FN_CAN1_TX_B___5 = 1215,
	FN_MOUT5___2 = 1216,
	FN_SSI_SDATA2___5 = 1217,
	FN_CAN1_RX_B___5 = 1218,
	FN_SSI_SCK1___4 = 1219,
	FN_MOUT6___2 = 1220,
	FN_SSI_SCK34___7 = 1221,
	FN_STP_OPWM_0___2 = 1222,
	FN_SCIFB0_SCK___3 = 1223,
	FN_MSIOF1_SCK___4 = 1224,
	FN_CAN_DEBUG_HW_TRIGGER___2 = 1225,
	FN_SSI_WS34___7 = 1226,
	FN_STP_IVCXO27_0___2 = 1227,
	FN_SCIFB0_RXD___3 = 1228,
	FN_MSIOF1_SYNC___4 = 1229,
	FN_CAN_STEP0___2 = 1230,
	FN_SSI_SDATA3___7 = 1231,
	FN_STP_ISCLK_0___2 = 1232,
	FN_SCIFB0_TXD___3 = 1233,
	FN_MSIOF1_SS1___3 = 1234,
	FN_CAN_TXCLK___2 = 1235,
	FN_SSI_SCK4___6 = 1236,
	FN_STP_ISD_0___2 = 1237,
	FN_SCIFB0_CTS_N___3 = 1238,
	FN_MSIOF1_SS2___3 = 1239,
	FN_SSI_SCK5_C = 1240,
	FN_CAN_DEBUGOUT0___2 = 1241,
	FN_SSI_WS4___6 = 1242,
	FN_STP_ISEN_0___2 = 1243,
	FN_SCIFB0_RTS_N___3 = 1244,
	FN_MSIOF1_TXD___4 = 1245,
	FN_SSI_WS5_C = 1246,
	FN_CAN_DEBUGOUT1___2 = 1247,
	FN_SSI_SDATA4___6 = 1248,
	FN_STP_ISSYNC_0___2 = 1249,
	FN_MSIOF1_RXD___4 = 1250,
	FN_CAN_DEBUGOUT2___2 = 1251,
	FN_SSI_SCK5___5 = 1252,
	FN_SCIFB1_SCK___3 = 1253,
	FN_IERX_B___4 = 1254,
	FN_DU2_EXHSYNC_DU2_HSYNC = 1255,
	FN_QSTH_QHS___5 = 1256,
	FN_CAN_DEBUGOUT3___2 = 1257,
	FN_SSI_WS5___5 = 1258,
	FN_SCIFB1_RXD___3 = 1259,
	FN_IECLK_B___4 = 1260,
	FN_DU2_EXVSYNC_DU2_VSYNC = 1261,
	FN_QSTB_QHE___5 = 1262,
	FN_CAN_DEBUGOUT4___2 = 1263,
	FN_SSI_SDATA5___5 = 1264,
	FN_SCIFB1_TXD___3 = 1265,
	FN_IETX_B___4 = 1266,
	FN_DU2_DR2 = 1267,
	FN_LCDOUT2___5 = 1268,
	FN_CAN_DEBUGOUT5___2 = 1269,
	FN_SSI_SCK6___5 = 1270,
	FN_SCIFB1_CTS_N___2 = 1271,
	FN_BPFCLK_D___4 = 1272,
	FN_DU2_DR3 = 1273,
	FN_LCDOUT3___5 = 1274,
	FN_CAN_DEBUGOUT6___2 = 1275,
	FN_BPFCLK_F = 1276,
	FN_SSI_WS6___5 = 1277,
	FN_SCIFB1_RTS_N___2 = 1278,
	FN_CAN0_TX_D___4 = 1279,
	FN_DU2_DR4 = 1280,
	FN_LCDOUT4___5 = 1281,
	FN_CAN_DEBUGOUT7___2 = 1282,
	FN_SSI_SDATA6___5 = 1283,
	FN_FMIN_D___4 = 1284,
	FN_DU2_DR5 = 1285,
	FN_LCDOUT5___5 = 1286,
	FN_CAN_DEBUGOUT8___2 = 1287,
	FN_SSI_SCK78___5 = 1288,
	FN_STP_IVCXO27_1 = 1289,
	FN_SCK1___3 = 1290,
	FN_SCIFA1_SCK___3 = 1291,
	FN_DU2_DR6 = 1292,
	FN_LCDOUT6___5 = 1293,
	FN_CAN_DEBUGOUT9___2 = 1294,
	FN_SSI_WS78___5 = 1295,
	FN_STP_ISCLK_1 = 1296,
	FN_SCIFB2_SCK___3 = 1297,
	FN_SCIFA2_CTS_N = 1298,
	FN_DU2_DR7 = 1299,
	FN_LCDOUT7___5 = 1300,
	FN_CAN_DEBUGOUT10___2 = 1301,
	FN_SSI_SDATA7___5 = 1302,
	FN_STP_ISD_1 = 1303,
	FN_SCIFB2_RXD___3 = 1304,
	FN_SCIFA2_RTS_N = 1305,
	FN_TCLK2___4 = 1306,
	FN_QSTVA_QVS___5 = 1307,
	FN_CAN_DEBUGOUT11___2 = 1308,
	FN_BPFCLK_E___3 = 1309,
	FN_SSI_SDATA7_B___5 = 1310,
	FN_FMIN_G = 1311,
	FN_SSI_SDATA8___5 = 1312,
	FN_STP_ISEN_1 = 1313,
	FN_SCIFB2_TXD___3 = 1314,
	FN_CAN0_TX_C___4 = 1315,
	FN_CAN_DEBUGOUT12___2 = 1316,
	FN_SSI_SDATA8_B___5 = 1317,
	FN_SSI_SDATA9___4 = 1318,
	FN_STP_ISSYNC_1 = 1319,
	FN_SCIFB2_CTS_N___3 = 1320,
	FN_SSI_WS1___4 = 1321,
	FN_SSI_SDATA5_C = 1322,
	FN_CAN_DEBUGOUT13___2 = 1323,
	FN_AUDIO_CLKA___6 = 1324,
	FN_SCIFB2_RTS_N___3 = 1325,
	FN_CAN_DEBUGOUT14___2 = 1326,
	FN_AUDIO_CLKB___6 = 1327,
	FN_SCIF_CLK___6 = 1328,
	FN_CAN0_RX_D___4 = 1329,
	FN_DVC_MUTE___4 = 1330,
	FN_CAN0_RX_C___4 = 1331,
	FN_CAN_DEBUGOUT15___2 = 1332,
	FN_REMOCON___4 = 1333,
	FN_SCIFA0_SCK = 1334,
	FN_HSCK1___5 = 1335,
	FN_SCK0___4 = 1336,
	FN_MSIOF3_SS2 = 1337,
	FN_DU2_DG2 = 1338,
	FN_LCDOUT10___5 = 1339,
	FN_IIC1_SDA_C___2 = 1340,
	FN_I2C1_SDA_C___3 = 1341,
	FN_SCIFA0_RXD___3 = 1342,
	FN_HRX1___4 = 1343,
	FN_RX0___4 = 1344,
	FN_DU2_DR0 = 1345,
	FN_LCDOUT0___5 = 1346,
	FN_SCIFA0_TXD___3 = 1347,
	FN_HTX1___4 = 1348,
	FN_TX0___4 = 1349,
	FN_DU2_DR1 = 1350,
	FN_LCDOUT1___5 = 1351,
	FN_SCIFA0_CTS_N = 1352,
	FN_HCTS1_N___3 = 1353,
	FN_CTS0_N___2 = 1354,
	FN_MSIOF3_SYNC = 1355,
	FN_DU2_DG3 = 1356,
	FN_LCDOUT11___5 = 1357,
	FN_PWM0_B___6 = 1358,
	FN_IIC1_SCL_C___2 = 1359,
	FN_I2C1_SCL_C___3 = 1360,
	FN_SCIFA0_RTS_N = 1361,
	FN_HRTS1_N___3 = 1362,
	FN_RTS0_N___2 = 1363,
	FN_MSIOF3_SS1 = 1364,
	FN_DU2_DG0 = 1365,
	FN_LCDOUT8___5 = 1366,
	FN_PWM1_B___4 = 1367,
	FN_SCIFA1_RXD___3 = 1368,
	FN_AD_DI___2 = 1369,
	FN_RX1___4 = 1370,
	FN_DU2_EXODDF_DU2_ODDF_DISP_CDE = 1371,
	FN_QCPV_QDE___5 = 1372,
	FN_SCIFA1_TXD___3 = 1373,
	FN_AD_DO___2 = 1374,
	FN_TX1___4 = 1375,
	FN_DU2_DG1 = 1376,
	FN_LCDOUT9___5 = 1377,
	FN_SCIFA1_CTS_N = 1378,
	FN_AD_CLK___2 = 1379,
	FN_CTS1_N___2 = 1380,
	FN_MSIOF3_RXD = 1381,
	FN_DU0_DOTCLKOUT = 1382,
	FN_QCLK___5 = 1383,
	FN_SCIFA1_RTS_N = 1384,
	FN_AD_NCS_N = 1385,
	FN_RTS1_N___2 = 1386,
	FN_MSIOF3_TXD = 1387,
	FN_DU1_DOTCLKOUT___3 = 1388,
	FN_QSTVB_QVE___5 = 1389,
	FN_HRTS0_N_C = 1390,
	FN_SCIFA2_SCK___3 = 1391,
	FN_FMCLK___4 = 1392,
	FN_SCK2___3 = 1393,
	FN_MSIOF3_SCK = 1394,
	FN_DU2_DG7 = 1395,
	FN_LCDOUT15___5 = 1396,
	FN_SCIF_CLK_B___5 = 1397,
	FN_SCIFA2_RXD___3 = 1398,
	FN_FMIN___4 = 1399,
	FN_TX2___4 = 1400,
	FN_DU2_DB0 = 1401,
	FN_LCDOUT16___5 = 1402,
	FN_IIC2_SCL = 1403,
	FN_I2C2_SCL___3 = 1404,
	FN_SCIFA2_TXD___3 = 1405,
	FN_BPFCLK___4 = 1406,
	FN_RX2___4 = 1407,
	FN_DU2_DB1 = 1408,
	FN_LCDOUT17___5 = 1409,
	FN_IIC2_SDA = 1410,
	FN_I2C2_SDA___3 = 1411,
	FN_HSCK0___6 = 1412,
	FN_TS_SDEN0___3 = 1413,
	FN_DU2_DG4 = 1414,
	FN_LCDOUT12___5 = 1415,
	FN_HCTS0_N_C = 1416,
	FN_HRX0___4 = 1417,
	FN_DU2_DB2 = 1418,
	FN_LCDOUT18___5 = 1419,
	FN_HTX0___4 = 1420,
	FN_DU2_DB3 = 1421,
	FN_LCDOUT19___5 = 1422,
	FN_HCTS0_N___4 = 1423,
	FN_SSI_SCK9___4 = 1424,
	FN_DU2_DB4 = 1425,
	FN_LCDOUT20___5 = 1426,
	FN_HRTS0_N___4 = 1427,
	FN_SSI_WS9___4 = 1428,
	FN_DU2_DB5 = 1429,
	FN_LCDOUT21___5 = 1430,
	FN_MSIOF0_SCK___4 = 1431,
	FN_TS_SDAT0___2 = 1432,
	FN_ADICLK___6 = 1433,
	FN_DU2_DB6 = 1434,
	FN_LCDOUT22___5 = 1435,
	FN_MSIOF0_SYNC___4 = 1436,
	FN_TS_SCK0___3 = 1437,
	FN_SSI_SCK2___4 = 1438,
	FN_ADIDATA___6 = 1439,
	FN_DU2_DB7 = 1440,
	FN_LCDOUT23___5 = 1441,
	FN_HRX0_C___2 = 1442,
	FN_MSIOF0_SS1___3 = 1443,
	FN_ADICHS0___6 = 1444,
	FN_DU2_DG5 = 1445,
	FN_LCDOUT13___5 = 1446,
	FN_MSIOF0_TXD___4 = 1447,
	FN_ADICHS1___6 = 1448,
	FN_DU2_DG6 = 1449,
	FN_LCDOUT14___5 = 1450,
	FN_MSIOF0_SS2___3 = 1451,
	FN_AUDIO_CLKOUT___5 = 1452,
	FN_ADICHS2___6 = 1453,
	FN_DU2_DISP = 1454,
	FN_QPOLA___5 = 1455,
	FN_HTX0_C___2 = 1456,
	FN_SCIFA2_TXD_B___3 = 1457,
	FN_MSIOF0_RXD___4 = 1458,
	FN_TS_SPSYNC0___3 = 1459,
	FN_SSI_WS2___4 = 1460,
	FN_ADICS_SAMP___6 = 1461,
	FN_DU2_CDE = 1462,
	FN_QPOLB___5 = 1463,
	FN_SCIFA2_RXD_B___3 = 1464,
	FN_USB1_PWEN___4 = 1465,
	FN_AUDIO_CLKOUT_D = 1466,
	FN_USB1_OVC___4 = 1467,
	FN_TCLK1_B___5 = 1468,
	FN_SEL_SCIF1_0___5 = 1469,
	FN_SEL_SCIF1_1___5 = 1470,
	FN_SEL_SCIF1_2___5 = 1471,
	FN_SEL_SCIF1_3___3 = 1472,
	FN_SEL_SCIF1_4 = 1473,
	FN_SEL_SCIFB_0___2 = 1474,
	FN_SEL_SCIFB_1___2 = 1475,
	FN_SEL_SCIFB_2___2 = 1476,
	FN_SEL_SCIFB2_0___2 = 1477,
	FN_SEL_SCIFB2_1___2 = 1478,
	FN_SEL_SCIFB2_2___2 = 1479,
	FN_SEL_SCIFB1_0___2 = 1480,
	FN_SEL_SCIFB1_1___2 = 1481,
	FN_SEL_SCIFB1_2___2 = 1482,
	FN_SEL_SCIFB1_3___2 = 1483,
	FN_SEL_SCIFB1_4 = 1484,
	FN_SEL_SCIFB1_5 = 1485,
	FN_SEL_SCIFB1_6 = 1486,
	FN_SEL_SCIFA1_0___3 = 1487,
	FN_SEL_SCIFA1_1___3 = 1488,
	FN_SEL_SCIFA1_2___3 = 1489,
	FN_SEL_SCIFA1_3 = 1490,
	FN_SEL_SCIF0_0___5 = 1491,
	FN_SEL_SCIF0_1___5 = 1492,
	FN_SEL_SCFA_0___2 = 1493,
	FN_SEL_SCFA_1___2 = 1494,
	FN_SEL_SOF1_0___2 = 1495,
	FN_SEL_SOF1_1___2 = 1496,
	FN_SEL_SSI7_0___5 = 1497,
	FN_SEL_SSI7_1___5 = 1498,
	FN_SEL_SSI7_2___2 = 1499,
	FN_SEL_SSI6_0___3 = 1500,
	FN_SEL_SSI6_1___3 = 1501,
	FN_SEL_SSI5_0___3 = 1502,
	FN_SEL_SSI5_1___3 = 1503,
	FN_SEL_SSI5_2 = 1504,
	FN_SEL_VI3_0 = 1505,
	FN_SEL_VI3_1 = 1506,
	FN_SEL_VI2_0 = 1507,
	FN_SEL_VI2_1 = 1508,
	FN_SEL_VI1_0___3 = 1509,
	FN_SEL_VI1_1___3 = 1510,
	FN_SEL_VI0_0___2 = 1511,
	FN_SEL_VI0_1___2 = 1512,
	FN_SEL_TSIF1_0 = 1513,
	FN_SEL_TSIF1_1 = 1514,
	FN_SEL_TSIF1_2 = 1515,
	FN_SEL_LBS_0___3 = 1516,
	FN_SEL_LBS_1___3 = 1517,
	FN_SEL_TSIF0_0___3 = 1518,
	FN_SEL_TSIF0_1___3 = 1519,
	FN_SEL_TSIF0_2___3 = 1520,
	FN_SEL_TSIF0_3___3 = 1521,
	FN_SEL_SOF3_0 = 1522,
	FN_SEL_SOF3_1 = 1523,
	FN_SEL_SOF0_0___2 = 1524,
	FN_SEL_SOF0_1___2 = 1525,
	FN_SEL_TMU1_0___4 = 1526,
	FN_SEL_TMU1_1___4 = 1527,
	FN_SEL_HSCIF1_0___5 = 1528,
	FN_SEL_HSCIF1_1___5 = 1529,
	FN_SEL_SCIFCLK_0___2 = 1530,
	FN_SEL_SCIFCLK_1___2 = 1531,
	FN_SEL_CAN0_0___5 = 1532,
	FN_SEL_CAN0_1___5 = 1533,
	FN_SEL_CAN0_2___4 = 1534,
	FN_SEL_CAN0_3___4 = 1535,
	FN_SEL_CANCLK_0___4 = 1536,
	FN_SEL_CANCLK_1___4 = 1537,
	FN_SEL_SCIFA2_0___3 = 1538,
	FN_SEL_SCIFA2_1___3 = 1539,
	FN_SEL_SCIFA2_2 = 1540,
	FN_SEL_CAN1_0___4 = 1541,
	FN_SEL_CAN1_1___4 = 1542,
	FN_SEL_SCIF2_0___5 = 1543,
	FN_SEL_SCIF2_1___5 = 1544,
	FN_SEL_ADI_0___2 = 1545,
	FN_SEL_ADI_1___2 = 1546,
	FN_SEL_SSP_0___2 = 1547,
	FN_SEL_SSP_1___2 = 1548,
	FN_SEL_FM_0___2 = 1549,
	FN_SEL_FM_1___2 = 1550,
	FN_SEL_FM_2___2 = 1551,
	FN_SEL_FM_3___2 = 1552,
	FN_SEL_FM_4___2 = 1553,
	FN_SEL_FM_5 = 1554,
	FN_SEL_FM_6 = 1555,
	FN_SEL_HSCIF0_0___5 = 1556,
	FN_SEL_HSCIF0_1___5 = 1557,
	FN_SEL_HSCIF0_2___2 = 1558,
	FN_SEL_HSCIF0_3 = 1559,
	FN_SEL_HSCIF0_4 = 1560,
	FN_SEL_HSCIF0_5 = 1561,
	FN_SEL_GPS_0___3 = 1562,
	FN_SEL_GPS_1___3 = 1563,
	FN_SEL_GPS_2___3 = 1564,
	FN_SEL_SIM_0___3 = 1565,
	FN_SEL_SIM_1___3 = 1566,
	FN_SEL_SIM_2 = 1567,
	FN_SEL_SSI8_0___5 = 1568,
	FN_SEL_SSI8_1___5 = 1569,
	FN_SEL_SSI8_2___2 = 1570,
	FN_SEL_IICDVFS_0 = 1571,
	FN_SEL_IICDVFS_1 = 1572,
	FN_SEL_IIC0_0___3 = 1573,
	FN_SEL_IIC0_1___3 = 1574,
	FN_SEL_IEB_0___3 = 1575,
	FN_SEL_IEB_1___3 = 1576,
	FN_SEL_IEB_2___3 = 1577,
	FN_SEL_IIC2_0 = 1578,
	FN_SEL_IIC2_1 = 1579,
	FN_SEL_IIC2_2 = 1580,
	FN_SEL_IIC2_3 = 1581,
	FN_SEL_IIC2_4 = 1582,
	FN_SEL_IIC1_0___2 = 1583,
	FN_SEL_IIC1_1___2 = 1584,
	FN_SEL_IIC1_2___2 = 1585,
	FN_SEL_I2C2_0___3 = 1586,
	FN_SEL_I2C2_1___3 = 1587,
	FN_SEL_I2C2_2___3 = 1588,
	FN_SEL_I2C2_3___3 = 1589,
	FN_SEL_I2C2_4 = 1590,
	FN_SEL_I2C1_0___3 = 1591,
	FN_SEL_I2C1_1___3 = 1592,
	FN_SEL_I2C1_2___3 = 1593,
	PINMUX_FUNCTION_END___11 = 1594,
	PINMUX_MARK_BEGIN___11 = 1595,
	VI1_DATA7_VI1_B7_MARK___2 = 1596,
	USB0_PWEN_MARK___4 = 1597,
	USB0_OVC_VBUS_MARK = 1598,
	USB2_PWEN_MARK = 1599,
	USB2_OVC_MARK = 1600,
	AVS1_MARK___4 = 1601,
	AVS2_MARK___4 = 1602,
	DU_DOTCLKIN0_MARK = 1603,
	DU_DOTCLKIN2_MARK = 1604,
	D0_MARK___7 = 1605,
	MSIOF3_SCK_B_MARK = 1606,
	VI3_DATA0_MARK___2 = 1607,
	VI0_G4_MARK___6 = 1608,
	VI0_G4_B_MARK = 1609,
	D1_MARK___7 = 1610,
	MSIOF3_SYNC_B_MARK = 1611,
	VI3_DATA1_MARK___2 = 1612,
	VI0_G5_MARK___6 = 1613,
	VI0_G5_B_MARK = 1614,
	D2_MARK___7 = 1615,
	MSIOF3_RXD_B_MARK = 1616,
	VI3_DATA2_MARK___2 = 1617,
	VI0_G6_MARK___5 = 1618,
	VI0_G6_B_MARK = 1619,
	D3_MARK___7 = 1620,
	MSIOF3_TXD_B_MARK = 1621,
	VI3_DATA3_MARK___2 = 1622,
	VI0_G7_MARK___5 = 1623,
	VI0_G7_B_MARK = 1624,
	D4_MARK___7 = 1625,
	SCIFB1_RXD_F_MARK = 1626,
	SCIFB0_RXD_C_MARK___2 = 1627,
	VI3_DATA4_MARK___2 = 1628,
	VI0_R0_MARK___5 = 1629,
	VI0_R0_B_MARK___2 = 1630,
	RX0_B_MARK___5 = 1631,
	D5_MARK___7 = 1632,
	SCIFB1_TXD_F_MARK = 1633,
	SCIFB0_TXD_C_MARK___2 = 1634,
	VI3_DATA5_MARK___2 = 1635,
	VI0_R1_MARK___5 = 1636,
	VI0_R1_B_MARK___2 = 1637,
	TX0_B_MARK___5 = 1638,
	D6_MARK___7 = 1639,
	IIC2_SCL_C_MARK = 1640,
	VI3_DATA6_MARK___2 = 1641,
	VI0_R2_MARK___5 = 1642,
	VI0_R2_B_MARK___2 = 1643,
	I2C2_SCL_C_MARK___3 = 1644,
	D7_MARK___7 = 1645,
	AD_DI_B_MARK = 1646,
	IIC2_SDA_C_MARK = 1647,
	VI3_DATA7_MARK___2 = 1648,
	VI0_R3_MARK___5 = 1649,
	VI0_R3_B_MARK___2 = 1650,
	I2C2_SDA_C_MARK___3 = 1651,
	TCLK1_MARK___6 = 1652,
	D8_MARK___7 = 1653,
	SCIFA1_SCK_C_MARK___2 = 1654,
	AVB_TXD0_MARK___5 = 1655,
	VI0_G0_MARK___5 = 1656,
	VI0_G0_B_MARK = 1657,
	VI2_DATA0_VI2_B0_MARK___2 = 1658,
	D9_MARK___7 = 1659,
	SCIFA1_RXD_C_MARK___3 = 1660,
	AVB_TXD1_MARK___5 = 1661,
	VI0_G1_MARK___5 = 1662,
	VI0_G1_B_MARK = 1663,
	VI2_DATA1_VI2_B1_MARK___2 = 1664,
	D10_MARK___7 = 1665,
	SCIFA1_TXD_C_MARK___3 = 1666,
	AVB_TXD2_MARK___5 = 1667,
	VI0_G2_MARK___6 = 1668,
	VI0_G2_B_MARK = 1669,
	VI2_DATA2_VI2_B2_MARK___2 = 1670,
	D11_MARK___7 = 1671,
	SCIFA1_CTS_N_C_MARK = 1672,
	AVB_TXD3_MARK___5 = 1673,
	VI0_G3_MARK___6 = 1674,
	VI0_G3_B_MARK = 1675,
	VI2_DATA3_VI2_B3_MARK___2 = 1676,
	D12_MARK___6 = 1677,
	SCIFA1_RTS_N_C_MARK = 1678,
	AVB_TXD4_MARK___5 = 1679,
	VI0_HSYNC_N_MARK___5 = 1680,
	VI0_HSYNC_N_B_MARK = 1681,
	VI2_DATA4_VI2_B4_MARK___2 = 1682,
	D13_MARK___6 = 1683,
	AVB_TXD5_MARK___5 = 1684,
	VI0_VSYNC_N_MARK___5 = 1685,
	VI0_VSYNC_N_B_MARK = 1686,
	VI2_DATA5_VI2_B5_MARK___2 = 1687,
	D14_MARK___6 = 1688,
	SCIFB1_RXD_C_MARK___2 = 1689,
	AVB_TXD6_MARK___5 = 1690,
	RX1_B_MARK___5 = 1691,
	VI0_CLKENB_MARK___7 = 1692,
	VI0_CLKENB_B_MARK = 1693,
	VI2_DATA6_VI2_B6_MARK___2 = 1694,
	D15_MARK___6 = 1695,
	SCIFB1_TXD_C_MARK___2 = 1696,
	AVB_TXD7_MARK___5 = 1697,
	TX1_B_MARK___5 = 1698,
	VI0_FIELD_MARK___7 = 1699,
	VI0_FIELD_B_MARK = 1700,
	VI2_DATA7_VI2_B7_MARK___2 = 1701,
	A0_MARK___10 = 1702,
	PWM3_MARK___6 = 1703,
	A1_MARK___8 = 1704,
	PWM4_MARK___6 = 1705,
	A2_MARK___8 = 1706,
	PWM5_MARK___5 = 1707,
	MSIOF1_SS1_B_MARK___3 = 1708,
	A3_MARK___8 = 1709,
	PWM6_MARK___5 = 1710,
	MSIOF1_SS2_B_MARK___3 = 1711,
	A4_MARK___7 = 1712,
	MSIOF1_TXD_B_MARK___4 = 1713,
	TPU0TO0_MARK___5 = 1714,
	A5_MARK___7 = 1715,
	SCIFA1_TXD_B_MARK___3 = 1716,
	TPU0TO1_MARK___5 = 1717,
	A6_MARK___8 = 1718,
	SCIFA1_RTS_N_B_MARK = 1719,
	TPU0TO2_MARK___4 = 1720,
	A7_MARK___8 = 1721,
	SCIFA1_SCK_B_MARK___3 = 1722,
	AUDIO_CLKOUT_B_MARK___5 = 1723,
	TPU0TO3_MARK___5 = 1724,
	A8_MARK___8 = 1725,
	SCIFA1_RXD_B_MARK___3 = 1726,
	SSI_SCK5_B_MARK___3 = 1727,
	VI0_R4_MARK___5 = 1728,
	VI0_R4_B_MARK___2 = 1729,
	SCIFB2_RXD_C_MARK___2 = 1730,
	RX2_B_MARK___5 = 1731,
	VI2_DATA0_VI2_B0_B_MARK = 1732,
	A9_MARK___8 = 1733,
	SCIFA1_CTS_N_B_MARK = 1734,
	SSI_WS5_B_MARK___3 = 1735,
	VI0_R5_MARK___5 = 1736,
	VI0_R5_B_MARK___2 = 1737,
	SCIFB2_TXD_C_MARK___2 = 1738,
	TX2_B_MARK___5 = 1739,
	VI2_DATA1_VI2_B1_B_MARK = 1740,
	A10_MARK___8 = 1741,
	SSI_SDATA5_B_MARK___3 = 1742,
	MSIOF2_SYNC_MARK___4 = 1743,
	VI0_R6_MARK___5 = 1744,
	VI0_R6_B_MARK = 1745,
	VI2_DATA2_VI2_B2_B_MARK = 1746,
	A11_MARK___8 = 1747,
	SCIFB2_CTS_N_B_MARK___2 = 1748,
	MSIOF2_SCK_MARK___4 = 1749,
	VI1_R0_MARK___2 = 1750,
	VI1_R0_B_MARK___2 = 1751,
	VI2_G0_MARK___2 = 1752,
	VI2_DATA3_VI2_B3_B_MARK = 1753,
	A12_MARK___8 = 1754,
	SCIFB2_RXD_B_MARK___2 = 1755,
	MSIOF2_TXD_MARK___6 = 1756,
	VI1_R1_MARK___2 = 1757,
	VI1_R1_B_MARK___2 = 1758,
	VI2_G1_MARK___2 = 1759,
	VI2_DATA4_VI2_B4_B_MARK = 1760,
	A13_MARK___8 = 1761,
	SCIFB2_RTS_N_B_MARK___2 = 1762,
	EX_WAIT2_MARK___4 = 1763,
	MSIOF2_RXD_MARK___5 = 1764,
	VI1_R2_MARK___2 = 1765,
	VI1_R2_B_MARK___2 = 1766,
	VI2_G2_MARK___2 = 1767,
	VI2_DATA5_VI2_B5_B_MARK = 1768,
	A14_MARK___8 = 1769,
	SCIFB2_TXD_B_MARK___2 = 1770,
	ATACS11_N_MARK___3 = 1771,
	MSIOF2_SS1_MARK___6 = 1772,
	A15_MARK___8 = 1773,
	SCIFB2_SCK_B_MARK___2 = 1774,
	ATARD1_N_MARK___3 = 1775,
	MSIOF2_SS2_MARK___6 = 1776,
	A16_MARK___8 = 1777,
	ATAWR1_N_MARK___3 = 1778,
	A17_MARK___9 = 1779,
	AD_DO_B_MARK = 1780,
	ATADIR1_N_MARK___3 = 1781,
	A18_MARK___9 = 1782,
	AD_CLK_B_MARK = 1783,
	ATAG1_N_MARK___3 = 1784,
	A19_MARK___9 = 1785,
	AD_NCS_N_B_MARK = 1786,
	ATACS01_N_MARK___3 = 1787,
	EX_WAIT0_B_MARK = 1788,
	A20_MARK___9 = 1789,
	SPCLK_MARK___4 = 1790,
	VI1_R3_MARK___2 = 1791,
	VI1_R3_B_MARK___2 = 1792,
	VI2_G4_MARK___2 = 1793,
	A21_MARK___9 = 1794,
	MOSI_IO0_MARK___4 = 1795,
	VI1_R4_MARK___2 = 1796,
	VI1_R4_B_MARK___2 = 1797,
	VI2_G5_MARK___2 = 1798,
	A22_MARK___9 = 1799,
	MISO_IO1_MARK___4 = 1800,
	VI1_R5_MARK___2 = 1801,
	VI1_R5_B_MARK___2 = 1802,
	VI2_G6_MARK___2 = 1803,
	A23_MARK___9 = 1804,
	IO2_MARK___4 = 1805,
	VI1_G7_MARK___2 = 1806,
	VI1_G7_B_MARK___2 = 1807,
	VI2_G7_MARK___2 = 1808,
	A24_MARK___9 = 1809,
	IO3_MARK___4 = 1810,
	VI1_R7_MARK___2 = 1811,
	VI1_R7_B_MARK___2 = 1812,
	VI2_CLKENB_MARK___4 = 1813,
	VI2_CLKENB_B_MARK = 1814,
	A25_MARK___9 = 1815,
	SSL_MARK___4 = 1816,
	VI1_G6_MARK___2 = 1817,
	VI1_G6_B_MARK___2 = 1818,
	VI2_FIELD_MARK___4 = 1819,
	VI2_FIELD_B_MARK = 1820,
	CS0_N_MARK___6 = 1821,
	VI1_R6_MARK___2 = 1822,
	VI1_R6_B_MARK___2 = 1823,
	VI2_G3_MARK___2 = 1824,
	MSIOF0_SS2_B_MARK___2 = 1825,
	CS1_N_A26_MARK___5 = 1826,
	SPEEDIN_MARK___5 = 1827,
	VI0_R7_MARK___5 = 1828,
	VI0_R7_B_MARK = 1829,
	VI2_CLK_MARK___4 = 1830,
	VI2_CLK_B_MARK = 1831,
	EX_CS0_N_MARK___4 = 1832,
	HRX1_B_MARK___5 = 1833,
	VI1_G5_MARK___2 = 1834,
	VI1_G5_B_MARK___2 = 1835,
	VI2_R0_MARK___2 = 1836,
	HTX0_B_MARK___5 = 1837,
	MSIOF0_SS1_B_MARK___2 = 1838,
	EX_CS1_N_MARK___4 = 1839,
	GPS_CLK_MARK___3 = 1840,
	HCTS1_N_B_MARK___2 = 1841,
	VI1_FIELD_MARK___7 = 1842,
	VI1_FIELD_B_MARK___2 = 1843,
	VI2_R1_MARK___2 = 1844,
	EX_CS2_N_MARK___4 = 1845,
	GPS_SIGN_MARK___3 = 1846,
	HRTS1_N_B_MARK___2 = 1847,
	VI3_CLKENB_MARK___3 = 1848,
	VI1_G0_MARK___2 = 1849,
	VI1_G0_B_MARK___2 = 1850,
	VI2_R2_MARK___2 = 1851,
	EX_CS3_N_MARK___4 = 1852,
	GPS_MAG_MARK___3 = 1853,
	VI3_FIELD_MARK___3 = 1854,
	VI1_G1_MARK___2 = 1855,
	VI1_G1_B_MARK___2 = 1856,
	VI2_R3_MARK___2 = 1857,
	EX_CS4_N_MARK___4 = 1858,
	MSIOF1_SCK_B_MARK___4 = 1859,
	VI3_HSYNC_N_MARK___2 = 1860,
	VI2_HSYNC_N_MARK___3 = 1861,
	IIC1_SCL_MARK___3 = 1862,
	VI2_HSYNC_N_B_MARK = 1863,
	INTC_EN0_N_MARK = 1864,
	I2C1_SCL_MARK___3 = 1865,
	EX_CS5_N_MARK___4 = 1866,
	CAN0_RX_MARK___5 = 1867,
	MSIOF1_RXD_B_MARK___4 = 1868,
	VI3_VSYNC_N_MARK___2 = 1869,
	VI1_G2_MARK___2 = 1870,
	VI1_G2_B_MARK___2 = 1871,
	VI2_R4_MARK___2 = 1872,
	IIC1_SDA_MARK___3 = 1873,
	INTC_EN1_N_MARK = 1874,
	I2C1_SDA_MARK___3 = 1875,
	BS_N_MARK___5 = 1876,
	IETX_MARK___5 = 1877,
	HTX1_B_MARK___5 = 1878,
	CAN1_TX_MARK___5 = 1879,
	DRACK0_MARK___7 = 1880,
	IETX_C_MARK___3 = 1881,
	RD_N_MARK___6 = 1882,
	CAN0_TX_MARK___5 = 1883,
	SCIFA0_SCK_B_MARK = 1884,
	RD_WR_N_MARK___5 = 1885,
	VI1_G3_MARK___2 = 1886,
	VI1_G3_B_MARK___2 = 1887,
	VI2_R5_MARK___2 = 1888,
	SCIFA0_RXD_B_MARK___3 = 1889,
	WE0_N_MARK___6 = 1890,
	IECLK_MARK___5 = 1891,
	CAN_CLK_MARK___5 = 1892,
	VI2_VSYNC_N_MARK___3 = 1893,
	SCIFA0_TXD_B_MARK___3 = 1894,
	VI2_VSYNC_N_B_MARK = 1895,
	WE1_N_MARK___6 = 1896,
	IERX_MARK___5 = 1897,
	CAN1_RX_MARK___5 = 1898,
	VI1_G4_MARK___2 = 1899,
	VI1_G4_B_MARK___2 = 1900,
	VI2_R6_MARK___2 = 1901,
	SCIFA0_CTS_N_B_MARK = 1902,
	IERX_C_MARK___3 = 1903,
	EX_WAIT0_MARK___6 = 1904,
	IRQ3_MARK___7 = 1905,
	VI3_CLK_MARK___3 = 1906,
	SCIFA0_RTS_N_B_MARK = 1907,
	HRX0_B_MARK___5 = 1908,
	MSIOF0_SCK_B_MARK___3 = 1909,
	DREQ0_N_MARK___4 = 1910,
	VI1_HSYNC_N_MARK___5 = 1911,
	VI1_HSYNC_N_B_MARK___2 = 1912,
	VI2_R7_MARK___2 = 1913,
	SSI_SCK78_C_MARK___2 = 1914,
	SSI_WS78_B_MARK___5 = 1915,
	DACK0_MARK___9 = 1916,
	IRQ0_MARK___8 = 1917,
	SSI_SCK6_B_MARK___3 = 1918,
	VI1_VSYNC_N_MARK___5 = 1919,
	VI1_VSYNC_N_B_MARK___2 = 1920,
	SSI_WS78_C_MARK___2 = 1921,
	DREQ1_N_MARK___4 = 1922,
	VI1_CLKENB_MARK___7 = 1923,
	VI1_CLKENB_B_MARK___2 = 1924,
	SSI_SDATA7_C_MARK___2 = 1925,
	SSI_SCK78_B_MARK___5 = 1926,
	DACK1_MARK___8 = 1927,
	IRQ1_MARK___8 = 1928,
	SSI_WS6_B_MARK___3 = 1929,
	SSI_SDATA8_C_MARK___2 = 1930,
	DREQ2_N_MARK___3 = 1931,
	HSCK1_B_MARK___3 = 1932,
	HCTS0_N_B_MARK___2 = 1933,
	MSIOF0_TXD_B_MARK___3 = 1934,
	DACK2_MARK___6 = 1935,
	IRQ2_MARK___7 = 1936,
	SSI_SDATA6_B_MARK___3 = 1937,
	HRTS0_N_B_MARK___2 = 1938,
	MSIOF0_RXD_B_MARK___3 = 1939,
	ETH_CRS_DV_MARK___6 = 1940,
	STP_ISCLK_0_B_MARK___2 = 1941,
	TS_SDEN0_D_MARK___2 = 1942,
	GLO_Q0_C_MARK___2 = 1943,
	IIC2_SCL_E_MARK = 1944,
	I2C2_SCL_E_MARK___2 = 1945,
	ETH_RX_ER_MARK___6 = 1946,
	STP_ISD_0_B_MARK___2 = 1947,
	TS_SPSYNC0_D_MARK___2 = 1948,
	GLO_Q1_C_MARK___2 = 1949,
	IIC2_SDA_E_MARK = 1950,
	I2C2_SDA_E_MARK___2 = 1951,
	ETH_RXD0_MARK___6 = 1952,
	STP_ISEN_0_B_MARK___2 = 1953,
	TS_SDAT0_D_MARK = 1954,
	GLO_I0_C_MARK___2 = 1955,
	SCIFB1_SCK_G_MARK = 1956,
	SCK1_E_MARK = 1957,
	ETH_RXD1_MARK___6 = 1958,
	HRX0_E_MARK = 1959,
	STP_ISSYNC_0_B_MARK___2 = 1960,
	TS_SCK0_D_MARK___2 = 1961,
	GLO_I1_C_MARK___2 = 1962,
	SCIFB1_RXD_G_MARK = 1963,
	RX1_E_MARK = 1964,
	ETH_LINK_MARK___6 = 1965,
	HTX0_E_MARK = 1966,
	STP_IVCXO27_0_B_MARK___2 = 1967,
	SCIFB1_TXD_G_MARK = 1968,
	TX1_E_MARK = 1969,
	ETH_REF_CLK_MARK___3 = 1970,
	HCTS0_N_E_MARK = 1971,
	STP_IVCXO27_1_B_MARK = 1972,
	HRX0_F_MARK = 1973,
	ETH_MDIO_MARK___6 = 1974,
	HRTS0_N_E_MARK = 1975,
	SIM0_D_C_MARK = 1976,
	HCTS0_N_F_MARK = 1977,
	ETH_TXD1_MARK___6 = 1978,
	HTX0_F_MARK = 1979,
	BPFCLK_G_MARK = 1980,
	ETH_TX_EN_MARK___6 = 1981,
	SIM0_CLK_C_MARK = 1982,
	HRTS0_N_F_MARK = 1983,
	ETH_MAGIC_MARK___6 = 1984,
	SIM0_RST_C_MARK = 1985,
	ETH_TXD0_MARK___6 = 1986,
	STP_ISCLK_1_B_MARK = 1987,
	TS_SDEN1_C_MARK = 1988,
	GLO_SCLK_C_MARK___2 = 1989,
	ETH_MDC_MARK___6 = 1990,
	STP_ISD_1_B_MARK = 1991,
	TS_SPSYNC1_C_MARK = 1992,
	GLO_SDATA_C_MARK___2 = 1993,
	PWM0_MARK___6 = 1994,
	SCIFA2_SCK_C_MARK = 1995,
	STP_ISEN_1_B_MARK = 1996,
	TS_SDAT1_C_MARK = 1997,
	GLO_SS_C_MARK___2 = 1998,
	PWM1_MARK___7 = 1999,
	SCIFA2_TXD_C_MARK = 2000,
	STP_ISSYNC_1_B_MARK = 2001,
	TS_SCK1_C_MARK = 2002,
	GLO_RFON_C_MARK___2 = 2003,
	PCMOE_N_MARK = 2004,
	PWM2_MARK___6 = 2005,
	PWMFSW0_MARK___2 = 2006,
	SCIFA2_RXD_C_MARK = 2007,
	PCMWE_N_MARK = 2008,
	IECLK_C_MARK___3 = 2009,
	DU_DOTCLKIN1_MARK = 2010,
	AUDIO_CLKC_MARK___5 = 2011,
	AUDIO_CLKOUT_C_MARK___4 = 2012,
	VI0_CLK_MARK___7 = 2013,
	ATACS00_N_MARK___3 = 2014,
	AVB_RXD1_MARK___5 = 2015,
	VI0_DATA0_VI0_B0_MARK___6 = 2016,
	ATACS10_N_MARK___3 = 2017,
	AVB_RXD2_MARK___5 = 2018,
	VI0_DATA1_VI0_B1_MARK___6 = 2019,
	ATARD0_N_MARK___3 = 2020,
	AVB_RXD3_MARK___5 = 2021,
	VI0_DATA2_VI0_B2_MARK___6 = 2022,
	ATAWR0_N_MARK___3 = 2023,
	AVB_RXD4_MARK___5 = 2024,
	VI0_DATA3_VI0_B3_MARK___6 = 2025,
	ATADIR0_N_MARK___3 = 2026,
	AVB_RXD5_MARK___5 = 2027,
	VI0_DATA4_VI0_B4_MARK___6 = 2028,
	ATAG0_N_MARK___3 = 2029,
	AVB_RXD6_MARK___5 = 2030,
	VI0_DATA5_VI0_B5_MARK___6 = 2031,
	EX_WAIT1_MARK___5 = 2032,
	AVB_RXD7_MARK___5 = 2033,
	VI0_DATA6_VI0_B6_MARK___5 = 2034,
	AVB_RX_ER_MARK___5 = 2035,
	VI0_DATA7_VI0_B7_MARK___5 = 2036,
	AVB_RX_CLK_MARK___5 = 2037,
	VI1_CLK_MARK___7 = 2038,
	AVB_RX_DV_MARK___5 = 2039,
	VI1_DATA0_VI1_B0_MARK___2 = 2040,
	SCIFA1_SCK_D_MARK = 2041,
	AVB_CRS_MARK___5 = 2042,
	VI1_DATA1_VI1_B1_MARK___2 = 2043,
	SCIFA1_RXD_D_MARK = 2044,
	AVB_MDC_MARK___5 = 2045,
	VI1_DATA2_VI1_B2_MARK___2 = 2046,
	SCIFA1_TXD_D_MARK = 2047,
	AVB_MDIO_MARK___5 = 2048,
	VI1_DATA3_VI1_B3_MARK___2 = 2049,
	SCIFA1_CTS_N_D_MARK = 2050,
	AVB_GTX_CLK_MARK___5 = 2051,
	VI1_DATA4_VI1_B4_MARK___2 = 2052,
	SCIFA1_RTS_N_D_MARK = 2053,
	AVB_MAGIC_MARK___5 = 2054,
	VI1_DATA5_VI1_B5_MARK___2 = 2055,
	AVB_PHY_INT_MARK___5 = 2056,
	VI1_DATA6_VI1_B6_MARK___2 = 2057,
	AVB_GTXREFCLK_MARK___5 = 2058,
	SD0_CLK_MARK___7 = 2059,
	VI1_DATA0_VI1_B0_B_MARK = 2060,
	SD0_CMD_MARK___7 = 2061,
	SCIFB1_SCK_B_MARK___2 = 2062,
	VI1_DATA1_VI1_B1_B_MARK = 2063,
	SD0_DAT0_MARK___5 = 2064,
	SCIFB1_RXD_B_MARK___2 = 2065,
	VI1_DATA2_VI1_B2_B_MARK = 2066,
	SD0_DAT1_MARK___5 = 2067,
	SCIFB1_TXD_B_MARK___2 = 2068,
	VI1_DATA3_VI1_B3_B_MARK = 2069,
	SD0_DAT2_MARK___5 = 2070,
	SCIFB1_CTS_N_B_MARK = 2071,
	VI1_DATA4_VI1_B4_B_MARK = 2072,
	SD0_DAT3_MARK___5 = 2073,
	SCIFB1_RTS_N_B_MARK = 2074,
	VI1_DATA5_VI1_B5_B_MARK = 2075,
	SD0_CD_MARK___7 = 2076,
	MMC0_D6_MARK___3 = 2077,
	TS_SDEN0_B_MARK___3 = 2078,
	USB0_EXTP_MARK = 2079,
	GLO_SCLK_MARK___2 = 2080,
	VI1_DATA6_VI1_B6_B_MARK = 2081,
	IIC1_SCL_B_MARK___2 = 2082,
	I2C1_SCL_B_MARK___3 = 2083,
	VI2_DATA6_VI2_B6_B_MARK = 2084,
	SD0_WP_MARK___7 = 2085,
	MMC0_D7_MARK___3 = 2086,
	TS_SPSYNC0_B_MARK___3 = 2087,
	USB0_IDIN_MARK = 2088,
	GLO_SDATA_MARK___2 = 2089,
	VI1_DATA7_VI1_B7_B_MARK = 2090,
	IIC1_SDA_B_MARK___2 = 2091,
	I2C1_SDA_B_MARK___3 = 2092,
	VI2_DATA7_VI2_B7_B_MARK = 2093,
	SD1_CLK_MARK___4 = 2094,
	AVB_TX_EN_MARK___5 = 2095,
	SD1_CMD_MARK___4 = 2096,
	AVB_TX_ER_MARK___5 = 2097,
	SCIFB0_SCK_B_MARK___2 = 2098,
	SD1_DAT0_MARK___2 = 2099,
	AVB_TX_CLK_MARK___5 = 2100,
	SCIFB0_RXD_B_MARK___2 = 2101,
	SD1_DAT1_MARK___2 = 2102,
	AVB_LINK_MARK___5 = 2103,
	SCIFB0_TXD_B_MARK___2 = 2104,
	SD1_DAT2_MARK___2 = 2105,
	AVB_COL_MARK___5 = 2106,
	SCIFB0_CTS_N_B_MARK___2 = 2107,
	SD1_DAT3_MARK___2 = 2108,
	AVB_RXD0_MARK___5 = 2109,
	SCIFB0_RTS_N_B_MARK___2 = 2110,
	SD1_CD_MARK___5 = 2111,
	MMC1_D6_MARK___2 = 2112,
	TS_SDEN1_MARK___3 = 2113,
	USB1_EXTP_MARK = 2114,
	GLO_SS_MARK___2 = 2115,
	VI0_CLK_B_MARK = 2116,
	IIC2_SCL_D_MARK = 2117,
	I2C2_SCL_D_MARK___3 = 2118,
	SIM0_CLK_B_MARK = 2119,
	VI3_CLK_B_MARK = 2120,
	SD1_WP_MARK___5 = 2121,
	MMC1_D7_MARK___2 = 2122,
	TS_SPSYNC1_MARK___3 = 2123,
	USB1_IDIN_MARK = 2124,
	GLO_RFON_MARK___2 = 2125,
	VI1_CLK_B_MARK___2 = 2126,
	IIC2_SDA_D_MARK = 2127,
	I2C2_SDA_D_MARK___3 = 2128,
	SIM0_D_B_MARK___2 = 2129,
	SD2_CLK_MARK___5 = 2130,
	MMC0_CLK_MARK___2 = 2131,
	SIM0_CLK_MARK___3 = 2132,
	VI0_DATA0_VI0_B0_B_MARK = 2133,
	TS_SDEN0_C_MARK___2 = 2134,
	GLO_SCLK_B_MARK___2 = 2135,
	VI3_DATA0_B_MARK = 2136,
	SD2_CMD_MARK___5 = 2137,
	MMC0_CMD_MARK___2 = 2138,
	SIM0_D_MARK___2 = 2139,
	VI0_DATA1_VI0_B1_B_MARK = 2140,
	SCIFB1_SCK_E_MARK = 2141,
	SCK1_D_MARK = 2142,
	TS_SPSYNC0_C_MARK___2 = 2143,
	GLO_SDATA_B_MARK___2 = 2144,
	VI3_DATA1_B_MARK = 2145,
	SD2_DAT0_MARK___3 = 2146,
	MMC0_D0_MARK___2 = 2147,
	FMCLK_B_MARK___4 = 2148,
	VI0_DATA2_VI0_B2_B_MARK = 2149,
	SCIFB1_RXD_E_MARK = 2150,
	RX1_D_MARK___4 = 2151,
	TS_SDAT0_C_MARK = 2152,
	GLO_SS_B_MARK___2 = 2153,
	VI3_DATA2_B_MARK = 2154,
	SD2_DAT1_MARK___3 = 2155,
	MMC0_D1_MARK___2 = 2156,
	FMIN_B_MARK___4 = 2157,
	VI0_DATA3_VI0_B3_B_MARK = 2158,
	SCIFB1_TXD_E_MARK = 2159,
	TX1_D_MARK___4 = 2160,
	TS_SCK0_C_MARK___2 = 2161,
	GLO_RFON_B_MARK___2 = 2162,
	VI3_DATA3_B_MARK = 2163,
	SD2_DAT2_MARK___3 = 2164,
	MMC0_D2_MARK___2 = 2165,
	BPFCLK_B_MARK___4 = 2166,
	VI0_DATA4_VI0_B4_B_MARK = 2167,
	HRX0_D_MARK = 2168,
	TS_SDEN1_B_MARK = 2169,
	GLO_Q0_B_MARK___2 = 2170,
	VI3_DATA4_B_MARK = 2171,
	SD2_DAT3_MARK___3 = 2172,
	MMC0_D3_MARK___2 = 2173,
	SIM0_RST_MARK___3 = 2174,
	VI0_DATA5_VI0_B5_B_MARK = 2175,
	HTX0_D_MARK = 2176,
	TS_SPSYNC1_B_MARK = 2177,
	GLO_Q1_B_MARK___2 = 2178,
	VI3_DATA5_B_MARK = 2179,
	SD2_CD_MARK___5 = 2180,
	MMC0_D4_MARK___3 = 2181,
	TS_SDAT0_B_MARK___2 = 2182,
	USB2_EXTP_MARK = 2183,
	GLO_I0_MARK___2 = 2184,
	VI0_DATA6_VI0_B6_B_MARK = 2185,
	HCTS0_N_D_MARK = 2186,
	TS_SDAT1_B_MARK = 2187,
	GLO_I0_B_MARK___2 = 2188,
	VI3_DATA6_B_MARK = 2189,
	SD2_WP_MARK___5 = 2190,
	MMC0_D5_MARK___3 = 2191,
	TS_SCK0_B_MARK___3 = 2192,
	USB2_IDIN_MARK = 2193,
	GLO_I1_MARK___2 = 2194,
	VI0_DATA7_VI0_B7_B_MARK = 2195,
	HRTS0_N_D_MARK = 2196,
	TS_SCK1_B_MARK = 2197,
	GLO_I1_B_MARK___2 = 2198,
	VI3_DATA7_B_MARK = 2199,
	SD3_CLK_MARK___2 = 2200,
	MMC1_CLK_MARK___2 = 2201,
	SD3_CMD_MARK___2 = 2202,
	MMC1_CMD_MARK___2 = 2203,
	MTS_N_MARK = 2204,
	SD3_DAT0_MARK___2 = 2205,
	MMC1_D0_MARK___2 = 2206,
	STM_N_MARK = 2207,
	SD3_DAT1_MARK___2 = 2208,
	MMC1_D1_MARK___2 = 2209,
	MDATA_MARK___2 = 2210,
	SD3_DAT2_MARK___2 = 2211,
	MMC1_D2_MARK___2 = 2212,
	SDATA_MARK___2 = 2213,
	SD3_DAT3_MARK___2 = 2214,
	MMC1_D3_MARK___2 = 2215,
	SCKZ_MARK___2 = 2216,
	SD3_CD_MARK___2 = 2217,
	MMC1_D4_MARK___2 = 2218,
	TS_SDAT1_MARK___3 = 2219,
	VSP_MARK___2 = 2220,
	GLO_Q0_MARK___2 = 2221,
	SIM0_RST_B_MARK___2 = 2222,
	SD3_WP_MARK___2 = 2223,
	MMC1_D5_MARK___2 = 2224,
	TS_SCK1_MARK___3 = 2225,
	GLO_Q1_MARK___2 = 2226,
	FMIN_C_MARK___4 = 2227,
	FMIN_E_MARK___3 = 2228,
	FMIN_F_MARK = 2229,
	MLB_CLK_MARK___5 = 2230,
	IIC2_SCL_B_MARK = 2231,
	I2C2_SCL_B_MARK___3 = 2232,
	MLB_SIG_MARK___5 = 2233,
	SCIFB1_RXD_D_MARK___2 = 2234,
	RX1_C_MARK___5 = 2235,
	IIC2_SDA_B_MARK = 2236,
	I2C2_SDA_B_MARK___3 = 2237,
	MLB_DAT_MARK___5 = 2238,
	SCIFB1_TXD_D_MARK___2 = 2239,
	TX1_C_MARK___5 = 2240,
	BPFCLK_C_MARK___4 = 2241,
	SSI_SCK0129_MARK___4 = 2242,
	CAN_CLK_B_MARK___6 = 2243,
	MOUT0_MARK___2 = 2244,
	SSI_WS0129_MARK___4 = 2245,
	CAN0_TX_B_MARK___6 = 2246,
	MOUT1_MARK___2 = 2247,
	SSI_SDATA0_MARK___5 = 2248,
	CAN0_RX_B_MARK___6 = 2249,
	MOUT2_MARK___2 = 2250,
	SSI_SDATA1_MARK___5 = 2251,
	CAN1_TX_B_MARK___5 = 2252,
	MOUT5_MARK___2 = 2253,
	SSI_SDATA2_MARK___5 = 2254,
	CAN1_RX_B_MARK___5 = 2255,
	SSI_SCK1_MARK___4 = 2256,
	MOUT6_MARK___2 = 2257,
	SSI_SCK34_MARK___7 = 2258,
	STP_OPWM_0_MARK___3 = 2259,
	SCIFB0_SCK_MARK___4 = 2260,
	MSIOF1_SCK_MARK___5 = 2261,
	CAN_DEBUG_HW_TRIGGER_MARK___2 = 2262,
	SSI_WS34_MARK___7 = 2263,
	STP_IVCXO27_0_MARK___2 = 2264,
	SCIFB0_RXD_MARK___4 = 2265,
	MSIOF1_SYNC_MARK___5 = 2266,
	CAN_STEP0_MARK___2 = 2267,
	SSI_SDATA3_MARK___7 = 2268,
	STP_ISCLK_0_MARK___3 = 2269,
	SCIFB0_TXD_MARK___4 = 2270,
	MSIOF1_SS1_MARK___5 = 2271,
	CAN_TXCLK_MARK___3 = 2272,
	SSI_SCK4_MARK___6 = 2273,
	STP_ISD_0_MARK___3 = 2274,
	SCIFB0_CTS_N_MARK___3 = 2275,
	MSIOF1_SS2_MARK___5 = 2276,
	SSI_SCK5_C_MARK = 2277,
	CAN_DEBUGOUT0_MARK___2 = 2278,
	SSI_WS4_MARK___6 = 2279,
	STP_ISEN_0_MARK___3 = 2280,
	SCIFB0_RTS_N_MARK___3 = 2281,
	MSIOF1_TXD_MARK___6 = 2282,
	SSI_WS5_C_MARK = 2283,
	CAN_DEBUGOUT1_MARK___2 = 2284,
	SSI_SDATA4_MARK___6 = 2285,
	STP_ISSYNC_0_MARK___3 = 2286,
	MSIOF1_RXD_MARK___6 = 2287,
	CAN_DEBUGOUT2_MARK___2 = 2288,
	SSI_SCK5_MARK___5 = 2289,
	SCIFB1_SCK_MARK___3 = 2290,
	IERX_B_MARK___4 = 2291,
	DU2_EXHSYNC_DU2_HSYNC_MARK = 2292,
	QSTH_QHS_MARK___5 = 2293,
	CAN_DEBUGOUT3_MARK___2 = 2294,
	SSI_WS5_MARK___5 = 2295,
	SCIFB1_RXD_MARK___3 = 2296,
	IECLK_B_MARK___4 = 2297,
	DU2_EXVSYNC_DU2_VSYNC_MARK = 2298,
	QSTB_QHE_MARK___5 = 2299,
	CAN_DEBUGOUT4_MARK___2 = 2300,
	SSI_SDATA5_MARK___5 = 2301,
	SCIFB1_TXD_MARK___3 = 2302,
	IETX_B_MARK___4 = 2303,
	DU2_DR2_MARK = 2304,
	LCDOUT2_MARK___5 = 2305,
	CAN_DEBUGOUT5_MARK___2 = 2306,
	SSI_SCK6_MARK___5 = 2307,
	SCIFB1_CTS_N_MARK___2 = 2308,
	BPFCLK_D_MARK___4 = 2309,
	DU2_DR3_MARK = 2310,
	LCDOUT3_MARK___5 = 2311,
	CAN_DEBUGOUT6_MARK___2 = 2312,
	BPFCLK_F_MARK = 2313,
	SSI_WS6_MARK___5 = 2314,
	SCIFB1_RTS_N_MARK___2 = 2315,
	CAN0_TX_D_MARK___4 = 2316,
	DU2_DR4_MARK = 2317,
	LCDOUT4_MARK___5 = 2318,
	CAN_DEBUGOUT7_MARK___2 = 2319,
	SSI_SDATA6_MARK___5 = 2320,
	FMIN_D_MARK___4 = 2321,
	DU2_DR5_MARK = 2322,
	LCDOUT5_MARK___5 = 2323,
	CAN_DEBUGOUT8_MARK___2 = 2324,
	SSI_SCK78_MARK___5 = 2325,
	STP_IVCXO27_1_MARK = 2326,
	SCK1_MARK___3 = 2327,
	SCIFA1_SCK_MARK___6 = 2328,
	DU2_DR6_MARK = 2329,
	LCDOUT6_MARK___5 = 2330,
	CAN_DEBUGOUT9_MARK___2 = 2331,
	SSI_WS78_MARK___5 = 2332,
	STP_ISCLK_1_MARK___2 = 2333,
	SCIFB2_SCK_MARK___3 = 2334,
	SCIFA2_CTS_N_MARK = 2335,
	DU2_DR7_MARK = 2336,
	LCDOUT7_MARK___5 = 2337,
	CAN_DEBUGOUT10_MARK___2 = 2338,
	SSI_SDATA7_MARK___5 = 2339,
	STP_ISD_1_MARK___2 = 2340,
	SCIFB2_RXD_MARK___3 = 2341,
	SCIFA2_RTS_N_MARK = 2342,
	TCLK2_MARK___4 = 2343,
	QSTVA_QVS_MARK___5 = 2344,
	CAN_DEBUGOUT11_MARK___2 = 2345,
	BPFCLK_E_MARK___3 = 2346,
	SSI_SDATA7_B_MARK___5 = 2347,
	FMIN_G_MARK = 2348,
	SSI_SDATA8_MARK___5 = 2349,
	STP_ISEN_1_MARK___2 = 2350,
	SCIFB2_TXD_MARK___3 = 2351,
	CAN0_TX_C_MARK___4 = 2352,
	CAN_DEBUGOUT12_MARK___2 = 2353,
	SSI_SDATA8_B_MARK___5 = 2354,
	SSI_SDATA9_MARK___4 = 2355,
	STP_ISSYNC_1_MARK___2 = 2356,
	SCIFB2_CTS_N_MARK___3 = 2357,
	SSI_WS1_MARK___4 = 2358,
	SSI_SDATA5_C_MARK = 2359,
	CAN_DEBUGOUT13_MARK___2 = 2360,
	AUDIO_CLKA_MARK___6 = 2361,
	SCIFB2_RTS_N_MARK___3 = 2362,
	CAN_DEBUGOUT14_MARK___2 = 2363,
	AUDIO_CLKB_MARK___6 = 2364,
	SCIF_CLK_MARK___6 = 2365,
	CAN0_RX_D_MARK___4 = 2366,
	DVC_MUTE_MARK___4 = 2367,
	CAN0_RX_C_MARK___4 = 2368,
	CAN_DEBUGOUT15_MARK___2 = 2369,
	REMOCON_MARK___4 = 2370,
	SCIFA0_SCK_MARK___4 = 2371,
	HSCK1_MARK___5 = 2372,
	SCK0_MARK___4 = 2373,
	MSIOF3_SS2_MARK___2 = 2374,
	DU2_DG2_MARK = 2375,
	LCDOUT10_MARK___5 = 2376,
	IIC1_SDA_C_MARK___2 = 2377,
	I2C1_SDA_C_MARK___3 = 2378,
	SCIFA0_RXD_MARK___6 = 2379,
	HRX1_MARK___4 = 2380,
	RX0_MARK___4 = 2381,
	DU2_DR0_MARK = 2382,
	LCDOUT0_MARK___5 = 2383,
	SCIFA0_TXD_MARK___6 = 2384,
	HTX1_MARK___4 = 2385,
	TX0_MARK___4 = 2386,
	DU2_DR1_MARK = 2387,
	LCDOUT1_MARK___5 = 2388,
	SCIFA0_CTS_N_MARK = 2389,
	HCTS1_N_MARK___3 = 2390,
	CTS0_N_MARK___2 = 2391,
	MSIOF3_SYNC_MARK___2 = 2392,
	DU2_DG3_MARK = 2393,
	LCDOUT11_MARK___5 = 2394,
	PWM0_B_MARK___6 = 2395,
	IIC1_SCL_C_MARK___2 = 2396,
	I2C1_SCL_C_MARK___3 = 2397,
	SCIFA0_RTS_N_MARK = 2398,
	HRTS1_N_MARK___3 = 2399,
	RTS0_N_MARK___2 = 2400,
	MSIOF3_SS1_MARK___2 = 2401,
	DU2_DG0_MARK = 2402,
	LCDOUT8_MARK___5 = 2403,
	PWM1_B_MARK___4 = 2404,
	SCIFA1_RXD_MARK___6 = 2405,
	AD_DI_MARK___2 = 2406,
	RX1_MARK___4 = 2407,
	DU2_EXODDF_DU2_ODDF_DISP_CDE_MARK = 2408,
	QCPV_QDE_MARK___5 = 2409,
	SCIFA1_TXD_MARK___6 = 2410,
	AD_DO_MARK___2 = 2411,
	TX1_MARK___4 = 2412,
	DU2_DG1_MARK = 2413,
	LCDOUT9_MARK___5 = 2414,
	SCIFA1_CTS_N_MARK = 2415,
	AD_CLK_MARK___2 = 2416,
	CTS1_N_MARK___2 = 2417,
	MSIOF3_RXD_MARK___2 = 2418,
	DU0_DOTCLKOUT_MARK___2 = 2419,
	QCLK_MARK___5 = 2420,
	SCIFA1_RTS_N_MARK = 2421,
	AD_NCS_N_MARK = 2422,
	RTS1_N_MARK___2 = 2423,
	MSIOF3_TXD_MARK___2 = 2424,
	DU1_DOTCLKOUT_MARK___3 = 2425,
	QSTVB_QVE_MARK___5 = 2426,
	HRTS0_N_C_MARK = 2427,
	SCIFA2_SCK_MARK___3 = 2428,
	FMCLK_MARK___4 = 2429,
	SCK2_MARK___3 = 2430,
	MSIOF3_SCK_MARK___2 = 2431,
	DU2_DG7_MARK = 2432,
	LCDOUT15_MARK___5 = 2433,
	SCIF_CLK_B_MARK___5 = 2434,
	SCIFA2_RXD_MARK___4 = 2435,
	FMIN_MARK___4 = 2436,
	TX2_MARK___4 = 2437,
	DU2_DB0_MARK = 2438,
	LCDOUT16_MARK___5 = 2439,
	IIC2_SCL_MARK = 2440,
	I2C2_SCL_MARK___3 = 2441,
	SCIFA2_TXD_MARK___4 = 2442,
	BPFCLK_MARK___4 = 2443,
	RX2_MARK___4 = 2444,
	DU2_DB1_MARK = 2445,
	LCDOUT17_MARK___5 = 2446,
	IIC2_SDA_MARK = 2447,
	I2C2_SDA_MARK___3 = 2448,
	HSCK0_MARK___6 = 2449,
	TS_SDEN0_MARK___3 = 2450,
	DU2_DG4_MARK = 2451,
	LCDOUT12_MARK___5 = 2452,
	HCTS0_N_C_MARK = 2453,
	HRX0_MARK___4 = 2454,
	DU2_DB2_MARK = 2455,
	LCDOUT18_MARK___5 = 2456,
	HTX0_MARK___4 = 2457,
	DU2_DB3_MARK = 2458,
	LCDOUT19_MARK___5 = 2459,
	HCTS0_N_MARK___4 = 2460,
	SSI_SCK9_MARK___4 = 2461,
	DU2_DB4_MARK = 2462,
	LCDOUT20_MARK___5 = 2463,
	HRTS0_N_MARK___4 = 2464,
	SSI_WS9_MARK___4 = 2465,
	DU2_DB5_MARK = 2466,
	LCDOUT21_MARK___5 = 2467,
	MSIOF0_SCK_MARK___5 = 2468,
	TS_SDAT0_MARK___2 = 2469,
	ADICLK_MARK___6 = 2470,
	DU2_DB6_MARK = 2471,
	LCDOUT22_MARK___5 = 2472,
	MSIOF0_SYNC_MARK___5 = 2473,
	TS_SCK0_MARK___3 = 2474,
	SSI_SCK2_MARK___4 = 2475,
	ADIDATA_MARK___6 = 2476,
	DU2_DB7_MARK = 2477,
	LCDOUT23_MARK___5 = 2478,
	HRX0_C_MARK___2 = 2479,
	MSIOF0_SS1_MARK___6 = 2480,
	ADICHS0_MARK___6 = 2481,
	DU2_DG5_MARK = 2482,
	LCDOUT13_MARK___5 = 2483,
	MSIOF0_TXD_MARK___7 = 2484,
	ADICHS1_MARK___6 = 2485,
	DU2_DG6_MARK = 2486,
	LCDOUT14_MARK___5 = 2487,
	MSIOF0_SS2_MARK___6 = 2488,
	AUDIO_CLKOUT_MARK___5 = 2489,
	ADICHS2_MARK___6 = 2490,
	DU2_DISP_MARK = 2491,
	QPOLA_MARK___5 = 2492,
	HTX0_C_MARK___2 = 2493,
	SCIFA2_TXD_B_MARK___3 = 2494,
	MSIOF0_RXD_MARK___7 = 2495,
	TS_SPSYNC0_MARK___3 = 2496,
	SSI_WS2_MARK___4 = 2497,
	ADICS_SAMP_MARK___6 = 2498,
	DU2_CDE_MARK = 2499,
	QPOLB_MARK___5 = 2500,
	SCIFA2_RXD_B_MARK___3 = 2501,
	USB1_PWEN_MARK___4 = 2502,
	AUDIO_CLKOUT_D_MARK = 2503,
	USB1_OVC_MARK___4 = 2504,
	TCLK1_B_MARK___5 = 2505,
	IIC0_SCL_MARK___4 = 2506,
	IIC0_SDA_MARK___4 = 2507,
	I2C0_SCL_MARK___3 = 2508,
	I2C0_SDA_MARK___3 = 2509,
	IIC3_SCL_MARK = 2510,
	IIC3_SDA_MARK = 2511,
	I2C3_SCL_MARK___3 = 2512,
	I2C3_SDA_MARK___3 = 2513,
	PINMUX_MARK_END___11 = 2514,
};

enum {
	PINMUX_TYPE_NONE = 0,
	PINMUX_TYPE_FUNCTION = 1,
	PINMUX_TYPE_GPIO = 2,
	PINMUX_TYPE_OUTPUT = 3,
	PINMUX_TYPE_INPUT = 4,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PLL_OFF_L_VAL = 0,
	PLL_OFF_CAL_L_VAL = 1,
	PLL_OFF_ALPHA_VAL = 2,
	PLL_OFF_ALPHA_VAL_U = 3,
	PLL_OFF_USER_CTL = 4,
	PLL_OFF_USER_CTL_U = 5,
	PLL_OFF_USER_CTL_U1 = 6,
	PLL_OFF_CONFIG_CTL = 7,
	PLL_OFF_CONFIG_CTL_U = 8,
	PLL_OFF_CONFIG_CTL_U1 = 9,
	PLL_OFF_CONFIG_CTL_U2 = 10,
	PLL_OFF_TEST_CTL = 11,
	PLL_OFF_TEST_CTL_U = 12,
	PLL_OFF_TEST_CTL_U1 = 13,
	PLL_OFF_TEST_CTL_U2 = 14,
	PLL_OFF_TEST_CTL_U3 = 15,
	PLL_OFF_STATE = 16,
	PLL_OFF_STATUS = 17,
	PLL_OFF_OPMODE = 18,
	PLL_OFF_FRAC = 19,
	PLL_OFF_CAL_VAL = 20,
	PLL_OFF_MAX_REGS = 21,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	PORT_LAST = 309,
	PIN_A11 = 310,
};

enum {
	PORT_LAST___2 = 158,
	PIN_LCD3_B2 = 159,
	PIN_LCD3_B3 = 160,
	PIN_LCD3_B4 = 161,
	PIN_LCD3_B5 = 162,
	PIN_LCD3_B6 = 163,
	PIN_LCD3_B7 = 164,
	PIN_LCD3_G2 = 165,
	PIN_LCD3_G3 = 166,
	PIN_LCD3_G4 = 167,
	PIN_LCD3_G5 = 168,
	PIN_LCD3_G6 = 169,
	PIN_LCD3_G7 = 170,
};

enum {
	POWERCAP_FC_CAP = 0,
	POWERCAP_FC_PAI = 1,
	POWERCAP_FC_MAX = 2,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREF_UNIT_OP_ON = 8,
	PREF_UNIT_OP_OFF = 4,
	PREF_UNIT_RST_CLR = 2,
	PREF_UNIT_RST_SET = 1,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_MSK = 240,
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_BASE = 4,
	PSM_CONFIG_REG4_DEBUG_TIMER = 2,
	PSM_CONFIG_REG4_RST_PHY_LINK_DETECT = 1,
};

enum {
	PULS_NO_STR = 0,
	PULS_21MS = 1,
	PULS_42MS = 2,
	PULS_84MS = 3,
	PULS_170MS = 4,
	PULS_340MS = 5,
	PULS_670MS = 6,
	PULS_1300MS = 7,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWR_DESC_ANY = 0,
	PWR_DESC_PWM = 1,
	PWR_DESC_HS = 2,
	PWR_DESC_SER_A = 1,
	PWR_DESC_SER_B = 2,
	PWR_DESC_G1 = 1,
	PWR_DESC_G2 = 2,
	PWR_DESC_G3 = 3,
	MD_MASK = 3,
	SR_MASK = 3,
	GR_MASK = 7,
};

enum {
	PWR_OK = 0,
	PWR_LOCAL = 1,
	PWR_REMOTE = 2,
	PWR_BUSY = 3,
	PWR_ERROR_CAP = 4,
	PWR_FATAL_ERROR = 5,
};

enum {
	P_AUD_REF_CLK = 0,
	P_GPLL0_OUT_MAIN = 1,
	P_GPLL4_OUT_MAIN = 2,
	P_PLL0_EARLY_DIV_CLK_SRC = 3,
	P_SLEEP_CLK = 4,
	P_XO = 5,
};

enum {
	P_BI_TCXO = 0,
	P_EMAC0_SGMIIPHY_MAC_RCLK = 1,
	P_EMAC0_SGMIIPHY_MAC_TCLK = 2,
	P_EMAC0_SGMIIPHY_RCLK = 3,
	P_EMAC0_SGMIIPHY_TCLK = 4,
	P_EMAC1_SGMIIPHY_MAC_RCLK = 5,
	P_EMAC1_SGMIIPHY_MAC_TCLK = 6,
	P_EMAC1_SGMIIPHY_RCLK = 7,
	P_EMAC1_SGMIIPHY_TCLK = 8,
	P_GPLL0_OUT_EVEN = 9,
	P_GPLL0_OUT_MAIN___2 = 10,
	P_GPLL4_OUT_MAIN___2 = 11,
	P_GPLL5_OUT_MAIN = 12,
	P_GPLL6_OUT_MAIN = 13,
	P_GPLL8_OUT_MAIN = 14,
	P_PCIE20_PHY_AUX_CLK = 15,
	P_PCIE_1_PIPE_CLK = 16,
	P_PCIE_2_PIPE_CLK = 17,
	P_PCIE_PIPE_CLK = 18,
	P_SLEEP_CLK___2 = 19,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 20,
};

enum {
	P_BI_TCXO___2 = 0,
	P_GCC_GPLL0_OUT_EVEN = 1,
	P_GCC_GPLL0_OUT_MAIN = 2,
	P_GCC_GPLL1_OUT_MAIN = 3,
	P_GCC_GPLL2_OUT_MAIN = 4,
	P_GCC_GPLL3_OUT_MAIN = 5,
	P_GCC_GPLL4_OUT_MAIN = 6,
	P_GCC_GPLL5_OUT_MAIN = 7,
	P_GCC_GPLL6_OUT_MAIN = 8,
	P_GCC_GPLL7_OUT_MAIN = 9,
	P_GCC_GPLL8_OUT_MAIN = 10,
	P_PCIE_0_PHY_AUX_CLK = 11,
	P_PCIE_0_PIPE_CLK = 12,
	P_SLEEP_CLK___3 = 13,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___2 = 14,
};

enum {
	P_BI_TCXO___3 = 0,
	P_GCC_GPLL0_OUT_EVEN___2 = 1,
	P_GCC_GPLL0_OUT_MAIN___2 = 2,
	P_GCC_GPLL1_OUT_MAIN___2 = 3,
	P_GCC_GPLL4_OUT_MAIN___2 = 4,
	P_GCC_GPLL5_OUT_MAIN___2 = 5,
	P_GCC_GPLL7_OUT_MAIN___2 = 6,
	P_GCC_GPLL9_OUT_MAIN = 7,
	P_PCIE_0_PIPE_CLK___2 = 8,
	P_PCIE_1_PIPE_CLK___2 = 9,
	P_PCIE_PHY_AUX_CLK = 10,
	P_RXC0_REF_CLK = 11,
	P_RXC1_REF_CLK = 12,
	P_SLEEP_CLK___4 = 13,
	P_UFS_CARD_RX_SYMBOL_0_CLK = 14,
	P_UFS_CARD_RX_SYMBOL_1_CLK = 15,
	P_UFS_CARD_TX_SYMBOL_0_CLK = 16,
	P_UFS_PHY_RX_SYMBOL_0_CLK = 17,
	P_UFS_PHY_RX_SYMBOL_1_CLK = 18,
	P_UFS_PHY_TX_SYMBOL_0_CLK = 19,
	P_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK = 20,
	P_USB3_PHY_WRAPPER_GCC_USB30_SEC_PIPE_CLK = 21,
};

enum {
	P_BI_TCXO___4 = 0,
	P_GPLL0_OUT_AUX2 = 1,
	P_GPLL0_OUT_EARLY = 2,
	P_GPLL10_OUT_MAIN = 3,
	P_GPLL11_OUT_AUX = 4,
	P_GPLL11_OUT_AUX2 = 5,
	P_GPLL11_OUT_MAIN = 6,
	P_GPLL3_OUT_EARLY = 7,
	P_GPLL3_OUT_MAIN = 8,
	P_GPLL4_OUT_MAIN___3 = 9,
	P_GPLL5_OUT_MAIN___2 = 10,
	P_GPLL6_OUT_EARLY = 11,
	P_GPLL6_OUT_MAIN___2 = 12,
	P_GPLL7_OUT_MAIN = 13,
	P_GPLL8_OUT_EARLY = 14,
	P_GPLL8_OUT_MAIN___2 = 15,
	P_GPLL9_OUT_EARLY = 16,
	P_GPLL9_OUT_MAIN = 17,
	P_SLEEP_CLK___5 = 18,
};

enum {
	P_DSI0_PHY_PLL_OUT_BYTECLK = 0,
	P_DSI0_PHY_PLL_OUT_DSICLK = 1,
	P_GPLL0_OUT_MAIN___3 = 2,
	P_GPLL1_OUT_MAIN = 3,
	P_GPLL3_OUT_MAIN___2 = 4,
	P_GPLL4_OUT_MAIN___4 = 5,
	P_GPLL6_OUT_AUX = 6,
	P_HDMI_PHY_PLL_CLK = 7,
	P_PCIE_0_PIPE_CLK___3 = 8,
	P_SLEEP_CLK___6 = 9,
	P_XO___2 = 10,
};

enum {
	P_XO___3 = 0,
	P_GPLL0 = 1,
	P_GPLL4 = 2,
};

enum {
	P_XO___4 = 0,
	P_PCIE30_PHY0_PIPE = 1,
	P_PCIE30_PHY1_PIPE = 2,
	P_PCIE30_PHY2_PIPE = 3,
	P_PCIE30_PHY3_PIPE = 4,
	P_USB3PHY_0_PIPE = 5,
	P_GPLL0___2 = 6,
	P_GPLL0_DIV2 = 7,
	P_GPLL0_OUT_AUX = 8,
	P_GPLL2 = 9,
	P_GPLL4___2 = 10,
	P_PI_SLEEP = 11,
	P_BIAS_PLL_UBI_NC_CLK = 12,
};

enum {
	P_XO___5 = 0,
	P_GPLL0___3 = 1,
	P_APSS_PLL_EARLY = 2,
};

enum {
	P_XO___6 = 0,
	P_GPLL0___4 = 1,
	P_GPLL0_DIV2___2 = 2,
	P_GPLL2___2 = 3,
	P_GPLL4___3 = 4,
	P_GPLL6 = 5,
	P_SLEEP_CLK___7 = 6,
	P_PCIE20_PHY0_PIPE = 7,
	P_PCIE20_PHY1_PIPE = 8,
	P_USB3PHY_0_PIPE___2 = 9,
	P_USB3PHY_1_PIPE = 10,
	P_UBI32_PLL = 11,
	P_NSS_CRYPTO_PLL = 12,
	P_BIAS_PLL = 13,
	P_BIAS_PLL_NSS_NOC = 14,
	P_UNIPHY0_RX = 15,
	P_UNIPHY0_TX = 16,
	P_UNIPHY1_RX = 17,
	P_UNIPHY1_TX = 18,
	P_UNIPHY2_RX = 19,
	P_UNIPHY2_TX = 20,
};

enum {
	P_XO___7 = 0,
	P_GPLL0___5 = 1,
	P_GPLL0_AUX = 2,
	P_BIMC = 3,
	P_GPLL1 = 4,
	P_GPLL1_AUX = 5,
	P_GPLL2___3 = 6,
	P_GPLL2_AUX = 7,
	P_SLEEP_CLK___8 = 8,
	P_DSI0_PHYPLL_BYTE = 9,
	P_DSI0_PHYPLL_DSI = 10,
	P_EXT_PRI_I2S = 11,
	P_EXT_SEC_I2S = 12,
	P_EXT_MCLK = 13,
};

enum {
	P_XO___8 = 0,
	P_GPLL0___6 = 1,
	P_GPLL0_EARLY_DIV = 2,
	P_SLEEP_CLK___9 = 3,
	P_GPLL4___4 = 4,
	P_AUD_REF_CLK___2 = 5,
};

enum {
	P_XO___9 = 0,
	P_BIAS_PLL___2 = 1,
	P_UNIPHY0_RX___2 = 2,
	P_UNIPHY0_TX___2 = 3,
	P_UNIPHY1_RX___2 = 4,
	P_BIAS_PLL_NSS_NOC___2 = 5,
	P_UNIPHY1_TX___2 = 6,
	P_PCIE20_PHY0_PIPE___2 = 7,
	P_USB3PHY_0_PIPE___3 = 8,
	P_GPLL0___7 = 9,
	P_GPLL0_DIV2___3 = 10,
	P_GPLL2___4 = 11,
	P_GPLL4___5 = 12,
	P_GPLL6___2 = 13,
	P_SLEEP_CLK___10 = 14,
	P_UBI32_PLL___2 = 15,
	P_NSS_CRYPTO_PLL___2 = 16,
	P_PI_SLEEP___2 = 17,
};

enum {
	P_XO___10 = 0,
	P_CORE_PI_SLEEP_CLK = 1,
	P_PCIE20_PHY0_PIPE___3 = 2,
	P_PCIE20_PHY1_PIPE___2 = 3,
	P_USB3PHY_0_PIPE___4 = 4,
	P_GEPHY_RX = 5,
	P_GEPHY_TX = 6,
	P_UNIPHY_RX = 7,
	P_UNIPHY_TX = 8,
	P_GPLL0___8 = 9,
	P_GPLL0_DIV2___4 = 10,
	P_GPLL2___5 = 11,
	P_GPLL4___6 = 12,
	P_UBI32_PLL___3 = 13,
};

enum {
	QCM2290_MASTER_APPSS_PROC = 1,
	QCM2290_MASTER_SNOC_BIMC_RT = 2,
	QCM2290_MASTER_SNOC_BIMC_NRT = 3,
	QCM2290_MASTER_SNOC_BIMC = 4,
	QCM2290_MASTER_TCU_0 = 5,
	QCM2290_MASTER_GFX3D = 6,
	QCM2290_MASTER_SNOC_CNOC = 7,
	QCM2290_MASTER_QDSS_DAP = 8,
	QCM2290_MASTER_CRYPTO_CORE0 = 9,
	QCM2290_MASTER_SNOC_CFG = 10,
	QCM2290_MASTER_TIC = 11,
	QCM2290_MASTER_ANOC_SNOC = 12,
	QCM2290_MASTER_BIMC_SNOC = 13,
	QCM2290_MASTER_PIMEM = 14,
	QCM2290_MASTER_QDSS_BAM = 15,
	QCM2290_MASTER_QUP_0 = 16,
	QCM2290_MASTER_IPA = 17,
	QCM2290_MASTER_QDSS_ETR = 18,
	QCM2290_MASTER_SDCC_1 = 19,
	QCM2290_MASTER_SDCC_2 = 20,
	QCM2290_MASTER_QPIC = 21,
	QCM2290_MASTER_USB3_0 = 22,
	QCM2290_MASTER_QUP_CORE_0 = 23,
	QCM2290_MASTER_CAMNOC_SF = 24,
	QCM2290_MASTER_VIDEO_P0 = 25,
	QCM2290_MASTER_VIDEO_PROC = 26,
	QCM2290_MASTER_CAMNOC_HF = 27,
	QCM2290_MASTER_MDP0 = 28,
	QCM2290_SLAVE_EBI1 = 29,
	QCM2290_SLAVE_BIMC_SNOC = 30,
	QCM2290_SLAVE_BIMC_CFG = 31,
	QCM2290_SLAVE_CAMERA_NRT_THROTTLE_CFG = 32,
	QCM2290_SLAVE_CAMERA_RT_THROTTLE_CFG = 33,
	QCM2290_SLAVE_CAMERA_CFG = 34,
	QCM2290_SLAVE_CLK_CTL = 35,
	QCM2290_SLAVE_CRYPTO_0_CFG = 36,
	QCM2290_SLAVE_DISPLAY_CFG = 37,
	QCM2290_SLAVE_DISPLAY_THROTTLE_CFG = 38,
	QCM2290_SLAVE_GPU_CFG = 39,
	QCM2290_SLAVE_HWKM = 40,
	QCM2290_SLAVE_IMEM_CFG = 41,
	QCM2290_SLAVE_IPA_CFG = 42,
	QCM2290_SLAVE_LPASS = 43,
	QCM2290_SLAVE_MESSAGE_RAM = 44,
	QCM2290_SLAVE_PDM = 45,
	QCM2290_SLAVE_PIMEM_CFG = 46,
	QCM2290_SLAVE_PKA_WRAPPER = 47,
	QCM2290_SLAVE_PMIC_ARB = 48,
	QCM2290_SLAVE_PRNG = 49,
	QCM2290_SLAVE_QDSS_CFG = 50,
	QCM2290_SLAVE_QM_CFG = 51,
	QCM2290_SLAVE_QM_MPU_CFG = 52,
	QCM2290_SLAVE_QPIC = 53,
	QCM2290_SLAVE_QUP_0 = 54,
	QCM2290_SLAVE_SDCC_1 = 55,
	QCM2290_SLAVE_SDCC_2 = 56,
	QCM2290_SLAVE_SNOC_CFG = 57,
	QCM2290_SLAVE_TCSR = 58,
	QCM2290_SLAVE_USB3 = 59,
	QCM2290_SLAVE_VENUS_CFG = 60,
	QCM2290_SLAVE_VENUS_THROTTLE_CFG = 61,
	QCM2290_SLAVE_VSENSE_CTRL_CFG = 62,
	QCM2290_SLAVE_SERVICE_CNOC = 63,
	QCM2290_SLAVE_APPSS = 64,
	QCM2290_SLAVE_SNOC_CNOC = 65,
	QCM2290_SLAVE_IMEM = 66,
	QCM2290_SLAVE_PIMEM = 67,
	QCM2290_SLAVE_SNOC_BIMC = 68,
	QCM2290_SLAVE_SERVICE_SNOC = 69,
	QCM2290_SLAVE_QDSS_STM = 70,
	QCM2290_SLAVE_TCU = 71,
	QCM2290_SLAVE_ANOC_SNOC = 72,
	QCM2290_SLAVE_QUP_CORE_0 = 73,
	QCM2290_SLAVE_SNOC_BIMC_NRT = 74,
	QCM2290_SLAVE_SNOC_BIMC_RT = 75,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QUERY_REQ_TIMEOUT_MIN = 1,
	QUERY_REQ_TIMEOUT_DEFAULT = 1500,
	QUERY_REQ_TIMEOUT_MAX = 30000,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_MAX = 15,
};

enum {
	Q_R1 = 0,
	Q_R2 = 128,
	Q_XS1 = 512,
	Q_XA1 = 640,
	Q_XS2 = 768,
	Q_XA2 = 896,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_ENA_STFWD = 32,
	RB_DIS_STFWD = 16,
	RB_ENA_OP_MD = 8,
	RB_DIS_OP_MD = 4,
	RB_RST_CLR = 2,
	RB_RST_SET = 1,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RB_START = 0,
	RB_END = 4,
	RB_WP = 8,
	RB_RP = 12,
	RB_RX_UTPP = 16,
	RB_RX_LTPP = 20,
	RB_RX_UTHP = 24,
	RB_RX_LTHP = 28,
	RB_PC = 32,
	RB_LEV = 36,
	RB_CTRL = 40,
	RB_TST1 = 41,
	RB_TST2 = 42,
};

enum {
	RCAR_PCI_ACCESS_READ = 0,
	RCAR_PCI_ACCESS_WRITE = 1,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CONTROLLER_CAPABILITIES = 0,
	REG_MCQCAP = 4,
	REG_UFS_VERSION = 8,
	REG_EXT_CONTROLLER_CAPABILITIES = 12,
	REG_CONTROLLER_PID = 16,
	REG_CONTROLLER_MID = 20,
	REG_AUTO_HIBERNATE_IDLE_TIMER = 24,
	REG_INTERRUPT_STATUS = 32,
	REG_INTERRUPT_ENABLE = 36,
	REG_CONTROLLER_STATUS = 48,
	REG_CONTROLLER_ENABLE = 52,
	REG_UIC_ERROR_CODE_PHY_ADAPTER_LAYER = 56,
	REG_UIC_ERROR_CODE_DATA_LINK_LAYER = 60,
	REG_UIC_ERROR_CODE_NETWORK_LAYER = 64,
	REG_UIC_ERROR_CODE_TRANSPORT_LAYER = 68,
	REG_UIC_ERROR_CODE_DME = 72,
	REG_UTP_TRANSFER_REQ_INT_AGG_CONTROL = 76,
	REG_UTP_TRANSFER_REQ_LIST_BASE_L = 80,
	REG_UTP_TRANSFER_REQ_LIST_BASE_H = 84,
	REG_UTP_TRANSFER_REQ_DOOR_BELL = 88,
	REG_UTP_TRANSFER_REQ_LIST_CLEAR = 92,
	REG_UTP_TRANSFER_REQ_LIST_RUN_STOP = 96,
	REG_UTP_TASK_REQ_LIST_BASE_L = 112,
	REG_UTP_TASK_REQ_LIST_BASE_H = 116,
	REG_UTP_TASK_REQ_DOOR_BELL = 120,
	REG_UTP_TASK_REQ_LIST_CLEAR = 124,
	REG_UTP_TASK_REQ_LIST_RUN_STOP = 128,
	REG_UIC_COMMAND = 144,
	REG_UIC_COMMAND_ARG_1 = 148,
	REG_UIC_COMMAND_ARG_2 = 152,
	REG_UIC_COMMAND_ARG_3 = 156,
	UFSHCI_REG_SPACE_SIZE = 160,
	REG_UFS_CCAP = 256,
	REG_UFS_CRYPTOCAP = 260,
	REG_UFS_MEM_CFG = 768,
	REG_UFS_MCQ_CFG = 896,
	REG_UFS_ESILBA = 900,
	REG_UFS_ESIUBA = 904,
	UFSHCI_CRYPTO_REG_SPACE_SIZE = 1024,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_CQHP = 0,
	REG_CQTP = 4,
};

enum {
	REG_CQIS = 0,
	REG_CQIE = 4,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REG_SQATTR = 0,
	REG_SQLBA = 4,
	REG_SQUBA = 8,
	REG_SQDAO = 12,
	REG_SQISAO = 16,
	REG_CQATTR = 32,
	REG_CQLBA = 36,
	REG_CQUBA = 40,
	REG_CQDAO = 44,
	REG_CQISAO = 48,
};

enum {
	REG_SQHP = 0,
	REG_SQTP = 4,
	REG_SQRTC = 8,
	REG_SQCTI = 12,
	REG_SQRTS = 16,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	__REQ_F_LAST_BIT = 39,
};

enum {
	RI_CLR_RD_PERR = 512,
	RI_CLR_WR_PERR = 256,
	RI_RST_CLR = 2,
	RI_RST_SET = 1,
};

enum {
	RK805_BUCK1_2_ILMAX_2500MA = 0,
	RK805_BUCK1_2_ILMAX_3000MA = 1,
	RK805_BUCK1_2_ILMAX_3500MA = 2,
	RK805_BUCK1_2_ILMAX_4000MA = 3,
};

enum {
	RK805_BUCK3_ILMAX_1500MA = 0,
	RK805_BUCK3_ILMAX_2000MA = 1,
	RK805_BUCK3_ILMAX_2500MA = 2,
	RK805_BUCK3_ILMAX_3000MA = 3,
};

enum {
	RK805_BUCK4_ILMAX_2000MA = 0,
	RK805_BUCK4_ILMAX_2500MA = 1,
	RK805_BUCK4_ILMAX_3000MA = 2,
	RK805_BUCK4_ILMAX_3500MA = 3,
};

enum {
	RK805_ID = 32848,
	RK806_ID = 32864,
	RK808_ID = 0,
	RK809_ID = 32912,
	RK816_ID = 33120,
	RK817_ID = 33136,
	RK818_ID = 33152,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RNG_OUTPUT_0_REG = 0,
	RNG_OUTPUT_1_REG = 1,
	RNG_OUTPUT_2_REG = 2,
	RNG_OUTPUT_3_REG = 3,
	RNG_STATUS_REG = 4,
	RNG_INTMASK_REG = 5,
	RNG_INTACK_REG = 6,
	RNG_CONTROL_REG = 7,
	RNG_CONFIG_REG = 8,
	RNG_ALARMCNT_REG = 9,
	RNG_FROENABLE_REG = 10,
	RNG_FRODETUNE_REG = 11,
	RNG_ALARMMASK_REG = 12,
	RNG_ALARMSTOP_REG = 13,
	RNG_REV_REG = 14,
	RNG_SYSCONFIG_REG = 15,
};

enum {
	ROCKCHIP_ARM_OFF_LOGIC_NORMAL = 0,
	ROCKCHIP_ARM_OFF_LOGIC_DEEP = 1,
};

enum {
	RPCAUTH_info = 0,
	RPCAUTH_EOF = 1,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_gssd = 8,
	RPCAUTH_RootEOF = 9,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPCSVC_MAXPAYLOAD = 4194304,
	RPCSVC_MAXPAYLOAD_TCP = 4194304,
	RPCSVC_MAXPAYLOAD_UDP = 32768,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RSC_DRV_TCS_OFFSET = 0,
	RSC_DRV_CMD_OFFSET = 1,
	DRV_SOLVER_CONFIG = 2,
	DRV_PRNT_CHLD_CONFIG = 3,
	RSC_DRV_IRQ_ENABLE = 4,
	RSC_DRV_IRQ_STATUS = 5,
	RSC_DRV_IRQ_CLEAR = 6,
	RSC_DRV_CMD_WAIT_FOR_CMPL = 7,
	RSC_DRV_CONTROL = 8,
	RSC_DRV_STATUS = 9,
	RSC_DRV_CMD_ENABLE = 10,
	RSC_DRV_CMD_MSGID = 11,
	RSC_DRV_CMD_ADDR = 12,
	RSC_DRV_CMD_DATA = 13,
	RSC_DRV_CMD_STATUS = 14,
	RSC_DRV_CMD_RESP_DATA = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTC_SEC = 0,
	RTC_MIN = 1,
	RTC_HOUR = 2,
	RTC_WEEKDAY = 3,
	RTC_MONTH = 4,
	RTC_YEAR = 5,
	RTC_MONTHDAY = 6,
	RTC_NR_TIME = 7,
};

enum {
	RTC_SEC___2 = 0,
	RTC_MIN___2 = 1,
	RTC_HOUR___2 = 2,
	RTC_WEEKDAY___2 = 3,
	RTC_DATE = 4,
	RTC_MONTH___2 = 5,
	RTC_YEAR1 = 6,
	RTC_YEAR2 = 7,
	RTC_MAX_NUM_TIME_REGS = 8,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RX_GCLKMAC_ENA = -2147483648,
	RX_GCLKMAC_OFF = 1073741824,
	RX_STFW_DIS = 536870912,
	RX_STFW_ENA = 268435456,
	RX_TRUNC_ON = 134217728,
	RX_TRUNC_OFF = 67108864,
	RX_VLAN_STRIP_ON = 33554432,
	RX_VLAN_STRIP_OFF = 16777216,
	RX_MACSEC_FLUSH_ON = 8388608,
	RX_MACSEC_FLUSH_OFF = 4194304,
	RX_MACSEC_ASF_FLUSH_ON = 2097152,
	RX_MACSEC_ASF_FLUSH_OFF = 1048576,
	GMF_RX_OVER_ON = 524288,
	GMF_RX_OVER_OFF = 262144,
	GMF_ASF_RX_OVER_ON = 131072,
	GMF_ASF_RX_OVER_OFF = 65536,
	GMF_WP_TST_ON = 16384,
	GMF_WP_TST_OFF = 8192,
	GMF_WP_STEP = 4096,
	GMF_RP_TST_ON = 1024,
	GMF_RP_TST_OFF = 512,
	GMF_RP_STEP = 256,
	GMF_RX_F_FL_ON = 128,
	GMF_RX_F_FL_OFF = 64,
	GMF_CLI_RX_FO = 32,
	GMF_CLI_RX_C = 16,
	GMF_OPER_ON = 8,
	GMF_OPER_OFF = 4,
	GMF_RST_CLR = 2,
	GMF_RST_SET = 1,
	RX_GMF_FL_THR_DEF = 10,
	GMF_RX_CTRL_DEF = 136,
};

enum {
	RX_IPV6_SA_MOB_ENA = 512,
	RX_IPV6_SA_MOB_DIS = 256,
	RX_IPV6_DA_MOB_ENA = 128,
	RX_IPV6_DA_MOB_DIS = 64,
	RX_PTR_SYNCDLY_ENA = 32,
	RX_PTR_SYNCDLY_DIS = 16,
	RX_ASF_NEWFLAG_ENA = 8,
	RX_ASF_NEWFLAG_DIS = 4,
	RX_FLSH_MISSPKT_ENA = 2,
	RX_FLSH_MISSPKT_DIS = 1,
};

enum {
	RX_XDP_REDIRECT = 0,
	RX_XDP_PASS = 1,
	RX_XDP_DROP = 2,
	RX_XDP_TX = 3,
	RX_XDP_TX_ERRORS = 4,
	TX_XDP_XMIT = 5,
	TX_XDP_XMIT_ERRORS = 6,
	XDP_STATS_TOTAL = 7,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	Rworksched = 1,
	Rpending = 2,
	Wworksched = 4,
	Wpending = 8,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCIx_ERI_IRQ = 0,
	SCIx_RXI_IRQ = 1,
	SCIx_TXI_IRQ = 2,
	SCIx_BRI_IRQ = 3,
	SCIx_DRI_IRQ = 4,
	SCIx_TEI_IRQ = 5,
	SCIx_NR_IRQS = 6,
	SCIx_MUX_IRQ = 6,
};

enum {
	SCIx_PROBE_REGTYPE = 0,
	SCIx_SCI_REGTYPE = 1,
	SCIx_IRDA_REGTYPE = 2,
	SCIx_SCIFA_REGTYPE = 3,
	SCIx_SCIFB_REGTYPE = 4,
	SCIx_SH2_SCIF_FIFODATA_REGTYPE = 5,
	SCIx_SH3_SCIF_REGTYPE = 6,
	SCIx_SH4_SCIF_REGTYPE = 7,
	SCIx_SH4_SCIF_BRG_REGTYPE = 8,
	SCIx_SH4_SCIF_NO_SCSPTR_REGTYPE = 9,
	SCIx_SH4_SCIF_FIFODATA_REGTYPE = 10,
	SCIx_SH7705_SCIF_REGTYPE = 11,
	SCIx_HSCIF_REGTYPE = 12,
	SCIx_RZ_SCIFA_REGTYPE = 13,
	SCIx_RZV2H_SCIF_REGTYPE = 14,
	SCIx_NR_REGTYPES = 15,
};

enum {
	SCMI_RAW_REPLY_QUEUE = 0,
	SCMI_RAW_NOTIF_QUEUE = 1,
	SCMI_RAW_ERRS_QUEUE = 2,
	SCMI_RAW_MAX_QUEUE = 3,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SCSMR = 0,
	SCBRR = 1,
	SCSCR = 2,
	SCxSR = 3,
	SCFCR = 4,
	SCFDR = 5,
	SCxTDR = 6,
	SCxRDR = 7,
	SCLSR = 8,
	SCTFDR = 9,
	SCRFDR = 10,
	SCSPTR = 11,
	HSSRR = 12,
	SCPCR = 13,
	SCPDR = 14,
	SCDL = 15,
	SCCKS = 16,
	HSRTRGR = 17,
	HSTTRGR = 18,
	SEMR = 19,
};

enum {
	SC_STAT_CLR_IRQ = 16,
	SC_STAT_OP_ON = 8,
	SC_STAT_OP_OFF = 4,
	SC_STAT_RST_CLR = 2,
	SC_STAT_RST_SET = 1,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SH_ETH_REG_GIGABIT = 0,
	SH_ETH_REG_FAST_RCAR = 1,
	SH_ETH_REG_FAST_SH4 = 2,
	SH_ETH_REG_FAST_SH3_SH2 = 3,
};

enum {
	SIL24_HOST_BAR = 0,
	SIL24_PORT_BAR = 2,
	SIL24_PRB_SZ = 64,
	SIL24_MAX_SGT = 63,
	SIL24_MAX_SGE = 253,
	HOST_SLOT_STAT = 0,
	HOST_CTRL = 64,
	HOST_IRQ_STAT___2 = 68,
	HOST_PHY_CFG = 72,
	HOST_BIST_CTRL = 80,
	HOST_BIST_PTRN = 84,
	HOST_BIST_STAT = 88,
	HOST_MEM_BIST_STAT = 92,
	HOST_FLASH_CMD = 112,
	HOST_FLASH_DATA = 116,
	HOST_TRANSITION_DETECT = 117,
	HOST_GPIO_CTRL = 118,
	HOST_I2C_ADDR = 120,
	HOST_I2C_DATA = 124,
	HOST_I2C_XFER_CNT = 126,
	HOST_I2C_CTRL = 127,
	HOST_SSTAT_ATTN = -2147483648,
	HOST_CTRL_M66EN = 65536,
	HOST_CTRL_TRDY = 131072,
	HOST_CTRL_STOP = 262144,
	HOST_CTRL_DEVSEL = 524288,
	HOST_CTRL_REQ64 = 1048576,
	HOST_CTRL_GLOBAL_RST = -2147483648,
	PORT_REGS_SIZE = 8192,
	PORT_LRAM = 0,
	PORT_LRAM_SLOT_SZ = 128,
	PORT_PMP = 3968,
	PORT_PMP_STATUS = 0,
	PORT_PMP_QACTIVE = 4,
	PORT_PMP_SIZE = 8,
	PORT_CTRL_STAT = 4096,
	PORT_CTRL_CLR = 4100,
	PORT_IRQ_STAT___2 = 4104,
	PORT_IRQ_ENABLE_SET = 4112,
	PORT_IRQ_ENABLE_CLR = 4116,
	PORT_ACTIVATE_UPPER_ADDR = 4124,
	PORT_EXEC_FIFO = 4128,
	PORT_CMD_ERR = 4132,
	PORT_FIS_CFG = 4136,
	PORT_FIFO_THRES = 4140,
	PORT_DECODE_ERR_CNT = 4160,
	PORT_DECODE_ERR_THRESH = 4162,
	PORT_CRC_ERR_CNT = 4164,
	PORT_CRC_ERR_THRESH = 4166,
	PORT_HSHK_ERR_CNT = 4168,
	PORT_HSHK_ERR_THRESH = 4170,
	PORT_PHY_CFG = 4176,
	PORT_SLOT_STAT = 6144,
	PORT_CMD_ACTIVATE = 7168,
	PORT_CONTEXT = 7684,
	PORT_EXEC_DIAG = 7680,
	PORT_PSD_DIAG = 7744,
	PORT_SCONTROL = 7936,
	PORT_SSTATUS = 7940,
	PORT_SERROR = 7944,
	PORT_SACTIVE = 7948,
	PORT_CS_PORT_RST = 1,
	PORT_CS_DEV_RST = 2,
	PORT_CS_INIT = 4,
	PORT_CS_IRQ_WOC = 8,
	PORT_CS_CDB16 = 32,
	PORT_CS_PMP_RESUME = 64,
	PORT_CS_32BIT_ACTV = 1024,
	PORT_CS_PMP_EN = 8192,
	PORT_CS_RDY = -2147483648,
	PORT_IRQ_COMPLETE = 1,
	PORT_IRQ_ERROR___2 = 2,
	PORT_IRQ_PORTRDY_CHG = 4,
	PORT_IRQ_PWR_CHG = 8,
	PORT_IRQ_PHYRDY_CHG = 16,
	PORT_IRQ_COMWAKE = 32,
	PORT_IRQ_UNK_FIS___2 = 64,
	PORT_IRQ_DEV_XCHG = 128,
	PORT_IRQ_8B10B = 256,
	PORT_IRQ_CRC = 512,
	PORT_IRQ_HANDSHAKE = 1024,
	PORT_IRQ_SDB_NOTIFY = 2048,
	DEF_PORT_IRQ___2 = 2259,
	PORT_IRQ_RAW_SHIFT = 16,
	PORT_IRQ_MASKED_MASK = 2047,
	PORT_IRQ_RAW_MASK = 134152192,
	PORT_IRQ_STEER_SHIFT = 30,
	PORT_IRQ_STEER_MASK = -1073741824,
	PORT_CERR_DEV = 1,
	PORT_CERR_SDB = 2,
	PORT_CERR_DATA = 3,
	PORT_CERR_SEND = 4,
	PORT_CERR_INCONSISTENT = 5,
	PORT_CERR_DIRECTION = 6,
	PORT_CERR_UNDERRUN = 7,
	PORT_CERR_OVERRUN = 8,
	PORT_CERR_PKT_PROT = 11,
	PORT_CERR_SGT_BOUNDARY = 16,
	PORT_CERR_SGT_TGTABRT = 17,
	PORT_CERR_SGT_MSTABRT = 18,
	PORT_CERR_SGT_PCIPERR = 19,
	PORT_CERR_CMD_BOUNDARY = 24,
	PORT_CERR_CMD_TGTABRT = 25,
	PORT_CERR_CMD_MSTABRT = 26,
	PORT_CERR_CMD_PCIPERR = 27,
	PORT_CERR_XFR_UNDEF = 32,
	PORT_CERR_XFR_TGTABRT = 33,
	PORT_CERR_XFR_MSTABRT = 34,
	PORT_CERR_XFR_PCIPERR = 35,
	PORT_CERR_SENDSERVICE = 36,
	PRB_CTRL_PROTOCOL = 1,
	PRB_CTRL_PACKET_READ = 16,
	PRB_CTRL_PACKET_WRITE = 32,
	PRB_CTRL_NIEN = 64,
	PRB_CTRL_SRST = 128,
	PRB_PROT_PACKET = 1,
	PRB_PROT_TCQ = 2,
	PRB_PROT_NCQ = 4,
	PRB_PROT_READ = 8,
	PRB_PROT_WRITE = 16,
	PRB_PROT_TRANSPARENT = 32,
	SGE_TRM = -2147483648,
	SGE_LNK = 1073741824,
	SGE_DRD = 536870912,
	SIL24_MAX_CMDS = 31,
	BID_SIL3124 = 0,
	BID_SIL3132 = 1,
	BID_SIL3131 = 2,
	SIL24_COMMON_FLAGS = 918658,
	SIL24_FLAG_PCIX_IRQ_WOC = 16777216,
	IRQ_STAT_4PORTS = 15,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SM6115_MASTER_AMPSS_M0 = 0,
	SM6115_MASTER_ANOC_SNOC = 1,
	SM6115_MASTER_BIMC_SNOC = 2,
	SM6115_MASTER_CAMNOC_HF = 3,
	SM6115_MASTER_CAMNOC_SF = 4,
	SM6115_MASTER_CRYPTO_CORE0 = 5,
	SM6115_MASTER_GRAPHICS_3D = 6,
	SM6115_MASTER_IPA = 7,
	SM6115_MASTER_MDP_PORT0 = 8,
	SM6115_MASTER_PIMEM = 9,
	SM6115_MASTER_QDSS_BAM = 10,
	SM6115_MASTER_QDSS_DAP = 11,
	SM6115_MASTER_QDSS_ETR = 12,
	SM6115_MASTER_QPIC = 13,
	SM6115_MASTER_QUP_0 = 14,
	SM6115_MASTER_QUP_CORE_0 = 15,
	SM6115_MASTER_SDCC_1 = 16,
	SM6115_MASTER_SDCC_2 = 17,
	SM6115_MASTER_SNOC_BIMC_NRT = 18,
	SM6115_MASTER_SNOC_BIMC_RT = 19,
	SM6115_MASTER_SNOC_BIMC = 20,
	SM6115_MASTER_SNOC_CFG = 21,
	SM6115_MASTER_SNOC_CNOC = 22,
	SM6115_MASTER_TCU_0 = 23,
	SM6115_MASTER_TIC = 24,
	SM6115_MASTER_USB3 = 25,
	SM6115_MASTER_VIDEO_P0 = 26,
	SM6115_MASTER_VIDEO_PROC = 27,
	SM6115_SLAVE_AHB2PHY_USB = 28,
	SM6115_SLAVE_ANOC_SNOC = 29,
	SM6115_SLAVE_APPSS = 30,
	SM6115_SLAVE_APSS_THROTTLE_CFG = 31,
	SM6115_SLAVE_BIMC_CFG = 32,
	SM6115_SLAVE_BIMC_SNOC = 33,
	SM6115_SLAVE_BOOT_ROM = 34,
	SM6115_SLAVE_CAMERA_CFG = 35,
	SM6115_SLAVE_CAMERA_NRT_THROTTLE_CFG = 36,
	SM6115_SLAVE_CAMERA_RT_THROTTLE_CFG = 37,
	SM6115_SLAVE_CLK_CTL = 38,
	SM6115_SLAVE_CNOC_MSS = 39,
	SM6115_SLAVE_CRYPTO_0_CFG = 40,
	SM6115_SLAVE_DCC_CFG = 41,
	SM6115_SLAVE_DDR_PHY_CFG = 42,
	SM6115_SLAVE_DDR_SS_CFG = 43,
	SM6115_SLAVE_DISPLAY_CFG = 44,
	SM6115_SLAVE_DISPLAY_THROTTLE_CFG = 45,
	SM6115_SLAVE_EBI_CH0 = 46,
	SM6115_SLAVE_GPU_CFG = 47,
	SM6115_SLAVE_GPU_THROTTLE_CFG = 48,
	SM6115_SLAVE_HWKM_CORE = 49,
	SM6115_SLAVE_IMEM_CFG = 50,
	SM6115_SLAVE_IPA_CFG = 51,
	SM6115_SLAVE_LPASS = 52,
	SM6115_SLAVE_MAPSS = 53,
	SM6115_SLAVE_MDSP_MPU_CFG = 54,
	SM6115_SLAVE_MESSAGE_RAM = 55,
	SM6115_SLAVE_OCIMEM = 56,
	SM6115_SLAVE_PDM = 57,
	SM6115_SLAVE_PIMEM_CFG = 58,
	SM6115_SLAVE_PIMEM = 59,
	SM6115_SLAVE_PKA_CORE = 60,
	SM6115_SLAVE_PMIC_ARB = 61,
	SM6115_SLAVE_QDSS_CFG = 62,
	SM6115_SLAVE_QDSS_STM = 63,
	SM6115_SLAVE_QM_CFG = 64,
	SM6115_SLAVE_QM_MPU_CFG = 65,
	SM6115_SLAVE_QPIC = 66,
	SM6115_SLAVE_QUP_0 = 67,
	SM6115_SLAVE_QUP_CORE_0 = 68,
	SM6115_SLAVE_RBCPR_CX_CFG = 69,
	SM6115_SLAVE_RBCPR_MX_CFG = 70,
	SM6115_SLAVE_RPM = 71,
	SM6115_SLAVE_SDCC_1 = 72,
	SM6115_SLAVE_SDCC_2 = 73,
	SM6115_SLAVE_SECURITY = 74,
	SM6115_SLAVE_SERVICE_CNOC = 75,
	SM6115_SLAVE_SERVICE_SNOC = 76,
	SM6115_SLAVE_SNOC_BIMC_NRT = 77,
	SM6115_SLAVE_SNOC_BIMC_RT = 78,
	SM6115_SLAVE_SNOC_BIMC = 79,
	SM6115_SLAVE_SNOC_CFG = 80,
	SM6115_SLAVE_SNOC_CNOC = 81,
	SM6115_SLAVE_TCSR = 82,
	SM6115_SLAVE_TCU = 83,
	SM6115_SLAVE_TLMM = 84,
	SM6115_SLAVE_USB3 = 85,
	SM6115_SLAVE_VENUS_CFG = 86,
	SM6115_SLAVE_VENUS_THROTTLE_CFG = 87,
	SM6115_SLAVE_VSENSE_CTRL_CFG = 88,
};

enum {
	SNDRV_CHMAP_UNKNOWN = 0,
	SNDRV_CHMAP_NA = 1,
	SNDRV_CHMAP_MONO = 2,
	SNDRV_CHMAP_FL = 3,
	SNDRV_CHMAP_FR = 4,
	SNDRV_CHMAP_RL = 5,
	SNDRV_CHMAP_RR = 6,
	SNDRV_CHMAP_FC = 7,
	SNDRV_CHMAP_LFE = 8,
	SNDRV_CHMAP_SL = 9,
	SNDRV_CHMAP_SR = 10,
	SNDRV_CHMAP_RC = 11,
	SNDRV_CHMAP_FLC = 12,
	SNDRV_CHMAP_FRC = 13,
	SNDRV_CHMAP_RLC = 14,
	SNDRV_CHMAP_RRC = 15,
	SNDRV_CHMAP_FLW = 16,
	SNDRV_CHMAP_FRW = 17,
	SNDRV_CHMAP_FLH = 18,
	SNDRV_CHMAP_FCH = 19,
	SNDRV_CHMAP_FRH = 20,
	SNDRV_CHMAP_TC = 21,
	SNDRV_CHMAP_TFL = 22,
	SNDRV_CHMAP_TFR = 23,
	SNDRV_CHMAP_TFC = 24,
	SNDRV_CHMAP_TRL = 25,
	SNDRV_CHMAP_TRR = 26,
	SNDRV_CHMAP_TRC = 27,
	SNDRV_CHMAP_TFLC = 28,
	SNDRV_CHMAP_TFRC = 29,
	SNDRV_CHMAP_TSL = 30,
	SNDRV_CHMAP_TSR = 31,
	SNDRV_CHMAP_LLFE = 32,
	SNDRV_CHMAP_RLFE = 33,
	SNDRV_CHMAP_BC = 34,
	SNDRV_CHMAP_BLC = 35,
	SNDRV_CHMAP_BRC = 36,
	SNDRV_CHMAP_LAST = 36,
};

enum {
	SNDRV_CTL_TLV_OP_READ = 0,
	SNDRV_CTL_TLV_OP_WRITE = 1,
	SNDRV_CTL_TLV_OP_CMD = -1,
};

enum {
	SNDRV_DEVICE_TYPE_CONTROL = 0,
	SNDRV_DEVICE_TYPE_SEQUENCER = 1,
	SNDRV_DEVICE_TYPE_TIMER = 2,
	SNDRV_DEVICE_TYPE_HWDEP = 3,
	SNDRV_DEVICE_TYPE_RAWMIDI = 4,
	SNDRV_DEVICE_TYPE_PCM_PLAYBACK = 5,
	SNDRV_DEVICE_TYPE_PCM_CAPTURE = 6,
	SNDRV_DEVICE_TYPE_COMPRESS = 7,
};

enum {
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT = 0,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT = 1,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK = 2,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE = 3,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED = 4,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED = 5,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST = 5,
};

enum {
	SNDRV_PCM_CLASS_GENERIC = 0,
	SNDRV_PCM_CLASS_MULTI = 1,
	SNDRV_PCM_CLASS_MODEM = 2,
	SNDRV_PCM_CLASS_DIGITIZER = 3,
	SNDRV_PCM_CLASS_LAST = 3,
};

enum {
	SNDRV_PCM_MMAP_OFFSET_DATA = 0,
	SNDRV_PCM_MMAP_OFFSET_STATUS_OLD = 2147483648,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD = 2164260864,
	SNDRV_PCM_MMAP_OFFSET_STATUS_NEW = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW = 2197815296,
	SNDRV_PCM_MMAP_OFFSET_STATUS = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL = 2197815296,
};

enum {
	SNDRV_PCM_STREAM_PLAYBACK = 0,
	SNDRV_PCM_STREAM_CAPTURE = 1,
	SNDRV_PCM_STREAM_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_NONE = 0,
	SNDRV_PCM_TSTAMP_ENABLE = 1,
	SNDRV_PCM_TSTAMP_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY = 0,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC = 1,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW = 2,
	SNDRV_PCM_TSTAMP_TYPE_LAST = 2,
};

enum {
	SNDRV_TIMER_CLASS_NONE = -1,
	SNDRV_TIMER_CLASS_SLAVE = 0,
	SNDRV_TIMER_CLASS_GLOBAL = 1,
	SNDRV_TIMER_CLASS_CARD = 2,
	SNDRV_TIMER_CLASS_PCM = 3,
	SNDRV_TIMER_CLASS_LAST = 3,
};

enum {
	SNDRV_TIMER_EVENT_RESOLUTION = 0,
	SNDRV_TIMER_EVENT_TICK = 1,
	SNDRV_TIMER_EVENT_START = 2,
	SNDRV_TIMER_EVENT_STOP = 3,
	SNDRV_TIMER_EVENT_CONTINUE = 4,
	SNDRV_TIMER_EVENT_PAUSE = 5,
	SNDRV_TIMER_EVENT_EARLY = 6,
	SNDRV_TIMER_EVENT_SUSPEND = 7,
	SNDRV_TIMER_EVENT_RESUME = 8,
	SNDRV_TIMER_EVENT_MSTART = 12,
	SNDRV_TIMER_EVENT_MSTOP = 13,
	SNDRV_TIMER_EVENT_MCONTINUE = 14,
	SNDRV_TIMER_EVENT_MPAUSE = 15,
	SNDRV_TIMER_EVENT_MSUSPEND = 17,
	SNDRV_TIMER_EVENT_MRESUME = 18,
};

enum {
	SNDRV_TIMER_IOCTL_START_OLD = 21536,
	SNDRV_TIMER_IOCTL_STOP_OLD = 21537,
	SNDRV_TIMER_IOCTL_CONTINUE_OLD = 21538,
	SNDRV_TIMER_IOCTL_PAUSE_OLD = 21539,
};

enum {
	SNDRV_TIMER_SCLASS_NONE = 0,
	SNDRV_TIMER_SCLASS_APPLICATION = 1,
	SNDRV_TIMER_SCLASS_SEQUENCER = 2,
	SNDRV_TIMER_SCLASS_OSS_SEQUENCER = 3,
	SNDRV_TIMER_SCLASS_LAST = 3,
};

enum {
	SND_CTL_SUBDEV_PCM = 0,
	SND_CTL_SUBDEV_RAWMIDI = 1,
	SND_CTL_SUBDEV_ITEMS = 2,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SPECTRE_UNAFFECTED = 0,
	SPECTRE_MITIGATED = 1,
	SPECTRE_VULNERABLE = 2,
};

enum {
	SPECTRE_V2_METHOD_BPIALL = 1,
	SPECTRE_V2_METHOD_ICIALLU = 2,
	SPECTRE_V2_METHOD_SMC = 4,
	SPECTRE_V2_METHOD_HVC = 8,
	SPECTRE_V2_METHOD_LOOP8 = 16,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	SQ_START = 0,
	SQ_STOP = 1,
	SQ_ICU = 2,
};

enum {
	SQ_STS = 1,
	SQ_CUS = 2,
};

enum {
	STATE_IDLE = 0,
	STATE_READ = 1,
	STATE_WRITE = 2,
};

enum {
	STAT_CTRL = 3712,
	STAT_LAST_IDX = 3716,
	STAT_LIST_ADDR_LO = 3720,
	STAT_LIST_ADDR_HI = 3724,
	STAT_TXA1_RIDX = 3728,
	STAT_TXS1_RIDX = 3730,
	STAT_TXA2_RIDX = 3732,
	STAT_TXS2_RIDX = 3734,
	STAT_TX_IDX_TH = 3736,
	STAT_PUT_IDX = 3740,
	STAT_FIFO_WP = 3744,
	STAT_FIFO_RP = 3748,
	STAT_FIFO_RSP = 3750,
	STAT_FIFO_LEVEL = 3752,
	STAT_FIFO_SHLVL = 3754,
	STAT_FIFO_WM = 3756,
	STAT_FIFO_ISR_WM = 3757,
	STAT_LEV_TIMER_INI = 3760,
	STAT_LEV_TIMER_CNT = 3764,
	STAT_LEV_TIMER_CTRL = 3768,
	STAT_LEV_TIMER_TEST = 3769,
	STAT_TX_TIMER_INI = 3776,
	STAT_TX_TIMER_CNT = 3780,
	STAT_TX_TIMER_CTRL = 3784,
	STAT_TX_TIMER_TEST = 3785,
	STAT_ISR_TIMER_INI = 3792,
	STAT_ISR_TIMER_CNT = 3796,
	STAT_ISR_TIMER_CTRL = 3800,
	STAT_ISR_TIMER_TEST = 3801,
};

enum {
	SUNRPC_PIPEFS_NFS_PRIO = 0,
	SUNRPC_PIPEFS_RPC_PRIO = 1,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SYNAPTICS_INTERTOUCH_NOT_SET = -1,
	SYNAPTICS_INTERTOUCH_OFF = 0,
	SYNAPTICS_INTERTOUCH_ON = 1,
};

enum {
	SYNC_LEN_G1 = 80000,
	SYNC_LEN_G2 = 40000,
	SYNC_LEN_G3 = 20000,
};

enum {
	SYSTAB = 0,
	MMBASE = 1,
	MMSIZE = 2,
	DCSIZE = 3,
	DCVERS = 4,
	PARAMCOUNT = 5,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TASK_REQ_UPIU_SIZE_DWORDS = 8,
	TASK_RSP_UPIU_SIZE_DWORDS = 8,
	ALIGNED_UPIU_SIZE = 512,
};

enum {
	TBMU_TEST_BMU_TX_CHK_AUTO_OFF = -2147483648,
	TBMU_TEST_BMU_TX_CHK_AUTO_ON = 1073741824,
	TBMU_TEST_HOME_ADD_PAD_FIX1_EN = 536870912,
	TBMU_TEST_HOME_ADD_PAD_FIX1_DIS = 268435456,
	TBMU_TEST_ROUTING_ADD_FIX_EN = 134217728,
	TBMU_TEST_ROUTING_ADD_FIX_DIS = 67108864,
	TBMU_TEST_HOME_ADD_FIX_EN = 33554432,
	TBMU_TEST_HOME_ADD_FIX_DIS = 16777216,
	TBMU_TEST_TEST_RSPTR_ON = 4194304,
	TBMU_TEST_TEST_RSPTR_OFF = 2097152,
	TBMU_TEST_TESTSTEP_RSPTR = 1048576,
	TBMU_TEST_TEST_RPTR_ON = 262144,
	TBMU_TEST_TEST_RPTR_OFF = 131072,
	TBMU_TEST_TESTSTEP_RPTR = 65536,
	TBMU_TEST_TEST_WSPTR_ON = 16384,
	TBMU_TEST_TEST_WSPTR_OFF = 8192,
	TBMU_TEST_TESTSTEP_WSPTR = 4096,
	TBMU_TEST_TEST_WPTR_ON = 1024,
	TBMU_TEST_TEST_WPTR_OFF = 512,
	TBMU_TEST_TESTSTEP_WPTR = 256,
	TBMU_TEST_TEST_REQ_NB_ON = 64,
	TBMU_TEST_TEST_REQ_NB_OFF = 32,
	TBMU_TEST_TESTSTEP_REQ_NB = 16,
	TBMU_TEST_TEST_DONE_IDX_ON = 4,
	TBMU_TEST_TEST_DONE_IDX_OFF = 2,
	TBMU_TEST_TESTSTEP_DONE_IDX = 1,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TC_MQPRIO_HW_OFFLOAD_NONE = 0,
	TC_MQPRIO_HW_OFFLOAD_TCS = 1,
	__TC_MQPRIO_HW_OFFLOAD_MAX = 2,
};

enum {
	TC_MQPRIO_SHAPER_DCB = 0,
	TC_MQPRIO_SHAPER_BW_RATE = 1,
	__TC_MQPRIO_SHAPER_MAX = 2,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	TIM_START = 4,
	TIM_STOP = 2,
	TIM_CLR_IRQ = 1,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOKEN_END = 0,
	TOKEN_START = 1,
	TOKEN_SLAVE_ADDR_WRITE = 2,
	TOKEN_SLAVE_ADDR_READ = 3,
	TOKEN_DATA = 4,
	TOKEN_DATA_LAST = 5,
	TOKEN_STOP = 6,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TPS65219_INT_LDO3_SCG = 0,
	TPS65219_INT_LDO3_OC = 1,
	TPS65219_INT_LDO3_UV = 2,
	TPS65219_INT_LDO4_SCG = 3,
	TPS65219_INT_LDO4_OC = 4,
	TPS65219_INT_LDO4_UV = 5,
	TPS65215_INT_LDO1_SCG = 6,
	TPS65215_INT_LDO1_OC = 7,
	TPS65215_INT_LDO1_UV = 8,
	TPS65215_INT_LDO2_SCG = 9,
	TPS65215_INT_LDO2_OC = 10,
	TPS65215_INT_LDO2_UV = 11,
	TPS65219_INT_LDO1_SCG = 12,
	TPS65219_INT_LDO1_OC = 13,
	TPS65219_INT_LDO1_UV = 14,
	TPS65219_INT_LDO2_SCG = 15,
	TPS65219_INT_LDO2_OC = 16,
	TPS65219_INT_LDO2_UV = 17,
	TPS65219_INT_BUCK3_SCG = 18,
	TPS65219_INT_BUCK3_OC = 19,
	TPS65219_INT_BUCK3_NEG_OC = 20,
	TPS65219_INT_BUCK3_UV = 21,
	TPS65219_INT_BUCK1_SCG = 22,
	TPS65219_INT_BUCK1_OC = 23,
	TPS65219_INT_BUCK1_NEG_OC = 24,
	TPS65219_INT_BUCK1_UV = 25,
	TPS65219_INT_BUCK2_SCG = 26,
	TPS65219_INT_BUCK2_OC = 27,
	TPS65219_INT_BUCK2_NEG_OC = 28,
	TPS65219_INT_BUCK2_UV = 29,
	TPS65219_INT_SENSOR_3_WARM = 30,
	TPS65219_INT_SENSOR_2_WARM = 31,
	TPS65219_INT_SENSOR_1_WARM = 32,
	TPS65219_INT_SENSOR_0_WARM = 33,
	TPS65219_INT_SENSOR_3_HOT = 34,
	TPS65219_INT_SENSOR_2_HOT = 35,
	TPS65219_INT_SENSOR_1_HOT = 36,
	TPS65219_INT_SENSOR_0_HOT = 37,
	TPS65219_INT_BUCK1_RV = 38,
	TPS65219_INT_BUCK2_RV = 39,
	TPS65219_INT_BUCK3_RV = 40,
	TPS65219_INT_LDO1_RV = 41,
	TPS65219_INT_LDO2_RV = 42,
	TPS65215_INT_LDO2_RV = 43,
	TPS65214_INT_LDO2_RV = 44,
	TPS65219_INT_LDO3_RV = 45,
	TPS65219_INT_LDO4_RV = 46,
	TPS65219_INT_BUCK1_RV_SD = 47,
	TPS65219_INT_BUCK2_RV_SD = 48,
	TPS65219_INT_BUCK3_RV_SD = 49,
	TPS65219_INT_LDO1_RV_SD = 50,
	TPS65214_INT_LDO1_RV_SD = 51,
	TPS65215_INT_LDO2_RV_SD = 52,
	TPS65219_INT_LDO2_RV_SD = 53,
	TPS65219_INT_LDO3_RV_SD = 54,
	TPS65219_INT_LDO4_RV_SD = 55,
	TPS65219_INT_TIMEOUT = 56,
	TPS65219_INT_PB_FALLING_EDGE_DETECT = 57,
	TPS65219_INT_PB_RISING_EDGE_DETECT = 58,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_TP_NAME = 13,
	TP_ERR_BAD_ADDR_SUFFIX = 14,
	TP_ERR_NO_GROUP_NAME = 15,
	TP_ERR_GROUP_TOO_LONG = 16,
	TP_ERR_BAD_GROUP_NAME = 17,
	TP_ERR_NO_EVENT_NAME = 18,
	TP_ERR_EVENT_TOO_LONG = 19,
	TP_ERR_BAD_EVENT_NAME = 20,
	TP_ERR_EVENT_EXIST = 21,
	TP_ERR_RETVAL_ON_PROBE = 22,
	TP_ERR_NO_RETVAL = 23,
	TP_ERR_BAD_STACK_NUM = 24,
	TP_ERR_BAD_ARG_NUM = 25,
	TP_ERR_BAD_VAR = 26,
	TP_ERR_BAD_REG_NAME = 27,
	TP_ERR_BAD_MEM_ADDR = 28,
	TP_ERR_BAD_IMM = 29,
	TP_ERR_IMMSTR_NO_CLOSE = 30,
	TP_ERR_FILE_ON_KPROBE = 31,
	TP_ERR_BAD_FILE_OFFS = 32,
	TP_ERR_SYM_ON_UPROBE = 33,
	TP_ERR_TOO_MANY_OPS = 34,
	TP_ERR_DEREF_NEED_BRACE = 35,
	TP_ERR_BAD_DEREF_OFFS = 36,
	TP_ERR_DEREF_OPEN_BRACE = 37,
	TP_ERR_COMM_CANT_DEREF = 38,
	TP_ERR_BAD_FETCH_ARG = 39,
	TP_ERR_ARRAY_NO_CLOSE = 40,
	TP_ERR_BAD_ARRAY_SUFFIX = 41,
	TP_ERR_BAD_ARRAY_NUM = 42,
	TP_ERR_ARRAY_TOO_BIG = 43,
	TP_ERR_BAD_TYPE = 44,
	TP_ERR_BAD_STRING = 45,
	TP_ERR_BAD_SYMSTRING = 46,
	TP_ERR_BAD_BITFIELD = 47,
	TP_ERR_ARG_NAME_TOO_LONG = 48,
	TP_ERR_NO_ARG_NAME = 49,
	TP_ERR_BAD_ARG_NAME = 50,
	TP_ERR_USED_ARG_NAME = 51,
	TP_ERR_ARG_TOO_LONG = 52,
	TP_ERR_NO_ARG_BODY = 53,
	TP_ERR_BAD_INSN_BNDRY = 54,
	TP_ERR_FAIL_REG_PROBE = 55,
	TP_ERR_DIFF_PROBE_TYPE = 56,
	TP_ERR_DIFF_ARG_TYPE = 57,
	TP_ERR_SAME_PROBE = 58,
	TP_ERR_NO_EVENT_INFO = 59,
	TP_ERR_BAD_ATTACH_EVENT = 60,
	TP_ERR_BAD_ATTACH_ARG = 61,
	TP_ERR_NO_EP_FILTER = 62,
	TP_ERR_NOSUP_BTFARG = 63,
	TP_ERR_NO_BTFARG = 64,
	TP_ERR_NO_BTF_ENTRY = 65,
	TP_ERR_BAD_VAR_ARGS = 66,
	TP_ERR_NOFENTRY_ARGS = 67,
	TP_ERR_DOUBLE_ARGS = 68,
	TP_ERR_ARGS_2LONG = 69,
	TP_ERR_ARGIDX_2BIG = 70,
	TP_ERR_NO_PTR_STRCT = 71,
	TP_ERR_NOSUP_DAT_ARG = 72,
	TP_ERR_BAD_HYPHEN = 73,
	TP_ERR_NO_BTF_FIELD = 74,
	TP_ERR_BAD_BTF_TID = 75,
	TP_ERR_BAD_TYPE4STR = 76,
	TP_ERR_NEED_STRING_TYPE = 77,
	TP_ERR_TOO_MANY_ARGS = 78,
	TP_ERR_TOO_MANY_EARGS = 79,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_LAST_BOOT = 4,
	TRACE_ARRAY_FL_MOD_INIT = 8,
	TRACE_ARRAY_FL_MEMMAP = 16,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TRANS_MODE_PIO = 0,
	TRANS_MODE_IDMAC = 1,
	TRANS_MODE_EDMAC = 2,
};

enum {
	TST_FRC_DPERR_MR = 128,
	TST_FRC_DPERR_MW = 64,
	TST_FRC_DPERR_TR = 32,
	TST_FRC_DPERR_TW = 16,
	TST_FRC_APERR_M = 8,
	TST_FRC_APERR_T = 4,
	TST_CFG_WRITE_ON = 2,
	TST_CFG_WRITE_OFF = 1,
};

enum {
	TXA_ENA_FSYNC = 128,
	TXA_DIS_FSYNC = 64,
	TXA_ENA_ALLOC = 32,
	TXA_DIS_ALLOC = 16,
	TXA_START_RC = 8,
	TXA_STOP_RC = 4,
	TXA_ENA_ARB = 2,
	TXA_DIS_ARB = 1,
};

enum {
	TXA_ITI_INI = 512,
	TXA_ITI_VAL = 516,
	TXA_LIM_INI = 520,
	TXA_LIM_VAL = 524,
	TXA_CTRL = 528,
	TXA_TEST = 529,
	TXA_STAT = 530,
	RSS_KEY = 544,
	RSS_CFG = 584,
};

enum {
	TX_DYN_WM_ENA = 3,
};

enum {
	TX_GMF_EA = 3392,
	TX_GMF_AE_THR = 3396,
	TX_GMF_CTRL_T = 3400,
	TX_GMF_WP = 3424,
	TX_GMF_WSP = 3428,
	TX_GMF_WLEV = 3432,
	TX_GMF_RP = 3440,
	TX_GMF_RSTP = 3444,
	TX_GMF_RLEV = 3448,
	ECU_AE_THR = 112,
	ECU_TXFF_LEV = 416,
	ECU_JUMBO_WM = 128,
};

enum {
	TX_STFW_DIS = -2147483648,
	TX_STFW_ENA = 1073741824,
	TX_VLAN_TAG_ON = 33554432,
	TX_VLAN_TAG_OFF = 16777216,
	TX_PCI_JUM_ENA = 8388608,
	TX_PCI_JUM_DIS = 4194304,
	GMF_WSP_TST_ON = 262144,
	GMF_WSP_TST_OFF = 131072,
	GMF_WSP_STEP = 65536,
	GMF_CLI_TX_FU = 64,
	GMF_CLI_TX_FC = 32,
	GMF_CLI_TX_PE = 16,
};

enum {
	UARTDM_1P1 = 1,
	UARTDM_1P2 = 2,
	UARTDM_1P3 = 3,
	UARTDM_1P4 = 4,
};

enum {
	UART_IRQ_SUM = 0,
	UART_RX_IRQ = 0,
	UART_TX_IRQ = 1,
	UART_IRQ_COUNT = 2,
};

enum {
	UDPTCP = 1,
	CALSUM = 2,
	WR_SUM = 4,
	INIT_SUM = 8,
	LOCK_SUM = 16,
	INS_VLAN = 32,
	EOP = 128,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UFSHCD_EH_IN_PROGRESS = 1,
};

enum {
	UFSHCD_MAX_CHANNEL = 0,
	UFSHCD_MAX_ID = 1,
};

enum {
	UFSHCD_NANO_AMP = 0,
	UFSHCD_MICRO_AMP = 1,
	UFSHCD_MILI_AMP = 2,
	UFSHCD_AMP = 3,
};

enum {
	UFSHCD_POLL_FROM_INTERRUPT_CONTEXT = -1,
};

enum {
	UFSHCD_UIC_DL_PA_INIT_ERROR = 1,
	UFSHCD_UIC_DL_NAC_RECEIVED_ERROR = 2,
	UFSHCD_UIC_DL_TCx_REPLAY_ERROR = 4,
	UFSHCD_UIC_NL_ERROR = 8,
	UFSHCD_UIC_TL_ERROR = 16,
	UFSHCD_UIC_DME_ERROR = 32,
	UFSHCD_UIC_PA_GENERIC_ERROR = 64,
};

enum {
	UFS_ABORT_TASK = 1,
	UFS_ABORT_TASK_SET = 2,
	UFS_CLEAR_TASK_SET = 4,
	UFS_LOGICAL_RESET = 8,
	UFS_QUERY_TASK = 128,
	UFS_QUERY_TASK_SET = 129,
};

enum {
	UFS_DEV_HIGH_TEMP_NOTIF = 16,
	UFS_DEV_LOW_TEMP_NOTIF = 32,
	UFS_DEV_EXT_TEMP_NOTIF = 64,
	UFS_DEV_HPB_SUPPORT = 128,
	UFS_DEV_WRITE_BOOSTER_SUP = 256,
	UFS_DEV_LVL_EXCEPTION_SUP = 4096,
};

enum {
	UFS_DEV_WB_BUF_RESIZE = 1,
};

enum {
	UFS_REG_OCPTHRTL = 192,
	UFS_REG_OOCPR = 196,
	UFS_REG_CDACFG = 208,
	UFS_REG_CDATX1 = 212,
	UFS_REG_CDATX2 = 216,
	UFS_REG_CDARX1 = 220,
	UFS_REG_CDARX2 = 224,
	UFS_REG_CDASTA = 228,
	UFS_REG_LBMCFG = 240,
	UFS_REG_LBMSTA = 244,
	UFS_REG_UFSMODE = 248,
	UFS_REG_HCLKDIV = 252,
};

enum {
	UFS_UPIU_REPORT_LUNS_WLUN = 129,
	UFS_UPIU_UFS_DEVICE_WLUN = 208,
	UFS_UPIU_BOOT_WLUN = 176,
	UFS_UPIU_RPMB_WLUN = 196,
};

enum {
	UIC_CMD_TIMEOUT_DEFAULT = 500,
	UIC_CMD_TIMEOUT_MAX = 5000,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNIPRO_L1_5 = 0,
	UNIPRO_L2 = 1,
	UNIPRO_L3 = 2,
	UNIPRO_L4 = 3,
	UNIPRO_DME = 4,
};

enum {
	UPIU_CMD_FLAGS_NONE = 0,
	UPIU_CMD_FLAGS_CP = 4,
	UPIU_CMD_FLAGS_WRITE = 32,
	UPIU_CMD_FLAGS_READ = 64,
};

enum {
	UPIU_COMMAND_SET_TYPE_SCSI = 0,
	UPIU_COMMAND_SET_TYPE_UFS = 1,
	UPIU_COMMAND_SET_TYPE_QUERY = 2,
};

enum {
	UPIU_QUERY_FUNC_STANDARD_READ_REQUEST = 1,
	UPIU_QUERY_FUNC_STANDARD_WRITE_REQUEST = 129,
};

enum {
	UPIU_RSP_FLAG_UNDERFLOW = 32,
	UPIU_RSP_FLAG_OVERFLOW = 64,
};

enum {
	UPIU_TASK_MANAGEMENT_FUNC_COMPL = 0,
	UPIU_TASK_MANAGEMENT_FUNC_NOT_SUPPORTED = 4,
	UPIU_TASK_MANAGEMENT_FUNC_SUCCEEDED = 8,
	UPIU_TASK_MANAGEMENT_FUNC_FAILED = 5,
	UPIU_INCORRECT_LOGICAL_UNIT_NO = 9,
};

enum {
	USB_CTRL_SETUP_SCB1_EN_SELECTOR = 0,
	USB_CTRL_SETUP_SCB2_EN_SELECTOR = 1,
	USB_CTRL_SETUP_SS_EHCI64BIT_EN_SELECTOR = 2,
	USB_CTRL_SETUP_STRAP_IPP_SEL_SELECTOR = 3,
	USB_CTRL_SETUP_OC3_DISABLE_PORT0_SELECTOR = 4,
	USB_CTRL_SETUP_OC3_DISABLE_PORT1_SELECTOR = 5,
	USB_CTRL_SETUP_OC3_DISABLE_SELECTOR = 6,
	USB_CTRL_PLL_CTL_PLL_IDDQ_PWRDN_SELECTOR = 7,
	USB_CTRL_USB_PM_BDC_SOFT_RESETB_SELECTOR = 8,
	USB_CTRL_USB_PM_XHC_SOFT_RESETB_SELECTOR = 9,
	USB_CTRL_USB_PM_USB_PWRDN_SELECTOR = 10,
	USB_CTRL_USB30_CTL1_XHC_SOFT_RESETB_SELECTOR = 11,
	USB_CTRL_USB30_CTL1_USB3_IOC_SELECTOR = 12,
	USB_CTRL_USB30_CTL1_USB3_IPP_SELECTOR = 13,
	USB_CTRL_USB_DEVICE_CTL1_PORT_MODE_SELECTOR = 14,
	USB_CTRL_USB_PM_SOFT_RESET_SELECTOR = 15,
	USB_CTRL_SETUP_CC_DRD_MODE_ENABLE_SELECTOR = 16,
	USB_CTRL_SETUP_STRAP_CC_DRD_MODE_ENABLE_SEL_SELECTOR = 17,
	USB_CTRL_USB_PM_USB20_HC_RESETB_SELECTOR = 18,
	USB_CTRL_SETUP_ENDIAN_SELECTOR = 19,
	USB_CTRL_SELECTOR_COUNT = 20,
};

enum {
	USER_CLOCKSOURCE = 0,
	USER_CLOCKEVENT = 1,
	USER_NR = 2,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	UTP_CMD_TYPE_UFS_STORAGE = 1,
};

enum {
	VFIO_DEVICE_NUM_STATES = 8,
};

enum {
	VFIO_PCI_BAR0_REGION_INDEX = 0,
	VFIO_PCI_BAR1_REGION_INDEX = 1,
	VFIO_PCI_BAR2_REGION_INDEX = 2,
	VFIO_PCI_BAR3_REGION_INDEX = 3,
	VFIO_PCI_BAR4_REGION_INDEX = 4,
	VFIO_PCI_BAR5_REGION_INDEX = 5,
	VFIO_PCI_ROM_REGION_INDEX = 6,
	VFIO_PCI_CONFIG_REGION_INDEX = 7,
	VFIO_PCI_VGA_REGION_INDEX = 8,
	VFIO_PCI_NUM_REGIONS = 9,
};

enum {
	VFIO_PCI_INTX_IRQ_INDEX = 0,
	VFIO_PCI_MSI_IRQ_INDEX = 1,
	VFIO_PCI_MSIX_IRQ_INDEX = 2,
	VFIO_PCI_ERR_IRQ_INDEX = 3,
	VFIO_PCI_REQ_IRQ_INDEX = 4,
	VFIO_PCI_NUM_IRQS = 5,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WB_BUF_MODE_LU_DEDICATED = 0,
	WB_BUF_MODE_SHARED = 1,
};

enum {
	WOL_CTL_LINK_CHG_OCC = 32768,
	WOL_CTL_MAGIC_PKT_OCC = 16384,
	WOL_CTL_PATTERN_OCC = 8192,
	WOL_CTL_CLEAR_RESULT = 4096,
	WOL_CTL_ENA_PME_ON_LINK_CHG = 2048,
	WOL_CTL_DIS_PME_ON_LINK_CHG = 1024,
	WOL_CTL_ENA_PME_ON_MAGIC_PKT = 512,
	WOL_CTL_DIS_PME_ON_MAGIC_PKT = 256,
	WOL_CTL_ENA_PME_ON_PATTERN = 128,
	WOL_CTL_DIS_PME_ON_PATTERN = 64,
	WOL_CTL_ENA_LINK_CHG_UNIT = 32,
	WOL_CTL_DIS_LINK_CHG_UNIT = 16,
	WOL_CTL_ENA_MAGIC_PKT_UNIT = 8,
	WOL_CTL_DIS_MAGIC_PKT_UNIT = 4,
	WOL_CTL_ENA_PATTERN_UNIT = 2,
	WOL_CTL_DIS_PATTERN_UNIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
};

enum {
	Y2_ASF_OS_PRES = 16,
	Y2_ASF_RESET = 8,
	Y2_ASF_RUNNING = 4,
	Y2_ASF_CLR_HSTI = 2,
	Y2_ASF_IRQ = 1,
	Y2_ASF_UC_STATE = 12,
	Y2_ASF_CLK_HALT = 0,
};

enum {
	Y2_B8_PREF_REGS = 1104,
	PREF_UNIT_CTRL = 0,
	PREF_UNIT_LAST_IDX = 4,
	PREF_UNIT_ADDR_LO = 8,
	PREF_UNIT_ADDR_HI = 12,
	PREF_UNIT_GET_IDX = 16,
	PREF_UNIT_PUT_IDX = 20,
	PREF_UNIT_FIFO_WP = 32,
	PREF_UNIT_FIFO_RP = 36,
	PREF_UNIT_FIFO_WM = 40,
	PREF_UNIT_FIFO_LEV = 44,
	PREF_UNIT_MASK_IDX = 4095,
};

enum {
	Y2_CLK_DIV_VAL_MSK = 16711680,
	Y2_CLK_DIV_VAL2_MSK = 14680064,
	Y2_CLK_SELECT2_MSK = 2031616,
	Y2_CLK_DIV_ENA = 2,
	Y2_CLK_DIV_DIS = 1,
};

enum {
	Y2_IS_HW_ERR = -2147483648,
	Y2_IS_STAT_BMU = 1073741824,
	Y2_IS_ASF = 536870912,
	Y2_IS_CPU_TO = 268435456,
	Y2_IS_POLL_CHK = 134217728,
	Y2_IS_TWSI_RDY = 67108864,
	Y2_IS_IRQ_SW = 33554432,
	Y2_IS_TIMINT = 16777216,
	Y2_IS_IRQ_PHY2 = 4096,
	Y2_IS_IRQ_MAC2 = 2048,
	Y2_IS_CHK_RX2 = 1024,
	Y2_IS_CHK_TXS2 = 512,
	Y2_IS_CHK_TXA2 = 256,
	Y2_IS_PSM_ACK = 128,
	Y2_IS_PTP_TIST = 64,
	Y2_IS_PHY_QLNK = 32,
	Y2_IS_IRQ_PHY1 = 16,
	Y2_IS_IRQ_MAC1 = 8,
	Y2_IS_CHK_RX1 = 4,
	Y2_IS_CHK_TXS1 = 2,
	Y2_IS_CHK_TXA1 = 1,
	Y2_IS_BASE = -1073741824,
	Y2_IS_PORT_1 = 29,
	Y2_IS_PORT_2 = 7424,
	Y2_IS_ERROR = -2147480307,
};

enum {
	Y2_IS_TIST_OV = 536870912,
	Y2_IS_SENSOR = 268435456,
	Y2_IS_MST_ERR = 134217728,
	Y2_IS_IRQ_STAT = 67108864,
	Y2_IS_PCI_EXP = 33554432,
	Y2_IS_PCI_NEXP = 16777216,
	Y2_IS_PAR_RD2 = 8192,
	Y2_IS_PAR_WR2 = 4096,
	Y2_IS_PAR_MAC2 = 2048,
	Y2_IS_PAR_RX2 = 1024,
	Y2_IS_TCP_TXS2 = 512,
	Y2_IS_TCP_TXA2 = 256,
	Y2_IS_PAR_RD1 = 32,
	Y2_IS_PAR_WR1 = 16,
	Y2_IS_PAR_MAC1 = 8,
	Y2_IS_PAR_RX1 = 4,
	Y2_IS_TCP_TXS1 = 2,
	Y2_IS_TCP_TXA1 = 1,
	Y2_HWE_L1_MASK = 63,
	Y2_HWE_L2_MASK = 16128,
	Y2_HWE_ALL_MASK = 738213695,
};

enum {
	Y2_STATUS_LNK2_INAC = 128,
	Y2_CLK_GAT_LNK2_DIS = 64,
	Y2_COR_CLK_LNK2_DIS = 32,
	Y2_PCI_CLK_LNK2_DIS = 16,
	Y2_STATUS_LNK1_INAC = 8,
	Y2_CLK_GAT_LNK1_DIS = 4,
	Y2_COR_CLK_LNK1_DIS = 2,
	Y2_PCI_CLK_LNK1_DIS = 1,
};

enum {
	Y2_VMAIN_AVAIL = 131072,
	Y2_VAUX_AVAIL = 65536,
	Y2_HW_WOL_ON = 32768,
	Y2_HW_WOL_OFF = 16384,
	Y2_ASF_ENABLE = 8192,
	Y2_ASF_DISABLE = 4096,
	Y2_CLK_RUN_ENA = 2048,
	Y2_CLK_RUN_DIS = 1024,
	Y2_LED_STAT_ON = 512,
	Y2_LED_STAT_OFF = 256,
	CS_ST_SW_IRQ = 128,
	CS_CL_SW_IRQ = 64,
	CS_STOP_DONE = 32,
	CS_STOP_MAST = 16,
	CS_MRST_CLR = 8,
	CS_MRST_SET = 4,
	CS_RST_CLR = 2,
	CS_RST_SET = 1,
};

enum {
	ZONELIST_FALLBACK = 0,
	MAX_ZONELISTS = 1,
};

enum {
	ZONE_MAN_CLKEN_MASK = 1,
	ZONE_MAN_RESET_CNTL_MASK = 2,
	ZONE_MAN_MEM_PWR_MASK = 16,
	ZONE_RESERVED_1_MASK = 32,
	ZONE_MAN_ISO_CNTL_MASK = 64,
	ZONE_MANUAL_CONTROL_MASK = 128,
	ZONE_PWR_DN_REQ_MASK = 512,
	ZONE_PWR_UP_REQ_MASK = 1024,
	ZONE_BLK_RST_ASSERT_MASK = 4096,
	ZONE_PWR_OFF_STATE_MASK = 33554432,
	ZONE_PWR_ON_STATE_MASK = 67108864,
	ZONE_DPG_PWR_STATE_MASK = 268435456,
	ZONE_MEM_PWR_STATE_MASK = 536870912,
	ZONE_RESET_STATE_MASK = 2147483648,
	CPU0_PWR_ZONE_CTRL_REG = 1,
	CPU_RESET_CONFIG_REG = 2,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 3072,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__MVNETA_DOWN = 0,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	__SPECTRE_V2_METHOD_BPIALL = 0,
	__SPECTRE_V2_METHOD_ICIALLU = 1,
	__SPECTRE_V2_METHOD_SMC = 2,
	__SPECTRE_V2_METHOD_HVC = 3,
	__SPECTRE_V2_METHOD_LOOP8 = 4,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 24,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 25,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 26,
	__ctx_convertBPF_PROG_TYPE_EXT = 27,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 28,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 29,
	__ctx_convert_unused = 30,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	vfio_noiommu = 0,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FL_READY = 0,
	FL_STATUS = 1,
	FL_CFI_QUERY = 2,
	FL_JEDEC_QUERY = 3,
	FL_ERASING = 4,
	FL_ERASE_SUSPENDING = 5,
	FL_ERASE_SUSPENDED = 6,
	FL_WRITING = 7,
	FL_WRITING_TO_BUFFER = 8,
	FL_OTP_WRITE = 9,
	FL_WRITE_SUSPENDING = 10,
	FL_WRITE_SUSPENDED = 11,
	FL_PM_SUSPENDED = 12,
	FL_SYNCING = 13,
	FL_UNLOADING = 14,
	FL_LOCKING = 15,
	FL_UNLOCKING = 16,
	FL_POINT = 17,
	FL_XIP_WHILE_ERASING = 18,
	FL_XIP_WHILE_WRITING = 19,
	FL_SHUTDOWN = 20,
	FL_READING = 21,
	FL_CACHEDPRG = 22,
	FL_RESETTING = 23,
	FL_OTPING = 24,
	FL_PREPARING_ERASE = 25,
	FL_VERIFYING_ERASE = 26,
	FL_UNKNOWN = 27,
} flstate_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef ZSTD_ErrorCode zstd_error_code;

enum APSR_BIT {
	APSR_MEMS = 2,
	APSR_CMSW = 16,
	APSR_RDM = 8192,
	APSR_TDM = 16384,
	APSR_MIISELECT = 16777216,
};

enum ARSTR_BIT {
	ARSTR_ARST = 1,
};

enum CCC_BIT {
	CCC_OPC = 3,
	CCC_OPC_RESET = 0,
	CCC_OPC_CONFIG = 1,
	CCC_OPC_OPERATION = 2,
	CCC_GAC = 128,
	CCC_DTSR = 256,
	CCC_CSEL = 196608,
	CCC_CSEL_HPB = 65536,
	CCC_CSEL_ETH_TX = 131072,
	CCC_CSEL_GMII_REF = 196608,
	CCC_LBME = 16777216,
};

enum CIE_BIT {
	CIE_CRIE = 1,
	CIE_CTIE = 256,
	CIE_RQFM = 65536,
	CIE_CL0M = 131072,
	CIE_RFWL = 262144,
	CIE_RFFL = 524288,
};

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum CSR0_BIT {
	CSR0_TPE = 16,
	CSR0_RPE = 32,
};

enum CSR1_BIT {
	CSR1_TIP4 = 1,
	CSR1_TTCP4 = 16,
	CSR1_TUDP4 = 32,
	CSR1_TICMP4 = 64,
	CSR1_TTCP6 = 1048576,
	CSR1_TUDP6 = 2097152,
	CSR1_TICMP6 = 4194304,
	CSR1_THOP = 16777216,
	CSR1_TROUT = 33554432,
	CSR1_TAHD = 67108864,
	CSR1_TDHD = 134217728,
};

enum CSR2_BIT {
	CSR2_RIP4 = 1,
	CSR2_RTCP4 = 16,
	CSR2_RUDP4 = 32,
	CSR2_RICMP4 = 64,
	CSR2_RTCP6 = 1048576,
	CSR2_RUDP6 = 2097152,
	CSR2_RICMP6 = 4194304,
	CSR2_RHOP = 16777216,
	CSR2_RROUT = 33554432,
	CSR2_RAHD = 67108864,
	CSR2_RDHD = 134217728,
};

enum CSR_BIT {
	CSR_OPS = 15,
	CSR_OPS_RESET = 1,
	CSR_OPS_CONFIG = 2,
	CSR_OPS_OPERATION = 4,
	CSR_OPS_STANDBY = 8,
	CSR_DTS = 256,
	CSR_TPO0 = 65536,
	CSR_TPO1 = 131072,
	CSR_TPO2 = 262144,
	CSR_TPO3 = 524288,
	CSR_RPO = 1048576,
};

enum CXR31_BIT {
	CXR31_SEL_LINK0 = 1,
	CXR31_SEL_LINK1 = 8,
};

enum CXR35_BIT {
	CXR35_SEL_XMII = 3,
	CXR35_SEL_XMII_RGMII = 0,
	CXR35_SEL_XMII_MII = 2,
	CXR35_HALFCYC_CLKSW = 4294901760,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum DIE_DT {
	DT_FEMPTY_IS = 16,
	DT_FEMPTY_IC = 32,
	DT_FEMPTY_ND = 48,
	DT_FEMPTY = 64,
	DT_FEMPTY_START = 80,
	DT_FEMPTY_MID = 96,
	DT_FEMPTY_END = 112,
	DT_FSINGLE = 128,
	DT_FSTART = 144,
	DT_FMID = 160,
	DT_FEND = 176,
	DT_LEMPTY = 192,
	DT_EEMPTY = 208,
	DT_LINK = 224,
	DT_EOS = 240,
	DT_MASK = 240,
	D_DIE = 8,
};

enum DIE_DT___2 {
	DT_FSINGLE___2 = 128,
	DT_FSTART___2 = 144,
	DT_FMID___2 = 160,
	DT_FEND___2 = 176,
	DT_LEMPTY___2 = 192,
	DT_EEMPTY___2 = 208,
	DT_LINKFIX = 0,
	DT_LINK___2 = 224,
	DT_EOS___2 = 240,
	DT_FEMPTY___2 = 64,
	DT_FEMPTY_IS___2 = 16,
	DT_FEMPTY_IC___2 = 32,
	DT_FEMPTY_ND___2 = 48,
	DT_FEMPTY_START___2 = 80,
	DT_FEMPTY_MID___2 = 96,
	DT_FEMPTY_END___2 = 112,
	DT_MASK___2 = 240,
	DIE = 8,
};

enum DIE_DT___3 {
	DT_FMID___3 = 64,
	DT_FSTART___3 = 80,
	DT_FEND___3 = 96,
	DT_FSINGLE___3 = 112,
	DT_LINK___3 = 128,
	DT_LINKFIX___2 = 144,
	DT_EOS___3 = 160,
	DT_FEMPTY___3 = 192,
	DT_FEMPTY_IS___3 = 208,
	DT_FEMPTY_IC___3 = 224,
	DT_FEMPTY_ND___3 = 240,
	DT_LEMPTY___3 = 32,
	DT_EEMPTY___3 = 48,
};

enum DMA_REGS_OFFSET {
	OFFSET_INT_FLAG = 0,
	OFFSET_INT_EN = 4,
	OFFSET_EN = 8,
	OFFSET_RST = 12,
	OFFSET_CON = 24,
	OFFSET_TX_MEM_ADDR = 28,
	OFFSET_RX_MEM_ADDR = 32,
	OFFSET_TX_LEN = 36,
	OFFSET_RX_LEN = 40,
	OFFSET_TX_4G_MODE = 84,
	OFFSET_RX_4G_MODE = 88,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum ECMR_BIT {
	ECMR_PRM = 1,
	ECMR_DM = 2,
	ECMR_TE = 32,
	ECMR_RE = 64,
	ECMR_MPDE = 512,
	ECMR_TXF = 65536,
	ECMR_RXF = 131072,
	ECMR_PFR = 262144,
	ECMR_ZPF = 524288,
	ECMR_RZPF = 1048576,
	ECMR_DPAD = 2097152,
	ECMR_RCSC = 8388608,
	ECMR_RCPT = 33554432,
	ECMR_TRCCM = 67108864,
};

enum ECMR_BIT___2 {
	ECMR_TRCCM___2 = 67108864,
	ECMR_RCSC___2 = 8388608,
	ECMR_DPAD___2 = 2097152,
	ECMR_RZPF___2 = 1048576,
	ECMR_ZPF___2 = 524288,
	ECMR_PFR___2 = 262144,
	ECMR_RXF___2 = 131072,
	ECMR_TXF___2 = 65536,
	ECMR_MCT = 8192,
	ECMR_PRCEF = 4096,
	ECMR_MPDE___2 = 512,
	ECMR_RE___2 = 64,
	ECMR_TE___2 = 32,
	ECMR_RTM = 16,
	ECMR_ILB = 8,
	ECMR_ELB = 4,
	ECMR_DM___2 = 2,
	ECMR_PRM___2 = 1,
};

enum ECSIPR_BIT {
	ECSIPR_ICDIP = 1,
	ECSIPR_MPDIP = 2,
	ECSIPR_LCHNGIP = 4,
};

enum ECSIPR_BIT___2 {
	ECSIPR_BRCRXIP = 32,
	ECSIPR_PSRTOIP = 16,
	ECSIPR_LCHNGIP___2 = 4,
	ECSIPR_MPDIP___2 = 2,
	ECSIPR_ICDIP___2 = 1,
};

enum ECSR_BIT {
	ECSR_ICD = 1,
	ECSR_MPD = 2,
	ECSR_LCHNG = 4,
	ECSR_PHYI = 8,
	ECSR_PFRI = 16,
};

enum ECSR_BIT___2 {
	ECSR_BRCRX = 32,
	ECSR_PSRTO = 16,
	ECSR_LCHNG___2 = 4,
	ECSR_MPD___2 = 2,
	ECSR_ICD___2 = 1,
};

enum EDMR_BIT {
	EDMR_NBST = 128,
	EDMR_EL = 64,
	EDMR_DL1 = 32,
	EDMR_DL0 = 16,
	EDMR_SRST_GETHER = 3,
	EDMR_SRST_ETHER = 1,
};

enum EDRRR_BIT {
	EDRRR_R = 1,
};

enum EDSR_BIT {
	EDSR_ENT = 1,
	EDSR_ENR = 2,
};

enum EDTRR_BIT {
	EDTRR_TRNS_GETHER = 3,
	EDTRR_TRNS_ETHER = 1,
};

enum EESIPR_BIT {
	EESIPR_TWB1IP = 2147483648,
	EESIPR_TWBIP = 1073741824,
	EESIPR_TC1IP = 536870912,
	EESIPR_TUCIP = 268435456,
	EESIPR_ROCIP = 134217728,
	EESIPR_TABTIP = 67108864,
	EESIPR_RABTIP = 33554432,
	EESIPR_RFCOFIP = 16777216,
	EESIPR_ADEIP = 8388608,
	EESIPR_ECIIP = 4194304,
	EESIPR_FTCIP = 2097152,
	EESIPR_TDEIP = 1048576,
	EESIPR_TFUFIP = 524288,
	EESIPR_FRIP = 262144,
	EESIPR_RDEIP = 131072,
	EESIPR_RFOFIP = 65536,
	EESIPR_CNDIP = 2048,
	EESIPR_DLCIP = 1024,
	EESIPR_CDIP = 512,
	EESIPR_TROIP = 256,
	EESIPR_RMAFIP = 128,
	EESIPR_CEEFIP = 64,
	EESIPR_CELFIP = 32,
	EESIPR_RRFIP = 16,
	EESIPR_RTLFIP = 8,
	EESIPR_RTSFIP = 4,
	EESIPR_PREIP = 2,
	EESIPR_CERFIP = 1,
};

enum EESR_BIT {
	EESR_TWB1 = 2147483648,
	EESR_TWB = 1073741824,
	EESR_TC1 = 536870912,
	EESR_TUC = 268435456,
	EESR_ROC = 134217728,
	EESR_TABT = 67108864,
	EESR_RABT = 33554432,
	EESR_RFRMER = 16777216,
	EESR_ADE = 8388608,
	EESR_ECI = 4194304,
	EESR_FTC = 2097152,
	EESR_TDE = 1048576,
	EESR_TFE = 524288,
	EESR_FRC = 262144,
	EESR_RDE = 131072,
	EESR_RFE = 65536,
	EESR_CND = 2048,
	EESR_DLC = 1024,
	EESR_CD = 512,
	EESR_TRO = 256,
	EESR_RMAF = 128,
	EESR_CEEF = 64,
	EESR_CELF = 32,
	EESR_RRF = 16,
	EESR_RTLF = 8,
	EESR_RTSF = 4,
	EESR_PRE = 2,
	EESR_CERF = 1,
};

enum EIS_BIT {
	EIS_MREF = 1,
	EIS_MTEF = 2,
	EIS_QEF = 4,
	EIS_SEF = 8,
	EIS_CLLF0 = 16,
	EIS_CLLF1 = 32,
	EIS_CULF0 = 64,
	EIS_CULF1 = 128,
	EIS_TFFF = 256,
	EIS_QFS = 65536,
	EIS_RESERVED = 4294899712,
};

enum EXT_INFO_DS_BIT {
	TXC = 16384,
};

enum FCFTR_BIT {
	FCFTR_RFF2 = 262144,
	FCFTR_RFF1 = 131072,
	FCFTR_RFF0 = 65536,
	FCFTR_RFD2 = 4,
	FCFTR_RFD1 = 2,
	FCFTR_RFD0 = 1,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum GCCR_BIT {
	GCCR_TCR = 3,
	GCCR_TCR_NOREQ = 0,
	GCCR_TCR_RESET = 1,
	GCCR_TCR_CAPTURE = 3,
	GCCR_LTO = 4,
	GCCR_LTI = 8,
	GCCR_LPTC = 16,
	GCCR_LMTT = 32,
	GCCR_TCSS = 768,
	GCCR_TCSS_GPTP = 0,
	GCCR_TCSS_ADJGPTP = 256,
	GCCR_TCSS_AVTP = 512,
};

enum GECMR_BIT {
	GECMR_10 = 0,
	GECMR_100 = 4,
	GECMR_1000 = 1,
};

enum GECMR_BIT___2 {
	GECMR_SPEED = 1,
	GECMR_SPEED_100 = 0,
	GECMR_SPEED_1000 = 1,
	GBETH_GECMR_SPEED = 48,
	GBETH_GECMR_SPEED_10 = 0,
	GBETH_GECMR_SPEED_100 = 16,
	GBETH_GECMR_SPEED_1000 = 32,
};

enum GIC_BIT {
	GIC_PTCE = 1,
	GIC_PTME = 4,
};

enum GID_BIT {
	GID_PTCD = 1,
	GID_PTOD = 2,
	GID_PTMD0 = 4,
	GID_PTMD1 = 8,
	GID_PTMD2 = 16,
	GID_PTMD3 = 32,
	GID_PTMD4 = 64,
	GID_PTMD5 = 128,
	GID_PTMD6 = 256,
	GID_PTMD7 = 512,
	GID_ATCD0 = 65536,
	GID_ATCD1 = 131072,
	GID_ATCD2 = 262144,
	GID_ATCD3 = 524288,
	GID_ATCD4 = 1048576,
	GID_ATCD5 = 2097152,
	GID_ATCD6 = 4194304,
	GID_ATCD7 = 8388608,
	GID_ATCD8 = 16777216,
	GID_ATCD9 = 33554432,
	GID_ATCD10 = 67108864,
	GID_ATCD11 = 134217728,
	GID_ATCD12 = 268435456,
	GID_ATCD13 = 536870912,
	GID_ATCD14 = 1073741824,
	GID_ATCD15 = 2147483648,
};

enum GIE_BIT {
	GIE_PTCS = 1,
	GIE_PTOS = 2,
	GIE_PTMS0 = 4,
	GIE_PTMS1 = 8,
	GIE_PTMS2 = 16,
	GIE_PTMS3 = 32,
	GIE_PTMS4 = 64,
	GIE_PTMS5 = 128,
	GIE_PTMS6 = 256,
	GIE_PTMS7 = 512,
	GIE_ATCS0 = 65536,
	GIE_ATCS1 = 131072,
	GIE_ATCS2 = 262144,
	GIE_ATCS3 = 524288,
	GIE_ATCS4 = 1048576,
	GIE_ATCS5 = 2097152,
	GIE_ATCS6 = 4194304,
	GIE_ATCS7 = 8388608,
	GIE_ATCS8 = 16777216,
	GIE_ATCS9 = 33554432,
	GIE_ATCS10 = 67108864,
	GIE_ATCS11 = 134217728,
	GIE_ATCS12 = 268435456,
	GIE_ATCS13 = 536870912,
	GIE_ATCS14 = 1073741824,
	GIE_ATCS15 = 2147483648,
};

enum GIS_BIT {
	GIS_PTCF = 1,
	GIS_PTMF = 4,
	GIS_RESERVED = 64512,
};

enum GTI_BIT {
	GTI_TIV = 268435455,
};

enum HCLGE_COMM_API_CAP_BITS {
	HCLGE_COMM_API_CAP_FLEX_RSS_TBL_B = 0,
};

enum HCLGE_COMM_CAP_BITS {
	HCLGE_COMM_CAP_UDP_GSO_B = 0,
	HCLGE_COMM_CAP_QB_B = 1,
	HCLGE_COMM_CAP_FD_FORWARD_TC_B = 2,
	HCLGE_COMM_CAP_PTP_B = 3,
	HCLGE_COMM_CAP_INT_QL_B = 4,
	HCLGE_COMM_CAP_HW_TX_CSUM_B = 5,
	HCLGE_COMM_CAP_TX_PUSH_B = 6,
	HCLGE_COMM_CAP_PHY_IMP_B = 7,
	HCLGE_COMM_CAP_TQP_TXRX_INDEP_B = 8,
	HCLGE_COMM_CAP_HW_PAD_B = 9,
	HCLGE_COMM_CAP_STASH_B = 10,
	HCLGE_COMM_CAP_UDP_TUNNEL_CSUM_B = 11,
	HCLGE_COMM_CAP_RAS_IMP_B = 12,
	HCLGE_COMM_CAP_FEC_B = 13,
	HCLGE_COMM_CAP_PAUSE_B = 14,
	HCLGE_COMM_CAP_RXD_ADV_LAYOUT_B = 15,
	HCLGE_COMM_CAP_PORT_VLAN_BYPASS_B = 17,
	HCLGE_COMM_CAP_CQ_B = 18,
	HCLGE_COMM_CAP_GRO_B = 20,
	HCLGE_COMM_CAP_FD_B = 21,
	HCLGE_COMM_CAP_FEC_STATS_B = 25,
	HCLGE_COMM_CAP_VF_FAULT_B = 26,
	HCLGE_COMM_CAP_LANE_NUM_B = 27,
	HCLGE_COMM_CAP_WOL_B = 28,
	HCLGE_COMM_CAP_TM_FLUSH_B = 31,
	HCLGE_COMM_CAP_ERR_MOD_GEN_REG_B = 32,
};

enum HCLGE_DEV_STATE {
	HCLGE_STATE_REINITING = 0,
	HCLGE_STATE_DOWN = 1,
	HCLGE_STATE_DISABLED = 2,
	HCLGE_STATE_REMOVING = 3,
	HCLGE_STATE_NIC_REGISTERED = 4,
	HCLGE_STATE_ROCE_REGISTERED = 5,
	HCLGE_STATE_SERVICE_INITED = 6,
	HCLGE_STATE_RST_SERVICE_SCHED = 7,
	HCLGE_STATE_RST_HANDLING = 8,
	HCLGE_STATE_MBX_SERVICE_SCHED = 9,
	HCLGE_STATE_MBX_HANDLING = 10,
	HCLGE_STATE_ERR_SERVICE_SCHED = 11,
	HCLGE_STATE_STATISTICS_UPDATING = 12,
	HCLGE_STATE_LINK_UPDATING = 13,
	HCLGE_STATE_RST_FAIL = 14,
	HCLGE_STATE_FD_TBL_CHANGED = 15,
	HCLGE_STATE_FD_CLEAR_ALL = 16,
	HCLGE_STATE_FD_USER_DEF_CHANGED = 17,
	HCLGE_STATE_PTP_EN = 18,
	HCLGE_STATE_PTP_TX_HANDLING = 19,
	HCLGE_STATE_FEC_STATS_UPDATING = 20,
	HCLGE_STATE_MAX = 21,
};

enum HCLGE_FD_ACTION {
	HCLGE_FD_ACTION_SELECT_QUEUE = 0,
	HCLGE_FD_ACTION_DROP_PACKET = 1,
	HCLGE_FD_ACTION_SELECT_TC = 2,
};

enum HCLGE_FD_ACTIVE_RULE_TYPE {
	HCLGE_FD_RULE_NONE = 0,
	HCLGE_FD_ARFS_ACTIVE = 1,
	HCLGE_FD_EP_ACTIVE = 2,
	HCLGE_FD_TC_FLOWER_ACTIVE = 3,
};

enum HCLGE_FD_KEY_OPT {
	KEY_OPT_U8 = 0,
	KEY_OPT_LE16 = 1,
	KEY_OPT_LE32 = 2,
	KEY_OPT_MAC = 3,
	KEY_OPT_IP = 4,
	KEY_OPT_VNI = 5,
};

enum HCLGE_FD_KEY_TYPE {
	HCLGE_FD_KEY_BASE_ON_PTYPE = 0,
	HCLGE_FD_KEY_BASE_ON_TUPLE = 1,
};

enum HCLGE_FD_META_DATA {
	PACKET_TYPE_ID = 0,
	IP_FRAGEMENT = 1,
	ROCE_TYPE = 2,
	NEXT_KEY = 3,
	VLAN_NUMBER = 4,
	SRC_VPORT = 5,
	DST_VPORT = 6,
	TUNNEL_PACKET = 7,
	MAX_META_DATA = 8,
};

enum HCLGE_FD_MODE {
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_400B_STAGE_1 = 0,
	HCLGE_FD_MODE_DEPTH_1K_WIDTH_400B_STAGE_2 = 1,
	HCLGE_FD_MODE_DEPTH_4K_WIDTH_200B_STAGE_1 = 2,
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_200B_STAGE_2 = 3,
};

enum HCLGE_FD_NODE_STATE {
	HCLGE_FD_TO_ADD = 0,
	HCLGE_FD_TO_DEL = 1,
	HCLGE_FD_ACTIVE = 2,
	HCLGE_FD_DELETED = 3,
};

enum HCLGE_FD_PACKET_TYPE {
	NIC_PACKET = 0,
	ROCE_PACKET = 1,
};

enum HCLGE_FD_STAGE {
	HCLGE_FD_STAGE_1 = 0,
	HCLGE_FD_STAGE_2 = 1,
	MAX_STAGE_NUM = 2,
};

enum HCLGE_FD_TUPLE {
	OUTER_DST_MAC = 0,
	OUTER_SRC_MAC = 1,
	OUTER_VLAN_TAG_FST = 2,
	OUTER_VLAN_TAG_SEC = 3,
	OUTER_ETH_TYPE = 4,
	OUTER_L2_RSV = 5,
	OUTER_IP_TOS = 6,
	OUTER_IP_PROTO = 7,
	OUTER_SRC_IP = 8,
	OUTER_DST_IP = 9,
	OUTER_L3_RSV = 10,
	OUTER_SRC_PORT = 11,
	OUTER_DST_PORT = 12,
	OUTER_L4_RSV = 13,
	OUTER_TUN_VNI = 14,
	OUTER_TUN_FLOW_ID = 15,
	INNER_DST_MAC = 16,
	INNER_SRC_MAC = 17,
	INNER_VLAN_TAG_FST = 18,
	INNER_VLAN_TAG_SEC = 19,
	INNER_ETH_TYPE = 20,
	INNER_L2_RSV = 21,
	INNER_IP_TOS = 22,
	INNER_IP_PROTO = 23,
	INNER_SRC_IP = 24,
	INNER_DST_IP = 25,
	INNER_L3_RSV = 26,
	INNER_SRC_PORT = 27,
	INNER_DST_PORT = 28,
	INNER_L4_RSV = 29,
	MAX_TUPLE = 30,
};

enum HCLGE_FD_USER_DEF_LAYER {
	HCLGE_FD_USER_DEF_NONE = 0,
	HCLGE_FD_USER_DEF_L2 = 1,
	HCLGE_FD_USER_DEF_L3 = 2,
	HCLGE_FD_USER_DEF_L4 = 3,
};

enum HCLGE_FIRMWARE_MAC_SPEED {
	HCLGE_FW_MAC_SPEED_1G = 0,
	HCLGE_FW_MAC_SPEED_10G = 1,
	HCLGE_FW_MAC_SPEED_25G = 2,
	HCLGE_FW_MAC_SPEED_40G = 3,
	HCLGE_FW_MAC_SPEED_50G = 4,
	HCLGE_FW_MAC_SPEED_100G = 5,
	HCLGE_FW_MAC_SPEED_10M = 6,
	HCLGE_FW_MAC_SPEED_100M = 7,
	HCLGE_FW_MAC_SPEED_200G = 8,
};

enum HCLGE_MAC_ADDR_TYPE {
	HCLGE_MAC_ADDR_UC = 0,
	HCLGE_MAC_ADDR_MC = 1,
};

enum HCLGE_MAC_DUPLEX {
	HCLGE_MAC_HALF = 0,
	HCLGE_MAC_FULL = 1,
};

enum HCLGE_MAC_NODE_STATE {
	HCLGE_MAC_TO_ADD = 0,
	HCLGE_MAC_TO_DEL = 1,
	HCLGE_MAC_ACTIVE = 2,
};

enum HCLGE_MAC_SPEED {
	HCLGE_MAC_SPEED_UNKNOWN = 0,
	HCLGE_MAC_SPEED_10M = 10,
	HCLGE_MAC_SPEED_100M = 100,
	HCLGE_MAC_SPEED_1G = 1000,
	HCLGE_MAC_SPEED_10G = 10000,
	HCLGE_MAC_SPEED_25G = 25000,
	HCLGE_MAC_SPEED_40G = 40000,
	HCLGE_MAC_SPEED_50G = 50000,
	HCLGE_MAC_SPEED_100G = 100000,
	HCLGE_MAC_SPEED_200G = 200000,
};

enum HCLGE_MBX_OPCODE {
	HCLGE_MBX_RESET = 1,
	HCLGE_MBX_ASSERTING_RESET = 2,
	HCLGE_MBX_SET_UNICAST = 3,
	HCLGE_MBX_SET_MULTICAST = 4,
	HCLGE_MBX_SET_VLAN = 5,
	HCLGE_MBX_MAP_RING_TO_VECTOR = 6,
	HCLGE_MBX_UNMAP_RING_TO_VECTOR = 7,
	HCLGE_MBX_SET_PROMISC_MODE = 8,
	HCLGE_MBX_SET_MACVLAN = 9,
	HCLGE_MBX_API_NEGOTIATE = 10,
	HCLGE_MBX_GET_QINFO = 11,
	HCLGE_MBX_GET_QDEPTH = 12,
	HCLGE_MBX_GET_BASIC_INFO = 13,
	HCLGE_MBX_GET_RETA = 14,
	HCLGE_MBX_GET_RSS_KEY = 15,
	HCLGE_MBX_GET_MAC_ADDR = 16,
	HCLGE_MBX_PF_VF_RESP = 17,
	HCLGE_MBX_GET_BDNUM = 18,
	HCLGE_MBX_GET_BUFSIZE = 19,
	HCLGE_MBX_GET_STREAMID = 20,
	HCLGE_MBX_SET_AESTART = 21,
	HCLGE_MBX_SET_TSOSTATS = 22,
	HCLGE_MBX_LINK_STAT_CHANGE = 23,
	HCLGE_MBX_GET_BASE_CONFIG = 24,
	HCLGE_MBX_BIND_FUNC_QUEUE = 25,
	HCLGE_MBX_GET_LINK_STATUS = 26,
	HCLGE_MBX_QUEUE_RESET = 27,
	HCLGE_MBX_KEEP_ALIVE = 28,
	HCLGE_MBX_SET_ALIVE = 29,
	HCLGE_MBX_SET_MTU = 30,
	HCLGE_MBX_GET_QID_IN_PF = 31,
	HCLGE_MBX_LINK_STAT_MODE = 32,
	HCLGE_MBX_GET_LINK_MODE = 33,
	HCLGE_MBX_PUSH_VLAN_INFO = 34,
	HCLGE_MBX_GET_MEDIA_TYPE = 35,
	HCLGE_MBX_PUSH_PROMISC_INFO = 36,
	HCLGE_MBX_VF_UNINIT = 37,
	HCLGE_MBX_HANDLE_VF_TBL = 38,
	HCLGE_MBX_GET_RING_VECTOR_MAP = 39,
	HCLGE_MBX_GET_VF_FLR_STATUS = 200,
	HCLGE_MBX_PUSH_LINK_STATUS = 201,
	HCLGE_MBX_NCSI_ERROR = 202,
};

enum HCLGE_VPORT_NEED_NOTIFY {
	HCLGE_VPORT_NEED_NOTIFY_RESET = 0,
	HCLGE_VPORT_NEED_NOTIFY_VF_VLAN = 1,
};

enum HCLGE_VPORT_STATE {
	HCLGE_VPORT_STATE_ALIVE = 0,
	HCLGE_VPORT_STATE_MAC_TBL_CHANGE = 1,
	HCLGE_VPORT_STATE_PROMISC_CHANGE = 2,
	HCLGE_VPORT_STATE_VLAN_FLTR_CHANGE = 3,
	HCLGE_VPORT_STATE_INITED = 4,
	HCLGE_VPORT_STATE_MAX = 5,
};

enum HLCGE_PORT_TYPE {
	HOST_PORT = 0,
	NETWORK_PORT = 1,
};

enum HNAE3_DEV_CAP_BITS {
	HNAE3_DEV_SUPPORT_FD_B = 0,
	HNAE3_DEV_SUPPORT_GRO_B = 1,
	HNAE3_DEV_SUPPORT_FEC_B = 2,
	HNAE3_DEV_SUPPORT_UDP_GSO_B = 3,
	HNAE3_DEV_SUPPORT_QB_B = 4,
	HNAE3_DEV_SUPPORT_FD_FORWARD_TC_B = 5,
	HNAE3_DEV_SUPPORT_PTP_B = 6,
	HNAE3_DEV_SUPPORT_INT_QL_B = 7,
	HNAE3_DEV_SUPPORT_HW_TX_CSUM_B = 8,
	HNAE3_DEV_SUPPORT_TX_PUSH_B = 9,
	HNAE3_DEV_SUPPORT_PHY_IMP_B = 10,
	HNAE3_DEV_SUPPORT_TQP_TXRX_INDEP_B = 11,
	HNAE3_DEV_SUPPORT_HW_PAD_B = 12,
	HNAE3_DEV_SUPPORT_STASH_B = 13,
	HNAE3_DEV_SUPPORT_UDP_TUNNEL_CSUM_B = 14,
	HNAE3_DEV_SUPPORT_PAUSE_B = 15,
	HNAE3_DEV_SUPPORT_RAS_IMP_B = 16,
	HNAE3_DEV_SUPPORT_RXD_ADV_LAYOUT_B = 17,
	HNAE3_DEV_SUPPORT_PORT_VLAN_BYPASS_B = 18,
	HNAE3_DEV_SUPPORT_VLAN_FLTR_MDF_B = 19,
	HNAE3_DEV_SUPPORT_MC_MAC_MNG_B = 20,
	HNAE3_DEV_SUPPORT_CQ_B = 21,
	HNAE3_DEV_SUPPORT_FEC_STATS_B = 22,
	HNAE3_DEV_SUPPORT_LANE_NUM_B = 23,
	HNAE3_DEV_SUPPORT_WOL_B = 24,
	HNAE3_DEV_SUPPORT_TM_FLUSH_B = 25,
	HNAE3_DEV_SUPPORT_VF_FAULT_B = 26,
	HNAE3_DEV_SUPPORT_ERR_MOD_GEN_REG_B = 27,
};

enum HNAE3_PF_CAP_BITS {
	HNAE3_PF_SUPPORT_VLAN_FLTR_MDF_B = 0,
};

enum I2C_REGS_OFFSET {
	OFFSET_DATA_PORT = 0,
	OFFSET_SLAVE_ADDR = 1,
	OFFSET_INTR_MASK = 2,
	OFFSET_INTR_STAT = 3,
	OFFSET_CONTROL = 4,
	OFFSET_TRANSFER_LEN = 5,
	OFFSET_TRANSAC_LEN = 6,
	OFFSET_DELAY_LEN = 7,
	OFFSET_TIMING = 8,
	OFFSET_START = 9,
	OFFSET_EXT_CONF = 10,
	OFFSET_FIFO_STAT = 11,
	OFFSET_FIFO_THRESH = 12,
	OFFSET_FIFO_ADDR_CLR = 13,
	OFFSET_IO_CONFIG = 14,
	OFFSET_RSV_DEBUG = 15,
	OFFSET_HS = 16,
	OFFSET_SOFTRESET = 17,
	OFFSET_DCM_EN = 18,
	OFFSET_MULTI_DMA = 19,
	OFFSET_PATH_DIR = 20,
	OFFSET_DEBUGSTAT = 21,
	OFFSET_DEBUGCTRL = 22,
	OFFSET_TRANSFER_LEN_AUX = 23,
	OFFSET_CLOCK_DIV = 24,
	OFFSET_LTIMING = 25,
	OFFSET_SCL_HIGH_LOW_RATIO = 26,
	OFFSET_HS_SCL_HIGH_LOW_RATIO = 27,
	OFFSET_SCL_MIS_COMP_POINT = 28,
	OFFSET_STA_STO_AC_TIMING = 29,
	OFFSET_HS_STA_STO_AC_TIMING = 30,
	OFFSET_SDA_TIMING = 31,
};

enum ISS_BIT {
	ISS_FRS = 1,
	ISS_FTS = 4,
	ISS_ES = 64,
	ISS_MS = 128,
	ISS_TFUS = 256,
	ISS_TFWS = 512,
	ISS_RFWS = 4096,
	ISS_CGIS = 8192,
	ISS_DPS1 = 131072,
	ISS_DPS2 = 262144,
	ISS_DPS3 = 524288,
	ISS_DPS4 = 1048576,
	ISS_DPS5 = 2097152,
	ISS_DPS6 = 4194304,
	ISS_DPS7 = 8388608,
	ISS_DPS8 = 16777216,
	ISS_DPS9 = 33554432,
	ISS_DPS10 = 67108864,
	ISS_DPS11 = 134217728,
	ISS_DPS12 = 268435456,
	ISS_DPS13 = 536870912,
	ISS_DPS14 = 1073741824,
	ISS_DPS15 = 2147483648,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum MAX77686_RTC_OP {
	MAX77686_RTC_WRITE = 0,
	MAX77686_RTC_READ = 1,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum MSC_BIT {
	MSC_CRC = 1,
	MSC_RFE = 2,
	MSC_RTSF = 4,
	MSC_RTLF = 8,
	MSC_FRE = 16,
	MSC_CRL = 32,
	MSC_CEEF = 64,
	MSC_MC = 128,
};

enum MT6323_IRQ_STATUS_numbers {
	MT6323_IRQ_STATUS_SPKL_AB = 0,
	MT6323_IRQ_STATUS_SPKL = 1,
	MT6323_IRQ_STATUS_BAT_L = 2,
	MT6323_IRQ_STATUS_BAT_H = 3,
	MT6323_IRQ_STATUS_WATCHDOG = 4,
	MT6323_IRQ_STATUS_PWRKEY = 5,
	MT6323_IRQ_STATUS_THR_L = 6,
	MT6323_IRQ_STATUS_THR_H = 7,
	MT6323_IRQ_STATUS_VBATON_UNDET = 8,
	MT6323_IRQ_STATUS_BVALID_DET = 9,
	MT6323_IRQ_STATUS_CHRDET = 10,
	MT6323_IRQ_STATUS_OV = 11,
	MT6323_IRQ_STATUS_LDO = 16,
	MT6323_IRQ_STATUS_FCHRKEY = 17,
	MT6323_IRQ_STATUS_ACCDET = 18,
	MT6323_IRQ_STATUS_AUDIO = 19,
	MT6323_IRQ_STATUS_RTC = 20,
	MT6323_IRQ_STATUS_VPROC = 21,
	MT6323_IRQ_STATUS_VSYS = 22,
	MT6323_IRQ_STATUS_VPA = 23,
	MT6323_IRQ_STATUS_NR = 24,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum Opt_errors {
	Opt_errors_continue = 0,
	Opt_errors_panic = 1,
};

enum PIR_BIT {
	PIR_MDI = 8,
	PIR_MDO = 4,
	PIR_MMD = 2,
	PIR_MDC = 1,
};

enum PIR_BIT___2 {
	PIR_MDC___2 = 1,
	PIR_MMD___2 = 2,
	PIR_MDO___2 = 4,
	PIR_MDI___2 = 8,
};

enum PSR_BIT {
	PSR_LMON = 1,
};

enum RAVB_QUEUE {
	RAVB_BE = 0,
	RAVB_NC = 1,
};

enum RCR_BIT {
	RCR_EFFS = 1,
	RCR_ENCF = 2,
	RCR_ESF = 12,
	RCR_ETS0 = 16,
	RCR_ETS2 = 32,
	RCR_RFCL = 536805376,
};

enum RD_LEN_BIT {
	RD_RFL = 65535,
	RD_RBL = 4294901760,
};

enum RD_STS_BIT {
	RD_RACT = 2147483648,
	RD_RDLE = 1073741824,
	RD_RFP1 = 536870912,
	RD_RFP0 = 268435456,
	RD_RFE = 134217728,
	RD_RFS10 = 512,
	RD_RFS9 = 256,
	RD_RFS8 = 128,
	RD_RFS7 = 64,
	RD_RFS6 = 32,
	RD_RFS5 = 16,
	RD_RFS4 = 8,
	RD_RFS3 = 4,
	RD_RFS2 = 2,
	RD_RFS1 = 1,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum RIC0_BIT {
	RIC0_FRE0 = 1,
	RIC0_FRE1 = 2,
	RIC0_FRE2 = 4,
	RIC0_FRE3 = 8,
	RIC0_FRE4 = 16,
	RIC0_FRE5 = 32,
	RIC0_FRE6 = 64,
	RIC0_FRE7 = 128,
	RIC0_FRE8 = 256,
	RIC0_FRE9 = 512,
	RIC0_FRE10 = 1024,
	RIC0_FRE11 = 2048,
	RIC0_FRE12 = 4096,
	RIC0_FRE13 = 8192,
	RIC0_FRE14 = 16384,
	RIC0_FRE15 = 32768,
	RIC0_FRE16 = 65536,
	RIC0_FRE17 = 131072,
};

enum RIC2_BIT {
	RIC2_QFE0 = 1,
	RIC2_QFE1 = 2,
	RIC2_QFE2 = 4,
	RIC2_QFE3 = 8,
	RIC2_QFE4 = 16,
	RIC2_QFE5 = 32,
	RIC2_QFE6 = 64,
	RIC2_QFE7 = 128,
	RIC2_QFE8 = 256,
	RIC2_QFE9 = 512,
	RIC2_QFE10 = 1024,
	RIC2_QFE11 = 2048,
	RIC2_QFE12 = 4096,
	RIC2_QFE13 = 8192,
	RIC2_QFE14 = 16384,
	RIC2_QFE15 = 32768,
	RIC2_QFE16 = 65536,
	RIC2_QFE17 = 131072,
	RIC2_RFFE = 2147483648,
};

enum RIS0_BIT {
	RIS0_FRF0 = 1,
	RIS0_FRF1 = 2,
	RIS0_FRF2 = 4,
	RIS0_FRF3 = 8,
	RIS0_FRF4 = 16,
	RIS0_FRF5 = 32,
	RIS0_FRF6 = 64,
	RIS0_FRF7 = 128,
	RIS0_FRF8 = 256,
	RIS0_FRF9 = 512,
	RIS0_FRF10 = 1024,
	RIS0_FRF11 = 2048,
	RIS0_FRF12 = 4096,
	RIS0_FRF13 = 8192,
	RIS0_FRF14 = 16384,
	RIS0_FRF15 = 32768,
	RIS0_FRF16 = 65536,
	RIS0_FRF17 = 131072,
	RIS0_RESERVED = 4294705152,
};

enum RIS2_BIT {
	RIS2_QFF0 = 1,
	RIS2_QFF1 = 2,
	RIS2_QFF2 = 4,
	RIS2_QFF3 = 8,
	RIS2_QFF4 = 16,
	RIS2_QFF5 = 32,
	RIS2_QFF6 = 64,
	RIS2_QFF7 = 128,
	RIS2_QFF8 = 256,
	RIS2_QFF9 = 512,
	RIS2_QFF10 = 1024,
	RIS2_QFF11 = 2048,
	RIS2_QFF12 = 4096,
	RIS2_QFF13 = 8192,
	RIS2_QFF14 = 16384,
	RIS2_QFF15 = 32768,
	RIS2_QFF16 = 65536,
	RIS2_QFF17 = 131072,
	RIS2_RFFF = 2147483648,
	RIS2_RESERVED = 2147221504,
};

enum RMCR_BIT {
	RMCR_RNC = 1,
};

enum RX_DS_CC_BIT {
	RX_DS = 4095,
	RX_TR = 4096,
	RX_EI = 8192,
	RX_PS = 49152,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum S2MPU02_regulators {
	S2MPU02_LDO1 = 0,
	S2MPU02_LDO2 = 1,
	S2MPU02_LDO3 = 2,
	S2MPU02_LDO4 = 3,
	S2MPU02_LDO5 = 4,
	S2MPU02_LDO6 = 5,
	S2MPU02_LDO7 = 6,
	S2MPU02_LDO8 = 7,
	S2MPU02_LDO9 = 8,
	S2MPU02_LDO10 = 9,
	S2MPU02_LDO11 = 10,
	S2MPU02_LDO12 = 11,
	S2MPU02_LDO13 = 12,
	S2MPU02_LDO14 = 13,
	S2MPU02_LDO15 = 14,
	S2MPU02_LDO16 = 15,
	S2MPU02_LDO17 = 16,
	S2MPU02_LDO18 = 17,
	S2MPU02_LDO19 = 18,
	S2MPU02_LDO20 = 19,
	S2MPU02_LDO21 = 20,
	S2MPU02_LDO22 = 21,
	S2MPU02_LDO23 = 22,
	S2MPU02_LDO24 = 23,
	S2MPU02_LDO25 = 24,
	S2MPU02_LDO26 = 25,
	S2MPU02_LDO27 = 26,
	S2MPU02_LDO28 = 27,
	S2MPU02_BUCK1 = 28,
	S2MPU02_BUCK2 = 29,
	S2MPU02_BUCK3 = 30,
	S2MPU02_BUCK4 = 31,
	S2MPU02_BUCK5 = 32,
	S2MPU02_BUCK6 = 33,
	S2MPU02_BUCK7 = 34,
	S2MPU02_REGULATOR_MAX = 35,
};

enum S2MPU05_reg {
	S2MPU05_REG_ID = 0,
	S2MPU05_REG_INT1 = 1,
	S2MPU05_REG_INT2 = 2,
	S2MPU05_REG_INT3 = 3,
	S2MPU05_REG_INT1M = 4,
	S2MPU05_REG_INT2M = 5,
	S2MPU05_REG_INT3M = 6,
	S2MPU05_REG_ST1 = 7,
	S2MPU05_REG_ST2 = 8,
	S2MPU05_REG_PWRONSRC = 9,
	S2MPU05_REG_OFFSRC = 10,
	S2MPU05_REG_BU_CHG = 11,
	S2MPU05_REG_RTC_BUF = 12,
	S2MPU05_REG_CTRL1 = 13,
	S2MPU05_REG_CTRL2 = 14,
	S2MPU05_REG_ETC_TEST = 15,
	S2MPU05_REG_OTP_ADRL = 16,
	S2MPU05_REG_OTP_ADRH = 17,
	S2MPU05_REG_OTP_DATA = 18,
	S2MPU05_REG_MON1SEL = 19,
	S2MPU05_REG_MON2SEL = 20,
	S2MPU05_REG_CTRL3 = 21,
	S2MPU05_REG_ETC_OTP = 22,
	S2MPU05_REG_UVLO = 23,
	S2MPU05_REG_TIME_CTRL1 = 24,
	S2MPU05_REG_TIME_CTRL2 = 25,
	S2MPU05_REG_B1CTRL1 = 26,
	S2MPU05_REG_B1CTRL2 = 27,
	S2MPU05_REG_B2CTRL1 = 28,
	S2MPU05_REG_B2CTRL2 = 29,
	S2MPU05_REG_B2CTRL3 = 30,
	S2MPU05_REG_B2CTRL4 = 31,
	S2MPU05_REG_B3CTRL1 = 32,
	S2MPU05_REG_B3CTRL2 = 33,
	S2MPU05_REG_B3CTRL3 = 34,
	S2MPU05_REG_B4CTRL1 = 35,
	S2MPU05_REG_B4CTRL2 = 36,
	S2MPU05_REG_B5CTRL1 = 37,
	S2MPU05_REG_B5CTRL2 = 38,
	S2MPU05_REG_BUCK_RAMP = 39,
	S2MPU05_REG_LDO_DVS1 = 40,
	S2MPU05_REG_LDO_DVS9 = 41,
	S2MPU05_REG_LDO_DVS10 = 42,
	S2MPU05_REG_L1CTRL = 43,
	S2MPU05_REG_L2CTRL = 44,
	S2MPU05_REG_L3CTRL = 45,
	S2MPU05_REG_L4CTRL = 46,
	S2MPU05_REG_L5CTRL = 47,
	S2MPU05_REG_L6CTRL = 48,
	S2MPU05_REG_L7CTRL = 49,
	S2MPU05_REG_L8CTRL = 50,
	S2MPU05_REG_L9CTRL1 = 51,
	S2MPU05_REG_L9CTRL2 = 52,
	S2MPU05_REG_L10CTRL = 53,
	S2MPU05_REG_L11CTRL1 = 54,
	S2MPU05_REG_L11CTRL2 = 55,
	S2MPU05_REG_L12CTRL = 56,
	S2MPU05_REG_L13CTRL = 57,
	S2MPU05_REG_L14CTRL = 58,
	S2MPU05_REG_L15CTRL = 59,
	S2MPU05_REG_L16CTRL = 60,
	S2MPU05_REG_L17CTRL1 = 61,
	S2MPU05_REG_L17CTRL2 = 62,
	S2MPU05_REG_L18CTRL1 = 63,
	S2MPU05_REG_L18CTRL2 = 64,
	S2MPU05_REG_L19CTRL = 65,
	S2MPU05_REG_L20CTRL = 66,
	S2MPU05_REG_L21CTRL = 67,
	S2MPU05_REG_L22CTRL = 68,
	S2MPU05_REG_L23CTRL = 69,
	S2MPU05_REG_L24CTRL = 70,
	S2MPU05_REG_L25CTRL = 71,
	S2MPU05_REG_L26CTRL = 72,
	S2MPU05_REG_L27CTRL = 73,
	S2MPU05_REG_L28CTRL = 74,
	S2MPU05_REG_L29CTRL = 75,
	S2MPU05_REG_L30CTRL = 76,
	S2MPU05_REG_L31CTRL = 77,
	S2MPU05_REG_L32CTRL = 78,
	S2MPU05_REG_L33CTRL = 79,
	S2MPU05_REG_L34CTRL = 80,
	S2MPU05_REG_L35CTRL = 81,
	S2MPU05_REG_LDO_DSCH1 = 82,
	S2MPU05_REG_LDO_DSCH2 = 83,
	S2MPU05_REG_LDO_DSCH3 = 84,
	S2MPU05_REG_LDO_DSCH4 = 85,
	S2MPU05_REG_LDO_DSCH5 = 86,
	S2MPU05_REG_LDO_CTRL1 = 87,
	S2MPU05_REG_LDO_CTRL2 = 88,
	S2MPU05_REG_TCXO_CTRL = 89,
	S2MPU05_REG_SELMIF = 90,
};

enum S2MPU05_regulators {
	S2MPU05_LDO1 = 0,
	S2MPU05_LDO2 = 1,
	S2MPU05_LDO3 = 2,
	S2MPU05_LDO4 = 3,
	S2MPU05_LDO5 = 4,
	S2MPU05_LDO6 = 5,
	S2MPU05_LDO7 = 6,
	S2MPU05_LDO8 = 7,
	S2MPU05_LDO9 = 8,
	S2MPU05_LDO10 = 9,
	S2MPU05_LDO11 = 10,
	S2MPU05_LDO12 = 11,
	S2MPU05_LDO13 = 12,
	S2MPU05_LDO14 = 13,
	S2MPU05_LDO15 = 14,
	S2MPU05_LDO16 = 15,
	S2MPU05_LDO17 = 16,
	S2MPU05_LDO18 = 17,
	S2MPU05_LDO19 = 18,
	S2MPU05_LDO20 = 19,
	S2MPU05_LDO21 = 20,
	S2MPU05_LDO22 = 21,
	S2MPU05_LDO23 = 22,
	S2MPU05_LDO24 = 23,
	S2MPU05_LDO25 = 24,
	S2MPU05_LDO26 = 25,
	S2MPU05_LDO27 = 26,
	S2MPU05_LDO28 = 27,
	S2MPU05_LDO29 = 28,
	S2MPU05_LDO30 = 29,
	S2MPU05_LDO31 = 30,
	S2MPU05_LDO32 = 31,
	S2MPU05_LDO33 = 32,
	S2MPU05_LDO34 = 33,
	S2MPU05_LDO35 = 34,
	S2MPU05_BUCK1 = 35,
	S2MPU05_BUCK2 = 36,
	S2MPU05_BUCK3 = 37,
	S2MPU05_BUCK4 = 38,
	S2MPU05_BUCK5 = 39,
	S2MPU05_REGULATOR_MAX = 40,
};

enum SCI_CLKS {
	SCI_FCK = 0,
	SCI_SCK = 1,
	SCI_BRG_INT = 2,
	SCI_SCIF_CLK = 3,
	SCI_NUM_CLKS = 4,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum SS4_PACKET_ID {
	SS4_PACKET_ID_IDLE = 0,
	SS4_PACKET_ID_ONE = 1,
	SS4_PACKET_ID_TWO = 2,
	SS4_PACKET_ID_MULTI = 3,
	SS4_PACKET_ID_STICK = 4,
};

enum TCCR_BIT {
	TCCR_TSRQ0 = 1,
	TCCR_TSRQ1 = 2,
	TCCR_TSRQ2 = 4,
	TCCR_TSRQ3 = 8,
	TCCR_TFEN = 256,
	TCCR_TFR = 512,
};

enum TD_STS_BIT {
	TD_TACT = 2147483648,
	TD_TDLE = 1073741824,
	TD_TFP1 = 536870912,
	TD_TFP0 = 268435456,
	TD_TFE = 134217728,
	TD_TWBI = 67108864,
};

enum TFA2_BIT {
	TFA2_TSV = 65535,
	TFA2_TST = 67043328,
};

enum TGC_BIT {
	TGC_TSM0 = 1,
	TGC_TSM1 = 2,
	TGC_TSM2 = 4,
	TGC_TSM3 = 8,
	TGC_TQP = 48,
	TGC_TQP_NONAVB = 0,
	TGC_TQP_AVBMODE1 = 16,
	TGC_TQP_AVBMODE2 = 48,
	TGC_TBD0 = 768,
	TGC_TBD1 = 12288,
	TGC_TBD2 = 196608,
	TGC_TBD3 = 3145728,
};

enum TIC_BIT {
	TIC_FTE0 = 1,
	TIC_FTE1 = 2,
	TIC_TFUE = 256,
	TIC_TFWE = 512,
};

enum TIS_BIT {
	TIS_FTF0 = 1,
	TIS_FTF1 = 2,
	TIS_TFUF = 256,
	TIS_TFWF = 512,
	TIS_RESERVED = 4293980400,
};

enum TPAUSER_BIT {
	TPAUSER_TPAUSE = 65535,
	TPAUSER_UNLIMITED = 0,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum TRSCER_BIT {
	TRSCER_CNDCE = 2048,
	TRSCER_DLCCE = 1024,
	TRSCER_CDCE = 512,
	TRSCER_TROCE = 256,
	TRSCER_RMAFCE = 128,
	TRSCER_RRFCE = 16,
	TRSCER_RTLFCE = 8,
	TRSCER_RTSFCE = 4,
	TRSCER_PRECE = 2,
	TRSCER_CERFCE = 1,
};

enum TSR_BIT {
	TSR_CCS0 = 3,
	TSR_CCS1 = 12,
	TSR_TFFL = 1792,
};

enum TSU_ADSBSY_BIT {
	TSU_ADSBSY_0 = 1,
};

enum TSU_FWSLC_BIT {
	TSU_FWSLC_POSTENU = 8192,
	TSU_FWSLC_POSTENL = 4096,
	TSU_FWSLC_CAMSEL03 = 128,
	TSU_FWSLC_CAMSEL02 = 64,
	TSU_FWSLC_CAMSEL01 = 32,
	TSU_FWSLC_CAMSEL00 = 16,
	TSU_FWSLC_CAMSEL13 = 8,
	TSU_FWSLC_CAMSEL12 = 4,
	TSU_FWSLC_CAMSEL11 = 2,
	TSU_FWSLC_CAMSEL10 = 1,
};

enum TX_DS_TAGL_BIT {
	TX_DS = 4095,
	TX_TAGL = 61440,
};

enum TX_FS_TAGL_BIT {
	TX_DS___2 = 4095,
	TX_TAGL___2 = 61440,
};

enum TX_TAGH_TSR_BIT {
	TX_TAGH = 63,
	TX_TSR = 64,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum V7_PACKET_ID {
	V7_PACKET_ID_IDLE = 0,
	V7_PACKET_ID_TWO = 1,
	V7_PACKET_ID_MULTI = 2,
	V7_PACKET_ID_NEW = 3,
	V7_PACKET_ID_UNKNOWN = 4,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _dsm_op_index {
	HNS_OP_RESET_FUNC = 1,
	HNS_OP_SERDES_LP_FUNC = 2,
	HNS_OP_LED_SET_FUNC = 3,
	HNS_OP_GET_PORT_TYPE_FUNC = 4,
	HNS_OP_GET_SFP_STAT_FUNC = 5,
	HNS_OP_LOCATE_LED_SET_FUNC = 6,
};

enum _dsm_rst_type {
	HNS_DSAF_RESET_FUNC = 1,
	HNS_PPE_RESET_FUNC = 2,
	HNS_XGE_RESET_FUNC = 4,
	HNS_GE_RESET_FUNC = 5,
	HNS_DSAF_CHN_RESET_FUNC = 6,
	HNS_ROCE_RESET_FUNC = 7,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum altera_pcie_version {
	ALTERA_PCIE_V1 = 0,
	ALTERA_PCIE_V2 = 1,
	ALTERA_PCIE_V3 = 2,
};

enum aqr_fw_src {
	AQR_FW_SRC_NVMEM = 0,
	AQR_FW_SRC_FS = 1,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arch_timer_spi_nr {
	ARCH_TIMER_PHYS_SPI = 0,
	ARCH_TIMER_VIRT_SPI = 1,
	ARCH_TIMER_MAX_TIMER_SPI = 2,
};

enum arm_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum arm_smmu_arch_version {
	ARM_SMMU_V1 = 0,
	ARM_SMMU_V1_64K = 1,
	ARM_SMMU_V2 = 2,
};

enum arm_smmu_cbar_type {
	CBAR_TYPE_S2_TRANS = 0,
	CBAR_TYPE_S1_TRANS_S2_BYPASS = 1,
	CBAR_TYPE_S1_TRANS_S2_FAULT = 2,
	CBAR_TYPE_S1_TRANS_S2_TRANS = 3,
};

enum arm_smmu_context_fmt {
	ARM_SMMU_CTX_FMT_NONE = 0,
	ARM_SMMU_CTX_FMT_AARCH64 = 1,
	ARM_SMMU_CTX_FMT_AARCH32_L = 2,
	ARM_SMMU_CTX_FMT_AARCH32_S = 3,
};

enum arm_smmu_domain_stage {
	ARM_SMMU_DOMAIN_S1 = 0,
	ARM_SMMU_DOMAIN_S2 = 1,
	ARM_SMMU_DOMAIN_NESTED = 2,
};

enum arm_smmu_implementation {
	GENERIC_SMMU = 0,
	ARM_MMU500 = 1,
	CAVIUM_SMMUV2 = 2,
	QCOM_SMMUV2 = 3,
};

enum arm_smmu_s2cr_privcfg {
	S2CR_PRIVCFG_DEFAULT = 0,
	S2CR_PRIVCFG_DIPAN = 1,
	S2CR_PRIVCFG_UNPRIV = 2,
	S2CR_PRIVCFG_PRIV = 3,
};

enum arm_smmu_s2cr_type {
	S2CR_TYPE_TRANS = 0,
	S2CR_TYPE_BYPASS = 1,
	S2CR_TYPE_FAULT = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum asp_netfilt_reg_type {
	ASP_NETFILT_MATCH = 0,
	ASP_NETFILT_MASK = 1,
	ASP_NETFILT_MAX = 2,
};

enum asp_rx_filter_id {
	ASP_RX_FILTER_MDA_PROMISC = 0,
	ASP_RX_FILTER_MDA_ALLMULTI = 1,
	ASP_RX_FILTER_MDA_BROADCAST = 2,
	ASP_RX_FILTER_MDA_OWN_ADDR = 3,
	ASP_RX_FILTER_MDA_RES_MAX = 4,
};

enum asp_rx_net_filter_block {
	ASP_RX_FILTER_NET_L2 = 0,
	ASP_RX_FILTER_NET_L3_0 = 1,
	ASP_RX_FILTER_NET_L3_1 = 2,
	ASP_RX_FILTER_NET_L4 = 3,
	ASP_RX_FILTER_NET_BLOCK_MAX = 4,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_idn {
	QUERY_ATTR_IDN_BOOT_LU_EN = 0,
	QUERY_ATTR_IDN_MAX_HPB_SINGLE_CMD = 1,
	QUERY_ATTR_IDN_POWER_MODE = 2,
	QUERY_ATTR_IDN_ACTIVE_ICC_LVL = 3,
	QUERY_ATTR_IDN_OOO_DATA_EN = 4,
	QUERY_ATTR_IDN_BKOPS_STATUS = 5,
	QUERY_ATTR_IDN_PURGE_STATUS = 6,
	QUERY_ATTR_IDN_MAX_DATA_IN = 7,
	QUERY_ATTR_IDN_MAX_DATA_OUT = 8,
	QUERY_ATTR_IDN_DYN_CAP_NEEDED = 9,
	QUERY_ATTR_IDN_REF_CLK_FREQ = 10,
	QUERY_ATTR_IDN_CONF_DESC_LOCK = 11,
	QUERY_ATTR_IDN_MAX_NUM_OF_RTT = 12,
	QUERY_ATTR_IDN_EE_CONTROL = 13,
	QUERY_ATTR_IDN_EE_STATUS = 14,
	QUERY_ATTR_IDN_SECONDS_PASSED = 15,
	QUERY_ATTR_IDN_CNTX_CONF = 16,
	QUERY_ATTR_IDN_CORR_PRG_BLK_NUM = 17,
	QUERY_ATTR_IDN_RESERVED2 = 18,
	QUERY_ATTR_IDN_RESERVED3 = 19,
	QUERY_ATTR_IDN_FFU_STATUS = 20,
	QUERY_ATTR_IDN_PSA_STATE = 21,
	QUERY_ATTR_IDN_PSA_DATA_SIZE = 22,
	QUERY_ATTR_IDN_REF_CLK_GATING_WAIT_TIME = 23,
	QUERY_ATTR_IDN_CASE_ROUGH_TEMP = 24,
	QUERY_ATTR_IDN_HIGH_TEMP_BOUND = 25,
	QUERY_ATTR_IDN_LOW_TEMP_BOUND = 26,
	QUERY_ATTR_IDN_WB_FLUSH_STATUS = 28,
	QUERY_ATTR_IDN_AVAIL_WB_BUFF_SIZE = 29,
	QUERY_ATTR_IDN_WB_BUFF_LIFE_TIME_EST = 30,
	QUERY_ATTR_IDN_CURR_WB_BUFF_SIZE = 31,
	QUERY_ATTR_IDN_TIMESTAMP = 48,
	QUERY_ATTR_IDN_DEV_LVL_EXCEPTION_ID = 52,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_HINT = 60,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_EN = 61,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_STATUS = 62,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum bam_command_type {
	BAM_WRITE_COMMAND = 0,
	BAM_READ_COMMAND = 1,
};

enum bam_reg {
	BAM_CTRL = 0,
	BAM_REVISION = 1,
	BAM_NUM_PIPES = 2,
	BAM_DESC_CNT_TRSHLD = 3,
	BAM_IRQ_SRCS = 4,
	BAM_IRQ_SRCS_MSK = 5,
	BAM_IRQ_SRCS_UNMASKED = 6,
	BAM_IRQ_STTS = 7,
	BAM_IRQ_CLR = 8,
	BAM_IRQ_EN = 9,
	BAM_CNFG_BITS = 10,
	BAM_IRQ_SRCS_EE = 11,
	BAM_IRQ_SRCS_MSK_EE = 12,
	BAM_P_CTRL = 13,
	BAM_P_RST = 14,
	BAM_P_HALT = 15,
	BAM_P_IRQ_STTS = 16,
	BAM_P_IRQ_CLR = 17,
	BAM_P_IRQ_EN = 18,
	BAM_P_EVNT_DEST_ADDR = 19,
	BAM_P_EVNT_REG = 20,
	BAM_P_SW_OFSTS = 21,
	BAM_P_DATA_FIFO_ADDR = 22,
	BAM_P_DESC_FIFO_ADDR = 23,
	BAM_P_EVNT_GEN_TRSHLD = 24,
	BAM_P_FIFO_SIZES = 25,
};

enum base_type {
	MSPI = 0,
	BSPI = 1,
	CHIP_SELECT = 2,
	BASEMAX = 3,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum bcmasp_stat_type {
	BCMASP_STAT_RX_CTRL = 0,
	BCMASP_STAT_RX_CTRL_PER_INTF = 1,
	BCMASP_STAT_SOFT = 2,
};

enum bd9571mwv_irqs {
	BD9571MWV_IRQ_MD1 = 0,
	BD9571MWV_IRQ_MD2_E1 = 1,
	BD9571MWV_IRQ_MD2_E2 = 2,
	BD9571MWV_IRQ_PROT_ERR = 3,
	BD9571MWV_IRQ_GP = 4,
	BD9571MWV_IRQ_128H_OF = 5,
	BD9571MWV_IRQ_WDT_OF = 6,
	BD9571MWV_IRQ_BKUP_TRG = 7,
};

enum bd9571mwv_regulators {
	VD09 = 0,
	VD18 = 1,
	VD25 = 2,
	VD33 = 3,
	DVFS = 4,
};

enum bdc_ep0_state {
	WAIT_FOR_SETUP = 0,
	WAIT_FOR_DATA_START = 1,
	WAIT_FOR_DATA_XMIT = 2,
	WAIT_FOR_STATUS_START = 3,
	WAIT_FOR_STATUS_XMIT = 4,
	STATUS_PENDING = 5,
};

enum bdc_link_state {
	BDC_LINK_STATE_U0 = 0,
	BDC_LINK_STATE_U3 = 3,
	BDC_LINK_STATE_RX_DET = 5,
	BDC_LINK_STATE_RESUME = 15,
};

enum bdcr_cmd_class {
	BDCR_CMD_UNSPEC = 0,
	BDCR_CMD_MAC_FILTER = 1,
	BDCR_CMD_VLAN_FILTER = 2,
	BDCR_CMD_RSS = 3,
	BDCR_CMD_RFS = 4,
	BDCR_CMD_PORT_GCL = 5,
	BDCR_CMD_RECV_CLASSIFIER = 6,
	BDCR_CMD_STREAM_IDENTIFY = 7,
	BDCR_CMD_STREAM_FILTER = 8,
	BDCR_CMD_STREAM_GCL = 9,
	BDCR_CMD_FLOW_METER = 10,
	__BDCR_CMD_MAX_LEN = 11,
	BDCR_CMD_MAX_LEN = 10,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum bkops_status {
	BKOPS_STATUS_NO_OP = 0,
	BKOPS_STATUS_NON_CRITICAL = 1,
	BKOPS_STATUS_PERF_IMPACT = 2,
	BKOPS_STATUS_CRITICAL = 3,
	BKOPS_STATUS_MAX = 3,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_key_type {
	BLK_CRYPTO_KEY_TYPE_RAW = 1,
	BLK_CRYPTO_KEY_TYPE_HW_WRAPPED = 2,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_req_status {
	REQ_PROCESSING = 0,
	REQ_WAITING = 1,
	REQ_DONE = 2,
	REQ_ERROR = 3,
	REQ_EOPNOTSUPP = 4,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blkif_state {
	BLKIF_STATE_DISCONNECTED = 0,
	BLKIF_STATE_CONNECTED = 1,
	BLKIF_STATE_SUSPENDED = 2,
	BLKIF_STATE_ERROR = 3,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bp_state {
	BP_DONE = 0,
	BP_WAIT = 1,
	BP_EAGAIN = 2,
	BP_ECANCELED = 3,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum bq27xxx_chip {
	BQ27000 = 1,
	BQ27010 = 2,
	BQ2750X = 3,
	BQ2751X = 4,
	BQ2752X = 5,
	BQ27500 = 6,
	BQ27510G1 = 7,
	BQ27510G2 = 8,
	BQ27510G3 = 9,
	BQ27520G1 = 10,
	BQ27520G2 = 11,
	BQ27520G3 = 12,
	BQ27520G4 = 13,
	BQ27521 = 14,
	BQ27530 = 15,
	BQ27531 = 16,
	BQ27541 = 17,
	BQ27542 = 18,
	BQ27546 = 19,
	BQ27742 = 20,
	BQ27545 = 21,
	BQ27411 = 22,
	BQ27421 = 23,
	BQ27425 = 24,
	BQ27426 = 25,
	BQ27441 = 26,
	BQ27621 = 27,
	BQ27Z561 = 28,
	BQ28Z610 = 29,
	BQ34Z100 = 30,
	BQ78Z100 = 31,
};

enum bq27xxx_dm_reg_id {
	BQ27XXX_DM_DESIGN_CAPACITY = 0,
	BQ27XXX_DM_DESIGN_ENERGY = 1,
	BQ27XXX_DM_TERMINATE_VOLTAGE = 2,
};

enum bq27xxx_reg_index {
	BQ27XXX_REG_CTRL = 0,
	BQ27XXX_REG_TEMP = 1,
	BQ27XXX_REG_INT_TEMP = 2,
	BQ27XXX_REG_VOLT = 3,
	BQ27XXX_REG_AI = 4,
	BQ27XXX_REG_FLAGS = 5,
	BQ27XXX_REG_TTE = 6,
	BQ27XXX_REG_TTF = 7,
	BQ27XXX_REG_TTES = 8,
	BQ27XXX_REG_TTECP = 9,
	BQ27XXX_REG_NAC = 10,
	BQ27XXX_REG_RC = 11,
	BQ27XXX_REG_FCC = 12,
	BQ27XXX_REG_CYCT = 13,
	BQ27XXX_REG_AE = 14,
	BQ27XXX_REG_SOC = 15,
	BQ27XXX_REG_DCAP = 16,
	BQ27XXX_REG_AP = 17,
	BQ27XXX_DM_CTRL = 18,
	BQ27XXX_DM_CLASS = 19,
	BQ27XXX_DM_BLOCK = 20,
	BQ27XXX_DM_DATA = 21,
	BQ27XXX_DM_CKSUM = 22,
	BQ27XXX_REG_SEDVF = 23,
	BQ27XXX_REG_PKCFG = 24,
	BQ27XXX_REG_MAX = 25,
};

enum brcm_family_type {
	BRCM_FAMILY_3390A0 = 0,
	BRCM_FAMILY_4908 = 1,
	BRCM_FAMILY_7250B0 = 2,
	BRCM_FAMILY_7271A0 = 3,
	BRCM_FAMILY_7364A0 = 4,
	BRCM_FAMILY_7366C0 = 5,
	BRCM_FAMILY_74371A0 = 6,
	BRCM_FAMILY_7439B0 = 7,
	BRCM_FAMILY_7445D0 = 8,
	BRCM_FAMILY_7260A0 = 9,
	BRCM_FAMILY_7278A0 = 10,
	BRCM_FAMILY_COUNT = 11,
};

enum brcm_sata_phy_rxaeq_mode {
	RXAEQ_MODE_OFF = 0,
	RXAEQ_MODE_AUTO = 1,
	RXAEQ_MODE_MANUAL = 2,
};

enum brcm_sata_phy_version {
	BRCM_SATA_PHY_STB_16NM = 0,
	BRCM_SATA_PHY_STB_28NM = 1,
	BRCM_SATA_PHY_STB_40NM = 2,
	BRCM_SATA_PHY_IPROC_NS2 = 3,
	BRCM_SATA_PHY_IPROC_NSP = 4,
	BRCM_SATA_PHY_IPROC_SR = 5,
	BRCM_SATA_PHY_DSL_28NM = 6,
};

enum brcm_usb_phy_id {
	BRCM_USB_PHY_2_0 = 0,
	BRCM_USB_PHY_3_0 = 1,
	BRCM_USB_PHY_ID_MAX = 2,
};

enum brcmstb_memc_hwtype {
	BRCMSTB_MEMC_V21 = 0,
	BRCMSTB_MEMC_V20 = 1,
	BRCMSTB_MEMC_V1X = 2,
};

enum brcmusb_reg_sel {
	BRCM_REGS_CTRL = 0,
	BRCM_REGS_XHCI_EC = 1,
	BRCM_REGS_XHCI_GBL = 2,
	BRCM_REGS_USB_PHY = 3,
	BRCM_REGS_USB_MDIO = 4,
	BRCM_REGS_BDC_EC = 5,
	BRCM_REGS_MAX = 6,
};

enum bsc_xfer_cmd {
	CMD_WR = 0,
	CMD_RD = 1,
	CMD_WR_NOACK = 2,
	CMD_RD_NOACK = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum buffer_map_state {
	UN_MAPPED = 0,
	PRE_MAPPED = 1,
	MUSB_MAPPED = 2,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum bus_speeds {
	SPD_375K = 0,
	SPD_390K = 1,
	SPD_187K = 2,
	SPD_200K = 3,
	SPD_93K = 4,
	SPD_97K = 5,
	SPD_46K = 6,
	SPD_50K = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cci_ace_port_type {
	ACE_INVALID_PORT = 0,
	ACE_PORT = 1,
	ACE_LITE_PORT = 2,
};

enum cd_types {
	ESDHC_CD_NONE = 0,
	ESDHC_CD_CONTROLLER = 1,
	ESDHC_CD_GPIO = 2,
	ESDHC_CD_PERMANENT = 3,
};

enum cea_audio_coding_types {
	AUDIO_CODING_TYPE_REF_STREAM_HEADER = 0,
	AUDIO_CODING_TYPE_LPCM = 1,
	AUDIO_CODING_TYPE_AC3 = 2,
	AUDIO_CODING_TYPE_MPEG1 = 3,
	AUDIO_CODING_TYPE_MP3 = 4,
	AUDIO_CODING_TYPE_MPEG2 = 5,
	AUDIO_CODING_TYPE_AACLC = 6,
	AUDIO_CODING_TYPE_DTS = 7,
	AUDIO_CODING_TYPE_ATRAC = 8,
	AUDIO_CODING_TYPE_SACD = 9,
	AUDIO_CODING_TYPE_EAC3 = 10,
	AUDIO_CODING_TYPE_DTS_HD = 11,
	AUDIO_CODING_TYPE_MLP = 12,
	AUDIO_CODING_TYPE_DST = 13,
	AUDIO_CODING_TYPE_WMAPRO = 14,
	AUDIO_CODING_TYPE_REF_CXT = 15,
	AUDIO_CODING_TYPE_HE_AAC = 15,
	AUDIO_CODING_TYPE_HE_AAC2 = 16,
	AUDIO_CODING_TYPE_MPEG_SURROUND = 17,
};

enum cea_audio_coding_xtypes {
	AUDIO_CODING_XTYPE_HE_REF_CT = 0,
	AUDIO_CODING_XTYPE_HE_AAC = 1,
	AUDIO_CODING_XTYPE_HE_AAC2 = 2,
	AUDIO_CODING_XTYPE_MPEG_SURROUND = 3,
	AUDIO_CODING_XTYPE_FIRST_RESERVED = 4,
};

enum cfi_quirks {
	CFI_QUIRK_DQ_TRUE_DATA = 1,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_COUNT = 0,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	perf_event_cgrp_id = 7,
	pids_cgrp_id = 8,
	CGROUP_SUBSYS_COUNT = 9,
};

enum ch_command {
	HIDMA_CH_DISABLE = 0,
	HIDMA_CH_ENABLE = 1,
	HIDMA_CH_SUSPEND = 2,
	HIDMA_CH_RESET = 9,
};

enum ch_state {
	HIDMA_CH_DISABLED = 0,
	HIDMA_CH_ENABLED = 1,
	HIDMA_CH_RUNNING = 2,
	HIDMA_CH_SUSPENDED = 3,
	HIDMA_CH_STOPPED = 4,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chip_id {
	MT6323_CHIP_ID = 35,
	MT6328_CHIP_ID = 48,
	MT6331_CHIP_ID = 32,
	MT6332_CHIP_ID = 32,
	MT6357_CHIP_ID = 87,
	MT6358_CHIP_ID = 88,
	MT6359_CHIP_ID = 89,
	MT6366_CHIP_ID = 102,
	MT6391_CHIP_ID = 145,
	MT6397_CHIP_ID = 151,
};

enum chips {
	PFUZE100 = 0,
	PFUZE200 = 1,
	PFUZE3000 = 3,
	PFUZE3001 = 49,
};

enum ci_hw_regs {
	CAP_CAPLENGTH = 0,
	CAP_HCCPARAMS = 1,
	CAP_DCCPARAMS = 2,
	CAP_TESTMODE = 3,
	CAP_LAST = 3,
	OP_USBCMD = 4,
	OP_USBSTS = 5,
	OP_USBINTR = 6,
	OP_FRINDEX = 7,
	OP_DEVICEADDR = 8,
	OP_ENDPTLISTADDR = 9,
	OP_TTCTRL = 10,
	OP_BURSTSIZE = 11,
	OP_ULPI_VIEWPORT = 12,
	OP_PORTSC = 13,
	OP_DEVLC = 14,
	OP_OTGSC = 15,
	OP_USBMODE = 16,
	OP_ENDPTSETUPSTAT = 17,
	OP_ENDPTPRIME = 18,
	OP_ENDPTFLUSH = 19,
	OP_ENDPTSTAT = 20,
	OP_ENDPTCOMPLETE = 21,
	OP_ENDPTCTRL = 22,
	OP_LAST = 38,
};

enum ci_revision {
	CI_REVISION_1X = 10,
	CI_REVISION_20 = 20,
	CI_REVISION_21 = 21,
	CI_REVISION_22 = 22,
	CI_REVISION_23 = 23,
	CI_REVISION_24 = 24,
	CI_REVISION_25 = 25,
	CI_REVISION_25_PLUS = 26,
	CI_REVISION_UNKNOWN = 99,
};

enum ci_role {
	CI_ROLE_HOST = 0,
	CI_ROLE_GADGET = 1,
	CI_ROLE_END = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_gating_state {
	CLKS_OFF = 0,
	CLKS_ON = 1,
	REQ_CLKS_OFF = 2,
	REQ_CLKS_ON = 3,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_id___2 {
	CLK_NONE = 0,
	CLK_MM = 1,
	CLK_MFG = 2,
	CLK_VENC = 3,
	CLK_VENC_LT = 4,
	CLK_ETHIF = 5,
	CLK_VDEC = 6,
	CLK_HIFSEL = 7,
	CLK_JPGDEC = 8,
	CLK_AUDIO = 9,
	CLK_MAX = 10,
};

enum clk_ids {
	LAST_DT_CORE_CLK = 25,
	CLK_EXTAL = 26,
	CLK_MAIN = 27,
	CLK_PLL0 = 28,
	CLK_PLL1 = 29,
	CLK_PLL3 = 30,
	CLK_PLL1_DIV2 = 31,
	MOD_CLK_BASE = 32,
};

enum clk_ids___2 {
	LAST_DT_CORE_CLK___2 = 29,
	CLK_EXTAL___2 = 30,
	CLK_USB_EXTAL = 31,
	CLK_MAIN___2 = 32,
	CLK_PLL0___2 = 33,
	CLK_PLL1___2 = 34,
	CLK_PLL3___2 = 35,
	CLK_PLL1_DIV2___2 = 36,
	MOD_CLK_BASE___2 = 37,
};

enum clk_ids___3 {
	LAST_DT_CORE_CLK___3 = 30,
	CLK_EXTAL___3 = 31,
	CLK_USB_EXTAL___2 = 32,
	CLK_MAIN___3 = 33,
	CLK_PLL0___3 = 34,
	CLK_PLL1___3 = 35,
	CLK_PLL3___3 = 36,
	CLK_PLL1_DIV2___3 = 37,
	MOD_CLK_BASE___3 = 38,
};

enum clk_ids___4 {
	LAST_DT_CORE_CLK___4 = 23,
	CLK_EXTAL___4 = 24,
	CLK_USB_EXTAL___3 = 25,
	CLK_MAIN___4 = 26,
	CLK_PLL0___4 = 27,
	CLK_PLL1___4 = 28,
	CLK_PLL3___4 = 29,
	CLK_PLL1_DIV2___4 = 30,
	MOD_CLK_BASE___4 = 31,
};

enum clk_ids___5 {
	LAST_DT_CORE_CLK___5 = 34,
	CLK_EXTAL___5 = 35,
	CLK_USB_EXTAL___4 = 36,
	CLK_MAIN___5 = 37,
	CLK_PLL0___5 = 38,
	CLK_PLL1___5 = 39,
	CLK_PLL3___5 = 40,
	CLK_PLL1_DIV2___5 = 41,
	MOD_CLK_BASE___5 = 42,
};

enum clk_ids___6 {
	LAST_DT_CORE_CLK___6 = 5,
	CLK_EXTAL___6 = 6,
	CLK_MAIN___6 = 7,
	CLK_PLL = 8,
	MOD_CLK_BASE___6 = 9,
};

enum clk_reg_layout {
	CLK_REG_LAYOUT_RCAR_GEN2_AND_GEN3 = 0,
	CLK_REG_LAYOUT_RZ_A = 1,
	CLK_REG_LAYOUT_RCAR_GEN4 = 2,
};

enum clk_sel {
	LOW_SPEED_IO_SEL = 0,
	NON_IO_SEL = 1,
	FAST_SEL = 2,
	AUDIO_SEL = 3,
	VIDEO_SEL = 4,
	TPM_SEL = 5,
	CKO1_SEL = 6,
	CKO2_SEL = 7,
	MISC_SEL = 8,
	MAX_SEL = 9,
};

enum clk_state {
	CLK_STATE_DISABLE = 0,
	CLK_STATE_ENABLE = 1,
	CLK_STATE_RESERVED = 2,
	CLK_STATE_UNCHANGED = 3,
};

enum clk_types {
	CLK_TYPE_IN = 0,
	CLK_TYPE_FF = 1,
	CLK_TYPE_DIV6P1 = 2,
	CLK_TYPE_DIV6_RO = 3,
	CLK_TYPE_FR = 4,
	CLK_TYPE_CUSTOM = 5,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmd_db_hw_type {
	CMD_DB_HW_INVALID = 0,
	CMD_DB_HW_MIN = 3,
	CMD_DB_HW_ARC = 3,
	CMD_DB_HW_VRM = 4,
	CMD_DB_HW_BCM = 5,
	CMD_DB_HW_MAX = 5,
	CMD_DB_HW_ALL = 255,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum c