(* Warning! This file is generated. Modify at your own risk.
        *)

(** Data definition for API Discovery Service (v1).
  
  For more information about this data model, see the
  {{:https://developers.google.com/discovery/}API Documentation}.
  *)

module JsonSchema :
sig
  module Annotations :
  sig
    type t = {
      required : string list;
      (** A list of methods for which this property is required on requests. *)
      
    }
    
    val required : (t, string list) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Variant :
  sig
    module Map :
    sig
      type t = {
        type_value : string;
        (**  *)
        _ref : string;
        (**  *)
        
      }
      
      val type_value : (t, string) GapiLens.t
      val _ref : (t, string) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      map : Map.t list;
      (** The map of discriminant value to schema to use for parsing.. *)
      discriminant : string;
      (** The name of the type discriminant property. *)
      
    }
    
    val map : (t, Map.t list) GapiLens.t
    val discriminant : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    format : string;
    (** An additional regular expression or key that helps constrain the value. For more details see: http://tools.ietf.org/html/draft-zyp-json-schema-03#section-5.23 *)
    maximum : string;
    (** The maximum value of this parameter. *)
    minimum : string;
    (** The minimum value of this parameter. *)
    enumDeprecated : bool list;
    (** The deprecation status for the enums. Each position maps to the corresponding value in the "enum" array. *)
    pattern : string;
    (** The regular expression this parameter must conform to. Uses Java 6 regex format: http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html *)
    repeated : bool;
    (** Whether this parameter may appear multiple times. *)
    _ref : string;
    (** A reference to another schema. The value of this property is the "id" of another schema. *)
    readOnly : bool;
    (** The value is read-only, generated by the service. The value cannot be modified by the client. If the value is included in a POST, PUT, or PATCH request, it is ignored by the service. *)
    _type : string;
    (** The value type for this schema. A list of values can be found here: http://tools.ietf.org/html/draft-zyp-json-schema-03#section-5.1 *)
    variant : Variant.t;
    (** In a variant data type, the value of one property is used to determine how to interpret the entire entity. Its value must exist in a map of descriminant values to schema names. *)
    required : bool;
    (** Whether the parameter is required. *)
    items : t option;
    (** If this is a schema for an array, this property is the schema for each element in the array. *)
    annotations : Annotations.t;
    (** Additional information about this property. *)
    enumDescriptions : string list;
    (** The descriptions for the enums. Each position maps to the corresponding value in the "enum" array. *)
    location : string;
    (** Whether this parameter goes in the query or the path for REST requests. *)
    default : string;
    (** The default value of this property (if one exists). *)
    description : string;
    (** A description of this object. *)
    deprecated : bool;
    (** Whether the parameter is deprecated. *)
    properties : (string * t) list;
    (** If this is a schema for an object, list the schema for each property of this object. *)
    enum : string list;
    (** Values this parameter may take (if it is an enum). *)
    additionalProperties : t option;
    (** If this is a schema for an object, this property is the schema for any additional properties with dynamic keys on this object. *)
    id : string;
    (** Unique identifier for this schema. *)
    
  }
  
  val format : (t, string) GapiLens.t
  val maximum : (t, string) GapiLens.t
  val minimum : (t, string) GapiLens.t
  val enumDeprecated : (t, bool list) GapiLens.t
  val pattern : (t, string) GapiLens.t
  val repeated : (t, bool) GapiLens.t
  val _ref : (t, string) GapiLens.t
  val readOnly : (t, bool) GapiLens.t
  val _type : (t, string) GapiLens.t
  val variant : (t, Variant.t) GapiLens.t
  val required : (t, bool) GapiLens.t
  val items : (t, t option) GapiLens.t
  val annotations : (t, Annotations.t) GapiLens.t
  val enumDescriptions : (t, string list) GapiLens.t
  val location : (t, string) GapiLens.t
  val default : (t, string) GapiLens.t
  val description : (t, string) GapiLens.t
  val deprecated : (t, bool) GapiLens.t
  val properties : (t, (string * t) list) GapiLens.t
  val enum : (t, string list) GapiLens.t
  val additionalProperties : (t, t option) GapiLens.t
  val id : (t, string) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module DirectoryList :
sig
  module Items :
  sig
    module Icons :
    sig
      type t = {
        x32 : string;
        (** The URL of the 32x32 icon. *)
        x16 : string;
        (** The URL of the 16x16 icon. *)
        
      }
      
      val x32 : (t, string) GapiLens.t
      val x16 : (t, string) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      description : string;
      (** The description of this API. *)
      name : string;
      (** The name of the API. *)
      documentationLink : string;
      (** A link to human readable documentation for the API. *)
      version : string;
      (** The version of the API. *)
      title : string;
      (** The title of this API. *)
      kind : string;
      (** The kind for this response. *)
      discoveryRestUrl : string;
      (** The URL for the discovery REST document. *)
      id : string;
      (** The id of this API. *)
      discoveryLink : string;
      (** A link to the discovery document. *)
      preferred : bool;
      (** True if this version is the preferred version to use. *)
      labels : string list;
      (** Labels for the status of this API, such as labs or deprecated. *)
      icons : Icons.t;
      (** Links to 16x16 and 32x32 icons representing the API. *)
      
    }
    
    val description : (t, string) GapiLens.t
    val name : (t, string) GapiLens.t
    val documentationLink : (t, string) GapiLens.t
    val version : (t, string) GapiLens.t
    val title : (t, string) GapiLens.t
    val kind : (t, string) GapiLens.t
    val discoveryRestUrl : (t, string) GapiLens.t
    val id : (t, string) GapiLens.t
    val discoveryLink : (t, string) GapiLens.t
    val preferred : (t, bool) GapiLens.t
    val labels : (t, string list) GapiLens.t
    val icons : (t, Icons.t) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    discoveryVersion : string;
    (** Indicate the version of the Discovery API used to generate this doc. *)
    kind : string;
    (** The kind for this response. *)
    items : Items.t list;
    (** The individual directory entries. One entry per api/version pair. *)
    
  }
  
  val discoveryVersion : (t, string) GapiLens.t
  val kind : (t, string) GapiLens.t
  val items : (t, Items.t list) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestMethod :
sig
  module MediaUpload :
  sig
    module Protocols :
    sig
      module Simple :
      sig
        type t = {
          multipart : bool;
          (** True if this endpoint supports upload multipart media. *)
          path : string;
          (** The URI path to be used for upload. Should be used in conjunction with the basePath property at the api-level. *)
          
        }
        
        val multipart : (t, bool) GapiLens.t
        val path : (t, string) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      module Resumable :
      sig
        type t = {
          path : string;
          (** The URI path to be used for upload. Should be used in conjunction with the basePath property at the api-level. *)
          multipart : bool;
          (** True if this endpoint supports uploading multipart media. *)
          
        }
        
        val path : (t, string) GapiLens.t
        val multipart : (t, bool) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      type t = {
        resumable : Resumable.t;
        (** Supports the Resumable Media Upload protocol. *)
        simple : Simple.t;
        (** Supports uploading as a single HTTP request. *)
        
      }
      
      val resumable : (t, Resumable.t) GapiLens.t
      val simple : (t, Simple.t) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      protocols : Protocols.t;
      (** Supported upload protocols. *)
      maxSize : string;
      (** Maximum size of a media upload, such as "1MB", "2GB" or "3TB". *)
      accept : string list;
      (** MIME Media Ranges for acceptable media uploads to this method. *)
      
    }
    
    val protocols : (t, Protocols.t) GapiLens.t
    val maxSize : (t, string) GapiLens.t
    val accept : (t, string list) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Response :
  sig
    type t = {
      _ref : string;
      (** Schema ID for the response schema. *)
      
    }
    
    val _ref : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Request :
  sig
    type t = {
      _ref : string;
      (** Schema ID for the request schema. *)
      parameterName : string;
      (** parameter name. *)
      
    }
    
    val _ref : (t, string) GapiLens.t
    val parameterName : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    useMediaDownloadService : bool;
    (** Indicates that downloads from this method should use the download service URL (i.e. "/download"). Only applies if the method supports media download. *)
    id : string;
    (** A unique ID for this method. This property can be used to match methods between different versions of Discovery. *)
    parameterOrder : string list;
    (** Ordered list of required parameters, serves as a hint to clients on how to structure their method signatures. The array is ordered such that the "most-significant" parameter appears first. *)
    etagRequired : bool;
    (** Whether this method requires an ETag to be specified. The ETag is sent as an HTTP If-Match or If-None-Match header. *)
    httpMethod : string;
    (** HTTP method used by this method. *)
    flatPath : string;
    (** The URI path of this REST method in (RFC 6570) format without level 2 features (\{+var\}). Supplementary to the path property. *)
    supportsMediaDownload : bool;
    (** Whether this method supports media downloads. *)
    scopes : string list;
    (** OAuth 2.0 scopes applicable to this method. *)
    request : Request.t;
    (** The schema for the request. *)
    description : string;
    (** Description of this method. *)
    deprecated : bool;
    (** Whether this method is deprecated. *)
    response : Response.t;
    (** The schema for the response. *)
    apiVersion : string;
    (** The API Version of this method, as passed in via the `X-Goog-Api-Version` header or `$apiVersion` query parameter. *)
    supportsMediaUpload : bool;
    (** Whether this method supports media uploads. *)
    path : string;
    (** The URI path of this REST method. Should be used in conjunction with the basePath property at the api-level. *)
    supportsSubscription : bool;
    (** Whether this method supports subscriptions. *)
    mediaUpload : MediaUpload.t;
    (** Media upload parameters. *)
    parameters : (string * JsonSchema.t) list;
    (** Details for all parameters in this method. *)
    
  }
  
  val useMediaDownloadService : (t, bool) GapiLens.t
  val id : (t, string) GapiLens.t
  val parameterOrder : (t, string list) GapiLens.t
  val etagRequired : (t, bool) GapiLens.t
  val httpMethod : (t, string) GapiLens.t
  val flatPath : (t, string) GapiLens.t
  val supportsMediaDownload : (t, bool) GapiLens.t
  val scopes : (t, string list) GapiLens.t
  val request : (t, Request.t) GapiLens.t
  val description : (t, string) GapiLens.t
  val deprecated : (t, bool) GapiLens.t
  val response : (t, Response.t) GapiLens.t
  val apiVersion : (t, string) GapiLens.t
  val supportsMediaUpload : (t, bool) GapiLens.t
  val path : (t, string) GapiLens.t
  val supportsSubscription : (t, bool) GapiLens.t
  val mediaUpload : (t, MediaUpload.t) GapiLens.t
  val parameters : (t, (string * JsonSchema.t) list) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestResource :
sig
  type t = {
    methods : (string * RestMethod.t) list;
    (** Methods on this resource. *)
    resources : (string * t) list;
    (** Sub-resources on this resource. *)
    deprecated : bool;
    (** Whether this resource is deprecated. *)
    
  }
  
  val methods : (t, (string * RestMethod.t) list) GapiLens.t
  val resources : (t, (string * t) list) GapiLens.t
  val deprecated : (t, bool) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestDescription :
sig
  module Auth :
  sig
    module Oauth2 :
    sig
      module Scopes :
      sig
        type t = {
          description : string;
          (** Description of scope. *)
          
        }
        
        val description : (t, string) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      type t = {
        scopes : (string * Scopes.t) list;
        (** Available OAuth 2.0 scopes. *)
        
      }
      
      val scopes : (t, (string * Scopes.t) list) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      oauth2 : Oauth2.t;
      (** OAuth 2.0 authentication information. *)
      
    }
    
    val oauth2 : (t, Oauth2.t) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Icons :
  sig
    type t = {
      x32 : string;
      (** The URL of the 32x32 icon. *)
      x16 : string;
      (** The URL of the 16x16 icon. *)
      
    }
    
    val x32 : (t, string) GapiLens.t
    val x16 : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Endpoints :
  sig
    type t = {
      location : string;
      (** The location of the endpoint *)
      deprecated : bool;
      (** Whether this endpoint is deprecated *)
      description : string;
      (** A string describing the host designated by the URL *)
      endpointUrl : string;
      (** The URL of the endpoint target host *)
      
    }
    
    val location : (t, string) GapiLens.t
    val deprecated : (t, bool) GapiLens.t
    val description : (t, string) GapiLens.t
    val endpointUrl : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    protocol : string;
    (** The protocol described by this document. *)
    kind : string;
    (** The kind for this response. *)
    documentationLink : string;
    (** A link to human readable documentation for the API. *)
    ownerName : string;
    (** The name of the owner of this API. See ownerDomain. *)
    rootUrl : string;
    (** The root URL under which all API services live. *)
    endpoints : Endpoints.t list;
    (** A list of location-based endpoint objects for this API. Each object contains the endpoint URL, location, description and deprecation status. *)
    labels : string list;
    (** Labels for the status of this API, such as labs or deprecated. *)
    packagePath : string;
    (** The package of the owner of this API. See ownerDomain. *)
    revision : string;
    (** The version of this API. *)
    id : string;
    (** The ID of this API. *)
    basePath : string;
    (** \[DEPRECATED\] The base path for REST requests. *)
    description : string;
    (** The description of this API. *)
    name : string;
    (** The name of this API. *)
    baseUrl : string;
    (** \[DEPRECATED\] The base URL for REST requests. *)
    canonicalName : string;
    (** Indicates how the API name should be capitalized and split into various parts. Useful for generating pretty class names. *)
    discoveryVersion : string;
    (** Indicate the version of the Discovery API used to generate this doc. *)
    schemas : (string * JsonSchema.t) list;
    (** The schemas for this API. *)
    batchPath : string;
    (** The path for REST batch requests. *)
    version_module : bool;
    (**  *)
    icons : Icons.t;
    (** Links to 16x16 and 32x32 icons representing the API. *)
    etag : string;
    (** The ETag for this response. *)
    version : string;
    (** The version of this API. *)
    servicePath : string;
    (** The base path for all REST requests. *)
    resources : (string * RestResource.t) list;
    (** The resources in this API. *)
    parameters : (string * JsonSchema.t) list;
    (** Common parameters that apply across all apis. *)
    methods : (string * RestMethod.t) list;
    (** API-level methods for this API. *)
    exponentialBackoffDefault : bool;
    (** Enable exponential backoff for suitable methods in the generated clients. *)
    ownerDomain : string;
    (** The domain of the owner of this API. Together with the ownerName and a packagePath values, this can be used to generate a library for this API which would have a unique fully qualified name. *)
    features : string list;
    (** A list of supported features for this API. *)
    auth : Auth.t;
    (** Authentication information. *)
    title : string;
    (** The title of this API. *)
    
  }
  
  val protocol : (t, string) GapiLens.t
  val kind : (t, string) GapiLens.t
  val documentationLink : (t, string) GapiLens.t
  val ownerName : (t, string) GapiLens.t
  val rootUrl : (t, string) GapiLens.t
  val endpoints : (t, Endpoints.t list) GapiLens.t
  val labels : (t, string list) GapiLens.t
  val packagePath : (t, string) GapiLens.t
  val revision : (t, string) GapiLens.t
  val id : (t, string) GapiLens.t
  val basePath : (t, string) GapiLens.t
  val description : (t, string) GapiLens.t
  val name : (t, string) GapiLens.t
  val baseUrl : (t, string) GapiLens.t
  val canonicalName : (t, string) GapiLens.t
  val discoveryVersion : (t, string) GapiLens.t
  val schemas : (t, (string * JsonSchema.t) list) GapiLens.t
  val batchPath : (t, string) GapiLens.t
  val version_module : (t, bool) GapiLens.t
  val icons : (t, Icons.t) GapiLens.t
  val etag : (t, string) GapiLens.t
  val version : (t, string) GapiLens.t
  val servicePath : (t, string) GapiLens.t
  val resources : (t, (string * RestResource.t) list) GapiLens.t
  val parameters : (t, (string * JsonSchema.t) list) GapiLens.t
  val methods : (t, (string * RestMethod.t) list) GapiLens.t
  val exponentialBackoffDefault : (t, bool) GapiLens.t
  val ownerDomain : (t, string) GapiLens.t
  val features : (t, string list) GapiLens.t
  val auth : (t, Auth.t) GapiLens.t
  val title : (t, string) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

