;;; proc.el --- AUCTeX style for `proc.cls'  -*- lexical-binding: t; -*-

;; Copyright (C) 2022--2024 Free Software Foundation, Inc.

;; Author: Arash Esbati <arash@gnu.org>
;; Maintainer: auctex-devel@gnu.org
;; Created: 2022-06-12
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 3, or (at your option) any
;; later version.

;; AUCTeX is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; This file adds support for `proc.cls' v1.3m from 2021-12-09.

;;; Code:

(require 'tex)

(defvar LaTeX-proc-class-options
  '("a4paper" "letterpaper" "legalpaper" "executivepaper"
    "landscape" "10pt" "11pt" "12pt" "oneside" "twoside" "draft" "final"
    "notitlepage" "twocolumn" "leqno" "fleqn" "openbib")
  "Package options for the proc class.")

(TeX-add-style-hook
 "proc"
 (lambda ()
   (TeX-run-style-hooks "article"))
 TeX-dialect)

;;; proc.el ends here
