/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericResourceManager.class);
    private String resourceName;
    private String userName;
    private String password;
    private TransactionManager transactionManager;
    private ConnectionFactory connectionFactory;

    public void recoverResource() {
        try {
            if (!Recovery.recover(this)) {
                LOGGER.info("Resource manager is unrecoverable");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("Resource manager is unrecoverable due to missing classes: " + String.valueOf(e));
        }
        catch (Throwable e) {
            LOGGER.warn("Error while recovering resource manager", e);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public static class ConnectionAndWrapperNamedXAResource
    extends WrapperNamedXAResource {
        final Connection connection;

        public ConnectionAndWrapperNamedXAResource(XAResource xaResource, String name, Connection connection) {
            super(xaResource, name);
            this.connection = connection;
        }
    }

    public static class Recovery {
        public static boolean isRecoverable(GenericResourceManager rm) {
            return rm.getConnectionFactory() instanceof XAConnectionFactory && rm.getTransactionManager() instanceof RecoverableTransactionManager && rm.getResourceName() != null && !"".equals(rm.getResourceName());
        }

        public static boolean recover(final GenericResourceManager rm) throws IOException {
            if (Recovery.isRecoverable(rm)) {
                final XAConnectionFactory connFactory = (XAConnectionFactory)rm.getConnectionFactory();
                RecoverableTransactionManager rtxManager = (RecoverableTransactionManager)rm.getTransactionManager();
                rtxManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                    public String getName() {
                        return rm.getResourceName();
                    }

                    public NamedXAResource getNamedXAResource() throws SystemException {
                        try {
                            XAConnection xaConnection = rm.getUserName() != null && rm.getPassword() != null ? connFactory.createXAConnection(rm.getUserName(), rm.getPassword()) : connFactory.createXAConnection();
                            XASession session = xaConnection.createXASession();
                            xaConnection.start();
                            LOGGER.debug("new namedXAResource's connection: " + String.valueOf(xaConnection));
                            return new ConnectionAndWrapperNamedXAResource(session.getXAResource(), this.getName(), (Connection)xaConnection);
                        }
                        catch (Exception e) {
                            SystemException se = new SystemException("Failed to create ConnectionAndWrapperNamedXAResource, " + e.getLocalizedMessage());
                            se.initCause((Throwable)e);
                            LOGGER.error(se.getLocalizedMessage(), (Throwable)se);
                            throw se;
                        }
                    }

                    public void returnNamedXAResource(NamedXAResource namedXaResource) {
                        if (namedXaResource instanceof ConnectionAndWrapperNamedXAResource) {
                            try {
                                LOGGER.debug("closing returned namedXAResource's connection: " + String.valueOf(((ConnectionAndWrapperNamedXAResource)namedXaResource).connection));
                                ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection.close();
                            }
                            catch (Exception ignored) {
                                LOGGER.debug("failed to close returned namedXAResource: " + String.valueOf(namedXaResource), (Throwable)ignored);
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        }
    }
}

