/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanFactoryDestinationResolver
implements DestinationResolver,
BeanFactoryAware {
    @Nullable
    private BeanFactory beanFactory;

    public BeanFactoryDestinationResolver() {
    }

    public BeanFactoryDestinationResolver(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, "BeanFactory is required");
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Destination resolveDestinationName(@Nullable Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Assert.state(this.beanFactory != null, "BeanFactory is required");
        try {
            return this.beanFactory.getBean(destinationName, Destination.class);
        }
        catch (BeansException ex) {
            throw new DestinationResolutionException("Failed to look up Destination bean with name '" + destinationName + "'", ex);
        }
    }
}

