/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.Deque;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.request.notification.NotificationCommand;
import org.jolokia.server.core.request.notification.NotificationCommandFactory;
import org.jolokia.server.core.util.RequestType;

public class JolokiaNotificationRequest
extends JolokiaRequest {
    private final NotificationCommand command;

    JolokiaNotificationRequest(NotificationCommand pCommand, ProcessingParameters pParams) {
        super(RequestType.NOTIFICATION, null, pParams, true);
        this.command = pCommand;
    }

    JolokiaNotificationRequest(NotificationCommand pCommand, Map<String, ?> pRequestMap, ProcessingParameters pParams) {
        super(pRequestMap, pParams, true);
        this.command = pCommand;
    }

    public <T extends NotificationCommand> T getCommand() {
        return (T)this.command;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        JSONObject commandJson = this.command.toJSON();
        ret.putAll((Map)commandJson);
        return ret;
    }

    static RequestCreator<JolokiaNotificationRequest> newCreator() {
        return new RequestCreator<JolokiaNotificationRequest>(){

            @Override
            public JolokiaNotificationRequest create(Deque<String> pStack, ProcessingParameters pParams) throws MalformedObjectNameException {
                NotificationCommand notifCommand = NotificationCommandFactory.createCommand(pStack);
                return new JolokiaNotificationRequest(notifCommand, pParams);
            }

            @Override
            public JolokiaNotificationRequest create(JSONObject requestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
                NotificationCommand notifCommand = NotificationCommandFactory.createCommand(requestMap);
                return new JolokiaNotificationRequest(notifCommand, (Map<String, ?>)requestMap, pParams);
            }
        };
    }
}

