/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class PropertiesValidationResult
implements Serializable {
    int errors;
    int warnings;
    String syntaxError;
    String unknownComponent;
    String incapable;
    Set<String> unknown;
    Map<String, String[]> unknownSuggestions;
    Set<String> required;
    Set<String> deprecated;
    Map<String, String> invalidEnum;
    Map<String, String[]> invalidEnumChoices;
    Map<String, String[]> invalidEnumSuggestions;
    Map<String, String> invalidMap;
    Map<String, String> invalidArray;
    Map<String, String> invalidReference;
    Map<String, String> invalidBoolean;
    Map<String, String> invalidInteger;
    Map<String, String> invalidNumber;
    Map<String, String> invalidDuration;
    Map<String, String> defaultValues;

    PropertiesValidationResult() {
    }

    public boolean hasErrors() {
        return this.errors > 0;
    }

    public int getNumberOfErrors() {
        return this.errors;
    }

    public boolean hasWarnings() {
        return this.warnings > 0;
    }

    public int getNumberOfWarnings() {
        return this.warnings;
    }

    public boolean isSuccess() {
        boolean ok;
        boolean bl = ok = this.syntaxError == null && this.unknown == null && this.required == null;
        if (ok) {
            boolean bl2 = ok = this.invalidEnum == null && this.invalidEnumChoices == null && this.invalidReference == null && this.invalidBoolean == null && this.invalidInteger == null && this.invalidNumber == null && this.invalidDuration == null;
        }
        if (ok) {
            ok = this.invalidMap == null && this.invalidArray == null;
        }
        return ok;
    }

    public void addSyntaxError(String syntaxError) {
        this.syntaxError = syntaxError;
        ++this.errors;
    }

    public void addIncapable(String uri) {
        this.incapable = uri;
        ++this.warnings;
    }

    public void addUnknownComponent(String name) {
        this.unknownComponent = name;
        ++this.warnings;
    }

    public void addUnknown(String name) {
        if (this.unknown == null) {
            this.unknown = new LinkedHashSet<String>();
        }
        if (!this.unknown.contains(name)) {
            this.unknown.add(name);
            ++this.errors;
        }
    }

    public void addUnknownSuggestions(String name, String[] suggestions) {
        if (this.unknownSuggestions == null) {
            this.unknownSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.unknownSuggestions.put(name, suggestions);
    }

    public void addRequired(String name) {
        if (this.required == null) {
            this.required = new LinkedHashSet<String>();
        }
        if (!this.required.contains(name)) {
            this.required.add(name);
            ++this.errors;
        }
    }

    public void addDeprecated(String name) {
        if (this.deprecated == null) {
            this.deprecated = new LinkedHashSet<String>();
        }
        this.deprecated.add(name);
    }

    private String computeErrors(String value) {
        ++this.errors;
        return value;
    }

    public void addInvalidEnum(String name, String value) {
        if (this.invalidEnum == null) {
            this.invalidEnum = new LinkedHashMap<String, String>();
        }
        this.invalidEnum.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidEnumChoices(String name, String[] choices) {
        if (this.invalidEnumChoices == null) {
            this.invalidEnumChoices = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumChoices.put(name, choices);
    }

    public void addInvalidEnumSuggestions(String name, String[] suggestions) {
        if (this.invalidEnumSuggestions == null) {
            this.invalidEnumSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumSuggestions.put(name, suggestions);
    }

    public void addInvalidReference(String name, String value) {
        if (this.invalidReference == null) {
            this.invalidReference = new LinkedHashMap<String, String>();
        }
        this.invalidReference.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidMap(String name, String value) {
        if (this.invalidMap == null) {
            this.invalidMap = new LinkedHashMap<String, String>();
        }
        this.invalidMap.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidArray(String name, String value) {
        if (this.invalidArray == null) {
            this.invalidArray = new LinkedHashMap<String, String>();
        }
        this.invalidArray.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidBoolean(String name, String value) {
        if (this.invalidBoolean == null) {
            this.invalidBoolean = new LinkedHashMap<String, String>();
        }
        this.invalidBoolean.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidInteger(String name, String value) {
        if (this.invalidInteger == null) {
            this.invalidInteger = new LinkedHashMap<String, String>();
        }
        this.invalidInteger.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidNumber(String name, String value) {
        if (this.invalidNumber == null) {
            this.invalidNumber = new LinkedHashMap<String, String>();
        }
        this.invalidNumber.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addInvalidDuration(String name, String value) {
        if (this.invalidDuration == null) {
            this.invalidDuration = new LinkedHashMap<String, String>();
        }
        this.invalidDuration.computeIfAbsent(name, k -> this.computeErrors(value));
    }

    public void addDefaultValue(String name, String value) {
        if (this.defaultValues == null) {
            this.defaultValues = new LinkedHashMap<String, String>();
        }
        this.defaultValues.put(name, value);
    }

    public String getSyntaxError() {
        return this.syntaxError;
    }

    public String getIncapable() {
        return this.incapable;
    }

    public Set<String> getUnknown() {
        return this.unknown;
    }

    public Map<String, String[]> getUnknownSuggestions() {
        return this.unknownSuggestions;
    }

    public String getUnknownComponent() {
        return this.unknownComponent;
    }

    public Set<String> getRequired() {
        return this.required;
    }

    public Set<String> getDeprecated() {
        return this.deprecated;
    }

    public Map<String, String> getInvalidEnum() {
        return this.invalidEnum;
    }

    public Map<String, String[]> getInvalidEnumChoices() {
        return this.invalidEnumChoices;
    }

    public List<String> getEnumChoices(String optionName) {
        String[] enums;
        if (this.invalidEnumChoices != null && (enums = this.invalidEnumChoices.get(optionName)) != null) {
            return Arrays.asList(enums);
        }
        return Collections.emptyList();
    }

    public Map<String, String> getInvalidReference() {
        return this.invalidReference;
    }

    public Map<String, String> getInvalidMap() {
        return this.invalidMap;
    }

    public Map<String, String> getInvalidArray() {
        return this.invalidArray;
    }

    public Map<String, String> getInvalidBoolean() {
        return this.invalidBoolean;
    }

    public Map<String, String> getInvalidInteger() {
        return this.invalidInteger;
    }

    public Map<String, String> getInvalidNumber() {
        return this.invalidNumber;
    }

    public Map<String, String> getInvalidDuration() {
        return this.invalidDuration;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    static boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }
}

