/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Collection;
import java.util.List;
import org.springframework.cloud.vault.config.DefaultSecretBackendConfigurer;
import org.springframework.cloud.vault.config.KeyValueSecretBackendMetadata;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendFactories;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultConfigurer;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;

class PropertySourceLocatorConfigurationFactory {
    private final Collection<VaultConfigurer> configurers;
    private final Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors;
    private final Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories;

    PropertySourceLocatorConfigurationFactory(Collection<VaultConfigurer> configurers, Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors, Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories) {
        this.configurers = configurers;
        this.vaultSecretBackendDescriptors = vaultSecretBackendDescriptors;
        this.factories = factories;
    }

    PropertySourceLocatorConfiguration getPropertySourceConfiguration(VaultKeyValueBackendPropertiesSupport ... keyValueBackends) {
        Collection<SecretBackendMetadata> backendAccessors;
        DefaultSecretBackendConfigurer secretBackendConfigurer = new DefaultSecretBackendConfigurer();
        if (this.configurers.isEmpty()) {
            secretBackendConfigurer.registerDefaultKeyValueSecretBackends(true).registerDefaultDiscoveredSecretBackends(true);
        } else {
            for (VaultConfigurer vaultConfigurer : this.configurers) {
                vaultConfigurer.addSecretBackends(secretBackendConfigurer);
            }
        }
        if (secretBackendConfigurer.isRegisterDefaultKeyValueSecretBackends()) {
            for (VaultKeyValueBackendPropertiesSupport keyValueBackend : keyValueBackends) {
                if (!keyValueBackend.isEnabled()) continue;
                List<String> contexts = KeyValueSecretBackendMetadata.buildContexts(keyValueBackend, keyValueBackend.getProfiles());
                for (String context : contexts) {
                    secretBackendConfigurer.add(KeyValueSecretBackendMetadata.create(keyValueBackend.getBackend(), context));
                }
            }
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            backendAccessors.forEach(secretBackendConfigurer::add);
        }
        if (secretBackendConfigurer.isRegisterDefaultDiscoveredSecretBackends()) {
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            backendAccessors.forEach(secretBackendConfigurer::add);
        }
        return secretBackendConfigurer;
    }
}

