/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.hibernate.Internal;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.beanvalidation.BeanValidationIntegrator;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.spi.BindableMappingDescriptor;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataBuilderContributor;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.boot.internal.StandardJpaScanEnvironmentImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class EntityManagerFactoryBuilderImpl
implements EntityManagerFactoryBuilder {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(EntityManagerFactoryBuilderImpl.class);
    public static final String INTEGRATOR_PROVIDER = "hibernate.integrator_provider";
    public static final String STRATEGY_REGISTRATION_PROVIDERS = "hibernate.strategy_registration_provider";
    public static final String TYPE_CONTRIBUTORS = "hibernate.type_contributors";
    public static final String METADATA_BUILDER_CONTRIBUTOR = "hibernate.metadata_builder_contributor";
    public static final String JANDEX_INDEX = "hibernate.jandex_index";
    private final PersistenceUnitDescriptor persistenceUnit;
    private final Map<String, Object> configurationValues;
    private final StandardServiceRegistry standardServiceRegistry;
    private final ManagedResources managedResources;
    private final MetadataBuilderImplementor metamodelBuilder;
    private static final String IS_JTA_TXN_COORD = "local.setting.IS_JTA_TXN_COORD";
    private Object validatorFactory;
    private DataSource dataSource;
    private MetadataImplementor metadata;

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings) {
        this(persistenceUnit, integrationSettings, null, null, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoader providedClassLoader) {
        this(persistenceUnit, integrationSettings, providedClassLoader, null, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoaderService providedClassLoaderService) {
        this(persistenceUnit, integrationSettings, null, providedClassLoaderService, null);
    }

    @Internal
    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, Map<String, Object> integration, Consumer<MergedSettings> mergedSettingsBaseline) {
        this(persistenceUnitDescriptor, integration, null, null, mergedSettingsBaseline);
    }

    private EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService, Consumer<MergedSettings> mergedSettingsBaseline) {
        LogHelper.logPersistenceUnitInformation(persistenceUnit);
        this.persistenceUnit = persistenceUnit;
        if (integrationSettings == null) {
            integrationSettings = new HashMap<String, Object>();
        }
        Map<String, Object> mergedIntegrationSettings = null;
        Properties properties = persistenceUnit.getProperties();
        if (properties != null) {
            mergedIntegrationSettings = new HashMap<Object, Object>(properties);
            mergedIntegrationSettings.putAll(integrationSettings);
        }
        BootstrapServiceRegistry bsr = this.buildBootstrapServiceRegistry(mergedIntegrationSettings != null ? mergedIntegrationSettings : integrationSettings, providedClassLoader, providedClassLoaderService);
        try {
            StandardServiceRegistryBuilder ssrBuilder = this.getStandardServiceRegistryBuilder(bsr);
            MergedSettings mergedSettings = this.mergeSettings(persistenceUnit, integrationSettings, ssrBuilder, mergedSettingsBaseline);
            if ("true".equals(mergedSettings.configurationValues.get("hibernate.transaction.flush_before_completion"))) {
                LOG.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
                mergedSettings.configurationValues.put("hibernate.transaction.flush_before_completion", "false");
            }
            this.configurationValues = mergedSettings.getConfigurationValues();
            ssrBuilder.applySettings(this.configurationValues);
            this.standardServiceRegistry = ssrBuilder.build();
            MetadataSources metadataSources = new MetadataSources(this.standardServiceRegistry);
            this.metamodelBuilder = (MetadataBuilderImplementor)metadataSources.getMetadataBuilder(this.standardServiceRegistry);
            List<ConverterDescriptor> attributeConverterDefinitions = this.applyMappingResources(metadataSources);
            this.applyMetamodelBuilderSettings(mergedSettings, attributeConverterDefinitions);
            this.applyMetadataBuilderContributor();
            CfgXmlAccessService cfgXmlAccessService = this.standardServiceRegistry.getService(CfgXmlAccessService.class);
            if (cfgXmlAccessService.getAggregatedConfig() != null && cfgXmlAccessService.getAggregatedConfig().getMappingReferences() != null) {
                for (MappingReference mappingReference : cfgXmlAccessService.getAggregatedConfig().getMappingReferences()) {
                    mappingReference.apply(metadataSources);
                }
            }
            this.managedResources = MetadataBuildingProcess.prepare(metadataSources, this.metamodelBuilder.getBootstrapContext());
            Object validatorFactory = this.configurationValues.get("jakarta.persistence.validation.factory");
            if (validatorFactory == null) {
                Object legacyValidatorFactory = this.configurationValues.get("javax.persistence.validation.factory");
                if (legacyValidatorFactory != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.validation.factory", "jakarta.persistence.validation.factory");
                }
                this.withValidatorFactory(legacyValidatorFactory);
            } else {
                this.withValidatorFactory(validatorFactory);
            }
            Object propertyValue = this.configurationValues.remove("hibernate.enhancer.enableDirtyTracking");
            boolean dirtyTrackingEnabled = propertyValue != null ? Boolean.parseBoolean(propertyValue.toString()) : true;
            propertyValue = this.configurationValues.remove("hibernate.enhancer.enableLazyInitialization");
            boolean lazyInitializationEnabled = propertyValue != null ? Boolean.parseBoolean(propertyValue.toString()) : true;
            boolean associationManagementEnabled = this.readBooleanConfigurationValue("hibernate.enhancer.enableAssociationManagement");
            if (!lazyInitializationEnabled) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("hibernate.enhancer.enableLazyInitialization", "true");
            }
            if (!dirtyTrackingEnabled) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("hibernate.enhancer.enableDirtyTracking", "true");
            }
            if (dirtyTrackingEnabled || lazyInitializationEnabled || associationManagementEnabled) {
                EnhancementContext enhancementContext = this.getEnhancementContext(dirtyTrackingEnabled, lazyInitializationEnabled, associationManagementEnabled);
                persistenceUnit.pushClassTransformer(enhancementContext);
                ClassTransformer classTransformer = persistenceUnit.getClassTransformer();
                if (classTransformer != null) {
                    ClassLoader classLoader = persistenceUnit.getTempClassLoader();
                    if (classLoader == null) {
                        throw this.persistenceException("Enhancement requires a temp class loader, but none was given.");
                    }
                    for (Binding<BindableMappingDescriptor> binding : metadataSources.getXmlBindings()) {
                        BindableMappingDescriptor root = binding.getRoot();
                        if (!(root instanceof JaxbHbmHibernateMapping)) continue;
                        JaxbHbmHibernateMapping hibernateMapping = (JaxbHbmHibernateMapping)root;
                        String packageName = hibernateMapping.getPackage();
                        for (JaxbHbmRootEntityType clazz : hibernateMapping.getClazz()) {
                            Object className = packageName == null || packageName.isEmpty() ? clazz.getName() : packageName + "." + clazz.getName();
                            try {
                                classTransformer.discoverTypes(classLoader, (String)className);
                            }
                            catch (EnhancementException ex) {
                                LOG.enhancementDiscoveryFailed((String)className, (Throwable)((Object)ex));
                            }
                        }
                    }
                    for (String string : metadataSources.getAnnotatedClassNames()) {
                        classTransformer.discoverTypes(classLoader, string);
                    }
                    for (Class clazz : metadataSources.getAnnotatedClasses()) {
                        classTransformer.discoverTypes(classLoader, clazz.getName());
                    }
                }
            }
            this.metamodelBuilder.applyTempClassLoader(null);
        }
        catch (Throwable t) {
            bsr.close();
            this.cleanup();
            throw t;
        }
    }

    protected StandardServiceRegistryBuilder getStandardServiceRegistryBuilder(BootstrapServiceRegistry bsr) {
        return StandardServiceRegistryBuilder.forJpa(bsr);
    }

    private void applyMetadataBuilderContributor() {
        MetadataBuilderContributor metadataBuilderContributor;
        Object metadataBuilderContributorSetting = this.configurationValues.get(METADATA_BUILDER_CONTRIBUTOR);
        if (metadataBuilderContributorSetting != null && (metadataBuilderContributor = this.loadSettingInstance(METADATA_BUILDER_CONTRIBUTOR, metadataBuilderContributorSetting, MetadataBuilderContributor.class)) != null) {
            metadataBuilderContributor.contribute(this.metamodelBuilder);
        }
        StandardServiceRegistry serviceRegistry = this.metamodelBuilder.getBootstrapContext().getServiceRegistry();
        ClassLoaderService cls = serviceRegistry.getService(ClassLoaderService.class);
        Collection<MetadataBuilderContributor> contributors = cls.loadJavaServices(MetadataBuilderContributor.class);
        contributors.forEach(contributor -> contributor.contribute(this.metamodelBuilder));
    }

    public Map<Object, Object> getConfigurationValues() {
        return Collections.unmodifiableMap(this.configurationValues);
    }

    private boolean readBooleanConfigurationValue(String propertyName) {
        Object propertyValue = this.configurationValues.remove(propertyName);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    protected EnhancementContext getEnhancementContext(final boolean dirtyTrackingEnabled, final boolean lazyInitializationEnabled, final boolean associationManagementEnabled) {
        return new DefaultEnhancementContext(){

            @Override
            public boolean isEntityClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isEntityClass(classDescriptor);
            }

            @Override
            public boolean isCompositeClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isCompositeClass(classDescriptor);
            }

            @Override
            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return associationManagementEnabled;
            }

            @Override
            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return dirtyTrackingEnabled;
            }

            @Override
            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean isLazyLoadable(UnloadedField field) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return false;
            }
        };
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(Map<?, ?> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        BootstrapServiceRegistryBuilder bsrBuilder = new BootstrapServiceRegistryBuilder();
        this.applyIntegrationProvider(integrationSettings, bsrBuilder);
        StrategyRegistrationProviderList strategyRegistrationProviderList = (StrategyRegistrationProviderList)integrationSettings.get(STRATEGY_REGISTRATION_PROVIDERS);
        if (strategyRegistrationProviderList != null) {
            for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviderList.getStrategyRegistrationProviders()) {
                bsrBuilder.applyStrategySelectors(strategyRegistrationProvider);
            }
        }
        this.configureClassLoading(integrationSettings, providedClassLoader, providedClassLoaderService, bsrBuilder);
        return bsrBuilder.build();
    }

    private void configureClassLoading(Map<?, ?> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService, BootstrapServiceRegistryBuilder bsrBuilder) {
        TcclLookupPrecedence tcclLookupPrecedence;
        Properties puProperties;
        Object classLoadersSetting;
        if (providedClassLoaderService != null) {
            bsrBuilder.applyClassLoaderService(providedClassLoaderService);
            return;
        }
        if (this.persistenceUnit.getClassLoader() != null) {
            bsrBuilder.applyClassLoader(this.persistenceUnit.getClassLoader());
        }
        if (providedClassLoader != null) {
            bsrBuilder.applyClassLoader(providedClassLoader);
        }
        if ((classLoadersSetting = integrationSettings.get("hibernate.classLoaders")) != null) {
            if (classLoadersSetting instanceof Collection) {
                ClassLoader[] classLoaders = (ClassLoader[])classLoadersSetting;
                for (ClassLoader classLoader : classLoaders) {
                    bsrBuilder.applyClassLoader(classLoader);
                }
            } else if (classLoadersSetting.getClass().isArray()) {
                for (ClassLoader classLoader : (ClassLoader[])classLoadersSetting) {
                    bsrBuilder.applyClassLoader(classLoader);
                }
            } else if (classLoadersSetting instanceof ClassLoader) {
                bsrBuilder.applyClassLoader((ClassLoader)classLoadersSetting);
            }
        }
        if ((puProperties = this.persistenceUnit.getProperties()) != null && (tcclLookupPrecedence = TcclLookupPrecedence.from(puProperties)) != null) {
            bsrBuilder.applyTcclLookupPrecedence(tcclLookupPrecedence);
        }
    }

    private void applyIntegrationProvider(Map<?, ?> integrationSettings, BootstrapServiceRegistryBuilder bsrBuilder) {
        Object integrationSetting = integrationSettings.get(INTEGRATOR_PROVIDER);
        if (integrationSetting == null) {
            return;
        }
        IntegratorProvider integratorProvider = this.loadSettingInstance(INTEGRATOR_PROVIDER, integrationSetting, IntegratorProvider.class);
        if (integratorProvider != null) {
            for (Integrator integrator : integratorProvider.getIntegrators()) {
                bsrBuilder.applyIntegrator(integrator);
            }
        }
    }

    private MergedSettings mergeSettings(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, StandardServiceRegistryBuilder ssrBuilder, Consumer<MergedSettings> mergedSettingsBaseline) {
        MergedSettings mergedSettings = new MergedSettings();
        if (mergedSettingsBaseline != null) {
            mergedSettingsBaseline.accept(mergedSettings);
        }
        mergedSettings.processPersistenceUnitDescriptorProperties(persistenceUnit);
        String cfgXmlResourceName = (String)mergedSettings.configurationValues.remove("hibernate.cfg_xml_file");
        if (StringHelper.isEmpty(cfgXmlResourceName)) {
            cfgXmlResourceName = (String)integrationSettings.get("hibernate.cfg_xml_file");
        }
        if (StringHelper.isNotEmpty(cfgXmlResourceName)) {
            this.processHibernateConfigXmlResources(ssrBuilder, mergedSettings, cfgXmlResourceName);
        }
        this.normalizeSettings(persistenceUnit, integrationSettings, mergedSettings);
        Iterator<Map.Entry<String, Object>> itr = mergedSettings.configurationValues.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Object> entry = itr.next();
            if (entry.getValue() == null) {
                itr.remove();
                break;
            }
            if (!(entry.getValue() instanceof String)) continue;
            String keyString = entry.getKey();
            String valueString = (String)entry.getValue();
            if (keyString.startsWith("hibernate.classcache")) {
                mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.classcache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.ENTITY));
                continue;
            }
            if (!keyString.startsWith("hibernate.collectioncache")) continue;
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.collectioncache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheRegionType.COLLECTION));
        }
        return mergedSettings;
    }

    private void normalizeSettings(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, MergedSettings mergedSettings) {
        HashMap<String, Object> integrationSettingsCopy = new HashMap<String, Object>(integrationSettings);
        this.normalizeConnectionAccessUserAndPass(integrationSettingsCopy, mergedSettings);
        this.normalizeTransactionCoordinator(persistenceUnit, integrationSettingsCopy, mergedSettings);
        this.normalizeDataAccess(integrationSettingsCopy, mergedSettings, persistenceUnit);
        Object intgValidationMode = integrationSettingsCopy.remove("javax.persistence.validation.mode");
        Object jakartaIntgValidationMode = integrationSettingsCopy.remove("jakarta.persistence.validation.mode");
        if (jakartaIntgValidationMode != null) {
            mergedSettings.configurationValues.put("jakarta.persistence.validation.mode", jakartaIntgValidationMode);
        } else if (intgValidationMode != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.validation.mode", "jakarta.persistence.validation.mode");
            mergedSettings.configurationValues.put("javax.persistence.validation.mode", intgValidationMode);
        } else if (persistenceUnit.getValidationMode() != null) {
            mergedSettings.configurationValues.put("jakarta.persistence.validation.mode", persistenceUnit.getValidationMode());
        }
        Object intgCacheMode = integrationSettingsCopy.remove("javax.persistence.sharedCache.mode");
        Object jakartaIntgCacheMode = integrationSettingsCopy.remove("jakarta.persistence.sharedCache.mode");
        if (jakartaIntgCacheMode != null) {
            mergedSettings.configurationValues.put("jakarta.persistence.sharedCache.mode", jakartaIntgCacheMode);
        } else if (intgCacheMode != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.sharedCache.mode", "jakarta.persistence.sharedCache.mode");
            mergedSettings.configurationValues.put("javax.persistence.sharedCache.mode", intgCacheMode);
        } else if (persistenceUnit.getSharedCacheMode() != null) {
            mergedSettings.configurationValues.put("jakarta.persistence.sharedCache.mode", persistenceUnit.getSharedCacheMode());
        }
        for (Map.Entry<String, Object> entry : integrationSettingsCopy.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                mergedSettings.configurationValues.remove(entry.getKey());
                continue;
            }
            mergedSettings.configurationValues.put(entry.getKey(), entry.getValue());
        }
    }

    private void normalizeConnectionAccessUserAndPass(HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        Object effectiveUser = NullnessHelper.coalesceSuppliedValues(() -> integrationSettingsCopy.remove("hibernate.connection.username"), () -> integrationSettingsCopy.remove("jakarta.persistence.jdbc.user"), () -> {
            Object setting = integrationSettingsCopy.remove("javax.persistence.jdbc.user");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user");
            }
            return setting;
        }, () -> this.extractPuProperty(this.persistenceUnit, "hibernate.connection.username"), () -> this.extractPuProperty(this.persistenceUnit, "jakarta.persistence.jdbc.user"), () -> {
            Object setting = this.extractPuProperty(this.persistenceUnit, "javax.persistence.jdbc.user");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user");
            }
            return setting;
        });
        Object effectivePass = NullnessHelper.coalesceSuppliedValues(() -> integrationSettingsCopy.remove("hibernate.connection.password"), () -> integrationSettingsCopy.remove("jakarta.persistence.jdbc.password"), () -> {
            Object setting = integrationSettingsCopy.remove("javax.persistence.jdbc.password");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
            }
            return setting;
        }, () -> this.extractPuProperty(this.persistenceUnit, "hibernate.connection.password"), () -> this.extractPuProperty(this.persistenceUnit, "jakarta.persistence.jdbc.password"), () -> {
            Object setting = this.extractPuProperty(this.persistenceUnit, "javax.persistence.jdbc.password");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
            }
            return setting;
        });
        if (effectiveUser != null || effectivePass != null) {
            this.applyUserAndPass(effectiveUser, effectivePass, mergedSettings);
        }
    }

    private <T> T extractPuProperty(PersistenceUnitDescriptor persistenceUnit, String propertyName) {
        return (T)(persistenceUnit.getProperties() == null ? null : persistenceUnit.getProperties().get(propertyName));
    }

    private void applyUserAndPass(Object effectiveUser, Object effectivePass, MergedSettings mergedSettings) {
        if (effectiveUser != null) {
            mergedSettings.configurationValues.put("hibernate.connection.username", effectiveUser);
            mergedSettings.configurationValues.put("jakarta.persistence.jdbc.user", effectiveUser);
            mergedSettings.configurationValues.put("javax.persistence.jdbc.user", effectiveUser);
        }
        if (effectivePass != null) {
            mergedSettings.configurationValues.put("hibernate.connection.password", effectivePass);
            mergedSettings.configurationValues.put("jakarta.persistence.jdbc.password", effectivePass);
            mergedSettings.configurationValues.put("javax.persistence.jdbc.password", effectivePass);
        }
    }

    private void normalizeTransactionCoordinator(PersistenceUnitDescriptor persistenceUnit, HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        boolean definiteJtaCoordinator;
        boolean hasTxStrategy;
        PersistenceUnitTransactionType txnType = null;
        Object intgTxnType = integrationSettingsCopy.remove("jakarta.persistence.transactionType");
        if (intgTxnType == null && (intgTxnType = integrationSettingsCopy.remove("javax.persistence.transactionType")) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
        }
        if (intgTxnType != null) {
            txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(intgTxnType);
        } else if (persistenceUnit.getTransactionType() != null) {
            txnType = persistenceUnit.getTransactionType();
        } else {
            Object puPropTxnType = mergedSettings.configurationValues.get("jakarta.persistence.transactionType");
            if (puPropTxnType == null && (puPropTxnType = mergedSettings.configurationValues.get("javax.persistence.transactionType")) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
            }
            if (puPropTxnType != null) {
                txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(puPropTxnType);
            }
        }
        if (txnType == null) {
            LOG.debug("PersistenceUnitTransactionType not specified - falling back to RESOURCE_LOCAL");
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        if (hasTxStrategy = mergedSettings.configurationValues.containsKey("hibernate.transaction.coordinator_class")) {
            LOG.overridingTransactionStrategyDangerous("hibernate.transaction.coordinator_class");
            Object strategy = mergedSettings.configurationValues.get("hibernate.transaction.coordinator_class");
            definiteJtaCoordinator = strategy instanceof TransactionCoordinatorBuilder ? ((TransactionCoordinatorBuilder)strategy).isJta() : false;
        } else if (txnType == PersistenceUnitTransactionType.JTA) {
            mergedSettings.configurationValues.put("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class);
            definiteJtaCoordinator = true;
        } else if (txnType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            mergedSettings.configurationValues.put("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
            definiteJtaCoordinator = false;
        } else {
            throw new IllegalStateException("Could not determine TransactionCoordinator strategy to use");
        }
        mergedSettings.configurationValues.put(IS_JTA_TXN_COORD, definiteJtaCoordinator);
    }

    private void normalizeDataAccess(HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings, PersistenceUnitDescriptor persistenceUnit) {
        Object url;
        Object integrationJdbcUrl;
        Object dataSourceRef;
        if (this.dataSource != null) {
            this.applyDataSource(this.dataSource, null, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("hibernate.connection.datasource") && (dataSourceRef = integrationSettingsCopy.remove("hibernate.connection.datasource")) != null) {
            this.applyDataSource(dataSourceRef, null, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.jtaDataSource") && (dataSourceRef = integrationSettingsCopy.remove("jakarta.persistence.jtaDataSource")) != null) {
            this.applyDataSource(dataSourceRef, true, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.jtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource");
            dataSourceRef = integrationSettingsCopy.remove("javax.persistence.jtaDataSource");
            if (dataSourceRef != null) {
                this.applyDataSource(dataSourceRef, true, integrationSettingsCopy, mergedSettings);
                return;
            }
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.nonJtaDataSource")) {
            dataSourceRef = integrationSettingsCopy.remove("jakarta.persistence.nonJtaDataSource");
            this.applyDataSource(dataSourceRef, false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.nonJtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
            dataSourceRef = integrationSettingsCopy.remove("javax.persistence.nonJtaDataSource");
            this.applyDataSource(dataSourceRef, false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("hibernate.connection.url") && (integrationJdbcUrl = integrationSettingsCopy.get("hibernate.connection.url")) != null) {
            this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("hibernate.connection.driver_class", integrationSettingsCopy), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", integrationSettingsCopy), () -> {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", integrationSettingsCopy);
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                return driver;
            }, () -> ConfigurationHelper.getString("hibernate.connection.driver_class", mergedSettings.configurationValues), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.configurationValues), () -> {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.configurationValues);
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                return driver;
            }), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.jdbc.url") && (integrationJdbcUrl = integrationSettingsCopy.get("jakarta.persistence.jdbc.url")) != null) {
            this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", integrationSettingsCopy), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.configurationValues)), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.jdbc.url")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url");
            integrationJdbcUrl = integrationSettingsCopy.get("javax.persistence.jdbc.url");
            if (integrationJdbcUrl != null) {
                this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> {
                    String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", integrationSettingsCopy);
                    if (driver != null) {
                        DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                    }
                    return driver;
                }, () -> {
                    String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.configurationValues);
                    if (driver != null) {
                        DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                    }
                    return driver;
                }), integrationSettingsCopy, mergedSettings);
                return;
            }
        }
        if (persistenceUnit.getJtaDataSource() != null) {
            this.applyDataSource(persistenceUnit.getJtaDataSource(), true, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (persistenceUnit.getNonJtaDataSource() != null) {
            this.applyDataSource(persistenceUnit.getNonJtaDataSource(), false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.configurationValues.containsKey("hibernate.connection.url") && (url = mergedSettings.configurationValues.get("hibernate.connection.url")) != null && (!(url instanceof String) || StringHelper.isNotEmpty((String)url))) {
            this.applyJdbcSettings(url, ConfigurationHelper.getString("hibernate.connection.driver_class", mergedSettings.configurationValues), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.configurationValues.containsKey("jakarta.persistence.jdbc.url") && (url = mergedSettings.configurationValues.get("jakarta.persistence.jdbc.url")) != null && (!(url instanceof String) || StringHelper.isNotEmpty((String)url))) {
            this.applyJdbcSettings(url, ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.configurationValues), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.configurationValues.containsKey("javax.persistence.jdbc.url")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url");
            url = mergedSettings.configurationValues.get("javax.persistence.jdbc.url");
            if (url != null && (!(url instanceof String) || StringHelper.isNotEmpty((String)url))) {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.configurationValues);
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                this.applyJdbcSettings(url, driver, integrationSettingsCopy, mergedSettings);
                return;
            }
        }
    }

    private void applyDataSource(Object dataSourceRef, Boolean useJtaDataSource, HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        String jakartaInverseEmfKey;
        String inverseEmfKey;
        String jakartaEmfKey;
        String emfKey;
        boolean isJta;
        boolean isJtaTransactionCoordinator = (Boolean)mergedSettings.configurationValues.remove(IS_JTA_TXN_COORD);
        boolean bl = isJta = useJtaDataSource == null ? isJtaTransactionCoordinator : useJtaDataSource;
        if (isJta) {
            emfKey = "javax.persistence.jtaDataSource";
            jakartaEmfKey = "jakarta.persistence.jtaDataSource";
            inverseEmfKey = "javax.persistence.nonJtaDataSource";
            jakartaInverseEmfKey = "jakarta.persistence.nonJtaDataSource";
        } else {
            emfKey = "javax.persistence.nonJtaDataSource";
            jakartaEmfKey = "jakarta.persistence.nonJtaDataSource";
            inverseEmfKey = "javax.persistence.jtaDataSource";
            jakartaInverseEmfKey = "jakarta.persistence.jtaDataSource";
        }
        mergedSettings.configurationValues.put(emfKey, dataSourceRef);
        mergedSettings.configurationValues.put(jakartaEmfKey, dataSourceRef);
        this.cleanUpConfigKeys(integrationSettingsCopy, mergedSettings, inverseEmfKey, jakartaInverseEmfKey, "javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver", "hibernate.connection.driver_class", "javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url", "hibernate.connection.url");
        this.cleanUpConfigKeys(integrationSettingsCopy, "hibernate.connection.datasource", "javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
        mergedSettings.configurationValues.put("hibernate.connection.datasource", dataSourceRef);
    }

    private void cleanUpConfigKeys(HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings, String ... keys) {
        for (String key : keys) {
            Object removedMergedSetting;
            Object removedIntgSetting = integrationSettingsCopy.remove(key);
            if (removedIntgSetting != null) {
                LOG.debugf("Removed integration override setting [%s] due to normalization", key);
            }
            if ((removedMergedSetting = mergedSettings.configurationValues.remove(key)) == null) continue;
            LOG.debugf("Removed merged setting [%s] due to normalization", key);
        }
    }

    private void cleanUpConfigKeys(Map<?, ?> settings, String ... keys) {
        for (String key : keys) {
            settings.remove(key);
        }
    }

    private void applyJdbcSettings(Object url, String driver, HashMap<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        mergedSettings.configurationValues.put("hibernate.connection.url", url);
        mergedSettings.configurationValues.put("javax.persistence.jdbc.url", url);
        mergedSettings.configurationValues.put("jakarta.persistence.jdbc.url", url);
        if (driver != null) {
            mergedSettings.configurationValues.put("hibernate.connection.driver_class", driver);
            mergedSettings.configurationValues.put("javax.persistence.jdbc.driver", driver);
            mergedSettings.configurationValues.put("jakarta.persistence.jdbc.driver", driver);
        } else {
            mergedSettings.configurationValues.remove("hibernate.connection.driver_class");
            mergedSettings.configurationValues.remove("javax.persistence.jdbc.driver");
            mergedSettings.configurationValues.remove("jakarta.persistence.jdbc.driver");
        }
        this.cleanUpConfigKeys(integrationSettingsCopy, "hibernate.connection.driver_class", "javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver", "hibernate.connection.url", "javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url", "hibernate.connection.username", "javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user", "hibernate.connection.password", "javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
        this.cleanUpConfigKeys(integrationSettingsCopy, mergedSettings, "hibernate.connection.datasource", "javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
    }

    private void processHibernateConfigXmlResources(StandardServiceRegistryBuilder ssrBuilder, MergedSettings mergedSettings, String cfgXmlResourceName) {
        LoadedConfig loadedConfig = ssrBuilder.getConfigLoader().loadConfigXmlResource(cfgXmlResourceName);
        mergedSettings.processHibernateConfigXmlResources(loadedConfig);
        ssrBuilder.getAggregatedCfgXml().merge(loadedConfig);
    }

    private CacheRegionDefinition parseCacheRegionDefinitionEntry(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
                error.append("hibernate.classcache").append(": ").append("hibernate.classcache");
            } else {
                error.append("hibernate.collectioncache").append(": ").append("hibernate.collectioncache");
            }
            error.append('.').append(role).append(' ').append(value).append(".  Was expecting configuration (usage[,region[,lazy]]), but found none");
            throw this.persistenceException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        boolean lazyProperty = true;
        if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
        } else {
            lazyProperty = false;
        }
        return new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
    }

    private List<ConverterDescriptor> applyMappingResources(MetadataSources metadataSources) {
        List explicitOrmXmlList;
        String explicitHbmXmls;
        ArrayList<ClassBasedConverterDescriptor> converterDescriptors = null;
        List loadedAnnotatedClasses = (List)this.configurationValues.remove("hibernate.loaded_classes");
        if (loadedAnnotatedClasses != null) {
            for (String[] cls : loadedAnnotatedClasses) {
                if (AttributeConverter.class.isAssignableFrom((Class<?>)cls)) {
                    if (converterDescriptors == null) {
                        converterDescriptors = new ArrayList<ClassBasedConverterDescriptor>();
                    }
                    converterDescriptors.add(new ClassBasedConverterDescriptor((Class<? extends AttributeConverter<?, ?>>)cls, this.metamodelBuilder.getBootstrapContext().getClassmateContext()));
                    continue;
                }
                metadataSources.addAnnotatedClass((Class<?>)cls);
            }
        }
        if ((explicitHbmXmls = (String)this.configurationValues.remove("hibernate.hbm_xml_files")) != null) {
            for (String hbmXml : StringHelper.split(", ", explicitHbmXmls)) {
                metadataSources.addResource(hbmXml);
            }
        }
        if ((explicitOrmXmlList = (List)this.configurationValues.remove("hibernate.orm_xml_files")) != null) {
            explicitOrmXmlList.forEach(metadataSources::addResource);
        }
        return converterDescriptors;
    }

    private void applyMetamodelBuilderSettings(MergedSettings mergedSettings, List<ConverterDescriptor> converterDescriptors) {
        this.metamodelBuilder.getBootstrapContext().markAsJpaBootstrap();
        if (this.persistenceUnit.getTempClassLoader() != null) {
            this.metamodelBuilder.applyTempClassLoader(this.persistenceUnit.getTempClassLoader());
        }
        this.metamodelBuilder.applyScanEnvironment(new StandardJpaScanEnvironmentImpl(this.persistenceUnit));
        this.metamodelBuilder.applyScanOptions(new StandardScanOptions((String)this.configurationValues.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses()));
        if (mergedSettings.cacheRegionDefinitions != null) {
            mergedSettings.cacheRegionDefinitions.forEach(this.metamodelBuilder::applyCacheRegionDefinition);
        }
        this.applyTypeContributors();
        if (converterDescriptors != null) {
            converterDescriptors.forEach(this.metamodelBuilder::applyAttributeConverter);
        }
    }

    private void applyTypeContributors() {
        TypeContributorList typeContributorList = (TypeContributorList)this.configurationValues.remove(TYPE_CONTRIBUTORS);
        if (typeContributorList != null) {
            typeContributorList.getTypeContributors().forEach(this.metamodelBuilder::applyTypes);
        }
        StandardServiceRegistry serviceRegistry = this.metamodelBuilder.getBootstrapContext().getServiceRegistry();
        ClassLoaderService cls = serviceRegistry.getService(ClassLoaderService.class);
        Collection<TypeContributor> typeContributors = cls.loadJavaServices(TypeContributor.class);
        typeContributors.forEach(this.metamodelBuilder::applyTypes);
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    @Override
    public ManagedResources getManagedResources() {
        return this.managedResources;
    }

    @Override
    public MetadataImplementor metadata() {
        if (this.metadata == null) {
            this.metadata = MetadataBuildingProcess.complete(this.managedResources, this.metamodelBuilder.getBootstrapContext(), this.metamodelBuilder.getMetadataBuildingOptions());
        }
        return this.metadata;
    }

    @Override
    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        this.validatorFactory = validatorFactory;
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory(validatorFactory);
        }
        return this;
    }

    @Override
    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public void cancel() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.standardServiceRegistry instanceof ServiceRegistryImplementor && this.standardServiceRegistry instanceof ServiceBinding.ServiceLifecycleOwner) {
            ServiceRegistryImplementor serviceRegistry = (ServiceRegistryImplementor)((Object)this.standardServiceRegistry);
            ServiceBinding.ServiceLifecycleOwner lifecycleOwner = (ServiceBinding.ServiceLifecycleOwner)((Object)serviceRegistry);
            ServiceBinding<ConnectionProvider> binding = serviceRegistry.locateServiceBinding(ConnectionProvider.class);
            if (binding != null && binding.getService() instanceof Stoppable) {
                lifecycleOwner.stopService(binding);
                binding.setService(null);
            }
        }
    }

    @Override
    public void generateSchema() {
        try {
            SessionFactoryBuilder sfBuilder = this.metadata().getSessionFactoryBuilder();
            this.populateSfBuilder(sfBuilder, this.standardServiceRegistry);
            SchemaManagementToolCoordinator.process(this.metadata, this.standardServiceRegistry, this.configurationValues, DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw this.persistenceException("Error performing schema management", e);
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public EntityManagerFactory build() {
        boolean success = false;
        try {
            SessionFactoryBuilder sfBuilder = this.metadata().getSessionFactoryBuilder();
            this.populateSfBuilder(sfBuilder, this.standardServiceRegistry);
            try {
                SessionFactory emf = sfBuilder.build();
                success = true;
                SessionFactory sessionFactory = emf;
                return sessionFactory;
            }
            catch (Exception e) {
                throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
            }
        }
        finally {
            if (!success) {
                this.cleanup();
            }
        }
    }

    protected void populateSfBuilder(SessionFactoryBuilder sfBuilder, StandardServiceRegistry ssr) {
        Object sessionFactoryObserverSetting;
        boolean allowRefreshDetachedEntity;
        StrategySelector strategySelector = ssr.getService(StrategySelector.class);
        boolean jtaTransactionAccessEnabled = this.readBooleanConfigurationValue("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableJtaTransactionAccess();
        }
        if (!(allowRefreshDetachedEntity = this.readBooleanConfigurationValue("hibernate.allow_refresh_detached_entity"))) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableRefreshDetachedEntity();
        }
        if ((sessionFactoryObserverSetting = this.configurationValues.remove("hibernate.session_factory_observer")) != null) {
            SessionFactoryObserver suppliedSessionFactoryObserver = strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            sfBuilder.addSessionFactoryObservers(suppliedSessionFactoryObserver);
        }
        sfBuilder.addSessionFactoryObservers(ServiceRegistryCloser.INSTANCE);
        sfBuilder.applyEntityNotFoundDelegate(JpaEntityNotFoundDelegate.INSTANCE);
        if (this.validatorFactory != null) {
            sfBuilder.applyValidatorFactory(this.validatorFactory);
        }
    }

    private PersistenceException persistenceException(String message) {
        return this.persistenceException(message, null);
    }

    protected PersistenceException persistenceException(String message, Exception cause) {
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnit.getName() + "] ";
    }

    private <T> T loadSettingInstance(String settingName, Object settingValue, Class<T> clazz) {
        Object instance = null;
        Class<Object> instanceClass = null;
        if (clazz.isAssignableFrom(settingValue.getClass())) {
            instance = settingValue;
        } else if (settingValue instanceof Class) {
            instanceClass = (Class<?>)settingValue;
        } else if (settingValue instanceof String) {
            String settingStringValue = (String)settingValue;
            if (this.standardServiceRegistry != null) {
                ClassLoaderService classLoaderService = this.standardServiceRegistry.getService(ClassLoaderService.class);
                instanceClass = classLoaderService.classForName(settingStringValue);
            } else {
                try {
                    instanceClass = Class.forName(settingStringValue);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Can't load class: " + settingStringValue, e);
                }
            }
        } else {
            throw new IllegalArgumentException("The provided " + settingName + " setting value [" + settingValue + "] is not supported");
        }
        if (instanceClass != null) {
            try {
                instance = instanceClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("The " + clazz.getSimpleName() + " class [" + instanceClass + "] could not be instantiated", e);
            }
        }
        return (T)instance;
    }

    protected StandardServiceRegistry getStandardServiceRegistry() {
        return this.standardServiceRegistry;
    }

    public static class MergedSettings {
        private final Map<String, Object> configurationValues = new ConcurrentHashMap<String, Object>(16, 0.75f, 1);
        private List<CacheRegionDefinition> cacheRegionDefinitions;

        private MergedSettings() {
            this.configurationValues.putAll(PropertiesHelper.map(Environment.getProperties()));
        }

        public void processPersistenceUnitDescriptorProperties(PersistenceUnitDescriptor persistenceUnit) {
            if (persistenceUnit.getProperties() != null) {
                this.configurationValues.putAll(PropertiesHelper.map(persistenceUnit.getProperties()));
            }
            this.configurationValues.put("hibernate.persistenceUnitName", persistenceUnit.getName());
        }

        public void processHibernateConfigXmlResources(LoadedConfig loadedConfig) {
            String sfName;
            if (!this.configurationValues.containsKey("hibernate.session_factory_name") && (sfName = loadedConfig.getSessionFactoryName()) != null) {
                this.configurationValues.put("hibernate.session_factory_name", sfName);
            }
            this.configurationValues.putAll(loadedConfig.getConfigurationValues());
        }

        public Map<String, Object> getConfigurationValues() {
            return this.configurationValues;
        }

        private void addCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
            if (this.cacheRegionDefinitions == null) {
                this.cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
            }
            this.cacheRegionDefinitions.add(cacheRegionDefinition);
        }
    }

    private static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        public static final ServiceRegistryCloser INSTANCE = new ServiceRegistryCloser();

        private ServiceRegistryCloser() {
        }

        @Override
        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        @Override
        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        public static final JpaEntityNotFoundDelegate INSTANCE = new JpaEntityNotFoundDelegate();

        private JpaEntityNotFoundDelegate() {
        }

        @Override
        public void handleEntityNotFound(String entityName, Object id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

