# coding: utf-8

"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from airflow_client.client.models.hitl_user import HITLUser
from airflow_client.client.models.task_instance_response import TaskInstanceResponse
from typing import Optional, Set
from typing_extensions import Self

class HITLDetail(BaseModel):
    """
    Schema for Human-in-the-loop detail.
    """ # noqa: E501
    assigned_users: Optional[List[HITLUser]] = None
    body: Optional[StrictStr] = None
    chosen_options: Optional[List[StrictStr]] = None
    created_at: datetime
    defaults: Optional[List[StrictStr]] = None
    multiple: Optional[StrictBool] = False
    options: Annotated[List[StrictStr], Field(min_length=1)]
    params: Optional[Dict[str, Any]] = None
    params_input: Optional[Dict[str, Any]] = None
    responded_at: Optional[datetime] = None
    responded_by_user: Optional[HITLUser] = None
    response_received: Optional[StrictBool] = False
    subject: StrictStr
    task_instance: TaskInstanceResponse
    __properties: ClassVar[List[str]] = ["assigned_users", "body", "chosen_options", "created_at", "defaults", "multiple", "options", "params", "params_input", "responded_at", "responded_by_user", "response_received", "subject", "task_instance"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HITLDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assigned_users (list)
        _items = []
        if self.assigned_users:
            for _item_assigned_users in self.assigned_users:
                if _item_assigned_users:
                    _items.append(_item_assigned_users.to_dict())
            _dict['assigned_users'] = _items
        # override the default output from pydantic by calling `to_dict()` of responded_by_user
        if self.responded_by_user:
            _dict['responded_by_user'] = self.responded_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_instance
        if self.task_instance:
            _dict['task_instance'] = self.task_instance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HITLDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assigned_users": [HITLUser.from_dict(_item) for _item in obj["assigned_users"]] if obj.get("assigned_users") is not None else None,
            "body": obj.get("body"),
            "chosen_options": obj.get("chosen_options"),
            "created_at": obj.get("created_at"),
            "defaults": obj.get("defaults"),
            "multiple": obj.get("multiple") if obj.get("multiple") is not None else False,
            "options": obj.get("options"),
            "params": obj.get("params"),
            "params_input": obj.get("params_input"),
            "responded_at": obj.get("responded_at"),
            "responded_by_user": HITLUser.from_dict(obj["responded_by_user"]) if obj.get("responded_by_user") is not None else None,
            "response_received": obj.get("response_received") if obj.get("response_received") is not None else False,
            "subject": obj.get("subject"),
            "task_instance": TaskInstanceResponse.from_dict(obj["task_instance"]) if obj.get("task_instance") is not None else None
        })
        return _obj


