/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.config;

import jakarta.xml.ws.RespectBindingFeature;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.validator.EndpointDescriptionValidator;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.util.WSDLExtensionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RespectBindingConfigurator
implements ClientConfigurator {
    private static final Log log = LogFactory.getLog(RespectBindingConfigurator.class);

    @Override
    public void configure(MessageContext messageContext, BindingProvider provider) {
        Binding bnd;
        RespectBindingFeature respectBindingFeature;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking RespectBindingConfiguration.configure() on client");
        }
        if ((respectBindingFeature = (RespectBindingFeature)(bnd = (Binding)provider.getBinding()).getFeature("jakarta.xml.ws.RespectBindingFeature")) == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"respectBindingNotSpecified"));
        }
        boolean isEnabled = respectBindingFeature.isEnabled();
        if (isEnabled) {
            if (bnd instanceof SOAPBinding) {
                ((SOAPBinding)bnd).setRespectBindingEnabled(isEnabled);
            }
            EndpointDescription endpointDescription = provider.getEndpointDescription();
            endpointDescription.setRespectBinding(isEnabled);
            WSDLExtensionUtils.processExtensions((EndpointDescription)endpointDescription);
            EndpointDescriptionValidator endpointValidator = new EndpointDescriptionValidator(endpointDescription);
            boolean isEndpointValid = endpointValidator.validate(true);
            if (!isEndpointValid) {
                String msg = Messages.getMessage((String)"endpointDescriptionValidationErrors", (String)endpointValidator.toString());
                throw ExceptionFactory.makeWebServiceException((String)msg);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit from RespectBindingConfiguration.configure() on client.");
        }
    }

    @Override
    public boolean supports(Binding binding) {
        return true;
    }
}

