/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axis2.corba.exceptions.PreProcessorException;

public class PreProcessorInputStream
extends InputStream {
    public static int MAX_DEPTH = 99;
    protected String[] userIncludePaths;
    protected String[] systemIncludePaths;
    protected String currentFile;
    protected String parentPath;
    protected StringBuffer idlContent;
    protected int contentLength;
    protected int lastRead = 0;

    public PreProcessorInputStream(String parentPath, String idlFilename) throws PreProcessorException {
        this(parentPath, idlFilename, new String[0], new String[0]);
    }

    public PreProcessorInputStream(String parentPath, String idlFilename, String[] userIncludePaths, String[] systemIncludePaths) throws PreProcessorException {
        this.userIncludePaths = userIncludePaths;
        this.systemIncludePaths = systemIncludePaths;
        this.parentPath = parentPath;
        this.currentFile = parentPath + File.separator + idlFilename;
        InputStream idlStream = this.getInputStream(parentPath, idlFilename);
        if (idlFilename == null) {
            throw new PreProcessorException("Cannot find the file " + parentPath + File.separator + idlFilename);
        }
        this.idlContent = this.readIdl(idlStream, 0);
        this.contentLength = this.idlContent.length();
    }

    protected StringBuffer readIdl(InputStream idlStream, int depth) throws PreProcessorException {
        StringBuffer buffer = new StringBuffer();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(idlStream));
        lineNumberReader.setLineNumber(1);
        HashMap<String, String> defs = new HashMap<String, String>();
        Stack<Boolean> ifdefValue = new Stack<Boolean>();
        boolean validLine = true;
        boolean elseNotValid = false;
        String lastLine = null;
        while (true) {
            Object line;
            try {
                line = lineNumberReader.readLine();
            }
            catch (IOException e) {
                throw new PreProcessorException("Error while reading next line" + this.getLineNoString(lineNumberReader), e);
            }
            if (line == null) break;
            if (((String)line).startsWith("#")) {
                line = ((String)line).trim();
            }
            if (lastLine != null) {
                line = lastLine + " " + (String)line;
                lastLine = null;
            }
            if (!ifdefValue.empty() && !((Boolean)ifdefValue.peek()).booleanValue() && !((String)line).startsWith("#")) continue;
            if (((String)line).startsWith("#") && ((String)line).endsWith("\\")) {
                lastLine = ((String)line).substring(0, ((String)line).lastIndexOf("\\"));
                continue;
            }
            if (((String)line).startsWith("#include") && validLine) {
                if (depth < MAX_DEPTH) {
                    String inc = ((String)line).replaceAll("#include", "").trim();
                    this.addComment(buffer, (String)line);
                    InputStream incis = this.resolveInclude(inc, this.getLineNoString(lineNumberReader));
                    buffer.append(this.readIdl(incis, depth + 1));
                    this.addComment(buffer, "end of " + (String)line);
                    continue;
                }
                throw new PreProcessorException("More than " + MAX_DEPTH + " nested #includes are not allowed" + this.getLineNoString(lineNumberReader));
            }
            if (((String)line).startsWith("#define")) {
                String def = ((String)line).replaceAll("#define", "").trim();
                StringTokenizer tok = new StringTokenizer(def = def.replaceAll("\"", ""), " ");
                if (tok.countTokens() == 1) {
                    def = tok.nextToken();
                    if (defs.containsKey(def)) {
                        throw new PreProcessorException("Variable " + def + " is already defined" + this.getLineNoString(lineNumberReader));
                    }
                    defs.put(def, null);
                } else if (tok.countTokens() == 2) {
                    defs.put(tok.nextToken(), tok.nextToken());
                }
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#undef")) {
                String def = ((String)line).replaceAll("#undef", "").trim();
                if (!defs.containsKey(def = def.replaceAll("\"", ""))) {
                    throw new PreProcessorException("Undifined variable " + def + this.getLineNoString(lineNumberReader));
                }
                defs.remove(def);
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#ifdef")) {
                String def = ((String)line).replaceAll("#ifdef", "").trim();
                if (defs.containsKey(def = def.replaceAll("\"", ""))) {
                    ifdefValue.push(Boolean.TRUE);
                } else {
                    validLine = false;
                    ifdefValue.push(Boolean.FALSE);
                }
                elseNotValid = false;
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#ifndef")) {
                String def = ((String)line).replaceAll("#ifndef", "").trim();
                if (defs.containsKey(def = def.replaceAll("\"", ""))) {
                    validLine = false;
                    ifdefValue.push(Boolean.FALSE);
                } else {
                    ifdefValue.push(Boolean.TRUE);
                }
                elseNotValid = false;
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#else")) {
                if (elseNotValid) {
                    throw new PreProcessorException("Invalid #else preprocessor directive" + this.getLineNoString(lineNumberReader));
                }
                boolean lastval = (Boolean)ifdefValue.peek();
                ifdefValue.setElementAt(new Boolean(!lastval), ifdefValue.size() - 1);
                validLine = this.isAllTrue(ifdefValue);
                elseNotValid = true;
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#endif")) {
                if (ifdefValue.empty()) {
                    throw new PreProcessorException("Invalid #endif preprocessor directive" + this.getLineNoString(lineNumberReader));
                }
                ifdefValue.pop();
                validLine = this.isAllTrue(ifdefValue);
                elseNotValid = false;
                this.addComment(buffer, (String)line);
                continue;
            }
            if (((String)line).startsWith("#")) {
                System.out.println("Ignoring unsupported preprocessor directive " + (String)line + this.getLineNoString(lineNumberReader));
                continue;
            }
            if (!validLine) continue;
            buffer.append((String)line);
            buffer.append('\n');
        }
        if (!ifdefValue.empty()) {
            throw new PreProcessorException("One or more #ifdef/#ifndef preprocessor directives are not properly closed" + this.getLineNoString(lineNumberReader));
        }
        try {
            lineNumberReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    protected InputStream resolveInclude(String include, String lineNoString) throws PreProcessorException {
        try {
            if (include.startsWith("\"") && include.endsWith("\"")) {
                File incFile = new File(include = include.replaceAll("\"", ""));
                if (incFile.exists()) {
                    this.currentFile = incFile.getAbsolutePath();
                    return new FileInputStream(incFile);
                }
                InputStream stream = this.getInputStream(this.parentPath, include);
                if (stream != null) {
                    return stream;
                }
                for (int i = 0; i < this.userIncludePaths.length; ++i) {
                    incFile = this.userIncludePaths[i].endsWith(File.separator) ? new File(this.userIncludePaths[i] + include) : new File(this.userIncludePaths[i] + File.separator + include);
                    if (!incFile.exists()) continue;
                    this.currentFile = incFile.getAbsolutePath();
                    return new FileInputStream(incFile);
                }
                throw new PreProcessorException("Unable to resolve include " + include + lineNoString);
            }
            if (include.startsWith("<") && include.endsWith(">")) {
                include = include.replaceAll("<", "");
                include = include.replaceAll(">", "");
                for (int i = 0; i < this.systemIncludePaths.length; ++i) {
                    File incFile = this.systemIncludePaths[i].endsWith(File.separator) ? new File(this.systemIncludePaths[i] + include) : new File(this.systemIncludePaths[i] + File.separator + include);
                    if (!incFile.exists()) continue;
                    this.currentFile = incFile.getAbsolutePath();
                    return new FileInputStream(incFile);
                }
                throw new PreProcessorException("Unable to resolve include " + include + lineNoString);
            }
            throw new PreProcessorException("Include name must be enclosed in '< >' or '\" \"'" + lineNoString);
        }
        catch (FileNotFoundException e) {
            throw new PreProcessorException("Unable to resolve include " + include + lineNoString, e);
        }
    }

    protected InputStream getInputStream(String parent, String filename) throws PreProcessorException {
        File parentFile = new File(parent);
        try {
            ZipEntry entry;
            if (parentFile.isDirectory()) {
                return new FileInputStream(parent + File.separator + filename);
            }
            ZipInputStream zin = new ZipInputStream(new FileInputStream(parentFile));
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equalsIgnoreCase(filename)) continue;
                return zin;
            }
            return null;
        }
        catch (IOException e) {
            throw new PreProcessorException("Unable to pre-process file " + parent + File.separator + filename, e);
        }
    }

    private boolean isAllTrue(Stack stack) {
        if (stack.empty()) {
            return true;
        }
        for (Boolean value : stack) {
            if (value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void addComment(StringBuffer buffer, String line) {
        buffer.append("/* ");
        buffer.append(line);
        buffer.append(" */\n");
    }

    private String getLineNoString(LineNumberReader lineNumberReader) {
        int lineNo;
        if (lineNumberReader != null && (lineNo = lineNumberReader.getLineNumber()) > 0) {
            return " (file:" + this.currentFile + ", line:" + (lineNo - 1) + ")";
        }
        return "";
    }

    @Override
    public int read() throws IOException {
        return this.contentLength > this.lastRead ? (int)this.idlContent.charAt(this.lastRead++) : -1;
    }
}

