/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp.dependencies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.util.TaskEvent;
import org.openjdk.source.util.TaskListener;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.comp.PubAPIs;
import org.openjdk.tools.sjavac.pubapi.PubApi;

public class PublicApiCollector
implements TaskListener {
    private Context context;
    private final Set<Symbol.ClassSymbol> classSymbols = new HashSet<Symbol.ClassSymbol>();
    private final Collection<JavaFileObject> explicitJFOs;
    private Map<String, PubApi> explicitPubApis;
    private Map<String, PubApi> nonExplicitPubApis;

    public PublicApiCollector(Context context, Collection<JavaFileObject> collection) {
        this.context = context;
        this.explicitJFOs = collection;
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        switch (taskEvent.getKind()) {
            case ANALYZE: {
                this.collectClassSymbols((JCTree.JCCompilationUnit)taskEvent.getCompilationUnit());
                break;
            }
            case COMPILATION: {
                Log.debug("Compilation finished");
                Log.debug("Extracting pub APIs for the following symbols:");
                for (Symbol.ClassSymbol classSymbol : this.classSymbols) {
                    Log.debug("    " + classSymbol.fullname);
                }
                this.extractPubApis();
                PubAPIs pubAPIs = PubAPIs.instance(this.context);
                this.explicitPubApis = pubAPIs.getPubapis(this.explicitJFOs, true);
                this.nonExplicitPubApis = pubAPIs.getPubapis(this.explicitJFOs, false);
                Log.debug("done");
            }
        }
    }

    private void collectClassSymbols(JCTree.JCCompilationUnit jCCompilationUnit) {
        for (Tree tree : jCCompilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            this.classSymbols.add(((JCTree.JCClassDecl)tree).sym);
        }
    }

    private void extractPubApis() {
        PubAPIs pubAPIs = PubAPIs.instance(this.context);
        this.classSymbols.forEach(pubAPIs::visitPubapi);
    }

    public Map<String, PubApi> getPubApis(boolean bl) {
        return bl ? this.explicitPubApis : this.nonExplicitPubApis;
    }
}

