/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.axis2.transport.testkit.http;

import java.io.IOException;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import org.apache.axis2.transport.testkit.endpoint.AsyncEndpoint;
import org.apache.axis2.transport.testkit.endpoint.InOnlyEndpointSupport;
import org.apache.axis2.transport.testkit.message.IncomingMessage;
import org.apache.axis2.transport.testkit.name.Name;
import org.apache.axis2.transport.testkit.tests.Setup;
import org.apache.axis2.transport.testkit.tests.Transient;

@Name("jetty")
public abstract class JettyAsyncEndpoint<M> extends JettyEndpoint implements AsyncEndpoint<M> {
    private @Transient InOnlyEndpointSupport<M> support;
    
    @Setup @SuppressWarnings("unused")
    private void setUp() throws Exception {
        support = new InOnlyEndpointSupport<M>();
    }
    
    @Override
    protected void handle(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        
        support.putMessage(handle(request));
    }
    
    protected abstract IncomingMessage<M> handle(HttpServletRequest request) throws ServletException, IOException;
    
    public void clear() throws Exception {
        support.clear();
    }

    public IncomingMessage<M> waitForMessage(int timeout) throws Throwable {
        return support.waitForMessage(timeout);
    }
}
