/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.tools.JsonTransformer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class SSTableExport {
    private static final String KEY_OPTION = "k";
    private static final String DEBUG_OUTPUT_OPTION = "d";
    private static final String EXCLUDE_KEY_OPTION = "x";
    private static final String ENUMERATE_KEYS_OPTION = "e";
    private static final String RAW_TIMESTAMPS = "t";
    private static final Options options = new Options();
    private static CommandLine cmd;

    public static CFMetaData metadataFromSSTable(Descriptor desc) throws IOException {
        if (!desc.version.storeRows()) {
            throw new IOException("pre-3.0 SSTable is not supported.");
        }
        EnumSet<MetadataType> types = EnumSet.of(MetadataType.STATS, MetadataType.HEADER);
        Map<MetadataType, MetadataComponent> sstableMetadata = desc.getMetadataSerializer().deserialize(desc, types);
        SerializationHeader.Component header = (SerializationHeader.Component)sstableMetadata.get((Object)MetadataType.HEADER);
        IPartitioner partitioner = FBUtilities.newPartitioner(desc);
        CFMetaData.Builder builder = CFMetaData.Builder.create("keyspace", "table").withPartitioner(partitioner);
        header.getStaticColumns().entrySet().stream().forEach(entry -> {
            ColumnIdentifier ident = ColumnIdentifier.getInterned(UTF8Type.instance.getString((ByteBuffer)entry.getKey()), true);
            builder.addStaticColumn(ident, (AbstractType)entry.getValue());
        });
        header.getRegularColumns().entrySet().stream().forEach(entry -> {
            ColumnIdentifier ident = ColumnIdentifier.getInterned(UTF8Type.instance.getString((ByteBuffer)entry.getKey()), true);
            builder.addRegularColumn(ident, (AbstractType)entry.getValue());
        });
        builder.addPartitionKey("PartitionKey", header.getKeyType());
        for (int i = 0; i < header.getClusteringTypes().size(); ++i) {
            builder.addClusteringColumn("clustering" + (i > 0 ? Integer.valueOf(i) : ""), header.getClusteringTypes().get(i));
        }
        return builder.build();
    }

    private static <T> Stream<T> iterToStream(Iterator<T> iter) {
        Spliterator<T> splititer = Spliterators.spliteratorUnknownSize(iter, 1024);
        return StreamSupport.stream(splititer, false);
    }

    public static void main(String[] args) throws ConfigurationException {
        block24: {
            PosixParser parser = new PosixParser();
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e1) {
                System.err.println(e1.getMessage());
                SSTableExport.printUsage();
                System.exit(1);
            }
            if (cmd.getArgs().length != 1) {
                System.err.println("You must supply exactly one sstable");
                SSTableExport.printUsage();
                System.exit(1);
            }
            String[] keys = cmd.getOptionValues(KEY_OPTION);
            HashSet<String> excludes = new HashSet<String>(Arrays.asList(cmd.getOptionValues(EXCLUDE_KEY_OPTION) == null ? new String[]{} : cmd.getOptionValues(EXCLUDE_KEY_OPTION)));
            String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
            if (Descriptor.isLegacyFile(new File(ssTableFileName))) {
                System.err.println("Unsupported legacy sstable");
                System.exit(1);
            }
            if (!new File(ssTableFileName).exists()) {
                System.err.println("Cannot find file " + ssTableFileName);
                System.exit(1);
            }
            Descriptor desc = Descriptor.fromFilename(ssTableFileName);
            try {
                ISSTableScanner currentScanner;
                CFMetaData metadata = SSTableExport.metadataFromSSTable(desc);
                if (cmd.hasOption(ENUMERATE_KEYS_OPTION)) {
                    try (KeyIterator iter = new KeyIterator(desc, metadata);){
                        JsonTransformer.keysToJson(null, SSTableExport.iterToStream(iter), cmd.hasOption(RAW_TIMESTAMPS), metadata, System.out);
                        break block24;
                    }
                }
                SSTableReader sstable = SSTableReader.openNoValidation(desc, metadata);
                IPartitioner partitioner = sstable.getPartitioner();
                if (keys != null && keys.length > 0) {
                    List bounds = Arrays.stream(keys).filter(key -> !excludes.contains(key)).map(metadata.getKeyValidator()::fromString).map(partitioner::decorateKey).sorted().map(DecoratedKey::getToken).map(token -> new Bounds<Token.KeyBound>(token.minKeyBound(), token.maxKeyBound())).collect(Collectors.toList());
                    currentScanner = sstable.getScanner(bounds.iterator());
                } else {
                    currentScanner = sstable.getScanner();
                }
                Stream<UnfilteredRowIterator> partitions = SSTableExport.iterToStream(currentScanner).filter(i -> excludes.isEmpty() || !excludes.contains(metadata.getKeyValidator().getString(i.partitionKey().getKey())));
                if (cmd.hasOption(DEBUG_OUTPUT_OPTION)) {
                    AtomicLong position = new AtomicLong();
                    partitions.forEach(partition -> {
                        position.set(currentScanner.getCurrentPosition());
                        if (!partition.partitionLevelDeletion().isLive()) {
                            System.out.println("[" + metadata.getKeyValidator().getString(partition.partitionKey().getKey()) + "]@" + position.get() + " " + partition.partitionLevelDeletion());
                        }
                        if (!partition.staticRow().isEmpty()) {
                            System.out.println("[" + metadata.getKeyValidator().getString(partition.partitionKey().getKey()) + "]@" + position.get() + " " + partition.staticRow().toString(metadata, true));
                        }
                        partition.forEachRemaining(row -> {
                            System.out.println("[" + metadata.getKeyValidator().getString(partition.partitionKey().getKey()) + "]@" + position.get() + " " + row.toString(metadata, false, true));
                            position.set(currentScanner.getCurrentPosition());
                        });
                    });
                } else {
                    JsonTransformer.toJson(currentScanner, partitions, cmd.hasOption(RAW_TIMESTAMPS), metadata, System.out);
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        System.exit(0);
    }

    private static void printUsage() {
        String usage = String.format("sstabledump <sstable file path> <options>%n", new Object[0]);
        String header = "Dump contents of given SSTable to standard output in JSON format.";
        new HelpFormatter().printHelp(usage, header, options, "");
    }

    static {
        DatabaseDescriptor.toolInitialization();
        Option optKey = new Option(KEY_OPTION, true, "Partition key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDE_KEY_OPTION, true, "Excluded partition key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATE_KEYS_OPTION, false, "enumerate partition keys only");
        options.addOption(optEnumerate);
        Option debugOutput = new Option(DEBUG_OUTPUT_OPTION, false, "CQL row per line internal representation");
        options.addOption(debugOutput);
        Option rawTimestamps = new Option(RAW_TIMESTAMPS, false, "Print raw timestamps instead of iso8601 date strings");
        options.addOption(rawTimestamps);
    }
}

