/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.acl.AuthCache;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.SystemAuthDatabaseAccessor;
import org.apache.cassandra.sidecar.exceptions.SchemaUnavailableException;

@Singleton
public class IdentityToRoleCache
extends AuthCache<String, String> {
    private static final String NAME = "identity_to_role_cache";

    @Inject
    public IdentityToRoleCache(Vertx vertx, ExecutorPools executorPools, SidecarConfiguration sidecarConfiguration, SystemAuthDatabaseAccessor systemAuthDatabaseAccessor) {
        super(NAME, vertx, executorPools, systemAuthDatabaseAccessor::findRoleFromIdentity, systemAuthDatabaseAccessor::findAllIdentityToRoles, sidecarConfiguration.accessControlConfiguration().permissionCacheConfiguration());
    }

    public boolean containsKey(String identity) {
        try {
            return this.cache() != null && this.get(identity) != null;
        }
        catch (SchemaUnavailableException e) {
            return false;
        }
    }
}

