/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import com.google.inject.Inject;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.acl.AuthCache;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.SystemAuthDatabaseAccessor;

public class SuperUserCache
extends AuthCache<String, Boolean> {
    private static final String NAME = "super_user_cache";

    @Inject
    public SuperUserCache(Vertx vertx, ExecutorPools executorPools, SidecarConfiguration sidecarConfiguration, SystemAuthDatabaseAccessor systemAuthDatabaseAccessor) {
        super(NAME, vertx, executorPools, systemAuthDatabaseAccessor::isSuperUser, systemAuthDatabaseAccessor::findAllRolesToSuperuserStatus, sidecarConfiguration.accessControlConfiguration().permissionCacheConfiguration());
    }

    public boolean isSuperUser(String role) {
        Boolean superUserStatus = (Boolean)this.get(role);
        return superUserStatus != null && superUserStatus != false;
    }
}

