/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.utils.StringUtils;
import org.apache.cassandra.sidecar.coordination.ElectorateMembership;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenZeroOfKeyspaceElectorateMembership
implements ElectorateMembership {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTokenZeroOfKeyspaceElectorateMembership.class);
    protected final InstanceMetadataFetcher instanceMetadataFetcher;

    public AbstractTokenZeroOfKeyspaceElectorateMembership(InstanceMetadataFetcher instanceMetadataFetcher) {
        this.instanceMetadataFetcher = instanceMetadataFetcher;
    }

    @Override
    public boolean isMember() {
        Set<String> localInstancesHostsAndPorts = this.collectLocalInstancesHostsAndPorts();
        if (localInstancesHostsAndPorts.isEmpty()) {
            return false;
        }
        String keyspace = this.keyspaceToDetermineElectorateMembership();
        if (keyspace == null) {
            return false;
        }
        LOGGER.debug("Using keyspace={} to determine electorate membership", (Object)keyspace);
        TokenRangeReplicasResponse tokenRangeReplicas = this.instanceMetadataFetcher.callOnFirstAvailableInstance(instance -> {
            CassandraAdapterDelegate delegate = instance.delegate();
            StorageOperations operations = delegate.storageOperations();
            NodeSettings nodeSettings = delegate.nodeSettings();
            return operations.tokenRangeReplicas(new Name(keyspace), nodeSettings.partitioner());
        });
        return this.anyInstanceOwnsTokenZero(tokenRangeReplicas, localInstancesHostsAndPorts);
    }

    protected abstract String keyspaceToDetermineElectorateMembership();

    protected Set<String> collectLocalInstancesHostsAndPorts() {
        HashSet<String> result = new HashSet<String>();
        for (InstanceMetadata instance : this.instanceMetadataFetcher.allLocalInstances()) {
            try {
                InetSocketAddress address = instance.delegate().localStorageBroadcastAddress();
                result.add(StringUtils.cassandraFormattedHostAndPort((InetSocketAddress)address));
            }
            catch (CassandraUnavailableException exception) {
                LOGGER.warn("Unable to determine local storage broadcast address for instance. instance={}", (Object)instance, (Object)exception);
            }
        }
        return result;
    }

    protected boolean anyInstanceOwnsTokenZero(TokenRangeReplicasResponse tokenRangeReplicas, Set<String> localInstancesHostAndPorts) {
        return tokenRangeReplicas.readReplicas().stream().filter(this::replicaOwnsTokenZero).anyMatch(replicaInfo -> {
            for (List replicas : replicaInfo.replicasByDatacenter().values()) {
                for (String replica : replicas) {
                    if (!localInstancesHostAndPorts.contains(replica)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    protected boolean replicaOwnsTokenZero(TokenRangeReplicasResponse.ReplicaInfo replicaInfo) {
        BigInteger start = new BigInteger(replicaInfo.start());
        BigInteger end = new BigInteger(replicaInfo.end());
        return start.compareTo(BigInteger.ZERO) < 0 && end.compareTo(BigInteger.ZERO) >= 0;
    }
}

