/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdentifiersProvider {
    protected static final String URN = "urn";
    protected static final String LI = "li";
    protected static final String DATA_PLATFORM = "dataPlatform";
    protected static final String DATA_PLATFORM_INSTANCE = "dataPlatformInstance";
    protected static final String CONTAINER = "container";
    protected static final String DATASET = "dataset";
    protected static final String PROD = "PROD";
    protected static final ToStringStyle STYLE = new ToStringStyle(){
        {
            this.setUseShortClassName(false);
            this.setUseClassName(true);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("(");
            this.setFieldSeparatorAtStart(false);
            this.setFieldSeparator(",");
            this.setFieldSeparatorAtEnd(false);
            this.setContentEnd(")");
            this.setDefaultFullDetail(true);
            this.setArrayContentDetail(true);
            this.setArrayStart("(");
            this.setArraySeparator(",");
            this.setArrayEnd(")");
            this.setNullText("null");
        }
    };

    @NotNull
    public String organization() {
        return "Cassandra";
    }

    @NotNull
    public String platform() {
        return "cassandra";
    }

    @NotNull
    public String environment() {
        return "ENVIRONMENT";
    }

    @NotNull
    public String application() {
        return "application";
    }

    @NotNull
    public abstract String cluster();

    @NotNull
    public UUID identifier() {
        return UUID.nameUUIDFromBytes((this.environment() + "." + this.application() + "." + this.cluster()).getBytes(Charset.defaultCharset()));
    }

    @NotNull
    public String urnDataPlatform() {
        return String.format("%s:%s:%s:%s", URN, LI, DATA_PLATFORM, this.platform());
    }

    @NotNull
    public String urnDataPlatformInstance() {
        return String.format("%s:%s:%s:(%s,%s)", URN, LI, DATA_PLATFORM_INSTANCE, this.urnDataPlatform(), this.identifier());
    }

    @NotNull
    public String urnContainer(@NotNull KeyspaceMetadata keyspace) {
        return String.format("%s:%s:%s:%s_%s", URN, LI, CONTAINER, this.identifier(), keyspace.getName());
    }

    @NotNull
    public String urnDataset(@NotNull TableMetadata table) {
        return String.format("%s:%s:%s:(%s,%s.%s.%s,%s)", URN, LI, DATASET, this.urnDataPlatform(), this.identifier(), table.getKeyspace().getName(), table.getName(), PROD);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.organization()).append((Object)this.platform()).append((Object)this.environment()).append((Object)this.application()).append((Object)this.cluster()).append((Object)this.identifier()).toHashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof IdentifiersProvider) {
            IdentifiersProvider that = (IdentifiersProvider)other;
            return new EqualsBuilder().append((Object)this.organization(), (Object)that.organization()).append((Object)this.platform(), (Object)that.platform()).append((Object)this.environment(), (Object)that.environment()).append((Object)this.application(), (Object)that.application()).append((Object)this.cluster(), (Object)that.cluster()).append((Object)this.identifier(), (Object)that.identifier()).isEquals();
        }
        return false;
    }

    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, STYLE).append((Object)this.organization()).append((Object)this.platform()).append((Object)this.environment()).append((Object)this.application()).append((Object)this.cluster()).append((Object)this.identifier()).toString().replaceAll("\\s", "");
    }
}

