/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.common.request.data.NodeCommandRequestPayload;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;

public abstract class NodeCommandHandler
extends AbstractHandler<NodeCommandRequestPayload> {
    protected NodeCommandHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    protected NodeCommandRequestPayload extractParamsOrThrow(RoutingContext ctx) {
        String body = ctx.body().asString();
        if (body == null || body.equalsIgnoreCase("null")) {
            this.logger.warn("Bad request. Received null payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Request body must be JSON with a non-null \"state\" field");
        }
        try {
            return (NodeCommandRequestPayload)Json.decodeValue((String)body, NodeCommandRequestPayload.class);
        }
        catch (DecodeException e) {
            this.logger.warn("Bad request. Received invalid JSON payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid state value: " + e.getMessage());
        }
    }
}

