/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.locator.LocalTokenRangesProvider;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.StringUtils;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.RestoreJobConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.restore.RingTopologyChangeListener;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RingTopologyRefresher
implements PeriodicTask,
LocalTokenRangesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingTopologyRefresher.class);
    private final InstanceMetadataFetcher metadataFetcher;
    private final ReplicaByTokenRangePerKeyspace replicaByTokenRangePerKeyspace;
    private final RestoreJobConfiguration restoreJobConfiguration;
    private final TaskExecutorPool executorPool;
    private final Map<String, Set<RingTopologyChangeListener>> listenersByKeyspace = new ConcurrentHashMap<String, Set<RingTopologyChangeListener>>();

    @Inject
    public RingTopologyRefresher(InstanceMetadataFetcher metadataFetcher, SidecarConfiguration config, ExecutorPools executorPools) {
        this.metadataFetcher = metadataFetcher;
        this.restoreJobConfiguration = config.restoreJobConfiguration();
        this.replicaByTokenRangePerKeyspace = new ReplicaByTokenRangePerKeyspace(this::dispatchRingTopologyChangeAsync);
        this.executorPool = executorPools.internal();
    }

    @Override
    public DurationSpec delay() {
        return this.restoreJobConfiguration.ringTopologyRefreshDelay();
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.replicaByTokenRangePerKeyspace.isEmpty() ? ScheduleDecision.SKIP : ScheduleDecision.EXECUTE;
    }

    @Override
    public synchronized void execute(Promise<Void> promise) {
        this.prepareAndFetch(this::loadAll);
        promise.tryComplete();
    }

    public Set<UUID> allRestoreJobsOfKeyspace(String keyspace) {
        return this.replicaByTokenRangePerKeyspace.jobsByKeyspace.get(keyspace);
    }

    public void register(RestoreJob restoreJob, RingTopologyChangeListener listener) {
        this.replicaByTokenRangePerKeyspace.register(restoreJob);
        this.addRingTopologyChangeListener(restoreJob.keyspaceName, listener);
    }

    public void unregister(RestoreJob restoreJob, RingTopologyChangeListener listener) {
        boolean allRemoved = this.replicaByTokenRangePerKeyspace.unregister(restoreJob);
        if (allRemoved) {
            this.removeRingTopologyChangeListener(restoreJob.keyspaceName, listener);
        }
    }

    public void addRingTopologyChangeListener(String keyspace, RingTopologyChangeListener listener) {
        this.listenersByKeyspace.computeIfAbsent(keyspace, key -> ConcurrentHashMap.newKeySet()).add(listener);
    }

    public void removeRingTopologyChangeListener(String keyspace, RingTopologyChangeListener listener) {
        this.listenersByKeyspace.computeIfPresent(keyspace, (k, v) -> {
            v.remove(listener);
            return v.isEmpty() ? null : v;
        });
    }

    @Nullable
    public TokenRangeReplicasResponse cachedReplicaByTokenRange(RestoreJob restoreJob) {
        return this.replicaByTokenRangePerKeyspace.forRestoreJob(restoreJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Set<TokenRange>> localTokenRanges(String keyspace, boolean forceRefresh) {
        TokenRangeReplicasResponse topology;
        if (forceRefresh) {
            RingTopologyRefresher ringTopologyRefresher = this;
            synchronized (ringTopologyRefresher) {
                topology = this.prepareAndFetch((storageOperations, nodeSettings) -> {
                    String partitioner = nodeSettings.partitioner();
                    return this.replicaByTokenRangePerKeyspace.loadOne(keyspace, k -> storageOperations.tokenRangeReplicas(new Name(keyspace), partitioner));
                });
            }
        } else {
            topology = this.replicaByTokenRangePerKeyspace.topologyOfKeyspace(keyspace);
        }
        return RingTopologyRefresher.calculateLocalTokenRanges(this.metadataFetcher, topology);
    }

    @NotNull
    public static Map<Integer, Set<TokenRange>> calculateLocalTokenRanges(InstanceMetadataFetcher metadataFetcher, TokenRangeReplicasResponse topology) {
        if (topology == null) {
            return Map.of();
        }
        Map<String, Integer> allNodes = topology.replicaMetadata().values().stream().collect(Collectors.toMap(TokenRangeReplicasResponse.ReplicaMetadata::address, TokenRangeReplicasResponse.ReplicaMetadata::port));
        List<InstanceMetadata> localNodes = metadataFetcher.allLocalInstances();
        HashMap<String, InstanceMetadata> localEndpointsToMetadata = new HashMap<String, InstanceMetadata>(localNodes.size());
        for (InstanceMetadata instanceMetadata : localNodes) {
            RingTopologyRefresher.populateEndpointToMetadata(instanceMetadata, allNodes, localEndpointsToMetadata);
        }
        HashMap<Integer, Set<TokenRange>> localTokenRanges = new HashMap<Integer, Set<TokenRange>>(localEndpointsToMetadata.size());
        for (TokenRangeReplicasResponse.ReplicaInfo ri : topology.writeReplicas()) {
            TokenRange range = new TokenRange(Token.from((String)ri.start()), Token.from((String)ri.end()));
            for (List instanceOfDc : ri.replicasByDatacenter().values()) {
                for (String instanceEndpoint : instanceOfDc) {
                    InstanceMetadata instanceMetadata = (InstanceMetadata)localEndpointsToMetadata.get(instanceEndpoint);
                    if (instanceMetadata == null) continue;
                    localTokenRanges.computeIfAbsent(instanceMetadata.id(), k -> new HashSet()).add(range);
                }
            }
        }
        return localTokenRanges;
    }

    public Future<TokenRangeReplicasResponse> replicaByTokenRangeAsync(RestoreJob restoreJob) {
        TokenRangeReplicasResponse cached = this.cachedReplicaByTokenRange(restoreJob);
        if (cached != null) {
            return Future.succeededFuture((Object)cached);
        }
        return this.replicaByTokenRangePerKeyspace.futureOf(restoreJob);
    }

    private Void loadAll(StorageOperations storageOperations, NodeSettings nodeSettings) {
        this.replicaByTokenRangePerKeyspace.load(keyspace -> storageOperations.tokenRangeReplicas(new Name(keyspace), nodeSettings.partitioner()));
        return null;
    }

    private <T> T prepareAndFetch(BiFunction<StorageOperations, NodeSettings, T> fetcher) {
        return (T)this.metadataFetcher.callOnFirstAvailableInstance(instance -> {
            CassandraAdapterDelegate delegate = instance.delegate();
            StorageOperations storageOperations = delegate.storageOperations();
            NodeSettings nodeSettings = delegate.nodeSettings();
            return fetcher.apply(storageOperations, nodeSettings);
        });
    }

    private void dispatchRingTopologyChangeAsync(String keyspace, TokenRangeReplicasResponse oldTopology, TokenRangeReplicasResponse newTopology) {
        this.listenersByKeyspace.getOrDefault(keyspace, Collections.emptySet()).forEach(listener -> this.executorPool.runBlocking(() -> listener.onRingTopologyChanged(keyspace, oldTopology, newTopology)));
    }

    private static void populateEndpointToMetadata(InstanceMetadata instanceMetadata, Map<String, Integer> allNodes, Map<String, InstanceMetadata> localEndpointsToMetadata) {
        String ip = RingTopologyRefresher.ipOf(instanceMetadata);
        Integer port = allNodes.get(ip);
        if (ip == null || port == null) {
            return;
        }
        String endpointWithPort = StringUtils.cassandraFormattedHostAndPort((String)ip, (int)port);
        localEndpointsToMetadata.put(endpointWithPort, instanceMetadata);
    }

    private static String ipOf(InstanceMetadata instanceMetadata) {
        String ipAddress = instanceMetadata.ipAddress();
        if (ipAddress == null) {
            try {
                return instanceMetadata.refreshIpAddress();
            }
            catch (UnknownHostException uhe) {
                LOGGER.debug("Failed to resolve IP address. host={}", (Object)instanceMetadata.host());
            }
        }
        return ipAddress;
    }

    @ThreadSafe
    static class ReplicaByTokenRangePerKeyspace {
        private final Set<UUID> allJobs = ConcurrentHashMap.newKeySet();
        private final Map<String, Set<UUID>> jobsByKeyspace = new ConcurrentHashMap<String, Set<UUID>>();
        private final Map<String, TokenRangeReplicasResponse> mapping = new ConcurrentHashMap<String, TokenRangeReplicasResponse>();
        private final Map<String, Promise<TokenRangeReplicasResponse>> promises = new ConcurrentHashMap<String, Promise<TokenRangeReplicasResponse>>();
        private final RingTopologyChangeListener asyncDispatcher;

        ReplicaByTokenRangePerKeyspace(@NotNull RingTopologyChangeListener asyncDispatcher) {
            this.asyncDispatcher = asyncDispatcher;
        }

        boolean isEmpty() {
            return this.allJobs.isEmpty();
        }

        String register(RestoreJob restoreJob) {
            if (this.allJobs.add(restoreJob.jobId)) {
                this.jobsByKeyspace.computeIfAbsent(restoreJob.keyspaceName, ks -> ConcurrentHashMap.newKeySet()).add(restoreJob.jobId);
            }
            return restoreJob.keyspaceName;
        }

        boolean unregister(RestoreJob restoreJob) {
            boolean containsJob = this.allJobs.remove(restoreJob.jobId);
            if (containsJob) {
                Set<UUID> jobIdsByKeyspace = this.jobsByKeyspace.get(restoreJob.keyspaceName);
                if (jobIdsByKeyspace == null || jobIdsByKeyspace.isEmpty() || !jobIdsByKeyspace.remove(restoreJob.jobId)) {
                    LOGGER.warn("Unable to find the restore job id to unregister. jobId={}", (Object)restoreJob.jobId);
                    return true;
                }
                if (!jobIdsByKeyspace.isEmpty()) {
                    return false;
                }
                LOGGER.info("All jobs of the keyspace are unregistered. keyspace={}", (Object)restoreJob.keyspaceName);
                this.jobsByKeyspace.remove(restoreJob.keyspaceName);
                this.mapping.remove(restoreJob.keyspaceName);
                Promise<TokenRangeReplicasResponse> p = this.promises.remove(restoreJob.keyspaceName);
                if (p != null) {
                    p.tryFail("Unable to retrieve topology for restoreJob. jobId=" + restoreJob.jobId + " keyspace=" + restoreJob.keyspaceName);
                }
            }
            return true;
        }

        Future<TokenRangeReplicasResponse> futureOf(RestoreJob restoreJob) {
            String keyspace = this.register(restoreJob);
            return this.promises.computeIfAbsent(keyspace, k -> Promise.promise()).future();
        }

        @Nullable
        TokenRangeReplicasResponse forRestoreJob(RestoreJob restoreJob) {
            if (!this.allJobs.contains(restoreJob.jobId)) {
                return null;
            }
            return this.mapping.get(restoreJob.keyspaceName);
        }

        void load(Function<String, TokenRangeReplicasResponse> loader) {
            Set<String> distinctKeyspaces = this.jobsByKeyspace.keySet();
            distinctKeyspaces.forEach(keyspace -> this.loadOne((String)keyspace, loader));
        }

        TokenRangeReplicasResponse loadOne(String keyspace, Function<String, TokenRangeReplicasResponse> loader) {
            try {
                TokenRangeReplicasResponse topology = loader.apply(keyspace);
                RingTopologyChangeContext context = new RingTopologyChangeContext(keyspace, topology);
                this.mapping.compute(keyspace, (key, existing) -> {
                    context.existing = existing;
                    if (existing == null) {
                        this.promises.computeIfPresent(keyspace, (k, promise) -> {
                            promise.tryComplete((Object)topology);
                            return promise;
                        });
                        context.shouldDispatch = true;
                        return topology;
                    }
                    if (existing.writeReplicas().equals(topology.writeReplicas())) {
                        LOGGER.debug("Ring topology of keyspace is unchanged. keyspace={}", (Object)keyspace);
                        return existing;
                    }
                    LOGGER.info("Ring topology of keyspace is changed. keyspace={}", (Object)keyspace);
                    context.shouldDispatch = true;
                    return topology;
                });
                if (context.shouldDispatch) {
                    this.asyncDispatcher.onRingTopologyChanged(context.keyspace, context.existing, context.current);
                }
                return topology;
            }
            catch (Throwable cause) {
                LOGGER.warn("Failure during load topology for keyspace. keyspace={}", (Object)keyspace, (Object)cause);
                this.promises.computeIfPresent(keyspace, (k, promise) -> {
                    promise.tryFail((Throwable)new IllegalStateException("Failed to load topology for keyspace: " + keyspace, cause));
                    return null;
                });
                return null;
            }
        }

        @Nullable
        TokenRangeReplicasResponse topologyOfKeyspace(String keyspace) {
            return this.mapping.get(keyspace);
        }

        @VisibleForTesting
        Set<UUID> allJobsUnsafe() {
            return this.allJobs;
        }

        @VisibleForTesting
        Map<String, Set<UUID>> jobsByKeyspaceUnsafe() {
            return this.jobsByKeyspace;
        }

        @VisibleForTesting
        Map<String, TokenRangeReplicasResponse> mappingUnsafe() {
            return this.mapping;
        }

        @VisibleForTesting
        Map<String, Promise<TokenRangeReplicasResponse>> promisesUnsafe() {
            return this.promises;
        }

        private static class RingTopologyChangeContext {
            final String keyspace;
            final TokenRangeReplicasResponse current;
            TokenRangeReplicasResponse existing;
            boolean shouldDispatch = false;

            RingTopologyChangeContext(String keyspace, TokenRangeReplicasResponse current) {
                this.keyspace = keyspace;
                this.current = current;
            }
        }
    }
}

