/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.sidecar.client.HttpClientConfig;
import org.apache.cassandra.sidecar.client.RequestExecutor;
import org.apache.cassandra.sidecar.client.SidecarClient;
import org.apache.cassandra.sidecar.client.SidecarClientConfig;
import org.apache.cassandra.sidecar.client.SidecarClientConfigImpl;
import org.apache.cassandra.sidecar.client.SidecarClientVertxRequestExecutor;
import org.apache.cassandra.sidecar.client.SidecarInstancesProvider;
import org.apache.cassandra.sidecar.client.VertxHttpClient;
import org.apache.cassandra.sidecar.client.retry.ExponentialBackoffRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.server.utils.SidecarVersionProvider;
import org.apache.cassandra.sidecar.common.server.utils.ThrowableUtils;
import org.apache.cassandra.sidecar.config.SidecarClientConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.utils.SslUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SidecarClientProvider
implements Provider<SidecarClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarClientProvider.class);
    private final Vertx vertx;
    private final SidecarInstancesProvider sidecarInstancesProvider;
    private final SidecarVersionProvider sidecarVersionProvider;
    private final SidecarClient client;
    private final WebClient webClient;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final WebClientOptions webClientOptions;
    private final SidecarClientConfiguration sidecarClientConfiguration;

    @Inject
    public SidecarClientProvider(Vertx vertx, SidecarConfiguration sidecarConfiguration, SidecarInstancesProvider sidecarInstancesProvider, SidecarVersionProvider sidecarVersionProvider) {
        this.vertx = vertx;
        this.sidecarInstancesProvider = sidecarInstancesProvider;
        this.sidecarVersionProvider = sidecarVersionProvider;
        this.sidecarClientConfiguration = sidecarConfiguration.sidecarClientConfiguration();
        this.webClientOptions = SidecarClientProvider.webClientOptions(this.sidecarClientConfiguration);
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)this.webClientOptions);
        this.client = this.initializeSidecarClient(this.sidecarClientConfiguration);
    }

    public SidecarClient get() {
        return this.client;
    }

    public Future<Boolean> updateSSLOptions(long lastModifiedTime) {
        SSLOptions sslOptions = this.webClientOptions.getSslOptions();
        SidecarClientProvider.configureSSLOptions(sslOptions, this.sidecarClientConfiguration.sslConfiguration(), lastModifiedTime);
        return this.webClient.updateSSLOptions(sslOptions);
    }

    public void close() {
        if (this.isClosing.compareAndSet(false, true)) {
            LOGGER.info("Closing Sidecar Client...");
            ThrowableUtils.propagate(() -> ((SidecarClient)this.client).close());
        }
    }

    private SidecarClient initializeSidecarClient(SidecarClientConfiguration clientConfig) {
        HttpClientConfig httpClientConfig = new HttpClientConfig.Builder().ssl(this.webClientOptions.isSsl()).timeoutMillis(clientConfig.requestTimeout().toMillis()).idleTimeoutMillis(clientConfig.requestIdleTimeout().toIntMillis()).userAgent("cassandra-sidecar/" + this.sidecarVersionProvider.sidecarVersion()).build();
        VertxHttpClient vertxHttpClient = new VertxHttpClient(this.vertx, this.webClient, httpClientConfig);
        ExponentialBackoffRetryPolicy defaultRetryPolicy = new ExponentialBackoffRetryPolicy(clientConfig.maxRetries(), clientConfig.retryDelay().toMillis(), clientConfig.maxRetryDelay().toMillis());
        SidecarClientVertxRequestExecutor requestExecutor = new SidecarClientVertxRequestExecutor(vertxHttpClient);
        SidecarClientConfig config = SidecarClientConfigImpl.builder().retryDelayMillis(clientConfig.retryDelay().toMillis()).maxRetryDelayMillis(clientConfig.maxRetryDelay().toMillis()).maxRetries(clientConfig.maxRetries()).build();
        return new SidecarClient(this.sidecarInstancesProvider, (RequestExecutor)requestExecutor, config, (RetryPolicy)defaultRetryPolicy);
    }

    static WebClientOptions webClientOptions(SidecarClientConfiguration clientConfig) {
        WebClientOptions options = new WebClientOptions();
        options.getPoolOptions().setCleanerPeriod(clientConfig.connectionPoolCleanerPeriod().toIntMillis()).setEventLoopSize(clientConfig.connectionPoolEventLoopSize()).setHttp1MaxSize(clientConfig.connectionPoolMaxSize()).setMaxWaitQueueSize(clientConfig.connectionPoolMaxWaitQueueSize());
        SslConfiguration ssl = clientConfig.sslConfiguration();
        if (ssl != null && ssl.enabled()) {
            options.setSsl(true);
            if (!ssl.secureTransportProtocols().isEmpty()) {
                options.setEnabledSecureTransportProtocols(new LinkedHashSet<String>(ssl.secureTransportProtocols()));
            }
            for (String cipherSuite : ssl.cipherSuites()) {
                options.addEnabledCipherSuite(cipherSuite);
            }
            if (ssl.preferOpenSSL() && OpenSSLEngineOptions.isAvailable()) {
                LOGGER.info("Using OpenSSL for encryption in Webclient Options");
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions().setSessionCacheEnabled(true));
            } else {
                LOGGER.warn("OpenSSL not enabled, using JDK for TLS in Webclient Options");
            }
            SidecarClientProvider.configureSSLOptions(options.getSslOptions(), ssl, 0L);
        }
        return options;
    }

    static void configureSSLOptions(SSLOptions options, SslConfiguration ssl, long timestamp) {
        options.setSslHandshakeTimeout(ssl.handshakeTimeout().quantity()).setSslHandshakeTimeoutUnit(ssl.handshakeTimeout().unit());
        if (ssl.isKeystoreConfigured()) {
            SslUtils.setKeyStoreConfiguration(options, ssl.keystore(), timestamp);
        }
        if (ssl.isTrustStoreConfigured()) {
            SslUtils.setTrustStoreConfiguration(options, ssl.truststore());
        }
    }
}

