/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class ScopeAuthorizationImpl
implements ScopeAuthorization {
    private static final JsonObject EMPTY = new JsonObject(Collections.emptyMap());
    private final String scopeSeparator;
    private final String claimKey;

    public ScopeAuthorizationImpl(String scopeSeparator, String claimKey) {
        this.scopeSeparator = Objects.requireNonNull(scopeSeparator);
        this.claimKey = claimKey;
    }

    public String getId() {
        return "oauth2-scope";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        this.getAuthorizations(user).onComplete(handler);
    }

    public Future<Void> getAuthorizations(User user) {
        String scopes = this.claimKey == null ? user.principal().getString("scope") : user.attributes().getJsonObject("accessToken", EMPTY).getString(this.claimKey);
        HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
        if (scopes != null) {
            String sep = user.attributes().getString("scope_separator", this.scopeSeparator);
            for (String scope : scopes.split(Pattern.quote(sep))) {
                authorizations.add(PermissionBasedAuthorization.create((String)scope));
            }
        }
        user.authorizations().add(this.getId(), authorizations);
        return Future.succeededFuture();
    }

    @Override
    public String separator() {
        return this.scopeSeparator;
    }

    @Override
    public String claimKey() {
        return this.claimKey;
    }

    @Override
    public String encode(List<String> scopes) {
        return String.join((CharSequence)this.separator(), scopes);
    }
}

