/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigInteger;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DFDLXLookAhead$;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.FNTwoArgs;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DFDLXLookAhead
extends FNTwoArgs
implements Product {
    private final List recipes;

    public static DFDLXLookAhead apply(List<CompiledDPath> list) {
        return DFDLXLookAhead$.MODULE$.apply(list);
    }

    public static DFDLXLookAhead fromProduct(Product product) {
        return DFDLXLookAhead$.MODULE$.fromProduct(product);
    }

    public static DFDLXLookAhead unapply(DFDLXLookAhead dFDLXLookAhead) {
        return DFDLXLookAhead$.MODULE$.unapply(dFDLXLookAhead);
    }

    public DFDLXLookAhead(List<CompiledDPath> recipes) {
        this.recipes = recipes;
        super(recipes);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DFDLXLookAhead)) return false;
        DFDLXLookAhead dFDLXLookAhead = (DFDLXLookAhead)object;
        List<CompiledDPath> list = this.recipes();
        List<CompiledDPath> list2 = dFDLXLookAhead.recipes();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!dFDLXLookAhead.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DFDLXLookAhead;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DFDLXLookAhead";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipes";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<CompiledDPath> recipes() {
        return this.recipes;
    }

    @Override
    public Object computeValue(Object arg1, Object arg2, DState dstate) {
        long maxLookahead;
        Long offset = DataValue$.MODULE$.getLong$extension(arg1);
        Long lBitSize = DataValue$.MODULE$.getLong$extension(arg2);
        if (Predef$.MODULE$.Long2long(offset) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.Long2long(offset).>=(0)");
        }
        if (Predef$.MODULE$.Long2long(lBitSize) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.Long2long(lBitSize).>=(0)");
        }
        long totalLookahead = Predef$.MODULE$.Long2long(offset) + Predef$.MODULE$.Long2long(lBitSize);
        if (totalLookahead > (maxLookahead = dstate.tunable().maxLookaheadFunctionBits())) {
            throw dstate.SDE("Look-ahead distance of %s bits exceeds implementation defined limit of %s bits", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalLookahead), BoxesRunTime.boxToLong((long)maxLookahead)}));
        }
        int bitSize = (int)Predef$.MODULE$.Long2long(lBitSize);
        if (!Maybe$.MODULE$.isDefined$extension(dstate.parseOrUnparseState())) {
            if (!dstate.isCompile()) {
                throw Assert$.MODULE$.abort("Invariant broken: dstate.isCompile");
            }
            throw new IllegalStateException("No input stream at compile time");
        }
        if ((ParseOrUnparseState)Maybe$.MODULE$.get$extension(dstate.parseOrUnparseState()) instanceof PState) {
            PState pstate = (PState)((ParseOrUnparseState)Maybe$.MODULE$.get$extension(dstate.parseOrUnparseState()));
            InputSourceDataInputStream dis = pstate.dataInputStream();
            if (!dis.isDefinedForLength(totalLookahead)) {
                Object object;
                Object object2 = dstate.runtimeData();
                if (Maybe$.MODULE$.isDefined$extension(object2)) {
                    Object object3 = dstate.runtimeData();
                    object = Maybe$One$.MODULE$.apply(((ElementRuntimeData)Maybe$.MODULE$.get$extension(object3)).schemaFileLocation());
                } else {
                    object = Maybe$.MODULE$.Nope();
                }
                Object maybeSFL = object;
                throw new ParseError(maybeSFL, dstate.contextLocation(), Maybe$.MODULE$.Nope(), Maybe$One$.MODULE$.apply("Insufficient bits available to satisfy dfdlx:lookAhead(%s,%s)."), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{offset, BoxesRunTime.boxToInteger((int)bitSize), BoxesRunTime.boxToLong((long)totalLookahead)}));
            }
            long mark = dis.markPos();
            dis.skip(Predef$.MODULE$.Long2long(offset), pstate);
            BigInteger ans = bitSize > 63 ? DataValue$.MODULE$.toDataValue(dis.getUnsignedBigInt(bitSize, pstate)) : (bitSize == 0 ? DataValue$.MODULE$.toDataValue(BigInteger.ZERO) : DataValue$.MODULE$.toDataValue(BigInteger.valueOf(dis.getUnsignedLong(bitSize, pstate))));
            dis.resetPos(mark);
            return ans;
        }
        if (!((ParseOrUnparseState)Maybe$.MODULE$.get$extension(dstate.parseOrUnparseState()) instanceof UState)) {
            throw Assert$.MODULE$.abort("Invariant broken: dstate.parseOrUnparseState.get.isInstanceOf[org.apache.daffodil.runtime1.processors.unparsers.UState]");
        }
        throw dstate.SDE("Cannot call dfdlx:lookAhead() during unparse", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public DFDLXLookAhead copy(List<CompiledDPath> recipes) {
        return new DFDLXLookAhead(recipes);
    }

    public List<CompiledDPath> copy$default$1() {
        return this.recipes();
    }

    public List<CompiledDPath> _1() {
        return this.recipes();
    }
}

