/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.URIUtils;

public class ResourceConnection {
    private InputStream stream = null;
    private URI uri = null;
    private URI redirect = null;
    private int statusCode = -1;
    private String contentType = null;
    private String etag = null;
    private Long lastModified = -1L;
    private Long date = -1L;

    public ResourceConnection(ResolverConfiguration config, String resolved) {
        this(config, resolved, false);
    }

    public ResourceConnection(ResolverConfiguration config, String resolved, boolean headOnly) {
        try {
            HashSet<URI> visited = new HashSet<URI>();
            URI connURI = this.uri = URIUtils.newURI(resolved);
            URLConnection connection = null;
            boolean tryAgain = true;
            while (tryAgain) {
                visited.add(connURI);
                URL url = connURI.toURL();
                connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    String location;
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    httpConnection.setInstanceFollowRedirects(true);
                    if (headOnly) {
                        httpConnection.setRequestMethod("HEAD");
                    } else {
                        httpConnection.setRequestMethod("GET");
                    }
                    httpConnection.connect();
                    this.statusCode = httpConnection.getResponseCode();
                    tryAgain = this.statusCode == 301 || this.statusCode == 302;
                    if (!tryAgain) continue;
                    if (!headOnly) {
                        try {
                            httpConnection.getInputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!visited.contains(connURI = URI.create(location = httpConnection.getHeaderField("Location")))) continue;
                    throw new IllegalArgumentException("Redirect URI already visited: " + connURI);
                }
                tryAgain = false;
                connection.connect();
                this.statusCode = 200;
            }
            if (headOnly) {
                if (connection.getInputStream() != null) {
                    connection.getInputStream().close();
                }
            } else {
                this.stream = connection.getInputStream();
            }
            this.contentType = connection.getContentType();
            this.etag = connection.getHeaderField("ETag");
            this.lastModified = connection.getLastModified();
            this.date = connection.getDate();
            this.redirect = connection.getURL().toURI();
            if (this.uri.equals(this.redirect)) {
                this.redirect = null;
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException use) {
            ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("warning", "Failed to %s: %s: %s", headOnly ? "HEAD" : "GET", resolved, use.getMessage());
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getDate() {
        return this.date;
    }

    public void close() {
    }
}

