// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

import org.junit.Assert;

suite("test_system_role","p0,auth") {
    test {
          sql """
              drop role operator;
          """
          exception "Can not drop role"
    }

    test {
          sql """
              drop role `admin`;
          """
          exception "Can not drop role"
    }

    test {
          sql """
              grant select_priv on *.*.* to role "operator";
          """
          exception "Can not grant"
    }
    test {
          sql """
              grant select_priv on *.*.* to role "admin";
          """
          exception "Can not grant"
    }
    test {
          sql """
              revoke Node_priv on *.*.* from role 'operator';
          """
          exception "Can not revoke"
    }

    test {
          sql """
              revoke Admin_priv on *.*.* from role 'admin';
          """
          exception "Can not revoke"
    }

}
