// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("huge_compound", "nonConcurrent") {
    sql """
        drop table if exists tyt_old_order;
        CREATE TABLE `tyt_old_order` (
        `n` varchar(65533) NULL,
        `c` varchar(65533) NULL
        ) ENGINE=OLAP
        DUPLICATE KEY(`n`)
        DISTRIBUTED BY HASH(`n`) BUCKETS AUTO
        PROPERTIES (
        "replication_allocation" = "tag.location.default: 1"
        );
        insert into tyt_old_order values("72", "93"), ("62", "xx")
    """
    setFeConfigTemporary([expr_children_limit: 100000]) {
    qt_1 """
         SELECT * 
         FROM tyt_old_order 
         where(n='72'AND c='93')OR(n='04'AND c='85')OR(n='43'AND c='37')OR(n='92'AND c='09')OR(n='85'AND c='69')OR(n='16'AND c='88')OR(n='87'AND c='22')OR(n='38'AND c='44')OR(n='65'AND c='22')OR(n='83'AND c='12')OR(n='14'AND c='44')OR(n='64'AND c='33')OR(n='44'AND c='58')OR(n='37'AND c='27')OR(n='59'AND c='36')OR(n='15'AND c='66')OR(n='44'AND c='66')OR(n='59'AND c='23')OR(n='08'AND c='87')OR(n='03'AND c='09')OR(n='85'AND c='26')OR(n='61'AND c='08')OR(n='23'AND c='13')OR(n='96'AND c='97')OR(n='15'AND c='44')OR(n='33'AND c='33')OR(n='11'AND c='87')OR(n='49'AND c='55')OR(n='70'AND c='29')OR(n='47'AND c='85')OR(n='14'AND c='18')OR(n='77'AND c='17')OR(n='66'AND c='07')OR(n='59'AND c='16')OR(n='48'AND c='11')OR(n='66'AND c='85')OR(n='46'AND c='65')OR(n='26'AND c='68')OR(n='63'AND c='22')OR(n='24'AND c='96')OR(n='17'AND c='00')OR(n='35'AND c='00')OR(n='06'AND c='26')OR(n='55'AND c='65')OR(n='16'AND c='17')OR(n='89'AND c='19')OR(n='57'AND c='30')OR(n='87'AND c='99')OR(n='27'AND c='89')OR(n='72'AND c='91')OR(n='47'AND c='51')OR(n='39'AND c='29')OR(n='87'AND c='45')OR(n='47'AND c='85')OR(n='99'AND c='40')OR(n='04'AND c='67')OR(n='65'AND c='50')OR(n='23'AND c='13')OR(n='54'AND c='44')OR(n='33'AND c='45')OR(n='48'AND c='86')OR(n='82'AND c='33')OR(n='15'AND c='85')OR(n='11'AND c='85')OR(n='33'AND c='93')OR(n='74'AND c='88')OR(n='07'AND c='58')OR(n='34'AND c='35')OR(n='90'AND c='18')OR(n='60'AND c='34')OR(n='78'AND c='77')OR(n='59'AND c='15')OR(n='89'AND c='79') 
            OR(n='69'AND c='69')OR(n='91'AND c='84')OR(n='28'AND c='76')OR(n='71'AND c='77')OR(n='12'AND c='65')OR(n='08'AND c='36')OR(n='23'AND c='16')OR(n='51'AND c='11')OR(n='48'AND c='19')OR(n='58'AND c='16')OR(n='77'AND c='15')OR(n='80'AND c='15')OR(n='75'AND c='15')OR(n='78'AND c='15')OR(n='61'AND c='15')OR(n='59'AND c='15')OR(n='07'AND c='15')OR(n='18'AND c='15')OR(n='59'AND c='15')OR(n='94'AND c='15')OR(n='55'AND c='15')OR(n='71'AND c='15')OR(n='11'AND c='65')OR(n='42'AND c='48')OR(n='91'AND c='00')OR(n='74'AND c='77')OR(n='20'AND c='80')OR(n='95'AND c='65')OR(n='12'AND c='00')OR(n='26'AND c='77')OR(n='10'AND c='48')OR(n='65'AND c='80')OR(n='20'AND c='48')OR(n='86'AND c='00')OR(n='22'AND c='77')OR(n='16'AND c='65')OR(n='56'AND c='80')OR(n='95'AND c='74')OR(n='61'AND c='68')OR(n='08'AND c='65')OR(n='05'AND c='48')OR(n='90'AND c='00')OR(n='96'AND c='77')OR(n='77'AND c='80')OR(n='46'AND c='65')OR(n='11'AND c='48')OR(n='79'AND c='00')OR(n='54'AND c='77')OR(n='25'AND c='80')OR(n='12'AND c='65')OR(n='39'AND c='48')OR(n='39'AND c='00')OR(n='24'AND c='77')OR(n='78'AND c='80')OR(n='21'AND c='02')OR(n='52'AND c='68')OR(n='12'AND c='66')OR(n='39'AND c='82')OR(n='36'AND c='19')OR(n='08'AND c='19')OR(n='29'AND c='19')OR(n='81'AND c='19')OR(n='25'AND c='19')OR(n='96'AND c='08')OR(n='98'AND c='19')OR(n='40'AND c='19')OR(n='03'AND c='19')OR(n='17'AND c='19')OR(n='97'AND c='19')OR(n='91'AND c='19')OR(n='21'AND c='19')OR(n='46'AND c='19')OR(n='69'AND c='19')OR(n='75'AND c='19')OR(n='68'AND c='19')OR(n='64'AND c='19')OR(n='31'AND c='19') 
            OR(n='89'AND c='19')OR(n='99'AND c='19')OR(n='60'AND c='19')OR(n='89'AND c='48')OR(n='40'AND c='00')OR(n='04'AND c='77')OR(n='40'AND c='65')OR(n='97'AND c='80')OR(n='59'AND c='48')OR(n='49'AND c='00')OR(n='38'AND c='77')OR(n='89'AND c='65')OR(n='25'AND c='80')OR(n='23'AND c='48')OR(n='88'AND c='00')OR(n='25'AND c='77')OR(n='82'AND c='65')OR(n='94'AND c='80')OR(n='26'AND c='65')OR(n='58'AND c='48')OR(n='95'AND c='00')OR(n='85'AND c='77')OR(n='46'AND c='80')OR(n='65'AND c='65')OR(n='40'AND c='48')OR(n='14'AND c='00')OR(n='93'AND c='77')OR(n='90'AND c='80')OR(n='51'AND c='65')OR(n='40'AND c='48')OR(n='74'AND c='00')OR(n='24'AND c='77')OR(n='56'AND c='80')OR(n='01'AND c='00')OR(n='79'AND c='77')OR(n='24'AND c='80')OR(n='48'AND c='65')OR(n='29'AND c='48')OR(n='09'AND c='00')OR(n='16'AND c='77')OR(n='61'AND c='80')OR(n='64'AND c='23')OR(n='52'AND c='65')OR(n='86'AND c='48')OR(n='62'AND c='00')OR(n='73'AND c='77')OR(n='36'AND c='80')OR(n='11'AND c='65')OR(n='13'AND c='48')OR(n='53'AND c='00')OR(n='39'AND c='77')OR(n='06'AND c='80')OR(n='21'AND c='76')OR(n='53'AND c='88')OR(n='37'AND c='53')OR(n='50'AND c='00')OR(n='42'AND c='00')OR(n='03'AND c='15')OR(n='82'AND c='71')OR(n='15'AND c='77')OR(n='79'AND c='18')OR(n='09'AND c='96')OR(n='15'AND c='98')OR(n='87'AND c='33')OR(n='04'AND c='80')OR(n='64'AND c='80')OR(n='88'AND c='05')OR(n='75'AND c='66')OR(n='85'AND c='80')OR(n='18'AND c='80')OR(n='12'AND c='58')OR(n='28'AND c='60')OR(n='61'AND c='55')OR(n='78'AND c='05')OR(n='39'AND c='77')OR(n='78'AND c='77')OR(n='02'AND c='65')OR(n='29'AND c='11')OR(n='49'AND c='87')OR(n='49'AND c='19')OR(n='43'AND c='19')OR(n='25'AND c='36')OR(n='90'AND c='84')OR(n='52'AND c='87')OR(n='46'AND c='77') 
            OR(n='99'AND c='89')OR(n='83'AND c='53')OR(n='73'AND c='69')OR(n='38'AND c='18')OR(n='06'AND c='02')OR(n='21'AND c='51')OR(n='27'AND c='88')OR(n='77'AND c='72')OR(n='28'AND c='92')OR(n='90'AND c='55')OR(n='75'AND c='05')OR(n='57'AND c='99')OR(n='45'AND c='07')OR(n='92'AND c='99')OR(n='51'AND c='55')OR(n='29'AND c='77')OR(n='82'AND c='30')OR(n='83'AND c='40')OR(n='79'AND c='89')OR(n='27'AND c='99')OR(n='25'AND c='06')OR(n='71'AND c='51')OR(n='57'AND c='39')OR(n='96'AND c='18')OR(n='18'AND c='02')OR(n='87'AND c='69')OR(n='53'AND c='01')OR(n='14'AND c='50')OR(n='19'AND c='33')OR(n='12'AND c='33')OR(n='99'AND c='86')OR(n='78'AND c='99')OR(n='98'AND c='66')OR(n='94'AND c='52')OR(n='96'AND c='50')OR(n='36'AND c='16')OR(n='58'AND c='18')OR(n='02'AND c='96')OR(n='84'AND c='11')OR(n='94'AND c='73')OR(n='97'AND c='08')OR(n='19'AND c='33')OR(n='41'AND c='06')OR(n='05'AND c='58')OR(n='12'AND c='30')OR(n='58'AND c='22')OR(n='41'AND c='66')OR(n='20'AND c='71')OR(n='41'AND c='71')OR(n='95'AND c='44')OR(n='90'AND c='58')OR(n='96'AND c='06')OR(n='18'AND c='00')OR(n='35'AND c='38')OR(n='45'AND c='02')OR(n='04'AND c='00')OR(n='87'AND c='99')OR(n='51'AND c='38')OR(n='42'AND c='61')OR(n='09'AND c='14')OR(n='48'AND c='70')OR(n='70'AND c='04')OR(n='39'AND c='97')OR(n='72'AND c='32')OR(n='46'AND c='72')OR(n='19'AND c='13')OR(n='98'AND c='37')OR(n='34'AND c='18')OR(n='64'AND c='71')OR(n='73'AND c='87')OR(n='82'AND c='19')OR(n='14'AND c='43')OR(n='36'AND c='22')OR(n='06'AND c='71')OR(n='08'AND c='71')OR(n='61'AND c='71')OR(n='71'AND c='88')OR(n='74'AND c='71') 
            OR(n='64'AND c='89')OR(n='13'AND c='71')OR(n='77'AND c='35')OR(n='66'AND c='11')OR(n='59'AND c='85')OR(n='29'AND c='66')OR(n='85'AND c='50')OR(n='18'AND c='66')OR(n='10'AND c='92')OR(n='76'AND c='66')OR(n='31'AND c='99')OR(n='86'AND c='91')OR(n='92'AND c='88')OR(n='40'AND c='18')OR(n='18'AND c='77')OR(n='72'AND c='63')OR(n='29'AND c='77')OR(n='24'AND c='87')OR(n='03'AND c='51')OR(n='81'AND c='01')OR(n='50'AND c='72')OR(n='25'AND c='33')OR(n='99'AND c='68')OR(n='51'AND c='13')OR(n='59'AND c='88')OR(n='31'AND c='97')OR(n='71'AND c='10')OR(n='15'AND c='91')OR(n='31'AND c='88')OR(n='92'AND c='00')OR(n='11'AND c='75')OR(n='06'AND c='99')OR(n='46'AND c='32')OR(n='13'AND c='09')OR(n='18'AND c='33')OR(n='88'AND c='58')OR(n='90'AND c='77')OR(n='22'AND c='10')OR(n='37'AND c='19')OR(n='52'AND c='10')OR(n='30'AND c='22')OR(n='98'AND c='66')OR(n='65'AND c='66')OR(n='22'AND c='98')OR(n='99'AND c='77')OR(n='84'AND c='32')OR(n='73'AND c='03')OR(n='99'AND c='58')OR(n='63'AND c='77')OR(n='50'AND c='99')OR(n='23'AND c='35')OR(n='40'AND c='88')OR(n='76'AND c='88')OR(n='10'AND c='88')OR(n='37'AND c='86')OR(n='94'AND c='08')OR(n='84'AND c='30')OR(n='95'AND c='88')OR(n='81'AND c='25')OR(n='34'AND c='25')OR(n='58'AND c='66')OR(n='40'AND c='21')OR(n='02'AND c='88')OR(n='44'AND c='53')OR(n='42'AND c='99')OR(n='56'AND c='16')OR(n='54'AND c='37')OR(n='89'AND c='97')OR(n='49'AND c='22')OR(n='97'AND c='81')OR(n='56'AND c='85')OR(n='13'AND c='93')OR(n='06'AND c='93')OR(n='40'AND c='44')OR(n='84'AND c='09')OR(n='67'AND c='83')OR(n='56'AND c='88')OR(n='72'AND c='58')OR(n='04'AND c='68') 
            OR(n='96'AND c='68')OR(n='74'AND c='39')OR(n='16'AND c='14')OR(n='28'AND c='00')OR(n='83'AND c='60')OR(n='61'AND c='88')OR(n='13'AND c='70')OR(n='79'AND c='36')OR(n='26'AND c='91')OR(n='41'AND c='91')OR(n='98'AND c='91')OR(n='29'AND c='50')OR(n='02'AND c='45')OR(n='51'AND c='77')OR(n='53'AND c='05')OR(n='02'AND c='14')OR(n='88'AND c='50')OR(n='93'AND c='90')OR(n='32'AND c='09')OR(n='53'AND c='56')OR(n='27'AND c='16')OR(n='30'AND c='68')OR(n='62'AND c='26')OR(n='33'AND c='26')OR(n='04'AND c='74')OR(n='79'AND c='08')OR(n='47'AND c='28')OR(n='93'AND c='44')OR(n='28'AND c='34')OR(n='89'AND c='79')OR(n='63'AND c='88')OR(n='51'AND c='33')OR(n='72'AND c='66')OR(n='22'AND c='79')OR(n='97'AND c='82')OR(n='45'AND c='61')OR(n='02'AND c='33')OR(n='83'AND c='08')OR(n='46'AND c='11')OR(n='09'AND c='33')OR(n='94'AND c='72')OR(n='82'AND c='09')OR(n='15'AND c='92')OR(n='54'AND c='50')OR(n='17'AND c='17')OR(n='89'AND c='26')OR(n='79'AND c='76')OR(n='08'AND c='76')OR(n='46'AND c='94')OR(n='73'AND c='78')OR(n='61'AND c='16')OR(n='42'AND c='43')OR(n='79'AND c='97')OR(n='43'AND c='02')OR(n='50'AND c='15')OR(n='26'AND c='21')OR(n='60'AND c='56')OR(n='08'AND c='51')OR(n='46'AND c='21')OR(n='29'AND c='37')OR(n='03'AND c='58')OR(n='84'AND c='79')OR(n='51'AND c='09')OR(n='15'AND c='09')OR(n='68'AND c='77')OR(n='45'AND c='77')OR(n='65'AND c='17')OR(n='76'AND c='16')OR(n='07'AND c='10')OR(n='13'AND c='56')OR(n='75'AND c='93')OR(n='17'AND c='51')OR(n='86'AND c='68')OR(n='73'AND c='68')OR(n='24'AND c='99')OR(n='88'AND c='99')OR(n='15'AND c='33')OR(n='24'AND c='95')OR(n='36'AND c='83') 
            OR(n='12'AND c='83')OR(n='32'AND c='83')OR(n='62'AND c='83')OR(n='35'AND c='56')OR(n='01'AND c='67')OR(n='37'AND c='85')OR(n='89'AND c='08')OR(n='57'AND c='39')OR(n='95'AND c='18')OR(n='31'AND c='08')OR(n='06'AND c='08')OR(n='69'AND c='79')OR(n='69'AND c='70')OR(n='43'AND c='06')OR(n='55'AND c='53')OR(n='75'AND c='91')OR(n='26'AND c='66')OR(n='14'AND c='22')OR(n='23'AND c='38')OR(n='07'AND c='18')OR(n='22'AND c='29')OR(n='39'AND c='53')OR(n='60'AND c='28')OR(n='12'AND c='12')OR(n='45'AND c='03')OR(n='54'AND c='60')OR(n='53'AND c='98')OR(n='11'AND c='78')OR(n='43'AND c='53')OR(n='80'AND c='98')OR(n='04'AND c='69')OR(n='75'AND c='68')OR(n='91'AND c='26')OR(n='55'AND c='93')OR(n='12'AND c='88')OR(n='10'AND c='03')OR(n='27'AND c='93')OR(n='96'AND c='89')OR(n='83'AND c='66')OR(n='09'AND c='23')OR(n='27'AND c='68')OR(n='71'AND c='33')OR(n='21'AND c='42')OR(n='49'AND c='56')OR(n='71'AND c='81')OR(n='83'AND c='82')OR(n='91'AND c='82')OR(n='82'AND c='92')OR(n='09'AND c='50')OR(n='99'AND c='45')OR(n='52'AND c='45')OR(n='47'AND c='70')OR(n='98'AND c='88')OR(n='01'AND c='35')OR(n='81'AND c='85')OR(n='02'AND c='53')OR(n='13'AND c='91')OR(n='75'AND c='88')OR(n='30'AND c='46')OR(n='56'AND c='90')OR(n='64'AND c='54')OR(n='37'AND c='95')OR(n='38'AND c='88')OR(n='89'AND c='05')OR(n='73'AND c='88')OR(n='60'AND c='51')OR(n='48'AND c='60')OR(n='25'AND c='62')OR(n='61'AND c='88')OR(n='74'AND c='19')OR(n='24'AND c='62')OR(n='44'AND c='68')OR(n='15'AND c='60')OR(n='89'AND c='69')OR(n='06'AND c='57')OR(n='83'AND c='49')OR(n='66'AND c='99')OR(n='31'AND c='11')OR(n='68'AND c='96') 
            OR(n='49'AND c='48')OR(n='59'AND c='95')OR(n='30'AND c='05')OR(n='63'AND c='20')OR(n='68'AND c='85')OR(n='75'AND c='99')OR(n='46'AND c='29')OR(n='93'AND c='99')OR(n='48'AND c='99')OR(n='24'AND c='88')OR(n='47'AND c='15')OR(n='52'AND c='99')OR(n='17'AND c='91')OR(n='12'AND c='53')OR(n='38'AND c='16')OR(n='82'AND c='82')OR(n='79'AND c='11')OR(n='99'AND c='01')OR(n='40'AND c='68')OR(n='33'AND c='79')OR(n='32'AND c='07')OR(n='39'AND c='26')OR(n='31'AND c='81')OR(n='16'AND c='66')OR(n='75'AND c='59')OR(n='76'AND c='77')OR(n='22'AND c='82')OR(n='49'AND c='08')OR(n='09'AND c='18')OR(n='79'AND c='87')OR(n='88'AND c='32')OR(n='14'AND c='16')OR(n='47'AND c='37')OR(n='24'AND c='33')OR(n='03'AND c='53')OR(n='96'AND c='88')OR(n='66'AND c='88')OR(n='82'AND c='19')OR(n='29'AND c='26')OR(n='33'AND c='48')OR(n='75'AND c='19')OR(n='76'AND c='39')OR(n='39'AND c='11')OR(n='41'AND c='22')OR(n='96'AND c='76')OR(n='63'AND c='33')OR(n='13'AND c='00')OR(n='08'AND c='28')OR(n='56'AND c='20')OR(n='28'AND c='20')OR(n='54'AND c='88')OR(n='53'AND c='78')OR(n='95'AND c='79')OR(n='08'AND c='75')OR(n='44'AND c='31')OR(n='45'AND c='47')OR(n='47'AND c='96')OR(n='84'AND c='33')OR(n='73'AND c='55')OR(n='74'AND c='77')OR(n='66'AND c='19')OR(n='20'AND c='19')OR(n='42'AND c='19')OR(n='16'AND c='19')OR(n='10'AND c='19')OR(n='37'AND c='65')OR(n='75'AND c='77')OR(n='64'AND c='48')OR(n='19'AND c='00')OR(n='93'AND c='80')OR(n='83'AND c='65')OR(n='45'AND c='77')OR(n='91'AND c='48')OR(n='81'AND c='00')OR(n='74'AND c='80') 
            OR(n='88'AND c='68')OR(n='21'AND c='34')OR(n='17'AND c='17')OR(n='40'AND c='79')OR(n='90'AND c='71')OR(n='80'AND c='22')OR(n='27'AND c='07')OR(n='12'AND c='88')OR(n='24'AND c='85')OR(n='16'AND c='38')OR(n='67'AND c='54')OR(n='06'AND c='20')OR(n='97'AND c='20')OR(n='41'AND c='66')OR(n='99'AND c='51')OR(n='88'AND c='55')OR(n='44'AND c='70')OR(n='23'AND c='91')OR(n='94'AND c='78')OR(n='64'AND c='00')OR(n='66'AND c='83')OR(n='83'AND c='27')OR(n='06'AND c='91')OR(n='28'AND c='23')OR(n='89'AND c='20')OR(n='79'AND c='13')OR(n='25'AND c='60')OR(n='92'AND c='28')OR(n='28'AND c='66')OR(n='84'AND c='76')OR(n='25'AND c='76')OR(n='59'AND c='66')OR(n='18'AND c='43')OR(n='70'AND c='58')OR(n='11'AND c='77')OR(n='22'AND c='83')OR(n='28'AND c='00')OR(n='05'AND c='00')OR(n='16'AND c='76')OR(n='74'AND c='98')OR(n='41'AND c='06')OR(n='99'AND c='06')OR(n='58'AND c='76')OR(n='24'AND c='22')OR(n='85'AND c='86')OR(n='30'AND c='67')OR(n='02'AND c='76')OR(n='40'AND c='00')OR(n='96'AND c='43')OR(n='51'AND c='39')OR(n='73'AND c='77')OR(n='74'AND c='75')OR(n='85'AND c='85')OR(n='97'AND c='93')OR(n='28'AND c='80')OR(n='29'AND c='80')OR(n='84'AND c='41')OR(n='05'AND c='86')OR(n='50'AND c='86')OR(n='89'AND c='00')OR(n='64'AND c='48')OR(n='85'AND c='65')OR(n='33'AND c='77')OR(n='85'AND c='80')OR(n='70'AND c='99')OR(n='63'AND c='69')OR(n='16'AND c='86')OR(n='42'AND c='86')OR(n='77'AND c='48')OR(n='10'AND c='65')OR(n='95'AND c='77')OR(n='81'AND c='00')OR(n='94'AND c='08')OR(n='09'AND c='44')OR(n='70'AND c='22')OR(n='32'AND c='51')OR(n='16'AND c='51')OR(n='47'AND c='99')OR(n='30'AND c='99')OR(n='32'AND c='99')
            OR(n='20'AND c='86')OR(n='36'AND c='86')OR(n='50'AND c='86')OR(n='77'AND c='86')OR(n='62'AND c='86')OR(n='92'AND c='86')OR(n='43'AND c='86')OR(n='40'AND c='86')OR(n='26'AND c='22')OR(n='99'AND c='35')OR(n='06'AND c='48')OR(n='77'AND c='65')OR(n='50'AND c='77')OR(n='14'AND c='00')OR(n='85'AND c='95')OR(n='21'AND c='48')OR(n='05'AND c='65')OR(n='19'AND c='77')OR(n='03'AND c='00')OR(n='65'AND c='19')OR(n='30'AND c='48')OR(n='93'AND c='65')OR(n='48'AND c='77')OR(n='74'AND c='00')OR(n='23'AND c='68')OR(n='73'AND c='22')OR(n='10'AND c='00')OR(n='55'AND c='48')OR(n='01'AND c='65')OR(n='17'AND c='77')OR(n='16'AND c='80')OR(n='44'AND c='88')OR(n='85'AND c='00')OR(n='30'AND c='48')OR(n='03'AND c='65')OR(n='91'AND c='77')OR(n='94'AND c='80')OR(n='05'AND c='00')OR(n='52'AND c='48')OR(n='00'AND c='65')OR(n='77'AND c='77')OR(n='77'AND c='80')OR(n='12'AND c='48')OR(n='39'AND c='65')OR(n='60'AND c='77')OR(n='53'AND c='00')OR(n='06'AND c='80')OR(n='22'AND c='97')OR(n='47'AND c='15')OR(n='06'AND c='15')OR(n='58'AND c='48')OR(n='99'AND c='65')OR(n='96'AND c='77')OR(n='40'AND c='00')OR(n='31'AND c='80')OR(n='45'AND c='00')OR(n='67'AND c='48')OR(n='63'AND c='65')OR(n='91'AND c='77')OR(n='41'AND c='80')OR(n='81'AND c='99')OR(n='87'AND c='99')OR(n='67'AND c='99')OR(n='46'AND c='00')OR(n='69'AND c='48')OR(n='62'AND c='65')OR(n='80'AND c='77')OR(n='92'AND c='80')OR(n='44'AND c='00')OR(n='07'AND c='48')OR(n='74'AND c='65')OR(n='92'AND c='77')OR(n='79'AND c='80')OR(n='72'AND c='12')OR(n='42'AND c='00')OR(n='23'AND c='48')OR(n='23'AND c='65')OR(n='88'AND c='77') 
            OR(n='41'AND c='80')OR(n='26'AND c='71')OR(n='95'AND c='85')OR(n='59'AND c='15')OR(n='63'AND c='70')OR(n='02'AND c='10')OR(n='26'AND c='33')OR(n='94'AND c='16')OR(n='99'AND c='60')OR(n='83'AND c='38')OR(n='40'AND c='85')OR(n='56'AND c='73')OR(n='58'AND c='85')OR(n='16'AND c='67')OR(n='36'AND c='36')OR(n='86'AND c='05')OR(n='73'AND c='82')OR(n='22'AND c='44')OR(n='04'AND c='86')OR(n='74'AND c='95')OR(n='83'AND c='56')OR(n='29'AND c='07')OR(n='74'AND c='71')OR(n='19'AND c='00')OR(n='79'AND c='22')OR(n='07'AND c='91')OR(n='48'AND c='00')OR(n='88'AND c='78')OR(n='05'AND c='88')OR(n='81'AND c='52')OR(n='20'AND c='52')OR(n='30'AND c='51')OR(n='77'AND c='32')OR(n='62'AND c='81')OR(n='78'AND c='97')OR(n='83'AND c='88')OR(n='12'AND c='96')OR(n='58'AND c='13')OR(n='69'AND c='10')OR(n='90'AND c='13')OR(n='60'AND c='13')OR(n='28'AND c='99')OR(n='83'AND c='45')OR(n='67'AND c='01')OR(n='05'AND c='88')OR(n='55'AND c='30')OR(n='74'AND c='40')OR(n='77'AND c='05')OR(n='65'AND c='44')OR(n='62'AND c='93')OR(n='70'AND c='88')OR(n='03'AND c='71')OR(n='35'AND c='86')OR(n='03'AND c='33')OR(n='64'AND c='62')OR(n='86'AND c='55')OR(n='52'AND c='68')OR(n='98'AND c='22')OR(n='81'AND c='96')OR(n='73'AND c='73')OR(n='26'AND c='33')OR(n='77'AND c='99')OR(n='61'AND c='30')OR(n='28'AND c='92')OR(n='28'AND c='66')OR(n='17'AND c='16')OR(n='27'AND c='62')OR(n='43'AND c='22')OR(n='97'AND c='00')OR(n='03'AND c='48')OR(n='65'AND c='65')OR(n='87'AND c='77')OR(n='93'AND c='80')OR(n='75'AND c='62')OR(n='29'AND c='19')OR(n='47'AND c='56')OR(n='42'AND c='33')OR(n='24'AND c='38')OR(n='08'AND c='52')OR(n='19'AND c='77')OR(n='30'AND c='26')OR(n='86'AND c='44')OR(n='94'AND c='95')OR(n='41'AND c='23')OR(n='44'AND c='51')OR(n='10'AND c='66')OR(n='59'AND c='54')OR(n='91'AND c='31')OR(n='95'AND c='99') 
            OR(n='73'AND c='20')OR(n='57'AND c='22')OR(n='81'AND c='88')OR(n='95'AND c='00')OR(n='96'AND c='88')OR(n='80'AND c='05')OR(n='43'AND c='22')OR(n='70'AND c='99')OR(n='99'AND c='78')OR(n='47'AND c='78')OR(n='85'AND c='77')OR(n='77'AND c='62')OR(n='64'AND c='67')OR(n='40'AND c='97')OR(n='48'AND c='68')OR(n='42'AND c='40')OR(n='54'AND c='02')OR(n='47'AND c='22')OR(n='77'AND c='62')OR(n='96'AND c='02')OR(n='65'AND c='87')OR(n='94'AND c='95')OR(n='67'AND c='52')OR(n='91'AND c='41')OR(n='87'AND c='06')OR(n='55'AND c='09')OR(n='20'AND c='89')OR(n='23'AND c='19')OR(n='59'AND c='27')OR(n='78'AND c='57')OR(n='67'AND c='97')OR(n='36'AND c='33')OR(n='71'AND c='27')OR(n='60'AND c='85')OR(n='06'AND c='69')OR(n='46'AND c='12')OR(n='71'AND c='00')OR(n='33'AND c='87')OR(n='26'AND c='31')OR(n='68'AND c='43')OR(n='47'AND c='41')OR(n='25'AND c='11')OR(n='67'AND c='56')OR(n='62'AND c='21')OR(n='92'AND c='88')OR(n='35'AND c='62')OR(n='34'AND c='99')OR(n='39'AND c='09')OR(n='42'AND c='22')OR(n='67'AND c='88')OR(n='79'AND c='65')OR(n='72'AND c='77')OR(n='21'AND c='38')OR(n='81'AND c='99')OR(n='06'AND c='40')OR(n='06'AND c='00')OR(n='99'AND c='99')OR(n='11'AND c='88')OR(n='38'AND c='55')OR(n='02'AND c='55')OR(n='44'AND c='99')OR(n='47'AND c='09')OR(n='02'AND c='33')OR(n='67'AND c='85')OR(n='00'AND c='53')OR(n='16'AND c='96')OR(n='97'AND c='20')OR(n='40'AND c='56')OR(n='59'AND c='73')OR(n='22'AND c='77')OR(n='88'AND c='55')OR(n='06'AND c='25')OR(n='17'AND c='19')OR(n='51'AND c='03')OR(n='30'AND c='22')OR(n='15'AND c='08')OR(n='95'AND c='00')OR(n='25'AND c='88')OR(n='54'AND c='88')OR(n='81'AND c='09')OR(n='06'AND c='33')OR(n='51'AND c='32')OR(n='79'AND c='32')OR(n='13'AND c='32')OR(n='54'AND c='39')OR(n='55'AND c='99')OR(n='47'AND c='30') 
            OR(n='03'AND c='66')OR(n='47'AND c='45')OR(n='21'AND c='08')OR(n='01'AND c='18')OR(n='71'AND c='65')OR(n='37'AND c='65')OR(n='66'AND c='99')OR(n='93'AND c='73')OR(n='46'AND c='33')OR(n='45'AND c='18')OR(n='10'AND c='27')OR(n='25'AND c='66')OR(n='84'AND c='71')OR(n='91'AND c='71')OR(n='02'AND c='71')OR(n='81'AND c='33')OR(n='49'AND c='44')OR(n='80'AND c='55')OR(n='22'AND c='05')OR(n='75'AND c='62')OR(n='98'AND c='67')OR(n='75'AND c='18')OR(n='02'AND c='00')OR(n='83'AND c='80')OR(n='36'AND c='00')OR(n='50'AND c='99')OR(n='36'AND c='37')OR(n='41'AND c='37')OR(n='83'AND c='00')OR(n='80'AND c='48')OR(n='71'AND c='77')OR(n='57'AND c='65')OR(n='77'AND c='80')OR(n='96'AND c='99')OR(n='70'AND c='00')OR(n='37'AND c='48')OR(n='09'AND c='77')OR(n='47'AND c='65')OR(n='23'AND c='80')OR(n='10'AND c='77')OR(n='19'AND c='88')OR(n='56'AND c='88')OR(n='11'AND c='93')OR(n='41'AND c='15')OR(n='00'AND c='15')OR(n='70'AND c='19')OR(n='35'AND c='15')OR(n='26'AND c='15')OR(n='56'AND c='00')OR(n='53'AND c='48')OR(n='18'AND c='77')OR(n='73'AND c='65')OR(n='82'AND c='80')OR(n='67'AND c='19')OR(n='69'AND c='48')OR(n='07'AND c='77')OR(n='44'AND c='00')OR(n='54'AND c='65')OR(n='20'AND c='80')OR(n='62'AND c='19')OR(n='91'AND c='19')OR(n='13'AND c='48')OR(n='05'AND c='77')OR(n='20'AND c='00')OR(n='54'AND c='65')OR(n='43'AND c='80')OR(n='53'AND c='80')OR(n='53'AND c='48')OR(n='02'AND c='77')OR(n='01'AND c='00')OR(n='82'AND c='65')OR(n='22'AND c='80')OR(n='23'AND c='36')OR(n='60'AND c='53')OR(n='68'AND c='53')OR(n='77'AND c='83')OR(n='87'AND c='35')OR(n='51'AND c='32')OR(n='44'AND c='76')OR(n='44'AND c='16')OR(n='06'AND c='89')OR(n='17'AND c='57')OR(n='61'AND c='57')OR(n='06'AND c='18')OR(n='18'AND c='89') 
            OR(n='17'AND c='18')OR(n='85'AND c='20')OR(n='98'AND c='15')OR(n='22'AND c='27')OR(n='00'AND c='27')OR(n='70'AND c='68')OR(n='23'AND c='08')OR(n='43'AND c='99')OR(n='43'AND c='88')OR(n='30'AND c='44')OR(n='69'AND c='78')OR(n='85'AND c='22')OR(n='00'AND c='62')OR(n='39'AND c='96')OR(n='25'AND c='77')OR(n='92'AND c='29')OR(n='77'AND c='77')OR(n='30'AND c='26')OR(n='16'AND c='88')OR(n='68'AND c='95')OR(n='21'AND c='10')OR(n='52'AND c='18')OR(n='07'AND c='19')OR(n='95'AND c='68')OR(n='01'AND c='37')OR(n='08'AND c='66')OR(n='69'AND c='23')OR(n='68'AND c='38')OR(n='60'AND c='25')OR(n='05'AND c='90')OR(n='02'AND c='87')OR(n='81'AND c='41')OR(n='33'AND c='57')OR(n='65'AND c='52')OR(n='03'AND c='28')OR(n='56'AND c='82')OR(n='49'AND c='79')OR(n='84'AND c='94')OR(n='86'AND c='56')OR(n='58'AND c='08')OR(n='42'AND c='50')OR(n='51'AND c='00')OR(n='55'AND c='55')OR(n='27'AND c='69')OR(n='23'AND c='69')OR(n='47'AND c='82')OR(n='82'AND c='18')OR(n='43'AND c='25')OR(n='84'AND c='87')OR(n='04'AND c='31')OR(n='20'AND c='54')OR(n='04'AND c='76')OR(n='31'AND c='99')OR(n='01'AND c='77')OR(n='30'AND c='77')OR(n='01'AND c='88')OR(n='33'AND c='97')OR(n='59'AND c='43')OR(n='49'AND c='77')OR(n='20'AND c='99')OR(n='99'AND c='82')OR(n='92'AND c='88')OR(n='54'AND c='87')OR(n='71'AND c='76')OR(n='02'AND c='22')OR(n='99'AND c='89')OR(n='18'AND c='84')OR(n='52'AND c='73')OR(n='05'AND c='26')OR(n='01'AND c='88')OR(n='48'AND c='78')OR(n='80'AND c='78')OR(n='29'AND c='86')OR(n='88'AND c='11')OR(n='60'AND c='22')OR(n='59'AND c='88')OR(n='33'AND c='99')OR(n='26'AND c='50')OR(n='62'AND c='59')OR(n='76'AND c='23')OR(n='17'AND c='81')OR(n='44'AND c='99')OR(n='57'AND c='00')OR(n='57'AND c='07')OR(n='22'AND c='78')OR(n='36'AND c='52')OR(n='08'AND c='12')OR(n='87'AND c='34')OR(n='94'AND c='77')OR(n='72'AND c='33')OR(n='56'AND c='89')OR(n='36'AND c='37')OR(n='38'AND c='99')OR(n='02'AND c='01')OR(n='89'AND c='97')OR(n='25'AND c='91') 
            OR(n='79'AND c='67')OR(n='61'AND c='77')OR(n='50'AND c='75')OR(n='05'AND c='07')OR(n='15'AND c='86')OR(n='60'AND c='11')OR(n='54'AND c='19')OR(n='19'AND c='14')OR(n='29'AND c='92') 
            OR(n='26'AND c='06')OR(n='63'AND c='78')OR(n='24'AND c='67')OR(n='56'AND c='58')OR(n='33'AND c='58')OR(n='79'AND c='53')OR(n='89'AND c='44')OR(n='52'AND c='14')OR(n='28'AND c='94')OR(n='32'AND c='76')OR(n='99'AND c='87')OR(n='73'AND c='87')OR(n='44'AND c='43')OR(n='33'AND c='33')OR(n='72'AND c='14')OR(n='16'AND c='29')OR(n='26'AND c='86')OR(n='24'AND c='99')OR(n='68'AND c='26')OR(n='99'AND c='24')OR(n='32'AND c='09')OR(n='22'AND c='34')OR(n='36'AND c='93')OR(n='78'AND c='57')OR(n='40'AND c='55')OR(n='81'AND c='01')OR(n='39'AND c='19')OR(n='39'AND c='88')OR(n='52'AND c='11')OR(n='61'AND c='58')OR(n='84'AND c='32')OR(n='42'AND c='83')OR(n='48'AND c='00')OR(n='63'AND c='51')OR(n='28'AND c='18')OR(n='18'AND c='60')OR(n='64'AND c='05')OR(n='50'AND c='18')OR(n='10'AND c='88')OR(n='68'AND c='88')OR(n='14'AND c='08')OR(n='62'AND c='88')OR(n='95'AND c='26')OR(n='78'AND c='76')OR(n='73'AND c='91')OR(n='74'AND c='89')OR(n='60'AND c='55')OR(n='46'AND c='90')OR(n='69'AND c='89')OR(n='52'AND c='98')OR(n='38'AND c='65')OR(n='99'AND c='75')OR(n='53'AND c='88')OR(n='35'AND c='77')OR(n='84'AND c='50')OR(n='50'AND c='77')OR(n='67'AND c='06')OR(n='28'AND c='49')OR(n='43'AND c='55')OR(n='79'AND c='31')OR(n='06'AND c='88')OR(n='41'AND c='93')OR(n='20'AND c='11')OR(n='23'AND c='50')OR(n='08'AND c='55')OR(n='15'AND c='00')OR(n='91'AND c='46')OR(n='03'AND c='88')OR(n='81'AND c='48')OR(n='09'AND c='11')OR(n='00'AND c='88')OR(n='49'AND c='00')OR(n='76'AND c='32')OR(n='58'AND c='06')OR(n='18'AND c='99')OR(n='76'AND c='39')OR(n='14'AND c='33')OR(n='66'AND c='05')OR(n='28'AND c='99')OR(n='20'AND c='90')OR(n='07'AND c='11')OR(n='45'AND c='19')OR(n='44'AND c='19')OR(n='51'AND c='80') 
            OR(n='64'AND c='81')OR(n='36'AND c='19')OR(n='35'AND c='67')OR(n='35'AND c='19')OR(n='21'AND c='11')OR(n='07'AND c='19')OR(n='54'AND c='19')OR(n='42'AND c='55')OR(n='77'AND c='96')OR(n='39'AND c='33')OR(n='04'AND c='01')OR(n='45'AND c='50')OR(n='69'AND c='88')OR(n='87'AND c='53')OR(n='96'AND c='98')OR(n='28'AND c='11')OR(n='55'AND c='71')OR(n='78'AND c='11')OR(n='50'AND c='77')OR(n='47'AND c='11')OR(n='49'AND c='48')OR(n='56'AND c='77')OR(n='09'AND c='77')OR(n='17'AND c='65')OR(n='51'AND c='80')OR(n='30'AND c='22')OR(n='37'AND c='44')OR(n='88'AND c='62')OR(n='17'AND c='88')OR(n='12'AND c='13')OR(n='24'AND c='49')OR(n='36'AND c='11')OR(n='00'AND c='55')OR(n='61'AND c='04')OR(n='88'AND c='32')OR(n='82'AND c='58')OR(n='42'AND c='60')OR(n='76'AND c='99')OR(n='41'AND c='39')OR(n='91'AND c='57')OR(n='28'AND c='18')OR(n='86'AND c='71')OR(n='18'AND c='71')OR(n='26'AND c='98')OR(n='53'AND c='27')OR(n='05'AND c='67')OR(n='32'AND c='82')OR(n='33'AND c='69')OR(n='27'AND c='68')OR(n='64'AND c='89')OR(n='48'AND c='56')OR(n='80'AND c='91')OR(n='02'AND c='39')OR(n='45'AND c='26')OR(n='67'AND c='88')OR(n='52'AND c='56')OR(n='22'AND c='12')OR(n='31'AND c='93')OR(n='36'AND c='50')OR(n='50'AND c='72')OR(n='34'AND c='44')OR(n='10'AND c='26')OR(n='98'AND c='40')OR(n='16'AND c='88')OR(n='89'AND c='66')OR(n='84'AND c='76')OR(n='55'AND c='32')OR(n='06'AND c='89')OR(n='94'AND c='33')OR(n='40'AND c='76')OR(n='01'AND c='00')OR(n='53'AND c='44')OR(n='36'AND c='78')OR(n='96'AND c='89')OR(n='18'AND c='77')OR(n='03'AND c='66')OR(n='61'AND c='83')OR(n='21'AND c='83')OR(n='56'AND c='32')OR(n='58'AND c='74')OR(n='71'AND c='98')OR(n='66'AND c='26')OR(n='75'AND c='30')OR(n='14'AND c='21')OR(n='58'AND c='81')OR(n='39'AND c='07')OR(n='26'AND c='88')OR(n='94'AND c='40')OR(n='02'AND c='29')OR(n='41'AND c='37')OR(n='20'AND c='92')OR(n='49'AND c='27')OR(n='29'AND c='89')OR(n='39'AND c='98')OR(n='40'AND c='98') 
            OR(n='95'AND c='33')OR(n='58'AND c='98')OR(n='85'AND c='88')OR(n='61'AND c='40')OR(n='85'AND c='77')OR(n='90'AND c='77')OR(n='52'AND c='77')OR(n='54'AND c='66')OR(n='06'AND c='92')OR(n='89'AND c='14')OR(n='37'AND c='69')OR(n='49'AND c='30')OR(n='64'AND c='20')OR(n='77'AND c='40')OR(n='22'AND c='98')OR(n='21'AND c='88')OR(n='98'AND c='66')OR(n='08'AND c='86')OR(n='65'AND c='18')OR(n='08'AND c='08')OR(n='29'AND c='92')OR(n='33'AND c='77')OR(n='12'AND c='89')OR(n='76'AND c='31')OR(n='12'AND c='31')OR(n='13'AND c='44')OR(n='04'AND c='17')OR(n='79'AND c='88')OR(n='87'AND c='83')OR(n='40'AND c='22')OR(n='74'AND c='19')OR(n='55'AND c='88')OR(n='19'AND c='96')OR(n='45'AND c='88')OR(n='55'AND c='88')OR(n='32'AND c='45')OR(n='10'AND c='37')OR(n='16'AND c='12')OR(n='02'AND c='28')OR(n='24'AND c='37')OR(n='34'AND c='56')OR(n='35'AND c='05')OR(n='48'AND c='50')OR(n='80'AND c='51')OR(n='86'AND c='92')OR(n='73'AND c='72')OR(n='37'AND c='37')OR(n='20'AND c='12')OR(n='24'AND c='28')OR(n='53'AND c='37')OR(n='75'AND c='56')OR(n='65'AND c='05')OR(n='52'AND c='50')OR(n='66'AND c='51')OR(n='81'AND c='92')OR(n='58'AND c='72')OR(n='40'AND c='77')OR(n='93'AND c='77')OR(n='05'AND c='60')OR(n='37'AND c='33')OR(n='06'AND c='71')OR(n='40'AND c='68')OR(n='54'AND c='15')OR(n='03'AND c='11')OR(n='15'AND c='77')OR(n='70'AND c='62')OR(n='42'AND c='28')OR(n='57'AND c='11')OR(n='46'AND c='33')OR(n='83'AND c='17')OR(n='12'AND c='81')OR(n='69'AND c='11')OR(n='76'AND c='05')OR(n='57'AND c='19')OR(n='75'AND c='19')OR(n='06'AND c='19')OR(n='09'AND c='77')OR(n='20'AND c='48')OR(n='45'AND c='80')OR(n='38'AND c='65')OR(n='13'AND c='19')OR(n='42'AND c='19')OR(n='55'AND c='11')OR(n='94'AND c='80')OR(n='59'AND c='77')OR(n='50'AND c='48')OR(n='39'AND c='80')OR(n='24'AND c='65')OR(n='21'AND c='77')OR(n='27'AND c='48')OR(n='92'AND c='80')OR(n='11'AND c='65')OR(n='59'AND c='19')OR(n='18'AND c='19') 
            OR(n='26'AND c='19')OR(n='15'AND c='48')OR(n='21'AND c='80')OR(n='54'AND c='77')OR(n='74'AND c='44')OR(n='00'AND c='48')OR(n='97'AND c='80')OR(n='72'AND c='77')OR(n='67'AND c='65')OR(n='33'AND c='48')OR(n='03'AND c='80')OR(n='37'AND c='77')OR(n='24'AND c='65')OR(n='05'AND c='15')OR(n='81'AND c='22')OR(n='47'AND c='71')OR(n='14'AND c='78')OR(n='11'AND c='99')OR(n='74'AND c='86')OR(n='37'AND c='95')OR(n='18'AND c='56')OR(n='30'AND c='90')OR(n='09'AND c='03')OR(n='55'AND c='53')OR(n='17'AND c='99')OR(n='83'AND c='81')OR(n='47'AND c='52')OR(n='99'AND c='97')OR(n='79'AND c='34')OR(n='02'AND c='22')OR(n='87'AND c='19')OR(n='03'AND c='98')OR(n='32'AND c='61')OR(n='36'AND c='71')OR(n='85'AND c='71')OR(n='54'AND c='71')OR(n='06'AND c='22')OR(n='43'AND c='30')OR(n='90'AND c='22')OR(n='15'AND c='05')OR(n='37'AND c='56')OR(n='24'AND c='00')OR(n='88'AND c='27')OR(n='37'AND c='27')OR(n='70'AND c='85')OR(n='04'AND c='85')OR(n='31'AND c='85')OR(n='25'AND c='85')OR(n='91'AND c='51')OR(n='57'AND c='85')OR(n='25'AND c='77')OR(n='67'AND c='87')OR(n='30'AND c='55')OR(n='46'AND c='48')OR(n='47'AND c='77')OR(n='34'AND c='15')OR(n='08'AND c='55')OR(n='05'AND c='77')OR(n='04'AND c='35')OR(n='64'AND c='55')OR(n='16'AND c='35')OR(n='84'AND c='73')OR(n='90'AND c='17')OR(n='68'AND c='08')OR(n='32'AND c='98')OR(n='82'AND c='27')OR(n='82'AND c='78')OR(n='65'AND c='66')OR(n='35'AND c='30')OR(n='60'AND c='45')OR(n='56'AND c='94')OR(n='42'AND c='02')OR(n='84'AND c='14')OR(n='01'AND c='80')OR(n='15'AND c='97')OR(n='18'AND c='85')OR(n='12'AND c='78')OR(n='50'AND c='85')OR(n='10'AND c='18')OR(n='11'AND c='96')OR(n='62'AND c='18')OR(n='49'AND c='85')OR(n='41'AND c='00')OR(n='33'AND c='82')OR(n='46'AND c='73')OR(n='95'AND c='71')OR(n='48'AND c='88')OR(n='82'AND c='73')OR(n='23'AND c='36')OR(n='43'AND c='67')OR(n='36'AND c='88')OR(n='20'AND c='78')OR(n='99'AND c='43')OR(n='66'AND c='68') 
            OR(n='82'AND c='09')OR(n='37'AND c='58')OR(n='24'AND c='13')OR(n='03'AND c='52')OR(n='47'AND c='22')OR(n='03'AND c='37')OR(n='46'AND c='76')OR(n='00'AND c='77')OR(n='04'AND c='19')OR(n='63'AND c='08')OR(n='15'AND c='90')OR(n='52'AND c='45')OR(n='18'AND c='05')OR(n='48'AND c='28')OR(n='84'AND c='00')OR(n='22'AND c='19')OR(n='32'AND c='89')OR(n='97'AND c='44')OR(n='74'AND c='89')OR(n='36'AND c='89')OR(n='21'AND c='55')OR(n='88'AND c='97')OR(n='34'AND c='86')OR(n='39'AND c='15')OR(n='00'AND c='19')OR(n='10'AND c='55')OR(n='21'AND c='70')OR(n='96'AND c='06')OR(n='88'AND c='58')OR(n='10'AND c='81')OR(n='39'AND c='99')OR(n='10'AND c='68')OR(n='85'AND c='28')OR(n='08'AND c='65')OR(n='97'AND c='65')OR(n='15'AND c='33')OR(n='85'AND c='55')OR(n='98'AND c='00')OR(n='67'AND c='78')OR(n='15'AND c='08')OR(n='94'AND c='96')OR(n='79'AND c='81')OR(n='36'AND c='10')OR(n='50'AND c='53')OR(n='61'AND c='98')OR(n='74'AND c='56')OR(n='38'AND c='44')OR(n='39'AND c='99')OR(n='78'AND c='92')OR(n='79'AND c='33')OR(n='07'AND c='75')OR(n='05'AND c='38')OR(n='04'AND c='31')OR(n='72'AND c='88')OR(n='22'AND c='36')OR(n='27'AND c='99')OR(n='59'AND c='99')OR(n='44'AND c='87')OR(n='42'AND c='03')OR(n='52'AND c='87')OR(n='42'AND c='91')OR(n='38'AND c='02')OR(n='19'AND c='91')OR(n='43'AND c='04')OR(n='30'AND c='83')OR(n='36'AND c='91')OR(n='09'AND c='95')OR(n='44'AND c='45')OR(n='32'AND c='05')OR(n='06'AND c='38')OR(n='40'AND c='37')OR(n='59'AND c='38')OR(n='39'AND c='37')OR(n='05'AND c='38')OR(n='09'AND c='38')OR(n='94'AND c='37')OR(n='88'AND c='38')OR(n='60'AND c='29')OR(n='52'AND c='38')OR(n='87'AND c='38')OR(n='56'AND c='37')OR(n='50'AND c='38')OR(n='30'AND c='37')OR(n='38'AND c='38')OR(n='24'AND c='29')OR(n='17'AND c='38')OR(n='91'AND c='26')OR(n='80'AND c='38')OR(n='34'AND c='29') 
            OR(n='68'AND c='38')OR(n='91'AND c='29')OR(n='23'AND c='29')OR(n='20'AND c='38')OR(n='83'AND c='29')OR(n='77'AND c='38')OR(n='61'AND c='38')OR(n='55'AND c='37')OR(n='39'AND c='38')OR(n='19'AND c='37')OR(n='41'AND c='38')OR(n='02'AND c='37')OR(n='40'AND c='38')OR(n='12'AND c='29')OR(n='01'AND c='38')OR(n='59'AND c='38')OR(n='76'AND c='37')OR(n='81'AND c='38')OR(n='54'AND c='37')OR(n='42'AND c='07')OR(n='38'AND c='03')OR(n='99'AND c='72')OR(n='79'AND c='19')OR(n='27'AND c='19')OR(n='31'AND c='19')OR(n='81'AND c='19')OR(n='66'AND c='19')OR(n='80'AND c='82')OR(n='69'AND c='27')OR(n='09'AND c='06')OR(n='97'AND c='87')OR(n='15'AND c='15')OR(n='06'AND c='15')OR(n='27'AND c='15')OR(n='04'AND c='15')OR(n='64'AND c='06')OR(n='14'AND c='15')OR(n='64'AND c='76')OR(n='39'AND c='59')OR(n='07'AND c='40')OR(n='51'AND c='68')OR(n='39'AND c='00')OR(n='35'AND c='33')OR(n='89'AND c='19')OR(n='16'AND c='00')OR(n='44'AND c='58')OR(n='76'AND c='18')OR(n='11'AND c='66')OR(n='27'AND c='87')OR(n='38'AND c='38')OR(n='57'AND c='55')OR(n='88'AND c='23')OR(n='24'AND c='29')OR(n='60'AND c='75')OR(n='81'AND c='27')OR(n='21'AND c='34')OR(n='11'AND c='96')OR(n='53'AND c='33')OR(n='26'AND c='89')OR(n='41'AND c='98')OR(n='59'AND c='98')OR(n='31'AND c='08')OR(n='29'AND c='70')OR(n='86'AND c='22')OR(n='18'AND c='96')OR(n='78'AND c='19')OR(n='32'AND c='81')OR(n='05'AND c='93')OR(n='59'AND c='65')OR(n='51'AND c='76')OR(n='87'AND c='15')OR(n='86'AND c='88')OR(n='18'AND c='15')OR(n='91'AND c='15')OR(n='43'AND c='48')OR(n='02'AND c='65')OR(n='21'AND c='14')OR(n='63'AND c='85')OR(n='50'AND c='48')OR(n='54'AND c='65')OR(n='84'AND c='15')OR(n='89'AND c='78')OR(n='95'AND c='60')OR(n='10'AND c='78')OR(n='42'AND c='87')OR(n='02'AND c='50')OR(n='82'AND c='78')OR(n='72'AND c='85')OR(n='24'AND c='77') 
            OR(n='43'AND c='98')OR(n='57'AND c='00')OR(n='23'AND c='00')OR(n='64'AND c='23')OR(n='15'AND c='83')OR(n='60'AND c='66')OR(n='40'AND c='88')OR(n='60'AND c='78')OR(n='92'AND c='51')OR(n='08'AND c='77')OR(n='13'AND c='99')OR(n='20'AND c='00')OR(n='23'AND c='89')OR(n='32'AND c='44')OR(n='71'AND c='67')OR(n='95'AND c='67')OR(n='28'AND c='31')OR(n='56'AND c='35')OR(n='02'AND c='36')OR(n='59'AND c='93')OR(n='31'AND c='92')OR(n='70'AND c='09')OR(n='37'AND c='44')OR(n='42'AND c='20')OR(n='16'AND c='13')OR(n='91'AND c='82')OR(n='20'AND c='37')OR(n='39'AND c='51')OR(n='04'AND c='85')OR(n='20'AND c='48')OR(n='65'AND c='11')OR(n='71'AND c='02')OR(n='82'AND c='52')OR(n='55'AND c='24')OR(n='74'AND c='55')OR(n='79'AND c='80')OR(n='31'AND c='33')OR(n='09'AND c='99')OR(n='89'AND c='98')OR(n='79'AND c='98')OR(n='54'AND c='37')OR(n='43'AND c='61')OR(n='13'AND c='53')OR(n='95'AND c='90')OR(n='17'AND c='70')OR(n='94'AND c='33')OR(n='25'AND c='26')OR(n='22'AND c='21')OR(n='06'AND c='03')OR(n='64'AND c='30')OR(n='37'AND c='00')OR(n='61'AND c='45')OR(n='80'AND c='38')OR(n='52'AND c='34')OR(n='84'AND c='29')OR(n='35'AND c='99')OR(n='30'AND c='99')OR(n='60'AND c='99')OR(n='38'AND c='89')OR(n='50'AND c='99')OR(n='16'AND c='18')OR(n='99'AND c='99')OR(n='14'AND c='88')OR(n='55'AND c='56')OR(n='11'AND c='82')OR(n='13'AND c='82')OR(n='74'AND c='78')OR(n='47'AND c='37')OR(n='19'AND c='48')OR(n='83'AND c='65')OR(n='09'AND c='99')OR(n='63'AND c='99')OR(n='64'AND c='99')OR(n='27'AND c='99')OR(n='59'AND c='99')OR(n='02'AND c='48')OR(n='29'AND c='65')OR(n='68'AND c='22')OR(n='34'AND c='48')OR(n='62'AND c='65')OR(n='52'AND c='48')OR(n='90'AND c='65')OR(n='22'AND c='48')OR(n='49'AND c='65')OR(n='97'AND c='48')OR(n='94'AND c='65')OR(n='67'AND c='91')OR(n='15'AND c='97')OR(n='96'AND c='94') 
            OR(n='66'AND c='15')OR(n='58'AND c='15')OR(n='27'AND c='11')OR(n='17'AND c='88')OR(n='81'AND c='27')OR(n='31'AND c='16')OR(n='00'AND c='19')OR(n='93'AND c='48')OR(n='43'AND c='65')OR(n='72'AND c='97')OR(n='09'AND c='48')OR(n='38'AND c='65')OR(n='52'AND c='11')OR(n='89'AND c='89')OR(n='24'AND c='53')OR(n='14'AND c='18')OR(n='72'AND c='80')OR(n='52'AND c='28')OR(n='01'AND c='26')OR(n='97'AND c='66')OR(n='34'AND c='00')OR(n='29'AND c='88')OR(n='19'AND c='90')OR(n='73'AND c='65')OR(n='67'AND c='71')OR(n='50'AND c='19')OR(n='92'AND c='67')OR(n='60'AND c='48')OR(n='36'AND c='65')OR(n='01'AND c='41')OR(n='19'AND c='78')OR(n='39'AND c='55')OR(n='26'AND c='66')OR(n='18'AND c='78')OR(n='30'AND c='71')OR(n='62'AND c='54')OR(n='41'AND c='66')OR(n='45'AND c='83')OR(n='62'AND c='72')OR(n='08'AND c='06')OR(n='09'AND c='88')OR(n='23'AND c='19')OR(n='90'AND c='46')OR(n='63'AND c='15')OR(n='70'AND c='89')OR(n='60'AND c='50')OR(n='68'AND c='28')OR(n='66'AND c='99')OR(n='56'AND c='93')OR(n='18'AND c='71')OR(n='94'AND c='29')OR(n='90'AND c='54')OR(n='94'AND c='71')OR(n='47'AND c='29')OR(n='96'AND c='71')OR(n='11'AND c='71')OR(n='87'AND c='37')OR(n='03'AND c='71') 
            OR(n='97'AND c='71')OR(n='64'AND c='71')OR(n='10'AND c='66')OR(n='24'AND c='71')OR(n='25'AND c='71')OR(n='69'AND c='71')OR(n='57'AND c='22')OR(n='12'AND c='71')OR(n='27'AND c='71')OR(n='41'AND c='71')OR(n='12'AND c='71')OR(n='15'AND c='29')OR(n='46'AND c='71')OR(n='00'AND c='85')OR(n='96'AND c='71')OR(n='42'AND c='82')OR(n='05'AND c='71')OR(n='45'AND c='71')OR(n='19'AND c='37')OR(n='55'AND c='71')OR(n='32'AND c='29')OR(n='70'AND c='71')OR(n='56'AND c='71')OR(n='38'AND c='71')OR(n='47'AND c='71')OR(n='24'AND c='37')OR(n='30'AND c='71')OR(n='86'AND c='28')OR(n='28'AND c='58')OR(n='09'AND c='33')OR(n='55'AND c='12')OR(n='37'AND c='32')OR(n='48'AND c='29')OR(n='08'AND c='38')OR(n='42'AND c='11')OR(n='65'AND c='57')OR(n='18'AND c='57')OR(n='42'AND c='08')OR(n='35'AND c='11')OR(n='19'AND c='00')OR(n='84'AND c='52')OR(n='20'AND c='59')OR(n='84'AND c='65')OR(n='01'AND c='59')OR(n='87'AND c='65')OR(n='98'AND c='65')OR(n='87'AND c='59')OR(n='58'AND c='24')OR(n='10'AND c='99')OR(n='50'AND c='57')OR(n='92'AND c='88')OR(n='69'AND c='20')OR(n='47'AND c='44')OR(n='71'AND c='44')OR(n='28'AND c='18')OR(n='12'AND c='18')OR(n='24'AND c='88')OR(n='84'AND c='16')OR(n='19'AND c='37')OR(n='01'AND c='34')OR(n='07'AND c='73')OR(n='48'AND c='02')OR(n='64'AND c='73')OR(n='23'AND c='73')OR(n='95'AND c='05')OR(n='42'AND c='05')OR(n='67'AND c='12')OR(n='02'AND c='13')OR(n='49'AND c='87')OR(n='23'AND c='53')OR(n='97'AND c='24')OR(n='47'AND c='98')OR(n='96'AND c='10')OR(n='17'AND c='78')OR(n='02'AND c='99')OR(n='21'AND c='69')OR(n='76'AND c='33')OR(n='41'AND c='18')OR(n='97'AND c='32')OR(n='40'AND c='97')OR(n='48'AND c='95')OR(n='26'AND c='95')OR(n='28'AND c='88')OR(n='51'AND c='08')OR(n='13'AND c='37')OR(n='43'AND c='83')OR(n='54'AND c='20')OR(n='98'AND c='34')OR(n='32'AND c='93')OR(n='63'AND c='96')OR(n='91'AND c='16')OR(n='24'AND c='16')OR(n='68'AND c='10')OR(n='76'AND c='88')OR(n='62'AND c='68')OR(n='49'AND c='76')OR(n='10'AND c='76')OR(n='95'AND c='62')OR(n='42'AND c='91')OR(n='98'AND c='22')OR(n='55'AND c='19')OR(n='45'AND c='66')OR(n='19'AND c='56')OR(n='54'AND c='98')OR(n='86'AND c='76')OR(n='92'AND c='63')OR(n='89'AND c='11')OR(n='63'AND c='90')OR(n='85'AND c='40')OR(n='01'AND c='67')OR(n='88'AND c='19')OR(n='26'AND c='11')OR(n='62'AND c='79')OR(n='74'AND c='81') 
            OR(n='47'AND c='55')OR(n='70'AND c='05')OR(n='82'AND c='20')OR(n='10'AND c='47')OR(n='29'AND c='59')OR(n='93'AND c='89')OR(n='06'AND c='88')OR(n='34'AND c='30')OR(n='23'AND c='55')OR(n='57'AND c='57')OR(n='43'AND c='86')OR(n='06'AND c='86')OR(n='28'AND c='86')OR(n='44'AND c='86')OR(n='20'AND c='86')OR(n='96'AND c='48')OR(n='19'AND c='48')OR(n='06'AND c='44')OR(n='82'AND c='68')OR(n='74'AND c='23')OR(n='60'AND c='86')OR(n='05'AND c='10')OR(n='61'AND c='93')OR(n='22'AND c='29')OR(n='22'AND c='92')OR(n='63'AND c='20')OR(n='47'AND c='19')OR(n='16'AND c='07')OR(n='02'AND c='18')OR(n='13'AND c='77')OR(n='35'AND c='11')OR(n='76'AND c='17')OR(n='87'AND c='11')OR(n='93'AND c='90')OR(n='14'AND c='71')OR(n='35'AND c='30')OR(n='37'AND c='44')OR(n='33'AND c='61')OR(n='05'AND c='78')OR(n='25'AND c='88')OR(n='55'AND c='18')OR(n='67'AND c='66')OR(n='55'AND c='68')OR(n='92'AND c='78')OR(n='30'AND c='15')OR(n='14'AND c='15')OR(n='60'AND c='15')OR(n='18'AND c='15')OR(n='64'AND c='89')OR(n='56'AND c='50')OR(n='34'AND c='86')OR(n='47'AND c='22')OR(n='42'AND c='44')OR(n='05'AND c='56')OR(n='67'AND c='82')OR(n='90'AND c='55')OR(n='58'AND c='55')OR(n='01'AND c='55')OR(n='18'AND c='41')OR(n='66'AND c='37')OR(n='89'AND c='97')OR(n='38'AND c='66')OR(n='16'AND c='15')OR(n='29'AND c='15')OR(n='29'AND c='15')OR(n='26'AND c='15')OR(n='04'AND c='19')OR(n='96'AND c='96')OR(n='56'AND c='66')OR(n='08'AND c='48')OR(n='13'AND c='48')OR(n='88'AND c='48')OR(n='67'AND c='69')OR(n='49'AND c='26')OR(n='14'AND c='64')OR(n='39'AND c='48')OR(n='18'AND c='53')OR(n='34'AND c='80')OR(n='43'AND c='17')OR(n='22'AND c='26')OR(n='03'AND c='65')OR(n='50'AND c='85')OR(n='98'AND c='11')OR(n='65'AND c='90')OR(n='54'AND c='97')OR(n='13'AND c='77')OR(n='59'AND c='82')OR(n='82'AND c='98')OR(n='98'AND c='60')OR(n='22'AND c='26')OR(n='83'AND c='11')OR(n='51'AND c='57')OR(n='82'AND c='33')OR(n='08'AND c='32')OR(n='94'AND c='13')OR(n='89'AND c='45')OR(n='32'AND c='75')OR(n='40'AND c='32')OR(n='82'AND c='67')OR(n='13'AND c='98')OR(n='61'AND c='30')OR(n='50'AND c='00')OR(n='78'AND c='60')OR(n='35'AND c='77')OR(n='03'AND c='26')OR(n='84'AND c='45')OR(n='13'AND c='19')OR(n='27'AND c='45')OR(n='01'AND c='19')OR(n='66'AND c='45')OR(n='33'AND c='45')OR(n='51'AND c='19')OR(n='70'AND c='45')OR(n='65'AND c='18')OR(n='68'AND c='19')OR(n='69'AND c='19')OR(n='21'AND c='23')OR(n='95'AND c='45')OR(n='78'AND c='19')OR(n='37'AND c='45')OR(n='16'AND c='50')OR(n='75'AND c='19')OR(n='54'AND c='23')OR(n='56'AND c='22')OR(n='88'AND c='28')OR(n='21'AND c='53')OR(n='32'AND c='23')OR(n='97'AND c='71') 
            OR(n='76'AND c='69')OR(n='73'AND c='92')OR(n='50'AND c='65')OR(n='34'AND c='88')OR(n='91'AND c='99')OR(n='51'AND c='90')OR(n='97'AND c='93')OR(n='84'AND c='48')OR(n='50'AND c='88')OR(n='65'AND c='35')OR(n='87'AND c='68')OR(n='19'AND c='16')OR(n='99'AND c='71')OR(n='98'AND c='00')OR(n='73'AND c='52')OR(n='66'AND c='16')OR(n='32'AND c='10')OR(n='71'AND c='44')OR(n='01'AND c='55')OR(n='60'AND c='00')OR(n='10'AND c='16')OR(n='03'AND c='88')OR(n='04'AND c='52')OR(n='59'AND c='57')OR(n='00'AND c='99')OR(n='63'AND c='23')OR(n='78'AND c='07')OR(n='90'AND c='87')OR(n='95'AND c='96')OR(n='52'AND c='18')OR(n='61'AND c='99')OR(n='65'AND c='66')OR(n='66'AND c='87')OR(n='24'AND c='80')OR(n='88'AND c='77')OR(n='05'AND c='01')OR(n='35'AND c='11')OR(n='59'AND c='80')OR(n='04'AND c='62')OR(n='53'AND c='88')OR(n='78'AND c='07')OR(n='94'AND c='59')OR(n='12'AND c='79')OR(n='00'AND c='88')OR(n='50'AND c='85')OR(n='66'AND c='55')OR(n='15'AND c='18')OR(n='89'AND c='28')OR(n='77'AND c='69')OR(n='70'AND c='87')OR(n='48'AND c='26')OR(n='55'AND c='03')OR(n='87'AND c='67')OR(n='05'AND c='82')OR(n='64'AND c='15')OR(n='05'AND c='49')OR(n='80'AND c='66')OR(n='60'AND c='78')OR(n='93'AND c='02')OR(n='25'AND c='91')OR(n='65'AND c='00')OR(n='80'AND c='91')OR(n='45'AND c='30')OR(n='68'AND c='98')OR(n='40'AND c='88')OR(n='37'AND c='19')OR(n='24'AND c='62')OR(n='71'AND c='48')OR(n='27'AND c='78')OR(n='56'AND c='21')OR(n='49'AND c='00')OR(n='05'AND c='77')OR(n='41'AND c='57')OR(n='67'AND c='99')OR(n='15'AND c='41')OR(n='68'AND c='70')OR(n='98'AND c='49')OR(n='90'AND c='03')OR(n='92'AND c='41')OR(n='59'AND c='00')OR(n='16'AND c='89')OR(n='63'AND c='76')OR(n='23'AND c='90')OR(n='76'AND c='91')OR(n='41'AND c='06')OR(n='08'AND c='44')OR(n='11'AND c='44')OR(n='46'AND c='91')OR(n='17'AND c='91')OR(n='17'AND c='91')OR(n='74'AND c='72')OR(n='05'AND c='72')OR(n='03'AND c='52')OR(n='52'AND c='81')OR(n='42'AND c='91')OR(n='17'AND c='91')OR(n='54'AND c='60')OR(n='02'AND c='67')OR(n='72'AND c='32')OR(n='71'AND c='91')OR(n='34'AND c='91')OR(n='34'AND c='88')OR(n='42'AND c='60')OR(n='58'AND c='21')OR(n='16'AND c='70')OR(n='18'AND c='38')OR(n='84'AND c='05')OR(n='10'AND c='11')OR(n='85'AND c='85')OR(n='90'AND c='09')OR(n='06'AND c='45')OR(n='01'AND c='21')OR(n='38'AND c='76')OR(n='92'AND c='02')OR(n='01'AND c='66')OR(n='42'AND c='26')OR(n='17'AND c='58')OR(n='07'AND c='12')OR(n='31'AND c='85')OR(n='34'AND c='87')OR(n='24'AND c='19')OR(n='94'AND c='19')OR(n='44'AND c='55')OR(n='97'AND c='47')OR(n='93'AND c='55')OR(n='78'AND c='62')OR(n='36'AND c='95')OR(n='25'AND c='89')OR(n='38'AND c='27')OR(n='72'AND c='32')OR(n='42'AND c='77')OR(n='41'AND c='09')OR(n='25'AND c='27')OR(n='20'AND c='99')OR(n='66'AND c='33')OR(n='13'AND c='65')OR(n='68'AND c='85')OR(n='79'AND c='87')OR(n='01'AND c='08')OR(n='20'AND c='19')OR(n='34'AND c='19')OR(n='24'AND c='19')OR(n='61'AND c='19')OR(n='71'AND c='19')OR(n='86'AND c='19')OR(n='93'AND c='19')OR(n='65'AND c='78')OR(n='25'AND c='55')OR(n='71'AND c='16')OR(n='10'AND c='68')OR(n='44'AND c='98')OR(n='35'AND c='86')OR(n='54'AND c='48')OR(n='11'AND c='82')OR(n='11'AND c='68')OR(n='71'AND c='98')OR(n='44'AND c='55')OR(n='06'AND c='16')OR(n='18'AND c='86')OR(n='31'AND c='48')OR(n='47'AND c='55')OR(n='18'AND c='16')OR(n='89'AND c='98')OR(n='19'AND c='68')OR(n='31'AND c='86')OR(n='65'AND c='48')OR(n='15'AND c='55')OR(n='14'AND c='16')OR(n='39'AND c='98')OR(n='64'AND c='68')OR(n='39'AND c='86')OR(n='34'AND c='48')OR(n='09'AND c='19')OR(n='60'AND c='19')OR(n='94'AND c='19')OR(n='20'AND c='55')OR(n='59'AND c='98')OR(n='82'AND c='16')OR(n='63'AND c='68')OR(n='75'AND c='86')OR(n='41'AND c='48')OR(n='59'AND c='39')OR(n='47'AND c='74')OR(n='60'AND c='87')OR(n='51'AND c='99')OR(n='56'AND c='00')OR(n='35'AND c='32')OR(n='25'AND c='19')OR(n='16'AND c='19')OR(n='20'AND c='38')OR(n='02'AND c='86')OR(n='18'AND c='82')OR(n='16'AND c='68')OR(n='99'AND c='11')OR(n='64'AND c='22')OR(n='84'AND c='66')OR(n='74'AND c='81')OR(n='18'AND c='88')OR(n='69'AND c='19')OR(n='00'AND c='19')OR(n='74'AND c='19')OR(n='05'AND c='88')OR(n='55'AND c='19')OR(n='63'AND c='19')OR(n='45'AND c='19')OR(n='71'AND c='99')OR(n='08'AND c='19')OR(n='82'AND c='19')OR(n='21'AND c='88')OR(n='17'AND c='19')OR(n='33'AND c='19')OR(n='54'AND c='77')OR(n='11'AND c='06')OR(n='32'AND c='77')OR(n='14'AND c='76')OR(n='68'AND c='84')OR(n='63'AND c='60')OR(n='22'AND c='11')OR(n='02'AND c='68') 
            OR(n='37'AND c='86')OR(n='97'AND c='56')OR(n='14'AND c='78')OR(n='54'AND c='53')OR(n='37'AND c='88')OR(n='60'AND c='01')OR(n='85'AND c='66')OR(n='03'AND c='11')OR(n='41'AND c='66')OR(n='53'AND c='26')OR(n='86'AND c='92')OR(n='23'AND c='82')OR(n='20'AND c='45')OR(n='40'AND c='68')OR(n='64'AND c='28')OR(n='46'AND c='66')OR(n='59'AND c='73')OR(n='74'AND c='68')OR(n='15'AND c='55')OR(n='82'AND c='92')OR(n='58'AND c='70')OR(n='37'AND c='88')OR(n='57'AND c='84')OR(n='89'AND c='89')OR(n='14'AND c='58')OR(n='86'AND c='08')OR(n='23'AND c='98')OR(n='90'AND c='22')OR(n='56'AND c='88')OR(n='93'AND c='12')OR(n='03'AND c='85')OR(n='17'AND c='44')OR(n='38'AND c='89')OR(n='44'AND c='88')OR(n='89'AND c='36')OR(n='52'AND c='21')OR(n='58'AND c='15')OR(n='07'AND c='98')OR(n='41'AND c='70')OR(n='01'AND c='99')OR(n='38'AND c='45')OR(n='00'AND c='02')OR(n='32'AND c='03')OR(n='45'AND c='89')OR(n='49'AND c='86')OR(n='26'AND c='78')OR(n='72'AND c='39')OR(n='81'AND c='91')OR(n='04'AND c='78')OR(n='53'AND c='88')OR(n='01'AND c='48')OR(n='21'AND c='62')OR(n='94'AND c='08')OR(n='06'AND c='70')OR(n='37'AND c='70')OR(n='31'AND c='06')OR(n='87'AND c='32')OR(n='02'AND c='99')OR(n='84'AND c='15')OR(n='83'AND c='15')OR(n='87'AND c='66')OR(n='17'AND c='69')OR(n='62'AND c='85')OR(n='70'AND c='43')OR(n='61'AND c='22')OR(n='17'AND c='82')OR(n='04'AND c='77')OR(n='35'AND c='61')OR(n='42'AND c='08')OR(n='46'AND c='32')OR(n='20'AND c='22')OR(n='17'AND c='13')OR(n='47'AND c='85')OR(n='11'AND c='43')OR(n='63'AND c='75')OR(n='54'AND c='60')OR(n='01'AND c='97')OR(n='71'AND c='45')OR(n='68'AND c='99')OR(n='70'AND c='88')OR(n='64'AND c='19')OR(n='99'AND c='19')OR(n='78'AND c='19')OR(n='41'AND c='19')OR(n='67'AND c='48')OR(n='21'AND c='04')OR(n='49'AND c='15')OR(n='28'AND c='19')OR(n='91'AND c='48')OR(n='56'AND c='04')OR(n='36'AND c='15')OR(n='61'AND c='19')OR(n='45'AND c='48')OR(n='08'AND c='04')OR(n='10'AND c='15')OR(n='93'AND c='19')OR(n='74'AND c='48')OR(n='23'AND c='04')OR(n='80'AND c='15')OR(n='13'AND c='19')OR(n='35'AND c='48')OR(n='36'AND c='04')OR(n='51'AND c='15')OR(n='20'AND c='82')OR(n='32'AND c='19')OR(n='34'AND c='48')OR(n='11'AND c='04')OR(n='20'AND c='15')OR(n='40'AND c='82')OR(n='89'AND c='19')OR(n='51'AND c='69')OR(n='91'AND c='69')OR(n='72'AND c='17')OR(n='20'AND c='98')OR(n='76'AND c='80')OR(n='20'AND c='91')OR(n='99'AND c='69')OR(n='13'AND c='15')OR(n='88'AND c='67')OR(n='53'AND c='98')OR(n='88'AND c='08')OR(n='48'AND c='58')OR(n='94'AND c='70')OR(n='57'AND c='40')OR(n='32'AND c='40')OR(n='92'AND c='40')OR(n='22'AND c='16')OR(n='38'AND c='75')OR(n='32'AND c='99')OR(n='10'AND c='16')OR(n='86'AND c='75')OR(n='19'AND c='99')OR(n='52'AND c='40')OR(n='11'AND c='65')OR(n='53'AND c='65')OR(n='04'AND c='99')OR(n='70'AND c='44')OR(n='37'AND c='87')OR(n='27'AND c='87')OR(n='28'AND c='30')OR(n='34'AND c='34')OR(n='69'AND c='00')OR(n='56'AND c='18')OR(n='28'AND c='34')OR(n='14'AND c='98')OR(n='51'AND c='02')OR(n='39'AND c='51')OR(n='66'AND c='19')OR(n='70'AND c='69')OR(n='64'AND c='78')OR(n='10'AND c='45')OR(n='15'AND c='80')OR(n='78'AND c='78')OR(n='51'AND c='30')OR(n='11'AND c='90')OR(n='87'AND c='20')OR(n='97'AND c='28')OR(n='78'AND c='69')OR(n='58'AND c='88')OR(n='74'AND c='79')OR(n='14'AND c='99')OR(n='63'AND c='99')OR(n='41'AND c='93')OR(n='83'AND c='72')OR(n='52'AND c='77')OR(n='45'AND c='66')OR(n='75'AND c='31')OR(n='81'AND c='27')OR(n='24'AND c='10')OR(n='88'AND c='26')OR(n='25'AND c='68')OR(n='60'AND c='60')OR(n='18'AND c='65')OR(n='55'AND c='16')OR(n='32'AND c='88')OR(n='36'AND c='39')OR(n='27'AND c='01')OR(n='07'AND c='67')OR(n='42'AND c='66')OR(n='03'AND c='65')OR(n='12'AND c='11')OR(n='42'AND c='91')OR(n='77'AND c='13')OR(n='99'AND c='38') 
            OR(n='33'AND c='93')OR(n='46'AND c='92')OR(n='77'AND c='53')OR(n='20'AND c='00')OR(n='58'AND c='97')OR(n='04'AND c='09')OR(n='42'AND c='51')OR(n='93'AND c='56')OR(n='58'AND c='06')OR(n='38'AND c='08')OR(n='46'AND c='12')OR(n='23'AND c='77')OR(n='17'AND c='33')OR(n='28'AND c='90')OR(n='49'AND c='16')OR(n='47'AND c='21')OR(n='04'AND c='25')OR(n='09'AND c='16')OR(n='38'AND c='95')OR(n='13'AND c='88')OR(n='67'AND c='88')OR(n='31'AND c='30')OR(n='58'AND c='23')OR(n='16'AND c='78')OR(n='94'AND c='99')OR(n='88'AND c='99')OR(n='89'AND c='39')OR(n='42'AND c='87')OR(n='42'AND c='99')OR(n='06'AND c='39')OR(n='26'AND c='20')OR(n='49'AND c='56')OR(n='22'AND c='79')OR(n='21'AND c='05')OR(n='08'AND c='09')OR(n='15'AND c='50')OR(n='99'AND c='60')OR(n='90'AND c='22')OR(n='64'AND c='34')OR(n='35'AND c='27')OR(n='95'AND c='91')OR(n='22'AND c='83')OR(n='23'AND c='45')OR(n='79'AND c='07')OR(n='30'AND c='69')OR(n='59'AND c='11')OR(n='46'AND c='44')OR(n='05'AND c='18')OR(n='42'AND c='81')OR(n='95'AND c='43')OR(n='64'AND c='30')OR(n='69'AND c='25')OR(n='43'AND c='61')OR(n='38'AND c='88')OR(n='98'AND c='91')OR(n='37'AND c='22')OR(n='13'AND c='06')OR(n='02'AND c='02')OR(n='39'AND c='50')OR(n='20'AND c='10')OR(n='69'AND c='26')OR(n='10'AND c='88')OR(n='25'AND c='19')OR(n='60'AND c='66')OR(n='59'AND c='11')OR(n='24'AND c='88')OR(n='89'AND c='99')OR(n='99'AND c='12')OR(n='16'AND c='08')OR(n='73'AND c='99')OR(n='34'AND c='88')OR(n='61'AND c='18')OR(n='37'AND c='50')OR(n='53'AND c='79')OR(n='30'AND c='30')OR(n='87'AND c='37')OR(n='12'AND c='26')OR(n='93'AND c='03')OR(n='25'AND c='88')OR(n='64'AND c='83')OR(n='26'AND c='13')OR(n='83'AND c='00')OR(n='37'AND c='70')OR(n='46'AND c='09')OR(n='05'AND c='10')OR(n='88'AND c='08')OR(n='45'AND c='11')OR(n='73'AND c='11')OR(n='14'AND c='66')OR(n='08'AND c='47')OR(n='50'AND c='44')OR(n='71'AND c='36')OR(n='47'AND c='88')OR(n='72'AND c='59')OR(n='00'AND c='67')OR(n='54'AND c='18')OR(n='64'AND c='58')OR(n='05'AND c='51')OR(n='77'AND c='39')OR(n='88'AND c='66')OR(n='62'AND c='77')OR(n='32'AND c='88')OR(n='19'AND c='38')OR(n='32'AND c='85')OR(n='97'AND c='17')OR(n='06'AND c='01')OR(n='53'AND c='03')OR(n='27'AND c='28')OR(n='55'AND c='51')OR(n='20'AND c='77')OR(n='41'AND c='97')OR(n='54'AND c='77')OR(n='18'AND c='23')OR(n='09'AND c='75')OR(n='63'AND c='89')OR(n='59'AND c='97')OR(n='01'AND c='66')OR(n='47'AND c='27')OR(n='32'AND c='50')OR(n='97'AND c='39')OR(n='44'AND c='98')OR(n='06'AND c='96')OR(n='32'AND c='79')OR(n='95'AND c='00')OR(n='52'AND c='57')OR(n='22'AND c='23')OR(n='00'AND c='19')OR(n='55'AND c='19')OR(n='65'AND c='19')OR(n='93'AND c='19')OR(n='94'AND c='19')OR(n='54'AND c='19')OR(n='91'AND c='20')OR(n='92'AND c='19')OR(n='12'AND c='19') 
            OR(n='49'AND c='19')OR(n='16'AND c='69')OR(n='97'AND c='29')OR(n='48'AND c='19')OR(n='89'AND c='19')OR(n='75'AND c='19')OR(n='97'AND c='19')OR(n='07'AND c='19')OR(n='67'AND c='19')OR(n='62'AND c='19')OR(n='73'AND c='19')OR(n='70'AND c='19')OR(n='66'AND c='48')OR(n='13'AND c='04')OR(n='13'AND c='15')OR(n='43'AND c='19')OR(n='93'AND c='82')OR(n='10'AND c='62')OR(n='69'AND c='30')OR(n='23'AND c='15')OR(n='33'AND c='89')OR(n='29'AND c='73')OR(n='35'AND c='30')OR(n='16'AND c='77')OR(n='28'AND c='19')OR(n='05'AND c='19')OR(n='68'AND c='19')OR(n='23'AND c='19')OR(n='33'AND c='19')OR(n='77'AND c='19')OR(n='79'AND c='19')OR(n='80'AND c='19')OR(n='22'AND c='19')OR(n='69'AND c='19')OR(n='23'AND c='19')OR(n='29'AND c='19')OR(n='69'AND c='19')OR(n='02'AND c='19')OR(n='72'AND c='19')OR(n='42'AND c='19')OR(n='95'AND c='65')OR(n='53'AND c='77')OR(n='65'AND c='77')OR(n='75'AND c='77')OR(n='67'AND c='15')OR(n='29'AND c='77')OR(n='98'AND c='77')OR(n='78'AND c='77')OR(n='85'AND c='77')OR(n='94'AND c='77')OR(n='58'AND c='77')OR(n='90'AND c='77')OR(n='88'AND c='77')OR(n='83'AND c='77')OR(n='28'AND c='77')OR(n='99'AND c='77')OR(n='37'AND c='77')OR(n='14'AND c='30')OR(n='34'AND c='91')OR(n='20'AND c='99')OR(n='98'AND c='54')OR(n='54'AND c='98')OR(n='88'AND c='98')OR(n='29'AND c='98')OR(n='31'AND c='98')OR(n='37'AND c='98')OR(n='25'AND c='60')OR(n='69'AND c='66')OR(n='98'AND c='89')OR(n='75'AND c='20')OR(n='83'AND c='60')OR(n='61'AND c='48')OR(n='00'AND c='04')OR(n='33'AND c='15')OR(n='36'AND c='19')OR(n='79'AND c='65')OR(n='51'AND c='99')OR(n='70'AND c='34')OR(n='97'AND c='88')OR(n='89'AND c='39')OR(n='73'AND c='11')OR(n='72'AND c='39')OR(n='06'AND c='22')OR(n='48'AND c='39')OR(n='59'AND c='81')OR(n='85'AND c='02')OR(n='40'AND c='39')OR(n='01'AND c='73')OR(n='44'AND c='57')OR(n='01'AND c='33')OR(n='51'AND c='36')OR(n='45'AND c='11')OR(n='31'AND c='88')OR(n='58'AND c='11')OR(n='71'AND c='11')OR(n='77'AND c='52')OR(n='88'AND c='33')OR(n='66'AND c='86')OR(n='14'AND c='40')OR(n='23'AND c='33')OR(n='79'AND c='19')OR(n='15'AND c='05')OR(n='23'AND c='76')OR(n='05'AND c='53')OR(n='69'AND c='76')OR(n='86'AND c='85')OR(n='17'AND c='44')OR(n='32'AND c='77')OR(n='17'AND c='95')OR(n='83'AND c='62')OR(n='59'AND c='28')OR(n='52'AND c='26')OR(n='48'AND c='26')OR(n='65'AND c='77')OR(n='62'AND c='19')OR(n='27'AND c='90')OR(n='10'AND c='88')OR(n='82'AND c='65')OR(n='38'AND c='44')OR(n='65'AND c='91')OR(n='98'AND c='12')OR(n='84'AND c='91')OR(n='94'AND c='85')OR(n='27'AND c='86')OR(n='18'AND c='78')OR(n='90'AND c='83')OR(n='85'AND c='80')OR(n='93'AND c='05') 
            OR(n='97'AND c='58')OR(n='60'AND c='71')OR(n='96'AND c='88')OR(n='31'AND c='86')OR(n='13'AND c='91')OR(n='33'AND c='91')OR(n='24'AND c='23')OR(n='74'AND c='80')OR(n='52'AND c='56')OR(n='16'AND c='85')OR(n='22'AND c='97')OR(n='74'AND c='30')OR(n='11'AND c='55')OR(n='68'AND c='36')OR(n='61'AND c='79')OR(n='86'AND c='03')OR(n='81'AND c='76')OR(n='77'AND c='82')OR(n='49'AND c='65')OR(n='68'AND c='76')OR(n='70'AND c='82')OR(n='13'AND c='18')OR(n='14'AND c='06')OR(n='52'AND c='88')OR(n='12'AND c='37')OR(n='57'AND c='11')OR(n='61'AND c='08')OR(n='04'AND c='44')OR(n='43'AND c='98')OR(n='40'AND c='00')OR(n='93'AND c='76')OR(n='62'AND c='82')OR(n='57'AND c='83')OR(n='57'AND c='19')OR(n='00'AND c='82')OR(n='28'AND c='48')OR(n='57'AND c='04')OR(n='06'AND c='19')OR(n='13'AND c='15')OR(n='81'AND c='88')OR(n='26'AND c='48')OR(n='45'AND c='04')OR(n='98'AND c='19')OR(n='08'AND c='15')OR(n='70'AND c='86')OR(n='84'AND c='77')OR(n='57'AND c='34')OR(n='99'AND c='90')OR(n='54'AND c='65')OR(n='19'AND c='36')OR(n='70'AND c='11')OR(n='68'AND c='11')OR(n='52'AND c='11')OR(n='11'AND c='11')OR(n='48'AND c='11')OR(n='33'AND c='11')OR(n='60'AND c='26')OR(n='36'AND c='40')OR(n='99'AND c='01')OR(n='52'AND c='99')OR(n='74'AND c='38')OR(n='45'AND c='52')OR(n='53'AND c='83')OR(n='74'AND c='96')OR(n='11'AND c='94')OR(n='43'AND c='22')OR(n='46'AND c='88')OR(n='01'AND c='93')OR(n='87'AND c='52')OR(n='82'AND c='98')OR(n='70'AND c='58')OR(n='43'AND c='57')OR(n='43'AND c='61')OR(n='30'AND c='68')OR(n='82'AND c='89')OR(n='55'AND c='06')OR(n='16'AND c='89')OR(n='57'AND c='89')OR(n='93'AND c='66')OR(n='77'AND c='22')OR(n='99'AND c='88')OR(n='00'AND c='50')OR(n='23'AND c='99')OR(n='17'AND c='22')OR(n='22'AND c='56')OR(n='88'AND c='27')OR(n='47'AND c='26')OR(n='81'AND c='91')OR(n='32'AND c='69')OR(n='68'AND c='58')OR(n='74'AND c='68')OR(n='38'AND c='60')OR(n='36'AND c='51')OR(n='85'AND c='22')OR(n='62'AND c='86')OR(n='54'AND c='82')OR(n='32'AND c='99')OR(n='38'AND c='67')OR(n='65'AND c='29')OR(n='35'AND c='00')OR(n='62'AND c='35')OR(n='24'AND c='73')OR(n='40'AND c='67')OR(n='38'AND c='01')OR(n='92'AND c='15')OR(n='46'AND c='78')OR(n='65'AND c='18')OR(n='31'AND c='44')OR(n='74'AND c='00')OR(n='91'AND c='86')OR(n='23'AND c='78')OR(n='92'AND c='33')OR(n='62'AND c='26')OR(n='08'AND c='58')OR(n='12'AND c='55')OR(n='97'AND c='85')OR(n='21'AND c='88')OR(n='07'AND c='33')OR(n='44'AND c='72')OR(n='32'AND c='29')OR(n='87'AND c='18')OR(n='97'AND c='40')OR(n='42'AND c='98')OR(n='72'AND c='83')OR(n='37'AND c='50')OR(n='33'AND c='63')OR(n='67'AND c='18')OR(n='55'AND c='11')OR(n='67'AND c='59')OR(n='84'AND c='88')OR(n='16'AND c='58')OR(n='92'AND c='55')OR(n='99'AND c='20')OR(n='31'AND c='15')OR(n='56'AND c='83') 
            OR(n='85'AND c='77')OR(n='70'AND c='89')OR(n='78'AND c='91')OR(n='21'AND c='43')OR(n='20'AND c='72')OR(n='27'AND c='86')OR(n='84'AND c='33')OR(n='46'AND c='30')OR(n='34'AND c='36')OR(n='40'AND c='67')OR(n='48'AND c='25')OR(n='53'AND c='18')OR(n='30'AND c='96')OR(n='16'AND c='95')OR(n='66'AND c='69')OR(n='02'AND c='43')OR(n='50'AND c='11')OR(n='92'AND c='30')OR(n='14'AND c='35')OR(n='34'AND c='45')OR(n='92'AND c='45')OR(n='84'AND c='37')OR(n='81'AND c='29')OR(n='96'AND c='19')OR(n='15'AND c='97')OR(n='89'AND c='32')OR(n='28'AND c='45')OR(n='89'AND c='71')OR(n='98'AND c='45')OR(n='11'AND c='22')OR(n='83'AND c='29')OR(n='71'AND c='19')OR(n='77'AND c='97')OR(n='19'AND c='45')OR(n='26'AND c='71')OR(n='36'AND c='45')OR(n='61'AND c='37')OR(n='67'AND c='29')OR(n='73'AND c='19')OR(n='70'AND c='97')OR(n='24'AND c='32')OR(n='99'AND c='45')OR(n='61'AND c='71')OR(n='50'AND c='11')OR(n='48'AND c='76')OR(n='22'AND c='81')OR(n='62'AND c='15')OR(n='67'AND c='77')OR(n='69'AND c='50')OR(n='97'AND c='34')OR(n='93'AND c='34')OR(n='04'AND c='55')OR(n='67'AND c='88')OR(n='98'AND c='93')OR(n='93'AND c='82')OR(n='63'AND c='77')OR(n='95'AND c='11')OR(n='91'AND c='25')OR(n='59'AND c='08')OR(n='48'AND c='97')OR(n='06'AND c='91')OR(n='02'AND c='22')OR(n='10'AND c='69')OR(n='32'AND c='28')OR(n='30'AND c='18')OR(n='70'AND c='68')OR(n='43'AND c='86')OR(n='76'AND c='95')OR(n='65'AND c='77')OR(n='64'AND c='29')OR(n='66'AND c='69')OR(n='13'AND c='93')OR(n='08'AND c='50')OR(n='65'AND c='66')OR(n='35'AND c='98')OR(n='46'AND c='49')OR(n='85'AND c='22')OR(n='90'AND c='77')OR(n='03'AND c='66')OR(n='33'AND c='99')OR(n='60'AND c='44')OR(n='71'AND c='86')OR(n='11'AND c='86')OR(n='48'AND c='86')OR(n='28'AND c='86')OR(n='40'AND c='86')OR(n='70'AND c='86')OR(n='99'AND c='82')OR(n='83'AND c='59')OR(n='85'AND c='88')OR(n='55'AND c='74')OR(n='97'AND c='96')OR(n='39'AND c='56')OR(n='59'AND c='48')OR(n='42'AND c='04')OR(n='96'AND c='15')OR(n='34'AND c='19')OR(n='26'AND c='15')OR(n='74'AND c='15')OR(n='76'AND c='25')OR(n='24'AND c='58')OR(n='67'AND c='81')OR(n='25'AND c='13')OR(n='98'AND c='75')OR(n='71'AND c='21')OR(n='81'AND c='25')OR(n='85'AND c='99')OR(n='34'AND c='99')OR(n='48'AND c='99')OR(n='53'AND c='79')OR(n='70'AND c='86')OR(n='02'AND c='86')OR(n='13'AND c='86')OR(n='25'AND c='11')OR(n='85'AND c='18')OR(n='50'AND c='78')OR(n='04'AND c='11')OR(n='54'AND c='86')OR(n='00'AND c='86')OR(n='28'AND c='86')OR(n='40'AND c='99')OR(n='97'AND c='99')OR(n='84'AND c='99')OR(n='47'AND c='48')OR(n='41'AND c='04')OR(n='56'AND c='15')OR(n='97'AND c='19')OR(n='91'AND c='48')OR(n='00'AND c='04')OR(n='97'AND c='15')OR(n='05'AND c='19')OR(n='47'AND c='48')OR(n='25'AND c='04')OR(n='72'AND c='15')OR(n='93'AND c='19')OR(n='68'AND c='48')OR(n='41'AND c='04')OR(n='17'AND c='15')OR(n='17'AND c='19')OR(n='70'AND c='48')OR(n='96'AND c='04')OR(n='65'AND c='15')OR(n='50'AND c='19')OR(n='31'AND c='48')OR(n='79'AND c='04')OR(n='01'AND c='15')OR(n='03'AND c='19')OR(n='12'AND c='48')OR(n='14'AND c='04')OR(n='70'AND c='15')OR(n='51'AND c='19')OR(n='30'AND c='48')OR(n='49'AND c='04')OR(n='41'AND c='15')OR(n='32'AND c='19')OR(n='34'AND c='48')OR(n='20'AND c='04')OR(n='13'AND c='15')OR(n='05'AND c='19')OR(n='29'AND c='48')OR(n='21'AND c='04')OR(n='48'AND c='15')OR(n='18'AND c='19')OR(n='17'AND c='99')OR(n='53'AND c='22')OR(n='96'AND c='17')OR(n='98'AND c='79')OR(n='86'AND c='25')OR(n='67'AND c='98')OR(n='46'AND c='12')OR(n='84'AND c='55')OR(n='67'AND c='83')OR(n='86'AND c='28')OR(n='65'AND c='36')OR(n='00'AND c='07')OR(n='78'AND c='60')OR(n='58'AND c='89')OR(n='60'AND c='25')OR(n='82'AND c='29')OR(n='19'AND c='77')OR(n='90'AND c='66')OR(n='82'AND c='95')OR(n='91'AND c='80')OR(n='59'AND c='11')OR(n='66'AND c='38')OR(n='93'AND c='78')OR(n='71'AND c='72')OR(n='95'AND c='32')OR(n='36'AND c='32')OR(n='09'AND c='32')OR(n='39'AND c='15')OR(n='61'AND c='48')OR(n='71'AND c='11')OR(n='30'AND c='22')OR(n='51'AND c='26')OR(n='82'AND c='37')OR(n='35'AND c='79')OR(n='43'AND c='44')OR(n='61'AND c='56')OR(n='39'AND c='08')OR(n='83'AND c='56')OR(n='68'AND c='99')OR(n='51'AND c='99')OR(n='31'AND c='78')OR(n='94'AND c='99')OR(n='01'AND c='99')OR(n='31'AND c='80')OR(n='78'AND c='78')OR(n='16'AND c='99')OR(n='65'AND c='55')OR(n='49'AND c='11')OR(n='35'AND c='94')OR(n='78'AND c='99')OR(n='49'AND c='49')OR(n='58'AND c='27')OR(n='75'AND c='66')OR(n='97'AND c='99')OR(n='55'AND c='23')OR(n='02'AND c='77')OR(n='44'AND c='98')OR(n='58'AND c='18')OR(n='04'AND c='11')OR(n='83'AND c='10')OR(n='49'AND c='93')OR(n='22'AND c='99')OR(n='65'AND c='30')OR(n='01'AND c='87')OR(n='03'AND c='22')OR(n='73'AND c='06')OR(n='41'AND c='76')OR(n='13'AND c='26')OR(n='92'AND c='69')OR(n='88'AND c='37')OR(n='62'AND c='06')OR(n='85'AND c='00')OR(n='28'AND c='77')OR(n='06'AND c='06')OR(n='47'AND c='26') 
            OR(n='16'AND c='98')OR(n='33'AND c='83')OR(n='14'AND c='56')OR(n='57'AND c='71')OR(n='01'AND c='71')OR(n='12'AND c='45')OR(n='50'AND c='68')OR(n='06'AND c='88')OR(n='07'AND c='68')OR(n='34'AND c='28')OR(n='44'AND c='60')OR(n='48'AND c='96')OR(n='42'AND c='24')OR(n='93'AND c='82')OR(n='33'AND c='67')OR(n='59'AND c='96')OR(n='62'AND c='30')OR(n='03'AND c='18')OR(n='37'AND c='11')OR(n='73'AND c='33')OR(n='84'AND c='18')OR(n='58'AND c='66')OR(n='17'AND c='02')OR(n='92'AND c='56')OR(n='39'AND c='38')OR(n='32'AND c='44')OR(n='62'AND c='77')OR(n='70'AND c='68')OR(n='50'AND c='26')OR(n='17'AND c='48')OR(n='91'AND c='48')OR(n='41'AND c='66')OR(n='11'AND c='60')OR(n='45'AND c='66')OR(n='89'AND c='71')OR(n='97'AND c='75')OR(n='19'AND c='88')OR(n='56'AND c='70')OR(n='28'AND c='08')OR(n='55'AND c='55')OR(n='48'AND c='88')OR(n='92'AND c='82')OR(n='41'AND c='30')OR(n='98'AND c='30')OR(n='27'AND c='66')OR(n='68'AND c='09')OR(n='02'AND c='82')OR(n='65'AND c='88')OR(n='76'AND c='03')OR(n='15'AND c='20')OR(n='39'AND c='56')OR(n='29'AND c='56')OR(n='55'AND c='51')OR(n='20'AND c='22')OR(n='27'AND c='00')OR(n='66'AND c='37')OR(n='75'AND c='27')OR(n='79'AND c='35')OR(n='21'AND c='54')OR(n='13'AND c='98')OR(n='21'AND c='83')OR(n='17'AND c='11')OR(n='95'AND c='26')OR(n='76'AND c='91')OR(n='74'AND c='68')OR(n='28'AND c='71')OR(n='83'AND c='56')OR(n='04'AND c='99')OR(n='17'AND c='60')OR(n='18'AND c='75')OR(n='56'AND c='94')OR(n='00'AND c='73')OR(n='42'AND c='88')OR(n='40'AND c='90')OR(n='63'AND c='87')OR(n='25'AND c='56')OR(n='77'AND c='03')OR(n='08'AND c='96')OR(n='91'AND c='66')OR(n='06'AND c='72')OR(n='94'AND c='86')OR(n='80'AND c='77')OR(n='34'AND c='07')OR(n='75'AND c='72')OR(n='05'AND c='50')OR(n='32'AND c='91')OR(n='94'AND c='71')OR(n='24'AND c='91')OR(n='95'AND c='06')OR(n='94'AND c='91')OR(n='71'AND c='86')OR(n='88'AND c='96')OR(n='36'AND c='88')OR(n='37'AND c='22')OR(n='65'AND c='66')OR(n='04'AND c='71')OR(n='41'AND c='27')OR(n='47'AND c='22')OR(n='32'AND c='97')OR(n='20'AND c='36')OR(n='63'AND c='66')OR(n='43'AND c='20')OR(n='98'AND c='97')OR(n='06'AND c='86')OR(n='45'AND c='58')OR(n='42'AND c='95')OR(n='20'AND c='65')OR(n='44'AND c='77')OR(n='76'AND c='88')OR(n='33'AND c='68')OR(n='48'AND c='83')OR(n='47'AND c='99') 
            """
    }
     
}
