// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite('nereids_arith_p0_string') {
	sql 'use regression_test_nereids_arith_p0'
	sql 'set enable_nereids_planner=true'
	sql 'set enable_fallback_to_original_planner=false'
	qt_sql_test_Char_TinyInt_0 """
		select id, kchr + ktint, kchr - ktint from expr_test order by id"""
	qt_sql_test_Char_TinyInt_notn_0 """
		select id, kchr + ktint, kchr - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_TinyInt_1 """
		select id, kchr * ktint, kchr / ktint, kchr % ktint from expr_test order by id"""
	qt_sql_test_Char_TinyInt_notn_1 """
		select id, kchr * ktint, kchr / ktint, kchr % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_TinyInt_2 """
		select id, kchr DIV ktint from expr_test order by id"""
	qt_sql_test_Char_TinyInt_notn_2 """
		select id, kchr DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_TinyInt_3 """
		select id, kchr & ktint, kchr | ktint, kchr ^ ktint from expr_test order by id"""
	qt_sql_test_Char_TinyInt_notn_3 """
		select id, kchr & ktint, kchr | ktint, kchr ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_TinyInt_4 """
	// 	select id, BITAND(kchr, ktint), BITOR(kchr, ktint), BITXOR(kchr, ktint) from expr_test order by id"""
	// qt_sql_test_Char_TinyInt_notn_4 """
	// 	select id, BITAND(kchr, ktint), BITOR(kchr, ktint), BITXOR(kchr, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_SmallInt_0 """
		select id, kchr + ksint, kchr - ksint from expr_test order by id"""
	qt_sql_test_Char_SmallInt_notn_0 """
		select id, kchr + ksint, kchr - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_SmallInt_1 """
		select id, kchr * ksint, kchr / ksint, kchr % ksint from expr_test order by id"""
	qt_sql_test_Char_SmallInt_notn_1 """
		select id, kchr * ksint, kchr / ksint, kchr % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_SmallInt_2 """
		select id, kchr DIV ksint from expr_test order by id"""
	qt_sql_test_Char_SmallInt_notn_2 """
		select id, kchr DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_SmallInt_3 """
		select id, kchr & ksint, kchr | ksint, kchr ^ ksint from expr_test order by id"""
	qt_sql_test_Char_SmallInt_notn_3 """
		select id, kchr & ksint, kchr | ksint, kchr ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_SmallInt_4 """
	// 	select id, BITAND(kchr, ksint), BITOR(kchr, ksint), BITXOR(kchr, ksint) from expr_test order by id"""
	// qt_sql_test_Char_SmallInt_notn_4 """
	// 	select id, BITAND(kchr, ksint), BITOR(kchr, ksint), BITXOR(kchr, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Integer_0 """
		select id, kchr + kint, kchr - kint from expr_test order by id"""
	qt_sql_test_Char_Integer_notn_0 """
		select id, kchr + kint, kchr - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Integer_1 """
		select id, kchr * kint, kchr / kint, kchr % kint from expr_test order by id"""
	qt_sql_test_Char_Integer_notn_1 """
		select id, kchr * kint, kchr / kint, kchr % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Integer_2 """
		select id, kchr DIV kint from expr_test order by id"""
	qt_sql_test_Char_Integer_notn_2 """
		select id, kchr DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Integer_3 """
		select id, kchr & kint, kchr | kint, kchr ^ kint from expr_test order by id"""
	qt_sql_test_Char_Integer_notn_3 """
		select id, kchr & kint, kchr | kint, kchr ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Integer_4 """
	// 	select id, BITAND(kchr, kint), BITOR(kchr, kint), BITXOR(kchr, kint) from expr_test order by id"""
	// qt_sql_test_Char_Integer_notn_4 """
	// 	select id, BITAND(kchr, kint), BITOR(kchr, kint), BITXOR(kchr, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_BigInt_0 """
		select id, kchr + kbint, kchr - kbint from expr_test order by id"""
	qt_sql_test_Char_BigInt_notn_0 """
		select id, kchr + kbint, kchr - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_BigInt_1 """
		select id, kchr * kbint, kchr / kbint, kchr % kbint from expr_test order by id"""
	qt_sql_test_Char_BigInt_notn_1 """
		select id, kchr * kbint, kchr / kbint, kchr % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_BigInt_2 """
		select id, kchr DIV kbint from expr_test order by id"""
	qt_sql_test_Char_BigInt_notn_2 """
		select id, kchr DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_BigInt_3 """
		select id, kchr & kbint, kchr | kbint, kchr ^ kbint from expr_test order by id"""
	qt_sql_test_Char_BigInt_notn_3 """
		select id, kchr & kbint, kchr | kbint, kchr ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_BigInt_4 """
	// 	select id, BITAND(kchr, kbint), BITOR(kchr, kbint), BITXOR(kchr, kbint) from expr_test order by id"""
	// qt_sql_test_Char_BigInt_notn_4 """
	// 	select id, BITAND(kchr, kbint), BITOR(kchr, kbint), BITXOR(kchr, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_LargeInt_0 """
		select id, kchr + klint, kchr - klint from expr_test order by id"""
	qt_sql_test_Char_LargeInt_notn_0 """
		select id, kchr + klint, kchr - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_LargeInt_1 """
		select id, kchr * klint, kchr / klint, kchr % klint from expr_test order by id"""
	qt_sql_test_Char_LargeInt_notn_1 """
		select id, kchr * klint, kchr / klint, kchr % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_LargeInt_2 """
		select id, kchr DIV klint from expr_test order by id"""
	qt_sql_test_Char_LargeInt_notn_2 """
		select id, kchr DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Char_LargeInt_3 """
		select id, kchr & klint, kchr | klint, kchr ^ klint from expr_test order by id"""
	qt_sql_test_Char_LargeInt_notn_3 """
		select id, kchr & klint, kchr | klint, kchr ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_LargeInt_4 """
	// 	select id, BITAND(kchr, klint), BITOR(kchr, klint), BITXOR(kchr, klint) from expr_test order by id"""
	// qt_sql_test_Char_LargeInt_notn_4 """
	// 	select id, BITAND(kchr, klint), BITOR(kchr, klint), BITXOR(kchr, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Float_0 """
		select id, kchr + kfloat, kchr - kfloat from expr_test order by id"""
	qt_sql_test_Char_Float_notn_0 """
		select id, kchr + kfloat, kchr - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Float_1 """
		select id, kchr * kfloat, kchr / kfloat, kchr % kfloat from expr_test order by id"""
	qt_sql_test_Char_Float_notn_1 """
		select id, kchr * kfloat, kchr / kfloat, kchr % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Float_2 """
		select id, kchr DIV kfloat from expr_test order by id"""
	qt_sql_test_Char_Float_notn_2 """
		select id, kchr DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Float_3 """
		select id, kchr & kfloat, kchr | kfloat, kchr ^ kfloat from expr_test order by id"""
	qt_sql_test_Char_Float_notn_3 """
		select id, kchr & kfloat, kchr | kfloat, kchr ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Float_4 """
	// 	select id, BITAND(kchr, kfloat), BITOR(kchr, kfloat), BITXOR(kchr, kfloat) from expr_test order by id"""
	// qt_sql_test_Char_Float_notn_4 """
	// 	select id, BITAND(kchr, kfloat), BITOR(kchr, kfloat), BITXOR(kchr, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Double_0 """
		select id, kchr + kdbl, kchr - kdbl from expr_test order by id"""
	qt_sql_test_Char_Double_notn_0 """
		select id, kchr + kdbl, kchr - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Double_1 """
		select id, kchr * kdbl, kchr / kdbl, kchr % kdbl from expr_test order by id"""
	qt_sql_test_Char_Double_notn_1 """
		select id, kchr * kdbl, kchr / kdbl, kchr % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Double_2 """
		select id, kchr DIV kdbl from expr_test order by id"""
	qt_sql_test_Char_Double_notn_2 """
		select id, kchr DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Double_3 """
		select id, kchr & kdbl, kchr | kdbl, kchr ^ kdbl from expr_test order by id"""
	qt_sql_test_Char_Double_notn_3 """
		select id, kchr & kdbl, kchr | kdbl, kchr ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Double_4 """
	// 	select id, BITAND(kchr, kdbl), BITOR(kchr, kdbl), BITXOR(kchr, kdbl) from expr_test order by id"""
	// qt_sql_test_Char_Double_notn_4 """
	// 	select id, BITAND(kchr, kdbl), BITOR(kchr, kdbl), BITXOR(kchr, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DecimalV2_0 """
		select id, kchr + kdcml, kchr - kdcml from expr_test order by id"""
	qt_sql_test_Char_DecimalV2_notn_0 """
		select id, kchr + kdcml, kchr - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DecimalV2_1 """
		select id, kchr * kdcml, kchr / kdcml, kchr % kdcml from expr_test order by id"""
	qt_sql_test_Char_DecimalV2_notn_1 """
		select id, kchr * kdcml, kchr / kdcml, kchr % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DecimalV2_2 """
		select id, kchr DIV kdcml from expr_test order by id"""
	qt_sql_test_Char_DecimalV2_notn_2 """
		select id, kchr DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DecimalV2_3 """
		select id, kchr & kdcml, kchr | kdcml, kchr ^ kdcml from expr_test order by id"""
	qt_sql_test_Char_DecimalV2_notn_3 """
		select id, kchr & kdcml, kchr | kdcml, kchr ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_DecimalV2_4 """
	// 	select id, BITAND(kchr, kdcml), BITOR(kchr, kdcml), BITXOR(kchr, kdcml) from expr_test order by id"""
	// qt_sql_test_Char_DecimalV2_notn_4 """
	// 	select id, BITAND(kchr, kdcml), BITOR(kchr, kdcml), BITXOR(kchr, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal32V3_0 """
		select id, kchr + kdcml32v3, kchr - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal32V3_notn_0 """
		select id, kchr + kdcml32v3, kchr - kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal32V3_1 """
		select id, kchr * kdcml32v3, kchr / kdcml32v3, kchr % kdcml32v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal32V3_notn_1 """
		select id, kchr * kdcml32v3, kchr / kdcml32v3, kchr % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal32V3_2 """
		select id, kchr DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal32V3_notn_2 """
		select id, kchr DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal32V3_3 """
		select id, kchr & kdcml32v3, kchr | kdcml32v3, kchr ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal32V3_notn_3 """
		select id, kchr & kdcml32v3, kchr | kdcml32v3, kchr ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Decimal32V3_4 """
	// 	select id, BITAND(kchr, kdcml32v3), BITOR(kchr, kdcml32v3), BITXOR(kchr, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Char_Decimal32V3_notn_4 """
	// 	select id, BITAND(kchr, kdcml32v3), BITOR(kchr, kdcml32v3), BITXOR(kchr, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal64V3_0 """
		select id, kchr + kdcml64v3, kchr - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal64V3_notn_0 """
		select id, kchr + kdcml64v3, kchr - kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal64V3_1 """
		select id, kchr * kdcml64v3, kchr / kdcml64v3, kchr % kdcml64v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal64V3_notn_1 """
		select id, kchr * kdcml64v3, kchr / kdcml64v3, kchr % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal64V3_2 """
		select id, kchr DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal64V3_notn_2 """
		select id, kchr DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal64V3_3 """
		select id, kchr & kdcml64v3, kchr | kdcml64v3, kchr ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal64V3_notn_3 """
		select id, kchr & kdcml64v3, kchr | kdcml64v3, kchr ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Decimal64V3_4 """
	// 	select id, BITAND(kchr, kdcml64v3), BITOR(kchr, kdcml64v3), BITXOR(kchr, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Char_Decimal64V3_notn_4 """
	// 	select id, BITAND(kchr, kdcml64v3), BITOR(kchr, kdcml64v3), BITXOR(kchr, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal128V3_0 """
		select id, kchr + kdcml128v3, kchr - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal128V3_notn_0 """
		select id, kchr + kdcml128v3, kchr - kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal128V3_1 """
		select id, kchr * kdcml128v3, kchr / kdcml128v3, kchr % kdcml128v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal128V3_notn_1 """
		select id, kchr * kdcml128v3, kchr / kdcml128v3, kchr % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal128V3_2 """
		select id, kchr DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal128V3_notn_2 """
		select id, kchr DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Decimal128V3_3 """
		select id, kchr & kdcml128v3, kchr | kdcml128v3, kchr ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Char_Decimal128V3_notn_3 """
		select id, kchr & kdcml128v3, kchr | kdcml128v3, kchr ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Decimal128V3_4 """
	// 	select id, BITAND(kchr, kdcml128v3), BITOR(kchr, kdcml128v3), BITXOR(kchr, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Char_Decimal128V3_notn_4 """
	// 	select id, BITAND(kchr, kdcml128v3), BITOR(kchr, kdcml128v3), BITXOR(kchr, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Char_0 """
		select id, kchr + kchr, kchr - kchr from expr_test order by id"""
	qt_sql_test_Char_Char_notn_0 """
		select id, kchr + kchr, kchr - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Char_1 """
		select id, kchr * kchr, kchr / kchr, kchr % kchr from expr_test order by id"""
	qt_sql_test_Char_Char_notn_1 """
		select id, kchr * kchr, kchr / kchr, kchr % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Char_2 """
		select id, kchr DIV kchr from expr_test order by id"""
	qt_sql_test_Char_Char_notn_2 """
		select id, kchr DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Char_3 """
		select id, kchr & kchr, kchr | kchr, kchr ^ kchr from expr_test order by id"""
	qt_sql_test_Char_Char_notn_3 """
		select id, kchr & kchr, kchr | kchr, kchr ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Char_4 """
	// 	select id, BITAND(kchr, kchr), BITOR(kchr, kchr), BITXOR(kchr, kchr) from expr_test order by id"""
	// qt_sql_test_Char_Char_notn_4 """
	// 	select id, BITAND(kchr, kchr), BITOR(kchr, kchr), BITXOR(kchr, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Varchar_0 """
		select id, kchr + kvchr, kchr - kvchr from expr_test order by id"""
	qt_sql_test_Char_Varchar_notn_0 """
		select id, kchr + kvchr, kchr - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Varchar_1 """
		select id, kchr * kvchr, kchr / kvchr, kchr % kvchr from expr_test order by id"""
	qt_sql_test_Char_Varchar_notn_1 """
		select id, kchr * kvchr, kchr / kvchr, kchr % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Varchar_2 """
		select id, kchr DIV kvchr from expr_test order by id"""
	qt_sql_test_Char_Varchar_notn_2 """
		select id, kchr DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Varchar_3 """
		select id, kchr & kvchr, kchr | kvchr, kchr ^ kvchr from expr_test order by id"""
	qt_sql_test_Char_Varchar_notn_3 """
		select id, kchr & kvchr, kchr | kvchr, kchr ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Varchar_4 """
	// 	select id, BITAND(kchr, kvchr), BITOR(kchr, kvchr), BITXOR(kchr, kvchr) from expr_test order by id"""
	// qt_sql_test_Char_Varchar_notn_4 """
	// 	select id, BITAND(kchr, kvchr), BITOR(kchr, kvchr), BITXOR(kchr, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_String_0 """
		select id, kchr + kstr, kchr - kstr from expr_test order by id"""
	qt_sql_test_Char_String_notn_0 """
		select id, kchr + kstr, kchr - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_String_1 """
		select id, kchr * kstr, kchr / kstr, kchr % kstr from expr_test order by id"""
	qt_sql_test_Char_String_notn_1 """
		select id, kchr * kstr, kchr / kstr, kchr % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_String_2 """
		select id, kchr DIV kstr from expr_test order by id"""
	qt_sql_test_Char_String_notn_2 """
		select id, kchr DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Char_String_3 """
		select id, kchr & kstr, kchr | kstr, kchr ^ kstr from expr_test order by id"""
	qt_sql_test_Char_String_notn_3 """
		select id, kchr & kstr, kchr | kstr, kchr ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_String_4 """
	// 	select id, BITAND(kchr, kstr), BITOR(kchr, kstr), BITXOR(kchr, kstr) from expr_test order by id"""
	// qt_sql_test_Char_String_notn_4 """
	// 	select id, BITAND(kchr, kstr), BITOR(kchr, kstr), BITXOR(kchr, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Date_0 """
		select id, kchr + kdt, kchr - kdt from expr_test order by id"""
	qt_sql_test_Char_Date_notn_0 """
		select id, kchr + kdt, kchr - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Date_1 """
		select id, kchr * kdt, kchr / kdt, kchr % kdt from expr_test order by id"""
	qt_sql_test_Char_Date_notn_1 """
		select id, kchr * kdt, kchr / kdt, kchr % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Date_2 """
		select id, kchr DIV kdt from expr_test order by id"""
	qt_sql_test_Char_Date_notn_2 """
		select id, kchr DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Date_3 """
		select id, kchr & kdt, kchr | kdt, kchr ^ kdt from expr_test order by id"""
	qt_sql_test_Char_Date_notn_3 """
		select id, kchr & kdt, kchr | kdt, kchr ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Date_4 """
	// 	select id, BITAND(kchr, kdt), BITOR(kchr, kdt), BITXOR(kchr, kdt) from expr_test order by id"""
	// qt_sql_test_Char_Date_notn_4 """
	// 	select id, BITAND(kchr, kdt), BITOR(kchr, kdt), BITXOR(kchr, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTime_0 """
		select id, kchr + kdtm, kchr - kdtm from expr_test order by id"""
	qt_sql_test_Char_DateTime_notn_0 """
		select id, kchr + kdtm, kchr - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTime_1 """
		select id, kchr * kdtm, kchr / kdtm, kchr % kdtm from expr_test order by id"""
	qt_sql_test_Char_DateTime_notn_1 """
		select id, kchr * kdtm, kchr / kdtm, kchr % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTime_2 """
		select id, kchr DIV kdtm from expr_test order by id"""
	qt_sql_test_Char_DateTime_notn_2 """
		select id, kchr DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTime_3 """
		select id, kchr & kdtm, kchr | kdtm, kchr ^ kdtm from expr_test order by id"""
	qt_sql_test_Char_DateTime_notn_3 """
		select id, kchr & kdtm, kchr | kdtm, kchr ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_DateTime_4 """
	// 	select id, BITAND(kchr, kdtm), BITOR(kchr, kdtm), BITXOR(kchr, kdtm) from expr_test order by id"""
	// qt_sql_test_Char_DateTime_notn_4 """
	// 	select id, BITAND(kchr, kdtm), BITOR(kchr, kdtm), BITXOR(kchr, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateV2_0 """
		select id, kchr + kdtv2, kchr - kdtv2 from expr_test order by id"""
	qt_sql_test_Char_DateV2_notn_0 """
		select id, kchr + kdtv2, kchr - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateV2_1 """
		select id, kchr * kdtv2, kchr / kdtv2, kchr % kdtv2 from expr_test order by id"""
	qt_sql_test_Char_DateV2_notn_1 """
		select id, kchr * kdtv2, kchr / kdtv2, kchr % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateV2_2 """
		select id, kchr DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Char_DateV2_notn_2 """
		select id, kchr DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateV2_3 """
		select id, kchr & kdtv2, kchr | kdtv2, kchr ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Char_DateV2_notn_3 """
		select id, kchr & kdtv2, kchr | kdtv2, kchr ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_DateV2_4 """
	// 	select id, BITAND(kchr, kdtv2), BITOR(kchr, kdtv2), BITXOR(kchr, kdtv2) from expr_test order by id"""
	// qt_sql_test_Char_DateV2_notn_4 """
	// 	select id, BITAND(kchr, kdtv2), BITOR(kchr, kdtv2), BITXOR(kchr, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTimeV2_0 """
		select id, kchr + kdtmv2, kchr - kdtmv2 from expr_test order by id"""
	qt_sql_test_Char_DateTimeV2_notn_0 """
		select id, kchr + kdtmv2, kchr - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTimeV2_1 """
		select id, kchr * kdtmv2, kchr / kdtmv2, kchr % kdtmv2 from expr_test order by id"""
	qt_sql_test_Char_DateTimeV2_notn_1 """
		select id, kchr * kdtmv2, kchr / kdtmv2, kchr % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTimeV2_2 """
		select id, kchr DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Char_DateTimeV2_notn_2 """
		select id, kchr DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Char_DateTimeV2_3 """
		select id, kchr & kdtmv2, kchr | kdtmv2, kchr ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Char_DateTimeV2_notn_3 """
		select id, kchr & kdtmv2, kchr | kdtmv2, kchr ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_DateTimeV2_4 """
	// 	select id, BITAND(kchr, kdtmv2), BITOR(kchr, kdtmv2), BITXOR(kchr, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Char_DateTimeV2_notn_4 """
	// 	select id, BITAND(kchr, kdtmv2), BITOR(kchr, kdtmv2), BITXOR(kchr, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Boolean_0 """
		select id, kchr + kbool, kchr - kbool from expr_test order by id"""
	qt_sql_test_Char_Boolean_notn_0 """
		select id, kchr + kbool, kchr - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Boolean_1 """
		select id, kchr * kbool, kchr / kbool, kchr % kbool from expr_test order by id"""
	qt_sql_test_Char_Boolean_notn_1 """
		select id, kchr * kbool, kchr / kbool, kchr % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Boolean_2 """
		select id, kchr DIV kbool from expr_test order by id"""
	qt_sql_test_Char_Boolean_notn_2 """
		select id, kchr DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Char_Boolean_3 """
		select id, kchr & kbool, kchr | kbool, kchr ^ kbool from expr_test order by id"""
	qt_sql_test_Char_Boolean_notn_3 """
		select id, kchr & kbool, kchr | kbool, kchr ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Char_Boolean_4 """
	// 	select id, BITAND(kchr, kbool), BITOR(kchr, kbool), BITXOR(kchr, kbool) from expr_test order by id"""
	// qt_sql_test_Char_Boolean_notn_4 """
	// 	select id, BITAND(kchr, kbool), BITOR(kchr, kbool), BITXOR(kchr, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_TinyInt_0 """
		select id, kvchr + ktint, kvchr - ktint from expr_test order by id"""
	qt_sql_test_Varchar_TinyInt_notn_0 """
		select id, kvchr + ktint, kvchr - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_TinyInt_1 """
		select id, kvchr * ktint, kvchr / ktint, kvchr % ktint from expr_test order by id"""
	qt_sql_test_Varchar_TinyInt_notn_1 """
		select id, kvchr * ktint, kvchr / ktint, kvchr % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_TinyInt_2 """
		select id, kvchr DIV ktint from expr_test order by id"""
	qt_sql_test_Varchar_TinyInt_notn_2 """
		select id, kvchr DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_TinyInt_3 """
		select id, kvchr & ktint, kvchr | ktint, kvchr ^ ktint from expr_test order by id"""
	qt_sql_test_Varchar_TinyInt_notn_3 """
		select id, kvchr & ktint, kvchr | ktint, kvchr ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_TinyInt_4 """
	// 	select id, BITAND(kvchr, ktint), BITOR(kvchr, ktint), BITXOR(kvchr, ktint) from expr_test order by id"""
	// qt_sql_test_Varchar_TinyInt_notn_4 """
	// 	select id, BITAND(kvchr, ktint), BITOR(kvchr, ktint), BITXOR(kvchr, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_SmallInt_0 """
		select id, kvchr + ksint, kvchr - ksint from expr_test order by id"""
	qt_sql_test_Varchar_SmallInt_notn_0 """
		select id, kvchr + ksint, kvchr - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_SmallInt_1 """
		select id, kvchr * ksint, kvchr / ksint, kvchr % ksint from expr_test order by id"""
	qt_sql_test_Varchar_SmallInt_notn_1 """
		select id, kvchr * ksint, kvchr / ksint, kvchr % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_SmallInt_2 """
		select id, kvchr DIV ksint from expr_test order by id"""
	qt_sql_test_Varchar_SmallInt_notn_2 """
		select id, kvchr DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_SmallInt_3 """
		select id, kvchr & ksint, kvchr | ksint, kvchr ^ ksint from expr_test order by id"""
	qt_sql_test_Varchar_SmallInt_notn_3 """
		select id, kvchr & ksint, kvchr | ksint, kvchr ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_SmallInt_4 """
	// 	select id, BITAND(kvchr, ksint), BITOR(kvchr, ksint), BITXOR(kvchr, ksint) from expr_test order by id"""
	// qt_sql_test_Varchar_SmallInt_notn_4 """
	// 	select id, BITAND(kvchr, ksint), BITOR(kvchr, ksint), BITXOR(kvchr, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Integer_0 """
		select id, kvchr + kint, kvchr - kint from expr_test order by id"""
	qt_sql_test_Varchar_Integer_notn_0 """
		select id, kvchr + kint, kvchr - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Integer_1 """
		select id, kvchr * kint, kvchr / kint, kvchr % kint from expr_test order by id"""
	qt_sql_test_Varchar_Integer_notn_1 """
		select id, kvchr * kint, kvchr / kint, kvchr % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Integer_2 """
		select id, kvchr DIV kint from expr_test order by id"""
	qt_sql_test_Varchar_Integer_notn_2 """
		select id, kvchr DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Integer_3 """
		select id, kvchr & kint, kvchr | kint, kvchr ^ kint from expr_test order by id"""
	qt_sql_test_Varchar_Integer_notn_3 """
		select id, kvchr & kint, kvchr | kint, kvchr ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Integer_4 """
	// 	select id, BITAND(kvchr, kint), BITOR(kvchr, kint), BITXOR(kvchr, kint) from expr_test order by id"""
	// qt_sql_test_Varchar_Integer_notn_4 """
	// 	select id, BITAND(kvchr, kint), BITOR(kvchr, kint), BITXOR(kvchr, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_BigInt_0 """
		select id, kvchr + kbint, kvchr - kbint from expr_test order by id"""
	qt_sql_test_Varchar_BigInt_notn_0 """
		select id, kvchr + kbint, kvchr - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_BigInt_1 """
		select id, kvchr * kbint, kvchr / kbint, kvchr % kbint from expr_test order by id"""
	qt_sql_test_Varchar_BigInt_notn_1 """
		select id, kvchr * kbint, kvchr / kbint, kvchr % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_BigInt_2 """
		select id, kvchr DIV kbint from expr_test order by id"""
	qt_sql_test_Varchar_BigInt_notn_2 """
		select id, kvchr DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_BigInt_3 """
		select id, kvchr & kbint, kvchr | kbint, kvchr ^ kbint from expr_test order by id"""
	qt_sql_test_Varchar_BigInt_notn_3 """
		select id, kvchr & kbint, kvchr | kbint, kvchr ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_BigInt_4 """
	// 	select id, BITAND(kvchr, kbint), BITOR(kvchr, kbint), BITXOR(kvchr, kbint) from expr_test order by id"""
	// qt_sql_test_Varchar_BigInt_notn_4 """
	// 	select id, BITAND(kvchr, kbint), BITOR(kvchr, kbint), BITXOR(kvchr, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_LargeInt_0 """
		select id, kvchr + klint, kvchr - klint from expr_test order by id"""
	qt_sql_test_Varchar_LargeInt_notn_0 """
		select id, kvchr + klint, kvchr - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_LargeInt_1 """
		select id, kvchr * klint, kvchr / klint, kvchr % klint from expr_test order by id"""
	qt_sql_test_Varchar_LargeInt_notn_1 """
		select id, kvchr * klint, kvchr / klint, kvchr % klint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_LargeInt_2 """
		select id, kvchr DIV klint from expr_test order by id"""
	qt_sql_test_Varchar_LargeInt_notn_2 """
		select id, kvchr DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_LargeInt_3 """
		select id, kvchr & klint, kvchr | klint, kvchr ^ klint from expr_test order by id"""
	qt_sql_test_Varchar_LargeInt_notn_3 """
		select id, kvchr & klint, kvchr | klint, kvchr ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_LargeInt_4 """
	// 	select id, BITAND(kvchr, klint), BITOR(kvchr, klint), BITXOR(kvchr, klint) from expr_test order by id"""
	// qt_sql_test_Varchar_LargeInt_notn_4 """
	// 	select id, BITAND(kvchr, klint), BITOR(kvchr, klint), BITXOR(kvchr, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Float_0 """
		select id, kvchr + kfloat, kvchr - kfloat from expr_test order by id"""
	qt_sql_test_Varchar_Float_notn_0 """
		select id, kvchr + kfloat, kvchr - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Float_1 """
		select id, kvchr * kfloat, kvchr / kfloat, kvchr % kfloat from expr_test order by id"""
	qt_sql_test_Varchar_Float_notn_1 """
		select id, kvchr * kfloat, kvchr / kfloat, kvchr % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Float_2 """
		select id, kvchr DIV kfloat from expr_test order by id"""
	qt_sql_test_Varchar_Float_notn_2 """
		select id, kvchr DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Float_3 """
		select id, kvchr & kfloat, kvchr | kfloat, kvchr ^ kfloat from expr_test order by id"""
	qt_sql_test_Varchar_Float_notn_3 """
		select id, kvchr & kfloat, kvchr | kfloat, kvchr ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Float_4 """
	// 	select id, BITAND(kvchr, kfloat), BITOR(kvchr, kfloat), BITXOR(kvchr, kfloat) from expr_test order by id"""
	// qt_sql_test_Varchar_Float_notn_4 """
	// 	select id, BITAND(kvchr, kfloat), BITOR(kvchr, kfloat), BITXOR(kvchr, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Double_0 """
		select id, kvchr + kdbl, kvchr - kdbl from expr_test order by id"""
	qt_sql_test_Varchar_Double_notn_0 """
		select id, kvchr + kdbl, kvchr - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Double_1 """
		select id, kvchr * kdbl, kvchr / kdbl, kvchr % kdbl from expr_test order by id"""
	qt_sql_test_Varchar_Double_notn_1 """
		select id, kvchr * kdbl, kvchr / kdbl, kvchr % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Double_2 """
		select id, kvchr DIV kdbl from expr_test order by id"""
	qt_sql_test_Varchar_Double_notn_2 """
		select id, kvchr DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Double_3 """
		select id, kvchr & kdbl, kvchr | kdbl, kvchr ^ kdbl from expr_test order by id"""
	qt_sql_test_Varchar_Double_notn_3 """
		select id, kvchr & kdbl, kvchr | kdbl, kvchr ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Double_4 """
	// 	select id, BITAND(kvchr, kdbl), BITOR(kvchr, kdbl), BITXOR(kvchr, kdbl) from expr_test order by id"""
	// qt_sql_test_Varchar_Double_notn_4 """
	// 	select id, BITAND(kvchr, kdbl), BITOR(kvchr, kdbl), BITXOR(kvchr, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DecimalV2_0 """
		select id, kvchr + kdcml, kvchr - kdcml from expr_test order by id"""
	qt_sql_test_Varchar_DecimalV2_notn_0 """
		select id, kvchr + kdcml, kvchr - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DecimalV2_1 """
		select id, kvchr * kdcml, kvchr / kdcml, kvchr % kdcml from expr_test order by id"""
	qt_sql_test_Varchar_DecimalV2_notn_1 """
		select id, kvchr * kdcml, kvchr / kdcml, kvchr % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DecimalV2_2 """
		select id, kvchr DIV kdcml from expr_test order by id"""
	qt_sql_test_Varchar_DecimalV2_notn_2 """
		select id, kvchr DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DecimalV2_3 """
		select id, kvchr & kdcml, kvchr | kdcml, kvchr ^ kdcml from expr_test order by id"""
	qt_sql_test_Varchar_DecimalV2_notn_3 """
		select id, kvchr & kdcml, kvchr | kdcml, kvchr ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_DecimalV2_4 """
	// 	select id, BITAND(kvchr, kdcml), BITOR(kvchr, kdcml), BITXOR(kvchr, kdcml) from expr_test order by id"""
	// qt_sql_test_Varchar_DecimalV2_notn_4 """
	// 	select id, BITAND(kvchr, kdcml), BITOR(kvchr, kdcml), BITXOR(kvchr, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal32V3_0 """
		select id, kvchr + kdcml32v3, kvchr - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal32V3_notn_0 """
		select id, kvchr + kdcml32v3, kvchr - kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal32V3_1 """
		select id, kvchr * kdcml32v3, kvchr / kdcml32v3, kvchr % kdcml32v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal32V3_notn_1 """
		select id, kvchr * kdcml32v3, kvchr / kdcml32v3, kvchr % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal32V3_2 """
		select id, kvchr DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal32V3_notn_2 """
		select id, kvchr DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal32V3_3 """
		select id, kvchr & kdcml32v3, kvchr | kdcml32v3, kvchr ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal32V3_notn_3 """
		select id, kvchr & kdcml32v3, kvchr | kdcml32v3, kvchr ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Decimal32V3_4 """
	// 	select id, BITAND(kvchr, kdcml32v3), BITOR(kvchr, kdcml32v3), BITXOR(kvchr, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Varchar_Decimal32V3_notn_4 """
	// 	select id, BITAND(kvchr, kdcml32v3), BITOR(kvchr, kdcml32v3), BITXOR(kvchr, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal64V3_0 """
		select id, kvchr + kdcml64v3, kvchr - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal64V3_notn_0 """
		select id, kvchr + kdcml64v3, kvchr - kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal64V3_1 """
		select id, kvchr * kdcml64v3, kvchr / kdcml64v3, kvchr % kdcml64v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal64V3_notn_1 """
		select id, kvchr * kdcml64v3, kvchr / kdcml64v3, kvchr % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal64V3_2 """
		select id, kvchr DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal64V3_notn_2 """
		select id, kvchr DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal64V3_3 """
		select id, kvchr & kdcml64v3, kvchr | kdcml64v3, kvchr ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal64V3_notn_3 """
		select id, kvchr & kdcml64v3, kvchr | kdcml64v3, kvchr ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Decimal64V3_4 """
	// 	select id, BITAND(kvchr, kdcml64v3), BITOR(kvchr, kdcml64v3), BITXOR(kvchr, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Varchar_Decimal64V3_notn_4 """
	// 	select id, BITAND(kvchr, kdcml64v3), BITOR(kvchr, kdcml64v3), BITXOR(kvchr, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal128V3_0 """
		select id, kvchr + kdcml128v3, kvchr - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal128V3_notn_0 """
		select id, kvchr + kdcml128v3, kvchr - kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal128V3_1 """
		select id, kvchr * kdcml128v3, kvchr / kdcml128v3, kvchr % kdcml128v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal128V3_notn_1 """
		select id, kvchr * kdcml128v3, kvchr / kdcml128v3, kvchr % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal128V3_2 """
		select id, kvchr DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal128V3_notn_2 """
		select id, kvchr DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Decimal128V3_3 """
		select id, kvchr & kdcml128v3, kvchr | kdcml128v3, kvchr ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Varchar_Decimal128V3_notn_3 """
		select id, kvchr & kdcml128v3, kvchr | kdcml128v3, kvchr ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Decimal128V3_4 """
	// 	select id, BITAND(kvchr, kdcml128v3), BITOR(kvchr, kdcml128v3), BITXOR(kvchr, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Varchar_Decimal128V3_notn_4 """
	// 	select id, BITAND(kvchr, kdcml128v3), BITOR(kvchr, kdcml128v3), BITXOR(kvchr, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Char_0 """
		select id, kvchr + kchr, kvchr - kchr from expr_test order by id"""
	qt_sql_test_Varchar_Char_notn_0 """
		select id, kvchr + kchr, kvchr - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Char_1 """
		select id, kvchr * kchr, kvchr / kchr, kvchr % kchr from expr_test order by id"""
	qt_sql_test_Varchar_Char_notn_1 """
		select id, kvchr * kchr, kvchr / kchr, kvchr % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Char_2 """
		select id, kvchr DIV kchr from expr_test order by id"""
	qt_sql_test_Varchar_Char_notn_2 """
		select id, kvchr DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Char_3 """
		select id, kvchr & kchr, kvchr | kchr, kvchr ^ kchr from expr_test order by id"""
	qt_sql_test_Varchar_Char_notn_3 """
		select id, kvchr & kchr, kvchr | kchr, kvchr ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Char_4 """
	// 	select id, BITAND(kvchr, kchr), BITOR(kvchr, kchr), BITXOR(kvchr, kchr) from expr_test order by id"""
	// qt_sql_test_Varchar_Char_notn_4 """
	// 	select id, BITAND(kvchr, kchr), BITOR(kvchr, kchr), BITXOR(kvchr, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Varchar_0 """
		select id, kvchr + kvchr, kvchr - kvchr from expr_test order by id"""
	qt_sql_test_Varchar_Varchar_notn_0 """
		select id, kvchr + kvchr, kvchr - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Varchar_1 """
		select id, kvchr * kvchr, kvchr / kvchr, kvchr % kvchr from expr_test order by id"""
	qt_sql_test_Varchar_Varchar_notn_1 """
		select id, kvchr * kvchr, kvchr / kvchr, kvchr % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Varchar_2 """
		select id, kvchr DIV kvchr from expr_test order by id"""
	qt_sql_test_Varchar_Varchar_notn_2 """
		select id, kvchr DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Varchar_3 """
		select id, kvchr & kvchr, kvchr | kvchr, kvchr ^ kvchr from expr_test order by id"""
	qt_sql_test_Varchar_Varchar_notn_3 """
		select id, kvchr & kvchr, kvchr | kvchr, kvchr ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Varchar_4 """
	// 	select id, BITAND(kvchr, kvchr), BITOR(kvchr, kvchr), BITXOR(kvchr, kvchr) from expr_test order by id"""
	// qt_sql_test_Varchar_Varchar_notn_4 """
	// 	select id, BITAND(kvchr, kvchr), BITOR(kvchr, kvchr), BITXOR(kvchr, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_String_0 """
		select id, kvchr + kstr, kvchr - kstr from expr_test order by id"""
	qt_sql_test_Varchar_String_notn_0 """
		select id, kvchr + kstr, kvchr - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_String_1 """
		select id, kvchr * kstr, kvchr / kstr, kvchr % kstr from expr_test order by id"""
	qt_sql_test_Varchar_String_notn_1 """
		select id, kvchr * kstr, kvchr / kstr, kvchr % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_String_2 """
		select id, kvchr DIV kstr from expr_test order by id"""
	qt_sql_test_Varchar_String_notn_2 """
		select id, kvchr DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_String_3 """
		select id, kvchr & kstr, kvchr | kstr, kvchr ^ kstr from expr_test order by id"""
	qt_sql_test_Varchar_String_notn_3 """
		select id, kvchr & kstr, kvchr | kstr, kvchr ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_String_4 """
	// 	select id, BITAND(kvchr, kstr), BITOR(kvchr, kstr), BITXOR(kvchr, kstr) from expr_test order by id"""
	// qt_sql_test_Varchar_String_notn_4 """
	// 	select id, BITAND(kvchr, kstr), BITOR(kvchr, kstr), BITXOR(kvchr, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Date_0 """
		select id, kvchr + kdt, kvchr - kdt from expr_test order by id"""
	qt_sql_test_Varchar_Date_notn_0 """
		select id, kvchr + kdt, kvchr - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Date_1 """
		select id, kvchr * kdt, kvchr / kdt, kvchr % kdt from expr_test order by id"""
	qt_sql_test_Varchar_Date_notn_1 """
		select id, kvchr * kdt, kvchr / kdt, kvchr % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Date_2 """
		select id, kvchr DIV kdt from expr_test order by id"""
	qt_sql_test_Varchar_Date_notn_2 """
		select id, kvchr DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Date_3 """
		select id, kvchr & kdt, kvchr | kdt, kvchr ^ kdt from expr_test order by id"""
	qt_sql_test_Varchar_Date_notn_3 """
		select id, kvchr & kdt, kvchr | kdt, kvchr ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Date_4 """
	// 	select id, BITAND(kvchr, kdt), BITOR(kvchr, kdt), BITXOR(kvchr, kdt) from expr_test order by id"""
	// qt_sql_test_Varchar_Date_notn_4 """
	// 	select id, BITAND(kvchr, kdt), BITOR(kvchr, kdt), BITXOR(kvchr, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTime_0 """
		select id, kvchr + kdtm, kvchr - kdtm from expr_test order by id"""
	qt_sql_test_Varchar_DateTime_notn_0 """
		select id, kvchr + kdtm, kvchr - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTime_1 """
		select id, kvchr * kdtm, kvchr / kdtm, kvchr % kdtm from expr_test order by id"""
	qt_sql_test_Varchar_DateTime_notn_1 """
		select id, kvchr * kdtm, kvchr / kdtm, kvchr % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTime_2 """
		select id, kvchr DIV kdtm from expr_test order by id"""
	qt_sql_test_Varchar_DateTime_notn_2 """
		select id, kvchr DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTime_3 """
		select id, kvchr & kdtm, kvchr | kdtm, kvchr ^ kdtm from expr_test order by id"""
	qt_sql_test_Varchar_DateTime_notn_3 """
		select id, kvchr & kdtm, kvchr | kdtm, kvchr ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_DateTime_4 """
	// 	select id, BITAND(kvchr, kdtm), BITOR(kvchr, kdtm), BITXOR(kvchr, kdtm) from expr_test order by id"""
	// qt_sql_test_Varchar_DateTime_notn_4 """
	// 	select id, BITAND(kvchr, kdtm), BITOR(kvchr, kdtm), BITXOR(kvchr, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateV2_0 """
		select id, kvchr + kdtv2, kvchr - kdtv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateV2_notn_0 """
		select id, kvchr + kdtv2, kvchr - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateV2_1 """
		select id, kvchr * kdtv2, kvchr / kdtv2, kvchr % kdtv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateV2_notn_1 """
		select id, kvchr * kdtv2, kvchr / kdtv2, kvchr % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateV2_2 """
		select id, kvchr DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateV2_notn_2 """
		select id, kvchr DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateV2_3 """
		select id, kvchr & kdtv2, kvchr | kdtv2, kvchr ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateV2_notn_3 """
		select id, kvchr & kdtv2, kvchr | kdtv2, kvchr ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_DateV2_4 """
	// 	select id, BITAND(kvchr, kdtv2), BITOR(kvchr, kdtv2), BITXOR(kvchr, kdtv2) from expr_test order by id"""
	// qt_sql_test_Varchar_DateV2_notn_4 """
	// 	select id, BITAND(kvchr, kdtv2), BITOR(kvchr, kdtv2), BITXOR(kvchr, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTimeV2_0 """
		select id, kvchr + kdtmv2, kvchr - kdtmv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateTimeV2_notn_0 """
		select id, kvchr + kdtmv2, kvchr - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTimeV2_1 """
		select id, kvchr * kdtmv2, kvchr / kdtmv2, kvchr % kdtmv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateTimeV2_notn_1 """
		select id, kvchr * kdtmv2, kvchr / kdtmv2, kvchr % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTimeV2_2 """
		select id, kvchr DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateTimeV2_notn_2 """
		select id, kvchr DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_DateTimeV2_3 """
		select id, kvchr & kdtmv2, kvchr | kdtmv2, kvchr ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Varchar_DateTimeV2_notn_3 """
		select id, kvchr & kdtmv2, kvchr | kdtmv2, kvchr ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_DateTimeV2_4 """
	// 	select id, BITAND(kvchr, kdtmv2), BITOR(kvchr, kdtmv2), BITXOR(kvchr, kdtmv2) from expr_test order by id"""
	// qt_sql_test_Varchar_DateTimeV2_notn_4 """
	// 	select id, BITAND(kvchr, kdtmv2), BITOR(kvchr, kdtmv2), BITXOR(kvchr, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Boolean_0 """
		select id, kvchr + kbool, kvchr - kbool from expr_test order by id"""
	qt_sql_test_Varchar_Boolean_notn_0 """
		select id, kvchr + kbool, kvchr - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Boolean_1 """
		select id, kvchr * kbool, kvchr / kbool, kvchr % kbool from expr_test order by id"""
	qt_sql_test_Varchar_Boolean_notn_1 """
		select id, kvchr * kbool, kvchr / kbool, kvchr % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Boolean_2 """
		select id, kvchr DIV kbool from expr_test order by id"""
	qt_sql_test_Varchar_Boolean_notn_2 """
		select id, kvchr DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Varchar_Boolean_3 """
		select id, kvchr & kbool, kvchr | kbool, kvchr ^ kbool from expr_test order by id"""
	qt_sql_test_Varchar_Boolean_notn_3 """
		select id, kvchr & kbool, kvchr | kbool, kvchr ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_Varchar_Boolean_4 """
	// 	select id, BITAND(kvchr, kbool), BITOR(kvchr, kbool), BITXOR(kvchr, kbool) from expr_test order by id"""
	// qt_sql_test_Varchar_Boolean_notn_4 """
	// 	select id, BITAND(kvchr, kbool), BITOR(kvchr, kbool), BITXOR(kvchr, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_String_TinyInt_0 """
		select id, kstr + ktint, kstr - ktint from expr_test order by id"""
	qt_sql_test_String_TinyInt_notn_0 """
		select id, kstr + ktint, kstr - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_String_TinyInt_1 """
		select id, kstr * ktint, kstr / ktint, kstr % ktint from expr_test order by id"""
	qt_sql_test_String_TinyInt_notn_1 """
		select id, kstr * ktint, kstr / ktint, kstr % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_String_TinyInt_2 """
		select id, kstr DIV ktint from expr_test order by id"""
	qt_sql_test_String_TinyInt_notn_2 """
		select id, kstr DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_String_TinyInt_3 """
		select id, kstr & ktint, kstr | ktint, kstr ^ ktint from expr_test order by id"""
	qt_sql_test_String_TinyInt_notn_3 """
		select id, kstr & ktint, kstr | ktint, kstr ^ ktint from expr_test_not_nullable order by id"""
	// qt_sql_test_String_TinyInt_4 """
	// 	select id, BITAND(kstr, ktint), BITOR(kstr, ktint), BITXOR(kstr, ktint) from expr_test order by id"""
	// qt_sql_test_String_TinyInt_notn_4 """
	// 	select id, BITAND(kstr, ktint), BITOR(kstr, ktint), BITXOR(kstr, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_String_SmallInt_0 """
		select id, kstr + ksint, kstr - ksint from expr_test order by id"""
	qt_sql_test_String_SmallInt_notn_0 """
		select id, kstr + ksint, kstr - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_String_SmallInt_1 """
		select id, kstr * ksint, kstr / ksint, kstr % ksint from expr_test order by id"""
	qt_sql_test_String_SmallInt_notn_1 """
		select id, kstr * ksint, kstr / ksint, kstr % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_String_SmallInt_2 """
		select id, kstr DIV ksint from expr_test order by id"""
	qt_sql_test_String_SmallInt_notn_2 """
		select id, kstr DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_String_SmallInt_3 """
		select id, kstr & ksint, kstr | ksint, kstr ^ ksint from expr_test order by id"""
	qt_sql_test_String_SmallInt_notn_3 """
		select id, kstr & ksint, kstr | ksint, kstr ^ ksint from expr_test_not_nullable order by id"""
	// qt_sql_test_String_SmallInt_4 """
	// 	select id, BITAND(kstr, ksint), BITOR(kstr, ksint), BITXOR(kstr, ksint) from expr_test order by id"""
	// qt_sql_test_String_SmallInt_notn_4 """
	// 	select id, BITAND(kstr, ksint), BITOR(kstr, ksint), BITXOR(kstr, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Integer_0 """
		select id, kstr + kint, kstr - kint from expr_test order by id"""
	qt_sql_test_String_Integer_notn_0 """
		select id, kstr + kint, kstr - kint from expr_test_not_nullable order by id"""
	qt_sql_test_String_Integer_1 """
		select id, kstr * kint, kstr / kint, kstr % kint from expr_test order by id"""
	qt_sql_test_String_Integer_notn_1 """
		select id, kstr * kint, kstr / kint, kstr % kint from expr_test_not_nullable order by id"""
	qt_sql_test_String_Integer_2 """
		select id, kstr DIV kint from expr_test order by id"""
	qt_sql_test_String_Integer_notn_2 """
		select id, kstr DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_String_Integer_3 """
		select id, kstr & kint, kstr | kint, kstr ^ kint from expr_test order by id"""
	qt_sql_test_String_Integer_notn_3 """
		select id, kstr & kint, kstr | kint, kstr ^ kint from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Integer_4 """
	// 	select id, BITAND(kstr, kint), BITOR(kstr, kint), BITXOR(kstr, kint) from expr_test order by id"""
	// qt_sql_test_String_Integer_notn_4 """
	// 	select id, BITAND(kstr, kint), BITOR(kstr, kint), BITXOR(kstr, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_String_BigInt_0 """
		select id, kstr + kbint, kstr - kbint from expr_test order by id"""
	qt_sql_test_String_BigInt_notn_0 """
		select id, kstr + kbint, kstr - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_String_BigInt_1 """
		select id, kstr * kbint, kstr / kbint, kstr % kbint from expr_test order by id"""
	qt_sql_test_String_BigInt_notn_1 """
		select id, kstr * kbint, kstr / kbint, kstr % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_String_BigInt_2 """
		select id, kstr DIV kbint from expr_test order by id"""
	qt_sql_test_String_BigInt_notn_2 """
		select id, kstr DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_String_BigInt_3 """
		select id, kstr & kbint, kstr | kbint, kstr ^ kbint from expr_test order by id"""
	qt_sql_test_String_BigInt_notn_3 """
		select id, kstr & kbint, kstr | kbint, kstr ^ kbint from expr_test_not_nullable order by id"""
	// qt_sql_test_String_BigInt_4 """
	// 	select id, BITAND(kstr, kbint), BITOR(kstr, kbint), BITXOR(kstr, kbint) from expr_test order by id"""
	// qt_sql_test_String_BigInt_notn_4 """
	// 	select id, BITAND(kstr, kbint), BITOR(kstr, kbint), BITXOR(kstr, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_String_LargeInt_0 """
		select id, kstr + klint, kstr - klint from expr_test order by id"""
	qt_sql_test_String_LargeInt_notn_0 """
		select id, kstr + klint, kstr - klint from expr_test_not_nullable order by id"""
	qt_sql_test_String_LargeInt_1 """
		select id, kstr * klint, kstr / klint, kstr % klint from expr_test order by id"""
	qt_sql_test_String_LargeInt_notn_1 """
		select id, kstr * klint, kstr / klint, kstr % klint from expr_test_not_nullable order by id"""
	qt_sql_test_String_LargeInt_2 """
		select id, kstr DIV klint from expr_test order by id"""
	qt_sql_test_String_LargeInt_notn_2 """
		select id, kstr DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_String_LargeInt_3 """
		select id, kstr & klint, kstr | klint, kstr ^ klint from expr_test order by id"""
	qt_sql_test_String_LargeInt_notn_3 """
		select id, kstr & klint, kstr | klint, kstr ^ klint from expr_test_not_nullable order by id"""
	// qt_sql_test_String_LargeInt_4 """
	// 	select id, BITAND(kstr, klint), BITOR(kstr, klint), BITXOR(kstr, klint) from expr_test order by id"""
	// qt_sql_test_String_LargeInt_notn_4 """
	// 	select id, BITAND(kstr, klint), BITOR(kstr, klint), BITXOR(kstr, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Float_0 """
		select id, kstr + kfloat, kstr - kfloat from expr_test order by id"""
	qt_sql_test_String_Float_notn_0 """
		select id, kstr + kfloat, kstr - kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_String_Float_1 """
		select id, kstr * kfloat, kstr / kfloat, kstr % kfloat from expr_test order by id"""
	qt_sql_test_String_Float_notn_1 """
		select id, kstr * kfloat, kstr / kfloat, kstr % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_String_Float_2 """
		select id, kstr DIV kfloat from expr_test order by id"""
	qt_sql_test_String_Float_notn_2 """
		select id, kstr DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_String_Float_3 """
		select id, kstr & kfloat, kstr | kfloat, kstr ^ kfloat from expr_test order by id"""
	qt_sql_test_String_Float_notn_3 """
		select id, kstr & kfloat, kstr | kfloat, kstr ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Float_4 """
	// 	select id, BITAND(kstr, kfloat), BITOR(kstr, kfloat), BITXOR(kstr, kfloat) from expr_test order by id"""
	// qt_sql_test_String_Float_notn_4 """
	// 	select id, BITAND(kstr, kfloat), BITOR(kstr, kfloat), BITXOR(kstr, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Double_0 """
		select id, kstr + kdbl, kstr - kdbl from expr_test order by id"""
	qt_sql_test_String_Double_notn_0 """
		select id, kstr + kdbl, kstr - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_String_Double_1 """
		select id, kstr * kdbl, kstr / kdbl, kstr % kdbl from expr_test order by id"""
	qt_sql_test_String_Double_notn_1 """
		select id, kstr * kdbl, kstr / kdbl, kstr % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_String_Double_2 """
		select id, kstr DIV kdbl from expr_test order by id"""
	qt_sql_test_String_Double_notn_2 """
		select id, kstr DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_String_Double_3 """
		select id, kstr & kdbl, kstr | kdbl, kstr ^ kdbl from expr_test order by id"""
	qt_sql_test_String_Double_notn_3 """
		select id, kstr & kdbl, kstr | kdbl, kstr ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Double_4 """
	// 	select id, BITAND(kstr, kdbl), BITOR(kstr, kdbl), BITXOR(kstr, kdbl) from expr_test order by id"""
	// qt_sql_test_String_Double_notn_4 """
	// 	select id, BITAND(kstr, kdbl), BITOR(kstr, kdbl), BITXOR(kstr, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_String_DecimalV2_0 """
		select id, kstr + kdcml, kstr - kdcml from expr_test order by id"""
	qt_sql_test_String_DecimalV2_notn_0 """
		select id, kstr + kdcml, kstr - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_String_DecimalV2_1 """
		select id, kstr * kdcml, kstr / kdcml, kstr % kdcml from expr_test order by id"""
	qt_sql_test_String_DecimalV2_notn_1 """
		select id, kstr * kdcml, kstr / kdcml, kstr % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_String_DecimalV2_2 """
		select id, kstr DIV kdcml from expr_test order by id"""
	qt_sql_test_String_DecimalV2_notn_2 """
		select id, kstr DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_String_DecimalV2_3 """
		select id, kstr & kdcml, kstr | kdcml, kstr ^ kdcml from expr_test order by id"""
	qt_sql_test_String_DecimalV2_notn_3 """
		select id, kstr & kdcml, kstr | kdcml, kstr ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_String_DecimalV2_4 """
	// 	select id, BITAND(kstr, kdcml), BITOR(kstr, kdcml), BITXOR(kstr, kdcml) from expr_test order by id"""
	// qt_sql_test_String_DecimalV2_notn_4 """
	// 	select id, BITAND(kstr, kdcml), BITOR(kstr, kdcml), BITXOR(kstr, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal32V3_0 """
		select id, kstr + kdcml32v3, kstr - kdcml32v3 from expr_test order by id"""
	qt_sql_test_String_Decimal32V3_notn_0 """
		select id, kstr + kdcml32v3, kstr - kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal32V3_1 """
		select id, kstr * kdcml32v3, kstr / kdcml32v3, kstr % kdcml32v3 from expr_test order by id"""
	qt_sql_test_String_Decimal32V3_notn_1 """
		select id, kstr * kdcml32v3, kstr / kdcml32v3, kstr % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal32V3_2 """
		select id, kstr DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_String_Decimal32V3_notn_2 """
		select id, kstr DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal32V3_3 """
		select id, kstr & kdcml32v3, kstr | kdcml32v3, kstr ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_String_Decimal32V3_notn_3 """
		select id, kstr & kdcml32v3, kstr | kdcml32v3, kstr ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Decimal32V3_4 """
	// 	select id, BITAND(kstr, kdcml32v3), BITOR(kstr, kdcml32v3), BITXOR(kstr, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_String_Decimal32V3_notn_4 """
	// 	select id, BITAND(kstr, kdcml32v3), BITOR(kstr, kdcml32v3), BITXOR(kstr, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal64V3_0 """
		select id, kstr + kdcml64v3, kstr - kdcml64v3 from expr_test order by id"""
	qt_sql_test_String_Decimal64V3_notn_0 """
		select id, kstr + kdcml64v3, kstr - kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal64V3_1 """
		select id, kstr * kdcml64v3, kstr / kdcml64v3, kstr % kdcml64v3 from expr_test order by id"""
	qt_sql_test_String_Decimal64V3_notn_1 """
		select id, kstr * kdcml64v3, kstr / kdcml64v3, kstr % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal64V3_2 """
		select id, kstr DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_String_Decimal64V3_notn_2 """
		select id, kstr DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal64V3_3 """
		select id, kstr & kdcml64v3, kstr | kdcml64v3, kstr ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_String_Decimal64V3_notn_3 """
		select id, kstr & kdcml64v3, kstr | kdcml64v3, kstr ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Decimal64V3_4 """
	// 	select id, BITAND(kstr, kdcml64v3), BITOR(kstr, kdcml64v3), BITXOR(kstr, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_String_Decimal64V3_notn_4 """
	// 	select id, BITAND(kstr, kdcml64v3), BITOR(kstr, kdcml64v3), BITXOR(kstr, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal128V3_0 """
		select id, kstr + kdcml128v3, kstr - kdcml128v3 from expr_test order by id"""
	qt_sql_test_String_Decimal128V3_notn_0 """
		select id, kstr + kdcml128v3, kstr - kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal128V3_1 """
		select id, kstr * kdcml128v3, kstr / kdcml128v3, kstr % kdcml128v3 from expr_test order by id"""
	qt_sql_test_String_Decimal128V3_notn_1 """
		select id, kstr * kdcml128v3, kstr / kdcml128v3, kstr % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal128V3_2 """
		select id, kstr DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_String_Decimal128V3_notn_2 """
		select id, kstr DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_String_Decimal128V3_3 """
		select id, kstr & kdcml128v3, kstr | kdcml128v3, kstr ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_String_Decimal128V3_notn_3 """
		select id, kstr & kdcml128v3, kstr | kdcml128v3, kstr ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Decimal128V3_4 """
	// 	select id, BITAND(kstr, kdcml128v3), BITOR(kstr, kdcml128v3), BITXOR(kstr, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_String_Decimal128V3_notn_4 """
	// 	select id, BITAND(kstr, kdcml128v3), BITOR(kstr, kdcml128v3), BITXOR(kstr, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Char_0 """
		select id, kstr + kchr, kstr - kchr from expr_test order by id"""
	qt_sql_test_String_Char_notn_0 """
		select id, kstr + kchr, kstr - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Char_1 """
		select id, kstr * kchr, kstr / kchr, kstr % kchr from expr_test order by id"""
	qt_sql_test_String_Char_notn_1 """
		select id, kstr * kchr, kstr / kchr, kstr % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Char_2 """
		select id, kstr DIV kchr from expr_test order by id"""
	qt_sql_test_String_Char_notn_2 """
		select id, kstr DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Char_3 """
		select id, kstr & kchr, kstr | kchr, kstr ^ kchr from expr_test order by id"""
	qt_sql_test_String_Char_notn_3 """
		select id, kstr & kchr, kstr | kchr, kstr ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Char_4 """
	// 	select id, BITAND(kstr, kchr), BITOR(kstr, kchr), BITXOR(kstr, kchr) from expr_test order by id"""
	// qt_sql_test_String_Char_notn_4 """
	// 	select id, BITAND(kstr, kchr), BITOR(kstr, kchr), BITXOR(kstr, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Varchar_0 """
		select id, kstr + kvchr, kstr - kvchr from expr_test order by id"""
	qt_sql_test_String_Varchar_notn_0 """
		select id, kstr + kvchr, kstr - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Varchar_1 """
		select id, kstr * kvchr, kstr / kvchr, kstr % kvchr from expr_test order by id"""
	qt_sql_test_String_Varchar_notn_1 """
		select id, kstr * kvchr, kstr / kvchr, kstr % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Varchar_2 """
		select id, kstr DIV kvchr from expr_test order by id"""
	qt_sql_test_String_Varchar_notn_2 """
		select id, kstr DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_String_Varchar_3 """
		select id, kstr & kvchr, kstr | kvchr, kstr ^ kvchr from expr_test order by id"""
	qt_sql_test_String_Varchar_notn_3 """
		select id, kstr & kvchr, kstr | kvchr, kstr ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Varchar_4 """
	// 	select id, BITAND(kstr, kvchr), BITOR(kstr, kvchr), BITXOR(kstr, kvchr) from expr_test order by id"""
	// qt_sql_test_String_Varchar_notn_4 """
	// 	select id, BITAND(kstr, kvchr), BITOR(kstr, kvchr), BITXOR(kstr, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_String_String_0 """
		select id, kstr + kstr, kstr - kstr from expr_test order by id"""
	qt_sql_test_String_String_notn_0 """
		select id, kstr + kstr, kstr - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_String_String_1 """
		select id, kstr * kstr, kstr / kstr, kstr % kstr from expr_test order by id"""
	qt_sql_test_String_String_notn_1 """
		select id, kstr * kstr, kstr / kstr, kstr % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_String_String_2 """
		select id, kstr DIV kstr from expr_test order by id"""
	qt_sql_test_String_String_notn_2 """
		select id, kstr DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_String_String_3 """
		select id, kstr & kstr, kstr | kstr, kstr ^ kstr from expr_test order by id"""
	qt_sql_test_String_String_notn_3 """
		select id, kstr & kstr, kstr | kstr, kstr ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_String_String_4 """
	// 	select id, BITAND(kstr, kstr), BITOR(kstr, kstr), BITXOR(kstr, kstr) from expr_test order by id"""
	// qt_sql_test_String_String_notn_4 """
	// 	select id, BITAND(kstr, kstr), BITOR(kstr, kstr), BITXOR(kstr, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Date_0 """
		select id, kstr + kdt, kstr - kdt from expr_test order by id"""
	qt_sql_test_String_Date_notn_0 """
		select id, kstr + kdt, kstr - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_String_Date_1 """
		select id, kstr * kdt, kstr / kdt, kstr % kdt from expr_test order by id"""
	qt_sql_test_String_Date_notn_1 """
		select id, kstr * kdt, kstr / kdt, kstr % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_String_Date_2 """
		select id, kstr DIV kdt from expr_test order by id"""
	qt_sql_test_String_Date_notn_2 """
		select id, kstr DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_String_Date_3 """
		select id, kstr & kdt, kstr | kdt, kstr ^ kdt from expr_test order by id"""
	qt_sql_test_String_Date_notn_3 """
		select id, kstr & kdt, kstr | kdt, kstr ^ kdt from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Date_4 """
	// 	select id, BITAND(kstr, kdt), BITOR(kstr, kdt), BITXOR(kstr, kdt) from expr_test order by id"""
	// qt_sql_test_String_Date_notn_4 """
	// 	select id, BITAND(kstr, kdt), BITOR(kstr, kdt), BITXOR(kstr, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTime_0 """
		select id, kstr + kdtm, kstr - kdtm from expr_test order by id"""
	qt_sql_test_String_DateTime_notn_0 """
		select id, kstr + kdtm, kstr - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTime_1 """
		select id, kstr * kdtm, kstr / kdtm, kstr % kdtm from expr_test order by id"""
	qt_sql_test_String_DateTime_notn_1 """
		select id, kstr * kdtm, kstr / kdtm, kstr % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTime_2 """
		select id, kstr DIV kdtm from expr_test order by id"""
	qt_sql_test_String_DateTime_notn_2 """
		select id, kstr DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTime_3 """
		select id, kstr & kdtm, kstr | kdtm, kstr ^ kdtm from expr_test order by id"""
	qt_sql_test_String_DateTime_notn_3 """
		select id, kstr & kdtm, kstr | kdtm, kstr ^ kdtm from expr_test_not_nullable order by id"""
	// qt_sql_test_String_DateTime_4 """
	// 	select id, BITAND(kstr, kdtm), BITOR(kstr, kdtm), BITXOR(kstr, kdtm) from expr_test order by id"""
	// qt_sql_test_String_DateTime_notn_4 """
	// 	select id, BITAND(kstr, kdtm), BITOR(kstr, kdtm), BITXOR(kstr, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateV2_0 """
		select id, kstr + kdtv2, kstr - kdtv2 from expr_test order by id"""
	qt_sql_test_String_DateV2_notn_0 """
		select id, kstr + kdtv2, kstr - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateV2_1 """
		select id, kstr * kdtv2, kstr / kdtv2, kstr % kdtv2 from expr_test order by id"""
	qt_sql_test_String_DateV2_notn_1 """
		select id, kstr * kdtv2, kstr / kdtv2, kstr % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateV2_2 """
		select id, kstr DIV kdtv2 from expr_test order by id"""
	qt_sql_test_String_DateV2_notn_2 """
		select id, kstr DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateV2_3 """
		select id, kstr & kdtv2, kstr | kdtv2, kstr ^ kdtv2 from expr_test order by id"""
	qt_sql_test_String_DateV2_notn_3 """
		select id, kstr & kdtv2, kstr | kdtv2, kstr ^ kdtv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_String_DateV2_4 """
	// 	select id, BITAND(kstr, kdtv2), BITOR(kstr, kdtv2), BITXOR(kstr, kdtv2) from expr_test order by id"""
	// qt_sql_test_String_DateV2_notn_4 """
	// 	select id, BITAND(kstr, kdtv2), BITOR(kstr, kdtv2), BITXOR(kstr, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTimeV2_0 """
		select id, kstr + kdtmv2, kstr - kdtmv2 from expr_test order by id"""
	qt_sql_test_String_DateTimeV2_notn_0 """
		select id, kstr + kdtmv2, kstr - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTimeV2_1 """
		select id, kstr * kdtmv2, kstr / kdtmv2, kstr % kdtmv2 from expr_test order by id"""
	qt_sql_test_String_DateTimeV2_notn_1 """
		select id, kstr * kdtmv2, kstr / kdtmv2, kstr % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTimeV2_2 """
		select id, kstr DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_String_DateTimeV2_notn_2 """
		select id, kstr DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_String_DateTimeV2_3 """
		select id, kstr & kdtmv2, kstr | kdtmv2, kstr ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_String_DateTimeV2_notn_3 """
		select id, kstr & kdtmv2, kstr | kdtmv2, kstr ^ kdtmv2 from expr_test_not_nullable order by id"""
	// qt_sql_test_String_DateTimeV2_4 """
	// 	select id, BITAND(kstr, kdtmv2), BITOR(kstr, kdtmv2), BITXOR(kstr, kdtmv2) from expr_test order by id"""
	// qt_sql_test_String_DateTimeV2_notn_4 """
	// 	select id, BITAND(kstr, kdtmv2), BITOR(kstr, kdtmv2), BITXOR(kstr, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_String_Boolean_0 """
		select id, kstr + kbool, kstr - kbool from expr_test order by id"""
	qt_sql_test_String_Boolean_notn_0 """
		select id, kstr + kbool, kstr - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_String_Boolean_1 """
		select id, kstr * kbool, kstr / kbool, kstr % kbool from expr_test order by id"""
	qt_sql_test_String_Boolean_notn_1 """
		select id, kstr * kbool, kstr / kbool, kstr % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_String_Boolean_2 """
		select id, kstr DIV kbool from expr_test order by id"""
	qt_sql_test_String_Boolean_notn_2 """
		select id, kstr DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_String_Boolean_3 """
		select id, kstr & kbool, kstr | kbool, kstr ^ kbool from expr_test order by id"""
	qt_sql_test_String_Boolean_notn_3 """
		select id, kstr & kbool, kstr | kbool, kstr ^ kbool from expr_test_not_nullable order by id"""
	// qt_sql_test_String_Boolean_4 """
	// 	select id, BITAND(kstr, kbool), BITOR(kstr, kbool), BITXOR(kstr, kbool) from expr_test order by id"""
	// qt_sql_test_String_Boolean_notn_4 """
	// 	select id, BITAND(kstr, kbool), BITOR(kstr, kbool), BITXOR(kstr, kbool) from expr_test_not_nullable order by id"""
}