// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.backup;

import java.util.concurrent.Callable;

public abstract class ResultfulTask implements Callable<String> {
    protected static final int MAX_RETRY_TIME = 3;
    protected static final long MAX_RETRY_INTERVAL_MS = 1000; // 1s;

    private static final String UNKNOWN_EXCEPTION = "Unknow Exception";

    protected String errMsg;

    protected void setErrMsg(Exception e) {
        errMsg = e.getMessage() == null ? UNKNOWN_EXCEPTION : e.getMessage();
    }
}
