/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.oauth;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilderBase;
import org.apache.pulsar.shade.org.asynchttpclient.SignatureCalculator;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.ConsumerKey;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.RequestToken;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = ThreadLocal.withInitial(() -> {
        try {
            return new OAuthSignatureCalculatorInstance();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    });
    private final ConsumerKey consumerAuth;
    private final RequestToken userAuth;

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
    }

    @Override
    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            String authorization = INSTANCES.get().computeAuthorizationHeader(this.consumerAuth, this.userAuth, request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams());
            requestBuilder.setHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, authorization);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Failed to compute a valid key from consumer and user secrets", e);
        }
    }
}

