/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.metrics.prometheus.PrometheusMetricsRegistryManager;

public final class OpenTelemetryPrometheusManager {
    public static OpenTelemetry initOpenTelemetry(String host, int prometheusExportPort) {
        if (StringUtils.isBlank((CharSequence)host)) {
            host = "0.0.0.0";
        }
        Resource resource = Resource.getDefault().merge(Resource.builder().put(ResourceAttributes.SERVICE_NAME, (Object)"EventMeshPrometheusExporter").build());
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder();
        PrometheusMetricsRegistryManager.getMetricsView().forEach(pair -> meterProviderBuilder.registerView((InstrumentSelector)pair.getLeft(), (View)pair.getRight()));
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setMeterProvider(meterProviderBuilder.setResource(resource).registerMetricReader((MetricReader)PrometheusHttpServer.builder().setHost(host).setPort(prometheusExportPort).build()).build()).buildAndRegisterGlobal();
        return openTelemetrySdk;
    }

    @Generated
    private OpenTelemetryPrometheusManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

