/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import io.pravega.client.ClientConfig;
import io.pravega.client.byteStream.ByteStreamReader;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.byteStream.impl.ByteStreamClientImpl;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.segment.impl.SegmentInputStreamFactoryImpl;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.segment.impl.SegmentOutputStreamFactoryImpl;

@Beta
public interface ByteStreamClientFactory
extends AutoCloseable {
    public static ByteStreamClientFactory withScope(String scope, ClientConfig config) {
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(config);
        ControllerImpl controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        ConnectionPoolImpl connectionPool = new ConnectionPoolImpl(config, (ConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory));
        SegmentInputStreamFactoryImpl inputStreamFactory = new SegmentInputStreamFactoryImpl(controller, connectionPool);
        SegmentOutputStreamFactoryImpl outputStreamFactory = new SegmentOutputStreamFactoryImpl(controller, connectionPool);
        SegmentMetadataClientFactoryImpl metaStreamFactory = new SegmentMetadataClientFactoryImpl(controller, connectionPool);
        return new ByteStreamClientImpl(scope, controller, connectionPool, inputStreamFactory, outputStreamFactory, metaStreamFactory);
    }

    @Beta
    public ByteStreamReader createByteStreamReader(String var1);

    @Beta
    public ByteStreamWriter createByteStreamWriter(String var1);

    @Override
    public void close();
}

