/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.ConditionalOutputStream;
import io.pravega.client.segment.impl.ConditionalOutputStreamFactory;
import io.pravega.client.segment.impl.ConditionalOutputStreamImpl;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.common.util.Retry;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;

public class ConditionalOutputStreamFactoryImpl
implements ConditionalOutputStreamFactory {
    private final Controller controller;
    private final ConnectionPool cp;

    @Override
    public ConditionalOutputStream createConditionalOutputStream(Segment segment, DelegationTokenProvider tokenProvider, EventWriterConfig config) {
        return new ConditionalOutputStreamImpl(UUID.randomUUID(), segment, this.controller, this.cp, tokenProvider, this.getRetryFromConfig(config));
    }

    private Retry.RetryWithBackoff getRetryFromConfig(EventWriterConfig config) {
        return Retry.withExpBackoff((long)config.getInitialBackoffMillis(), (int)config.getBackoffMultiple(), (int)config.getRetryAttempts(), (long)config.getMaxBackoffMillis());
    }

    @ConstructorProperties(value={"controller", "cp"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConditionalOutputStreamFactoryImpl(Controller controller, ConnectionPool cp) {
        this.controller = controller;
        this.cp = cp;
    }
}

