/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.AsyncSegmentInputStream;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.CircularBuffer;
import io.pravega.shared.protocol.netty.WireCommands;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentInputStreamImpl
implements SegmentInputStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentInputStreamImpl.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    static final int MIN_BUFFER_SIZE = 1024;
    static final int DEFAULT_BUFFER_SIZE = 0x100000;
    static final int MAX_BUFFER_SIZE = 0xA00000;
    private static final int DEFAULT_READ_LENGTH = 262144;
    private static final long UNBOUNDED_END_OFFSET = Long.MAX_VALUE;
    private final AsyncSegmentInputStream asyncInput;
    private final int minReadLength;
    @GuardedBy(value="$lock")
    private final CircularBuffer buffer;
    @GuardedBy(value="$lock")
    private long offset;
    @GuardedBy(value="$lock")
    private final long endOffset;
    @GuardedBy(value="$lock")
    private boolean receivedEndOfSegment = false;
    @GuardedBy(value="$lock")
    private boolean receivedTruncated = false;
    @GuardedBy(value="$lock")
    private CompletableFuture<WireCommands.SegmentRead> outstandingRequest = null;

    SegmentInputStreamImpl(AsyncSegmentInputStream asyncInput, long startOffset) {
        this(asyncInput, startOffset, Long.MAX_VALUE, 0x100000);
    }

    SegmentInputStreamImpl(AsyncSegmentInputStream asyncInput, long startOffset, long endOffset, int bufferSize) {
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)asyncInput);
        Preconditions.checkNotNull((Object)endOffset, (Object)"endOffset");
        Preconditions.checkArgument((endOffset >= startOffset ? 1 : 0) != 0, (Object)"Invalid end offset.");
        this.asyncInput = asyncInput;
        this.offset = startOffset;
        this.endOffset = endOffset;
        this.minReadLength = Math.min(262144, bufferSize);
        this.buffer = new CircularBuffer(bufferSize);
        this.issueRequestIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(long offset, boolean resendRequest) {
        Object object = this.$lock;
        synchronized (object) {
            log.trace("SetOffset {}", (Object)offset);
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0);
            Exceptions.checkNotClosed((boolean)this.asyncInput.isClosed(), (Object)this);
            if (offset > this.offset) {
                this.receivedTruncated = false;
            }
            if (offset != this.offset || resendRequest) {
                if (this.outstandingRequest != null) {
                    log.debug("Cancelling the read request for segment {} at offset {}. The new read offset is {}", new Object[]{this.asyncInput.getSegmentId(), this.offset, offset});
                    this.cancelOutstandingRequest();
                }
                this.offset = offset;
                this.buffer.clear();
                this.receivedEndOfSegment = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOffset() {
        Object object = this.$lock;
        synchronized (object) {
            return this.offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer toFill, long timeout) throws EndOfSegmentException, SegmentTruncatedException {
        Object object = this.$lock;
        synchronized (object) {
            Exceptions.checkNotClosed((boolean)this.asyncInput.isClosed(), (Object)this);
            if (this.offset >= this.endOffset) {
                log.debug("All events up to the configured end offset:{} have been read", (Object)this.endOffset);
                throw new EndOfSegmentException(EndOfSegmentException.ErrorType.END_OFFSET_REACHED);
            }
            if (this.outstandingRequest == null) {
                this.fillBuffer();
            }
            if (this.receivedTruncated) {
                throw new SegmentTruncatedException();
            }
            while (this.buffer.dataAvailable() == 0) {
                if (this.receivedEndOfSegment) {
                    throw new EndOfSegmentException();
                }
                Futures.await(this.outstandingRequest, (long)timeout);
                if (!this.outstandingRequest.isDone()) {
                    return 0;
                }
                this.handleRequest();
            }
            int read = this.buffer.read(toFill);
            this.offset += (long)read;
            return read;
        }
    }

    private boolean dataWaitingToGoInBuffer() {
        return this.outstandingRequest != null && Futures.isSuccessful(this.outstandingRequest) && this.buffer.capacityAvailable() > 0;
    }

    private void handleRequest() throws SegmentTruncatedException {
        WireCommands.SegmentRead segmentRead;
        try {
            segmentRead = this.outstandingRequest.join();
        }
        catch (Exception e) {
            this.outstandingRequest = null;
            if (Exceptions.unwrap((Throwable)e) instanceof SegmentTruncatedException) {
                this.receivedTruncated = true;
                throw new SegmentTruncatedException(e);
            }
            throw e;
        }
        this.verifyIsAtCorrectOffset(segmentRead);
        if (segmentRead.getData().readableBytes() > 0) {
            int copied = this.buffer.fill(segmentRead.getData().nioBuffers());
            segmentRead.getData().skipBytes(copied);
        }
        if (segmentRead.isEndOfSegment()) {
            this.receivedEndOfSegment = true;
        }
        if (segmentRead.getData().readableBytes() == 0) {
            segmentRead.release();
            this.outstandingRequest = null;
            this.issueRequestIfNeeded();
        }
    }

    private void verifyIsAtCorrectOffset(WireCommands.SegmentRead segmentRead) {
        long expectedOffset;
        long offsetRead = segmentRead.getOffset() + (long)segmentRead.getData().readerIndex();
        Preconditions.checkState((offsetRead == (expectedOffset = this.offset + (long)this.buffer.dataAvailable()) ? 1 : 0) != 0, (String)"ReadSegment returned data for the wrong offset %s vs %s", (long)offsetRead, (long)expectedOffset);
    }

    private void issueRequestIfNeeded() {
        int updatedReadLength = this.computeReadLength(this.offset + (long)this.buffer.dataAvailable());
        if (!this.receivedEndOfSegment && !this.receivedTruncated && updatedReadLength > 0 && this.outstandingRequest == null) {
            if (log.isTraceEnabled()) {
                log.trace("Issuing read request for segment {} of {} bytes", (Object)this.getSegmentId(), (Object)updatedReadLength);
            }
            CompletableFuture<WireCommands.SegmentRead> r = this.asyncInput.read(this.offset + (long)this.buffer.dataAvailable(), updatedReadLength);
            this.outstandingRequest = Futures.cancellableFuture(r, WireCommands.ReleasableCommand::release);
        }
    }

    private int computeReadLength(long currentFetchOffset) {
        Preconditions.checkState((this.endOffset >= currentFetchOffset ? 1 : 0) != 0, (Object)"Current offset up to to which events are fetched should be less than the configured end offset");
        int currentReadLength = Math.max(this.minReadLength, this.buffer.capacityAvailable());
        if (Long.MAX_VALUE == this.endOffset) {
            return currentReadLength;
        }
        long numberOfBytesRemaining = this.endOffset - currentFetchOffset;
        return Math.toIntExact(Math.min((long)currentReadLength, numberOfBytesRemaining));
    }

    @GuardedBy(value="$lock")
    private void cancelOutstandingRequest() {
        this.outstandingRequest.cancel(true);
        if (this.outstandingRequest.isDone() && !this.outstandingRequest.isCompletedExceptionally()) {
            WireCommands.SegmentRead request = this.outstandingRequest.join();
            request.release();
        }
        log.debug("Completed cancelling outstanding read request for segment {}", (Object)this.asyncInput.getSegmentId());
        this.outstandingRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            log.trace("Closing {}", (Object)this);
            if (this.outstandingRequest != null) {
                log.debug("Cancel outstanding read request for segment {}", (Object)this.asyncInput.getSegmentId());
                this.cancelOutstandingRequest();
            }
            this.asyncInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> fillBuffer() {
        Object object = this.$lock;
        synchronized (object) {
            log.trace("Filling buffer {}", (Object)this);
            Exceptions.checkNotClosed((boolean)this.asyncInput.isClosed(), (Object)this);
            try {
                this.issueRequestIfNeeded();
                while (this.dataWaitingToGoInBuffer()) {
                    this.handleRequest();
                }
            }
            catch (SegmentTruncatedException e) {
                log.warn("Encountered exception filling buffer", (Throwable)e);
                return CompletableFuture.completedFuture(null);
            }
            return this.outstandingRequest == null ? CompletableFuture.completedFuture(null) : this.outstandingRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bytesInBuffer() {
        Object object = this.$lock;
        synchronized (object) {
            boolean atEnd;
            int result = this.buffer.dataAvailable();
            boolean bl = atEnd = this.receivedEndOfSegment || this.receivedTruncated || this.outstandingRequest != null && this.outstandingRequest.isCompletedExceptionally();
            if (this.outstandingRequest != null && Futures.isSuccessful(this.outstandingRequest)) {
                WireCommands.SegmentRead request = this.outstandingRequest.join();
                result += request.getData().readableBytes();
                atEnd |= request.isEndOfSegment();
            }
            if (result <= 0 && atEnd) {
                result = -1;
            }
            log.trace("bytesInBuffer {} on segment {} status is {}", new Object[]{result, this.getSegmentId(), this});
            return result;
        }
    }

    @Override
    public Segment getSegmentId() {
        return this.asyncInput.getSegmentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBufferSize() {
        Object object = this.$lock;
        synchronized (object) {
            return this.buffer.getCapacity();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentInputStreamImpl(asyncInput=" + this.asyncInput + ", minReadLength=" + this.minReadLength + ", buffer=" + this.buffer + ", offset=" + this.getOffset() + ", endOffset=" + this.endOffset + ", receivedEndOfSegment=" + this.receivedEndOfSegment + ", receivedTruncated=" + this.receivedTruncated + ", outstandingRequest=" + this.outstandingRequest + ")";
    }
}

