/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.tcp;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class TcpMessageProtocolResolver {
    public static CloudEvent buildEvent(Header header, String cloudEventJson) throws ProtocolHandleException {
        String protocolType = header.getProperty("protocoltype").toString();
        String protocolVersion = header.getProperty("protocolversion").toString();
        String protocolDesc = header.getProperty("protocoldesc").toString();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{protocolType, protocolVersion, protocolDesc})) {
            throw new ProtocolHandleException(String.format("invalid protocol params protocolType %s|protocolVersion %s|protocolDesc %s", protocolType, protocolVersion, protocolDesc));
        }
        if (StringUtils.isBlank((CharSequence)cloudEventJson)) {
            throw new ProtocolHandleException(String.format("invalid method params cloudEventJson %s", cloudEventJson));
        }
        if (!StringUtils.equals((CharSequence)"cloudevents", (CharSequence)protocolType)) {
            throw new ProtocolHandleException(String.format("Unsupported protocolType: %s", protocolType));
        }
        if (StringUtils.equalsAny((CharSequence)protocolVersion, (CharSequence[])new CharSequence[]{SpecVersion.V1.toString(), SpecVersion.V03.toString()})) {
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");
            Preconditions.checkNotNull((Object)eventFormat, (String)"EventFormat: %s is not supported", (Object)"application/cloudevents+json");
            CloudEvent event = eventFormat.deserialize(cloudEventJson.getBytes(StandardCharsets.UTF_8));
            CloudEventBuilder cloudEventBuilder = CloudEventBuilder.from((CloudEvent)event);
            header.getProperties().forEach((k, v) -> cloudEventBuilder.withExtension(k, v.toString()));
            return cloudEventBuilder.build();
        }
        throw new ProtocolHandleException(String.format("Unsupported protocolVersion: %s", protocolVersion));
    }
}

