/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.CharsetConversion;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;

public final class UserVarLogEvent
extends LogEvent {
    private final String name;
    private final Serializable value;
    private final int type;
    private final int charsetNumber;
    private final boolean isNull;
    public static final int STRING_RESULT = 0;
    public static final int REAL_RESULT = 1;
    public static final int INT_RESULT = 2;
    public static final int ROW_RESULT = 3;
    public static final int DECIMAL_RESULT = 4;
    public static final int UV_VAL_LEN_SIZE = 4;
    public static final int UV_VAL_IS_NULL = 1;
    public static final int UV_VAL_TYPE_SIZE = 1;
    public static final int UV_NAME_LEN_SIZE = 4;
    public static final int UV_CHARSET_NUMBER_SIZE = 4;

    public UserVarLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) throws IOException {
        super(header);
        buffer.position(descriptionEvent.commonHeaderLen + descriptionEvent.postHeaderLen[13]);
        int nameLen = (int)buffer.getUint32();
        this.name = buffer.getFixString(nameLen);
        boolean bl = this.isNull = 0 != buffer.getInt8();
        if (this.isNull) {
            this.type = 0;
            this.charsetNumber = 63;
            this.value = null;
        } else {
            this.type = buffer.getInt8();
            this.charsetNumber = (int)buffer.getUint32();
            int valueLen = (int)buffer.getUint32();
            int limit = buffer.limit();
            buffer.limit(buffer.position() + valueLen);
            switch (this.type) {
                case 1: {
                    this.value = Double.valueOf(buffer.getDouble64());
                    break;
                }
                case 2: {
                    if (valueLen == 8) {
                        this.value = Long.valueOf(buffer.getLong64());
                        break;
                    }
                    if (valueLen == 4) {
                        this.value = Long.valueOf(buffer.getUint32());
                        break;
                    }
                    throw new IOException("Error INT_RESULT length: " + valueLen);
                }
                case 4: {
                    int precision = buffer.getInt8();
                    int scale = buffer.getInt8();
                    this.value = buffer.getDecimal(precision, scale);
                    break;
                }
                case 0: {
                    Charset charset = CharsetConversion.getNioCharset(this.charsetNumber);
                    this.value = buffer.getFixString(valueLen, charset);
                    break;
                }
                case 3: {
                    throw new IOException("ROW_RESULT is unsupported");
                }
                default: {
                    this.value = null;
                }
            }
            buffer.limit(limit);
        }
    }

    public final String getQuery() {
        if (this.value == null) {
            return "SET @" + this.name + " := NULL";
        }
        if (this.type == 0) {
            return "SET @" + this.name + " := '" + this.value + '\'';
        }
        return "SET @" + this.name + " := " + String.valueOf(this.value);
    }
}

