/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.eventmesh.common.config.connector.rdb.canal.SinkConnectorConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.SourceConnectorConfig;

public class DatabaseConnection {
    public static DruidDataSource sourceDataSource;
    public static DruidDataSource sinkDataSource;
    public static SourceConnectorConfig sourceConfig;
    public static SinkConnectorConfig sinkConfig;

    public static DruidDataSource createDruidDataSource(String url, String userName, String passWord) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(userName);
        dataSource.setPassword(passWord);
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(5);
        dataSource.setMaxActive(20);
        dataSource.setMaxWait(60000L);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(20);
        return dataSource;
    }

    public static void initSourceConnection() {
        sourceDataSource = DatabaseConnection.createDruidDataSource(sourceConfig.getUrl(), sourceConfig.getUserName(), sourceConfig.getPassWord());
    }

    public static void initSinkConnection() {
        sinkDataSource = DatabaseConnection.createDruidDataSource(sinkConfig.getUrl(), sinkConfig.getUserName(), sinkConfig.getPassWord());
    }

    public static Connection getSourceConnection() throws SQLException {
        return sourceDataSource.getConnection();
    }

    public static Connection getSinkConnection() throws SQLException {
        return sinkDataSource.getConnection();
    }
}

