/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink.connector;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkConfig;
import org.apache.eventmesh.common.remote.job.JobType;
import org.apache.eventmesh.connector.canal.sink.connector.CanalSinkCheckConnector;
import org.apache.eventmesh.connector.canal.sink.connector.CanalSinkFullConnector;
import org.apache.eventmesh.connector.canal.sink.connector.CanalSinkIncrementConnector;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalSinkConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSinkConnector.class);
    private CanalSinkConfig sinkConfig;
    private Sink sink;

    public Class<? extends Config> configClass() {
        return CanalSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (CanalSinkConfig)config;
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        if (sinkConnectorContext.getJobType().equals((Object)JobType.FULL)) {
            this.sink = new CanalSinkFullConnector();
        } else if (sinkConnectorContext.getJobType().equals((Object)JobType.INCREASE)) {
            this.sink = new CanalSinkIncrementConnector();
        } else if (sinkConnectorContext.getJobType().equals((Object)JobType.CHECK)) {
            this.sink = new CanalSinkCheckConnector();
        } else {
            throw new RuntimeException("unsupported job type " + sinkConnectorContext.getJobType());
        }
        this.sink.init((ConnectorContext)sinkConnectorContext);
    }

    public void start() throws Exception {
        this.sink.start();
    }

    public void commit(ConnectRecord record) {
        this.sink.commit(record);
    }

    public String name() {
        return this.sink.name();
    }

    public void onException(ConnectRecord record) {
        this.sink.onException(record);
    }

    public void stop() throws Exception {
        this.sink.stop();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        this.sink.put(sinkRecords);
    }

    public Sink create() {
        return new CanalSinkConnector();
    }
}

