/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.data;

import java.util.concurrent.atomic.AtomicInteger;

public class HttpAttemptEvent {
    public static final String PREFIX = "http-attempt-event-";
    private final int maxAttempts;
    private final AtomicInteger attempts;
    private Throwable lastException;

    public HttpAttemptEvent(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        this.attempts = new AtomicInteger(0);
    }

    public void incrementAttempts() {
        this.attempts.incrementAndGet();
    }

    public void updateEvent(Throwable exception) {
        this.incrementAttempts();
        this.lastException = exception;
    }

    public boolean canAttempt() {
        return this.attempts.get() < this.maxAttempts;
    }

    public boolean isComplete() {
        if (this.attempts.get() == 0) {
            return false;
        }
        return !this.canAttempt() || this.lastException == null;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getAttempts() {
        return this.attempts.get();
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public String getLimitedExceptionMessage() {
        return this.getLimitedExceptionMessage(256);
    }

    public String getLimitedExceptionMessage(int maxLimit) {
        if (this.lastException == null) {
            return "";
        }
        String message = this.lastException.getMessage();
        if (message == null) {
            return "";
        }
        if (message.length() > maxLimit) {
            return message.substring(0, maxLimit);
        }
        return message;
    }
}

