/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source.protocol.impl;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.connector.http.SourceConnectorConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.http.source.data.CommonResponse;
import org.apache.eventmesh.connector.http.source.data.WebhookRequest;
import org.apache.eventmesh.connector.http.source.protocol.Protocol;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubProtocol
implements Protocol {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitHubProtocol.class);
    public static final String PROTOCOL_NAME = "GitHub";
    private static final String H_MAC_SHA_265 = "HmacSHA256";
    private static final String SECRET_KEY = "secret";
    private String contentType = "application/json";
    private String secret;

    @Override
    public void initialize(SourceConnectorConfig sourceConnectorConfig) {
        Map extraConfig = sourceConnectorConfig.getExtraConfig();
        this.secret = (String)extraConfig.get(SECRET_KEY);
        if (StringUtils.isBlank((CharSequence)this.secret)) {
            throw new EventMeshException("The secret is required for GitHub protocol.");
        }
        this.contentType = extraConfig.getOrDefault("contentType", this.contentType);
    }

    @Override
    public void setHandler(Route route, BlockingQueue<Object> queue) {
        route.method(HttpMethod.POST).handler((Handler)BodyHandler.create()).handler(ctx -> {
            String payloadStr = ctx.body().asString(Constants.DEFAULT_CHARSET.toString());
            MultiMap headers = ctx.request().headers();
            if (!StringUtils.contains((CharSequence)headers.get("Content-Type"), (CharSequence)this.contentType)) {
                String errorMsg = String.format("content-type is invalid, please check the content-type. received content-type: %s", headers.get("Content-Type"));
                ctx.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)new EventMeshException(errorMsg));
                return;
            }
            String signature = headers.get("X-Hub-Signature-256");
            if (BooleanUtils.isFalse((Boolean)this.validateSignature(signature, payloadStr, this.secret))) {
                String errorMsg = String.format("signature is invalid, please check the secret. received signature: %s", signature);
                ctx.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)new EventMeshException(errorMsg));
                return;
            }
            if (StringUtils.contains((CharSequence)this.contentType, (CharSequence)"application/x-www-form-urlencoded") || StringUtils.contains((CharSequence)this.contentType, (CharSequence)"multipart/form-data")) {
                JSONObject payloadObj = new JSONObject();
                ctx.request().formAttributes().forEach(entry -> payloadObj.put(entry.getKey(), entry.getValue()));
                payloadStr = payloadObj.toJSONString(new JSONWriter.Feature[0]);
            }
            Map<String, String> headerMap = headers.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            WebhookRequest webhookRequest = new WebhookRequest(PROTOCOL_NAME, ctx.request().absoluteURI(), headerMap, payloadStr, (RoutingContext)ctx);
            if (!queue.offer(webhookRequest)) {
                throw new IllegalStateException("Failed to store the request.");
            }
            ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(CommonResponse.success().toJsonStr());
        }).failureHandler(ctx -> {
            log.error("Failed to handle the request from github. ", ctx.failure());
            ctx.response().setStatusCode(ctx.statusCode()).end(CommonResponse.base(ctx.failure().getMessage()).toJsonStr());
        });
    }

    public boolean validateSignature(String signature, String payload, String secret) {
        String hash = "sha256=";
        try {
            Mac sha = Mac.getInstance(H_MAC_SHA_265);
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(Constants.DEFAULT_CHARSET), H_MAC_SHA_265);
            sha.init(secretKey);
            byte[] bytes = sha.doFinal(payload.getBytes(Constants.DEFAULT_CHARSET));
            hash = hash + this.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            throw new EventMeshException("Error occurred while validating the signature.", (Throwable)e);
        }
        return hash.equals(signature);
    }

    private String byteArrayToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    @Override
    public ConnectRecord convertToConnectRecord(Object message) {
        WebhookRequest request = (WebhookRequest)message;
        Map<String, String> headers = request.getHeaders();
        ConnectRecord connectRecord = new ConnectRecord(null, null, Long.valueOf(System.currentTimeMillis()), request.getPayload());
        connectRecord.addExtension("id", (Object)headers.get("X-GitHub-Delivery"));
        connectRecord.addExtension("topic", (Object)headers.get("X-GitHub-Event"));
        connectRecord.addExtension("source", (Object)headers.get(request.getProtocolName()));
        connectRecord.addExtension("type", (Object)headers.get("X-GitHub-Hook-Installation-Target-Type"));
        return connectRecord;
    }
}

