/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.clock;

import com.navercorp.pinpoint.common.profiler.clock.TickClock;

public interface Clock {
    public long millis();

    public static Clock systemUTC() {
        return SystemClock.UTC;
    }

    public static Clock fixed(long timestamp) {
        return new FixedClock(timestamp);
    }

    public static Clock tick(long tick) {
        return new TickClock(Clock.systemUTC(), tick);
    }

    public static Clock tick(Clock clock, long tick) {
        return new TickClock(clock, tick);
    }

    public static class FixedClock
    implements Clock {
        private final long timestamp;

        public FixedClock(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public long millis() {
            return this.timestamp;
        }
    }

    public static class SystemClock
    implements Clock {
        static final SystemClock UTC = new SystemClock();

        @Override
        public long millis() {
            return System.currentTimeMillis();
        }
    }
}

