/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.util.SimpleSampler;
import com.navercorp.pinpoint.bootstrap.util.SimpleSamplerFactory;

public class HttpDumpConfig {
    private boolean dumpCookie = false;
    private DumpType cookieDumpType = DumpType.EXCEPTION;
    private SimpleSampler cookieSampler;
    private int cookieDumpSize;
    private boolean dumpEntity;
    private DumpType entityDumpType;
    private SimpleSampler entitySampler;
    private int entityDumpSize;

    public static HttpDumpConfig getDefault() {
        HttpDumpConfig config = new HttpDumpConfig();
        config.setDumpCookie(false);
        config.setCookieDumpType(DumpType.EXCEPTION);
        config.setCookieSampler(SimpleSamplerFactory.createSampler(false, 1));
        config.setCookieDumpSize(128);
        config.setDumpEntity(false);
        config.setEntityDumpType(DumpType.EXCEPTION);
        config.setEntitySampler(SimpleSamplerFactory.createSampler(false, 1));
        config.setEntityDumpSize(128);
        return config;
    }

    public static HttpDumpConfig get(boolean cookie, DumpType cookieDumpType, int cookieDumpSamplingRate, int cookieDumpSize, boolean entity, DumpType entityDumpType, int entityDumpSamplingRate, int entityDumpSize) {
        HttpDumpConfig config = new HttpDumpConfig();
        config.setDumpCookie(cookie);
        config.setCookieDumpType(cookieDumpType);
        config.setCookieSampler(SimpleSamplerFactory.createSampler(cookie, cookieDumpSamplingRate));
        config.setCookieDumpSize(cookieDumpSize);
        config.setDumpEntity(entity);
        config.setEntityDumpType(entityDumpType);
        config.setEntitySampler(SimpleSamplerFactory.createSampler(entity, entityDumpSamplingRate));
        config.setEntityDumpSize(entityDumpSize);
        return config;
    }

    public boolean isDumpCookie() {
        return this.dumpCookie;
    }

    public void setDumpCookie(boolean dumpCookie) {
        this.dumpCookie = dumpCookie;
    }

    public DumpType getCookieDumpType() {
        return this.cookieDumpType;
    }

    public void setCookieDumpType(DumpType cookieDumpType) {
        this.cookieDumpType = cookieDumpType;
    }

    public SimpleSampler getCookieSampler() {
        return this.cookieSampler;
    }

    public void setCookieSampler(SimpleSampler cookieSampler) {
        this.cookieSampler = cookieSampler;
    }

    public int getCookieDumpSize() {
        return this.cookieDumpSize;
    }

    public void setCookieDumpSize(int cookieDumpSize) {
        this.cookieDumpSize = cookieDumpSize;
    }

    public boolean isDumpEntity() {
        return this.dumpEntity;
    }

    public void setDumpEntity(boolean dumpEntity) {
        this.dumpEntity = dumpEntity;
    }

    public DumpType getEntityDumpType() {
        return this.entityDumpType;
    }

    public void setEntityDumpType(DumpType entityDumpType) {
        this.entityDumpType = entityDumpType;
    }

    public SimpleSampler getEntitySampler() {
        return this.entitySampler;
    }

    public void setEntitySampler(SimpleSampler entitySampler) {
        this.entitySampler = entitySampler;
    }

    public int getEntityDumpSize() {
        return this.entityDumpSize;
    }

    public void setEntityDumpSize(int entityDumpSize) {
        this.entityDumpSize = entityDumpSize;
    }
}

