/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import java.util.Objects;

public abstract class AbstractSpanEventInterceptorForPlugin {
    protected final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final TraceContext traceContext;

    protected AbstractSpanEventInterceptorForPlugin(TraceContext traceContext) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
    }

    protected Trace currentTrace() {
        return this.traceContext.currentTraceObject();
    }

    protected void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, args);
    }

    protected void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, args, result, throwable);
    }

    protected TraceContext getTraceContext() {
        return this.traceContext;
    }
}

