/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.http;

public final class HttpStatusUtils {
    static final int SC_INFORMATIONAL_PREFIX = 1;
    static final int SC_SUCCESS_PREFIX = 2;
    static final int SC_REDIRECTION_PREFIX = 3;
    static final int SC_CLIENT_ERROR_PREFIX = 4;
    static final int SC_SERVER_ERROR_PREFIX = 5;

    private HttpStatusUtils() {
    }

    public static boolean isError(int statusCode) {
        int prefix = HttpStatusUtils.toPrefix(statusCode);
        switch (prefix) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNonError(int statusCode) {
        int prefix = HttpStatusUtils.toPrefix(statusCode);
        switch (prefix) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static int toPrefix(int statusCode) {
        return statusCode / 100;
    }
}

