/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AsyncContextSpanEventApiIdAwareAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.reactor.ReactorContextAccessorUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;

public class FluxAndMonoSubscribeInterceptor
extends AsyncContextSpanEventApiIdAwareAroundInterceptor {
    private final ServiceType serviceType;

    public FluxAndMonoSubscribeInterceptor(TraceContext traceContext, ServiceType serviceType) {
        super(traceContext);
        this.serviceType = serviceType;
    }

    @Override
    public AsyncContext getAsyncContext(Object target, Object[] args) {
        if (this.checkTargetReactorContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        if (this.checkTargetAsyncContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        if (this.checkSubscriberReactorContextAccessor(target, args)) {
            return AsyncContextAccessorUtils.getAsyncContext(target);
        }
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    private boolean checkTargetReactorContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToSubscriber(asyncContext, args);
            return true;
        }
        return false;
    }

    private boolean checkTargetAsyncContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToTarget(asyncContext, target);
            this.setReactorContextToSubscriber(asyncContext, args);
            return true;
        }
        return false;
    }

    private boolean checkSubscriberReactorContextAccessor(Object target, Object[] args) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(args, 0);
        if (asyncContext != null) {
            this.setReactorContextToTarget(asyncContext, target);
            return true;
        }
        return false;
    }

    protected void setReactorContextToTarget(AsyncContext asyncContext, Object target) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, target);
        if (this.isDebug) {
            this.logger.debug("Set reactorContext to target. reactorContext={}", (Object)asyncContext);
        }
    }

    protected void setReactorContextToSubscriber(AsyncContext asyncContext, Object[] args) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, args, 0);
        if (this.isDebug) {
            this.logger.debug("Set reactorContext to args[0]. asyncContext={}", (Object)asyncContext);
        }
    }

    @Override
    public void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, int apiId, Object[] args) {
    }

    @Override
    public AsyncContext getAsyncContext(Object target, Object[] args, Object result, Throwable throwable) {
        return AsyncContextAccessorUtils.getAsyncContext(target);
    }

    @Override
    public void doInAfterTrace(SpanEventRecorder recorder, Object target, int apiId, Object[] args, Object result, Throwable throwable) {
        recorder.recordApiId(apiId);
        recorder.recordServiceType(this.serviceType);
        recorder.recordException(throwable);
    }
}

