/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.NameSpaceChecker;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Objects;

public class DefaultNameSpaceChecker<T>
implements NameSpaceChecker<T> {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final RequestAdaptor<T> requestAdaptor;
    private final String applicationNamespace;

    public DefaultNameSpaceChecker(RequestAdaptor<T> requestAdaptor, String applicationNamespace) {
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
        if (StringUtils.isEmpty((String)applicationNamespace)) {
            throw new IllegalArgumentException("applicationNamespace must not be empty");
        }
        this.applicationNamespace = applicationNamespace;
    }

    @Override
    public boolean checkNamespace(T request) {
        String parentApplicationNamespace = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_NAMESPACE.toString());
        if (parentApplicationNamespace == null) {
            return true;
        }
        if (this.applicationNamespace.equals(parentApplicationNamespace)) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Collision namespace. applicationNamespace={}, parentApplicationNamespace={}", (Object)this.applicationNamespace, (Object)parentApplicationNamespace);
        }
        return false;
    }
}

