/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.source.connector;

import com.mongodb.connection.ClusterType;
import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.mongodb.MongodbSourceConfig;
import org.apache.eventmesh.connector.mongodb.source.client.Impl.MongodbSourceClient;
import org.apache.eventmesh.connector.mongodb.source.client.MongodbReplicaSetSourceClient;
import org.apache.eventmesh.connector.mongodb.source.client.MongodbStandaloneSourceClient;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;

public class MongodbSourceConnector
implements Source {
    private MongodbSourceConfig sourceConfig;
    private BlockingQueue<CloudEvent> queue;
    private int maxBatchSize;
    private long maxPollWaitTime;
    private MongodbSourceClient client;

    public Class<? extends Config> configClass() {
        return MongodbSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (MongodbSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (MongodbSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.maxBatchSize = this.sourceConfig.getPollConfig().getMaxBatchSize();
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
        this.queue = new LinkedBlockingQueue<CloudEvent>(this.sourceConfig.getPollConfig().getCapacity());
        String connectorType = this.sourceConfig.getConnectorConfig().getConnectorType();
        if (connectorType.equals(ClusterType.STANDALONE.name())) {
            this.client = new MongodbStandaloneSourceClient(this.sourceConfig.getConnectorConfig(), this.queue);
        }
        if (connectorType.equals(ClusterType.REPLICA_SET.name())) {
            this.client = new MongodbReplicaSetSourceClient(this.sourceConfig.getConnectorConfig(), this.queue);
        }
        this.client.init();
    }

    public void start() throws Exception {
        this.client.start();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.connectorConfig.getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
        this.client.stop();
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollWaitTime;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int count = 0; count < this.maxBatchSize; ++count) {
            try {
                CloudEvent event = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollWaitTime > elapsedTime ? this.maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }
}

