/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.sink.connector;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.knative.KnativeSinkConfig;
import org.apache.eventmesh.connector.knative.cloudevent.KnativeMessageFactory;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnativeSinkConnector.class);
    private KnativeSinkConfig sinkConfig;
    private transient AsyncHttpClient asyncHttpClient;
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public Class<? extends Config> configClass() {
        return KnativeSinkConfig.class;
    }

    public void init(Config config) throws Exception {
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (KnativeSinkConfig)sinkConnectorContext.getSinkConfig();
        this.asyncHttpClient = Dsl.asyncHttpClient();
    }

    public void start() throws Exception {
        started.compareAndSet(false, true);
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        started.compareAndSet(true, false);
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            CloudEvent cloudEvent = CloudEventUtil.convertRecordToEvent((ConnectRecord)connectRecord);
            try {
                ListenableFuture execute = ((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.asyncHttpClient.preparePost("http://" + this.sinkConfig.getConnectorConfig().getServiceAddr()).addHeader((CharSequence)"Content-Type", cloudEvent.getDataContentType())).addHeader((CharSequence)"Ce-Id", cloudEvent.getId())).addHeader((CharSequence)"Ce-Specversion", String.valueOf(cloudEvent.getSpecVersion()))).addHeader((CharSequence)"Ce-Type", cloudEvent.getType())).addHeader((CharSequence)"Ce-Source", String.valueOf(cloudEvent.getSource()))).setBody(KnativeMessageFactory.createReader(cloudEvent))).execute();
                Response response = (Response)execute.get(10L, TimeUnit.SECONDS);
                if (response.getStatusCode() == HttpConstants.ResponseStatusCodes.OK_200) continue;
                log.error("[KnativeSinkConnector] sendResult fail : {}", (Object)response.getResponseBody());
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[KnativeSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
            catch (Exception e) {
                log.error("[KnativeSinkConnector] sendResult has error : ", (Throwable)e);
            }
        }
    }
}

