/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import lombok.Generated;
import org.apache.eventmesh.common.enums.HttpMethod;
import org.apache.eventmesh.runtime.admin.handler.HttpHandler;
import org.apache.eventmesh.runtime.admin.response.Result;
import org.apache.eventmesh.runtime.util.HttpResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpHandler
implements HttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpHandler.class);

    protected void writeText(ChannelHandlerContext ctx, String text) {
        HttpHeaders responseHeaders = HttpResponseUtils.buildDefaultHttpHeaders(HttpHeaderValues.TEXT_HTML);
        this.write(ctx, HttpResponseUtils.buildHttpResponse(text, ctx, responseHeaders, HttpResponseStatus.OK));
    }

    protected void writeJson(ChannelHandlerContext ctx, String json, HttpResponseStatus status) {
        HttpHeaders responseHeaders = HttpResponseUtils.buildDefaultHttpHeaders(HttpHeaderValues.APPLICATION_JSON);
        this.write(ctx, HttpResponseUtils.buildHttpResponse(json, ctx, responseHeaders, status));
    }

    protected void writeJson(ChannelHandlerContext ctx, String json) {
        this.writeJson(ctx, json, HttpResponseStatus.OK);
    }

    protected void writeSuccess(ChannelHandlerContext ctx, Object data) {
        Result<Object> result = Result.success(data);
        String json = JSON.toJSONString(result, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
        this.writeJson(ctx, json);
    }

    protected void writeBadRequest(ChannelHandlerContext ctx, String message) {
        Result result = new Result(message);
        String json = JSON.toJSONString(result, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
        this.writeJson(ctx, json, HttpResponseStatus.BAD_REQUEST);
    }

    protected void writeUnauthorized(ChannelHandlerContext ctx, String message) {
        Result result = new Result(message);
        String json = JSON.toJSONString(result, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
        this.writeJson(ctx, json, HttpResponseStatus.UNAUTHORIZED);
    }

    protected void writeInternalServerError(ChannelHandlerContext ctx, String message) {
        Result result = new Result(message);
        String json = JSON.toJSONString(result, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
        this.writeJson(ctx, json, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    protected void write(ChannelHandlerContext ctx, HttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        try {
            switch (HttpMethod.valueOf((String)httpRequest.method().name())) {
                case OPTIONS: {
                    this.preflight(ctx);
                    break;
                }
                case GET: {
                    this.get(httpRequest, ctx);
                    break;
                }
                case POST: {
                    this.post(httpRequest, ctx);
                    break;
                }
                case PUT: {
                    this.put(httpRequest, ctx);
                    break;
                }
                case DELETE: {
                    this.delete(httpRequest, ctx);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            StackTraceElement element = e.getStackTrace()[0];
            String className = element.getClassName();
            String handlerName = className.substring(className.lastIndexOf(".") + 1);
            if (e instanceof IllegalArgumentException) {
                log.warn("Admin endpoint {}:{} - {}", new Object[]{handlerName, element.getLineNumber(), e.getMessage()});
                this.writeBadRequest(ctx, e.getMessage());
            }
            log.error("Admin endpoint {}:{} - {}", new Object[]{handlerName, element.getLineNumber(), e.getMessage(), e});
            this.writeInternalServerError(ctx, e.getMessage());
        }
    }

    protected void preflight(ChannelHandlerContext ctx) {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        responseHeaders.add("Access-Control-Allow-Methods", (Object)"*");
        responseHeaders.add("Access-Control-Allow-Headers", (Object)"*");
        responseHeaders.add("Access-Control-Max-Age", (Object)"86400");
        this.write(ctx, HttpResponseUtils.buildHttpResponse("", ctx, (HttpHeaders)responseHeaders, HttpResponseStatus.OK));
    }

    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
    }

    protected void post(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
    }

    protected void put(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
    }

    protected void delete(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
    }

    @Generated
    public AbstractHttpHandler() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHttpHandler)) {
            return false;
        }
        AbstractHttpHandler other = (AbstractHttpHandler)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractHttpHandler;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "AbstractHttpHandler()";
    }
}

