/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.HeartbeatServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.HeartbeatProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatService
extends HeartbeatServiceGrpc.HeartbeatServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeartbeatService.class);
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient ThreadPoolExecutor threadPoolExecutor;

    public HeartbeatService(EventMeshGrpcServer eventMeshGrpcServer, ThreadPoolExecutor threadPoolExecutor) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void heartbeat(CloudEvent request, StreamObserver<CloudEvent> responseObserver) {
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"heartbeat", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)request), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            HeartbeatProcessor heartbeatProcessor = new HeartbeatProcessor(this.eventMeshGrpcServer);
            try {
                heartbeatProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_HEARTBEAT_ERR.getRetCode(), StatusCode.EVENTMESH_HEARTBEAT_ERR.getErrMsg(), e});
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_HEARTBEAT_ERR, e.getMessage(), emitter);
            }
        });
    }
}

